
/*  ************************************************************************  *
 *	 xmsfunc.h - a collection of macros representing XMS functions	      *
 *  ************************************************************************  */

#include    "standard.h"

/*  This header file provides macros which translate the XMS functions as
    in-line C functions.  It is assumed that the XMS calling point is
    available as lpXMS.

    The scheme works because functions declared with the _fastcall keyword
    place their arguments in the order AX, DX, BX.  Many XMS functions
    return a Boolean value in register ax.  For most practical purposes, the
    error code in bl if ax is returned FALSE is unimportant.  Some functions
    return information in dx, where it will be available as the high word of
    a dword function value.  */

typedef BOOL _fastcall _far ONEARG_BOOLFUNC (WORD);
typedef BOOL _fastcall _far TWOARGS_BOOLFUNC (WORD, WORD);
typedef BOOL _fastcall _far THREEARGS_BOOLFUNC (WORD, WORD, WORD);

typedef DWORD _fastcall _far ONEARG_DWORDFUNC (WORD);
typedef DWORD _fastcall _far TWOARGS_DWORDFUNC (WORD, WORD);

/*  XMS functions 00h, 0Ch, 0Eh and 10h return values in bx and cannot be
    represented by macros.  XMS function 0Bh takes input from DS:SI and
    cannot be represented by a macro.  */

#define AllocateHMA(bytes)  ((TWOARGS_BOOLFUNC *) lpXMS) (0x0100, bytes)
#define ReleaseHMA()	    ((ONEARG_BOOLFUNC *) lpXMS) (0x0200)

#define GlobalEnableA20()   ((ONEARG_BOOLFUNC *) lpXMS) (0x0300)
#define GlobalDisableA20()  ((ONEARG_BOOLFUNC *) lpXMS) (0x0400)
#define LocalEnableA20()    ((ONEARG_BOOLFUNC *) lpXMS) (0x0500)
#define LocalDisableA20()   ((ONEARG_BOOLFUNC *) lpXMS) (0x0600)
#define QueryA20()	    ((ONEARG_BOOLFUNC *) lpXMS) (0x0700)

#define QueryFreeXMS()	    ((ONEARG_DWORDFUNC *) lpXMS) (0x0800)
#define AllocateEMB(kb)     ((TWOARGS_DWORDFUNC *) lpXMS) (0x0900, kb)
#define ReleaseEMB(handle)  ((TWOARGS_BOOLFUNC *) lpXMS) (0x0A00, handle)

#define UnlockEMB(handle)   ((TWOARGS_BOOLFUNC *) lpXMS) (0x0D00, handle)

#define ResizeEMB(handle,newkb) \
    ((THREEARGS_BOOLFUNC *) lpXMS) (0x0F00, handle, newkb)

#define ReleaseUMB(paras)   ((TWOARGS_BOOLFUNC *) lpXMS) (0x1100, handle)

/*  EMB Information structure for XMS function 0Eh  */

struct EMBINFO {
    BYTE cFreeHandles;
    BYTE cLocks;
    WORD wSizeInKB;
};

/*  ************************************************************************  */

