
/*  ************************************************************************  *
 *				   xmsfunc.c				      *
 *  ************************************************************************  */

#include    "standard.h"

#include    "xmsfunc.h"

extern void (_far *lpXMS) (void);

/*  Two C language equivalents for XMS functions 0Ch and 0Eh, which cannot
    be represented by macros using a _fastcall cast because they return
    values in register bx as well as ax and dx.  */

BOOL LockEMB (WORD handle, DWORD *baseptr)
{
    DWORD base;

    _asm {
	    mov     dx,handle
	    mov     ah,0Ch
	    call    lpXMS
	    or	    ax,ax
	    jz	    done
	    mov     word ptr base,bx
	    mov     word ptr base+2,dx
    }
    *baseptr = base;
    _asm {
	    mov     ax,0001h
	done:
    }
}

BOOL GetEMBInfo (WORD handle, register struct EMBINFO *infoptr)
{
    struct EMBINFO info;

    _asm {
	    mov     dx,handle
	    mov     ah,0Eh
	    call    lpXMS
	    or	    ax,ax
	    jz	    done
	    mov     info.cFreeHandles,bl
	    mov     info.cLocks,bh
	    mov     info.wSizeInKB,dx
    }
    *infoptr = info;
    _asm {
	    mov     ax,0001h
	done:
    }
}

/*  ************************************************************************  */

