
/*  ************************************************************************  *
 *				   xmschain.c				      *
 *  ************************************************************************  */

#include    <dos.h>

#include    "standard.h"

#pragma intrinsic (_disable, _enable)

/*  An XMS handler must begin with a short jump and three NOP instructions -
    enough padding to allow replacement by an intersegment jump to an
    additional handler.  */

struct XMSENTRY {
    BYTE jump;
    union {
	struct {
	    SBYTE displacement;
	    BYTE nops [3];
	};
	struct XMSENTRY _far *lpNext;
    };
};

#define     NOP 	0x90
#define     JMP_FAR	0xEA
#define     JMP_SHORT	0xEB

/*  A pointer to the XMS calling point - must be initialised before calling
    either function in this module  */

extern void (_far *lpXMS) (void);

/*  ========================================================================  */

/*  Successive handlers are reached by direct intersegment JMP instructions
    patched over the original short JMP and NOPs.  The first function in
    this file simply follows the far jump at the start of one handler to
    return the address of the next.  */

struct XMSENTRY _far *FollowXMSChain (struct XMSENTRY _far *callpoint)
{
    if (callpoint -> jump == JMP_FAR) return (callpoint -> lpNext);
    else return (NULL);
}

/*  The following function threads a new handler onto the chain, returning
    the address to which XMS requests would have been sent (by a short jump
    before the addition.  A null pointer is returned if the chain of far
    jumps is corrupt.  */

#pragma optimize ("e", on)

void (_far *ThreadXMSChain (void (_far *newhandler) (void))) (void)
{
    struct XMSENTRY _far *xmsptr;
    void (_far *next) (void);

    /*	Find the end of the chain.  */

    xmsptr = (struct XMSENTRY _far *) lpXMS;
    while (xmsptr -> jump == JMP_FAR) {
	xmsptr = xmsptr -> lpNext;
    }

    /*	Now, xmsptr addresses the calling point of the handler at the end of
	the chain.  This last handler should begin with a short jump and
	three NOP instructions.  If so, return the destination of the short
	jump, having set in place a far jump to the new handler.  */

    if (xmsptr -> jump == JMP_SHORT
	AND *((WORD _far *) xmsptr -> nops) == MK_WORD (NOP, NOP)
	AND xmsptr -> nops [2] == NOP) {

	#define target(x) (&(x) + sizeof (x) + (SWORD)(x))
	next = (void (_far *) (void)) target (xmsptr -> displacement);

	/*  Disable interrupts temporarily to guard against the slight
	    possibility in complex systems that a hardware interrupt handler
	    may issue an XMS call (to test the A20 status, for instance)
	    while the far jump is being patched in.  */

	_disable ();
	xmsptr -> jump = JMP_FAR;
	xmsptr -> lpNext = (struct XMSENTRY _far *) newhandler;
	_enable ();

	/*  Return the destination of the short jump that has just been
	    replaced.  The newly-added XMS handler may use this address to
	    send XMS requests on their original route or to obtain XMS
	    services from the pre-existing server.  */

	return (next);
    }
    return (NULL);
}

/*  ************************************************************************  */

