
/*  ************************************************************************  *
 *				   version.c				      *
 *  ************************************************************************  */

#include    <stdio.h>

#include    "standard.h"

extern void (_far *lpXMS) (void);

static BYTE ConvertBCD (BYTE);

void ReportVersion (void)
{
    WORD XMSversion, HIMEMversion;

    /*	Give the version numbers of both the XMS server (typically the
	device driver HIMEM.SYS) and the XMS specification to which the
	server adheres.  Note that XMS function 00h returns the version
	numbers as packed BCD.	*/

    _asm {
	    xor     ah,ah		//  AH = 00h is the function number;
	    call    lpXMS		//  a far call to the XMS server;
	    mov     XMSversion,ax	//  values are returned in registers
	    mov     HIMEMversion,bx	//  ax and bx (also in dx, but not
    }					//  needed here)

    printf ("\nXMS driver version %hu.%02hu (Specification %hu.%02hu)\n",
	ConvertBCD (HIGHBYTE (HIMEMversion)),
	ConvertBCD (LOWBYTE (HIMEMversion)),
	ConvertBCD (HIGHBYTE (XMSversion)),
	ConvertBCD (LOWBYTE (XMSversion)));
}

static BYTE ConvertBCD (BYTE bcd)
{
    _asm {
	    mov     al,bcd
	    mov     ah,al
	    mov     cl,04h
	    shr     ah,cl
	    and     al,0Fh
	    aad 		    // acts like al = ah * 10 + al, ah = 0
    }
}

/*  ************************************************************************  */

