
/*  ************************************************************************  *
 *				   sysvars.h				      *
 *  ************************************************************************  */

#ifndef     _SYSVARS_INC
#define     _SYSVARS_INC

#include    "buffers.h"
#include    "cds.h"
#include    "dpb.h"
#include    "driver.h"
#include    "sft.h"
#include    "standard.h"

/*  This structure is prepared for DOS 4 and 5 only.  */

struct SYSVARS {
    struct DPB _far *lpFirstDPB;
    struct SFT_HEADER _far *lpSFTs;
    struct DRIVER_HEADER _far *lpClock;
    struct DRIVER_HEADER _far *lpKeyboard;
    WORD wMaxSectorSize;
    struct BUFFERSTABLE _far *lpBuffersTable;
    struct CDS _far *lpFirstCDS;
    struct SFT_HEADER _far *lpFCBSFTs;
    WORD wSafeFCBs;				// not meaningful in DOS 5
    BYTE cPhysicalDrives;
    BYTE cLogicalDrives;
    struct DRIVER_HEADER NULHeader;
    BYTE cJOINedDrives;
    union {
	struct {					// for DOS 5
	    WORD wReserved;
	    void _far *lpVersionTable;
	    void _based (void) *pSetA20Fiddle;
	    _segment spPSPForA20Fiddle;
	};
	struct {					// for DOS 4
	    void _based ((_segment) _self) *pVersionTable;
	    void (_far *lpIFSService) (void);
	    void _far *lpFirstIFS;
	};
    };
    WORD wBuffers1;
    WORD wBuffers2;
    BYTE cBootDrive;
    BYTE b80386;
    WORD wExtendedMemoryInKB;
};

#endif

/*  ************************************************************************  */

