
/*  ************************************************************************  *
 *				   standard.h				      *
 *  ************************************************************************  */

#ifndef     _STANDARD_INC
#define     _STANDARD_INC

/*  Logical operators and values  */

#define     AND     &&
#define     NOT     !
#define     OR      ||

#define     FALSE   0
#define     TRUE    1	    // for consistency with TRUE = NOT FALSE

#define     OFF     0
#define     ON	    1

#define     CLEAR   0
#define     SET     1

/*  Convenient data types  */

typedef unsigned char	BYTE;
typedef unsigned int	WORD;
typedef unsigned long	DWORD;

typedef signed char	SBYTE;
typedef signed int	SWORD;
typedef signed long	SDWORD;

typedef unsigned char	CHAR;

typedef int		BOOL;

/*  Macro for generating a far pointer from segment and offset	*/

#define MK_FP(seg,off) (((_segment) (seg)) :> ((void _based (void) *) (off)))

/*  The above form for MK_FP has a problem (at least in C 6.00) with
    multiple dereferencing through structures.	On the other hand, the
    compiler generates much more efficient code with it.  As an alternative,
    keep the more familiar macro on standby.  */

#if FALSE
#define MK_FP(seg,off) ((void _far *) (((DWORD) (seg) << 16) | ((WORD) (off))))
#endif

/*  Macros to decompose 16-bit and 32-bit objects into high and low
    components and to reconstitute them  */

#define HIGHBYTE(x) ((BYTE) ((x) >> 8))
#define LOWBYTE(x)  ((BYTE) (x))

#define MK_WORD(high,low)  (((WORD) (high) << 8) | (low))

#define HIGHWORD(x) ((WORD) ((x) >> 16))
#define LOWWORD(x)  ((WORD) (x))

#define MK_DWORD(high,low) (((DWORD) (high) << 16) | (low))

/*  Macros for directing the compiler to use current segment register
    values rather than generate relocatable references	*/

#define     CODESEG	    _based (_segname ("_CODE"))
#define     CONSTSEG	    _based (_segname ("_CONST"))
#define     DATASEG	    _based (_segname ("_DATA"))
#define     STACKSEG	    _based (_segname ("_STACK"))

/*  Macro for NULL in case using STDLIB.H would be inappropriate  */

#ifndef NULL
#define NULL ((void *) 0)
#endif

#endif

/*  ************************************************************************  */

