
/*  ************************************************************************  *
 *				     sft.h				      *
 *  ************************************************************************  */

#ifndef     _SFT_INC
#define     _SFT_INC

#include    "dpb.h"
#include    "driver.h"
#include    "standard.h"

#pragma pack (1)

/*  System File Table Header  */

struct SFT_HEADER {
    struct SFT_HEADER _far *lpNext;
    WORD wCount;
};

/*  System File Table  */

struct SFT {
    WORD wHandles;
    WORD wAccess;
    BYTE cAttribute;
    WORD wMode;
    union {
	struct DPB _far *lpDPB;
	struct DRIVER_HEADER _far *lpDriver;
    };
    WORD wStartingCluster;
    WORD wTime;
    WORD wDate;
    DWORD dwSize;
    DWORD dwFilePointer;
    WORD wRelativeCluster;
    DWORD dwDirSector;
    BYTE cDirSectorEntry;
    CHAR cName [11];
    struct SFT _far *lpNextShare;
    WORD wMachine;
    _segment spOwner;
    void _based (void) *pSharingRecord;
    WORD wAbsoluteCluster;
    void _far *lpIFS;
};

#pragma pack ()

#endif

/*  ************************************************************************  */

