
/*  ************************************************************************
 *				   memowner.c				   *
 *  ************************************************************************  */

#include    "arena.h"
#include    "psp.h"
#include    "standard.h"

extern _segment GetArenaSegment (_segment);			// arena.c
extern _segment GetSubArenaSegment (_segment, _segment);	// arena.c
extern BYTE GetValidArenaID (_segment); 			// arena.c
extern BYTE GetValidSubArenaID (_segment);			// arena.c

#ifdef _MANUAL_UMBLINK_
extern struct {
    BYTE minor;
    BYTE major;
} wDOSVersion;
#define _osmajor wDOSVersion.major
#define _osminor wDOSVersion.minor
#else
extern BYTE _osminor;			// defined in STDLIB.H
extern BYTE _osmajor;			// defined in STDLIB.H
#endif

#define MK_ARENA_FP(seg)    ((struct ARENA_HEADER _far *) MK_FP (seg, NULL))
#define MK_PSP_FP(seg)	    ((struct PSP _far *) MK_FP (seg, NULL))

CHAR _far * _far GetMemoryOwner (void _far *address)
{
    register _segment testseg, ownerseg;
    _segment blockseg;
    WORD temp;
    BYTE id;

    /*	Determine which paragraph contains the given address, checking of
	course, that the paragraph calculation does not overflow 16 bits.  */

    temp = (WORD) address >> 4;
    if ((_segment) address > 0xFFFF - temp) return (NULL);
    testseg = (_segment) address + temp;

    /*	Find the memory arena header for the block containing the desired
	segment.  */

    blockseg = GetArenaSegment (testseg);
    if (blockseg == 0) return (NULL);

    /*	If it seems plausible that the block's owner is indeed the PSP that
	obtained the allocation from DOS, then return a pointer to the name
	field in the arena header belonging to the PSP.  This demonstration
	makes no attempt (under early DOS versions) to retrieve program
	names from environment blocks.	*/

    ownerseg = MK_ARENA_FP (blockseg) -> spOwner;
    if (GetValidArenaID (ownerseg - 1) != 0) {
	if (MK_ARENA_FP (ownerseg - 1) -> spOwner == ownerseg) {
	    if (_osmajor < 4) return (NULL);
	    else return (MK_ARENA_FP (ownerseg - 1) -> cName);
	}
    }

    /*	Otherwise, the block is not owned by a program.  Not much can be
	done in this case without the subarena system introduced with DOS 4
	for identifying device drivers (and IFSs) by their filenames.  */

    if (_osmajor < 4) return (NULL);

    blockseg = GetSubArenaSegment (blockseg, testseg);
    if (blockseg == 0) return (NULL);
    id = GetValidSubArenaID (blockseg);
    if (id == 'D' OR id == 'I') return (MK_ARENA_FP (blockseg) -> cName);

    return (NULL);
}

