
/*  ************************************************************************  *
 *		     main.c - primary file for xmswatch.exe		      *
 *  ************************************************************************  */

#include    <dos.h>
#include    <stdarg.h>
#include    <stdio.h>
#include    <stdlib.h>
#include    <string.h>

#include    "standard.h"
#include    "sysvars.h"

/*  A description of the program - for display with the /? switch  */

static CHAR description [] = "\n\
Reports extended memory usage.\n";

/*  Functions and data concerned with the presence of an XMS server  */

extern void (_far *GetXMSAddress (void)) (void);
void (_far *lpXMS) (void);

/*  Installation and report generation	*/

extern void ReportVersion (void);
extern void ReportHMA (void);
extern void ReportFreeEMBs (void);
extern void ReportHandlers (void);
extern void ReportExistingEMBs (void);

/*  A function in the style of printf to lend error messages some degree of
    uniformity.  */

void PutError (CHAR *, ...);

/*  Miscellany	*/

static struct SYSVARS _far *GetSysvarsAddress (void);

static WORD _far *GetUMBLinkSegAddress (_segment);

struct SYSVARS _far *lpSysvars = NULL;
WORD _far *lpUMBLinkSeg = NULL;
WORD wDOSVersion = 0;

BOOL LockAllEMBs = FALSE;

/*  ========================================================================  */

int main (int argc, char **argv)
{
    register CHAR *ptr;

    /*	Parse the command line.  The present version admits only a /? switch
	to obtain the syntax and a /install switch (or any abbreviation) to
	load the program permanently.  A likely future extension would be
	switches that allow selective reporting about the XMS environment.  */

    while (++ argv, -- argc) {
	ptr = *argv;
	if (*ptr == '/') {
	    ptr ++;
	    if (ptr [0] == '?' AND ptr [1] == '\0') {
		printf (description);
		return (0);
	    }
	    if ((ptr[0] == 'L' || ptr[0] == 'l') && ptr[1] == '\0') {
		LockAllEMBs = TRUE;
		continue;
	    }
	    ptr --;
            PutError ("invalid switch - %s", ptr);
            return (-1);
	}
	else {
	    PutError ("invalid parameter - %s", ptr);
	    return (-1);
	}
    }

    /*	An XMS server such as HIMEM.SYS must be present.  */

    lpXMS = GetXMSAddress ();
    if (lpXMS == NULL) {
	PutError ("No XMS server present");
	return (-1);
    }

    /*	On behalf of a routine in the program's resident section, obtain
	and record the address of DOS's internal variable table.  For DOS
	versions 5 and higher, supplement this with the address of the
	variable in which the DOS kernel keeps the segment address of the
	arena header immediately at the end of the conventional memory
	chain.	*/

    lpSysvars = GetSysvarsAddress ();
    if (_osmajor >= 5)
	lpUMBLinkSeg = GetUMBLinkSegAddress ((_segment) lpSysvars);
    wDOSVersion = MK_WORD (_osmajor, _osminor);

    /*	From here on, the goal is to generate a report on extended memory
	services provided by the XMS.  Deal with each XMS feature in a
	separate function.  This allows the program to be extended with
	minimal disruption.  */

    ReportHandlers ();
    ReportVersion ();
    ReportHMA ();
    ReportFreeEMBs ();
    ReportExistingEMBs ();

    return (0);
}

static struct SYSVARS _far *GetSysvarsAddress (void)
{
    _asm {
	    mov     ah,52h
	    int     21h
	    mov     ax,bx
	    mov     dx,es
    }
}

static WORD _far *GetUMBLinkSegAddress (_segment spDOSData)
{
    _asm {
	    xor     dx,dx
	    xor     cx,cx
	    mov     bx,0015h
	    mov     ax,1607h
	    int     2Fh
	    xor     ax,ax		// prepare to return dx:ax = NULL
	    cwd
	    jcxz    done
	    cmp     word ptr es:[bx],0005h
	    jb	    done
	    mov     ax,word ptr es:[bx+0Ch]
	    mov     dx,spDOSData
	done:
    }
}

/*  Message output  */

void PutError (CHAR *str, ...)
{
    va_list va_start (argptr, str);
    printf ("\nXMSWATCH fatal error:  ");
    vprintf (str, argptr);
    printf ("\n");
    va_end (argptr);
}

/*  ************************************************************************  */

