
/*  ************************************************************************  *
 *				     hma.c				      *
 *  ************************************************************************  */

#include    <stdio.h>

#include    "standard.h"

#include    "xmsfunc.h"

/*  The XMS calling point - already determined by a higher-level module.  */

extern void (_far *lpXMS) (void);		// in main.c

/*  The header file XMSFUNC.H provides in-line XMS calls for those functions
    whose parameter passing fits nicely with the _fastcall convention.	This
    includes the two HMA management functions, but there is also the HMA
    status flag returned (in dx) by XMS function 00h.  */

#define GetHMAStatus()	    HIGHWORD (((ONEARG_DWORDFUNC *) lpXMS) (0x0000))

/*  A function to determine the current value of the HMAMIN parameter.	*/

static WORD GetHMAMIN (void);

/*  ========================================================================  */

void ReportHMA (void)
{
    printf ("\nThe HMA ");
    if (NOT GetHMAStatus ()) printf ("does not exist for XMS purposes.");
    else if (NOT AllocateHMA (0xFFFF)) printf ("has already been allocated.");
    else {
	ReleaseHMA ();
	printf ("is free - HMAMIN is %u bytes.", GetHMAMIN ());
    }
    printf ("\n");
}

static WORD GetHMAMIN (void)
{
    register WORD big_enough = 0xFFFF, test;
    WORD too_small = 0, step = 0;

    /*	Find HMAMIN by trial-and-error.  The XMS server refuses the HMA to
	all callers who do not claim the need for at least HMAMIN bytes.
	Assuming that the HMA is free when this function is called, then
	AllocateHMA (0) may fail and AllocateHMA (0xFFFF) is guaranteed to
	succeed:  somewhere between these two extremes is the value sought.  */

    do {
	if (AllocateHMA (test = too_small + step)) {
	    ReleaseHMA ();
	    big_enough = test;
	}
	else too_small = test;
    } while (step = big_enough - too_small >> 1);
    return (big_enough);
}

/*  ************************************************************************  */

