
/*  ************************************************************************  *
 *				   handlers.c				      *
 *  ************************************************************************  */

#include    <stdio.h>

#include    "standard.h"

/*  The start of the chain of XMS handlers and a function to trace the chain
    one handler at a time  */

extern void (_far *lpXMS) (void);
extern void (_far *FollowXMSChain (void (_far *) (void))) (void);

/*  A function to identify the owner of each handler in the chain  */

extern CHAR _far * _far GetMemoryOwner (void _far *);

/*  Message header  */

static CHAR header [] = "\n\
Report on XMS Handler Chain:  \n\
\n\
    Entry Point     Owner\n\
    ------------------------\
";

#pragma optimize ("e", on)

void ReportHandlers (void)
{
    void (_far *callpoint) (void);
    CHAR _far *nameptr;
    struct {
	struct NAME {
	    CHAR letters [8];
	} name;
	BYTE null;
    } namebuffer;

    namebuffer.null = '\0';

    printf (header);

    /*	Trace the handler chain to its end, reporting the address of each
	handler and the name of its owner.  */

    callpoint = lpXMS;
    do {
	printf ("\n     %Fp      ", callpoint);

	nameptr = GetMemoryOwner ((void _far *) callpoint);
	if (nameptr) {
	    namebuffer.name = *((struct NAME _far *) nameptr);
	    printf ("%-8s", namebuffer.name.letters);
	}
	else printf ("        ");

	callpoint = FollowXMSChain (callpoint);
    } while (callpoint != NULL);

    printf ("\n");
}

/*  ************************************************************************  */

