
/*  ************************************************************************  *
 *				    getxms.c				      *
 *  ************************************************************************  */

/*  The following C function returns the address of the XMS calling point,
    if an XMS server is installed.  Otherwise, it returns a null pointer.  */

void (_far *GetXMSAddress (void)) (void)
{
    _asm {
	    mov     ax,4300h	    //	int 2Fh with AX = 4300h
	    int     2Fh 	    //	returns al = 80h
	    cmp     al,80h	    //	if an XMS server is present
	    jnz     no_xms

	    xor	    bx,bx	    //	faint pessimism!
	    mov	    es,bx

	    mov     ax,4310h	    //	int 2Fh with AX = 4310h
	    int     2Fh 	    //	returns with es:bx addressing the
	    mov     ax,bx	    //	calling point for the XMS functions
	    mov     dx,es
	    jmp     done

	no_xms:
	    xor     ax,ax
	    cwd
	done:
    }
}

/*  ************************************************************************  */

