
/*  ************************************************************************  *
 *				   watched.c				      *
 *  ************************************************************************  */

#include    <stdio.h>

#include    "standard.h"

#include    "xmsfunc.h"
#include    "xmswatch.h"

/*  XMS services  */

extern void (_far *lpXMS) (void);

extern BOOL LockEMB (WORD, DWORD *);
extern BOOL GetEMBInfo (WORD, struct EMBINFO *);

/*  Results are presented in a multi-column table under the following
    header.  Data for each column is handled by a separate function that
    pads the item to the expected width - adjacent columns are separated
    by five spaces.  */

static CHAR banner [] = "\n\
Visible Extended Memory Allocations:";

static CHAR header [] = "\n\
\n\
  Linear Address  Size (KB)  Locks   Handle\n\
  -----------------------------------------";

static void PutLocks (struct HANDLE *);
static void PutHandle (struct HANDLE *);

static void SpaceOut (void);

/*  A few functions developed for FREE.C help harmonise this report with the
    one about free memory blocks.  */

extern void PutLinearAddress (struct HANDLE *);
extern void PutSizeInKB (struct HANDLE *);
extern void PutShortfall (WORD);

extern BOOL LockAllEMBs;

/*  ========================================================================  */

void ReportExistingEMBs (void)
{
    struct HANDLE hnd;
    struct EMBINFO info;

    printf (banner);
    printf (header);

    for (hnd.wHandle = 0x0001; hnd.wHandle; hnd.wHandle++)
	if (GetEMBInfo (hnd.wHandle, &info)) {
	    hnd.cLocks = info.cLocks;
	    hnd.wSizeInKB = info.wSizeInKB;
	    hnd.wFlags = USED_EMB;
	    if ((LockAllEMBs || hnd.cLocks) && LockEMB (hnd.wHandle, &hnd.dwBase)) {
		hnd.wFlags |= PHYSICAL_EMB;
		UnlockEMB (hnd.wHandle);
	    }
	    printf ("\n     ");
	    PutLinearAddress (&hnd);
	    SpaceOut ();
	    PutSizeInKB (&hnd);
	    SpaceOut ();
	    PutLocks (&hnd);
	    SpaceOut ();
	    PutHandle (&hnd);
	}

    printf("\n");

}

/*  The Locks, Handle and Owner headings are relevant only for allocated
    EMBs.  For free blocks, maintain column alignment by padding the display
    with an equivalent number of spaces.  */

static void PutLocks (struct HANDLE *ptr)
{
    if (ptr -> wFlags & USED_EMB) printf ("%3u", ptr -> cLocks);
    else printf ("   ");
}

static void PutHandle (struct HANDLE *ptr)
{
    if (ptr -> wFlags & USED_EMB) printf ("%04Xh", ptr -> wHandle);
    else printf ("     ");
}

static void SpaceOut (void)
{
    printf ("     ");
}

/*  ************************************************************************  */

