
/*  ************************************************************************  *
 *				    driver.h				      *
 *  ************************************************************************  */

#ifndef     _DRIVER_INC
#define     _DRIVER_INC

#include    "standard.h"

#pragma pack (1)

/*  Device driver header  */

struct DRIVER_HEADER {
    struct DRIVER_HEADER _far *lpNext;
    WORD wAttribute;
    void _based ((_segment) _self) *pStrategy;
    void _based ((_segment) _self) *pInterrupt;
    union {
	CHAR cName [8];
	BYTE cUnitsSupported;
    };
};

/*  Attribute values  */

#define     IS_STDIN		    0x0001
#define     IS_STDOUT		    0x0002
#define     IS_HUGE_BLOCK	    0x0002
#define     IS_NUL		    0x0004
#define     IS_CLOCK		    0x0008
#define     INT29H_OK		    0x0010
#define     GIOCTL_OK		    0x0040
#define     GIOCTL_QUERY_OK	    0x0080
#define     OCRM_OK		    0x0800
#define     OTB_OK		    0x2000
#define     FAT_REQUIRED	    0x2000
#define     IOCTL_OK		    0x4000
#define     IS_CHAR_DEVICE	    0x8000

/*  Device driver commands  */

#define     D_INIT		    0x00
#define     D_MEDIA_CHECK	    0x01
#define     D_BUILD_BPB 	    0x02
#define     D_IOCTL_READ	    0x03
#define     D_READ		    0x04
#define     D_NONDESTRUCTIVE_READ   0x05
#define     D_INPUT_STATUS	    0x06
#define     D_INPUT_FLUSH	    0x07
#define     D_WRITE		    0x08
#define     D_WRITE_WITH_VERIFY     0x09
#define     D_OUTPUT_STATUS	    0x0A
#define     D_OUTPUT_FLUSH	    0x0B
#define     D_IOCTL_WRITE	    0x0C
#define     D_OPEN_DEVICE	    0x0D
#define     D_CLOSE_DEVICE	    0x0E
#define     D_REMOVABLE_MEDIA	    0x0F
#define     D_OUTPUT_UNTIL_BUSY     0x10
#define     D_GENERIC_IOCTL	    0x13
#define     D_GET_LOGICAL_DEVICE    0x17
#define     D_SET_LOGICAL_DEVICE    0x18
#define     D_IOCTL_QUERY	    0x19

#define     MAX_DRIVER_COMMAND	    0x19

/*  Driver status values  */

#define     D_DONE		    0x0100
#define     D_BUSY		    0x0200
#define     D_ERROR		    0x8000

/*  Driver error values  */

#define     D_WRITE_PROTECTED	    0x00
#define     D_BAD_UNIT		    0x01
#define     D_NOT_READY 	    0x02
#define     D_BAD_COMMAND	    0x03
#define     D_BAD_CRC		    0x04
#define     D_BAD_HEADER	    0x05
#define     D_SEEK_FAILURE	    0x06
#define     D_BAD_MEDIA 	    0x07
#define     D_SECTOR_NOT_FOUND	    0x08
#define     D_NO_PAPER		    0x09
#define     D_WRITE_ERROR	    0x0A
#define     D_READ_ERROR	    0x0B
#define     D_GENERAL_FAILURE	    0x0C
#define     D_BAD_DISK_CHANGE	    0x0F

/*  Request header structure  */

struct REQUEST_HEADER {

    /*	The format of the request header's first portion is common to all
	commands.  */

    BYTE cHeaderLength;
    BYTE cUnit;
    BYTE cCommand;
    WORD wStatus;
    char cReserved [8];

    /*	No further fields are required for commands

	    06h (input status)		07h (input flush)
	    0Ah (output status) 	0Bh (output flush)
	    0Dh (open device)		0Eh (close device)
	    17h (get logical device)	18h (set logical device)

	The request header format for the remaining commands can be
	handled by a set of overlapping structures.  */

    union {

	struct {

	    /*	command 00h (initialise driver)  */

	    BYTE cUnitsSupported;
	    void _far *lpEndOfMemory;
	    union {
		CHAR _far *lpCommandLine;
		void _far *lpBPBTable;
	    };
	    BYTE cDrive;
	    WORD wMessageFlag;
	};

	/*  Many commands are provided with a media descriptor byte at the
	    first location in the variable portion of the request header -
	    hence another set of overlapping structures.  */

	struct {

	    BYTE cMediaDescriptor;

	    union {
		struct {

		    /*	command 01h (media check)  */

		    BYTE cChangeStatus;
		    CHAR _far *lpVolumeIDForCheck;
		};
		struct {

		    /*	command 02h (build BPB)  */

		    void _far *lpFATSector;
		    void _far *lpBPB;
		};
		struct {

		    /*	Commands 03h (IOCTL Read), 04h (Read), 08h (Write),
			09h (Write with verify) and 0Ch (IOCTL Write) all
			transfer data to or from a buffer, though only some
			of these commands require all the following fields.  */

		    BYTE _far *lpBuffer;
		    WORD wCount;
		    WORD wStart;
		    CHAR _far *lpVolumeIDForIO;
		    DWORD dwHugeStart;
		};
	    };
	};

	/*  Command 05h (non-destructive read) simply returns a character
	    waiting for input, if one is present and requires only one
	    field in its request header.  */

	CHAR cCharWaiting;

	struct {

	    /*	Commands 13h (Generic IOCTL) and 19h (IOCTL query)  */

	    BYTE cCategory;
	    BYTE cMinorCode;
	    WORD wGIOCTLReserved;
	    BYTE _far *lpData;
	};
    };
};

#pragma pack ()

#endif

/*  ************************************************************************  */

