
/*  ************************************************************************  *
 *				   buffers.h				      *
 *  ************************************************************************  */

#ifndef     _BUFFERS_INC
#define     _BUFFERS_INC

#include    "dpb.h"
#include    "standard.h"

#pragma pack (1)

/*  The BUFFERSTABLE structure is necessarily at address 006Dh in the DOS
    kernel's data segment.  Material after this table (i.e., from 007Eh
    onwards is not connected with the BUFFERS system in DOS 5).  */

struct BUFFERSTABLE {
    struct BUFFERSHEADER _far *lpFirstBuffer;
    WORD wDirtyCount;
    BYTE _far *lpLookAheadBuffer;
    WORD wLookAheadSectors;
    BYTE cHMA;			// 00h in absence of low memory sector buffer
    BYTE _far *lpLowBuffer;
};

struct BUFFERSHEADER {
    struct BUFFERSHEADER _based ((_segment) _self) *pNext;
    struct BUFFERSHEADER _based ((_segment) _self) *pPrevious;
    BYTE cDrive;
    BYTE cFlags;
    DWORD dwSector;
    BYTE cNumberOfCopies;
    WORD cSectorSpacing;
    struct DPB _far *lpDPB;
    BYTE cReserved [3];
};

#define B_FAT	    0x02
#define B_DIR	    0x04
#define B_DATA	    0x08	// allow ignore when flushing to disk
#define B_DIRTY     0x40	// differs from reality on disk

#pragma pack ()

#endif

/*  ************************************************************************  */

