
/*  ************************************************************************  *
 *				    arena.h				      *
 *  ************************************************************************  */

/*  Structure and equates for DOS memory arena headers	*/

#ifndef     _ARENA_INC
#define     _ARENA_INC

#include    "standard.h"

#pragma pack (1)

struct ARENA_HEADER {
    BYTE cSignature;
    _segment spOwner;
    WORD wParagraphs;
    BYTE cReserved [3];
    BYTE cName [8];
};

#define     ARENA_IN_CHAIN  0x4D
#define     ARENA_LAST	    0x5A

#define     ARENA_FREE	    0x0000
#define     ARENA_DOS	    0x0008
#define     ARENA_EMM386    0x000A

/*  Memory allocation strategies  */

#define     FIRST_FIT	    0x00
#define     BEST_FIT	    0x01
#define     LAST_FIT	    0x02

#define     STRATEGIES	    0x03

#define     STRATEGY_MASK   0x3F

#define     HIGHONLY	    0x40
#define     LOADHIGH	    0x80

/*  UMB Linkage  */

#define     NOUMBS	    0x0000	    // upper memory link disabled
#define     UMBS	    0x0001	    // upper memory link enabled

#pragma pack ()

#endif

/*  ************************************************************************  */

