#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>

struct handlepages
{
    unsigned handle;
    unsigned pages;
};

struct handledir
{
    unsigned handle;
    unsigned char name[8];
};

struct mappablepage
{
    unsigned seg;
    unsigned num;
};

struct hardwareinfo
{
    unsigned raw_page_size;
    unsigned alt_reg_sets;
    unsigned context_save_area_size;
    unsigned DMA_reg_sets;
    unsigned DMA_channel_oper;
};

main(argc, argv, envp)
int argc;
char *argv[];
char *envp[];
{
    unsigned char status;
    unsigned handles;

    {
        _asm
        {
            MOV AH, 40h
            INT 67h
            MOV status, AH
        }
        printf("Get Status call returns status=%02X\n", status);
    }

    {
        unsigned frame;

        _asm
        {
            MOV AH, 41h
            INT 67h
            MOV status, AH
            MOV frame, BX
        }
        if (!status)
            printf("\nGet Page Frame call returns frame=%04X\n", frame);
        else
            printf("\nGet Page Frame call fails, error code=%02X\n", status);
    }

    {
        unsigned total, free;

        _asm
        {
            MOV AH, 42h
            INT 67h
            MOV status, AH
            MOV total, DX
            MOV free, BX
        }
        if (!status)
            printf("\nGet Unallocated Page Count call returns %u total pages and %u free pages\n", total, free);
        else
            printf("\nGet Unallocated Page Count call fails, error code=%02X\n", status);
    }

    {
        unsigned char version;

        _asm
        {
            MOV AH, 46h
            INT 67h
            MOV status, AH
            MOV version, AL
        }
        if (!status)
            printf("\nGet Version call returns LIM EMS v%X.%X\n", version >> 4, version & 0x0F);
        else
            printf("\nGet Version call fails, error code=%02X\n", status);
    }

    {
        _asm
        {
            MOV AH, 4Bh
            INT 67h
            MOV status, AH
            MOV handles, BX
        }
        if (!status)
            printf("\nGet Handle Count call returns %04X handles\n", handles);
        else
        {
            printf("\nGet Handle Count call fails, error code=%02X\n", status);
            handles = 0;
        }
    }

    if (handles > 0 && handles <= 255)
    {
        struct handlepages _near *enumbuf;

        enumbuf = _nmalloc(handles * sizeof(struct handlepages));
        if (enumbuf != NULL)
        {
            _asm
            {
                MOV AX, DS
                MOV ES, AX
                MOV AH, 4Dh
                MOV DI, enumbuf
                INT 67h
                MOV status, AH
            }
            if (!status)
            {
                unsigned i;

                printf("Get All Handle Pages call returns:\n"
                       "  Handle  Pages\n");
                for (i = 0; i < handles; i++)
                    printf("  %04X    %u\n", enumbuf[i].handle, enumbuf[i].pages);
            }
            else
                printf("Get All Handle Pages call fails, error code=%02X\n", status);
            _nfree(enumbuf);
        }
        else
            printf("Not enough memory to enumerate the handles\n");
    }

    {
        unsigned char bufsize;

        _asm
        {
            MOV AX, 4E03h
            INT 67h
            MOV status, AH
            MOV bufsize, AL
        }
        if (!status)
            printf("\nGet Size of Page Map Save Array call returns size=%02X\n", bufsize);
        else
            printf("\nGet Size of Page Map Save Array call fails, error code=%02X\n", status);
    }

    {
        unsigned char attr;

        _asm
        {
            MOV AX, 5200h
            XOR DX, DX
            INT 67h
            MOV status, AH
            MOV attr, AL
        }
        if (!status)
            printf("\nGet Handle Attribute call for the system handle returns attribute=%02X\n", attr);
        else
            printf("\nGet Handle Attribute call for the system handle fails, error code=%02X\n", status);
    }

    {
        unsigned char attrcap;

        _asm
        {
            MOV AX, 5202h
            INT 67h
            MOV status, AH
            MOV attrcap, AL
        }
        if (!status)
            printf("\nGet Attribute Capability call returns capability=%02X\n", attrcap);
        else
            printf("\nGet Attribute Capability call fails, error code=%02X\n", status);
    }

    {
        unsigned totalhandles;

        _asm
        {
            MOV AX, 5402h
            INT 67h
            MOV status, AH
            MOV totalhandles, BX
        }
        if (!status)
            printf("\nGet Total Handles call returns %04X handles\n", totalhandles);
        else
            printf("\nGet Total Handles call fails, error code=%02X\n", status);
    }

    if (handles > 0 && handles <= 255)
    {
        struct handledir _near *enumbuf;

        enumbuf = _nmalloc(handles * sizeof(struct handledir));
        if (enumbuf != NULL)
        {
            _asm
            {
                MOV AX, DS
                MOV ES, AX
                MOV AX, 5400h
                MOV DI, enumbuf
                INT 67h
                MOV status, AH
            }
            if (!status)
            {
                unsigned i;

                printf("Get Handle Directory call returns:\n"
                       "  Handle  Name\n");
                for (i = 0; i < handles; i++)
                {
                    unsigned char name[9];
                    unsigned char j;

                    for (j = 0; j < 8; j++)
                    {
                        if (enumbuf[i].name[j] >= 0x20 && enumbuf[i].name[j] <= 0x7E)
                            name[j] = enumbuf[i].name[j];
                        else
                            name[j] = ' ';
                    }
                    name[8] = '\0';
                    printf("  %04X    %02X %02X %02X %02X %02X %02X %02X %02X (%s)\n",
                           enumbuf[i].handle,
                           enumbuf[i].name[0], enumbuf[i].name[1], enumbuf[i].name[2], enumbuf[i].name[3],
                           enumbuf[i].name[4], enumbuf[i].name[5], enumbuf[i].name[6], enumbuf[i].name[7],
                           name);
                }
            }
            else
                printf("Get Handle Directory call fails, error code=%02X\n", status);
            _nfree(enumbuf);
        }
        else
            printf("Not enough memory to enumerate the handles\n");
    }

    {
        unsigned stkspace;

        _asm
        {
            MOV AX, 5602h
            INT 67h
            MOV status, AH
            MOV stkspace, BX
        }
        if (!status)
            printf("\nGet Page Map Stack Space Size call returns stack space=%04X\n", stkspace);
        else
            printf("\nGet Page Map Stack Space Size call fails, error code=%02X\n", status);
    }

    {
        unsigned pages;

        _asm
        {
            MOV AX, 5801h
            INT 67h
            MOV status, AH
            MOV pages, CX
        }
        if (!status)
        {
            printf("\nGet Mappable Pages call returns %04X pages\n", pages);
            if (pages > 0 && pages <= 64)
            {
                struct mappablepage _near *enumbuf;

                enumbuf = _nmalloc(pages * sizeof(struct mappablepage));
                if (enumbuf != NULL)
                {
                    _asm
                    {
                        MOV AX, DS
                        MOV ES, AX
                        MOV AX, 5800h
                        MOV DI, enumbuf
                        INT 67h
                        MOV status, AH
                    }
                    if (!status)
                    {
                        unsigned i;

                        printf("Get Mappable Physical Address Array call returns:\n"
                               "  Segment  Number\n");
                        for (i = 0; i < pages; i++)
                            printf("  %04X     %04X\n", enumbuf[i].seg, enumbuf[i].num);
                    }
                    else
                        printf("Get Mappable Physical Address Array call fails, error code=%02X\n", status);
                    _nfree(enumbuf);
                }
                else
                    printf("Not enough memory to enumerate the mappable pages\n");
            }
        }
        else
            printf("\nGet Mappable Pages call fails, error code=%02X\n", status);
    }

    {
        struct hardwareinfo hwinfo;

        _asm
        {
            MOV AX, DS
            MOV ES, AX
            MOV AX, 5900h
            LEA DI, hwinfo
            INT 67h
            MOV status, AH
        }
        if (!status)
            printf("\n"
                   "Get Hardware Configuration Array call returns:\n"
                   "  Raw Page Size: %04X\n"
                   "  Alternate Register Sets: %04X\n"
                   "  Context Save Area Size: %04X\n"
                   "  DMA Register Sets: %04X\n"
                   "  DMA Channel Operation: %04X\n",
                   hwinfo.raw_page_size, hwinfo.alt_reg_sets,
                   hwinfo.context_save_area_size, hwinfo.DMA_reg_sets,
                   hwinfo.DMA_channel_oper);
        else
            printf("\nGet Hardware Configuration Array call fails, error code=%02X\n", status);
    }

    {
        unsigned total, free;

        _asm
        {
            MOV AX, 5901h
            INT 67h
            MOV status, AH
            MOV total, DX
            MOV free, BX
        }
        if (!status)
            printf("\nGet Raw Page Count call returns %u total pages and %u free pages\n", total, free);
        else
            printf("\nGet Raw Page Count call fails, error code=%02X\n", status);
    }

    exit(0);
}
