	INCLUDE	MMM386.INC
	.386P

; XMS handle record
XMS_Handle	STRUC
XMS_Handle_Size		DD	?
XMS_Handle_PhysPage	DD	?
XMS_Handle_LinBlkHnd	DW	?
XMS_Handle_InUseCnt	DB	?
XMS_Handle_PhysLockCnt	DB	?
XMS_Handle	ENDS

STARTUP	SEGMENT	USE32	BYTE	PUBLIC	'CODE'

	ASSUME	CS:STARTUP,DS:NOTHING,ES:NOTHING,SS:NOTHING

	PUBLIC	XMSEMB_InitHandleTbl
XMSEMB_InitHandleTbl	PROC	NEAR
	ASSUME	DS:MAINDAT,ES:NOTHING
	MOV	[XMSEMB_HandleTbl],EDI
	MOVZX	ECX,[XMSEMB_Handles]
	MOV	EAX,ECX
	SHL	ECX,1
	ADD	ECX,EAX
	MOV	EAX,0FFFFFFFFh
	REP	STOS	DWORD PTR ES:[EDI]
	RET
XMSEMB_InitHandleTbl	ENDP

STARTUP	ENDS

MAINCOD	SEGMENT	USE32	BYTE	PUBLIC	'CODE'

	EXTRN	PhysPageAlloc:NEAR
	EXTRN	PhysPageFree:NEAR
	EXTRN	PhysRegionAlloc:NEAR
	EXTRN	PhysRegionFree:NEAR
	EXTRN	PhysRegionQuery:NEAR
	EXTRN	LinSpaceAlloc:NEAR
	EXTRN	LinSpaceFree:NEAR
	EXTRN	LinSpaceLock:NEAR
	EXTRN	LinSpaceUnlock:NEAR
	EXTRN	LinSpaceAccess:NEAR
	EXTRN	LinSpaceNoAccess:NEAR
	EXTRN	LinSpaceShrinkInPlace:NEAR
	EXTRN	LinSpaceGrowAnywhere:NEAR
	EXTRN	PageUtilFillRegWithUnlockedPages:NEAR
	EXTRN	PageUtilFreeReg:NEAR

	ASSUME	CS:MAINCOD,DS:NOTHING,ES:NOTHING,SS:NOTHING

	PUBLIC	XMSEMB_GetFreeMem
XMSEMB_GetFreeMem	PROC	NEAR
	ASSUME	DS:MAINDAT,ES:NOTHING
	CMP	[PermLockModeTransition],0
	JZ	@F
	MOV	WORD PTR [EBP+18h],0
	MOV	BYTE PTR [EBP+14h],8Eh
	RET
@@:	TEST	BYTE PTR [EBP+18h],80h
	JZ	@F
	MOV	EAX,[TotalPhysMemPages]
	ADD	EAX,100h
	SHL	EAX,0Ch
	MOV	DWORD PTR [EBP+10h],EAX
@@:	PUSHFD
	CLI
	MOV	ECX,[FreePages]
	MOV	EAX,ECX
	SHL	EAX,2
	TEST	BYTE PTR [EBP+18h],80h
	JZ	@F
	MOV	DWORD PTR [EBP+0Ch],EAX
	JMP	GetFreeMemFilledDX
@@:	CMP	EAX,0FFFFh
	JBE	@F
	MOV	EAX,0FFFFh
@@:	MOV	WORD PTR [EBP+0Ch],AX
GetFreeMemFilledDX:
	CMP	[PermLockMode],0
	JZ	@F
	CALL	PhysRegionQuery
@@:	POPFD
	SHL	ECX,2
	TEST	BYTE PTR [EBP+18h],80h
	JZ	@F
	MOV	DWORD PTR [EBP+18h],ECX
	JMP	GetFreeMemFilledAX
@@:	CMP	ECX,0FFFFh
	JBE	@F
	MOV	ECX,0FFFFh
@@:	MOV	WORD PTR [EBP+18h],CX
GetFreeMemFilledAX:
	TEST	ECX,ECX
	JNZ	@F
	MOV	BYTE PTR [EBP+14h],0A0h
@@:	RET
XMSEMB_GetFreeMem	ENDP

	PUBLIC	XMSEMB_Alloc
XMSEMB_Alloc	PROC	NEAR
	ASSUME	DS:MAINDAT,ES:NOTHING
	CMP	[PermLockModeTransition],0
	JZ	@F
	MOV	BYTE PTR [EBP+14h],8Eh
	JMP	AllocFailReturn
@@:	TEST	BYTE PTR [EBP+18h],80h
	JNZ	@F
	MOVZX	EDX,DX
@@:	ADD	EDX,3				; We deal with pages, not KBs
	SHR	EDX,2
; First get ourselves a handle.
	MOV	ESI,[XMSEMB_HandleTbl]
	MOVZX	ECX,[XMSEMB_Handles]
	PUSHFD
	CLI
@@:	CMP	ES:[ESI].XMS_Handle_Size,0FFFFFFFFh
	JE	@F
	ADD	ESI,0Ch
	LOOP	@B
	POPFD
	MOV	BYTE PTR [EBP+14h],0A1h
	JMP	AllocFailReturn
@@:	MOV	ES:[ESI].XMS_Handle_Size,EDX
	MOV	ES:[ESI].XMS_Handle_LinBlkHnd,0FFFFh
	POPFD
; See if the client is asking for a null EMB.
	XOR	BX,BX				; In case we jump to
	MOV	ES:[ESI].XMS_Handle_PhysPage,0	;   AllocSuccess here
	TEST	EDX,EDX
	JZ	AllocSuccess
; Now allocate the high linear block.
	MOV	ECX,EDX
	CALL	LinSpaceAlloc
	JNC	@F
	MOV	BYTE PTR [EBP+14h],0A1h
	JMP	AllocFailFreeHandle
@@:
; Now fill it with memory. We have to do it differently depending on whether
; the permanent lock mode is on.
	CMP	[PermLockMode],0
	JNZ	AllocPermLockMode
; Lock the linear block handle and fill it.
	CALL	LinSpaceLock
	PUSH	EDX
	SHL	EDX,2
	ADD	EDX,[HighLinSpacePageTbl]
	CALL	PageUtilFillRegWithUnlockedPages
	JC	@F
	POP	EDX
	CALL	LinSpaceUnlock
	JMP	AllocSuccess
@@:	JECXZ	@F
	CALL	PageUtilFreeReg
@@:	POP	EDX
	MOV	BYTE PTR [EBP+14h],0A0h
AllocFailUnlockLinBlock:
	CALL	LinSpaceUnlock
AllocFailFreeLinBlock:
	CALL	LinSpaceFree
AllocFailFreeHandle:
	MOV	ES:[ESI].XMS_Handle_Size,0FFFFFFFFh
AllocFailReturn:
	MOV	WORD PTR [EBP+18h],0
	RET
AllocPermLockMode:
; In this mode we need a physical region.
	CALL	PhysRegionAlloc
	JNC	@F
	MOV	BYTE PTR [EBP+14h],0A0h
	JMP	AllocFailFreeLinBlock
@@:	PUSH	EDX
	CALL	LinSpaceLock
	MOV	EDI,EDX
	POP	EDX
	MOV	ES:[ESI].XMS_Handle_PhysPage,EDX
	ADD	EDX,100h
	SHL	EDX,0Ch
	PUSH	EDI
	SHL	EDI,2
	ADD	EDI,[HighLinSpacePageTbl]
@@:	MOV	EAX,EDX
	OR	EAX,67h
	STOS	DWORD PTR ES:[EDI]
	ADD	EDX,1000h
	LOOP	@B
	POP	EDX
	CALL	LinSpaceUnlock
AllocSuccess:
	MOV	ES:[ESI].XMS_Handle_InUseCnt,0
	MOV	ES:[ESI].XMS_Handle_PhysLockCnt,0
	MOV	ES:[ESI].XMS_Handle_LinBlkHnd,BX
	MOV	WORD PTR [EBP+18h],1
	MOV	EAX,ESI
	SUB	EAX,[XMSEMB_HandleTbl]
	XOR	EDX,EDX
	MOV	ECX,0Ch
	DIV	ECX
	INC	EAX
	MOV	WORD PTR [EBP+0Ch],AX
	RET
XMSEMB_Alloc	ENDP

ParseHandle	PROC	NEAR
	MOVZX	EDX,DX
	TEST	EDX,EDX
	JZ	@F
	DEC	EDX
	TEST	EDX,0FFFFFF00h
	JNZ	@F
	CMP	DL,[XMSEMB_Handles]
	JAE	@F
	SHL	EDX,2
	MOV	ESI,EDX
	SHL	EDX,1
	ADD	ESI,EDX
	ADD	ESI,[XMSEMB_HandleTbl]
	RET
@@:	MOV	WORD PTR [EBP+18h],0
	MOV	BYTE PTR [EBP+14h],0A2h
	STC
	RET
ParseHandle	ENDP

	PUBLIC	XMSEMB_Free
XMSEMB_Free	PROC	NEAR
	ASSUME	DS:MAINDAT,ES:NOTHING
	CMP	[PermLockModeTransition],0
	JZ	@F
	MOV	WORD PTR [EBP+18h],0
	MOV	BYTE PTR [EBP+14h],8Eh
	RET
@@:	CALL	ParseHandle
	JNC	@F
	RET
@@:	PUSHFD
	CLI
	CMP	ES:[ESI].XMS_Handle_Size,0FFFFFFFFh
	JNE	@F
	POPFD
	MOV	WORD PTR [EBP+18h],0
	MOV	BYTE PTR [EBP+14h],0A2h
	RET
@@:	MOV	BX,ES:[ESI].XMS_Handle_LinBlkHnd
	CMP	BX,0FFFFh
	JNE	@F
	POPFD
	MOV	WORD PTR [EBP+18h],0
	MOV	BYTE PTR [EBP+14h],0A2h
	RET
@@:	CMP	ES:[ESI].XMS_Handle_InUseCnt,0
	JZ	@F
	POPFD
	MOV	WORD PTR [EBP+18h],0
	MOV	BYTE PTR [EBP+14h],0ABh
	RET
@@:	MOV	ES:[ESI].XMS_Handle_LinBlkHnd,0FFFFh
	POPFD
	MOV	ECX,ES:[ESI].XMS_Handle_Size
	JECXZ	@F
	CALL	LinSpaceLock
	PUSH	EDX
	SHL	EDX,2
	ADD	EDX,[HighLinSpacePageTbl]
	CALL	PageUtilFreeReg
	POP	EDX
	CALL	LinSpaceUnlock
	CALL	LinSpaceFree
@@:	MOV	ES:[ESI].XMS_Handle_Size,0FFFFFFFFh
	MOV	WORD PTR [EBP+18h],1
	RET
XMSEMB_Free	ENDP

	PUBLIC	XMSEMB_MoveBlock
XMSEMB_MoveBlock	PROC	NEAR
	ASSUME	DS:MAINDAT,ES:NOTHING
	MOVZX	EAX,WORD PTR [EBP+38h]
	SHL	EAX,4
	MOVZX	EBX,WORD PTR [EBP+4]
	ADD	EBX,EAX
	MOV	ECX,DWORD PTR ES:[EBX]
	TEST	ECX,ECX
	JZ	MoveBlockSuccess
	TEST	ECX,1
	JZ	@F
	MOV	WORD PTR [EBP+18h],0
	MOV	BYTE PTR [EBP+14h],0A7h
	RET
@@:	MOV	EAX,4
	MOV	DL,0A3h
	CALL	MoveBlockPrepare
	JNC	@F
	RET
@@:	MOV	ESI,EDX
	MOV	EAX,0Ah
	MOV	DL,0A5h
	CALL	MoveBlockPrepare
	JNC	@F
	MOV	EAX,4
	CALL	MoveBlockCleanup
	RET
@@:	MOV	EDI,EDX
	CMP	ESI,EDI
	JE	MoveBlockDone
	JA	MoveBlockNormal
	MOV	EAX,ESI
	ADD	EAX,ECX
	CMP	EAX,EDI
	JBE	MoveBlockNormal
	MOV	ESI,EAX
	SUB	ESI,2
	ADD	EDI,ECX
	SUB	EDI,2
	SHR	ECX,1
	STD
	REP	MOVS	WORD PTR ES:[EDI],WORD PTR ES:[ESI]
	CLD
	JMP	MoveBlockDone
MoveBlockNormal:
	SHR	ECX,2				; Don't trash CF!
	REP	MOVS	DWORD PTR ES:[EDI],DWORD PTR ES:[ESI]
	JNC	MoveBlockDone
	MOVS	WORD PTR ES:[EDI],WORD PTR ES:[ESI]
MoveBlockDone:
	MOV	EAX,4
	CALL	MoveBlockCleanup
	MOV	EAX,0Ah
	CALL	MoveBlockCleanup
MoveBlockSuccess:
	MOV	WORD PTR [EBP+18h],1
	RET
XMSEMB_MoveBlock	ENDP

MoveBlockPrepare	PROC	NEAR
	ASSUME	DS:MAINDAT,ES:NOTHING
	PUSH	EDX
	PUSH	ESI
	MOV	DX,WORD PTR ES:[EBX+EAX]
	TEST	DX,DX
	JZ	MoveBlockConventional
	CALL	ParseHandle
	JNC	@F
	MOV	DL,BYTE PTR [ESP+4]
	JMP	MoveBlockFail
@@:	PUSHFD
	CLI
	CMP	ES:[ESI].XMS_Handle_Size,0FFFFFFFFh
	JNE	@F
	POPFD
	MOV	DL,BYTE PTR [ESP+4]
	JMP	MoveBlockFail
@@:	CMP	ES:[ESI].XMS_Handle_LinBlkHnd,0FFFFh
	JNE	@F
	POPFD
	MOV	DL,BYTE PTR [ESP+4]
	JMP	MoveBlockFail
@@:	CMP	ES:[ESI].XMS_Handle_InUseCnt,0FFh
	JNE	@F
	POPFD
	MOV	DL,0ACh
	JMP	MoveBlockFail
@@:	INC	ES:[ESI].XMS_Handle_InUseCnt
	POPFD
	PUSH	ECX
	MOV	ECX,ES:[ESI].XMS_Handle_Size
	SHL	ECX,0Ch
	MOV	EDX,DWORD PTR ES:[EBX+EAX+2]
	CMP	EDX,ECX
	JBE	@F
	POP	ECX
	DEC	ES:[ESI].XMS_Handle_InUseCnt
	MOV	DL,BYTE PTR [ESP+4]
	INC	DL
	JMP	MoveBlockFail
@@:	ADD	EDX,DWORD PTR ES:[EBX]
	CMP	EDX,ECX
	POP	ECX
	JBE	@F
	DEC	ES:[ESI].XMS_Handle_InUseCnt
	MOV	DL,0A7h
	JMP	MoveBlockFail
@@:	PUSH	EBX
	MOV	BX,ES:[ESI].XMS_Handle_LinBlkHnd
	CALL	LinSpaceLock
	POP	EBX
	PUSH	EAX
	CALL	LinSpaceAccess
	MOV	EDX,EAX
	POP	EAX
	ADD	EDX,DWORD PTR ES:[EBX+EAX+2]
	MOV	DWORD PTR [ESP+4],EDX
	CLC
	JMP	MoveBlockRet
MoveBlockConventional:
	MOVZX	ESI,WORD PTR ES:[EBX+EAX+4]
	SHL	ESI,4
	MOVZX	EDX,WORD PTR ES:[EBX+EAX+2]
	ADD	EDX,ESI
	MOV	ESI,EDX
	ADD	ESI,DWORD PTR ES:[EBX]
	CMP	ESI,110000h
	JBE	@F
	MOV	DL,0A7h
	JMP	MoveBlockFail
@@:	MOV	DWORD PTR [ESP+4],EDX
	CLC
	JMP	MoveBlockRet
MoveBlockFail:
	MOV	WORD PTR [EBP+18h],0
	MOV	BYTE PTR [EBP+14h],DL
	STC
MoveBlockRet:
	POP	ESI
	POP	EDX
	RET
MoveBlockPrepare	ENDP

MoveBlockCleanup	PROC	NEAR
	ASSUME	DS:MAINDAT,ES:NOTHING
	MOV	DX,WORD PTR ES:[EBX+EAX]
	TEST	DX,DX
	JNZ	@F
	RET
@@:	CALL	ParseHandle
	PUSH	EBX
	MOV	BX,ES:[ESI].XMS_Handle_LinBlkHnd
	CALL	LinSpaceUnlock
	POP	EBX
	DEC	ES:[ESI].XMS_Handle_InUseCnt
	RET
MoveBlockCleanup	ENDP

	PUBLIC	XMSEMB_Lock
XMSEMB_Lock	PROC	NEAR
	ASSUME	DS:MAINDAT,ES:NOTHING
; First the standard boilerplate.
	CMP	[PermLockModeTransition],0
	JZ	@F
	MOV	BYTE PTR [EBP+14h],8Eh
	JMP	LockFail
@@:	CALL	ParseHandle
	JNC	@F
	RET
@@:	PUSHFD
	CLI
	CMP	ES:[ESI].XMS_Handle_Size,0FFFFFFFFh
	JNE	@F
	POPFD
	MOV	BYTE PTR [EBP+14h],0A2h
	JMP	LockFail
@@:	CMP	ES:[ESI].XMS_Handle_LinBlkHnd,0FFFFh
	JNE	@F
	POPFD
	MOV	BYTE PTR [EBP+14h],0A2h
	JMP	LockFail
@@:	CMP	ES:[ESI].XMS_Handle_InUseCnt,0FFh
	JNE	@F
	POPFD
	MOV	BYTE PTR [EBP+14h],0ACh
	JMP	LockFail
@@:	INC	ES:[ESI].XMS_Handle_InUseCnt
; Now the physical lock count.
	MOV	DL,ES:[ESI].XMS_Handle_PhysLockCnt
	CMP	DL,0FFh
	JB	@F
	POPFD
	MOV	BYTE PTR [EBP+14h],0ABh
	JMP	LockFailDecInUseCnt
@@:	CMP	DL,0FEh
	JB	@F
	POPFD
	MOV	BYTE PTR [EBP+14h],0ACh
	JMP	LockFailDecInUseCnt
@@:	MOV	ES:[ESI].XMS_Handle_PhysLockCnt,0FFh
	POPFD
; Is it locked already?
	CMP	[PermLockMode],0
	JNZ	LockSuccess
	TEST	DL,DL
	JNZ	LockSuccess
; Actually lock it.
	CALL	PhysLock
	JNC	LockSuccess
	MOV	BYTE PTR [EBP+14h],0ADh
	JMP	LockFailRestorePhysLockCnt
LockSuccess:
	MOV	EAX,ES:[ESI].XMS_Handle_PhysPage
	ADD	EAX,100h
	SHL	EAX,0Ch
	MOV	WORD PTR [EBP+14h],AX
	SHR	EAX,10h
	MOV	WORD PTR [EBP+0Ch],AX
	INC	DL
	MOV	ES:[ESI].XMS_Handle_PhysLockCnt,DL
	DEC	ES:[ESI].XMS_Handle_InUseCnt
	MOV	WORD PTR [EBP+18h],1
	RET
LockFailRestorePhysLockCnt:
	MOV	ES:[ESI].XMS_Handle_PhysLockCnt,DL
LockFailDecInUseCnt:
	DEC	ES:[ESI].XMS_Handle_InUseCnt
LockFail:
	MOV	WORD PTR [EBP+18h],0
	RET
XMSEMB_Lock	ENDP

PhysLock	PROC	NEAR
	ASSUME	DS:MAINDAT,ES:NOTHING
; First make sure we are not wasting time on a null EMB. Locking a null EMB is
; an exercise in futility.
	CMP	ES:[ESI].XMS_Handle_Size,0
	JNZ	@F
	RET					; Success
@@:	PUSH	EAX
	PUSH	EBX
	PUSH	ECX
	PUSH	EDX
	PUSH	EDI
; First try to lock it in place. Lock it linearly and see if its pages are
; mapped contiguously and not claimed.
	MOV	BX,ES:[ESI].XMS_Handle_LinBlkHnd
	CALL	LinSpaceLock
	SHL	EDX,2
	ADD	EDX,[HighLinSpacePageTbl]
	MOV	ECX,ES:[ESI].XMS_Handle_Size
	PUSHFD
	CLI
	MOV	EDI,DWORD PTR ES:[EDX]
	SHR	EDI,0Ch
	SUB	EDI,100h
	MOV	EAX,EDI
	ADD	EAX,ECX
	CMP	EAX,[TotalPhysMemPages]
	JA	PhysLockCantLockInPlace
	SHL	EDI,2
	ADD	EDI,[PhysPageAllocTbl]
	MOV	EAX,EDI
@@:	CMP	DWORD PTR ES:[EAX],EDX
	JNE	PhysLockCantLockInPlace
	ADD	EAX,4
	ADD	EDX,4
	LOOP	@B
; Hurrah! They are mapped contigously and not claimed! Mark them as locked.
	MOV	EAX,0FFFFFFFFh
	MOV	ECX,ES:[ESI].XMS_Handle_Size
	MOV	EDX,EDI
	REP	STOS	DWORD PTR ES:[EDI]
	POPFD
	CALL	LinSpaceUnlock
	SUB	EDX,[PhysPageAllocTbl]
	SHR	EDX,2
	MOV	ES:[ESI].XMS_Handle_PhysPage,EDX
	JMP	PhysLockRet
PhysLockCantLockInPlace:
	POPFD
	CALL	LinSpaceUnlock
; Since we couldn't lock it in place, try to allocate a physical region and
; then move the block there.
	MOV	ECX,ES:[ESI].XMS_Handle_Size
	CALL	PhysRegionAlloc
	JC	PhysLockRet
; Successful! The rest is tedious, but not error-prone.
	MOV	ES:[ESI].XMS_Handle_PhysPage,EDX
	MOV	EDI,EDX
	ADD	EDI,100h
	SHL	EDI,0Ch
	CALL	LinSpaceLock
	SHL	EDX,2
	ADD	EDX,[HighLinSpacePageTbl]
; Now the move loop.
	PUSH	ESI
@@:	PUSH	ECX
	PUSHFD
	CLI
	MOV	ESI,DWORD PTR ES:[EDX]
	AND	ESI,0FFFFF000h
	MOV	EAX,ESI
	PUSH	EDI
	OR	EDI,67h
	MOV	DWORD PTR ES:[EDX],EDI
	POP	EDI
	MOV	ECX,400h
	REP	MOVS	DWORD PTR ES:[EDI],DWORD PTR ES:[ESI]
	PUSH	EDX
	MOV	EDX,EAX
	SHR	EDX,0Ch
	SUB	EDX,100h
	CALL	PhysPageFree
	POP	EDX
	MOV	EAX,[PDBRVAL]
	MOV	CR3,EAX
	POPFD
	POP	ECX
	ADD	EDX,4
	LOOP	@B
	POP	ESI
	CALL	LinSpaceUnlock
	CLC
PhysLockRet:
	POP	EDI
	POP	EDX
	POP	ECX
	POP	EBX
	POP	EAX
	RET
PhysLock	ENDP

	PUBLIC	XMSEMB_Unlock
XMSEMB_Unlock	PROC	NEAR
	ASSUME	DS:MAINDAT,ES:NOTHING
; First the standard boilerplate.
	CMP	[PermLockModeTransition],0
	JZ	@F
	MOV	BYTE PTR [EBP+14h],8Eh
	JMP	UnlockFail
@@:	CALL	ParseHandle
	JNC	@F
	RET
@@:	PUSHFD
	CLI
	CMP	ES:[ESI].XMS_Handle_Size,0FFFFFFFFh
	JNE	@F
	POPFD
	MOV	BYTE PTR [EBP+14h],0A2h
	JMP	UnlockFail
@@:	CMP	ES:[ESI].XMS_Handle_LinBlkHnd,0FFFFh
	JNE	@F
	POPFD
	MOV	BYTE PTR [EBP+14h],0A2h
	JMP	UnlockFail
@@:	CMP	ES:[ESI].XMS_Handle_InUseCnt,0FFh
	JNE	@F
	POPFD
	MOV	BYTE PTR [EBP+14h],0ACh
	JMP	UnlockFail
@@:	INC	ES:[ESI].XMS_Handle_InUseCnt
; Now the physical lock count.
	MOV	DL,ES:[ESI].XMS_Handle_PhysLockCnt
	CMP	DL,0FFh
	JB	@F
	POPFD
	MOV	BYTE PTR [EBP+14h],0ABh
	JMP	UnlockFailDecInUseCnt
@@:	TEST	DL,DL
	JNZ	@F
	POPFD
	MOV	BYTE PTR [EBP+14h],0AAh
	JMP	UnlockFailDecInUseCnt
@@:	MOV	ES:[ESI].XMS_Handle_PhysLockCnt,0FFh
	POPFD
	DEC	DL
; Should we really unlock it?
	CMP	[PermLockMode],0
	JNZ	UnlockSuccess
	TEST	DL,DL
	JNZ	UnlockSuccess
; Actually unlock it.
	CALL	PhysUnlock
UnlockSuccess:
	MOV	ES:[ESI].XMS_Handle_PhysLockCnt,DL
	DEC	ES:[ESI].XMS_Handle_InUseCnt
	MOV	WORD PTR [EBP+18h],1
	RET
UnlockFailDecInUseCnt:
	DEC	ES:[ESI].XMS_Handle_InUseCnt
UnlockFail:
	MOV	WORD PTR [EBP+18h],0
	RET
XMSEMB_Unlock	ENDP

PhysUnlock	PROC	NEAR
	ASSUME	DS:MAINDAT,ES:NOTHING
; First make sure we are not wasting time on a null EMB.
	CMP	ES:[ESI].XMS_Handle_Size,0
	JNZ	@F
	RET
@@:	PUSH	EAX
	PUSH	EBX
	PUSH	ECX
	PUSH	EDX
	MOV	BX,ES:[ESI].XMS_Handle_LinBlkHnd
	CALL	LinSpaceLock
	SHL	EDX,2
	ADD	EDX,[HighLinSpacePageTbl]
	MOV	ECX,ES:[ESI].XMS_Handle_Size
@@:	MOV	EAX,DWORD PTR ES:[EDX]
	SHR	EAX,0Ch
	SUB	EAX,100h
	SHL	EAX,2
	ADD	EAX,[PhysPageAllocTbl]
	MOV	DWORD PTR ES:[EAX],EDX
	ADD	EDX,4
	LOOP	@B
	CALL	LinSpaceUnlock
	POP	EDX
	POP	ECX
	POP	EBX
	POP	EAX
	RET
PhysUnlock	ENDP

	PUBLIC	XMSEMB_HandleInfo
XMSEMB_HandleInfo	PROC	NEAR
	ASSUME	DS:MAINDAT,ES:NOTHING
	CALL	ParseHandle
	JNC	@F
	RET
@@:	PUSHFD
	CLI
	MOV	EDX,ES:[ESI].XMS_Handle_Size
	CMP	EDX,0FFFFFFFFh
	JNE	@F
	POPFD
	MOV	WORD PTR [EBP+18h],0
	MOV	BYTE PTR [EBP+14h],0A2h
	RET
@@:	CMP	ES:[ESI].XMS_Handle_LinBlkHnd,0FFFFh
	JNE	@F
	POPFD
	MOV	WORD PTR [EBP+18h],0
	MOV	BYTE PTR [EBP+14h],0A2h
	RET
@@:	MOV	BH,ES:[ESI].XMS_Handle_PhysLockCnt
	XOR	EAX,EAX
	MOV	ESI,[XMSEMB_HandleTbl]
	MOVZX	ECX,[XMSEMB_Handles]
HandleInfoCountFree:
	CMP	ES:[ESI].XMS_Handle_Size,0FFFFFFFFh
	JNE	@F
	INC	EAX
@@:	ADD	ESI,0Ch
	LOOP	HandleInfoCountFree
	POPFD
	SHL	EDX,2
	TEST	BYTE PTR [EBP+18h],80h
	JZ	@F
	MOV	WORD PTR [EBP+18h],1
	MOV	BYTE PTR [EBP+15h],BH
	MOV	WORD PTR [EBP+10h],AX
	MOV	DWORD PTR [EBP+0Ch],EDX
	RET
@@:	CMP	EDX,0FFFFh
	JBE	@F
	MOV	WORD PTR [EBP+18h],0
	MOV	BYTE PTR [EBP+14h],0A2h
	RET
@@:	MOV	WORD PTR [EBP+18h],1
	MOV	BYTE PTR [EBP+14h],AL
	MOV	BYTE PTR [EBP+15h],BH
	MOV	WORD PTR [EBP+0Ch],DX
	RET
XMSEMB_HandleInfo	ENDP

	PUBLIC	XMSEMB_Realloc
XMSEMB_Realloc	PROC	NEAR
	ASSUME	DS:MAINDAT,ES:NOTHING
	CMP	[PermLockModeTransition],0
	JZ	@F
	MOV	WORD PTR [EBP+18h],0
	MOV	BYTE PTR [EBP+14h],8Eh
	RET
@@:	CMP	[PermLockMode],0
	JZ	@F
	MOV	WORD PTR [EBP+18h],0
	MOV	BYTE PTR [EBP+14h],80h
	RET
@@:	CALL	ParseHandle
	JNC	@F
	RET
@@:	PUSHFD
	CLI
	CMP	ES:[ESI].XMS_Handle_Size,0FFFFFFFFh
	JNE	@F
	POPFD
	MOV	WORD PTR [EBP+18h],0
	MOV	BYTE PTR [EBP+14h],0A2h
	RET
@@:	MOV	BX,ES:[ESI].XMS_Handle_LinBlkHnd
	CMP	BX,0FFFFh
	JNE	@F
	POPFD
	MOV	WORD PTR [EBP+18h],0
	MOV	BYTE PTR [EBP+14h],0A2h
	RET
@@:	CMP	ES:[ESI].XMS_Handle_InUseCnt,0
	JZ	@F
	POPFD
	MOV	WORD PTR [EBP+18h],0
	MOV	BYTE PTR [EBP+14h],0ABh
	RET
@@:	CMP	ES:[ESI].XMS_Handle_PhysLockCnt,0
	JZ	@F
	POPFD
	MOV	WORD PTR [EBP+18h],0
	MOV	BYTE PTR [EBP+14h],0ABh
	RET
@@:	MOV	ES:[ESI].XMS_Handle_LinBlkHnd,0FFFFh
	POPFD
; Now get the new size.
	MOV	ECX,DWORD PTR [EBP+14h]
	TEST	BYTE PTR [EBP+18h],80h
	JNZ	@F
	MOVZX	ECX,CX
@@:	ADD	ECX,3
	SHR	ECX,2
; Now see whether we are doing nothing, allocating, freeing, or really
; resizing.
	XOR	EAX,EAX
	JECXZ	@F
	OR	AL,4
@@:	CMP	ES:[ESI].XMS_Handle_Size,0
	JZ	@F
	OR	AL,8
@@:	CALL	ReallocFuncTbl[EAX]
; The routine we've just called has set the client registers for return. Now
; regardless of the outcome, we have to put the linear block handle back in.
	MOV	ES:[ESI].XMS_Handle_LinBlkHnd,BX
	RET
XMSEMB_Realloc	ENDP

ReallocDoNothing	PROC	NEAR
	ASSUME	DS:MAINDAT,ES:NOTHING
	MOV	WORD PTR [EBP+18h],1
	RET
ReallocDoNothing	ENDP

ReallocAlloc	PROC	NEAR
	ASSUME	DS:MAINDAT,ES:NOTHING
; Allocate the high linear block.
	CALL	LinSpaceAlloc
	JNC	@F
	MOV	BYTE PTR [EBP+14h],0A1h
	JMP	ReallocAllocFail
@@:
; Now fill it with memory.
; Lock the linear block handle and fill it.
	CALL	LinSpaceLock
	PUSH	EDX
	SHL	EDX,2
	ADD	EDX,[HighLinSpacePageTbl]
	CALL	PageUtilFillRegWithUnlockedPages
	JC	@F
	POP	EDX
	CALL	LinSpaceUnlock
	JMP	ReallocAllocSuccess
@@:	JECXZ	@F
	CALL	PageUtilFreeReg
@@:	POP	EDX
	MOV	BYTE PTR [EBP+14h],0A0h
	CALL	LinSpaceUnlock
	CALL	LinSpaceFree
ReallocAllocFail:
	MOV	WORD PTR [EBP+18h],0
	RET
ReallocAllocSuccess:
	MOV	ES:[ESI].XMS_Handle_Size,ECX
	MOV	WORD PTR [EBP+18h],1
	RET
ReallocAlloc	ENDP

ReallocFree	PROC	NEAR
	ASSUME	DS:MAINDAT,ES:NOTHING
	MOV	ECX,ES:[ESI].XMS_Handle_Size
	CALL	LinSpaceLock
	PUSH	EDX
	SHL	EDX,2
	ADD	EDX,[HighLinSpacePageTbl]
	CALL	PageUtilFreeReg
	POP	EDX
	CALL	LinSpaceUnlock
	CALL	LinSpaceFree
	XOR	BX,BX
	MOV	ES:[ESI].XMS_Handle_Size,0
	MOV	ES:[ESI].XMS_Handle_PhysPage,0
	MOV	WORD PTR [EBP+18h],1
	RET
ReallocFree	ENDP

ReallocResize	PROC	NEAR
	ASSUME	DS:MAINDAT,ES:NOTHING
	CMP	ECX,ES:[ESI].XMS_Handle_Size
	JB	ReallocShrink
	JA	ReallocGrow
	MOV	WORD PTR [EBP+18h],1
	RET
ReallocResize	ENDP

ReallocShrink	PROC	NEAR
	ASSUME	DS:MAINDAT,ES:NOTHING
	PUSH	EBP
	MOV	EBP,ES:[ESI].XMS_Handle_Size
	CALL	LinSpaceLock
	PUSH	ECX
	PUSH	EDX
	ADD	EDX,ECX
	SHL	EDX,2
	ADD	EDX,[HighLinSpacePageTbl]
	SUB	EBP,ECX
	MOV	ECX,EBP
	CALL	PageUtilFreeReg
	POP	EDX
	POP	ECX
	CALL	LinSpaceUnlock
	CALL	LinSpaceShrinkInPlace
	MOV	ES:[ESI].XMS_Handle_Size,ECX
	POP	EBP
	MOV	WORD PTR [EBP+18h],1
	RET
ReallocShrink	ENDP

ReallocGrow	PROC	NEAR
	ASSUME	DS:MAINDAT,ES:NOTHING
; First grow the linear block.
	CALL	LinSpaceGrowAnywhere
	JNC	@F
	MOV	WORD PTR [EBP+18h],0
	MOV	BYTE PTR [EBP+14h],0A1h
	RET
@@:
; Now fill the added pages with memory.
	CALL	LinSpaceLock
	PUSH	ECX
	PUSH	EDX
	ADD	EDX,ES:[ESI].XMS_Handle_Size
	SHL	EDX,2
	ADD	EDX,[HighLinSpacePageTbl]
	SUB	ECX,ES:[ESI].XMS_Handle_Size
	CALL	PageUtilFillRegWithUnlockedPages
	JC	@F
	POP	EDX
	POP	ECX
	CALL	LinSpaceNoAccess		; We've mapped in extra pages
	CALL	LinSpaceUnlock
	MOV	ES:[ESI].XMS_Handle_Size,ECX
	MOV	WORD PTR [EBP+18h],1
	RET
@@:	JECXZ	@F
	CALL	PageUtilFreeReg
@@:	POP	EDX
	POP	ECX
	CALL	LinSpaceUnlock
	MOV	ECX,ES:[ESI].XMS_Handle_Size
	CALL	LinSpaceShrinkInPlace
	MOV	WORD PTR [EBP+18h],0
	MOV	BYTE PTR [EBP+14h],0A0h
	RET
ReallocGrow	ENDP

	PUBLIC	XMSEMB_PermLockModeEnter
XMSEMB_PermLockModeEnter	PROC	NEAR
	ASSUME	DS:MAINDAT,ES:NOTHING
	PUSH	EBX
	PUSH	ECX
	PUSH	ESI
	MOV	[PermLockModeTransition],1
	MOV	ESI,[XMSEMB_HandleTbl]
	MOVZX	ECX,[XMSEMB_Handles]
	XOR	EBX,EBX
PermLockModeEnterLoop:
	CMP	ES:[ESI].XMS_Handle_Size,0FFFFFFFFh
	JE	@F
	CALL	PhysLock
	JC	PermLockModeEnterFail
@@:	ADD	ESI,0Ch
	INC	EBX
	LOOP	PermLockModeEnterLoop
	MOV	[PermLockMode],1
PermLockModeEnterRet:
	MOV	[PermLockModeTransition],0
	POP	ESI
	POP	ECX
	POP	EBX
	RET
PermLockModeEnterFail:
	MOV	ESI,[XMSEMB_HandleTbl]
	MOV	ECX,EBX
	JECXZ	PermLockModeEnterRet
PermLockModeEnterFailLoop:
	CMP	ES:[ESI].XMS_Handle_Size,0FFFFFFFFh
	JE	@F
	CALL	PhysUnlock
@@:	ADD	ESI,0Ch
	LOOP	PermLockModeEnterFailLoop
	STC
	JMP	PermLockModeEnterRet
XMSEMB_PermLockModeEnter	ENDP

	PUBLIC	XMSEMB_PermLockModeLeave
XMSEMB_PermLockModeLeave	PROC	NEAR
	ASSUME	DS:MAINDAT,ES:NOTHING
	PUSH	ECX
	PUSH	ESI
	MOV	[PermLockModeTransition],1
	MOV	ESI,[XMSEMB_HandleTbl]
	MOVZX	ECX,[XMSEMB_Handles]
PermLockModeLeaveLoop:
	CMP	ES:[ESI].XMS_Handle_Size,0FFFFFFFFh
	JE	@F
	CALL	PhysUnlock
@@:	ADD	ESI,0Ch
	LOOP	PermLockModeLeaveLoop
	MOV	[PermLockMode],0
	MOV	[PermLockModeTransition],0
	POP	ESI
	POP	ECX
	RET
XMSEMB_PermLockModeLeave	ENDP

	PUBLIC	XMSEMB_PagingImport
XMSEMB_PagingImport	PROC	NEAR
	ASSUME	DS:MAINDAT,ES:NOTHING
	PUSH	EAX
	PUSH	ECX
	PUSH	EBP
	PUSH	ESI
	MOV	AL,[XMSEMB_Handles]
	STOS	BYTE PTR ES:[EDI]
	MOVZX	ECX,AL
	MOV	EBP,1
	MOV	ESI,[XMSEMB_HandleTbl]
PagingImportLoop:
	MOV	EAX,EBP
	STOS	WORD PTR ES:[EDI]
	CMP	ES:[ESI].XMS_Handle_Size,0FFFFFFFFh
	JE	@F
	XOR	EAX,EAX
	STOS	WORD PTR ES:[EDI]
	MOV	EAX,ES:[ESI].XMS_Handle_Size
	SHL	EAX,2
	STOS	DWORD PTR ES:[EDI]
	MOV	EAX,ES:[ESI].XMS_Handle_PhysPage
	ADD	EAX,100h
	SHL	EAX,0Ch
	STOS	DWORD PTR ES:[EDI]
	JMP	PagingImportNext
@@:	MOV	EAX,1
	STOS	WORD PTR ES:[EDI]
	XOR	EAX,EAX
	STOS	DWORD PTR ES:[EDI]
	STOS	DWORD PTR ES:[EDI]
PagingImportNext:
	ADD	ESI,0Ch
	INC	EBP
	LOOP	PagingImportLoop
	POP	ESI
	POP	EBP
	POP	ECX
	POP	EAX
	RET
XMSEMB_PagingImport	ENDP

MAINCOD	ENDS

MAINDAT	SEGMENT	USE32	BYTE	PUBLIC	'DATA'

	EXTRN	TotalPhysMemPages:DWORD
	EXTRN	FreePages:DWORD
	EXTRN	PhysPageAllocTbl:DWORD
	EXTRN	HighLinSpacePageTbl:DWORD
	EXTRN	PDBRVAL:DWORD

	PUBLIC	XMSEMB_Handles
XMSEMB_Handles		DB	?
	PUBLIC	XMSEMB_HandleTbl
XMSEMB_HandleTbl	DD	?

PermLockMode		DB	0
PermLockModeTransition	DB	0

ReallocFuncTbl	DD	ReallocDoNothing,ReallocAlloc,ReallocFree,ReallocResize

MAINDAT	ENDS

	END
