	INCLUDE	MMM386.INC
	.386P
STARTUP	SEGMENT	USE32	BYTE	PUBLIC	'CODE'
STARTUP	ENDS

MAINCOD	SEGMENT	USE32	BYTE	PUBLIC	'CODE'

	EXTRN	PhysPageAlloc:NEAR
	EXTRN	PhysPageFree:NEAR

	ASSUME	CS:MAINCOD,DS:NOTHING,ES:NOTHING,SS:NOTHING

; PageUtilFillRegWithUnlockedPages fills a linear region with unlocked pages.
; On entry EDX points to the PTEs to fill and ECX contains the number of pages
; to fill. If successful, CF is clear. If not successful (out of memory), CF is
; set and ECX contains the # of pages allocated. These pages are left
; allocated, so "not successful" really means partially successful unless ECX
; is 0 on return.
	PUBLIC	PageUtilFillRegWithUnlockedPages
PageUtilFillRegWithUnlockedPages	PROC	NEAR
	ASSUME	DS:MAINDAT,ES:NOTHING
	PUSH	EAX
	PUSH	EBX
	PUSH	EDX
	PUSH	EDI
	MOV	EDI,EDX
	XOR	EBX,EBX
@@:	CALL	PhysPageAlloc
	JC	@F
	MOV	EAX,EDX
	SHL	EAX,2
	ADD	EAX,[PhysPageAllocTbl]
	PUSHFD
	CLI
	MOV	DWORD PTR ES:[EAX],EDI
	MOV	EAX,EDX
	ADD	EAX,100h
	SHL	EAX,0Ch
	OR	EAX,67h
	STOS	DWORD PTR ES:[EDI]
	POPFD
	INC	EBX
	LOOP	@B
@@:	MOV	ECX,EBX
	POP	EDI
	POP	EDX
	POP	EBX
	POP	EAX
	RET
PageUtilFillRegWithUnlockedPages	ENDP

; PageUtilFillRegWithLockedPages fills a linear region with locked pages. On
; entry EDX points to the PTEs to fill and ECX contains the number of pages to
; fill. If successful, CF is clear. If not successful (out of memory), CF is
; set and ECX contains the # of pages allocated. These pages are left
; allocated, so "not successful" really means partially successful unless ECX
; is 0 on return.
	PUBLIC	PageUtilFillRegWithLockedPages
PageUtilFillRegWithLockedPages	PROC	NEAR
	ASSUME	DS:MAINDAT,ES:NOTHING
	PUSH	EAX
	PUSH	EBX
	PUSH	EDX
	PUSH	EDI
	MOV	EDI,EDX
	XOR	EBX,EBX
@@:	CALL	PhysPageAlloc
	JC	@F
	MOV	EAX,EDX
	ADD	EAX,100h
	SHL	EAX,0Ch
	OR	EAX,67h
	STOS	DWORD PTR ES:[EDI]
	INC	EBX
	LOOP	@B
@@:	MOV	ECX,EBX
	POP	EDI
	POP	EDX
	POP	EBX
	POP	EAX
	RET
PageUtilFillRegWithLockedPages	ENDP

; PageUtilFreeReg frees all physical pages in a linear region. On entry EDX
; points to the PTEs to free and ECX contains the # of pages to free. Always
; succeeds.
	PUBLIC	PageUtilFreeReg
PageUtilFreeReg	PROC	NEAR
	ASSUME	DS:MAINDAT,ES:NOTHING
	PUSH	EAX
	PUSH	ECX
	PUSH	EDX
	PUSH	ESI
	PUSH	EDI
	MOV	ESI,EDX
	MOV	EDI,EDX
@@:	LODS	DWORD PTR ES:[ESI]
	MOV	EDX,EAX
	SHR	EDX,0Ch
	SUB	EDX,100h
	XOR	EAX,EAX
	PUSHFD
	CLI
	STOS	DWORD PTR ES:[EDI]
	CALL	PhysPageFree
	POPFD
	LOOP	@B
	POP	EDI
	POP	ESI
	POP	EDX
	POP	ECX
	POP	EAX
	RET
PageUtilFreeReg	ENDP

MAINCOD	ENDS

MAINDAT	SEGMENT	USE32	BYTE	PUBLIC	'DATA'

	EXTRN	PhysPageAllocTbl:DWORD

MAINDAT	ENDS

	END
