	INCLUDE	MMM386.INC
	.386P
STARTUP	SEGMENT	USE32	BYTE	PUBLIC	'CODE'

	ASSUME	CS:STARTUP,DS:NOTHING,ES:NOTHING,SS:NOTHING

	PUBLIC	LinSpaceInitPageTables
LinSpaceInitPageTables	PROC	NEAR
	ASSUME	DS:MAINDAT,ES:NOTHING
	MOV	[HighLinSpacePageTbl],EDI
	MOV	ESI,EDI
	MOV	ECX,[HighLinSpacePageTables]
	SHL	ECX,0Ah
	MOV	[HighLinSpacePages],ECX
	DEC	ECX
	MOV	EAX,ECX
	SHL	EAX,0Ch
	STOSD
	XOR	EAX,EAX
	REP	STOSD
	PUSH	EDI
	MOV	EDI,[PDBRVAL]
	ADD	EDI,800h
	MOV	ECX,[HighLinSpacePageTables]
@@:	MOV	EAX,ESI
	OR	EAX,67h
	STOSD
	ADD	ESI,1000h
	LOOP	@B
	POP	EDI
	RET
LinSpaceInitPageTables	ENDP

	PUBLIC	LinSpaceInitHandleTbl
LinSpaceInitHandleTbl	PROC	NEAR
	ASSUME	DS:MAINDAT,ES:NOTHING
	MOV	[LinBlockHandleTbl],EDI
	XOR	EAX,EAX
	MOVZX	ECX,[LinBlockHandles]
	REP	STOSD
	RET
LinSpaceInitHandleTbl	ENDP

STARTUP	ENDS

MAINCOD	SEGMENT	USE32	BYTE	PUBLIC	'CODE'

	ASSUME	CS:MAINCOD,DS:NOTHING,ES:NOTHING,SS:NOTHING

; LinSpaceAlloc allocates a high linear block. On entry ECX contains the block
; size in pages. If successful, CF is clear and BX contains the handle for the
; allocated block. The high word of EBX must be regarded as corrupt. If not
; successful, CF is set.
; Blocks are allocated unlocked.
	PUBLIC	LinSpaceAlloc
LinSpaceAlloc	PROC	NEAR
	ASSUME	DS:MAINDAT,ES:NOTHING
	PUSH	EAX
	PUSH	ECX
	PUSH	EDX
	PUSH	EBP
	PUSH	ESI
	PUSH	EDI
; First get ourselves a handle.
	MOV	EDI,[LinBlockHandleTbl]
	XOR	EAX,EAX
	PUSHFD
	CLI
	PUSH	ECX
	MOVZX	ECX,[LinBlockHandles]
	REPNZ	SCAS	DWORD PTR ES:[EDI]
	POP	ECX
	JNZ	AllocFailed
	SUB	EDI,4
	MOV	EBX,EDI
; Now try to find and allocate a large enough contiguous piece of free linear
; address space.
	INC	ECX				; Add block info PTE overhead
	MOV	ESI,[HighLinSpacePageTbl]
	MOV	EAX,[HighLinSpacePages]
	LEA	EBP,[ESI+EAX*4]			; Point to the end of the table
AllocSearchForContigFreeReg:
	CMP	ESI,EBP
	JE	AllocNoContigFreeReg
	LODS	DWORD PTR ES:[ESI]
	TEST	EAX,200h			; Allocated?
	PUSHFD
	SHR	EAX,0Ch				; Isolate region size
	POPFD
	JNZ	@F
	CMP	EAX,ECX
	JAE	AllocFoundContigFreeReg
@@:	SHL	EAX,2				; Skip over this one
	ADD	ESI,EAX
	JMP	AllocSearchForContigFreeReg
AllocFoundContigFreeReg:
; First mark our region as allocated and mark the remainder, if any, as free.
	MOV	EDI,ECX
	SHL	EDI,0Ch
	OR	EDI,200h
	MOV	DWORD PTR ES:[ESI-4],EDI
	SUB	EAX,ECX
	JZ	@F
	SHL	EAX,0Ch
	MOV	DWORD PTR ES:[ESI+ECX*4],EAX
@@:
; Now fill the handle table entry and the block info PTE.
	ADD	ESI,4
	MOV	EAX,ESI
	SUB	EAX,[HighLinSpacePageTbl]
	SHR	EAX,2
	MOV	DWORD PTR ES:[EBX],EAX
	SUB	EBX,[LinBlockHandleTbl]
	SHR	EBX,2
	MOV	WORD PTR ES:[ESI-2],BX
	MOV	WORD PTR ES:[ESI-4],0000h
	POPFD
	POP	EDI
	POP	ESI
	POP	EBP
	POP	EDX
	POP	ECX
	POP	EAX
	RET
AllocNoContigFreeReg:
; See if there is a large enough region without locked blocks.
	MOV	ESI,[HighLinSpacePageTbl]
AllocSearchForContigUnlockedReg:
	CMP	ESI,EBP
	JE	AllocFailed
	LODS	DWORD PTR ES:[ESI]
	TEST	EAX,200h			; Allocated?
	JZ	@F				; N - Great!
	CMP	BYTE PTR ES:[ESI+1],0		; Locked?
	JZ	@F				; N - Great!
	SHR	EAX,0Ch				; Skip over this one
	SHL	EAX,2
	ADD	ESI,EAX
	JMP	AllocSearchForContigUnlockedReg
@@:
; An unlocked region starts here.
	MOV	EDI,ESI
	XOR	EDX,EDX				; No free space so far
AllocContinueUnlockedReg:
	TEST	EAX,200h
	PUSHFD
	SHR	EAX,0Ch
	POPFD
	JNZ	@F				; Allocated?
	ADD	EDX,EAX				; N - count it as free
	INC	EDX				; Count the arena PTE too
@@:	SHL	EAX,2
	ADD	ESI,EAX
	CMP	ESI,EBP
	JE	AllocSeeIfUnlockedRegSuitsUs
	LODS	DWORD PTR ES:[ESI]
	TEST	EAX,200h			; Allocated?
	JZ	AllocContinueUnlockedReg	; N - Great!
	CMP	BYTE PTR ES:[ESI+1],0		; Locked?
	JZ	AllocContinueUnlockedReg	; N - Great!
	SUB	ESI,4
AllocSeeIfUnlockedRegSuitsUs:
	CMP	EDX,ECX
	JBE	AllocSearchForContigUnlockedReg
; Found it! Now we have to squeeze it. During the squeeze ESI points to the
; next arena being studied and EDI points to the place where the next block
; would go if moved. EBP points to the end of the region we are working on.
	SUB	EDI,4
	MOV	EBP,ESI
	MOV	ESI,EDI
	PUSH	ECX				; Req size isn't needed here
AllocSqueezeLoop:
	CMP	ESI,EBP
	JE	AllocSqueezeDone
	LODS	DWORD PTR ES:[ESI]
	TEST	EAX,200h
	JNE	@F
	SHR	EAX,0Ch				; Simply skip over free regions
	LEA	ESI,[ESI+EAX*4]
	JMP	AllocSqueezeLoop
@@:	SUB	ESI,4
	CMP	ESI,EDI				; Do we have to move it?
	JNE	@F				; Y - Do it
	SHR	EAX,0Ch				; We can skip over this one
	LEA	ESI,[ESI+EAX*4+4]
	MOV	EDI,ESI				; We didn't move it, but it is
	JMP	AllocSqueezeLoop		;  in place nonetheless
@@:	AND	EAX,NOT 400h			; Not accessible any more
	MOV	DWORD PTR ES:[ESI],EAX
	SHR	EAX,0Ch
	INC	EAX				; We are moving arena PTE too
	MOV	ECX,EAX
	MOVZX	EAX,WORD PTR ES:[ESI+6]		; Get the handle
	SHL	EAX,2
	ADD	EAX,[LinBlockHandleTbl]
	MOV	EDX,EDI
	SUB	EDX,[HighLinSpacePageTbl]
	SHR	EDX,2
	ADD	EDX,2				; Arena header and block info
	MOV	DWORD PTR ES:[EAX],EDX
	PUSH	ESI
	PUSH	EDI
	PUSH	ECX
	REP	MOVS	DWORD PTR ES:[EDI],DWORD PTR ES:[ESI]
	POP	ECX
	POP	ESI
	ADD	ESI,8				; Point to the real PTEs
	SUB	ECX,2
; Update the PTE pointers for any unlocked physical pages in there.
AllocUpdateUnlockedPagePtrsLoop:
	LODS	DWORD PTR ES:[ESI]
	TEST	EAX,1				; Real present page?
	JZ	AllocUpdateUnlockedPagePtrsNext
	SHR	EAX,0Ch
	SUB	EAX,100h
	JC	AllocUpdateUnlockedPagePtrsNext
	SHL	EAX,2
	ADD	EAX,[PhysPageAllocTbl]
	CMP	DWORD PTR ES:[EAX],0FFFFFFFFh
	JE	AllocUpdateUnlockedPagePtrsNext
	AND	DWORD PTR ES:[EAX],1
	MOV	EDX,ESI
	SUB	EDX,4
	OR	DWORD PTR ES:[EAX],EDX
AllocUpdateUnlockedPagePtrsNext:
	LOOP	AllocUpdateUnlockedPagePtrsLoop
	POP	ESI
	JMP	AllocSqueezeLoop
AllocSqueezeDone:
	POP	ECX
	MOV	ESI,EDI
	ADD	ESI,4
	SUB	EBP,ESI
	SHR	EBP,2
	MOV	EAX,EBP
	JMP	AllocFoundContigFreeReg
AllocFailed:
	POPFD
	STC
	POP	EDI
	POP	ESI
	POP	EBP
	POP	EDX
	POP	ECX
	POP	EAX
	RET
LinSpaceAlloc	ENDP

; LinSpaceFree frees a high linear block. On entry BX contains the block
; handle. Always succeeds.
	PUBLIC	LinSpaceFree
LinSpaceFree	PROC	NEAR
	ASSUME	DS:MAINDAT,ES:NOTHING
	PUSH	EAX
	PUSH	EBX
	PUSH	EDX
	PUSH	EBP
	PUSH	ESI
	MOVZX	EBX,BX
	SHL	EBX,2
	ADD	EBX,[LinBlockHandleTbl]
	PUSHFD
	CLI
	MOV	EDX,DWORD PTR ES:[EBX]
	MOV	DWORD PTR ES:[EBX],0		; Free it
	SUB	EDX,2				; Point to the arena PTE
	SHL	EDX,2
	MOV	ESI,[HighLinSpacePageTbl]
	ADD	EDX,ESI
	MOV	EAX,[HighLinSpacePages]
	LEA	EBP,[ESI+EAX*4]
; First pre-coalesce it.
FreePreCoalesceLoop:
	CMP	ESI,EDX
	JE	FreePreCoalesceDone
	LODS	DWORD PTR ES:[ESI]
	TEST	EAX,200h
	PUSHFD
	SHR	EAX,0Ch
	POPFD
	LEA	EAX,[ESI+EAX*4]
	JNZ	@F
	CMP	EAX,EDX				; Can we pre-coalesce it?
	JNE	@F
	SUB	ESI,4
	JMP	FreePreCoalesceDone
@@:	MOV	ESI,EAX
	JMP	FreePreCoalesceLoop
FreePreCoalesceDone:
; Now post-coalesce it.
	MOV	EAX,DWORD PTR ES:[EDX]
	SHR	EAX,0Ch
	LEA	EDX,[EDX+EAX*4+4]
	CMP	EDX,EBP
	JE	FreePostCoalesceDone
	TEST	DWORD PTR ES:[EDX],200h
	JNE	FreePostCoalesceDone
	MOV	EAX,DWORD PTR ES:[EDX]
	SHR	EAX,0Ch
	LEA	EDX,[EDX+EAX*4+4]
FreePostCoalesceDone:
; Now put it a free region arena PTE and we are done!
	ADD	ESI,4
	SUB	EDX,ESI
	SHL	EDX,0Ah
	MOV	DWORD PTR ES:[ESI-4],EDX
	POPFD
	POP	ESI
	POP	EBP
	POP	EDX
	POP	EBX
	POP	EAX
	RET
LinSpaceFree	ENDP

; LinSpaceLock locks a high linear block. On entry BX contains the block
; handle. If successful, CF is clear and EDX contains the starting high linear
; page # for the block. If not successful (lock count overflow), CF is set.
	PUBLIC	LinSpaceLock
LinSpaceLock	PROC	NEAR
	ASSUME	DS:MAINDAT,ES:NOTHING
	PUSH	EBX
	MOVZX	EBX,BX
	SHL	EBX,2
	ADD	EBX,[LinBlockHandleTbl]
	PUSHFD
	CLI
	MOV	EDX,DWORD PTR ES:[EBX]
	MOV	EBX,EDX
	SHL	EBX,2
	ADD	EBX,[HighLinSpacePageTbl]
	CMP	BYTE PTR ES:[EBX-3],0FFh
	JE	LockCountOverflow
	INC	BYTE PTR ES:[EBX-3]
	POPFD
	POP	EBX
	RET
LockCountOverflow:
	POPFD
	STC
	POP	EBX
	RET
LinSpaceLock	ENDP

; LinSpaceUnlock unlocks a high linear block. On entry BX contains the block
; handle. Always succeeds.
	PUBLIC	LinSpaceUnlock
LinSpaceUnlock	PROC	NEAR
	ASSUME	DS:MAINDAT,ES:NOTHING
	PUSH	EBX
	PUSH	EDX
	MOVZX	EBX,BX
	SHL	EBX,2
	ADD	EBX,[LinBlockHandleTbl]
	MOV	EDX,DWORD PTR ES:[EBX]
	SHL	EDX,2
	ADD	EDX,[HighLinSpacePageTbl]
	DEC	BYTE PTR ES:[EDX-3]
	POP	EDX
	POP	EBX
	RET
LinSpaceUnlock	ENDP

; LinSpaceAccess prepares a locked high linear block for direct access. On
; entry EDX contains the starting linear page # for the block. On exit EAX
; contains the starting linear address for the block. Always succeeds.
	PUBLIC	LinSpaceAccess
LinSpaceAccess	PROC	NEAR
	ASSUME	DS:MAINDAT,ES:NOTHING
	PUSH	EDX
	SHL	EDX,2
	ADD	EDX,[HighLinSpacePageTbl]
	TEST	DWORD PTR ES:[EDX-8],400h
	JNZ	@F
	MOV	EAX,[PDBRVAL]
	MOV	CR3,EAX
	OR	DWORD PTR ES:[EDX-8],400h
@@:	POP	EDX
	MOV	EAX,EDX
	SHL	EAX,0Ch
	ADD	EAX,80000000h
	RET
LinSpaceAccess	ENDP

; LinSpaceNoAccess marks a locked high linear block as not directly accessible.
; Normally called by routines that map physical pages into the block. On entry
; EDX contains the starting high linear page # for the block. Always succeeds.
	PUBLIC	LinSpaceNoAccess
LinSpaceNoAccess	PROC	NEAR
	ASSUME	DS:MAINDAT,ES:NOTHING
	PUSH	EDX
	SHL	EDX,2
	ADD	EDX,[HighLinSpacePageTbl]
	AND	DWORD PTR ES:[EDX-8],NOT 400h
	POP	EDX
	RET
LinSpaceNoAccess	ENDP

; LinSpaceShrinkInPlace shrinks a high linear block without reallocating it. On
; entry BX contains the block handle and ECX contains the new size in pages
; (must be strictly less than the current size). Always succeeds. Since
; shrinking never requires reallocation, the block handle doesn't change.
	PUBLIC	LinSpaceShrinkInPlace
LinSpaceShrinkInPlace	PROC	NEAR
	ASSUME	DS:MAINDAT,ES:NOTHING
	PUSH	EAX
	PUSH	EBX
	PUSH	ECX
	PUSH	EDX
	PUSH	EBP
	PUSH	EDI
	MOVZX	EBX,BX
	SHL	EBX,2
	ADD	EBX,[LinBlockHandleTbl]
	MOV	EBP,[HighLinSpacePages]
	SHL	EBP,2
	ADD	EBP,[HighLinSpacePageTbl]
	PUSHFD
	CLI
	MOV	EDX,DWORD PTR ES:[EBX]
	SHL	EDX,2
	ADD	EDX,[HighLinSpacePageTbl]
	MOV	EAX,DWORD PTR ES:[EDX-8]
	SHR	EAX,0Ch
	DEC	EAX				; Block info PTE
	MOV	EDI,EAX
	SUB	EAX,ECX
	SHL	EDI,2
	ADD	EDI,EDX
	CMP	EDI,EBP
	JE	@F
	MOV	EDI,DWORD PTR ES:[EDI]
	TEST	EDI,200h
	JNZ	@F
	SHR	EDI,0Ch
	INC	EDI				; Arena header PTE
	ADD	EAX,EDI
@@:	LEA	EBX,[EDX+ECX*4]
	INC	ECX				; Block info PTE
	SHL	ECX,0Ch
	AND	DWORD PTR ES:[EDX-8],0FFFh
	OR	DWORD PTR ES:[EDX-8],ECX
	DEC	EAX				; Arena header PTE
	SHL	EAX,0Ch
	MOV	DWORD PTR ES:[EBX],EAX
	POPFD
	POP	EDI
	POP	EBP
	POP	EDX
	POP	ECX
	POP	EBX
	POP	EAX
	RET
LinSpaceShrinkInPlace	ENDP

; LinSpaceGrowInPlace attempts to grow a high linear block without reallocating
; it. On entry BX contains the block handle and ECX contains the new size in
; pages (must be strictly greater than the current size). Returns CF clear if
; successful and CF set if not. Since this routine attempts to grow the block
; without reallocation, its handle doesn't change.
	PUBLIC	LinSpaceGrowInPlace
LinSpaceGrowInPlace	PROC	NEAR
	ASSUME	DS:MAINDAT,ES:NOTHING
	PUSH	EAX
	PUSH	EBX
	PUSH	ECX
	PUSH	EDX
	PUSH	EBP
	MOVZX	EBX,BX
	SHL	EBX,2
	ADD	EBX,[LinBlockHandleTbl]
	MOV	EBP,[HighLinSpacePages]
	SHL	EBP,2
	ADD	EBP,[HighLinSpacePageTbl]
	PUSHFD
	CLI
	MOV	EDX,DWORD PTR ES:[EBX]
	SHL	EDX,2
	ADD	EDX,[HighLinSpacePageTbl]
	MOV	EAX,DWORD PTR ES:[EDX-8]
	SHR	EAX,0Ch
	DEC	EAX				; Block info PTE
	LEA	EBX,[EDX+EAX*4]
	CMP	EBX,EBP
	JE	GrowInPlaceFail
	MOV	EBX,DWORD PTR ES:[EBX]
	TEST	EBX,200h
	JNZ	GrowInPlaceFail
	SHR	EBX,0Ch
	INC	EBX				; Arena header PTE
	ADD	EBX,EAX
	SUB	EBX,ECX
	JB	GrowInPlaceFail
	JE	@F
	DEC	EBX				; Arena header PTE
	SHL	EBX,0Ch
	MOV	DWORD PTR ES:[EDX+ECX*4],EBX
@@:	INC	ECX				; Block info PTE
	SHL	ECX,0Ch
	AND	DWORD PTR ES:[EDX-8],0FFFh
	OR	DWORD PTR ES:[EDX-8],ECX
	POPFD
	POP	EBP
	POP	EDX
	POP	ECX
	POP	EBX
	POP	EAX
	RET
GrowInPlaceFail:
	POPFD
	STC
	POP	EBP
	POP	EDX
	POP	ECX
	POP	EBX
	POP	EAX
	RET
LinSpaceGrowInPlace	ENDP

; LinSpaceGrowAnywhere attempts to grow a high linear block, possibly
; reallocating it. On entry BX contains the original block handle and ECX
; contains the new size in pages (must be strictly greater than the current
; size). Returns CF clear if successful and CF set if not. If successful, BX
; contains the new handle, which may or may not be equal to the original one.
; The high word of EBX must be regarded as corrupt.
	PUBLIC	LinSpaceGrowAnywhere
LinSpaceGrowAnywhere	PROC	NEAR
	ASSUME	DS:MAINDAT,ES:NOTHING
; First try growing it in place.
	CALL	LinSpaceGrowInPlace
	JC	@F
	RET
@@:	PUSH	EAX
	PUSH	ECX
	PUSH	EDX
	PUSH	EBP
	PUSH	ESI
	PUSH	EDI
; Now try reallocating it.
	MOV	EBP,EBX
	CALL	LinSpaceAlloc
	JC	GrowAnywhereFail
	PUSH	EBX
	MOV	EBX,EBP
	CALL	LinSpaceLock
	POP	EBX
	SHL	EDX,2
	ADD	EDX,[HighLinSpacePageTbl]
	MOV	ESI,EDX
	CALL	LinSpaceLock
	SHL	EDX,2
	ADD	EDX,[HighLinSpacePageTbl]
	MOV	EDI,EDX
	MOV	ECX,DWORD PTR ES:[ESI-8]
	DEC	ECX				; Block info PTE
; Now move the PTEs. Take care to zero out the original block and to update the
; back pointers in any unlocked pages.
GrowAnywhereMovePTEsLoop:
	PUSHFD
	CLI
	LODS	DWORD PTR ES:[ESI]
	MOV	DWORD PTR ES:[ESI-4],0
	PUSH	EAX
	TEST	EAX,1				; Real present page?
	JZ	@F
	SHR	EAX,0Ch
	SUB	EAX,100h
	JC	@F
	SHL	EAX,2
	ADD	EAX,[PhysPageAllocTbl]
	CMP	DWORD PTR ES:[EAX],0FFFFFFFFh	; Locked?
	JE	@F
	AND	DWORD PTR ES:[EAX],1
	OR	DWORD PTR ES:[EAX],EDI
@@:	POP	EAX
	STOS	DWORD PTR ES:[EDI]
	POPFD
	LOOP	GrowAnywhereMovePTEsLoop
; Now finish up.
	CALL	LinSpaceUnlock
	PUSH	EBX
	MOV	EBX,EBP
	CALL	LinSpaceUnlock
	CALL	LinSpaceFree
	POP	EBX
	POP	EDI
	POP	ESI
	POP	EBP
	POP	EDX
	POP	ECX
	POP	EAX
	CLC
	RET
GrowAnywhereFail:
	MOV	EBX,EBP
	POP	EDI
	POP	ESI
	POP	EBP
	POP	EDX
	POP	ECX
	POP	EAX
	STC
	RET
LinSpaceGrowAnywhere	ENDP

MAINCOD	ENDS

MAINDAT	SEGMENT	USE32	BYTE	PUBLIC	'DATA'

	EXTRN	PDBRVAL:DWORD
	EXTRN	PhysPageAllocTbl:DWORD

	PUBLIC	HighLinSpacePages
HighLinSpacePages	DD	?
	PUBLIC	HighLinSpacePageTables
HighLinSpacePageTables	DD	?
	PUBLIC	HighLinSpacePageTbl
HighLinSpacePageTbl	DD	?
	PUBLIC	LinBlockHandles
LinBlockHandles		DW	?
	PUBLIC	LinBlockHandleTbl
LinBlockHandleTbl	DD	?

MAINDAT	ENDS

	END
