	INCLUDE	MMM386.INC
	.386P
STARTUP	SEGMENT	USE32	BYTE	PUBLIC	'CODE'
STARTUP	ENDS

MAINCOD	SEGMENT	USE32	BYTE	PUBLIC	'CODE'
	ASSUME	CS:MAINCOD,DS:NOTHING,ES:NOTHING,SS:NOTHING

	ASSUME	DS:MAINDAT,ES:NOTHING
	PUBLIC	FatalErrorStand
FatalErrorStand:
	MOV	EDI,[FatalErr_ScreenBuf]
	MOV	ESI,EDI
	MOV	EDX,OFFSET FatalErrMsg_Header
	CALL	PrintString
	MOV	EDX,[FatalErr_StandDesc]
	CALL	PrintString
	MOV	EDX,OFFSET FatalErrMsg_SysHalt
	CALL	PrintString
	JMP	FatalErrorDisplay

	ASSUME	DS:MAINDAT,ES:NOTHING
	PUBLIC	FatalErrorDump
FatalErrorDump:
	MOV	EDI,[FatalErr_ScreenBuf]
	MOV	ESI,EDI
	MOV	EDX,OFFSET FatalErrMsg_Header
	CALL	PrintString
	CMP	[FatalErr_DumpType],0
	JZ	@F
	MOV	EDX,[FatalErr_DumpFaultDesc]
	CALL	PrintString
	MOV	EDX,OFFSET FatalErrMsg_FaultCode
	CALL	PrintString
	CMP	[FatalErr_DumpType],2
	JNE	@F
	MOV	EDX,OFFSET FatalErrMsg_LinAddr
	CALL	PrintString
	MOV	EDX,CR2
	CALL	PrintHex32
	MOV	AL,0Ah
	CALL	PrintChar
@@:	CMP	[FatalErr_DumpType],0
	JNZ	@F
	MOV	EDX,OFFSET FatalErrMsg_InvReflect
	CALL	PrintString
	MOV	DL,BYTE PTR [EBP+30h]
	CALL	PrintHex8
	MOV	AL,0Ah
	CALL	PrintChar
@@:	MOV	EDX,OFFSET FatalErrMsg_OccurBeg
	CALL	PrintString
	CALL	FatalErrDump_IdentLoc
	MOV	EDX,OFFSET FatalErrMsg_OccurEnd
	CALL	PrintString
	MOV	EDX,OFFSET FatalErrMsg_Ring0RegBeg
	CALL	PrintString
	CMP	[FatalErr_DumpType],0
	JZ	@F
	MOV	EDX,OFFSET FatalErrMsg_Fault
@@:	JNZ	@F
	MOV	EDX,OFFSET FatalErrMsg_IntExcep
@@:	CALL	PrintString
	MOV	EDX,OFFSET FatalErrMsg_Ring0RegEnd
	CALL	PrintString
	TEST	DWORD PTR [EBP+3Ch],20000h	; VM
	JNZ	@F
	TEST	DWORD PTR [EBP+38h],0003h	; RPL/CPL
	JZ	FatalErrDump_Ring0
@@:	MOV	AL,0Ah
	CALL	PrintChar
	CALL	FatalErrDump_IdentLoc
	MOV	EDX,OFFSET FatalErrMsg_CliRegsHdr
	CALL	PrintString
	TEST	DWORD PTR [EBP+3Ch],20000h	; VM
	JZ	@F
	MOV	EDX,OFFSET FatalErrMsg_CliSegRegs
	CALL	PrintString
@@:	MOV	EDX,OFFSET FatalErrMsg_CliStack
	CALL	PrintString
FatalErrDump_Ring0:
	MOV	EDX,OFFSET FatalErrMsg_SysHalt
	CALL	PrintString
	JMP	FatalErrorDisplay

FatalErrDump_IdentLoc	PROC	NEAR
	ASSUME	DS:MAINDAT,ES:NOTHING
	TEST	DWORD PTR [EBP+3Ch],20000h
	JNZ	@F
	MOV	EDX,OFFSET FatalErrMsg_Ring
	CALL	PrintString
	MOV	AL,BYTE PTR [EBP+38h]
	AND	AL,03h
	ADD	AL,'0'
	CALL	PrintChar
	RET
@@:	MOV	EDX,OFFSET FatalErrMsg_V86
	CALL	PrintString
	RET
FatalErrDump_IdentLoc	ENDP

	ASSUME	DS:MAINDAT,ES:NOTHING
	PUBLIC	FatalErrorDisplay
FatalErrorDisplay:
	MOV	EDI,0B0000h
	MOV	ECX,10h
	MOV	AH,07h				; Attribute
FatalErrorDisplayLoop:
	PUSH	ECX
	MOV	ESI,[FatalErr_ScreenBuf]
	MOV	ECX,800h
@@:	LODS	BYTE PTR ES:[ESI]
	STOS	WORD PTR ES:[EDI]
	LOOP	@B
	POP	ECX
	LOOP	FatalErrorDisplayLoop
	JMP	$

PrintChar	PROC	NEAR
	ASSUME	DS:MAINDAT,ES:NOTHING
	CMP	AL,0Ah
	JE	@F
	STOS	BYTE PTR ES:[EDI]
	RET
@@:	ADD	ESI,50h
	MOV	EDI,ESI
	RET
PrintChar	ENDP

PrintNibble	PROC	NEAR
	ASSUME	DS:MAINDAT,ES:NOTHING
	ADD	AL,'0'
	CMP	AL,'9'
	JBE	@F
	ADD	AL,7
@@:	CALL	PrintChar
	RET
PrintNibble	ENDP

PrintHex8	PROC	NEAR
	ASSUME	DS:MAINDAT,ES:NOTHING
	MOV	ECX,2
@@:	ROL	DL,4
	MOV	AL,DL
	AND	AL,0Fh
	CALL	PrintNibble
	LOOP	@B
	RET
PrintHex8	ENDP

PrintHex16	PROC	NEAR
	ASSUME	DS:MAINDAT,ES:NOTHING
	MOV	ECX,4
@@:	ROL	DX,4
	MOV	AL,DL
	AND	AL,0Fh
	CALL	PrintNibble
	LOOP	@B
	RET
PrintHex16	ENDP

PrintHex32	PROC	NEAR
	ASSUME	DS:MAINDAT,ES:NOTHING
	MOV	ECX,8
@@:	ROL	EDX,4
	MOV	AL,DL
	AND	AL,0Fh
	CALL	PrintNibble
	LOOP	@B
	RET
PrintHex32	ENDP

PrintString	PROC	NEAR
	ASSUME	DS:MAINDAT,ES:NOTHING
PrintStringLoop:
	MOV	AL,BYTE PTR DS:[EDX]
	INC	EDX
	TEST	AL,AL
	JZ	PrintStringDone
	CMP	AL,'#'
	JE	PrintStringHash
	CALL	PrintChar
	JMP	PrintStringLoop
PrintStringHash:
	MOV	AH,BYTE PTR DS:[EDX]
	INC	EDX
	CMP	BYTE PTR DS:[EDX+1],'S'
	JNE	PrintStringFromStack
	MOV	AL,BYTE PTR DS:[EDX]
	ADD	EDX,2
	PUSH	EDX
	CMP	AL,'C'
	JNE	@F
	MOV	EDX,CS
@@:	CMP	AL,'S'
	JNE	@F
	MOV	EDX,SS
@@:	CMP	AL,'D'
	JNE	@F
	MOV	EDX,DS
@@:	CMP	AL,'E'
	JNE	@F
	MOV	EDX,ES
@@:	CMP	AL,'F'
	JNE	@F
	MOV	EDX,FS
@@:	CMP	AL,'G'
	JNE	@F
	MOV	EDX,GS
@@:	JMP	PrintStringNumber
PrintStringFromStack:
	CALL	ParseHexDigit
	SHL	AL,4
	MOV	BL,AL
	CALL	ParseHexDigit
	OR	BL,AL
	MOVZX	EBX,BL
	PUSH	EDX
;	MOV	EDX,DWORD PTR [EBP+EBX]
	DB	8Bh,54h,1Dh,00h
; MASM v6.00 gets hopelessly confused on the above instruction and makes EBX
; the base and EBP the index, whereas we want the opposite. Segmentation makes
; this difference crucial.
PrintStringNumber:
	CMP	AH,'L'
	JNE	@F
	CALL	PrintHex32
	ADD	DWORD PTR [ESP],4
@@:	CMP	AH,'S'
	JNE	@F
	CALL	PrintHex16
@@:	POP	EDX
	JMP	PrintStringLoop
PrintStringDone:
	RET
PrintString	ENDP

ParseHexDigit	PROC	NEAR
	ASSUME	DS:MAINDAT,ES:NOTHING
	MOV	AL,BYTE PTR DS:[EDX]
	INC	EDX
	CMP	AL,'0'
	JB	@F
	CMP	AL,'9'
	JA	@F
	SUB	AL,'0'
	RET
@@:	SUB	AL,'A'
	ADD	AL,0Ah
	RET
ParseHexDigit	ENDP

MAINCOD	ENDS

MAINDAT	SEGMENT	USE32	BYTE	PUBLIC	'DATA'

FatalErrMsg_Header	DB	'MMM386 fatal error: ',0
FatalErrMsg_SysHalt	DB	0Ah,'System halted',0Ah,0

FatalErrMsg_FaultCode	DB	0Ah,'Fault error code: #S30',0Ah,0
FatalErrMsg_LinAddr	DB	0Ah,'Offending linear address: ',0

FatalErrMsg_InvReflect	DB	'Reflectable exception or software interrupt not in V86 mode',0Ah,0Ah
			DB	'Interrupt/exception vector: ',0

FatalErrMsg_OccurBeg	DB	0Ah,'Occurred in ',0
FatalErrMsg_OccurEnd	DB	' code at:',0Ah
			DB	'CS:EIP=#S38:#L34#### EFLAGS=#L3C####',0Ah,0
FatalErrMsg_Ring	DB	'Ring ',0
FatalErrMsg_V86		DB	'V86 mode',0
FatalErrMsg_Ring0RegBeg	DB	0Ah,'Ring 0 registers on entry to the ',0
FatalErrMsg_Ring0RegEnd	DB	' handler:',0Ah
			DB	'EAX=#L2C#### EBX=#L20#### ECX=#L28#### EDX=#L24#### ESI=#L14#### EDI=#L10####',0Ah
			DB	'DS=#S0C ES=#S08 FS=#S04 GS=#S00 SS:ESP=#SSS:#L1C#### EBP=#L18####',0Ah,0
FatalErrMsg_Fault	DB	'fault',0
FatalErrMsg_IntExcep	DB	'interrupt/exception reflection',0
FatalErrMsg_CliRegsHdr	DB	' registers:',0Ah,0
FatalErrMsg_CliSegRegs	DB	'DS=#S4C ES=#S48 FS=#S50 GS=#S54 ',0
FatalErrMsg_CliStack	DB	'SS:ESP=#S44:#L40####',0Ah,0

	PUBLIC	FatalErr_StandDesc
FatalErr_StandDesc	DD	?
	PUBLIC	FatalErr_DumpType
FatalErr_DumpType	DB	?
	PUBLIC	FatalErr_DumpFaultDesc
FatalErr_DumpFaultDesc	DD	?

	PUBLIC	FatalErr_ScreenBuf
FatalErr_ScreenBuf	DD	?

MAINDAT	ENDS

	END
