	INCLUDE	MMM386.INC
	.386P
RCODE	SEGMENT	USE16	PARA	PUBLIC	'CODE'
	ASSUME	CS:RCODE,DS:NOTHING,ES:NOTHING,SS:NOTHING
MMMNEXT	DD	-1
MMMDATR	DW	8000H
	DW	OFFSET STRAT
	DW	OFFSET INTR
MMMSIGN	DB	'EMMXXXX0'
	ARPL	AX,AX
	DB	'MODULAR MEMORY MANAGER 386'
	DW	MMM386_Ver

STRAT	LABEL	FAR
	MOV	WORD PTR CS:[RH_PNTR],BX
	MOV	WORD PTR CS:[RH_PNTR+2],ES
	RETF
INTR	LABEL	FAR
	PUSH	BX
	PUSH	ES
	PUSHF
	LES	BX,CS:[RH_PNTR]
	MOV	WORD PTR ES:[BX+3],100H
	CMP	BYTE PTR ES:[BX+2],0
	JNZ	@F
	CALL	INIDRV
@@:	CMP	BYTE PTR ES:[BX+2],3
	JNE	@F
	CALL	IOCTLI
@@:	POPF
	POP	ES
	POP	BX
	RETF
RH_PNTR	DD	?

;DOSDISP	PROC	NEAR	; TEMP WHOLE PROC
;	PUSH	CX
;	PUSH	DX
;	MOV	CX,4
;TEMPLR:	ROL	AX,4
;	MOV	DL,AL
;	AND	DL,0FH
;	ADD	DL,30H
;	CMP	DL,39H
;	JBE	@F
;	ADD	DL,7
;@@:	MOV	FS:[DI],DL
;	ADD	DI,2
;	LOOP	TEMPLR
;	POP	DX
;	POP	CX
;	RET
;DOSDISP	ENDP

HOOK67:	STI
	CMP	AH,0DEH
	JE	H67EMS
	CMP	AH,0E0H
	JNE	@F
	XOR	AX,AX
	MOV	BL,8EH
	IRET
@@:	CMP	AH,0E1H
	JAE	H67EMS
	CMP	AH,87H
	JE	H67STC
	CMP	AH,89H
	JE	H67STC
	CMP	AH,40H
	JB	@F
	CMP	AH,5DH
	JA	@F
	JMP	H67EMS
@@:	MOV	AH,84H
	IRET
H67EMS:	MOV	AH,80H
	IRET
H67STC:	PUSH	BP
	MOV	BP,SP
	OR	WORD PTR [BP+6],1
	POP	BP
	IRET

HOOK15:	STI
	CMP	AH,87H
	JNE	@F
	INT	67H
	JC	H15NXT
	RETF	2
@@:	CMP	AH,88H
	JNE	@F
	XOR	AX,AX
	RETF	2
@@:	CMP	AH,89H
	JNE	H15NXT
	INT	67H
	JC	H15NXT
	MOV	AX,0FFFFH
	STC
	RETF	2
H15NXT:	CLI
	JMP	CS:[SVADR15]
SVADR15	DD	?

HOOK2F:	STI
	CMP	AH,43H
	JNE	HOOK2F_Check1605
	TEST	AL,AL
	JNZ	@F
	MOV	AL,80H
	IRET
@@:	CMP	AL,10H
	JNE	@F
	MOV	BX,CS
	MOV	ES,BX
	LEA	BX,[H2FXMSE]
@@:	IRET
HOOK2F_Next:
	CLI
	JMP	CS:[SVADR2F]
SVADR2F	DD	?
H2FXMSE	LABEL	FAR
	JMP	SHORT	@F
	NOP
	NOP
	NOP
@@:	MOV	AL,AH
	MOV	AH,0E0H
	INT	67H
	RETF

HOOK2F_Check1605:
	CMP	AX,1605H
	JNE	HOOK2F_Check1606
	TEST	DX,1
	JNZ	HOOK2F_DOSX
	PUSHF
	CLI
	CALL	CS:[SVADR2F]
	TEST	CX,CX
	JNZ	HOOK2F_IRET
	CMP	DI,30AH
	JAE	@F
	PUSH	DX
	MOV	DX,OFFSET Win386_NeedAtLeast310_Msg
HOOK2F_Error:
	PUSH	AX
	MOV	AX,CS
	MOV	DS,AX
	MOV	AH,9
	INT	21H
	MOV	CX,1
	POP	AX
	POP	DX
	IRET
@@:
; Since we are in charge of the execution environment, we can treat DS:SI here
; as totally ours and set it without even checking.
	MOV	SI,CS
	MOV	DS,SI
	LEA	SI,[WSWITCH]
	PUSH	AX
	PUSH	ECX
	PUSH	EDX
	MOV	AH,0E7h
	INT	67h
	JNC	@F
	POP	EDX
	POP	ECX
	POP	AX
	PUSH	DX
	MOV	DX,OFFSET Win386_CantLockAll_Msg
	JMP	HOOK2F_Error
@@:	MOV	AH,0E4h
	MOV	ECX,MMM386_MaxPagesNeededForImportStruc
	INT	67H
	JNC	@F
	POP	EDX
	POP	ECX
	POP	AX
	PUSH	DX
	MOV	DX,OFFSET Win386_NoMemForImp_Msg
	JMP	HOOK2F_Error
@@:	ADD	EDX,100h
	SHL	EDX,0Ch
	MOV	[WIMPADR],EDX
	POP	EDX
	POP	ECX
	POP	AX
	MOV	[Win386_Mode_Active],1
	OR	[MMMDATR],4000H
HOOK2F_IRET:
	IRET

; The following stuff is for DOSX v3.10. Without this check it would hang if
; run under MMM386. The hang is caused by the same familiar bug with trash in
; the high word of ESP that all VCPI-capable versions of Murray Sargent's DOS
; extender suffer from. The MOV DWORD PTR [ESP+8],23002h instruction in the
; client-to-server environment switch function causes a stack fault, but since
; the fault handler also needs to look at the stack using similar instructions,
; it faults again, with the result being an endless loop (i.e. hang) instead of
; the informative fault error message. The CPU doesn't signal a double or
; triple fault since from its viewpoint the stack is OK (the extender obviously
; sets B=0 and the 16-bit SP is correct), and the actual exceptions process
; correctly. During the hang SP is endlessly circling around the extender's
; 64KB stack segment.
;
; If this bug were the only problem, we would do a run-time patch here (it's
; absolutely trivial). The real problem is that DOSX v3.10's design inherently
; requires the PICs to be mapped at 08 & 70 while the DPMI client is running,
; and thus requires the VCPI server not to remap them. (Note that DOSX simply
; assumes this without checking!)
;
; The VCPI-capable versions of the original pre-DPMI Ring 0 extender (like the
; one in CV) have a similar restriction, but for a different reason. Those DO
; want the PICs to be remapped, but insist on doing the remapping themselves
; and don't accept the server's remapping. This problem is not really inherent,
; and I've been able to fix it in the CV version by some creative patching.
;
; Unfortunately, the problem in DOSX v3.10 IS inherent, and no patching will
; help. Sure, you could completely reverse-engineer it and construct a new
; version with a different design that doesn't exhibit this problem, but then
; it would no longer be DOSX v3.10, and you might as well throw DOSX out
; altogether and replace it with a real DPMI host.
;
; Anyway, back to DOSX v3.10 and MMM386. The two are incompatible, and we stop
; the culprit from loading and issue an error message in reaction to its init
; broadcast.
HOOK2F_DOSX:
	PUSHF
	CLI
	CALL	CS:[SVADR2F]
	TEST	CX,CX
	JNZ	HOOK2F_IRET
; Do this for v3.10 ONLY. Sure, earlier versions don't support VCPI at all, but
; that's normal behavior and doesn't require special intervention from us. Also
; let's give Microsoft the benefit of the doubt and trust them that if they
; ever decide to make DOSX v3.11 or v4.00 or whatever, they'll do it right.
	CMP	DI,30AH
	JNE	HOOK2F_IRET
	PUSH	DX
	LEA	DX,[Ugly_DOSX31_Msg]
	JMP	HOOK2F_Error

HOOK2F_Check1606:
	CMP	AX,1606H
	JNE	HOOK2F_Next
	TEST	DX,1
	JNZ	HOOK2F_Next
	CMP	CS:[Win386_Mode_Active],0
	JZ	HOOK2F_Next
	AND	CS:[MMMDATR],0BFFFH
	MOV	CS:[Win386_Mode_Active],0
	PUSH	AX
	PUSH	ECX
	PUSH	EDX
	MOV	AH,0E5h
	MOV	ECX,MMM386_MaxPagesNeededForImportStruc
	MOV	EDX,CS:[WIMPADR]
	SHR	EDX,0Ch
	SUB	EDX,100h
	INT	67H
	MOV	AH,0E8h
	INT	67h
	POP	EDX
	POP	ECX
	POP	AX
	JMP	HOOK2F_Next

Win386_Mode_Active	DB	0
Win386_NeedAtLeast310_Msg	DB	'MMM386 is not compatible with Win386 versions earlier than 3.10',0DH,0AH,'$'
Win386_CantLockAll_Msg		DB	'MMM386: Unable to physically lock all XMS EMBs as required to run Win386',0DH,0AH,'$'
Win386_NoMemForImp_Msg		DB	'MMM386: Not enough contiguous extended memory for the Paging Import structure',0DH,0AH
				DB	'required to run Win386',0DH,0AH,'$'
Ugly_DOSX31_Msg			DB	'Microsoft 286 DOS extender (DOSX) assumes that the VCPI server does not remap',0Dh,0Ah
				DB	'hardware interrupts and therefore cannot be run under MMM386 or any other',0Dh,0Ah
				DB	'memory manager that does.',0Dh,0Ah,'$'
WIMPADR	DD	?
	DB	1,0BH

IOCTLI:	PUSH	CX
	MOV	CX,ES:[BX+12H]
	CMP	CX,6
	JB	IOIERR
	PUSH	DI
	PUSH	ES
	LES	DI,ES:[BX+0EH]
	CMP	BYTE PTR ES:[DI],1
	JE	@F
	POP	ES
	POP	DI
	JMP	IOIERR
@@:	PUSH	SI
	PUSH	DS
	MOV	SI,CS
	MOV	DS,SI
	LEA	SI,[WIMPADR]
	MOV	CX,3
	REP	MOVSW
	POP	DS
	POP	SI
	POP	ES
	POP	DI
	MOV	WORD PTR ES:[BX+12H],6
IOIRET:	POP	CX
	RETN
IOIERR:	MOV	WORD PTR ES:[BX+12H],0
	JMP	IOIRET

WSWITCH	LABEL	FAR
	TEST	AX,AX
	JNZ	WSBACK
	MOV	CS:[MMMSIGN],'$'
	PUSH	EAX
	PUSH	EDI
	MOV	AH,0EAH
	MOV	EDI,CS:[WIMPADR]
	INT	67H
	POP	EDI
	PUSH	EBP
	PUSH	ESI
	PUSH	DS
	PUSH	ES
	PUSH	FS
	PUSH	GS
	PUSH	SS
	MOV	AX,CS
	MOVZX	EAX,AX
	SHL	EAX,4
	MOV	EBP,OFFSET WSWITCH_SAVEGDT
	ADD	EBP,EAX
	MOV	ESI,OFFSET WSWITCH_RESUME
	ADD	ESI,EAX
	MOV	AH,0E9H
	SUB	SP,10h
	INT	67H
	ADD	SP,10h
	POP	SS
	POP	GS
	POP	FS
	POP	ES
	POP	DS
	POP	ESI
	POP	EBP
	POP	EAX
	RETF
WSBACK:	PUSH	EAX
	PUSH	EBP
	MOV	EBP,ESP
	XOR	AX,AX
	PUSH	AX
	PUSH	GS
	PUSH	AX
	PUSH	FS
	PUSH	AX
	PUSH	DS
	PUSH	AX
	PUSH	ES
	PUSH	AX
	PUSH	SS
	PUSH	EBP
	PUSH	AX
	PUSH	AX
	PUSH	AX
	PUSH	CS
	PUSH	AX
	PUSH	OFFSET WSBRET
	DB	66h
	LGDT	CS:[WSWITCH_SAVEGDT]
	SMSW	AX
	OR	AX,0001h
	LMSW	AX
	DB	0EAh
WSWITCH_RESUME	DD	?
WSBRET:	MOV	CS:[MMMSIGN],'E'
	POP	EBP
	POP	EAX
	RETF

WSWITCH_SAVEGDT	DF	?

START:	MOV	AX,ES
	MOV	BX,ZSEG
	SUB	BX,AX
	MOV	AH,4AH
	INT	21H
	MOV	SI,81H
CLPENT:	MOV	AX,RDATA
	MOV	ES,AX
	ASSUME	ES:RDATA
	MOV	AX,3000H
	INT	21H
	CMP	AL,3
	JAE	@F
	LEA	DX,[EDVMSG]
	JMP	RETERR
@@:	XCHG	AL,AH
	MOV	WORD PTR ES:[OSMINOR],AX
	PUSH	DS
	PUSH	ES
	POP	DS
	LEA	DX,[PROMSG]
	MOV	AH,9
	INT	21H
	POP	DS
	LEA	DX,[ECLMSG]
CLPCYC:	LODSB
	CMP	AL,9
	JE	CLPCYC
	CMP	AL,20H
	JE	CLPCYC
	CMP	AL,0DH
	JE	CLPEND
	CMP	AL,0AH
	JE	CLPEND
	CMP	AL,2FH
	JNE	RETERR
	LODSB
	AND	AL,11011111B
	CMP	AL,'U'
	JNE	@F
	MOV	ES:[UMBFLAG],1
	JMP	CLPCYC
@@:	CMP	AL,'H'
	JNE	NHMASW
	LODSB
	CMP	AL,3AH
	JNE	RETERR
	CALL	ParseDecNumber
	JC	RETERR
	TEST	BX,BX
	JZ	@F
	LEA	DX,[EHMMSG]
	JMP	RETERR
@@:	CMP	CX,40h
	JB	@F
	LEA	DX,[EHMMSG]
	JMP	RETERR
@@:	MOV	ES:[HMAMIN],CL
	JMP	CLPCYC
NHMASW:	CMP	AL,'S'
	JNE	NSTKSW
	LODSB
	CMP	AL,3AH
	JNE	RETERR
	CALL	ParseDecNumber
	JC	RETERR
	TEST	CX,0003h
	JZ	@F
	LEA	DX,[ESAMSG]
	JMP	RETERR
@@:	TEST	BX,BX
	JZ	@F
	LEA	DX,[ESBMSG]
	JMP	RETERR
@@:	CMP	CX,8000h
	JBE	@F
	LEA	DX,[ESBMSG]
	JMP	RETERR
@@:	CMP	CX,800h
	JAE	@F
	LEA	DX,[ESSMSG]
	JMP	RETERR
@@:	MOV	ES:[STACKSZ],CX
	JMP	CLPCYC
NSTKSW:	CMP	AL,'P'
	JNE	NPAGSW
	LODSB
	CMP	AL,3AH
	JNE	RETERR
	CALL	ParseDecNumber
	JC	RETERR
	CMP	BX,7
	JB	PGSWOK
	JE	@F
	LEA	DX,[EPBMSG]
	JMP	RETERR
@@:	CMP	CX,0FEDEh
	JBE	PGSWOK
	LEA	DX,[EPBMSG]
	JMP	RETERR
PGSWOK:	MOV	WORD PTR ES:[PHYSPAG],CX
	MOV	WORD PTR ES:[PHYSPAG+2],BX
	JMP	CLPCYC
NPAGSW:	CMP	AL,'A'
	JNE	NADRSW
	LODSB
	CMP	AL,3AH
	JNE	RETERR
	CALL	ParseDecNumber
	JC	RETERR
	TEST	BX,BX
	JE	@F
	LEA	DX,[EABMSG]
	JMP	RETERR
@@:	CMP	CX,0200h
	JBE	@F
	LEA	DX,[EABMSG]
	JMP	RETERR
@@:	TEST	CX,CX
	JNZ	@F
	LEA	DX,[EASMSG]
	JMP	RETERR
@@:	MOV	ES:[ADDRSPC],CX
	JMP	CLPCYC
NADRSW:	CMP	AL,'B'
	JNE	NBLKSW
	LODSB
	CMP	AL,3AH
	JNE	RETERR
	CALL	ParseDecNumber
	JC	RETERR
	TEST	BX,BX
	JE	@F
	LEA	DX,[EBBMSG]
	JMP	RETERR
@@:	CMP	CX,8000h
	JBE	@F
	LEA	DX,[EBBMSG]
	JMP	RETERR
@@:	CMP	CX,100h
	JAE	@F
	LEA	DX,[EBSMSG]
	JMP	RETERR
@@:	MOV	ES:[LINBLKS],CX
	JMP	CLPCYC
NBLKSW:	CMP	AL,'X'
	JNE	NXMSSW
	LODSB
	CMP	AL,3AH
	JNE	RETERR
	CALL	ParseDecNumber
	JC	RETERR
	TEST	BX,BX
	JZ	@F
	LEA	DX,[EXBMSG]
	JMP	RETERR
@@:	TEST	CH,CH
	JZ	@F
	LEA	DX,[EXBMSG]
	JMP	RETERR
@@:	CMP	CL,20h
	JAE	@F
	LEA	DX,[EXSMSG]
	JMP	RETERR
@@:	MOV	ES:[XMSBLKS],CL
	JMP	CLPCYC
NXMSSW:	CMP	AL,'F'
	JNE	NFRMSW
	LODSB
	CMP	AL,3AH
	JNE	RETERR
	XOR	DI,DI
	MOV	BP,4
FRMSWC:	LODSB
	CMP	AL,30H
	JB	RETERR
	CMP	AL,39H
	JA	@F
	SUB	AL,30H
	JMP	FRMSWA
@@:	AND	AL,11011111B
	SUB	AL,41H
	JC	RETERR
	CMP	AL,5
	JA	RETERR
	ADD	AL,0AH
FRMSWA:	SHL	DI,4
	CBW
	ADD	DI,AX
	DEC	BP
	JNZ	FRMSWC
	CMP	DI,0C000H
	JNB	@F
	LEA	DX,[EFLMSG]
	JMP	RETERR
@@:	CMP	DI,0E000H
	JNA	@F
	LEA	DX,[EFHMSG]
	JMP	RETERR
@@:	TEST	DI,3FFH
	JZ	@F
	LEA	DX,[EFNMSG]
	JMP	RETERR
@@:	MOV	ES:[EMSFRAM],DI
	JMP	CLPCYC
NFRMSW:	CMP	AL,'N'
	JNE	@F
	MOV	ES:[NOFRAME],1
	JMP	CLPCYC
@@:	CMP	AL,'V'
	JNE	RETERR
	MOV	ES:[CHECKPH],0
	JMP	CLPCYC
CLPEND:	MOV	AX,ES
	MOV	DS,AX
	ASSUME	DS:RDATA
	PUSH	SP
	POP	AX
	CMP	AX,SP
	LEA	DX,[ECPMSG]
	JNE	RETERR
	SIDT	[CPUCHKB]
	CMP	BYTE PTR [CPUCHKB+5],0
	JNZ	RETERR
	MOV	AX,4300H
	PUSH	DS
	PUSH	ES
	INT	2FH
	POP	ES
	POP	DS
	CMP	AL,80H
	LEA	DX,[EXPMSG]
	JE	RETERR
	MOV	AX,3567H
	PUSH	ES
	INT	21H
	LEA	SI,[EMMSIGN]
	MOV	DI,0AH
	MOV	CX,4
	CLD
	REPE	CMPSW
	POP	ES
	LEA	DX,[EEPMSG]
	JE	RETERR
	SMSW	AX
	TEST	AX,1
	LEA	DX,[EPMMSG]
	JNZ	RETERR
	LEA	DI,[UMBLIST]
	MOV	SI,0C000H
	XOR	BP,BP
UMBCYC:	CMP	SI,0F000H
	JAE	UMBDON
	PUSH	DS
	MOV	DS,SI
	CMP	WORD PTR DS:[0],0AA55H
	MOV	AL,DS:[2]
	POP	DS
	JE	NOUMB
	ADD	BP,80H
	CMP	BP,SI
	JNE	@F
	INC	BYTE PTR [DI-1]
	ADD	SI,80H
	JMP	UMBCYC
@@:	MOV	BP,SI
	MOV	AX,SI
	STOSW
	MOV	AL,1
	STOSB
	ADD	SI,80H
	JMP	UMBCYC
NOUMB:	XOR	AH,AH
	ADD	AX,3
	SHR	AX,2
	SHL	AX,7
	ADD	SI,AX
	JNC	UMBCYC
UMBDON:	XOR	AX,AX
	STOSW
	LEA	DI,[UMBLIST]
TRCCYC:	MOV	AX,[DI]
	TEST	AX,AX
	JZ	TRCDON
	TEST	AX,80H
	JZ	@F
	ADD	WORD PTR [DI],80H
	DEC	BYTE PTR [DI+2]
@@:	SHR	BYTE PTR [DI+2],1
	MOV	AL,[DI+2]
	XOR	AH,AH
	ADD	[TOTLUMB],AX
	TEST	AL,AL
	JNZ	NONULL
	MOV	SI,DI
	ADD	SI,3
	PUSH	DI
@@:	LODSW
	STOSW
	TEST	AX,AX
	JZ	@F
	MOVSB
	JMP	@B
@@:	POP	DI
	SUB	DI,3
NONULL:	ADD	DI,3
	JMP	TRCCYC
TRCDON:	CMP	[NOFRAME],0
	JNZ	EMSDON
	CMP	[EMSFRAM],0
	JNZ	AUEMSF
	LEA	SI,[UMBLIST]
NSCCYC:	LODSW
	TEST	AX,AX
	LEA	DX,[ENFMSG]
	JZ	RETERR
	MOV	DX,AX
	AND	AX,0300H
	TEST	AX,AX
	JZ	@F
	MOV	AL,AH
	MOV	AH,4
	SUB	AH,AL
	AND	DX,0FC00H
	ADD	DX,0400H
@@:	LODSB
	SUB	AL,AH
	JC	NSCCYC
	CMP	AL,10H
	JB	NSCCYC
	MOV	[EMSFRAM],DX
AUEMSF:	MOV	BP,[EMSFRAM]
	LEA	SI,[UMBLIST]
FSCCYC:	LODSW
	TEST	AX,AX
	JZ	EMSFAS
	MOV	DX,AX
	LODSB
	MOV	BX,BP
	SUB	BX,DX
	JC	EMSFAS
	MOV	BL,BH
	ADD	BH,10H
	SUB	AL,BH
	JC	FSCCYC
	SUB	[TOTLUMB],10H
	XOR	DL,DL
	TEST	BL,BL
	JZ	@F
	OR	DL,1
@@:	TEST	AL,AL
	JZ	@F
	OR	DL,2
@@:	TEST	DL,DL
	JNZ	NPGFR0
	MOV	DI,SI
	SUB	DI,3
@@:	LODSW
	STOSW
	TEST	AX,AX
	JZ	@F
	MOVSB
	JMP	@B
@@:	JMP	EMSDON
NPGFR0:	CMP	DL,1
	JNE	NPGFR1
	MOV	[SI-1],BL
	JMP	EMSDON
NPGFR1:	CMP	DL,2
	JNE	NPGFR2
	ADD	WORD PTR [SI-3],1000H
	MOV	[SI-1],AL
	JMP	EMSDON
NPGFR2:	MOV	DX,SI
@@:	CMP	WORD PTR [SI],0
	JZ	@F
	ADD	SI,3
	JMP	@B
@@:	INC	SI
	MOV	DI,SI
	ADD	DI,3
	MOV	CX,SI
	INC	CX
	SUB	CX,DX
	STD
	REP	MOVSB
	CLD
	MOV	[SI],BL
	MOV	BH,AL
	MOV	AX,[SI-2]
	ADD	AH,BL
	ADD	AH,10H
	MOV	[SI+1],AX
	MOV	[SI+3],BH
	JMP	EMSDON
EMSFAS:	LEA	DX,[EPFMSG]
	JMP	RETERR
EMSDON:

; Now it's time for real business. First figure out how much memory do we have
; and how much of it do we need for various overhead. Use INT 15/AH=88 to
; figure out the extended memory size and convert it to pages. The user can
; force the physical page count to any value with the /P switch. This is so
; that we can support memory not reported by INT 15/AH=88, usually above 64 MB.
; True, we could implement EISA memory configuration like HIMEM does, but:
; (a) It's a pita.
; (b) The documentation is scarce and reverse-engineering HIMEM is far from the
;     top of my to-do list.
; (c) Although one would think that everyone wants to be compatible with HIMEM
;     and would gladly support the EISA mechanism, the architecture of these
;     crazy Pentiums with infinite RAM is definitely not EISA, and aside from
;     the speculation about HIMEM compatibility, I don't have any hard evidence
;     that these critters actually support the EISA mechanism.
; For these reasons I have decided not to waste my valuable time on
; implementing the EISA mechanism. If you have more than 64 MB of RAM, use the
; /P switch.
; When this switch is specified, the INT 15/AH=88 call is bypassed.

	CMP	[PHYSPAG],0
	JNZ	@F
	MOV	AH,88H
	INT	15H
	LEA	DX,[EIMMSG]
	JC	RETERR
	SHR	AX,2				; We can only deal with pages
	MOV	WORD PTR [PHYSPAG],AX
@@:
; Now provide the default for the high linear address space size, if not set by
; the user.
	CMP	[ADDRSPC],0
	JNZ	HighLinSpaceSizeAlreadySet
	MOV	EAX,[PHYSPAG]
	SHL	EAX,2				; default = 4 * physical memory
	ADD	EAX,3FFh			; We need complete page tables
	SHR	EAX,0Ah
	CMP	EAX,200h			; Can't be more than 2 GB
	JBE	@F
	MOV	EAX,200h
@@:	MOV	[ADDRSPC],AX
HighLinSpaceSizeAlreadySet:
	MOV	AX,MAINDAT
	MOV	ES,AX
	ASSUME	ES:MAINDAT
	MOV	EAX,[PHYSPAG]
	MOV	ES:[TotalPhysMemPages],EAX
	ADD	EAX,22H				; For INT 15/AH=87 handling
	MOV	ES:[LowLinSpacePTEsNeeded],EAX
	MOV	EDI,OFFSET MAINCOD_END
	ADD	EDI,OFFSET MAINDAT_END
	ADD	EDI,800h			; Fatal error screen buffer
	MOVZX	EBX,[STACKSZ]
	MOV	ES:[Ring0StackSize],EBX
	ADD	EDI,EBX
; Now account for the physical page alloc table
	SHL	EAX,2
	ADD	EDI,EAX
; Now the linear address space block handle table
	MOVZX	EAX,[LINBLKS]
	MOV	ES:[LinBlockHandles],AX
	SHL	EAX,2				; Each entry is a DWORD
	ADD	EDI,EAX
; Now the XMS EMB handle table
	MOVZX	EAX,[XMSBLKS]
	MOV	ES:[XMSEMB_Handles],AL
	SHL	EAX,2				; Each entry is 3 DWORDs
	ADD	EDI,EAX
	SHL	EAX,1
	ADD	EDI,EAX
; That's it for now. Convert it to pages.
	ADD	EDI,0FFFh
	SHR	EDI,0Ch
; Now add the full-page overhead.
	ADD	EDI,10h+1			; HMA and page directory
; Now the low linear space page tables
	MOV	EAX,ES:[LowLinSpacePTEsNeeded]
	ADD	EAX,100h+3FFh			; 100 1st MB + 3FF to round up
	SHR	EAX,0Ah
	ADD	EDI,EAX
; Now the high linear space page tables
	MOVZX	EAX,[ADDRSPC]
	MOV	ES:[HighLinSpacePageTables],EAX
	ADD	EDI,EAX
	CMP	[UMBFLAG],0			; Now the UMBs
	JZ	@F
	MOVZX	EAX,[TOTLUMB]
	ADD	EDI,EAX
@@:	MOV	ES:[SystemReservedPages],EDI
; Now the ultimate comparison. We need at least one page left free.
	LEA	DX,[EIMMSG]
	CMP	EDI,ES:[TotalPhysMemPages]
	JAE	RETERR
; Copy some vars into place
	MOV	AL,[HMAMIN]
	MOV	ES:[XMS_HMAMIN],AL
	MOV	AL,[UMBFLAG]
	MOV	ES:[XMS_DoUMB],AL
	MOV	AL,[CHECKPH]
	MOV	ES:[Hide_VCPI_From_Ugly_Phar_Lap],AL
	CMP	[NOFRAME],0
	JNZ	@F
	MOV	AX,[EMSFRAM]
	MOV	ES:[EMS_PageFrameSeg],AX
@@:

; Now we are ready to switch to protected mode! Fasten your seat belts!

	MOV	AX,STARTUP
	MOV	DL,AH
	SHL	AX,4
	SHR	DL,4
	MOV	WORD PTR ES:[BSSTART],AX
	MOV	ES:[BSSTART+2],DL
	MOV	AX,RSTACK
	MOV	DL,AH
	SHL	AX,4
	SHR	DL,4
	MOV	WORD PTR ES:[BSSTACK],AX
	MOV	ES:[BSSTACK+2],DL
	MOV	AX,MAINDAT
	MOV	DL,AH
	SHL	AX,4
	SHR	DL,4
	MOV	WORD PTR ES:[BSMAIND],AX
	MOV	ES:[BSMAIND+2],DL
	ADD	AX,OFFSET GDT
	ADC	DL,0
	MOV	ES:[BASEGDT],AX
	MOV	BYTE PTR ES:[BASEGDT+2],DL
	CLI
	CALL	ENABA20
	JC	@F
	DB	66h
	LGDT	FWORD PTR ES:[DESCGDT]
	SMSW	AX
	OR	AX,1
	LMSW	AX
	DB	0EAH
	DW	OFFSET PMINIT,50H
@@:	STI
	LEA	DX,[EENMSG]
; Fall through

	ASSUME	DS:NOTHING,ES:NOTHING
RETERR:	MOV	AX,RDATA
	MOV	DS,AX
	ASSUME	DS:RDATA
	MOV	AH,9
	INT	21H
	CMP	[SYSDRV],0
	JZ	@F
	XOR	DX,DX
	JMP	DRVRET
@@:	MOV	AX,4C01H
	INT	21H

	ASSUME	DS:RDATA,ES:RDATA
VMINIT:	MOV	AX,CS
	MOV	DS,AX
	ASSUME	DS:RCODE
	LEA	DX,[HOOK67]
	MOV	AX,2567H
	INT	21H
	MOV	AX,3515H
	INT	21H
	MOV	WORD PTR [SVADR15],BX
	MOV	WORD PTR [SVADR15+2],ES
	LEA	DX,[HOOK15]
	MOV	AX,2515H
	INT	21H
	MOV	AX,352FH
	INT	21H
	MOV	WORD PTR [SVADR2F],BX
	MOV	WORD PTR [SVADR2F+2],ES
	LEA	DX,[HOOK2F]
	MOV	AX,252FH
	INT	21H
	MOV	AX,RDATA
	MOV	DS,AX
	ASSUME	DS:RDATA
	CMP	[SYSDRV],0
	JNZ	NODOSP
	MOV	AH,52H
	INT	21H
	ADD	BX,22H
	CMP	WORD PTR [OSMINOR],300H
	JNE	@F
	ADD	BX,6
@@:	MOV	AX,ES:[BX]
	MOV	WORD PTR CS:[MMMNEXT],AX
	MOV	AX,ES:[BX+2]
	MOV	WORD PTR CS:[MMMNEXT+2],AX
	CLI
	MOV	WORD PTR ES:[BX],OFFSET MMMNEXT
	MOV	WORD PTR ES:[BX+2],SEG MMMNEXT
	STI
NODOSP:	LEA	DX,[INSMSG]
	MOV	AH,9
	INT	21H
	LEA	DX,[START]
	CMP	[SYSDRV],0
	JNZ	DRVRET
	ADD	DX,0FH
	SHR	DX,4
	ADD	DX,10H
	MOV	AX,3100H
	INT	21H

	ASSUME	DS:NOTHING,ES:NOTHING
INIDRV:	PUSH	AX
	PUSH	DS
	MOV	AX,RDATA
	MOV	DS,AX
	ASSUME	DS:RDATA
	MOV	[SYSDRV],1
	MOV	WORD PTR [KEEP_SP],SP
	MOV	WORD PTR [KEEP_SP+2],SS
	MOV	AX,RSTACK
	MOV	SS,AX
	MOV	SP,1000H
	PUSH	CX
	PUSH	DX
	PUSH	BP
	PUSH	SI
	PUSH	DI
	PUSH	BX
	PUSH	ES
	LES	DI,ES:[BX+12H]
	MOV	AL,20H
	MOV	CX,0FFFFH
	CLD
	REPNE	SCASB
	MOV	AX,ES
	MOV	DS,AX
	ASSUME	DS:NOTHING
	MOV	SI,DI
	JMP	CLPENT

	ASSUME	DS:RDATA,ES:NOTHING
DRVRET:	POP	ES
	POP	BX
	MOV	ES:[BX+0EH],DX
	MOV	ES:[BX+10H],CS
	POP	DI
	POP	SI
	POP	BP
	POP	DX
	POP	CX
	MOV	SS,WORD PTR [KEEP_SP+2]
	MOV	SP,WORD PTR [KEEP_SP]
	POP	DS
	ASSUME	DS:NOTHING
	POP	AX
	RETN

ParseDecNumber	PROC	NEAR
	ASSUME	DS:NOTHING,ES:NOTHING
	XOR	BX,BX
	XOR	CX,CX
	MOV	DI,SI
	XOR	AH,AH
	MOV	BP,0Ah
@@:	LODS	BYTE PTR DS:[SI]
	SUB	AL,'0'
	JC	@F
	CMP	AL,9
	JA	@F
	PUSH	AX
	MOV	AX,BX
	MUL	BP
	MOV	BX,AX
	POP	AX
	TEST	DX,DX
	JNZ	ParseDecNumberTooBig
	PUSH	AX
	MOV	AX,CX
	MUL	BP
	MOV	CX,AX
	POP	AX
	ADD	BX,DX
	JC	ParseDecNumberTooBig
	ADD	CX,AX
	ADC	BX,0
	JC	ParseDecNumberTooBig
	JMP	@B
@@:	DEC	SI
	CMP	SI,DI
	JNE	ParseDecNumberRet
	STC
	JMP	ParseDecNumberRet
ParseDecNumberTooBig:
	MOV	BX,0FFFFh
	MOV	CX,0FFFFh
	CLC
ParseDecNumberRet:
	RET
ParseDecNumber	ENDP

	ASSUME	DS:NOTHING,ES:NOTHING
ENABA20	PROC	NEAR
	PUSH	AX
	CALL	SYN8042
	STC
	JNZ	@F
	MOV	AL,0D1H
	OUT	64H,AL
	CALL	SYN8042
	STC
	JNZ	@F
	MOV	AL,0DFH
	OUT	60H,AL
	CALL	SYN8042
	STC
	JNZ	@F
	MOV	AL,0FFH
	OUT	64H,AL
	CALL	SYN8042
	STC
	JNZ	@F
	CLC
@@:	POP	AX
	RET
ENABA20	ENDP
SYN8042	PROC	NEAR
	XOR	CX,CX
@@:	JMP	SHORT	$+2
	JMP	SHORT	$+2
	IN	AL,64H
	AND	AL,2
	LOOPNZ	@B
	JNZ	@F
	RET
@@:	JMP	SHORT	$+2
	JMP	SHORT	$+2
	IN	AL,64H
	AND	AL,2
	LOOPNZ	@B
	RET
SYN8042	ENDP

RCODE	ENDS

RDATA	SEGMENT	USE16	PARA	PUBLIC	'DATA'
UMBFLAG	DB	0
HMAMIN	DB	0
STACKSZ	DW	2000h
PHYSPAG	DD	0
ADDRSPC	DW	0
LINBLKS	DW	400h
XMSBLKS	DB	40h
EMSFRAM	DW	0
NOFRAME	DB	0
CHECKPH	DB	1
CPUCHKB	DF	?
UMBLIST	DB	48*3+2 DUP(?)
TOTLUMB	DW	0
SYSDRV	DB	0
KEEP_SP	DD	?
EMMSIGN	DB	'EMMXXXX0'
OSMINOR	DB	?
OSMAJOR	DB	?
PROMSG	DB	'Modular Memory Manager 386',0DH,0AH
	DB	'By Michael Sokolov <mxs46@k2.scl.cwru.edu>',0DH,0AH,0DH,0AH,'$'
INSMSG	DB	'MMM386 successfully installed',0DH,0AH,'$'
EDVMSG	DB	'DOS version 3.00 or later is required',0DH,0AH,'$'
ECLMSG	DB	'Invalid command line',0DH,0AH,'$'
EHMMSG	DB	'Minimum program size to get HMA cannot be more than 63 KB',0DH,0AH,'$'
ESAMSG	DB	'Ring 0 stack size must be a multiple of 4 bytes',0Dh,0Ah,'$'
ESBMSG	DB	'Ring 0 stack size cannot be larger than 32 KB',0Dh,0Ah,'$'
ESSMSG	DB	'Ring 0 stack size cannot be smaller than 2 KB',0Dh,0Ah,'$'
EPBMSG	DB	'Cannot handle more than 523998 physical extended memory pages',0Dh,0Ah,'$'
EABMSG	DB	'Cannot have more than 512 page tables (2 GB) of high linear address space',0Dh,0Ah,'$'
EASMSG	DB	'At least one page table of high linear address space is required',0Dh,0Ah,'$'
EBBMSG	DB	'Cannot handle more than 32768 linear block handles',0Dh,0Ah,'$'
EBSMSG	DB	'At least 256 linear block handles are required',0Dh,0Ah,'$'
EXBMSG	DB	'Cannot handle more than 255 XMS EMB handles',0Dh,0Ah,'$'
EXSMSG	DB	'At least 32 XMS EMB handles are required',0Dh,0Ah,'$'
EFLMSG	DB	'EMS page frame address cannot be lower than C000',0DH,0AH,'$'
EFHMSG	DB	'EMS page frame address cannot be higher than E000',0DH,0AH,'$'
EFNMSG	DB	'EMS page frame must be on a 16KB boundary',0DH,0AH,'$'
ECPMSG	DB	'386 or later CPU is required',0DH,0AH,'$'
ENFMSG	DB	'Cannot find enough contiguous UMB space for the EMS page frame',0DH,0AH,'$'
EPFMSG	DB	'Cannot locate the EMS page frame at the specified address',0DH,0AH,'$'
EIMMSG	DB	'Extended memory is too small to manage it',0DH,0AH,'$'
EXPMSG	DB	'An Extended Memory Manager is already installed',0DH,0AH,'$'
EEPMSG	DB	'An Expanded Memory Manager is already installed',0DH,0AH,'$'
EPMMSG	DB	'CPU is already in protected mode',0DH,0AH,'$'
EENMSG	DB	'Unable to enable A20 line',0DH,0AH,'$'
RDATA	ENDS

RSTACK	SEGMENT	USE16	PARA	STACK	'STACK'
RMSTACK	DW	2048 DUP(?)
RSTACK	ENDS

STARTUP	SEGMENT	USE32	PARA	PUBLIC	'CODE'

; All our startup EXTRNs go here
	EXTRN	STARTUP_END:NEAR
	EXTRN	LinSpaceInitHandleTbl:NEAR
	EXTRN	LinSpaceInitPageTables:NEAR
	EXTRN	XMSEMB_InitHandleTbl:NEAR
	EXTRN	XMS_UMB_Init:NEAR

	ASSUME	CS:STARTUP,DS:MAINDAT,ES:MAINDAT,SS:NOTHING

PMINIT:	MOV	EAX,18h
	MOV	DS,EAX
	MOV	EAX,20h
	MOV	ES,EAX
	MOV	EAX,28h
	MOV	SS,EAX
	XOR	EAX,EAX
	MOV	FS,EAX
	MOV	GS,EAX
	MOV	EAX,3002H
	PUSH	EAX
	POPFD
	MOV	EBP,110000H
	MOV	EAX,EBP
	MOV	WORD PTR [BSMAIND],AX
	SHR	EAX,10H
	MOV	[BSMAIND+2],AL
	MOV	EAX,EBP
	ADD	EAX,OFFSET GDT
	MOV	DWORD PTR [BASEGDT],EAX
	MOV	EAX,EBP
	ADD	EAX,OFFSET IDT
	MOV	DWORD PTR [BASEIDT],EAX
	MOV	ECX,OFFSET MAINDAT_END
	MOV	EAX,18H
	PUSH	ES
	MOV	ES,EAX
	XOR	ESI,ESI
	XOR	EDI,EDI
	PUSH	ECX
	REP	MOVS	BYTE PTR ES:[EDI],BYTE PTR DS:[ESI]
	POP	ECX
	MOV	DS,EAX
	POP	ES
	LGDT	FWORD PTR [DESCGDT]
	LIDT	FWORD PTR [DESCIDT]
	MOV	EAX,EBP
	ADD	EAX,OFFSET TSS
	MOV	WORD PTR [BASETSS],AX
	SHR	EAX,10H
	MOV	[BASETSS+2],AL
	XOR	EAX,EAX			; Intel docs recommend explicitly
	LLDT	AX			;   clearing LDTR if there is no LDT
	MOV	EAX,48H
	LTR	AX
	ADD	EBP,ECX
	MOV	ESI,MAINCOD
	SHL	ESI,4
	MOV	EDI,EBP
	MOV	EAX,EDI
	MOV	WORD PTR [BSMAINC],AX
	SHR	EAX,10H
	MOV	[BSMAINC+2],AL
	MOV	ECX,OFFSET MAINCOD_END
	REP	MOVS	BYTE PTR ES:[EDI],BYTE PTR ES:[ESI]
; Program the PICs to our normal values, 50 & 70
	MOV	BX,5070h
	FARCALL	ProgramPICs_FAR,0040h
; Continue preparing the memory. All stuff needed for VCPI should come first.
; As it happens, all we need for VCPI, aside from our own code and data, is the
; physical page alloc table and our Ring 0 stack. Therefore, put it first.
; NOTE: The Ring 0 stack is crucial. During the switch from our environment to
; the client, for a brief period of time the client's CR3 is in effect, but
; SS:ESP still points to our stack.
	ADD	EDI,3
	AND	EDI,0FFFFFFFCh
	MOV	[PhysPageAllocTbl],EDI
	MOV	ECX,[SystemReservedPages]
	MOV	EAX,0FFFFFFFFh
	REP	STOS	DWORD PTR ES:[EDI]
	MOV	ECX,[TotalPhysMemPages]
	SUB	ECX,[SystemReservedPages]
	MOV	[FreePages],ECX
	XOR	EAX,EAX
	REP	STOS	DWORD PTR ES:[EDI]
; Now the Ring 0 stack.
	ADD	EDI,[Ring0StackSize]
	MOV	[STKPNTR],EDI
; All VCPI stuff is in place. Now calculate and remember the # of pages we'll
; need to ask the clients to reserve for us.
	MOV	EAX,EDI
	ADD	EAX,0FFFh
	SHR	EAX,0Ch
	MOV	[PagesNeededForVCPI],EAX
; Now the fatal error screen buffer.
	MOV	[FatalErr_ScreenBuf],EDI
	XOR	EAX,EAX
	MOV	ECX,200h
	REP	STOS	DWORD PTR ES:[EDI]
; Now the linear block handle table.
	CALL	LinSpaceInitHandleTbl
; Now the XMS EMB handle table.
	CALL	XMSEMB_InitHandleTbl
; Now the page directory and the low linear space page tables.
	ADD	EDI,0FFFH
	AND	EDI,NOT 0FFFH
	MOV	[PDBRVAL],EDI
	MOV	EBP,EDI
	ADD	EBP,1000H
	MOV	[LowLinearSpacePageTbl],EBP
	MOV	ECX,[LowLinSpacePTEsNeeded]
	ADD	ECX,4FFH			; 100 1st MB + 3FF to round up
	SHR	ECX,0AH
	MOV	EAX,EBP
	MOV	AL,01100111B
@@:	STOSD
	ADD	EAX,1000H
	LOOP	@B
	MOV	ECX,EBP
	SUB	ECX,EDI
	SHR	ECX,2
	XOR	EAX,EAX
	REP	STOSD
	MOV	EAX,01100111B
	MOV	ECX,[LowLinSpacePTEsNeeded]
	ADD	ECX,100H
@@:	STOSD
	ADD	EAX,1000H
	LOOP	@B
; Pad the remainder of the last page table, if any.
	MOV	ECX,EDI
	ADD	ECX,0FFFh
	AND	ECX,NOT 0FFFh
	SUB	ECX,EDI
	JECXZ	@F
	SHR	ECX,2
	XOR	EAX,EAX
	REP	STOS	DWORD PTR ES:[EDI]
@@:
; Now the high linear space page tables.
	CALL	LinSpaceInitPageTables
; The virtual A20 starts off disabled
	MOV	EAX,100000H
	MOV	ECX,10H
	XOR	EDX,EDX
	FARCALL	PAGEMPF,0040h
; Finally, take care of the UMBs. First the physical part.
	CMP	[XMS_DoUMB],0
	JZ	UMB_Done
	MOV	ESI,RDATA
	SHL	ESI,4
	ADD	ESI,OFFSET UMBLIST
	PUSH	ESI
	ADD	EDI,0FFFH
	MOV	EDX,EDI
UMBCLP:	XOR	EAX,EAX
	MOV	AX,ES:[ESI]
	TEST	EAX,EAX
	JZ	UMBCDN
	XOR	ECX,ECX
	MOV	CL,ES:[ESI+2]
	ADD	ESI,3
	SHL	EAX,4
	FARCALL	PAGEMPF,0040h
	JMP	UMBCLP
UMBCDN:	POP	ESI
; The high-level part will later be done by the XMS code. It requires the
; paging to be on. Take care to preserve ESI!
UMB_Done:
; We are ready to turn the paging on!
	MOV	EAX,[PDBRVAL]
	MOV	CR3,EAX
	MOV	EAX,CR0
	OR	EAX,80000000H
	MOV	CR0,EAX
	JMP	SHORT	$+2			; Intel docs say we have to do
						;   this after setting PG.
; Now do the high-level part of the UMB initialization, if necessary.
	CMP	[XMS_DoUMB],0
	JZ	@F
	CALL	XMS_UMB_Init
@@:
; Now enter V86 for the first time!
	MOV	EDX,ESP
	XOR	EAX,EAX
	PUSH	EAX
	PUSH	EAX
	MOV	EAX,RDATA
	PUSH	EAX
	PUSH	EAX
	PUSH	DWORD PTR RSTACK
	PUSH	EDX
	PUSH	23202H
	PUSH	DWORD PTR RCODE
	DB	68H
	DW	OFFSET VMINIT,0
	IRETD


DISP_ST	PROC	NEAR
	ASSUME	DS:NOTHING,ES:NOTHING
	PUSH	EAX
	PUSH	EBX
	PUSH	ECX
	PUSH	EDX
	MOV	ECX,8
TEMPLS:	SHLD	EBX,EAX,4
	SHL	EAX,4
	AND	BL,0FH
	ADD	BL,30H
	CMP	BL,39H
	JBE	@F
	ADD	BL,7
@@:	MOV	ES:[EDX],BL
	ADD	EDX,2
	LOOP	TEMPLS
	POP	EDX
	POP	ECX
	POP	EBX
	POP	EAX
	RET
DISP_ST	ENDP
STARTUP	ENDS

MAINCOD	SEGMENT	USE32	PARA	PUBLIC	'CODE'

; All our code EXTRNs go here
	EXTRN	MAINCOD_END:NEAR
	EXTRN	FatalErrorStand:NEAR
	EXTRN	FatalErrorDump:NEAR
	EXTRN	VCPI_Driver:NEAR
	EXTRN	PhysPageAlloc:NEAR
	EXTRN	PhysPageFree:NEAR
	EXTRN	PhysRegionAlloc:NEAR
	EXTRN	PhysRegionFree:NEAR
	EXTRN	XMS_Driver:NEAR
	EXTRN	XMSEMB_PermLockModeEnter:NEAR
	EXTRN	XMSEMB_PermLockModeLeave:NEAR
	EXTRN	XMSEMB_PagingImport:NEAR

	ASSUME	CS:MAINCOD,DS:NOTHING,ES:NOTHING,SS:NOTHING

ProgramPICs	PROC	NEAR
	ASSUME	DS:NOTHING,ES:NOTHING
	IN	AL,0A1h
	JMP	SHORT	$+2
	JMP	SHORT	$+2
	XCHG	AL,AH
	IN	AL,21h
	JMP	SHORT	$+2
	JMP	SHORT	$+2
	PUSH	EAX
	MOV	AL,11H
	OUT	0A0H,AL
	JMP	SHORT	$+2
	JMP	SHORT	$+2
	OUT	20H,AL
	JMP	SHORT	$+2
	JMP	SHORT	$+2
	MOV	AL,BL
	OUT	0A1H,AL
	JMP	SHORT	$+2
	JMP	SHORT	$+2
	MOV	AL,BH
	OUT	21H,AL
	JMP	SHORT	$+2
	JMP	SHORT	$+2
	MOV	AL,2
	OUT	0A1H,AL
	JMP	SHORT	$+2
	JMP	SHORT	$+2
	MOV	AL,4
	OUT	21H,AL
	JMP	SHORT	$+2
	JMP	SHORT	$+2
	MOV	AL,1
	OUT	0A1H,AL
	JMP	SHORT	$+2
	JMP	SHORT	$+2
	OUT	21H,AL
	JMP	SHORT	$+2
	JMP	SHORT	$+2
	POP	EAX
	XCHG	AL,AH
	OUT	0A1h,AL
	JMP	SHORT	$+2
	JMP	SHORT	$+2
	XCHG	AL,AH
	OUT	21h,AL
	RET
ProgramPICs	ENDP

ProgramPICs_FAR	PROC	FAR
	CALL	ProgramPICs
	RET
ProgramPICs_FAR	ENDP

DN	=	8
	REPT	8
	.RADIX	16
@CATSTR(INTH,%DN):	DB	6AH,DN
	.RADIX	10
	JMP	INTPIC
DN	=	DN+1
	ENDM

DN	=	20h
	REPT	30h
	.RADIX	16
@CATSTR(INTH,%DN):	DB	6AH,DN
	.RADIX	10
	JMP	INTREF
DN	=	DN+1
	ENDM

DN	=	50H
	REPT	8
	.RADIX	16
@CATSTR(INTH,%DN):	DB	6AH,DN
	.RADIX	10
	JMP	INTPIC
DN	=	DN+1
	ENDM

DN	=	58h
	REPT	0Fh
	.RADIX	16
@CATSTR(INTH,%DN):	DB	6AH,DN
	.RADIX	10
	JMP	INTREF
DN	=	DN+1
	ENDM

DN	=	68h
	REPT	8
	.RADIX	16
@CATSTR(INTH,%DN):	DB	6AH,DN
	.RADIX	10
	JMP	INTREF
DN	=	DN+1
	ENDM

DN	=	70H
	REPT	8
	.RADIX	16
@CATSTR(INTH,%DN):	DB	6AH,DN
	.RADIX	10
	JMP	INTPIC
DN	=	DN+1
	ENDM

DN	=	78h
	REPT	88h
	.RADIX	16
@CATSTR(INTH,%DN):	DB	6AH,DN
	.RADIX	10
	JMP	INTREF
DN	=	DN+1
	ENDM

SetIntReflectNormal	PROC	NEAR
	ASSUME	DS:MAINDAT,ES:NOTHING
	PUSH	ESI
	PUSHFD
	CLI
	MOV	ESI,DWORD PTR [BASEIDT]
DN	=	0
	REPT	8
	.RADIX	16
	MOV	WORD PTR ES:[ESI+(DN+50h)*8],OFFSET @CATSTR(INTH,%DN+8)
	.RADIX	10
DN	=	DN+1
	ENDM
	POPFD
	POP	ESI
	RET
SetIntReflectNormal	ENDP

SetIntReflect5070	PROC	NEAR
	ASSUME	DS:MAINDAT,ES:NOTHING
	PUSH	ESI
	PUSHFD
	CLI
	MOV	ESI,DWORD PTR [BASEIDT]
DN	=	0
	REPT	8
	.RADIX	16
	MOV	WORD PTR ES:[ESI+(DN+50h)*8],OFFSET @CATSTR(INTH,%DN+50h)
	.RADIX	10
DN	=	DN+1
	ENDM
	POPFD
	POP	ESI
	RET
SetIntReflect5070	ENDP

	ASSUME	DS:NOTHING,ES:NOTHING
INTDIV:	PUSH	0
	JMP	INTREF

	ASSUME	DS:NOTHING,ES:NOTHING
INTDBG:	PUSH	1
	JMP	INTREF

	ASSUME	DS:NOTHING,ES:NOTHING
INTNMI:	MOV	EAX,18H
	MOV	DS,EAX
	ASSUME	DS:MAINDAT
	MOV	EAX,20H
	MOV	ES,EAX
	MOV	[FatalErr_StandDesc],OFFSET FatalErrMsg_NMI
	JMP	FatalErrorStand

	ASSUME	DS:NOTHING,ES:NOTHING
INTBPT:	PUSH	3
	JMP	INTREF

	ASSUME	DS:NOTHING,ES:NOTHING
INTOVF:	PUSH	4
	JMP	INTREF

	ASSUME	DS:NOTHING,ES:NOTHING
INTBND:	PUSH	5
	JMP	INTREF

	ASSUME	DS:NOTHING,ES:NOTHING
INTBOP:	TEST	DWORD PTR [ESP+8],20000h	; V86?
	JZ	@F
	CMP	WORD PTR [ESP+4],RCODE
	JNE	@F
	CMP	WORD PTR [ESP],12H
	JNE	@F
	MOV	EAX,18H
	MOV	DS,EAX
	ASSUME	DS:MAINDAT
	CLI
	ADD	ESP,24H
	POP	[STKPNTR]
	POP	GS
	POP	FS
	POP	ES
	POP	DS
	ASSUME	DS:NOTHING
	POP	EAX
	ADD	ESP,4
	IRETD
@@:	PUSH	6
	JMP	INTREF

	ASSUME	DS:NOTHING,ES:NOTHING
INTDNA:	PUSH	07h
	JMP	INTREF

	ASSUME	DS:NOTHING,ES:NOTHING
INTDBF:	PUSHAD
	PUSH	DS
	PUSH	ES
	PUSH	FS
	PUSH	GS
	MOV	EBP,ESP
	MOV	EAX,18H
	MOV	DS,EAX
	ASSUME	DS:MAINDAT
	MOV	EAX,20H
	MOV	ES,EAX
	MOV	[FatalErr_DumpType],1
	MOV	[FatalErr_DumpFaultDesc],OFFSET FatalErrMsg_DoubleFault
	JMP	FatalErrorDump

	ASSUME	DS:NOTHING,ES:NOTHING
INTNSO:	MOV	EAX,18H
	MOV	DS,EAX
	ASSUME	DS:MAINDAT
	MOV	EAX,20H
	MOV	ES,EAX
	MOV	[FatalErr_StandDesc],OFFSET FatalErrMsg_NPXSegLim
	JMP	FatalErrorStand

	ASSUME	DS:NOTHING,ES:NOTHING
INTTSF:	PUSHAD
	PUSH	DS
	PUSH	ES
	PUSH	FS
	PUSH	GS
	MOV	EBP,ESP
	MOV	EAX,18H
	MOV	DS,EAX
	ASSUME	DS:MAINDAT
	MOV	EAX,20H
	MOV	ES,EAX
	MOV	[FatalErr_DumpType],1
	MOV	[FatalErr_DumpFaultDesc],OFFSET FatalErrMsg_TSFault
	JMP	FatalErrorDump

	ASSUME	DS:NOTHING,ES:NOTHING
INTNPF:	PUSHAD
	PUSH	DS
	PUSH	ES
	PUSH	FS
	PUSH	GS
	MOV	EBP,ESP
	MOV	EAX,18H
	MOV	DS,EAX
	ASSUME	DS:MAINDAT
	MOV	EAX,20H
	MOV	ES,EAX
	MOV	[FatalErr_DumpType],1
	MOV	[FatalErr_DumpFaultDesc],OFFSET FatalErrMsg_NPFault
	JMP	FatalErrorDump

	ASSUME	DS:NOTHING,ES:NOTHING
INTSSF:	PUSHAD
	PUSH	DS
	PUSH	ES
	PUSH	FS
	PUSH	GS
	MOV	EBP,ESP
	MOV	EAX,18H
	MOV	DS,EAX
	ASSUME	DS:MAINDAT
	MOV	EAX,20H
	MOV	ES,EAX
	MOV	[FatalErr_DumpType],1
	MOV	[FatalErr_DumpFaultDesc],OFFSET FatalErrMsg_StackFault
	JMP	FatalErrorDump

	ASSUME	DS:NOTHING,ES:NOTHING
INTGPF:
; Normally, a GP fault is a fatal error and causes a dump. However, we also use
; GP faults to reflect some V86 mode software interrupts (the nasty ones). How
; do we tell whether to dump or to reflect? The reflection code assumes that
; the GP fault is caused by an INT nn instruction in V86 mode. Thus, the error
; code must refer to an interrupt (IDT=1) and show the instruction as the cause
; (EXT=0), and EFLAGS must indicate V86 mode (VM=1).
	TEST	DWORD PTR [ESP],2		; IDT
	JZ	INTGPF_Fatal
	TEST	DWORD PTR [ESP],1		; EXT
	JNZ	INTGPF_Fatal
	TEST	DWORD PTR [ESP+0Ch],20000h	; VM
	JZ	INTGPF_Fatal

; Reflect it.
	ASSUME	DS:NOTHING,ES:NOTHING
	PUSH	EAX
	PUSH	EBX
	PUSH	ECX
	MOV	EAX,20H
	MOV	DS,EAX
	MOV	EBX,[ESP+0CH]
	AND	EBX,7F8H
	SHR	EBX,1
	MOV	ECX,[EBX]
	MOVZX	EAX,WORD PTR [ESP+20H]
	SHL	EAX,4
	MOV	EBX,[ESP+1CH]
	SUB	BX,6
	MOV	[ESP+1CH],EBX
	MOVZX	EBX,BX
	ADD	EBX,EAX
	MOV	EAX,[ESP+10H]
	ADD	AX,2
	MOV	[EBX],AX
	MOV	EAX,[ESP+14H]
	MOV	[EBX+2],AX
	MOV	EAX,[ESP+18H]
	MOV	[EBX+4],AX
	AND	EAX,0FFFFFCFFH
	MOV	[ESP+18H],EAX
	MOV	[ESP+10H],CX
	SHR	ECX,10H
	MOV	[ESP+14H],ECX
	POP	ECX
	POP	EBX
	POP	EAX
	ADD	ESP,4
	IRETD

; Fatal GP fault.
	ASSUME	DS:NOTHING,ES:NOTHING
INTGPF_Fatal:
	CLI
	PUSHAD
	PUSH	DS
	PUSH	ES
	PUSH	FS
	PUSH	GS
	MOV	EBP,ESP
	MOV	EAX,18H
	MOV	DS,EAX
	ASSUME	DS:MAINDAT
	MOV	EAX,20H
	MOV	ES,EAX
	MOV	[FatalErr_DumpType],1
	MOV	[FatalErr_DumpFaultDesc],OFFSET FatalErrMsg_GPFault
	JMP	FatalErrorDump

	ASSUME	DS:NOTHING,ES:NOTHING
INTPGF:	PUSHAD
	PUSH	DS
	PUSH	ES
	PUSH	FS
	PUSH	GS
	MOV	EBP,ESP
	MOV	EAX,18H
	MOV	DS,EAX
	ASSUME	DS:MAINDAT
	MOV	EAX,20H
	MOV	ES,EAX
	MOV	[FatalErr_DumpType],2
	MOV	[FatalErr_DumpFaultDesc],OFFSET FatalErrMsg_PageFault
	JMP	FatalErrorDump

	ASSUME	DS:NOTHING,ES:NOTHING
INTCOP:	PUSH	10H
	JMP	INTREF

	ASSUME	DS:NOTHING,ES:NOTHING
INTACF:	PUSHAD
	PUSH	DS
	PUSH	ES
	PUSH	FS
	PUSH	GS
	MOV	EBP,ESP
	MOV	EAX,18H
	MOV	DS,EAX
	ASSUME	DS:MAINDAT
	MOV	EAX,20H
	MOV	ES,EAX
	MOV	[FatalErr_DumpType],1
	MOV	[FatalErr_DumpFaultDesc],OFFSET FatalErrMsg_ACFault
	JMP	FatalErrorDump

	ASSUME	DS:NOTHING,ES:NOTHING
INTPIC:	TEST	DWORD PTR [ESP+0CH],20000H
	JNZ	@F
	PUSH	EAX
	PUSH	DS
	PUSH	ES
	PUSH	FS
	PUSH	GS
	MOV	EAX,18H
	MOV	DS,EAX
	ASSUME	DS:MAINDAT
	MOV	EAX,20H
	MOV	ES,EAX
	PUSH	[STKPNTR]
	MOV	[STKPNTR],ESP
	XOR	EAX,EAX
	PUSH	EAX
	PUSH	EAX
	PUSH	EAX
	PUSH	EAX
	MOV	EAX,[ESP+10H]
	PUSH	SS:[EAX-14H]
	PUSH	SS:[EAX-18H]
	MOVZX	EAX,WORD PTR [ESP+4]
	SHL	EAX,4
	PUSH	EBX
	MOV	EBX,[ESP+4]
	SUB	BX,6
	MOV	[ESP+4],EBX
	MOVZX	EBX,BX
	ADD	EBX,EAX
	MOV	WORD PTR ES:[EBX],12H
	MOV	WORD PTR ES:[EBX+2],RCODE
	MOV	WORD PTR ES:[EBX+4],3202H
	POP	EBX
	PUSH	23002H
	MOV	EAX,[ESP+34H]
	AND	EAX,0FFH
	SHL	EAX,2
	MOV	EAX,ES:[EAX]
	PUSH	EAX
	MOVZX	EAX,AX
	PUSH	EAX
	SHR	DWORD PTR [ESP+4],10H
	IRETD

INTREF:	TEST	DWORD PTR [ESP+0CH],20000H
	JNZ	@F
	CLI
	PUSHAD
	PUSH	DS
	PUSH	ES
	PUSH	FS
	PUSH	GS
	MOV	EBP,ESP
	MOV	EAX,18H
	MOV	DS,EAX
	ASSUME	DS:MAINDAT
	MOV	EAX,20H
	MOV	ES,EAX
	MOV	[FatalErr_DumpType],0
	JMP	FatalErrorDump

	ASSUME	DS:NOTHING,ES:NOTHING
@@:	PUSH	EAX
	PUSH	EBX
	PUSH	ECX
	MOV	EAX,20H
	MOV	DS,EAX
	MOV	EBX,[ESP+0CH]
	AND	EBX,0FFH
	SHL	EBX,2
	MOV	ECX,[EBX]
	MOVZX	EAX,WORD PTR [ESP+20H]
	SHL	EAX,4
	MOV	EBX,[ESP+1CH]
	SUB	BX,6
	MOV	[ESP+1CH],EBX
	MOVZX	EBX,BX
	ADD	EBX,EAX
	MOV	EAX,[ESP+10H]
	MOV	[EBX],AX
	MOV	EAX,[ESP+14H]
	MOV	[EBX+2],AX
	MOV	EAX,[ESP+18H]
	MOV	[EBX+4],AX
	AND	EAX,0FFFFFCFFH
	MOV	[ESP+18H],EAX
	MOV	[ESP+10H],CX
	SHR	ECX,10H
	MOV	[ESP+14H],ECX
	POP	ECX
	POP	EBX
	POP	EAX
	ADD	ESP,4
	IRETD

	PUBLIC	Simulate_VM_Int
Simulate_VM_Int	PROC	FAR
	ASSUME	DS:NOTHING,ES:NOTHING
	SUB	ESP,4
	PUSH	EAX
	PUSH	DS
	PUSH	ES
	PUSH	FS
	PUSH	GS
	MOV	EAX,18H
	MOV	DS,EAX
	ASSUME	DS:MAINDAT
	MOV	EAX,20H
	MOV	ES,EAX
	CLI
	PUSH	[STKPNTR]
	MOV	[STKPNTR],ESP
	XOR	EAX,EAX
	PUSH	EAX
	PUSH	EAX
	PUSH	EAX
	PUSH	EAX
	MOV	EAX,[ESP+10H]
	PUSH	SS:[EAX-14H]
	PUSH	SS:[EAX-18H]
	MOVZX	EAX,WORD PTR [ESP+4]
	SHL	EAX,4
	PUSH	EBX
	MOV	EBX,[ESP+4]
	SUB	BX,6
	MOV	[ESP+4],EBX
	MOVZX	EBX,BX
	ADD	EBX,EAX
	MOV	WORD PTR ES:[EBX],12H
	MOV	WORD PTR ES:[EBX+2],RCODE
	MOV	AX,WORD PTR [ESP+40h]
	MOV	WORD PTR ES:[EBX+4],AX
	POP	EBX
	PUSH	23002H
	MOV	EAX,[ESP+44H]
	AND	EAX,0FFH
	SHL	EAX,2
	MOV	EAX,ES:[EAX]
	PUSH	EAX
	MOVZX	EAX,AX
	PUSH	EAX
	SHR	DWORD PTR [ESP+4],10H
	MOV	EAX,DWORD PTR [ESP+38h]
	IRETD
Simulate_VM_Int	ENDP

	PUBLIC	Call_VM_Proc_With_RETF_Frame
Call_VM_Proc_With_RETF_Frame	PROC	FAR
	ASSUME	DS:NOTHING,ES:NOTHING
	SUB	ESP,4
	PUSH	EAX
	PUSH	DS
	PUSH	ES
	PUSH	FS
	PUSH	GS
	MOV	EAX,18H
	MOV	DS,EAX
	ASSUME	DS:MAINDAT
	MOV	EAX,20H
	MOV	ES,EAX
	CLI
	PUSH	[STKPNTR]
	MOV	[STKPNTR],ESP
	XOR	EAX,EAX
	PUSH	EAX
	PUSH	EAX
	PUSH	EAX
	PUSH	EAX
	MOV	EAX,[ESP+10H]
	PUSH	SS:[EAX-14H]
	PUSH	SS:[EAX-18H]
	MOVZX	EAX,WORD PTR [ESP+4]
	SHL	EAX,4
	PUSH	EBX
	MOV	EBX,[ESP+4]
	SUB	BX,4
	MOV	[ESP+4],EBX
	MOVZX	EBX,BX
	ADD	EBX,EAX
	MOV	WORD PTR ES:[EBX],12H
	MOV	WORD PTR ES:[EBX+2],RCODE
	POP	EBX
	MOV	EAX,DWORD PTR [ESP+3Ch]
	OR	EAX,20000h
	PUSH	EAX
	MOV	EAX,[ESP+44H]
	PUSH	EAX
	MOVZX	EAX,AX
	PUSH	EAX
	SHR	DWORD PTR [ESP+4],10H
	MOV	EAX,DWORD PTR [ESP+38h]
	IRETD
Call_VM_Proc_With_RETF_Frame	ENDP

	PUBLIC	Call_VM_Proc_With_IRET_Frame
Call_VM_Proc_With_IRET_Frame	PROC	FAR
	ASSUME	DS:NOTHING,ES:NOTHING
	SUB	ESP,4
	PUSH	EAX
	PUSH	DS
	PUSH	ES
	PUSH	FS
	PUSH	GS
	MOV	EAX,18H
	MOV	DS,EAX
	ASSUME	DS:MAINDAT
	MOV	EAX,20H
	MOV	ES,EAX
	CLI
	PUSH	[STKPNTR]
	MOV	[STKPNTR],ESP
	XOR	EAX,EAX
	PUSH	EAX
	PUSH	EAX
	PUSH	EAX
	PUSH	EAX
	MOV	EAX,[ESP+10H]
	PUSH	SS:[EAX-14H]
	PUSH	SS:[EAX-18H]
	MOVZX	EAX,WORD PTR [ESP+4]
	SHL	EAX,4
	PUSH	EBX
	MOV	EBX,[ESP+4]
	SUB	BX,6
	MOV	[ESP+4],EBX
	MOVZX	EBX,BX
	ADD	EBX,EAX
	MOV	WORD PTR ES:[EBX],12H
	MOV	WORD PTR ES:[EBX+2],RCODE
	MOV	AX,WORD PTR [ESP+40h]
	MOV	WORD PTR ES:[EBX+4],AX
	POP	EBX
	PUSH	23002H
	MOV	EAX,[ESP+44H]
	PUSH	EAX
	MOVZX	EAX,AX
	PUSH	EAX
	SHR	DWORD PTR [ESP+4],10H
	MOV	EAX,DWORD PTR [ESP+38h]
	IRETD
Call_VM_Proc_With_IRET_Frame	ENDP

	ASSUME	DS:NOTHING,ES:NOTHING
INTUNS:	MOV	EAX,18H
	MOV	DS,EAX
	ASSUME	DS:MAINDAT
	MOV	EAX,20H
	MOV	ES,EAX
	MOV	[FatalErr_StandDesc],OFFSET FatalErrMsg_UnsupExp
	JMP	FatalErrorStand

	ASSUME	DS:NOTHING,ES:NOTHING
INTCTL:	CLD
	PUSH	EAX
	MOV	EAX,18H
	MOV	DS,EAX
	ASSUME	DS:MAINDAT
	MOV	EAX,20H
	MOV	ES,EAX
	POP	EAX
	CMP	AH,0DEH
	JNE	@F
	CALL	VCPI_Driver
	IRETD
@@:	CMP	AH,0E0H
	JNE	@F
	CALL	XMS_Driver
	IRETD
@@:	CMP	AH,0E1H
	JNE	@F
	REP	MOVS	DWORD PTR ES:[EDI],DWORD PTR ES:[ESI]
	IRETD
@@:	CMP	AH,0E2h
	JNE	@F
	CALL	SetIntReflectNormal
	IRETD
@@:	CMP	AH,0E3h
	JNE	@F
	CALL	SetIntReflect5070
	IRETD
@@:	CMP	AH,0E4h
	JNE	NotE4
	CALL	PhysRegionAlloc
	JC	@F
	AND	DWORD PTR [ESP+8],NOT 1
	IRETD
@@:	OR	DWORD PTR [ESP+8],1
	IRETD
NotE4:	CMP	AH,0E5h
	JNE	@F
	CALL	PhysRegionFree
	AND	DWORD PTR [ESP+8],NOT 1
	IRETD
@@:	CMP	AH,0E6h
	JNE	@F
	OR	BX,0001h
	LMSW	BX
	IRETD
@@:	CMP	AH,0E7h
	JNE	NotE7
	CALL	XMSEMB_PermLockModeEnter
	JC	@F
	AND	DWORD PTR [ESP+8],NOT 1
	IRETD
@@:	OR	DWORD PTR [ESP+8],1
	IRETD
NotE7:	CMP	AH,0E8h
	JNE	@F
	CALL	XMSEMB_PermLockModeLeave
	AND	DWORD PTR [ESP+8],NOT 1
	IRETD
@@:	CMP	AH,0E9H
	JE	SUSPND
	CMP	AH,0EAH
	JNE	@F
	CALL	GEMMIMP
	IRETD
@@:	CMP	AH,87H
	JNE	@F
	CALL	BIOSEMB
	IRETD
@@:	CMP	AH,89H
	JNE	@F
	AND	DWORD PTR [ESP+8],NOT 1
	IRETD
@@:	CMP	AH,40H
	JB	@F
	CMP	AH,5DH
	JA	@F
	MOV	AH,80H
	IRETD
@@:	MOV	AH,84H
	IRETD

	ASSUME	DS:MAINDAT,ES:NOTHING
SUSPND:	AND	[BASETSS+3],0FDH
	MOV	EAX,CR0
	AND	EAX,7FFFFFFFH
	MOV	CR0,EAX
	JMP	SHORT	$+2			; Intel docs say we have to do
						;   this after setting PG. I
						;   guess the same applies to
						;   resetting it.
	XOR	EAX,EAX
	MOV	CR3,EAX
	SGDT	FWORD PTR SS:[EBP]
	MOV	WORD PTR ES:[ESI],OFFSET RESUME
	MOV	WORD PTR ES:[ESI+2],0040h
	PUSH	EBX
	MOV	BX,0870h
	CALL	ProgramPICs
	POP	EBX
	LIDT	FWORD PTR [REALIDT]
	POP	ESI
	POP	EAX
	SHL	EAX,10h
	OR	ESI,EAX
	ADD	ESP,4
	POP	EBP
	POP	EAX
	MOVZX	EAX,AX
	SHL	EAX,4
	MOV	WORD PTR [BSSTACK],AX
	MOV	WORD PTR [BSRCODE],AX
	SHR	EAX,10H
	MOV	[BSSTACK+2],AL
	MOV	[BSRCODE+2],AL
	MOV	EAX,28H
	MOV	DS,EAX
	ASSUME	DS:NOTHING
	MOV	ES,EAX
	MOV	FS,EAX
	MOV	GS,EAX
	MOV	SS,EAX
	MOV	ESP,EBP
	MOVZX	EBP,BP
	MOV	DWORD PTR [EBP],0C0200F90h
	MOV	DWORD PTR [EBP+4],0FEE08366h
	MOV	DWORD PTR [EBP+8],0EAC0220Fh
	MOV	DWORD PTR [EBP+0Ch],ESI
	PUSH	DWORD PTR 0030h
	PUSH	EBP
	RETF

	ASSUME	DS:NOTHING,ES:NOTHING
RESUME:	MOV	EAX,18H
	MOV	DS,EAX
	ASSUME	DS:MAINDAT
	MOV	EAX,[PDBRVAL]
	MOV	CR3,EAX
	MOV	EAX,CR0
	OR	EAX,80000000H
	MOV	CR0,EAX
	JMP	SHORT	$+2			; Intel docs say we have to do
						;   this after setting PG.
	LIDT	FWORD PTR [DESCIDT]
	XOR	EAX,EAX			; Intel docs recommend explicitly
	LLDT	AX			;   clearing LDTR if there is no LDT
	MOV	EAX,48H
	LTR	AX
	PUSH	EBX
	MOV	BX,5070h
	CALL	ProgramPICs
	POP	EBX
	MOVZX	ESP,SP
	MOV	DWORD PTR [ESP+8],23002H
	IRETD

GEMMIMP	PROC	NEAR
	ASSUME	DS:MAINDAT,ES:NOTHING
	PUSH	EAX
	PUSH	EBX
	PUSH	ECX
	PUSH	EDX
	PUSH	EBP
	PUSH	ESI
	MOV	EDX,EDI
	MOV	EAX,4
	STOSD
	MOV	EAX,10BH
	STOSW
	XOR	EAX,EAX
	STOSD
	MOV	ECX,40H
	MOV	ESI,EDI
@@:	MOV	EAX,0FFFFFF00H
	STOSD
	MOV	EAX,0FFH
	STOSW
	LOOP	@B
	MOVZX	EAX,[EMS_PageFrameSeg]
	SHR	EAX,8
	MOV	EBX,EAX
	SHR	EAX,1
	ADD	EBX,EAX
	MOV	BYTE PTR ES:[ESI+EBX],3
	MOV	DWORD PTR ES:[ESI+EBX+2],1FFFH
	MOV	BYTE PTR ES:[ESI+EBX+6],3
	MOV	DWORD PTR ES:[ESI+EBX+8],11FFFH
	MOV	BYTE PTR ES:[ESI+EBX+0Ch],3
	MOV	DWORD PTR ES:[ESI+EBX+0Eh],21FFFH
	MOV	BYTE PTR ES:[ESI+EBX+12h],3
	MOV	DWORD PTR ES:[ESI+EBX+14h],31FFFH
	MOV	AL,10H
	STOSB
	INC	EDI
	XOR	BL,BL
	MOV	ECX,40H
	PUSH	EDX
	MOV	EDX,[LowLinearSpacePageTbl]
	XOR	EBP,EBP
GEIPSL:	CMP	BYTE PTR ES:[ESI],0
	JNE	GEIPSI
	PUSH	ECX
	MOV	CX,0104h
	MOV	BH,4
GEIIPL:	MOV	EAX,ES:[EDX]
	ADD	EDX,4
	SHR	EAX,0CH
	STOSD
	CMP	EAX,EBP
	JNE	@F
	MOV	DWORD PTR ES:[EDI-4],0
	SHL	CH,1
	OR	BYTE PTR ES:[ESI+5],CH
@@:	CMP	EAX,EBP
	JE	@F
	OR	BYTE PTR ES:[ESI],CL
	OR	BYTE PTR ES:[ESI+5],CH
	SHL	CH,1
@@:	SHL	CX,1
	INC	EBP
	DEC	BH
	JNZ	GEIIPL
	POP	ECX
	CMP	BYTE PTR ES:[ESI],0
	JNZ	@F
	SUB	EDI,10H
	JMP	GEIPSN
@@:	MOV	ES:[ESI+1],BL
	INC	BL
	JMP	GEIPSN
GEIPSI:	ADD	EDX,10H
	ADD	EBP,4
GEIPSN:	ADD	ESI,6
	LOOP	GEIPSL
	POP	EDX
	MOV	ES:[ESI+1],BL
	MOV	AL,1
	STOSB
	XOR	EAX,EAX
	STOSD
	STOSD
	STOSD
	STOSD
	MOV	EAX,ES:[19CH]
	STOSD
	XOR	EAX,EAX
	STOSD
	STOSB
	CALL	XMSEMB_PagingImport
	XOR	AL,AL
	STOSB
	MOV	EAX,EDI
	SUB	EAX,EDX
	MOV	ES:[EDX+2],AX
	MOV	ECX,0AH
	LEA	ESI,[MMMIDST]
	REP	MOVSD
	POP	ESI
	POP	EBP
	POP	EDX
	POP	ECX
	POP	EBX
	POP	EAX
	RET
GEMMIMP	ENDP

BIOSEMB	PROC	NEAR
	ASSUME	DS:MAINDAT,ES:NOTHING
	PUSH	EAX
	PUSH	EBX
	PUSH	ECX
	PUSH	ESI
	PUSH	EDI
	MOVZX	ECX,CX
	MOVZX	EBX,WORD PTR [ESP+28H]
	SHL	EBX,4
	MOVZX	ESI,SI
	ADD	EBX,ESI
	MOV	AL,ES:[EBX+14H]
	MOV	AH,ES:[EBX+17H]
	SHL	EAX,10H
	MOV	AX,ES:[EBX+12H]
	MOV	ESI,EAX
	MOV	AL,ES:[EBX+1CH]
	MOV	AH,ES:[EBX+1FH]
	SHL	EAX,10H
	MOV	AX,ES:[EBX+1AH]
	MOV	EDI,EAX
	MOV	EBX,[TotalPhysMemPages]
	ADD	EBX,100H
	SHL	EBX,0CH
	PUSH	ECX
	SHL	ECX,1
	MOV	EAX,ESI
	CMP	EAX,EBX
	JA	@F
	ADD	EAX,ECX
	CMP	EAX,EBX
	JBE	NSRCVP
@@:	PUSH	ECX
	PUSH	EDX
	MOV	EDX,ESI
	AND	ESI,0FFFH
	MOV	EAX,EBX
	ADD	ESI,EAX
	MOV	ECX,11H
	CALL	PAGEMAP
	MOV	EAX,[PDBRVAL]
	MOV	CR3,EAX
	POP	EDX
	POP	ECX
NSRCVP:	MOV	EAX,EDI
	CMP	EAX,EBX
	JA	@F
	ADD	EAX,ECX
	CMP	EAX,EBX
	JBE	NDSTVP
@@:	PUSH	ECX
	PUSH	EDX
	MOV	EDX,EDI
	AND	EDI,0FFFH
	MOV	EAX,EBX
	ADD	EAX,11000H
	ADD	EDI,EAX
	MOV	ECX,11H
	CALL	PAGEMAP
	MOV	EAX,[PDBRVAL]
	MOV	CR3,EAX
	POP	EDX
	POP	ECX
NDSTVP:	POP	ECX
	SHR	ECX,1
	REP	MOVS	DWORD PTR ES:[EDI],DWORD PTR ES:[ESI]
	JNC	@F
	MOVS	WORD PTR ES:[EDI],WORD PTR ES:[ESI]
@@:	POP	EDI
	POP	ESI
	POP	ECX
	POP	EBX
	POP	EAX
	XOR	AH,AH
	AND	DWORD PTR [ESP+0CH],NOT 1
	RET
BIOSEMB	ENDP

	PUBLIC	PAGEMAP
PAGEMAP	PROC	NEAR
	ASSUME	DS:MAINDAT,ES:NOTHING
	SHR	EAX,0CH
	SHL	EAX,2
	ADD	EAX,[LowLinearSpacePageTbl]
	AND	EDX,NOT 0FFFH
	MOV	DL,01100111B
@@:	MOV	ES:[EAX],EDX
	ADD	EAX,4
	ADD	EDX,1000H
	LOOP	@B
	RET
PAGEMAP	ENDP
PAGEMPF	PROC	FAR
	CALL	PAGEMAP
	RET
PAGEMPF	ENDP


	PUBLIC	DISP
DISP	PROC	NEAR
	ASSUME	DS:NOTHING,ES:NOTHING
	PUSH	EAX
	PUSH	EBX
	PUSH	ECX
	PUSH	EDX
	MOV	ECX,8
TEMPLP:	SHLD	EBX,EAX,4
	SHL	EAX,4
	AND	BL,0FH
	ADD	BL,30H
	CMP	BL,39H
	JBE	@F
	ADD	BL,7
@@:	MOV	ES:[EDX],BL
	ADD	EDX,2
	LOOP	TEMPLP
	POP	EDX
	POP	ECX
	POP	EBX
	POP	EAX
	RET
DISP	ENDP
MAINCOD	ENDS

MAINDAT	SEGMENT	USE32	PARA	PUBLIC	'DATA'

; All our data EXTRNs go here
	EXTRN	MAINDAT_END:NEAR
	EXTRN	FatalErr_ScreenBuf:DWORD
	EXTRN	FatalErr_StandDesc:DWORD
	EXTRN	FatalErr_DumpType:BYTE
	EXTRN	FatalErr_DumpFaultDesc:DWORD
	EXTRN	PagesNeededForVCPI:DWORD
	EXTRN	Hide_VCPI_From_Ugly_Phar_Lap:BYTE
	EXTRN	HighLinSpacePageTables:DWORD
	EXTRN	LinBlockHandles:WORD
	EXTRN	XMSEMB_Handles:BYTE
	EXTRN	XMS_HMAMIN:BYTE
	EXTRN	XMS_DoUMB:BYTE
	EXTRN	EMS_PageFrameSeg:WORD

GDT	DB	8 DUP(0)
	PUBLIC	DESCGDT
DESCGDT	DW	57H
BASEGDT	DW	3 DUP(0)
	PUBLIC	DESCIDT
DESCIDT	DW	7FFH
BASEIDT	DW	3 DUP(0)
	PUBLIC	DSMAIND
DSMAIND	DW	OFFSET MAINDAT_END-1
BSMAIND	DB	3 DUP(?),10010011B,40H,0
DESFLAT	DW	0FFFFH
BASFLAT	DB	3 DUP(0),10010011B,0CFH,0
DSSTACK	DW	0FFFFH
BSSTACK	DB	3 DUP(?),10010011B,0,0
DSRCODE	DW	0FFFFH
BSRCODE	DB	3 DUP(?),10011011B,0,0
DSFLATC	DW	0FFFFH
BSFLATC	DB	3 DUP(0),10011011B,0CFH,0
	PUBLIC	DSMAINC
DSMAINC	DW	OFFSET MAINCOD_END-1
BSMAINC	DB	3 DUP(?),10011011B,40H,0
DESCTSS	DW	2067H
	PUBLIC	BASETSS
BASETSS	DB	3 DUP(?),10001001B,40H,0
DSSTART	DW	OFFSET STARTUP_END-1
BSSTART	DB	3 DUP(?),10011011B,40H,0
TSS	DD	0
STKPNTR	DD	?
	DW	20H,0,2DH DUP(0),68H
	DD	800h DUP(0)
	PUBLIC	PDBRVAL
PDBRVAL	DD	?

IDT	LABEL	BYTE

IDTDESC	MACRO	handler,access
	DW	handler,0040h
	DB	00h,access
	DW	0000h
	ENDM

; CPU exceptions
	IDTDESC	INTDIV,8Fh			; 00 - Divide by zero
	IDTDESC	INTDBG,8Fh			; 01 - Debug
	IDTDESC	INTNMI,8Eh			; 02 - NMI
	IDTDESC	INTBPT,0EFh			; 03 - Breakpoint
	IDTDESC	INTOVF,0EFh			; 04 - Overflow
	IDTDESC	INTBND,8Fh			; 05 - BOUND
	IDTDESC	INTBOP,8Fh			; 06 - Invalid opcode
	IDTDESC	INTDNA,8Fh			; 07 - Device not available
	IDTDESC	INTDBF,8Eh			; 08 - Double fault
	IDTDESC	INTNSO,8Eh			; 09 - NPX seg limit overrun
	IDTDESC	INTTSF,8Eh			; 0A - Invalid TSS fault
	IDTDESC	INTNPF,8Eh			; 0B - Not Present fault
	IDTDESC	INTSSF,8Eh			; 0C - Stack fault
	IDTDESC	INTGPF,8Fh			; 0D - GP fault
	IDTDESC	INTPGF,8Eh			; 0E - Page fault
	IDTDESC	INTUNS,8Eh
	IDTDESC	INTCOP,8Fh			; 10 - Coprocessor error
	IDTDESC	INTACF,8Eh			; 11 - Alignment Check fault

	REPT	0Eh
	IDTDESC	INTUNS,8Eh
	ENDM

; Ints 20 through 4F have dedicated reflectors for speed
DN	=	20h
	REPT	30h
	.RADIX	16
	IDTDESC	@CATSTR(INTH,%DN),0EFh
	.RADIX	10
DN	=	DN+1
	ENDM

; Ints 50 through 57 are our map for the master PIC
DN	=	8
	REPT	8
	.RADIX	16
	IDTDESC	@CATSTR(INTH,%DN),8Eh
	.RADIX	10
DN	=	DN+1
	ENDM

; Ints 58 through 66 have dedicated reflectors for speed
DN	=	58h
	REPT	0Fh
	.RADIX	16
	IDTDESC	@CATSTR(INTH,%DN),0EFh
	.RADIX	10
DN	=	DN+1
	ENDM

; INT 67 is our magic nexus
	IDTDESC	INTCTL,0EFh

; Ints 68 through 6F have dedicated reflectors for speed
DN	=	68h
	REPT	8
	.RADIX	16
	IDTDESC	@CATSTR(INTH,%DN),0EFh
	.RADIX	10
DN	=	DN+1
	ENDM

; Ints 70 through 77 are our map for the slace PIC
DN	=	70h
	REPT	8
	.RADIX	16
	IDTDESC	@CATSTR(INTH,%DN),8Eh
	.RADIX	10
DN	=	DN+1
	ENDM

; Ints 78 through FF have dedicated reflectors for speed
DN	=	78h
	REPT	88h
	.RADIX	16
	IDTDESC	@CATSTR(INTH,%DN),0EFh
	.RADIX	10
DN	=	DN+1
	ENDM

.ERRNZ	$-IDT-800h,IDT has a wrong number of entries

Ring0StackSize		DD	?
LowLinSpacePTEsNeeded	DD	?
			PUBLIC	TotalPhysMemPages
TotalPhysMemPages	DD	?
			PUBLIC	SystemReservedPages
SystemReservedPages	DD	?
			PUBLIC	FreePages
FreePages		DD	?
			PUBLIC	PhysPageAllocTbl
PhysPageAllocTbl	DD	?
			PUBLIC	LowLinearSpacePageTbl
LowLinearSpacePageTbl	DD	?

REALIDT	DW	3FFH,0,0

MMMIDST	DB	'Michael Sokolov     '
	DB	'MMM386 version 1.00 '

FatalErrMsg_UnsupExp	DB	'Unsupported processor exception',0Ah,0
FatalErrMsg_NMI		DB	'Non-Maskable Interrupt (NMI)',0Ah,0
FatalErrMsg_NPXSegLim	DB	'NPX segment limit overrun',0Ah,0

FatalErrMsg_DoubleFault	DB	'Double fault',0Ah,0
FatalErrMsg_TSFault	DB	'Invalid TSS fault',0Ah,0
FatalErrMsg_NPFault	DB	'Not Present (NP) fault',0Ah,0
FatalErrMsg_StackFault	DB	'Stack fault',0Ah,0
FatalErrMsg_GPFault	DB	'General Protection (GP) fault',0Ah,0
FatalErrMsg_PageFault	DB	'Page fault',0Ah,0
FatalErrMsg_ACFault	DB	'Alignment Check (AC) fault',0Ah,0

TEMPPTR	DD	0B8000h	; TEMP

MAINDAT	ENDS

ZSEG	SEGMENT	USE16	PARA	MEMORY	'BLANK'
ZSEG	ENDS

	END	START
