#include <stdio.h>
#include <stdlib.h>

struct
{
    unsigned long edi;
    unsigned long esi;
    unsigned long ebp;
    unsigned long espres;
    unsigned long ebx;
    unsigned long edx;
    unsigned long ecx;
    unsigned long eax;
    unsigned flags;
    unsigned es;
    unsigned ds;
    unsigned fs;
    unsigned gs;
    unsigned ip;
    unsigned cs;
    unsigned sp;
    unsigned ss;
} rmcall = {0, 0, 0, 0, 0, 0, 0, 0, 0x202, 0, 0, 0, 0, 0, 0, 0, 0};

extern unsigned _initax, _initbx;

unsigned char pmstart = 0, skipmcp = 0;

main(argc, argv, envp)
int argc;
char *argv[];
char *envp[];
{
    _asm
    {
	PUSH ES
	MOV AX, _psp
	MOV ES, AX
	MOV AX, ES:[30h]
	POP ES
	MOV BX, SS
	CMP AX, BX
	JE normalrun
	MOV pmstart, 1
normalrun:
    }

    if (pmstart)
	printf("Began life already in protected mode\n"
	       "Skipping pre-test and mode switch test\n");
    else
    {
	pretest();
	modeswitch();
    }

    {
	unsigned char i;

	for(i = 1; i < argc; i++)
	{
	    if (!stricmp(argv[i], "/NOMCP"))
	    {
		skipmcp = 1;
		break;
	    }
	}
    }

    maintest();
    exit(0);
}

pretest()
{
    unsigned dos386ret, curmoderet;

    printf("*** PRE-TEST\n");

    _asm
    {
	MOV AX, 1600h
	INT 2Fh
	MOV dos386ret, AX
    }
    dos386disp(dos386ret, 0);

    _asm
    {
	MOV AX, 1686h
	INT 2Fh
	MOV curmoderet, AX
    }
    curmodedisp(curmoderet, 0);
    return;
}

modeswitch()
{
    unsigned mscretax, mscretbx, mscretcx, mscretdx, mscretsi;
    void (far *mscallbk)();
    _segment hostmem;
    unsigned char mserror=0;

    printf("\n*** SWITCHING INTO PM\n");

    _asm
    {
	MOV AX, 1687h
	INT 2Fh
	MOV mscretax, AX
	MOV mscretbx, BX
	MOV mscretcx, CX
	MOV mscretdx, DX
	MOV mscretsi, SI
	MOV WORD PTR mscallbk, DI
	MOV WORD PTR mscallbk+2, ES
    }
    if (mscretax)
    {
	printf("\nReal-to-protected mode switch call not supported, cannot continue\n");
	exit(1);
    }
    printf("\nReal-to-protected mode switch call returns BX=%04X, CX=%04X, DX=%04X, SI=%04x\n",
	   mscretbx, mscretcx, mscretdx, mscretsi);
    if (mscretbx & 1)
	printf("32-bit clients supported\n");
    else
	printf("Only 16-bit clients supported\n");
    switch (mscretcx)
    {
	case 2:
	    printf("CPU is 80286\n");
	    break;
	case 3:
	    printf("CPU is 80386\n");
	    break;
	case 4:
	    printf("CPU is 80486\n");
	    break;
	default:
	    printf("CPU is unknown\n");
    }
    if (mscretsi)
    {
	printf("Host requires %Xh paragraphs for its own use\n", mscretsi);
	_asm
	{
	    MOV AH, 48h
	    MOV BX, mscretsi
	    INT 21h
	    JNC hostmemok
	    MOV mserror, 1
hostmemok:
	    MOV hostmem, AX
	}
	if (mserror)
	{
	    printf("Unable to allocate memory for the host, cannot continue\n");
	    exit(1);
	}
    }
    else
	printf("Host doesn't require any memory for its own use\n");

    _asm
    {
	XOR AX, AX
	MOV ES, hostmem
	CALL mscallbk
	JNC modeswok
	MOV mserror, 1
modeswok:
    }
    if (mserror)
    {
	printf("Unable to switch into protected mode, cannot continue\n");
	exit(1);
    }
    return;
}

maintest()
{
    unsigned ourcs, ourds;
    unsigned char ourcpl;

    printf("\n*** MAIN TEST\n");

    _asm
    {
	MOV ourcs, CS
	MOV ourds, DS
    }
    printf("\nHello world from protected mode!\n"
	   "Our code segment is %04X and our DGROUP is %04X\n", ourcs, ourds);

    _asm
    {
	LAR AX, ourcs
	AND AH, 60h
	SHR AH, 5
	MOV ourcpl, AH
    }
    printf("\nWe are running at Ring %X\n", ourcpl);

    if (pmstart)
    {
	printf("\nAt startup AX=%04X, possible selector\n", _initax);
	seltest(_initax);
	printf("\nAt startup BX=%04X, possible selector\n", _initbx);
	seltest(_initbx);
    }

    {
	unsigned retax;

	_asm
	{
	    MOV AX, 1600h
	    INT 2Fh
	    MOV retax, AX
	}
	dos386disp(retax, 0);
    }

    {
	rmcall.eax = 0x1600;
	_asm
	{
	    MOV AX, DS
	    MOV ES, AX
	    LEA DI, rmcall
	    MOV AX, 300h
	    MOV BX, 2Fh
	    XOR CX, CX
	    INT 31h
	}
	dos386disp((unsigned) rmcall.eax, 1);
    }

    {
	unsigned retax;

	_asm
	{
	    MOV AX, 1686h
	    INT 2Fh
	    MOV retax, AX
	}
	printf("\nDirect written DPMI mode detect call returns %04X in AX\n", retax);
	if (retax)
	{
	    if (retax == 0x1686)
		printf("Probably no one handles this call\n");
	    else
		printf("Someone seems to handle this call, but with a bug\n");
	}
	else
	    printf("Correctly says that we are in protected mode\n");
    }

    {
	rmcall.eax = 0x1686;
	_asm
	{
	    MOV AX, DS
	    MOV ES, AX
	    LEA DI, rmcall
	    MOV AX, 300h
	    MOV BX, 2Fh
	    XOR CX, CX
	    INT 31h
	}
	curmodedisp((unsigned) rmcall.eax, 1);
    }

    {
	unsigned retax, retbx;

	_asm
	{
	    MOV AX, 1688h
	    XOR BX, BX
	    INT 2Fh
	    MOV retax, AX
	    MOV retbx, BX
	}
	printf("\nINT 2Fh/AX=1688h with BX=0000 returns AX=%04X", retax);
	if (!retax)
	{
	    printf(" and BX=%04X (supposed LDT data alias)\n", retbx);
	    seltest(retbx);
	}
	else
	{
	    if (retax == 0x1688)
		printf("\nPerhaps no one handles this call\n");
	    else
		printf("\nProbably someone handles this call, but fails it\n");
	}
    }

    {
	unsigned retax, retbx;

	_asm
	{
	    MOV AX, 1688h
	    MOV BX, 0BADh
	    INT 2Fh
	    MOV retax, AX
	    MOV retbx, BX
	}
	printf("\nINT 2Fh/AX=1688h with BX=0BAD returns AX=%04X", retax);
	if (!retax)
	{
	    printf(" and BX=%04X (supposed LDT data alias)\n", retbx);
	    seltest(retbx);
	}
	else
	{
	    if (retax == 0x1688)
		printf("\nPerhaps no one handles this call\n");
	    else
		printf("\nProbably someone handles this call, but fails it\n");
	}
    }

    {
	char extname[] = "MS-DOS";
	unsigned char retal, retax;
	void (far *callbk)();

	_asm
	{
	    MOV AX, 168Ah
	    LEA SI, extname[0]
	    INT 2Fh
	    MOV retal, AL
	    MOV WORD PTR callbk, DI
	    MOV WORD PTR callbk+2, ES
	}
	printf("\nMS-DOS API extension detect call returns AL=%02X\n", retal);
	if (retal != 0x8A)
	{
	    unsigned char cf;

	    printf("The extension is present\n");

	    cf = 0;
	    _asm
	    {
		XOR AX, AX
		CALL callbk
		JNC extverok
		MOV cf, 1
extverok:
		MOV retax, AX
	    }
	    printf("\nThe get extension version call returns CF=%u and AX=%04X\n"
		   "The extension version is %u.%02u\n", cf, retax, retax>>8, retax&0xFF);

	    cf = 0;
	    _asm
	    {
		MOV AX, 100h
		CALL callbk
		JNC extldtok
		MOV cf, 1
extldtok:
		MOV retax, AX
	    }
	    printf("\nThe get LDT data alias call returns CF=%u and AX=%04X\n", cf, retax);
	    seltest(retax);
	}
	else
	    printf("The extension is not present\n");
    }

    {
	unsigned char fail = 0;

	_asm
	{
	    MOV AX, 0Dh
	    MOV BX, 4
	    INT 31h
	    JNC specselok
	    MOV fail, 1
specselok:
	}
	printf("\nAllocate specific LDT selector function with BX=0004 ");
	if (!fail)
	{
	    printf("successful\nAppears to be supported\n");
	    _asm
	    {
		MOV AX, 1
		MOV BX, 4
		INT 31h
	    }
	}
	else
	    printf("failed\nAppears to be unsupported\n");
    }

    {
	unsigned char fail = 0;
	void far *vector31, far *vector21;

	_asm
	{
	    MOV AX, 204h
	    MOV BL, 21h
	    INT 31h
	    JNC getvectok
	    MOV fail, 1
getvectok:
	    MOV vector31, DX
	    MOV vector31+2, CX
	}
	printf("\nGet PM int vector INT 31h call for vector 21h ");
	if (!fail)
	{
	    printf("succeeded and returned %Fp\n", (void far *) vector31);
	    _asm
	    {
		MOV AX, 3521h
		INT 21h
		MOV vector21, BX
		MOV vector21+2, ES
	    }
	    if (vector31 == vector21)
		printf("Equivalent INT 21h call returns the same address\n"
		       "The INT 31h call appears to be supported\n");
	    else
		printf("Equivalent INT 21h call returns a different address (%Fp)\n"
		       "The INT 31h call appears to be unsupported or implemented incorrectly\n", (void far *) vector21);
	}
	else
	    printf("failed\nThe INT 31h call appears to be unsupported\n");
    }

    {
	unsigned char fail = 0;

	_asm
	{
	    MOV AX, 305h
	    INT 31h
	    JNC statesaveok
	    MOV fail, 1
statesaveok:
	}
	printf("\nGet state save/restore addresses INT 31h call ");
	if (!fail)
	    printf("succeeded\nAppears to be supported\n");
	else
	    printf("failed\nAppears to be unsupported\n");
    }

    {
	unsigned char fail = 0;

	_asm
	{
	    MOV AX, 306h
	    INT 31h
	    JNC rawswitchok
	    MOV fail, 1
rawswitchok:
	}
	printf("\nGet raw mode switch addresses INT 31h call ");
	if (!fail)
	    printf("succeeded\nAppears to be supported\n");
	else
	    printf("failed\nAppears to be unsupported\n");
    }

    {
	unsigned retax, retbx, retcx, retdx;

	_asm
	{
	    MOV AX, 400h
	    INT 31h
	    MOV retax, AX
	    MOV retbx, BX
	    MOV retcx, CX
	    MOV retdx, DX
	}
	printf("\nGet DPMI version INT 31h call returns AX=%04X, BX=%04X, CX=%04X, DX=%04X\n",
	       retax, retbx, retcx, retdx);
	if (retbx & 1)
	    printf("32-bit clients supported\n");
	else
	    printf("Only 16-bit clients supported\n");
	if (retbx & 2)
	    printf("Interrupts are reflected into real mode\n");
	else
	    printf("Interrupts are reflected into V86 mode\n");
	if (retbx & 4)
	    printf("Virtual memory supported\n");
	else
	    printf("Virtual memory not supported\n");
	switch (retcx)
	{
	    case 2:
		printf("CPU is 80286\n");
		break;
	    case 3:
		printf("CPU is 80386\n");
		break;
	    case 4:
		printf("CPU is 80486\n");
		break;
	    default:
		printf("CPU is unknown\n");
	}
	printf("PICs are programmed to %02X (master) and %02X (slave)\n", retdx>>8, retdx&0xFF);
    }

    {
	unsigned char fail = 0;

	_asm
	{
	    MOV AX, 604h
	    INT 31h
	    JNC getpagesizeok
	    MOV fail, 1
getpagesizeok:
	}
	printf("\nGet page size INT 31h call ");
	if (!fail)
	    printf("succeeded\nAppears to be supported\n");
	else
	    printf("failed\nAppears to be unsupported\n");
    }

    {
	unsigned char fail;
	unsigned long addr, page, handle;
	unsigned char desc[8];
	unsigned sel;

	fail = 0;
	_asm
	{
	    MOV AX, 501h
	    XOR BX, BX
	    MOV CX, 2000h
	    INT 31h
	    JNC memallocok
	    MOV fail, 1
memallocok:
	    MOV WORD PTR addr, CX
	    MOV WORD PTR addr+2, BX
	    MOV WORD PTR handle, DI
	    MOV WORD PTR handle+2, SI
	}
	if (!fail)
	{
	    fail = 0;
	    _asm
	    {
		XOR AX, AX
		MOV CX, 1
		INT 31h
		JNC selallocok
		MOV fail, 1
selallocok:
		MOV sel, AX
	    }
	    if (!fail)
	    {
		fail = 0;
		desc[0] = 0x20;
		desc[1] = 0x00;
		desc[2] = addr & 0xFF;
		desc[3] = addr >> 8 & 0xFF;
		desc[4] = addr >> 16 & 0xFF;
		desc[5] = 0x93 + (ourcpl << 5);
		desc[6] = 0x00;
		desc[7] = addr >> 24;
		_asm
		{
		    MOV AX, DS
		    MOV ES, AX
		    LEA DI, desc[0]
		    MOV AX, 0Ch
		    MOV BX, sel
		    INT 31h
		    JNC selsetok
		    MOV fail, 1
selsetok:
		}
		if (!fail)
		{
		    fail = 0;
		    _asm
		    {
			MOV AX, 4
			MOV BX, sel
			INT 31h
			JNC sellockok
			MOV fail, 1
sellockok:
		    }
		    printf("\nUndocumented DPMI lock selector call ");
		    if (!fail)
		    {
			printf("succeeded\nAppears to be supported\n");
			_asm
			{
			    MOV AX, 5
			    MOV BX, sel
			    INT 31h
			}
		    }
		    else
			printf("failed\nAppears to be unsupported\n");
		}
		else
		    printf("\nUnable to set the descriptor bytes for a selector\n"
			   "Cannot test the lock selector function\n");
		_asm
		{
		    MOV AX, 1
		    MOV BX, sel
		    INT 31h
		}
	    }
	    else
		printf("\nUnable to allocate a selector\n"
		       "Cannot test the lock selector function\n");
	    fail = 0;
	    page = addr + 0xFFF >> 12;
	    _asm
	    {
		MOV AX, 701h
		MOV CX, WORD PTR page
		MOV BX, WORD PTR page+2
		XOR SI, SI
		MOV DI, 1
		INT 31h
		JNC pagediscok
		MOV fail, 1
pagediscok:
	    }
	    printf("\nUndocumented DPMI discard page contents call ");
	    if (!fail)
		printf("succeeded\nAppears to be supported\n");
	    else
		printf("failed\nAppears to be unsupported\n");
	    fail = 0;
	    _asm
	    {
		MOV AX, 703h
		MOV CX, WORD PTR addr
		MOV BX, WORD PTR addr+2
		XOR SI, SI
		MOV DI, 2000h
		INT 31h
		JNC bytediscok
		MOV fail, 1
bytediscok:
	    }
	    printf("\nWritten DPMI discard page contents call ");
	    if (!fail)
		printf("succeeded\nAppears to be supported\n");
	    else
		printf("failed\nAppears to be unsupported\n");
	    _asm
	    {
		MOV AX, 502h
		MOV DI, WORD PTR handle
		MOV SI, WORD PTR handle+2
		INT 31h
	    }
	}
	else
	    printf("\nUnable to allocate a memory block\n"
		   "Cannot test the lock selector and discard page contents functions\n");
    }

    {
	unsigned char fail = 0;
	unsigned handle;

	_asm
	{
	    MOV AX, 0B00h
	    XOR BX, BX
	    MOV CX, 400h
	    MOV DX, 1
	    INT 31h
	    JNC bkptok
	    MOV fail, 1
bkptok:
	    MOV handle, BX
	}
	printf("\nSet debug watchpoint INT 31h function ");
	if (!fail)
	{
	    printf("succeeded\nAppears to be supported\n");
	    _asm
	    {
		MOV AX, 0B01h
		MOV BX, handle
		INT 31h
	    }
	}
	else
	    printf("failed\nAppears to be unsupported\n");
    }

    if (!skipmcp)
    {
	unsigned char fail = 0;
	unsigned retax;

	_asm
	{
	    MOV AX, 0E00h
	    INT 31h
	    JNC coprocok
	    MOV fail, 1
coprocok:
	    MOV retax, AX
	}
	printf("\nGet coprocessor status INT 31h call ");
	if (!fail)
	{
	    printf("succeeded and returned AX=%04X\n"
		   "Numeric coprocessor is %s for this client\n"
		   "Client is %semulating coprocessor instructions\n"
		   "Numeric coprocessor is %spresent\n"
		   "Host is %semulating coprocessor instructions\n",
		   retax, retax&1 ? "enabled" : "disabled", retax&2 ? "" : "not ", retax&4 ? "" : "not ", retax&8 ? "" : "not ");
	    switch (retax >> 4 & 0xF)
	    {
		case 0:
		    printf("There is no coprocessor\n");
		    break;
		case 2:
		    printf("Coprocessor is 80287\n");
		    break;
		case 3:
		    printf("Coprocessor is 80387\n");
		    break;
		case 4:
		    printf("CPU is 80486 with coprocessor\n");
		    break;
		default:
		    printf("Coprocessor type is unknown\n");
	    }
	}
	else
	    printf("failed\nAppears to be unsupported\n");
    }
    else
	printf("\nCoprocessor-related INT 31h calls test skipped\n");

    return;
}

dos386disp(dos386ret, mode)
unsigned dos386ret;
unsigned char mode;
{
    unsigned char d3retal;

    printf("\n%s DOS386 detection call returns %04X in AX\n", mode ? "Real mode" : "Direct", dos386ret);
    d3retal = dos386ret & 0xFF;
    if (d3retal)
    {
	if (d3retal == 1 || d3retal == 0xFF)
	    printf("Windows/386 version 2.xx present\n");
	else
	    printf("DOS386 version %d.%02d present\n", d3retal, dos386ret>>8);
    }
    else
	printf("DOS386 not present\n");
    return;
}

curmodedisp(curmoderet, mode)
unsigned curmoderet;
unsigned char mode;
{
    printf("\n%s written DPMI mode detect call returns %04X in AX\n", mode ? "Real mode" : "Direct", curmoderet);
    if (curmoderet)
    {
	if (curmoderet == 0x1686)
	    printf("Maybe no one handles this call\n");
	else
	    printf("Someone seems to handle this call\n");
    }
    else
	printf("WRONG! It says that we are in protected mode!\n");
    return;
}

seltest(sel)
unsigned sel;
{
    unsigned char instrfail, desc[8];

    instrfail = 0;
    _asm
    {
	VERR sel
	JZ verrpass
	MOV instrfail, 1
verrpass:
    }
    printf("%s VERR test\n", instrfail ? "Fails" : "Passes");

    instrfail = 0;
    _asm
    {
	VERW sel
	JZ verwpass
	MOV instrfail, 1
verwpass:
    }
    printf("%s VERW test\n", instrfail ? "Fails" : "Passes");

    instrfail = 0;
    _asm
    {
	MOV AX, DS
	MOV ES, AX
	LEA DI, desc[0]
	MOV AX, 0Bh
	MOV BX, sel
	INT 31h
	JNC getpass
	MOV instrfail, 1
getpass:
    }
    if (!instrfail)
	printf("The descriptor bytes are %02X %02X %02X %02X %02X %02X %02X %02X\n",
	       desc[0], desc[1], desc[2], desc[3], desc[4], desc[5], desc[6], desc[7]);
    else
	printf("Unable to get the descriptor bytes thru INT 31h API\n");
    return;
}
