#ifndef         NET_SERVER_POWER_DEMO_H
#define         NET_SERVER_POWER_DEMO_H

/*******************/
/* Include headers */
/*******************/

#include "nucleus.h"
#include "kernel/nu_kernel.h"
#include "networking/nu_networking.h"
#include "services/nu_services.h"
#include "drivers/nu_drivers.h"

/*********************/
/* MACRO Definitions */
/*********************/

/* Task management macros */
#define TASK_STACK_SIZE        8192
#define TASK_PRIORITY          31
#define TASK_TIMESLICE         0

/* Sever setting macros */
#define  DEMO_IFACE_NAME       "eth0"
#define  PORT_NUM              8080         /* Port number for server. */
#define  BUF_SIZE              4096         /* Size of workspace buffer. */
#define  AUX_BUF_SIZE          500          /* Size of auxillary buffer. */
#define  FMT_SIZE              24           /* Size of format string. */
#define  STATUS_FAILURE        -1           /* The operation failed. */

/* Power management macros */
#define	 NUM_SYS_STATES        2
#define	 SYS_STATE_0           0
#define	 SYS_STATE_1           1
#define	 STATE_ON              255
#define  STATE_OFF             0
#define	 STATE_INIT            0
#define	 STATE_SWT_SS0         1
#define	 STATE_SWT_SS1         2
#define	 STATE_SWT_OP          3

/*******************/
/* Data structures */
/*******************/

struct	_demo_params_{

	CHAR	host_ip[24];
	CHAR	target_ip[24];
	UINT32	cpu_util;
	CHAR	ss0url[35];
	CHAR	ss1url[35];
	UINT8	num_op_points;
	CHAR	opurls[140];
	UINT8	curr_op;
	UINT8	curr_ss;
};

typedef struct _demo_params_ DEMO_PARAMETERS;


/* Macros for HTML content */
#define	HTML_PAGE "HTTP/1.0 200 OK\r\nContent-Type:text/html\r\n\r\n                            \
        <div><p><b>Nucleus Power Services Demonstration<p></p></b></p><p></p><p>		        \
		________________________________________________<p></p></p><p></p>						\
		<p><b>Target and Host IP addresses<p></p></b></p>										\
		<p></p><table border=\"1\" cellspacing=\"0\" cellpadding=\"0\">							\
		<tbody><tr><td width=\"319\" valign=\"top\"><p>Host IP<p></p></p>						\
		</td><td width=\"319\" valign=\"top\"><p>%s<p></p></p>									\
		</td></tr><tr><td width=\"319\" valign=\"top\"><p>Target IP<p></p></p>					\
		</td><td width=\"319\" valign=\"top\"><p>%s<p></p></p>									\
		</td></tr></tbody></table><p><p></p></p><p></p><p><b>CPU Utilization<p></p>				\
		</b></p><p></p><table border=\"1\" cellspacing=\"0\" cellpadding=\"0\">					\
		<tbody><tr><td width=\"319\" valign=\"top\"><p>CPU Utilization in %%<p></p></p>			\
		</td><td width=\"319\" valign=\"top\"><p>%d<p></p></p></td></tr>						\
		</td></tr><tr><td width=\"319\" valign=\"top\"><p>Current operating point <p></p></p>	\
		</td><td width=\"319\" valign=\"top\"><p>%d<p></p></p></td></tr>						\
		</td></tr><tr><td width=\"319\" valign=\"top\"><p>Current system state <p></p></p>		\
		</td><td width=\"319\" valign=\"top\"><p>%d<p></p></p>									\
		</td></tr></tbody></table><p><p></p></p><p></p>											\
		<p><b>Peripherals and their states<p></p></b></p>										\
		<p></p><table border=\"1\" cellspacing=\"0\" cellpadding=\"0\">							\
		<tbody><tr><td width=\"213\" valign=\"top\">											\
		<p>Serial<p></p></p></td><td width=\"213\" valign=\"top\"><p>ON<p></p></p>				\
		</td><td width=\"213\" valign=\"top\"><p>OFF<p></p></p>									\
		</td></tr><tr><td width=\"213\" valign=\"top\"><p>Ethernet<p></p></p>					\
		</td><td width=\"213\" valign=\"top\"><p>ON<p></p></p>									\
		</td><td width=\"213\" valign=\"top\"><p>OFF<p></p></p>									\
		</td></tr></tbody></table><p><p></p></p><p></p><p><b>System states<p></p></b></p>		\
		<p></p><table border=\"1\" cellspacing=\"0\" cellpadding=\"0\">							\
		<tbody><tr><td width=\"213\" valign=\"top\"><p><p></p></p>								\
		</td><td width=\"213\" valign=\"top\"><p>Serial<p></p></p>								\
		</td><td width=\"213\" valign=\"top\"><p>Ethernet<p></p></p>							\
		</td></tr><tr><td width=\"213\"valign=\"top\">											\
		<p><a href=\"%s\">System State SS0</a><p></p></p>										\
		</td><td width=\"213\" valign=\"top\"><p>ON<p></p></p>									\
		</td><td width=\"213\" valign=\"top\"><p>ON<p></p></p>									\
		</td></tr><tr><td width=\"213\" valign=\"top\">											\
		<p><a href=\"%s\">System State SS1</a><p></p></p>										\
		</td><td width=\"213\" valign=\"top\"><p>OFF<p></p></p>									\
		</td><td width=\"213\" valign=\"top\"><p>ON<p></p></p>									\
		</td></tr></tbody></table><p><p></p></p><p></p><p><b>Operating points<p></p></b></p>	\
		<p></p><table border=\"1\" cellspacing=\"0\" cellpadding=\"0\">							\
		<tbody><tr><td width=\"319\" valign=\"top\">											\
		<p>Number of operating points<p></p></p>												\
		</td><td width=\"319\"valign=\"top\"><p>%d<p></p></p>									\
		</td></tr></tbody></table><p><b><p></p></b></p><p></p><div>%s"


#define	OP_POINTS	"<div><p><a href=\"%s\">Switch to operating point %d</a><p></p></p><p></p><div>"

/*********************************/
/* External function definitions */
/*********************************/

STATUS	Enable_Device_Power_State(DV_DEV_LABEL dev_label[]);
STATUS	System_Power_Mgmt_Init(DEMO_PARAMETERS* p_demo_params);
STATUS	Process_Request(CHAR* state_string, DEMO_PARAMETERS* p_demo_params);

#endif  /* SIMPLE_SERVER_DEMO_POWER_MGMT_H */
