/*************************************************************************/
/*                                                                       */
/*               Copyright 1993 Mentor Graphics Corporation              */
/*                         All Rights Reserved.                          */
/*                                                                       */
/* THIS WORK CONTAINS TRADE SECRET AND PROPRIETARY INFORMATION WHICH IS  */
/* THE PROPERTY OF MENTOR GRAPHICS CORPORATION OR ITS LICENSORS AND IS   */
/* SUBJECT TO LICENSE TERMS.                                             */
/*                                                                       */
/*************************************************************************/
/*************************************************************************
* FILE NAME
*                                                                       
*       cp936.c
*                                                                       
* COMPONENT                                                             
*                                                                       
*       CP
*                                                                       
* DESCRIPTION                                                           
*                                                                       
*       Data tables used for converting a character from codepage 936 
*       format to Unicode and vice versa.
*                                                                       
* 
* FUNCTIONS                                                             
*
*       None.
*
*************************************************************************/

#include "storage/pcdisk.h"
#if (CFG_NU_OS_STOR_FILE_VFS_INCLUDE_CP_SUPPORT == 1)

#define CP936_CP_IDX_NULL     0x0000
#define CP936_CP_VAL_NULL     0x0000
#define CP936_UNI_IDX_NULL    0x0000
#define CP936_UNI_VAL_NULL    0x0000

UINT16 cp936_CP_a0x0[] = {
    0x0,
    0x1,
    0x2,
    0x3,
    0x4,
    0x5,
    0x6,
    0x7,
    0x8,
    0x9,
    0xa,
    0xb,
    0xc,
    0xd,
    0xe,
    0xf,
    0x10,
    0x11,
    0x12,
    0x13,
    0x14,
    0x15,
    0x16,
    0x17,
    0x18,
    0x19,
    0x1a,
    0x1b,
    0x1c,
    0x1d,
    0x1e,
    0x1f,
    0x20,
    0x21,
    0x22,
    0x23,
    0x24,
    0x25,
    0x26,
    0x27,
    0x28,
    0x29,
    0x2a,
    0x2b,
    0x2c,
    0x2d,
    0x2e,
    0x2f,
    0x30,
    0x31,
    0x32,
    0x33,
    0x34,
    0x35,
    0x36,
    0x37,
    0x38,
    0x39,
    0x3a,
    0x3b,
    0x3c,
    0x3d,
    0x3e,
    0x3f,
    0x40,
    0x41,
    0x42,
    0x43,
    0x44,
    0x45,
    0x46,
    0x47,
    0x48,
    0x49,
    0x4a,
    0x4b,
    0x4c,
    0x4d,
    0x4e,
    0x4f,
    0x50,
    0x51,
    0x52,
    0x53,
    0x54,
    0x55,
    0x56,
    0x57,
    0x58,
    0x59,
    0x5a,
    0x5b,
    0x5c,
    0x5d,
    0x5e,
    0x5f,
    0x60,
    0x61,
    0x62,
    0x63,
    0x64,
    0x65,
    0x66,
    0x67,
    0x68,
    0x69,
    0x6a,
    0x6b,
    0x6c,
    0x6d,
    0x6e,
    0x6f,
    0x70,
    0x71,
    0x72,
    0x73,
    0x74,
    0x75,
    0x76,
    0x77,
    0x78,
    0x79,
    0x7a,
    0x7b,
    0x7c,
    0x7d,
    0x7e,
    0x7f,
    0x20ac,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0x81[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x4e02,
    0x4e04,
    0x4e05,
    0x4e06,
    0x4e0f,
    0x4e12,
    0x4e17,
    0x4e1f,
    0x4e20,
    0x4e21,
    0x4e23,
    0x4e26,
    0x4e29,
    0x4e2e,
    0x4e2f,
    0x4e31,
    0x4e33,
    0x4e35,
    0x4e37,
    0x4e3c,
    0x4e40,
    0x4e41,
    0x4e42,
    0x4e44,
    0x4e46,
    0x4e4a,
    0x4e51,
    0x4e55,
    0x4e57,
    0x4e5a,
    0x4e5b,
    0x4e62,
    0x4e63,
    0x4e64,
    0x4e65,
    0x4e67,
    0x4e68,
    0x4e6a,
    0x4e6b,
    0x4e6c,
    0x4e6d,
    0x4e6e,
    0x4e6f,
    0x4e72,
    0x4e74,
    0x4e75,
    0x4e76,
    0x4e77,
    0x4e78,
    0x4e79,
    0x4e7a,
    0x4e7b,
    0x4e7c,
    0x4e7d,
    0x4e7f,
    0x4e80,
    0x4e81,
    0x4e82,
    0x4e83,
    0x4e84,
    0x4e85,
    0x4e87,
    0x4e8a,
    CP936_CP_VAL_NULL,
    0x4e90,
    0x4e96,
    0x4e97,
    0x4e99,
    0x4e9c,
    0x4e9d,
    0x4e9e,
    0x4ea3,
    0x4eaa,
    0x4eaf,
    0x4eb0,
    0x4eb1,
    0x4eb4,
    0x4eb6,
    0x4eb7,
    0x4eb8,
    0x4eb9,
    0x4ebc,
    0x4ebd,
    0x4ebe,
    0x4ec8,
    0x4ecc,
    0x4ecf,
    0x4ed0,
    0x4ed2,
    0x4eda,
    0x4edb,
    0x4edc,
    0x4ee0,
    0x4ee2,
    0x4ee6,
    0x4ee7,
    0x4ee9,
    0x4eed,
    0x4eee,
    0x4eef,
    0x4ef1,
    0x4ef4,
    0x4ef8,
    0x4ef9,
    0x4efa,
    0x4efc,
    0x4efe,
    0x4f00,
    0x4f02,
    0x4f03,
    0x4f04,
    0x4f05,
    0x4f06,
    0x4f07,
    0x4f08,
    0x4f0b,
    0x4f0c,
    0x4f12,
    0x4f13,
    0x4f14,
    0x4f15,
    0x4f16,
    0x4f1c,
    0x4f1d,
    0x4f21,
    0x4f23,
    0x4f28,
    0x4f29,
    0x4f2c,
    0x4f2d,
    0x4f2e,
    0x4f31,
    0x4f33,
    0x4f35,
    0x4f37,
    0x4f39,
    0x4f3b,
    0x4f3e,
    0x4f3f,
    0x4f40,
    0x4f41,
    0x4f42,
    0x4f44,
    0x4f45,
    0x4f47,
    0x4f48,
    0x4f49,
    0x4f4a,
    0x4f4b,
    0x4f4c,
    0x4f52,
    0x4f54,
    0x4f56,
    0x4f61,
    0x4f62,
    0x4f66,
    0x4f68,
    0x4f6a,
    0x4f6b,
    0x4f6d,
    0x4f6e,
    0x4f71,
    0x4f72,
    0x4f75,
    0x4f77,
    0x4f78,
    0x4f79,
    0x4f7a,
    0x4f7d,
    0x4f80,
    0x4f81,
    0x4f82,
    0x4f85,
    0x4f86,
    0x4f87,
    0x4f8a,
    0x4f8c,
    0x4f8e,
    0x4f90,
    0x4f92,
    0x4f93,
    0x4f95,
    0x4f96,
    0x4f98,
    0x4f99,
    0x4f9a,
    0x4f9c,
    0x4f9e,
    0x4f9f,
    0x4fa1,
    0x4fa2,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0x82[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x4fa4,
    0x4fab,
    0x4fad,
    0x4fb0,
    0x4fb1,
    0x4fb2,
    0x4fb3,
    0x4fb4,
    0x4fb6,
    0x4fb7,
    0x4fb8,
    0x4fb9,
    0x4fba,
    0x4fbb,
    0x4fbc,
    0x4fbd,
    0x4fbe,
    0x4fc0,
    0x4fc1,
    0x4fc2,
    0x4fc6,
    0x4fc7,
    0x4fc8,
    0x4fc9,
    0x4fcb,
    0x4fcc,
    0x4fcd,
    0x4fd2,
    0x4fd3,
    0x4fd4,
    0x4fd5,
    0x4fd6,
    0x4fd9,
    0x4fdb,
    0x4fe0,
    0x4fe2,
    0x4fe4,
    0x4fe5,
    0x4fe7,
    0x4feb,
    0x4fec,
    0x4ff0,
    0x4ff2,
    0x4ff4,
    0x4ff5,
    0x4ff6,
    0x4ff7,
    0x4ff9,
    0x4ffb,
    0x4ffc,
    0x4ffd,
    0x4fff,
    0x5000,
    0x5001,
    0x5002,
    0x5003,
    0x5004,
    0x5005,
    0x5006,
    0x5007,
    0x5008,
    0x5009,
    0x500a,
    CP936_CP_VAL_NULL,
    0x500b,
    0x500e,
    0x5010,
    0x5011,
    0x5013,
    0x5015,
    0x5016,
    0x5017,
    0x501b,
    0x501d,
    0x501e,
    0x5020,
    0x5022,
    0x5023,
    0x5024,
    0x5027,
    0x502b,
    0x502f,
    0x5030,
    0x5031,
    0x5032,
    0x5033,
    0x5034,
    0x5035,
    0x5036,
    0x5037,
    0x5038,
    0x5039,
    0x503b,
    0x503d,
    0x503f,
    0x5040,
    0x5041,
    0x5042,
    0x5044,
    0x5045,
    0x5046,
    0x5049,
    0x504a,
    0x504b,
    0x504d,
    0x5050,
    0x5051,
    0x5052,
    0x5053,
    0x5054,
    0x5056,
    0x5057,
    0x5058,
    0x5059,
    0x505b,
    0x505d,
    0x505e,
    0x505f,
    0x5060,
    0x5061,
    0x5062,
    0x5063,
    0x5064,
    0x5066,
    0x5067,
    0x5068,
    0x5069,
    0x506a,
    0x506b,
    0x506d,
    0x506e,
    0x506f,
    0x5070,
    0x5071,
    0x5072,
    0x5073,
    0x5074,
    0x5075,
    0x5078,
    0x5079,
    0x507a,
    0x507c,
    0x507d,
    0x5081,
    0x5082,
    0x5083,
    0x5084,
    0x5086,
    0x5087,
    0x5089,
    0x508a,
    0x508b,
    0x508c,
    0x508e,
    0x508f,
    0x5090,
    0x5091,
    0x5092,
    0x5093,
    0x5094,
    0x5095,
    0x5096,
    0x5097,
    0x5098,
    0x5099,
    0x509a,
    0x509b,
    0x509c,
    0x509d,
    0x509e,
    0x509f,
    0x50a0,
    0x50a1,
    0x50a2,
    0x50a4,
    0x50a6,
    0x50aa,
    0x50ab,
    0x50ad,
    0x50ae,
    0x50af,
    0x50b0,
    0x50b1,
    0x50b3,
    0x50b4,
    0x50b5,
    0x50b6,
    0x50b7,
    0x50b8,
    0x50b9,
    0x50bc,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0x83[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x50bd,
    0x50be,
    0x50bf,
    0x50c0,
    0x50c1,
    0x50c2,
    0x50c3,
    0x50c4,
    0x50c5,
    0x50c6,
    0x50c7,
    0x50c8,
    0x50c9,
    0x50ca,
    0x50cb,
    0x50cc,
    0x50cd,
    0x50ce,
    0x50d0,
    0x50d1,
    0x50d2,
    0x50d3,
    0x50d4,
    0x50d5,
    0x50d7,
    0x50d8,
    0x50d9,
    0x50db,
    0x50dc,
    0x50dd,
    0x50de,
    0x50df,
    0x50e0,
    0x50e1,
    0x50e2,
    0x50e3,
    0x50e4,
    0x50e5,
    0x50e8,
    0x50e9,
    0x50ea,
    0x50eb,
    0x50ef,
    0x50f0,
    0x50f1,
    0x50f2,
    0x50f4,
    0x50f6,
    0x50f7,
    0x50f8,
    0x50f9,
    0x50fa,
    0x50fc,
    0x50fd,
    0x50fe,
    0x50ff,
    0x5100,
    0x5101,
    0x5102,
    0x5103,
    0x5104,
    0x5105,
    0x5108,
    CP936_CP_VAL_NULL,
    0x5109,
    0x510a,
    0x510c,
    0x510d,
    0x510e,
    0x510f,
    0x5110,
    0x5111,
    0x5113,
    0x5114,
    0x5115,
    0x5116,
    0x5117,
    0x5118,
    0x5119,
    0x511a,
    0x511b,
    0x511c,
    0x511d,
    0x511e,
    0x511f,
    0x5120,
    0x5122,
    0x5123,
    0x5124,
    0x5125,
    0x5126,
    0x5127,
    0x5128,
    0x5129,
    0x512a,
    0x512b,
    0x512c,
    0x512d,
    0x512e,
    0x512f,
    0x5130,
    0x5131,
    0x5132,
    0x5133,
    0x5134,
    0x5135,
    0x5136,
    0x5137,
    0x5138,
    0x5139,
    0x513a,
    0x513b,
    0x513c,
    0x513d,
    0x513e,
    0x5142,
    0x5147,
    0x514a,
    0x514c,
    0x514e,
    0x514f,
    0x5150,
    0x5152,
    0x5153,
    0x5157,
    0x5158,
    0x5159,
    0x515b,
    0x515d,
    0x515e,
    0x515f,
    0x5160,
    0x5161,
    0x5163,
    0x5164,
    0x5166,
    0x5167,
    0x5169,
    0x516a,
    0x516f,
    0x5172,
    0x517a,
    0x517e,
    0x517f,
    0x5183,
    0x5184,
    0x5186,
    0x5187,
    0x518a,
    0x518b,
    0x518e,
    0x518f,
    0x5190,
    0x5191,
    0x5193,
    0x5194,
    0x5198,
    0x519a,
    0x519d,
    0x519e,
    0x519f,
    0x51a1,
    0x51a3,
    0x51a6,
    0x51a7,
    0x51a8,
    0x51a9,
    0x51aa,
    0x51ad,
    0x51ae,
    0x51b4,
    0x51b8,
    0x51b9,
    0x51ba,
    0x51be,
    0x51bf,
    0x51c1,
    0x51c2,
    0x51c3,
    0x51c5,
    0x51c8,
    0x51ca,
    0x51cd,
    0x51ce,
    0x51d0,
    0x51d2,
    0x51d3,
    0x51d4,
    0x51d5,
    0x51d6,
    0x51d7,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0x84[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x51d8,
    0x51d9,
    0x51da,
    0x51dc,
    0x51de,
    0x51df,
    0x51e2,
    0x51e3,
    0x51e5,
    0x51e6,
    0x51e7,
    0x51e8,
    0x51e9,
    0x51ea,
    0x51ec,
    0x51ee,
    0x51f1,
    0x51f2,
    0x51f4,
    0x51f7,
    0x51fe,
    0x5204,
    0x5205,
    0x5209,
    0x520b,
    0x520c,
    0x520f,
    0x5210,
    0x5213,
    0x5214,
    0x5215,
    0x521c,
    0x521e,
    0x521f,
    0x5221,
    0x5222,
    0x5223,
    0x5225,
    0x5226,
    0x5227,
    0x522a,
    0x522c,
    0x522f,
    0x5231,
    0x5232,
    0x5234,
    0x5235,
    0x523c,
    0x523e,
    0x5244,
    0x5245,
    0x5246,
    0x5247,
    0x5248,
    0x5249,
    0x524b,
    0x524e,
    0x524f,
    0x5252,
    0x5253,
    0x5255,
    0x5257,
    0x5258,
    CP936_CP_VAL_NULL,
    0x5259,
    0x525a,
    0x525b,
    0x525d,
    0x525f,
    0x5260,
    0x5262,
    0x5263,
    0x5264,
    0x5266,
    0x5268,
    0x526b,
    0x526c,
    0x526d,
    0x526e,
    0x5270,
    0x5271,
    0x5273,
    0x5274,
    0x5275,
    0x5276,
    0x5277,
    0x5278,
    0x5279,
    0x527a,
    0x527b,
    0x527c,
    0x527e,
    0x5280,
    0x5283,
    0x5284,
    0x5285,
    0x5286,
    0x5287,
    0x5289,
    0x528a,
    0x528b,
    0x528c,
    0x528d,
    0x528e,
    0x528f,
    0x5291,
    0x5292,
    0x5294,
    0x5295,
    0x5296,
    0x5297,
    0x5298,
    0x5299,
    0x529a,
    0x529c,
    0x52a4,
    0x52a5,
    0x52a6,
    0x52a7,
    0x52ae,
    0x52af,
    0x52b0,
    0x52b4,
    0x52b5,
    0x52b6,
    0x52b7,
    0x52b8,
    0x52b9,
    0x52ba,
    0x52bb,
    0x52bc,
    0x52bd,
    0x52c0,
    0x52c1,
    0x52c2,
    0x52c4,
    0x52c5,
    0x52c6,
    0x52c8,
    0x52ca,
    0x52cc,
    0x52cd,
    0x52ce,
    0x52cf,
    0x52d1,
    0x52d3,
    0x52d4,
    0x52d5,
    0x52d7,
    0x52d9,
    0x52da,
    0x52db,
    0x52dc,
    0x52dd,
    0x52de,
    0x52e0,
    0x52e1,
    0x52e2,
    0x52e3,
    0x52e5,
    0x52e6,
    0x52e7,
    0x52e8,
    0x52e9,
    0x52ea,
    0x52eb,
    0x52ec,
    0x52ed,
    0x52ee,
    0x52ef,
    0x52f1,
    0x52f2,
    0x52f3,
    0x52f4,
    0x52f5,
    0x52f6,
    0x52f7,
    0x52f8,
    0x52fb,
    0x52fc,
    0x52fd,
    0x5301,
    0x5302,
    0x5303,
    0x5304,
    0x5307,
    0x5309,
    0x530a,
    0x530b,
    0x530c,
    0x530e,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0x85[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x5311,
    0x5312,
    0x5313,
    0x5314,
    0x5318,
    0x531b,
    0x531c,
    0x531e,
    0x531f,
    0x5322,
    0x5324,
    0x5325,
    0x5327,
    0x5328,
    0x5329,
    0x532b,
    0x532c,
    0x532d,
    0x532f,
    0x5330,
    0x5331,
    0x5332,
    0x5333,
    0x5334,
    0x5335,
    0x5336,
    0x5337,
    0x5338,
    0x533c,
    0x533d,
    0x5340,
    0x5342,
    0x5344,
    0x5346,
    0x534b,
    0x534c,
    0x534d,
    0x5350,
    0x5354,
    0x5358,
    0x5359,
    0x535b,
    0x535d,
    0x5365,
    0x5368,
    0x536a,
    0x536c,
    0x536d,
    0x5372,
    0x5376,
    0x5379,
    0x537b,
    0x537c,
    0x537d,
    0x537e,
    0x5380,
    0x5381,
    0x5383,
    0x5387,
    0x5388,
    0x538a,
    0x538e,
    0x538f,
    CP936_CP_VAL_NULL,
    0x5390,
    0x5391,
    0x5392,
    0x5393,
    0x5394,
    0x5396,
    0x5397,
    0x5399,
    0x539b,
    0x539c,
    0x539e,
    0x53a0,
    0x53a1,
    0x53a4,
    0x53a7,
    0x53aa,
    0x53ab,
    0x53ac,
    0x53ad,
    0x53af,
    0x53b0,
    0x53b1,
    0x53b2,
    0x53b3,
    0x53b4,
    0x53b5,
    0x53b7,
    0x53b8,
    0x53b9,
    0x53ba,
    0x53bc,
    0x53bd,
    0x53be,
    0x53c0,
    0x53c3,
    0x53c4,
    0x53c5,
    0x53c6,
    0x53c7,
    0x53ce,
    0x53cf,
    0x53d0,
    0x53d2,
    0x53d3,
    0x53d5,
    0x53da,
    0x53dc,
    0x53dd,
    0x53de,
    0x53e1,
    0x53e2,
    0x53e7,
    0x53f4,
    0x53fa,
    0x53fe,
    0x53ff,
    0x5400,
    0x5402,
    0x5405,
    0x5407,
    0x540b,
    0x5414,
    0x5418,
    0x5419,
    0x541a,
    0x541c,
    0x5422,
    0x5424,
    0x5425,
    0x542a,
    0x5430,
    0x5433,
    0x5436,
    0x5437,
    0x543a,
    0x543d,
    0x543f,
    0x5441,
    0x5442,
    0x5444,
    0x5445,
    0x5447,
    0x5449,
    0x544c,
    0x544d,
    0x544e,
    0x544f,
    0x5451,
    0x545a,
    0x545d,
    0x545e,
    0x545f,
    0x5460,
    0x5461,
    0x5463,
    0x5465,
    0x5467,
    0x5469,
    0x546a,
    0x546b,
    0x546c,
    0x546d,
    0x546e,
    0x546f,
    0x5470,
    0x5474,
    0x5479,
    0x547a,
    0x547e,
    0x547f,
    0x5481,
    0x5483,
    0x5485,
    0x5487,
    0x5488,
    0x5489,
    0x548a,
    0x548d,
    0x5491,
    0x5493,
    0x5497,
    0x5498,
    0x549c,
    0x549e,
    0x549f,
    0x54a0,
    0x54a1,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0x86[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x54a2,
    0x54a5,
    0x54ae,
    0x54b0,
    0x54b2,
    0x54b5,
    0x54b6,
    0x54b7,
    0x54b9,
    0x54ba,
    0x54bc,
    0x54be,
    0x54c3,
    0x54c5,
    0x54ca,
    0x54cb,
    0x54d6,
    0x54d8,
    0x54db,
    0x54e0,
    0x54e1,
    0x54e2,
    0x54e3,
    0x54e4,
    0x54eb,
    0x54ec,
    0x54ef,
    0x54f0,
    0x54f1,
    0x54f4,
    0x54f5,
    0x54f6,
    0x54f7,
    0x54f8,
    0x54f9,
    0x54fb,
    0x54fe,
    0x5500,
    0x5502,
    0x5503,
    0x5504,
    0x5505,
    0x5508,
    0x550a,
    0x550b,
    0x550c,
    0x550d,
    0x550e,
    0x5512,
    0x5513,
    0x5515,
    0x5516,
    0x5517,
    0x5518,
    0x5519,
    0x551a,
    0x551c,
    0x551d,
    0x551e,
    0x551f,
    0x5521,
    0x5525,
    0x5526,
    CP936_CP_VAL_NULL,
    0x5528,
    0x5529,
    0x552b,
    0x552d,
    0x5532,
    0x5534,
    0x5535,
    0x5536,
    0x5538,
    0x5539,
    0x553a,
    0x553b,
    0x553d,
    0x5540,
    0x5542,
    0x5545,
    0x5547,
    0x5548,
    0x554b,
    0x554c,
    0x554d,
    0x554e,
    0x554f,
    0x5551,
    0x5552,
    0x5553,
    0x5554,
    0x5557,
    0x5558,
    0x5559,
    0x555a,
    0x555b,
    0x555d,
    0x555e,
    0x555f,
    0x5560,
    0x5562,
    0x5563,
    0x5568,
    0x5569,
    0x556b,
    0x556f,
    0x5570,
    0x5571,
    0x5572,
    0x5573,
    0x5574,
    0x5579,
    0x557a,
    0x557d,
    0x557f,
    0x5585,
    0x5586,
    0x558c,
    0x558d,
    0x558e,
    0x5590,
    0x5592,
    0x5593,
    0x5595,
    0x5596,
    0x5597,
    0x559a,
    0x559b,
    0x559e,
    0x55a0,
    0x55a1,
    0x55a2,
    0x55a3,
    0x55a4,
    0x55a5,
    0x55a6,
    0x55a8,
    0x55a9,
    0x55aa,
    0x55ab,
    0x55ac,
    0x55ad,
    0x55ae,
    0x55af,
    0x55b0,
    0x55b2,
    0x55b4,
    0x55b6,
    0x55b8,
    0x55ba,
    0x55bc,
    0x55bf,
    0x55c0,
    0x55c1,
    0x55c2,
    0x55c3,
    0x55c6,
    0x55c7,
    0x55c8,
    0x55ca,
    0x55cb,
    0x55ce,
    0x55cf,
    0x55d0,
    0x55d5,
    0x55d7,
    0x55d8,
    0x55d9,
    0x55da,
    0x55db,
    0x55de,
    0x55e0,
    0x55e2,
    0x55e7,
    0x55e9,
    0x55ed,
    0x55ee,
    0x55f0,
    0x55f1,
    0x55f4,
    0x55f6,
    0x55f8,
    0x55f9,
    0x55fa,
    0x55fb,
    0x55fc,
    0x55ff,
    0x5602,
    0x5603,
    0x5604,
    0x5605,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0x87[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x5606,
    0x5607,
    0x560a,
    0x560b,
    0x560d,
    0x5610,
    0x5611,
    0x5612,
    0x5613,
    0x5614,
    0x5615,
    0x5616,
    0x5617,
    0x5619,
    0x561a,
    0x561c,
    0x561d,
    0x5620,
    0x5621,
    0x5622,
    0x5625,
    0x5626,
    0x5628,
    0x5629,
    0x562a,
    0x562b,
    0x562e,
    0x562f,
    0x5630,
    0x5633,
    0x5635,
    0x5637,
    0x5638,
    0x563a,
    0x563c,
    0x563d,
    0x563e,
    0x5640,
    0x5641,
    0x5642,
    0x5643,
    0x5644,
    0x5645,
    0x5646,
    0x5647,
    0x5648,
    0x5649,
    0x564a,
    0x564b,
    0x564f,
    0x5650,
    0x5651,
    0x5652,
    0x5653,
    0x5655,
    0x5656,
    0x565a,
    0x565b,
    0x565d,
    0x565e,
    0x565f,
    0x5660,
    0x5661,
    CP936_CP_VAL_NULL,
    0x5663,
    0x5665,
    0x5666,
    0x5667,
    0x566d,
    0x566e,
    0x566f,
    0x5670,
    0x5672,
    0x5673,
    0x5674,
    0x5675,
    0x5677,
    0x5678,
    0x5679,
    0x567a,
    0x567d,
    0x567e,
    0x567f,
    0x5680,
    0x5681,
    0x5682,
    0x5683,
    0x5684,
    0x5687,
    0x5688,
    0x5689,
    0x568a,
    0x568b,
    0x568c,
    0x568d,
    0x5690,
    0x5691,
    0x5692,
    0x5694,
    0x5695,
    0x5696,
    0x5697,
    0x5698,
    0x5699,
    0x569a,
    0x569b,
    0x569c,
    0x569d,
    0x569e,
    0x569f,
    0x56a0,
    0x56a1,
    0x56a2,
    0x56a4,
    0x56a5,
    0x56a6,
    0x56a7,
    0x56a8,
    0x56a9,
    0x56aa,
    0x56ab,
    0x56ac,
    0x56ad,
    0x56ae,
    0x56b0,
    0x56b1,
    0x56b2,
    0x56b3,
    0x56b4,
    0x56b5,
    0x56b6,
    0x56b8,
    0x56b9,
    0x56ba,
    0x56bb,
    0x56bd,
    0x56be,
    0x56bf,
    0x56c0,
    0x56c1,
    0x56c2,
    0x56c3,
    0x56c4,
    0x56c5,
    0x56c6,
    0x56c7,
    0x56c8,
    0x56c9,
    0x56cb,
    0x56cc,
    0x56cd,
    0x56ce,
    0x56cf,
    0x56d0,
    0x56d1,
    0x56d2,
    0x56d3,
    0x56d5,
    0x56d6,
    0x56d8,
    0x56d9,
    0x56dc,
    0x56e3,
    0x56e5,
    0x56e6,
    0x56e7,
    0x56e8,
    0x56e9,
    0x56ea,
    0x56ec,
    0x56ee,
    0x56ef,
    0x56f2,
    0x56f3,
    0x56f6,
    0x56f7,
    0x56f8,
    0x56fb,
    0x56fc,
    0x5700,
    0x5701,
    0x5702,
    0x5705,
    0x5707,
    0x570b,
    0x570c,
    0x570d,
    0x570e,
    0x570f,
    0x5710,
    0x5711,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0x88[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x5712,
    0x5713,
    0x5714,
    0x5715,
    0x5716,
    0x5717,
    0x5718,
    0x5719,
    0x571a,
    0x571b,
    0x571d,
    0x571e,
    0x5720,
    0x5721,
    0x5722,
    0x5724,
    0x5725,
    0x5726,
    0x5727,
    0x572b,
    0x5731,
    0x5732,
    0x5734,
    0x5735,
    0x5736,
    0x5737,
    0x5738,
    0x573c,
    0x573d,
    0x573f,
    0x5741,
    0x5743,
    0x5744,
    0x5745,
    0x5746,
    0x5748,
    0x5749,
    0x574b,
    0x5752,
    0x5753,
    0x5754,
    0x5755,
    0x5756,
    0x5758,
    0x5759,
    0x5762,
    0x5763,
    0x5765,
    0x5767,
    0x576c,
    0x576e,
    0x5770,
    0x5771,
    0x5772,
    0x5774,
    0x5775,
    0x5778,
    0x5779,
    0x577a,
    0x577d,
    0x577e,
    0x577f,
    0x5780,
    CP936_CP_VAL_NULL,
    0x5781,
    0x5787,
    0x5788,
    0x5789,
    0x578a,
    0x578d,
    0x578e,
    0x578f,
    0x5790,
    0x5791,
    0x5794,
    0x5795,
    0x5796,
    0x5797,
    0x5798,
    0x5799,
    0x579a,
    0x579c,
    0x579d,
    0x579e,
    0x579f,
    0x57a5,
    0x57a8,
    0x57aa,
    0x57ac,
    0x57af,
    0x57b0,
    0x57b1,
    0x57b3,
    0x57b5,
    0x57b6,
    0x57b7,
    0x57b9,
    0x57ba,
    0x57bb,
    0x57bc,
    0x57bd,
    0x57be,
    0x57bf,
    0x57c0,
    0x57c1,
    0x57c4,
    0x57c5,
    0x57c6,
    0x57c7,
    0x57c8,
    0x57c9,
    0x57ca,
    0x57cc,
    0x57cd,
    0x57d0,
    0x57d1,
    0x57d3,
    0x57d6,
    0x57d7,
    0x57db,
    0x57dc,
    0x57de,
    0x57e1,
    0x57e2,
    0x57e3,
    0x57e5,
    0x57e6,
    0x57e7,
    0x57e8,
    0x57e9,
    0x57ea,
    0x57eb,
    0x57ec,
    0x57ee,
    0x57f0,
    0x57f1,
    0x57f2,
    0x57f3,
    0x57f5,
    0x57f6,
    0x57f7,
    0x57fb,
    0x57fc,
    0x57fe,
    0x57ff,
    0x5801,
    0x5803,
    0x5804,
    0x5805,
    0x5808,
    0x5809,
    0x580a,
    0x580c,
    0x580e,
    0x580f,
    0x5810,
    0x5812,
    0x5813,
    0x5814,
    0x5816,
    0x5817,
    0x5818,
    0x581a,
    0x581b,
    0x581c,
    0x581d,
    0x581f,
    0x5822,
    0x5823,
    0x5825,
    0x5826,
    0x5827,
    0x5828,
    0x5829,
    0x582b,
    0x582c,
    0x582d,
    0x582e,
    0x582f,
    0x5831,
    0x5832,
    0x5833,
    0x5834,
    0x5836,
    0x5837,
    0x5838,
    0x5839,
    0x583a,
    0x583b,
    0x583c,
    0x583d,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0x89[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x583e,
    0x583f,
    0x5840,
    0x5841,
    0x5842,
    0x5843,
    0x5845,
    0x5846,
    0x5847,
    0x5848,
    0x5849,
    0x584a,
    0x584b,
    0x584e,
    0x584f,
    0x5850,
    0x5852,
    0x5853,
    0x5855,
    0x5856,
    0x5857,
    0x5859,
    0x585a,
    0x585b,
    0x585c,
    0x585d,
    0x585f,
    0x5860,
    0x5861,
    0x5862,
    0x5863,
    0x5864,
    0x5866,
    0x5867,
    0x5868,
    0x5869,
    0x586a,
    0x586d,
    0x586e,
    0x586f,
    0x5870,
    0x5871,
    0x5872,
    0x5873,
    0x5874,
    0x5875,
    0x5876,
    0x5877,
    0x5878,
    0x5879,
    0x587a,
    0x587b,
    0x587c,
    0x587d,
    0x587f,
    0x5882,
    0x5884,
    0x5886,
    0x5887,
    0x5888,
    0x588a,
    0x588b,
    0x588c,
    CP936_CP_VAL_NULL,
    0x588d,
    0x588e,
    0x588f,
    0x5890,
    0x5891,
    0x5894,
    0x5895,
    0x5896,
    0x5897,
    0x5898,
    0x589b,
    0x589c,
    0x589d,
    0x58a0,
    0x58a1,
    0x58a2,
    0x58a3,
    0x58a4,
    0x58a5,
    0x58a6,
    0x58a7,
    0x58aa,
    0x58ab,
    0x58ac,
    0x58ad,
    0x58ae,
    0x58af,
    0x58b0,
    0x58b1,
    0x58b2,
    0x58b3,
    0x58b4,
    0x58b5,
    0x58b6,
    0x58b7,
    0x58b8,
    0x58b9,
    0x58ba,
    0x58bb,
    0x58bd,
    0x58be,
    0x58bf,
    0x58c0,
    0x58c2,
    0x58c3,
    0x58c4,
    0x58c6,
    0x58c7,
    0x58c8,
    0x58c9,
    0x58ca,
    0x58cb,
    0x58cc,
    0x58cd,
    0x58ce,
    0x58cf,
    0x58d0,
    0x58d2,
    0x58d3,
    0x58d4,
    0x58d6,
    0x58d7,
    0x58d8,
    0x58d9,
    0x58da,
    0x58db,
    0x58dc,
    0x58dd,
    0x58de,
    0x58df,
    0x58e0,
    0x58e1,
    0x58e2,
    0x58e3,
    0x58e5,
    0x58e6,
    0x58e7,
    0x58e8,
    0x58e9,
    0x58ea,
    0x58ed,
    0x58ef,
    0x58f1,
    0x58f2,
    0x58f4,
    0x58f5,
    0x58f7,
    0x58f8,
    0x58fa,
    0x58fb,
    0x58fc,
    0x58fd,
    0x58fe,
    0x58ff,
    0x5900,
    0x5901,
    0x5903,
    0x5905,
    0x5906,
    0x5908,
    0x5909,
    0x590a,
    0x590b,
    0x590c,
    0x590e,
    0x5910,
    0x5911,
    0x5912,
    0x5913,
    0x5917,
    0x5918,
    0x591b,
    0x591d,
    0x591e,
    0x5920,
    0x5921,
    0x5922,
    0x5923,
    0x5926,
    0x5928,
    0x592c,
    0x5930,
    0x5932,
    0x5933,
    0x5935,
    0x5936,
    0x593b,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0x8a[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x593d,
    0x593e,
    0x593f,
    0x5940,
    0x5943,
    0x5945,
    0x5946,
    0x594a,
    0x594c,
    0x594d,
    0x5950,
    0x5952,
    0x5953,
    0x5959,
    0x595b,
    0x595c,
    0x595d,
    0x595e,
    0x595f,
    0x5961,
    0x5963,
    0x5964,
    0x5966,
    0x5967,
    0x5968,
    0x5969,
    0x596a,
    0x596b,
    0x596c,
    0x596d,
    0x596e,
    0x596f,
    0x5970,
    0x5971,
    0x5972,
    0x5975,
    0x5977,
    0x597a,
    0x597b,
    0x597c,
    0x597e,
    0x597f,
    0x5980,
    0x5985,
    0x5989,
    0x598b,
    0x598c,
    0x598e,
    0x598f,
    0x5990,
    0x5991,
    0x5994,
    0x5995,
    0x5998,
    0x599a,
    0x599b,
    0x599c,
    0x599d,
    0x599f,
    0x59a0,
    0x59a1,
    0x59a2,
    0x59a6,
    CP936_CP_VAL_NULL,
    0x59a7,
    0x59ac,
    0x59ad,
    0x59b0,
    0x59b1,
    0x59b3,
    0x59b4,
    0x59b5,
    0x59b6,
    0x59b7,
    0x59b8,
    0x59ba,
    0x59bc,
    0x59bd,
    0x59bf,
    0x59c0,
    0x59c1,
    0x59c2,
    0x59c3,
    0x59c4,
    0x59c5,
    0x59c7,
    0x59c8,
    0x59c9,
    0x59cc,
    0x59cd,
    0x59ce,
    0x59cf,
    0x59d5,
    0x59d6,
    0x59d9,
    0x59db,
    0x59de,
    0x59df,
    0x59e0,
    0x59e1,
    0x59e2,
    0x59e4,
    0x59e6,
    0x59e7,
    0x59e9,
    0x59ea,
    0x59eb,
    0x59ed,
    0x59ee,
    0x59ef,
    0x59f0,
    0x59f1,
    0x59f2,
    0x59f3,
    0x59f4,
    0x59f5,
    0x59f6,
    0x59f7,
    0x59f8,
    0x59fa,
    0x59fc,
    0x59fd,
    0x59fe,
    0x5a00,
    0x5a02,
    0x5a0a,
    0x5a0b,
    0x5a0d,
    0x5a0e,
    0x5a0f,
    0x5a10,
    0x5a12,
    0x5a14,
    0x5a15,
    0x5a16,
    0x5a17,
    0x5a19,
    0x5a1a,
    0x5a1b,
    0x5a1d,
    0x5a1e,
    0x5a21,
    0x5a22,
    0x5a24,
    0x5a26,
    0x5a27,
    0x5a28,
    0x5a2a,
    0x5a2b,
    0x5a2c,
    0x5a2d,
    0x5a2e,
    0x5a2f,
    0x5a30,
    0x5a33,
    0x5a35,
    0x5a37,
    0x5a38,
    0x5a39,
    0x5a3a,
    0x5a3b,
    0x5a3d,
    0x5a3e,
    0x5a3f,
    0x5a41,
    0x5a42,
    0x5a43,
    0x5a44,
    0x5a45,
    0x5a47,
    0x5a48,
    0x5a4b,
    0x5a4c,
    0x5a4d,
    0x5a4e,
    0x5a4f,
    0x5a50,
    0x5a51,
    0x5a52,
    0x5a53,
    0x5a54,
    0x5a56,
    0x5a57,
    0x5a58,
    0x5a59,
    0x5a5b,
    0x5a5c,
    0x5a5d,
    0x5a5e,
    0x5a5f,
    0x5a60,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0x8b[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x5a61,
    0x5a63,
    0x5a64,
    0x5a65,
    0x5a66,
    0x5a68,
    0x5a69,
    0x5a6b,
    0x5a6c,
    0x5a6d,
    0x5a6e,
    0x5a6f,
    0x5a70,
    0x5a71,
    0x5a72,
    0x5a73,
    0x5a78,
    0x5a79,
    0x5a7b,
    0x5a7c,
    0x5a7d,
    0x5a7e,
    0x5a80,
    0x5a81,
    0x5a82,
    0x5a83,
    0x5a84,
    0x5a85,
    0x5a86,
    0x5a87,
    0x5a88,
    0x5a89,
    0x5a8a,
    0x5a8b,
    0x5a8c,
    0x5a8d,
    0x5a8e,
    0x5a8f,
    0x5a90,
    0x5a91,
    0x5a93,
    0x5a94,
    0x5a95,
    0x5a96,
    0x5a97,
    0x5a98,
    0x5a99,
    0x5a9c,
    0x5a9d,
    0x5a9e,
    0x5a9f,
    0x5aa0,
    0x5aa1,
    0x5aa2,
    0x5aa3,
    0x5aa4,
    0x5aa5,
    0x5aa6,
    0x5aa7,
    0x5aa8,
    0x5aa9,
    0x5aab,
    0x5aac,
    CP936_CP_VAL_NULL,
    0x5aad,
    0x5aae,
    0x5aaf,
    0x5ab0,
    0x5ab1,
    0x5ab4,
    0x5ab6,
    0x5ab7,
    0x5ab9,
    0x5aba,
    0x5abb,
    0x5abc,
    0x5abd,
    0x5abf,
    0x5ac0,
    0x5ac3,
    0x5ac4,
    0x5ac5,
    0x5ac6,
    0x5ac7,
    0x5ac8,
    0x5aca,
    0x5acb,
    0x5acd,
    0x5ace,
    0x5acf,
    0x5ad0,
    0x5ad1,
    0x5ad3,
    0x5ad5,
    0x5ad7,
    0x5ad9,
    0x5ada,
    0x5adb,
    0x5add,
    0x5ade,
    0x5adf,
    0x5ae2,
    0x5ae4,
    0x5ae5,
    0x5ae7,
    0x5ae8,
    0x5aea,
    0x5aec,
    0x5aed,
    0x5aee,
    0x5aef,
    0x5af0,
    0x5af2,
    0x5af3,
    0x5af4,
    0x5af5,
    0x5af6,
    0x5af7,
    0x5af8,
    0x5af9,
    0x5afa,
    0x5afb,
    0x5afc,
    0x5afd,
    0x5afe,
    0x5aff,
    0x5b00,
    0x5b01,
    0x5b02,
    0x5b03,
    0x5b04,
    0x5b05,
    0x5b06,
    0x5b07,
    0x5b08,
    0x5b0a,
    0x5b0b,
    0x5b0c,
    0x5b0d,
    0x5b0e,
    0x5b0f,
    0x5b10,
    0x5b11,
    0x5b12,
    0x5b13,
    0x5b14,
    0x5b15,
    0x5b18,
    0x5b19,
    0x5b1a,
    0x5b1b,
    0x5b1c,
    0x5b1d,
    0x5b1e,
    0x5b1f,
    0x5b20,
    0x5b21,
    0x5b22,
    0x5b23,
    0x5b24,
    0x5b25,
    0x5b26,
    0x5b27,
    0x5b28,
    0x5b29,
    0x5b2a,
    0x5b2b,
    0x5b2c,
    0x5b2d,
    0x5b2e,
    0x5b2f,
    0x5b30,
    0x5b31,
    0x5b33,
    0x5b35,
    0x5b36,
    0x5b38,
    0x5b39,
    0x5b3a,
    0x5b3b,
    0x5b3c,
    0x5b3d,
    0x5b3e,
    0x5b3f,
    0x5b41,
    0x5b42,
    0x5b43,
    0x5b44,
    0x5b45,
    0x5b46,
    0x5b47,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0x8c[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x5b48,
    0x5b49,
    0x5b4a,
    0x5b4b,
    0x5b4c,
    0x5b4d,
    0x5b4e,
    0x5b4f,
    0x5b52,
    0x5b56,
    0x5b5e,
    0x5b60,
    0x5b61,
    0x5b67,
    0x5b68,
    0x5b6b,
    0x5b6d,
    0x5b6e,
    0x5b6f,
    0x5b72,
    0x5b74,
    0x5b76,
    0x5b77,
    0x5b78,
    0x5b79,
    0x5b7b,
    0x5b7c,
    0x5b7e,
    0x5b7f,
    0x5b82,
    0x5b86,
    0x5b8a,
    0x5b8d,
    0x5b8e,
    0x5b90,
    0x5b91,
    0x5b92,
    0x5b94,
    0x5b96,
    0x5b9f,
    0x5ba7,
    0x5ba8,
    0x5ba9,
    0x5bac,
    0x5bad,
    0x5bae,
    0x5baf,
    0x5bb1,
    0x5bb2,
    0x5bb7,
    0x5bba,
    0x5bbb,
    0x5bbc,
    0x5bc0,
    0x5bc1,
    0x5bc3,
    0x5bc8,
    0x5bc9,
    0x5bca,
    0x5bcb,
    0x5bcd,
    0x5bce,
    0x5bcf,
    CP936_CP_VAL_NULL,
    0x5bd1,
    0x5bd4,
    0x5bd5,
    0x5bd6,
    0x5bd7,
    0x5bd8,
    0x5bd9,
    0x5bda,
    0x5bdb,
    0x5bdc,
    0x5be0,
    0x5be2,
    0x5be3,
    0x5be6,
    0x5be7,
    0x5be9,
    0x5bea,
    0x5beb,
    0x5bec,
    0x5bed,
    0x5bef,
    0x5bf1,
    0x5bf2,
    0x5bf3,
    0x5bf4,
    0x5bf5,
    0x5bf6,
    0x5bf7,
    0x5bfd,
    0x5bfe,
    0x5c00,
    0x5c02,
    0x5c03,
    0x5c05,
    0x5c07,
    0x5c08,
    0x5c0b,
    0x5c0c,
    0x5c0d,
    0x5c0e,
    0x5c10,
    0x5c12,
    0x5c13,
    0x5c17,
    0x5c19,
    0x5c1b,
    0x5c1e,
    0x5c1f,
    0x5c20,
    0x5c21,
    0x5c23,
    0x5c26,
    0x5c28,
    0x5c29,
    0x5c2a,
    0x5c2b,
    0x5c2d,
    0x5c2e,
    0x5c2f,
    0x5c30,
    0x5c32,
    0x5c33,
    0x5c35,
    0x5c36,
    0x5c37,
    0x5c43,
    0x5c44,
    0x5c46,
    0x5c47,
    0x5c4c,
    0x5c4d,
    0x5c52,
    0x5c53,
    0x5c54,
    0x5c56,
    0x5c57,
    0x5c58,
    0x5c5a,
    0x5c5b,
    0x5c5c,
    0x5c5d,
    0x5c5f,
    0x5c62,
    0x5c64,
    0x5c67,
    0x5c68,
    0x5c69,
    0x5c6a,
    0x5c6b,
    0x5c6c,
    0x5c6d,
    0x5c70,
    0x5c72,
    0x5c73,
    0x5c74,
    0x5c75,
    0x5c76,
    0x5c77,
    0x5c78,
    0x5c7b,
    0x5c7c,
    0x5c7d,
    0x5c7e,
    0x5c80,
    0x5c83,
    0x5c84,
    0x5c85,
    0x5c86,
    0x5c87,
    0x5c89,
    0x5c8a,
    0x5c8b,
    0x5c8e,
    0x5c8f,
    0x5c92,
    0x5c93,
    0x5c95,
    0x5c9d,
    0x5c9e,
    0x5c9f,
    0x5ca0,
    0x5ca1,
    0x5ca4,
    0x5ca5,
    0x5ca6,
    0x5ca7,
    0x5ca8,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0x8d[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x5caa,
    0x5cae,
    0x5caf,
    0x5cb0,
    0x5cb2,
    0x5cb4,
    0x5cb6,
    0x5cb9,
    0x5cba,
    0x5cbb,
    0x5cbc,
    0x5cbe,
    0x5cc0,
    0x5cc2,
    0x5cc3,
    0x5cc5,
    0x5cc6,
    0x5cc7,
    0x5cc8,
    0x5cc9,
    0x5cca,
    0x5ccc,
    0x5ccd,
    0x5cce,
    0x5ccf,
    0x5cd0,
    0x5cd1,
    0x5cd3,
    0x5cd4,
    0x5cd5,
    0x5cd6,
    0x5cd7,
    0x5cd8,
    0x5cda,
    0x5cdb,
    0x5cdc,
    0x5cdd,
    0x5cde,
    0x5cdf,
    0x5ce0,
    0x5ce2,
    0x5ce3,
    0x5ce7,
    0x5ce9,
    0x5ceb,
    0x5cec,
    0x5cee,
    0x5cef,
    0x5cf1,
    0x5cf2,
    0x5cf3,
    0x5cf4,
    0x5cf5,
    0x5cf6,
    0x5cf7,
    0x5cf8,
    0x5cf9,
    0x5cfa,
    0x5cfc,
    0x5cfd,
    0x5cfe,
    0x5cff,
    0x5d00,
    CP936_CP_VAL_NULL,
    0x5d01,
    0x5d04,
    0x5d05,
    0x5d08,
    0x5d09,
    0x5d0a,
    0x5d0b,
    0x5d0c,
    0x5d0d,
    0x5d0f,
    0x5d10,
    0x5d11,
    0x5d12,
    0x5d13,
    0x5d15,
    0x5d17,
    0x5d18,
    0x5d19,
    0x5d1a,
    0x5d1c,
    0x5d1d,
    0x5d1f,
    0x5d20,
    0x5d21,
    0x5d22,
    0x5d23,
    0x5d25,
    0x5d28,
    0x5d2a,
    0x5d2b,
    0x5d2c,
    0x5d2f,
    0x5d30,
    0x5d31,
    0x5d32,
    0x5d33,
    0x5d35,
    0x5d36,
    0x5d37,
    0x5d38,
    0x5d39,
    0x5d3a,
    0x5d3b,
    0x5d3c,
    0x5d3f,
    0x5d40,
    0x5d41,
    0x5d42,
    0x5d43,
    0x5d44,
    0x5d45,
    0x5d46,
    0x5d48,
    0x5d49,
    0x5d4d,
    0x5d4e,
    0x5d4f,
    0x5d50,
    0x5d51,
    0x5d52,
    0x5d53,
    0x5d54,
    0x5d55,
    0x5d56,
    0x5d57,
    0x5d59,
    0x5d5a,
    0x5d5c,
    0x5d5e,
    0x5d5f,
    0x5d60,
    0x5d61,
    0x5d62,
    0x5d63,
    0x5d64,
    0x5d65,
    0x5d66,
    0x5d67,
    0x5d68,
    0x5d6a,
    0x5d6d,
    0x5d6e,
    0x5d70,
    0x5d71,
    0x5d72,
    0x5d73,
    0x5d75,
    0x5d76,
    0x5d77,
    0x5d78,
    0x5d79,
    0x5d7a,
    0x5d7b,
    0x5d7c,
    0x5d7d,
    0x5d7e,
    0x5d7f,
    0x5d80,
    0x5d81,
    0x5d83,
    0x5d84,
    0x5d85,
    0x5d86,
    0x5d87,
    0x5d88,
    0x5d89,
    0x5d8a,
    0x5d8b,
    0x5d8c,
    0x5d8d,
    0x5d8e,
    0x5d8f,
    0x5d90,
    0x5d91,
    0x5d92,
    0x5d93,
    0x5d94,
    0x5d95,
    0x5d96,
    0x5d97,
    0x5d98,
    0x5d9a,
    0x5d9b,
    0x5d9c,
    0x5d9e,
    0x5d9f,
    0x5da0,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0x8e[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x5da1,
    0x5da2,
    0x5da3,
    0x5da4,
    0x5da5,
    0x5da6,
    0x5da7,
    0x5da8,
    0x5da9,
    0x5daa,
    0x5dab,
    0x5dac,
    0x5dad,
    0x5dae,
    0x5daf,
    0x5db0,
    0x5db1,
    0x5db2,
    0x5db3,
    0x5db4,
    0x5db5,
    0x5db6,
    0x5db8,
    0x5db9,
    0x5dba,
    0x5dbb,
    0x5dbc,
    0x5dbd,
    0x5dbe,
    0x5dbf,
    0x5dc0,
    0x5dc1,
    0x5dc2,
    0x5dc3,
    0x5dc4,
    0x5dc6,
    0x5dc7,
    0x5dc8,
    0x5dc9,
    0x5dca,
    0x5dcb,
    0x5dcc,
    0x5dce,
    0x5dcf,
    0x5dd0,
    0x5dd1,
    0x5dd2,
    0x5dd3,
    0x5dd4,
    0x5dd5,
    0x5dd6,
    0x5dd7,
    0x5dd8,
    0x5dd9,
    0x5dda,
    0x5ddc,
    0x5ddf,
    0x5de0,
    0x5de3,
    0x5de4,
    0x5dea,
    0x5dec,
    0x5ded,
    CP936_CP_VAL_NULL,
    0x5df0,
    0x5df5,
    0x5df6,
    0x5df8,
    0x5df9,
    0x5dfa,
    0x5dfb,
    0x5dfc,
    0x5dff,
    0x5e00,
    0x5e04,
    0x5e07,
    0x5e09,
    0x5e0a,
    0x5e0b,
    0x5e0d,
    0x5e0e,
    0x5e12,
    0x5e13,
    0x5e17,
    0x5e1e,
    0x5e1f,
    0x5e20,
    0x5e21,
    0x5e22,
    0x5e23,
    0x5e24,
    0x5e25,
    0x5e28,
    0x5e29,
    0x5e2a,
    0x5e2b,
    0x5e2c,
    0x5e2f,
    0x5e30,
    0x5e32,
    0x5e33,
    0x5e34,
    0x5e35,
    0x5e36,
    0x5e39,
    0x5e3a,
    0x5e3e,
    0x5e3f,
    0x5e40,
    0x5e41,
    0x5e43,
    0x5e46,
    0x5e47,
    0x5e48,
    0x5e49,
    0x5e4a,
    0x5e4b,
    0x5e4d,
    0x5e4e,
    0x5e4f,
    0x5e50,
    0x5e51,
    0x5e52,
    0x5e53,
    0x5e56,
    0x5e57,
    0x5e58,
    0x5e59,
    0x5e5a,
    0x5e5c,
    0x5e5d,
    0x5e5f,
    0x5e60,
    0x5e63,
    0x5e64,
    0x5e65,
    0x5e66,
    0x5e67,
    0x5e68,
    0x5e69,
    0x5e6a,
    0x5e6b,
    0x5e6c,
    0x5e6d,
    0x5e6e,
    0x5e6f,
    0x5e70,
    0x5e71,
    0x5e75,
    0x5e77,
    0x5e79,
    0x5e7e,
    0x5e81,
    0x5e82,
    0x5e83,
    0x5e85,
    0x5e88,
    0x5e89,
    0x5e8c,
    0x5e8d,
    0x5e8e,
    0x5e92,
    0x5e98,
    0x5e9b,
    0x5e9d,
    0x5ea1,
    0x5ea2,
    0x5ea3,
    0x5ea4,
    0x5ea8,
    0x5ea9,
    0x5eaa,
    0x5eab,
    0x5eac,
    0x5eae,
    0x5eaf,
    0x5eb0,
    0x5eb1,
    0x5eb2,
    0x5eb4,
    0x5eba,
    0x5ebb,
    0x5ebc,
    0x5ebd,
    0x5ebf,
    0x5ec0,
    0x5ec1,
    0x5ec2,
    0x5ec3,
    0x5ec4,
    0x5ec5,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0x8f[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x5ec6,
    0x5ec7,
    0x5ec8,
    0x5ecb,
    0x5ecc,
    0x5ecd,
    0x5ece,
    0x5ecf,
    0x5ed0,
    0x5ed4,
    0x5ed5,
    0x5ed7,
    0x5ed8,
    0x5ed9,
    0x5eda,
    0x5edc,
    0x5edd,
    0x5ede,
    0x5edf,
    0x5ee0,
    0x5ee1,
    0x5ee2,
    0x5ee3,
    0x5ee4,
    0x5ee5,
    0x5ee6,
    0x5ee7,
    0x5ee9,
    0x5eeb,
    0x5eec,
    0x5eed,
    0x5eee,
    0x5eef,
    0x5ef0,
    0x5ef1,
    0x5ef2,
    0x5ef3,
    0x5ef5,
    0x5ef8,
    0x5ef9,
    0x5efb,
    0x5efc,
    0x5efd,
    0x5f05,
    0x5f06,
    0x5f07,
    0x5f09,
    0x5f0c,
    0x5f0d,
    0x5f0e,
    0x5f10,
    0x5f12,
    0x5f14,
    0x5f16,
    0x5f19,
    0x5f1a,
    0x5f1c,
    0x5f1d,
    0x5f1e,
    0x5f21,
    0x5f22,
    0x5f23,
    0x5f24,
    CP936_CP_VAL_NULL,
    0x5f28,
    0x5f2b,
    0x5f2c,
    0x5f2e,
    0x5f30,
    0x5f32,
    0x5f33,
    0x5f34,
    0x5f35,
    0x5f36,
    0x5f37,
    0x5f38,
    0x5f3b,
    0x5f3d,
    0x5f3e,
    0x5f3f,
    0x5f41,
    0x5f42,
    0x5f43,
    0x5f44,
    0x5f45,
    0x5f46,
    0x5f47,
    0x5f48,
    0x5f49,
    0x5f4a,
    0x5f4b,
    0x5f4c,
    0x5f4d,
    0x5f4e,
    0x5f4f,
    0x5f51,
    0x5f54,
    0x5f59,
    0x5f5a,
    0x5f5b,
    0x5f5c,
    0x5f5e,
    0x5f5f,
    0x5f60,
    0x5f63,
    0x5f65,
    0x5f67,
    0x5f68,
    0x5f6b,
    0x5f6e,
    0x5f6f,
    0x5f72,
    0x5f74,
    0x5f75,
    0x5f76,
    0x5f78,
    0x5f7a,
    0x5f7d,
    0x5f7e,
    0x5f7f,
    0x5f83,
    0x5f86,
    0x5f8d,
    0x5f8e,
    0x5f8f,
    0x5f91,
    0x5f93,
    0x5f94,
    0x5f96,
    0x5f9a,
    0x5f9b,
    0x5f9d,
    0x5f9e,
    0x5f9f,
    0x5fa0,
    0x5fa2,
    0x5fa3,
    0x5fa4,
    0x5fa5,
    0x5fa6,
    0x5fa7,
    0x5fa9,
    0x5fab,
    0x5fac,
    0x5faf,
    0x5fb0,
    0x5fb1,
    0x5fb2,
    0x5fb3,
    0x5fb4,
    0x5fb6,
    0x5fb8,
    0x5fb9,
    0x5fba,
    0x5fbb,
    0x5fbe,
    0x5fbf,
    0x5fc0,
    0x5fc1,
    0x5fc2,
    0x5fc7,
    0x5fc8,
    0x5fca,
    0x5fcb,
    0x5fce,
    0x5fd3,
    0x5fd4,
    0x5fd5,
    0x5fda,
    0x5fdb,
    0x5fdc,
    0x5fde,
    0x5fdf,
    0x5fe2,
    0x5fe3,
    0x5fe5,
    0x5fe6,
    0x5fe8,
    0x5fe9,
    0x5fec,
    0x5fef,
    0x5ff0,
    0x5ff2,
    0x5ff3,
    0x5ff4,
    0x5ff6,
    0x5ff7,
    0x5ff9,
    0x5ffa,
    0x5ffc,
    0x6007,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0x90[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x6008,
    0x6009,
    0x600b,
    0x600c,
    0x6010,
    0x6011,
    0x6013,
    0x6017,
    0x6018,
    0x601a,
    0x601e,
    0x601f,
    0x6022,
    0x6023,
    0x6024,
    0x602c,
    0x602d,
    0x602e,
    0x6030,
    0x6031,
    0x6032,
    0x6033,
    0x6034,
    0x6036,
    0x6037,
    0x6038,
    0x6039,
    0x603a,
    0x603d,
    0x603e,
    0x6040,
    0x6044,
    0x6045,
    0x6046,
    0x6047,
    0x6048,
    0x6049,
    0x604a,
    0x604c,
    0x604e,
    0x604f,
    0x6051,
    0x6053,
    0x6054,
    0x6056,
    0x6057,
    0x6058,
    0x605b,
    0x605c,
    0x605e,
    0x605f,
    0x6060,
    0x6061,
    0x6065,
    0x6066,
    0x606e,
    0x6071,
    0x6072,
    0x6074,
    0x6075,
    0x6077,
    0x607e,
    0x6080,
    CP936_CP_VAL_NULL,
    0x6081,
    0x6082,
    0x6085,
    0x6086,
    0x6087,
    0x6088,
    0x608a,
    0x608b,
    0x608e,
    0x608f,
    0x6090,
    0x6091,
    0x6093,
    0x6095,
    0x6097,
    0x6098,
    0x6099,
    0x609c,
    0x609e,
    0x60a1,
    0x60a2,
    0x60a4,
    0x60a5,
    0x60a7,
    0x60a9,
    0x60aa,
    0x60ae,
    0x60b0,
    0x60b3,
    0x60b5,
    0x60b6,
    0x60b7,
    0x60b9,
    0x60ba,
    0x60bd,
    0x60be,
    0x60bf,
    0x60c0,
    0x60c1,
    0x60c2,
    0x60c3,
    0x60c4,
    0x60c7,
    0x60c8,
    0x60c9,
    0x60cc,
    0x60cd,
    0x60ce,
    0x60cf,
    0x60d0,
    0x60d2,
    0x60d3,
    0x60d4,
    0x60d6,
    0x60d7,
    0x60d9,
    0x60db,
    0x60de,
    0x60e1,
    0x60e2,
    0x60e3,
    0x60e4,
    0x60e5,
    0x60ea,
    0x60f1,
    0x60f2,
    0x60f5,
    0x60f7,
    0x60f8,
    0x60fb,
    0x60fc,
    0x60fd,
    0x60fe,
    0x60ff,
    0x6102,
    0x6103,
    0x6104,
    0x6105,
    0x6107,
    0x610a,
    0x610b,
    0x610c,
    0x6110,
    0x6111,
    0x6112,
    0x6113,
    0x6114,
    0x6116,
    0x6117,
    0x6118,
    0x6119,
    0x611b,
    0x611c,
    0x611d,
    0x611e,
    0x6121,
    0x6122,
    0x6125,
    0x6128,
    0x6129,
    0x612a,
    0x612c,
    0x612d,
    0x612e,
    0x612f,
    0x6130,
    0x6131,
    0x6132,
    0x6133,
    0x6134,
    0x6135,
    0x6136,
    0x6137,
    0x6138,
    0x6139,
    0x613a,
    0x613b,
    0x613c,
    0x613d,
    0x613e,
    0x6140,
    0x6141,
    0x6142,
    0x6143,
    0x6144,
    0x6145,
    0x6146,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0x91[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x6147,
    0x6149,
    0x614b,
    0x614d,
    0x614f,
    0x6150,
    0x6152,
    0x6153,
    0x6154,
    0x6156,
    0x6157,
    0x6158,
    0x6159,
    0x615a,
    0x615b,
    0x615c,
    0x615e,
    0x615f,
    0x6160,
    0x6161,
    0x6163,
    0x6164,
    0x6165,
    0x6166,
    0x6169,
    0x616a,
    0x616b,
    0x616c,
    0x616d,
    0x616e,
    0x616f,
    0x6171,
    0x6172,
    0x6173,
    0x6174,
    0x6176,
    0x6178,
    0x6179,
    0x617a,
    0x617b,
    0x617c,
    0x617d,
    0x617e,
    0x617f,
    0x6180,
    0x6181,
    0x6182,
    0x6183,
    0x6184,
    0x6185,
    0x6186,
    0x6187,
    0x6188,
    0x6189,
    0x618a,
    0x618c,
    0x618d,
    0x618f,
    0x6190,
    0x6191,
    0x6192,
    0x6193,
    0x6195,
    CP936_CP_VAL_NULL,
    0x6196,
    0x6197,
    0x6198,
    0x6199,
    0x619a,
    0x619b,
    0x619c,
    0x619e,
    0x619f,
    0x61a0,
    0x61a1,
    0x61a2,
    0x61a3,
    0x61a4,
    0x61a5,
    0x61a6,
    0x61aa,
    0x61ab,
    0x61ad,
    0x61ae,
    0x61af,
    0x61b0,
    0x61b1,
    0x61b2,
    0x61b3,
    0x61b4,
    0x61b5,
    0x61b6,
    0x61b8,
    0x61b9,
    0x61ba,
    0x61bb,
    0x61bc,
    0x61bd,
    0x61bf,
    0x61c0,
    0x61c1,
    0x61c3,
    0x61c4,
    0x61c5,
    0x61c6,
    0x61c7,
    0x61c9,
    0x61cc,
    0x61cd,
    0x61ce,
    0x61cf,
    0x61d0,
    0x61d3,
    0x61d5,
    0x61d6,
    0x61d7,
    0x61d8,
    0x61d9,
    0x61da,
    0x61db,
    0x61dc,
    0x61dd,
    0x61de,
    0x61df,
    0x61e0,
    0x61e1,
    0x61e2,
    0x61e3,
    0x61e4,
    0x61e5,
    0x61e7,
    0x61e8,
    0x61e9,
    0x61ea,
    0x61eb,
    0x61ec,
    0x61ed,
    0x61ee,
    0x61ef,
    0x61f0,
    0x61f1,
    0x61f2,
    0x61f3,
    0x61f4,
    0x61f6,
    0x61f7,
    0x61f8,
    0x61f9,
    0x61fa,
    0x61fb,
    0x61fc,
    0x61fd,
    0x61fe,
    0x6200,
    0x6201,
    0x6202,
    0x6203,
    0x6204,
    0x6205,
    0x6207,
    0x6209,
    0x6213,
    0x6214,
    0x6219,
    0x621c,
    0x621d,
    0x621e,
    0x6220,
    0x6223,
    0x6226,
    0x6227,
    0x6228,
    0x6229,
    0x622b,
    0x622d,
    0x622f,
    0x6230,
    0x6231,
    0x6232,
    0x6235,
    0x6236,
    0x6238,
    0x6239,
    0x623a,
    0x623b,
    0x623c,
    0x6242,
    0x6244,
    0x6245,
    0x6246,
    0x624a,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0x92[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x624f,
    0x6250,
    0x6255,
    0x6256,
    0x6257,
    0x6259,
    0x625a,
    0x625c,
    0x625d,
    0x625e,
    0x625f,
    0x6260,
    0x6261,
    0x6262,
    0x6264,
    0x6265,
    0x6268,
    0x6271,
    0x6272,
    0x6274,
    0x6275,
    0x6277,
    0x6278,
    0x627a,
    0x627b,
    0x627d,
    0x6281,
    0x6282,
    0x6283,
    0x6285,
    0x6286,
    0x6287,
    0x6288,
    0x628b,
    0x628c,
    0x628d,
    0x628e,
    0x628f,
    0x6290,
    0x6294,
    0x6299,
    0x629c,
    0x629d,
    0x629e,
    0x62a3,
    0x62a6,
    0x62a7,
    0x62a9,
    0x62aa,
    0x62ad,
    0x62ae,
    0x62af,
    0x62b0,
    0x62b2,
    0x62b3,
    0x62b4,
    0x62b6,
    0x62b7,
    0x62b8,
    0x62ba,
    0x62be,
    0x62c0,
    0x62c1,
    CP936_CP_VAL_NULL,
    0x62c3,
    0x62cb,
    0x62cf,
    0x62d1,
    0x62d5,
    0x62dd,
    0x62de,
    0x62e0,
    0x62e1,
    0x62e4,
    0x62ea,
    0x62eb,
    0x62f0,
    0x62f2,
    0x62f5,
    0x62f8,
    0x62f9,
    0x62fa,
    0x62fb,
    0x6300,
    0x6303,
    0x6304,
    0x6305,
    0x6306,
    0x630a,
    0x630b,
    0x630c,
    0x630d,
    0x630f,
    0x6310,
    0x6312,
    0x6313,
    0x6314,
    0x6315,
    0x6317,
    0x6318,
    0x6319,
    0x631c,
    0x6326,
    0x6327,
    0x6329,
    0x632c,
    0x632d,
    0x632e,
    0x6330,
    0x6331,
    0x6333,
    0x6334,
    0x6335,
    0x6336,
    0x6337,
    0x6338,
    0x633b,
    0x633c,
    0x633e,
    0x633f,
    0x6340,
    0x6341,
    0x6344,
    0x6347,
    0x6348,
    0x634a,
    0x6351,
    0x6352,
    0x6353,
    0x6354,
    0x6356,
    0x6357,
    0x6358,
    0x6359,
    0x635a,
    0x635b,
    0x635c,
    0x635d,
    0x6360,
    0x6364,
    0x6365,
    0x6366,
    0x6368,
    0x636a,
    0x636b,
    0x636c,
    0x636f,
    0x6370,
    0x6372,
    0x6373,
    0x6374,
    0x6375,
    0x6378,
    0x6379,
    0x637c,
    0x637d,
    0x637e,
    0x637f,
    0x6381,
    0x6383,
    0x6384,
    0x6385,
    0x6386,
    0x638b,
    0x638d,
    0x6391,
    0x6393,
    0x6394,
    0x6395,
    0x6397,
    0x6399,
    0x639a,
    0x639b,
    0x639c,
    0x639d,
    0x639e,
    0x639f,
    0x63a1,
    0x63a4,
    0x63a6,
    0x63ab,
    0x63af,
    0x63b1,
    0x63b2,
    0x63b5,
    0x63b6,
    0x63b9,
    0x63bb,
    0x63bd,
    0x63bf,
    0x63c0,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0x93[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x63c1,
    0x63c2,
    0x63c3,
    0x63c5,
    0x63c7,
    0x63c8,
    0x63ca,
    0x63cb,
    0x63cc,
    0x63d1,
    0x63d3,
    0x63d4,
    0x63d5,
    0x63d7,
    0x63d8,
    0x63d9,
    0x63da,
    0x63db,
    0x63dc,
    0x63dd,
    0x63df,
    0x63e2,
    0x63e4,
    0x63e5,
    0x63e6,
    0x63e7,
    0x63e8,
    0x63eb,
    0x63ec,
    0x63ee,
    0x63ef,
    0x63f0,
    0x63f1,
    0x63f3,
    0x63f5,
    0x63f7,
    0x63f9,
    0x63fa,
    0x63fb,
    0x63fc,
    0x63fe,
    0x6403,
    0x6404,
    0x6406,
    0x6407,
    0x6408,
    0x6409,
    0x640a,
    0x640d,
    0x640e,
    0x6411,
    0x6412,
    0x6415,
    0x6416,
    0x6417,
    0x6418,
    0x6419,
    0x641a,
    0x641d,
    0x641f,
    0x6422,
    0x6423,
    0x6424,
    CP936_CP_VAL_NULL,
    0x6425,
    0x6427,
    0x6428,
    0x6429,
    0x642b,
    0x642e,
    0x642f,
    0x6430,
    0x6431,
    0x6432,
    0x6433,
    0x6435,
    0x6436,
    0x6437,
    0x6438,
    0x6439,
    0x643b,
    0x643c,
    0x643e,
    0x6440,
    0x6442,
    0x6443,
    0x6449,
    0x644b,
    0x644c,
    0x644d,
    0x644e,
    0x644f,
    0x6450,
    0x6451,
    0x6453,
    0x6455,
    0x6456,
    0x6457,
    0x6459,
    0x645a,
    0x645b,
    0x645c,
    0x645d,
    0x645f,
    0x6460,
    0x6461,
    0x6462,
    0x6463,
    0x6464,
    0x6465,
    0x6466,
    0x6468,
    0x646a,
    0x646b,
    0x646c,
    0x646e,
    0x646f,
    0x6470,
    0x6471,
    0x6472,
    0x6473,
    0x6474,
    0x6475,
    0x6476,
    0x6477,
    0x647b,
    0x647c,
    0x647d,
    0x647e,
    0x647f,
    0x6480,
    0x6481,
    0x6483,
    0x6486,
    0x6488,
    0x6489,
    0x648a,
    0x648b,
    0x648c,
    0x648d,
    0x648e,
    0x648f,
    0x6490,
    0x6493,
    0x6494,
    0x6497,
    0x6498,
    0x649a,
    0x649b,
    0x649c,
    0x649d,
    0x649f,
    0x64a0,
    0x64a1,
    0x64a2,
    0x64a3,
    0x64a5,
    0x64a6,
    0x64a7,
    0x64a8,
    0x64aa,
    0x64ab,
    0x64af,
    0x64b1,
    0x64b2,
    0x64b3,
    0x64b4,
    0x64b6,
    0x64b9,
    0x64bb,
    0x64bd,
    0x64be,
    0x64bf,
    0x64c1,
    0x64c3,
    0x64c4,
    0x64c6,
    0x64c7,
    0x64c8,
    0x64c9,
    0x64ca,
    0x64cb,
    0x64cc,
    0x64cf,
    0x64d1,
    0x64d3,
    0x64d4,
    0x64d5,
    0x64d6,
    0x64d9,
    0x64da,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0x94[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x64db,
    0x64dc,
    0x64dd,
    0x64df,
    0x64e0,
    0x64e1,
    0x64e3,
    0x64e5,
    0x64e7,
    0x64e8,
    0x64e9,
    0x64ea,
    0x64eb,
    0x64ec,
    0x64ed,
    0x64ee,
    0x64ef,
    0x64f0,
    0x64f1,
    0x64f2,
    0x64f3,
    0x64f4,
    0x64f5,
    0x64f6,
    0x64f7,
    0x64f8,
    0x64f9,
    0x64fa,
    0x64fb,
    0x64fc,
    0x64fd,
    0x64fe,
    0x64ff,
    0x6501,
    0x6502,
    0x6503,
    0x6504,
    0x6505,
    0x6506,
    0x6507,
    0x6508,
    0x650a,
    0x650b,
    0x650c,
    0x650d,
    0x650e,
    0x650f,
    0x6510,
    0x6511,
    0x6513,
    0x6514,
    0x6515,
    0x6516,
    0x6517,
    0x6519,
    0x651a,
    0x651b,
    0x651c,
    0x651d,
    0x651e,
    0x651f,
    0x6520,
    0x6521,
    CP936_CP_VAL_NULL,
    0x6522,
    0x6523,
    0x6524,
    0x6526,
    0x6527,
    0x6528,
    0x6529,
    0x652a,
    0x652c,
    0x652d,
    0x6530,
    0x6531,
    0x6532,
    0x6533,
    0x6537,
    0x653a,
    0x653c,
    0x653d,
    0x6540,
    0x6541,
    0x6542,
    0x6543,
    0x6544,
    0x6546,
    0x6547,
    0x654a,
    0x654b,
    0x654d,
    0x654e,
    0x6550,
    0x6552,
    0x6553,
    0x6554,
    0x6557,
    0x6558,
    0x655a,
    0x655c,
    0x655f,
    0x6560,
    0x6561,
    0x6564,
    0x6565,
    0x6567,
    0x6568,
    0x6569,
    0x656a,
    0x656d,
    0x656e,
    0x656f,
    0x6571,
    0x6573,
    0x6575,
    0x6576,
    0x6578,
    0x6579,
    0x657a,
    0x657b,
    0x657c,
    0x657d,
    0x657e,
    0x657f,
    0x6580,
    0x6581,
    0x6582,
    0x6583,
    0x6584,
    0x6585,
    0x6586,
    0x6588,
    0x6589,
    0x658a,
    0x658d,
    0x658e,
    0x658f,
    0x6592,
    0x6594,
    0x6595,
    0x6596,
    0x6598,
    0x659a,
    0x659d,
    0x659e,
    0x65a0,
    0x65a2,
    0x65a3,
    0x65a6,
    0x65a8,
    0x65aa,
    0x65ac,
    0x65ae,
    0x65b1,
    0x65b2,
    0x65b3,
    0x65b4,
    0x65b5,
    0x65b6,
    0x65b7,
    0x65b8,
    0x65ba,
    0x65bb,
    0x65be,
    0x65bf,
    0x65c0,
    0x65c2,
    0x65c7,
    0x65c8,
    0x65c9,
    0x65ca,
    0x65cd,
    0x65d0,
    0x65d1,
    0x65d3,
    0x65d4,
    0x65d5,
    0x65d8,
    0x65d9,
    0x65da,
    0x65db,
    0x65dc,
    0x65dd,
    0x65de,
    0x65df,
    0x65e1,
    0x65e3,
    0x65e4,
    0x65ea,
    0x65eb,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0x95[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x65f2,
    0x65f3,
    0x65f4,
    0x65f5,
    0x65f8,
    0x65f9,
    0x65fb,
    0x65fc,
    0x65fd,
    0x65fe,
    0x65ff,
    0x6601,
    0x6604,
    0x6605,
    0x6607,
    0x6608,
    0x6609,
    0x660b,
    0x660d,
    0x6610,
    0x6611,
    0x6612,
    0x6616,
    0x6617,
    0x6618,
    0x661a,
    0x661b,
    0x661c,
    0x661e,
    0x6621,
    0x6622,
    0x6623,
    0x6624,
    0x6626,
    0x6629,
    0x662a,
    0x662b,
    0x662c,
    0x662e,
    0x6630,
    0x6632,
    0x6633,
    0x6637,
    0x6638,
    0x6639,
    0x663a,
    0x663b,
    0x663d,
    0x663f,
    0x6640,
    0x6642,
    0x6644,
    0x6645,
    0x6646,
    0x6647,
    0x6648,
    0x6649,
    0x664a,
    0x664d,
    0x664e,
    0x6650,
    0x6651,
    0x6658,
    CP936_CP_VAL_NULL,
    0x6659,
    0x665b,
    0x665c,
    0x665d,
    0x665e,
    0x6660,
    0x6662,
    0x6663,
    0x6665,
    0x6667,
    0x6669,
    0x666a,
    0x666b,
    0x666c,
    0x666d,
    0x6671,
    0x6672,
    0x6673,
    0x6675,
    0x6678,
    0x6679,
    0x667b,
    0x667c,
    0x667d,
    0x667f,
    0x6680,
    0x6681,
    0x6683,
    0x6685,
    0x6686,
    0x6688,
    0x6689,
    0x668a,
    0x668b,
    0x668d,
    0x668e,
    0x668f,
    0x6690,
    0x6692,
    0x6693,
    0x6694,
    0x6695,
    0x6698,
    0x6699,
    0x669a,
    0x669b,
    0x669c,
    0x669e,
    0x669f,
    0x66a0,
    0x66a1,
    0x66a2,
    0x66a3,
    0x66a4,
    0x66a5,
    0x66a6,
    0x66a9,
    0x66aa,
    0x66ab,
    0x66ac,
    0x66ad,
    0x66af,
    0x66b0,
    0x66b1,
    0x66b2,
    0x66b3,
    0x66b5,
    0x66b6,
    0x66b7,
    0x66b8,
    0x66ba,
    0x66bb,
    0x66bc,
    0x66bd,
    0x66bf,
    0x66c0,
    0x66c1,
    0x66c2,
    0x66c3,
    0x66c4,
    0x66c5,
    0x66c6,
    0x66c7,
    0x66c8,
    0x66c9,
    0x66ca,
    0x66cb,
    0x66cc,
    0x66cd,
    0x66ce,
    0x66cf,
    0x66d0,
    0x66d1,
    0x66d2,
    0x66d3,
    0x66d4,
    0x66d5,
    0x66d6,
    0x66d7,
    0x66d8,
    0x66da,
    0x66de,
    0x66df,
    0x66e0,
    0x66e1,
    0x66e2,
    0x66e3,
    0x66e4,
    0x66e5,
    0x66e7,
    0x66e8,
    0x66ea,
    0x66eb,
    0x66ec,
    0x66ed,
    0x66ee,
    0x66ef,
    0x66f1,
    0x66f5,
    0x66f6,
    0x66f8,
    0x66fa,
    0x66fb,
    0x66fd,
    0x6701,
    0x6702,
    0x6703,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0x96[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x6704,
    0x6705,
    0x6706,
    0x6707,
    0x670c,
    0x670e,
    0x670f,
    0x6711,
    0x6712,
    0x6713,
    0x6716,
    0x6718,
    0x6719,
    0x671a,
    0x671c,
    0x671e,
    0x6720,
    0x6721,
    0x6722,
    0x6723,
    0x6724,
    0x6725,
    0x6727,
    0x6729,
    0x672e,
    0x6730,
    0x6732,
    0x6733,
    0x6736,
    0x6737,
    0x6738,
    0x6739,
    0x673b,
    0x673c,
    0x673e,
    0x673f,
    0x6741,
    0x6744,
    0x6745,
    0x6747,
    0x674a,
    0x674b,
    0x674d,
    0x6752,
    0x6754,
    0x6755,
    0x6757,
    0x6758,
    0x6759,
    0x675a,
    0x675b,
    0x675d,
    0x6762,
    0x6763,
    0x6764,
    0x6766,
    0x6767,
    0x676b,
    0x676c,
    0x676e,
    0x6771,
    0x6774,
    0x6776,
    CP936_CP_VAL_NULL,
    0x6778,
    0x6779,
    0x677a,
    0x677b,
    0x677d,
    0x6780,
    0x6782,
    0x6783,
    0x6785,
    0x6786,
    0x6788,
    0x678a,
    0x678c,
    0x678d,
    0x678e,
    0x678f,
    0x6791,
    0x6792,
    0x6793,
    0x6794,
    0x6796,
    0x6799,
    0x679b,
    0x679f,
    0x67a0,
    0x67a1,
    0x67a4,
    0x67a6,
    0x67a9,
    0x67ac,
    0x67ae,
    0x67b1,
    0x67b2,
    0x67b4,
    0x67b9,
    0x67ba,
    0x67bb,
    0x67bc,
    0x67bd,
    0x67be,
    0x67bf,
    0x67c0,
    0x67c2,
    0x67c5,
    0x67c6,
    0x67c7,
    0x67c8,
    0x67c9,
    0x67ca,
    0x67cb,
    0x67cc,
    0x67cd,
    0x67ce,
    0x67d5,
    0x67d6,
    0x67d7,
    0x67db,
    0x67df,
    0x67e1,
    0x67e3,
    0x67e4,
    0x67e6,
    0x67e7,
    0x67e8,
    0x67ea,
    0x67eb,
    0x67ed,
    0x67ee,
    0x67f2,
    0x67f5,
    0x67f6,
    0x67f7,
    0x67f8,
    0x67f9,
    0x67fa,
    0x67fb,
    0x67fc,
    0x67fe,
    0x6801,
    0x6802,
    0x6803,
    0x6804,
    0x6806,
    0x680d,
    0x6810,
    0x6812,
    0x6814,
    0x6815,
    0x6818,
    0x6819,
    0x681a,
    0x681b,
    0x681c,
    0x681e,
    0x681f,
    0x6820,
    0x6822,
    0x6823,
    0x6824,
    0x6825,
    0x6826,
    0x6827,
    0x6828,
    0x682b,
    0x682c,
    0x682d,
    0x682e,
    0x682f,
    0x6830,
    0x6831,
    0x6834,
    0x6835,
    0x6836,
    0x683a,
    0x683b,
    0x683f,
    0x6847,
    0x684b,
    0x684d,
    0x684f,
    0x6852,
    0x6856,
    0x6857,
    0x6858,
    0x6859,
    0x685a,
    0x685b,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0x97[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x685c,
    0x685d,
    0x685e,
    0x685f,
    0x686a,
    0x686c,
    0x686d,
    0x686e,
    0x686f,
    0x6870,
    0x6871,
    0x6872,
    0x6873,
    0x6875,
    0x6878,
    0x6879,
    0x687a,
    0x687b,
    0x687c,
    0x687d,
    0x687e,
    0x687f,
    0x6880,
    0x6882,
    0x6884,
    0x6887,
    0x6888,
    0x6889,
    0x688a,
    0x688b,
    0x688c,
    0x688d,
    0x688e,
    0x6890,
    0x6891,
    0x6892,
    0x6894,
    0x6895,
    0x6896,
    0x6898,
    0x6899,
    0x689a,
    0x689b,
    0x689c,
    0x689d,
    0x689e,
    0x689f,
    0x68a0,
    0x68a1,
    0x68a3,
    0x68a4,
    0x68a5,
    0x68a9,
    0x68aa,
    0x68ab,
    0x68ac,
    0x68ae,
    0x68b1,
    0x68b2,
    0x68b4,
    0x68b6,
    0x68b7,
    0x68b8,
    CP936_CP_VAL_NULL,
    0x68b9,
    0x68ba,
    0x68bb,
    0x68bc,
    0x68bd,
    0x68be,
    0x68bf,
    0x68c1,
    0x68c3,
    0x68c4,
    0x68c5,
    0x68c6,
    0x68c7,
    0x68c8,
    0x68ca,
    0x68cc,
    0x68ce,
    0x68cf,
    0x68d0,
    0x68d1,
    0x68d3,
    0x68d4,
    0x68d6,
    0x68d7,
    0x68d9,
    0x68db,
    0x68dc,
    0x68dd,
    0x68de,
    0x68df,
    0x68e1,
    0x68e2,
    0x68e4,
    0x68e5,
    0x68e6,
    0x68e7,
    0x68e8,
    0x68e9,
    0x68ea,
    0x68eb,
    0x68ec,
    0x68ed,
    0x68ef,
    0x68f2,
    0x68f3,
    0x68f4,
    0x68f6,
    0x68f7,
    0x68f8,
    0x68fb,
    0x68fd,
    0x68fe,
    0x68ff,
    0x6900,
    0x6902,
    0x6903,
    0x6904,
    0x6906,
    0x6907,
    0x6908,
    0x6909,
    0x690a,
    0x690c,
    0x690f,
    0x6911,
    0x6913,
    0x6914,
    0x6915,
    0x6916,
    0x6917,
    0x6918,
    0x6919,
    0x691a,
    0x691b,
    0x691c,
    0x691d,
    0x691e,
    0x6921,
    0x6922,
    0x6923,
    0x6925,
    0x6926,
    0x6927,
    0x6928,
    0x6929,
    0x692a,
    0x692b,
    0x692c,
    0x692e,
    0x692f,
    0x6931,
    0x6932,
    0x6933,
    0x6935,
    0x6936,
    0x6937,
    0x6938,
    0x693a,
    0x693b,
    0x693c,
    0x693e,
    0x6940,
    0x6941,
    0x6943,
    0x6944,
    0x6945,
    0x6946,
    0x6947,
    0x6948,
    0x6949,
    0x694a,
    0x694b,
    0x694c,
    0x694d,
    0x694e,
    0x694f,
    0x6950,
    0x6951,
    0x6952,
    0x6953,
    0x6955,
    0x6956,
    0x6958,
    0x6959,
    0x695b,
    0x695c,
    0x695f,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0x98[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x6961,
    0x6962,
    0x6964,
    0x6965,
    0x6967,
    0x6968,
    0x6969,
    0x696a,
    0x696c,
    0x696d,
    0x696f,
    0x6970,
    0x6972,
    0x6973,
    0x6974,
    0x6975,
    0x6976,
    0x697a,
    0x697b,
    0x697d,
    0x697e,
    0x697f,
    0x6981,
    0x6983,
    0x6985,
    0x698a,
    0x698b,
    0x698c,
    0x698e,
    0x698f,
    0x6990,
    0x6991,
    0x6992,
    0x6993,
    0x6996,
    0x6997,
    0x6999,
    0x699a,
    0x699d,
    0x699e,
    0x699f,
    0x69a0,
    0x69a1,
    0x69a2,
    0x69a3,
    0x69a4,
    0x69a5,
    0x69a6,
    0x69a9,
    0x69aa,
    0x69ac,
    0x69ae,
    0x69af,
    0x69b0,
    0x69b2,
    0x69b3,
    0x69b5,
    0x69b6,
    0x69b8,
    0x69b9,
    0x69ba,
    0x69bc,
    0x69bd,
    CP936_CP_VAL_NULL,
    0x69be,
    0x69bf,
    0x69c0,
    0x69c2,
    0x69c3,
    0x69c4,
    0x69c5,
    0x69c6,
    0x69c7,
    0x69c8,
    0x69c9,
    0x69cb,
    0x69cd,
    0x69cf,
    0x69d1,
    0x69d2,
    0x69d3,
    0x69d5,
    0x69d6,
    0x69d7,
    0x69d8,
    0x69d9,
    0x69da,
    0x69dc,
    0x69dd,
    0x69de,
    0x69e1,
    0x69e2,
    0x69e3,
    0x69e4,
    0x69e5,
    0x69e6,
    0x69e7,
    0x69e8,
    0x69e9,
    0x69ea,
    0x69eb,
    0x69ec,
    0x69ee,
    0x69ef,
    0x69f0,
    0x69f1,
    0x69f3,
    0x69f4,
    0x69f5,
    0x69f6,
    0x69f7,
    0x69f8,
    0x69f9,
    0x69fa,
    0x69fb,
    0x69fc,
    0x69fe,
    0x6a00,
    0x6a01,
    0x6a02,
    0x6a03,
    0x6a04,
    0x6a05,
    0x6a06,
    0x6a07,
    0x6a08,
    0x6a09,
    0x6a0b,
    0x6a0c,
    0x6a0d,
    0x6a0e,
    0x6a0f,
    0x6a10,
    0x6a11,
    0x6a12,
    0x6a13,
    0x6a14,
    0x6a15,
    0x6a16,
    0x6a19,
    0x6a1a,
    0x6a1b,
    0x6a1c,
    0x6a1d,
    0x6a1e,
    0x6a20,
    0x6a22,
    0x6a23,
    0x6a24,
    0x6a25,
    0x6a26,
    0x6a27,
    0x6a29,
    0x6a2b,
    0x6a2c,
    0x6a2d,
    0x6a2e,
    0x6a30,
    0x6a32,
    0x6a33,
    0x6a34,
    0x6a36,
    0x6a37,
    0x6a38,
    0x6a39,
    0x6a3a,
    0x6a3b,
    0x6a3c,
    0x6a3f,
    0x6a40,
    0x6a41,
    0x6a42,
    0x6a43,
    0x6a45,
    0x6a46,
    0x6a48,
    0x6a49,
    0x6a4a,
    0x6a4b,
    0x6a4c,
    0x6a4d,
    0x6a4e,
    0x6a4f,
    0x6a51,
    0x6a52,
    0x6a53,
    0x6a54,
    0x6a55,
    0x6a56,
    0x6a57,
    0x6a5a,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0x99[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x6a5c,
    0x6a5d,
    0x6a5e,
    0x6a5f,
    0x6a60,
    0x6a62,
    0x6a63,
    0x6a64,
    0x6a66,
    0x6a67,
    0x6a68,
    0x6a69,
    0x6a6a,
    0x6a6b,
    0x6a6c,
    0x6a6d,
    0x6a6e,
    0x6a6f,
    0x6a70,
    0x6a72,
    0x6a73,
    0x6a74,
    0x6a75,
    0x6a76,
    0x6a77,
    0x6a78,
    0x6a7a,
    0x6a7b,
    0x6a7d,
    0x6a7e,
    0x6a7f,
    0x6a81,
    0x6a82,
    0x6a83,
    0x6a85,
    0x6a86,
    0x6a87,
    0x6a88,
    0x6a89,
    0x6a8a,
    0x6a8b,
    0x6a8c,
    0x6a8d,
    0x6a8f,
    0x6a92,
    0x6a93,
    0x6a94,
    0x6a95,
    0x6a96,
    0x6a98,
    0x6a99,
    0x6a9a,
    0x6a9b,
    0x6a9c,
    0x6a9d,
    0x6a9e,
    0x6a9f,
    0x6aa1,
    0x6aa2,
    0x6aa3,
    0x6aa4,
    0x6aa5,
    0x6aa6,
    CP936_CP_VAL_NULL,
    0x6aa7,
    0x6aa8,
    0x6aaa,
    0x6aad,
    0x6aae,
    0x6aaf,
    0x6ab0,
    0x6ab1,
    0x6ab2,
    0x6ab3,
    0x6ab4,
    0x6ab5,
    0x6ab6,
    0x6ab7,
    0x6ab8,
    0x6ab9,
    0x6aba,
    0x6abb,
    0x6abc,
    0x6abd,
    0x6abe,
    0x6abf,
    0x6ac0,
    0x6ac1,
    0x6ac2,
    0x6ac3,
    0x6ac4,
    0x6ac5,
    0x6ac6,
    0x6ac7,
    0x6ac8,
    0x6ac9,
    0x6aca,
    0x6acb,
    0x6acc,
    0x6acd,
    0x6ace,
    0x6acf,
    0x6ad0,
    0x6ad1,
    0x6ad2,
    0x6ad3,
    0x6ad4,
    0x6ad5,
    0x6ad6,
    0x6ad7,
    0x6ad8,
    0x6ad9,
    0x6ada,
    0x6adb,
    0x6adc,
    0x6add,
    0x6ade,
    0x6adf,
    0x6ae0,
    0x6ae1,
    0x6ae2,
    0x6ae3,
    0x6ae4,
    0x6ae5,
    0x6ae6,
    0x6ae7,
    0x6ae8,
    0x6ae9,
    0x6aea,
    0x6aeb,
    0x6aec,
    0x6aed,
    0x6aee,
    0x6aef,
    0x6af0,
    0x6af1,
    0x6af2,
    0x6af3,
    0x6af4,
    0x6af5,
    0x6af6,
    0x6af7,
    0x6af8,
    0x6af9,
    0x6afa,
    0x6afb,
    0x6afc,
    0x6afd,
    0x6afe,
    0x6aff,
    0x6b00,
    0x6b01,
    0x6b02,
    0x6b03,
    0x6b04,
    0x6b05,
    0x6b06,
    0x6b07,
    0x6b08,
    0x6b09,
    0x6b0a,
    0x6b0b,
    0x6b0c,
    0x6b0d,
    0x6b0e,
    0x6b0f,
    0x6b10,
    0x6b11,
    0x6b12,
    0x6b13,
    0x6b14,
    0x6b15,
    0x6b16,
    0x6b17,
    0x6b18,
    0x6b19,
    0x6b1a,
    0x6b1b,
    0x6b1c,
    0x6b1d,
    0x6b1e,
    0x6b1f,
    0x6b25,
    0x6b26,
    0x6b28,
    0x6b29,
    0x6b2a,
    0x6b2b,
    0x6b2c,
    0x6b2d,
    0x6b2e,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0x9a[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x6b2f,
    0x6b30,
    0x6b31,
    0x6b33,
    0x6b34,
    0x6b35,
    0x6b36,
    0x6b38,
    0x6b3b,
    0x6b3c,
    0x6b3d,
    0x6b3f,
    0x6b40,
    0x6b41,
    0x6b42,
    0x6b44,
    0x6b45,
    0x6b48,
    0x6b4a,
    0x6b4b,
    0x6b4d,
    0x6b4e,
    0x6b4f,
    0x6b50,
    0x6b51,
    0x6b52,
    0x6b53,
    0x6b54,
    0x6b55,
    0x6b56,
    0x6b57,
    0x6b58,
    0x6b5a,
    0x6b5b,
    0x6b5c,
    0x6b5d,
    0x6b5e,
    0x6b5f,
    0x6b60,
    0x6b61,
    0x6b68,
    0x6b69,
    0x6b6b,
    0x6b6c,
    0x6b6d,
    0x6b6e,
    0x6b6f,
    0x6b70,
    0x6b71,
    0x6b72,
    0x6b73,
    0x6b74,
    0x6b75,
    0x6b76,
    0x6b77,
    0x6b78,
    0x6b7a,
    0x6b7d,
    0x6b7e,
    0x6b7f,
    0x6b80,
    0x6b85,
    0x6b88,
    CP936_CP_VAL_NULL,
    0x6b8c,
    0x6b8e,
    0x6b8f,
    0x6b90,
    0x6b91,
    0x6b94,
    0x6b95,
    0x6b97,
    0x6b98,
    0x6b99,
    0x6b9c,
    0x6b9d,
    0x6b9e,
    0x6b9f,
    0x6ba0,
    0x6ba2,
    0x6ba3,
    0x6ba4,
    0x6ba5,
    0x6ba6,
    0x6ba7,
    0x6ba8,
    0x6ba9,
    0x6bab,
    0x6bac,
    0x6bad,
    0x6bae,
    0x6baf,
    0x6bb0,
    0x6bb1,
    0x6bb2,
    0x6bb6,
    0x6bb8,
    0x6bb9,
    0x6bba,
    0x6bbb,
    0x6bbc,
    0x6bbd,
    0x6bbe,
    0x6bc0,
    0x6bc3,
    0x6bc4,
    0x6bc6,
    0x6bc7,
    0x6bc8,
    0x6bc9,
    0x6bca,
    0x6bcc,
    0x6bce,
    0x6bd0,
    0x6bd1,
    0x6bd8,
    0x6bda,
    0x6bdc,
    0x6bdd,
    0x6bde,
    0x6bdf,
    0x6be0,
    0x6be2,
    0x6be3,
    0x6be4,
    0x6be5,
    0x6be6,
    0x6be7,
    0x6be8,
    0x6be9,
    0x6bec,
    0x6bed,
    0x6bee,
    0x6bf0,
    0x6bf1,
    0x6bf2,
    0x6bf4,
    0x6bf6,
    0x6bf7,
    0x6bf8,
    0x6bfa,
    0x6bfb,
    0x6bfc,
    0x6bfe,
    0x6bff,
    0x6c00,
    0x6c01,
    0x6c02,
    0x6c03,
    0x6c04,
    0x6c08,
    0x6c09,
    0x6c0a,
    0x6c0b,
    0x6c0c,
    0x6c0e,
    0x6c12,
    0x6c17,
    0x6c1c,
    0x6c1d,
    0x6c1e,
    0x6c20,
    0x6c23,
    0x6c25,
    0x6c2b,
    0x6c2c,
    0x6c2d,
    0x6c31,
    0x6c33,
    0x6c36,
    0x6c37,
    0x6c39,
    0x6c3a,
    0x6c3b,
    0x6c3c,
    0x6c3e,
    0x6c3f,
    0x6c43,
    0x6c44,
    0x6c45,
    0x6c48,
    0x6c4b,
    0x6c4c,
    0x6c4d,
    0x6c4e,
    0x6c4f,
    0x6c51,
    0x6c52,
    0x6c53,
    0x6c56,
    0x6c58,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0x9b[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x6c59,
    0x6c5a,
    0x6c62,
    0x6c63,
    0x6c65,
    0x6c66,
    0x6c67,
    0x6c6b,
    0x6c6c,
    0x6c6d,
    0x6c6e,
    0x6c6f,
    0x6c71,
    0x6c73,
    0x6c75,
    0x6c77,
    0x6c78,
    0x6c7a,
    0x6c7b,
    0x6c7c,
    0x6c7f,
    0x6c80,
    0x6c84,
    0x6c87,
    0x6c8a,
    0x6c8b,
    0x6c8d,
    0x6c8e,
    0x6c91,
    0x6c92,
    0x6c95,
    0x6c96,
    0x6c97,
    0x6c98,
    0x6c9a,
    0x6c9c,
    0x6c9d,
    0x6c9e,
    0x6ca0,
    0x6ca2,
    0x6ca8,
    0x6cac,
    0x6caf,
    0x6cb0,
    0x6cb4,
    0x6cb5,
    0x6cb6,
    0x6cb7,
    0x6cba,
    0x6cc0,
    0x6cc1,
    0x6cc2,
    0x6cc3,
    0x6cc6,
    0x6cc7,
    0x6cc8,
    0x6ccb,
    0x6ccd,
    0x6cce,
    0x6ccf,
    0x6cd1,
    0x6cd2,
    0x6cd8,
    CP936_CP_VAL_NULL,
    0x6cd9,
    0x6cda,
    0x6cdc,
    0x6cdd,
    0x6cdf,
    0x6ce4,
    0x6ce6,
    0x6ce7,
    0x6ce9,
    0x6cec,
    0x6ced,
    0x6cf2,
    0x6cf4,
    0x6cf9,
    0x6cff,
    0x6d00,
    0x6d02,
    0x6d03,
    0x6d05,
    0x6d06,
    0x6d08,
    0x6d09,
    0x6d0a,
    0x6d0d,
    0x6d0f,
    0x6d10,
    0x6d11,
    0x6d13,
    0x6d14,
    0x6d15,
    0x6d16,
    0x6d18,
    0x6d1c,
    0x6d1d,
    0x6d1f,
    0x6d20,
    0x6d21,
    0x6d22,
    0x6d23,
    0x6d24,
    0x6d26,
    0x6d28,
    0x6d29,
    0x6d2c,
    0x6d2d,
    0x6d2f,
    0x6d30,
    0x6d34,
    0x6d36,
    0x6d37,
    0x6d38,
    0x6d3a,
    0x6d3f,
    0x6d40,
    0x6d42,
    0x6d44,
    0x6d49,
    0x6d4c,
    0x6d50,
    0x6d55,
    0x6d56,
    0x6d57,
    0x6d58,
    0x6d5b,
    0x6d5d,
    0x6d5f,
    0x6d61,
    0x6d62,
    0x6d64,
    0x6d65,
    0x6d67,
    0x6d68,
    0x6d6b,
    0x6d6c,
    0x6d6d,
    0x6d70,
    0x6d71,
    0x6d72,
    0x6d73,
    0x6d75,
    0x6d76,
    0x6d79,
    0x6d7a,
    0x6d7b,
    0x6d7d,
    0x6d7e,
    0x6d7f,
    0x6d80,
    0x6d81,
    0x6d83,
    0x6d84,
    0x6d86,
    0x6d87,
    0x6d8a,
    0x6d8b,
    0x6d8d,
    0x6d8f,
    0x6d90,
    0x6d92,
    0x6d96,
    0x6d97,
    0x6d98,
    0x6d99,
    0x6d9a,
    0x6d9c,
    0x6da2,
    0x6da5,
    0x6dac,
    0x6dad,
    0x6db0,
    0x6db1,
    0x6db3,
    0x6db4,
    0x6db6,
    0x6db7,
    0x6db9,
    0x6dba,
    0x6dbb,
    0x6dbc,
    0x6dbd,
    0x6dbe,
    0x6dc1,
    0x6dc2,
    0x6dc3,
    0x6dc8,
    0x6dc9,
    0x6dca,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0x9c[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x6dcd,
    0x6dce,
    0x6dcf,
    0x6dd0,
    0x6dd2,
    0x6dd3,
    0x6dd4,
    0x6dd5,
    0x6dd7,
    0x6dda,
    0x6ddb,
    0x6ddc,
    0x6ddf,
    0x6de2,
    0x6de3,
    0x6de5,
    0x6de7,
    0x6de8,
    0x6de9,
    0x6dea,
    0x6ded,
    0x6def,
    0x6df0,
    0x6df2,
    0x6df4,
    0x6df5,
    0x6df6,
    0x6df8,
    0x6dfa,
    0x6dfd,
    0x6dfe,
    0x6dff,
    0x6e00,
    0x6e01,
    0x6e02,
    0x6e03,
    0x6e04,
    0x6e06,
    0x6e07,
    0x6e08,
    0x6e09,
    0x6e0b,
    0x6e0f,
    0x6e12,
    0x6e13,
    0x6e15,
    0x6e18,
    0x6e19,
    0x6e1b,
    0x6e1c,
    0x6e1e,
    0x6e1f,
    0x6e22,
    0x6e26,
    0x6e27,
    0x6e28,
    0x6e2a,
    0x6e2c,
    0x6e2e,
    0x6e30,
    0x6e31,
    0x6e33,
    0x6e35,
    CP936_CP_VAL_NULL,
    0x6e36,
    0x6e37,
    0x6e39,
    0x6e3b,
    0x6e3c,
    0x6e3d,
    0x6e3e,
    0x6e3f,
    0x6e40,
    0x6e41,
    0x6e42,
    0x6e45,
    0x6e46,
    0x6e47,
    0x6e48,
    0x6e49,
    0x6e4a,
    0x6e4b,
    0x6e4c,
    0x6e4f,
    0x6e50,
    0x6e51,
    0x6e52,
    0x6e55,
    0x6e57,
    0x6e59,
    0x6e5a,
    0x6e5c,
    0x6e5d,
    0x6e5e,
    0x6e60,
    0x6e61,
    0x6e62,
    0x6e63,
    0x6e64,
    0x6e65,
    0x6e66,
    0x6e67,
    0x6e68,
    0x6e69,
    0x6e6a,
    0x6e6c,
    0x6e6d,
    0x6e6f,
    0x6e70,
    0x6e71,
    0x6e72,
    0x6e73,
    0x6e74,
    0x6e75,
    0x6e76,
    0x6e77,
    0x6e78,
    0x6e79,
    0x6e7a,
    0x6e7b,
    0x6e7c,
    0x6e7d,
    0x6e80,
    0x6e81,
    0x6e82,
    0x6e84,
    0x6e87,
    0x6e88,
    0x6e8a,
    0x6e8b,
    0x6e8c,
    0x6e8d,
    0x6e8e,
    0x6e91,
    0x6e92,
    0x6e93,
    0x6e94,
    0x6e95,
    0x6e96,
    0x6e97,
    0x6e99,
    0x6e9a,
    0x6e9b,
    0x6e9d,
    0x6e9e,
    0x6ea0,
    0x6ea1,
    0x6ea3,
    0x6ea4,
    0x6ea6,
    0x6ea8,
    0x6ea9,
    0x6eab,
    0x6eac,
    0x6ead,
    0x6eae,
    0x6eb0,
    0x6eb3,
    0x6eb5,
    0x6eb8,
    0x6eb9,
    0x6ebc,
    0x6ebe,
    0x6ebf,
    0x6ec0,
    0x6ec3,
    0x6ec4,
    0x6ec5,
    0x6ec6,
    0x6ec8,
    0x6ec9,
    0x6eca,
    0x6ecc,
    0x6ecd,
    0x6ece,
    0x6ed0,
    0x6ed2,
    0x6ed6,
    0x6ed8,
    0x6ed9,
    0x6edb,
    0x6edc,
    0x6edd,
    0x6ee3,
    0x6ee7,
    0x6eea,
    0x6eeb,
    0x6eec,
    0x6eed,
    0x6eee,
    0x6eef,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0x9d[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x6ef0,
    0x6ef1,
    0x6ef2,
    0x6ef3,
    0x6ef5,
    0x6ef6,
    0x6ef7,
    0x6ef8,
    0x6efa,
    0x6efb,
    0x6efc,
    0x6efd,
    0x6efe,
    0x6eff,
    0x6f00,
    0x6f01,
    0x6f03,
    0x6f04,
    0x6f05,
    0x6f07,
    0x6f08,
    0x6f0a,
    0x6f0b,
    0x6f0c,
    0x6f0d,
    0x6f0e,
    0x6f10,
    0x6f11,
    0x6f12,
    0x6f16,
    0x6f17,
    0x6f18,
    0x6f19,
    0x6f1a,
    0x6f1b,
    0x6f1c,
    0x6f1d,
    0x6f1e,
    0x6f1f,
    0x6f21,
    0x6f22,
    0x6f23,
    0x6f25,
    0x6f26,
    0x6f27,
    0x6f28,
    0x6f2c,
    0x6f2e,
    0x6f30,
    0x6f32,
    0x6f34,
    0x6f35,
    0x6f37,
    0x6f38,
    0x6f39,
    0x6f3a,
    0x6f3b,
    0x6f3c,
    0x6f3d,
    0x6f3f,
    0x6f40,
    0x6f41,
    0x6f42,
    CP936_CP_VAL_NULL,
    0x6f43,
    0x6f44,
    0x6f45,
    0x6f48,
    0x6f49,
    0x6f4a,
    0x6f4c,
    0x6f4e,
    0x6f4f,
    0x6f50,
    0x6f51,
    0x6f52,
    0x6f53,
    0x6f54,
    0x6f55,
    0x6f56,
    0x6f57,
    0x6f59,
    0x6f5a,
    0x6f5b,
    0x6f5d,
    0x6f5f,
    0x6f60,
    0x6f61,
    0x6f63,
    0x6f64,
    0x6f65,
    0x6f67,
    0x6f68,
    0x6f69,
    0x6f6a,
    0x6f6b,
    0x6f6c,
    0x6f6f,
    0x6f70,
    0x6f71,
    0x6f73,
    0x6f75,
    0x6f76,
    0x6f77,
    0x6f79,
    0x6f7b,
    0x6f7d,
    0x6f7e,
    0x6f7f,
    0x6f80,
    0x6f81,
    0x6f82,
    0x6f83,
    0x6f85,
    0x6f86,
    0x6f87,
    0x6f8a,
    0x6f8b,
    0x6f8f,
    0x6f90,
    0x6f91,
    0x6f92,
    0x6f93,
    0x6f94,
    0x6f95,
    0x6f96,
    0x6f97,
    0x6f98,
    0x6f99,
    0x6f9a,
    0x6f9b,
    0x6f9d,
    0x6f9e,
    0x6f9f,
    0x6fa0,
    0x6fa2,
    0x6fa3,
    0x6fa4,
    0x6fa5,
    0x6fa6,
    0x6fa8,
    0x6fa9,
    0x6faa,
    0x6fab,
    0x6fac,
    0x6fad,
    0x6fae,
    0x6faf,
    0x6fb0,
    0x6fb1,
    0x6fb2,
    0x6fb4,
    0x6fb5,
    0x6fb7,
    0x6fb8,
    0x6fba,
    0x6fbb,
    0x6fbc,
    0x6fbd,
    0x6fbe,
    0x6fbf,
    0x6fc1,
    0x6fc3,
    0x6fc4,
    0x6fc5,
    0x6fc6,
    0x6fc7,
    0x6fc8,
    0x6fca,
    0x6fcb,
    0x6fcc,
    0x6fcd,
    0x6fce,
    0x6fcf,
    0x6fd0,
    0x6fd3,
    0x6fd4,
    0x6fd5,
    0x6fd6,
    0x6fd7,
    0x6fd8,
    0x6fd9,
    0x6fda,
    0x6fdb,
    0x6fdc,
    0x6fdd,
    0x6fdf,
    0x6fe2,
    0x6fe3,
    0x6fe4,
    0x6fe5,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0x9e[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x6fe6,
    0x6fe7,
    0x6fe8,
    0x6fe9,
    0x6fea,
    0x6feb,
    0x6fec,
    0x6fed,
    0x6ff0,
    0x6ff1,
    0x6ff2,
    0x6ff3,
    0x6ff4,
    0x6ff5,
    0x6ff6,
    0x6ff7,
    0x6ff8,
    0x6ff9,
    0x6ffa,
    0x6ffb,
    0x6ffc,
    0x6ffd,
    0x6ffe,
    0x6fff,
    0x7000,
    0x7001,
    0x7002,
    0x7003,
    0x7004,
    0x7005,
    0x7006,
    0x7007,
    0x7008,
    0x7009,
    0x700a,
    0x700b,
    0x700c,
    0x700d,
    0x700e,
    0x700f,
    0x7010,
    0x7012,
    0x7013,
    0x7014,
    0x7015,
    0x7016,
    0x7017,
    0x7018,
    0x7019,
    0x701c,
    0x701d,
    0x701e,
    0x701f,
    0x7020,
    0x7021,
    0x7022,
    0x7024,
    0x7025,
    0x7026,
    0x7027,
    0x7028,
    0x7029,
    0x702a,
    CP936_CP_VAL_NULL,
    0x702b,
    0x702c,
    0x702d,
    0x702e,
    0x702f,
    0x7030,
    0x7031,
    0x7032,
    0x7033,
    0x7034,
    0x7036,
    0x7037,
    0x7038,
    0x703a,
    0x703b,
    0x703c,
    0x703d,
    0x703e,
    0x703f,
    0x7040,
    0x7041,
    0x7042,
    0x7043,
    0x7044,
    0x7045,
    0x7046,
    0x7047,
    0x7048,
    0x7049,
    0x704a,
    0x704b,
    0x704d,
    0x704e,
    0x7050,
    0x7051,
    0x7052,
    0x7053,
    0x7054,
    0x7055,
    0x7056,
    0x7057,
    0x7058,
    0x7059,
    0x705a,
    0x705b,
    0x705c,
    0x705d,
    0x705f,
    0x7060,
    0x7061,
    0x7062,
    0x7063,
    0x7064,
    0x7065,
    0x7066,
    0x7067,
    0x7068,
    0x7069,
    0x706a,
    0x706e,
    0x7071,
    0x7072,
    0x7073,
    0x7074,
    0x7077,
    0x7079,
    0x707a,
    0x707b,
    0x707d,
    0x7081,
    0x7082,
    0x7083,
    0x7084,
    0x7086,
    0x7087,
    0x7088,
    0x708b,
    0x708c,
    0x708d,
    0x708f,
    0x7090,
    0x7091,
    0x7093,
    0x7097,
    0x7098,
    0x709a,
    0x709b,
    0x709e,
    0x709f,
    0x70a0,
    0x70a1,
    0x70a2,
    0x70a3,
    0x70a4,
    0x70a5,
    0x70a6,
    0x70a7,
    0x70a8,
    0x70a9,
    0x70aa,
    0x70b0,
    0x70b2,
    0x70b4,
    0x70b5,
    0x70b6,
    0x70ba,
    0x70be,
    0x70bf,
    0x70c4,
    0x70c5,
    0x70c6,
    0x70c7,
    0x70c9,
    0x70cb,
    0x70cc,
    0x70cd,
    0x70ce,
    0x70cf,
    0x70d0,
    0x70d1,
    0x70d2,
    0x70d3,
    0x70d4,
    0x70d5,
    0x70d6,
    0x70d7,
    0x70da,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0x9f[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x70dc,
    0x70dd,
    0x70de,
    0x70e0,
    0x70e1,
    0x70e2,
    0x70e3,
    0x70e5,
    0x70ea,
    0x70ee,
    0x70f0,
    0x70f1,
    0x70f2,
    0x70f3,
    0x70f4,
    0x70f5,
    0x70f6,
    0x70f8,
    0x70fa,
    0x70fb,
    0x70fc,
    0x70fe,
    0x70ff,
    0x7100,
    0x7101,
    0x7102,
    0x7103,
    0x7104,
    0x7105,
    0x7106,
    0x7107,
    0x7108,
    0x710b,
    0x710c,
    0x710d,
    0x710e,
    0x710f,
    0x7111,
    0x7112,
    0x7114,
    0x7117,
    0x711b,
    0x711c,
    0x711d,
    0x711e,
    0x711f,
    0x7120,
    0x7121,
    0x7122,
    0x7123,
    0x7124,
    0x7125,
    0x7127,
    0x7128,
    0x7129,
    0x712a,
    0x712b,
    0x712c,
    0x712d,
    0x712e,
    0x7132,
    0x7133,
    0x7134,
    CP936_CP_VAL_NULL,
    0x7135,
    0x7137,
    0x7138,
    0x7139,
    0x713a,
    0x713b,
    0x713c,
    0x713d,
    0x713e,
    0x713f,
    0x7140,
    0x7141,
    0x7142,
    0x7143,
    0x7144,
    0x7146,
    0x7147,
    0x7148,
    0x7149,
    0x714b,
    0x714d,
    0x714f,
    0x7150,
    0x7151,
    0x7152,
    0x7153,
    0x7154,
    0x7155,
    0x7156,
    0x7157,
    0x7158,
    0x7159,
    0x715a,
    0x715b,
    0x715d,
    0x715f,
    0x7160,
    0x7161,
    0x7162,
    0x7163,
    0x7165,
    0x7169,
    0x716a,
    0x716b,
    0x716c,
    0x716d,
    0x716f,
    0x7170,
    0x7171,
    0x7174,
    0x7175,
    0x7176,
    0x7177,
    0x7179,
    0x717b,
    0x717c,
    0x717e,
    0x717f,
    0x7180,
    0x7181,
    0x7182,
    0x7183,
    0x7185,
    0x7186,
    0x7187,
    0x7188,
    0x7189,
    0x718b,
    0x718c,
    0x718d,
    0x718e,
    0x7190,
    0x7191,
    0x7192,
    0x7193,
    0x7195,
    0x7196,
    0x7197,
    0x719a,
    0x719b,
    0x719c,
    0x719d,
    0x719e,
    0x71a1,
    0x71a2,
    0x71a3,
    0x71a4,
    0x71a5,
    0x71a6,
    0x71a7,
    0x71a9,
    0x71aa,
    0x71ab,
    0x71ad,
    0x71ae,
    0x71af,
    0x71b0,
    0x71b1,
    0x71b2,
    0x71b4,
    0x71b6,
    0x71b7,
    0x71b8,
    0x71ba,
    0x71bb,
    0x71bc,
    0x71bd,
    0x71be,
    0x71bf,
    0x71c0,
    0x71c1,
    0x71c2,
    0x71c4,
    0x71c5,
    0x71c6,
    0x71c7,
    0x71c8,
    0x71c9,
    0x71ca,
    0x71cb,
    0x71cc,
    0x71cd,
    0x71cf,
    0x71d0,
    0x71d1,
    0x71d2,
    0x71d3,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xa0[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x71d6,
    0x71d7,
    0x71d8,
    0x71d9,
    0x71da,
    0x71db,
    0x71dc,
    0x71dd,
    0x71de,
    0x71df,
    0x71e1,
    0x71e2,
    0x71e3,
    0x71e4,
    0x71e6,
    0x71e8,
    0x71e9,
    0x71ea,
    0x71eb,
    0x71ec,
    0x71ed,
    0x71ef,
    0x71f0,
    0x71f1,
    0x71f2,
    0x71f3,
    0x71f4,
    0x71f5,
    0x71f6,
    0x71f7,
    0x71f8,
    0x71fa,
    0x71fb,
    0x71fc,
    0x71fd,
    0x71fe,
    0x71ff,
    0x7200,
    0x7201,
    0x7202,
    0x7203,
    0x7204,
    0x7205,
    0x7207,
    0x7208,
    0x7209,
    0x720a,
    0x720b,
    0x720c,
    0x720d,
    0x720e,
    0x720f,
    0x7210,
    0x7211,
    0x7212,
    0x7213,
    0x7214,
    0x7215,
    0x7216,
    0x7217,
    0x7218,
    0x7219,
    0x721a,
    CP936_CP_VAL_NULL,
    0x721b,
    0x721c,
    0x721e,
    0x721f,
    0x7220,
    0x7221,
    0x7222,
    0x7223,
    0x7224,
    0x7225,
    0x7226,
    0x7227,
    0x7229,
    0x722b,
    0x722d,
    0x722e,
    0x722f,
    0x7232,
    0x7233,
    0x7234,
    0x723a,
    0x723c,
    0x723e,
    0x7240,
    0x7241,
    0x7242,
    0x7243,
    0x7244,
    0x7245,
    0x7246,
    0x7249,
    0x724a,
    0x724b,
    0x724e,
    0x724f,
    0x7250,
    0x7251,
    0x7253,
    0x7254,
    0x7255,
    0x7257,
    0x7258,
    0x725a,
    0x725c,
    0x725e,
    0x7260,
    0x7263,
    0x7264,
    0x7265,
    0x7268,
    0x726a,
    0x726b,
    0x726c,
    0x726d,
    0x7270,
    0x7271,
    0x7273,
    0x7274,
    0x7276,
    0x7277,
    0x7278,
    0x727b,
    0x727c,
    0x727d,
    0x7282,
    0x7283,
    0x7285,
    0x7286,
    0x7287,
    0x7288,
    0x7289,
    0x728c,
    0x728e,
    0x7290,
    0x7291,
    0x7293,
    0x7294,
    0x7295,
    0x7296,
    0x7297,
    0x7298,
    0x7299,
    0x729a,
    0x729b,
    0x729c,
    0x729d,
    0x729e,
    0x72a0,
    0x72a1,
    0x72a2,
    0x72a3,
    0x72a4,
    0x72a5,
    0x72a6,
    0x72a7,
    0x72a8,
    0x72a9,
    0x72aa,
    0x72ab,
    0x72ae,
    0x72b1,
    0x72b2,
    0x72b3,
    0x72b5,
    0x72ba,
    0x72bb,
    0x72bc,
    0x72bd,
    0x72be,
    0x72bf,
    0x72c0,
    0x72c5,
    0x72c6,
    0x72c7,
    0x72c9,
    0x72ca,
    0x72cb,
    0x72cc,
    0x72cf,
    0x72d1,
    0x72d3,
    0x72d4,
    0x72d5,
    0x72d6,
    0x72d8,
    0x72da,
    0x72db,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xa1[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x3000,
    0x3001,
    0x3002,
    0xb7,
    0x2c9,
    0x2c7,
    0xa8,
    0x3003,
    0x3005,
    0x2014,
    0xff5e,
    0x2016,
    0x2026,
    0x2018,
    0x2019,
    0x201c,
    0x201d,
    0x3014,
    0x3015,
    0x3008,
    0x3009,
    0x300a,
    0x300b,
    0x300c,
    0x300d,
    0x300e,
    0x300f,
    0x3016,
    0x3017,
    0x3010,
    0x3011,
    0xb1,
    0xd7,
    0xf7,
    0x2236,
    0x2227,
    0x2228,
    0x2211,
    0x220f,
    0x222a,
    0x2229,
    0x2208,
    0x2237,
    0x221a,
    0x22a5,
    0x2225,
    0x2220,
    0x2312,
    0x2299,
    0x222b,
    0x222e,
    0x2261,
    0x224c,
    0x2248,
    0x223d,
    0x221d,
    0x2260,
    0x226e,
    0x226f,
    0x2264,
    0x2265,
    0x221e,
    0x2235,
    0x2234,
    0x2642,
    0x2640,
    0xb0,
    0x2032,
    0x2033,
    0x2103,
    0xff04,
    0xa4,
    0xffe0,
    0xffe1,
    0x2030,
    0xa7,
    0x2116,
    0x2606,
    0x2605,
    0x25cb,
    0x25cf,
    0x25ce,
    0x25c7,
    0x25c6,
    0x25a1,
    0x25a0,
    0x25b3,
    0x25b2,
    0x203b,
    0x2192,
    0x2190,
    0x2191,
    0x2193,
    0x3013,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xa2[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x2170,
    0x2171,
    0x2172,
    0x2173,
    0x2174,
    0x2175,
    0x2176,
    0x2177,
    0x2178,
    0x2179,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x2488,
    0x2489,
    0x248a,
    0x248b,
    0x248c,
    0x248d,
    0x248e,
    0x248f,
    0x2490,
    0x2491,
    0x2492,
    0x2493,
    0x2494,
    0x2495,
    0x2496,
    0x2497,
    0x2498,
    0x2499,
    0x249a,
    0x249b,
    0x2474,
    0x2475,
    0x2476,
    0x2477,
    0x2478,
    0x2479,
    0x247a,
    0x247b,
    0x247c,
    0x247d,
    0x247e,
    0x247f,
    0x2480,
    0x2481,
    0x2482,
    0x2483,
    0x2484,
    0x2485,
    0x2486,
    0x2487,
    0x2460,
    0x2461,
    0x2462,
    0x2463,
    0x2464,
    0x2465,
    0x2466,
    0x2467,
    0x2468,
    0x2469,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x3220,
    0x3221,
    0x3222,
    0x3223,
    0x3224,
    0x3225,
    0x3226,
    0x3227,
    0x3228,
    0x3229,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x2160,
    0x2161,
    0x2162,
    0x2163,
    0x2164,
    0x2165,
    0x2166,
    0x2167,
    0x2168,
    0x2169,
    0x216a,
    0x216b,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xa3[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0xff01,
    0xff02,
    0xff03,
    0xffe5,
    0xff05,
    0xff06,
    0xff07,
    0xff08,
    0xff09,
    0xff0a,
    0xff0b,
    0xff0c,
    0xff0d,
    0xff0e,
    0xff0f,
    0xff10,
    0xff11,
    0xff12,
    0xff13,
    0xff14,
    0xff15,
    0xff16,
    0xff17,
    0xff18,
    0xff19,
    0xff1a,
    0xff1b,
    0xff1c,
    0xff1d,
    0xff1e,
    0xff1f,
    0xff20,
    0xff21,
    0xff22,
    0xff23,
    0xff24,
    0xff25,
    0xff26,
    0xff27,
    0xff28,
    0xff29,
    0xff2a,
    0xff2b,
    0xff2c,
    0xff2d,
    0xff2e,
    0xff2f,
    0xff30,
    0xff31,
    0xff32,
    0xff33,
    0xff34,
    0xff35,
    0xff36,
    0xff37,
    0xff38,
    0xff39,
    0xff3a,
    0xff3b,
    0xff3c,
    0xff3d,
    0xff3e,
    0xff3f,
    0xff40,
    0xff41,
    0xff42,
    0xff43,
    0xff44,
    0xff45,
    0xff46,
    0xff47,
    0xff48,
    0xff49,
    0xff4a,
    0xff4b,
    0xff4c,
    0xff4d,
    0xff4e,
    0xff4f,
    0xff50,
    0xff51,
    0xff52,
    0xff53,
    0xff54,
    0xff55,
    0xff56,
    0xff57,
    0xff58,
    0xff59,
    0xff5a,
    0xff5b,
    0xff5c,
    0xff5d,
    0xffe3,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xa4[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x3041,
    0x3042,
    0x3043,
    0x3044,
    0x3045,
    0x3046,
    0x3047,
    0x3048,
    0x3049,
    0x304a,
    0x304b,
    0x304c,
    0x304d,
    0x304e,
    0x304f,
    0x3050,
    0x3051,
    0x3052,
    0x3053,
    0x3054,
    0x3055,
    0x3056,
    0x3057,
    0x3058,
    0x3059,
    0x305a,
    0x305b,
    0x305c,
    0x305d,
    0x305e,
    0x305f,
    0x3060,
    0x3061,
    0x3062,
    0x3063,
    0x3064,
    0x3065,
    0x3066,
    0x3067,
    0x3068,
    0x3069,
    0x306a,
    0x306b,
    0x306c,
    0x306d,
    0x306e,
    0x306f,
    0x3070,
    0x3071,
    0x3072,
    0x3073,
    0x3074,
    0x3075,
    0x3076,
    0x3077,
    0x3078,
    0x3079,
    0x307a,
    0x307b,
    0x307c,
    0x307d,
    0x307e,
    0x307f,
    0x3080,
    0x3081,
    0x3082,
    0x3083,
    0x3084,
    0x3085,
    0x3086,
    0x3087,
    0x3088,
    0x3089,
    0x308a,
    0x308b,
    0x308c,
    0x308d,
    0x308e,
    0x308f,
    0x3090,
    0x3091,
    0x3092,
    0x3093,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xa5[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x30a1,
    0x30a2,
    0x30a3,
    0x30a4,
    0x30a5,
    0x30a6,
    0x30a7,
    0x30a8,
    0x30a9,
    0x30aa,
    0x30ab,
    0x30ac,
    0x30ad,
    0x30ae,
    0x30af,
    0x30b0,
    0x30b1,
    0x30b2,
    0x30b3,
    0x30b4,
    0x30b5,
    0x30b6,
    0x30b7,
    0x30b8,
    0x30b9,
    0x30ba,
    0x30bb,
    0x30bc,
    0x30bd,
    0x30be,
    0x30bf,
    0x30c0,
    0x30c1,
    0x30c2,
    0x30c3,
    0x30c4,
    0x30c5,
    0x30c6,
    0x30c7,
    0x30c8,
    0x30c9,
    0x30ca,
    0x30cb,
    0x30cc,
    0x30cd,
    0x30ce,
    0x30cf,
    0x30d0,
    0x30d1,
    0x30d2,
    0x30d3,
    0x30d4,
    0x30d5,
    0x30d6,
    0x30d7,
    0x30d8,
    0x30d9,
    0x30da,
    0x30db,
    0x30dc,
    0x30dd,
    0x30de,
    0x30df,
    0x30e0,
    0x30e1,
    0x30e2,
    0x30e3,
    0x30e4,
    0x30e5,
    0x30e6,
    0x30e7,
    0x30e8,
    0x30e9,
    0x30ea,
    0x30eb,
    0x30ec,
    0x30ed,
    0x30ee,
    0x30ef,
    0x30f0,
    0x30f1,
    0x30f2,
    0x30f3,
    0x30f4,
    0x30f5,
    0x30f6,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xa6[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x391,
    0x392,
    0x393,
    0x394,
    0x395,
    0x396,
    0x397,
    0x398,
    0x399,
    0x39a,
    0x39b,
    0x39c,
    0x39d,
    0x39e,
    0x39f,
    0x3a0,
    0x3a1,
    0x3a3,
    0x3a4,
    0x3a5,
    0x3a6,
    0x3a7,
    0x3a8,
    0x3a9,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x3b1,
    0x3b2,
    0x3b3,
    0x3b4,
    0x3b5,
    0x3b6,
    0x3b7,
    0x3b8,
    0x3b9,
    0x3ba,
    0x3bb,
    0x3bc,
    0x3bd,
    0x3be,
    0x3bf,
    0x3c0,
    0x3c1,
    0x3c3,
    0x3c4,
    0x3c5,
    0x3c6,
    0x3c7,
    0x3c8,
    0x3c9,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0xfe35,
    0xfe36,
    0xfe39,
    0xfe3a,
    0xfe3f,
    0xfe40,
    0xfe3d,
    0xfe3e,
    0xfe41,
    0xfe42,
    0xfe43,
    0xfe44,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0xfe3b,
    0xfe3c,
    0xfe37,
    0xfe38,
    0xfe31,
    CP936_CP_VAL_NULL,
    0xfe33,
    0xfe34,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xa7[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x410,
    0x411,
    0x412,
    0x413,
    0x414,
    0x415,
    0x401,
    0x416,
    0x417,
    0x418,
    0x419,
    0x41a,
    0x41b,
    0x41c,
    0x41d,
    0x41e,
    0x41f,
    0x420,
    0x421,
    0x422,
    0x423,
    0x424,
    0x425,
    0x426,
    0x427,
    0x428,
    0x429,
    0x42a,
    0x42b,
    0x42c,
    0x42d,
    0x42e,
    0x42f,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x430,
    0x431,
    0x432,
    0x433,
    0x434,
    0x435,
    0x451,
    0x436,
    0x437,
    0x438,
    0x439,
    0x43a,
    0x43b,
    0x43c,
    0x43d,
    0x43e,
    0x43f,
    0x440,
    0x441,
    0x442,
    0x443,
    0x444,
    0x445,
    0x446,
    0x447,
    0x448,
    0x449,
    0x44a,
    0x44b,
    0x44c,
    0x44d,
    0x44e,
    0x44f,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xa8[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x2ca,
    0x2cb,
    0x2d9,
    0x2013,
    0x2015,
    0x2025,
    0x2035,
    0x2105,
    0x2109,
    0x2196,
    0x2197,
    0x2198,
    0x2199,
    0x2215,
    0x221f,
    0x2223,
    0x2252,
    0x2266,
    0x2267,
    0x22bf,
    0x2550,
    0x2551,
    0x2552,
    0x2553,
    0x2554,
    0x2555,
    0x2556,
    0x2557,
    0x2558,
    0x2559,
    0x255a,
    0x255b,
    0x255c,
    0x255d,
    0x255e,
    0x255f,
    0x2560,
    0x2561,
    0x2562,
    0x2563,
    0x2564,
    0x2565,
    0x2566,
    0x2567,
    0x2568,
    0x2569,
    0x256a,
    0x256b,
    0x256c,
    0x256d,
    0x256e,
    0x256f,
    0x2570,
    0x2571,
    0x2572,
    0x2573,
    0x2581,
    0x2582,
    0x2583,
    0x2584,
    0x2585,
    0x2586,
    0x2587,
    CP936_CP_VAL_NULL,
    0x2588,
    0x2589,
    0x258a,
    0x258b,
    0x258c,
    0x258d,
    0x258e,
    0x258f,
    0x2593,
    0x2594,
    0x2595,
    0x25bc,
    0x25bd,
    0x25e2,
    0x25e3,
    0x25e4,
    0x25e5,
    0x2609,
    0x2295,
    0x3012,
    0x301d,
    0x301e,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x101,
    0xe1,
    0x1ce,
    0xe0,
    0x113,
    0xe9,
    0x11b,
    0xe8,
    0x12b,
    0xed,
    0x1d0,
    0xec,
    0x14d,
    0xf3,
    0x1d2,
    0xf2,
    0x16b,
    0xfa,
    0x1d4,
    0xf9,
    0x1d6,
    0x1d8,
    0x1da,
    0x1dc,
    0xfc,
    0xea,
    0x251,
    CP936_CP_VAL_NULL,
    0x144,
    0x148,
    CP936_CP_VAL_NULL,
    0x261,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x3105,
    0x3106,
    0x3107,
    0x3108,
    0x3109,
    0x310a,
    0x310b,
    0x310c,
    0x310d,
    0x310e,
    0x310f,
    0x3110,
    0x3111,
    0x3112,
    0x3113,
    0x3114,
    0x3115,
    0x3116,
    0x3117,
    0x3118,
    0x3119,
    0x311a,
    0x311b,
    0x311c,
    0x311d,
    0x311e,
    0x311f,
    0x3120,
    0x3121,
    0x3122,
    0x3123,
    0x3124,
    0x3125,
    0x3126,
    0x3127,
    0x3128,
    0x3129,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xa9[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x3021,
    0x3022,
    0x3023,
    0x3024,
    0x3025,
    0x3026,
    0x3027,
    0x3028,
    0x3029,
    0x32a3,
    0x338e,
    0x338f,
    0x339c,
    0x339d,
    0x339e,
    0x33a1,
    0x33c4,
    0x33ce,
    0x33d1,
    0x33d2,
    0x33d5,
    0xfe30,
    0xffe2,
    0xffe4,
    CP936_CP_VAL_NULL,
    0x2121,
    0x3231,
    CP936_CP_VAL_NULL,
    0x2010,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x30fc,
    0x309b,
    0x309c,
    0x30fd,
    0x30fe,
    0x3006,
    0x309d,
    0x309e,
    0xfe49,
    0xfe4a,
    0xfe4b,
    0xfe4c,
    0xfe4d,
    0xfe4e,
    0xfe4f,
    0xfe50,
    0xfe51,
    0xfe52,
    0xfe54,
    0xfe55,
    0xfe56,
    0xfe57,
    0xfe59,
    0xfe5a,
    0xfe5b,
    0xfe5c,
    0xfe5d,
    0xfe5e,
    0xfe5f,
    0xfe60,
    0xfe61,
    CP936_CP_VAL_NULL,
    0xfe62,
    0xfe63,
    0xfe64,
    0xfe65,
    0xfe66,
    0xfe68,
    0xfe69,
    0xfe6a,
    0xfe6b,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x3007,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x2500,
    0x2501,
    0x2502,
    0x2503,
    0x2504,
    0x2505,
    0x2506,
    0x2507,
    0x2508,
    0x2509,
    0x250a,
    0x250b,
    0x250c,
    0x250d,
    0x250e,
    0x250f,
    0x2510,
    0x2511,
    0x2512,
    0x2513,
    0x2514,
    0x2515,
    0x2516,
    0x2517,
    0x2518,
    0x2519,
    0x251a,
    0x251b,
    0x251c,
    0x251d,
    0x251e,
    0x251f,
    0x2520,
    0x2521,
    0x2522,
    0x2523,
    0x2524,
    0x2525,
    0x2526,
    0x2527,
    0x2528,
    0x2529,
    0x252a,
    0x252b,
    0x252c,
    0x252d,
    0x252e,
    0x252f,
    0x2530,
    0x2531,
    0x2532,
    0x2533,
    0x2534,
    0x2535,
    0x2536,
    0x2537,
    0x2538,
    0x2539,
    0x253a,
    0x253b,
    0x253c,
    0x253d,
    0x253e,
    0x253f,
    0x2540,
    0x2541,
    0x2542,
    0x2543,
    0x2544,
    0x2545,
    0x2546,
    0x2547,
    0x2548,
    0x2549,
    0x254a,
    0x254b,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xaa[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x72dc,
    0x72dd,
    0x72df,
    0x72e2,
    0x72e3,
    0x72e4,
    0x72e5,
    0x72e6,
    0x72e7,
    0x72ea,
    0x72eb,
    0x72f5,
    0x72f6,
    0x72f9,
    0x72fd,
    0x72fe,
    0x72ff,
    0x7300,
    0x7302,
    0x7304,
    0x7305,
    0x7306,
    0x7307,
    0x7308,
    0x7309,
    0x730b,
    0x730c,
    0x730d,
    0x730f,
    0x7310,
    0x7311,
    0x7312,
    0x7314,
    0x7318,
    0x7319,
    0x731a,
    0x731f,
    0x7320,
    0x7323,
    0x7324,
    0x7326,
    0x7327,
    0x7328,
    0x732d,
    0x732f,
    0x7330,
    0x7332,
    0x7333,
    0x7335,
    0x7336,
    0x733a,
    0x733b,
    0x733c,
    0x733d,
    0x7340,
    0x7341,
    0x7342,
    0x7343,
    0x7344,
    0x7345,
    0x7346,
    0x7347,
    0x7348,
    CP936_CP_VAL_NULL,
    0x7349,
    0x734a,
    0x734b,
    0x734c,
    0x734e,
    0x734f,
    0x7351,
    0x7353,
    0x7354,
    0x7355,
    0x7356,
    0x7358,
    0x7359,
    0x735a,
    0x735b,
    0x735c,
    0x735d,
    0x735e,
    0x735f,
    0x7361,
    0x7362,
    0x7363,
    0x7364,
    0x7365,
    0x7366,
    0x7367,
    0x7368,
    0x7369,
    0x736a,
    0x736b,
    0x736e,
    0x7370,
    0x7371,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xab[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x7372,
    0x7373,
    0x7374,
    0x7375,
    0x7376,
    0x7377,
    0x7378,
    0x7379,
    0x737a,
    0x737b,
    0x737c,
    0x737d,
    0x737f,
    0x7380,
    0x7381,
    0x7382,
    0x7383,
    0x7385,
    0x7386,
    0x7388,
    0x738a,
    0x738c,
    0x738d,
    0x738f,
    0x7390,
    0x7392,
    0x7393,
    0x7394,
    0x7395,
    0x7397,
    0x7398,
    0x7399,
    0x739a,
    0x739c,
    0x739d,
    0x739e,
    0x73a0,
    0x73a1,
    0x73a3,
    0x73a4,
    0x73a5,
    0x73a6,
    0x73a7,
    0x73a8,
    0x73aa,
    0x73ac,
    0x73ad,
    0x73b1,
    0x73b4,
    0x73b5,
    0x73b6,
    0x73b8,
    0x73b9,
    0x73bc,
    0x73bd,
    0x73be,
    0x73bf,
    0x73c1,
    0x73c3,
    0x73c4,
    0x73c5,
    0x73c6,
    0x73c7,
    CP936_CP_VAL_NULL,
    0x73cb,
    0x73cc,
    0x73ce,
    0x73d2,
    0x73d3,
    0x73d4,
    0x73d5,
    0x73d6,
    0x73d7,
    0x73d8,
    0x73da,
    0x73db,
    0x73dc,
    0x73dd,
    0x73df,
    0x73e1,
    0x73e2,
    0x73e3,
    0x73e4,
    0x73e6,
    0x73e8,
    0x73ea,
    0x73eb,
    0x73ec,
    0x73ee,
    0x73ef,
    0x73f0,
    0x73f1,
    0x73f3,
    0x73f4,
    0x73f5,
    0x73f6,
    0x73f7,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xac[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x73f8,
    0x73f9,
    0x73fa,
    0x73fb,
    0x73fc,
    0x73fd,
    0x73fe,
    0x73ff,
    0x7400,
    0x7401,
    0x7402,
    0x7404,
    0x7407,
    0x7408,
    0x740b,
    0x740c,
    0x740d,
    0x740e,
    0x7411,
    0x7412,
    0x7413,
    0x7414,
    0x7415,
    0x7416,
    0x7417,
    0x7418,
    0x7419,
    0x741c,
    0x741d,
    0x741e,
    0x741f,
    0x7420,
    0x7421,
    0x7423,
    0x7424,
    0x7427,
    0x7429,
    0x742b,
    0x742d,
    0x742f,
    0x7431,
    0x7432,
    0x7437,
    0x7438,
    0x7439,
    0x743a,
    0x743b,
    0x743d,
    0x743e,
    0x743f,
    0x7440,
    0x7442,
    0x7443,
    0x7444,
    0x7445,
    0x7446,
    0x7447,
    0x7448,
    0x7449,
    0x744a,
    0x744b,
    0x744c,
    0x744d,
    CP936_CP_VAL_NULL,
    0x744e,
    0x744f,
    0x7450,
    0x7451,
    0x7452,
    0x7453,
    0x7454,
    0x7456,
    0x7458,
    0x745d,
    0x7460,
    0x7461,
    0x7462,
    0x7463,
    0x7464,
    0x7465,
    0x7466,
    0x7467,
    0x7468,
    0x7469,
    0x746a,
    0x746b,
    0x746c,
    0x746e,
    0x746f,
    0x7471,
    0x7472,
    0x7473,
    0x7474,
    0x7475,
    0x7478,
    0x7479,
    0x747a,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xad[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x747b,
    0x747c,
    0x747d,
    0x747f,
    0x7482,
    0x7484,
    0x7485,
    0x7486,
    0x7488,
    0x7489,
    0x748a,
    0x748c,
    0x748d,
    0x748f,
    0x7491,
    0x7492,
    0x7493,
    0x7494,
    0x7495,
    0x7496,
    0x7497,
    0x7498,
    0x7499,
    0x749a,
    0x749b,
    0x749d,
    0x749f,
    0x74a0,
    0x74a1,
    0x74a2,
    0x74a3,
    0x74a4,
    0x74a5,
    0x74a6,
    0x74aa,
    0x74ab,
    0x74ac,
    0x74ad,
    0x74ae,
    0x74af,
    0x74b0,
    0x74b1,
    0x74b2,
    0x74b3,
    0x74b4,
    0x74b5,
    0x74b6,
    0x74b7,
    0x74b8,
    0x74b9,
    0x74bb,
    0x74bc,
    0x74bd,
    0x74be,
    0x74bf,
    0x74c0,
    0x74c1,
    0x74c2,
    0x74c3,
    0x74c4,
    0x74c5,
    0x74c6,
    0x74c7,
    CP936_CP_VAL_NULL,
    0x74c8,
    0x74c9,
    0x74ca,
    0x74cb,
    0x74cc,
    0x74cd,
    0x74ce,
    0x74cf,
    0x74d0,
    0x74d1,
    0x74d3,
    0x74d4,
    0x74d5,
    0x74d6,
    0x74d7,
    0x74d8,
    0x74d9,
    0x74da,
    0x74db,
    0x74dd,
    0x74df,
    0x74e1,
    0x74e5,
    0x74e7,
    0x74e8,
    0x74e9,
    0x74ea,
    0x74eb,
    0x74ec,
    0x74ed,
    0x74f0,
    0x74f1,
    0x74f2,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xae[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x74f3,
    0x74f5,
    0x74f8,
    0x74f9,
    0x74fa,
    0x74fb,
    0x74fc,
    0x74fd,
    0x74fe,
    0x7500,
    0x7501,
    0x7502,
    0x7503,
    0x7505,
    0x7506,
    0x7507,
    0x7508,
    0x7509,
    0x750a,
    0x750b,
    0x750c,
    0x750e,
    0x7510,
    0x7512,
    0x7514,
    0x7515,
    0x7516,
    0x7517,
    0x751b,
    0x751d,
    0x751e,
    0x7520,
    0x7521,
    0x7522,
    0x7523,
    0x7524,
    0x7526,
    0x7527,
    0x752a,
    0x752e,
    0x7534,
    0x7536,
    0x7539,
    0x753c,
    0x753d,
    0x753f,
    0x7541,
    0x7542,
    0x7543,
    0x7544,
    0x7546,
    0x7547,
    0x7549,
    0x754a,
    0x754d,
    0x7550,
    0x7551,
    0x7552,
    0x7553,
    0x7555,
    0x7556,
    0x7557,
    0x7558,
    CP936_CP_VAL_NULL,
    0x755d,
    0x755e,
    0x755f,
    0x7560,
    0x7561,
    0x7562,
    0x7563,
    0x7564,
    0x7567,
    0x7568,
    0x7569,
    0x756b,
    0x756c,
    0x756d,
    0x756e,
    0x756f,
    0x7570,
    0x7571,
    0x7573,
    0x7575,
    0x7576,
    0x7577,
    0x757a,
    0x757b,
    0x757c,
    0x757d,
    0x757e,
    0x7580,
    0x7581,
    0x7582,
    0x7584,
    0x7585,
    0x7587,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xaf[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x7588,
    0x7589,
    0x758a,
    0x758c,
    0x758d,
    0x758e,
    0x7590,
    0x7593,
    0x7595,
    0x7598,
    0x759b,
    0x759c,
    0x759e,
    0x75a2,
    0x75a6,
    0x75a7,
    0x75a8,
    0x75a9,
    0x75aa,
    0x75ad,
    0x75b6,
    0x75b7,
    0x75ba,
    0x75bb,
    0x75bf,
    0x75c0,
    0x75c1,
    0x75c6,
    0x75cb,
    0x75cc,
    0x75ce,
    0x75cf,
    0x75d0,
    0x75d1,
    0x75d3,
    0x75d7,
    0x75d9,
    0x75da,
    0x75dc,
    0x75dd,
    0x75df,
    0x75e0,
    0x75e1,
    0x75e5,
    0x75e9,
    0x75ec,
    0x75ed,
    0x75ee,
    0x75ef,
    0x75f2,
    0x75f3,
    0x75f5,
    0x75f6,
    0x75f7,
    0x75f8,
    0x75fa,
    0x75fb,
    0x75fd,
    0x75fe,
    0x7602,
    0x7604,
    0x7606,
    0x7607,
    CP936_CP_VAL_NULL,
    0x7608,
    0x7609,
    0x760b,
    0x760d,
    0x760e,
    0x760f,
    0x7611,
    0x7612,
    0x7613,
    0x7614,
    0x7616,
    0x761a,
    0x761c,
    0x761d,
    0x761e,
    0x7621,
    0x7623,
    0x7627,
    0x7628,
    0x762c,
    0x762e,
    0x762f,
    0x7631,
    0x7632,
    0x7636,
    0x7637,
    0x7639,
    0x763a,
    0x763b,
    0x763d,
    0x7641,
    0x7642,
    0x7644,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xb0[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x7645,
    0x7646,
    0x7647,
    0x7648,
    0x7649,
    0x764a,
    0x764b,
    0x764e,
    0x764f,
    0x7650,
    0x7651,
    0x7652,
    0x7653,
    0x7655,
    0x7657,
    0x7658,
    0x7659,
    0x765a,
    0x765b,
    0x765d,
    0x765f,
    0x7660,
    0x7661,
    0x7662,
    0x7664,
    0x7665,
    0x7666,
    0x7667,
    0x7668,
    0x7669,
    0x766a,
    0x766c,
    0x766d,
    0x766e,
    0x7670,
    0x7671,
    0x7672,
    0x7673,
    0x7674,
    0x7675,
    0x7676,
    0x7677,
    0x7679,
    0x767a,
    0x767c,
    0x767f,
    0x7680,
    0x7681,
    0x7683,
    0x7685,
    0x7689,
    0x768a,
    0x768c,
    0x768d,
    0x768f,
    0x7690,
    0x7692,
    0x7694,
    0x7695,
    0x7697,
    0x7698,
    0x769a,
    0x769b,
    CP936_CP_VAL_NULL,
    0x769c,
    0x769d,
    0x769e,
    0x769f,
    0x76a0,
    0x76a1,
    0x76a2,
    0x76a3,
    0x76a5,
    0x76a6,
    0x76a7,
    0x76a8,
    0x76a9,
    0x76aa,
    0x76ab,
    0x76ac,
    0x76ad,
    0x76af,
    0x76b0,
    0x76b3,
    0x76b5,
    0x76b6,
    0x76b7,
    0x76b8,
    0x76b9,
    0x76ba,
    0x76bb,
    0x76bc,
    0x76bd,
    0x76be,
    0x76c0,
    0x76c1,
    0x76c3,
    0x554a,
    0x963f,
    0x57c3,
    0x6328,
    0x54ce,
    0x5509,
    0x54c0,
    0x7691,
    0x764c,
    0x853c,
    0x77ee,
    0x827e,
    0x788d,
    0x7231,
    0x9698,
    0x978d,
    0x6c28,
    0x5b89,
    0x4ffa,
    0x6309,
    0x6697,
    0x5cb8,
    0x80fa,
    0x6848,
    0x80ae,
    0x6602,
    0x76ce,
    0x51f9,
    0x6556,
    0x71ac,
    0x7ff1,
    0x8884,
    0x50b2,
    0x5965,
    0x61ca,
    0x6fb3,
    0x82ad,
    0x634c,
    0x6252,
    0x53ed,
    0x5427,
    0x7b06,
    0x516b,
    0x75a4,
    0x5df4,
    0x62d4,
    0x8dcb,
    0x9776,
    0x628a,
    0x8019,
    0x575d,
    0x9738,
    0x7f62,
    0x7238,
    0x767d,
    0x67cf,
    0x767e,
    0x6446,
    0x4f70,
    0x8d25,
    0x62dc,
    0x7a17,
    0x6591,
    0x73ed,
    0x642c,
    0x6273,
    0x822c,
    0x9881,
    0x677f,
    0x7248,
    0x626e,
    0x62cc,
    0x4f34,
    0x74e3,
    0x534a,
    0x529e,
    0x7eca,
    0x90a6,
    0x5e2e,
    0x6886,
    0x699c,
    0x8180,
    0x7ed1,
    0x68d2,
    0x78c5,
    0x868c,
    0x9551,
    0x508d,
    0x8c24,
    0x82de,
    0x80de,
    0x5305,
    0x8912,
    0x5265,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xb1[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x76c4,
    0x76c7,
    0x76c9,
    0x76cb,
    0x76cc,
    0x76d3,
    0x76d5,
    0x76d9,
    0x76da,
    0x76dc,
    0x76dd,
    0x76de,
    0x76e0,
    0x76e1,
    0x76e2,
    0x76e3,
    0x76e4,
    0x76e6,
    0x76e7,
    0x76e8,
    0x76e9,
    0x76ea,
    0x76eb,
    0x76ec,
    0x76ed,
    0x76f0,
    0x76f3,
    0x76f5,
    0x76f6,
    0x76f7,
    0x76fa,
    0x76fb,
    0x76fd,
    0x76ff,
    0x7700,
    0x7702,
    0x7703,
    0x7705,
    0x7706,
    0x770a,
    0x770c,
    0x770e,
    0x770f,
    0x7710,
    0x7711,
    0x7712,
    0x7713,
    0x7714,
    0x7715,
    0x7716,
    0x7717,
    0x7718,
    0x771b,
    0x771c,
    0x771d,
    0x771e,
    0x7721,
    0x7723,
    0x7724,
    0x7725,
    0x7727,
    0x772a,
    0x772b,
    CP936_CP_VAL_NULL,
    0x772c,
    0x772e,
    0x7730,
    0x7731,
    0x7732,
    0x7733,
    0x7734,
    0x7739,
    0x773b,
    0x773d,
    0x773e,
    0x773f,
    0x7742,
    0x7744,
    0x7745,
    0x7746,
    0x7748,
    0x7749,
    0x774a,
    0x774b,
    0x774c,
    0x774d,
    0x774e,
    0x774f,
    0x7752,
    0x7753,
    0x7754,
    0x7755,
    0x7756,
    0x7757,
    0x7758,
    0x7759,
    0x775c,
    0x8584,
    0x96f9,
    0x4fdd,
    0x5821,
    0x9971,
    0x5b9d,
    0x62b1,
    0x62a5,
    0x66b4,
    0x8c79,
    0x9c8d,
    0x7206,
    0x676f,
    0x7891,
    0x60b2,
    0x5351,
    0x5317,
    0x8f88,
    0x80cc,
    0x8d1d,
    0x94a1,
    0x500d,
    0x72c8,
    0x5907,
    0x60eb,
    0x7119,
    0x88ab,
    0x5954,
    0x82ef,
    0x672c,
    0x7b28,
    0x5d29,
    0x7ef7,
    0x752d,
    0x6cf5,
    0x8e66,
    0x8ff8,
    0x903c,
    0x9f3b,
    0x6bd4,
    0x9119,
    0x7b14,
    0x5f7c,
    0x78a7,
    0x84d6,
    0x853d,
    0x6bd5,
    0x6bd9,
    0x6bd6,
    0x5e01,
    0x5e87,
    0x75f9,
    0x95ed,
    0x655d,
    0x5f0a,
    0x5fc5,
    0x8f9f,
    0x58c1,
    0x81c2,
    0x907f,
    0x965b,
    0x97ad,
    0x8fb9,
    0x7f16,
    0x8d2c,
    0x6241,
    0x4fbf,
    0x53d8,
    0x535e,
    0x8fa8,
    0x8fa9,
    0x8fab,
    0x904d,
    0x6807,
    0x5f6a,
    0x8198,
    0x8868,
    0x9cd6,
    0x618b,
    0x522b,
    0x762a,
    0x5f6c,
    0x658c,
    0x6fd2,
    0x6ee8,
    0x5bbe,
    0x6448,
    0x5175,
    0x51b0,
    0x67c4,
    0x4e19,
    0x79c9,
    0x997c,
    0x70b3,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xb2[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x775d,
    0x775e,
    0x775f,
    0x7760,
    0x7764,
    0x7767,
    0x7769,
    0x776a,
    0x776d,
    0x776e,
    0x776f,
    0x7770,
    0x7771,
    0x7772,
    0x7773,
    0x7774,
    0x7775,
    0x7776,
    0x7777,
    0x7778,
    0x777a,
    0x777b,
    0x777c,
    0x7781,
    0x7782,
    0x7783,
    0x7786,
    0x7787,
    0x7788,
    0x7789,
    0x778a,
    0x778b,
    0x778f,
    0x7790,
    0x7793,
    0x7794,
    0x7795,
    0x7796,
    0x7797,
    0x7798,
    0x7799,
    0x779a,
    0x779b,
    0x779c,
    0x779d,
    0x779e,
    0x77a1,
    0x77a3,
    0x77a4,
    0x77a6,
    0x77a8,
    0x77ab,
    0x77ad,
    0x77ae,
    0x77af,
    0x77b1,
    0x77b2,
    0x77b4,
    0x77b6,
    0x77b7,
    0x77b8,
    0x77b9,
    0x77ba,
    CP936_CP_VAL_NULL,
    0x77bc,
    0x77be,
    0x77c0,
    0x77c1,
    0x77c2,
    0x77c3,
    0x77c4,
    0x77c5,
    0x77c6,
    0x77c7,
    0x77c8,
    0x77c9,
    0x77ca,
    0x77cb,
    0x77cc,
    0x77ce,
    0x77cf,
    0x77d0,
    0x77d1,
    0x77d2,
    0x77d3,
    0x77d4,
    0x77d5,
    0x77d6,
    0x77d8,
    0x77d9,
    0x77da,
    0x77dd,
    0x77de,
    0x77df,
    0x77e0,
    0x77e1,
    0x77e4,
    0x75c5,
    0x5e76,
    0x73bb,
    0x83e0,
    0x64ad,
    0x62e8,
    0x94b5,
    0x6ce2,
    0x535a,
    0x52c3,
    0x640f,
    0x94c2,
    0x7b94,
    0x4f2f,
    0x5e1b,
    0x8236,
    0x8116,
    0x818a,
    0x6e24,
    0x6cca,
    0x9a73,
    0x6355,
    0x535c,
    0x54fa,
    0x8865,
    0x57e0,
    0x4e0d,
    0x5e03,
    0x6b65,
    0x7c3f,
    0x90e8,
    0x6016,
    0x64e6,
    0x731c,
    0x88c1,
    0x6750,
    0x624d,
    0x8d22,
    0x776c,
    0x8e29,
    0x91c7,
    0x5f69,
    0x83dc,
    0x8521,
    0x9910,
    0x53c2,
    0x8695,
    0x6b8b,
    0x60ed,
    0x60e8,
    0x707f,
    0x82cd,
    0x8231,
    0x4ed3,
    0x6ca7,
    0x85cf,
    0x64cd,
    0x7cd9,
    0x69fd,
    0x66f9,
    0x8349,
    0x5395,
    0x7b56,
    0x4fa7,
    0x518c,
    0x6d4b,
    0x5c42,
    0x8e6d,
    0x63d2,
    0x53c9,
    0x832c,
    0x8336,
    0x67e5,
    0x78b4,
    0x643d,
    0x5bdf,
    0x5c94,
    0x5dee,
    0x8be7,
    0x62c6,
    0x67f4,
    0x8c7a,
    0x6400,
    0x63ba,
    0x8749,
    0x998b,
    0x8c17,
    0x7f20,
    0x94f2,
    0x4ea7,
    0x9610,
    0x98a4,
    0x660c,
    0x7316,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xb3[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x77e6,
    0x77e8,
    0x77ea,
    0x77ef,
    0x77f0,
    0x77f1,
    0x77f2,
    0x77f4,
    0x77f5,
    0x77f7,
    0x77f9,
    0x77fa,
    0x77fb,
    0x77fc,
    0x7803,
    0x7804,
    0x7805,
    0x7806,
    0x7807,
    0x7808,
    0x780a,
    0x780b,
    0x780e,
    0x780f,
    0x7810,
    0x7813,
    0x7815,
    0x7819,
    0x781b,
    0x781e,
    0x7820,
    0x7821,
    0x7822,
    0x7824,
    0x7828,
    0x782a,
    0x782b,
    0x782e,
    0x782f,
    0x7831,
    0x7832,
    0x7833,
    0x7835,
    0x7836,
    0x783d,
    0x783f,
    0x7841,
    0x7842,
    0x7843,
    0x7844,
    0x7846,
    0x7848,
    0x7849,
    0x784a,
    0x784b,
    0x784d,
    0x784f,
    0x7851,
    0x7853,
    0x7854,
    0x7858,
    0x7859,
    0x785a,
    CP936_CP_VAL_NULL,
    0x785b,
    0x785c,
    0x785e,
    0x785f,
    0x7860,
    0x7861,
    0x7862,
    0x7863,
    0x7864,
    0x7865,
    0x7866,
    0x7867,
    0x7868,
    0x7869,
    0x786f,
    0x7870,
    0x7871,
    0x7872,
    0x7873,
    0x7874,
    0x7875,
    0x7876,
    0x7878,
    0x7879,
    0x787a,
    0x787b,
    0x787d,
    0x787e,
    0x787f,
    0x7880,
    0x7881,
    0x7882,
    0x7883,
    0x573a,
    0x5c1d,
    0x5e38,
    0x957f,
    0x507f,
    0x80a0,
    0x5382,
    0x655e,
    0x7545,
    0x5531,
    0x5021,
    0x8d85,
    0x6284,
    0x949e,
    0x671d,
    0x5632,
    0x6f6e,
    0x5de2,
    0x5435,
    0x7092,
    0x8f66,
    0x626f,
    0x64a4,
    0x63a3,
    0x5f7b,
    0x6f88,
    0x90f4,
    0x81e3,
    0x8fb0,
    0x5c18,
    0x6668,
    0x5ff1,
    0x6c89,
    0x9648,
    0x8d81,
    0x886c,
    0x6491,
    0x79f0,
    0x57ce,
    0x6a59,
    0x6210,
    0x5448,
    0x4e58,
    0x7a0b,
    0x60e9,
    0x6f84,
    0x8bda,
    0x627f,
    0x901e,
    0x9a8b,
    0x79e4,
    0x5403,
    0x75f4,
    0x6301,
    0x5319,
    0x6c60,
    0x8fdf,
    0x5f1b,
    0x9a70,
    0x803b,
    0x9f7f,
    0x4f88,
    0x5c3a,
    0x8d64,
    0x7fc5,
    0x65a5,
    0x70bd,
    0x5145,
    0x51b2,
    0x866b,
    0x5d07,
    0x5ba0,
    0x62bd,
    0x916c,
    0x7574,
    0x8e0c,
    0x7a20,
    0x6101,
    0x7b79,
    0x4ec7,
    0x7ef8,
    0x7785,
    0x4e11,
    0x81ed,
    0x521d,
    0x51fa,
    0x6a71,
    0x53a8,
    0x8e87,
    0x9504,
    0x96cf,
    0x6ec1,
    0x9664,
    0x695a,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xb4[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x7884,
    0x7885,
    0x7886,
    0x7888,
    0x788a,
    0x788b,
    0x788f,
    0x7890,
    0x7892,
    0x7894,
    0x7895,
    0x7896,
    0x7899,
    0x789d,
    0x789e,
    0x78a0,
    0x78a2,
    0x78a4,
    0x78a6,
    0x78a8,
    0x78a9,
    0x78aa,
    0x78ab,
    0x78ac,
    0x78ad,
    0x78ae,
    0x78af,
    0x78b5,
    0x78b6,
    0x78b7,
    0x78b8,
    0x78ba,
    0x78bb,
    0x78bc,
    0x78bd,
    0x78bf,
    0x78c0,
    0x78c2,
    0x78c3,
    0x78c4,
    0x78c6,
    0x78c7,
    0x78c8,
    0x78cc,
    0x78cd,
    0x78ce,
    0x78cf,
    0x78d1,
    0x78d2,
    0x78d3,
    0x78d6,
    0x78d7,
    0x78d8,
    0x78da,
    0x78db,
    0x78dc,
    0x78dd,
    0x78de,
    0x78df,
    0x78e0,
    0x78e1,
    0x78e2,
    0x78e3,
    CP936_CP_VAL_NULL,
    0x78e4,
    0x78e5,
    0x78e6,
    0x78e7,
    0x78e9,
    0x78ea,
    0x78eb,
    0x78ed,
    0x78ee,
    0x78ef,
    0x78f0,
    0x78f1,
    0x78f3,
    0x78f5,
    0x78f6,
    0x78f8,
    0x78f9,
    0x78fb,
    0x78fc,
    0x78fd,
    0x78fe,
    0x78ff,
    0x7900,
    0x7902,
    0x7903,
    0x7904,
    0x7906,
    0x7907,
    0x7908,
    0x7909,
    0x790a,
    0x790b,
    0x790c,
    0x7840,
    0x50a8,
    0x77d7,
    0x6410,
    0x89e6,
    0x5904,
    0x63e3,
    0x5ddd,
    0x7a7f,
    0x693d,
    0x4f20,
    0x8239,
    0x5598,
    0x4e32,
    0x75ae,
    0x7a97,
    0x5e62,
    0x5e8a,
    0x95ef,
    0x521b,
    0x5439,
    0x708a,
    0x6376,
    0x9524,
    0x5782,
    0x6625,
    0x693f,
    0x9187,
    0x5507,
    0x6df3,
    0x7eaf,
    0x8822,
    0x6233,
    0x7ef0,
    0x75b5,
    0x8328,
    0x78c1,
    0x96cc,
    0x8f9e,
    0x6148,
    0x74f7,
    0x8bcd,
    0x6b64,
    0x523a,
    0x8d50,
    0x6b21,
    0x806a,
    0x8471,
    0x56f1,
    0x5306,
    0x4ece,
    0x4e1b,
    0x51d1,
    0x7c97,
    0x918b,
    0x7c07,
    0x4fc3,
    0x8e7f,
    0x7be1,
    0x7a9c,
    0x6467,
    0x5d14,
    0x50ac,
    0x8106,
    0x7601,
    0x7cb9,
    0x6dec,
    0x7fe0,
    0x6751,
    0x5b58,
    0x5bf8,
    0x78cb,
    0x64ae,
    0x6413,
    0x63aa,
    0x632b,
    0x9519,
    0x642d,
    0x8fbe,
    0x7b54,
    0x7629,
    0x6253,
    0x5927,
    0x5446,
    0x6b79,
    0x50a3,
    0x6234,
    0x5e26,
    0x6b86,
    0x4ee3,
    0x8d37,
    0x888b,
    0x5f85,
    0x902e,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xb5[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x790d,
    0x790e,
    0x790f,
    0x7910,
    0x7911,
    0x7912,
    0x7914,
    0x7915,
    0x7916,
    0x7917,
    0x7918,
    0x7919,
    0x791a,
    0x791b,
    0x791c,
    0x791d,
    0x791f,
    0x7920,
    0x7921,
    0x7922,
    0x7923,
    0x7925,
    0x7926,
    0x7927,
    0x7928,
    0x7929,
    0x792a,
    0x792b,
    0x792c,
    0x792d,
    0x792e,
    0x792f,
    0x7930,
    0x7931,
    0x7932,
    0x7933,
    0x7935,
    0x7936,
    0x7937,
    0x7938,
    0x7939,
    0x793d,
    0x793f,
    0x7942,
    0x7943,
    0x7944,
    0x7945,
    0x7947,
    0x794a,
    0x794b,
    0x794c,
    0x794d,
    0x794e,
    0x794f,
    0x7950,
    0x7951,
    0x7952,
    0x7954,
    0x7955,
    0x7958,
    0x7959,
    0x7961,
    0x7963,
    CP936_CP_VAL_NULL,
    0x7964,
    0x7966,
    0x7969,
    0x796a,
    0x796b,
    0x796c,
    0x796e,
    0x7970,
    0x7971,
    0x7972,
    0x7973,
    0x7974,
    0x7975,
    0x7976,
    0x7979,
    0x797b,
    0x797c,
    0x797d,
    0x797e,
    0x797f,
    0x7982,
    0x7983,
    0x7986,
    0x7987,
    0x7988,
    0x7989,
    0x798b,
    0x798c,
    0x798d,
    0x798e,
    0x7990,
    0x7991,
    0x7992,
    0x6020,
    0x803d,
    0x62c5,
    0x4e39,
    0x5355,
    0x90f8,
    0x63b8,
    0x80c6,
    0x65e6,
    0x6c2e,
    0x4f46,
    0x60ee,
    0x6de1,
    0x8bde,
    0x5f39,
    0x86cb,
    0x5f53,
    0x6321,
    0x515a,
    0x8361,
    0x6863,
    0x5200,
    0x6363,
    0x8e48,
    0x5012,
    0x5c9b,
    0x7977,
    0x5bfc,
    0x5230,
    0x7a3b,
    0x60bc,
    0x9053,
    0x76d7,
    0x5fb7,
    0x5f97,
    0x7684,
    0x8e6c,
    0x706f,
    0x767b,
    0x7b49,
    0x77aa,
    0x51f3,
    0x9093,
    0x5824,
    0x4f4e,
    0x6ef4,
    0x8fea,
    0x654c,
    0x7b1b,
    0x72c4,
    0x6da4,
    0x7fdf,
    0x5ae1,
    0x62b5,
    0x5e95,
    0x5730,
    0x8482,
    0x7b2c,
    0x5e1d,
    0x5f1f,
    0x9012,
    0x7f14,
    0x98a0,
    0x6382,
    0x6ec7,
    0x7898,
    0x70b9,
    0x5178,
    0x975b,
    0x57ab,
    0x7535,
    0x4f43,
    0x7538,
    0x5e97,
    0x60e6,
    0x5960,
    0x6dc0,
    0x6bbf,
    0x7889,
    0x53fc,
    0x96d5,
    0x51cb,
    0x5201,
    0x6389,
    0x540a,
    0x9493,
    0x8c03,
    0x8dcc,
    0x7239,
    0x789f,
    0x8776,
    0x8fed,
    0x8c0d,
    0x53e0,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xb6[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x7993,
    0x7994,
    0x7995,
    0x7996,
    0x7997,
    0x7998,
    0x7999,
    0x799b,
    0x799c,
    0x799d,
    0x799e,
    0x799f,
    0x79a0,
    0x79a1,
    0x79a2,
    0x79a3,
    0x79a4,
    0x79a5,
    0x79a6,
    0x79a8,
    0x79a9,
    0x79aa,
    0x79ab,
    0x79ac,
    0x79ad,
    0x79ae,
    0x79af,
    0x79b0,
    0x79b1,
    0x79b2,
    0x79b4,
    0x79b5,
    0x79b6,
    0x79b7,
    0x79b8,
    0x79bc,
    0x79bf,
    0x79c2,
    0x79c4,
    0x79c5,
    0x79c7,
    0x79c8,
    0x79ca,
    0x79cc,
    0x79ce,
    0x79cf,
    0x79d0,
    0x79d3,
    0x79d4,
    0x79d6,
    0x79d7,
    0x79d9,
    0x79da,
    0x79db,
    0x79dc,
    0x79dd,
    0x79de,
    0x79e0,
    0x79e1,
    0x79e2,
    0x79e5,
    0x79e8,
    0x79ea,
    CP936_CP_VAL_NULL,
    0x79ec,
    0x79ee,
    0x79f1,
    0x79f2,
    0x79f3,
    0x79f4,
    0x79f5,
    0x79f6,
    0x79f7,
    0x79f9,
    0x79fa,
    0x79fc,
    0x79fe,
    0x79ff,
    0x7a01,
    0x7a04,
    0x7a05,
    0x7a07,
    0x7a08,
    0x7a09,
    0x7a0a,
    0x7a0c,
    0x7a0f,
    0x7a10,
    0x7a11,
    0x7a12,
    0x7a13,
    0x7a15,
    0x7a16,
    0x7a18,
    0x7a19,
    0x7a1b,
    0x7a1c,
    0x4e01,
    0x76ef,
    0x53ee,
    0x9489,
    0x9876,
    0x9f0e,
    0x952d,
    0x5b9a,
    0x8ba2,
    0x4e22,
    0x4e1c,
    0x51ac,
    0x8463,
    0x61c2,
    0x52a8,
    0x680b,
    0x4f97,
    0x606b,
    0x51bb,
    0x6d1e,
    0x515c,
    0x6296,
    0x6597,
    0x9661,
    0x8c46,
    0x9017,
    0x75d8,
    0x90fd,
    0x7763,
    0x6bd2,
    0x728a,
    0x72ec,
    0x8bfb,
    0x5835,
    0x7779,
    0x8d4c,
    0x675c,
    0x9540,
    0x809a,
    0x5ea6,
    0x6e21,
    0x5992,
    0x7aef,
    0x77ed,
    0x953b,
    0x6bb5,
    0x65ad,
    0x7f0e,
    0x5806,
    0x5151,
    0x961f,
    0x5bf9,
    0x58a9,
    0x5428,
    0x8e72,
    0x6566,
    0x987f,
    0x56e4,
    0x949d,
    0x76fe,
    0x9041,
    0x6387,
    0x54c6,
    0x591a,
    0x593a,
    0x579b,
    0x8eb2,
    0x6735,
    0x8dfa,
    0x8235,
    0x5241,
    0x60f0,
    0x5815,
    0x86fe,
    0x5ce8,
    0x9e45,
    0x4fc4,
    0x989d,
    0x8bb9,
    0x5a25,
    0x6076,
    0x5384,
    0x627c,
    0x904f,
    0x9102,
    0x997f,
    0x6069,
    0x800c,
    0x513f,
    0x8033,
    0x5c14,
    0x9975,
    0x6d31,
    0x4e8c,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xb7[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x7a1d,
    0x7a1f,
    0x7a21,
    0x7a22,
    0x7a24,
    0x7a25,
    0x7a26,
    0x7a27,
    0x7a28,
    0x7a29,
    0x7a2a,
    0x7a2b,
    0x7a2c,
    0x7a2d,
    0x7a2e,
    0x7a2f,
    0x7a30,
    0x7a31,
    0x7a32,
    0x7a34,
    0x7a35,
    0x7a36,
    0x7a38,
    0x7a3a,
    0x7a3e,
    0x7a40,
    0x7a41,
    0x7a42,
    0x7a43,
    0x7a44,
    0x7a45,
    0x7a47,
    0x7a48,
    0x7a49,
    0x7a4a,
    0x7a4b,
    0x7a4c,
    0x7a4d,
    0x7a4e,
    0x7a4f,
    0x7a50,
    0x7a52,
    0x7a53,
    0x7a54,
    0x7a55,
    0x7a56,
    0x7a58,
    0x7a59,
    0x7a5a,
    0x7a5b,
    0x7a5c,
    0x7a5d,
    0x7a5e,
    0x7a5f,
    0x7a60,
    0x7a61,
    0x7a62,
    0x7a63,
    0x7a64,
    0x7a65,
    0x7a66,
    0x7a67,
    0x7a68,
    CP936_CP_VAL_NULL,
    0x7a69,
    0x7a6a,
    0x7a6b,
    0x7a6c,
    0x7a6d,
    0x7a6e,
    0x7a6f,
    0x7a71,
    0x7a72,
    0x7a73,
    0x7a75,
    0x7a7b,
    0x7a7c,
    0x7a7d,
    0x7a7e,
    0x7a82,
    0x7a85,
    0x7a87,
    0x7a89,
    0x7a8a,
    0x7a8b,
    0x7a8c,
    0x7a8e,
    0x7a8f,
    0x7a90,
    0x7a93,
    0x7a94,
    0x7a99,
    0x7a9a,
    0x7a9b,
    0x7a9e,
    0x7aa1,
    0x7aa2,
    0x8d30,
    0x53d1,
    0x7f5a,
    0x7b4f,
    0x4f10,
    0x4e4f,
    0x9600,
    0x6cd5,
    0x73d0,
    0x85e9,
    0x5e06,
    0x756a,
    0x7ffb,
    0x6a0a,
    0x77fe,
    0x9492,
    0x7e41,
    0x51e1,
    0x70e6,
    0x53cd,
    0x8fd4,
    0x8303,
    0x8d29,
    0x72af,
    0x996d,
    0x6cdb,
    0x574a,
    0x82b3,
    0x65b9,
    0x80aa,
    0x623f,
    0x9632,
    0x59a8,
    0x4eff,
    0x8bbf,
    0x7eba,
    0x653e,
    0x83f2,
    0x975e,
    0x5561,
    0x98de,
    0x80a5,
    0x532a,
    0x8bfd,
    0x5420,
    0x80ba,
    0x5e9f,
    0x6cb8,
    0x8d39,
    0x82ac,
    0x915a,
    0x5429,
    0x6c1b,
    0x5206,
    0x7eb7,
    0x575f,
    0x711a,
    0x6c7e,
    0x7c89,
    0x594b,
    0x4efd,
    0x5fff,
    0x6124,
    0x7caa,
    0x4e30,
    0x5c01,
    0x67ab,
    0x8702,
    0x5cf0,
    0x950b,
    0x98ce,
    0x75af,
    0x70fd,
    0x9022,
    0x51af,
    0x7f1d,
    0x8bbd,
    0x5949,
    0x51e4,
    0x4f5b,
    0x5426,
    0x592b,
    0x6577,
    0x80a4,
    0x5b75,
    0x6276,
    0x62c2,
    0x8f90,
    0x5e45,
    0x6c1f,
    0x7b26,
    0x4f0f,
    0x4fd8,
    0x670d,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xb8[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x7aa3,
    0x7aa4,
    0x7aa7,
    0x7aa9,
    0x7aaa,
    0x7aab,
    0x7aae,
    0x7aaf,
    0x7ab0,
    0x7ab1,
    0x7ab2,
    0x7ab4,
    0x7ab5,
    0x7ab6,
    0x7ab7,
    0x7ab8,
    0x7ab9,
    0x7aba,
    0x7abb,
    0x7abc,
    0x7abd,
    0x7abe,
    0x7ac0,
    0x7ac1,
    0x7ac2,
    0x7ac3,
    0x7ac4,
    0x7ac5,
    0x7ac6,
    0x7ac7,
    0x7ac8,
    0x7ac9,
    0x7aca,
    0x7acc,
    0x7acd,
    0x7ace,
    0x7acf,
    0x7ad0,
    0x7ad1,
    0x7ad2,
    0x7ad3,
    0x7ad4,
    0x7ad5,
    0x7ad7,
    0x7ad8,
    0x7ada,
    0x7adb,
    0x7adc,
    0x7add,
    0x7ae1,
    0x7ae2,
    0x7ae4,
    0x7ae7,
    0x7ae8,
    0x7ae9,
    0x7aea,
    0x7aeb,
    0x7aec,
    0x7aee,
    0x7af0,
    0x7af1,
    0x7af2,
    0x7af3,
    CP936_CP_VAL_NULL,
    0x7af4,
    0x7af5,
    0x7af6,
    0x7af7,
    0x7af8,
    0x7afb,
    0x7afc,
    0x7afe,
    0x7b00,
    0x7b01,
    0x7b02,
    0x7b05,
    0x7b07,
    0x7b09,
    0x7b0c,
    0x7b0d,
    0x7b0e,
    0x7b10,
    0x7b12,
    0x7b13,
    0x7b16,
    0x7b17,
    0x7b18,
    0x7b1a,
    0x7b1c,
    0x7b1d,
    0x7b1f,
    0x7b21,
    0x7b22,
    0x7b23,
    0x7b27,
    0x7b29,
    0x7b2d,
    0x6d6e,
    0x6daa,
    0x798f,
    0x88b1,
    0x5f17,
    0x752b,
    0x629a,
    0x8f85,
    0x4fef,
    0x91dc,
    0x65a7,
    0x812f,
    0x8151,
    0x5e9c,
    0x8150,
    0x8d74,
    0x526f,
    0x8986,
    0x8d4b,
    0x590d,
    0x5085,
    0x4ed8,
    0x961c,
    0x7236,
    0x8179,
    0x8d1f,
    0x5bcc,
    0x8ba3,
    0x9644,
    0x5987,
    0x7f1a,
    0x5490,
    0x5676,
    0x560e,
    0x8be5,
    0x6539,
    0x6982,
    0x9499,
    0x76d6,
    0x6e89,
    0x5e72,
    0x7518,
    0x6746,
    0x67d1,
    0x7aff,
    0x809d,
    0x8d76,
    0x611f,
    0x79c6,
    0x6562,
    0x8d63,
    0x5188,
    0x521a,
    0x94a2,
    0x7f38,
    0x809b,
    0x7eb2,
    0x5c97,
    0x6e2f,
    0x6760,
    0x7bd9,
    0x768b,
    0x9ad8,
    0x818f,
    0x7f94,
    0x7cd5,
    0x641e,
    0x9550,
    0x7a3f,
    0x544a,
    0x54e5,
    0x6b4c,
    0x6401,
    0x6208,
    0x9e3d,
    0x80f3,
    0x7599,
    0x5272,
    0x9769,
    0x845b,
    0x683c,
    0x86e4,
    0x9601,
    0x9694,
    0x94ec,
    0x4e2a,
    0x5404,
    0x7ed9,
    0x6839,
    0x8ddf,
    0x8015,
    0x66f4,
    0x5e9a,
    0x7fb9,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xb9[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x7b2f,
    0x7b30,
    0x7b32,
    0x7b34,
    0x7b35,
    0x7b36,
    0x7b37,
    0x7b39,
    0x7b3b,
    0x7b3d,
    0x7b3f,
    0x7b40,
    0x7b41,
    0x7b42,
    0x7b43,
    0x7b44,
    0x7b46,
    0x7b48,
    0x7b4a,
    0x7b4d,
    0x7b4e,
    0x7b53,
    0x7b55,
    0x7b57,
    0x7b59,
    0x7b5c,
    0x7b5e,
    0x7b5f,
    0x7b61,
    0x7b63,
    0x7b64,
    0x7b65,
    0x7b66,
    0x7b67,
    0x7b68,
    0x7b69,
    0x7b6a,
    0x7b6b,
    0x7b6c,
    0x7b6d,
    0x7b6f,
    0x7b70,
    0x7b73,
    0x7b74,
    0x7b76,
    0x7b78,
    0x7b7a,
    0x7b7c,
    0x7b7d,
    0x7b7f,
    0x7b81,
    0x7b82,
    0x7b83,
    0x7b84,
    0x7b86,
    0x7b87,
    0x7b88,
    0x7b89,
    0x7b8a,
    0x7b8b,
    0x7b8c,
    0x7b8e,
    0x7b8f,
    CP936_CP_VAL_NULL,
    0x7b91,
    0x7b92,
    0x7b93,
    0x7b96,
    0x7b98,
    0x7b99,
    0x7b9a,
    0x7b9b,
    0x7b9e,
    0x7b9f,
    0x7ba0,
    0x7ba3,
    0x7ba4,
    0x7ba5,
    0x7bae,
    0x7baf,
    0x7bb0,
    0x7bb2,
    0x7bb3,
    0x7bb5,
    0x7bb6,
    0x7bb7,
    0x7bb9,
    0x7bba,
    0x7bbb,
    0x7bbc,
    0x7bbd,
    0x7bbe,
    0x7bbf,
    0x7bc0,
    0x7bc2,
    0x7bc3,
    0x7bc4,
    0x57c2,
    0x803f,
    0x6897,
    0x5de5,
    0x653b,
    0x529f,
    0x606d,
    0x9f9a,
    0x4f9b,
    0x8eac,
    0x516c,
    0x5bab,
    0x5f13,
    0x5de9,
    0x6c5e,
    0x62f1,
    0x8d21,
    0x5171,
    0x94a9,
    0x52fe,
    0x6c9f,
    0x82df,
    0x72d7,
    0x57a2,
    0x6784,
    0x8d2d,
    0x591f,
    0x8f9c,
    0x83c7,
    0x5495,
    0x7b8d,
    0x4f30,
    0x6cbd,
    0x5b64,
    0x59d1,
    0x9f13,
    0x53e4,
    0x86ca,
    0x9aa8,
    0x8c37,
    0x80a1,
    0x6545,
    0x987e,
    0x56fa,
    0x96c7,
    0x522e,
    0x74dc,
    0x5250,
    0x5be1,
    0x6302,
    0x8902,
    0x4e56,
    0x62d0,
    0x602a,
    0x68fa,
    0x5173,
    0x5b98,
    0x51a0,
    0x89c2,
    0x7ba1,
    0x9986,
    0x7f50,
    0x60ef,
    0x704c,
    0x8d2f,
    0x5149,
    0x5e7f,
    0x901b,
    0x7470,
    0x89c4,
    0x572d,
    0x7845,
    0x5f52,
    0x9f9f,
    0x95fa,
    0x8f68,
    0x9b3c,
    0x8be1,
    0x7678,
    0x6842,
    0x67dc,
    0x8dea,
    0x8d35,
    0x523d,
    0x8f8a,
    0x6eda,
    0x68cd,
    0x9505,
    0x90ed,
    0x56fd,
    0x679c,
    0x88f9,
    0x8fc7,
    0x54c8,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xba[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x7bc5,
    0x7bc8,
    0x7bc9,
    0x7bca,
    0x7bcb,
    0x7bcd,
    0x7bce,
    0x7bcf,
    0x7bd0,
    0x7bd2,
    0x7bd4,
    0x7bd5,
    0x7bd6,
    0x7bd7,
    0x7bd8,
    0x7bdb,
    0x7bdc,
    0x7bde,
    0x7bdf,
    0x7be0,
    0x7be2,
    0x7be3,
    0x7be4,
    0x7be7,
    0x7be8,
    0x7be9,
    0x7beb,
    0x7bec,
    0x7bed,
    0x7bef,
    0x7bf0,
    0x7bf2,
    0x7bf3,
    0x7bf4,
    0x7bf5,
    0x7bf6,
    0x7bf8,
    0x7bf9,
    0x7bfa,
    0x7bfb,
    0x7bfd,
    0x7bff,
    0x7c00,
    0x7c01,
    0x7c02,
    0x7c03,
    0x7c04,
    0x7c05,
    0x7c06,
    0x7c08,
    0x7c09,
    0x7c0a,
    0x7c0d,
    0x7c0e,
    0x7c10,
    0x7c11,
    0x7c12,
    0x7c13,
    0x7c14,
    0x7c15,
    0x7c17,
    0x7c18,
    0x7c19,
    CP936_CP_VAL_NULL,
    0x7c1a,
    0x7c1b,
    0x7c1c,
    0x7c1d,
    0x7c1e,
    0x7c20,
    0x7c21,
    0x7c22,
    0x7c23,
    0x7c24,
    0x7c25,
    0x7c28,
    0x7c29,
    0x7c2b,
    0x7c2c,
    0x7c2d,
    0x7c2e,
    0x7c2f,
    0x7c30,
    0x7c31,
    0x7c32,
    0x7c33,
    0x7c34,
    0x7c35,
    0x7c36,
    0x7c37,
    0x7c39,
    0x7c3a,
    0x7c3b,
    0x7c3c,
    0x7c3d,
    0x7c3e,
    0x7c42,
    0x9ab8,
    0x5b69,
    0x6d77,
    0x6c26,
    0x4ea5,
    0x5bb3,
    0x9a87,
    0x9163,
    0x61a8,
    0x90af,
    0x97e9,
    0x542b,
    0x6db5,
    0x5bd2,
    0x51fd,
    0x558a,
    0x7f55,
    0x7ff0,
    0x64bc,
    0x634d,
    0x65f1,
    0x61be,
    0x608d,
    0x710a,
    0x6c57,
    0x6c49,
    0x592f,
    0x676d,
    0x822a,
    0x58d5,
    0x568e,
    0x8c6a,
    0x6beb,
    0x90dd,
    0x597d,
    0x8017,
    0x53f7,
    0x6d69,
    0x5475,
    0x559d,
    0x8377,
    0x83cf,
    0x6838,
    0x79be,
    0x548c,
    0x4f55,
    0x5408,
    0x76d2,
    0x8c89,
    0x9602,
    0x6cb3,
    0x6db8,
    0x8d6b,
    0x8910,
    0x9e64,
    0x8d3a,
    0x563f,
    0x9ed1,
    0x75d5,
    0x5f88,
    0x72e0,
    0x6068,
    0x54fc,
    0x4ea8,
    0x6a2a,
    0x8861,
    0x6052,
    0x8f70,
    0x54c4,
    0x70d8,
    0x8679,
    0x9e3f,
    0x6d2a,
    0x5b8f,
    0x5f18,
    0x7ea2,
    0x5589,
    0x4faf,
    0x7334,
    0x543c,
    0x539a,
    0x5019,
    0x540e,
    0x547c,
    0x4e4e,
    0x5ffd,
    0x745a,
    0x58f6,
    0x846b,
    0x80e1,
    0x8774,
    0x72d0,
    0x7cca,
    0x6e56,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xbb[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x7c43,
    0x7c44,
    0x7c45,
    0x7c46,
    0x7c47,
    0x7c48,
    0x7c49,
    0x7c4a,
    0x7c4b,
    0x7c4c,
    0x7c4e,
    0x7c4f,
    0x7c50,
    0x7c51,
    0x7c52,
    0x7c53,
    0x7c54,
    0x7c55,
    0x7c56,
    0x7c57,
    0x7c58,
    0x7c59,
    0x7c5a,
    0x7c5b,
    0x7c5c,
    0x7c5d,
    0x7c5e,
    0x7c5f,
    0x7c60,
    0x7c61,
    0x7c62,
    0x7c63,
    0x7c64,
    0x7c65,
    0x7c66,
    0x7c67,
    0x7c68,
    0x7c69,
    0x7c6a,
    0x7c6b,
    0x7c6c,
    0x7c6d,
    0x7c6e,
    0x7c6f,
    0x7c70,
    0x7c71,
    0x7c72,
    0x7c75,
    0x7c76,
    0x7c77,
    0x7c78,
    0x7c79,
    0x7c7a,
    0x7c7e,
    0x7c7f,
    0x7c80,
    0x7c81,
    0x7c82,
    0x7c83,
    0x7c84,
    0x7c85,
    0x7c86,
    0x7c87,
    CP936_CP_VAL_NULL,
    0x7c88,
    0x7c8a,
    0x7c8b,
    0x7c8c,
    0x7c8d,
    0x7c8e,
    0x7c8f,
    0x7c90,
    0x7c93,
    0x7c94,
    0x7c96,
    0x7c99,
    0x7c9a,
    0x7c9b,
    0x7ca0,
    0x7ca1,
    0x7ca3,
    0x7ca6,
    0x7ca7,
    0x7ca8,
    0x7ca9,
    0x7cab,
    0x7cac,
    0x7cad,
    0x7caf,
    0x7cb0,
    0x7cb4,
    0x7cb5,
    0x7cb6,
    0x7cb7,
    0x7cb8,
    0x7cba,
    0x7cbb,
    0x5f27,
    0x864e,
    0x552c,
    0x62a4,
    0x4e92,
    0x6caa,
    0x6237,
    0x82b1,
    0x54d7,
    0x534e,
    0x733e,
    0x6ed1,
    0x753b,
    0x5212,
    0x5316,
    0x8bdd,
    0x69d0,
    0x5f8a,
    0x6000,
    0x6dee,
    0x574f,
    0x6b22,
    0x73af,
    0x6853,
    0x8fd8,
    0x7f13,
    0x6362,
    0x60a3,
    0x5524,
    0x75ea,
    0x8c62,
    0x7115,
    0x6da3,
    0x5ba6,
    0x5e7b,
    0x8352,
    0x614c,
    0x9ec4,
    0x78fa,
    0x8757,
    0x7c27,
    0x7687,
    0x51f0,
    0x60f6,
    0x714c,
    0x6643,
    0x5e4c,
    0x604d,
    0x8c0e,
    0x7070,
    0x6325,
    0x8f89,
    0x5fbd,
    0x6062,
    0x86d4,
    0x56de,
    0x6bc1,
    0x6094,
    0x6167,
    0x5349,
    0x60e0,
    0x6666,
    0x8d3f,
    0x79fd,
    0x4f1a,
    0x70e9,
    0x6c47,
    0x8bb3,
    0x8bf2,
    0x7ed8,
    0x8364,
    0x660f,
    0x5a5a,
    0x9b42,
    0x6d51,
    0x6df7,
    0x8c41,
    0x6d3b,
    0x4f19,
    0x706b,
    0x83b7,
    0x6216,
    0x60d1,
    0x970d,
    0x8d27,
    0x7978,
    0x51fb,
    0x573e,
    0x57fa,
    0x673a,
    0x7578,
    0x7a3d,
    0x79ef,
    0x7b95,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xbc[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x7cbf,
    0x7cc0,
    0x7cc2,
    0x7cc3,
    0x7cc4,
    0x7cc6,
    0x7cc9,
    0x7ccb,
    0x7cce,
    0x7ccf,
    0x7cd0,
    0x7cd1,
    0x7cd2,
    0x7cd3,
    0x7cd4,
    0x7cd8,
    0x7cda,
    0x7cdb,
    0x7cdd,
    0x7cde,
    0x7ce1,
    0x7ce2,
    0x7ce3,
    0x7ce4,
    0x7ce5,
    0x7ce6,
    0x7ce7,
    0x7ce9,
    0x7cea,
    0x7ceb,
    0x7cec,
    0x7ced,
    0x7cee,
    0x7cf0,
    0x7cf1,
    0x7cf2,
    0x7cf3,
    0x7cf4,
    0x7cf5,
    0x7cf6,
    0x7cf7,
    0x7cf9,
    0x7cfa,
    0x7cfc,
    0x7cfd,
    0x7cfe,
    0x7cff,
    0x7d00,
    0x7d01,
    0x7d02,
    0x7d03,
    0x7d04,
    0x7d05,
    0x7d06,
    0x7d07,
    0x7d08,
    0x7d09,
    0x7d0b,
    0x7d0c,
    0x7d0d,
    0x7d0e,
    0x7d0f,
    0x7d10,
    CP936_CP_VAL_NULL,
    0x7d11,
    0x7d12,
    0x7d13,
    0x7d14,
    0x7d15,
    0x7d16,
    0x7d17,
    0x7d18,
    0x7d19,
    0x7d1a,
    0x7d1b,
    0x7d1c,
    0x7d1d,
    0x7d1e,
    0x7d1f,
    0x7d21,
    0x7d23,
    0x7d24,
    0x7d25,
    0x7d26,
    0x7d28,
    0x7d29,
    0x7d2a,
    0x7d2c,
    0x7d2d,
    0x7d2e,
    0x7d30,
    0x7d31,
    0x7d32,
    0x7d33,
    0x7d34,
    0x7d35,
    0x7d36,
    0x808c,
    0x9965,
    0x8ff9,
    0x6fc0,
    0x8ba5,
    0x9e21,
    0x59ec,
    0x7ee9,
    0x7f09,
    0x5409,
    0x6781,
    0x68d8,
    0x8f91,
    0x7c4d,
    0x96c6,
    0x53ca,
    0x6025,
    0x75be,
    0x6c72,
    0x5373,
    0x5ac9,
    0x7ea7,
    0x6324,
    0x51e0,
    0x810a,
    0x5df1,
    0x84df,
    0x6280,
    0x5180,
    0x5b63,
    0x4f0e,
    0x796d,
    0x5242,
    0x60b8,
    0x6d4e,
    0x5bc4,
    0x5bc2,
    0x8ba1,
    0x8bb0,
    0x65e2,
    0x5fcc,
    0x9645,
    0x5993,
    0x7ee7,
    0x7eaa,
    0x5609,
    0x67b7,
    0x5939,
    0x4f73,
    0x5bb6,
    0x52a0,
    0x835a,
    0x988a,
    0x8d3e,
    0x7532,
    0x94be,
    0x5047,
    0x7a3c,
    0x4ef7,
    0x67b6,
    0x9a7e,
    0x5ac1,
    0x6b7c,
    0x76d1,
    0x575a,
    0x5c16,
    0x7b3a,
    0x95f4,
    0x714e,
    0x517c,
    0x80a9,
    0x8270,
    0x5978,
    0x7f04,
    0x8327,
    0x68c0,
    0x67ec,
    0x78b1,
    0x7877,
    0x62e3,
    0x6361,
    0x7b80,
    0x4fed,
    0x526a,
    0x51cf,
    0x8350,
    0x69db,
    0x9274,
    0x8df5,
    0x8d31,
    0x89c1,
    0x952e,
    0x7bad,
    0x4ef6,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xbd[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x7d37,
    0x7d38,
    0x7d39,
    0x7d3a,
    0x7d3b,
    0x7d3c,
    0x7d3d,
    0x7d3e,
    0x7d3f,
    0x7d40,
    0x7d41,
    0x7d42,
    0x7d43,
    0x7d44,
    0x7d45,
    0x7d46,
    0x7d47,
    0x7d48,
    0x7d49,
    0x7d4a,
    0x7d4b,
    0x7d4c,
    0x7d4d,
    0x7d4e,
    0x7d4f,
    0x7d50,
    0x7d51,
    0x7d52,
    0x7d53,
    0x7d54,
    0x7d55,
    0x7d56,
    0x7d57,
    0x7d58,
    0x7d59,
    0x7d5a,
    0x7d5b,
    0x7d5c,
    0x7d5d,
    0x7d5e,
    0x7d5f,
    0x7d60,
    0x7d61,
    0x7d62,
    0x7d63,
    0x7d64,
    0x7d65,
    0x7d66,
    0x7d67,
    0x7d68,
    0x7d69,
    0x7d6a,
    0x7d6b,
    0x7d6c,
    0x7d6d,
    0x7d6f,
    0x7d70,
    0x7d71,
    0x7d72,
    0x7d73,
    0x7d74,
    0x7d75,
    0x7d76,
    CP936_CP_VAL_NULL,
    0x7d78,
    0x7d79,
    0x7d7a,
    0x7d7b,
    0x7d7c,
    0x7d7d,
    0x7d7e,
    0x7d7f,
    0x7d80,
    0x7d81,
    0x7d82,
    0x7d83,
    0x7d84,
    0x7d85,
    0x7d86,
    0x7d87,
    0x7d88,
    0x7d89,
    0x7d8a,
    0x7d8b,
    0x7d8c,
    0x7d8d,
    0x7d8e,
    0x7d8f,
    0x7d90,
    0x7d91,
    0x7d92,
    0x7d93,
    0x7d94,
    0x7d95,
    0x7d96,
    0x7d97,
    0x7d98,
    0x5065,
    0x8230,
    0x5251,
    0x996f,
    0x6e10,
    0x6e85,
    0x6da7,
    0x5efa,
    0x50f5,
    0x59dc,
    0x5c06,
    0x6d46,
    0x6c5f,
    0x7586,
    0x848b,
    0x6868,
    0x5956,
    0x8bb2,
    0x5320,
    0x9171,
    0x964d,
    0x8549,
    0x6912,
    0x7901,
    0x7126,
    0x80f6,
    0x4ea4,
    0x90ca,
    0x6d47,
    0x9a84,
    0x5a07,
    0x56bc,
    0x6405,
    0x94f0,
    0x77eb,
    0x4fa5,
    0x811a,
    0x72e1,
    0x89d2,
    0x997a,
    0x7f34,
    0x7ede,
    0x527f,
    0x6559,
    0x9175,
    0x8f7f,
    0x8f83,
    0x53eb,
    0x7a96,
    0x63ed,
    0x63a5,
    0x7686,
    0x79f8,
    0x8857,
    0x9636,
    0x622a,
    0x52ab,
    0x8282,
    0x6854,
    0x6770,
    0x6377,
    0x776b,
    0x7aed,
    0x6d01,
    0x7ed3,
    0x89e3,
    0x59d0,
    0x6212,
    0x85c9,
    0x82a5,
    0x754c,
    0x501f,
    0x4ecb,
    0x75a5,
    0x8beb,
    0x5c4a,
    0x5dfe,
    0x7b4b,
    0x65a4,
    0x91d1,
    0x4eca,
    0x6d25,
    0x895f,
    0x7d27,
    0x9526,
    0x4ec5,
    0x8c28,
    0x8fdb,
    0x9773,
    0x664b,
    0x7981,
    0x8fd1,
    0x70ec,
    0x6d78,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xbe[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x7d99,
    0x7d9a,
    0x7d9b,
    0x7d9c,
    0x7d9d,
    0x7d9e,
    0x7d9f,
    0x7da0,
    0x7da1,
    0x7da2,
    0x7da3,
    0x7da4,
    0x7da5,
    0x7da7,
    0x7da8,
    0x7da9,
    0x7daa,
    0x7dab,
    0x7dac,
    0x7dad,
    0x7daf,
    0x7db0,
    0x7db1,
    0x7db2,
    0x7db3,
    0x7db4,
    0x7db5,
    0x7db6,
    0x7db7,
    0x7db8,
    0x7db9,
    0x7dba,
    0x7dbb,
    0x7dbc,
    0x7dbd,
    0x7dbe,
    0x7dbf,
    0x7dc0,
    0x7dc1,
    0x7dc2,
    0x7dc3,
    0x7dc4,
    0x7dc5,
    0x7dc6,
    0x7dc7,
    0x7dc8,
    0x7dc9,
    0x7dca,
    0x7dcb,
    0x7dcc,
    0x7dcd,
    0x7dce,
    0x7dcf,
    0x7dd0,
    0x7dd1,
    0x7dd2,
    0x7dd3,
    0x7dd4,
    0x7dd5,
    0x7dd6,
    0x7dd7,
    0x7dd8,
    0x7dd9,
    CP936_CP_VAL_NULL,
    0x7dda,
    0x7ddb,
    0x7ddc,
    0x7ddd,
    0x7dde,
    0x7ddf,
    0x7de0,
    0x7de1,
    0x7de2,
    0x7de3,
    0x7de4,
    0x7de5,
    0x7de6,
    0x7de7,
    0x7de8,
    0x7de9,
    0x7dea,
    0x7deb,
    0x7dec,
    0x7ded,
    0x7dee,
    0x7def,
    0x7df0,
    0x7df1,
    0x7df2,
    0x7df3,
    0x7df4,
    0x7df5,
    0x7df6,
    0x7df7,
    0x7df8,
    0x7df9,
    0x7dfa,
    0x5c3d,
    0x52b2,
    0x8346,
    0x5162,
    0x830e,
    0x775b,
    0x6676,
    0x9cb8,
    0x4eac,
    0x60ca,
    0x7cbe,
    0x7cb3,
    0x7ecf,
    0x4e95,
    0x8b66,
    0x666f,
    0x9888,
    0x9759,
    0x5883,
    0x656c,
    0x955c,
    0x5f84,
    0x75c9,
    0x9756,
    0x7adf,
    0x7ade,
    0x51c0,
    0x70af,
    0x7a98,
    0x63ea,
    0x7a76,
    0x7ea0,
    0x7396,
    0x97ed,
    0x4e45,
    0x7078,
    0x4e5d,
    0x9152,
    0x53a9,
    0x6551,
    0x65e7,
    0x81fc,
    0x8205,
    0x548e,
    0x5c31,
    0x759a,
    0x97a0,
    0x62d8,
    0x72d9,
    0x75bd,
    0x5c45,
    0x9a79,
    0x83ca,
    0x5c40,
    0x5480,
    0x77e9,
    0x4e3e,
    0x6cae,
    0x805a,
    0x62d2,
    0x636e,
    0x5de8,
    0x5177,
    0x8ddd,
    0x8e1e,
    0x952f,
    0x4ff1,
    0x53e5,
    0x60e7,
    0x70ac,
    0x5267,
    0x6350,
    0x9e43,
    0x5a1f,
    0x5026,
    0x7737,
    0x5377,
    0x7ee2,
    0x6485,
    0x652b,
    0x6289,
    0x6398,
    0x5014,
    0x7235,
    0x89c9,
    0x51b3,
    0x8bc0,
    0x7edd,
    0x5747,
    0x83cc,
    0x94a7,
    0x519b,
    0x541b,
    0x5cfb,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xbf[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x7dfb,
    0x7dfc,
    0x7dfd,
    0x7dfe,
    0x7dff,
    0x7e00,
    0x7e01,
    0x7e02,
    0x7e03,
    0x7e04,
    0x7e05,
    0x7e06,
    0x7e07,
    0x7e08,
    0x7e09,
    0x7e0a,
    0x7e0b,
    0x7e0c,
    0x7e0d,
    0x7e0e,
    0x7e0f,
    0x7e10,
    0x7e11,
    0x7e12,
    0x7e13,
    0x7e14,
    0x7e15,
    0x7e16,
    0x7e17,
    0x7e18,
    0x7e19,
    0x7e1a,
    0x7e1b,
    0x7e1c,
    0x7e1d,
    0x7e1e,
    0x7e1f,
    0x7e20,
    0x7e21,
    0x7e22,
    0x7e23,
    0x7e24,
    0x7e25,
    0x7e26,
    0x7e27,
    0x7e28,
    0x7e29,
    0x7e2a,
    0x7e2b,
    0x7e2c,
    0x7e2d,
    0x7e2e,
    0x7e2f,
    0x7e30,
    0x7e31,
    0x7e32,
    0x7e33,
    0x7e34,
    0x7e35,
    0x7e36,
    0x7e37,
    0x7e38,
    0x7e39,
    CP936_CP_VAL_NULL,
    0x7e3a,
    0x7e3c,
    0x7e3d,
    0x7e3e,
    0x7e3f,
    0x7e40,
    0x7e42,
    0x7e43,
    0x7e44,
    0x7e45,
    0x7e46,
    0x7e48,
    0x7e49,
    0x7e4a,
    0x7e4b,
    0x7e4c,
    0x7e4d,
    0x7e4e,
    0x7e4f,
    0x7e50,
    0x7e51,
    0x7e52,
    0x7e53,
    0x7e54,
    0x7e55,
    0x7e56,
    0x7e57,
    0x7e58,
    0x7e59,
    0x7e5a,
    0x7e5b,
    0x7e5c,
    0x7e5d,
    0x4fca,
    0x7ae3,
    0x6d5a,
    0x90e1,
    0x9a8f,
    0x5580,
    0x5496,
    0x5361,
    0x54af,
    0x5f00,
    0x63e9,
    0x6977,
    0x51ef,
    0x6168,
    0x520a,
    0x582a,
    0x52d8,
    0x574e,
    0x780d,
    0x770b,
    0x5eb7,
    0x6177,
    0x7ce0,
    0x625b,
    0x6297,
    0x4ea2,
    0x7095,
    0x8003,
    0x62f7,
    0x70e4,
    0x9760,
    0x5777,
    0x82db,
    0x67ef,
    0x68f5,
    0x78d5,
    0x9897,
    0x79d1,
    0x58f3,
    0x54b3,
    0x53ef,
    0x6e34,
    0x514b,
    0x523b,
    0x5ba2,
    0x8bfe,
    0x80af,
    0x5543,
    0x57a6,
    0x6073,
    0x5751,
    0x542d,
    0x7a7a,
    0x6050,
    0x5b54,
    0x63a7,
    0x62a0,
    0x53e3,
    0x6263,
    0x5bc7,
    0x67af,
    0x54ed,
    0x7a9f,
    0x82e6,
    0x9177,
    0x5e93,
    0x88e4,
    0x5938,
    0x57ae,
    0x630e,
    0x8de8,
    0x80ef,
    0x5757,
    0x7b77,
    0x4fa9,
    0x5feb,
    0x5bbd,
    0x6b3e,
    0x5321,
    0x7b50,
    0x72c2,
    0x6846,
    0x77ff,
    0x7736,
    0x65f7,
    0x51b5,
    0x4e8f,
    0x76d4,
    0x5cbf,
    0x7aa5,
    0x8475,
    0x594e,
    0x9b41,
    0x5080,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xc0[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x7e5e,
    0x7e5f,
    0x7e60,
    0x7e61,
    0x7e62,
    0x7e63,
    0x7e64,
    0x7e65,
    0x7e66,
    0x7e67,
    0x7e68,
    0x7e69,
    0x7e6a,
    0x7e6b,
    0x7e6c,
    0x7e6d,
    0x7e6e,
    0x7e6f,
    0x7e70,
    0x7e71,
    0x7e72,
    0x7e73,
    0x7e74,
    0x7e75,
    0x7e76,
    0x7e77,
    0x7e78,
    0x7e79,
    0x7e7a,
    0x7e7b,
    0x7e7c,
    0x7e7d,
    0x7e7e,
    0x7e7f,
    0x7e80,
    0x7e81,
    0x7e83,
    0x7e84,
    0x7e85,
    0x7e86,
    0x7e87,
    0x7e88,
    0x7e89,
    0x7e8a,
    0x7e8b,
    0x7e8c,
    0x7e8d,
    0x7e8e,
    0x7e8f,
    0x7e90,
    0x7e91,
    0x7e92,
    0x7e93,
    0x7e94,
    0x7e95,
    0x7e96,
    0x7e97,
    0x7e98,
    0x7e99,
    0x7e9a,
    0x7e9c,
    0x7e9d,
    0x7e9e,
    CP936_CP_VAL_NULL,
    0x7eae,
    0x7eb4,
    0x7ebb,
    0x7ebc,
    0x7ed6,
    0x7ee4,
    0x7eec,
    0x7ef9,
    0x7f0a,
    0x7f10,
    0x7f1e,
    0x7f37,
    0x7f39,
    0x7f3b,
    0x7f3c,
    0x7f3d,
    0x7f3e,
    0x7f3f,
    0x7f40,
    0x7f41,
    0x7f43,
    0x7f46,
    0x7f47,
    0x7f48,
    0x7f49,
    0x7f4a,
    0x7f4b,
    0x7f4c,
    0x7f4d,
    0x7f4e,
    0x7f4f,
    0x7f52,
    0x7f53,
    0x9988,
    0x6127,
    0x6e83,
    0x5764,
    0x6606,
    0x6346,
    0x56f0,
    0x62ec,
    0x6269,
    0x5ed3,
    0x9614,
    0x5783,
    0x62c9,
    0x5587,
    0x8721,
    0x814a,
    0x8fa3,
    0x5566,
    0x83b1,
    0x6765,
    0x8d56,
    0x84dd,
    0x5a6a,
    0x680f,
    0x62e6,
    0x7bee,
    0x9611,
    0x5170,
    0x6f9c,
    0x8c30,
    0x63fd,
    0x89c8,
    0x61d2,
    0x7f06,
    0x70c2,
    0x6ee5,
    0x7405,
    0x6994,
    0x72fc,
    0x5eca,
    0x90ce,
    0x6717,
    0x6d6a,
    0x635e,
    0x52b3,
    0x7262,
    0x8001,
    0x4f6c,
    0x59e5,
    0x916a,
    0x70d9,
    0x6d9d,
    0x52d2,
    0x4e50,
    0x96f7,
    0x956d,
    0x857e,
    0x78ca,
    0x7d2f,
    0x5121,
    0x5792,
    0x64c2,
    0x808b,
    0x7c7b,
    0x6cea,
    0x68f1,
    0x695e,
    0x51b7,
    0x5398,
    0x68a8,
    0x7281,
    0x9ece,
    0x7bf1,
    0x72f8,
    0x79bb,
    0x6f13,
    0x7406,
    0x674e,
    0x91cc,
    0x9ca4,
    0x793c,
    0x8389,
    0x8354,
    0x540f,
    0x6817,
    0x4e3d,
    0x5389,
    0x52b1,
    0x783e,
    0x5386,
    0x5229,
    0x5088,
    0x4f8b,
    0x4fd0,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xc1[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x7f56,
    0x7f59,
    0x7f5b,
    0x7f5c,
    0x7f5d,
    0x7f5e,
    0x7f60,
    0x7f63,
    0x7f64,
    0x7f65,
    0x7f66,
    0x7f67,
    0x7f6b,
    0x7f6c,
    0x7f6d,
    0x7f6f,
    0x7f70,
    0x7f73,
    0x7f75,
    0x7f76,
    0x7f77,
    0x7f78,
    0x7f7a,
    0x7f7b,
    0x7f7c,
    0x7f7d,
    0x7f7f,
    0x7f80,
    0x7f82,
    0x7f83,
    0x7f84,
    0x7f85,
    0x7f86,
    0x7f87,
    0x7f88,
    0x7f89,
    0x7f8b,
    0x7f8d,
    0x7f8f,
    0x7f90,
    0x7f91,
    0x7f92,
    0x7f93,
    0x7f95,
    0x7f96,
    0x7f97,
    0x7f98,
    0x7f99,
    0x7f9b,
    0x7f9c,
    0x7fa0,
    0x7fa2,
    0x7fa3,
    0x7fa5,
    0x7fa6,
    0x7fa8,
    0x7fa9,
    0x7faa,
    0x7fab,
    0x7fac,
    0x7fad,
    0x7fae,
    0x7fb1,
    CP936_CP_VAL_NULL,
    0x7fb3,
    0x7fb4,
    0x7fb5,
    0x7fb6,
    0x7fb7,
    0x7fba,
    0x7fbb,
    0x7fbe,
    0x7fc0,
    0x7fc2,
    0x7fc3,
    0x7fc4,
    0x7fc6,
    0x7fc7,
    0x7fc8,
    0x7fc9,
    0x7fcb,
    0x7fcd,
    0x7fcf,
    0x7fd0,
    0x7fd1,
    0x7fd2,
    0x7fd3,
    0x7fd6,
    0x7fd7,
    0x7fd9,
    0x7fda,
    0x7fdb,
    0x7fdc,
    0x7fdd,
    0x7fde,
    0x7fe2,
    0x7fe3,
    0x75e2,
    0x7acb,
    0x7c92,
    0x6ca5,
    0x96b6,
    0x529b,
    0x7483,
    0x54e9,
    0x4fe9,
    0x8054,
    0x83b2,
    0x8fde,
    0x9570,
    0x5ec9,
    0x601c,
    0x6d9f,
    0x5e18,
    0x655b,
    0x8138,
    0x94fe,
    0x604b,
    0x70bc,
    0x7ec3,
    0x7cae,
    0x51c9,
    0x6881,
    0x7cb1,
    0x826f,
    0x4e24,
    0x8f86,
    0x91cf,
    0x667e,
    0x4eae,
    0x8c05,
    0x64a9,
    0x804a,
    0x50da,
    0x7597,
    0x71ce,
    0x5be5,
    0x8fbd,
    0x6f66,
    0x4e86,
    0x6482,
    0x9563,
    0x5ed6,
    0x6599,
    0x5217,
    0x88c2,
    0x70c8,
    0x52a3,
    0x730e,
    0x7433,
    0x6797,
    0x78f7,
    0x9716,
    0x4e34,
    0x90bb,
    0x9cde,
    0x6dcb,
    0x51db,
    0x8d41,
    0x541d,
    0x62ce,
    0x73b2,
    0x83f1,
    0x96f6,
    0x9f84,
    0x94c3,
    0x4f36,
    0x7f9a,
    0x51cc,
    0x7075,
    0x9675,
    0x5cad,
    0x9886,
    0x53e6,
    0x4ee4,
    0x6e9c,
    0x7409,
    0x69b4,
    0x786b,
    0x998f,
    0x7559,
    0x5218,
    0x7624,
    0x6d41,
    0x67f3,
    0x516d,
    0x9f99,
    0x804b,
    0x5499,
    0x7b3c,
    0x7abf,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xc2[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x7fe4,
    0x7fe7,
    0x7fe8,
    0x7fea,
    0x7feb,
    0x7fec,
    0x7fed,
    0x7fef,
    0x7ff2,
    0x7ff4,
    0x7ff5,
    0x7ff6,
    0x7ff7,
    0x7ff8,
    0x7ff9,
    0x7ffa,
    0x7ffd,
    0x7ffe,
    0x7fff,
    0x8002,
    0x8007,
    0x8008,
    0x8009,
    0x800a,
    0x800e,
    0x800f,
    0x8011,
    0x8013,
    0x801a,
    0x801b,
    0x801d,
    0x801e,
    0x801f,
    0x8021,
    0x8023,
    0x8024,
    0x802b,
    0x802c,
    0x802d,
    0x802e,
    0x802f,
    0x8030,
    0x8032,
    0x8034,
    0x8039,
    0x803a,
    0x803c,
    0x803e,
    0x8040,
    0x8041,
    0x8044,
    0x8045,
    0x8047,
    0x8048,
    0x8049,
    0x804e,
    0x804f,
    0x8050,
    0x8051,
    0x8053,
    0x8055,
    0x8056,
    0x8057,
    CP936_CP_VAL_NULL,
    0x8059,
    0x805b,
    0x805c,
    0x805d,
    0x805e,
    0x805f,
    0x8060,
    0x8061,
    0x8062,
    0x8063,
    0x8064,
    0x8065,
    0x8066,
    0x8067,
    0x8068,
    0x806b,
    0x806c,
    0x806d,
    0x806e,
    0x806f,
    0x8070,
    0x8072,
    0x8073,
    0x8074,
    0x8075,
    0x8076,
    0x8077,
    0x8078,
    0x8079,
    0x807a,
    0x807b,
    0x807c,
    0x807d,
    0x9686,
    0x5784,
    0x62e2,
    0x9647,
    0x697c,
    0x5a04,
    0x6402,
    0x7bd3,
    0x6f0f,
    0x964b,
    0x82a6,
    0x5362,
    0x9885,
    0x5e90,
    0x7089,
    0x63b3,
    0x5364,
    0x864f,
    0x9c81,
    0x9e93,
    0x788c,
    0x9732,
    0x8def,
    0x8d42,
    0x9e7f,
    0x6f5e,
    0x7984,
    0x5f55,
    0x9646,
    0x622e,
    0x9a74,
    0x5415,
    0x94dd,
    0x4fa3,
    0x65c5,
    0x5c65,
    0x5c61,
    0x7f15,
    0x8651,
    0x6c2f,
    0x5f8b,
    0x7387,
    0x6ee4,
    0x7eff,
    0x5ce6,
    0x631b,
    0x5b6a,
    0x6ee6,
    0x5375,
    0x4e71,
    0x63a0,
    0x7565,
    0x62a1,
    0x8f6e,
    0x4f26,
    0x4ed1,
    0x6ca6,
    0x7eb6,
    0x8bba,
    0x841d,
    0x87ba,
    0x7f57,
    0x903b,
    0x9523,
    0x7ba9,
    0x9aa1,
    0x88f8,
    0x843d,
    0x6d1b,
    0x9a86,
    0x7edc,
    0x5988,
    0x9ebb,
    0x739b,
    0x7801,
    0x8682,
    0x9a6c,
    0x9a82,
    0x561b,
    0x5417,
    0x57cb,
    0x4e70,
    0x9ea6,
    0x5356,
    0x8fc8,
    0x8109,
    0x7792,
    0x9992,
    0x86ee,
    0x6ee1,
    0x8513,
    0x66fc,
    0x6162,
    0x6f2b,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xc3[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x807e,
    0x8081,
    0x8082,
    0x8085,
    0x8088,
    0x808a,
    0x808d,
    0x808e,
    0x808f,
    0x8090,
    0x8091,
    0x8092,
    0x8094,
    0x8095,
    0x8097,
    0x8099,
    0x809e,
    0x80a3,
    0x80a6,
    0x80a7,
    0x80a8,
    0x80ac,
    0x80b0,
    0x80b3,
    0x80b5,
    0x80b6,
    0x80b8,
    0x80b9,
    0x80bb,
    0x80c5,
    0x80c7,
    0x80c8,
    0x80c9,
    0x80ca,
    0x80cb,
    0x80cf,
    0x80d0,
    0x80d1,
    0x80d2,
    0x80d3,
    0x80d4,
    0x80d5,
    0x80d8,
    0x80df,
    0x80e0,
    0x80e2,
    0x80e3,
    0x80e6,
    0x80ee,
    0x80f5,
    0x80f7,
    0x80f9,
    0x80fb,
    0x80fe,
    0x80ff,
    0x8100,
    0x8101,
    0x8103,
    0x8104,
    0x8105,
    0x8107,
    0x8108,
    0x810b,
    CP936_CP_VAL_NULL,
    0x810c,
    0x8115,
    0x8117,
    0x8119,
    0x811b,
    0x811c,
    0x811d,
    0x811f,
    0x8120,
    0x8121,
    0x8122,
    0x8123,
    0x8124,
    0x8125,
    0x8126,
    0x8127,
    0x8128,
    0x8129,
    0x812a,
    0x812b,
    0x812d,
    0x812e,
    0x8130,
    0x8133,
    0x8134,
    0x8135,
    0x8137,
    0x8139,
    0x813a,
    0x813b,
    0x813c,
    0x813d,
    0x813f,
    0x8c29,
    0x8292,
    0x832b,
    0x76f2,
    0x6c13,
    0x5fd9,
    0x83bd,
    0x732b,
    0x8305,
    0x951a,
    0x6bdb,
    0x77db,
    0x94c6,
    0x536f,
    0x8302,
    0x5192,
    0x5e3d,
    0x8c8c,
    0x8d38,
    0x4e48,
    0x73ab,
    0x679a,
    0x6885,
    0x9176,
    0x9709,
    0x7164,
    0x6ca1,
    0x7709,
    0x5a92,
    0x9541,
    0x6bcf,
    0x7f8e,
    0x6627,
    0x5bd0,
    0x59b9,
    0x5a9a,
    0x95e8,
    0x95f7,
    0x4eec,
    0x840c,
    0x8499,
    0x6aac,
    0x76df,
    0x9530,
    0x731b,
    0x68a6,
    0x5b5f,
    0x772f,
    0x919a,
    0x9761,
    0x7cdc,
    0x8ff7,
    0x8c1c,
    0x5f25,
    0x7c73,
    0x79d8,
    0x89c5,
    0x6ccc,
    0x871c,
    0x5bc6,
    0x5e42,
    0x68c9,
    0x7720,
    0x7ef5,
    0x5195,
    0x514d,
    0x52c9,
    0x5a29,
    0x7f05,
    0x9762,
    0x82d7,
    0x63cf,
    0x7784,
    0x85d0,
    0x79d2,
    0x6e3a,
    0x5e99,
    0x5999,
    0x8511,
    0x706d,
    0x6c11,
    0x62bf,
    0x76bf,
    0x654f,
    0x60af,
    0x95fd,
    0x660e,
    0x879f,
    0x9e23,
    0x94ed,
    0x540d,
    0x547d,
    0x8c2c,
    0x6478,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xc4[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x8140,
    0x8141,
    0x8142,
    0x8143,
    0x8144,
    0x8145,
    0x8147,
    0x8149,
    0x814d,
    0x814e,
    0x814f,
    0x8152,
    0x8156,
    0x8157,
    0x8158,
    0x815b,
    0x815c,
    0x815d,
    0x815e,
    0x815f,
    0x8161,
    0x8162,
    0x8163,
    0x8164,
    0x8166,
    0x8168,
    0x816a,
    0x816b,
    0x816c,
    0x816f,
    0x8172,
    0x8173,
    0x8175,
    0x8176,
    0x8177,
    0x8178,
    0x8181,
    0x8183,
    0x8184,
    0x8185,
    0x8186,
    0x8187,
    0x8189,
    0x818b,
    0x818c,
    0x818d,
    0x818e,
    0x8190,
    0x8192,
    0x8193,
    0x8194,
    0x8195,
    0x8196,
    0x8197,
    0x8199,
    0x819a,
    0x819e,
    0x819f,
    0x81a0,
    0x81a1,
    0x81a2,
    0x81a4,
    0x81a5,
    CP936_CP_VAL_NULL,
    0x81a7,
    0x81a9,
    0x81ab,
    0x81ac,
    0x81ad,
    0x81ae,
    0x81af,
    0x81b0,
    0x81b1,
    0x81b2,
    0x81b4,
    0x81b5,
    0x81b6,
    0x81b7,
    0x81b8,
    0x81b9,
    0x81bc,
    0x81bd,
    0x81be,
    0x81bf,
    0x81c4,
    0x81c5,
    0x81c7,
    0x81c8,
    0x81c9,
    0x81cb,
    0x81cd,
    0x81ce,
    0x81cf,
    0x81d0,
    0x81d1,
    0x81d2,
    0x81d3,
    0x6479,
    0x8611,
    0x6a21,
    0x819c,
    0x78e8,
    0x6469,
    0x9b54,
    0x62b9,
    0x672b,
    0x83ab,
    0x58a8,
    0x9ed8,
    0x6cab,
    0x6f20,
    0x5bde,
    0x964c,
    0x8c0b,
    0x725f,
    0x67d0,
    0x62c7,
    0x7261,
    0x4ea9,
    0x59c6,
    0x6bcd,
    0x5893,
    0x66ae,
    0x5e55,
    0x52df,
    0x6155,
    0x6728,
    0x76ee,
    0x7766,
    0x7267,
    0x7a46,
    0x62ff,
    0x54ea,
    0x5450,
    0x94a0,
    0x90a3,
    0x5a1c,
    0x7eb3,
    0x6c16,
    0x4e43,
    0x5976,
    0x8010,
    0x5948,
    0x5357,
    0x7537,
    0x96be,
    0x56ca,
    0x6320,
    0x8111,
    0x607c,
    0x95f9,
    0x6dd6,
    0x5462,
    0x9981,
    0x5185,
    0x5ae9,
    0x80fd,
    0x59ae,
    0x9713,
    0x502a,
    0x6ce5,
    0x5c3c,
    0x62df,
    0x4f60,
    0x533f,
    0x817b,
    0x9006,
    0x6eba,
    0x852b,
    0x62c8,
    0x5e74,
    0x78be,
    0x64b5,
    0x637b,
    0x5ff5,
    0x5a18,
    0x917f,
    0x9e1f,
    0x5c3f,
    0x634f,
    0x8042,
    0x5b7d,
    0x556e,
    0x954a,
    0x954d,
    0x6d85,
    0x60a8,
    0x67e0,
    0x72de,
    0x51dd,
    0x5b81,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xc5[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x81d4,
    0x81d5,
    0x81d6,
    0x81d7,
    0x81d8,
    0x81d9,
    0x81da,
    0x81db,
    0x81dc,
    0x81dd,
    0x81de,
    0x81df,
    0x81e0,
    0x81e1,
    0x81e2,
    0x81e4,
    0x81e5,
    0x81e6,
    0x81e8,
    0x81e9,
    0x81eb,
    0x81ee,
    0x81ef,
    0x81f0,
    0x81f1,
    0x81f2,
    0x81f5,
    0x81f6,
    0x81f7,
    0x81f8,
    0x81f9,
    0x81fa,
    0x81fd,
    0x81ff,
    0x8203,
    0x8207,
    0x8208,
    0x8209,
    0x820a,
    0x820b,
    0x820e,
    0x820f,
    0x8211,
    0x8213,
    0x8215,
    0x8216,
    0x8217,
    0x8218,
    0x8219,
    0x821a,
    0x821d,
    0x8220,
    0x8224,
    0x8225,
    0x8226,
    0x8227,
    0x8229,
    0x822e,
    0x8232,
    0x823a,
    0x823c,
    0x823d,
    0x823f,
    CP936_CP_VAL_NULL,
    0x8240,
    0x8241,
    0x8242,
    0x8243,
    0x8245,
    0x8246,
    0x8248,
    0x824a,
    0x824c,
    0x824d,
    0x824e,
    0x8250,
    0x8251,
    0x8252,
    0x8253,
    0x8254,
    0x8255,
    0x8256,
    0x8257,
    0x8259,
    0x825b,
    0x825c,
    0x825d,
    0x825e,
    0x8260,
    0x8261,
    0x8262,
    0x8263,
    0x8264,
    0x8265,
    0x8266,
    0x8267,
    0x8269,
    0x62e7,
    0x6cde,
    0x725b,
    0x626d,
    0x94ae,
    0x7ebd,
    0x8113,
    0x6d53,
    0x519c,
    0x5f04,
    0x5974,
    0x52aa,
    0x6012,
    0x5973,
    0x6696,
    0x8650,
    0x759f,
    0x632a,
    0x61e6,
    0x7cef,
    0x8bfa,
    0x54e6,
    0x6b27,
    0x9e25,
    0x6bb4,
    0x85d5,
    0x5455,
    0x5076,
    0x6ca4,
    0x556a,
    0x8db4,
    0x722c,
    0x5e15,
    0x6015,
    0x7436,
    0x62cd,
    0x6392,
    0x724c,
    0x5f98,
    0x6e43,
    0x6d3e,
    0x6500,
    0x6f58,
    0x76d8,
    0x78d0,
    0x76fc,
    0x7554,
    0x5224,
    0x53db,
    0x4e53,
    0x5e9e,
    0x65c1,
    0x802a,
    0x80d6,
    0x629b,
    0x5486,
    0x5228,
    0x70ae,
    0x888d,
    0x8dd1,
    0x6ce1,
    0x5478,
    0x80da,
    0x57f9,
    0x88f4,
    0x8d54,
    0x966a,
    0x914d,
    0x4f69,
    0x6c9b,
    0x55b7,
    0x76c6,
    0x7830,
    0x62a8,
    0x70f9,
    0x6f8e,
    0x5f6d,
    0x84ec,
    0x68da,
    0x787c,
    0x7bf7,
    0x81a8,
    0x670b,
    0x9e4f,
    0x6367,
    0x78b0,
    0x576f,
    0x7812,
    0x9739,
    0x6279,
    0x62ab,
    0x5288,
    0x7435,
    0x6bd7,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xc6[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x826a,
    0x826b,
    0x826c,
    0x826d,
    0x8271,
    0x8275,
    0x8276,
    0x8277,
    0x8278,
    0x827b,
    0x827c,
    0x8280,
    0x8281,
    0x8283,
    0x8285,
    0x8286,
    0x8287,
    0x8289,
    0x828c,
    0x8290,
    0x8293,
    0x8294,
    0x8295,
    0x8296,
    0x829a,
    0x829b,
    0x829e,
    0x82a0,
    0x82a2,
    0x82a3,
    0x82a7,
    0x82b2,
    0x82b5,
    0x82b6,
    0x82ba,
    0x82bb,
    0x82bc,
    0x82bf,
    0x82c0,
    0x82c2,
    0x82c3,
    0x82c5,
    0x82c6,
    0x82c9,
    0x82d0,
    0x82d6,
    0x82d9,
    0x82da,
    0x82dd,
    0x82e2,
    0x82e7,
    0x82e8,
    0x82e9,
    0x82ea,
    0x82ec,
    0x82ed,
    0x82ee,
    0x82f0,
    0x82f2,
    0x82f3,
    0x82f5,
    0x82f6,
    0x82f8,
    CP936_CP_VAL_NULL,
    0x82fa,
    0x82fc,
    0x82fd,
    0x82fe,
    0x82ff,
    0x8300,
    0x830a,
    0x830b,
    0x830d,
    0x8310,
    0x8312,
    0x8313,
    0x8316,
    0x8318,
    0x8319,
    0x831d,
    0x831e,
    0x831f,
    0x8320,
    0x8321,
    0x8322,
    0x8323,
    0x8324,
    0x8325,
    0x8326,
    0x8329,
    0x832a,
    0x832e,
    0x8330,
    0x8332,
    0x8337,
    0x833b,
    0x833d,
    0x5564,
    0x813e,
    0x75b2,
    0x76ae,
    0x5339,
    0x75de,
    0x50fb,
    0x5c41,
    0x8b6c,
    0x7bc7,
    0x504f,
    0x7247,
    0x9a97,
    0x98d8,
    0x6f02,
    0x74e2,
    0x7968,
    0x6487,
    0x77a5,
    0x62fc,
    0x9891,
    0x8d2b,
    0x54c1,
    0x8058,
    0x4e52,
    0x576a,
    0x82f9,
    0x840d,
    0x5e73,
    0x51ed,
    0x74f6,
    0x8bc4,
    0x5c4f,
    0x5761,
    0x6cfc,
    0x9887,
    0x5a46,
    0x7834,
    0x9b44,
    0x8feb,
    0x7c95,
    0x5256,
    0x6251,
    0x94fa,
    0x4ec6,
    0x8386,
    0x8461,
    0x83e9,
    0x84b2,
    0x57d4,
    0x6734,
    0x5703,
    0x666e,
    0x6d66,
    0x8c31,
    0x66dd,
    0x7011,
    0x671f,
    0x6b3a,
    0x6816,
    0x621a,
    0x59bb,
    0x4e03,
    0x51c4,
    0x6f06,
    0x67d2,
    0x6c8f,
    0x5176,
    0x68cb,
    0x5947,
    0x6b67,
    0x7566,
    0x5d0e,
    0x8110,
    0x9f50,
    0x65d7,
    0x7948,
    0x7941,
    0x9a91,
    0x8d77,
    0x5c82,
    0x4e5e,
    0x4f01,
    0x542f,
    0x5951,
    0x780c,
    0x5668,
    0x6c14,
    0x8fc4,
    0x5f03,
    0x6c7d,
    0x6ce3,
    0x8bab,
    0x6390,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xc7[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x833e,
    0x833f,
    0x8341,
    0x8342,
    0x8344,
    0x8345,
    0x8348,
    0x834a,
    0x834b,
    0x834c,
    0x834d,
    0x834e,
    0x8353,
    0x8355,
    0x8356,
    0x8357,
    0x8358,
    0x8359,
    0x835d,
    0x8362,
    0x8370,
    0x8371,
    0x8372,
    0x8373,
    0x8374,
    0x8375,
    0x8376,
    0x8379,
    0x837a,
    0x837e,
    0x837f,
    0x8380,
    0x8381,
    0x8382,
    0x8383,
    0x8384,
    0x8387,
    0x8388,
    0x838a,
    0x838b,
    0x838c,
    0x838d,
    0x838f,
    0x8390,
    0x8391,
    0x8394,
    0x8395,
    0x8396,
    0x8397,
    0x8399,
    0x839a,
    0x839d,
    0x839f,
    0x83a1,
    0x83a2,
    0x83a3,
    0x83a4,
    0x83a5,
    0x83a6,
    0x83a7,
    0x83ac,
    0x83ad,
    0x83ae,
    CP936_CP_VAL_NULL,
    0x83af,
    0x83b5,
    0x83bb,
    0x83be,
    0x83bf,
    0x83c2,
    0x83c3,
    0x83c4,
    0x83c6,
    0x83c8,
    0x83c9,
    0x83cb,
    0x83cd,
    0x83ce,
    0x83d0,
    0x83d1,
    0x83d2,
    0x83d3,
    0x83d5,
    0x83d7,
    0x83d9,
    0x83da,
    0x83db,
    0x83de,
    0x83e2,
    0x83e3,
    0x83e4,
    0x83e6,
    0x83e7,
    0x83e8,
    0x83eb,
    0x83ec,
    0x83ed,
    0x6070,
    0x6d3d,
    0x7275,
    0x6266,
    0x948e,
    0x94c5,
    0x5343,
    0x8fc1,
    0x7b7e,
    0x4edf,
    0x8c26,
    0x4e7e,
    0x9ed4,
    0x94b1,
    0x94b3,
    0x524d,
    0x6f5c,
    0x9063,
    0x6d45,
    0x8c34,
    0x5811,
    0x5d4c,
    0x6b20,
    0x6b49,
    0x67aa,
    0x545b,
    0x8154,
    0x7f8c,
    0x5899,
    0x8537,
    0x5f3a,
    0x62a2,
    0x6a47,
    0x9539,
    0x6572,
    0x6084,
    0x6865,
    0x77a7,
    0x4e54,
    0x4fa8,
    0x5de7,
    0x9798,
    0x64ac,
    0x7fd8,
    0x5ced,
    0x4fcf,
    0x7a8d,
    0x5207,
    0x8304,
    0x4e14,
    0x602f,
    0x7a83,
    0x94a6,
    0x4fb5,
    0x4eb2,
    0x79e6,
    0x7434,
    0x52e4,
    0x82b9,
    0x64d2,
    0x79bd,
    0x5bdd,
    0x6c81,
    0x9752,
    0x8f7b,
    0x6c22,
    0x503e,
    0x537f,
    0x6e05,
    0x64ce,
    0x6674,
    0x6c30,
    0x60c5,
    0x9877,
    0x8bf7,
    0x5e86,
    0x743c,
    0x7a77,
    0x79cb,
    0x4e18,
    0x90b1,
    0x7403,
    0x6c42,
    0x56da,
    0x914b,
    0x6cc5,
    0x8d8b,
    0x533a,
    0x86c6,
    0x66f2,
    0x8eaf,
    0x5c48,
    0x9a71,
    0x6e20,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xc8[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x83ee,
    0x83ef,
    0x83f3,
    0x83f4,
    0x83f5,
    0x83f6,
    0x83f7,
    0x83fa,
    0x83fb,
    0x83fc,
    0x83fe,
    0x83ff,
    0x8400,
    0x8402,
    0x8405,
    0x8407,
    0x8408,
    0x8409,
    0x840a,
    0x8410,
    0x8412,
    0x8413,
    0x8414,
    0x8415,
    0x8416,
    0x8417,
    0x8419,
    0x841a,
    0x841b,
    0x841e,
    0x841f,
    0x8420,
    0x8421,
    0x8422,
    0x8423,
    0x8429,
    0x842a,
    0x842b,
    0x842c,
    0x842d,
    0x842e,
    0x842f,
    0x8430,
    0x8432,
    0x8433,
    0x8434,
    0x8435,
    0x8436,
    0x8437,
    0x8439,
    0x843a,
    0x843b,
    0x843e,
    0x843f,
    0x8440,
    0x8441,
    0x8442,
    0x8443,
    0x8444,
    0x8445,
    0x8447,
    0x8448,
    0x8449,
    CP936_CP_VAL_NULL,
    0x844a,
    0x844b,
    0x844c,
    0x844d,
    0x844e,
    0x844f,
    0x8450,
    0x8452,
    0x8453,
    0x8454,
    0x8455,
    0x8456,
    0x8458,
    0x845d,
    0x845e,
    0x845f,
    0x8460,
    0x8462,
    0x8464,
    0x8465,
    0x8466,
    0x8467,
    0x8468,
    0x846a,
    0x846e,
    0x846f,
    0x8470,
    0x8472,
    0x8474,
    0x8477,
    0x8479,
    0x847b,
    0x847c,
    0x53d6,
    0x5a36,
    0x9f8b,
    0x8da3,
    0x53bb,
    0x5708,
    0x98a7,
    0x6743,
    0x919b,
    0x6cc9,
    0x5168,
    0x75ca,
    0x62f3,
    0x72ac,
    0x5238,
    0x529d,
    0x7f3a,
    0x7094,
    0x7638,
    0x5374,
    0x9e4a,
    0x69b7,
    0x786e,
    0x96c0,
    0x88d9,
    0x7fa4,
    0x7136,
    0x71c3,
    0x5189,
    0x67d3,
    0x74e4,
    0x58e4,
    0x6518,
    0x56b7,
    0x8ba9,
    0x9976,
    0x6270,
    0x7ed5,
    0x60f9,
    0x70ed,
    0x58ec,
    0x4ec1,
    0x4eba,
    0x5fcd,
    0x97e7,
    0x4efb,
    0x8ba4,
    0x5203,
    0x598a,
    0x7eab,
    0x6254,
    0x4ecd,
    0x65e5,
    0x620e,
    0x8338,
    0x84c9,
    0x8363,
    0x878d,
    0x7194,
    0x6eb6,
    0x5bb9,
    0x7ed2,
    0x5197,
    0x63c9,
    0x67d4,
    0x8089,
    0x8339,
    0x8815,
    0x5112,
    0x5b7a,
    0x5982,
    0x8fb1,
    0x4e73,
    0x6c5d,
    0x5165,
    0x8925,
    0x8f6f,
    0x962e,
    0x854a,
    0x745e,
    0x9510,
    0x95f0,
    0x6da6,
    0x82e5,
    0x5f31,
    0x6492,
    0x6d12,
    0x8428,
    0x816e,
    0x9cc3,
    0x585e,
    0x8d5b,
    0x4e09,
    0x53c1,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xc9[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x847d,
    0x847e,
    0x847f,
    0x8480,
    0x8481,
    0x8483,
    0x8484,
    0x8485,
    0x8486,
    0x848a,
    0x848d,
    0x848f,
    0x8490,
    0x8491,
    0x8492,
    0x8493,
    0x8494,
    0x8495,
    0x8496,
    0x8498,
    0x849a,
    0x849b,
    0x849d,
    0x849e,
    0x849f,
    0x84a0,
    0x84a2,
    0x84a3,
    0x84a4,
    0x84a5,
    0x84a6,
    0x84a7,
    0x84a8,
    0x84a9,
    0x84aa,
    0x84ab,
    0x84ac,
    0x84ad,
    0x84ae,
    0x84b0,
    0x84b1,
    0x84b3,
    0x84b5,
    0x84b6,
    0x84b7,
    0x84bb,
    0x84bc,
    0x84be,
    0x84c0,
    0x84c2,
    0x84c3,
    0x84c5,
    0x84c6,
    0x84c7,
    0x84c8,
    0x84cb,
    0x84cc,
    0x84ce,
    0x84cf,
    0x84d2,
    0x84d4,
    0x84d5,
    0x84d7,
    CP936_CP_VAL_NULL,
    0x84d8,
    0x84d9,
    0x84da,
    0x84db,
    0x84dc,
    0x84de,
    0x84e1,
    0x84e2,
    0x84e4,
    0x84e7,
    0x84e8,
    0x84e9,
    0x84ea,
    0x84eb,
    0x84ed,
    0x84ee,
    0x84ef,
    0x84f1,
    0x84f2,
    0x84f3,
    0x84f4,
    0x84f5,
    0x84f6,
    0x84f7,
    0x84f8,
    0x84f9,
    0x84fa,
    0x84fb,
    0x84fd,
    0x84fe,
    0x8500,
    0x8501,
    0x8502,
    0x4f1e,
    0x6563,
    0x6851,
    0x55d3,
    0x4e27,
    0x6414,
    0x9a9a,
    0x626b,
    0x5ac2,
    0x745f,
    0x8272,
    0x6da9,
    0x68ee,
    0x50e7,
    0x838e,
    0x7802,
    0x6740,
    0x5239,
    0x6c99,
    0x7eb1,
    0x50bb,
    0x5565,
    0x715e,
    0x7b5b,
    0x6652,
    0x73ca,
    0x82eb,
    0x6749,
    0x5c71,
    0x5220,
    0x717d,
    0x886b,
    0x95ea,
    0x9655,
    0x64c5,
    0x8d61,
    0x81b3,
    0x5584,
    0x6c55,
    0x6247,
    0x7f2e,
    0x5892,
    0x4f24,
    0x5546,
    0x8d4f,
    0x664c,
    0x4e0a,
    0x5c1a,
    0x88f3,
    0x68a2,
    0x634e,
    0x7a0d,
    0x70e7,
    0x828d,
    0x52fa,
    0x97f6,
    0x5c11,
    0x54e8,
    0x90b5,
    0x7ecd,
    0x5962,
    0x8d4a,
    0x86c7,
    0x820c,
    0x820d,
    0x8d66,
    0x6444,
    0x5c04,
    0x6151,
    0x6d89,
    0x793e,
    0x8bbe,
    0x7837,
    0x7533,
    0x547b,
    0x4f38,
    0x8eab,
    0x6df1,
    0x5a20,
    0x7ec5,
    0x795e,
    0x6c88,
    0x5ba1,
    0x5a76,
    0x751a,
    0x80be,
    0x614e,
    0x6e17,
    0x58f0,
    0x751f,
    0x7525,
    0x7272,
    0x5347,
    0x7ef3,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xca[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x8503,
    0x8504,
    0x8505,
    0x8506,
    0x8507,
    0x8508,
    0x8509,
    0x850a,
    0x850b,
    0x850d,
    0x850e,
    0x850f,
    0x8510,
    0x8512,
    0x8514,
    0x8515,
    0x8516,
    0x8518,
    0x8519,
    0x851b,
    0x851c,
    0x851d,
    0x851e,
    0x8520,
    0x8522,
    0x8523,
    0x8524,
    0x8525,
    0x8526,
    0x8527,
    0x8528,
    0x8529,
    0x852a,
    0x852d,
    0x852e,
    0x852f,
    0x8530,
    0x8531,
    0x8532,
    0x8533,
    0x8534,
    0x8535,
    0x8536,
    0x853e,
    0x853f,
    0x8540,
    0x8541,
    0x8542,
    0x8544,
    0x8545,
    0x8546,
    0x8547,
    0x854b,
    0x854c,
    0x854d,
    0x854e,
    0x854f,
    0x8550,
    0x8551,
    0x8552,
    0x8553,
    0x8554,
    0x8555,
    CP936_CP_VAL_NULL,
    0x8557,
    0x8558,
    0x855a,
    0x855b,
    0x855c,
    0x855d,
    0x855f,
    0x8560,
    0x8561,
    0x8562,
    0x8563,
    0x8565,
    0x8566,
    0x8567,
    0x8569,
    0x856a,
    0x856b,
    0x856c,
    0x856d,
    0x856e,
    0x856f,
    0x8570,
    0x8571,
    0x8573,
    0x8575,
    0x8576,
    0x8577,
    0x8578,
    0x857c,
    0x857d,
    0x857f,
    0x8580,
    0x8581,
    0x7701,
    0x76db,
    0x5269,
    0x80dc,
    0x5723,
    0x5e08,
    0x5931,
    0x72ee,
    0x65bd,
    0x6e7f,
    0x8bd7,
    0x5c38,
    0x8671,
    0x5341,
    0x77f3,
    0x62fe,
    0x65f6,
    0x4ec0,
    0x98df,
    0x8680,
    0x5b9e,
    0x8bc6,
    0x53f2,
    0x77e2,
    0x4f7f,
    0x5c4e,
    0x9a76,
    0x59cb,
    0x5f0f,
    0x793a,
    0x58eb,
    0x4e16,
    0x67ff,
    0x4e8b,
    0x62ed,
    0x8a93,
    0x901d,
    0x52bf,
    0x662f,
    0x55dc,
    0x566c,
    0x9002,
    0x4ed5,
    0x4f8d,
    0x91ca,
    0x9970,
    0x6c0f,
    0x5e02,
    0x6043,
    0x5ba4,
    0x89c6,
    0x8bd5,
    0x6536,
    0x624b,
    0x9996,
    0x5b88,
    0x5bff,
    0x6388,
    0x552e,
    0x53d7,
    0x7626,
    0x517d,
    0x852c,
    0x67a2,
    0x68b3,
    0x6b8a,
    0x6292,
    0x8f93,
    0x53d4,
    0x8212,
    0x6dd1,
    0x758f,
    0x4e66,
    0x8d4e,
    0x5b70,
    0x719f,
    0x85af,
    0x6691,
    0x66d9,
    0x7f72,
    0x8700,
    0x9ecd,
    0x9f20,
    0x5c5e,
    0x672f,
    0x8ff0,
    0x6811,
    0x675f,
    0x620d,
    0x7ad6,
    0x5885,
    0x5eb6,
    0x6570,
    0x6f31,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xcb[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x8582,
    0x8583,
    0x8586,
    0x8588,
    0x8589,
    0x858a,
    0x858b,
    0x858c,
    0x858d,
    0x858e,
    0x8590,
    0x8591,
    0x8592,
    0x8593,
    0x8594,
    0x8595,
    0x8596,
    0x8597,
    0x8598,
    0x8599,
    0x859a,
    0x859d,
    0x859e,
    0x859f,
    0x85a0,
    0x85a1,
    0x85a2,
    0x85a3,
    0x85a5,
    0x85a6,
    0x85a7,
    0x85a9,
    0x85ab,
    0x85ac,
    0x85ad,
    0x85b1,
    0x85b2,
    0x85b3,
    0x85b4,
    0x85b5,
    0x85b6,
    0x85b8,
    0x85ba,
    0x85bb,
    0x85bc,
    0x85bd,
    0x85be,
    0x85bf,
    0x85c0,
    0x85c2,
    0x85c3,
    0x85c4,
    0x85c5,
    0x85c6,
    0x85c7,
    0x85c8,
    0x85ca,
    0x85cb,
    0x85cc,
    0x85cd,
    0x85ce,
    0x85d1,
    0x85d2,
    CP936_CP_VAL_NULL,
    0x85d4,
    0x85d6,
    0x85d7,
    0x85d8,
    0x85d9,
    0x85da,
    0x85db,
    0x85dd,
    0x85de,
    0x85df,
    0x85e0,
    0x85e1,
    0x85e2,
    0x85e3,
    0x85e5,
    0x85e6,
    0x85e7,
    0x85e8,
    0x85ea,
    0x85eb,
    0x85ec,
    0x85ed,
    0x85ee,
    0x85ef,
    0x85f0,
    0x85f1,
    0x85f2,
    0x85f3,
    0x85f4,
    0x85f5,
    0x85f6,
    0x85f7,
    0x85f8,
    0x6055,
    0x5237,
    0x800d,
    0x6454,
    0x8870,
    0x7529,
    0x5e05,
    0x6813,
    0x62f4,
    0x971c,
    0x53cc,
    0x723d,
    0x8c01,
    0x6c34,
    0x7761,
    0x7a0e,
    0x542e,
    0x77ac,
    0x987a,
    0x821c,
    0x8bf4,
    0x7855,
    0x6714,
    0x70c1,
    0x65af,
    0x6495,
    0x5636,
    0x601d,
    0x79c1,
    0x53f8,
    0x4e1d,
    0x6b7b,
    0x8086,
    0x5bfa,
    0x55e3,
    0x56db,
    0x4f3a,
    0x4f3c,
    0x9972,
    0x5df3,
    0x677e,
    0x8038,
    0x6002,
    0x9882,
    0x9001,
    0x5b8b,
    0x8bbc,
    0x8bf5,
    0x641c,
    0x8258,
    0x64de,
    0x55fd,
    0x82cf,
    0x9165,
    0x4fd7,
    0x7d20,
    0x901f,
    0x7c9f,
    0x50f3,
    0x5851,
    0x6eaf,
    0x5bbf,
    0x8bc9,
    0x8083,
    0x9178,
    0x849c,
    0x7b97,
    0x867d,
    0x968b,
    0x968f,
    0x7ee5,
    0x9ad3,
    0x788e,
    0x5c81,
    0x7a57,
    0x9042,
    0x96a7,
    0x795f,
    0x5b59,
    0x635f,
    0x7b0b,
    0x84d1,
    0x68ad,
    0x5506,
    0x7f29,
    0x7410,
    0x7d22,
    0x9501,
    0x6240,
    0x584c,
    0x4ed6,
    0x5b83,
    0x5979,
    0x5854,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xcc[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x85f9,
    0x85fa,
    0x85fc,
    0x85fd,
    0x85fe,
    0x8600,
    0x8601,
    0x8602,
    0x8603,
    0x8604,
    0x8606,
    0x8607,
    0x8608,
    0x8609,
    0x860a,
    0x860b,
    0x860c,
    0x860d,
    0x860e,
    0x860f,
    0x8610,
    0x8612,
    0x8613,
    0x8614,
    0x8615,
    0x8617,
    0x8618,
    0x8619,
    0x861a,
    0x861b,
    0x861c,
    0x861d,
    0x861e,
    0x861f,
    0x8620,
    0x8621,
    0x8622,
    0x8623,
    0x8624,
    0x8625,
    0x8626,
    0x8628,
    0x862a,
    0x862b,
    0x862c,
    0x862d,
    0x862e,
    0x862f,
    0x8630,
    0x8631,
    0x8632,
    0x8633,
    0x8634,
    0x8635,
    0x8636,
    0x8637,
    0x8639,
    0x863a,
    0x863b,
    0x863d,
    0x863e,
    0x863f,
    0x8640,
    CP936_CP_VAL_NULL,
    0x8641,
    0x8642,
    0x8643,
    0x8644,
    0x8645,
    0x8646,
    0x8647,
    0x8648,
    0x8649,
    0x864a,
    0x864b,
    0x864c,
    0x8652,
    0x8653,
    0x8655,
    0x8656,
    0x8657,
    0x8658,
    0x8659,
    0x865b,
    0x865c,
    0x865d,
    0x865f,
    0x8660,
    0x8661,
    0x8663,
    0x8664,
    0x8665,
    0x8666,
    0x8667,
    0x8668,
    0x8669,
    0x866a,
    0x736d,
    0x631e,
    0x8e4b,
    0x8e0f,
    0x80ce,
    0x82d4,
    0x62ac,
    0x53f0,
    0x6cf0,
    0x915e,
    0x592a,
    0x6001,
    0x6c70,
    0x574d,
    0x644a,
    0x8d2a,
    0x762b,
    0x6ee9,
    0x575b,
    0x6a80,
    0x75f0,
    0x6f6d,
    0x8c2d,
    0x8c08,
    0x5766,
    0x6bef,
    0x8892,
    0x78b3,
    0x63a2,
    0x53f9,
    0x70ad,
    0x6c64,
    0x5858,
    0x642a,
    0x5802,
    0x68e0,
    0x819b,
    0x5510,
    0x7cd6,
    0x5018,
    0x8eba,
    0x6dcc,
    0x8d9f,
    0x70eb,
    0x638f,
    0x6d9b,
    0x6ed4,
    0x7ee6,
    0x8404,
    0x6843,
    0x9003,
    0x6dd8,
    0x9676,
    0x8ba8,
    0x5957,
    0x7279,
    0x85e4,
    0x817e,
    0x75bc,
    0x8a8a,
    0x68af,
    0x5254,
    0x8e22,
    0x9511,
    0x63d0,
    0x9898,
    0x8e44,
    0x557c,
    0x4f53,
    0x66ff,
    0x568f,
    0x60d5,
    0x6d95,
    0x5243,
    0x5c49,
    0x5929,
    0x6dfb,
    0x586b,
    0x7530,
    0x751c,
    0x606c,
    0x8214,
    0x8146,
    0x6311,
    0x6761,
    0x8fe2,
    0x773a,
    0x8df3,
    0x8d34,
    0x94c1,
    0x5e16,
    0x5385,
    0x542c,
    0x70c3,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xcd[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x866d,
    0x866f,
    0x8670,
    0x8672,
    0x8673,
    0x8674,
    0x8675,
    0x8676,
    0x8677,
    0x8678,
    0x8683,
    0x8684,
    0x8685,
    0x8686,
    0x8687,
    0x8688,
    0x8689,
    0x868e,
    0x868f,
    0x8690,
    0x8691,
    0x8692,
    0x8694,
    0x8696,
    0x8697,
    0x8698,
    0x8699,
    0x869a,
    0x869b,
    0x869e,
    0x869f,
    0x86a0,
    0x86a1,
    0x86a2,
    0x86a5,
    0x86a6,
    0x86ab,
    0x86ad,
    0x86ae,
    0x86b2,
    0x86b3,
    0x86b7,
    0x86b8,
    0x86b9,
    0x86bb,
    0x86bc,
    0x86bd,
    0x86be,
    0x86bf,
    0x86c1,
    0x86c2,
    0x86c3,
    0x86c5,
    0x86c8,
    0x86cc,
    0x86cd,
    0x86d2,
    0x86d3,
    0x86d5,
    0x86d6,
    0x86d7,
    0x86da,
    0x86dc,
    CP936_CP_VAL_NULL,
    0x86dd,
    0x86e0,
    0x86e1,
    0x86e2,
    0x86e3,
    0x86e5,
    0x86e6,
    0x86e7,
    0x86e8,
    0x86ea,
    0x86eb,
    0x86ec,
    0x86ef,
    0x86f5,
    0x86f6,
    0x86f7,
    0x86fa,
    0x86fb,
    0x86fc,
    0x86fd,
    0x86ff,
    0x8701,
    0x8704,
    0x8705,
    0x8706,
    0x870b,
    0x870c,
    0x870e,
    0x870f,
    0x8710,
    0x8711,
    0x8714,
    0x8716,
    0x6c40,
    0x5ef7,
    0x505c,
    0x4ead,
    0x5ead,
    0x633a,
    0x8247,
    0x901a,
    0x6850,
    0x916e,
    0x77b3,
    0x540c,
    0x94dc,
    0x5f64,
    0x7ae5,
    0x6876,
    0x6345,
    0x7b52,
    0x7edf,
    0x75db,
    0x5077,
    0x6295,
    0x5934,
    0x900f,
    0x51f8,
    0x79c3,
    0x7a81,
    0x56fe,
    0x5f92,
    0x9014,
    0x6d82,
    0x5c60,
    0x571f,
    0x5410,
    0x5154,
    0x6e4d,
    0x56e2,
    0x63a8,
    0x9893,
    0x817f,
    0x8715,
    0x892a,
    0x9000,
    0x541e,
    0x5c6f,
    0x81c0,
    0x62d6,
    0x6258,
    0x8131,
    0x9e35,
    0x9640,
    0x9a6e,
    0x9a7c,
    0x692d,
    0x59a5,
    0x62d3,
    0x553e,
    0x6316,
    0x54c7,
    0x86d9,
    0x6d3c,
    0x5a03,
    0x74e6,
    0x889c,
    0x6b6a,
    0x5916,
    0x8c4c,
    0x5f2f,
    0x6e7e,
    0x73a9,
    0x987d,
    0x4e38,
    0x70f7,
    0x5b8c,
    0x7897,
    0x633d,
    0x665a,
    0x7696,
    0x60cb,
    0x5b9b,
    0x5a49,
    0x4e07,
    0x8155,
    0x6c6a,
    0x738b,
    0x4ea1,
    0x6789,
    0x7f51,
    0x5f80,
    0x65fa,
    0x671b,
    0x5fd8,
    0x5984,
    0x5a01,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xce[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x8719,
    0x871b,
    0x871d,
    0x871f,
    0x8720,
    0x8724,
    0x8726,
    0x8727,
    0x8728,
    0x872a,
    0x872b,
    0x872c,
    0x872d,
    0x872f,
    0x8730,
    0x8732,
    0x8733,
    0x8735,
    0x8736,
    0x8738,
    0x8739,
    0x873a,
    0x873c,
    0x873d,
    0x8740,
    0x8741,
    0x8742,
    0x8743,
    0x8744,
    0x8745,
    0x8746,
    0x874a,
    0x874b,
    0x874d,
    0x874f,
    0x8750,
    0x8751,
    0x8752,
    0x8754,
    0x8755,
    0x8756,
    0x8758,
    0x875a,
    0x875b,
    0x875c,
    0x875d,
    0x875e,
    0x875f,
    0x8761,
    0x8762,
    0x8766,
    0x8767,
    0x8768,
    0x8769,
    0x876a,
    0x876b,
    0x876c,
    0x876d,
    0x876f,
    0x8771,
    0x8772,
    0x8773,
    0x8775,
    CP936_CP_VAL_NULL,
    0x8777,
    0x8778,
    0x8779,
    0x877a,
    0x877f,
    0x8780,
    0x8781,
    0x8784,
    0x8786,
    0x8787,
    0x8789,
    0x878a,
    0x878c,
    0x878e,
    0x878f,
    0x8790,
    0x8791,
    0x8792,
    0x8794,
    0x8795,
    0x8796,
    0x8798,
    0x8799,
    0x879a,
    0x879b,
    0x879c,
    0x879d,
    0x879e,
    0x87a0,
    0x87a1,
    0x87a2,
    0x87a3,
    0x87a4,
    0x5dcd,
    0x5fae,
    0x5371,
    0x97e6,
    0x8fdd,
    0x6845,
    0x56f4,
    0x552f,
    0x60df,
    0x4e3a,
    0x6f4d,
    0x7ef4,
    0x82c7,
    0x840e,
    0x59d4,
    0x4f1f,
    0x4f2a,
    0x5c3e,
    0x7eac,
    0x672a,
    0x851a,
    0x5473,
    0x754f,
    0x80c3,
    0x5582,
    0x9b4f,
    0x4f4d,
    0x6e2d,
    0x8c13,
    0x5c09,
    0x6170,
    0x536b,
    0x761f,
    0x6e29,
    0x868a,
    0x6587,
    0x95fb,
    0x7eb9,
    0x543b,
    0x7a33,
    0x7d0a,
    0x95ee,
    0x55e1,
    0x7fc1,
    0x74ee,
    0x631d,
    0x8717,
    0x6da1,
    0x7a9d,
    0x6211,
    0x65a1,
    0x5367,
    0x63e1,
    0x6c83,
    0x5deb,
    0x545c,
    0x94a8,
    0x4e4c,
    0x6c61,
    0x8bec,
    0x5c4b,
    0x65e0,
    0x829c,
    0x68a7,
    0x543e,
    0x5434,
    0x6bcb,
    0x6b66,
    0x4e94,
    0x6342,
    0x5348,
    0x821e,
    0x4f0d,
    0x4fae,
    0x575e,
    0x620a,
    0x96fe,
    0x6664,
    0x7269,
    0x52ff,
    0x52a1,
    0x609f,
    0x8bef,
    0x6614,
    0x7199,
    0x6790,
    0x897f,
    0x7852,
    0x77fd,
    0x6670,
    0x563b,
    0x5438,
    0x9521,
    0x727a,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xcf[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x87a5,
    0x87a6,
    0x87a7,
    0x87a9,
    0x87aa,
    0x87ae,
    0x87b0,
    0x87b1,
    0x87b2,
    0x87b4,
    0x87b6,
    0x87b7,
    0x87b8,
    0x87b9,
    0x87bb,
    0x87bc,
    0x87be,
    0x87bf,
    0x87c1,
    0x87c2,
    0x87c3,
    0x87c4,
    0x87c5,
    0x87c7,
    0x87c8,
    0x87c9,
    0x87cc,
    0x87cd,
    0x87ce,
    0x87cf,
    0x87d0,
    0x87d4,
    0x87d5,
    0x87d6,
    0x87d7,
    0x87d8,
    0x87d9,
    0x87da,
    0x87dc,
    0x87dd,
    0x87de,
    0x87df,
    0x87e1,
    0x87e2,
    0x87e3,
    0x87e4,
    0x87e6,
    0x87e7,
    0x87e8,
    0x87e9,
    0x87eb,
    0x87ec,
    0x87ed,
    0x87ef,
    0x87f0,
    0x87f1,
    0x87f2,
    0x87f3,
    0x87f4,
    0x87f5,
    0x87f6,
    0x87f7,
    0x87f8,
    CP936_CP_VAL_NULL,
    0x87fa,
    0x87fb,
    0x87fc,
    0x87fd,
    0x87ff,
    0x8800,
    0x8801,
    0x8802,
    0x8804,
    0x8805,
    0x8806,
    0x8807,
    0x8808,
    0x8809,
    0x880b,
    0x880c,
    0x880d,
    0x880e,
    0x880f,
    0x8810,
    0x8811,
    0x8812,
    0x8814,
    0x8817,
    0x8818,
    0x8819,
    0x881a,
    0x881c,
    0x881d,
    0x881e,
    0x881f,
    0x8820,
    0x8823,
    0x7a00,
    0x606f,
    0x5e0c,
    0x6089,
    0x819d,
    0x5915,
    0x60dc,
    0x7184,
    0x70ef,
    0x6eaa,
    0x6c50,
    0x7280,
    0x6a84,
    0x88ad,
    0x5e2d,
    0x4e60,
    0x5ab3,
    0x559c,
    0x94e3,
    0x6d17,
    0x7cfb,
    0x9699,
    0x620f,
    0x7ec6,
    0x778e,
    0x867e,
    0x5323,
    0x971e,
    0x8f96,
    0x6687,
    0x5ce1,
    0x4fa0,
    0x72ed,
    0x4e0b,
    0x53a6,
    0x590f,
    0x5413,
    0x6380,
    0x9528,
    0x5148,
    0x4ed9,
    0x9c9c,
    0x7ea4,
    0x54b8,
    0x8d24,
    0x8854,
    0x8237,
    0x95f2,
    0x6d8e,
    0x5f26,
    0x5acc,
    0x663e,
    0x9669,
    0x73b0,
    0x732e,
    0x53bf,
    0x817a,
    0x9985,
    0x7fa1,
    0x5baa,
    0x9677,
    0x9650,
    0x7ebf,
    0x76f8,
    0x53a2,
    0x9576,
    0x9999,
    0x7bb1,
    0x8944,
    0x6e58,
    0x4e61,
    0x7fd4,
    0x7965,
    0x8be6,
    0x60f3,
    0x54cd,
    0x4eab,
    0x9879,
    0x5df7,
    0x6a61,
    0x50cf,
    0x5411,
    0x8c61,
    0x8427,
    0x785d,
    0x9704,
    0x524a,
    0x54ee,
    0x56a3,
    0x9500,
    0x6d88,
    0x5bb5,
    0x6dc6,
    0x6653,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xd0[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x8824,
    0x8825,
    0x8826,
    0x8827,
    0x8828,
    0x8829,
    0x882a,
    0x882b,
    0x882c,
    0x882d,
    0x882e,
    0x882f,
    0x8830,
    0x8831,
    0x8833,
    0x8834,
    0x8835,
    0x8836,
    0x8837,
    0x8838,
    0x883a,
    0x883b,
    0x883d,
    0x883e,
    0x883f,
    0x8841,
    0x8842,
    0x8843,
    0x8846,
    0x8847,
    0x8848,
    0x8849,
    0x884a,
    0x884b,
    0x884e,
    0x884f,
    0x8850,
    0x8851,
    0x8852,
    0x8853,
    0x8855,
    0x8856,
    0x8858,
    0x885a,
    0x885b,
    0x885c,
    0x885d,
    0x885e,
    0x885f,
    0x8860,
    0x8866,
    0x8867,
    0x886a,
    0x886d,
    0x886f,
    0x8871,
    0x8873,
    0x8874,
    0x8875,
    0x8876,
    0x8878,
    0x8879,
    0x887a,
    CP936_CP_VAL_NULL,
    0x887b,
    0x887c,
    0x8880,
    0x8883,
    0x8886,
    0x8887,
    0x8889,
    0x888a,
    0x888c,
    0x888e,
    0x888f,
    0x8890,
    0x8891,
    0x8893,
    0x8894,
    0x8895,
    0x8897,
    0x8898,
    0x8899,
    0x889a,
    0x889b,
    0x889d,
    0x889e,
    0x889f,
    0x88a0,
    0x88a1,
    0x88a3,
    0x88a5,
    0x88a6,
    0x88a7,
    0x88a8,
    0x88a9,
    0x88aa,
    0x5c0f,
    0x5b5d,
    0x6821,
    0x8096,
    0x5578,
    0x7b11,
    0x6548,
    0x6954,
    0x4e9b,
    0x6b47,
    0x874e,
    0x978b,
    0x534f,
    0x631f,
    0x643a,
    0x90aa,
    0x659c,
    0x80c1,
    0x8c10,
    0x5199,
    0x68b0,
    0x5378,
    0x87f9,
    0x61c8,
    0x6cc4,
    0x6cfb,
    0x8c22,
    0x5c51,
    0x85aa,
    0x82af,
    0x950c,
    0x6b23,
    0x8f9b,
    0x65b0,
    0x5ffb,
    0x5fc3,
    0x4fe1,
    0x8845,
    0x661f,
    0x8165,
    0x7329,
    0x60fa,
    0x5174,
    0x5211,
    0x578b,
    0x5f62,
    0x90a2,
    0x884c,
    0x9192,
    0x5e78,
    0x674f,
    0x6027,
    0x59d3,
    0x5144,
    0x51f6,
    0x80f8,
    0x5308,
    0x6c79,
    0x96c4,
    0x718a,
    0x4f11,
    0x4fee,
    0x7f9e,
    0x673d,
    0x55c5,
    0x9508,
    0x79c0,
    0x8896,
    0x7ee3,
    0x589f,
    0x620c,
    0x9700,
    0x865a,
    0x5618,
    0x987b,
    0x5f90,
    0x8bb8,
    0x84c4,
    0x9157,
    0x53d9,
    0x65ed,
    0x5e8f,
    0x755c,
    0x6064,
    0x7d6e,
    0x5a7f,
    0x7eea,
    0x7eed,
    0x8f69,
    0x55a7,
    0x5ba3,
    0x60ac,
    0x65cb,
    0x7384,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xd1[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x88ac,
    0x88ae,
    0x88af,
    0x88b0,
    0x88b2,
    0x88b3,
    0x88b4,
    0x88b5,
    0x88b6,
    0x88b8,
    0x88b9,
    0x88ba,
    0x88bb,
    0x88bd,
    0x88be,
    0x88bf,
    0x88c0,
    0x88c3,
    0x88c4,
    0x88c7,
    0x88c8,
    0x88ca,
    0x88cb,
    0x88cc,
    0x88cd,
    0x88cf,
    0x88d0,
    0x88d1,
    0x88d3,
    0x88d6,
    0x88d7,
    0x88da,
    0x88db,
    0x88dc,
    0x88dd,
    0x88de,
    0x88e0,
    0x88e1,
    0x88e6,
    0x88e7,
    0x88e9,
    0x88ea,
    0x88eb,
    0x88ec,
    0x88ed,
    0x88ee,
    0x88ef,
    0x88f2,
    0x88f5,
    0x88f6,
    0x88f7,
    0x88fa,
    0x88fb,
    0x88fd,
    0x88ff,
    0x8900,
    0x8901,
    0x8903,
    0x8904,
    0x8905,
    0x8906,
    0x8907,
    0x8908,
    CP936_CP_VAL_NULL,
    0x8909,
    0x890b,
    0x890c,
    0x890d,
    0x890e,
    0x890f,
    0x8911,
    0x8914,
    0x8915,
    0x8916,
    0x8917,
    0x8918,
    0x891c,
    0x891d,
    0x891e,
    0x891f,
    0x8920,
    0x8922,
    0x8923,
    0x8924,
    0x8926,
    0x8927,
    0x8928,
    0x8929,
    0x892c,
    0x892d,
    0x892e,
    0x892f,
    0x8931,
    0x8932,
    0x8933,
    0x8935,
    0x8937,
    0x9009,
    0x7663,
    0x7729,
    0x7eda,
    0x9774,
    0x859b,
    0x5b66,
    0x7a74,
    0x96ea,
    0x8840,
    0x52cb,
    0x718f,
    0x5faa,
    0x65ec,
    0x8be2,
    0x5bfb,
    0x9a6f,
    0x5de1,
    0x6b89,
    0x6c5b,
    0x8bad,
    0x8baf,
    0x900a,
    0x8fc5,
    0x538b,
    0x62bc,
    0x9e26,
    0x9e2d,
    0x5440,
    0x4e2b,
    0x82bd,
    0x7259,
    0x869c,
    0x5d16,
    0x8859,
    0x6daf,
    0x96c5,
    0x54d1,
    0x4e9a,
    0x8bb6,
    0x7109,
    0x54bd,
    0x9609,
    0x70df,
    0x6df9,
    0x76d0,
    0x4e25,
    0x7814,
    0x8712,
    0x5ca9,
    0x5ef6,
    0x8a00,
    0x989c,
    0x960e,
    0x708e,
    0x6cbf,
    0x5944,
    0x63a9,
    0x773c,
    0x884d,
    0x6f14,
    0x8273,
    0x5830,
    0x71d5,
    0x538c,
    0x781a,
    0x96c1,
    0x5501,
    0x5f66,
    0x7130,
    0x5bb4,
    0x8c1a,
    0x9a8c,
    0x6b83,
    0x592e,
    0x9e2f,
    0x79e7,
    0x6768,
    0x626c,
    0x4f6f,
    0x75a1,
    0x7f8a,
    0x6d0b,
    0x9633,
    0x6c27,
    0x4ef0,
    0x75d2,
    0x517b,
    0x6837,
    0x6f3e,
    0x9080,
    0x8170,
    0x5996,
    0x7476,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xd2[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x8938,
    0x8939,
    0x893a,
    0x893b,
    0x893c,
    0x893d,
    0x893e,
    0x893f,
    0x8940,
    0x8942,
    0x8943,
    0x8945,
    0x8946,
    0x8947,
    0x8948,
    0x8949,
    0x894a,
    0x894b,
    0x894c,
    0x894d,
    0x894e,
    0x894f,
    0x8950,
    0x8951,
    0x8952,
    0x8953,
    0x8954,
    0x8955,
    0x8956,
    0x8957,
    0x8958,
    0x8959,
    0x895a,
    0x895b,
    0x895c,
    0x895d,
    0x8960,
    0x8961,
    0x8962,
    0x8963,
    0x8964,
    0x8965,
    0x8967,
    0x8968,
    0x8969,
    0x896a,
    0x896b,
    0x896c,
    0x896d,
    0x896e,
    0x896f,
    0x8970,
    0x8971,
    0x8972,
    0x8973,
    0x8974,
    0x8975,
    0x8976,
    0x8977,
    0x8978,
    0x8979,
    0x897a,
    0x897c,
    CP936_CP_VAL_NULL,
    0x897d,
    0x897e,
    0x8980,
    0x8982,
    0x8984,
    0x8985,
    0x8987,
    0x8988,
    0x8989,
    0x898a,
    0x898b,
    0x898c,
    0x898d,
    0x898e,
    0x898f,
    0x8990,
    0x8991,
    0x8992,
    0x8993,
    0x8994,
    0x8995,
    0x8996,
    0x8997,
    0x8998,
    0x8999,
    0x899a,
    0x899b,
    0x899c,
    0x899d,
    0x899e,
    0x899f,
    0x89a0,
    0x89a1,
    0x6447,
    0x5c27,
    0x9065,
    0x7a91,
    0x8c23,
    0x59da,
    0x54ac,
    0x8200,
    0x836f,
    0x8981,
    0x8000,
    0x6930,
    0x564e,
    0x8036,
    0x7237,
    0x91ce,
    0x51b6,
    0x4e5f,
    0x9875,
    0x6396,
    0x4e1a,
    0x53f6,
    0x66f3,
    0x814b,
    0x591c,
    0x6db2,
    0x4e00,
    0x58f9,
    0x533b,
    0x63d6,
    0x94f1,
    0x4f9d,
    0x4f0a,
    0x8863,
    0x9890,
    0x5937,
    0x9057,
    0x79fb,
    0x4eea,
    0x80f0,
    0x7591,
    0x6c82,
    0x5b9c,
    0x59e8,
    0x5f5d,
    0x6905,
    0x8681,
    0x501a,
    0x5df2,
    0x4e59,
    0x77e3,
    0x4ee5,
    0x827a,
    0x6291,
    0x6613,
    0x9091,
    0x5c79,
    0x4ebf,
    0x5f79,
    0x81c6,
    0x9038,
    0x8084,
    0x75ab,
    0x4ea6,
    0x88d4,
    0x610f,
    0x6bc5,
    0x5fc6,
    0x4e49,
    0x76ca,
    0x6ea2,
    0x8be3,
    0x8bae,
    0x8c0a,
    0x8bd1,
    0x5f02,
    0x7ffc,
    0x7fcc,
    0x7ece,
    0x8335,
    0x836b,
    0x56e0,
    0x6bb7,
    0x97f3,
    0x9634,
    0x59fb,
    0x541f,
    0x94f6,
    0x6deb,
    0x5bc5,
    0x996e,
    0x5c39,
    0x5f15,
    0x9690,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xd3[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x89a2,
    0x89a3,
    0x89a4,
    0x89a5,
    0x89a6,
    0x89a7,
    0x89a8,
    0x89a9,
    0x89aa,
    0x89ab,
    0x89ac,
    0x89ad,
    0x89ae,
    0x89af,
    0x89b0,
    0x89b1,
    0x89b2,
    0x89b3,
    0x89b4,
    0x89b5,
    0x89b6,
    0x89b7,
    0x89b8,
    0x89b9,
    0x89ba,
    0x89bb,
    0x89bc,
    0x89bd,
    0x89be,
    0x89bf,
    0x89c0,
    0x89c3,
    0x89cd,
    0x89d3,
    0x89d4,
    0x89d5,
    0x89d7,
    0x89d8,
    0x89d9,
    0x89db,
    0x89dd,
    0x89df,
    0x89e0,
    0x89e1,
    0x89e2,
    0x89e4,
    0x89e7,
    0x89e8,
    0x89e9,
    0x89ea,
    0x89ec,
    0x89ed,
    0x89ee,
    0x89f0,
    0x89f1,
    0x89f2,
    0x89f4,
    0x89f5,
    0x89f6,
    0x89f7,
    0x89f8,
    0x89f9,
    0x89fa,
    CP936_CP_VAL_NULL,
    0x89fb,
    0x89fc,
    0x89fd,
    0x89fe,
    0x89ff,
    0x8a01,
    0x8a02,
    0x8a03,
    0x8a04,
    0x8a05,
    0x8a06,
    0x8a08,
    0x8a09,
    0x8a0a,
    0x8a0b,
    0x8a0c,
    0x8a0d,
    0x8a0e,
    0x8a0f,
    0x8a10,
    0x8a11,
    0x8a12,
    0x8a13,
    0x8a14,
    0x8a15,
    0x8a16,
    0x8a17,
    0x8a18,
    0x8a19,
    0x8a1a,
    0x8a1b,
    0x8a1c,
    0x8a1d,
    0x5370,
    0x82f1,
    0x6a31,
    0x5a74,
    0x9e70,
    0x5e94,
    0x7f28,
    0x83b9,
    0x8424,
    0x8425,
    0x8367,
    0x8747,
    0x8fce,
    0x8d62,
    0x76c8,
    0x5f71,
    0x9896,
    0x786c,
    0x6620,
    0x54df,
    0x62e5,
    0x4f63,
    0x81c3,
    0x75c8,
    0x5eb8,
    0x96cd,
    0x8e0a,
    0x86f9,
    0x548f,
    0x6cf3,
    0x6d8c,
    0x6c38,
    0x607f,
    0x52c7,
    0x7528,
    0x5e7d,
    0x4f18,
    0x60a0,
    0x5fe7,
    0x5c24,
    0x7531,
    0x90ae,
    0x94c0,
    0x72b9,
    0x6cb9,
    0x6e38,
    0x9149,
    0x6709,
    0x53cb,
    0x53f3,
    0x4f51,
    0x91c9,
    0x8bf1,
    0x53c8,
    0x5e7c,
    0x8fc2,
    0x6de4,
    0x4e8e,
    0x76c2,
    0x6986,
    0x865e,
    0x611a,
    0x8206,
    0x4f59,
    0x4fde,
    0x903e,
    0x9c7c,
    0x6109,
    0x6e1d,
    0x6e14,
    0x9685,
    0x4e88,
    0x5a31,
    0x96e8,
    0x4e0e,
    0x5c7f,
    0x79b9,
    0x5b87,
    0x8bed,
    0x7fbd,
    0x7389,
    0x57df,
    0x828b,
    0x90c1,
    0x5401,
    0x9047,
    0x55bb,
    0x5cea,
    0x5fa1,
    0x6108,
    0x6b32,
    0x72f1,
    0x80b2,
    0x8a89,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xd4[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x8a1e,
    0x8a1f,
    0x8a20,
    0x8a21,
    0x8a22,
    0x8a23,
    0x8a24,
    0x8a25,
    0x8a26,
    0x8a27,
    0x8a28,
    0x8a29,
    0x8a2a,
    0x8a2b,
    0x8a2c,
    0x8a2d,
    0x8a2e,
    0x8a2f,
    0x8a30,
    0x8a31,
    0x8a32,
    0x8a33,
    0x8a34,
    0x8a35,
    0x8a36,
    0x8a37,
    0x8a38,
    0x8a39,
    0x8a3a,
    0x8a3b,
    0x8a3c,
    0x8a3d,
    0x8a3f,
    0x8a40,
    0x8a41,
    0x8a42,
    0x8a43,
    0x8a44,
    0x8a45,
    0x8a46,
    0x8a47,
    0x8a49,
    0x8a4a,
    0x8a4b,
    0x8a4c,
    0x8a4d,
    0x8a4e,
    0x8a4f,
    0x8a50,
    0x8a51,
    0x8a52,
    0x8a53,
    0x8a54,
    0x8a55,
    0x8a56,
    0x8a57,
    0x8a58,
    0x8a59,
    0x8a5a,
    0x8a5b,
    0x8a5c,
    0x8a5d,
    0x8a5e,
    CP936_CP_VAL_NULL,
    0x8a5f,
    0x8a60,
    0x8a61,
    0x8a62,
    0x8a63,
    0x8a64,
    0x8a65,
    0x8a66,
    0x8a67,
    0x8a68,
    0x8a69,
    0x8a6a,
    0x8a6b,
    0x8a6c,
    0x8a6d,
    0x8a6e,
    0x8a6f,
    0x8a70,
    0x8a71,
    0x8a72,
    0x8a73,
    0x8a74,
    0x8a75,
    0x8a76,
    0x8a77,
    0x8a78,
    0x8a7a,
    0x8a7b,
    0x8a7c,
    0x8a7d,
    0x8a7e,
    0x8a7f,
    0x8a80,
    0x6d74,
    0x5bd3,
    0x88d5,
    0x9884,
    0x8c6b,
    0x9a6d,
    0x9e33,
    0x6e0a,
    0x51a4,
    0x5143,
    0x57a3,
    0x8881,
    0x539f,
    0x63f4,
    0x8f95,
    0x56ed,
    0x5458,
    0x5706,
    0x733f,
    0x6e90,
    0x7f18,
    0x8fdc,
    0x82d1,
    0x613f,
    0x6028,
    0x9662,
    0x66f0,
    0x7ea6,
    0x8d8a,
    0x8dc3,
    0x94a5,
    0x5cb3,
    0x7ca4,
    0x6708,
    0x60a6,
    0x9605,
    0x8018,
    0x4e91,
    0x90e7,
    0x5300,
    0x9668,
    0x5141,
    0x8fd0,
    0x8574,
    0x915d,
    0x6655,
    0x97f5,
    0x5b55,
    0x531d,
    0x7838,
    0x6742,
    0x683d,
    0x54c9,
    0x707e,
    0x5bb0,
    0x8f7d,
    0x518d,
    0x5728,
    0x54b1,
    0x6512,
    0x6682,
    0x8d5e,
    0x8d43,
    0x810f,
    0x846c,
    0x906d,
    0x7cdf,
    0x51ff,
    0x85fb,
    0x67a3,
    0x65e9,
    0x6fa1,
    0x86a4,
    0x8e81,
    0x566a,
    0x9020,
    0x7682,
    0x7076,
    0x71e5,
    0x8d23,
    0x62e9,
    0x5219,
    0x6cfd,
    0x8d3c,
    0x600e,
    0x589e,
    0x618e,
    0x66fe,
    0x8d60,
    0x624e,
    0x55b3,
    0x6e23,
    0x672d,
    0x8f67,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xd5[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x8a81,
    0x8a82,
    0x8a83,
    0x8a84,
    0x8a85,
    0x8a86,
    0x8a87,
    0x8a88,
    0x8a8b,
    0x8a8c,
    0x8a8d,
    0x8a8e,
    0x8a8f,
    0x8a90,
    0x8a91,
    0x8a92,
    0x8a94,
    0x8a95,
    0x8a96,
    0x8a97,
    0x8a98,
    0x8a99,
    0x8a9a,
    0x8a9b,
    0x8a9c,
    0x8a9d,
    0x8a9e,
    0x8a9f,
    0x8aa0,
    0x8aa1,
    0x8aa2,
    0x8aa3,
    0x8aa4,
    0x8aa5,
    0x8aa6,
    0x8aa7,
    0x8aa8,
    0x8aa9,
    0x8aaa,
    0x8aab,
    0x8aac,
    0x8aad,
    0x8aae,
    0x8aaf,
    0x8ab0,
    0x8ab1,
    0x8ab2,
    0x8ab3,
    0x8ab4,
    0x8ab5,
    0x8ab6,
    0x8ab7,
    0x8ab8,
    0x8ab9,
    0x8aba,
    0x8abb,
    0x8abc,
    0x8abd,
    0x8abe,
    0x8abf,
    0x8ac0,
    0x8ac1,
    0x8ac2,
    CP936_CP_VAL_NULL,
    0x8ac3,
    0x8ac4,
    0x8ac5,
    0x8ac6,
    0x8ac7,
    0x8ac8,
    0x8ac9,
    0x8aca,
    0x8acb,
    0x8acc,
    0x8acd,
    0x8ace,
    0x8acf,
    0x8ad0,
    0x8ad1,
    0x8ad2,
    0x8ad3,
    0x8ad4,
    0x8ad5,
    0x8ad6,
    0x8ad7,
    0x8ad8,
    0x8ad9,
    0x8ada,
    0x8adb,
    0x8adc,
    0x8add,
    0x8ade,
    0x8adf,
    0x8ae0,
    0x8ae1,
    0x8ae2,
    0x8ae3,
    0x94e1,
    0x95f8,
    0x7728,
    0x6805,
    0x69a8,
    0x548b,
    0x4e4d,
    0x70b8,
    0x8bc8,
    0x6458,
    0x658b,
    0x5b85,
    0x7a84,
    0x503a,
    0x5be8,
    0x77bb,
    0x6be1,
    0x8a79,
    0x7c98,
    0x6cbe,
    0x76cf,
    0x65a9,
    0x8f97,
    0x5d2d,
    0x5c55,
    0x8638,
    0x6808,
    0x5360,
    0x6218,
    0x7ad9,
    0x6e5b,
    0x7efd,
    0x6a1f,
    0x7ae0,
    0x5f70,
    0x6f33,
    0x5f20,
    0x638c,
    0x6da8,
    0x6756,
    0x4e08,
    0x5e10,
    0x8d26,
    0x4ed7,
    0x80c0,
    0x7634,
    0x969c,
    0x62db,
    0x662d,
    0x627e,
    0x6cbc,
    0x8d75,
    0x7167,
    0x7f69,
    0x5146,
    0x8087,
    0x53ec,
    0x906e,
    0x6298,
    0x54f2,
    0x86f0,
    0x8f99,
    0x8005,
    0x9517,
    0x8517,
    0x8fd9,
    0x6d59,
    0x73cd,
    0x659f,
    0x771f,
    0x7504,
    0x7827,
    0x81fb,
    0x8d1e,
    0x9488,
    0x4fa6,
    0x6795,
    0x75b9,
    0x8bca,
    0x9707,
    0x632f,
    0x9547,
    0x9635,
    0x84b8,
    0x6323,
    0x7741,
    0x5f81,
    0x72f0,
    0x4e89,
    0x6014,
    0x6574,
    0x62ef,
    0x6b63,
    0x653f,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xd6[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x8ae4,
    0x8ae5,
    0x8ae6,
    0x8ae7,
    0x8ae8,
    0x8ae9,
    0x8aea,
    0x8aeb,
    0x8aec,
    0x8aed,
    0x8aee,
    0x8aef,
    0x8af0,
    0x8af1,
    0x8af2,
    0x8af3,
    0x8af4,
    0x8af5,
    0x8af6,
    0x8af7,
    0x8af8,
    0x8af9,
    0x8afa,
    0x8afb,
    0x8afc,
    0x8afd,
    0x8afe,
    0x8aff,
    0x8b00,
    0x8b01,
    0x8b02,
    0x8b03,
    0x8b04,
    0x8b05,
    0x8b06,
    0x8b08,
    0x8b09,
    0x8b0a,
    0x8b0b,
    0x8b0c,
    0x8b0d,
    0x8b0e,
    0x8b0f,
    0x8b10,
    0x8b11,
    0x8b12,
    0x8b13,
    0x8b14,
    0x8b15,
    0x8b16,
    0x8b17,
    0x8b18,
    0x8b19,
    0x8b1a,
    0x8b1b,
    0x8b1c,
    0x8b1d,
    0x8b1e,
    0x8b1f,
    0x8b20,
    0x8b21,
    0x8b22,
    0x8b23,
    CP936_CP_VAL_NULL,
    0x8b24,
    0x8b25,
    0x8b27,
    0x8b28,
    0x8b29,
    0x8b2a,
    0x8b2b,
    0x8b2c,
    0x8b2d,
    0x8b2e,
    0x8b2f,
    0x8b30,
    0x8b31,
    0x8b32,
    0x8b33,
    0x8b34,
    0x8b35,
    0x8b36,
    0x8b37,
    0x8b38,
    0x8b39,
    0x8b3a,
    0x8b3b,
    0x8b3c,
    0x8b3d,
    0x8b3e,
    0x8b3f,
    0x8b40,
    0x8b41,
    0x8b42,
    0x8b43,
    0x8b44,
    0x8b45,
    0x5e27,
    0x75c7,
    0x90d1,
    0x8bc1,
    0x829d,
    0x679d,
    0x652f,
    0x5431,
    0x8718,
    0x77e5,
    0x80a2,
    0x8102,
    0x6c41,
    0x4e4b,
    0x7ec7,
    0x804c,
    0x76f4,
    0x690d,
    0x6b96,
    0x6267,
    0x503c,
    0x4f84,
    0x5740,
    0x6307,
    0x6b62,
    0x8dbe,
    0x53ea,
    0x65e8,
    0x7eb8,
    0x5fd7,
    0x631a,
    0x63b7,
    0x81f3,
    0x81f4,
    0x7f6e,
    0x5e1c,
    0x5cd9,
    0x5236,
    0x667a,
    0x79e9,
    0x7a1a,
    0x8d28,
    0x7099,
    0x75d4,
    0x6ede,
    0x6cbb,
    0x7a92,
    0x4e2d,
    0x76c5,
    0x5fe0,
    0x949f,
    0x8877,
    0x7ec8,
    0x79cd,
    0x80bf,
    0x91cd,
    0x4ef2,
    0x4f17,
    0x821f,
    0x5468,
    0x5dde,
    0x6d32,
    0x8bcc,
    0x7ca5,
    0x8f74,
    0x8098,
    0x5e1a,
    0x5492,
    0x76b1,
    0x5b99,
    0x663c,
    0x9aa4,
    0x73e0,
    0x682a,
    0x86db,
    0x6731,
    0x732a,
    0x8bf8,
    0x8bdb,
    0x9010,
    0x7af9,
    0x70db,
    0x716e,
    0x62c4,
    0x77a9,
    0x5631,
    0x4e3b,
    0x8457,
    0x67f1,
    0x52a9,
    0x86c0,
    0x8d2e,
    0x94f8,
    0x7b51,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xd7[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x8b46,
    0x8b47,
    0x8b48,
    0x8b49,
    0x8b4a,
    0x8b4b,
    0x8b4c,
    0x8b4d,
    0x8b4e,
    0x8b4f,
    0x8b50,
    0x8b51,
    0x8b52,
    0x8b53,
    0x8b54,
    0x8b55,
    0x8b56,
    0x8b57,
    0x8b58,
    0x8b59,
    0x8b5a,
    0x8b5b,
    0x8b5c,
    0x8b5d,
    0x8b5e,
    0x8b5f,
    0x8b60,
    0x8b61,
    0x8b62,
    0x8b63,
    0x8b64,
    0x8b65,
    0x8b67,
    0x8b68,
    0x8b69,
    0x8b6a,
    0x8b6b,
    0x8b6d,
    0x8b6e,
    0x8b6f,
    0x8b70,
    0x8b71,
    0x8b72,
    0x8b73,
    0x8b74,
    0x8b75,
    0x8b76,
    0x8b77,
    0x8b78,
    0x8b79,
    0x8b7a,
    0x8b7b,
    0x8b7c,
    0x8b7d,
    0x8b7e,
    0x8b7f,
    0x8b80,
    0x8b81,
    0x8b82,
    0x8b83,
    0x8b84,
    0x8b85,
    0x8b86,
    CP936_CP_VAL_NULL,
    0x8b87,
    0x8b88,
    0x8b89,
    0x8b8a,
    0x8b8b,
    0x8b8c,
    0x8b8d,
    0x8b8e,
    0x8b8f,
    0x8b90,
    0x8b91,
    0x8b92,
    0x8b93,
    0x8b94,
    0x8b95,
    0x8b96,
    0x8b97,
    0x8b98,
    0x8b99,
    0x8b9a,
    0x8b9b,
    0x8b9c,
    0x8b9d,
    0x8b9e,
    0x8b9f,
    0x8bac,
    0x8bb1,
    0x8bbb,
    0x8bc7,
    0x8bd0,
    0x8bea,
    0x8c09,
    0x8c1e,
    0x4f4f,
    0x6ce8,
    0x795d,
    0x9a7b,
    0x6293,
    0x722a,
    0x62fd,
    0x4e13,
    0x7816,
    0x8f6c,
    0x64b0,
    0x8d5a,
    0x7bc6,
    0x6869,
    0x5e84,
    0x88c5,
    0x5986,
    0x649e,
    0x58ee,
    0x72b6,
    0x690e,
    0x9525,
    0x8ffd,
    0x8d58,
    0x5760,
    0x7f00,
    0x8c06,
    0x51c6,
    0x6349,
    0x62d9,
    0x5353,
    0x684c,
    0x7422,
    0x8301,
    0x914c,
    0x5544,
    0x7740,
    0x707c,
    0x6d4a,
    0x5179,
    0x54a8,
    0x8d44,
    0x59ff,
    0x6ecb,
    0x6dc4,
    0x5b5c,
    0x7d2b,
    0x4ed4,
    0x7c7d,
    0x6ed3,
    0x5b50,
    0x81ea,
    0x6e0d,
    0x5b57,
    0x9b03,
    0x68d5,
    0x8e2a,
    0x5b97,
    0x7efc,
    0x603b,
    0x7eb5,
    0x90b9,
    0x8d70,
    0x594f,
    0x63cd,
    0x79df,
    0x8db3,
    0x5352,
    0x65cf,
    0x7956,
    0x8bc5,
    0x963b,
    0x7ec4,
    0x94bb,
    0x7e82,
    0x5634,
    0x9189,
    0x6700,
    0x7f6a,
    0x5c0a,
    0x9075,
    0x6628,
    0x5de6,
    0x4f50,
    0x67de,
    0x505a,
    0x4f5c,
    0x5750,
    0x5ea7,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xd8[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x8c38,
    0x8c39,
    0x8c3a,
    0x8c3b,
    0x8c3c,
    0x8c3d,
    0x8c3e,
    0x8c3f,
    0x8c40,
    0x8c42,
    0x8c43,
    0x8c44,
    0x8c45,
    0x8c48,
    0x8c4a,
    0x8c4b,
    0x8c4d,
    0x8c4e,
    0x8c4f,
    0x8c50,
    0x8c51,
    0x8c52,
    0x8c53,
    0x8c54,
    0x8c56,
    0x8c57,
    0x8c58,
    0x8c59,
    0x8c5b,
    0x8c5c,
    0x8c5d,
    0x8c5e,
    0x8c5f,
    0x8c60,
    0x8c63,
    0x8c64,
    0x8c65,
    0x8c66,
    0x8c67,
    0x8c68,
    0x8c69,
    0x8c6c,
    0x8c6d,
    0x8c6e,
    0x8c6f,
    0x8c70,
    0x8c71,
    0x8c72,
    0x8c74,
    0x8c75,
    0x8c76,
    0x8c77,
    0x8c7b,
    0x8c7c,
    0x8c7d,
    0x8c7e,
    0x8c7f,
    0x8c80,
    0x8c81,
    0x8c83,
    0x8c84,
    0x8c86,
    0x8c87,
    CP936_CP_VAL_NULL,
    0x8c88,
    0x8c8b,
    0x8c8d,
    0x8c8e,
    0x8c8f,
    0x8c90,
    0x8c91,
    0x8c92,
    0x8c93,
    0x8c95,
    0x8c96,
    0x8c97,
    0x8c99,
    0x8c9a,
    0x8c9b,
    0x8c9c,
    0x8c9d,
    0x8c9e,
    0x8c9f,
    0x8ca0,
    0x8ca1,
    0x8ca2,
    0x8ca3,
    0x8ca4,
    0x8ca5,
    0x8ca6,
    0x8ca7,
    0x8ca8,
    0x8ca9,
    0x8caa,
    0x8cab,
    0x8cac,
    0x8cad,
    0x4e8d,
    0x4e0c,
    0x5140,
    0x4e10,
    0x5eff,
    0x5345,
    0x4e15,
    0x4e98,
    0x4e1e,
    0x9b32,
    0x5b6c,
    0x5669,
    0x4e28,
    0x79ba,
    0x4e3f,
    0x5315,
    0x4e47,
    0x592d,
    0x723b,
    0x536e,
    0x6c10,
    0x56df,
    0x80e4,
    0x9997,
    0x6bd3,
    0x777e,
    0x9f17,
    0x4e36,
    0x4e9f,
    0x9f10,
    0x4e5c,
    0x4e69,
    0x4e93,
    0x8288,
    0x5b5b,
    0x556c,
    0x560f,
    0x4ec4,
    0x538d,
    0x539d,
    0x53a3,
    0x53a5,
    0x53ae,
    0x9765,
    0x8d5d,
    0x531a,
    0x53f5,
    0x5326,
    0x532e,
    0x533e,
    0x8d5c,
    0x5366,
    0x5363,
    0x5202,
    0x5208,
    0x520e,
    0x522d,
    0x5233,
    0x523f,
    0x5240,
    0x524c,
    0x525e,
    0x5261,
    0x525c,
    0x84af,
    0x527d,
    0x5282,
    0x5281,
    0x5290,
    0x5293,
    0x5182,
    0x7f54,
    0x4ebb,
    0x4ec3,
    0x4ec9,
    0x4ec2,
    0x4ee8,
    0x4ee1,
    0x4eeb,
    0x4ede,
    0x4f1b,
    0x4ef3,
    0x4f22,
    0x4f64,
    0x4ef5,
    0x4f25,
    0x4f27,
    0x4f09,
    0x4f2b,
    0x4f5e,
    0x4f67,
    0x6538,
    0x4f5a,
    0x4f5d,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xd9[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x8cae,
    0x8caf,
    0x8cb0,
    0x8cb1,
    0x8cb2,
    0x8cb3,
    0x8cb4,
    0x8cb5,
    0x8cb6,
    0x8cb7,
    0x8cb8,
    0x8cb9,
    0x8cba,
    0x8cbb,
    0x8cbc,
    0x8cbd,
    0x8cbe,
    0x8cbf,
    0x8cc0,
    0x8cc1,
    0x8cc2,
    0x8cc3,
    0x8cc4,
    0x8cc5,
    0x8cc6,
    0x8cc7,
    0x8cc8,
    0x8cc9,
    0x8cca,
    0x8ccb,
    0x8ccc,
    0x8ccd,
    0x8cce,
    0x8ccf,
    0x8cd0,
    0x8cd1,
    0x8cd2,
    0x8cd3,
    0x8cd4,
    0x8cd5,
    0x8cd6,
    0x8cd7,
    0x8cd8,
    0x8cd9,
    0x8cda,
    0x8cdb,
    0x8cdc,
    0x8cdd,
    0x8cde,
    0x8cdf,
    0x8ce0,
    0x8ce1,
    0x8ce2,
    0x8ce3,
    0x8ce4,
    0x8ce5,
    0x8ce6,
    0x8ce7,
    0x8ce8,
    0x8ce9,
    0x8cea,
    0x8ceb,
    0x8cec,
    CP936_CP_VAL_NULL,
    0x8ced,
    0x8cee,
    0x8cef,
    0x8cf0,
    0x8cf1,
    0x8cf2,
    0x8cf3,
    0x8cf4,
    0x8cf5,
    0x8cf6,
    0x8cf7,
    0x8cf8,
    0x8cf9,
    0x8cfa,
    0x8cfb,
    0x8cfc,
    0x8cfd,
    0x8cfe,
    0x8cff,
    0x8d00,
    0x8d01,
    0x8d02,
    0x8d03,
    0x8d04,
    0x8d05,
    0x8d06,
    0x8d07,
    0x8d08,
    0x8d09,
    0x8d0a,
    0x8d0b,
    0x8d0c,
    0x8d0d,
    0x4f5f,
    0x4f57,
    0x4f32,
    0x4f3d,
    0x4f76,
    0x4f74,
    0x4f91,
    0x4f89,
    0x4f83,
    0x4f8f,
    0x4f7e,
    0x4f7b,
    0x4faa,
    0x4f7c,
    0x4fac,
    0x4f94,
    0x4fe6,
    0x4fe8,
    0x4fea,
    0x4fc5,
    0x4fda,
    0x4fe3,
    0x4fdc,
    0x4fd1,
    0x4fdf,
    0x4ff8,
    0x5029,
    0x504c,
    0x4ff3,
    0x502c,
    0x500f,
    0x502e,
    0x502d,
    0x4ffe,
    0x501c,
    0x500c,
    0x5025,
    0x5028,
    0x507e,
    0x5043,
    0x5055,
    0x5048,
    0x504e,
    0x506c,
    0x507b,
    0x50a5,
    0x50a7,
    0x50a9,
    0x50ba,
    0x50d6,
    0x5106,
    0x50ed,
    0x50ec,
    0x50e6,
    0x50ee,
    0x5107,
    0x510b,
    0x4edd,
    0x6c3d,
    0x4f58,
    0x4f65,
    0x4fce,
    0x9fa0,
    0x6c46,
    0x7c74,
    0x516e,
    0x5dfd,
    0x9ec9,
    0x9998,
    0x5181,
    0x5914,
    0x52f9,
    0x530d,
    0x8a07,
    0x5310,
    0x51eb,
    0x5919,
    0x5155,
    0x4ea0,
    0x5156,
    0x4eb3,
    0x886e,
    0x88a4,
    0x4eb5,
    0x8114,
    0x88d2,
    0x7980,
    0x5b34,
    0x8803,
    0x7fb8,
    0x51ab,
    0x51b1,
    0x51bd,
    0x51bc,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xda[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x8d0e,
    0x8d0f,
    0x8d10,
    0x8d11,
    0x8d12,
    0x8d13,
    0x8d14,
    0x8d15,
    0x8d16,
    0x8d17,
    0x8d18,
    0x8d19,
    0x8d1a,
    0x8d1b,
    0x8d1c,
    0x8d20,
    0x8d51,
    0x8d52,
    0x8d57,
    0x8d5f,
    0x8d65,
    0x8d68,
    0x8d69,
    0x8d6a,
    0x8d6c,
    0x8d6e,
    0x8d6f,
    0x8d71,
    0x8d72,
    0x8d78,
    0x8d79,
    0x8d7a,
    0x8d7b,
    0x8d7c,
    0x8d7d,
    0x8d7e,
    0x8d7f,
    0x8d80,
    0x8d82,
    0x8d83,
    0x8d86,
    0x8d87,
    0x8d88,
    0x8d89,
    0x8d8c,
    0x8d8d,
    0x8d8e,
    0x8d8f,
    0x8d90,
    0x8d92,
    0x8d93,
    0x8d95,
    0x8d96,
    0x8d97,
    0x8d98,
    0x8d99,
    0x8d9a,
    0x8d9b,
    0x8d9c,
    0x8d9d,
    0x8d9e,
    0x8da0,
    0x8da1,
    CP936_CP_VAL_NULL,
    0x8da2,
    0x8da4,
    0x8da5,
    0x8da6,
    0x8da7,
    0x8da8,
    0x8da9,
    0x8daa,
    0x8dab,
    0x8dac,
    0x8dad,
    0x8dae,
    0x8daf,
    0x8db0,
    0x8db2,
    0x8db6,
    0x8db7,
    0x8db9,
    0x8dbb,
    0x8dbd,
    0x8dc0,
    0x8dc1,
    0x8dc2,
    0x8dc5,
    0x8dc7,
    0x8dc8,
    0x8dc9,
    0x8dca,
    0x8dcd,
    0x8dd0,
    0x8dd2,
    0x8dd3,
    0x8dd4,
    0x51c7,
    0x5196,
    0x51a2,
    0x51a5,
    0x8ba0,
    0x8ba6,
    0x8ba7,
    0x8baa,
    0x8bb4,
    0x8bb5,
    0x8bb7,
    0x8bc2,
    0x8bc3,
    0x8bcb,
    0x8bcf,
    0x8bce,
    0x8bd2,
    0x8bd3,
    0x8bd4,
    0x8bd6,
    0x8bd8,
    0x8bd9,
    0x8bdc,
    0x8bdf,
    0x8be0,
    0x8be4,
    0x8be8,
    0x8be9,
    0x8bee,
    0x8bf0,
    0x8bf3,
    0x8bf6,
    0x8bf9,
    0x8bfc,
    0x8bff,
    0x8c00,
    0x8c02,
    0x8c04,
    0x8c07,
    0x8c0c,
    0x8c0f,
    0x8c11,
    0x8c12,
    0x8c14,
    0x8c15,
    0x8c16,
    0x8c19,
    0x8c1b,
    0x8c18,
    0x8c1d,
    0x8c1f,
    0x8c20,
    0x8c21,
    0x8c25,
    0x8c27,
    0x8c2a,
    0x8c2b,
    0x8c2e,
    0x8c2f,
    0x8c32,
    0x8c33,
    0x8c35,
    0x8c36,
    0x5369,
    0x537a,
    0x961d,
    0x9622,
    0x9621,
    0x9631,
    0x962a,
    0x963d,
    0x963c,
    0x9642,
    0x9649,
    0x9654,
    0x965f,
    0x9667,
    0x966c,
    0x9672,
    0x9674,
    0x9688,
    0x968d,
    0x9697,
    0x96b0,
    0x9097,
    0x909b,
    0x909d,
    0x9099,
    0x90ac,
    0x90a1,
    0x90b4,
    0x90b3,
    0x90b6,
    0x90ba,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xdb[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x8dd5,
    0x8dd8,
    0x8dd9,
    0x8ddc,
    0x8de0,
    0x8de1,
    0x8de2,
    0x8de5,
    0x8de6,
    0x8de7,
    0x8de9,
    0x8ded,
    0x8dee,
    0x8df0,
    0x8df1,
    0x8df2,
    0x8df4,
    0x8df6,
    0x8dfc,
    0x8dfe,
    0x8dff,
    0x8e00,
    0x8e01,
    0x8e02,
    0x8e03,
    0x8e04,
    0x8e06,
    0x8e07,
    0x8e08,
    0x8e0b,
    0x8e0d,
    0x8e0e,
    0x8e10,
    0x8e11,
    0x8e12,
    0x8e13,
    0x8e15,
    0x8e16,
    0x8e17,
    0x8e18,
    0x8e19,
    0x8e1a,
    0x8e1b,
    0x8e1c,
    0x8e20,
    0x8e21,
    0x8e24,
    0x8e25,
    0x8e26,
    0x8e27,
    0x8e28,
    0x8e2b,
    0x8e2d,
    0x8e30,
    0x8e32,
    0x8e33,
    0x8e34,
    0x8e36,
    0x8e37,
    0x8e38,
    0x8e3b,
    0x8e3c,
    0x8e3e,
    CP936_CP_VAL_NULL,
    0x8e3f,
    0x8e43,
    0x8e45,
    0x8e46,
    0x8e4c,
    0x8e4d,
    0x8e4e,
    0x8e4f,
    0x8e50,
    0x8e53,
    0x8e54,
    0x8e55,
    0x8e56,
    0x8e57,
    0x8e58,
    0x8e5a,
    0x8e5b,
    0x8e5c,
    0x8e5d,
    0x8e5e,
    0x8e5f,
    0x8e60,
    0x8e61,
    0x8e62,
    0x8e63,
    0x8e64,
    0x8e65,
    0x8e67,
    0x8e68,
    0x8e6a,
    0x8e6b,
    0x8e6e,
    0x8e71,
    0x90b8,
    0x90b0,
    0x90cf,
    0x90c5,
    0x90be,
    0x90d0,
    0x90c4,
    0x90c7,
    0x90d3,
    0x90e6,
    0x90e2,
    0x90dc,
    0x90d7,
    0x90db,
    0x90eb,
    0x90ef,
    0x90fe,
    0x9104,
    0x9122,
    0x911e,
    0x9123,
    0x9131,
    0x912f,
    0x9139,
    0x9143,
    0x9146,
    0x520d,
    0x5942,
    0x52a2,
    0x52ac,
    0x52ad,
    0x52be,
    0x54ff,
    0x52d0,
    0x52d6,
    0x52f0,
    0x53df,
    0x71ee,
    0x77cd,
    0x5ef4,
    0x51f5,
    0x51fc,
    0x9b2f,
    0x53b6,
    0x5f01,
    0x755a,
    0x5def,
    0x574c,
    0x57a9,
    0x57a1,
    0x587e,
    0x58bc,
    0x58c5,
    0x58d1,
    0x5729,
    0x572c,
    0x572a,
    0x5733,
    0x5739,
    0x572e,
    0x572f,
    0x575c,
    0x573b,
    0x5742,
    0x5769,
    0x5785,
    0x576b,
    0x5786,
    0x577c,
    0x577b,
    0x5768,
    0x576d,
    0x5776,
    0x5773,
    0x57ad,
    0x57a4,
    0x578c,
    0x57b2,
    0x57cf,
    0x57a7,
    0x57b4,
    0x5793,
    0x57a0,
    0x57d5,
    0x57d8,
    0x57da,
    0x57d9,
    0x57d2,
    0x57b8,
    0x57f4,
    0x57ef,
    0x57f8,
    0x57e4,
    0x57dd,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xdc[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x8e73,
    0x8e75,
    0x8e77,
    0x8e78,
    0x8e79,
    0x8e7a,
    0x8e7b,
    0x8e7d,
    0x8e7e,
    0x8e80,
    0x8e82,
    0x8e83,
    0x8e84,
    0x8e86,
    0x8e88,
    0x8e89,
    0x8e8a,
    0x8e8b,
    0x8e8c,
    0x8e8d,
    0x8e8e,
    0x8e91,
    0x8e92,
    0x8e93,
    0x8e95,
    0x8e96,
    0x8e97,
    0x8e98,
    0x8e99,
    0x8e9a,
    0x8e9b,
    0x8e9d,
    0x8e9f,
    0x8ea0,
    0x8ea1,
    0x8ea2,
    0x8ea3,
    0x8ea4,
    0x8ea5,
    0x8ea6,
    0x8ea7,
    0x8ea8,
    0x8ea9,
    0x8eaa,
    0x8ead,
    0x8eae,
    0x8eb0,
    0x8eb1,
    0x8eb3,
    0x8eb4,
    0x8eb5,
    0x8eb6,
    0x8eb7,
    0x8eb8,
    0x8eb9,
    0x8ebb,
    0x8ebc,
    0x8ebd,
    0x8ebe,
    0x8ebf,
    0x8ec0,
    0x8ec1,
    0x8ec2,
    CP936_CP_VAL_NULL,
    0x8ec3,
    0x8ec4,
    0x8ec5,
    0x8ec6,
    0x8ec7,
    0x8ec8,
    0x8ec9,
    0x8eca,
    0x8ecb,
    0x8ecc,
    0x8ecd,
    0x8ecf,
    0x8ed0,
    0x8ed1,
    0x8ed2,
    0x8ed3,
    0x8ed4,
    0x8ed5,
    0x8ed6,
    0x8ed7,
    0x8ed8,
    0x8ed9,
    0x8eda,
    0x8edb,
    0x8edc,
    0x8edd,
    0x8ede,
    0x8edf,
    0x8ee0,
    0x8ee1,
    0x8ee2,
    0x8ee3,
    0x8ee4,
    0x580b,
    0x580d,
    0x57fd,
    0x57ed,
    0x5800,
    0x581e,
    0x5819,
    0x5844,
    0x5820,
    0x5865,
    0x586c,
    0x5881,
    0x5889,
    0x589a,
    0x5880,
    0x99a8,
    0x9f19,
    0x61ff,
    0x8279,
    0x827d,
    0x827f,
    0x828f,
    0x828a,
    0x82a8,
    0x8284,
    0x828e,
    0x8291,
    0x8297,
    0x8299,
    0x82ab,
    0x82b8,
    0x82be,
    0x82b0,
    0x82c8,
    0x82ca,
    0x82e3,
    0x8298,
    0x82b7,
    0x82ae,
    0x82cb,
    0x82cc,
    0x82c1,
    0x82a9,
    0x82b4,
    0x82a1,
    0x82aa,
    0x829f,
    0x82c4,
    0x82ce,
    0x82a4,
    0x82e1,
    0x8309,
    0x82f7,
    0x82e4,
    0x830f,
    0x8307,
    0x82dc,
    0x82f4,
    0x82d2,
    0x82d8,
    0x830c,
    0x82fb,
    0x82d3,
    0x8311,
    0x831a,
    0x8306,
    0x8314,
    0x8315,
    0x82e0,
    0x82d5,
    0x831c,
    0x8351,
    0x835b,
    0x835c,
    0x8308,
    0x8392,
    0x833c,
    0x8334,
    0x8331,
    0x839b,
    0x835e,
    0x832f,
    0x834f,
    0x8347,
    0x8343,
    0x835f,
    0x8340,
    0x8317,
    0x8360,
    0x832d,
    0x833a,
    0x8333,
    0x8366,
    0x8365,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xdd[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x8ee5,
    0x8ee6,
    0x8ee7,
    0x8ee8,
    0x8ee9,
    0x8eea,
    0x8eeb,
    0x8eec,
    0x8eed,
    0x8eee,
    0x8eef,
    0x8ef0,
    0x8ef1,
    0x8ef2,
    0x8ef3,
    0x8ef4,
    0x8ef5,
    0x8ef6,
    0x8ef7,
    0x8ef8,
    0x8ef9,
    0x8efa,
    0x8efb,
    0x8efc,
    0x8efd,
    0x8efe,
    0x8eff,
    0x8f00,
    0x8f01,
    0x8f02,
    0x8f03,
    0x8f04,
    0x8f05,
    0x8f06,
    0x8f07,
    0x8f08,
    0x8f09,
    0x8f0a,
    0x8f0b,
    0x8f0c,
    0x8f0d,
    0x8f0e,
    0x8f0f,
    0x8f10,
    0x8f11,
    0x8f12,
    0x8f13,
    0x8f14,
    0x8f15,
    0x8f16,
    0x8f17,
    0x8f18,
    0x8f19,
    0x8f1a,
    0x8f1b,
    0x8f1c,
    0x8f1d,
    0x8f1e,
    0x8f1f,
    0x8f20,
    0x8f21,
    0x8f22,
    0x8f23,
    CP936_CP_VAL_NULL,
    0x8f24,
    0x8f25,
    0x8f26,
    0x8f27,
    0x8f28,
    0x8f29,
    0x8f2a,
    0x8f2b,
    0x8f2c,
    0x8f2d,
    0x8f2e,
    0x8f2f,
    0x8f30,
    0x8f31,
    0x8f32,
    0x8f33,
    0x8f34,
    0x8f35,
    0x8f36,
    0x8f37,
    0x8f38,
    0x8f39,
    0x8f3a,
    0x8f3b,
    0x8f3c,
    0x8f3d,
    0x8f3e,
    0x8f3f,
    0x8f40,
    0x8f41,
    0x8f42,
    0x8f43,
    0x8f44,
    0x8368,
    0x831b,
    0x8369,
    0x836c,
    0x836a,
    0x836d,
    0x836e,
    0x83b0,
    0x8378,
    0x83b3,
    0x83b4,
    0x83a0,
    0x83aa,
    0x8393,
    0x839c,
    0x8385,
    0x837c,
    0x83b6,
    0x83a9,
    0x837d,
    0x83b8,
    0x837b,
    0x8398,
    0x839e,
    0x83a8,
    0x83ba,
    0x83bc,
    0x83c1,
    0x8401,
    0x83e5,
    0x83d8,
    0x5807,
    0x8418,
    0x840b,
    0x83dd,
    0x83fd,
    0x83d6,
    0x841c,
    0x8438,
    0x8411,
    0x8406,
    0x83d4,
    0x83df,
    0x840f,
    0x8403,
    0x83f8,
    0x83f9,
    0x83ea,
    0x83c5,
    0x83c0,
    0x8426,
    0x83f0,
    0x83e1,
    0x845c,
    0x8451,
    0x845a,
    0x8459,
    0x8473,
    0x8487,
    0x8488,
    0x847a,
    0x8489,
    0x8478,
    0x843c,
    0x8446,
    0x8469,
    0x8476,
    0x848c,
    0x848e,
    0x8431,
    0x846d,
    0x84c1,
    0x84cd,
    0x84d0,
    0x84e6,
    0x84bd,
    0x84d3,
    0x84ca,
    0x84bf,
    0x84ba,
    0x84e0,
    0x84a1,
    0x84b9,
    0x84b4,
    0x8497,
    0x84e5,
    0x84e3,
    0x850c,
    0x750d,
    0x8538,
    0x84f0,
    0x8539,
    0x851f,
    0x853a,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xde[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x8f45,
    0x8f46,
    0x8f47,
    0x8f48,
    0x8f49,
    0x8f4a,
    0x8f4b,
    0x8f4c,
    0x8f4d,
    0x8f4e,
    0x8f4f,
    0x8f50,
    0x8f51,
    0x8f52,
    0x8f53,
    0x8f54,
    0x8f55,
    0x8f56,
    0x8f57,
    0x8f58,
    0x8f59,
    0x8f5a,
    0x8f5b,
    0x8f5c,
    0x8f5d,
    0x8f5e,
    0x8f5f,
    0x8f60,
    0x8f61,
    0x8f62,
    0x8f63,
    0x8f64,
    0x8f65,
    0x8f6a,
    0x8f80,
    0x8f8c,
    0x8f92,
    0x8f9d,
    0x8fa0,
    0x8fa1,
    0x8fa2,
    0x8fa4,
    0x8fa5,
    0x8fa6,
    0x8fa7,
    0x8faa,
    0x8fac,
    0x8fad,
    0x8fae,
    0x8faf,
    0x8fb2,
    0x8fb3,
    0x8fb4,
    0x8fb5,
    0x8fb7,
    0x8fb8,
    0x8fba,
    0x8fbb,
    0x8fbc,
    0x8fbf,
    0x8fc0,
    0x8fc3,
    0x8fc6,
    CP936_CP_VAL_NULL,
    0x8fc9,
    0x8fca,
    0x8fcb,
    0x8fcc,
    0x8fcd,
    0x8fcf,
    0x8fd2,
    0x8fd6,
    0x8fd7,
    0x8fda,
    0x8fe0,
    0x8fe1,
    0x8fe3,
    0x8fe7,
    0x8fec,
    0x8fef,
    0x8ff1,
    0x8ff2,
    0x8ff4,
    0x8ff5,
    0x8ff6,
    0x8ffa,
    0x8ffb,
    0x8ffc,
    0x8ffe,
    0x8fff,
    0x9007,
    0x9008,
    0x900c,
    0x900e,
    0x9013,
    0x9015,
    0x9018,
    0x8556,
    0x853b,
    0x84ff,
    0x84fc,
    0x8559,
    0x8548,
    0x8568,
    0x8564,
    0x855e,
    0x857a,
    0x77a2,
    0x8543,
    0x8572,
    0x857b,
    0x85a4,
    0x85a8,
    0x8587,
    0x858f,
    0x8579,
    0x85ae,
    0x859c,
    0x8585,
    0x85b9,
    0x85b7,
    0x85b0,
    0x85d3,
    0x85c1,
    0x85dc,
    0x85ff,
    0x8627,
    0x8605,
    0x8629,
    0x8616,
    0x863c,
    0x5efe,
    0x5f08,
    0x593c,
    0x5941,
    0x8037,
    0x5955,
    0x595a,
    0x5958,
    0x530f,
    0x5c22,
    0x5c25,
    0x5c2c,
    0x5c34,
    0x624c,
    0x626a,
    0x629f,
    0x62bb,
    0x62ca,
    0x62da,
    0x62d7,
    0x62ee,
    0x6322,
    0x62f6,
    0x6339,
    0x634b,
    0x6343,
    0x63ad,
    0x63f6,
    0x6371,
    0x637a,
    0x638e,
    0x63b4,
    0x636d,
    0x63ac,
    0x638a,
    0x6369,
    0x63ae,
    0x63bc,
    0x63f2,
    0x63f8,
    0x63e0,
    0x63ff,
    0x63c4,
    0x63de,
    0x63ce,
    0x6452,
    0x63c6,
    0x63be,
    0x6445,
    0x6441,
    0x640b,
    0x641b,
    0x6420,
    0x640c,
    0x6426,
    0x6421,
    0x645e,
    0x6484,
    0x646d,
    0x6496,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xdf[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x9019,
    0x901c,
    0x9023,
    0x9024,
    0x9025,
    0x9027,
    0x9028,
    0x9029,
    0x902a,
    0x902b,
    0x902c,
    0x9030,
    0x9031,
    0x9032,
    0x9033,
    0x9034,
    0x9037,
    0x9039,
    0x903a,
    0x903d,
    0x903f,
    0x9040,
    0x9043,
    0x9045,
    0x9046,
    0x9048,
    0x9049,
    0x904a,
    0x904b,
    0x904c,
    0x904e,
    0x9054,
    0x9055,
    0x9056,
    0x9059,
    0x905a,
    0x905c,
    0x905d,
    0x905e,
    0x905f,
    0x9060,
    0x9061,
    0x9064,
    0x9066,
    0x9067,
    0x9069,
    0x906a,
    0x906b,
    0x906c,
    0x906f,
    0x9070,
    0x9071,
    0x9072,
    0x9073,
    0x9076,
    0x9077,
    0x9078,
    0x9079,
    0x907a,
    0x907b,
    0x907c,
    0x907e,
    0x9081,
    CP936_CP_VAL_NULL,
    0x9084,
    0x9085,
    0x9086,
    0x9087,
    0x9089,
    0x908a,
    0x908c,
    0x908d,
    0x908e,
    0x908f,
    0x9090,
    0x9092,
    0x9094,
    0x9096,
    0x9098,
    0x909a,
    0x909c,
    0x909e,
    0x909f,
    0x90a0,
    0x90a4,
    0x90a5,
    0x90a7,
    0x90a8,
    0x90a9,
    0x90ab,
    0x90ad,
    0x90b2,
    0x90b7,
    0x90bc,
    0x90bd,
    0x90bf,
    0x90c0,
    0x647a,
    0x64b7,
    0x64b8,
    0x6499,
    0x64ba,
    0x64c0,
    0x64d0,
    0x64d7,
    0x64e4,
    0x64e2,
    0x6509,
    0x6525,
    0x652e,
    0x5f0b,
    0x5fd2,
    0x7519,
    0x5f11,
    0x535f,
    0x53f1,
    0x53fd,
    0x53e9,
    0x53e8,
    0x53fb,
    0x5412,
    0x5416,
    0x5406,
    0x544b,
    0x5452,
    0x5453,
    0x5454,
    0x5456,
    0x5443,
    0x5421,
    0x5457,
    0x5459,
    0x5423,
    0x5432,
    0x5482,
    0x5494,
    0x5477,
    0x5471,
    0x5464,
    0x549a,
    0x549b,
    0x5484,
    0x5476,
    0x5466,
    0x549d,
    0x54d0,
    0x54ad,
    0x54c2,
    0x54b4,
    0x54d2,
    0x54a7,
    0x54a6,
    0x54d3,
    0x54d4,
    0x5472,
    0x54a3,
    0x54d5,
    0x54bb,
    0x54bf,
    0x54cc,
    0x54d9,
    0x54da,
    0x54dc,
    0x54a9,
    0x54aa,
    0x54a4,
    0x54dd,
    0x54cf,
    0x54de,
    0x551b,
    0x54e7,
    0x5520,
    0x54fd,
    0x5514,
    0x54f3,
    0x5522,
    0x5523,
    0x550f,
    0x5511,
    0x5527,
    0x552a,
    0x5567,
    0x558f,
    0x55b5,
    0x5549,
    0x556d,
    0x5541,
    0x5555,
    0x553f,
    0x5550,
    0x553c,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xe0[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x90c2,
    0x90c3,
    0x90c6,
    0x90c8,
    0x90c9,
    0x90cb,
    0x90cc,
    0x90cd,
    0x90d2,
    0x90d4,
    0x90d5,
    0x90d6,
    0x90d8,
    0x90d9,
    0x90da,
    0x90de,
    0x90df,
    0x90e0,
    0x90e3,
    0x90e4,
    0x90e5,
    0x90e9,
    0x90ea,
    0x90ec,
    0x90ee,
    0x90f0,
    0x90f1,
    0x90f2,
    0x90f3,
    0x90f5,
    0x90f6,
    0x90f7,
    0x90f9,
    0x90fa,
    0x90fb,
    0x90fc,
    0x90ff,
    0x9100,
    0x9101,
    0x9103,
    0x9105,
    0x9106,
    0x9107,
    0x9108,
    0x9109,
    0x910a,
    0x910b,
    0x910c,
    0x910d,
    0x910e,
    0x910f,
    0x9110,
    0x9111,
    0x9112,
    0x9113,
    0x9114,
    0x9115,
    0x9116,
    0x9117,
    0x9118,
    0x911a,
    0x911b,
    0x911c,
    CP936_CP_VAL_NULL,
    0x911d,
    0x911f,
    0x9120,
    0x9121,
    0x9124,
    0x9125,
    0x9126,
    0x9127,
    0x9128,
    0x9129,
    0x912a,
    0x912b,
    0x912c,
    0x912d,
    0x912e,
    0x9130,
    0x9132,
    0x9133,
    0x9134,
    0x9135,
    0x9136,
    0x9137,
    0x9138,
    0x913a,
    0x913b,
    0x913c,
    0x913d,
    0x913e,
    0x913f,
    0x9140,
    0x9141,
    0x9142,
    0x9144,
    0x5537,
    0x5556,
    0x5575,
    0x5576,
    0x5577,
    0x5533,
    0x5530,
    0x555c,
    0x558b,
    0x55d2,
    0x5583,
    0x55b1,
    0x55b9,
    0x5588,
    0x5581,
    0x559f,
    0x557e,
    0x55d6,
    0x5591,
    0x557b,
    0x55df,
    0x55bd,
    0x55be,
    0x5594,
    0x5599,
    0x55ea,
    0x55f7,
    0x55c9,
    0x561f,
    0x55d1,
    0x55eb,
    0x55ec,
    0x55d4,
    0x55e6,
    0x55dd,
    0x55c4,
    0x55ef,
    0x55e5,
    0x55f2,
    0x55f3,
    0x55cc,
    0x55cd,
    0x55e8,
    0x55f5,
    0x55e4,
    0x8f94,
    0x561e,
    0x5608,
    0x560c,
    0x5601,
    0x5624,
    0x5623,
    0x55fe,
    0x5600,
    0x5627,
    0x562d,
    0x5658,
    0x5639,
    0x5657,
    0x562c,
    0x564d,
    0x5662,
    0x5659,
    0x565c,
    0x564c,
    0x5654,
    0x5686,
    0x5664,
    0x5671,
    0x566b,
    0x567b,
    0x567c,
    0x5685,
    0x5693,
    0x56af,
    0x56d4,
    0x56d7,
    0x56dd,
    0x56e1,
    0x56f5,
    0x56eb,
    0x56f9,
    0x56ff,
    0x5704,
    0x570a,
    0x5709,
    0x571c,
    0x5e0f,
    0x5e19,
    0x5e14,
    0x5e11,
    0x5e31,
    0x5e3b,
    0x5e3c,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xe1[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x9145,
    0x9147,
    0x9148,
    0x9151,
    0x9153,
    0x9154,
    0x9155,
    0x9156,
    0x9158,
    0x9159,
    0x915b,
    0x915c,
    0x915f,
    0x9160,
    0x9166,
    0x9167,
    0x9168,
    0x916b,
    0x916d,
    0x9173,
    0x917a,
    0x917b,
    0x917c,
    0x9180,
    0x9181,
    0x9182,
    0x9183,
    0x9184,
    0x9186,
    0x9188,
    0x918a,
    0x918e,
    0x918f,
    0x9193,
    0x9194,
    0x9195,
    0x9196,
    0x9197,
    0x9198,
    0x9199,
    0x919c,
    0x919d,
    0x919e,
    0x919f,
    0x91a0,
    0x91a1,
    0x91a4,
    0x91a5,
    0x91a6,
    0x91a7,
    0x91a8,
    0x91a9,
    0x91ab,
    0x91ac,
    0x91b0,
    0x91b1,
    0x91b2,
    0x91b3,
    0x91b6,
    0x91b7,
    0x91b8,
    0x91b9,
    0x91bb,
    CP936_CP_VAL_NULL,
    0x91bc,
    0x91bd,
    0x91be,
    0x91bf,
    0x91c0,
    0x91c1,
    0x91c2,
    0x91c3,
    0x91c4,
    0x91c5,
    0x91c6,
    0x91c8,
    0x91cb,
    0x91d0,
    0x91d2,
    0x91d3,
    0x91d4,
    0x91d5,
    0x91d6,
    0x91d7,
    0x91d8,
    0x91d9,
    0x91da,
    0x91db,
    0x91dd,
    0x91de,
    0x91df,
    0x91e0,
    0x91e1,
    0x91e2,
    0x91e3,
    0x91e4,
    0x91e5,
    0x5e37,
    0x5e44,
    0x5e54,
    0x5e5b,
    0x5e5e,
    0x5e61,
    0x5c8c,
    0x5c7a,
    0x5c8d,
    0x5c90,
    0x5c96,
    0x5c88,
    0x5c98,
    0x5c99,
    0x5c91,
    0x5c9a,
    0x5c9c,
    0x5cb5,
    0x5ca2,
    0x5cbd,
    0x5cac,
    0x5cab,
    0x5cb1,
    0x5ca3,
    0x5cc1,
    0x5cb7,
    0x5cc4,
    0x5cd2,
    0x5ce4,
    0x5ccb,
    0x5ce5,
    0x5d02,
    0x5d03,
    0x5d27,
    0x5d26,
    0x5d2e,
    0x5d24,
    0x5d1e,
    0x5d06,
    0x5d1b,
    0x5d58,
    0x5d3e,
    0x5d34,
    0x5d3d,
    0x5d6c,
    0x5d5b,
    0x5d6f,
    0x5d5d,
    0x5d6b,
    0x5d4b,
    0x5d4a,
    0x5d69,
    0x5d74,
    0x5d82,
    0x5d99,
    0x5d9d,
    0x8c73,
    0x5db7,
    0x5dc5,
    0x5f73,
    0x5f77,
    0x5f82,
    0x5f87,
    0x5f89,
    0x5f8c,
    0x5f95,
    0x5f99,
    0x5f9c,
    0x5fa8,
    0x5fad,
    0x5fb5,
    0x5fbc,
    0x8862,
    0x5f61,
    0x72ad,
    0x72b0,
    0x72b4,
    0x72b7,
    0x72b8,
    0x72c3,
    0x72c1,
    0x72ce,
    0x72cd,
    0x72d2,
    0x72e8,
    0x72ef,
    0x72e9,
    0x72f2,
    0x72f4,
    0x72f7,
    0x7301,
    0x72f3,
    0x7303,
    0x72fa,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xe2[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x91e6,
    0x91e7,
    0x91e8,
    0x91e9,
    0x91ea,
    0x91eb,
    0x91ec,
    0x91ed,
    0x91ee,
    0x91ef,
    0x91f0,
    0x91f1,
    0x91f2,
    0x91f3,
    0x91f4,
    0x91f5,
    0x91f6,
    0x91f7,
    0x91f8,
    0x91f9,
    0x91fa,
    0x91fb,
    0x91fc,
    0x91fd,
    0x91fe,
    0x91ff,
    0x9200,
    0x9201,
    0x9202,
    0x9203,
    0x9204,
    0x9205,
    0x9206,
    0x9207,
    0x9208,
    0x9209,
    0x920a,
    0x920b,
    0x920c,
    0x920d,
    0x920e,
    0x920f,
    0x9210,
    0x9211,
    0x9212,
    0x9213,
    0x9214,
    0x9215,
    0x9216,
    0x9217,
    0x9218,
    0x9219,
    0x921a,
    0x921b,
    0x921c,
    0x921d,
    0x921e,
    0x921f,
    0x9220,
    0x9221,
    0x9222,
    0x9223,
    0x9224,
    CP936_CP_VAL_NULL,
    0x9225,
    0x9226,
    0x9227,
    0x9228,
    0x9229,
    0x922a,
    0x922b,
    0x922c,
    0x922d,
    0x922e,
    0x922f,
    0x9230,
    0x9231,
    0x9232,
    0x9233,
    0x9234,
    0x9235,
    0x9236,
    0x9237,
    0x9238,
    0x9239,
    0x923a,
    0x923b,
    0x923c,
    0x923d,
    0x923e,
    0x923f,
    0x9240,
    0x9241,
    0x9242,
    0x9243,
    0x9244,
    0x9245,
    0x72fb,
    0x7317,
    0x7313,
    0x7321,
    0x730a,
    0x731e,
    0x731d,
    0x7315,
    0x7322,
    0x7339,
    0x7325,
    0x732c,
    0x7338,
    0x7331,
    0x7350,
    0x734d,
    0x7357,
    0x7360,
    0x736c,
    0x736f,
    0x737e,
    0x821b,
    0x5925,
    0x98e7,
    0x5924,
    0x5902,
    0x9963,
    0x9967,
    0x9968,
    0x9969,
    0x996a,
    0x996b,
    0x996c,
    0x9974,
    0x9977,
    0x997d,
    0x9980,
    0x9984,
    0x9987,
    0x998a,
    0x998d,
    0x9990,
    0x9991,
    0x9993,
    0x9994,
    0x9995,
    0x5e80,
    0x5e91,
    0x5e8b,
    0x5e96,
    0x5ea5,
    0x5ea0,
    0x5eb9,
    0x5eb5,
    0x5ebe,
    0x5eb3,
    0x8d53,
    0x5ed2,
    0x5ed1,
    0x5edb,
    0x5ee8,
    0x5eea,
    0x81ba,
    0x5fc4,
    0x5fc9,
    0x5fd6,
    0x5fcf,
    0x6003,
    0x5fee,
    0x6004,
    0x5fe1,
    0x5fe4,
    0x5ffe,
    0x6005,
    0x6006,
    0x5fea,
    0x5fed,
    0x5ff8,
    0x6019,
    0x6035,
    0x6026,
    0x601b,
    0x600f,
    0x600d,
    0x6029,
    0x602b,
    0x600a,
    0x603f,
    0x6021,
    0x6078,
    0x6079,
    0x607b,
    0x607a,
    0x6042,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xe3[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x9246,
    0x9247,
    0x9248,
    0x9249,
    0x924a,
    0x924b,
    0x924c,
    0x924d,
    0x924e,
    0x924f,
    0x9250,
    0x9251,
    0x9252,
    0x9253,
    0x9254,
    0x9255,
    0x9256,
    0x9257,
    0x9258,
    0x9259,
    0x925a,
    0x925b,
    0x925c,
    0x925d,
    0x925e,
    0x925f,
    0x9260,
    0x9261,
    0x9262,
    0x9263,
    0x9264,
    0x9265,
    0x9266,
    0x9267,
    0x9268,
    0x9269,
    0x926a,
    0x926b,
    0x926c,
    0x926d,
    0x926e,
    0x926f,
    0x9270,
    0x9271,
    0x9272,
    0x9273,
    0x9275,
    0x9276,
    0x9277,
    0x9278,
    0x9279,
    0x927a,
    0x927b,
    0x927c,
    0x927d,
    0x927e,
    0x927f,
    0x9280,
    0x9281,
    0x9282,
    0x9283,
    0x9284,
    0x9285,
    CP936_CP_VAL_NULL,
    0x9286,
    0x9287,
    0x9288,
    0x9289,
    0x928a,
    0x928b,
    0x928c,
    0x928d,
    0x928f,
    0x9290,
    0x9291,
    0x9292,
    0x9293,
    0x9294,
    0x9295,
    0x9296,
    0x9297,
    0x9298,
    0x9299,
    0x929a,
    0x929b,
    0x929c,
    0x929d,
    0x929e,
    0x929f,
    0x92a0,
    0x92a1,
    0x92a2,
    0x92a3,
    0x92a4,
    0x92a5,
    0x92a6,
    0x92a7,
    0x606a,
    0x607d,
    0x6096,
    0x609a,
    0x60ad,
    0x609d,
    0x6083,
    0x6092,
    0x608c,
    0x609b,
    0x60ec,
    0x60bb,
    0x60b1,
    0x60dd,
    0x60d8,
    0x60c6,
    0x60da,
    0x60b4,
    0x6120,
    0x6126,
    0x6115,
    0x6123,
    0x60f4,
    0x6100,
    0x610e,
    0x612b,
    0x614a,
    0x6175,
    0x61ac,
    0x6194,
    0x61a7,
    0x61b7,
    0x61d4,
    0x61f5,
    0x5fdd,
    0x96b3,
    0x95e9,
    0x95eb,
    0x95f1,
    0x95f3,
    0x95f5,
    0x95f6,
    0x95fc,
    0x95fe,
    0x9603,
    0x9604,
    0x9606,
    0x9608,
    0x960a,
    0x960b,
    0x960c,
    0x960d,
    0x960f,
    0x9612,
    0x9615,
    0x9616,
    0x9617,
    0x9619,
    0x961a,
    0x4e2c,
    0x723f,
    0x6215,
    0x6c35,
    0x6c54,
    0x6c5c,
    0x6c4a,
    0x6ca3,
    0x6c85,
    0x6c90,
    0x6c94,
    0x6c8c,
    0x6c68,
    0x6c69,
    0x6c74,
    0x6c76,
    0x6c86,
    0x6ca9,
    0x6cd0,
    0x6cd4,
    0x6cad,
    0x6cf7,
    0x6cf8,
    0x6cf1,
    0x6cd7,
    0x6cb2,
    0x6ce0,
    0x6cd6,
    0x6cfa,
    0x6ceb,
    0x6cee,
    0x6cb1,
    0x6cd3,
    0x6cef,
    0x6cfe,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xe4[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x92a8,
    0x92a9,
    0x92aa,
    0x92ab,
    0x92ac,
    0x92ad,
    0x92af,
    0x92b0,
    0x92b1,
    0x92b2,
    0x92b3,
    0x92b4,
    0x92b5,
    0x92b6,
    0x92b7,
    0x92b8,
    0x92b9,
    0x92ba,
    0x92bb,
    0x92bc,
    0x92bd,
    0x92be,
    0x92bf,
    0x92c0,
    0x92c1,
    0x92c2,
    0x92c3,
    0x92c4,
    0x92c5,
    0x92c6,
    0x92c7,
    0x92c9,
    0x92ca,
    0x92cb,
    0x92cc,
    0x92cd,
    0x92ce,
    0x92cf,
    0x92d0,
    0x92d1,
    0x92d2,
    0x92d3,
    0x92d4,
    0x92d5,
    0x92d6,
    0x92d7,
    0x92d8,
    0x92d9,
    0x92da,
    0x92db,
    0x92dc,
    0x92dd,
    0x92de,
    0x92df,
    0x92e0,
    0x92e1,
    0x92e2,
    0x92e3,
    0x92e4,
    0x92e5,
    0x92e6,
    0x92e7,
    0x92e8,
    CP936_CP_VAL_NULL,
    0x92e9,
    0x92ea,
    0x92eb,
    0x92ec,
    0x92ed,
    0x92ee,
    0x92ef,
    0x92f0,
    0x92f1,
    0x92f2,
    0x92f3,
    0x92f4,
    0x92f5,
    0x92f6,
    0x92f7,
    0x92f8,
    0x92f9,
    0x92fa,
    0x92fb,
    0x92fc,
    0x92fd,
    0x92fe,
    0x92ff,
    0x9300,
    0x9301,
    0x9302,
    0x9303,
    0x9304,
    0x9305,
    0x9306,
    0x9307,
    0x9308,
    0x9309,
    0x6d39,
    0x6d27,
    0x6d0c,
    0x6d43,
    0x6d48,
    0x6d07,
    0x6d04,
    0x6d19,
    0x6d0e,
    0x6d2b,
    0x6d4d,
    0x6d2e,
    0x6d35,
    0x6d1a,
    0x6d4f,
    0x6d52,
    0x6d54,
    0x6d33,
    0x6d91,
    0x6d6f,
    0x6d9e,
    0x6da0,
    0x6d5e,
    0x6d93,
    0x6d94,
    0x6d5c,
    0x6d60,
    0x6d7c,
    0x6d63,
    0x6e1a,
    0x6dc7,
    0x6dc5,
    0x6dde,
    0x6e0e,
    0x6dbf,
    0x6de0,
    0x6e11,
    0x6de6,
    0x6ddd,
    0x6dd9,
    0x6e16,
    0x6dab,
    0x6e0c,
    0x6dae,
    0x6e2b,
    0x6e6e,
    0x6e4e,
    0x6e6b,
    0x6eb2,
    0x6e5f,
    0x6e86,
    0x6e53,
    0x6e54,
    0x6e32,
    0x6e25,
    0x6e44,
    0x6edf,
    0x6eb1,
    0x6e98,
    0x6ee0,
    0x6f2d,
    0x6ee2,
    0x6ea5,
    0x6ea7,
    0x6ebd,
    0x6ebb,
    0x6eb7,
    0x6ed7,
    0x6eb4,
    0x6ecf,
    0x6e8f,
    0x6ec2,
    0x6e9f,
    0x6f62,
    0x6f46,
    0x6f47,
    0x6f24,
    0x6f15,
    0x6ef9,
    0x6f2f,
    0x6f36,
    0x6f4b,
    0x6f74,
    0x6f2a,
    0x6f09,
    0x6f29,
    0x6f89,
    0x6f8d,
    0x6f8c,
    0x6f78,
    0x6f72,
    0x6f7c,
    0x6f7a,
    0x6fd1,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xe5[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x930a,
    0x930b,
    0x930c,
    0x930d,
    0x930e,
    0x930f,
    0x9310,
    0x9311,
    0x9312,
    0x9313,
    0x9314,
    0x9315,
    0x9316,
    0x9317,
    0x9318,
    0x9319,
    0x931a,
    0x931b,
    0x931c,
    0x931d,
    0x931e,
    0x931f,
    0x9320,
    0x9321,
    0x9322,
    0x9323,
    0x9324,
    0x9325,
    0x9326,
    0x9327,
    0x9328,
    0x9329,
    0x932a,
    0x932b,
    0x932c,
    0x932d,
    0x932e,
    0x932f,
    0x9330,
    0x9331,
    0x9332,
    0x9333,
    0x9334,
    0x9335,
    0x9336,
    0x9337,
    0x9338,
    0x9339,
    0x933a,
    0x933b,
    0x933c,
    0x933d,
    0x933f,
    0x9340,
    0x9341,
    0x9342,
    0x9343,
    0x9344,
    0x9345,
    0x9346,
    0x9347,
    0x9348,
    0x9349,
    CP936_CP_VAL_NULL,
    0x934a,
    0x934b,
    0x934c,
    0x934d,
    0x934e,
    0x934f,
    0x9350,
    0x9351,
    0x9352,
    0x9353,
    0x9354,
    0x9355,
    0x9356,
    0x9357,
    0x9358,
    0x9359,
    0x935a,
    0x935b,
    0x935c,
    0x935d,
    0x935e,
    0x935f,
    0x9360,
    0x9361,
    0x9362,
    0x9363,
    0x9364,
    0x9365,
    0x9366,
    0x9367,
    0x9368,
    0x9369,
    0x936b,
    0x6fc9,
    0x6fa7,
    0x6fb9,
    0x6fb6,
    0x6fc2,
    0x6fe1,
    0x6fee,
    0x6fde,
    0x6fe0,
    0x6fef,
    0x701a,
    0x7023,
    0x701b,
    0x7039,
    0x7035,
    0x704f,
    0x705e,
    0x5b80,
    0x5b84,
    0x5b95,
    0x5b93,
    0x5ba5,
    0x5bb8,
    0x752f,
    0x9a9e,
    0x6434,
    0x5be4,
    0x5bee,
    0x8930,
    0x5bf0,
    0x8e47,
    0x8b07,
    0x8fb6,
    0x8fd3,
    0x8fd5,
    0x8fe5,
    0x8fee,
    0x8fe4,
    0x8fe9,
    0x8fe6,
    0x8ff3,
    0x8fe8,
    0x9005,
    0x9004,
    0x900b,
    0x9026,
    0x9011,
    0x900d,
    0x9016,
    0x9021,
    0x9035,
    0x9036,
    0x902d,
    0x902f,
    0x9044,
    0x9051,
    0x9052,
    0x9050,
    0x9068,
    0x9058,
    0x9062,
    0x905b,
    0x66b9,
    0x9074,
    0x907d,
    0x9082,
    0x9088,
    0x9083,
    0x908b,
    0x5f50,
    0x5f57,
    0x5f56,
    0x5f58,
    0x5c3b,
    0x54ab,
    0x5c50,
    0x5c59,
    0x5b71,
    0x5c63,
    0x5c66,
    0x7fbc,
    0x5f2a,
    0x5f29,
    0x5f2d,
    0x8274,
    0x5f3c,
    0x9b3b,
    0x5c6e,
    0x5981,
    0x5983,
    0x598d,
    0x59a9,
    0x59aa,
    0x59a3,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xe6[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x936c,
    0x936d,
    0x936e,
    0x936f,
    0x9370,
    0x9371,
    0x9372,
    0x9373,
    0x9374,
    0x9375,
    0x9376,
    0x9377,
    0x9378,
    0x9379,
    0x937a,
    0x937b,
    0x937c,
    0x937d,
    0x937e,
    0x937f,
    0x9380,
    0x9381,
    0x9382,
    0x9383,
    0x9384,
    0x9385,
    0x9386,
    0x9387,
    0x9388,
    0x9389,
    0x938a,
    0x938b,
    0x938c,
    0x938d,
    0x938e,
    0x9390,
    0x9391,
    0x9392,
    0x9393,
    0x9394,
    0x9395,
    0x9396,
    0x9397,
    0x9398,
    0x9399,
    0x939a,
    0x939b,
    0x939c,
    0x939d,
    0x939e,
    0x939f,
    0x93a0,
    0x93a1,
    0x93a2,
    0x93a3,
    0x93a4,
    0x93a5,
    0x93a6,
    0x93a7,
    0x93a8,
    0x93a9,
    0x93aa,
    0x93ab,
    CP936_CP_VAL_NULL,
    0x93ac,
    0x93ad,
    0x93ae,
    0x93af,
    0x93b0,
    0x93b1,
    0x93b2,
    0x93b3,
    0x93b4,
    0x93b5,
    0x93b6,
    0x93b7,
    0x93b8,
    0x93b9,
    0x93ba,
    0x93bb,
    0x93bc,
    0x93bd,
    0x93be,
    0x93bf,
    0x93c0,
    0x93c1,
    0x93c2,
    0x93c3,
    0x93c4,
    0x93c5,
    0x93c6,
    0x93c7,
    0x93c8,
    0x93c9,
    0x93cb,
    0x93cc,
    0x93cd,
    0x5997,
    0x59ca,
    0x59ab,
    0x599e,
    0x59a4,
    0x59d2,
    0x59b2,
    0x59af,
    0x59d7,
    0x59be,
    0x5a05,
    0x5a06,
    0x59dd,
    0x5a08,
    0x59e3,
    0x59d8,
    0x59f9,
    0x5a0c,
    0x5a09,
    0x5a32,
    0x5a34,
    0x5a11,
    0x5a23,
    0x5a13,
    0x5a40,
    0x5a67,
    0x5a4a,
    0x5a55,
    0x5a3c,
    0x5a62,
    0x5a75,
    0x80ec,
    0x5aaa,
    0x5a9b,
    0x5a77,
    0x5a7a,
    0x5abe,
    0x5aeb,
    0x5ab2,
    0x5ad2,
    0x5ad4,
    0x5ab8,
    0x5ae0,
    0x5ae3,
    0x5af1,
    0x5ad6,
    0x5ae6,
    0x5ad8,
    0x5adc,
    0x5b09,
    0x5b17,
    0x5b16,
    0x5b32,
    0x5b37,
    0x5b40,
    0x5c15,
    0x5c1c,
    0x5b5a,
    0x5b65,
    0x5b73,
    0x5b51,
    0x5b53,
    0x5b62,
    0x9a75,
    0x9a77,
    0x9a78,
    0x9a7a,
    0x9a7f,
    0x9a7d,
    0x9a80,
    0x9a81,
    0x9a85,
    0x9a88,
    0x9a8a,
    0x9a90,
    0x9a92,
    0x9a93,
    0x9a96,
    0x9a98,
    0x9a9b,
    0x9a9c,
    0x9a9d,
    0x9a9f,
    0x9aa0,
    0x9aa2,
    0x9aa3,
    0x9aa5,
    0x9aa7,
    0x7e9f,
    0x7ea1,
    0x7ea3,
    0x7ea5,
    0x7ea8,
    0x7ea9,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xe7[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x93ce,
    0x93cf,
    0x93d0,
    0x93d1,
    0x93d2,
    0x93d3,
    0x93d4,
    0x93d5,
    0x93d7,
    0x93d8,
    0x93d9,
    0x93da,
    0x93db,
    0x93dc,
    0x93dd,
    0x93de,
    0x93df,
    0x93e0,
    0x93e1,
    0x93e2,
    0x93e3,
    0x93e4,
    0x93e5,
    0x93e6,
    0x93e7,
    0x93e8,
    0x93e9,
    0x93ea,
    0x93eb,
    0x93ec,
    0x93ed,
    0x93ee,
    0x93ef,
    0x93f0,
    0x93f1,
    0x93f2,
    0x93f3,
    0x93f4,
    0x93f5,
    0x93f6,
    0x93f7,
    0x93f8,
    0x93f9,
    0x93fa,
    0x93fb,
    0x93fc,
    0x93fd,
    0x93fe,
    0x93ff,
    0x9400,
    0x9401,
    0x9402,
    0x9403,
    0x9404,
    0x9405,
    0x9406,
    0x9407,
    0x9408,
    0x9409,
    0x940a,
    0x940b,
    0x940c,
    0x940d,
    CP936_CP_VAL_NULL,
    0x940e,
    0x940f,
    0x9410,
    0x9411,
    0x9412,
    0x9413,
    0x9414,
    0x9415,
    0x9416,
    0x9417,
    0x9418,
    0x9419,
    0x941a,
    0x941b,
    0x941c,
    0x941d,
    0x941e,
    0x941f,
    0x9420,
    0x9421,
    0x9422,
    0x9423,
    0x9424,
    0x9425,
    0x9426,
    0x9427,
    0x9428,
    0x9429,
    0x942a,
    0x942b,
    0x942c,
    0x942d,
    0x942e,
    0x7ead,
    0x7eb0,
    0x7ebe,
    0x7ec0,
    0x7ec1,
    0x7ec2,
    0x7ec9,
    0x7ecb,
    0x7ecc,
    0x7ed0,
    0x7ed4,
    0x7ed7,
    0x7edb,
    0x7ee0,
    0x7ee1,
    0x7ee8,
    0x7eeb,
    0x7eee,
    0x7eef,
    0x7ef1,
    0x7ef2,
    0x7f0d,
    0x7ef6,
    0x7efa,
    0x7efb,
    0x7efe,
    0x7f01,
    0x7f02,
    0x7f03,
    0x7f07,
    0x7f08,
    0x7f0b,
    0x7f0c,
    0x7f0f,
    0x7f11,
    0x7f12,
    0x7f17,
    0x7f19,
    0x7f1c,
    0x7f1b,
    0x7f1f,
    0x7f21,
    0x7f22,
    0x7f23,
    0x7f24,
    0x7f25,
    0x7f26,
    0x7f27,
    0x7f2a,
    0x7f2b,
    0x7f2c,
    0x7f2d,
    0x7f2f,
    0x7f30,
    0x7f31,
    0x7f32,
    0x7f33,
    0x7f35,
    0x5e7a,
    0x757f,
    0x5ddb,
    0x753e,
    0x9095,
    0x738e,
    0x7391,
    0x73ae,
    0x73a2,
    0x739f,
    0x73cf,
    0x73c2,
    0x73d1,
    0x73b7,
    0x73b3,
    0x73c0,
    0x73c9,
    0x73c8,
    0x73e5,
    0x73d9,
    0x987c,
    0x740a,
    0x73e9,
    0x73e7,
    0x73de,
    0x73ba,
    0x73f2,
    0x740f,
    0x742a,
    0x745b,
    0x7426,
    0x7425,
    0x7428,
    0x7430,
    0x742e,
    0x742c,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xe8[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x942f,
    0x9430,
    0x9431,
    0x9432,
    0x9433,
    0x9434,
    0x9435,
    0x9436,
    0x9437,
    0x9438,
    0x9439,
    0x943a,
    0x943b,
    0x943c,
    0x943d,
    0x943f,
    0x9440,
    0x9441,
    0x9442,
    0x9443,
    0x9444,
    0x9445,
    0x9446,
    0x9447,
    0x9448,
    0x9449,
    0x944a,
    0x944b,
    0x944c,
    0x944d,
    0x944e,
    0x944f,
    0x9450,
    0x9451,
    0x9452,
    0x9453,
    0x9454,
    0x9455,
    0x9456,
    0x9457,
    0x9458,
    0x9459,
    0x945a,
    0x945b,
    0x945c,
    0x945d,
    0x945e,
    0x945f,
    0x9460,
    0x9461,
    0x9462,
    0x9463,
    0x9464,
    0x9465,
    0x9466,
    0x9467,
    0x9468,
    0x9469,
    0x946a,
    0x946c,
    0x946d,
    0x946e,
    0x946f,
    CP936_CP_VAL_NULL,
    0x9470,
    0x9471,
    0x9472,
    0x9473,
    0x9474,
    0x9475,
    0x9476,
    0x9477,
    0x9478,
    0x9479,
    0x947a,
    0x947b,
    0x947c,
    0x947d,
    0x947e,
    0x947f,
    0x9480,
    0x9481,
    0x9482,
    0x9483,
    0x9484,
    0x9491,
    0x9496,
    0x9498,
    0x94c7,
    0x94cf,
    0x94d3,
    0x94d4,
    0x94da,
    0x94e6,
    0x94fb,
    0x951c,
    0x9520,
    0x741b,
    0x741a,
    0x7441,
    0x745c,
    0x7457,
    0x7455,
    0x7459,
    0x7477,
    0x746d,
    0x747e,
    0x749c,
    0x748e,
    0x7480,
    0x7481,
    0x7487,
    0x748b,
    0x749e,
    0x74a8,
    0x74a9,
    0x7490,
    0x74a7,
    0x74d2,
    0x74ba,
    0x97ea,
    0x97eb,
    0x97ec,
    0x674c,
    0x6753,
    0x675e,
    0x6748,
    0x6769,
    0x67a5,
    0x6787,
    0x676a,
    0x6773,
    0x6798,
    0x67a7,
    0x6775,
    0x67a8,
    0x679e,
    0x67ad,
    0x678b,
    0x6777,
    0x677c,
    0x67f0,
    0x6809,
    0x67d8,
    0x680a,
    0x67e9,
    0x67b0,
    0x680c,
    0x67d9,
    0x67b5,
    0x67da,
    0x67b3,
    0x67dd,
    0x6800,
    0x67c3,
    0x67b8,
    0x67e2,
    0x680e,
    0x67c1,
    0x67fd,
    0x6832,
    0x6833,
    0x6860,
    0x6861,
    0x684e,
    0x6862,
    0x6844,
    0x6864,
    0x6883,
    0x681d,
    0x6855,
    0x6866,
    0x6841,
    0x6867,
    0x6840,
    0x683e,
    0x684a,
    0x6849,
    0x6829,
    0x68b5,
    0x688f,
    0x6874,
    0x6877,
    0x6893,
    0x686b,
    0x68c2,
    0x696e,
    0x68fc,
    0x691f,
    0x6920,
    0x68f9,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xe9[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x9527,
    0x9533,
    0x953d,
    0x9543,
    0x9548,
    0x954b,
    0x9555,
    0x955a,
    0x9560,
    0x956e,
    0x9574,
    0x9575,
    0x9577,
    0x9578,
    0x9579,
    0x957a,
    0x957b,
    0x957c,
    0x957d,
    0x957e,
    0x9580,
    0x9581,
    0x9582,
    0x9583,
    0x9584,
    0x9585,
    0x9586,
    0x9587,
    0x9588,
    0x9589,
    0x958a,
    0x958b,
    0x958c,
    0x958d,
    0x958e,
    0x958f,
    0x9590,
    0x9591,
    0x9592,
    0x9593,
    0x9594,
    0x9595,
    0x9596,
    0x9597,
    0x9598,
    0x9599,
    0x959a,
    0x959b,
    0x959c,
    0x959d,
    0x959e,
    0x959f,
    0x95a0,
    0x95a1,
    0x95a2,
    0x95a3,
    0x95a4,
    0x95a5,
    0x95a6,
    0x95a7,
    0x95a8,
    0x95a9,
    0x95aa,
    CP936_CP_VAL_NULL,
    0x95ab,
    0x95ac,
    0x95ad,
    0x95ae,
    0x95af,
    0x95b0,
    0x95b1,
    0x95b2,
    0x95b3,
    0x95b4,
    0x95b5,
    0x95b6,
    0x95b7,
    0x95b8,
    0x95b9,
    0x95ba,
    0x95bb,
    0x95bc,
    0x95bd,
    0x95be,
    0x95bf,
    0x95c0,
    0x95c1,
    0x95c2,
    0x95c3,
    0x95c4,
    0x95c5,
    0x95c6,
    0x95c7,
    0x95c8,
    0x95c9,
    0x95ca,
    0x95cb,
    0x6924,
    0x68f0,
    0x690b,
    0x6901,
    0x6957,
    0x68e3,
    0x6910,
    0x6971,
    0x6939,
    0x6960,
    0x6942,
    0x695d,
    0x6984,
    0x696b,
    0x6980,
    0x6998,
    0x6978,
    0x6934,
    0x69cc,
    0x6987,
    0x6988,
    0x69ce,
    0x6989,
    0x6966,
    0x6963,
    0x6979,
    0x699b,
    0x69a7,
    0x69bb,
    0x69ab,
    0x69ad,
    0x69d4,
    0x69b1,
    0x69c1,
    0x69ca,
    0x69df,
    0x6995,
    0x69e0,
    0x698d,
    0x69ff,
    0x6a2f,
    0x69ed,
    0x6a17,
    0x6a18,
    0x6a65,
    0x69f2,
    0x6a44,
    0x6a3e,
    0x6aa0,
    0x6a50,
    0x6a5b,
    0x6a35,
    0x6a8e,
    0x6a79,
    0x6a3d,
    0x6a28,
    0x6a58,
    0x6a7c,
    0x6a91,
    0x6a90,
    0x6aa9,
    0x6a97,
    0x6aab,
    0x7337,
    0x7352,
    0x6b81,
    0x6b82,
    0x6b87,
    0x6b84,
    0x6b92,
    0x6b93,
    0x6b8d,
    0x6b9a,
    0x6b9b,
    0x6ba1,
    0x6baa,
    0x8f6b,
    0x8f6d,
    0x8f71,
    0x8f72,
    0x8f73,
    0x8f75,
    0x8f76,
    0x8f78,
    0x8f77,
    0x8f79,
    0x8f7a,
    0x8f7c,
    0x8f7e,
    0x8f81,
    0x8f82,
    0x8f84,
    0x8f87,
    0x8f8b,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xea[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x95cc,
    0x95cd,
    0x95ce,
    0x95cf,
    0x95d0,
    0x95d1,
    0x95d2,
    0x95d3,
    0x95d4,
    0x95d5,
    0x95d6,
    0x95d7,
    0x95d8,
    0x95d9,
    0x95da,
    0x95db,
    0x95dc,
    0x95dd,
    0x95de,
    0x95df,
    0x95e0,
    0x95e1,
    0x95e2,
    0x95e3,
    0x95e4,
    0x95e5,
    0x95e6,
    0x95e7,
    0x95ec,
    0x95ff,
    0x9607,
    0x9613,
    0x9618,
    0x961b,
    0x961e,
    0x9620,
    0x9623,
    0x9624,
    0x9625,
    0x9626,
    0x9627,
    0x9628,
    0x9629,
    0x962b,
    0x962c,
    0x962d,
    0x962f,
    0x9630,
    0x9637,
    0x9638,
    0x9639,
    0x963a,
    0x963e,
    0x9641,
    0x9643,
    0x964a,
    0x964e,
    0x964f,
    0x9651,
    0x9652,
    0x9653,
    0x9656,
    0x9657,
    CP936_CP_VAL_NULL,
    0x9658,
    0x9659,
    0x965a,
    0x965c,
    0x965d,
    0x965e,
    0x9660,
    0x9663,
    0x9665,
    0x9666,
    0x966b,
    0x966d,
    0x966e,
    0x966f,
    0x9670,
    0x9671,
    0x9673,
    0x9678,
    0x9679,
    0x967a,
    0x967b,
    0x967c,
    0x967d,
    0x967e,
    0x967f,
    0x9680,
    0x9681,
    0x9682,
    0x9683,
    0x9684,
    0x9687,
    0x9689,
    0x968a,
    0x8f8d,
    0x8f8e,
    0x8f8f,
    0x8f98,
    0x8f9a,
    0x8ece,
    0x620b,
    0x6217,
    0x621b,
    0x621f,
    0x6222,
    0x6221,
    0x6225,
    0x6224,
    0x622c,
    0x81e7,
    0x74ef,
    0x74f4,
    0x74ff,
    0x750f,
    0x7511,
    0x7513,
    0x6534,
    0x65ee,
    0x65ef,
    0x65f0,
    0x660a,
    0x6619,
    0x6772,
    0x6603,
    0x6615,
    0x6600,
    0x7085,
    0x66f7,
    0x661d,
    0x6634,
    0x6631,
    0x6636,
    0x6635,
    0x8006,
    0x665f,
    0x6654,
    0x6641,
    0x664f,
    0x6656,
    0x6661,
    0x6657,
    0x6677,
    0x6684,
    0x668c,
    0x66a7,
    0x669d,
    0x66be,
    0x66db,
    0x66dc,
    0x66e6,
    0x66e9,
    0x8d32,
    0x8d33,
    0x8d36,
    0x8d3b,
    0x8d3d,
    0x8d40,
    0x8d45,
    0x8d46,
    0x8d48,
    0x8d49,
    0x8d47,
    0x8d4d,
    0x8d55,
    0x8d59,
    0x89c7,
    0x89ca,
    0x89cb,
    0x89cc,
    0x89ce,
    0x89cf,
    0x89d0,
    0x89d1,
    0x726e,
    0x729f,
    0x725d,
    0x7266,
    0x726f,
    0x727e,
    0x727f,
    0x7284,
    0x728b,
    0x728d,
    0x728f,
    0x7292,
    0x6308,
    0x6332,
    0x63b0,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xeb[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x968c,
    0x968e,
    0x9691,
    0x9692,
    0x9693,
    0x9695,
    0x9696,
    0x969a,
    0x969b,
    0x969d,
    0x969e,
    0x969f,
    0x96a0,
    0x96a1,
    0x96a2,
    0x96a3,
    0x96a4,
    0x96a5,
    0x96a6,
    0x96a8,
    0x96a9,
    0x96aa,
    0x96ab,
    0x96ac,
    0x96ad,
    0x96ae,
    0x96af,
    0x96b1,
    0x96b2,
    0x96b4,
    0x96b5,
    0x96b7,
    0x96b8,
    0x96ba,
    0x96bb,
    0x96bf,
    0x96c2,
    0x96c3,
    0x96c8,
    0x96ca,
    0x96cb,
    0x96d0,
    0x96d1,
    0x96d3,
    0x96d4,
    0x96d6,
    0x96d7,
    0x96d8,
    0x96d9,
    0x96da,
    0x96db,
    0x96dc,
    0x96dd,
    0x96de,
    0x96df,
    0x96e1,
    0x96e2,
    0x96e3,
    0x96e4,
    0x96e5,
    0x96e6,
    0x96e7,
    0x96eb,
    CP936_CP_VAL_NULL,
    0x96ec,
    0x96ed,
    0x96ee,
    0x96f0,
    0x96f1,
    0x96f2,
    0x96f4,
    0x96f5,
    0x96f8,
    0x96fa,
    0x96fb,
    0x96fc,
    0x96fd,
    0x96ff,
    0x9702,
    0x9703,
    0x9705,
    0x970a,
    0x970b,
    0x970c,
    0x9710,
    0x9711,
    0x9712,
    0x9714,
    0x9715,
    0x9717,
    0x9718,
    0x9719,
    0x971a,
    0x971b,
    0x971d,
    0x971f,
    0x9720,
    0x643f,
    0x64d8,
    0x8004,
    0x6bea,
    0x6bf3,
    0x6bfd,
    0x6bf5,
    0x6bf9,
    0x6c05,
    0x6c07,
    0x6c06,
    0x6c0d,
    0x6c15,
    0x6c18,
    0x6c19,
    0x6c1a,
    0x6c21,
    0x6c29,
    0x6c24,
    0x6c2a,
    0x6c32,
    0x6535,
    0x6555,
    0x656b,
    0x724d,
    0x7252,
    0x7256,
    0x7230,
    0x8662,
    0x5216,
    0x809f,
    0x809c,
    0x8093,
    0x80bc,
    0x670a,
    0x80bd,
    0x80b1,
    0x80ab,
    0x80ad,
    0x80b4,
    0x80b7,
    0x80e7,
    0x80e8,
    0x80e9,
    0x80ea,
    0x80db,
    0x80c2,
    0x80c4,
    0x80d9,
    0x80cd,
    0x80d7,
    0x6710,
    0x80dd,
    0x80eb,
    0x80f1,
    0x80f4,
    0x80ed,
    0x810d,
    0x810e,
    0x80f2,
    0x80fc,
    0x6715,
    0x8112,
    0x8c5a,
    0x8136,
    0x811e,
    0x812c,
    0x8118,
    0x8132,
    0x8148,
    0x814c,
    0x8153,
    0x8174,
    0x8159,
    0x815a,
    0x8171,
    0x8160,
    0x8169,
    0x817c,
    0x817d,
    0x816d,
    0x8167,
    0x584d,
    0x5ab5,
    0x8188,
    0x8182,
    0x8191,
    0x6ed5,
    0x81a3,
    0x81aa,
    0x81cc,
    0x6726,
    0x81ca,
    0x81bb,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xec[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x9721,
    0x9722,
    0x9723,
    0x9724,
    0x9725,
    0x9726,
    0x9727,
    0x9728,
    0x9729,
    0x972b,
    0x972c,
    0x972e,
    0x972f,
    0x9731,
    0x9733,
    0x9734,
    0x9735,
    0x9736,
    0x9737,
    0x973a,
    0x973b,
    0x973c,
    0x973d,
    0x973f,
    0x9740,
    0x9741,
    0x9742,
    0x9743,
    0x9744,
    0x9745,
    0x9746,
    0x9747,
    0x9748,
    0x9749,
    0x974a,
    0x974b,
    0x974c,
    0x974d,
    0x974e,
    0x974f,
    0x9750,
    0x9751,
    0x9754,
    0x9755,
    0x9757,
    0x9758,
    0x975a,
    0x975c,
    0x975d,
    0x975f,
    0x9763,
    0x9764,
    0x9766,
    0x9767,
    0x9768,
    0x976a,
    0x976b,
    0x976c,
    0x976d,
    0x976e,
    0x976f,
    0x9770,
    0x9771,
    CP936_CP_VAL_NULL,
    0x9772,
    0x9775,
    0x9777,
    0x9778,
    0x9779,
    0x977a,
    0x977b,
    0x977d,
    0x977e,
    0x977f,
    0x9780,
    0x9781,
    0x9782,
    0x9783,
    0x9784,
    0x9786,
    0x9787,
    0x9788,
    0x9789,
    0x978a,
    0x978c,
    0x978e,
    0x978f,
    0x9790,
    0x9793,
    0x9795,
    0x9796,
    0x9797,
    0x9799,
    0x979a,
    0x979b,
    0x979c,
    0x979d,
    0x81c1,
    0x81a6,
    0x6b24,
    0x6b37,
    0x6b39,
    0x6b43,
    0x6b46,
    0x6b59,
    0x98d1,
    0x98d2,
    0x98d3,
    0x98d5,
    0x98d9,
    0x98da,
    0x6bb3,
    0x5f40,
    0x6bc2,
    0x89f3,
    0x6590,
    0x9f51,
    0x6593,
    0x65bc,
    0x65c6,
    0x65c4,
    0x65c3,
    0x65cc,
    0x65ce,
    0x65d2,
    0x65d6,
    0x7080,
    0x709c,
    0x7096,
    0x709d,
    0x70bb,
    0x70c0,
    0x70b7,
    0x70ab,
    0x70b1,
    0x70e8,
    0x70ca,
    0x7110,
    0x7113,
    0x7116,
    0x712f,
    0x7131,
    0x7173,
    0x715c,
    0x7168,
    0x7145,
    0x7172,
    0x714a,
    0x7178,
    0x717a,
    0x7198,
    0x71b3,
    0x71b5,
    0x71a8,
    0x71a0,
    0x71e0,
    0x71d4,
    0x71e7,
    0x71f9,
    0x721d,
    0x7228,
    0x706c,
    0x7118,
    0x7166,
    0x71b9,
    0x623e,
    0x623d,
    0x6243,
    0x6248,
    0x6249,
    0x793b,
    0x7940,
    0x7946,
    0x7949,
    0x795b,
    0x795c,
    0x7953,
    0x795a,
    0x7962,
    0x7957,
    0x7960,
    0x796f,
    0x7967,
    0x797a,
    0x7985,
    0x798a,
    0x799a,
    0x79a7,
    0x79b3,
    0x5fd1,
    0x5fd0,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xed[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x979e,
    0x979f,
    0x97a1,
    0x97a2,
    0x97a4,
    0x97a5,
    0x97a6,
    0x97a7,
    0x97a8,
    0x97a9,
    0x97aa,
    0x97ac,
    0x97ae,
    0x97b0,
    0x97b1,
    0x97b3,
    0x97b5,
    0x97b6,
    0x97b7,
    0x97b8,
    0x97b9,
    0x97ba,
    0x97bb,
    0x97bc,
    0x97bd,
    0x97be,
    0x97bf,
    0x97c0,
    0x97c1,
    0x97c2,
    0x97c3,
    0x97c4,
    0x97c5,
    0x97c6,
    0x97c7,
    0x97c8,
    0x97c9,
    0x97ca,
    0x97cb,
    0x97cc,
    0x97cd,
    0x97ce,
    0x97cf,
    0x97d0,
    0x97d1,
    0x97d2,
    0x97d3,
    0x97d4,
    0x97d5,
    0x97d6,
    0x97d7,
    0x97d8,
    0x97d9,
    0x97da,
    0x97db,
    0x97dc,
    0x97dd,
    0x97de,
    0x97df,
    0x97e0,
    0x97e1,
    0x97e2,
    0x97e3,
    CP936_CP_VAL_NULL,
    0x97e4,
    0x97e5,
    0x97e8,
    0x97ee,
    0x97ef,
    0x97f0,
    0x97f1,
    0x97f2,
    0x97f4,
    0x97f7,
    0x97f8,
    0x97f9,
    0x97fa,
    0x97fb,
    0x97fc,
    0x97fd,
    0x97fe,
    0x97ff,
    0x9800,
    0x9801,
    0x9802,
    0x9803,
    0x9804,
    0x9805,
    0x9806,
    0x9807,
    0x9808,
    0x9809,
    0x980a,
    0x980b,
    0x980c,
    0x980d,
    0x980e,
    0x603c,
    0x605d,
    0x605a,
    0x6067,
    0x6041,
    0x6059,
    0x6063,
    0x60ab,
    0x6106,
    0x610d,
    0x615d,
    0x61a9,
    0x619d,
    0x61cb,
    0x61d1,
    0x6206,
    0x8080,
    0x807f,
    0x6c93,
    0x6cf6,
    0x6dfc,
    0x77f6,
    0x77f8,
    0x7800,
    0x7809,
    0x7817,
    0x7818,
    0x7811,
    0x65ab,
    0x782d,
    0x781c,
    0x781d,
    0x7839,
    0x783a,
    0x783b,
    0x781f,
    0x783c,
    0x7825,
    0x782c,
    0x7823,
    0x7829,
    0x784e,
    0x786d,
    0x7856,
    0x7857,
    0x7826,
    0x7850,
    0x7847,
    0x784c,
    0x786a,
    0x789b,
    0x7893,
    0x789a,
    0x7887,
    0x789c,
    0x78a1,
    0x78a3,
    0x78b2,
    0x78b9,
    0x78a5,
    0x78d4,
    0x78d9,
    0x78c9,
    0x78ec,
    0x78f2,
    0x7905,
    0x78f4,
    0x7913,
    0x7924,
    0x791e,
    0x7934,
    0x9f9b,
    0x9ef9,
    0x9efb,
    0x9efc,
    0x76f1,
    0x7704,
    0x770d,
    0x76f9,
    0x7707,
    0x7708,
    0x771a,
    0x7722,
    0x7719,
    0x772d,
    0x7726,
    0x7735,
    0x7738,
    0x7750,
    0x7751,
    0x7747,
    0x7743,
    0x775a,
    0x7768,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xee[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x980f,
    0x9810,
    0x9811,
    0x9812,
    0x9813,
    0x9814,
    0x9815,
    0x9816,
    0x9817,
    0x9818,
    0x9819,
    0x981a,
    0x981b,
    0x981c,
    0x981d,
    0x981e,
    0x981f,
    0x9820,
    0x9821,
    0x9822,
    0x9823,
    0x9824,
    0x9825,
    0x9826,
    0x9827,
    0x9828,
    0x9829,
    0x982a,
    0x982b,
    0x982c,
    0x982d,
    0x982e,
    0x982f,
    0x9830,
    0x9831,
    0x9832,
    0x9833,
    0x9834,
    0x9835,
    0x9836,
    0x9837,
    0x9838,
    0x9839,
    0x983a,
    0x983b,
    0x983c,
    0x983d,
    0x983e,
    0x983f,
    0x9840,
    0x9841,
    0x9842,
    0x9843,
    0x9844,
    0x9845,
    0x9846,
    0x9847,
    0x9848,
    0x9849,
    0x984a,
    0x984b,
    0x984c,
    0x984d,
    CP936_CP_VAL_NULL,
    0x984e,
    0x984f,
    0x9850,
    0x9851,
    0x9852,
    0x9853,
    0x9854,
    0x9855,
    0x9856,
    0x9857,
    0x9858,
    0x9859,
    0x985a,
    0x985b,
    0x985c,
    0x985d,
    0x985e,
    0x985f,
    0x9860,
    0x9861,
    0x9862,
    0x9863,
    0x9864,
    0x9865,
    0x9866,
    0x9867,
    0x9868,
    0x9869,
    0x986a,
    0x986b,
    0x986c,
    0x986d,
    0x986e,
    0x7762,
    0x7765,
    0x777f,
    0x778d,
    0x777d,
    0x7780,
    0x778c,
    0x7791,
    0x779f,
    0x77a0,
    0x77b0,
    0x77b5,
    0x77bd,
    0x753a,
    0x7540,
    0x754e,
    0x754b,
    0x7548,
    0x755b,
    0x7572,
    0x7579,
    0x7583,
    0x7f58,
    0x7f61,
    0x7f5f,
    0x8a48,
    0x7f68,
    0x7f74,
    0x7f71,
    0x7f79,
    0x7f81,
    0x7f7e,
    0x76cd,
    0x76e5,
    0x8832,
    0x9485,
    0x9486,
    0x9487,
    0x948b,
    0x948a,
    0x948c,
    0x948d,
    0x948f,
    0x9490,
    0x9494,
    0x9497,
    0x9495,
    0x949a,
    0x949b,
    0x949c,
    0x94a3,
    0x94a4,
    0x94ab,
    0x94aa,
    0x94ad,
    0x94ac,
    0x94af,
    0x94b0,
    0x94b2,
    0x94b4,
    0x94b6,
    0x94b7,
    0x94b8,
    0x94b9,
    0x94ba,
    0x94bc,
    0x94bd,
    0x94bf,
    0x94c4,
    0x94c8,
    0x94c9,
    0x94ca,
    0x94cb,
    0x94cc,
    0x94cd,
    0x94ce,
    0x94d0,
    0x94d1,
    0x94d2,
    0x94d5,
    0x94d6,
    0x94d7,
    0x94d9,
    0x94d8,
    0x94db,
    0x94de,
    0x94df,
    0x94e0,
    0x94e2,
    0x94e4,
    0x94e5,
    0x94e7,
    0x94e8,
    0x94ea,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xef[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x986f,
    0x9870,
    0x9871,
    0x9872,
    0x9873,
    0x9874,
    0x988b,
    0x988e,
    0x9892,
    0x9895,
    0x9899,
    0x98a3,
    0x98a8,
    0x98a9,
    0x98aa,
    0x98ab,
    0x98ac,
    0x98ad,
    0x98ae,
    0x98af,
    0x98b0,
    0x98b1,
    0x98b2,
    0x98b3,
    0x98b4,
    0x98b5,
    0x98b6,
    0x98b7,
    0x98b8,
    0x98b9,
    0x98ba,
    0x98bb,
    0x98bc,
    0x98bd,
    0x98be,
    0x98bf,
    0x98c0,
    0x98c1,
    0x98c2,
    0x98c3,
    0x98c4,
    0x98c5,
    0x98c6,
    0x98c7,
    0x98c8,
    0x98c9,
    0x98ca,
    0x98cb,
    0x98cc,
    0x98cd,
    0x98cf,
    0x98d0,
    0x98d4,
    0x98d6,
    0x98d7,
    0x98db,
    0x98dc,
    0x98dd,
    0x98e0,
    0x98e1,
    0x98e2,
    0x98e3,
    0x98e4,
    CP936_CP_VAL_NULL,
    0x98e5,
    0x98e6,
    0x98e9,
    0x98ea,
    0x98eb,
    0x98ec,
    0x98ed,
    0x98ee,
    0x98ef,
    0x98f0,
    0x98f1,
    0x98f2,
    0x98f3,
    0x98f4,
    0x98f5,
    0x98f6,
    0x98f7,
    0x98f8,
    0x98f9,
    0x98fa,
    0x98fb,
    0x98fc,
    0x98fd,
    0x98fe,
    0x98ff,
    0x9900,
    0x9901,
    0x9902,
    0x9903,
    0x9904,
    0x9905,
    0x9906,
    0x9907,
    0x94e9,
    0x94eb,
    0x94ee,
    0x94ef,
    0x94f3,
    0x94f4,
    0x94f5,
    0x94f7,
    0x94f9,
    0x94fc,
    0x94fd,
    0x94ff,
    0x9503,
    0x9502,
    0x9506,
    0x9507,
    0x9509,
    0x950a,
    0x950d,
    0x950e,
    0x950f,
    0x9512,
    0x9513,
    0x9514,
    0x9515,
    0x9516,
    0x9518,
    0x951b,
    0x951d,
    0x951e,
    0x951f,
    0x9522,
    0x952a,
    0x952b,
    0x9529,
    0x952c,
    0x9531,
    0x9532,
    0x9534,
    0x9536,
    0x9537,
    0x9538,
    0x953c,
    0x953e,
    0x953f,
    0x9542,
    0x9535,
    0x9544,
    0x9545,
    0x9546,
    0x9549,
    0x954c,
    0x954e,
    0x954f,
    0x9552,
    0x9553,
    0x9554,
    0x9556,
    0x9557,
    0x9558,
    0x9559,
    0x955b,
    0x955e,
    0x955f,
    0x955d,
    0x9561,
    0x9562,
    0x9564,
    0x9565,
    0x9566,
    0x9567,
    0x9568,
    0x9569,
    0x956a,
    0x956b,
    0x956c,
    0x956f,
    0x9571,
    0x9572,
    0x9573,
    0x953a,
    0x77e7,
    0x77ec,
    0x96c9,
    0x79d5,
    0x79ed,
    0x79e3,
    0x79eb,
    0x7a06,
    0x5d47,
    0x7a03,
    0x7a02,
    0x7a1e,
    0x7a14,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xf0[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x9908,
    0x9909,
    0x990a,
    0x990b,
    0x990c,
    0x990e,
    0x990f,
    0x9911,
    0x9912,
    0x9913,
    0x9914,
    0x9915,
    0x9916,
    0x9917,
    0x9918,
    0x9919,
    0x991a,
    0x991b,
    0x991c,
    0x991d,
    0x991e,
    0x991f,
    0x9920,
    0x9921,
    0x9922,
    0x9923,
    0x9924,
    0x9925,
    0x9926,
    0x9927,
    0x9928,
    0x9929,
    0x992a,
    0x992b,
    0x992c,
    0x992d,
    0x992f,
    0x9930,
    0x9931,
    0x9932,
    0x9933,
    0x9934,
    0x9935,
    0x9936,
    0x9937,
    0x9938,
    0x9939,
    0x993a,
    0x993b,
    0x993c,
    0x993d,
    0x993e,
    0x993f,
    0x9940,
    0x9941,
    0x9942,
    0x9943,
    0x9944,
    0x9945,
    0x9946,
    0x9947,
    0x9948,
    0x9949,
    CP936_CP_VAL_NULL,
    0x994a,
    0x994b,
    0x994c,
    0x994d,
    0x994e,
    0x994f,
    0x9950,
    0x9951,
    0x9952,
    0x9953,
    0x9956,
    0x9957,
    0x9958,
    0x9959,
    0x995a,
    0x995b,
    0x995c,
    0x995d,
    0x995e,
    0x995f,
    0x9960,
    0x9961,
    0x9962,
    0x9964,
    0x9966,
    0x9973,
    0x9978,
    0x9979,
    0x997b,
    0x997e,
    0x9982,
    0x9983,
    0x9989,
    0x7a39,
    0x7a37,
    0x7a51,
    0x9ecf,
    0x99a5,
    0x7a70,
    0x7688,
    0x768e,
    0x7693,
    0x7699,
    0x76a4,
    0x74de,
    0x74e0,
    0x752c,
    0x9e20,
    0x9e22,
    0x9e28,
    0x9e29,
    0x9e2a,
    0x9e2b,
    0x9e2c,
    0x9e32,
    0x9e31,
    0x9e36,
    0x9e38,
    0x9e37,
    0x9e39,
    0x9e3a,
    0x9e3e,
    0x9e41,
    0x9e42,
    0x9e44,
    0x9e46,
    0x9e47,
    0x9e48,
    0x9e49,
    0x9e4b,
    0x9e4c,
    0x9e4e,
    0x9e51,
    0x9e55,
    0x9e57,
    0x9e5a,
    0x9e5b,
    0x9e5c,
    0x9e5e,
    0x9e63,
    0x9e66,
    0x9e67,
    0x9e68,
    0x9e69,
    0x9e6a,
    0x9e6b,
    0x9e6c,
    0x9e71,
    0x9e6d,
    0x9e73,
    0x7592,
    0x7594,
    0x7596,
    0x75a0,
    0x759d,
    0x75ac,
    0x75a3,
    0x75b3,
    0x75b4,
    0x75b8,
    0x75c4,
    0x75b1,
    0x75b0,
    0x75c3,
    0x75c2,
    0x75d6,
    0x75cd,
    0x75e3,
    0x75e8,
    0x75e6,
    0x75e4,
    0x75eb,
    0x75e7,
    0x7603,
    0x75f1,
    0x75fc,
    0x75ff,
    0x7610,
    0x7600,
    0x7605,
    0x760c,
    0x7617,
    0x760a,
    0x7625,
    0x7618,
    0x7615,
    0x7619,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xf1[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x998c,
    0x998e,
    0x999a,
    0x999b,
    0x999c,
    0x999d,
    0x999e,
    0x999f,
    0x99a0,
    0x99a1,
    0x99a2,
    0x99a3,
    0x99a4,
    0x99a6,
    0x99a7,
    0x99a9,
    0x99aa,
    0x99ab,
    0x99ac,
    0x99ad,
    0x99ae,
    0x99af,
    0x99b0,
    0x99b1,
    0x99b2,
    0x99b3,
    0x99b4,
    0x99b5,
    0x99b6,
    0x99b7,
    0x99b8,
    0x99b9,
    0x99ba,
    0x99bb,
    0x99bc,
    0x99bd,
    0x99be,
    0x99bf,
    0x99c0,
    0x99c1,
    0x99c2,
    0x99c3,
    0x99c4,
    0x99c5,
    0x99c6,
    0x99c7,
    0x99c8,
    0x99c9,
    0x99ca,
    0x99cb,
    0x99cc,
    0x99cd,
    0x99ce,
    0x99cf,
    0x99d0,
    0x99d1,
    0x99d2,
    0x99d3,
    0x99d4,
    0x99d5,
    0x99d6,
    0x99d7,
    0x99d8,
    CP936_CP_VAL_NULL,
    0x99d9,
    0x99da,
    0x99db,
    0x99dc,
    0x99dd,
    0x99de,
    0x99df,
    0x99e0,
    0x99e1,
    0x99e2,
    0x99e3,
    0x99e4,
    0x99e5,
    0x99e6,
    0x99e7,
    0x99e8,
    0x99e9,
    0x99ea,
    0x99eb,
    0x99ec,
    0x99ed,
    0x99ee,
    0x99ef,
    0x99f0,
    0x99f1,
    0x99f2,
    0x99f3,
    0x99f4,
    0x99f5,
    0x99f6,
    0x99f7,
    0x99f8,
    0x99f9,
    0x761b,
    0x763c,
    0x7622,
    0x7620,
    0x7640,
    0x762d,
    0x7630,
    0x763f,
    0x7635,
    0x7643,
    0x763e,
    0x7633,
    0x764d,
    0x765e,
    0x7654,
    0x765c,
    0x7656,
    0x766b,
    0x766f,
    0x7fca,
    0x7ae6,
    0x7a78,
    0x7a79,
    0x7a80,
    0x7a86,
    0x7a88,
    0x7a95,
    0x7aa6,
    0x7aa0,
    0x7aac,
    0x7aa8,
    0x7aad,
    0x7ab3,
    0x8864,
    0x8869,
    0x8872,
    0x887d,
    0x887f,
    0x8882,
    0x88a2,
    0x88c6,
    0x88b7,
    0x88bc,
    0x88c9,
    0x88e2,
    0x88ce,
    0x88e3,
    0x88e5,
    0x88f1,
    0x891a,
    0x88fc,
    0x88e8,
    0x88fe,
    0x88f0,
    0x8921,
    0x8919,
    0x8913,
    0x891b,
    0x890a,
    0x8934,
    0x892b,
    0x8936,
    0x8941,
    0x8966,
    0x897b,
    0x758b,
    0x80e5,
    0x76b2,
    0x76b4,
    0x77dc,
    0x8012,
    0x8014,
    0x8016,
    0x801c,
    0x8020,
    0x8022,
    0x8025,
    0x8026,
    0x8027,
    0x8029,
    0x8028,
    0x8031,
    0x800b,
    0x8035,
    0x8043,
    0x8046,
    0x804d,
    0x8052,
    0x8069,
    0x8071,
    0x8983,
    0x9878,
    0x9880,
    0x9883,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xf2[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x99fa,
    0x99fb,
    0x99fc,
    0x99fd,
    0x99fe,
    0x99ff,
    0x9a00,
    0x9a01,
    0x9a02,
    0x9a03,
    0x9a04,
    0x9a05,
    0x9a06,
    0x9a07,
    0x9a08,
    0x9a09,
    0x9a0a,
    0x9a0b,
    0x9a0c,
    0x9a0d,
    0x9a0e,
    0x9a0f,
    0x9a10,
    0x9a11,
    0x9a12,
    0x9a13,
    0x9a14,
    0x9a15,
    0x9a16,
    0x9a17,
    0x9a18,
    0x9a19,
    0x9a1a,
    0x9a1b,
    0x9a1c,
    0x9a1d,
    0x9a1e,
    0x9a1f,
    0x9a20,
    0x9a21,
    0x9a22,
    0x9a23,
    0x9a24,
    0x9a25,
    0x9a26,
    0x9a27,
    0x9a28,
    0x9a29,
    0x9a2a,
    0x9a2b,
    0x9a2c,
    0x9a2d,
    0x9a2e,
    0x9a2f,
    0x9a30,
    0x9a31,
    0x9a32,
    0x9a33,
    0x9a34,
    0x9a35,
    0x9a36,
    0x9a37,
    0x9a38,
    CP936_CP_VAL_NULL,
    0x9a39,
    0x9a3a,
    0x9a3b,
    0x9a3c,
    0x9a3d,
    0x9a3e,
    0x9a3f,
    0x9a40,
    0x9a41,
    0x9a42,
    0x9a43,
    0x9a44,
    0x9a45,
    0x9a46,
    0x9a47,
    0x9a48,
    0x9a49,
    0x9a4a,
    0x9a4b,
    0x9a4c,
    0x9a4d,
    0x9a4e,
    0x9a4f,
    0x9a50,
    0x9a51,
    0x9a52,
    0x9a53,
    0x9a54,
    0x9a55,
    0x9a56,
    0x9a57,
    0x9a58,
    0x9a59,
    0x9889,
    0x988c,
    0x988d,
    0x988f,
    0x9894,
    0x989a,
    0x989b,
    0x989e,
    0x989f,
    0x98a1,
    0x98a2,
    0x98a5,
    0x98a6,
    0x864d,
    0x8654,
    0x866c,
    0x866e,
    0x867f,
    0x867a,
    0x867c,
    0x867b,
    0x86a8,
    0x868d,
    0x868b,
    0x86ac,
    0x869d,
    0x86a7,
    0x86a3,
    0x86aa,
    0x8693,
    0x86a9,
    0x86b6,
    0x86c4,
    0x86b5,
    0x86ce,
    0x86b0,
    0x86ba,
    0x86b1,
    0x86af,
    0x86c9,
    0x86cf,
    0x86b4,
    0x86e9,
    0x86f1,
    0x86f2,
    0x86ed,
    0x86f3,
    0x86d0,
    0x8713,
    0x86de,
    0x86f4,
    0x86df,
    0x86d8,
    0x86d1,
    0x8703,
    0x8707,
    0x86f8,
    0x8708,
    0x870a,
    0x870d,
    0x8709,
    0x8723,
    0x873b,
    0x871e,
    0x8725,
    0x872e,
    0x871a,
    0x873e,
    0x8748,
    0x8734,
    0x8731,
    0x8729,
    0x8737,
    0x873f,
    0x8782,
    0x8722,
    0x877d,
    0x877e,
    0x877b,
    0x8760,
    0x8770,
    0x874c,
    0x876e,
    0x878b,
    0x8753,
    0x8763,
    0x877c,
    0x8764,
    0x8759,
    0x8765,
    0x8793,
    0x87af,
    0x87a8,
    0x87d2,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xf3[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x9a5a,
    0x9a5b,
    0x9a5c,
    0x9a5d,
    0x9a5e,
    0x9a5f,
    0x9a60,
    0x9a61,
    0x9a62,
    0x9a63,
    0x9a64,
    0x9a65,
    0x9a66,
    0x9a67,
    0x9a68,
    0x9a69,
    0x9a6a,
    0x9a6b,
    0x9a72,
    0x9a83,
    0x9a89,
    0x9a8d,
    0x9a8e,
    0x9a94,
    0x9a95,
    0x9a99,
    0x9aa6,
    0x9aa9,
    0x9aaa,
    0x9aab,
    0x9aac,
    0x9aad,
    0x9aae,
    0x9aaf,
    0x9ab2,
    0x9ab3,
    0x9ab4,
    0x9ab5,
    0x9ab9,
    0x9abb,
    0x9abd,
    0x9abe,
    0x9abf,
    0x9ac3,
    0x9ac4,
    0x9ac6,
    0x9ac7,
    0x9ac8,
    0x9ac9,
    0x9aca,
    0x9acd,
    0x9ace,
    0x9acf,
    0x9ad0,
    0x9ad2,
    0x9ad4,
    0x9ad5,
    0x9ad6,
    0x9ad7,
    0x9ad9,
    0x9ada,
    0x9adb,
    0x9adc,
    CP936_CP_VAL_NULL,
    0x9add,
    0x9ade,
    0x9ae0,
    0x9ae2,
    0x9ae3,
    0x9ae4,
    0x9ae5,
    0x9ae7,
    0x9ae8,
    0x9ae9,
    0x9aea,
    0x9aec,
    0x9aee,
    0x9af0,
    0x9af1,
    0x9af2,
    0x9af3,
    0x9af4,
    0x9af5,
    0x9af6,
    0x9af7,
    0x9af8,
    0x9afa,
    0x9afc,
    0x9afd,
    0x9afe,
    0x9aff,
    0x9b00,
    0x9b01,
    0x9b02,
    0x9b04,
    0x9b05,
    0x9b06,
    0x87c6,
    0x8788,
    0x8785,
    0x87ad,
    0x8797,
    0x8783,
    0x87ab,
    0x87e5,
    0x87ac,
    0x87b5,
    0x87b3,
    0x87cb,
    0x87d3,
    0x87bd,
    0x87d1,
    0x87c0,
    0x87ca,
    0x87db,
    0x87ea,
    0x87e0,
    0x87ee,
    0x8816,
    0x8813,
    0x87fe,
    0x880a,
    0x881b,
    0x8821,
    0x8839,
    0x883c,
    0x7f36,
    0x7f42,
    0x7f44,
    0x7f45,
    0x8210,
    0x7afa,
    0x7afd,
    0x7b08,
    0x7b03,
    0x7b04,
    0x7b15,
    0x7b0a,
    0x7b2b,
    0x7b0f,
    0x7b47,
    0x7b38,
    0x7b2a,
    0x7b19,
    0x7b2e,
    0x7b31,
    0x7b20,
    0x7b25,
    0x7b24,
    0x7b33,
    0x7b3e,
    0x7b1e,
    0x7b58,
    0x7b5a,
    0x7b45,
    0x7b75,
    0x7b4c,
    0x7b5d,
    0x7b60,
    0x7b6e,
    0x7b7b,
    0x7b62,
    0x7b72,
    0x7b71,
    0x7b90,
    0x7ba6,
    0x7ba7,
    0x7bb8,
    0x7bac,
    0x7b9d,
    0x7ba8,
    0x7b85,
    0x7baa,
    0x7b9c,
    0x7ba2,
    0x7bab,
    0x7bb4,
    0x7bd1,
    0x7bc1,
    0x7bcc,
    0x7bdd,
    0x7bda,
    0x7be5,
    0x7be6,
    0x7bea,
    0x7c0c,
    0x7bfe,
    0x7bfc,
    0x7c0f,
    0x7c16,
    0x7c0b,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xf4[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x9b07,
    0x9b09,
    0x9b0a,
    0x9b0b,
    0x9b0c,
    0x9b0d,
    0x9b0e,
    0x9b10,
    0x9b11,
    0x9b12,
    0x9b14,
    0x9b15,
    0x9b16,
    0x9b17,
    0x9b18,
    0x9b19,
    0x9b1a,
    0x9b1b,
    0x9b1c,
    0x9b1d,
    0x9b1e,
    0x9b20,
    0x9b21,
    0x9b22,
    0x9b24,
    0x9b25,
    0x9b26,
    0x9b27,
    0x9b28,
    0x9b29,
    0x9b2a,
    0x9b2b,
    0x9b2c,
    0x9b2d,
    0x9b2e,
    0x9b30,
    0x9b31,
    0x9b33,
    0x9b34,
    0x9b35,
    0x9b36,
    0x9b37,
    0x9b38,
    0x9b39,
    0x9b3a,
    0x9b3d,
    0x9b3e,
    0x9b3f,
    0x9b40,
    0x9b46,
    0x9b4a,
    0x9b4b,
    0x9b4c,
    0x9b4e,
    0x9b50,
    0x9b52,
    0x9b53,
    0x9b55,
    0x9b56,
    0x9b57,
    0x9b58,
    0x9b59,
    0x9b5a,
    CP936_CP_VAL_NULL,
    0x9b5b,
    0x9b5c,
    0x9b5d,
    0x9b5e,
    0x9b5f,
    0x9b60,
    0x9b61,
    0x9b62,
    0x9b63,
    0x9b64,
    0x9b65,
    0x9b66,
    0x9b67,
    0x9b68,
    0x9b69,
    0x9b6a,
    0x9b6b,
    0x9b6c,
    0x9b6d,
    0x9b6e,
    0x9b6f,
    0x9b70,
    0x9b71,
    0x9b72,
    0x9b73,
    0x9b74,
    0x9b75,
    0x9b76,
    0x9b77,
    0x9b78,
    0x9b79,
    0x9b7a,
    0x9b7b,
    0x7c1f,
    0x7c2a,
    0x7c26,
    0x7c38,
    0x7c41,
    0x7c40,
    0x81fe,
    0x8201,
    0x8202,
    0x8204,
    0x81ec,
    0x8844,
    0x8221,
    0x8222,
    0x8223,
    0x822d,
    0x822f,
    0x8228,
    0x822b,
    0x8238,
    0x823b,
    0x8233,
    0x8234,
    0x823e,
    0x8244,
    0x8249,
    0x824b,
    0x824f,
    0x825a,
    0x825f,
    0x8268,
    0x887e,
    0x8885,
    0x8888,
    0x88d8,
    0x88df,
    0x895e,
    0x7f9d,
    0x7f9f,
    0x7fa7,
    0x7faf,
    0x7fb0,
    0x7fb2,
    0x7c7c,
    0x6549,
    0x7c91,
    0x7c9d,
    0x7c9c,
    0x7c9e,
    0x7ca2,
    0x7cb2,
    0x7cbc,
    0x7cbd,
    0x7cc1,
    0x7cc7,
    0x7ccc,
    0x7ccd,
    0x7cc8,
    0x7cc5,
    0x7cd7,
    0x7ce8,
    0x826e,
    0x66a8,
    0x7fbf,
    0x7fce,
    0x7fd5,
    0x7fe5,
    0x7fe1,
    0x7fe6,
    0x7fe9,
    0x7fee,
    0x7ff3,
    0x7cf8,
    0x7d77,
    0x7da6,
    0x7dae,
    0x7e47,
    0x7e9b,
    0x9eb8,
    0x9eb4,
    0x8d73,
    0x8d84,
    0x8d94,
    0x8d91,
    0x8db1,
    0x8d67,
    0x8d6d,
    0x8c47,
    0x8c49,
    0x914a,
    0x9150,
    0x914e,
    0x914f,
    0x9164,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xf5[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x9b7c,
    0x9b7d,
    0x9b7e,
    0x9b7f,
    0x9b80,
    0x9b81,
    0x9b82,
    0x9b83,
    0x9b84,
    0x9b85,
    0x9b86,
    0x9b87,
    0x9b88,
    0x9b89,
    0x9b8a,
    0x9b8b,
    0x9b8c,
    0x9b8d,
    0x9b8e,
    0x9b8f,
    0x9b90,
    0x9b91,
    0x9b92,
    0x9b93,
    0x9b94,
    0x9b95,
    0x9b96,
    0x9b97,
    0x9b98,
    0x9b99,
    0x9b9a,
    0x9b9b,
    0x9b9c,
    0x9b9d,
    0x9b9e,
    0x9b9f,
    0x9ba0,
    0x9ba1,
    0x9ba2,
    0x9ba3,
    0x9ba4,
    0x9ba5,
    0x9ba6,
    0x9ba7,
    0x9ba8,
    0x9ba9,
    0x9baa,
    0x9bab,
    0x9bac,
    0x9bad,
    0x9bae,
    0x9baf,
    0x9bb0,
    0x9bb1,
    0x9bb2,
    0x9bb3,
    0x9bb4,
    0x9bb5,
    0x9bb6,
    0x9bb7,
    0x9bb8,
    0x9bb9,
    0x9bba,
    CP936_CP_VAL_NULL,
    0x9bbb,
    0x9bbc,
    0x9bbd,
    0x9bbe,
    0x9bbf,
    0x9bc0,
    0x9bc1,
    0x9bc2,
    0x9bc3,
    0x9bc4,
    0x9bc5,
    0x9bc6,
    0x9bc7,
    0x9bc8,
    0x9bc9,
    0x9bca,
    0x9bcb,
    0x9bcc,
    0x9bcd,
    0x9bce,
    0x9bcf,
    0x9bd0,
    0x9bd1,
    0x9bd2,
    0x9bd3,
    0x9bd4,
    0x9bd5,
    0x9bd6,
    0x9bd7,
    0x9bd8,
    0x9bd9,
    0x9bda,
    0x9bdb,
    0x9162,
    0x9161,
    0x9170,
    0x9169,
    0x916f,
    0x917d,
    0x917e,
    0x9172,
    0x9174,
    0x9179,
    0x918c,
    0x9185,
    0x9190,
    0x918d,
    0x9191,
    0x91a2,
    0x91a3,
    0x91aa,
    0x91ad,
    0x91ae,
    0x91af,
    0x91b5,
    0x91b4,
    0x91ba,
    0x8c55,
    0x9e7e,
    0x8db8,
    0x8deb,
    0x8e05,
    0x8e59,
    0x8e69,
    0x8db5,
    0x8dbf,
    0x8dbc,
    0x8dba,
    0x8dc4,
    0x8dd6,
    0x8dd7,
    0x8dda,
    0x8dde,
    0x8dce,
    0x8dcf,
    0x8ddb,
    0x8dc6,
    0x8dec,
    0x8df7,
    0x8df8,
    0x8de3,
    0x8df9,
    0x8dfb,
    0x8de4,
    0x8e09,
    0x8dfd,
    0x8e14,
    0x8e1d,
    0x8e1f,
    0x8e2c,
    0x8e2e,
    0x8e23,
    0x8e2f,
    0x8e3a,
    0x8e40,
    0x8e39,
    0x8e35,
    0x8e3d,
    0x8e31,
    0x8e49,
    0x8e41,
    0x8e42,
    0x8e51,
    0x8e52,
    0x8e4a,
    0x8e70,
    0x8e76,
    0x8e7c,
    0x8e6f,
    0x8e74,
    0x8e85,
    0x8e8f,
    0x8e94,
    0x8e90,
    0x8e9c,
    0x8e9e,
    0x8c78,
    0x8c82,
    0x8c8a,
    0x8c85,
    0x8c98,
    0x8c94,
    0x659b,
    0x89d6,
    0x89de,
    0x89da,
    0x89dc,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xf6[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x9bdc,
    0x9bdd,
    0x9bde,
    0x9bdf,
    0x9be0,
    0x9be1,
    0x9be2,
    0x9be3,
    0x9be4,
    0x9be5,
    0x9be6,
    0x9be7,
    0x9be8,
    0x9be9,
    0x9bea,
    0x9beb,
    0x9bec,
    0x9bed,
    0x9bee,
    0x9bef,
    0x9bf0,
    0x9bf1,
    0x9bf2,
    0x9bf3,
    0x9bf4,
    0x9bf5,
    0x9bf6,
    0x9bf7,
    0x9bf8,
    0x9bf9,
    0x9bfa,
    0x9bfb,
    0x9bfc,
    0x9bfd,
    0x9bfe,
    0x9bff,
    0x9c00,
    0x9c01,
    0x9c02,
    0x9c03,
    0x9c04,
    0x9c05,
    0x9c06,
    0x9c07,
    0x9c08,
    0x9c09,
    0x9c0a,
    0x9c0b,
    0x9c0c,
    0x9c0d,
    0x9c0e,
    0x9c0f,
    0x9c10,
    0x9c11,
    0x9c12,
    0x9c13,
    0x9c14,
    0x9c15,
    0x9c16,
    0x9c17,
    0x9c18,
    0x9c19,
    0x9c1a,
    CP936_CP_VAL_NULL,
    0x9c1b,
    0x9c1c,
    0x9c1d,
    0x9c1e,
    0x9c1f,
    0x9c20,
    0x9c21,
    0x9c22,
    0x9c23,
    0x9c24,
    0x9c25,
    0x9c26,
    0x9c27,
    0x9c28,
    0x9c29,
    0x9c2a,
    0x9c2b,
    0x9c2c,
    0x9c2d,
    0x9c2e,
    0x9c2f,
    0x9c30,
    0x9c31,
    0x9c32,
    0x9c33,
    0x9c34,
    0x9c35,
    0x9c36,
    0x9c37,
    0x9c38,
    0x9c39,
    0x9c3a,
    0x9c3b,
    0x89e5,
    0x89eb,
    0x89ef,
    0x8a3e,
    0x8b26,
    0x9753,
    0x96e9,
    0x96f3,
    0x96ef,
    0x9706,
    0x9701,
    0x9708,
    0x970f,
    0x970e,
    0x972a,
    0x972d,
    0x9730,
    0x973e,
    0x9f80,
    0x9f83,
    0x9f85,
    0x9f86,
    0x9f87,
    0x9f88,
    0x9f89,
    0x9f8a,
    0x9f8c,
    0x9efe,
    0x9f0b,
    0x9f0d,
    0x96b9,
    0x96bc,
    0x96bd,
    0x96ce,
    0x96d2,
    0x77bf,
    0x96e0,
    0x928e,
    0x92ae,
    0x92c8,
    0x933e,
    0x936a,
    0x93ca,
    0x938f,
    0x943e,
    0x946b,
    0x9c7f,
    0x9c82,
    0x9c85,
    0x9c86,
    0x9c87,
    0x9c88,
    0x7a23,
    0x9c8b,
    0x9c8e,
    0x9c90,
    0x9c91,
    0x9c92,
    0x9c94,
    0x9c95,
    0x9c9a,
    0x9c9b,
    0x9c9e,
    0x9c9f,
    0x9ca0,
    0x9ca1,
    0x9ca2,
    0x9ca3,
    0x9ca5,
    0x9ca6,
    0x9ca7,
    0x9ca8,
    0x9ca9,
    0x9cab,
    0x9cad,
    0x9cae,
    0x9cb0,
    0x9cb1,
    0x9cb2,
    0x9cb3,
    0x9cb4,
    0x9cb5,
    0x9cb6,
    0x9cb7,
    0x9cba,
    0x9cbb,
    0x9cbc,
    0x9cbd,
    0x9cc4,
    0x9cc5,
    0x9cc6,
    0x9cc7,
    0x9cca,
    0x9ccb,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xf7[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x9c3c,
    0x9c3d,
    0x9c3e,
    0x9c3f,
    0x9c40,
    0x9c41,
    0x9c42,
    0x9c43,
    0x9c44,
    0x9c45,
    0x9c46,
    0x9c47,
    0x9c48,
    0x9c49,
    0x9c4a,
    0x9c4b,
    0x9c4c,
    0x9c4d,
    0x9c4e,
    0x9c4f,
    0x9c50,
    0x9c51,
    0x9c52,
    0x9c53,
    0x9c54,
    0x9c55,
    0x9c56,
    0x9c57,
    0x9c58,
    0x9c59,
    0x9c5a,
    0x9c5b,
    0x9c5c,
    0x9c5d,
    0x9c5e,
    0x9c5f,
    0x9c60,
    0x9c61,
    0x9c62,
    0x9c63,
    0x9c64,
    0x9c65,
    0x9c66,
    0x9c67,
    0x9c68,
    0x9c69,
    0x9c6a,
    0x9c6b,
    0x9c6c,
    0x9c6d,
    0x9c6e,
    0x9c6f,
    0x9c70,
    0x9c71,
    0x9c72,
    0x9c73,
    0x9c74,
    0x9c75,
    0x9c76,
    0x9c77,
    0x9c78,
    0x9c79,
    0x9c7a,
    CP936_CP_VAL_NULL,
    0x9c7b,
    0x9c7d,
    0x9c7e,
    0x9c80,
    0x9c83,
    0x9c84,
    0x9c89,
    0x9c8a,
    0x9c8c,
    0x9c8f,
    0x9c93,
    0x9c96,
    0x9c97,
    0x9c98,
    0x9c99,
    0x9c9d,
    0x9caa,
    0x9cac,
    0x9caf,
    0x9cb9,
    0x9cbe,
    0x9cbf,
    0x9cc0,
    0x9cc1,
    0x9cc2,
    0x9cc8,
    0x9cc9,
    0x9cd1,
    0x9cd2,
    0x9cda,
    0x9cdb,
    0x9ce0,
    0x9ce1,
    0x9ccc,
    0x9ccd,
    0x9cce,
    0x9ccf,
    0x9cd0,
    0x9cd3,
    0x9cd4,
    0x9cd5,
    0x9cd7,
    0x9cd8,
    0x9cd9,
    0x9cdc,
    0x9cdd,
    0x9cdf,
    0x9ce2,
    0x977c,
    0x9785,
    0x9791,
    0x9792,
    0x9794,
    0x97af,
    0x97ab,
    0x97a3,
    0x97b2,
    0x97b4,
    0x9ab1,
    0x9ab0,
    0x9ab7,
    0x9e58,
    0x9ab6,
    0x9aba,
    0x9abc,
    0x9ac1,
    0x9ac0,
    0x9ac5,
    0x9ac2,
    0x9acb,
    0x9acc,
    0x9ad1,
    0x9b45,
    0x9b43,
    0x9b47,
    0x9b49,
    0x9b48,
    0x9b4d,
    0x9b51,
    0x98e8,
    0x990d,
    0x992e,
    0x9955,
    0x9954,
    0x9adf,
    0x9ae1,
    0x9ae6,
    0x9aef,
    0x9aeb,
    0x9afb,
    0x9aed,
    0x9af9,
    0x9b08,
    0x9b0f,
    0x9b13,
    0x9b1f,
    0x9b23,
    0x9ebd,
    0x9ebe,
    0x7e3b,
    0x9e82,
    0x9e87,
    0x9e88,
    0x9e8b,
    0x9e92,
    0x93d6,
    0x9e9d,
    0x9e9f,
    0x9edb,
    0x9edc,
    0x9edd,
    0x9ee0,
    0x9edf,
    0x9ee2,
    0x9ee9,
    0x9ee7,
    0x9ee5,
    0x9eea,
    0x9eef,
    0x9f22,
    0x9f2c,
    0x9f2f,
    0x9f39,
    0x9f37,
    0x9f3d,
    0x9f3e,
    0x9f44,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xf8[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x9ce3,
    0x9ce4,
    0x9ce5,
    0x9ce6,
    0x9ce7,
    0x9ce8,
    0x9ce9,
    0x9cea,
    0x9ceb,
    0x9cec,
    0x9ced,
    0x9cee,
    0x9cef,
    0x9cf0,
    0x9cf1,
    0x9cf2,
    0x9cf3,
    0x9cf4,
    0x9cf5,
    0x9cf6,
    0x9cf7,
    0x9cf8,
    0x9cf9,
    0x9cfa,
    0x9cfb,
    0x9cfc,
    0x9cfd,
    0x9cfe,
    0x9cff,
    0x9d00,
    0x9d01,
    0x9d02,
    0x9d03,
    0x9d04,
    0x9d05,
    0x9d06,
    0x9d07,
    0x9d08,
    0x9d09,
    0x9d0a,
    0x9d0b,
    0x9d0c,
    0x9d0d,
    0x9d0e,
    0x9d0f,
    0x9d10,
    0x9d11,
    0x9d12,
    0x9d13,
    0x9d14,
    0x9d15,
    0x9d16,
    0x9d17,
    0x9d18,
    0x9d19,
    0x9d1a,
    0x9d1b,
    0x9d1c,
    0x9d1d,
    0x9d1e,
    0x9d1f,
    0x9d20,
    0x9d21,
    CP936_CP_VAL_NULL,
    0x9d22,
    0x9d23,
    0x9d24,
    0x9d25,
    0x9d26,
    0x9d27,
    0x9d28,
    0x9d29,
    0x9d2a,
    0x9d2b,
    0x9d2c,
    0x9d2d,
    0x9d2e,
    0x9d2f,
    0x9d30,
    0x9d31,
    0x9d32,
    0x9d33,
    0x9d34,
    0x9d35,
    0x9d36,
    0x9d37,
    0x9d38,
    0x9d39,
    0x9d3a,
    0x9d3b,
    0x9d3c,
    0x9d3d,
    0x9d3e,
    0x9d3f,
    0x9d40,
    0x9d41,
    0x9d42,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xf9[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x9d43,
    0x9d44,
    0x9d45,
    0x9d46,
    0x9d47,
    0x9d48,
    0x9d49,
    0x9d4a,
    0x9d4b,
    0x9d4c,
    0x9d4d,
    0x9d4e,
    0x9d4f,
    0x9d50,
    0x9d51,
    0x9d52,
    0x9d53,
    0x9d54,
    0x9d55,
    0x9d56,
    0x9d57,
    0x9d58,
    0x9d59,
    0x9d5a,
    0x9d5b,
    0x9d5c,
    0x9d5d,
    0x9d5e,
    0x9d5f,
    0x9d60,
    0x9d61,
    0x9d62,
    0x9d63,
    0x9d64,
    0x9d65,
    0x9d66,
    0x9d67,
    0x9d68,
    0x9d69,
    0x9d6a,
    0x9d6b,
    0x9d6c,
    0x9d6d,
    0x9d6e,
    0x9d6f,
    0x9d70,
    0x9d71,
    0x9d72,
    0x9d73,
    0x9d74,
    0x9d75,
    0x9d76,
    0x9d77,
    0x9d78,
    0x9d79,
    0x9d7a,
    0x9d7b,
    0x9d7c,
    0x9d7d,
    0x9d7e,
    0x9d7f,
    0x9d80,
    0x9d81,
    CP936_CP_VAL_NULL,
    0x9d82,
    0x9d83,
    0x9d84,
    0x9d85,
    0x9d86,
    0x9d87,
    0x9d88,
    0x9d89,
    0x9d8a,
    0x9d8b,
    0x9d8c,
    0x9d8d,
    0x9d8e,
    0x9d8f,
    0x9d90,
    0x9d91,
    0x9d92,
    0x9d93,
    0x9d94,
    0x9d95,
    0x9d96,
    0x9d97,
    0x9d98,
    0x9d99,
    0x9d9a,
    0x9d9b,
    0x9d9c,
    0x9d9d,
    0x9d9e,
    0x9d9f,
    0x9da0,
    0x9da1,
    0x9da2,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xfa[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x9da3,
    0x9da4,
    0x9da5,
    0x9da6,
    0x9da7,
    0x9da8,
    0x9da9,
    0x9daa,
    0x9dab,
    0x9dac,
    0x9dad,
    0x9dae,
    0x9daf,
    0x9db0,
    0x9db1,
    0x9db2,
    0x9db3,
    0x9db4,
    0x9db5,
    0x9db6,
    0x9db7,
    0x9db8,
    0x9db9,
    0x9dba,
    0x9dbb,
    0x9dbc,
    0x9dbd,
    0x9dbe,
    0x9dbf,
    0x9dc0,
    0x9dc1,
    0x9dc2,
    0x9dc3,
    0x9dc4,
    0x9dc5,
    0x9dc6,
    0x9dc7,
    0x9dc8,
    0x9dc9,
    0x9dca,
    0x9dcb,
    0x9dcc,
    0x9dcd,
    0x9dce,
    0x9dcf,
    0x9dd0,
    0x9dd1,
    0x9dd2,
    0x9dd3,
    0x9dd4,
    0x9dd5,
    0x9dd6,
    0x9dd7,
    0x9dd8,
    0x9dd9,
    0x9dda,
    0x9ddb,
    0x9ddc,
    0x9ddd,
    0x9dde,
    0x9ddf,
    0x9de0,
    0x9de1,
    CP936_CP_VAL_NULL,
    0x9de2,
    0x9de3,
    0x9de4,
    0x9de5,
    0x9de6,
    0x9de7,
    0x9de8,
    0x9de9,
    0x9dea,
    0x9deb,
    0x9dec,
    0x9ded,
    0x9dee,
    0x9def,
    0x9df0,
    0x9df1,
    0x9df2,
    0x9df3,
    0x9df4,
    0x9df5,
    0x9df6,
    0x9df7,
    0x9df8,
    0x9df9,
    0x9dfa,
    0x9dfb,
    0x9dfc,
    0x9dfd,
    0x9dfe,
    0x9dff,
    0x9e00,
    0x9e01,
    0x9e02,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xfb[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x9e03,
    0x9e04,
    0x9e05,
    0x9e06,
    0x9e07,
    0x9e08,
    0x9e09,
    0x9e0a,
    0x9e0b,
    0x9e0c,
    0x9e0d,
    0x9e0e,
    0x9e0f,
    0x9e10,
    0x9e11,
    0x9e12,
    0x9e13,
    0x9e14,
    0x9e15,
    0x9e16,
    0x9e17,
    0x9e18,
    0x9e19,
    0x9e1a,
    0x9e1b,
    0x9e1c,
    0x9e1d,
    0x9e1e,
    0x9e24,
    0x9e27,
    0x9e2e,
    0x9e30,
    0x9e34,
    0x9e3b,
    0x9e3c,
    0x9e40,
    0x9e4d,
    0x9e50,
    0x9e52,
    0x9e53,
    0x9e54,
    0x9e56,
    0x9e59,
    0x9e5d,
    0x9e5f,
    0x9e60,
    0x9e61,
    0x9e62,
    0x9e65,
    0x9e6e,
    0x9e6f,
    0x9e72,
    0x9e74,
    0x9e75,
    0x9e76,
    0x9e77,
    0x9e78,
    0x9e79,
    0x9e7a,
    0x9e7b,
    0x9e7c,
    0x9e7d,
    0x9e80,
    CP936_CP_VAL_NULL,
    0x9e81,
    0x9e83,
    0x9e84,
    0x9e85,
    0x9e86,
    0x9e89,
    0x9e8a,
    0x9e8c,
    0x9e8d,
    0x9e8e,
    0x9e8f,
    0x9e90,
    0x9e91,
    0x9e94,
    0x9e95,
    0x9e96,
    0x9e97,
    0x9e98,
    0x9e99,
    0x9e9a,
    0x9e9b,
    0x9e9c,
    0x9e9e,
    0x9ea0,
    0x9ea1,
    0x9ea2,
    0x9ea3,
    0x9ea4,
    0x9ea5,
    0x9ea7,
    0x9ea8,
    0x9ea9,
    0x9eaa,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xfc[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x9eab,
    0x9eac,
    0x9ead,
    0x9eae,
    0x9eaf,
    0x9eb0,
    0x9eb1,
    0x9eb2,
    0x9eb3,
    0x9eb5,
    0x9eb6,
    0x9eb7,
    0x9eb9,
    0x9eba,
    0x9ebc,
    0x9ebf,
    0x9ec0,
    0x9ec1,
    0x9ec2,
    0x9ec3,
    0x9ec5,
    0x9ec6,
    0x9ec7,
    0x9ec8,
    0x9eca,
    0x9ecb,
    0x9ecc,
    0x9ed0,
    0x9ed2,
    0x9ed3,
    0x9ed5,
    0x9ed6,
    0x9ed7,
    0x9ed9,
    0x9eda,
    0x9ede,
    0x9ee1,
    0x9ee3,
    0x9ee4,
    0x9ee6,
    0x9ee8,
    0x9eeb,
    0x9eec,
    0x9eed,
    0x9eee,
    0x9ef0,
    0x9ef1,
    0x9ef2,
    0x9ef3,
    0x9ef4,
    0x9ef5,
    0x9ef6,
    0x9ef7,
    0x9ef8,
    0x9efa,
    0x9efd,
    0x9eff,
    0x9f00,
    0x9f01,
    0x9f02,
    0x9f03,
    0x9f04,
    0x9f05,
    CP936_CP_VAL_NULL,
    0x9f06,
    0x9f07,
    0x9f08,
    0x9f09,
    0x9f0a,
    0x9f0c,
    0x9f0f,
    0x9f11,
    0x9f12,
    0x9f14,
    0x9f15,
    0x9f16,
    0x9f18,
    0x9f1a,
    0x9f1b,
    0x9f1c,
    0x9f1d,
    0x9f1e,
    0x9f1f,
    0x9f21,
    0x9f23,
    0x9f24,
    0x9f25,
    0x9f26,
    0x9f27,
    0x9f28,
    0x9f29,
    0x9f2a,
    0x9f2b,
    0x9f2d,
    0x9f2e,
    0x9f30,
    0x9f31,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xfd[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0x9f32,
    0x9f33,
    0x9f34,
    0x9f35,
    0x9f36,
    0x9f38,
    0x9f3a,
    0x9f3c,
    0x9f3f,
    0x9f40,
    0x9f41,
    0x9f42,
    0x9f43,
    0x9f45,
    0x9f46,
    0x9f47,
    0x9f48,
    0x9f49,
    0x9f4a,
    0x9f4b,
    0x9f4c,
    0x9f4d,
    0x9f4e,
    0x9f4f,
    0x9f52,
    0x9f53,
    0x9f54,
    0x9f55,
    0x9f56,
    0x9f57,
    0x9f58,
    0x9f59,
    0x9f5a,
    0x9f5b,
    0x9f5c,
    0x9f5d,
    0x9f5e,
    0x9f5f,
    0x9f60,
    0x9f61,
    0x9f62,
    0x9f63,
    0x9f64,
    0x9f65,
    0x9f66,
    0x9f67,
    0x9f68,
    0x9f69,
    0x9f6a,
    0x9f6b,
    0x9f6c,
    0x9f6d,
    0x9f6e,
    0x9f6f,
    0x9f70,
    0x9f71,
    0x9f72,
    0x9f73,
    0x9f74,
    0x9f75,
    0x9f76,
    0x9f77,
    0x9f78,
    CP936_CP_VAL_NULL,
    0x9f79,
    0x9f7a,
    0x9f7b,
    0x9f7c,
    0x9f7d,
    0x9f7e,
    0x9f81,
    0x9f82,
    0x9f8d,
    0x9f8e,
    0x9f8f,
    0x9f90,
    0x9f91,
    0x9f92,
    0x9f93,
    0x9f94,
    0x9f95,
    0x9f96,
    0x9f97,
    0x9f98,
    0x9f9c,
    0x9f9d,
    0x9f9e,
    0x9fa1,
    0x9fa2,
    0x9fa3,
    0x9fa4,
    0x9fa5,
    0xf92c,
    0xf979,
    0xf995,
    0xf9e7,
    0xf9f1,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL
};
UINT16 cp936_CP_a0xfe[] = {
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    0xfa0c,
    0xfa0d,
    0xfa0e,
    0xfa0f,
    0xfa11,
    0xfa13,
    0xfa14,
    0xfa18,
    0xfa1f,
    0xfa20,
    0xfa21,
    0xfa23,
    0xfa24,
    0xfa27,
    0xfa28,
    0xfa29,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL
};
VOID *cp936_CP_idx[] = {
    &cp936_CP_a0x0,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    CP936_CP_VAL_NULL,
    &cp936_CP_a0x81,
    &cp936_CP_a0x82,
    &cp936_CP_a0x83,
    &cp936_CP_a0x84,
    &cp936_CP_a0x85,
    &cp936_CP_a0x86,
    &cp936_CP_a0x87,
    &cp936_CP_a0x88,
    &cp936_CP_a0x89,
    &cp936_CP_a0x8a,
    &cp936_CP_a0x8b,
    &cp936_CP_a0x8c,
    &cp936_CP_a0x8d,
    &cp936_CP_a0x8e,
    &cp936_CP_a0x8f,
    &cp936_CP_a0x90,
    &cp936_CP_a0x91,
    &cp936_CP_a0x92,
    &cp936_CP_a0x93,
    &cp936_CP_a0x94,
    &cp936_CP_a0x95,
    &cp936_CP_a0x96,
    &cp936_CP_a0x97,
    &cp936_CP_a0x98,
    &cp936_CP_a0x99,
    &cp936_CP_a0x9a,
    &cp936_CP_a0x9b,
    &cp936_CP_a0x9c,
    &cp936_CP_a0x9d,
    &cp936_CP_a0x9e,
    &cp936_CP_a0x9f,
    &cp936_CP_a0xa0,
    &cp936_CP_a0xa1,
    &cp936_CP_a0xa2,
    &cp936_CP_a0xa3,
    &cp936_CP_a0xa4,
    &cp936_CP_a0xa5,
    &cp936_CP_a0xa6,
    &cp936_CP_a0xa7,
    &cp936_CP_a0xa8,
    &cp936_CP_a0xa9,
    &cp936_CP_a0xaa,
    &cp936_CP_a0xab,
    &cp936_CP_a0xac,
    &cp936_CP_a0xad,
    &cp936_CP_a0xae,
    &cp936_CP_a0xaf,
    &cp936_CP_a0xb0,
    &cp936_CP_a0xb1,
    &cp936_CP_a0xb2,
    &cp936_CP_a0xb3,
    &cp936_CP_a0xb4,
    &cp936_CP_a0xb5,
    &cp936_CP_a0xb6,
    &cp936_CP_a0xb7,
    &cp936_CP_a0xb8,
    &cp936_CP_a0xb9,
    &cp936_CP_a0xba,
    &cp936_CP_a0xbb,
    &cp936_CP_a0xbc,
    &cp936_CP_a0xbd,
    &cp936_CP_a0xbe,
    &cp936_CP_a0xbf,
    &cp936_CP_a0xc0,
    &cp936_CP_a0xc1,
    &cp936_CP_a0xc2,
    &cp936_CP_a0xc3,
    &cp936_CP_a0xc4,
    &cp936_CP_a0xc5,
    &cp936_CP_a0xc6,
    &cp936_CP_a0xc7,
    &cp936_CP_a0xc8,
    &cp936_CP_a0xc9,
    &cp936_CP_a0xca,
    &cp936_CP_a0xcb,
    &cp936_CP_a0xcc,
    &cp936_CP_a0xcd,
    &cp936_CP_a0xce,
    &cp936_CP_a0xcf,
    &cp936_CP_a0xd0,
    &cp936_CP_a0xd1,
    &cp936_CP_a0xd2,
    &cp936_CP_a0xd3,
    &cp936_CP_a0xd4,
    &cp936_CP_a0xd5,
    &cp936_CP_a0xd6,
    &cp936_CP_a0xd7,
    &cp936_CP_a0xd8,
    &cp936_CP_a0xd9,
    &cp936_CP_a0xda,
    &cp936_CP_a0xdb,
    &cp936_CP_a0xdc,
    &cp936_CP_a0xdd,
    &cp936_CP_a0xde,
    &cp936_CP_a0xdf,
    &cp936_CP_a0xe0,
    &cp936_CP_a0xe1,
    &cp936_CP_a0xe2,
    &cp936_CP_a0xe3,
    &cp936_CP_a0xe4,
    &cp936_CP_a0xe5,
    &cp936_CP_a0xe6,
    &cp936_CP_a0xe7,
    &cp936_CP_a0xe8,
    &cp936_CP_a0xe9,
    &cp936_CP_a0xea,
    &cp936_CP_a0xeb,
    &cp936_CP_a0xec,
    &cp936_CP_a0xed,
    &cp936_CP_a0xee,
    &cp936_CP_a0xef,
    &cp936_CP_a0xf0,
    &cp936_CP_a0xf1,
    &cp936_CP_a0xf2,
    &cp936_CP_a0xf3,
    &cp936_CP_a0xf4,
    &cp936_CP_a0xf5,
    &cp936_CP_a0xf6,
    &cp936_CP_a0xf7,
    &cp936_CP_a0xf8,
    &cp936_CP_a0xf9,
    &cp936_CP_a0xfa,
    &cp936_CP_a0xfb,
    &cp936_CP_a0xfc,
    &cp936_CP_a0xfd,
    &cp936_CP_a0xfe,
    CP936_CP_VAL_NULL
};
UINT16 cp936_UNI_a0x0[] = {
    0x0,
    0x1,
    0x2,
    0x3,
    0x4,
    0x5,
    0x6,
    0x7,
    0x8,
    0x9,
    0xa,
    0xb,
    0xc,
    0xd,
    0xe,
    0xf,
    0x10,
    0x11,
    0x12,
    0x13,
    0x14,
    0x15,
    0x16,
    0x17,
    0x18,
    0x19,
    0x1a,
    0x1b,
    0x1c,
    0x1d,
    0x1e,
    0x1f,
    0x20,
    0x21,
    0x22,
    0x23,
    0x24,
    0x25,
    0x26,
    0x27,
    0x28,
    0x29,
    0x2a,
    0x2b,
    0x2c,
    0x2d,
    0x2e,
    0x2f,
    0x30,
    0x31,
    0x32,
    0x33,
    0x34,
    0x35,
    0x36,
    0x37,
    0x38,
    0x39,
    0x3a,
    0x3b,
    0x3c,
    0x3d,
    0x3e,
    0x3f,
    0x40,
    0x41,
    0x42,
    0x43,
    0x44,
    0x45,
    0x46,
    0x47,
    0x48,
    0x49,
    0x4a,
    0x4b,
    0x4c,
    0x4d,
    0x4e,
    0x4f,
    0x50,
    0x51,
    0x52,
    0x53,
    0x54,
    0x55,
    0x56,
    0x57,
    0x58,
    0x59,
    0x5a,
    0x5b,
    0x5c,
    0x5d,
    0x5e,
    0x5f,
    0x60,
    0x61,
    0x62,
    0x63,
    0x64,
    0x65,
    0x66,
    0x67,
    0x68,
    0x69,
    0x6a,
    0x6b,
    0x6c,
    0x6d,
    0x6e,
    0x6f,
    0x70,
    0x71,
    0x72,
    0x73,
    0x74,
    0x75,
    0x76,
    0x77,
    0x78,
    0x79,
    0x7a,
    0x7b,
    0x7c,
    0x7d,
    0x7e,
    0x7f,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa1e8,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa1ec,
    0xa1a7,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa1e3,
    0xa1c0,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa1a4,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa1c1,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa8a4,
    0xa8a2,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa8a8,
    0xa8a6,
    0xa8ba,
    CP936_UNI_VAL_NULL,
    0xa8ac,
    0xa8aa,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa8b0,
    0xa8ae,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa1c2,
    CP936_UNI_VAL_NULL,
    0xa8b4,
    0xa8b2,
    CP936_UNI_VAL_NULL,
    0xa8b9,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL
};
UINT16 cp936_UNI_a0x1[] = {
    CP936_UNI_VAL_NULL,
    0xa8a1,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa8a5,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa8a7,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa8a9,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa8bd,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa8be,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa8ad,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa8b1,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa8a3,
    CP936_UNI_VAL_NULL,
    0xa8ab,
    CP936_UNI_VAL_NULL,
    0xa8af,
    CP936_UNI_VAL_NULL,
    0xa8b3,
    CP936_UNI_VAL_NULL,
    0xa8b5,
    CP936_UNI_VAL_NULL,
    0xa8b6,
    CP936_UNI_VAL_NULL,
    0xa8b7,
    CP936_UNI_VAL_NULL,
    0xa8b8,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL
};
UINT16 cp936_UNI_a0x2[] = {
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa8bb,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa8c0,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa1a6,
    CP936_UNI_VAL_NULL,
    0xa1a5,
    0xa840,
    0xa841,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa842,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL
};
UINT16 cp936_UNI_a0x3[] = {
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa6a1,
    0xa6a2,
    0xa6a3,
    0xa6a4,
    0xa6a5,
    0xa6a6,
    0xa6a7,
    0xa6a8,
    0xa6a9,
    0xa6aa,
    0xa6ab,
    0xa6ac,
    0xa6ad,
    0xa6ae,
    0xa6af,
    0xa6b0,
    0xa6b1,
    CP936_UNI_VAL_NULL,
    0xa6b2,
    0xa6b3,
    0xa6b4,
    0xa6b5,
    0xa6b6,
    0xa6b7,
    0xa6b8,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa6c1,
    0xa6c2,
    0xa6c3,
    0xa6c4,
    0xa6c5,
    0xa6c6,
    0xa6c7,
    0xa6c8,
    0xa6c9,
    0xa6ca,
    0xa6cb,
    0xa6cc,
    0xa6cd,
    0xa6ce,
    0xa6cf,
    0xa6d0,
    0xa6d1,
    CP936_UNI_VAL_NULL,
    0xa6d2,
    0xa6d3,
    0xa6d4,
    0xa6d5,
    0xa6d6,
    0xa6d7,
    0xa6d8,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL
};
UINT16 cp936_UNI_a0x4[] = {
    CP936_UNI_VAL_NULL,
    0xa7a7,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa7a1,
    0xa7a2,
    0xa7a3,
    0xa7a4,
    0xa7a5,
    0xa7a6,
    0xa7a8,
    0xa7a9,
    0xa7aa,
    0xa7ab,
    0xa7ac,
    0xa7ad,
    0xa7ae,
    0xa7af,
    0xa7b0,
    0xa7b1,
    0xa7b2,
    0xa7b3,
    0xa7b4,
    0xa7b5,
    0xa7b6,
    0xa7b7,
    0xa7b8,
    0xa7b9,
    0xa7ba,
    0xa7bb,
    0xa7bc,
    0xa7bd,
    0xa7be,
    0xa7bf,
    0xa7c0,
    0xa7c1,
    0xa7d1,
    0xa7d2,
    0xa7d3,
    0xa7d4,
    0xa7d5,
    0xa7d6,
    0xa7d8,
    0xa7d9,
    0xa7da,
    0xa7db,
    0xa7dc,
    0xa7dd,
    0xa7de,
    0xa7df,
    0xa7e0,
    0xa7e1,
    0xa7e2,
    0xa7e3,
    0xa7e4,
    0xa7e5,
    0xa7e6,
    0xa7e7,
    0xa7e8,
    0xa7e9,
    0xa7ea,
    0xa7eb,
    0xa7ec,
    0xa7ed,
    0xa7ee,
    0xa7ef,
    0xa7f0,
    0xa7f1,
    CP936_UNI_VAL_NULL,
    0xa7d7,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL
};
UINT16 cp936_UNI_a0x20[] = {
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa95c,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa843,
    0xa1aa,
    0xa844,
    0xa1ac,
    CP936_UNI_VAL_NULL,
    0xa1ae,
    0xa1af,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa1b0,
    0xa1b1,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa845,
    0xa1ad,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa1eb,
    CP936_UNI_VAL_NULL,
    0xa1e4,
    0xa1e5,
    CP936_UNI_VAL_NULL,
    0xa846,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa1f9,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0x80,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL
};
UINT16 cp936_UNI_a0x21[] = {
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa1e6,
    CP936_UNI_VAL_NULL,
    0xa847,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa848,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa1ed,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa959,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa2f1,
    0xa2f2,
    0xa2f3,
    0xa2f4,
    0xa2f5,
    0xa2f6,
    0xa2f7,
    0xa2f8,
    0xa2f9,
    0xa2fa,
    0xa2fb,
    0xa2fc,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa2a1,
    0xa2a2,
    0xa2a3,
    0xa2a4,
    0xa2a5,
    0xa2a6,
    0xa2a7,
    0xa2a8,
    0xa2a9,
    0xa2aa,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa1fb,
    0xa1fc,
    0xa1fa,
    0xa1fd,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa849,
    0xa84a,
    0xa84b,
    0xa84c,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL
};
UINT16 cp936_UNI_a0x22[] = {
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa1ca,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa1c7,
    CP936_UNI_VAL_NULL,
    0xa1c6,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa84d,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa1cc,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa1d8,
    0xa1de,
    0xa84e,
    0xa1cf,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa84f,
    CP936_UNI_VAL_NULL,
    0xa1ce,
    CP936_UNI_VAL_NULL,
    0xa1c4,
    0xa1c5,
    0xa1c9,
    0xa1c8,
    0xa1d2,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa1d3,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa1e0,
    0xa1df,
    0xa1c3,
    0xa1cb,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa1d7,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa1d6,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa1d5,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa850,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa1d9,
    0xa1d4,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa1dc,
    0xa1dd,
    0xa851,
    0xa852,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa1da,
    0xa1db,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa892,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa1d1,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa1cd,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa853,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL
};
UINT16 cp936_UNI_a0x23[] = {
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa1d0,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL
};
UINT16 cp936_UNI_a0x24[] = {
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa2d9,
    0xa2da,
    0xa2db,
    0xa2dc,
    0xa2dd,
    0xa2de,
    0xa2df,
    0xa2e0,
    0xa2e1,
    0xa2e2,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa2c5,
    0xa2c6,
    0xa2c7,
    0xa2c8,
    0xa2c9,
    0xa2ca,
    0xa2cb,
    0xa2cc,
    0xa2cd,
    0xa2ce,
    0xa2cf,
    0xa2d0,
    0xa2d1,
    0xa2d2,
    0xa2d3,
    0xa2d4,
    0xa2d5,
    0xa2d6,
    0xa2d7,
    0xa2d8,
    0xa2b1,
    0xa2b2,
    0xa2b3,
    0xa2b4,
    0xa2b5,
    0xa2b6,
    0xa2b7,
    0xa2b8,
    0xa2b9,
    0xa2ba,
    0xa2bb,
    0xa2bc,
    0xa2bd,
    0xa2be,
    0xa2bf,
    0xa2c0,
    0xa2c1,
    0xa2c2,
    0xa2c3,
    0xa2c4,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL
};
UINT16 cp936_UNI_a0x25[] = {
    0xa9a4,
    0xa9a5,
    0xa9a6,
    0xa9a7,
    0xa9a8,
    0xa9a9,
    0xa9aa,
    0xa9ab,
    0xa9ac,
    0xa9ad,
    0xa9ae,
    0xa9af,
    0xa9b0,
    0xa9b1,
    0xa9b2,
    0xa9b3,
    0xa9b4,
    0xa9b5,
    0xa9b6,
    0xa9b7,
    0xa9b8,
    0xa9b9,
    0xa9ba,
    0xa9bb,
    0xa9bc,
    0xa9bd,
    0xa9be,
    0xa9bf,
    0xa9c0,
    0xa9c1,
    0xa9c2,
    0xa9c3,
    0xa9c4,
    0xa9c5,
    0xa9c6,
    0xa9c7,
    0xa9c8,
    0xa9c9,
    0xa9ca,
    0xa9cb,
    0xa9cc,
    0xa9cd,
    0xa9ce,
    0xa9cf,
    0xa9d0,
    0xa9d1,
    0xa9d2,
    0xa9d3,
    0xa9d4,
    0xa9d5,
    0xa9d6,
    0xa9d7,
    0xa9d8,
    0xa9d9,
    0xa9da,
    0xa9db,
    0xa9dc,
    0xa9dd,
    0xa9de,
    0xa9df,
    0xa9e0,
    0xa9e1,
    0xa9e2,
    0xa9e3,
    0xa9e4,
    0xa9e5,
    0xa9e6,
    0xa9e7,
    0xa9e8,
    0xa9e9,
    0xa9ea,
    0xa9eb,
    0xa9ec,
    0xa9ed,
    0xa9ee,
    0xa9ef,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa854,
    0xa855,
    0xa856,
    0xa857,
    0xa858,
    0xa859,
    0xa85a,
    0xa85b,
    0xa85c,
    0xa85d,
    0xa85e,
    0xa85f,
    0xa860,
    0xa861,
    0xa862,
    0xa863,
    0xa864,
    0xa865,
    0xa866,
    0xa867,
    0xa868,
    0xa869,
    0xa86a,
    0xa86b,
    0xa86c,
    0xa86d,
    0xa86e,
    0xa86f,
    0xa870,
    0xa871,
    0xa872,
    0xa873,
    0xa874,
    0xa875,
    0xa876,
    0xa877,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa878,
    0xa879,
    0xa87a,
    0xa87b,
    0xa87c,
    0xa87d,
    0xa87e,
    0xa880,
    0xa881,
    0xa882,
    0xa883,
    0xa884,
    0xa885,
    0xa886,
    0xa887,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa888,
    0xa889,
    0xa88a,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa1f6,
    0xa1f5,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa1f8,
    0xa1f7,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa88b,
    0xa88c,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa1f4,
    0xa1f3,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa1f0,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa1f2,
    0xa1f1,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa88d,
    0xa88e,
    0xa88f,
    0xa890,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL
};
UINT16 cp936_UNI_a0x26[] = {
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa1ef,
    0xa1ee,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa891,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa1e2,
    CP936_UNI_VAL_NULL,
    0xa1e1,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL
};
UINT16 cp936_UNI_a0x30[] = {
    0xa1a1,
    0xa1a2,
    0xa1a3,
    0xa1a8,
    CP936_UNI_VAL_NULL,
    0xa1a9,
    0xa965,
    0xa996,
    0xa1b4,
    0xa1b5,
    0xa1b6,
    0xa1b7,
    0xa1b8,
    0xa1b9,
    0xa1ba,
    0xa1bb,
    0xa1be,
    0xa1bf,
    0xa893,
    0xa1fe,
    0xa1b2,
    0xa1b3,
    0xa1bc,
    0xa1bd,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa894,
    0xa895,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa940,
    0xa941,
    0xa942,
    0xa943,
    0xa944,
    0xa945,
    0xa946,
    0xa947,
    0xa948,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa4a1,
    0xa4a2,
    0xa4a3,
    0xa4a4,
    0xa4a5,
    0xa4a6,
    0xa4a7,
    0xa4a8,
    0xa4a9,
    0xa4aa,
    0xa4ab,
    0xa4ac,
    0xa4ad,
    0xa4ae,
    0xa4af,
    0xa4b0,
    0xa4b1,
    0xa4b2,
    0xa4b3,
    0xa4b4,
    0xa4b5,
    0xa4b6,
    0xa4b7,
    0xa4b8,
    0xa4b9,
    0xa4ba,
    0xa4bb,
    0xa4bc,
    0xa4bd,
    0xa4be,
    0xa4bf,
    0xa4c0,
    0xa4c1,
    0xa4c2,
    0xa4c3,
    0xa4c4,
    0xa4c5,
    0xa4c6,
    0xa4c7,
    0xa4c8,
    0xa4c9,
    0xa4ca,
    0xa4cb,
    0xa4cc,
    0xa4cd,
    0xa4ce,
    0xa4cf,
    0xa4d0,
    0xa4d1,
    0xa4d2,
    0xa4d3,
    0xa4d4,
    0xa4d5,
    0xa4d6,
    0xa4d7,
    0xa4d8,
    0xa4d9,
    0xa4da,
    0xa4db,
    0xa4dc,
    0xa4dd,
    0xa4de,
    0xa4df,
    0xa4e0,
    0xa4e1,
    0xa4e2,
    0xa4e3,
    0xa4e4,
    0xa4e5,
    0xa4e6,
    0xa4e7,
    0xa4e8,
    0xa4e9,
    0xa4ea,
    0xa4eb,
    0xa4ec,
    0xa4ed,
    0xa4ee,
    0xa4ef,
    0xa4f0,
    0xa4f1,
    0xa4f2,
    0xa4f3,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa961,
    0xa962,
    0xa966,
    0xa967,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa5a1,
    0xa5a2,
    0xa5a3,
    0xa5a4,
    0xa5a5,
    0xa5a6,
    0xa5a7,
    0xa5a8,
    0xa5a9,
    0xa5aa,
    0xa5ab,
    0xa5ac,
    0xa5ad,
    0xa5ae,
    0xa5af,
    0xa5b0,
    0xa5b1,
    0xa5b2,
    0xa5b3,
    0xa5b4,
    0xa5b5,
    0xa5b6,
    0xa5b7,
    0xa5b8,
    0xa5b9,
    0xa5ba,
    0xa5bb,
    0xa5bc,
    0xa5bd,
    0xa5be,
    0xa5bf,
    0xa5c0,
    0xa5c1,
    0xa5c2,
    0xa5c3,
    0xa5c4,
    0xa5c5,
    0xa5c6,
    0xa5c7,
    0xa5c8,
    0xa5c9,
    0xa5ca,
    0xa5cb,
    0xa5cc,
    0xa5cd,
    0xa5ce,
    0xa5cf,
    0xa5d0,
    0xa5d1,
    0xa5d2,
    0xa5d3,
    0xa5d4,
    0xa5d5,
    0xa5d6,
    0xa5d7,
    0xa5d8,
    0xa5d9,
    0xa5da,
    0xa5db,
    0xa5dc,
    0xa5dd,
    0xa5de,
    0xa5df,
    0xa5e0,
    0xa5e1,
    0xa5e2,
    0xa5e3,
    0xa5e4,
    0xa5e5,
    0xa5e6,
    0xa5e7,
    0xa5e8,
    0xa5e9,
    0xa5ea,
    0xa5eb,
    0xa5ec,
    0xa5ed,
    0xa5ee,
    0xa5ef,
    0xa5f0,
    0xa5f1,
    0xa5f2,
    0xa5f3,
    0xa5f4,
    0xa5f5,
    0xa5f6,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa960,
    0xa963,
    0xa964,
    CP936_UNI_VAL_NULL
};
UINT16 cp936_UNI_a0x31[] = {
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa8c5,
    0xa8c6,
    0xa8c7,
    0xa8c8,
    0xa8c9,
    0xa8ca,
    0xa8cb,
    0xa8cc,
    0xa8cd,
    0xa8ce,
    0xa8cf,
    0xa8d0,
    0xa8d1,
    0xa8d2,
    0xa8d3,
    0xa8d4,
    0xa8d5,
    0xa8d6,
    0xa8d7,
    0xa8d8,
    0xa8d9,
    0xa8da,
    0xa8db,
    0xa8dc,
    0xa8dd,
    0xa8de,
    0xa8df,
    0xa8e0,
    0xa8e1,
    0xa8e2,
    0xa8e3,
    0xa8e4,
    0xa8e5,
    0xa8e6,
    0xa8e7,
    0xa8e8,
    0xa8e9,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL
};
UINT16 cp936_UNI_a0x32[] = {
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa2e5,
    0xa2e6,
    0xa2e7,
    0xa2e8,
    0xa2e9,
    0xa2ea,
    0xa2eb,
    0xa2ec,
    0xa2ed,
    0xa2ee,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa95a,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa949,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL
};
UINT16 cp936_UNI_a0x33[] = {
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa94a,
    0xa94b,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa94c,
    0xa94d,
    0xa94e,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa94f,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa950,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa951,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa952,
    0xa953,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa954,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL
};
UINT16 cp936_UNI_a0x4e[] = {
    0xd2bb,
    0xb6a1,
    0x8140,
    0xc6df,
    0x8141,
    0x8142,
    0x8143,
    0xcdf2,
    0xd5c9,
    0xc8fd,
    0xc9cf,
    0xcfc2,
    0xd8a2,
    0xb2bb,
    0xd3eb,
    0x8144,
    0xd8a4,
    0xb3f3,
    0x8145,
    0xd7a8,
    0xc7d2,
    0xd8a7,
    0xcac0,
    0x8146,
    0xc7f0,
    0xb1fb,
    0xd2b5,
    0xb4d4,
    0xb6ab,
    0xcbbf,
    0xd8a9,
    0x8147,
    0x8148,
    0x8149,
    0xb6aa,
    0x814a,
    0xc1bd,
    0xd1cf,
    0x814b,
    0xc9a5,
    0xd8ad,
    0x814c,
    0xb8f6,
    0xd1be,
    0xe3dc,
    0xd6d0,
    0x814d,
    0x814e,
    0xb7e1,
    0x814f,
    0xb4ae,
    0x8150,
    0xc1d9,
    0x8151,
    0xd8bc,
    0x8152,
    0xcde8,
    0xb5a4,
    0xceaa,
    0xd6f7,
    0x8153,
    0xc0f6,
    0xbed9,
    0xd8af,
    0x8154,
    0x8155,
    0x8156,
    0xc4cb,
    0x8157,
    0xbec3,
    0x8158,
    0xd8b1,
    0xc3b4,
    0xd2e5,
    0x8159,
    0xd6ae,
    0xceda,
    0xd5a7,
    0xbaf5,
    0xb7a6,
    0xc0d6,
    0x815a,
    0xc6b9,
    0xc5d2,
    0xc7c7,
    0x815b,
    0xb9d4,
    0x815c,
    0xb3cb,
    0xd2d2,
    0x815d,
    0x815e,
    0xd8bf,
    0xbec5,
    0xc6f2,
    0xd2b2,
    0xcfb0,
    0xcfe7,
    0x815f,
    0x8160,
    0x8161,
    0x8162,
    0xcae9,
    0x8163,
    0x8164,
    0xd8c0,
    0x8165,
    0x8166,
    0x8167,
    0x8168,
    0x8169,
    0x816a,
    0xc2f2,
    0xc2d2,
    0x816b,
    0xc8e9,
    0x816c,
    0x816d,
    0x816e,
    0x816f,
    0x8170,
    0x8171,
    0x8172,
    0x8173,
    0x8174,
    0x8175,
    0xc7ac,
    0x8176,
    0x8177,
    0x8178,
    0x8179,
    0x817a,
    0x817b,
    0x817c,
    0xc1cb,
    0x817d,
    0xd3e8,
    0xd5f9,
    0x817e,
    0xcac2,
    0xb6fe,
    0xd8a1,
    0xd3da,
    0xbff7,
    0x8180,
    0xd4c6,
    0xbba5,
    0xd8c1,
    0xcee5,
    0xbeae,
    0x8181,
    0x8182,
    0xd8a8,
    0x8183,
    0xd1c7,
    0xd0a9,
    0x8184,
    0x8185,
    0x8186,
    0xd8bd,
    0xd9ef,
    0xcdf6,
    0xbfba,
    0x8187,
    0xbdbb,
    0xbaa5,
    0xd2e0,
    0xb2fa,
    0xbae0,
    0xc4b6,
    0x8188,
    0xcfed,
    0xbea9,
    0xcda4,
    0xc1c1,
    0x8189,
    0x818a,
    0x818b,
    0xc7d7,
    0xd9f1,
    0x818c,
    0xd9f4,
    0x818d,
    0x818e,
    0x818f,
    0x8190,
    0xc8cb,
    0xd8e9,
    0x8191,
    0x8192,
    0x8193,
    0xd2da,
    0xcab2,
    0xc8ca,
    0xd8ec,
    0xd8ea,
    0xd8c6,
    0xbdf6,
    0xc6cd,
    0xb3f0,
    0x8194,
    0xd8eb,
    0xbdf1,
    0xbde9,
    0x8195,
    0xc8d4,
    0xb4d3,
    0x8196,
    0x8197,
    0xc2d8,
    0x8198,
    0xb2d6,
    0xd7d0,
    0xcacb,
    0xcbfb,
    0xd5cc,
    0xb8b6,
    0xcfc9,
    0x8199,
    0x819a,
    0x819b,
    0xd9da,
    0xd8f0,
    0xc7aa,
    0x819c,
    0xd8ee,
    0x819d,
    0xb4fa,
    0xc1ee,
    0xd2d4,
    0x819e,
    0x819f,
    0xd8ed,
    0x81a0,
    0xd2c7,
    0xd8ef,
    0xc3c7,
    0x81a1,
    0x81a2,
    0x81a3,
    0xd1f6,
    0x81a4,
    0xd6d9,
    0xd8f2,
    0x81a5,
    0xd8f5,
    0xbcfe,
    0xbcdb,
    0x81a6,
    0x81a7,
    0x81a8,
    0xc8ce,
    0x81a9,
    0xb7dd,
    0x81aa,
    0xb7c2
};
UINT16 cp936_UNI_a0x4f[] = {
    0x81ab,
    0xc6f3,
    0x81ac,
    0x81ad,
    0x81ae,
    0x81af,
    0x81b0,
    0x81b1,
    0x81b2,
    0xd8f8,
    0xd2c1,
    0x81b3,
    0x81b4,
    0xcee9,
    0xbcbf,
    0xb7fc,
    0xb7a5,
    0xd0dd,
    0x81b5,
    0x81b6,
    0x81b7,
    0x81b8,
    0x81b9,
    0xd6da,
    0xd3c5,
    0xbbef,
    0xbbe1,
    0xd8f1,
    0x81ba,
    0x81bb,
    0xc9a1,
    0xceb0,
    0xb4ab,
    0x81bc,
    0xd8f3,
    0x81bd,
    0xc9cb,
    0xd8f6,
    0xc2d7,
    0xd8f7,
    0x81be,
    0x81bf,
    0xceb1,
    0xd8f9,
    0x81c0,
    0x81c1,
    0x81c2,
    0xb2ae,
    0xb9c0,
    0x81c3,
    0xd9a3,
    0x81c4,
    0xb0e9,
    0x81c5,
    0xc1e6,
    0x81c6,
    0xc9ec,
    0x81c7,
    0xcbc5,
    0x81c8,
    0xcbc6,
    0xd9a4,
    0x81c9,
    0x81ca,
    0x81cb,
    0x81cc,
    0x81cd,
    0xb5e8,
    0x81ce,
    0x81cf,
    0xb5ab,
    0x81d0,
    0x81d1,
    0x81d2,
    0x81d3,
    0x81d4,
    0x81d5,
    0xcebb,
    0xb5cd,
    0xd7a1,
    0xd7f4,
    0xd3d3,
    0x81d6,
    0xcce5,
    0x81d7,
    0xbace,
    0x81d8,
    0xd9a2,
    0xd9dc,
    0xd3e0,
    0xd8fd,
    0xb7f0,
    0xd7f7,
    0xd8fe,
    0xd8fa,
    0xd9a1,
    0xc4e3,
    0x81d9,
    0x81da,
    0xd3b6,
    0xd8f4,
    0xd9dd,
    0x81db,
    0xd8fb,
    0x81dc,
    0xc5e5,
    0x81dd,
    0x81de,
    0xc0d0,
    0x81df,
    0x81e0,
    0xd1f0,
    0xb0db,
    0x81e1,
    0x81e2,
    0xbcd1,
    0xd9a6,
    0x81e3,
    0xd9a5,
    0x81e4,
    0x81e5,
    0x81e6,
    0x81e7,
    0xd9ac,
    0xd9ae,
    0x81e8,
    0xd9ab,
    0xcab9,
    0x81e9,
    0x81ea,
    0x81eb,
    0xd9a9,
    0xd6b6,
    0x81ec,
    0x81ed,
    0x81ee,
    0xb3de,
    0xd9a8,
    0x81ef,
    0xc0fd,
    0x81f0,
    0xcacc,
    0x81f1,
    0xd9aa,
    0x81f2,
    0xd9a7,
    0x81f3,
    0x81f4,
    0xd9b0,
    0x81f5,
    0x81f6,
    0xb6b1,
    0x81f7,
    0x81f8,
    0x81f9,
    0xb9a9,
    0x81fa,
    0xd2c0,
    0x81fb,
    0x81fc,
    0xcfc0,
    0x81fd,
    0x81fe,
    0xc2c2,
    0x8240,
    0xbdc4,
    0xd5ec,
    0xb2e0,
    0xc7c8,
    0xbfeb,
    0xd9ad,
    0x8241,
    0xd9af,
    0x8242,
    0xceea,
    0xbaee,
    0x8243,
    0x8244,
    0x8245,
    0x8246,
    0x8247,
    0xc7d6,
    0x8248,
    0x8249,
    0x824a,
    0x824b,
    0x824c,
    0x824d,
    0x824e,
    0x824f,
    0x8250,
    0xb1e3,
    0x8251,
    0x8252,
    0x8253,
    0xb4d9,
    0xb6ed,
    0xd9b4,
    0x8254,
    0x8255,
    0x8256,
    0x8257,
    0xbfa1,
    0x8258,
    0x8259,
    0x825a,
    0xd9de,
    0xc7ce,
    0xc0fe,
    0xd9b8,
    0x825b,
    0x825c,
    0x825d,
    0x825e,
    0x825f,
    0xcbd7,
    0xb7fd,
    0x8260,
    0xd9b5,
    0x8261,
    0xd9b7,
    0xb1a3,
    0xd3e1,
    0xd9b9,
    0x8262,
    0xd0c5,
    0x8263,
    0xd9b6,
    0x8264,
    0x8265,
    0xd9b1,
    0x8266,
    0xd9b2,
    0xc1a9,
    0xd9b3,
    0x8267,
    0x8268,
    0xbcf3,
    0xd0de,
    0xb8a9,
    0x8269,
    0xbee3,
    0x826a,
    0xd9bd,
    0x826b,
    0x826c,
    0x826d,
    0x826e,
    0xd9ba,
    0x826f,
    0xb0b3,
    0x8270,
    0x8271,
    0x8272,
    0xd9c2,
    0x8273
};
UINT16 cp936_UNI_a0x50[] = {
    0x8274,
    0x8275,
    0x8276,
    0x8277,
    0x8278,
    0x8279,
    0x827a,
    0x827b,
    0x827c,
    0x827d,
    0x827e,
    0x8280,
    0xd9c4,
    0xb1b6,
    0x8281,
    0xd9bf,
    0x8282,
    0x8283,
    0xb5b9,
    0x8284,
    0xbef3,
    0x8285,
    0x8286,
    0x8287,
    0xccc8,
    0xbaf2,
    0xd2d0,
    0x8288,
    0xd9c3,
    0x8289,
    0x828a,
    0xbde8,
    0x828b,
    0xb3ab,
    0x828c,
    0x828d,
    0x828e,
    0xd9c5,
    0xbeeb,
    0x828f,
    0xd9c6,
    0xd9bb,
    0xc4df,
    0x8290,
    0xd9be,
    0xd9c1,
    0xd9c0,
    0x8291,
    0x8292,
    0x8293,
    0x8294,
    0x8295,
    0x8296,
    0x8297,
    0x8298,
    0x8299,
    0x829a,
    0x829b,
    0xd5ae,
    0x829c,
    0xd6b5,
    0x829d,
    0xc7e3,
    0x829e,
    0x829f,
    0x82a0,
    0x82a1,
    0xd9c8,
    0x82a2,
    0x82a3,
    0x82a4,
    0xbcd9,
    0xd9ca,
    0x82a5,
    0x82a6,
    0x82a7,
    0xd9bc,
    0x82a8,
    0xd9cb,
    0xc6ab,
    0x82a9,
    0x82aa,
    0x82ab,
    0x82ac,
    0x82ad,
    0xd9c9,
    0x82ae,
    0x82af,
    0x82b0,
    0x82b1,
    0xd7f6,
    0x82b2,
    0xcda3,
    0x82b3,
    0x82b4,
    0x82b5,
    0x82b6,
    0x82b7,
    0x82b8,
    0x82b9,
    0x82ba,
    0xbda1,
    0x82bb,
    0x82bc,
    0x82bd,
    0x82be,
    0x82bf,
    0x82c0,
    0xd9cc,
    0x82c1,
    0x82c2,
    0x82c3,
    0x82c4,
    0x82c5,
    0x82c6,
    0x82c7,
    0x82c8,
    0x82c9,
    0xc5bc,
    0xcdb5,
    0x82ca,
    0x82cb,
    0x82cc,
    0xd9cd,
    0x82cd,
    0x82ce,
    0xd9c7,
    0xb3a5,
    0xbffe,
    0x82cf,
    0x82d0,
    0x82d1,
    0x82d2,
    0xb8b5,
    0x82d3,
    0x82d4,
    0xc0fc,
    0x82d5,
    0x82d6,
    0x82d7,
    0x82d8,
    0xb0f8,
    0x82d9,
    0x82da,
    0x82db,
    0x82dc,
    0x82dd,
    0x82de,
    0x82df,
    0x82e0,
    0x82e1,
    0x82e2,
    0x82e3,
    0x82e4,
    0x82e5,
    0x82e6,
    0x82e7,
    0x82e8,
    0x82e9,
    0x82ea,
    0x82eb,
    0x82ec,
    0x82ed,
    0xb4f6,
    0x82ee,
    0xd9ce,
    0x82ef,
    0xd9cf,
    0xb4a2,
    0xd9d0,
    0x82f0,
    0x82f1,
    0xb4df,
    0x82f2,
    0x82f3,
    0x82f4,
    0x82f5,
    0x82f6,
    0xb0c1,
    0x82f7,
    0x82f8,
    0x82f9,
    0x82fa,
    0x82fb,
    0x82fc,
    0x82fd,
    0xd9d1,
    0xc9b5,
    0x82fe,
    0x8340,
    0x8341,
    0x8342,
    0x8343,
    0x8344,
    0x8345,
    0x8346,
    0x8347,
    0x8348,
    0x8349,
    0x834a,
    0x834b,
    0x834c,
    0x834d,
    0x834e,
    0x834f,
    0x8350,
    0x8351,
    0xcff1,
    0x8352,
    0x8353,
    0x8354,
    0x8355,
    0x8356,
    0x8357,
    0xd9d2,
    0x8358,
    0x8359,
    0x835a,
    0xc1c5,
    0x835b,
    0x835c,
    0x835d,
    0x835e,
    0x835f,
    0x8360,
    0x8361,
    0x8362,
    0x8363,
    0x8364,
    0x8365,
    0xd9d6,
    0xc9ae,
    0x8366,
    0x8367,
    0x8368,
    0x8369,
    0xd9d5,
    0xd9d4,
    0xd9d7,
    0x836a,
    0x836b,
    0x836c,
    0x836d,
    0xcbdb,
    0x836e,
    0xbda9,
    0x836f,
    0x8370,
    0x8371,
    0x8372,
    0x8373,
    0xc6a7,
    0x8374,
    0x8375,
    0x8376,
    0x8377
};
UINT16 cp936_UNI_a0x51[] = {
    0x8378,
    0x8379,
    0x837a,
    0x837b,
    0x837c,
    0x837d,
    0xd9d3,
    0xd9d8,
    0x837e,
    0x8380,
    0x8381,
    0xd9d9,
    0x8382,
    0x8383,
    0x8384,
    0x8385,
    0x8386,
    0x8387,
    0xc8e5,
    0x8388,
    0x8389,
    0x838a,
    0x838b,
    0x838c,
    0x838d,
    0x838e,
    0x838f,
    0x8390,
    0x8391,
    0x8392,
    0x8393,
    0x8394,
    0x8395,
    0xc0dc,
    0x8396,
    0x8397,
    0x8398,
    0x8399,
    0x839a,
    0x839b,
    0x839c,
    0x839d,
    0x839e,
    0x839f,
    0x83a0,
    0x83a1,
    0x83a2,
    0x83a3,
    0x83a4,
    0x83a5,
    0x83a6,
    0x83a7,
    0x83a8,
    0x83a9,
    0x83aa,
    0x83ab,
    0x83ac,
    0x83ad,
    0x83ae,
    0x83af,
    0x83b0,
    0x83b1,
    0x83b2,
    0xb6f9,
    0xd8a3,
    0xd4ca,
    0x83b3,
    0xd4aa,
    0xd0d6,
    0xb3e4,
    0xd5d7,
    0x83b4,
    0xcfc8,
    0xb9e2,
    0x83b5,
    0xbfcb,
    0x83b6,
    0xc3e2,
    0x83b7,
    0x83b8,
    0x83b9,
    0xb6d2,
    0x83ba,
    0x83bb,
    0xcdc3,
    0xd9ee,
    0xd9f0,
    0x83bc,
    0x83bd,
    0x83be,
    0xb5b3,
    0x83bf,
    0xb6b5,
    0x83c0,
    0x83c1,
    0x83c2,
    0x83c3,
    0x83c4,
    0xbea4,
    0x83c5,
    0x83c6,
    0xc8eb,
    0x83c7,
    0x83c8,
    0xc8ab,
    0x83c9,
    0x83ca,
    0xb0cb,
    0xb9ab,
    0xc1f9,
    0xd9e2,
    0x83cb,
    0xc0bc,
    0xb9b2,
    0x83cc,
    0xb9d8,
    0xd0cb,
    0xb1f8,
    0xc6e4,
    0xbedf,
    0xb5e4,
    0xd7c8,
    0x83cd,
    0xd1f8,
    0xbce6,
    0xcade,
    0x83ce,
    0x83cf,
    0xbcbd,
    0xd9e6,
    0xd8e7,
    0x83d0,
    0x83d1,
    0xc4da,
    0x83d2,
    0x83d3,
    0xb8d4,
    0xc8bd,
    0x83d4,
    0x83d5,
    0xb2e1,
    0xd4d9,
    0x83d6,
    0x83d7,
    0x83d8,
    0x83d9,
    0xc3b0,
    0x83da,
    0x83db,
    0xc3e1,
    0xdaa2,
    0xc8df,
    0x83dc,
    0xd0b4,
    0x83dd,
    0xbefc,
    0xc5a9,
    0x83de,
    0x83df,
    0x83e0,
    0xb9da,
    0x83e1,
    0xdaa3,
    0x83e2,
    0xd4a9,
    0xdaa4,
    0x83e3,
    0x83e4,
    0x83e5,
    0x83e6,
    0x83e7,
    0xd9fb,
    0xb6ac,
    0x83e8,
    0x83e9,
    0xb7eb,
    0xb1f9,
    0xd9fc,
    0xb3e5,
    0xbef6,
    0x83ea,
    0xbff6,
    0xd2b1,
    0xc0e4,
    0x83eb,
    0x83ec,
    0x83ed,
    0xb6b3,
    0xd9fe,
    0xd9fd,
    0x83ee,
    0x83ef,
    0xbebb,
    0x83f0,
    0x83f1,
    0x83f2,
    0xc6e0,
    0x83f3,
    0xd7bc,
    0xdaa1,
    0x83f4,
    0xc1b9,
    0x83f5,
    0xb5f2,
    0xc1e8,
    0x83f6,
    0x83f7,
    0xbcf5,
    0x83f8,
    0xb4d5,
    0x83f9,
    0x83fa,
    0x83fb,
    0x83fc,
    0x83fd,
    0x83fe,
    0x8440,
    0x8441,
    0x8442,
    0xc1dd,
    0x8443,
    0xc4fd,
    0x8444,
    0x8445,
    0xbcb8,
    0xb7b2,
    0x8446,
    0x8447,
    0xb7ef,
    0x8448,
    0x8449,
    0x844a,
    0x844b,
    0x844c,
    0x844d,
    0xd9ec,
    0x844e,
    0xc6be,
    0x844f,
    0xbfad,
    0xbbcb,
    0x8450,
    0x8451,
    0xb5ca,
    0x8452,
    0xdbc9,
    0xd0d7,
    0x8453,
    0xcdb9,
    0xb0bc,
    0xb3f6,
    0xbbf7,
    0xdbca,
    0xbaaf,
    0x8454,
    0xd4e4
};
UINT16 cp936_UNI_a0x52[] = {
    0xb5b6,
    0xb5f3,
    0xd8d6,
    0xc8d0,
    0x8455,
    0x8456,
    0xb7d6,
    0xc7d0,
    0xd8d7,
    0x8457,
    0xbfaf,
    0x8458,
    0x8459,
    0xdbbb,
    0xd8d8,
    0x845a,
    0x845b,
    0xd0cc,
    0xbbae,
    0x845c,
    0x845d,
    0x845e,
    0xebbe,
    0xc1d0,
    0xc1f5,
    0xd4f2,
    0xb8d5,
    0xb4b4,
    0x845f,
    0xb3f5,
    0x8460,
    0x8461,
    0xc9be,
    0x8462,
    0x8463,
    0x8464,
    0xc5d0,
    0x8465,
    0x8466,
    0x8467,
    0xc5d9,
    0xc0fb,
    0x8468,
    0xb1f0,
    0x8469,
    0xd8d9,
    0xb9ce,
    0x846a,
    0xb5bd,
    0x846b,
    0x846c,
    0xd8da,
    0x846d,
    0x846e,
    0xd6c6,
    0xcba2,
    0xc8af,
    0xc9b2,
    0xb4cc,
    0xbfcc,
    0x846f,
    0xb9f4,
    0x8470,
    0xd8db,
    0xd8dc,
    0xb6e7,
    0xbcc1,
    0xccea,
    0x8471,
    0x8472,
    0x8473,
    0x8474,
    0x8475,
    0x8476,
    0xcff7,
    0x8477,
    0xd8dd,
    0xc7b0,
    0x8478,
    0x8479,
    0xb9d0,
    0xbda3,
    0x847a,
    0x847b,
    0xccde,
    0x847c,
    0xc6ca,
    0x847d,
    0x847e,
    0x8480,
    0x8481,
    0x8482,
    0xd8e0,
    0x8483,
    0xd8de,
    0x8484,
    0x8485,
    0xd8df,
    0x8486,
    0x8487,
    0x8488,
    0xb0fe,
    0x8489,
    0xbee7,
    0x848a,
    0xcaa3,
    0xbcf4,
    0x848b,
    0x848c,
    0x848d,
    0x848e,
    0xb8b1,
    0x848f,
    0x8490,
    0xb8ee,
    0x8491,
    0x8492,
    0x8493,
    0x8494,
    0x8495,
    0x8496,
    0x8497,
    0x8498,
    0x8499,
    0x849a,
    0xd8e2,
    0x849b,
    0xbdcb,
    0x849c,
    0xd8e4,
    0xd8e3,
    0x849d,
    0x849e,
    0x849f,
    0x84a0,
    0x84a1,
    0xc5fc,
    0x84a2,
    0x84a3,
    0x84a4,
    0x84a5,
    0x84a6,
    0x84a7,
    0x84a8,
    0xd8e5,
    0x84a9,
    0x84aa,
    0xd8e6,
    0x84ab,
    0x84ac,
    0x84ad,
    0x84ae,
    0x84af,
    0x84b0,
    0x84b1,
    0xc1a6,
    0x84b2,
    0xc8b0,
    0xb0ec,
    0xb9a6,
    0xbcd3,
    0xcef1,
    0xdbbd,
    0xc1d3,
    0x84b3,
    0x84b4,
    0x84b5,
    0x84b6,
    0xb6af,
    0xd6fa,
    0xc5ac,
    0xbdd9,
    0xdbbe,
    0xdbbf,
    0x84b7,
    0x84b8,
    0x84b9,
    0xc0f8,
    0xbea2,
    0xc0cd,
    0x84ba,
    0x84bb,
    0x84bc,
    0x84bd,
    0x84be,
    0x84bf,
    0x84c0,
    0x84c1,
    0x84c2,
    0x84c3,
    0xdbc0,
    0xcac6,
    0x84c4,
    0x84c5,
    0x84c6,
    0xb2aa,
    0x84c7,
    0x84c8,
    0x84c9,
    0xd3c2,
    0x84ca,
    0xc3e3,
    0x84cb,
    0xd1ab,
    0x84cc,
    0x84cd,
    0x84ce,
    0x84cf,
    0xdbc2,
    0x84d0,
    0xc0d5,
    0x84d1,
    0x84d2,
    0x84d3,
    0xdbc3,
    0x84d4,
    0xbfb1,
    0x84d5,
    0x84d6,
    0x84d7,
    0x84d8,
    0x84d9,
    0x84da,
    0xc4bc,
    0x84db,
    0x84dc,
    0x84dd,
    0x84de,
    0xc7da,
    0x84df,
    0x84e0,
    0x84e1,
    0x84e2,
    0x84e3,
    0x84e4,
    0x84e5,
    0x84e6,
    0x84e7,
    0x84e8,
    0x84e9,
    0xdbc4,
    0x84ea,
    0x84eb,
    0x84ec,
    0x84ed,
    0x84ee,
    0x84ef,
    0x84f0,
    0x84f1,
    0xd9e8,
    0xc9d7,
    0x84f2,
    0x84f3,
    0x84f4,
    0xb9b4,
    0xcef0
};
UINT16 cp936_UNI_a0x53[] = {
    0xd4c8,
    0x84f5,
    0x84f6,
    0x84f7,
    0x84f8,
    0xb0fc,
    0xb4d2,
    0x84f9,
    0xd0d9,
    0x84fa,
    0x84fb,
    0x84fc,
    0x84fd,
    0xd9e9,
    0x84fe,
    0xdecb,
    0xd9eb,
    0x8540,
    0x8541,
    0x8542,
    0x8543,
    0xd8b0,
    0xbbaf,
    0xb1b1,
    0x8544,
    0xb3d7,
    0xd8ce,
    0x8545,
    0x8546,
    0xd4d1,
    0x8547,
    0x8548,
    0xbdb3,
    0xbfef,
    0x8549,
    0xcfbb,
    0x854a,
    0x854b,
    0xd8d0,
    0x854c,
    0x854d,
    0x854e,
    0xb7cb,
    0x854f,
    0x8550,
    0x8551,
    0xd8d1,
    0x8552,
    0x8553,
    0x8554,
    0x8555,
    0x8556,
    0x8557,
    0x8558,
    0x8559,
    0x855a,
    0x855b,
    0xc6a5,
    0xc7f8,
    0xd2bd,
    0x855c,
    0x855d,
    0xd8d2,
    0xc4e4,
    0x855e,
    0xcaae,
    0x855f,
    0xc7a7,
    0x8560,
    0xd8a6,
    0x8561,
    0xc9fd,
    0xcee7,
    0xbbdc,
    0xb0eb,
    0x8562,
    0x8563,
    0x8564,
    0xbbaa,
    0xd0ad,
    0x8565,
    0xb1b0,
    0xd7e4,
    0xd7bf,
    0x8566,
    0xb5a5,
    0xc2f4,
    0xc4cf,
    0x8567,
    0x8568,
    0xb2a9,
    0x8569,
    0xb2b7,
    0x856a,
    0xb1e5,
    0xdfb2,
    0xd5bc,
    0xbfa8,
    0xc2ac,
    0xd8d5,
    0xc2b1,
    0x856b,
    0xd8d4,
    0xced4,
    0x856c,
    0xdae0,
    0x856d,
    0xcec0,
    0x856e,
    0x856f,
    0xd8b4,
    0xc3ae,
    0xd3a1,
    0xcea3,
    0x8570,
    0xbcb4,
    0xc8b4,
    0xc2d1,
    0x8571,
    0xbeed,
    0xd0b6,
    0x8572,
    0xdae1,
    0x8573,
    0x8574,
    0x8575,
    0x8576,
    0xc7e4,
    0x8577,
    0x8578,
    0xb3a7,
    0x8579,
    0xb6f2,
    0xccfc,
    0xc0fa,
    0x857a,
    0x857b,
    0xc0f7,
    0x857c,
    0xd1b9,
    0xd1e1,
    0xd8c7,
    0x857d,
    0x857e,
    0x8580,
    0x8581,
    0x8582,
    0x8583,
    0x8584,
    0xb2de,
    0x8585,
    0x8586,
    0xc0e5,
    0x8587,
    0xbaf1,
    0x8588,
    0x8589,
    0xd8c8,
    0x858a,
    0xd4ad,
    0x858b,
    0x858c,
    0xcfe1,
    0xd8c9,
    0x858d,
    0xd8ca,
    0xcfc3,
    0x858e,
    0xb3f8,
    0xbec7,
    0x858f,
    0x8590,
    0x8591,
    0x8592,
    0xd8cb,
    0x8593,
    0x8594,
    0x8595,
    0x8596,
    0x8597,
    0x8598,
    0x8599,
    0xdbcc,
    0x859a,
    0x859b,
    0x859c,
    0x859d,
    0xc8a5,
    0x859e,
    0x859f,
    0x85a0,
    0xcfd8,
    0x85a1,
    0xc8fe,
    0xb2ce,
    0x85a2,
    0x85a3,
    0x85a4,
    0x85a5,
    0x85a6,
    0xd3d6,
    0xb2e6,
    0xbcb0,
    0xd3d1,
    0xcbab,
    0xb7b4,
    0x85a7,
    0x85a8,
    0x85a9,
    0xb7a2,
    0x85aa,
    0x85ab,
    0xcae5,
    0x85ac,
    0xc8a1,
    0xcadc,
    0xb1e4,
    0xd0f0,
    0x85ad,
    0xc5d1,
    0x85ae,
    0x85af,
    0x85b0,
    0xdbc5,
    0xb5fe,
    0x85b1,
    0x85b2,
    0xbfda,
    0xb9c5,
    0xbee4,
    0xc1ed,
    0x85b3,
    0xdfb6,
    0xdfb5,
    0xd6bb,
    0xbdd0,
    0xd5d9,
    0xb0c8,
    0xb6a3,
    0xbfc9,
    0xcca8,
    0xdfb3,
    0xcab7,
    0xd3d2,
    0x85b4,
    0xd8cf,
    0xd2b6,
    0xbac5,
    0xcbbe,
    0xccbe,
    0x85b5,
    0xdfb7,
    0xb5f0,
    0xdfb4,
    0x85b6,
    0x85b7
};
UINT16 cp936_UNI_a0x54[] = {
    0x85b8,
    0xd3f5,
    0x85b9,
    0xb3d4,
    0xb8f7,
    0x85ba,
    0xdfba,
    0x85bb,
    0xbacf,
    0xbcaa,
    0xb5f5,
    0x85bc,
    0xcdac,
    0xc3fb,
    0xbaf3,
    0xc0f4,
    0xcdc2,
    0xcff2,
    0xdfb8,
    0xcfc5,
    0x85bd,
    0xc2c0,
    0xdfb9,
    0xc2f0,
    0x85be,
    0x85bf,
    0x85c0,
    0xbefd,
    0x85c1,
    0xc1df,
    0xcdcc,
    0xd2f7,
    0xb7cd,
    0xdfc1,
    0x85c2,
    0xdfc4,
    0x85c3,
    0x85c4,
    0xb7f1,
    0xb0c9,
    0xb6d6,
    0xb7d4,
    0x85c5,
    0xbaac,
    0xccfd,
    0xbfd4,
    0xcbb1,
    0xc6f4,
    0x85c6,
    0xd6a8,
    0xdfc5,
    0x85c7,
    0xcee2,
    0xb3b3,
    0x85c8,
    0x85c9,
    0xcefc,
    0xb4b5,
    0x85ca,
    0xcec7,
    0xbaf0,
    0x85cb,
    0xcee1,
    0x85cc,
    0xd1bd,
    0x85cd,
    0x85ce,
    0xdfc0,
    0x85cf,
    0x85d0,
    0xb4f4,
    0x85d1,
    0xb3ca,
    0x85d2,
    0xb8e6,
    0xdfbb,
    0x85d3,
    0x85d4,
    0x85d5,
    0x85d6,
    0xc4c5,
    0x85d7,
    0xdfbc,
    0xdfbd,
    0xdfbe,
    0xc5bb,
    0xdfbf,
    0xdfc2,
    0xd4b1,
    0xdfc3,
    0x85d8,
    0xc7ba,
    0xced8,
    0x85d9,
    0x85da,
    0x85db,
    0x85dc,
    0x85dd,
    0xc4d8,
    0x85de,
    0xdfca,
    0x85df,
    0xdfcf,
    0x85e0,
    0xd6dc,
    0x85e1,
    0x85e2,
    0x85e3,
    0x85e4,
    0x85e5,
    0x85e6,
    0x85e7,
    0x85e8,
    0xdfc9,
    0xdfda,
    0xceb6,
    0x85e9,
    0xbac7,
    0xdfce,
    0xdfc8,
    0xc5de,
    0x85ea,
    0x85eb,
    0xc9eb,
    0xbaf4,
    0xc3fc,
    0x85ec,
    0x85ed,
    0xbed7,
    0x85ee,
    0xdfc6,
    0x85ef,
    0xdfcd,
    0x85f0,
    0xc5d8,
    0x85f1,
    0x85f2,
    0x85f3,
    0x85f4,
    0xd5a6,
    0xbacd,
    0x85f5,
    0xbecc,
    0xd3bd,
    0xb8c0,
    0x85f6,
    0xd6e4,
    0x85f7,
    0xdfc7,
    0xb9be,
    0xbfa7,
    0x85f8,
    0x85f9,
    0xc1fc,
    0xdfcb,
    0xdfcc,
    0x85fa,
    0xdfd0,
    0x85fb,
    0x85fc,
    0x85fd,
    0x85fe,
    0x8640,
    0xdfdb,
    0xdfe5,
    0x8641,
    0xdfd7,
    0xdfd6,
    0xd7c9,
    0xdfe3,
    0xdfe4,
    0xe5eb,
    0xd2a7,
    0xdfd2,
    0x8642,
    0xbfa9,
    0x8643,
    0xd4db,
    0x8644,
    0xbfc8,
    0xdfd4,
    0x8645,
    0x8646,
    0x8647,
    0xcfcc,
    0x8648,
    0x8649,
    0xdfdd,
    0x864a,
    0xd1ca,
    0x864b,
    0xdfde,
    0xb0a7,
    0xc6b7,
    0xdfd3,
    0x864c,
    0xbae5,
    0x864d,
    0xb6df,
    0xcddb,
    0xb9fe,
    0xd4d5,
    0x864e,
    0x864f,
    0xdfdf,
    0xcfec,
    0xb0a5,
    0xdfe7,
    0xdfd1,
    0xd1c6,
    0xdfd5,
    0xdfd8,
    0xdfd9,
    0xdfdc,
    0x8650,
    0xbba9,
    0x8651,
    0xdfe0,
    0xdfe1,
    0x8652,
    0xdfe2,
    0xdfe6,
    0xdfe8,
    0xd3b4,
    0x8653,
    0x8654,
    0x8655,
    0x8656,
    0x8657,
    0xb8e7,
    0xc5b6,
    0xdfea,
    0xc9da,
    0xc1a8,
    0xc4c4,
    0x8658,
    0x8659,
    0xbfde,
    0xcff8,
    0x865a,
    0x865b,
    0x865c,
    0xd5dc,
    0xdfee,
    0x865d,
    0x865e,
    0x865f,
    0x8660,
    0x8661,
    0x8662,
    0xb2b8,
    0x8663,
    0xbadf,
    0xdfec,
    0x8664,
    0xdbc1
};
UINT16 cp936_UNI_a0x55[] = {
    0x8665,
    0xd1e4,
    0x8666,
    0x8667,
    0x8668,
    0x8669,
    0xcbf4,
    0xb4bd,
    0x866a,
    0xb0a6,
    0x866b,
    0x866c,
    0x866d,
    0x866e,
    0x866f,
    0xdff1,
    0xccc6,
    0xdff2,
    0x8670,
    0x8671,
    0xdfed,
    0x8672,
    0x8673,
    0x8674,
    0x8675,
    0x8676,
    0x8677,
    0xdfe9,
    0x8678,
    0x8679,
    0x867a,
    0x867b,
    0xdfeb,
    0x867c,
    0xdfef,
    0xdff0,
    0xbbbd,
    0x867d,
    0x867e,
    0xdff3,
    0x8680,
    0x8681,
    0xdff4,
    0x8682,
    0xbba3,
    0x8683,
    0xcadb,
    0xcea8,
    0xe0a7,
    0xb3aa,
    0x8684,
    0xe0a6,
    0x8685,
    0x8686,
    0x8687,
    0xe0a1,
    0x8688,
    0x8689,
    0x868a,
    0x868b,
    0xdffe,
    0x868c,
    0xcdd9,
    0xdffc,
    0x868d,
    0xdffa,
    0x868e,
    0xbfd0,
    0xd7c4,
    0x868f,
    0xc9cc,
    0x8690,
    0x8691,
    0xdff8,
    0xb0a1,
    0x8692,
    0x8693,
    0x8694,
    0x8695,
    0x8696,
    0xdffd,
    0x8697,
    0x8698,
    0x8699,
    0x869a,
    0xdffb,
    0xe0a2,
    0x869b,
    0x869c,
    0x869d,
    0x869e,
    0x869f,
    0xe0a8,
    0x86a0,
    0x86a1,
    0x86a2,
    0x86a3,
    0xb7c8,
    0x86a4,
    0x86a5,
    0xc6a1,
    0xc9b6,
    0xc0b2,
    0xdff5,
    0x86a6,
    0x86a7,
    0xc5be,
    0x86a8,
    0xd8c4,
    0xdff9,
    0xc4f6,
    0x86a9,
    0x86aa,
    0x86ab,
    0x86ac,
    0x86ad,
    0x86ae,
    0xe0a3,
    0xe0a4,
    0xe0a5,
    0xd0a5,
    0x86af,
    0x86b0,
    0xe0b4,
    0xcce4,
    0x86b1,
    0xe0b1,
    0x86b2,
    0xbfa6,
    0xe0af,
    0xceb9,
    0xe0ab,
    0xc9c6,
    0x86b3,
    0x86b4,
    0xc0ae,
    0xe0ae,
    0xbaed,
    0xbab0,
    0xe0a9,
    0x86b5,
    0x86b6,
    0x86b7,
    0xdff6,
    0x86b8,
    0xe0b3,
    0x86b9,
    0x86ba,
    0xe0b8,
    0x86bb,
    0x86bc,
    0x86bd,
    0xb4ad,
    0xe0b9,
    0x86be,
    0x86bf,
    0xcfb2,
    0xbac8,
    0x86c0,
    0xe0b0,
    0x86c1,
    0x86c2,
    0x86c3,
    0x86c4,
    0x86c5,
    0x86c6,
    0x86c7,
    0xd0fa,
    0x86c8,
    0x86c9,
    0x86ca,
    0x86cb,
    0x86cc,
    0x86cd,
    0x86ce,
    0x86cf,
    0x86d0,
    0xe0ac,
    0x86d1,
    0xd4fb,
    0x86d2,
    0xdff7,
    0x86d3,
    0xc5e7,
    0x86d4,
    0xe0ad,
    0x86d5,
    0xd3f7,
    0x86d6,
    0xe0b6,
    0xe0b7,
    0x86d7,
    0x86d8,
    0x86d9,
    0x86da,
    0x86db,
    0xe0c4,
    0xd0e1,
    0x86dc,
    0x86dd,
    0x86de,
    0xe0bc,
    0x86df,
    0x86e0,
    0xe0c9,
    0xe0ca,
    0x86e1,
    0x86e2,
    0x86e3,
    0xe0be,
    0xe0aa,
    0xc9a4,
    0xe0c1,
    0x86e4,
    0xe0b2,
    0x86e5,
    0x86e6,
    0x86e7,
    0x86e8,
    0x86e9,
    0xcac8,
    0xe0c3,
    0x86ea,
    0xe0b5,
    0x86eb,
    0xcecb,
    0x86ec,
    0xcbc3,
    0xe0cd,
    0xe0c6,
    0xe0c2,
    0x86ed,
    0xe0cb,
    0x86ee,
    0xe0ba,
    0xe0bf,
    0xe0c0,
    0x86ef,
    0x86f0,
    0xe0c5,
    0x86f1,
    0x86f2,
    0xe0c7,
    0xe0c8,
    0x86f3,
    0xe0cc,
    0x86f4,
    0xe0bb,
    0x86f5,
    0x86f6,
    0x86f7,
    0x86f8,
    0x86f9,
    0xcbd4,
    0xe0d5,
    0x86fa
};
UINT16 cp936_UNI_a0x56[] = {
    0xe0d6,
    0xe0d2,
    0x86fb,
    0x86fc,
    0x86fd,
    0x86fe,
    0x8740,
    0x8741,
    0xe0d0,
    0xbcce,
    0x8742,
    0x8743,
    0xe0d1,
    0x8744,
    0xb8c2,
    0xd8c5,
    0x8745,
    0x8746,
    0x8747,
    0x8748,
    0x8749,
    0x874a,
    0x874b,
    0x874c,
    0xd0ea,
    0x874d,
    0x874e,
    0xc2ef,
    0x874f,
    0x8750,
    0xe0cf,
    0xe0bd,
    0x8751,
    0x8752,
    0x8753,
    0xe0d4,
    0xe0d3,
    0x8754,
    0x8755,
    0xe0d7,
    0x8756,
    0x8757,
    0x8758,
    0x8759,
    0xe0dc,
    0xe0d8,
    0x875a,
    0x875b,
    0x875c,
    0xd6f6,
    0xb3b0,
    0x875d,
    0xd7ec,
    0x875e,
    0xcbbb,
    0x875f,
    0x8760,
    0xe0da,
    0x8761,
    0xcefb,
    0x8762,
    0x8763,
    0x8764,
    0xbad9,
    0x8765,
    0x8766,
    0x8767,
    0x8768,
    0x8769,
    0x876a,
    0x876b,
    0x876c,
    0x876d,
    0x876e,
    0x876f,
    0x8770,
    0xe0e1,
    0xe0dd,
    0xd2ad,
    0x8771,
    0x8772,
    0x8773,
    0x8774,
    0x8775,
    0xe0e2,
    0x8776,
    0x8777,
    0xe0db,
    0xe0d9,
    0xe0df,
    0x8778,
    0x8779,
    0xe0e0,
    0x877a,
    0x877b,
    0x877c,
    0x877d,
    0x877e,
    0xe0de,
    0x8780,
    0xe0e4,
    0x8781,
    0x8782,
    0x8783,
    0xc6f7,
    0xd8ac,
    0xd4eb,
    0xe0e6,
    0xcac9,
    0x8784,
    0x8785,
    0x8786,
    0x8787,
    0xe0e5,
    0x8788,
    0x8789,
    0x878a,
    0x878b,
    0xb8c1,
    0x878c,
    0x878d,
    0x878e,
    0x878f,
    0xe0e7,
    0xe0e8,
    0x8790,
    0x8791,
    0x8792,
    0x8793,
    0x8794,
    0x8795,
    0x8796,
    0x8797,
    0xe0e9,
    0xe0e3,
    0x8798,
    0x8799,
    0x879a,
    0x879b,
    0x879c,
    0x879d,
    0x879e,
    0xbabf,
    0xcce7,
    0x879f,
    0x87a0,
    0x87a1,
    0xe0ea,
    0x87a2,
    0x87a3,
    0x87a4,
    0x87a5,
    0x87a6,
    0x87a7,
    0x87a8,
    0x87a9,
    0x87aa,
    0x87ab,
    0x87ac,
    0x87ad,
    0x87ae,
    0x87af,
    0x87b0,
    0xcff9,
    0x87b1,
    0x87b2,
    0x87b3,
    0x87b4,
    0x87b5,
    0x87b6,
    0x87b7,
    0x87b8,
    0x87b9,
    0x87ba,
    0x87bb,
    0xe0eb,
    0x87bc,
    0x87bd,
    0x87be,
    0x87bf,
    0x87c0,
    0x87c1,
    0x87c2,
    0xc8c2,
    0x87c3,
    0x87c4,
    0x87c5,
    0x87c6,
    0xbdc0,
    0x87c7,
    0x87c8,
    0x87c9,
    0x87ca,
    0x87cb,
    0x87cc,
    0x87cd,
    0x87ce,
    0x87cf,
    0x87d0,
    0x87d1,
    0x87d2,
    0x87d3,
    0xc4d2,
    0x87d4,
    0x87d5,
    0x87d6,
    0x87d7,
    0x87d8,
    0x87d9,
    0x87da,
    0x87db,
    0x87dc,
    0xe0ec,
    0x87dd,
    0x87de,
    0xe0ed,
    0x87df,
    0x87e0,
    0xc7f4,
    0xcbc4,
    0x87e1,
    0xe0ee,
    0xbbd8,
    0xd8b6,
    0xd2f2,
    0xe0ef,
    0xcdc5,
    0x87e2,
    0xb6da,
    0x87e3,
    0x87e4,
    0x87e5,
    0x87e6,
    0x87e7,
    0x87e8,
    0xe0f1,
    0x87e9,
    0xd4b0,
    0x87ea,
    0x87eb,
    0xc0a7,
    0xb4d1,
    0x87ec,
    0x87ed,
    0xcea7,
    0xe0f0,
    0x87ee,
    0x87ef,
    0x87f0,
    0xe0f2,
    0xb9cc,
    0x87f1,
    0x87f2,
    0xb9fa,
    0xcdbc,
    0xe0f3
};
UINT16 cp936_UNI_a0x57[] = {
    0x87f3,
    0x87f4,
    0x87f5,
    0xc6d4,
    0xe0f4,
    0x87f6,
    0xd4b2,
    0x87f7,
    0xc8a6,
    0xe0f6,
    0xe0f5,
    0x87f8,
    0x87f9,
    0x87fa,
    0x87fb,
    0x87fc,
    0x87fd,
    0x87fe,
    0x8840,
    0x8841,
    0x8842,
    0x8843,
    0x8844,
    0x8845,
    0x8846,
    0x8847,
    0x8848,
    0x8849,
    0xe0f7,
    0x884a,
    0x884b,
    0xcdc1,
    0x884c,
    0x884d,
    0x884e,
    0xcaa5,
    0x884f,
    0x8850,
    0x8851,
    0x8852,
    0xd4da,
    0xdbd7,
    0xdbd9,
    0x8853,
    0xdbd8,
    0xb9e7,
    0xdbdc,
    0xdbdd,
    0xb5d8,
    0x8854,
    0x8855,
    0xdbda,
    0x8856,
    0x8857,
    0x8858,
    0x8859,
    0x885a,
    0xdbdb,
    0xb3a1,
    0xdbdf,
    0x885b,
    0x885c,
    0xbbf8,
    0x885d,
    0xd6b7,
    0x885e,
    0xdbe0,
    0x885f,
    0x8860,
    0x8861,
    0x8862,
    0xbef9,
    0x8863,
    0x8864,
    0xb7bb,
    0x8865,
    0xdbd0,
    0xccae,
    0xbfb2,
    0xbbb5,
    0xd7f8,
    0xbfd3,
    0x8866,
    0x8867,
    0x8868,
    0x8869,
    0x886a,
    0xbfe9,
    0x886b,
    0x886c,
    0xbce1,
    0xccb3,
    0xdbde,
    0xb0d3,
    0xceeb,
    0xb7d8,
    0xd7b9,
    0xc6c2,
    0x886d,
    0x886e,
    0xc0a4,
    0x886f,
    0xccb9,
    0x8870,
    0xdbe7,
    0xdbe1,
    0xc6ba,
    0xdbe3,
    0x8871,
    0xdbe8,
    0x8872,
    0xc5f7,
    0x8873,
    0x8874,
    0x8875,
    0xdbea,
    0x8876,
    0x8877,
    0xdbe9,
    0xbfc0,
    0x8878,
    0x8879,
    0x887a,
    0xdbe6,
    0xdbe5,
    0x887b,
    0x887c,
    0x887d,
    0x887e,
    0x8880,
    0xb4b9,
    0xc0ac,
    0xc2a2,
    0xdbe2,
    0xdbe4,
    0x8881,
    0x8882,
    0x8883,
    0x8884,
    0xd0cd,
    0xdbed,
    0x8885,
    0x8886,
    0x8887,
    0x8888,
    0x8889,
    0xc0dd,
    0xdbf2,
    0x888a,
    0x888b,
    0x888c,
    0x888d,
    0x888e,
    0x888f,
    0x8890,
    0xb6e2,
    0x8891,
    0x8892,
    0x8893,
    0x8894,
    0xdbf3,
    0xdbd2,
    0xb9b8,
    0xd4ab,
    0xdbec,
    0x8895,
    0xbfd1,
    0xdbf0,
    0x8896,
    0xdbd1,
    0x8897,
    0xb5e6,
    0x8898,
    0xdbeb,
    0xbfe5,
    0x8899,
    0x889a,
    0x889b,
    0xdbee,
    0x889c,
    0xdbf1,
    0x889d,
    0x889e,
    0x889f,
    0xdbf9,
    0x88a0,
    0x88a1,
    0x88a2,
    0x88a3,
    0x88a4,
    0x88a5,
    0x88a6,
    0x88a7,
    0x88a8,
    0xb9a1,
    0xb0a3,
    0x88a9,
    0x88aa,
    0x88ab,
    0x88ac,
    0x88ad,
    0x88ae,
    0x88af,
    0xc2f1,
    0x88b0,
    0x88b1,
    0xb3c7,
    0xdbef,
    0x88b2,
    0x88b3,
    0xdbf8,
    0x88b4,
    0xc6d2,
    0xdbf4,
    0x88b5,
    0x88b6,
    0xdbf5,
    0xdbf7,
    0xdbf6,
    0x88b7,
    0x88b8,
    0xdbfe,
    0x88b9,
    0xd3f2,
    0xb2ba,
    0x88ba,
    0x88bb,
    0x88bc,
    0xdbfd,
    0x88bd,
    0x88be,
    0x88bf,
    0x88c0,
    0x88c1,
    0x88c2,
    0x88c3,
    0x88c4,
    0xdca4,
    0x88c5,
    0xdbfb,
    0x88c6,
    0x88c7,
    0x88c8,
    0x88c9,
    0xdbfa,
    0x88ca,
    0x88cb,
    0x88cc,
    0xdbfc,
    0xc5e0,
    0xbbf9,
    0x88cd,
    0x88ce,
    0xdca3,
    0x88cf,
    0x88d0
};
UINT16 cp936_UNI_a0x58[] = {
    0xdca5,
    0x88d1,
    0xccc3,
    0x88d2,
    0x88d3,
    0x88d4,
    0xb6d1,
    0xddc0,
    0x88d5,
    0x88d6,
    0x88d7,
    0xdca1,
    0x88d8,
    0xdca2,
    0x88d9,
    0x88da,
    0x88db,
    0xc7b5,
    0x88dc,
    0x88dd,
    0x88de,
    0xb6e9,
    0x88df,
    0x88e0,
    0x88e1,
    0xdca7,
    0x88e2,
    0x88e3,
    0x88e4,
    0x88e5,
    0xdca6,
    0x88e6,
    0xdca9,
    0xb1a4,
    0x88e7,
    0x88e8,
    0xb5cc,
    0x88e9,
    0x88ea,
    0x88eb,
    0x88ec,
    0x88ed,
    0xbfb0,
    0x88ee,
    0x88ef,
    0x88f0,
    0x88f1,
    0x88f2,
    0xd1df,
    0x88f3,
    0x88f4,
    0x88f5,
    0x88f6,
    0xb6c2,
    0x88f7,
    0x88f8,
    0x88f9,
    0x88fa,
    0x88fb,
    0x88fc,
    0x88fd,
    0x88fe,
    0x8940,
    0x8941,
    0x8942,
    0x8943,
    0x8944,
    0x8945,
    0xdca8,
    0x8946,
    0x8947,
    0x8948,
    0x8949,
    0x894a,
    0x894b,
    0x894c,
    0xcbfa,
    0xebf3,
    0x894d,
    0x894e,
    0x894f,
    0xcbdc,
    0x8950,
    0x8951,
    0xcbfe,
    0x8952,
    0x8953,
    0x8954,
    0xccc1,
    0x8955,
    0x8956,
    0x8957,
    0x8958,
    0x8959,
    0xc8fb,
    0x895a,
    0x895b,
    0x895c,
    0x895d,
    0x895e,
    0x895f,
    0xdcaa,
    0x8960,
    0x8961,
    0x8962,
    0x8963,
    0x8964,
    0xccee,
    0xdcab,
    0x8965,
    0x8966,
    0x8967,
    0x8968,
    0x8969,
    0x896a,
    0x896b,
    0x896c,
    0x896d,
    0x896e,
    0x896f,
    0x8970,
    0x8971,
    0x8972,
    0x8973,
    0x8974,
    0x8975,
    0xdbd3,
    0x8976,
    0xdcaf,
    0xdcac,
    0x8977,
    0xbeb3,
    0x8978,
    0xcafb,
    0x8979,
    0x897a,
    0x897b,
    0xdcad,
    0x897c,
    0x897d,
    0x897e,
    0x8980,
    0x8981,
    0x8982,
    0x8983,
    0x8984,
    0xc9ca,
    0xc4b9,
    0x8985,
    0x8986,
    0x8987,
    0x8988,
    0x8989,
    0xc7bd,
    0xdcae,
    0x898a,
    0x898b,
    0x898c,
    0xd4f6,
    0xd0e6,
    0x898d,
    0x898e,
    0x898f,
    0x8990,
    0x8991,
    0x8992,
    0x8993,
    0x8994,
    0xc4ab,
    0xb6d5,
    0x8995,
    0x8996,
    0x8997,
    0x8998,
    0x8999,
    0x899a,
    0x899b,
    0x899c,
    0x899d,
    0x899e,
    0x899f,
    0x89a0,
    0x89a1,
    0x89a2,
    0x89a3,
    0x89a4,
    0x89a5,
    0x89a6,
    0xdbd4,
    0x89a7,
    0x89a8,
    0x89a9,
    0x89aa,
    0xb1da,
    0x89ab,
    0x89ac,
    0x89ad,
    0xdbd5,
    0x89ae,
    0x89af,
    0x89b0,
    0x89b1,
    0x89b2,
    0x89b3,
    0x89b4,
    0x89b5,
    0x89b6,
    0x89b7,
    0x89b8,
    0xdbd6,
    0x89b9,
    0x89ba,
    0x89bb,
    0xbabe,
    0x89bc,
    0x89bd,
    0x89be,
    0x89bf,
    0x89c0,
    0x89c1,
    0x89c2,
    0x89c3,
    0x89c4,
    0x89c5,
    0x89c6,
    0x89c7,
    0x89c8,
    0x89c9,
    0xc8c0,
    0x89ca,
    0x89cb,
    0x89cc,
    0x89cd,
    0x89ce,
    0x89cf,
    0xcabf,
    0xc8c9,
    0x89d0,
    0xd7b3,
    0x89d1,
    0xc9f9,
    0x89d2,
    0x89d3,
    0xbfc7,
    0x89d4,
    0x89d5,
    0xbaf8,
    0x89d6,
    0x89d7,
    0xd2bc,
    0x89d8,
    0x89d9,
    0x89da,
    0x89db,
    0x89dc,
    0x89dd
};
UINT16 cp936_UNI_a0x59[] = {
    0x89de,
    0x89df,
    0xe2ba,
    0x89e0,
    0xb4a6,
    0x89e1,
    0x89e2,
    0xb1b8,
    0x89e3,
    0x89e4,
    0x89e5,
    0x89e6,
    0x89e7,
    0xb8b4,
    0x89e8,
    0xcfc4,
    0x89e9,
    0x89ea,
    0x89eb,
    0x89ec,
    0xd9e7,
    0xcfa6,
    0xcde2,
    0x89ed,
    0x89ee,
    0xd9ed,
    0xb6e0,
    0x89ef,
    0xd2b9,
    0x89f0,
    0x89f1,
    0xb9bb,
    0x89f2,
    0x89f3,
    0x89f4,
    0x89f5,
    0xe2b9,
    0xe2b7,
    0x89f6,
    0xb4f3,
    0x89f7,
    0xccec,
    0xccab,
    0xb7f2,
    0x89f8,
    0xd8b2,
    0xd1eb,
    0xbabb,
    0x89f9,
    0xcaa7,
    0x89fa,
    0x89fb,
    0xcdb7,
    0x89fc,
    0x89fd,
    0xd2c4,
    0xbfe4,
    0xbcd0,
    0xb6e1,
    0x89fe,
    0xdec5,
    0x8a40,
    0x8a41,
    0x8a42,
    0x8a43,
    0xdec6,
    0xdbbc,
    0x8a44,
    0xd1d9,
    0x8a45,
    0x8a46,
    0xc6e6,
    0xc4ce,
    0xb7ee,
    0x8a47,
    0xb7dc,
    0x8a48,
    0x8a49,
    0xbffc,
    0xd7e0,
    0x8a4a,
    0xc6f5,
    0x8a4b,
    0x8a4c,
    0xb1bc,
    0xdec8,
    0xbdb1,
    0xccd7,
    0xdeca,
    0x8a4d,
    0xdec9,
    0x8a4e,
    0x8a4f,
    0x8a50,
    0x8a51,
    0x8a52,
    0xb5ec,
    0x8a53,
    0xc9dd,
    0x8a54,
    0x8a55,
    0xb0c2,
    0x8a56,
    0x8a57,
    0x8a58,
    0x8a59,
    0x8a5a,
    0x8a5b,
    0x8a5c,
    0x8a5d,
    0x8a5e,
    0x8a5f,
    0x8a60,
    0x8a61,
    0x8a62,
    0xc5ae,
    0xc5ab,
    0x8a63,
    0xc4cc,
    0x8a64,
    0xbce9,
    0xcbfd,
    0x8a65,
    0x8a66,
    0x8a67,
    0xbac3,
    0x8a68,
    0x8a69,
    0x8a6a,
    0xe5f9,
    0xc8e7,
    0xe5fa,
    0xcdfd,
    0x8a6b,
    0xd7b1,
    0xb8be,
    0xc2e8,
    0x8a6c,
    0xc8d1,
    0x8a6d,
    0x8a6e,
    0xe5fb,
    0x8a6f,
    0x8a70,
    0x8a71,
    0x8a72,
    0xb6ca,
    0xbccb,
    0x8a73,
    0x8a74,
    0xd1fd,
    0xe6a1,
    0x8a75,
    0xc3ee,
    0x8a76,
    0x8a77,
    0x8a78,
    0x8a79,
    0xe6a4,
    0x8a7a,
    0x8a7b,
    0x8a7c,
    0x8a7d,
    0xe5fe,
    0xe6a5,
    0xcdd7,
    0x8a7e,
    0x8a80,
    0xb7c1,
    0xe5fc,
    0xe5fd,
    0xe6a3,
    0x8a81,
    0x8a82,
    0xc4dd,
    0xe6a8,
    0x8a83,
    0x8a84,
    0xe6a7,
    0x8a85,
    0x8a86,
    0x8a87,
    0x8a88,
    0x8a89,
    0x8a8a,
    0xc3c3,
    0x8a8b,
    0xc6de,
    0x8a8c,
    0x8a8d,
    0xe6aa,
    0x8a8e,
    0x8a8f,
    0x8a90,
    0x8a91,
    0x8a92,
    0x8a93,
    0x8a94,
    0xc4b7,
    0x8a95,
    0x8a96,
    0x8a97,
    0xe6a2,
    0xcabc,
    0x8a98,
    0x8a99,
    0x8a9a,
    0x8a9b,
    0xbde3,
    0xb9c3,
    0xe6a6,
    0xd0d5,
    0xceaf,
    0x8a9c,
    0x8a9d,
    0xe6a9,
    0xe6b0,
    0x8a9e,
    0xd2a6,
    0x8a9f,
    0xbdaa,
    0xe6ad,
    0x8aa0,
    0x8aa1,
    0x8aa2,
    0x8aa3,
    0x8aa4,
    0xe6af,
    0x8aa5,
    0xc0d1,
    0x8aa6,
    0x8aa7,
    0xd2cc,
    0x8aa8,
    0x8aa9,
    0x8aaa,
    0xbca7,
    0x8aab,
    0x8aac,
    0x8aad,
    0x8aae,
    0x8aaf,
    0x8ab0,
    0x8ab1,
    0x8ab2,
    0x8ab3,
    0x8ab4,
    0x8ab5,
    0x8ab6,
    0xe6b1,
    0x8ab7,
    0xd2f6,
    0x8ab8,
    0x8ab9,
    0x8aba,
    0xd7cb
};
UINT16 cp936_UNI_a0x5a[] = {
    0x8abb,
    0xcdfe,
    0x8abc,
    0xcdde,
    0xc2a6,
    0xe6ab,
    0xe6ac,
    0xbdbf,
    0xe6ae,
    0xe6b3,
    0x8abd,
    0x8abe,
    0xe6b2,
    0x8abf,
    0x8ac0,
    0x8ac1,
    0x8ac2,
    0xe6b6,
    0x8ac3,
    0xe6b8,
    0x8ac4,
    0x8ac5,
    0x8ac6,
    0x8ac7,
    0xc4ef,
    0x8ac8,
    0x8ac9,
    0x8aca,
    0xc4c8,
    0x8acb,
    0x8acc,
    0xbeea,
    0xc9ef,
    0x8acd,
    0x8ace,
    0xe6b7,
    0x8acf,
    0xb6f0,
    0x8ad0,
    0x8ad1,
    0x8ad2,
    0xc3e4,
    0x8ad3,
    0x8ad4,
    0x8ad5,
    0x8ad6,
    0x8ad7,
    0x8ad8,
    0x8ad9,
    0xd3e9,
    0xe6b4,
    0x8ada,
    0xe6b5,
    0x8adb,
    0xc8a2,
    0x8adc,
    0x8add,
    0x8ade,
    0x8adf,
    0x8ae0,
    0xe6bd,
    0x8ae1,
    0x8ae2,
    0x8ae3,
    0xe6b9,
    0x8ae4,
    0x8ae5,
    0x8ae6,
    0x8ae7,
    0x8ae8,
    0xc6c5,
    0x8ae9,
    0x8aea,
    0xcdf1,
    0xe6bb,
    0x8aeb,
    0x8aec,
    0x8aed,
    0x8aee,
    0x8aef,
    0x8af0,
    0x8af1,
    0x8af2,
    0x8af3,
    0x8af4,
    0xe6bc,
    0x8af5,
    0x8af6,
    0x8af7,
    0x8af8,
    0xbbe9,
    0x8af9,
    0x8afa,
    0x8afb,
    0x8afc,
    0x8afd,
    0x8afe,
    0x8b40,
    0xe6be,
    0x8b41,
    0x8b42,
    0x8b43,
    0x8b44,
    0xe6ba,
    0x8b45,
    0x8b46,
    0xc0b7,
    0x8b47,
    0x8b48,
    0x8b49,
    0x8b4a,
    0x8b4b,
    0x8b4c,
    0x8b4d,
    0x8b4e,
    0x8b4f,
    0xd3a4,
    0xe6bf,
    0xc9f4,
    0xe6c3,
    0x8b50,
    0x8b51,
    0xe6c4,
    0x8b52,
    0x8b53,
    0x8b54,
    0x8b55,
    0xd0f6,
    0x8b56,
    0x8b57,
    0x8b58,
    0x8b59,
    0x8b5a,
    0x8b5b,
    0x8b5c,
    0x8b5d,
    0x8b5e,
    0x8b5f,
    0x8b60,
    0x8b61,
    0x8b62,
    0x8b63,
    0x8b64,
    0x8b65,
    0x8b66,
    0x8b67,
    0xc3bd,
    0x8b68,
    0x8b69,
    0x8b6a,
    0x8b6b,
    0x8b6c,
    0x8b6d,
    0x8b6e,
    0xc3c4,
    0xe6c2,
    0x8b6f,
    0x8b70,
    0x8b71,
    0x8b72,
    0x8b73,
    0x8b74,
    0x8b75,
    0x8b76,
    0x8b77,
    0x8b78,
    0x8b79,
    0x8b7a,
    0x8b7b,
    0x8b7c,
    0xe6c1,
    0x8b7d,
    0x8b7e,
    0x8b80,
    0x8b81,
    0x8b82,
    0x8b83,
    0x8b84,
    0xe6c7,
    0xcfb1,
    0x8b85,
    0xebf4,
    0x8b86,
    0x8b87,
    0xe6ca,
    0x8b88,
    0x8b89,
    0x8b8a,
    0x8b8b,
    0x8b8c,
    0xe6c5,
    0x8b8d,
    0x8b8e,
    0xbcde,
    0xc9a9,
    0x8b8f,
    0x8b90,
    0x8b91,
    0x8b92,
    0x8b93,
    0x8b94,
    0xbcb5,
    0x8b95,
    0x8b96,
    0xcfd3,
    0x8b97,
    0x8b98,
    0x8b99,
    0x8b9a,
    0x8b9b,
    0xe6c8,
    0x8b9c,
    0xe6c9,
    0x8b9d,
    0xe6ce,
    0x8b9e,
    0xe6d0,
    0x8b9f,
    0x8ba0,
    0x8ba1,
    0xe6d1,
    0x8ba2,
    0x8ba3,
    0x8ba4,
    0xe6cb,
    0xb5d5,
    0x8ba5,
    0xe6cc,
    0x8ba6,
    0x8ba7,
    0xe6cf,
    0x8ba8,
    0x8ba9,
    0xc4db,
    0x8baa,
    0xe6c6,
    0x8bab,
    0x8bac,
    0x8bad,
    0x8bae,
    0x8baf,
    0xe6cd,
    0x8bb0,
    0x8bb1,
    0x8bb2,
    0x8bb3,
    0x8bb4,
    0x8bb5,
    0x8bb6,
    0x8bb7,
    0x8bb8,
    0x8bb9,
    0x8bba,
    0x8bbb,
    0x8bbc,
    0x8bbd
};
UINT16 cp936_UNI_a0x5b[] = {
    0x8bbe,
    0x8bbf,
    0x8bc0,
    0x8bc1,
    0x8bc2,
    0x8bc3,
    0x8bc4,
    0x8bc5,
    0x8bc6,
    0xe6d2,
    0x8bc7,
    0x8bc8,
    0x8bc9,
    0x8bca,
    0x8bcb,
    0x8bcc,
    0x8bcd,
    0x8bce,
    0x8bcf,
    0x8bd0,
    0x8bd1,
    0x8bd2,
    0xe6d4,
    0xe6d3,
    0x8bd3,
    0x8bd4,
    0x8bd5,
    0x8bd6,
    0x8bd7,
    0x8bd8,
    0x8bd9,
    0x8bda,
    0x8bdb,
    0x8bdc,
    0x8bdd,
    0x8bde,
    0x8bdf,
    0x8be0,
    0x8be1,
    0x8be2,
    0x8be3,
    0x8be4,
    0x8be5,
    0x8be6,
    0x8be7,
    0x8be8,
    0x8be9,
    0x8bea,
    0x8beb,
    0x8bec,
    0xe6d5,
    0x8bed,
    0xd9f8,
    0x8bee,
    0x8bef,
    0xe6d6,
    0x8bf0,
    0x8bf1,
    0x8bf2,
    0x8bf3,
    0x8bf4,
    0x8bf5,
    0x8bf6,
    0x8bf7,
    0xe6d7,
    0x8bf8,
    0x8bf9,
    0x8bfa,
    0x8bfb,
    0x8bfc,
    0x8bfd,
    0x8bfe,
    0x8c40,
    0x8c41,
    0x8c42,
    0x8c43,
    0x8c44,
    0x8c45,
    0x8c46,
    0x8c47,
    0xd7d3,
    0xe6dd,
    0x8c48,
    0xe6de,
    0xbfd7,
    0xd4d0,
    0x8c49,
    0xd7d6,
    0xb4e6,
    0xcbef,
    0xe6da,
    0xd8c3,
    0xd7ce,
    0xd0a2,
    0x8c4a,
    0xc3cf,
    0x8c4b,
    0x8c4c,
    0xe6df,
    0xbcbe,
    0xb9c2,
    0xe6db,
    0xd1a7,
    0x8c4d,
    0x8c4e,
    0xbaa2,
    0xc2cf,
    0x8c4f,
    0xd8ab,
    0x8c50,
    0x8c51,
    0x8c52,
    0xcaeb,
    0xe5ee,
    0x8c53,
    0xe6dc,
    0x8c54,
    0xb7f5,
    0x8c55,
    0x8c56,
    0x8c57,
    0x8c58,
    0xc8e6,
    0x8c59,
    0x8c5a,
    0xc4f5,
    0x8c5b,
    0x8c5c,
    0xe5b2,
    0xc4fe,
    0x8c5d,
    0xcbfc,
    0xe5b3,
    0xd5ac,
    0x8c5e,
    0xd3ee,
    0xcad8,
    0xb0b2,
    0x8c5f,
    0xcbce,
    0xcdea,
    0x8c60,
    0x8c61,
    0xbaea,
    0x8c62,
    0x8c63,
    0x8c64,
    0xe5b5,
    0x8c65,
    0xe5b4,
    0x8c66,
    0xd7da,
    0xb9d9,
    0xd6e6,
    0xb6a8,
    0xcdf0,
    0xd2cb,
    0xb1a6,
    0xcab5,
    0x8c67,
    0xb3e8,
    0xc9f3,
    0xbfcd,
    0xd0fb,
    0xcad2,
    0xe5b6,
    0xbbc2,
    0x8c68,
    0x8c69,
    0x8c6a,
    0xcfdc,
    0xb9ac,
    0x8c6b,
    0x8c6c,
    0x8c6d,
    0x8c6e,
    0xd4d7,
    0x8c6f,
    0x8c70,
    0xbaa6,
    0xd1e7,
    0xcffc,
    0xbcd2,
    0x8c71,
    0xe5b7,
    0xc8dd,
    0x8c72,
    0x8c73,
    0x8c74,
    0xbfed,
    0xb1f6,
    0xcbde,
    0x8c75,
    0x8c76,
    0xbcc5,
    0x8c77,
    0xbcc4,
    0xd2fa,
    0xc3dc,
    0xbfdc,
    0x8c78,
    0x8c79,
    0x8c7a,
    0x8c7b,
    0xb8bb,
    0x8c7c,
    0x8c7d,
    0x8c7e,
    0xc3c2,
    0x8c80,
    0xbaae,
    0xd4a2,
    0x8c81,
    0x8c82,
    0x8c83,
    0x8c84,
    0x8c85,
    0x8c86,
    0x8c87,
    0x8c88,
    0x8c89,
    0xc7de,
    0xc4af,
    0xb2ec,
    0x8c8a,
    0xb9d1,
    0x8c8b,
    0x8c8c,
    0xe5bb,
    0xc1c8,
    0x8c8d,
    0x8c8e,
    0xd5af,
    0x8c8f,
    0x8c90,
    0x8c91,
    0x8c92,
    0x8c93,
    0xe5bc,
    0x8c94,
    0xe5be,
    0x8c95,
    0x8c96,
    0x8c97,
    0x8c98,
    0x8c99,
    0x8c9a,
    0x8c9b,
    0xb4e7,
    0xb6d4,
    0xcbc2,
    0xd1b0,
    0xb5bc,
    0x8c9c,
    0x8c9d,
    0xcad9
};
UINT16 cp936_UNI_a0x5c[] = {
    0x8c9e,
    0xb7e2,
    0x8c9f,
    0x8ca0,
    0xc9e4,
    0x8ca1,
    0xbdab,
    0x8ca2,
    0x8ca3,
    0xcebe,
    0xd7f0,
    0x8ca4,
    0x8ca5,
    0x8ca6,
    0x8ca7,
    0xd0a1,
    0x8ca8,
    0xc9d9,
    0x8ca9,
    0x8caa,
    0xb6fb,
    0xe6d8,
    0xbce2,
    0x8cab,
    0xb3be,
    0x8cac,
    0xc9d0,
    0x8cad,
    0xe6d9,
    0xb3a2,
    0x8cae,
    0x8caf,
    0x8cb0,
    0x8cb1,
    0xdecc,
    0x8cb2,
    0xd3c8,
    0xdecd,
    0x8cb3,
    0xd2a2,
    0x8cb4,
    0x8cb5,
    0x8cb6,
    0x8cb7,
    0xdece,
    0x8cb8,
    0x8cb9,
    0x8cba,
    0x8cbb,
    0xbecd,
    0x8cbc,
    0x8cbd,
    0xdecf,
    0x8cbe,
    0x8cbf,
    0x8cc0,
    0xcaac,
    0xd2fc,
    0xb3df,
    0xe5ea,
    0xc4e1,
    0xbea1,
    0xceb2,
    0xc4f2,
    0xbed6,
    0xc6a8,
    0xb2e3,
    0x8cc1,
    0x8cc2,
    0xbed3,
    0x8cc3,
    0x8cc4,
    0xc7fc,
    0xcceb,
    0xbdec,
    0xcedd,
    0x8cc5,
    0x8cc6,
    0xcaba,
    0xc6c1,
    0xe5ec,
    0xd0bc,
    0x8cc7,
    0x8cc8,
    0x8cc9,
    0xd5b9,
    0x8cca,
    0x8ccb,
    0x8ccc,
    0xe5ed,
    0x8ccd,
    0x8cce,
    0x8ccf,
    0x8cd0,
    0xcaf4,
    0x8cd1,
    0xcdc0,
    0xc2c5,
    0x8cd2,
    0xe5ef,
    0x8cd3,
    0xc2c4,
    0xe5f0,
    0x8cd4,
    0x8cd5,
    0x8cd6,
    0x8cd7,
    0x8cd8,
    0x8cd9,
    0x8cda,
    0xe5f8,
    0xcdcd,
    0x8cdb,
    0xc9bd,
    0x8cdc,
    0x8cdd,
    0x8cde,
    0x8cdf,
    0x8ce0,
    0x8ce1,
    0x8ce2,
    0xd2d9,
    0xe1a8,
    0x8ce3,
    0x8ce4,
    0x8ce5,
    0x8ce6,
    0xd3ec,
    0x8ce7,
    0xcbea,
    0xc6f1,
    0x8ce8,
    0x8ce9,
    0x8cea,
    0x8ceb,
    0x8cec,
    0xe1ac,
    0x8ced,
    0x8cee,
    0x8cef,
    0xe1a7,
    0xe1a9,
    0x8cf0,
    0x8cf1,
    0xe1aa,
    0xe1af,
    0x8cf2,
    0x8cf3,
    0xb2ed,
    0x8cf4,
    0xe1ab,
    0xb8da,
    0xe1ad,
    0xe1ae,
    0xe1b0,
    0xb5ba,
    0xe1b1,
    0x8cf5,
    0x8cf6,
    0x8cf7,
    0x8cf8,
    0x8cf9,
    0xe1b3,
    0xe1b8,
    0x8cfa,
    0x8cfb,
    0x8cfc,
    0x8cfd,
    0x8cfe,
    0xd1d2,
    0x8d40,
    0xe1b6,
    0xe1b5,
    0xc1eb,
    0x8d41,
    0x8d42,
    0x8d43,
    0xe1b7,
    0x8d44,
    0xd4c0,
    0x8d45,
    0xe1b2,
    0x8d46,
    0xe1ba,
    0xb0b6,
    0x8d47,
    0x8d48,
    0x8d49,
    0x8d4a,
    0xe1b4,
    0x8d4b,
    0xbff9,
    0x8d4c,
    0xe1b9,
    0x8d4d,
    0x8d4e,
    0xe1bb,
    0x8d4f,
    0x8d50,
    0x8d51,
    0x8d52,
    0x8d53,
    0x8d54,
    0xe1be,
    0x8d55,
    0x8d56,
    0x8d57,
    0x8d58,
    0x8d59,
    0x8d5a,
    0xe1bc,
    0x8d5b,
    0x8d5c,
    0x8d5d,
    0x8d5e,
    0x8d5f,
    0x8d60,
    0xd6c5,
    0x8d61,
    0x8d62,
    0x8d63,
    0x8d64,
    0x8d65,
    0x8d66,
    0x8d67,
    0xcfbf,
    0x8d68,
    0x8d69,
    0xe1bd,
    0xe1bf,
    0xc2cd,
    0x8d6a,
    0xb6eb,
    0x8d6b,
    0xd3f8,
    0x8d6c,
    0x8d6d,
    0xc7cd,
    0x8d6e,
    0x8d6f,
    0xb7e5,
    0x8d70,
    0x8d71,
    0x8d72,
    0x8d73,
    0x8d74,
    0x8d75,
    0x8d76,
    0x8d77,
    0x8d78,
    0x8d79,
    0xbefe,
    0x8d7a,
    0x8d7b,
    0x8d7c,
    0x8d7d
};
UINT16 cp936_UNI_a0x5d[] = {
    0x8d7e,
    0x8d80,
    0xe1c0,
    0xe1c1,
    0x8d81,
    0x8d82,
    0xe1c7,
    0xb3e7,
    0x8d83,
    0x8d84,
    0x8d85,
    0x8d86,
    0x8d87,
    0x8d88,
    0xc6e9,
    0x8d89,
    0x8d8a,
    0x8d8b,
    0x8d8c,
    0x8d8d,
    0xb4de,
    0x8d8e,
    0xd1c2,
    0x8d8f,
    0x8d90,
    0x8d91,
    0x8d92,
    0xe1c8,
    0x8d93,
    0x8d94,
    0xe1c6,
    0x8d95,
    0x8d96,
    0x8d97,
    0x8d98,
    0x8d99,
    0xe1c5,
    0x8d9a,
    0xe1c3,
    0xe1c2,
    0x8d9b,
    0xb1c0,
    0x8d9c,
    0x8d9d,
    0x8d9e,
    0xd5b8,
    0xe1c4,
    0x8d9f,
    0x8da0,
    0x8da1,
    0x8da2,
    0x8da3,
    0xe1cb,
    0x8da4,
    0x8da5,
    0x8da6,
    0x8da7,
    0x8da8,
    0x8da9,
    0x8daa,
    0x8dab,
    0xe1cc,
    0xe1ca,
    0x8dac,
    0x8dad,
    0x8dae,
    0x8daf,
    0x8db0,
    0x8db1,
    0x8db2,
    0x8db3,
    0xeffa,
    0x8db4,
    0x8db5,
    0xe1d3,
    0xe1d2,
    0xc7b6,
    0x8db6,
    0x8db7,
    0x8db8,
    0x8db9,
    0x8dba,
    0x8dbb,
    0x8dbc,
    0x8dbd,
    0x8dbe,
    0x8dbf,
    0x8dc0,
    0xe1c9,
    0x8dc1,
    0x8dc2,
    0xe1ce,
    0x8dc3,
    0xe1d0,
    0x8dc4,
    0x8dc5,
    0x8dc6,
    0x8dc7,
    0x8dc8,
    0x8dc9,
    0x8dca,
    0x8dcb,
    0x8dcc,
    0x8dcd,
    0x8dce,
    0xe1d4,
    0x8dcf,
    0xe1d1,
    0xe1cd,
    0x8dd0,
    0x8dd1,
    0xe1cf,
    0x8dd2,
    0x8dd3,
    0x8dd4,
    0x8dd5,
    0xe1d5,
    0x8dd6,
    0x8dd7,
    0x8dd8,
    0x8dd9,
    0x8dda,
    0x8ddb,
    0x8ddc,
    0x8ddd,
    0x8dde,
    0x8ddf,
    0x8de0,
    0x8de1,
    0x8de2,
    0xe1d6,
    0x8de3,
    0x8de4,
    0x8de5,
    0x8de6,
    0x8de7,
    0x8de8,
    0x8de9,
    0x8dea,
    0x8deb,
    0x8dec,
    0x8ded,
    0x8dee,
    0x8def,
    0x8df0,
    0x8df1,
    0x8df2,
    0x8df3,
    0x8df4,
    0x8df5,
    0x8df6,
    0x8df7,
    0x8df8,
    0xe1d7,
    0x8df9,
    0x8dfa,
    0x8dfb,
    0xe1d8,
    0x8dfc,
    0x8dfd,
    0x8dfe,
    0x8e40,
    0x8e41,
    0x8e42,
    0x8e43,
    0x8e44,
    0x8e45,
    0x8e46,
    0x8e47,
    0x8e48,
    0x8e49,
    0x8e4a,
    0x8e4b,
    0x8e4c,
    0x8e4d,
    0x8e4e,
    0x8e4f,
    0x8e50,
    0x8e51,
    0x8e52,
    0x8e53,
    0x8e54,
    0x8e55,
    0xe1da,
    0x8e56,
    0x8e57,
    0x8e58,
    0x8e59,
    0x8e5a,
    0x8e5b,
    0x8e5c,
    0x8e5d,
    0x8e5e,
    0x8e5f,
    0x8e60,
    0x8e61,
    0x8e62,
    0xe1db,
    0x8e63,
    0x8e64,
    0x8e65,
    0x8e66,
    0x8e67,
    0x8e68,
    0x8e69,
    0xcea1,
    0x8e6a,
    0x8e6b,
    0x8e6c,
    0x8e6d,
    0x8e6e,
    0x8e6f,
    0x8e70,
    0x8e71,
    0x8e72,
    0x8e73,
    0x8e74,
    0x8e75,
    0x8e76,
    0xe7dd,
    0x8e77,
    0xb4a8,
    0xd6dd,
    0x8e78,
    0x8e79,
    0xd1b2,
    0xb3b2,
    0x8e7a,
    0x8e7b,
    0xb9a4,
    0xd7f3,
    0xc7c9,
    0xbede,
    0xb9ae,
    0x8e7c,
    0xced7,
    0x8e7d,
    0x8e7e,
    0xb2ee,
    0xdbcf,
    0x8e80,
    0xbcba,
    0xd2d1,
    0xcbc8,
    0xb0cd,
    0x8e81,
    0x8e82,
    0xcfef,
    0x8e83,
    0x8e84,
    0x8e85,
    0x8e86,
    0x8e87,
    0xd9e3,
    0xbded,
    0x8e88
};
UINT16 cp936_UNI_a0x5e[] = {
    0x8e89,
    0xb1d2,
    0xcad0,
    0xb2bc,
    0x8e8a,
    0xcba7,
    0xb7ab,
    0x8e8b,
    0xcaa6,
    0x8e8c,
    0x8e8d,
    0x8e8e,
    0xcfa3,
    0x8e8f,
    0x8e90,
    0xe0f8,
    0xd5ca,
    0xe0fb,
    0x8e91,
    0x8e92,
    0xe0fa,
    0xc5c1,
    0xccfb,
    0x8e93,
    0xc1b1,
    0xe0f9,
    0xd6e3,
    0xb2af,
    0xd6c4,
    0xb5db,
    0x8e94,
    0x8e95,
    0x8e96,
    0x8e97,
    0x8e98,
    0x8e99,
    0x8e9a,
    0x8e9b,
    0xb4f8,
    0xd6a1,
    0x8e9c,
    0x8e9d,
    0x8e9e,
    0x8e9f,
    0x8ea0,
    0xcfaf,
    0xb0ef,
    0x8ea1,
    0x8ea2,
    0xe0fc,
    0x8ea3,
    0x8ea4,
    0x8ea5,
    0x8ea6,
    0x8ea7,
    0xe1a1,
    0xb3a3,
    0x8ea8,
    0x8ea9,
    0xe0fd,
    0xe0fe,
    0xc3b1,
    0x8eaa,
    0x8eab,
    0x8eac,
    0x8ead,
    0xc3dd,
    0x8eae,
    0xe1a2,
    0xb7f9,
    0x8eaf,
    0x8eb0,
    0x8eb1,
    0x8eb2,
    0x8eb3,
    0x8eb4,
    0xbbcf,
    0x8eb5,
    0x8eb6,
    0x8eb7,
    0x8eb8,
    0x8eb9,
    0x8eba,
    0x8ebb,
    0xe1a3,
    0xc4bb,
    0x8ebc,
    0x8ebd,
    0x8ebe,
    0x8ebf,
    0x8ec0,
    0xe1a4,
    0x8ec1,
    0x8ec2,
    0xe1a5,
    0x8ec3,
    0x8ec4,
    0xe1a6,
    0xb4b1,
    0x8ec5,
    0x8ec6,
    0x8ec7,
    0x8ec8,
    0x8ec9,
    0x8eca,
    0x8ecb,
    0x8ecc,
    0x8ecd,
    0x8ece,
    0x8ecf,
    0x8ed0,
    0x8ed1,
    0x8ed2,
    0x8ed3,
    0xb8c9,
    0xc6bd,
    0xc4ea,
    0x8ed4,
    0xb2a2,
    0x8ed5,
    0xd0d2,
    0x8ed6,
    0xe7db,
    0xbbc3,
    0xd3d7,
    0xd3c4,
    0x8ed7,
    0xb9e3,
    0xe2cf,
    0x8ed8,
    0x8ed9,
    0x8eda,
    0xd7af,
    0x8edb,
    0xc7ec,
    0xb1d3,
    0x8edc,
    0x8edd,
    0xb4b2,
    0xe2d1,
    0x8ede,
    0x8edf,
    0x8ee0,
    0xd0f2,
    0xc2ae,
    0xe2d0,
    0x8ee1,
    0xbfe2,
    0xd3a6,
    0xb5d7,
    0xe2d2,
    0xb5ea,
    0x8ee2,
    0xc3ed,
    0xb8fd,
    0x8ee3,
    0xb8ae,
    0x8ee4,
    0xc5d3,
    0xb7cf,
    0xe2d4,
    0x8ee5,
    0x8ee6,
    0x8ee7,
    0x8ee8,
    0xe2d3,
    0xb6c8,
    0xd7f9,
    0x8ee9,
    0x8eea,
    0x8eeb,
    0x8eec,
    0x8eed,
    0xcda5,
    0x8eee,
    0x8eef,
    0x8ef0,
    0x8ef1,
    0x8ef2,
    0xe2d8,
    0x8ef3,
    0xe2d6,
    0xcafc,
    0xbfb5,
    0xd3b9,
    0xe2d5,
    0x8ef4,
    0x8ef5,
    0x8ef6,
    0x8ef7,
    0xe2d7,
    0x8ef8,
    0x8ef9,
    0x8efa,
    0x8efb,
    0x8efc,
    0x8efd,
    0x8efe,
    0x8f40,
    0x8f41,
    0x8f42,
    0xc1ae,
    0xc0c8,
    0x8f43,
    0x8f44,
    0x8f45,
    0x8f46,
    0x8f47,
    0x8f48,
    0xe2db,
    0xe2da,
    0xc0aa,
    0x8f49,
    0x8f4a,
    0xc1ce,
    0x8f4b,
    0x8f4c,
    0x8f4d,
    0x8f4e,
    0xe2dc,
    0x8f4f,
    0x8f50,
    0x8f51,
    0x8f52,
    0x8f53,
    0x8f54,
    0x8f55,
    0x8f56,
    0x8f57,
    0x8f58,
    0x8f59,
    0x8f5a,
    0xe2dd,
    0x8f5b,
    0xe2de,
    0x8f5c,
    0x8f5d,
    0x8f5e,
    0x8f5f,
    0x8f60,
    0x8f61,
    0x8f62,
    0x8f63,
    0x8f64,
    0xdbc8,
    0x8f65,
    0xd1d3,
    0xcda2,
    0x8f66,
    0x8f67,
    0xbda8,
    0x8f68,
    0x8f69,
    0x8f6a,
    0xdec3,
    0xd8a5
};
UINT16 cp936_UNI_a0x5f[] = {
    0xbfaa,
    0xdbcd,
    0xd2ec,
    0xc6fa,
    0xc5aa,
    0x8f6b,
    0x8f6c,
    0x8f6d,
    0xdec4,
    0x8f6e,
    0xb1d7,
    0xdfae,
    0x8f6f,
    0x8f70,
    0x8f71,
    0xcabd,
    0x8f72,
    0xdfb1,
    0x8f73,
    0xb9ad,
    0x8f74,
    0xd2fd,
    0x8f75,
    0xb8a5,
    0xbaeb,
    0x8f76,
    0x8f77,
    0xb3da,
    0x8f78,
    0x8f79,
    0x8f7a,
    0xb5dc,
    0xd5c5,
    0x8f7b,
    0x8f7c,
    0x8f7d,
    0x8f7e,
    0xc3d6,
    0xcfd2,
    0xbba1,
    0x8f80,
    0xe5f3,
    0xe5f2,
    0x8f81,
    0x8f82,
    0xe5f4,
    0x8f83,
    0xcde4,
    0x8f84,
    0xc8f5,
    0x8f85,
    0x8f86,
    0x8f87,
    0x8f88,
    0x8f89,
    0x8f8a,
    0x8f8b,
    0xb5af,
    0xc7bf,
    0x8f8c,
    0xe5f6,
    0x8f8d,
    0x8f8e,
    0x8f8f,
    0xecb0,
    0x8f90,
    0x8f91,
    0x8f92,
    0x8f93,
    0x8f94,
    0x8f95,
    0x8f96,
    0x8f97,
    0x8f98,
    0x8f99,
    0x8f9a,
    0x8f9b,
    0x8f9c,
    0x8f9d,
    0x8f9e,
    0xe5e6,
    0x8f9f,
    0xb9e9,
    0xb5b1,
    0x8fa0,
    0xc2bc,
    0xe5e8,
    0xe5e7,
    0xe5e9,
    0x8fa1,
    0x8fa2,
    0x8fa3,
    0x8fa4,
    0xd2cd,
    0x8fa5,
    0x8fa6,
    0x8fa7,
    0xe1ea,
    0xd0ce,
    0x8fa8,
    0xcdae,
    0x8fa9,
    0xd1e5,
    0x8faa,
    0x8fab,
    0xb2ca,
    0xb1eb,
    0x8fac,
    0xb1f2,
    0xc5ed,
    0x8fad,
    0x8fae,
    0xd5c3,
    0xd3b0,
    0x8faf,
    0xe1dc,
    0x8fb0,
    0x8fb1,
    0x8fb2,
    0xe1dd,
    0x8fb3,
    0xd2db,
    0x8fb4,
    0xb3b9,
    0xb1cb,
    0x8fb5,
    0x8fb6,
    0x8fb7,
    0xcdf9,
    0xd5f7,
    0xe1de,
    0x8fb8,
    0xbeb6,
    0xb4fd,
    0x8fb9,
    0xe1df,
    0xbadc,
    0xe1e0,
    0xbbb2,
    0xc2c9,
    0xe1e1,
    0x8fba,
    0x8fbb,
    0x8fbc,
    0xd0ec,
    0x8fbd,
    0xcdbd,
    0x8fbe,
    0x8fbf,
    0xe1e2,
    0x8fc0,
    0xb5c3,
    0xc5c7,
    0xe1e3,
    0x8fc1,
    0x8fc2,
    0xe1e4,
    0x8fc3,
    0x8fc4,
    0x8fc5,
    0x8fc6,
    0xd3f9,
    0x8fc7,
    0x8fc8,
    0x8fc9,
    0x8fca,
    0x8fcb,
    0x8fcc,
    0xe1e5,
    0x8fcd,
    0xd1ad,
    0x8fce,
    0x8fcf,
    0xe1e6,
    0xcea2,
    0x8fd0,
    0x8fd1,
    0x8fd2,
    0x8fd3,
    0x8fd4,
    0x8fd5,
    0xe1e7,
    0x8fd6,
    0xb5c2,
    0x8fd7,
    0x8fd8,
    0x8fd9,
    0x8fda,
    0xe1e8,
    0xbbd5,
    0x8fdb,
    0x8fdc,
    0x8fdd,
    0x8fde,
    0x8fdf,
    0xd0c4,
    0xe2e0,
    0xb1d8,
    0xd2e4,
    0x8fe0,
    0x8fe1,
    0xe2e1,
    0x8fe2,
    0x8fe3,
    0xbcc9,
    0xc8cc,
    0x8fe4,
    0xe2e3,
    0xecfe,
    0xecfd,
    0xdfaf,
    0x8fe5,
    0x8fe6,
    0x8fe7,
    0xe2e2,
    0xd6be,
    0xcdfc,
    0xc3a6,
    0x8fe8,
    0x8fe9,
    0x8fea,
    0xe3c3,
    0x8feb,
    0x8fec,
    0xd6d2,
    0xe2e7,
    0x8fed,
    0x8fee,
    0xe2e8,
    0x8fef,
    0x8ff0,
    0xd3c7,
    0x8ff1,
    0x8ff2,
    0xe2ec,
    0xbfec,
    0x8ff3,
    0xe2ed,
    0xe2e5,
    0x8ff4,
    0x8ff5,
    0xb3c0,
    0x8ff6,
    0x8ff7,
    0x8ff8,
    0xc4ee,
    0x8ff9,
    0x8ffa,
    0xe2ee,
    0x8ffb,
    0x8ffc,
    0xd0c3,
    0x8ffd,
    0xbaf6,
    0xe2e9,
    0xb7de
};
UINT16 cp936_UNI_a0x60[] = {
    0xbbb3,
    0xccac,
    0xcbcb,
    0xe2e4,
    0xe2e6,
    0xe2ea,
    0xe2eb,
    0x8ffe,
    0x9040,
    0x9041,
    0xe2f7,
    0x9042,
    0x9043,
    0xe2f4,
    0xd4f5,
    0xe2f3,
    0x9044,
    0x9045,
    0xc5ad,
    0x9046,
    0xd5fa,
    0xc5c2,
    0xb2c0,
    0x9047,
    0x9048,
    0xe2ef,
    0x9049,
    0xe2f2,
    0xc1af,
    0xcbbc,
    0x904a,
    0x904b,
    0xb5a1,
    0xe2f9,
    0x904c,
    0x904d,
    0x904e,
    0xbcb1,
    0xe2f1,
    0xd0d4,
    0xd4b9,
    0xe2f5,
    0xb9d6,
    0xe2f6,
    0x904f,
    0x9050,
    0x9051,
    0xc7d3,
    0x9052,
    0x9053,
    0x9054,
    0x9055,
    0x9056,
    0xe2f0,
    0x9057,
    0x9058,
    0x9059,
    0x905a,
    0x905b,
    0xd7dc,
    0xeda1,
    0x905c,
    0x905d,
    0xe2f8,
    0x905e,
    0xeda5,
    0xe2fe,
    0xcad1,
    0x905f,
    0x9060,
    0x9061,
    0x9062,
    0x9063,
    0x9064,
    0x9065,
    0xc1b5,
    0x9066,
    0xbbd0,
    0x9067,
    0x9068,
    0xbfd6,
    0x9069,
    0xbae3,
    0x906a,
    0x906b,
    0xcba1,
    0x906c,
    0x906d,
    0x906e,
    0xeda6,
    0xeda3,
    0x906f,
    0x9070,
    0xeda2,
    0x9071,
    0x9072,
    0x9073,
    0x9074,
    0xbbd6,
    0xeda7,
    0xd0f4,
    0x9075,
    0x9076,
    0xeda4,
    0xbade,
    0xb6f7,
    0xe3a1,
    0xb6b2,
    0xccf1,
    0xb9a7,
    0x9077,
    0xcfa2,
    0xc7a1,
    0x9078,
    0x9079,
    0xbfd2,
    0x907a,
    0x907b,
    0xb6f1,
    0x907c,
    0xe2fa,
    0xe2fb,
    0xe2fd,
    0xe2fc,
    0xc4d5,
    0xe3a2,
    0x907d,
    0xd3c1,
    0x907e,
    0x9080,
    0x9081,
    0xe3a7,
    0xc7c4,
    0x9082,
    0x9083,
    0x9084,
    0x9085,
    0xcfa4,
    0x9086,
    0x9087,
    0xe3a9,
    0xbab7,
    0x9088,
    0x9089,
    0x908a,
    0x908b,
    0xe3a8,
    0x908c,
    0xbbda,
    0x908d,
    0xe3a3,
    0x908e,
    0x908f,
    0x9090,
    0xe3a4,
    0xe3aa,
    0x9091,
    0xe3a6,
    0x9092,
    0xcef2,
    0xd3c6,
    0x9093,
    0x9094,
    0xbbbc,
    0x9095,
    0x9096,
    0xd4c3,
    0x9097,
    0xc4fa,
    0x9098,
    0x9099,
    0xeda8,
    0xd0fc,
    0xe3a5,
    0x909a,
    0xc3f5,
    0x909b,
    0xe3ad,
    0xb1af,
    0x909c,
    0xe3b2,
    0x909d,
    0x909e,
    0x909f,
    0xbcc2,
    0x90a0,
    0x90a1,
    0xe3ac,
    0xb5bf,
    0x90a2,
    0x90a3,
    0x90a4,
    0x90a5,
    0x90a6,
    0x90a7,
    0x90a8,
    0x90a9,
    0xc7e9,
    0xe3b0,
    0x90aa,
    0x90ab,
    0x90ac,
    0xbeaa,
    0xcdef,
    0x90ad,
    0x90ae,
    0x90af,
    0x90b0,
    0x90b1,
    0xbbf3,
    0x90b2,
    0x90b3,
    0x90b4,
    0xcce8,
    0x90b5,
    0x90b6,
    0xe3af,
    0x90b7,
    0xe3b1,
    0x90b8,
    0xcfa7,
    0xe3ae,
    0x90b9,
    0xcea9,
    0xbbdd,
    0x90ba,
    0x90bb,
    0x90bc,
    0x90bd,
    0x90be,
    0xb5eb,
    0xbee5,
    0xb2d2,
    0xb3cd,
    0x90bf,
    0xb1b9,
    0xe3ab,
    0xb2d1,
    0xb5ac,
    0xb9df,
    0xb6e8,
    0x90c0,
    0x90c1,
    0xcfeb,
    0xe3b7,
    0x90c2,
    0xbbcc,
    0x90c3,
    0x90c4,
    0xc8c7,
    0xd0ca,
    0x90c5,
    0x90c6,
    0x90c7,
    0x90c8,
    0x90c9
};
UINT16 cp936_UNI_a0x61[] = {
    0xe3b8,
    0xb3ee,
    0x90ca,
    0x90cb,
    0x90cc,
    0x90cd,
    0xeda9,
    0x90ce,
    0xd3fa,
    0xd3e4,
    0x90cf,
    0x90d0,
    0x90d1,
    0xedaa,
    0xe3b9,
    0xd2e2,
    0x90d2,
    0x90d3,
    0x90d4,
    0x90d5,
    0x90d6,
    0xe3b5,
    0x90d7,
    0x90d8,
    0x90d9,
    0x90da,
    0xd3de,
    0x90db,
    0x90dc,
    0x90dd,
    0x90de,
    0xb8d0,
    0xe3b3,
    0x90df,
    0x90e0,
    0xe3b6,
    0xb7df,
    0x90e1,
    0xe3b4,
    0xc0a2,
    0x90e2,
    0x90e3,
    0x90e4,
    0xe3ba,
    0x90e5,
    0x90e6,
    0x90e7,
    0x90e8,
    0x90e9,
    0x90ea,
    0x90eb,
    0x90ec,
    0x90ed,
    0x90ee,
    0x90ef,
    0x90f0,
    0x90f1,
    0x90f2,
    0x90f3,
    0x90f4,
    0x90f5,
    0x90f6,
    0x90f7,
    0xd4b8,
    0x90f8,
    0x90f9,
    0x90fa,
    0x90fb,
    0x90fc,
    0x90fd,
    0x90fe,
    0x9140,
    0xb4c8,
    0x9141,
    0xe3bb,
    0x9142,
    0xbbc5,
    0x9143,
    0xc9f7,
    0x9144,
    0x9145,
    0xc9e5,
    0x9146,
    0x9147,
    0x9148,
    0xc4bd,
    0x9149,
    0x914a,
    0x914b,
    0x914c,
    0x914d,
    0x914e,
    0x914f,
    0xedab,
    0x9150,
    0x9151,
    0x9152,
    0x9153,
    0xc2fd,
    0x9154,
    0x9155,
    0x9156,
    0x9157,
    0xbbdb,
    0xbfae,
    0x9158,
    0x9159,
    0x915a,
    0x915b,
    0x915c,
    0x915d,
    0x915e,
    0xcebf,
    0x915f,
    0x9160,
    0x9161,
    0x9162,
    0xe3bc,
    0x9163,
    0xbfb6,
    0x9164,
    0x9165,
    0x9166,
    0x9167,
    0x9168,
    0x9169,
    0x916a,
    0x916b,
    0x916c,
    0x916d,
    0x916e,
    0x916f,
    0x9170,
    0x9171,
    0x9172,
    0x9173,
    0x9174,
    0x9175,
    0x9176,
    0xb1ef,
    0x9177,
    0x9178,
    0xd4f7,
    0x9179,
    0x917a,
    0x917b,
    0x917c,
    0x917d,
    0xe3be,
    0x917e,
    0x9180,
    0x9181,
    0x9182,
    0x9183,
    0x9184,
    0x9185,
    0x9186,
    0xedad,
    0x9187,
    0x9188,
    0x9189,
    0x918a,
    0x918b,
    0x918c,
    0x918d,
    0x918e,
    0x918f,
    0xe3bf,
    0xbaa9,
    0xedac,
    0x9190,
    0x9191,
    0xe3bd,
    0x9192,
    0x9193,
    0x9194,
    0x9195,
    0x9196,
    0x9197,
    0x9198,
    0x9199,
    0x919a,
    0x919b,
    0xe3c0,
    0x919c,
    0x919d,
    0x919e,
    0x919f,
    0x91a0,
    0x91a1,
    0xbab6,
    0x91a2,
    0x91a3,
    0x91a4,
    0xb6ae,
    0x91a5,
    0x91a6,
    0x91a7,
    0x91a8,
    0x91a9,
    0xd0b8,
    0x91aa,
    0xb0c3,
    0xedae,
    0x91ab,
    0x91ac,
    0x91ad,
    0x91ae,
    0x91af,
    0xedaf,
    0xc0c1,
    0x91b0,
    0xe3c1,
    0x91b1,
    0x91b2,
    0x91b3,
    0x91b4,
    0x91b5,
    0x91b6,
    0x91b7,
    0x91b8,
    0x91b9,
    0x91ba,
    0x91bb,
    0x91bc,
    0x91bd,
    0x91be,
    0x91bf,
    0x91c0,
    0x91c1,
    0xc5b3,
    0x91c2,
    0x91c3,
    0x91c4,
    0x91c5,
    0x91c6,
    0x91c7,
    0x91c8,
    0x91c9,
    0x91ca,
    0x91cb,
    0x91cc,
    0x91cd,
    0x91ce,
    0x91cf,
    0xe3c2,
    0x91d0,
    0x91d1,
    0x91d2,
    0x91d3,
    0x91d4,
    0x91d5,
    0x91d6,
    0x91d7,
    0x91d8,
    0xdcb2
};
UINT16 cp936_UNI_a0x62[] = {
    0x91d9,
    0x91da,
    0x91db,
    0x91dc,
    0x91dd,
    0x91de,
    0xedb0,
    0x91df,
    0xb8ea,
    0x91e0,
    0xceec,
    0xeaa7,
    0xd0e7,
    0xcaf9,
    0xc8d6,
    0xcfb7,
    0xb3c9,
    0xced2,
    0xbde4,
    0x91e1,
    0x91e2,
    0xe3de,
    0xbbf2,
    0xeaa8,
    0xd5bd,
    0x91e3,
    0xc6dd,
    0xeaa9,
    0x91e4,
    0x91e5,
    0x91e6,
    0xeaaa,
    0x91e7,
    0xeaac,
    0xeaab,
    0x91e8,
    0xeaae,
    0xeaad,
    0x91e9,
    0x91ea,
    0x91eb,
    0x91ec,
    0xbdd8,
    0x91ed,
    0xeaaf,
    0x91ee,
    0xc2be,
    0x91ef,
    0x91f0,
    0x91f1,
    0x91f2,
    0xb4c1,
    0xb4f7,
    0x91f3,
    0x91f4,
    0xbba7,
    0x91f5,
    0x91f6,
    0x91f7,
    0x91f8,
    0x91f9,
    0xece6,
    0xece5,
    0xb7bf,
    0xcbf9,
    0xb1e2,
    0x91fa,
    0xece7,
    0x91fb,
    0x91fc,
    0x91fd,
    0xc9c8,
    0xece8,
    0xece9,
    0x91fe,
    0xcad6,
    0xded0,
    0xb2c5,
    0xd4fa,
    0x9240,
    0x9241,
    0xc6cb,
    0xb0c7,
    0xb4f2,
    0xc8d3,
    0x9242,
    0x9243,
    0x9244,
    0xcdd0,
    0x9245,
    0x9246,
    0xbfb8,
    0x9247,
    0x9248,
    0x9249,
    0x924a,
    0x924b,
    0x924c,
    0x924d,
    0xbfdb,
    0x924e,
    0x924f,
    0xc7a4,
    0xd6b4,
    0x9250,
    0xc0a9,
    0xded1,
    0xc9a8,
    0xd1ef,
    0xc5a4,
    0xb0e7,
    0xb3b6,
    0xc8c5,
    0x9251,
    0x9252,
    0xb0e2,
    0x9253,
    0x9254,
    0xb7f6,
    0x9255,
    0x9256,
    0xc5fa,
    0x9257,
    0x9258,
    0xb6f3,
    0x9259,
    0xd5d2,
    0xb3d0,
    0xbcbc,
    0x925a,
    0x925b,
    0x925c,
    0xb3ad,
    0x925d,
    0x925e,
    0x925f,
    0x9260,
    0xbef1,
    0xb0d1,
    0x9261,
    0x9262,
    0x9263,
    0x9264,
    0x9265,
    0x9266,
    0xd2d6,
    0xcae3,
    0xd7a5,
    0x9267,
    0xcdb6,
    0xb6b6,
    0xbfb9,
    0xd5db,
    0x9268,
    0xb8a7,
    0xc5d7,
    0x9269,
    0x926a,
    0x926b,
    0xded2,
    0xbfd9,
    0xc2d5,
    0xc7c0,
    0x926c,
    0xbba4,
    0xb1a8,
    0x926d,
    0x926e,
    0xc5ea,
    0x926f,
    0x9270,
    0xc5fb,
    0xcca7,
    0x9271,
    0x9272,
    0x9273,
    0x9274,
    0xb1a7,
    0x9275,
    0x9276,
    0x9277,
    0xb5d6,
    0x9278,
    0x9279,
    0x927a,
    0xc4a8,
    0x927b,
    0xded3,
    0xd1ba,
    0xb3e9,
    0x927c,
    0xc3f2,
    0x927d,
    0x927e,
    0xb7f7,
    0x9280,
    0xd6f4,
    0xb5a3,
    0xb2f0,
    0xc4b4,
    0xc4e9,
    0xc0ad,
    0xded4,
    0x9281,
    0xb0e8,
    0xc5c4,
    0xc1e0,
    0x9282,
    0xb9d5,
    0x9283,
    0xbedc,
    0xcdd8,
    0xb0ce,
    0x9284,
    0xcdcf,
    0xded6,
    0xbed0,
    0xd7be,
    0xded5,
    0xd5d0,
    0xb0dd,
    0x9285,
    0x9286,
    0xc4e2,
    0x9287,
    0x9288,
    0xc2a3,
    0xbcf0,
    0x9289,
    0xd3b5,
    0xc0b9,
    0xc5a1,
    0xb2a6,
    0xd4f1,
    0x928a,
    0x928b,
    0xc0a8,
    0xcac3,
    0xded7,
    0xd5fc,
    0x928c,
    0xb9b0,
    0x928d,
    0xc8ad,
    0xcba9,
    0x928e,
    0xded9,
    0xbfbd,
    0x928f,
    0x9290,
    0x9291,
    0x9292,
    0xc6b4,
    0xd7a7,
    0xcab0,
    0xc4c3
};
UINT16 cp936_UNI_a0x63[] = {
    0x9293,
    0xb3d6,
    0xb9d2,
    0x9294,
    0x9295,
    0x9296,
    0x9297,
    0xd6b8,
    0xeafc,
    0xb0b4,
    0x9298,
    0x9299,
    0x929a,
    0x929b,
    0xbfe6,
    0x929c,
    0x929d,
    0xccf4,
    0x929e,
    0x929f,
    0x92a0,
    0x92a1,
    0xcdda,
    0x92a2,
    0x92a3,
    0x92a4,
    0xd6bf,
    0xc2ce,
    0x92a5,
    0xcece,
    0xcca2,
    0xd0ae,
    0xc4d3,
    0xb5b2,
    0xded8,
    0xd5f5,
    0xbcb7,
    0xbbd3,
    0x92a6,
    0x92a7,
    0xb0a4,
    0x92a8,
    0xc5b2,
    0xb4ec,
    0x92a9,
    0x92aa,
    0x92ab,
    0xd5f1,
    0x92ac,
    0x92ad,
    0xeafd,
    0x92ae,
    0x92af,
    0x92b0,
    0x92b1,
    0x92b2,
    0x92b3,
    0xdeda,
    0xcda6,
    0x92b4,
    0x92b5,
    0xcdec,
    0x92b6,
    0x92b7,
    0x92b8,
    0x92b9,
    0xcee6,
    0xdedc,
    0x92ba,
    0xcdb1,
    0xc0a6,
    0x92bb,
    0x92bc,
    0xd7bd,
    0x92bd,
    0xdedb,
    0xb0c6,
    0xbab4,
    0xc9d3,
    0xc4f3,
    0xbee8,
    0x92be,
    0x92bf,
    0x92c0,
    0x92c1,
    0xb2b6,
    0x92c2,
    0x92c3,
    0x92c4,
    0x92c5,
    0x92c6,
    0x92c7,
    0x92c8,
    0x92c9,
    0xc0cc,
    0xcbf0,
    0x92ca,
    0xbcf1,
    0xbbbb,
    0xb5b7,
    0x92cb,
    0x92cc,
    0x92cd,
    0xc5f5,
    0x92ce,
    0xdee6,
    0x92cf,
    0x92d0,
    0x92d1,
    0xdee3,
    0xbedd,
    0x92d2,
    0x92d3,
    0xdedf,
    0x92d4,
    0x92d5,
    0x92d6,
    0x92d7,
    0xb4b7,
    0xbddd,
    0x92d8,
    0x92d9,
    0xdee0,
    0xc4ed,
    0x92da,
    0x92db,
    0x92dc,
    0x92dd,
    0xcfc6,
    0x92de,
    0xb5e0,
    0x92df,
    0x92e0,
    0x92e1,
    0x92e2,
    0xb6de,
    0xcada,
    0xb5f4,
    0xdee5,
    0x92e3,
    0xd5c6,
    0x92e4,
    0xdee1,
    0xcccd,
    0xc6fe,
    0x92e5,
    0xc5c5,
    0x92e6,
    0x92e7,
    0x92e8,
    0xd2b4,
    0x92e9,
    0xbef2,
    0x92ea,
    0x92eb,
    0x92ec,
    0x92ed,
    0x92ee,
    0x92ef,
    0x92f0,
    0xc2d3,
    0x92f1,
    0xccbd,
    0xb3b8,
    0x92f2,
    0xbdd3,
    0x92f3,
    0xbfd8,
    0xcdc6,
    0xd1da,
    0xb4eb,
    0x92f4,
    0xdee4,
    0xdedd,
    0xdee7,
    0x92f5,
    0xeafe,
    0x92f6,
    0x92f7,
    0xc2b0,
    0xdee2,
    0x92f8,
    0x92f9,
    0xd6c0,
    0xb5a7,
    0x92fa,
    0xb2f4,
    0x92fb,
    0xdee8,
    0x92fc,
    0xdef2,
    0x92fd,
    0x92fe,
    0x9340,
    0x9341,
    0x9342,
    0xdeed,
    0x9343,
    0xdef1,
    0x9344,
    0x9345,
    0xc8e0,
    0x9346,
    0x9347,
    0x9348,
    0xd7e1,
    0xdeef,
    0xc3e8,
    0xcce1,
    0x9349,
    0xb2e5,
    0x934a,
    0x934b,
    0x934c,
    0xd2be,
    0x934d,
    0x934e,
    0x934f,
    0x9350,
    0x9351,
    0x9352,
    0x9353,
    0xdeee,
    0x9354,
    0xdeeb,
    0xced5,
    0x9355,
    0xb4a7,
    0x9356,
    0x9357,
    0x9358,
    0x9359,
    0x935a,
    0xbfab,
    0xbebe,
    0x935b,
    0x935c,
    0xbdd2,
    0x935d,
    0x935e,
    0x935f,
    0x9360,
    0xdee9,
    0x9361,
    0xd4ae,
    0x9362,
    0xdede,
    0x9363,
    0xdeea,
    0x9364,
    0x9365,
    0x9366,
    0x9367,
    0xc0bf,
    0x9368,
    0xdeec
};
UINT16 cp936_UNI_a0x64[] = {
    0xb2f3,
    0xb8e9,
    0xc2a7,
    0x9369,
    0x936a,
    0xbdc1,
    0x936b,
    0x936c,
    0x936d,
    0x936e,
    0x936f,
    0xdef5,
    0xdef8,
    0x9370,
    0x9371,
    0xb2ab,
    0xb4a4,
    0x9372,
    0x9373,
    0xb4ea,
    0xc9a6,
    0x9374,
    0x9375,
    0x9376,
    0x9377,
    0x9378,
    0x9379,
    0xdef6,
    0xcbd1,
    0x937a,
    0xb8e3,
    0x937b,
    0xdef7,
    0xdefa,
    0x937c,
    0x937d,
    0x937e,
    0x9380,
    0xdef9,
    0x9381,
    0x9382,
    0x9383,
    0xccc2,
    0x9384,
    0xb0e1,
    0xb4ee,
    0x9385,
    0x9386,
    0x9387,
    0x9388,
    0x9389,
    0x938a,
    0xe5ba,
    0x938b,
    0x938c,
    0x938d,
    0x938e,
    0x938f,
    0xd0af,
    0x9390,
    0x9391,
    0xb2eb,
    0x9392,
    0xeba1,
    0x9393,
    0xdef4,
    0x9394,
    0x9395,
    0xc9e3,
    0xdef3,
    0xb0da,
    0xd2a1,
    0xb1f7,
    0x9396,
    0xccaf,
    0x9397,
    0x9398,
    0x9399,
    0x939a,
    0x939b,
    0x939c,
    0x939d,
    0xdef0,
    0x939e,
    0xcba4,
    0x939f,
    0x93a0,
    0x93a1,
    0xd5aa,
    0x93a2,
    0x93a3,
    0x93a4,
    0x93a5,
    0x93a6,
    0xdefb,
    0x93a7,
    0x93a8,
    0x93a9,
    0x93aa,
    0x93ab,
    0x93ac,
    0x93ad,
    0x93ae,
    0xb4dd,
    0x93af,
    0xc4a6,
    0x93b0,
    0x93b1,
    0x93b2,
    0xdefd,
    0x93b3,
    0x93b4,
    0x93b5,
    0x93b6,
    0x93b7,
    0x93b8,
    0x93b9,
    0x93ba,
    0x93bb,
    0x93bc,
    0xc3fe,
    0xc4a1,
    0xdfa1,
    0x93bd,
    0x93be,
    0x93bf,
    0x93c0,
    0x93c1,
    0x93c2,
    0x93c3,
    0xc1cc,
    0x93c4,
    0xdefc,
    0xbeef,
    0x93c5,
    0xc6b2,
    0x93c6,
    0x93c7,
    0x93c8,
    0x93c9,
    0x93ca,
    0x93cb,
    0x93cc,
    0x93cd,
    0x93ce,
    0xb3c5,
    0xc8f6,
    0x93cf,
    0x93d0,
    0xcbba,
    0xdefe,
    0x93d1,
    0x93d2,
    0xdfa4,
    0x93d3,
    0x93d4,
    0x93d5,
    0x93d6,
    0xd7b2,
    0x93d7,
    0x93d8,
    0x93d9,
    0x93da,
    0x93db,
    0xb3b7,
    0x93dc,
    0x93dd,
    0x93de,
    0x93df,
    0xc1c3,
    0x93e0,
    0x93e1,
    0xc7cb,
    0xb2a5,
    0xb4e9,
    0x93e2,
    0xd7ab,
    0x93e3,
    0x93e4,
    0x93e5,
    0x93e6,
    0xc4ec,
    0x93e7,
    0xdfa2,
    0xdfa3,
    0x93e8,
    0xdfa5,
    0x93e9,
    0xbab3,
    0x93ea,
    0x93eb,
    0x93ec,
    0xdfa6,
    0x93ed,
    0xc0de,
    0x93ee,
    0x93ef,
    0xc9c3,
    0x93f0,
    0x93f1,
    0x93f2,
    0x93f3,
    0x93f4,
    0x93f5,
    0x93f6,
    0xb2d9,
    0xc7e6,
    0x93f7,
    0xdfa7,
    0x93f8,
    0xc7dc,
    0x93f9,
    0x93fa,
    0x93fb,
    0x93fc,
    0xdfa8,
    0xeba2,
    0x93fd,
    0x93fe,
    0x9440,
    0x9441,
    0x9442,
    0xcbd3,
    0x9443,
    0x9444,
    0x9445,
    0xdfaa,
    0x9446,
    0xdfa9,
    0x9447,
    0xb2c1,
    0x9448,
    0x9449,
    0x944a,
    0x944b,
    0x944c,
    0x944d,
    0x944e,
    0x944f,
    0x9450,
    0x9451,
    0x9452,
    0x9453,
    0x9454,
    0x9455,
    0x9456,
    0x9457,
    0x9458,
    0x9459,
    0x945a,
    0x945b,
    0x945c,
    0x945d,
    0x945e,
    0x945f,
    0x9460
};
UINT16 cp936_UNI_a0x65[] = {
    0xc5ca,
    0x9461,
    0x9462,
    0x9463,
    0x9464,
    0x9465,
    0x9466,
    0x9467,
    0x9468,
    0xdfab,
    0x9469,
    0x946a,
    0x946b,
    0x946c,
    0x946d,
    0x946e,
    0x946f,
    0x9470,
    0xd4dc,
    0x9471,
    0x9472,
    0x9473,
    0x9474,
    0x9475,
    0xc8c1,
    0x9476,
    0x9477,
    0x9478,
    0x9479,
    0x947a,
    0x947b,
    0x947c,
    0x947d,
    0x947e,
    0x9480,
    0x9481,
    0x9482,
    0xdfac,
    0x9483,
    0x9484,
    0x9485,
    0x9486,
    0x9487,
    0xbef0,
    0x9488,
    0x9489,
    0xdfad,
    0xd6a7,
    0x948a,
    0x948b,
    0x948c,
    0x948d,
    0xeab7,
    0xebb6,
    0xcad5,
    0x948e,
    0xd8fc,
    0xb8c4,
    0x948f,
    0xb9a5,
    0x9490,
    0x9491,
    0xb7c5,
    0xd5fe,
    0x9492,
    0x9493,
    0x9494,
    0x9495,
    0x9496,
    0xb9ca,
    0x9497,
    0x9498,
    0xd0a7,
    0xf4cd,
    0x9499,
    0x949a,
    0xb5d0,
    0x949b,
    0x949c,
    0xc3f4,
    0x949d,
    0xbec8,
    0x949e,
    0x949f,
    0x94a0,
    0xebb7,
    0xb0bd,
    0x94a1,
    0x94a2,
    0xbdcc,
    0x94a3,
    0xc1b2,
    0x94a4,
    0xb1d6,
    0xb3a8,
    0x94a5,
    0x94a6,
    0x94a7,
    0xb8d2,
    0xc9a2,
    0x94a8,
    0x94a9,
    0xb6d8,
    0x94aa,
    0x94ab,
    0x94ac,
    0x94ad,
    0xebb8,
    0xbeb4,
    0x94ae,
    0x94af,
    0x94b0,
    0xcafd,
    0x94b1,
    0xc7c3,
    0x94b2,
    0xd5fb,
    0x94b3,
    0x94b4,
    0xb7f3,
    0x94b5,
    0x94b6,
    0x94b7,
    0x94b8,
    0x94b9,
    0x94ba,
    0x94bb,
    0x94bc,
    0x94bd,
    0x94be,
    0x94bf,
    0x94c0,
    0x94c1,
    0x94c2,
    0x94c3,
    0xcec4,
    0x94c4,
    0x94c5,
    0x94c6,
    0xd5ab,
    0xb1f3,
    0x94c7,
    0x94c8,
    0x94c9,
    0xecb3,
    0xb0df,
    0x94ca,
    0xecb5,
    0x94cb,
    0x94cc,
    0x94cd,
    0xb6b7,
    0x94ce,
    0xc1cf,
    0x94cf,
    0xf5fa,
    0xd0b1,
    0x94d0,
    0x94d1,
    0xd5e5,
    0x94d2,
    0xced3,
    0x94d3,
    0x94d4,
    0xbdef,
    0xb3e2,
    0x94d5,
    0xb8ab,
    0x94d6,
    0xd5b6,
    0x94d7,
    0xedbd,
    0x94d8,
    0xb6cf,
    0x94d9,
    0xcbb9,
    0xd0c2,
    0x94da,
    0x94db,
    0x94dc,
    0x94dd,
    0x94de,
    0x94df,
    0x94e0,
    0x94e1,
    0xb7bd,
    0x94e2,
    0x94e3,
    0xecb6,
    0xcaa9,
    0x94e4,
    0x94e5,
    0x94e6,
    0xc5d4,
    0x94e7,
    0xecb9,
    0xecb8,
    0xc2c3,
    0xecb7,
    0x94e8,
    0x94e9,
    0x94ea,
    0x94eb,
    0xd0fd,
    0xecba,
    0x94ec,
    0xecbb,
    0xd7e5,
    0x94ed,
    0x94ee,
    0xecbc,
    0x94ef,
    0x94f0,
    0x94f1,
    0xecbd,
    0xc6ec,
    0x94f2,
    0x94f3,
    0x94f4,
    0x94f5,
    0x94f6,
    0x94f7,
    0x94f8,
    0x94f9,
    0xcede,
    0x94fa,
    0xbcc8,
    0x94fb,
    0x94fc,
    0xc8d5,
    0xb5a9,
    0xbec9,
    0xd6bc,
    0xd4e7,
    0x94fd,
    0x94fe,
    0xd1ae,
    0xd0f1,
    0xeab8,
    0xeab9,
    0xeaba,
    0xbab5,
    0x9540,
    0x9541,
    0x9542,
    0x9543,
    0xcab1,
    0xbff5,
    0x9544,
    0x9545,
    0xcdfa,
    0x9546,
    0x9547,
    0x9548,
    0x9549,
    0x954a
};
UINT16 cp936_UNI_a0x66[] = {
    0xeac0,
    0x954b,
    0xb0ba,
    0xeabe,
    0x954c,
    0x954d,
    0xc0a5,
    0x954e,
    0x954f,
    0x9550,
    0xeabb,
    0x9551,
    0xb2fd,
    0x9552,
    0xc3f7,
    0xbbe8,
    0x9553,
    0x9554,
    0x9555,
    0xd2d7,
    0xcef4,
    0xeabf,
    0x9556,
    0x9557,
    0x9558,
    0xeabc,
    0x9559,
    0x955a,
    0x955b,
    0xeac3,
    0x955c,
    0xd0c7,
    0xd3b3,
    0x955d,
    0x955e,
    0x955f,
    0x9560,
    0xb4ba,
    0x9561,
    0xc3c1,
    0xd7f2,
    0x9562,
    0x9563,
    0x9564,
    0x9565,
    0xd5d1,
    0x9566,
    0xcac7,
    0x9567,
    0xeac5,
    0x9568,
    0x9569,
    0xeac4,
    0xeac7,
    0xeac6,
    0x956a,
    0x956b,
    0x956c,
    0x956d,
    0x956e,
    0xd6e7,
    0x956f,
    0xcfd4,
    0x9570,
    0x9571,
    0xeacb,
    0x9572,
    0xbbce,
    0x9573,
    0x9574,
    0x9575,
    0x9576,
    0x9577,
    0x9578,
    0x9579,
    0xbdfa,
    0xc9ce,
    0x957a,
    0x957b,
    0xeacc,
    0x957c,
    0x957d,
    0xc9b9,
    0xcffe,
    0xeaca,
    0xd4ce,
    0xeacd,
    0xeacf,
    0x957e,
    0x9580,
    0xcded,
    0x9581,
    0x9582,
    0x9583,
    0x9584,
    0xeac9,
    0x9585,
    0xeace,
    0x9586,
    0x9587,
    0xceee,
    0x9588,
    0xbbde,
    0x9589,
    0xb3bf,
    0x958a,
    0x958b,
    0x958c,
    0x958d,
    0x958e,
    0xc6d5,
    0xbeb0,
    0xcefa,
    0x958f,
    0x9590,
    0x9591,
    0xc7e7,
    0x9592,
    0xbea7,
    0xead0,
    0x9593,
    0x9594,
    0xd6c7,
    0x9595,
    0x9596,
    0x9597,
    0xc1c0,
    0x9598,
    0x9599,
    0x959a,
    0xd4dd,
    0x959b,
    0xead1,
    0x959c,
    0x959d,
    0xcfbe,
    0x959e,
    0x959f,
    0x95a0,
    0x95a1,
    0xead2,
    0x95a2,
    0x95a3,
    0x95a4,
    0x95a5,
    0xcaee,
    0x95a6,
    0x95a7,
    0x95a8,
    0x95a9,
    0xc5af,
    0xb0b5,
    0x95aa,
    0x95ab,
    0x95ac,
    0x95ad,
    0x95ae,
    0xead4,
    0x95af,
    0x95b0,
    0x95b1,
    0x95b2,
    0x95b3,
    0x95b4,
    0x95b5,
    0x95b6,
    0x95b7,
    0xead3,
    0xf4df,
    0x95b8,
    0x95b9,
    0x95ba,
    0x95bb,
    0x95bc,
    0xc4ba,
    0x95bd,
    0x95be,
    0x95bf,
    0x95c0,
    0x95c1,
    0xb1a9,
    0x95c2,
    0x95c3,
    0x95c4,
    0x95c5,
    0xe5df,
    0x95c6,
    0x95c7,
    0x95c8,
    0x95c9,
    0xead5,
    0x95ca,
    0x95cb,
    0x95cc,
    0x95cd,
    0x95ce,
    0x95cf,
    0x95d0,
    0x95d1,
    0x95d2,
    0x95d3,
    0x95d4,
    0x95d5,
    0x95d6,
    0x95d7,
    0x95d8,
    0x95d9,
    0x95da,
    0x95db,
    0x95dc,
    0x95dd,
    0x95de,
    0x95df,
    0x95e0,
    0x95e1,
    0x95e2,
    0x95e3,
    0xcaef,
    0x95e4,
    0xead6,
    0xead7,
    0xc6d8,
    0x95e5,
    0x95e6,
    0x95e7,
    0x95e8,
    0x95e9,
    0x95ea,
    0x95eb,
    0x95ec,
    0xead8,
    0x95ed,
    0x95ee,
    0xead9,
    0x95ef,
    0x95f0,
    0x95f1,
    0x95f2,
    0x95f3,
    0x95f4,
    0xd4bb,
    0x95f5,
    0xc7fa,
    0xd2b7,
    0xb8fc,
    0x95f6,
    0x95f7,
    0xeac2,
    0x95f8,
    0xb2dc,
    0x95f9,
    0x95fa,
    0xc2fc,
    0x95fb,
    0xd4f8,
    0xcce6
};
UINT16 cp936_UNI_a0x67[] = {
    0xd7ee,
    0x95fc,
    0x95fd,
    0x95fe,
    0x9640,
    0x9641,
    0x9642,
    0x9643,
    0xd4c2,
    0xd3d0,
    0xebc3,
    0xc5f3,
    0x9644,
    0xb7fe,
    0x9645,
    0x9646,
    0xebd4,
    0x9647,
    0x9648,
    0x9649,
    0xcbb7,
    0xebde,
    0x964a,
    0xc0ca,
    0x964b,
    0x964c,
    0x964d,
    0xcdfb,
    0x964e,
    0xb3af,
    0x964f,
    0xc6da,
    0x9650,
    0x9651,
    0x9652,
    0x9653,
    0x9654,
    0x9655,
    0xebfc,
    0x9656,
    0xc4be,
    0x9657,
    0xceb4,
    0xc4a9,
    0xb1be,
    0xd4fd,
    0x9658,
    0xcaf5,
    0x9659,
    0xd6ec,
    0x965a,
    0x965b,
    0xc6d3,
    0xb6e4,
    0x965c,
    0x965d,
    0x965e,
    0x965f,
    0xbbfa,
    0x9660,
    0x9661,
    0xd0e0,
    0x9662,
    0x9663,
    0xc9b1,
    0x9664,
    0xd4d3,
    0xc8a8,
    0x9665,
    0x9666,
    0xb8cb,
    0x9667,
    0xe8be,
    0xc9bc,
    0x9668,
    0x9669,
    0xe8bb,
    0x966a,
    0xc0ee,
    0xd0d3,
    0xb2c4,
    0xb4e5,
    0x966b,
    0xe8bc,
    0x966c,
    0x966d,
    0xd5c8,
    0x966e,
    0x966f,
    0x9670,
    0x9671,
    0x9672,
    0xb6c5,
    0x9673,
    0xe8bd,
    0xcaf8,
    0xb8dc,
    0xccf5,
    0x9674,
    0x9675,
    0x9676,
    0xc0b4,
    0x9677,
    0x9678,
    0xd1ee,
    0xe8bf,
    0xe8c2,
    0x9679,
    0x967a,
    0xbabc,
    0x967b,
    0xb1ad,
    0xbddc,
    0x967c,
    0xeabd,
    0xe8c3,
    0x967d,
    0xe8c6,
    0x967e,
    0xe8cb,
    0x9680,
    0x9681,
    0x9682,
    0x9683,
    0xe8cc,
    0x9684,
    0xcbc9,
    0xb0e5,
    0x9685,
    0xbcab,
    0x9686,
    0x9687,
    0xb9b9,
    0x9688,
    0x9689,
    0xe8c1,
    0x968a,
    0xcdf7,
    0x968b,
    0xe8ca,
    0x968c,
    0x968d,
    0x968e,
    0x968f,
    0xcef6,
    0x9690,
    0x9691,
    0x9692,
    0x9693,
    0xd5ed,
    0x9694,
    0xc1d6,
    0xe8c4,
    0x9695,
    0xc3b6,
    0x9696,
    0xb9fb,
    0xd6a6,
    0xe8c8,
    0x9697,
    0x9698,
    0x9699,
    0xcae0,
    0xd4e6,
    0x969a,
    0xe8c0,
    0x969b,
    0xe8c5,
    0xe8c7,
    0x969c,
    0xc7b9,
    0xb7e3,
    0x969d,
    0xe8c9,
    0x969e,
    0xbfdd,
    0xe8d2,
    0x969f,
    0x96a0,
    0xe8d7,
    0x96a1,
    0xe8d5,
    0xbcdc,
    0xbccf,
    0xe8db,
    0x96a2,
    0x96a3,
    0x96a4,
    0x96a5,
    0x96a6,
    0x96a7,
    0x96a8,
    0x96a9,
    0xe8de,
    0x96aa,
    0xe8da,
    0xb1fa,
    0x96ab,
    0x96ac,
    0x96ad,
    0x96ae,
    0x96af,
    0x96b0,
    0x96b1,
    0x96b2,
    0x96b3,
    0x96b4,
    0xb0d8,
    0xc4b3,
    0xb8cc,
    0xc6e2,
    0xc8be,
    0xc8e1,
    0x96b5,
    0x96b6,
    0x96b7,
    0xe8cf,
    0xe8d4,
    0xe8d6,
    0x96b8,
    0xb9f1,
    0xe8d8,
    0xd7f5,
    0x96b9,
    0xc4fb,
    0x96ba,
    0xe8dc,
    0x96bb,
    0x96bc,
    0xb2e9,
    0x96bd,
    0x96be,
    0x96bf,
    0xe8d1,
    0x96c0,
    0x96c1,
    0xbced,
    0x96c2,
    0x96c3,
    0xbfc2,
    0xe8cd,
    0xd6f9,
    0x96c4,
    0xc1f8,
    0xb2f1,
    0x96c5,
    0x96c6,
    0x96c7,
    0x96c8,
    0x96c9,
    0x96ca,
    0x96cb,
    0x96cc,
    0xe8df,
    0x96cd,
    0xcac1
};
UINT16 cp936_UNI_a0x68[] = {
    0xe8d9,
    0x96ce,
    0x96cf,
    0x96d0,
    0x96d1,
    0xd5a4,
    0x96d2,
    0xb1ea,
    0xd5bb,
    0xe8ce,
    0xe8d0,
    0xb6b0,
    0xe8d3,
    0x96d3,
    0xe8dd,
    0xc0b8,
    0x96d4,
    0xcaf7,
    0x96d5,
    0xcba8,
    0x96d6,
    0x96d7,
    0xc6dc,
    0xc0f5,
    0x96d8,
    0x96d9,
    0x96da,
    0x96db,
    0x96dc,
    0xe8e9,
    0x96dd,
    0x96de,
    0x96df,
    0xd0a3,
    0x96e0,
    0x96e1,
    0x96e2,
    0x96e3,
    0x96e4,
    0x96e5,
    0x96e6,
    0xe8f2,
    0xd6ea,
    0x96e7,
    0x96e8,
    0x96e9,
    0x96ea,
    0x96eb,
    0x96ec,
    0x96ed,
    0xe8e0,
    0xe8e1,
    0x96ee,
    0x96ef,
    0x96f0,
    0xd1f9,
    0xbacb,
    0xb8f9,
    0x96f1,
    0x96f2,
    0xb8f1,
    0xd4d4,
    0xe8ef,
    0x96f3,
    0xe8ee,
    0xe8ec,
    0xb9f0,
    0xccd2,
    0xe8e6,
    0xcea6,
    0xbff2,
    0x96f4,
    0xb0b8,
    0xe8f1,
    0xe8f0,
    0x96f5,
    0xd7c0,
    0x96f6,
    0xe8e4,
    0x96f7,
    0xcda9,
    0xc9a3,
    0x96f8,
    0xbbb8,
    0xbddb,
    0xe8ea,
    0x96f9,
    0x96fa,
    0x96fb,
    0x96fc,
    0x96fd,
    0x96fe,
    0x9740,
    0x9741,
    0x9742,
    0x9743,
    0xe8e2,
    0xe8e3,
    0xe8e5,
    0xb5b5,
    0xe8e7,
    0xc7c5,
    0xe8eb,
    0xe8ed,
    0xbdb0,
    0xd7ae,
    0x9744,
    0xe8f8,
    0x9745,
    0x9746,
    0x9747,
    0x9748,
    0x9749,
    0x974a,
    0x974b,
    0x974c,
    0xe8f5,
    0x974d,
    0xcdb0,
    0xe8f6,
    0x974e,
    0x974f,
    0x9750,
    0x9751,
    0x9752,
    0x9753,
    0x9754,
    0x9755,
    0x9756,
    0xc1ba,
    0x9757,
    0xe8e8,
    0x9758,
    0xc3b7,
    0xb0f0,
    0x9759,
    0x975a,
    0x975b,
    0x975c,
    0x975d,
    0x975e,
    0x975f,
    0x9760,
    0xe8f4,
    0x9761,
    0x9762,
    0x9763,
    0xe8f7,
    0x9764,
    0x9765,
    0x9766,
    0xb9a3,
    0x9767,
    0x9768,
    0x9769,
    0x976a,
    0x976b,
    0x976c,
    0x976d,
    0x976e,
    0x976f,
    0x9770,
    0xc9d2,
    0x9771,
    0x9772,
    0x9773,
    0xc3ce,
    0xcee0,
    0xc0e6,
    0x9774,
    0x9775,
    0x9776,
    0x9777,
    0xcbf3,
    0x9778,
    0xccdd,
    0xd0b5,
    0x9779,
    0x977a,
    0xcae1,
    0x977b,
    0xe8f3,
    0x977c,
    0x977d,
    0x977e,
    0x9780,
    0x9781,
    0x9782,
    0x9783,
    0x9784,
    0x9785,
    0x9786,
    0xbcec,
    0x9787,
    0xe8f9,
    0x9788,
    0x9789,
    0x978a,
    0x978b,
    0x978c,
    0x978d,
    0xc3de,
    0x978e,
    0xc6e5,
    0x978f,
    0xb9f7,
    0x9790,
    0x9791,
    0x9792,
    0x9793,
    0xb0f4,
    0x9794,
    0x9795,
    0xd7d8,
    0x9796,
    0x9797,
    0xbcac,
    0x9798,
    0xc5ef,
    0x9799,
    0x979a,
    0x979b,
    0x979c,
    0x979d,
    0xccc4,
    0x979e,
    0x979f,
    0xe9a6,
    0x97a0,
    0x97a1,
    0x97a2,
    0x97a3,
    0x97a4,
    0x97a5,
    0x97a6,
    0x97a7,
    0x97a8,
    0x97a9,
    0xc9ad,
    0x97aa,
    0xe9a2,
    0xc0e2,
    0x97ab,
    0x97ac,
    0x97ad,
    0xbfc3,
    0x97ae,
    0x97af,
    0x97b0,
    0xe8fe,
    0xb9d7,
    0x97b1,
    0xe8fb,
    0x97b2,
    0x97b3,
    0x97b4
};
UINT16 cp936_UNI_a0x69[] = {
    0x97b5,
    0xe9a4,
    0x97b6,
    0x97b7,
    0x97b8,
    0xd2ce,
    0x97b9,
    0x97ba,
    0x97bb,
    0x97bc,
    0x97bd,
    0xe9a3,
    0x97be,
    0xd6b2,
    0xd7b5,
    0x97bf,
    0xe9a7,
    0x97c0,
    0xbdb7,
    0x97c1,
    0x97c2,
    0x97c3,
    0x97c4,
    0x97c5,
    0x97c6,
    0x97c7,
    0x97c8,
    0x97c9,
    0x97ca,
    0x97cb,
    0x97cc,
    0xe8fc,
    0xe8fd,
    0x97cd,
    0x97ce,
    0x97cf,
    0xe9a1,
    0x97d0,
    0x97d1,
    0x97d2,
    0x97d3,
    0x97d4,
    0x97d5,
    0x97d6,
    0x97d7,
    0xcdd6,
    0x97d8,
    0x97d9,
    0xd2ac,
    0x97da,
    0x97db,
    0x97dc,
    0xe9b2,
    0x97dd,
    0x97de,
    0x97df,
    0x97e0,
    0xe9a9,
    0x97e1,
    0x97e2,
    0x97e3,
    0xb4aa,
    0x97e4,
    0xb4bb,
    0x97e5,
    0x97e6,
    0xe9ab,
    0x97e7,
    0x97e8,
    0x97e9,
    0x97ea,
    0x97eb,
    0x97ec,
    0x97ed,
    0x97ee,
    0x97ef,
    0x97f0,
    0x97f1,
    0x97f2,
    0x97f3,
    0x97f4,
    0x97f5,
    0x97f6,
    0x97f7,
    0xd0a8,
    0x97f8,
    0x97f9,
    0xe9a5,
    0x97fa,
    0x97fb,
    0xb3fe,
    0x97fc,
    0x97fd,
    0xe9ac,
    0xc0e3,
    0x97fe,
    0xe9aa,
    0x9840,
    0x9841,
    0xe9b9,
    0x9842,
    0x9843,
    0xe9b8,
    0x9844,
    0x9845,
    0x9846,
    0x9847,
    0xe9ae,
    0x9848,
    0x9849,
    0xe8fa,
    0x984a,
    0x984b,
    0xe9a8,
    0x984c,
    0x984d,
    0x984e,
    0x984f,
    0x9850,
    0xbfac,
    0xe9b1,
    0xe9ba,
    0x9851,
    0x9852,
    0xc2a5,
    0x9853,
    0x9854,
    0x9855,
    0xe9af,
    0x9856,
    0xb8c5,
    0x9857,
    0xe9ad,
    0x9858,
    0xd3dc,
    0xe9b4,
    0xe9b5,
    0xe9b7,
    0x9859,
    0x985a,
    0x985b,
    0xe9c7,
    0x985c,
    0x985d,
    0x985e,
    0x985f,
    0x9860,
    0x9861,
    0xc0c6,
    0xe9c5,
    0x9862,
    0x9863,
    0xe9b0,
    0x9864,
    0x9865,
    0xe9bb,
    0xb0f1,
    0x9866,
    0x9867,
    0x9868,
    0x9869,
    0x986a,
    0x986b,
    0x986c,
    0x986d,
    0x986e,
    0x986f,
    0xe9bc,
    0xd5a5,
    0x9870,
    0x9871,
    0xe9be,
    0x9872,
    0xe9bf,
    0x9873,
    0x9874,
    0x9875,
    0xe9c1,
    0x9876,
    0x9877,
    0xc1f1,
    0x9878,
    0x9879,
    0xc8b6,
    0x987a,
    0x987b,
    0x987c,
    0xe9bd,
    0x987d,
    0x987e,
    0x9880,
    0x9881,
    0x9882,
    0xe9c2,
    0x9883,
    0x9884,
    0x9885,
    0x9886,
    0x9887,
    0x9888,
    0x9889,
    0x988a,
    0xe9c3,
    0x988b,
    0xe9b3,
    0x988c,
    0xe9b6,
    0x988d,
    0xbbb1,
    0x988e,
    0x988f,
    0x9890,
    0xe9c0,
    0x9891,
    0x9892,
    0x9893,
    0x9894,
    0x9895,
    0x9896,
    0xbcf7,
    0x9897,
    0x9898,
    0x9899,
    0xe9c4,
    0xe9c6,
    0x989a,
    0x989b,
    0x989c,
    0x989d,
    0x989e,
    0x989f,
    0x98a0,
    0x98a1,
    0x98a2,
    0x98a3,
    0x98a4,
    0x98a5,
    0xe9ca,
    0x98a6,
    0x98a7,
    0x98a8,
    0x98a9,
    0xe9ce,
    0x98aa,
    0x98ab,
    0x98ac,
    0x98ad,
    0x98ae,
    0x98af,
    0x98b0,
    0x98b1,
    0x98b2,
    0x98b3,
    0xb2db,
    0x98b4,
    0xe9c8
};
UINT16 cp936_UNI_a0x6a[] = {
    0x98b5,
    0x98b6,
    0x98b7,
    0x98b8,
    0x98b9,
    0x98ba,
    0x98bb,
    0x98bc,
    0x98bd,
    0x98be,
    0xb7ae,
    0x98bf,
    0x98c0,
    0x98c1,
    0x98c2,
    0x98c3,
    0x98c4,
    0x98c5,
    0x98c6,
    0x98c7,
    0x98c8,
    0x98c9,
    0x98ca,
    0xe9cb,
    0xe9cc,
    0x98cb,
    0x98cc,
    0x98cd,
    0x98ce,
    0x98cf,
    0x98d0,
    0xd5c1,
    0x98d1,
    0xc4a3,
    0x98d2,
    0x98d3,
    0x98d4,
    0x98d5,
    0x98d6,
    0x98d7,
    0xe9d8,
    0x98d8,
    0xbae1,
    0x98d9,
    0x98da,
    0x98db,
    0x98dc,
    0xe9c9,
    0x98dd,
    0xd3a3,
    0x98de,
    0x98df,
    0x98e0,
    0xe9d4,
    0x98e1,
    0x98e2,
    0x98e3,
    0x98e4,
    0x98e5,
    0x98e6,
    0x98e7,
    0xe9d7,
    0xe9d0,
    0x98e8,
    0x98e9,
    0x98ea,
    0x98eb,
    0x98ec,
    0xe9cf,
    0x98ed,
    0x98ee,
    0xc7c1,
    0x98ef,
    0x98f0,
    0x98f1,
    0x98f2,
    0x98f3,
    0x98f4,
    0x98f5,
    0x98f6,
    0xe9d2,
    0x98f7,
    0x98f8,
    0x98f9,
    0x98fa,
    0x98fb,
    0x98fc,
    0x98fd,
    0xe9d9,
    0xb3c8,
    0x98fe,
    0xe9d3,
    0x9940,
    0x9941,
    0x9942,
    0x9943,
    0x9944,
    0xcff0,
    0x9945,
    0x9946,
    0x9947,
    0xe9cd,
    0x9948,
    0x9949,
    0x994a,
    0x994b,
    0x994c,
    0x994d,
    0x994e,
    0x994f,
    0x9950,
    0x9951,
    0x9952,
    0xb3f7,
    0x9953,
    0x9954,
    0x9955,
    0x9956,
    0x9957,
    0x9958,
    0x9959,
    0xe9d6,
    0x995a,
    0x995b,
    0xe9da,
    0x995c,
    0x995d,
    0x995e,
    0xccb4,
    0x995f,
    0x9960,
    0x9961,
    0xcfad,
    0x9962,
    0x9963,
    0x9964,
    0x9965,
    0x9966,
    0x9967,
    0x9968,
    0x9969,
    0x996a,
    0xe9d5,
    0x996b,
    0xe9dc,
    0xe9db,
    0x996c,
    0x996d,
    0x996e,
    0x996f,
    0x9970,
    0xe9de,
    0x9971,
    0x9972,
    0x9973,
    0x9974,
    0x9975,
    0x9976,
    0x9977,
    0x9978,
    0xe9d1,
    0x9979,
    0x997a,
    0x997b,
    0x997c,
    0x997d,
    0x997e,
    0x9980,
    0x9981,
    0xe9dd,
    0x9982,
    0xe9df,
    0xc3ca,
    0x9983,
    0x9984,
    0x9985,
    0x9986,
    0x9987,
    0x9988,
    0x9989,
    0x998a,
    0x998b,
    0x998c,
    0x998d,
    0x998e,
    0x998f,
    0x9990,
    0x9991,
    0x9992,
    0x9993,
    0x9994,
    0x9995,
    0x9996,
    0x9997,
    0x9998,
    0x9999,
    0x999a,
    0x999b,
    0x999c,
    0x999d,
    0x999e,
    0x999f,
    0x99a0,
    0x99a1,
    0x99a2,
    0x99a3,
    0x99a4,
    0x99a5,
    0x99a6,
    0x99a7,
    0x99a8,
    0x99a9,
    0x99aa,
    0x99ab,
    0x99ac,
    0x99ad,
    0x99ae,
    0x99af,
    0x99b0,
    0x99b1,
    0x99b2,
    0x99b3,
    0x99b4,
    0x99b5,
    0x99b6,
    0x99b7,
    0x99b8,
    0x99b9,
    0x99ba,
    0x99bb,
    0x99bc,
    0x99bd,
    0x99be,
    0x99bf,
    0x99c0,
    0x99c1,
    0x99c2,
    0x99c3,
    0x99c4,
    0x99c5,
    0x99c6,
    0x99c7,
    0x99c8,
    0x99c9,
    0x99ca,
    0x99cb,
    0x99cc,
    0x99cd,
    0x99ce,
    0x99cf,
    0x99d0,
    0x99d1,
    0x99d2,
    0x99d3,
    0x99d4,
    0x99d5
};
UINT16 cp936_UNI_a0x6b[] = {
    0x99d6,
    0x99d7,
    0x99d8,
    0x99d9,
    0x99da,
    0x99db,
    0x99dc,
    0x99dd,
    0x99de,
    0x99df,
    0x99e0,
    0x99e1,
    0x99e2,
    0x99e3,
    0x99e4,
    0x99e5,
    0x99e6,
    0x99e7,
    0x99e8,
    0x99e9,
    0x99ea,
    0x99eb,
    0x99ec,
    0x99ed,
    0x99ee,
    0x99ef,
    0x99f0,
    0x99f1,
    0x99f2,
    0x99f3,
    0x99f4,
    0x99f5,
    0xc7b7,
    0xb4ce,
    0xbbb6,
    0xd0c0,
    0xeca3,
    0x99f6,
    0x99f7,
    0xc5b7,
    0x99f8,
    0x99f9,
    0x99fa,
    0x99fb,
    0x99fc,
    0x99fd,
    0x99fe,
    0x9a40,
    0x9a41,
    0x9a42,
    0xd3fb,
    0x9a43,
    0x9a44,
    0x9a45,
    0x9a46,
    0xeca4,
    0x9a47,
    0xeca5,
    0xc6db,
    0x9a48,
    0x9a49,
    0x9a4a,
    0xbfee,
    0x9a4b,
    0x9a4c,
    0x9a4d,
    0x9a4e,
    0xeca6,
    0x9a4f,
    0x9a50,
    0xeca7,
    0xd0aa,
    0x9a51,
    0xc7b8,
    0x9a52,
    0x9a53,
    0xb8e8,
    0x9a54,
    0x9a55,
    0x9a56,
    0x9a57,
    0x9a58,
    0x9a59,
    0x9a5a,
    0x9a5b,
    0x9a5c,
    0x9a5d,
    0x9a5e,
    0x9a5f,
    0xeca8,
    0x9a60,
    0x9a61,
    0x9a62,
    0x9a63,
    0x9a64,
    0x9a65,
    0x9a66,
    0x9a67,
    0xd6b9,
    0xd5fd,
    0xb4cb,
    0xb2bd,
    0xcee4,
    0xc6e7,
    0x9a68,
    0x9a69,
    0xcde1,
    0x9a6a,
    0x9a6b,
    0x9a6c,
    0x9a6d,
    0x9a6e,
    0x9a6f,
    0x9a70,
    0x9a71,
    0x9a72,
    0x9a73,
    0x9a74,
    0x9a75,
    0x9a76,
    0x9a77,
    0xb4f5,
    0x9a78,
    0xcbc0,
    0xbcdf,
    0x9a79,
    0x9a7a,
    0x9a7b,
    0x9a7c,
    0xe9e2,
    0xe9e3,
    0xd1ea,
    0xe9e5,
    0x9a7d,
    0xb4f9,
    0xe9e4,
    0x9a7e,
    0xd1b3,
    0xcae2,
    0xb2d0,
    0x9a80,
    0xe9e8,
    0x9a81,
    0x9a82,
    0x9a83,
    0x9a84,
    0xe9e6,
    0xe9e7,
    0x9a85,
    0x9a86,
    0xd6b3,
    0x9a87,
    0x9a88,
    0x9a89,
    0xe9e9,
    0xe9ea,
    0x9a8a,
    0x9a8b,
    0x9a8c,
    0x9a8d,
    0x9a8e,
    0xe9eb,
    0x9a8f,
    0x9a90,
    0x9a91,
    0x9a92,
    0x9a93,
    0x9a94,
    0x9a95,
    0x9a96,
    0xe9ec,
    0x9a97,
    0x9a98,
    0x9a99,
    0x9a9a,
    0x9a9b,
    0x9a9c,
    0x9a9d,
    0x9a9e,
    0xecaf,
    0xc5b9,
    0xb6ce,
    0x9a9f,
    0xd2f3,
    0x9aa0,
    0x9aa1,
    0x9aa2,
    0x9aa3,
    0x9aa4,
    0x9aa5,
    0x9aa6,
    0xb5ee,
    0x9aa7,
    0xbbd9,
    0xecb1,
    0x9aa8,
    0x9aa9,
    0xd2e3,
    0x9aaa,
    0x9aab,
    0x9aac,
    0x9aad,
    0x9aae,
    0xcee3,
    0x9aaf,
    0xc4b8,
    0x9ab0,
    0xc3bf,
    0x9ab1,
    0x9ab2,
    0xb6be,
    0xd8b9,
    0xb1c8,
    0xb1cf,
    0xb1d1,
    0xc5fe,
    0x9ab3,
    0xb1d0,
    0x9ab4,
    0xc3ab,
    0x9ab5,
    0x9ab6,
    0x9ab7,
    0x9ab8,
    0x9ab9,
    0xd5b1,
    0x9aba,
    0x9abb,
    0x9abc,
    0x9abd,
    0x9abe,
    0x9abf,
    0x9ac0,
    0x9ac1,
    0xeba4,
    0xbac1,
    0x9ac2,
    0x9ac3,
    0x9ac4,
    0xccba,
    0x9ac5,
    0x9ac6,
    0x9ac7,
    0xeba5,
    0x9ac8,
    0xeba7,
    0x9ac9,
    0x9aca,
    0x9acb,
    0xeba8,
    0x9acc,
    0x9acd,
    0x9ace,
    0xeba6,
    0x9acf,
    0x9ad0
};
UINT16 cp936_UNI_a0x6c[] = {
    0x9ad1,
    0x9ad2,
    0x9ad3,
    0x9ad4,
    0x9ad5,
    0xeba9,
    0xebab,
    0xebaa,
    0x9ad6,
    0x9ad7,
    0x9ad8,
    0x9ad9,
    0x9ada,
    0xebac,
    0x9adb,
    0xcacf,
    0xd8b5,
    0xc3f1,
    0x9adc,
    0xc3a5,
    0xc6f8,
    0xebad,
    0xc4ca,
    0x9add,
    0xebae,
    0xebaf,
    0xebb0,
    0xb7d5,
    0x9ade,
    0x9adf,
    0x9ae0,
    0xb7fa,
    0x9ae1,
    0xebb1,
    0xc7e2,
    0x9ae2,
    0xebb3,
    0x9ae3,
    0xbaa4,
    0xd1f5,
    0xb0b1,
    0xebb2,
    0xebb4,
    0x9ae4,
    0x9ae5,
    0x9ae6,
    0xb5aa,
    0xc2c8,
    0xc7e8,
    0x9ae7,
    0xebb5,
    0x9ae8,
    0xcbae,
    0xe3df,
    0x9ae9,
    0x9aea,
    0xd3c0,
    0x9aeb,
    0x9aec,
    0x9aed,
    0x9aee,
    0xd9db,
    0x9aef,
    0x9af0,
    0xcda1,
    0xd6ad,
    0xc7f3,
    0x9af1,
    0x9af2,
    0x9af3,
    0xd9e0,
    0xbbe3,
    0x9af4,
    0xbaba,
    0xe3e2,
    0x9af5,
    0x9af6,
    0x9af7,
    0x9af8,
    0x9af9,
    0xcfab,
    0x9afa,
    0x9afb,
    0x9afc,
    0xe3e0,
    0xc9c7,
    0x9afd,
    0xbab9,
    0x9afe,
    0x9b40,
    0x9b41,
    0xd1b4,
    0xe3e1,
    0xc8ea,
    0xb9af,
    0xbdad,
    0xb3d8,
    0xcedb,
    0x9b42,
    0x9b43,
    0xccc0,
    0x9b44,
    0x9b45,
    0x9b46,
    0xe3e8,
    0xe3e9,
    0xcdf4,
    0x9b47,
    0x9b48,
    0x9b49,
    0x9b4a,
    0x9b4b,
    0xccad,
    0x9b4c,
    0xbcb3,
    0x9b4d,
    0xe3ea,
    0x9b4e,
    0xe3eb,
    0x9b4f,
    0x9b50,
    0xd0da,
    0x9b51,
    0x9b52,
    0x9b53,
    0xc6fb,
    0xb7da,
    0x9b54,
    0x9b55,
    0xc7df,
    0xd2ca,
    0xced6,
    0x9b56,
    0xe3e4,
    0xe3ec,
    0x9b57,
    0xc9f2,
    0xb3c1,
    0x9b58,
    0x9b59,
    0xe3e7,
    0x9b5a,
    0x9b5b,
    0xc6e3,
    0xe3e5,
    0x9b5c,
    0x9b5d,
    0xedb3,
    0xe3e6,
    0x9b5e,
    0x9b5f,
    0x9b60,
    0x9b61,
    0xc9b3,
    0x9b62,
    0xc5e6,
    0x9b63,
    0x9b64,
    0x9b65,
    0xb9b5,
    0x9b66,
    0xc3bb,
    0x9b67,
    0xe3e3,
    0xc5bd,
    0xc1a4,
    0xc2d9,
    0xb2d7,
    0x9b68,
    0xe3ed,
    0xbba6,
    0xc4ad,
    0x9b69,
    0xe3f0,
    0xbeda,
    0x9b6a,
    0x9b6b,
    0xe3fb,
    0xe3f5,
    0xbad3,
    0x9b6c,
    0x9b6d,
    0x9b6e,
    0x9b6f,
    0xb7d0,
    0xd3cd,
    0x9b70,
    0xd6ce,
    0xd5d3,
    0xb9c1,
    0xd5b4,
    0xd1d8,
    0x9b71,
    0x9b72,
    0x9b73,
    0x9b74,
    0xd0b9,
    0xc7f6,
    0x9b75,
    0x9b76,
    0x9b77,
    0xc8aa,
    0xb2b4,
    0x9b78,
    0xc3da,
    0x9b79,
    0x9b7a,
    0x9b7b,
    0xe3ee,
    0x9b7c,
    0x9b7d,
    0xe3fc,
    0xe3ef,
    0xb7a8,
    0xe3f7,
    0xe3f4,
    0x9b7e,
    0x9b80,
    0x9b81,
    0xb7ba,
    0x9b82,
    0x9b83,
    0xc5a2,
    0x9b84,
    0xe3f6,
    0xc5dd,
    0xb2a8,
    0xc6fc,
    0x9b85,
    0xc4e0,
    0x9b86,
    0x9b87,
    0xd7a2,
    0x9b88,
    0xc0e1,
    0xe3f9,
    0x9b89,
    0x9b8a,
    0xe3fa,
    0xe3fd,
    0xcca9,
    0xe3f3,
    0x9b8b,
    0xd3be,
    0x9b8c,
    0xb1c3,
    0xedb4,
    0xe3f1,
    0xe3f2,
    0x9b8d,
    0xe3f8,
    0xd0ba,
    0xc6c3,
    0xd4f3,
    0xe3fe,
    0x9b8e
};
UINT16 cp936_UNI_a0x6d[] = {
    0x9b8f,
    0xbde0,
    0x9b90,
    0x9b91,
    0xe4a7,
    0x9b92,
    0x9b93,
    0xe4a6,
    0x9b94,
    0x9b95,
    0x9b96,
    0xd1f3,
    0xe4a3,
    0x9b97,
    0xe4a9,
    0x9b98,
    0x9b99,
    0x9b9a,
    0xc8f7,
    0x9b9b,
    0x9b9c,
    0x9b9d,
    0x9b9e,
    0xcfb4,
    0x9b9f,
    0xe4a8,
    0xe4ae,
    0xc2e5,
    0x9ba0,
    0x9ba1,
    0xb6b4,
    0x9ba2,
    0x9ba3,
    0x9ba4,
    0x9ba5,
    0x9ba6,
    0x9ba7,
    0xbdf2,
    0x9ba8,
    0xe4a2,
    0x9ba9,
    0x9baa,
    0xbae9,
    0xe4aa,
    0x9bab,
    0x9bac,
    0xe4ac,
    0x9bad,
    0x9bae,
    0xb6fd,
    0xd6de,
    0xe4b2,
    0x9baf,
    0xe4ad,
    0x9bb0,
    0x9bb1,
    0x9bb2,
    0xe4a1,
    0x9bb3,
    0xbbee,
    0xcddd,
    0xc7a2,
    0xc5c9,
    0x9bb4,
    0x9bb5,
    0xc1f7,
    0x9bb6,
    0xe4a4,
    0x9bb7,
    0xc7b3,
    0xbdac,
    0xbdbd,
    0xe4a5,
    0x9bb8,
    0xd7c7,
    0xb2e2,
    0x9bb9,
    0xe4ab,
    0xbcc3,
    0xe4af,
    0x9bba,
    0xbbeb,
    0xe4b0,
    0xc5a8,
    0xe4b1,
    0x9bbb,
    0x9bbc,
    0x9bbd,
    0x9bbe,
    0xd5e3,
    0xbfa3,
    0x9bbf,
    0xe4ba,
    0x9bc0,
    0xe4b7,
    0x9bc1,
    0xe4bb,
    0x9bc2,
    0x9bc3,
    0xe4bd,
    0x9bc4,
    0x9bc5,
    0xc6d6,
    0x9bc6,
    0x9bc7,
    0xbac6,
    0xc0cb,
    0x9bc8,
    0x9bc9,
    0x9bca,
    0xb8a1,
    0xe4b4,
    0x9bcb,
    0x9bcc,
    0x9bcd,
    0x9bce,
    0xd4a1,
    0x9bcf,
    0x9bd0,
    0xbaa3,
    0xbdfe,
    0x9bd1,
    0x9bd2,
    0x9bd3,
    0xe4bc,
    0x9bd4,
    0x9bd5,
    0x9bd6,
    0x9bd7,
    0x9bd8,
    0xcdbf,
    0x9bd9,
    0x9bda,
    0xc4f9,
    0x9bdb,
    0x9bdc,
    0xcffb,
    0xc9e6,
    0x9bdd,
    0x9bde,
    0xd3bf,
    0x9bdf,
    0xcfd1,
    0x9be0,
    0x9be1,
    0xe4b3,
    0x9be2,
    0xe4b8,
    0xe4b9,
    0xcce9,
    0x9be3,
    0x9be4,
    0x9be5,
    0x9be6,
    0x9be7,
    0xccce,
    0x9be8,
    0xc0d4,
    0xe4b5,
    0xc1b0,
    0xe4b6,
    0xced0,
    0x9be9,
    0xbbc1,
    0xb5d3,
    0x9bea,
    0xc8f3,
    0xbda7,
    0xd5c7,
    0xc9ac,
    0xb8a2,
    0xe4ca,
    0x9beb,
    0x9bec,
    0xe4cc,
    0xd1c4,
    0x9bed,
    0x9bee,
    0xd2ba,
    0x9bef,
    0x9bf0,
    0xbaad,
    0x9bf1,
    0x9bf2,
    0xbad4,
    0x9bf3,
    0x9bf4,
    0x9bf5,
    0x9bf6,
    0x9bf7,
    0x9bf8,
    0xe4c3,
    0xb5ed,
    0x9bf9,
    0x9bfa,
    0x9bfb,
    0xd7cd,
    0xe4c0,
    0xcffd,
    0xe4bf,
    0x9bfc,
    0x9bfd,
    0x9bfe,
    0xc1dc,
    0xccca,
    0x9c40,
    0x9c41,
    0x9c42,
    0x9c43,
    0xcae7,
    0x9c44,
    0x9c45,
    0x9c46,
    0x9c47,
    0xc4d7,
    0x9c48,
    0xccd4,
    0xe4c8,
    0x9c49,
    0x9c4a,
    0x9c4b,
    0xe4c7,
    0xe4c1,
    0x9c4c,
    0xe4c4,
    0xb5ad,
    0x9c4d,
    0x9c4e,
    0xd3d9,
    0x9c4f,
    0xe4c6,
    0x9c50,
    0x9c51,
    0x9c52,
    0x9c53,
    0xd2f9,
    0xb4e3,
    0x9c54,
    0xbbb4,
    0x9c55,
    0x9c56,
    0xc9ee,
    0x9c57,
    0xb4be,
    0x9c58,
    0x9c59,
    0x9c5a,
    0xbbec,
    0x9c5b,
    0xd1cd,
    0x9c5c,
    0xcced,
    0xedb5,
    0x9c5d,
    0x9c5e,
    0x9c5f
};
UINT16 cp936_UNI_a0x6e[] = {
    0x9c60,
    0x9c61,
    0x9c62,
    0x9c63,
    0x9c64,
    0xc7e5,
    0x9c65,
    0x9c66,
    0x9c67,
    0x9c68,
    0xd4a8,
    0x9c69,
    0xe4cb,
    0xd7d5,
    0xe4c2,
    0x9c6a,
    0xbda5,
    0xe4c5,
    0x9c6b,
    0x9c6c,
    0xd3e6,
    0x9c6d,
    0xe4c9,
    0xc9f8,
    0x9c6e,
    0x9c6f,
    0xe4be,
    0x9c70,
    0x9c71,
    0xd3e5,
    0x9c72,
    0x9c73,
    0xc7fe,
    0xb6c9,
    0x9c74,
    0xd4fc,
    0xb2b3,
    0xe4d7,
    0x9c75,
    0x9c76,
    0x9c77,
    0xcec2,
    0x9c78,
    0xe4cd,
    0x9c79,
    0xcebc,
    0x9c7a,
    0xb8db,
    0x9c7b,
    0x9c7c,
    0xe4d6,
    0x9c7d,
    0xbfca,
    0x9c7e,
    0x9c80,
    0x9c81,
    0xd3ce,
    0x9c82,
    0xc3ec,
    0x9c83,
    0x9c84,
    0x9c85,
    0x9c86,
    0x9c87,
    0x9c88,
    0x9c89,
    0x9c8a,
    0xc5c8,
    0xe4d8,
    0x9c8b,
    0x9c8c,
    0x9c8d,
    0x9c8e,
    0x9c8f,
    0x9c90,
    0x9c91,
    0x9c92,
    0xcdc4,
    0xe4cf,
    0x9c93,
    0x9c94,
    0x9c95,
    0x9c96,
    0xe4d4,
    0xe4d5,
    0x9c97,
    0xbafe,
    0x9c98,
    0xcfe6,
    0x9c99,
    0x9c9a,
    0xd5bf,
    0x9c9b,
    0x9c9c,
    0x9c9d,
    0xe4d2,
    0x9c9e,
    0x9c9f,
    0x9ca0,
    0x9ca1,
    0x9ca2,
    0x9ca3,
    0x9ca4,
    0x9ca5,
    0x9ca6,
    0x9ca7,
    0x9ca8,
    0xe4d0,
    0x9ca9,
    0x9caa,
    0xe4ce,
    0x9cab,
    0x9cac,
    0x9cad,
    0x9cae,
    0x9caf,
    0x9cb0,
    0x9cb1,
    0x9cb2,
    0x9cb3,
    0x9cb4,
    0x9cb5,
    0x9cb6,
    0x9cb7,
    0x9cb8,
    0x9cb9,
    0xcde5,
    0xcaaa,
    0x9cba,
    0x9cbb,
    0x9cbc,
    0xc0a3,
    0x9cbd,
    0xbda6,
    0xe4d3,
    0x9cbe,
    0x9cbf,
    0xb8c8,
    0x9cc0,
    0x9cc1,
    0x9cc2,
    0x9cc3,
    0x9cc4,
    0xe4e7,
    0xd4b4,
    0x9cc5,
    0x9cc6,
    0x9cc7,
    0x9cc8,
    0x9cc9,
    0x9cca,
    0x9ccb,
    0xe4db,
    0x9ccc,
    0x9ccd,
    0x9cce,
    0xc1ef,
    0x9ccf,
    0x9cd0,
    0xe4e9,
    0x9cd1,
    0x9cd2,
    0xd2e7,
    0x9cd3,
    0x9cd4,
    0xe4df,
    0x9cd5,
    0xe4e0,
    0x9cd6,
    0x9cd7,
    0xcfaa,
    0x9cd8,
    0x9cd9,
    0x9cda,
    0x9cdb,
    0xcbdd,
    0x9cdc,
    0xe4da,
    0xe4d1,
    0x9cdd,
    0xe4e5,
    0x9cde,
    0xc8dc,
    0xe4e3,
    0x9cdf,
    0x9ce0,
    0xc4e7,
    0xe4e2,
    0x9ce1,
    0xe4e1,
    0x9ce2,
    0x9ce3,
    0x9ce4,
    0xb3fc,
    0xe4e8,
    0x9ce5,
    0x9ce6,
    0x9ce7,
    0x9ce8,
    0xb5e1,
    0x9ce9,
    0x9cea,
    0x9ceb,
    0xd7cc,
    0x9cec,
    0x9ced,
    0x9cee,
    0xe4e6,
    0x9cef,
    0xbbac,
    0x9cf0,
    0xd7d2,
    0xcccf,
    0xebf8,
    0x9cf1,
    0xe4e4,
    0x9cf2,
    0x9cf3,
    0xb9f6,
    0x9cf4,
    0x9cf5,
    0x9cf6,
    0xd6cd,
    0xe4d9,
    0xe4dc,
    0xc2fa,
    0xe4de,
    0x9cf7,
    0xc2cb,
    0xc0c4,
    0xc2d0,
    0x9cf8,
    0xb1f5,
    0xccb2,
    0x9cf9,
    0x9cfa,
    0x9cfb,
    0x9cfc,
    0x9cfd,
    0x9cfe,
    0x9d40,
    0x9d41,
    0x9d42,
    0x9d43,
    0xb5ce,
    0x9d44,
    0x9d45,
    0x9d46,
    0x9d47,
    0xe4ef,
    0x9d48,
    0x9d49,
    0x9d4a,
    0x9d4b,
    0x9d4c,
    0x9d4d
};
UINT16 cp936_UNI_a0x6f[] = {
    0x9d4e,
    0x9d4f,
    0xc6af,
    0x9d50,
    0x9d51,
    0x9d52,
    0xc6e1,
    0x9d53,
    0x9d54,
    0xe4f5,
    0x9d55,
    0x9d56,
    0x9d57,
    0x9d58,
    0x9d59,
    0xc2a9,
    0x9d5a,
    0x9d5b,
    0x9d5c,
    0xc0ec,
    0xd1dd,
    0xe4ee,
    0x9d5d,
    0x9d5e,
    0x9d5f,
    0x9d60,
    0x9d61,
    0x9d62,
    0x9d63,
    0x9d64,
    0x9d65,
    0x9d66,
    0xc4ae,
    0x9d67,
    0x9d68,
    0x9d69,
    0xe4ed,
    0x9d6a,
    0x9d6b,
    0x9d6c,
    0x9d6d,
    0xe4f6,
    0xe4f4,
    0xc2fe,
    0x9d6e,
    0xe4dd,
    0x9d6f,
    0xe4f0,
    0x9d70,
    0xcafe,
    0x9d71,
    0xd5c4,
    0x9d72,
    0x9d73,
    0xe4f1,
    0x9d74,
    0x9d75,
    0x9d76,
    0x9d77,
    0x9d78,
    0x9d79,
    0x9d7a,
    0xd1fa,
    0x9d7b,
    0x9d7c,
    0x9d7d,
    0x9d7e,
    0x9d80,
    0x9d81,
    0x9d82,
    0xe4eb,
    0xe4ec,
    0x9d83,
    0x9d84,
    0x9d85,
    0xe4f2,
    0x9d86,
    0xceab,
    0x9d87,
    0x9d88,
    0x9d89,
    0x9d8a,
    0x9d8b,
    0x9d8c,
    0x9d8d,
    0x9d8e,
    0x9d8f,
    0x9d90,
    0xc5cb,
    0x9d91,
    0x9d92,
    0x9d93,
    0xc7b1,
    0x9d94,
    0xc2ba,
    0x9d95,
    0x9d96,
    0x9d97,
    0xe4ea,
    0x9d98,
    0x9d99,
    0x9d9a,
    0xc1ca,
    0x9d9b,
    0x9d9c,
    0x9d9d,
    0x9d9e,
    0x9d9f,
    0x9da0,
    0xccb6,
    0xb3b1,
    0x9da1,
    0x9da2,
    0x9da3,
    0xe4fb,
    0x9da4,
    0xe4f3,
    0x9da5,
    0x9da6,
    0x9da7,
    0xe4fa,
    0x9da8,
    0xe4fd,
    0x9da9,
    0xe4fc,
    0x9daa,
    0x9dab,
    0x9dac,
    0x9dad,
    0x9dae,
    0x9daf,
    0x9db0,
    0xb3ce,
    0x9db1,
    0x9db2,
    0x9db3,
    0xb3ba,
    0xe4f7,
    0x9db4,
    0x9db5,
    0xe4f9,
    0xe4f8,
    0xc5ec,
    0x9db6,
    0x9db7,
    0x9db8,
    0x9db9,
    0x9dba,
    0x9dbb,
    0x9dbc,
    0x9dbd,
    0x9dbe,
    0x9dbf,
    0x9dc0,
    0x9dc1,
    0x9dc2,
    0xc0bd,
    0x9dc3,
    0x9dc4,
    0x9dc5,
    0x9dc6,
    0xd4e8,
    0x9dc7,
    0x9dc8,
    0x9dc9,
    0x9dca,
    0x9dcb,
    0xe5a2,
    0x9dcc,
    0x9dcd,
    0x9dce,
    0x9dcf,
    0x9dd0,
    0x9dd1,
    0x9dd2,
    0x9dd3,
    0x9dd4,
    0x9dd5,
    0x9dd6,
    0xb0c4,
    0x9dd7,
    0x9dd8,
    0xe5a4,
    0x9dd9,
    0x9dda,
    0xe5a3,
    0x9ddb,
    0x9ddc,
    0x9ddd,
    0x9dde,
    0x9ddf,
    0x9de0,
    0xbca4,
    0x9de1,
    0xe5a5,
    0x9de2,
    0x9de3,
    0x9de4,
    0x9de5,
    0x9de6,
    0x9de7,
    0xe5a1,
    0x9de8,
    0x9de9,
    0x9dea,
    0x9deb,
    0x9dec,
    0x9ded,
    0x9dee,
    0xe4fe,
    0xb1f4,
    0x9def,
    0x9df0,
    0x9df1,
    0x9df2,
    0x9df3,
    0x9df4,
    0x9df5,
    0x9df6,
    0x9df7,
    0x9df8,
    0x9df9,
    0xe5a8,
    0x9dfa,
    0xe5a9,
    0xe5a6,
    0x9dfb,
    0x9dfc,
    0x9dfd,
    0x9dfe,
    0x9e40,
    0x9e41,
    0x9e42,
    0x9e43,
    0x9e44,
    0x9e45,
    0x9e46,
    0x9e47,
    0xe5a7,
    0xe5aa,
    0x9e48,
    0x9e49,
    0x9e4a,
    0x9e4b,
    0x9e4c,
    0x9e4d,
    0x9e4e,
    0x9e4f,
    0x9e50,
    0x9e51,
    0x9e52,
    0x9e53,
    0x9e54,
    0x9e55,
    0x9e56,
    0x9e57
};
UINT16 cp936_UNI_a0x70[] = {
    0x9e58,
    0x9e59,
    0x9e5a,
    0x9e5b,
    0x9e5c,
    0x9e5d,
    0x9e5e,
    0x9e5f,
    0x9e60,
    0x9e61,
    0x9e62,
    0x9e63,
    0x9e64,
    0x9e65,
    0x9e66,
    0x9e67,
    0x9e68,
    0xc6d9,
    0x9e69,
    0x9e6a,
    0x9e6b,
    0x9e6c,
    0x9e6d,
    0x9e6e,
    0x9e6f,
    0x9e70,
    0xe5ab,
    0xe5ad,
    0x9e71,
    0x9e72,
    0x9e73,
    0x9e74,
    0x9e75,
    0x9e76,
    0x9e77,
    0xe5ac,
    0x9e78,
    0x9e79,
    0x9e7a,
    0x9e7b,
    0x9e7c,
    0x9e7d,
    0x9e7e,
    0x9e80,
    0x9e81,
    0x9e82,
    0x9e83,
    0x9e84,
    0x9e85,
    0x9e86,
    0x9e87,
    0x9e88,
    0x9e89,
    0xe5af,
    0x9e8a,
    0x9e8b,
    0x9e8c,
    0xe5ae,
    0x9e8d,
    0x9e8e,
    0x9e8f,
    0x9e90,
    0x9e91,
    0x9e92,
    0x9e93,
    0x9e94,
    0x9e95,
    0x9e96,
    0x9e97,
    0x9e98,
    0x9e99,
    0x9e9a,
    0x9e9b,
    0x9e9c,
    0x9e9d,
    0x9e9e,
    0xb9e0,
    0x9e9f,
    0x9ea0,
    0xe5b0,
    0x9ea1,
    0x9ea2,
    0x9ea3,
    0x9ea4,
    0x9ea5,
    0x9ea6,
    0x9ea7,
    0x9ea8,
    0x9ea9,
    0x9eaa,
    0x9eab,
    0x9eac,
    0x9ead,
    0x9eae,
    0xe5b1,
    0x9eaf,
    0x9eb0,
    0x9eb1,
    0x9eb2,
    0x9eb3,
    0x9eb4,
    0x9eb5,
    0x9eb6,
    0x9eb7,
    0x9eb8,
    0x9eb9,
    0x9eba,
    0xbbf0,
    0xece1,
    0xc3f0,
    0x9ebb,
    0xb5c6,
    0xbbd2,
    0x9ebc,
    0x9ebd,
    0x9ebe,
    0x9ebf,
    0xc1e9,
    0xd4ee,
    0x9ec0,
    0xbec4,
    0x9ec1,
    0x9ec2,
    0x9ec3,
    0xd7c6,
    0x9ec4,
    0xd4d6,
    0xb2d3,
    0xecbe,
    0x9ec5,
    0x9ec6,
    0x9ec7,
    0x9ec8,
    0xeac1,
    0x9ec9,
    0x9eca,
    0x9ecb,
    0xc2af,
    0xb4b6,
    0x9ecc,
    0x9ecd,
    0x9ece,
    0xd1d7,
    0x9ecf,
    0x9ed0,
    0x9ed1,
    0xb3b4,
    0x9ed2,
    0xc8b2,
    0xbfbb,
    0xecc0,
    0x9ed3,
    0x9ed4,
    0xd6cb,
    0x9ed5,
    0x9ed6,
    0xecbf,
    0xecc1,
    0x9ed7,
    0x9ed8,
    0x9ed9,
    0x9eda,
    0x9edb,
    0x9edc,
    0x9edd,
    0x9ede,
    0x9edf,
    0x9ee0,
    0x9ee1,
    0x9ee2,
    0x9ee3,
    0xecc5,
    0xbee6,
    0xccbf,
    0xc5da,
    0xbebc,
    0x9ee4,
    0xecc6,
    0x9ee5,
    0xb1fe,
    0x9ee6,
    0x9ee7,
    0x9ee8,
    0xecc4,
    0xd5a8,
    0xb5e3,
    0x9ee9,
    0xecc2,
    0xc1b6,
    0xb3e3,
    0x9eea,
    0x9eeb,
    0xecc3,
    0xcbb8,
    0xc0c3,
    0xccfe,
    0x9eec,
    0x9eed,
    0x9eee,
    0x9eef,
    0xc1d2,
    0x9ef0,
    0xecc8,
    0x9ef1,
    0x9ef2,
    0x9ef3,
    0x9ef4,
    0x9ef5,
    0x9ef6,
    0x9ef7,
    0x9ef8,
    0x9ef9,
    0x9efa,
    0x9efb,
    0x9efc,
    0x9efd,
    0xbae6,
    0xc0d3,
    0x9efe,
    0xd6f2,
    0x9f40,
    0x9f41,
    0x9f42,
    0xd1cc,
    0x9f43,
    0x9f44,
    0x9f45,
    0x9f46,
    0xbfbe,
    0x9f47,
    0xb7b3,
    0xc9d5,
    0xecc7,
    0xbbe2,
    0x9f48,
    0xcccc,
    0xbdfd,
    0xc8c8,
    0x9f49,
    0xcfa9,
    0x9f4a,
    0x9f4b,
    0x9f4c,
    0x9f4d,
    0x9f4e,
    0x9f4f,
    0x9f50,
    0xcde9,
    0x9f51,
    0xc5eb,
    0x9f52,
    0x9f53,
    0x9f54,
    0xb7e9,
    0x9f55,
    0x9f56
};
UINT16 cp936_UNI_a0x71[] = {
    0x9f57,
    0x9f58,
    0x9f59,
    0x9f5a,
    0x9f5b,
    0x9f5c,
    0x9f5d,
    0x9f5e,
    0x9f5f,
    0xd1c9,
    0xbab8,
    0x9f60,
    0x9f61,
    0x9f62,
    0x9f63,
    0x9f64,
    0xecc9,
    0x9f65,
    0x9f66,
    0xecca,
    0x9f67,
    0xbbc0,
    0xeccb,
    0x9f68,
    0xece2,
    0xb1ba,
    0xb7d9,
    0x9f69,
    0x9f6a,
    0x9f6b,
    0x9f6c,
    0x9f6d,
    0x9f6e,
    0x9f6f,
    0x9f70,
    0x9f71,
    0x9f72,
    0x9f73,
    0xbdb9,
    0x9f74,
    0x9f75,
    0x9f76,
    0x9f77,
    0x9f78,
    0x9f79,
    0x9f7a,
    0x9f7b,
    0xeccc,
    0xd1e6,
    0xeccd,
    0x9f7c,
    0x9f7d,
    0x9f7e,
    0x9f80,
    0xc8bb,
    0x9f81,
    0x9f82,
    0x9f83,
    0x9f84,
    0x9f85,
    0x9f86,
    0x9f87,
    0x9f88,
    0x9f89,
    0x9f8a,
    0x9f8b,
    0x9f8c,
    0x9f8d,
    0x9f8e,
    0xecd1,
    0x9f8f,
    0x9f90,
    0x9f91,
    0x9f92,
    0xecd3,
    0x9f93,
    0xbbcd,
    0x9f94,
    0xbce5,
    0x9f95,
    0x9f96,
    0x9f97,
    0x9f98,
    0x9f99,
    0x9f9a,
    0x9f9b,
    0x9f9c,
    0x9f9d,
    0x9f9e,
    0x9f9f,
    0x9fa0,
    0x9fa1,
    0xeccf,
    0x9fa2,
    0xc9b7,
    0x9fa3,
    0x9fa4,
    0x9fa5,
    0x9fa6,
    0x9fa7,
    0xc3ba,
    0x9fa8,
    0xece3,
    0xd5d5,
    0xecd0,
    0x9fa9,
    0x9faa,
    0x9fab,
    0x9fac,
    0x9fad,
    0xd6f3,
    0x9fae,
    0x9faf,
    0x9fb0,
    0xecd2,
    0xecce,
    0x9fb1,
    0x9fb2,
    0x9fb3,
    0x9fb4,
    0xecd4,
    0x9fb5,
    0xecd5,
    0x9fb6,
    0x9fb7,
    0xc9bf,
    0x9fb8,
    0x9fb9,
    0x9fba,
    0x9fbb,
    0x9fbc,
    0x9fbd,
    0xcfa8,
    0x9fbe,
    0x9fbf,
    0x9fc0,
    0x9fc1,
    0x9fc2,
    0xd0dc,
    0x9fc3,
    0x9fc4,
    0x9fc5,
    0x9fc6,
    0xd1ac,
    0x9fc7,
    0x9fc8,
    0x9fc9,
    0x9fca,
    0xc8db,
    0x9fcb,
    0x9fcc,
    0x9fcd,
    0xecd6,
    0xcef5,
    0x9fce,
    0x9fcf,
    0x9fd0,
    0x9fd1,
    0x9fd2,
    0xcaec,
    0xecda,
    0x9fd3,
    0x9fd4,
    0x9fd5,
    0x9fd6,
    0x9fd7,
    0x9fd8,
    0x9fd9,
    0xecd9,
    0x9fda,
    0x9fdb,
    0x9fdc,
    0xb0be,
    0x9fdd,
    0x9fde,
    0x9fdf,
    0x9fe0,
    0x9fe1,
    0x9fe2,
    0xecd7,
    0x9fe3,
    0xecd8,
    0x9fe4,
    0x9fe5,
    0x9fe6,
    0xece4,
    0x9fe7,
    0x9fe8,
    0x9fe9,
    0x9fea,
    0x9feb,
    0x9fec,
    0x9fed,
    0x9fee,
    0x9fef,
    0xc8bc,
    0x9ff0,
    0x9ff1,
    0x9ff2,
    0x9ff3,
    0x9ff4,
    0x9ff5,
    0x9ff6,
    0x9ff7,
    0x9ff8,
    0x9ff9,
    0xc1c7,
    0x9ffa,
    0x9ffb,
    0x9ffc,
    0x9ffd,
    0x9ffe,
    0xecdc,
    0xd1e0,
    0xa040,
    0xa041,
    0xa042,
    0xa043,
    0xa044,
    0xa045,
    0xa046,
    0xa047,
    0xa048,
    0xa049,
    0xecdb,
    0xa04a,
    0xa04b,
    0xa04c,
    0xa04d,
    0xd4ef,
    0xa04e,
    0xecdd,
    0xa04f,
    0xa050,
    0xa051,
    0xa052,
    0xa053,
    0xa054,
    0xdbc6,
    0xa055,
    0xa056,
    0xa057,
    0xa058,
    0xa059,
    0xa05a,
    0xa05b,
    0xa05c,
    0xa05d,
    0xa05e,
    0xecde,
    0xa05f,
    0xa060,
    0xa061,
    0xa062,
    0xa063,
    0xa064
};
UINT16 cp936_UNI_a0x72[] = {
    0xa065,
    0xa066,
    0xa067,
    0xa068,
    0xa069,
    0xa06a,
    0xb1ac,
    0xa06b,
    0xa06c,
    0xa06d,
    0xa06e,
    0xa06f,
    0xa070,
    0xa071,
    0xa072,
    0xa073,
    0xa074,
    0xa075,
    0xa076,
    0xa077,
    0xa078,
    0xa079,
    0xa07a,
    0xa07b,
    0xa07c,
    0xa07d,
    0xa07e,
    0xa080,
    0xa081,
    0xecdf,
    0xa082,
    0xa083,
    0xa084,
    0xa085,
    0xa086,
    0xa087,
    0xa088,
    0xa089,
    0xa08a,
    0xa08b,
    0xece0,
    0xa08c,
    0xd7a6,
    0xa08d,
    0xc5c0,
    0xa08e,
    0xa08f,
    0xa090,
    0xebbc,
    0xb0ae,
    0xa091,
    0xa092,
    0xa093,
    0xbef4,
    0xb8b8,
    0xd2af,
    0xb0d6,
    0xb5f9,
    0xa094,
    0xd8b3,
    0xa095,
    0xcbac,
    0xa096,
    0xe3dd,
    0xa097,
    0xa098,
    0xa099,
    0xa09a,
    0xa09b,
    0xa09c,
    0xa09d,
    0xc6ac,
    0xb0e6,
    0xa09e,
    0xa09f,
    0xa0a0,
    0xc5c6,
    0xebb9,
    0xa0a1,
    0xa0a2,
    0xa0a3,
    0xa0a4,
    0xebba,
    0xa0a5,
    0xa0a6,
    0xa0a7,
    0xebbb,
    0xa0a8,
    0xa0a9,
    0xd1c0,
    0xa0aa,
    0xc5a3,
    0xa0ab,
    0xeaf2,
    0xa0ac,
    0xc4b2,
    0xa0ad,
    0xc4b5,
    0xc0ce,
    0xa0ae,
    0xa0af,
    0xa0b0,
    0xeaf3,
    0xc4c1,
    0xa0b1,
    0xceef,
    0xa0b2,
    0xa0b3,
    0xa0b4,
    0xa0b5,
    0xeaf0,
    0xeaf4,
    0xa0b6,
    0xa0b7,
    0xc9fc,
    0xa0b8,
    0xa0b9,
    0xc7a3,
    0xa0ba,
    0xa0bb,
    0xa0bc,
    0xccd8,
    0xcefe,
    0xa0bd,
    0xa0be,
    0xa0bf,
    0xeaf5,
    0xeaf6,
    0xcfac,
    0xc0e7,
    0xa0c0,
    0xa0c1,
    0xeaf7,
    0xa0c2,
    0xa0c3,
    0xa0c4,
    0xa0c5,
    0xa0c6,
    0xb6bf,
    0xeaf8,
    0xa0c7,
    0xeaf9,
    0xa0c8,
    0xeafa,
    0xa0c9,
    0xa0ca,
    0xeafb,
    0xa0cb,
    0xa0cc,
    0xa0cd,
    0xa0ce,
    0xa0cf,
    0xa0d0,
    0xa0d1,
    0xa0d2,
    0xa0d3,
    0xa0d4,
    0xa0d5,
    0xa0d6,
    0xeaf1,
    0xa0d7,
    0xa0d8,
    0xa0d9,
    0xa0da,
    0xa0db,
    0xa0dc,
    0xa0dd,
    0xa0de,
    0xa0df,
    0xa0e0,
    0xa0e1,
    0xa0e2,
    0xc8ae,
    0xe1eb,
    0xa0e3,
    0xb7b8,
    0xe1ec,
    0xa0e4,
    0xa0e5,
    0xa0e6,
    0xe1ed,
    0xa0e7,
    0xd7b4,
    0xe1ee,
    0xe1ef,
    0xd3cc,
    0xa0e8,
    0xa0e9,
    0xa0ea,
    0xa0eb,
    0xa0ec,
    0xa0ed,
    0xa0ee,
    0xe1f1,
    0xbff1,
    0xe1f0,
    0xb5d2,
    0xa0ef,
    0xa0f0,
    0xa0f1,
    0xb1b7,
    0xa0f2,
    0xa0f3,
    0xa0f4,
    0xa0f5,
    0xe1f3,
    0xe1f2,
    0xa0f6,
    0xbafc,
    0xa0f7,
    0xe1f4,
    0xa0f8,
    0xa0f9,
    0xa0fa,
    0xa0fb,
    0xb9b7,
    0xa0fc,
    0xbed1,
    0xa0fd,
    0xa0fe,
    0xaa40,
    0xaa41,
    0xc4fc,
    0xaa42,
    0xbadd,
    0xbdc6,
    0xaa43,
    0xaa44,
    0xaa45,
    0xaa46,
    0xaa47,
    0xaa48,
    0xe1f5,
    0xe1f7,
    0xaa49,
    0xaa4a,
    0xb6c0,
    0xcfc1,
    0xcaa8,
    0xe1f6,
    0xd5f8,
    0xd3fc,
    0xe1f8,
    0xe1fc,
    0xe1f9,
    0xaa4b,
    0xaa4c,
    0xe1fa,
    0xc0ea,
    0xaa4d,
    0xe1fe,
    0xe2a1,
    0xc0c7,
    0xaa4e,
    0xaa4f,
    0xaa50
};
UINT16 cp936_UNI_a0x73[] = {
    0xaa51,
    0xe1fb,
    0xaa52,
    0xe1fd,
    0xaa53,
    0xaa54,
    0xaa55,
    0xaa56,
    0xaa57,
    0xaa58,
    0xe2a5,
    0xaa59,
    0xaa5a,
    0xaa5b,
    0xc1d4,
    0xaa5c,
    0xaa5d,
    0xaa5e,
    0xaa5f,
    0xe2a3,
    0xaa60,
    0xe2a8,
    0xb2fe,
    0xe2a2,
    0xaa61,
    0xaa62,
    0xaa63,
    0xc3cd,
    0xb2c2,
    0xe2a7,
    0xe2a6,
    0xaa64,
    0xaa65,
    0xe2a4,
    0xe2a9,
    0xaa66,
    0xaa67,
    0xe2ab,
    0xaa68,
    0xaa69,
    0xaa6a,
    0xd0c9,
    0xd6ed,
    0xc3a8,
    0xe2ac,
    0xaa6b,
    0xcfd7,
    0xaa6c,
    0xaa6d,
    0xe2ae,
    0xaa6e,
    0xaa6f,
    0xbaef,
    0xaa70,
    0xaa71,
    0xe9e0,
    0xe2ad,
    0xe2aa,
    0xaa72,
    0xaa73,
    0xaa74,
    0xaa75,
    0xbbab,
    0xd4b3,
    0xaa76,
    0xaa77,
    0xaa78,
    0xaa79,
    0xaa7a,
    0xaa7b,
    0xaa7c,
    0xaa7d,
    0xaa7e,
    0xaa80,
    0xaa81,
    0xaa82,
    0xaa83,
    0xe2b0,
    0xaa84,
    0xaa85,
    0xe2af,
    0xaa86,
    0xe9e1,
    0xaa87,
    0xaa88,
    0xaa89,
    0xaa8a,
    0xe2b1,
    0xaa8b,
    0xaa8c,
    0xaa8d,
    0xaa8e,
    0xaa8f,
    0xaa90,
    0xaa91,
    0xaa92,
    0xe2b2,
    0xaa93,
    0xaa94,
    0xaa95,
    0xaa96,
    0xaa97,
    0xaa98,
    0xaa99,
    0xaa9a,
    0xaa9b,
    0xaa9c,
    0xaa9d,
    0xe2b3,
    0xcca1,
    0xaa9e,
    0xe2b4,
    0xaa9f,
    0xaaa0,
    0xab40,
    0xab41,
    0xab42,
    0xab43,
    0xab44,
    0xab45,
    0xab46,
    0xab47,
    0xab48,
    0xab49,
    0xab4a,
    0xab4b,
    0xe2b5,
    0xab4c,
    0xab4d,
    0xab4e,
    0xab4f,
    0xab50,
    0xd0fe,
    0xab51,
    0xab52,
    0xc2ca,
    0xab53,
    0xd3f1,
    0xab54,
    0xcdf5,
    0xab55,
    0xab56,
    0xe7e0,
    0xab57,
    0xab58,
    0xe7e1,
    0xab59,
    0xab5a,
    0xab5b,
    0xab5c,
    0xbec1,
    0xab5d,
    0xab5e,
    0xab5f,
    0xab60,
    0xc2ea,
    0xab61,
    0xab62,
    0xab63,
    0xe7e4,
    0xab64,
    0xab65,
    0xe7e3,
    0xab66,
    0xab67,
    0xab68,
    0xab69,
    0xab6a,
    0xab6b,
    0xcde6,
    0xab6c,
    0xc3b5,
    0xab6d,
    0xab6e,
    0xe7e2,
    0xbbb7,
    0xcfd6,
    0xab6f,
    0xc1e1,
    0xe7e9,
    0xab70,
    0xab71,
    0xab72,
    0xe7e8,
    0xab73,
    0xab74,
    0xe7f4,
    0xb2a3,
    0xab75,
    0xab76,
    0xab77,
    0xab78,
    0xe7ea,
    0xab79,
    0xe7e6,
    0xab7a,
    0xab7b,
    0xab7c,
    0xab7d,
    0xab7e,
    0xe7ec,
    0xe7eb,
    0xc9ba,
    0xab80,
    0xab81,
    0xd5e4,
    0xab82,
    0xe7e5,
    0xb7a9,
    0xe7e7,
    0xab83,
    0xab84,
    0xab85,
    0xab86,
    0xab87,
    0xab88,
    0xab89,
    0xe7ee,
    0xab8a,
    0xab8b,
    0xab8c,
    0xab8d,
    0xe7f3,
    0xab8e,
    0xd6e9,
    0xab8f,
    0xab90,
    0xab91,
    0xab92,
    0xe7ed,
    0xab93,
    0xe7f2,
    0xab94,
    0xe7f1,
    0xab95,
    0xab96,
    0xab97,
    0xb0e0,
    0xab98,
    0xab99,
    0xab9a,
    0xab9b,
    0xe7f5,
    0xab9c,
    0xab9d,
    0xab9e,
    0xab9f,
    0xaba0,
    0xac40,
    0xac41,
    0xac42,
    0xac43,
    0xac44,
    0xac45,
    0xac46,
    0xac47
};
UINT16 cp936_UNI_a0x74[] = {
    0xac48,
    0xac49,
    0xac4a,
    0xc7f2,
    0xac4b,
    0xc0c5,
    0xc0ed,
    0xac4c,
    0xac4d,
    0xc1f0,
    0xe7f0,
    0xac4e,
    0xac4f,
    0xac50,
    0xac51,
    0xe7f6,
    0xcbf6,
    0xac52,
    0xac53,
    0xac54,
    0xac55,
    0xac56,
    0xac57,
    0xac58,
    0xac59,
    0xac5a,
    0xe8a2,
    0xe8a1,
    0xac5b,
    0xac5c,
    0xac5d,
    0xac5e,
    0xac5f,
    0xac60,
    0xd7c1,
    0xac61,
    0xac62,
    0xe7fa,
    0xe7f9,
    0xac63,
    0xe7fb,
    0xac64,
    0xe7f7,
    0xac65,
    0xe7fe,
    0xac66,
    0xe7fd,
    0xac67,
    0xe7fc,
    0xac68,
    0xac69,
    0xc1d5,
    0xc7d9,
    0xc5fd,
    0xc5c3,
    0xac6a,
    0xac6b,
    0xac6c,
    0xac6d,
    0xac6e,
    0xc7ed,
    0xac6f,
    0xac70,
    0xac71,
    0xac72,
    0xe8a3,
    0xac73,
    0xac74,
    0xac75,
    0xac76,
    0xac77,
    0xac78,
    0xac79,
    0xac7a,
    0xac7b,
    0xac7c,
    0xac7d,
    0xac7e,
    0xac80,
    0xac81,
    0xac82,
    0xac83,
    0xac84,
    0xac85,
    0xac86,
    0xe8a6,
    0xac87,
    0xe8a5,
    0xac88,
    0xe8a7,
    0xbaf7,
    0xe7f8,
    0xe8a4,
    0xac89,
    0xc8f0,
    0xc9aa,
    0xac8a,
    0xac8b,
    0xac8c,
    0xac8d,
    0xac8e,
    0xac8f,
    0xac90,
    0xac91,
    0xac92,
    0xac93,
    0xac94,
    0xac95,
    0xac96,
    0xe8a9,
    0xac97,
    0xac98,
    0xb9e5,
    0xac99,
    0xac9a,
    0xac9b,
    0xac9c,
    0xac9d,
    0xd1fe,
    0xe8a8,
    0xac9e,
    0xac9f,
    0xaca0,
    0xad40,
    0xad41,
    0xad42,
    0xe8aa,
    0xad43,
    0xe8ad,
    0xe8ae,
    0xad44,
    0xc1a7,
    0xad45,
    0xad46,
    0xad47,
    0xe8af,
    0xad48,
    0xad49,
    0xad4a,
    0xe8b0,
    0xad4b,
    0xad4c,
    0xe8ac,
    0xad4d,
    0xe8b4,
    0xad4e,
    0xad4f,
    0xad50,
    0xad51,
    0xad52,
    0xad53,
    0xad54,
    0xad55,
    0xad56,
    0xad57,
    0xad58,
    0xe8ab,
    0xad59,
    0xe8b1,
    0xad5a,
    0xad5b,
    0xad5c,
    0xad5d,
    0xad5e,
    0xad5f,
    0xad60,
    0xad61,
    0xe8b5,
    0xe8b2,
    0xe8b3,
    0xad62,
    0xad63,
    0xad64,
    0xad65,
    0xad66,
    0xad67,
    0xad68,
    0xad69,
    0xad6a,
    0xad6b,
    0xad6c,
    0xad6d,
    0xad6e,
    0xad6f,
    0xad70,
    0xad71,
    0xe8b7,
    0xad72,
    0xad73,
    0xad74,
    0xad75,
    0xad76,
    0xad77,
    0xad78,
    0xad79,
    0xad7a,
    0xad7b,
    0xad7c,
    0xad7d,
    0xad7e,
    0xad80,
    0xad81,
    0xad82,
    0xad83,
    0xad84,
    0xad85,
    0xad86,
    0xad87,
    0xad88,
    0xad89,
    0xe8b6,
    0xad8a,
    0xad8b,
    0xad8c,
    0xad8d,
    0xad8e,
    0xad8f,
    0xad90,
    0xad91,
    0xad92,
    0xb9cf,
    0xad93,
    0xf0ac,
    0xad94,
    0xf0ad,
    0xad95,
    0xc6b0,
    0xb0ea,
    0xc8bf,
    0xad96,
    0xcddf,
    0xad97,
    0xad98,
    0xad99,
    0xad9a,
    0xad9b,
    0xad9c,
    0xad9d,
    0xcecd,
    0xeab1,
    0xad9e,
    0xad9f,
    0xada0,
    0xae40,
    0xeab2,
    0xae41,
    0xc6bf,
    0xb4c9,
    0xae42,
    0xae43,
    0xae44,
    0xae45,
    0xae46,
    0xae47,
    0xae48,
    0xeab3
};
UINT16 cp936_UNI_a0x75[] = {
    0xae49,
    0xae4a,
    0xae4b,
    0xae4c,
    0xd5e7,
    0xae4d,
    0xae4e,
    0xae4f,
    0xae50,
    0xae51,
    0xae52,
    0xae53,
    0xae54,
    0xddf9,
    0xae55,
    0xeab4,
    0xae56,
    0xeab5,
    0xae57,
    0xeab6,
    0xae58,
    0xae59,
    0xae5a,
    0xae5b,
    0xb8ca,
    0xdfb0,
    0xc9f5,
    0xae5c,
    0xccf0,
    0xae5d,
    0xae5e,
    0xc9fa,
    0xae5f,
    0xae60,
    0xae61,
    0xae62,
    0xae63,
    0xc9fb,
    0xae64,
    0xae65,
    0xd3c3,
    0xcba6,
    0xae66,
    0xb8a6,
    0xf0ae,
    0xb1c2,
    0xae67,
    0xe5b8,
    0xccef,
    0xd3c9,
    0xbcd7,
    0xc9ea,
    0xae68,
    0xb5e7,
    0xae69,
    0xc4d0,
    0xb5e9,
    0xae6a,
    0xeeae,
    0xbbad,
    0xae6b,
    0xae6c,
    0xe7de,
    0xae6d,
    0xeeaf,
    0xae6e,
    0xae6f,
    0xae70,
    0xae71,
    0xb3a9,
    0xae72,
    0xae73,
    0xeeb2,
    0xae74,
    0xae75,
    0xeeb1,
    0xbde7,
    0xae76,
    0xeeb0,
    0xceb7,
    0xae77,
    0xae78,
    0xae79,
    0xae7a,
    0xc5cf,
    0xae7b,
    0xae7c,
    0xae7d,
    0xae7e,
    0xc1f4,
    0xdbce,
    0xeeb3,
    0xd0f3,
    0xae80,
    0xae81,
    0xae82,
    0xae83,
    0xae84,
    0xae85,
    0xae86,
    0xae87,
    0xc2d4,
    0xc6e8,
    0xae88,
    0xae89,
    0xae8a,
    0xb7ac,
    0xae8b,
    0xae8c,
    0xae8d,
    0xae8e,
    0xae8f,
    0xae90,
    0xae91,
    0xeeb4,
    0xae92,
    0xb3eb,
    0xae93,
    0xae94,
    0xae95,
    0xbbfb,
    0xeeb5,
    0xae96,
    0xae97,
    0xae98,
    0xae99,
    0xae9a,
    0xe7dc,
    0xae9b,
    0xae9c,
    0xae9d,
    0xeeb6,
    0xae9e,
    0xae9f,
    0xbdae,
    0xaea0,
    0xaf40,
    0xaf41,
    0xaf42,
    0xf1e2,
    0xaf43,
    0xaf44,
    0xaf45,
    0xcae8,
    0xaf46,
    0xd2c9,
    0xf0da,
    0xaf47,
    0xf0db,
    0xaf48,
    0xf0dc,
    0xc1c6,
    0xaf49,
    0xb8ed,
    0xbece,
    0xaf4a,
    0xaf4b,
    0xf0de,
    0xaf4c,
    0xc5b1,
    0xf0dd,
    0xd1f1,
    0xaf4d,
    0xf0e0,
    0xb0cc,
    0xbdea,
    0xaf4e,
    0xaf4f,
    0xaf50,
    0xaf51,
    0xaf52,
    0xd2df,
    0xf0df,
    0xaf53,
    0xb4af,
    0xb7e8,
    0xf0e6,
    0xf0e5,
    0xc6a3,
    0xf0e1,
    0xf0e2,
    0xb4c3,
    0xaf54,
    0xaf55,
    0xf0e3,
    0xd5ee,
    0xaf56,
    0xaf57,
    0xccdb,
    0xbed2,
    0xbcb2,
    0xaf58,
    0xaf59,
    0xaf5a,
    0xf0e8,
    0xf0e7,
    0xf0e4,
    0xb2a1,
    0xaf5b,
    0xd6a2,
    0xd3b8,
    0xbeb7,
    0xc8ac,
    0xaf5c,
    0xaf5d,
    0xf0ea,
    0xaf5e,
    0xaf5f,
    0xaf60,
    0xaf61,
    0xd1f7,
    0xaf62,
    0xd6cc,
    0xbadb,
    0xf0e9,
    0xaf63,
    0xb6bb,
    0xaf64,
    0xaf65,
    0xcdb4,
    0xaf66,
    0xaf67,
    0xc6a6,
    0xaf68,
    0xaf69,
    0xaf6a,
    0xc1a1,
    0xf0eb,
    0xf0ee,
    0xaf6b,
    0xf0ed,
    0xf0f0,
    0xf0ec,
    0xaf6c,
    0xbbbe,
    0xf0ef,
    0xaf6d,
    0xaf6e,
    0xaf6f,
    0xaf70,
    0xccb5,
    0xf0f2,
    0xaf71,
    0xaf72,
    0xb3d5,
    0xaf73,
    0xaf74,
    0xaf75,
    0xaf76,
    0xb1d4,
    0xaf77,
    0xaf78,
    0xf0f3,
    0xaf79,
    0xaf7a,
    0xf0f4
};
UINT16 cp936_UNI_a0x76[] = {
    0xf0f6,
    0xb4e1,
    0xaf7b,
    0xf0f1,
    0xaf7c,
    0xf0f7,
    0xaf7d,
    0xaf7e,
    0xaf80,
    0xaf81,
    0xf0fa,
    0xaf82,
    0xf0f8,
    0xaf83,
    0xaf84,
    0xaf85,
    0xf0f5,
    0xaf86,
    0xaf87,
    0xaf88,
    0xaf89,
    0xf0fd,
    0xaf8a,
    0xf0f9,
    0xf0fc,
    0xf0fe,
    0xaf8b,
    0xf1a1,
    0xaf8c,
    0xaf8d,
    0xaf8e,
    0xcec1,
    0xf1a4,
    0xaf8f,
    0xf1a3,
    0xaf90,
    0xc1f6,
    0xf0fb,
    0xcadd,
    0xaf91,
    0xaf92,
    0xb4f1,
    0xb1f1,
    0xccb1,
    0xaf93,
    0xf1a6,
    0xaf94,
    0xaf95,
    0xf1a7,
    0xaf96,
    0xaf97,
    0xf1ac,
    0xd5ce,
    0xf1a9,
    0xaf98,
    0xaf99,
    0xc8b3,
    0xaf9a,
    0xaf9b,
    0xaf9c,
    0xf1a2,
    0xaf9d,
    0xf1ab,
    0xf1a8,
    0xf1a5,
    0xaf9e,
    0xaf9f,
    0xf1aa,
    0xafa0,
    0xb040,
    0xb041,
    0xb042,
    0xb043,
    0xb044,
    0xb045,
    0xb046,
    0xb0a9,
    0xf1ad,
    0xb047,
    0xb048,
    0xb049,
    0xb04a,
    0xb04b,
    0xb04c,
    0xf1af,
    0xb04d,
    0xf1b1,
    0xb04e,
    0xb04f,
    0xb050,
    0xb051,
    0xb052,
    0xf1b0,
    0xb053,
    0xf1ae,
    0xb054,
    0xb055,
    0xb056,
    0xb057,
    0xd1a2,
    0xb058,
    0xb059,
    0xb05a,
    0xb05b,
    0xb05c,
    0xb05d,
    0xb05e,
    0xf1b2,
    0xb05f,
    0xb060,
    0xb061,
    0xf1b3,
    0xb062,
    0xb063,
    0xb064,
    0xb065,
    0xb066,
    0xb067,
    0xb068,
    0xb069,
    0xb9ef,
    0xb06a,
    0xb06b,
    0xb5c7,
    0xb06c,
    0xb0d7,
    0xb0d9,
    0xb06d,
    0xb06e,
    0xb06f,
    0xd4ed,
    0xb070,
    0xb5c4,
    0xb071,
    0xbdd4,
    0xbbca,
    0xf0a7,
    0xb072,
    0xb073,
    0xb8de,
    0xb074,
    0xb075,
    0xf0a8,
    0xb076,
    0xb077,
    0xb0a8,
    0xb078,
    0xf0a9,
    0xb079,
    0xb07a,
    0xcdee,
    0xb07b,
    0xb07c,
    0xf0aa,
    0xb07d,
    0xb07e,
    0xb080,
    0xb081,
    0xb082,
    0xb083,
    0xb084,
    0xb085,
    0xb086,
    0xb087,
    0xf0ab,
    0xb088,
    0xb089,
    0xb08a,
    0xb08b,
    0xb08c,
    0xb08d,
    0xb08e,
    0xb08f,
    0xb090,
    0xc6a4,
    0xb091,
    0xb092,
    0xd6e5,
    0xf1e4,
    0xb093,
    0xf1e5,
    0xb094,
    0xb095,
    0xb096,
    0xb097,
    0xb098,
    0xb099,
    0xb09a,
    0xb09b,
    0xb09c,
    0xb09d,
    0xc3f3,
    0xb09e,
    0xb09f,
    0xd3db,
    0xb0a0,
    0xb140,
    0xd6d1,
    0xc5e8,
    0xb141,
    0xd3af,
    0xb142,
    0xd2e6,
    0xb143,
    0xb144,
    0xeec1,
    0xb0bb,
    0xd5b5,
    0xd1ce,
    0xbce0,
    0xbad0,
    0xb145,
    0xbff8,
    0xb146,
    0xb8c7,
    0xb5c1,
    0xc5cc,
    0xb147,
    0xb148,
    0xcaa2,
    0xb149,
    0xb14a,
    0xb14b,
    0xc3cb,
    0xb14c,
    0xb14d,
    0xb14e,
    0xb14f,
    0xb150,
    0xeec2,
    0xb151,
    0xb152,
    0xb153,
    0xb154,
    0xb155,
    0xb156,
    0xb157,
    0xb158,
    0xc4bf,
    0xb6a2,
    0xb159,
    0xedec,
    0xc3a4,
    0xb15a,
    0xd6b1,
    0xb15b,
    0xb15c,
    0xb15d,
    0xcfe0,
    0xedef,
    0xb15e,
    0xb15f,
    0xc5ce,
    0xb160,
    0xb6dc,
    0xb161
};
UINT16 cp936_UNI_a0x77[] = {
    0xb162,
    0xcaa1,
    0xb163,
    0xb164,
    0xeded,
    0xb165,
    0xb166,
    0xedf0,
    0xedf1,
    0xc3bc,
    0xb167,
    0xbfb4,
    0xb168,
    0xedee,
    0xb169,
    0xb16a,
    0xb16b,
    0xb16c,
    0xb16d,
    0xb16e,
    0xb16f,
    0xb170,
    0xb171,
    0xb172,
    0xb173,
    0xedf4,
    0xedf2,
    0xb174,
    0xb175,
    0xb176,
    0xb177,
    0xd5e6,
    0xc3df,
    0xb178,
    0xedf3,
    0xb179,
    0xb17a,
    0xb17b,
    0xedf6,
    0xb17c,
    0xd5a3,
    0xd1a3,
    0xb17d,
    0xb17e,
    0xb180,
    0xedf5,
    0xb181,
    0xc3d0,
    0xb182,
    0xb183,
    0xb184,
    0xb185,
    0xb186,
    0xedf7,
    0xbff4,
    0xbeec,
    0xedf8,
    0xb187,
    0xccf7,
    0xb188,
    0xd1db,
    0xb189,
    0xb18a,
    0xb18b,
    0xd7c5,
    0xd5f6,
    0xb18c,
    0xedfc,
    0xb18d,
    0xb18e,
    0xb18f,
    0xedfb,
    0xb190,
    0xb191,
    0xb192,
    0xb193,
    0xb194,
    0xb195,
    0xb196,
    0xb197,
    0xedf9,
    0xedfa,
    0xb198,
    0xb199,
    0xb19a,
    0xb19b,
    0xb19c,
    0xb19d,
    0xb19e,
    0xb19f,
    0xedfd,
    0xbea6,
    0xb1a0,
    0xb240,
    0xb241,
    0xb242,
    0xb243,
    0xcbaf,
    0xeea1,
    0xb6bd,
    0xb244,
    0xeea2,
    0xc4c0,
    0xb245,
    0xedfe,
    0xb246,
    0xb247,
    0xbdde,
    0xb2c7,
    0xb248,
    0xb249,
    0xb24a,
    0xb24b,
    0xb24c,
    0xb24d,
    0xb24e,
    0xb24f,
    0xb250,
    0xb251,
    0xb252,
    0xb253,
    0xb6c3,
    0xb254,
    0xb255,
    0xb256,
    0xeea5,
    0xd8ba,
    0xeea3,
    0xeea6,
    0xb257,
    0xb258,
    0xb259,
    0xc3e9,
    0xb3f2,
    0xb25a,
    0xb25b,
    0xb25c,
    0xb25d,
    0xb25e,
    0xb25f,
    0xeea7,
    0xeea4,
    0xcfb9,
    0xb260,
    0xb261,
    0xeea8,
    0xc2f7,
    0xb262,
    0xb263,
    0xb264,
    0xb265,
    0xb266,
    0xb267,
    0xb268,
    0xb269,
    0xb26a,
    0xb26b,
    0xb26c,
    0xb26d,
    0xeea9,
    0xeeaa,
    0xb26e,
    0xdeab,
    0xb26f,
    0xb270,
    0xc6b3,
    0xb271,
    0xc7c6,
    0xb272,
    0xd6f5,
    0xb5c9,
    0xb273,
    0xcbb2,
    0xb274,
    0xb275,
    0xb276,
    0xeeab,
    0xb277,
    0xb278,
    0xcdab,
    0xb279,
    0xeeac,
    0xb27a,
    0xb27b,
    0xb27c,
    0xb27d,
    0xb27e,
    0xd5b0,
    0xb280,
    0xeead,
    0xb281,
    0xf6c4,
    0xb282,
    0xb283,
    0xb284,
    0xb285,
    0xb286,
    0xb287,
    0xb288,
    0xb289,
    0xb28a,
    0xb28b,
    0xb28c,
    0xb28d,
    0xb28e,
    0xdbc7,
    0xb28f,
    0xb290,
    0xb291,
    0xb292,
    0xb293,
    0xb294,
    0xb295,
    0xb296,
    0xb297,
    0xb4a3,
    0xb298,
    0xb299,
    0xb29a,
    0xc3ac,
    0xf1e6,
    0xb29b,
    0xb29c,
    0xb29d,
    0xb29e,
    0xb29f,
    0xcab8,
    0xd2d3,
    0xb2a0,
    0xd6aa,
    0xb340,
    0xeff2,
    0xb341,
    0xbed8,
    0xb342,
    0xbdc3,
    0xeff3,
    0xb6cc,
    0xb0ab,
    0xb343,
    0xb344,
    0xb345,
    0xb346,
    0xcaaf,
    0xb347,
    0xb348,
    0xedb6,
    0xb349,
    0xedb7,
    0xb34a,
    0xb34b,
    0xb34c,
    0xb34d,
    0xcef9,
    0xb7af,
    0xbff3
};
UINT16 cp936_UNI_a0x78[] = {
    0xedb8,
    0xc2eb,
    0xc9b0,
    0xb34e,
    0xb34f,
    0xb350,
    0xb351,
    0xb352,
    0xb353,
    0xedb9,
    0xb354,
    0xb355,
    0xc6f6,
    0xbfb3,
    0xb356,
    0xb357,
    0xb358,
    0xedbc,
    0xc5f8,
    0xb359,
    0xd1d0,
    0xb35a,
    0xd7a9,
    0xedba,
    0xedbb,
    0xb35b,
    0xd1e2,
    0xb35c,
    0xedbf,
    0xedc0,
    0xb35d,
    0xedc4,
    0xb35e,
    0xb35f,
    0xb360,
    0xedc8,
    0xb361,
    0xedc6,
    0xedce,
    0xd5e8,
    0xb362,
    0xedc9,
    0xb363,
    0xb364,
    0xedc7,
    0xedbe,
    0xb365,
    0xb366,
    0xc5e9,
    0xb367,
    0xb368,
    0xb369,
    0xc6c6,
    0xb36a,
    0xb36b,
    0xc9e9,
    0xd4d2,
    0xedc1,
    0xedc2,
    0xedc3,
    0xedc5,
    0xb36c,
    0xc0f9,
    0xb36d,
    0xb4a1,
    0xb36e,
    0xb36f,
    0xb370,
    0xb371,
    0xb9e8,
    0xb372,
    0xedd0,
    0xb373,
    0xb374,
    0xb375,
    0xb376,
    0xedd1,
    0xb377,
    0xedca,
    0xb378,
    0xedcf,
    0xb379,
    0xcef8,
    0xb37a,
    0xb37b,
    0xcbb6,
    0xedcc,
    0xedcd,
    0xb37c,
    0xb37d,
    0xb37e,
    0xb380,
    0xb381,
    0xcff5,
    0xb382,
    0xb383,
    0xb384,
    0xb385,
    0xb386,
    0xb387,
    0xb388,
    0xb389,
    0xb38a,
    0xb38b,
    0xb38c,
    0xb38d,
    0xedd2,
    0xc1f2,
    0xd3b2,
    0xedcb,
    0xc8b7,
    0xb38e,
    0xb38f,
    0xb390,
    0xb391,
    0xb392,
    0xb393,
    0xb394,
    0xb395,
    0xbcef,
    0xb396,
    0xb397,
    0xb398,
    0xb399,
    0xc5f0,
    0xb39a,
    0xb39b,
    0xb39c,
    0xb39d,
    0xb39e,
    0xb39f,
    0xb3a0,
    0xb440,
    0xb441,
    0xb442,
    0xedd6,
    0xb443,
    0xb5ef,
    0xb444,
    0xb445,
    0xc2b5,
    0xb0ad,
    0xcbe9,
    0xb446,
    0xb447,
    0xb1ae,
    0xb448,
    0xedd4,
    0xb449,
    0xb44a,
    0xb44b,
    0xcdeb,
    0xb5e2,
    0xb44c,
    0xedd5,
    0xedd3,
    0xedd7,
    0xb44d,
    0xb44e,
    0xb5fa,
    0xb44f,
    0xedd8,
    0xb450,
    0xedd9,
    0xb451,
    0xeddc,
    0xb452,
    0xb1cc,
    0xb453,
    0xb454,
    0xb455,
    0xb456,
    0xb457,
    0xb458,
    0xb459,
    0xb45a,
    0xc5f6,
    0xbcee,
    0xedda,
    0xccbc,
    0xb2ea,
    0xb45b,
    0xb45c,
    0xb45d,
    0xb45e,
    0xeddb,
    0xb45f,
    0xb460,
    0xb461,
    0xb462,
    0xc4eb,
    0xb463,
    0xb464,
    0xb4c5,
    0xb465,
    0xb466,
    0xb467,
    0xb0f5,
    0xb468,
    0xb469,
    0xb46a,
    0xeddf,
    0xc0da,
    0xb4e8,
    0xb46b,
    0xb46c,
    0xb46d,
    0xb46e,
    0xc5cd,
    0xb46f,
    0xb470,
    0xb471,
    0xeddd,
    0xbfc4,
    0xb472,
    0xb473,
    0xb474,
    0xedde,
    0xb475,
    0xb476,
    0xb477,
    0xb478,
    0xb479,
    0xb47a,
    0xb47b,
    0xb47c,
    0xb47d,
    0xb47e,
    0xb480,
    0xb481,
    0xb482,
    0xb483,
    0xc4a5,
    0xb484,
    0xb485,
    0xb486,
    0xede0,
    0xb487,
    0xb488,
    0xb489,
    0xb48a,
    0xb48b,
    0xede1,
    0xb48c,
    0xede3,
    0xb48d,
    0xb48e,
    0xc1d7,
    0xb48f,
    0xb490,
    0xbbc7,
    0xb491,
    0xb492,
    0xb493,
    0xb494,
    0xb495
};
UINT16 cp936_UNI_a0x79[] = {
    0xb496,
    0xbdb8,
    0xb497,
    0xb498,
    0xb499,
    0xede2,
    0xb49a,
    0xb49b,
    0xb49c,
    0xb49d,
    0xb49e,
    0xb49f,
    0xb4a0,
    0xb540,
    0xb541,
    0xb542,
    0xb543,
    0xb544,
    0xb545,
    0xede4,
    0xb546,
    0xb547,
    0xb548,
    0xb549,
    0xb54a,
    0xb54b,
    0xb54c,
    0xb54d,
    0xb54e,
    0xb54f,
    0xede6,
    0xb550,
    0xb551,
    0xb552,
    0xb553,
    0xb554,
    0xede5,
    0xb555,
    0xb556,
    0xb557,
    0xb558,
    0xb559,
    0xb55a,
    0xb55b,
    0xb55c,
    0xb55d,
    0xb55e,
    0xb55f,
    0xb560,
    0xb561,
    0xb562,
    0xb563,
    0xede7,
    0xb564,
    0xb565,
    0xb566,
    0xb567,
    0xb568,
    0xcabe,
    0xecea,
    0xc0f1,
    0xb569,
    0xc9e7,
    0xb56a,
    0xeceb,
    0xc6ee,
    0xb56b,
    0xb56c,
    0xb56d,
    0xb56e,
    0xecec,
    0xb56f,
    0xc6ed,
    0xeced,
    0xb570,
    0xb571,
    0xb572,
    0xb573,
    0xb574,
    0xb575,
    0xb576,
    0xb577,
    0xb578,
    0xecf0,
    0xb579,
    0xb57a,
    0xd7e6,
    0xecf3,
    0xb57b,
    0xb57c,
    0xecf1,
    0xecee,
    0xecef,
    0xd7a3,
    0xc9f1,
    0xcbee,
    0xecf4,
    0xb57d,
    0xecf2,
    0xb57e,
    0xb580,
    0xcfe9,
    0xb581,
    0xecf6,
    0xc6b1,
    0xb582,
    0xb583,
    0xb584,
    0xb585,
    0xbcc0,
    0xb586,
    0xecf5,
    0xb587,
    0xb588,
    0xb589,
    0xb58a,
    0xb58b,
    0xb58c,
    0xb58d,
    0xb5bb,
    0xbbf6,
    0xb58e,
    0xecf7,
    0xb58f,
    0xb590,
    0xb591,
    0xb592,
    0xb593,
    0xd9f7,
    0xbdfb,
    0xb594,
    0xb595,
    0xc2bb,
    0xecf8,
    0xb596,
    0xb597,
    0xb598,
    0xb599,
    0xecf9,
    0xb59a,
    0xb59b,
    0xb59c,
    0xb59d,
    0xb8a3,
    0xb59e,
    0xb59f,
    0xb5a0,
    0xb640,
    0xb641,
    0xb642,
    0xb643,
    0xb644,
    0xb645,
    0xb646,
    0xecfa,
    0xb647,
    0xb648,
    0xb649,
    0xb64a,
    0xb64b,
    0xb64c,
    0xb64d,
    0xb64e,
    0xb64f,
    0xb650,
    0xb651,
    0xb652,
    0xecfb,
    0xb653,
    0xb654,
    0xb655,
    0xb656,
    0xb657,
    0xb658,
    0xb659,
    0xb65a,
    0xb65b,
    0xb65c,
    0xb65d,
    0xecfc,
    0xb65e,
    0xb65f,
    0xb660,
    0xb661,
    0xb662,
    0xd3ed,
    0xd8ae,
    0xc0eb,
    0xb663,
    0xc7dd,
    0xbacc,
    0xb664,
    0xd0e3,
    0xcbbd,
    0xb665,
    0xcdba,
    0xb666,
    0xb667,
    0xb8d1,
    0xb668,
    0xb669,
    0xb1fc,
    0xb66a,
    0xc7ef,
    0xb66b,
    0xd6d6,
    0xb66c,
    0xb66d,
    0xb66e,
    0xbfc6,
    0xc3eb,
    0xb66f,
    0xb670,
    0xeff5,
    0xb671,
    0xb672,
    0xc3d8,
    0xb673,
    0xb674,
    0xb675,
    0xb676,
    0xb677,
    0xb678,
    0xd7e2,
    0xb679,
    0xb67a,
    0xb67b,
    0xeff7,
    0xb3d3,
    0xb67c,
    0xc7d8,
    0xd1ed,
    0xb67d,
    0xd6c8,
    0xb67e,
    0xeff8,
    0xb680,
    0xeff6,
    0xb681,
    0xbbfd,
    0xb3c6,
    0xb682,
    0xb683,
    0xb684,
    0xb685,
    0xb686,
    0xb687,
    0xb688,
    0xbdd5,
    0xb689,
    0xb68a,
    0xd2c6,
    0xb68b,
    0xbbe0,
    0xb68c,
    0xb68d
};
UINT16 cp936_UNI_a0x7a[] = {
    0xcfa1,
    0xb68e,
    0xeffc,
    0xeffb,
    0xb68f,
    0xb690,
    0xeff9,
    0xb691,
    0xb692,
    0xb693,
    0xb694,
    0xb3cc,
    0xb695,
    0xc9d4,
    0xcbb0,
    0xb696,
    0xb697,
    0xb698,
    0xb699,
    0xb69a,
    0xeffe,
    0xb69b,
    0xb69c,
    0xb0de,
    0xb69d,
    0xb69e,
    0xd6c9,
    0xb69f,
    0xb6a0,
    0xb740,
    0xeffd,
    0xb741,
    0xb3ed,
    0xb742,
    0xb743,
    0xf6d5,
    0xb744,
    0xb745,
    0xb746,
    0xb747,
    0xb748,
    0xb749,
    0xb74a,
    0xb74b,
    0xb74c,
    0xb74d,
    0xb74e,
    0xb74f,
    0xb750,
    0xb751,
    0xb752,
    0xcec8,
    0xb753,
    0xb754,
    0xb755,
    0xf0a2,
    0xb756,
    0xf0a1,
    0xb757,
    0xb5be,
    0xbcda,
    0xbbfc,
    0xb758,
    0xb8e5,
    0xb759,
    0xb75a,
    0xb75b,
    0xb75c,
    0xb75d,
    0xb75e,
    0xc4c2,
    0xb75f,
    0xb760,
    0xb761,
    0xb762,
    0xb763,
    0xb764,
    0xb765,
    0xb766,
    0xb767,
    0xb768,
    0xf0a3,
    0xb769,
    0xb76a,
    0xb76b,
    0xb76c,
    0xb76d,
    0xcbeb,
    0xb76e,
    0xb76f,
    0xb770,
    0xb771,
    0xb772,
    0xb773,
    0xb774,
    0xb775,
    0xb776,
    0xb777,
    0xb778,
    0xb779,
    0xb77a,
    0xb77b,
    0xb77c,
    0xb77d,
    0xb77e,
    0xb780,
    0xb781,
    0xb782,
    0xb783,
    0xb784,
    0xb785,
    0xb786,
    0xf0a6,
    0xb787,
    0xb788,
    0xb789,
    0xd1a8,
    0xb78a,
    0xbebf,
    0xc7ee,
    0xf1b6,
    0xf1b7,
    0xbfd5,
    0xb78b,
    0xb78c,
    0xb78d,
    0xb78e,
    0xb4a9,
    0xf1b8,
    0xcdbb,
    0xb78f,
    0xc7d4,
    0xd5ad,
    0xb790,
    0xf1b9,
    0xb791,
    0xf1ba,
    0xb792,
    0xb793,
    0xb794,
    0xb795,
    0xc7cf,
    0xb796,
    0xb797,
    0xb798,
    0xd2a4,
    0xd6cf,
    0xb799,
    0xb79a,
    0xf1bb,
    0xbdd1,
    0xb4b0,
    0xbebd,
    0xb79b,
    0xb79c,
    0xb79d,
    0xb4dc,
    0xced1,
    0xb79e,
    0xbfdf,
    0xf1bd,
    0xb79f,
    0xb7a0,
    0xb840,
    0xb841,
    0xbffa,
    0xf1bc,
    0xb842,
    0xf1bf,
    0xb843,
    0xb844,
    0xb845,
    0xf1be,
    0xf1c0,
    0xb846,
    0xb847,
    0xb848,
    0xb849,
    0xb84a,
    0xf1c1,
    0xb84b,
    0xb84c,
    0xb84d,
    0xb84e,
    0xb84f,
    0xb850,
    0xb851,
    0xb852,
    0xb853,
    0xb854,
    0xb855,
    0xc1fe,
    0xb856,
    0xb857,
    0xb858,
    0xb859,
    0xb85a,
    0xb85b,
    0xb85c,
    0xb85d,
    0xb85e,
    0xb85f,
    0xb860,
    0xc1a2,
    0xb861,
    0xb862,
    0xb863,
    0xb864,
    0xb865,
    0xb866,
    0xb867,
    0xb868,
    0xb869,
    0xb86a,
    0xcafa,
    0xb86b,
    0xb86c,
    0xd5be,
    0xb86d,
    0xb86e,
    0xb86f,
    0xb870,
    0xbeba,
    0xbeb9,
    0xd5c2,
    0xb871,
    0xb872,
    0xbfa2,
    0xb873,
    0xcdaf,
    0xf1b5,
    0xb874,
    0xb875,
    0xb876,
    0xb877,
    0xb878,
    0xb879,
    0xbddf,
    0xb87a,
    0xb6cb,
    0xb87b,
    0xb87c,
    0xb87d,
    0xb87e,
    0xb880,
    0xb881,
    0xb882,
    0xb883,
    0xb884,
    0xd6f1,
    0xf3c3,
    0xb885,
    0xb886,
    0xf3c4,
    0xb887,
    0xb8cd
};
UINT16 cp936_UNI_a0x7b[] = {
    0xb888,
    0xb889,
    0xb88a,
    0xf3c6,
    0xf3c7,
    0xb88b,
    0xb0ca,
    0xb88c,
    0xf3c5,
    0xb88d,
    0xf3c9,
    0xcbf1,
    0xb88e,
    0xb88f,
    0xb890,
    0xf3cb,
    0xb891,
    0xd0a6,
    0xb892,
    0xb893,
    0xb1ca,
    0xf3c8,
    0xb894,
    0xb895,
    0xb896,
    0xf3cf,
    0xb897,
    0xb5d1,
    0xb898,
    0xb899,
    0xf3d7,
    0xb89a,
    0xf3d2,
    0xb89b,
    0xb89c,
    0xb89d,
    0xf3d4,
    0xf3d3,
    0xb7fb,
    0xb89e,
    0xb1bf,
    0xb89f,
    0xf3ce,
    0xf3ca,
    0xb5da,
    0xb8a0,
    0xf3d0,
    0xb940,
    0xb941,
    0xf3d1,
    0xb942,
    0xf3d5,
    0xb943,
    0xb944,
    0xb945,
    0xb946,
    0xf3cd,
    0xb947,
    0xbce3,
    0xb948,
    0xc1fd,
    0xb949,
    0xf3d6,
    0xb94a,
    0xb94b,
    0xb94c,
    0xb94d,
    0xb94e,
    0xb94f,
    0xf3da,
    0xb950,
    0xf3cc,
    0xb951,
    0xb5c8,
    0xb952,
    0xbdee,
    0xf3dc,
    0xb953,
    0xb954,
    0xb7a4,
    0xbff0,
    0xd6fe,
    0xcdb2,
    0xb955,
    0xb4f0,
    0xb956,
    0xb2df,
    0xb957,
    0xf3d8,
    0xb958,
    0xf3d9,
    0xc9b8,
    0xb959,
    0xf3dd,
    0xb95a,
    0xb95b,
    0xf3de,
    0xb95c,
    0xf3e1,
    0xb95d,
    0xb95e,
    0xb95f,
    0xb960,
    0xb961,
    0xb962,
    0xb963,
    0xb964,
    0xb965,
    0xb966,
    0xb967,
    0xf3df,
    0xb968,
    0xb969,
    0xf3e3,
    0xf3e2,
    0xb96a,
    0xb96b,
    0xf3db,
    0xb96c,
    0xbfea,
    0xb96d,
    0xb3ef,
    0xb96e,
    0xf3e0,
    0xb96f,
    0xb970,
    0xc7a9,
    0xb971,
    0xbcf2,
    0xb972,
    0xb973,
    0xb974,
    0xb975,
    0xf3eb,
    0xb976,
    0xb977,
    0xb978,
    0xb979,
    0xb97a,
    0xb97b,
    0xb97c,
    0xb9bf,
    0xb97d,
    0xb97e,
    0xf3e4,
    0xb980,
    0xb981,
    0xb982,
    0xb2ad,
    0xbbfe,
    0xb983,
    0xcbe3,
    0xb984,
    0xb985,
    0xb986,
    0xb987,
    0xf3ed,
    0xf3e9,
    0xb988,
    0xb989,
    0xb98a,
    0xb9dc,
    0xf3ee,
    0xb98b,
    0xb98c,
    0xb98d,
    0xf3e5,
    0xf3e6,
    0xf3ea,
    0xc2e1,
    0xf3ec,
    0xf3ef,
    0xf3e8,
    0xbcfd,
    0xb98e,
    0xb98f,
    0xb990,
    0xcfe4,
    0xb991,
    0xb992,
    0xf3f0,
    0xb993,
    0xb994,
    0xb995,
    0xf3e7,
    0xb996,
    0xb997,
    0xb998,
    0xb999,
    0xb99a,
    0xb99b,
    0xb99c,
    0xb99d,
    0xf3f2,
    0xb99e,
    0xb99f,
    0xb9a0,
    0xba40,
    0xd7ad,
    0xc6aa,
    0xba41,
    0xba42,
    0xba43,
    0xba44,
    0xf3f3,
    0xba45,
    0xba46,
    0xba47,
    0xba48,
    0xf3f1,
    0xba49,
    0xc2a8,
    0xba4a,
    0xba4b,
    0xba4c,
    0xba4d,
    0xba4e,
    0xb8dd,
    0xf3f5,
    0xba4f,
    0xba50,
    0xf3f4,
    0xba51,
    0xba52,
    0xba53,
    0xb4db,
    0xba54,
    0xba55,
    0xba56,
    0xf3f6,
    0xf3f7,
    0xba57,
    0xba58,
    0xba59,
    0xf3f8,
    0xba5a,
    0xba5b,
    0xba5c,
    0xc0ba,
    0xba5d,
    0xba5e,
    0xc0e9,
    0xba5f,
    0xba60,
    0xba61,
    0xba62,
    0xba63,
    0xc5f1,
    0xba64,
    0xba65,
    0xba66,
    0xba67,
    0xf3fb,
    0xba68,
    0xf3fa,
    0xba69
};
UINT16 cp936_UNI_a0x7c[] = {
    0xba6a,
    0xba6b,
    0xba6c,
    0xba6d,
    0xba6e,
    0xba6f,
    0xba70,
    0xb4d8,
    0xba71,
    0xba72,
    0xba73,
    0xf3fe,
    0xf3f9,
    0xba74,
    0xba75,
    0xf3fc,
    0xba76,
    0xba77,
    0xba78,
    0xba79,
    0xba7a,
    0xba7b,
    0xf3fd,
    0xba7c,
    0xba7d,
    0xba7e,
    0xba80,
    0xba81,
    0xba82,
    0xba83,
    0xba84,
    0xf4a1,
    0xba85,
    0xba86,
    0xba87,
    0xba88,
    0xba89,
    0xba8a,
    0xf4a3,
    0xbbc9,
    0xba8b,
    0xba8c,
    0xf4a2,
    0xba8d,
    0xba8e,
    0xba8f,
    0xba90,
    0xba91,
    0xba92,
    0xba93,
    0xba94,
    0xba95,
    0xba96,
    0xba97,
    0xba98,
    0xba99,
    0xf4a4,
    0xba9a,
    0xba9b,
    0xba9c,
    0xba9d,
    0xba9e,
    0xba9f,
    0xb2be,
    0xf4a6,
    0xf4a5,
    0xbaa0,
    0xbb40,
    0xbb41,
    0xbb42,
    0xbb43,
    0xbb44,
    0xbb45,
    0xbb46,
    0xbb47,
    0xbb48,
    0xbb49,
    0xbcae,
    0xbb4a,
    0xbb4b,
    0xbb4c,
    0xbb4d,
    0xbb4e,
    0xbb4f,
    0xbb50,
    0xbb51,
    0xbb52,
    0xbb53,
    0xbb54,
    0xbb55,
    0xbb56,
    0xbb57,
    0xbb58,
    0xbb59,
    0xbb5a,
    0xbb5b,
    0xbb5c,
    0xbb5d,
    0xbb5e,
    0xbb5f,
    0xbb60,
    0xbb61,
    0xbb62,
    0xbb63,
    0xbb64,
    0xbb65,
    0xbb66,
    0xbb67,
    0xbb68,
    0xbb69,
    0xbb6a,
    0xbb6b,
    0xbb6c,
    0xbb6d,
    0xbb6e,
    0xc3d7,
    0xd9e1,
    0xbb6f,
    0xbb70,
    0xbb71,
    0xbb72,
    0xbb73,
    0xbb74,
    0xc0e0,
    0xf4cc,
    0xd7d1,
    0xbb75,
    0xbb76,
    0xbb77,
    0xbb78,
    0xbb79,
    0xbb7a,
    0xbb7b,
    0xbb7c,
    0xbb7d,
    0xbb7e,
    0xbb80,
    0xb7db,
    0xbb81,
    0xbb82,
    0xbb83,
    0xbb84,
    0xbb85,
    0xbb86,
    0xbb87,
    0xf4ce,
    0xc1a3,
    0xbb88,
    0xbb89,
    0xc6c9,
    0xbb8a,
    0xb4d6,
    0xd5b3,
    0xbb8b,
    0xbb8c,
    0xbb8d,
    0xf4d0,
    0xf4cf,
    0xf4d1,
    0xcbda,
    0xbb8e,
    0xbb8f,
    0xf4d2,
    0xbb90,
    0xd4c1,
    0xd6e0,
    0xbb91,
    0xbb92,
    0xbb93,
    0xbb94,
    0xb7e0,
    0xbb95,
    0xbb96,
    0xbb97,
    0xc1b8,
    0xbb98,
    0xbb99,
    0xc1bb,
    0xf4d3,
    0xbeac,
    0xbb9a,
    0xbb9b,
    0xbb9c,
    0xbb9d,
    0xbb9e,
    0xb4e2,
    0xbb9f,
    0xbba0,
    0xf4d4,
    0xf4d5,
    0xbeab,
    0xbc40,
    0xbc41,
    0xf4d6,
    0xbc42,
    0xbc43,
    0xbc44,
    0xf4db,
    0xbc45,
    0xf4d7,
    0xf4da,
    0xbc46,
    0xbafd,
    0xbc47,
    0xf4d8,
    0xf4d9,
    0xbc48,
    0xbc49,
    0xbc4a,
    0xbc4b,
    0xbc4c,
    0xbc4d,
    0xbc4e,
    0xb8e2,
    0xccc7,
    0xf4dc,
    0xbc4f,
    0xb2da,
    0xbc50,
    0xbc51,
    0xc3d3,
    0xbc52,
    0xbc53,
    0xd4e3,
    0xbfb7,
    0xbc54,
    0xbc55,
    0xbc56,
    0xbc57,
    0xbc58,
    0xbc59,
    0xbc5a,
    0xf4dd,
    0xbc5b,
    0xbc5c,
    0xbc5d,
    0xbc5e,
    0xbc5f,
    0xbc60,
    0xc5b4,
    0xbc61,
    0xbc62,
    0xbc63,
    0xbc64,
    0xbc65,
    0xbc66,
    0xbc67,
    0xbc68,
    0xf4e9,
    0xbc69,
    0xbc6a,
    0xcfb5,
    0xbc6b,
    0xbc6c,
    0xbc6d,
    0xbc6e
};
UINT16 cp936_UNI_a0x7d[] = {
    0xbc6f,
    0xbc70,
    0xbc71,
    0xbc72,
    0xbc73,
    0xbc74,
    0xbc75,
    0xbc76,
    0xbc77,
    0xbc78,
    0xcec9,
    0xbc79,
    0xbc7a,
    0xbc7b,
    0xbc7c,
    0xbc7d,
    0xbc7e,
    0xbc80,
    0xbc81,
    0xbc82,
    0xbc83,
    0xbc84,
    0xbc85,
    0xbc86,
    0xbc87,
    0xbc88,
    0xbc89,
    0xbc8a,
    0xbc8b,
    0xbc8c,
    0xbc8d,
    0xbc8e,
    0xcbd8,
    0xbc8f,
    0xcbf7,
    0xbc90,
    0xbc91,
    0xbc92,
    0xbc93,
    0xbdf4,
    0xbc94,
    0xbc95,
    0xbc96,
    0xd7cf,
    0xbc97,
    0xbc98,
    0xbc99,
    0xc0db,
    0xbc9a,
    0xbc9b,
    0xbc9c,
    0xbc9d,
    0xbc9e,
    0xbc9f,
    0xbca0,
    0xbd40,
    0xbd41,
    0xbd42,
    0xbd43,
    0xbd44,
    0xbd45,
    0xbd46,
    0xbd47,
    0xbd48,
    0xbd49,
    0xbd4a,
    0xbd4b,
    0xbd4c,
    0xbd4d,
    0xbd4e,
    0xbd4f,
    0xbd50,
    0xbd51,
    0xbd52,
    0xbd53,
    0xbd54,
    0xbd55,
    0xbd56,
    0xbd57,
    0xbd58,
    0xbd59,
    0xbd5a,
    0xbd5b,
    0xbd5c,
    0xbd5d,
    0xbd5e,
    0xbd5f,
    0xbd60,
    0xbd61,
    0xbd62,
    0xbd63,
    0xbd64,
    0xbd65,
    0xbd66,
    0xbd67,
    0xbd68,
    0xbd69,
    0xbd6a,
    0xbd6b,
    0xbd6c,
    0xbd6d,
    0xbd6e,
    0xbd6f,
    0xbd70,
    0xbd71,
    0xbd72,
    0xbd73,
    0xbd74,
    0xbd75,
    0xbd76,
    0xd0f5,
    0xbd77,
    0xbd78,
    0xbd79,
    0xbd7a,
    0xbd7b,
    0xbd7c,
    0xbd7d,
    0xbd7e,
    0xf4ea,
    0xbd80,
    0xbd81,
    0xbd82,
    0xbd83,
    0xbd84,
    0xbd85,
    0xbd86,
    0xbd87,
    0xbd88,
    0xbd89,
    0xbd8a,
    0xbd8b,
    0xbd8c,
    0xbd8d,
    0xbd8e,
    0xbd8f,
    0xbd90,
    0xbd91,
    0xbd92,
    0xbd93,
    0xbd94,
    0xbd95,
    0xbd96,
    0xbd97,
    0xbd98,
    0xbd99,
    0xbd9a,
    0xbd9b,
    0xbd9c,
    0xbd9d,
    0xbd9e,
    0xbd9f,
    0xbda0,
    0xbe40,
    0xbe41,
    0xbe42,
    0xbe43,
    0xbe44,
    0xbe45,
    0xbe46,
    0xbe47,
    0xbe48,
    0xbe49,
    0xbe4a,
    0xbe4b,
    0xbe4c,
    0xf4eb,
    0xbe4d,
    0xbe4e,
    0xbe4f,
    0xbe50,
    0xbe51,
    0xbe52,
    0xbe53,
    0xf4ec,
    0xbe54,
    0xbe55,
    0xbe56,
    0xbe57,
    0xbe58,
    0xbe59,
    0xbe5a,
    0xbe5b,
    0xbe5c,
    0xbe5d,
    0xbe5e,
    0xbe5f,
    0xbe60,
    0xbe61,
    0xbe62,
    0xbe63,
    0xbe64,
    0xbe65,
    0xbe66,
    0xbe67,
    0xbe68,
    0xbe69,
    0xbe6a,
    0xbe6b,
    0xbe6c,
    0xbe6d,
    0xbe6e,
    0xbe6f,
    0xbe70,
    0xbe71,
    0xbe72,
    0xbe73,
    0xbe74,
    0xbe75,
    0xbe76,
    0xbe77,
    0xbe78,
    0xbe79,
    0xbe7a,
    0xbe7b,
    0xbe7c,
    0xbe7d,
    0xbe7e,
    0xbe80,
    0xbe81,
    0xbe82,
    0xbe83,
    0xbe84,
    0xbe85,
    0xbe86,
    0xbe87,
    0xbe88,
    0xbe89,
    0xbe8a,
    0xbe8b,
    0xbe8c,
    0xbe8d,
    0xbe8e,
    0xbe8f,
    0xbe90,
    0xbe91,
    0xbe92,
    0xbe93,
    0xbe94,
    0xbe95,
    0xbe96,
    0xbe97,
    0xbe98,
    0xbe99,
    0xbe9a,
    0xbe9b,
    0xbe9c,
    0xbe9d,
    0xbe9e,
    0xbe9f,
    0xbea0,
    0xbf40,
    0xbf41,
    0xbf42,
    0xbf43,
    0xbf44
};
UINT16 cp936_UNI_a0x7e[] = {
    0xbf45,
    0xbf46,
    0xbf47,
    0xbf48,
    0xbf49,
    0xbf4a,
    0xbf4b,
    0xbf4c,
    0xbf4d,
    0xbf4e,
    0xbf4f,
    0xbf50,
    0xbf51,
    0xbf52,
    0xbf53,
    0xbf54,
    0xbf55,
    0xbf56,
    0xbf57,
    0xbf58,
    0xbf59,
    0xbf5a,
    0xbf5b,
    0xbf5c,
    0xbf5d,
    0xbf5e,
    0xbf5f,
    0xbf60,
    0xbf61,
    0xbf62,
    0xbf63,
    0xbf64,
    0xbf65,
    0xbf66,
    0xbf67,
    0xbf68,
    0xbf69,
    0xbf6a,
    0xbf6b,
    0xbf6c,
    0xbf6d,
    0xbf6e,
    0xbf6f,
    0xbf70,
    0xbf71,
    0xbf72,
    0xbf73,
    0xbf74,
    0xbf75,
    0xbf76,
    0xbf77,
    0xbf78,
    0xbf79,
    0xbf7a,
    0xbf7b,
    0xbf7c,
    0xbf7d,
    0xbf7e,
    0xbf80,
    0xf7e3,
    0xbf81,
    0xbf82,
    0xbf83,
    0xbf84,
    0xbf85,
    0xb7b1,
    0xbf86,
    0xbf87,
    0xbf88,
    0xbf89,
    0xbf8a,
    0xf4ed,
    0xbf8b,
    0xbf8c,
    0xbf8d,
    0xbf8e,
    0xbf8f,
    0xbf90,
    0xbf91,
    0xbf92,
    0xbf93,
    0xbf94,
    0xbf95,
    0xbf96,
    0xbf97,
    0xbf98,
    0xbf99,
    0xbf9a,
    0xbf9b,
    0xbf9c,
    0xbf9d,
    0xbf9e,
    0xbf9f,
    0xbfa0,
    0xc040,
    0xc041,
    0xc042,
    0xc043,
    0xc044,
    0xc045,
    0xc046,
    0xc047,
    0xc048,
    0xc049,
    0xc04a,
    0xc04b,
    0xc04c,
    0xc04d,
    0xc04e,
    0xc04f,
    0xc050,
    0xc051,
    0xc052,
    0xc053,
    0xc054,
    0xc055,
    0xc056,
    0xc057,
    0xc058,
    0xc059,
    0xc05a,
    0xc05b,
    0xc05c,
    0xc05d,
    0xc05e,
    0xc05f,
    0xc060,
    0xc061,
    0xc062,
    0xc063,
    0xd7eb,
    0xc064,
    0xc065,
    0xc066,
    0xc067,
    0xc068,
    0xc069,
    0xc06a,
    0xc06b,
    0xc06c,
    0xc06d,
    0xc06e,
    0xc06f,
    0xc070,
    0xc071,
    0xc072,
    0xc073,
    0xc074,
    0xc075,
    0xc076,
    0xc077,
    0xc078,
    0xc079,
    0xc07a,
    0xc07b,
    0xf4ee,
    0xc07c,
    0xc07d,
    0xc07e,
    0xe6f9,
    0xbec0,
    0xe6fa,
    0xbaec,
    0xe6fb,
    0xcfcb,
    0xe6fc,
    0xd4bc,
    0xbcb6,
    0xe6fd,
    0xe6fe,
    0xbccd,
    0xc8d2,
    0xceb3,
    0xe7a1,
    0xc080,
    0xb4bf,
    0xe7a2,
    0xc9b4,
    0xb8d9,
    0xc4c9,
    0xc081,
    0xd7dd,
    0xc2da,
    0xb7d7,
    0xd6bd,
    0xcec6,
    0xb7c4,
    0xc082,
    0xc083,
    0xc5a6,
    0xe7a3,
    0xcfdf,
    0xe7a4,
    0xe7a5,
    0xe7a6,
    0xc1b7,
    0xd7e9,
    0xc9f0,
    0xcfb8,
    0xd6af,
    0xd6d5,
    0xe7a7,
    0xb0ed,
    0xe7a8,
    0xe7a9,
    0xc9dc,
    0xd2ef,
    0xbead,
    0xe7aa,
    0xb0f3,
    0xc8de,
    0xbde1,
    0xe7ab,
    0xc8c6,
    0xc084,
    0xe7ac,
    0xbbe6,
    0xb8f8,
    0xd1a4,
    0xe7ad,
    0xc2e7,
    0xbef8,
    0xbdca,
    0xcdb3,
    0xe7ae,
    0xe7af,
    0xbeee,
    0xd0e5,
    0xc085,
    0xcbe7,
    0xccd0,
    0xbccc,
    0xe7b0,
    0xbca8,
    0xd0f7,
    0xe7b1,
    0xc086,
    0xd0f8,
    0xe7b2,
    0xe7b3,
    0xb4c2,
    0xe7b4,
    0xe7b5,
    0xc9fe,
    0xceac,
    0xc3e0,
    0xe7b7,
    0xb1c1,
    0xb3f1,
    0xc087,
    0xe7b8,
    0xe7b9,
    0xd7db,
    0xd5c0,
    0xe7ba,
    0xc2cc
};
UINT16 cp936_UNI_a0x7f[] = {
    0xd7ba,
    0xe7bb,
    0xe7bc,
    0xe7bd,
    0xbcea,
    0xc3e5,
    0xc0c2,
    0xe7be,
    0xe7bf,
    0xbca9,
    0xc088,
    0xe7c0,
    0xe7c1,
    0xe7b6,
    0xb6d0,
    0xe7c2,
    0xc089,
    0xe7c3,
    0xe7c4,
    0xbbba,
    0xb5de,
    0xc2c6,
    0xb1e0,
    0xe7c5,
    0xd4b5,
    0xe7c6,
    0xb8bf,
    0xe7c8,
    0xe7c7,
    0xb7ec,
    0xc08a,
    0xe7c9,
    0xb2f8,
    0xe7ca,
    0xe7cb,
    0xe7cc,
    0xe7cd,
    0xe7ce,
    0xe7cf,
    0xe7d0,
    0xd3a7,
    0xcbf5,
    0xe7d1,
    0xe7d2,
    0xe7d3,
    0xe7d4,
    0xc9c9,
    0xe7d5,
    0xe7d6,
    0xe7d7,
    0xe7d8,
    0xe7d9,
    0xbdc9,
    0xe7da,
    0xf3be,
    0xc08b,
    0xb8d7,
    0xc08c,
    0xc8b1,
    0xc08d,
    0xc08e,
    0xc08f,
    0xc090,
    0xc091,
    0xc092,
    0xc093,
    0xf3bf,
    0xc094,
    0xf3c0,
    0xf3c1,
    0xc095,
    0xc096,
    0xc097,
    0xc098,
    0xc099,
    0xc09a,
    0xc09b,
    0xc09c,
    0xc09d,
    0xc09e,
    0xb9de,
    0xcdf8,
    0xc09f,
    0xc0a0,
    0xd8e8,
    0xbab1,
    0xc140,
    0xc2de,
    0xeeb7,
    0xc141,
    0xb7a3,
    0xc142,
    0xc143,
    0xc144,
    0xc145,
    0xeeb9,
    0xc146,
    0xeeb8,
    0xb0d5,
    0xc147,
    0xc148,
    0xc149,
    0xc14a,
    0xc14b,
    0xeebb,
    0xd5d6,
    0xd7ef,
    0xc14c,
    0xc14d,
    0xc14e,
    0xd6c3,
    0xc14f,
    0xc150,
    0xeebd,
    0xcaf0,
    0xc151,
    0xeebc,
    0xc152,
    0xc153,
    0xc154,
    0xc155,
    0xeebe,
    0xc156,
    0xc157,
    0xc158,
    0xc159,
    0xeec0,
    0xc15a,
    0xc15b,
    0xeebf,
    0xc15c,
    0xc15d,
    0xc15e,
    0xc15f,
    0xc160,
    0xc161,
    0xc162,
    0xc163,
    0xd1f2,
    0xc164,
    0xc7bc,
    0xc165,
    0xc3c0,
    0xc166,
    0xc167,
    0xc168,
    0xc169,
    0xc16a,
    0xb8e1,
    0xc16b,
    0xc16c,
    0xc16d,
    0xc16e,
    0xc16f,
    0xc1e7,
    0xc170,
    0xc171,
    0xf4c6,
    0xd0df,
    0xf4c7,
    0xc172,
    0xcfdb,
    0xc173,
    0xc174,
    0xc8ba,
    0xc175,
    0xc176,
    0xf4c8,
    0xc177,
    0xc178,
    0xc179,
    0xc17a,
    0xc17b,
    0xc17c,
    0xc17d,
    0xf4c9,
    0xf4ca,
    0xc17e,
    0xf4cb,
    0xc180,
    0xc181,
    0xc182,
    0xc183,
    0xc184,
    0xd9fa,
    0xb8fe,
    0xc185,
    0xc186,
    0xe5f1,
    0xd3f0,
    0xc187,
    0xf4e0,
    0xc188,
    0xcecc,
    0xc189,
    0xc18a,
    0xc18b,
    0xb3e1,
    0xc18c,
    0xc18d,
    0xc18e,
    0xc18f,
    0xf1b4,
    0xc190,
    0xd2ee,
    0xc191,
    0xf4e1,
    0xc192,
    0xc193,
    0xc194,
    0xc195,
    0xc196,
    0xcfe8,
    0xf4e2,
    0xc197,
    0xc198,
    0xc7cc,
    0xc199,
    0xc19a,
    0xc19b,
    0xc19c,
    0xc19d,
    0xc19e,
    0xb5d4,
    0xb4e4,
    0xf4e4,
    0xc19f,
    0xc1a0,
    0xc240,
    0xf4e3,
    0xf4e5,
    0xc241,
    0xc242,
    0xf4e6,
    0xc243,
    0xc244,
    0xc245,
    0xc246,
    0xf4e7,
    0xc247,
    0xbab2,
    0xb0bf,
    0xc248,
    0xf4e8,
    0xc249,
    0xc24a,
    0xc24b,
    0xc24c,
    0xc24d,
    0xc24e,
    0xc24f,
    0xb7ad,
    0xd2ed,
    0xc250,
    0xc251,
    0xc252
};
UINT16 cp936_UNI_a0x80[] = {
    0xd2ab,
    0xc0cf,
    0xc253,
    0xbfbc,
    0xeba3,
    0xd5df,
    0xeac8,
    0xc254,
    0xc255,
    0xc256,
    0xc257,
    0xf1f3,
    0xb6f8,
    0xcba3,
    0xc258,
    0xc259,
    0xc4cd,
    0xc25a,
    0xf1e7,
    0xc25b,
    0xf1e8,
    0xb8fb,
    0xf1e9,
    0xbac4,
    0xd4c5,
    0xb0d2,
    0xc25c,
    0xc25d,
    0xf1ea,
    0xc25e,
    0xc25f,
    0xc260,
    0xf1eb,
    0xc261,
    0xf1ec,
    0xc262,
    0xc263,
    0xf1ed,
    0xf1ee,
    0xf1ef,
    0xf1f1,
    0xf1f0,
    0xc5d5,
    0xc264,
    0xc265,
    0xc266,
    0xc267,
    0xc268,
    0xc269,
    0xf1f2,
    0xc26a,
    0xb6fa,
    0xc26b,
    0xf1f4,
    0xd2ae,
    0xdec7,
    0xcbca,
    0xc26c,
    0xc26d,
    0xb3dc,
    0xc26e,
    0xb5a2,
    0xc26f,
    0xb9a2,
    0xc270,
    0xc271,
    0xc4f4,
    0xf1f5,
    0xc272,
    0xc273,
    0xf1f6,
    0xc274,
    0xc275,
    0xc276,
    0xc1c4,
    0xc1fb,
    0xd6b0,
    0xf1f7,
    0xc277,
    0xc278,
    0xc279,
    0xc27a,
    0xf1f8,
    0xc27b,
    0xc1aa,
    0xc27c,
    0xc27d,
    0xc27e,
    0xc6b8,
    0xc280,
    0xbedb,
    0xc281,
    0xc282,
    0xc283,
    0xc284,
    0xc285,
    0xc286,
    0xc287,
    0xc288,
    0xc289,
    0xc28a,
    0xc28b,
    0xc28c,
    0xc28d,
    0xc28e,
    0xf1f9,
    0xb4cf,
    0xc28f,
    0xc290,
    0xc291,
    0xc292,
    0xc293,
    0xc294,
    0xf1fa,
    0xc295,
    0xc296,
    0xc297,
    0xc298,
    0xc299,
    0xc29a,
    0xc29b,
    0xc29c,
    0xc29d,
    0xc29e,
    0xc29f,
    0xc2a0,
    0xc340,
    0xedb2,
    0xedb1,
    0xc341,
    0xc342,
    0xcbe0,
    0xd2de,
    0xc343,
    0xcbc1,
    0xd5d8,
    0xc344,
    0xc8e2,
    0xc345,
    0xc0df,
    0xbca1,
    0xc346,
    0xc347,
    0xc348,
    0xc349,
    0xc34a,
    0xc34b,
    0xebc1,
    0xc34c,
    0xc34d,
    0xd0a4,
    0xc34e,
    0xd6e2,
    0xc34f,
    0xb6c7,
    0xb8d8,
    0xebc0,
    0xb8ce,
    0xc350,
    0xebbf,
    0xb3a6,
    0xb9c9,
    0xd6ab,
    0xc351,
    0xb7f4,
    0xb7ca,
    0xc352,
    0xc353,
    0xc354,
    0xbce7,
    0xb7be,
    0xebc6,
    0xc355,
    0xebc7,
    0xb0b9,
    0xbfcf,
    0xc356,
    0xebc5,
    0xd3fd,
    0xc357,
    0xebc8,
    0xc358,
    0xc359,
    0xebc9,
    0xc35a,
    0xc35b,
    0xb7ce,
    0xc35c,
    0xebc2,
    0xebc4,
    0xc9f6,
    0xd6d7,
    0xd5cd,
    0xd0b2,
    0xebcf,
    0xceb8,
    0xebd0,
    0xc35d,
    0xb5a8,
    0xc35e,
    0xc35f,
    0xc360,
    0xc361,
    0xc362,
    0xb1b3,
    0xebd2,
    0xcca5,
    0xc363,
    0xc364,
    0xc365,
    0xc366,
    0xc367,
    0xc368,
    0xc369,
    0xc5d6,
    0xebd3,
    0xc36a,
    0xebd1,
    0xc5df,
    0xebce,
    0xcaa4,
    0xebd5,
    0xb0fb,
    0xc36b,
    0xc36c,
    0xbafa,
    0xc36d,
    0xc36e,
    0xd8b7,
    0xf1e3,
    0xc36f,
    0xebca,
    0xebcb,
    0xebcc,
    0xebcd,
    0xebd6,
    0xe6c0,
    0xebd9,
    0xc370,
    0xbfe8,
    0xd2c8,
    0xebd7,
    0xebdc,
    0xb8ec,
    0xebd8,
    0xc371,
    0xbdba,
    0xc372,
    0xd0d8,
    0xc373,
    0xb0b7,
    0xc374,
    0xebdd,
    0xc4dc,
    0xc375,
    0xc376
};
UINT16 cp936_UNI_a0x81[] = {
    0xc377,
    0xc378,
    0xd6ac,
    0xc379,
    0xc37a,
    0xc37b,
    0xb4e0,
    0xc37c,
    0xc37d,
    0xc2f6,
    0xbcb9,
    0xc37e,
    0xc380,
    0xebda,
    0xebdb,
    0xd4e0,
    0xc6ea,
    0xc4d4,
    0xebdf,
    0xc5a7,
    0xd9f5,
    0xc381,
    0xb2b1,
    0xc382,
    0xebe4,
    0xc383,
    0xbdc5,
    0xc384,
    0xc385,
    0xc386,
    0xebe2,
    0xc387,
    0xc388,
    0xc389,
    0xc38a,
    0xc38b,
    0xc38c,
    0xc38d,
    0xc38e,
    0xc38f,
    0xc390,
    0xc391,
    0xc392,
    0xc393,
    0xebe3,
    0xc394,
    0xc395,
    0xb8ac,
    0xc396,
    0xcdd1,
    0xebe5,
    0xc397,
    0xc398,
    0xc399,
    0xebe1,
    0xc39a,
    0xc1b3,
    0xc39b,
    0xc39c,
    0xc39d,
    0xc39e,
    0xc39f,
    0xc6a2,
    0xc3a0,
    0xc440,
    0xc441,
    0xc442,
    0xc443,
    0xc444,
    0xc445,
    0xccf3,
    0xc446,
    0xebe6,
    0xc447,
    0xc0b0,
    0xd2b8,
    0xebe7,
    0xc448,
    0xc449,
    0xc44a,
    0xb8af,
    0xb8ad,
    0xc44b,
    0xebe8,
    0xc7bb,
    0xcdf3,
    0xc44c,
    0xc44d,
    0xc44e,
    0xebea,
    0xebeb,
    0xc44f,
    0xc450,
    0xc451,
    0xc452,
    0xc453,
    0xebed,
    0xc454,
    0xc455,
    0xc456,
    0xc457,
    0xd0c8,
    0xc458,
    0xebf2,
    0xc459,
    0xebee,
    0xc45a,
    0xc45b,
    0xc45c,
    0xebf1,
    0xc8f9,
    0xc45d,
    0xd1fc,
    0xebec,
    0xc45e,
    0xc45f,
    0xebe9,
    0xc460,
    0xc461,
    0xc462,
    0xc463,
    0xb8b9,
    0xcfd9,
    0xc4e5,
    0xebef,
    0xebf0,
    0xccda,
    0xcdc8,
    0xb0f2,
    0xc464,
    0xebf6,
    0xc465,
    0xc466,
    0xc467,
    0xc468,
    0xc469,
    0xebf5,
    0xc46a,
    0xb2b2,
    0xc46b,
    0xc46c,
    0xc46d,
    0xc46e,
    0xb8e0,
    0xc46f,
    0xebf7,
    0xc470,
    0xc471,
    0xc472,
    0xc473,
    0xc474,
    0xc475,
    0xb1ec,
    0xc476,
    0xc477,
    0xccc5,
    0xc4a4,
    0xcfa5,
    0xc478,
    0xc479,
    0xc47a,
    0xc47b,
    0xc47c,
    0xebf9,
    0xc47d,
    0xc47e,
    0xeca2,
    0xc480,
    0xc5f2,
    0xc481,
    0xebfa,
    0xc482,
    0xc483,
    0xc484,
    0xc485,
    0xc486,
    0xc487,
    0xc488,
    0xc489,
    0xc9c5,
    0xc48a,
    0xc48b,
    0xc48c,
    0xc48d,
    0xc48e,
    0xc48f,
    0xe2df,
    0xebfe,
    0xc490,
    0xc491,
    0xc492,
    0xc493,
    0xcdce,
    0xeca1,
    0xb1db,
    0xd3b7,
    0xc494,
    0xc495,
    0xd2dc,
    0xc496,
    0xc497,
    0xc498,
    0xebfd,
    0xc499,
    0xebfb,
    0xc49a,
    0xc49b,
    0xc49c,
    0xc49d,
    0xc49e,
    0xc49f,
    0xc4a0,
    0xc540,
    0xc541,
    0xc542,
    0xc543,
    0xc544,
    0xc545,
    0xc546,
    0xc547,
    0xc548,
    0xc549,
    0xc54a,
    0xc54b,
    0xc54c,
    0xc54d,
    0xc54e,
    0xb3bc,
    0xc54f,
    0xc550,
    0xc551,
    0xeab0,
    0xc552,
    0xc553,
    0xd7d4,
    0xc554,
    0xf4ab,
    0xb3f4,
    0xc555,
    0xc556,
    0xc557,
    0xc558,
    0xc559,
    0xd6c1,
    0xd6c2,
    0xc55a,
    0xc55b,
    0xc55c,
    0xc55d,
    0xc55e,
    0xc55f,
    0xd5e9,
    0xbeca,
    0xc560,
    0xf4a7,
    0xc561
};
UINT16 cp936_UNI_a0x82[] = {
    0xd2a8,
    0xf4a8,
    0xf4a9,
    0xc562,
    0xf4aa,
    0xbecb,
    0xd3df,
    0xc563,
    0xc564,
    0xc565,
    0xc566,
    0xc567,
    0xc9e0,
    0xc9e1,
    0xc568,
    0xc569,
    0xf3c2,
    0xc56a,
    0xcae6,
    0xc56b,
    0xccf2,
    0xc56c,
    0xc56d,
    0xc56e,
    0xc56f,
    0xc570,
    0xc571,
    0xe2b6,
    0xcbb4,
    0xc572,
    0xcee8,
    0xd6db,
    0xc573,
    0xf4ad,
    0xf4ae,
    0xf4af,
    0xc574,
    0xc575,
    0xc576,
    0xc577,
    0xf4b2,
    0xc578,
    0xbabd,
    0xf4b3,
    0xb0e3,
    0xf4b0,
    0xc579,
    0xf4b1,
    0xbda2,
    0xb2d5,
    0xc57a,
    0xf4b6,
    0xf4b7,
    0xb6e6,
    0xb2b0,
    0xcfcf,
    0xf4b4,
    0xb4ac,
    0xc57b,
    0xf4b5,
    0xc57c,
    0xc57d,
    0xf4b8,
    0xc57e,
    0xc580,
    0xc581,
    0xc582,
    0xc583,
    0xf4b9,
    0xc584,
    0xc585,
    0xcda7,
    0xc586,
    0xf4ba,
    0xc587,
    0xf4bb,
    0xc588,
    0xc589,
    0xc58a,
    0xf4bc,
    0xc58b,
    0xc58c,
    0xc58d,
    0xc58e,
    0xc58f,
    0xc590,
    0xc591,
    0xc592,
    0xcbd2,
    0xc593,
    0xf4bd,
    0xc594,
    0xc595,
    0xc596,
    0xc597,
    0xf4be,
    0xc598,
    0xc599,
    0xc59a,
    0xc59b,
    0xc59c,
    0xc59d,
    0xc59e,
    0xc59f,
    0xf4bf,
    0xc5a0,
    0xc640,
    0xc641,
    0xc642,
    0xc643,
    0xf4de,
    0xc1bc,
    0xbce8,
    0xc644,
    0xc9ab,
    0xd1de,
    0xe5f5,
    0xc645,
    0xc646,
    0xc647,
    0xc648,
    0xdcb3,
    0xd2d5,
    0xc649,
    0xc64a,
    0xdcb4,
    0xb0ac,
    0xdcb5,
    0xc64b,
    0xc64c,
    0xbdda,
    0xc64d,
    0xdcb9,
    0xc64e,
    0xc64f,
    0xc650,
    0xd8c2,
    0xc651,
    0xdcb7,
    0xd3f3,
    0xc652,
    0xc9d6,
    0xdcba,
    0xdcb6,
    0xc653,
    0xdcbb,
    0xc3a2,
    0xc654,
    0xc655,
    0xc656,
    0xc657,
    0xdcbc,
    0xdcc5,
    0xdcbd,
    0xc658,
    0xc659,
    0xcedf,
    0xd6a5,
    0xc65a,
    0xdccf,
    0xc65b,
    0xdccd,
    0xc65c,
    0xc65d,
    0xdcd2,
    0xbde6,
    0xc2ab,
    0xc65e,
    0xdcb8,
    0xdccb,
    0xdcce,
    0xdcbe,
    0xb7d2,
    0xb0c5,
    0xdcc7,
    0xd0be,
    0xdcc1,
    0xbba8,
    0xc65f,
    0xb7bc,
    0xdccc,
    0xc660,
    0xc661,
    0xdcc6,
    0xdcbf,
    0xc7db,
    0xc662,
    0xc663,
    0xc664,
    0xd1bf,
    0xdcc0,
    0xc665,
    0xc666,
    0xdcca,
    0xc667,
    0xc668,
    0xdcd0,
    0xc669,
    0xc66a,
    0xcead,
    0xdcc2,
    0xc66b,
    0xdcc3,
    0xdcc8,
    0xdcc9,
    0xb2d4,
    0xdcd1,
    0xcbd5,
    0xc66c,
    0xd4b7,
    0xdcdb,
    0xdcdf,
    0xcca6,
    0xdce6,
    0xc66d,
    0xc3e7,
    0xdcdc,
    0xc66e,
    0xc66f,
    0xbfc1,
    0xdcd9,
    0xc670,
    0xb0fa,
    0xb9b6,
    0xdce5,
    0xdcd3,
    0xc671,
    0xdcc4,
    0xdcd6,
    0xc8f4,
    0xbfe0,
    0xc672,
    0xc673,
    0xc674,
    0xc675,
    0xc9bb,
    0xc676,
    0xc677,
    0xc678,
    0xb1bd,
    0xc679,
    0xd3a2,
    0xc67a,
    0xc67b,
    0xdcda,
    0xc67c,
    0xc67d,
    0xdcd5,
    0xc67e,
    0xc6bb,
    0xc680,
    0xdcde,
    0xc681,
    0xc682,
    0xc683,
    0xc684
};
UINT16 cp936_UNI_a0x83[] = {
    0xc685,
    0xd7c2,
    0xc3af,
    0xb7b6,
    0xc7d1,
    0xc3a9,
    0xdce2,
    0xdcd8,
    0xdceb,
    0xdcd4,
    0xc686,
    0xc687,
    0xdcdd,
    0xc688,
    0xbea5,
    0xdcd7,
    0xc689,
    0xdce0,
    0xc68a,
    0xc68b,
    0xdce3,
    0xdce4,
    0xc68c,
    0xdcf8,
    0xc68d,
    0xc68e,
    0xdce1,
    0xdda2,
    0xdce7,
    0xc68f,
    0xc690,
    0xc691,
    0xc692,
    0xc693,
    0xc694,
    0xc695,
    0xc696,
    0xc697,
    0xc698,
    0xbceb,
    0xb4c4,
    0xc699,
    0xc69a,
    0xc3a3,
    0xb2e7,
    0xdcfa,
    0xc69b,
    0xdcf2,
    0xc69c,
    0xdcef,
    0xc69d,
    0xdcfc,
    0xdcee,
    0xd2f0,
    0xb2e8,
    0xc69e,
    0xc8d7,
    0xc8e3,
    0xdcfb,
    0xc69f,
    0xdced,
    0xc6a0,
    0xc740,
    0xc741,
    0xdcf7,
    0xc742,
    0xc743,
    0xdcf5,
    0xc744,
    0xc745,
    0xbea3,
    0xdcf4,
    0xc746,
    0xb2dd,
    0xc747,
    0xc748,
    0xc749,
    0xc74a,
    0xc74b,
    0xdcf3,
    0xbcf6,
    0xdce8,
    0xbbc4,
    0xc74c,
    0xc0f3,
    0xc74d,
    0xc74e,
    0xc74f,
    0xc750,
    0xc751,
    0xbcd4,
    0xdce9,
    0xdcea,
    0xc752,
    0xdcf1,
    0xdcf6,
    0xdcf9,
    0xb5b4,
    0xc753,
    0xc8d9,
    0xbbe7,
    0xdcfe,
    0xdcfd,
    0xd3ab,
    0xdda1,
    0xdda3,
    0xdda5,
    0xd2f1,
    0xdda4,
    0xdda6,
    0xdda7,
    0xd2a9,
    0xc754,
    0xc755,
    0xc756,
    0xc757,
    0xc758,
    0xc759,
    0xc75a,
    0xbac9,
    0xdda9,
    0xc75b,
    0xc75c,
    0xddb6,
    0xddb1,
    0xddb4,
    0xc75d,
    0xc75e,
    0xc75f,
    0xc760,
    0xc761,
    0xc762,
    0xc763,
    0xddb0,
    0xc6ce,
    0xc764,
    0xc765,
    0xc0f2,
    0xc766,
    0xc767,
    0xc768,
    0xc769,
    0xc9af,
    0xc76a,
    0xc76b,
    0xc76c,
    0xdcec,
    0xddae,
    0xc76d,
    0xc76e,
    0xc76f,
    0xc770,
    0xddb7,
    0xc771,
    0xc772,
    0xdcf0,
    0xddaf,
    0xc773,
    0xddb8,
    0xc774,
    0xddac,
    0xc775,
    0xc776,
    0xc777,
    0xc778,
    0xc779,
    0xc77a,
    0xc77b,
    0xddb9,
    0xddb3,
    0xddad,
    0xc4aa,
    0xc77c,
    0xc77d,
    0xc77e,
    0xc780,
    0xdda8,
    0xc0b3,
    0xc1ab,
    0xddaa,
    0xddab,
    0xc781,
    0xddb2,
    0xbbf1,
    0xddb5,
    0xd3a8,
    0xddba,
    0xc782,
    0xddbb,
    0xc3a7,
    0xc783,
    0xc784,
    0xddd2,
    0xddbc,
    0xc785,
    0xc786,
    0xc787,
    0xddd1,
    0xc788,
    0xb9bd,
    0xc789,
    0xc78a,
    0xbed5,
    0xc78b,
    0xbefa,
    0xc78c,
    0xc78d,
    0xbaca,
    0xc78e,
    0xc78f,
    0xc790,
    0xc791,
    0xddca,
    0xc792,
    0xddc5,
    0xc793,
    0xddbf,
    0xc794,
    0xc795,
    0xc796,
    0xb2cb,
    0xddc3,
    0xc797,
    0xddcb,
    0xb2a4,
    0xddd5,
    0xc798,
    0xc799,
    0xc79a,
    0xddbe,
    0xc79b,
    0xc79c,
    0xc79d,
    0xc6d0,
    0xddd0,
    0xc79e,
    0xc79f,
    0xc7a0,
    0xc840,
    0xc841,
    0xddd4,
    0xc1e2,
    0xb7c6,
    0xc842,
    0xc843,
    0xc844,
    0xc845,
    0xc846,
    0xddce,
    0xddcf,
    0xc847,
    0xc848,
    0xc849,
    0xddc4,
    0xc84a,
    0xc84b
};
UINT16 cp936_UNI_a0x84[] = {
    0xc84c,
    0xddbd,
    0xc84d,
    0xddcd,
    0xccd1,
    0xc84e,
    0xddc9,
    0xc84f,
    0xc850,
    0xc851,
    0xc852,
    0xddc2,
    0xc3c8,
    0xc6bc,
    0xceae,
    0xddcc,
    0xc853,
    0xddc8,
    0xc854,
    0xc855,
    0xc856,
    0xc857,
    0xc858,
    0xc859,
    0xddc1,
    0xc85a,
    0xc85b,
    0xc85c,
    0xddc6,
    0xc2dc,
    0xc85d,
    0xc85e,
    0xc85f,
    0xc860,
    0xc861,
    0xc862,
    0xd3a9,
    0xd3aa,
    0xddd3,
    0xcff4,
    0xc8f8,
    0xc863,
    0xc864,
    0xc865,
    0xc866,
    0xc867,
    0xc868,
    0xc869,
    0xc86a,
    0xdde6,
    0xc86b,
    0xc86c,
    0xc86d,
    0xc86e,
    0xc86f,
    0xc870,
    0xddc7,
    0xc871,
    0xc872,
    0xc873,
    0xdde0,
    0xc2e4,
    0xc874,
    0xc875,
    0xc876,
    0xc877,
    0xc878,
    0xc879,
    0xc87a,
    0xc87b,
    0xdde1,
    0xc87c,
    0xc87d,
    0xc87e,
    0xc880,
    0xc881,
    0xc882,
    0xc883,
    0xc884,
    0xc885,
    0xc886,
    0xddd7,
    0xc887,
    0xc888,
    0xc889,
    0xc88a,
    0xc88b,
    0xd6f8,
    0xc88c,
    0xddd9,
    0xddd8,
    0xb8f0,
    0xddd6,
    0xc88d,
    0xc88e,
    0xc88f,
    0xc890,
    0xc6cf,
    0xc891,
    0xb6ad,
    0xc892,
    0xc893,
    0xc894,
    0xc895,
    0xc896,
    0xdde2,
    0xc897,
    0xbaf9,
    0xd4e1,
    0xdde7,
    0xc898,
    0xc899,
    0xc89a,
    0xb4d0,
    0xc89b,
    0xddda,
    0xc89c,
    0xbffb,
    0xdde3,
    0xc89d,
    0xdddf,
    0xc89e,
    0xdddd,
    0xc89f,
    0xc8a0,
    0xc940,
    0xc941,
    0xc942,
    0xc943,
    0xc944,
    0xb5d9,
    0xc945,
    0xc946,
    0xc947,
    0xc948,
    0xdddb,
    0xdddc,
    0xddde,
    0xc949,
    0xbdaf,
    0xdde4,
    0xc94a,
    0xdde5,
    0xc94b,
    0xc94c,
    0xc94d,
    0xc94e,
    0xc94f,
    0xc950,
    0xc951,
    0xc952,
    0xddf5,
    0xc953,
    0xc3c9,
    0xc954,
    0xc955,
    0xcbe2,
    0xc956,
    0xc957,
    0xc958,
    0xc959,
    0xddf2,
    0xc95a,
    0xc95b,
    0xc95c,
    0xc95d,
    0xc95e,
    0xc95f,
    0xc960,
    0xc961,
    0xc962,
    0xc963,
    0xc964,
    0xc965,
    0xc966,
    0xd8e1,
    0xc967,
    0xc968,
    0xc6d1,
    0xc969,
    0xddf4,
    0xc96a,
    0xc96b,
    0xc96c,
    0xd5f4,
    0xddf3,
    0xddf0,
    0xc96d,
    0xc96e,
    0xddec,
    0xc96f,
    0xddef,
    0xc970,
    0xdde8,
    0xc971,
    0xc972,
    0xd0ee,
    0xc973,
    0xc974,
    0xc975,
    0xc976,
    0xc8d8,
    0xddee,
    0xc977,
    0xc978,
    0xdde9,
    0xc979,
    0xc97a,
    0xddea,
    0xcbf2,
    0xc97b,
    0xdded,
    0xc97c,
    0xc97d,
    0xb1cd,
    0xc97e,
    0xc980,
    0xc981,
    0xc982,
    0xc983,
    0xc984,
    0xc0b6,
    0xc985,
    0xbcbb,
    0xddf1,
    0xc986,
    0xc987,
    0xddf7,
    0xc988,
    0xddf6,
    0xddeb,
    0xc989,
    0xc98a,
    0xc98b,
    0xc98c,
    0xc98d,
    0xc5ee,
    0xc98e,
    0xc98f,
    0xc990,
    0xddfb,
    0xc991,
    0xc992,
    0xc993,
    0xc994,
    0xc995,
    0xc996,
    0xc997,
    0xc998,
    0xc999,
    0xc99a,
    0xc99b,
    0xdea4,
    0xc99c,
    0xc99d,
    0xdea3
};
UINT16 cp936_UNI_a0x85[] = {
    0xc99e,
    0xc99f,
    0xc9a0,
    0xca40,
    0xca41,
    0xca42,
    0xca43,
    0xca44,
    0xca45,
    0xca46,
    0xca47,
    0xca48,
    0xddf8,
    0xca49,
    0xca4a,
    0xca4b,
    0xca4c,
    0xc3ef,
    0xca4d,
    0xc2fb,
    0xca4e,
    0xca4f,
    0xca50,
    0xd5e1,
    0xca51,
    0xca52,
    0xceb5,
    0xca53,
    0xca54,
    0xca55,
    0xca56,
    0xddfd,
    0xca57,
    0xb2cc,
    0xca58,
    0xca59,
    0xca5a,
    0xca5b,
    0xca5c,
    0xca5d,
    0xca5e,
    0xca5f,
    0xca60,
    0xc4e8,
    0xcadf,
    0xca61,
    0xca62,
    0xca63,
    0xca64,
    0xca65,
    0xca66,
    0xca67,
    0xca68,
    0xca69,
    0xca6a,
    0xc7be,
    0xddfa,
    0xddfc,
    0xddfe,
    0xdea2,
    0xb0aa,
    0xb1ce,
    0xca6b,
    0xca6c,
    0xca6d,
    0xca6e,
    0xca6f,
    0xdeac,
    0xca70,
    0xca71,
    0xca72,
    0xca73,
    0xdea6,
    0xbdb6,
    0xc8ef,
    0xca74,
    0xca75,
    0xca76,
    0xca77,
    0xca78,
    0xca79,
    0xca7a,
    0xca7b,
    0xca7c,
    0xca7d,
    0xca7e,
    0xdea1,
    0xca80,
    0xca81,
    0xdea5,
    0xca82,
    0xca83,
    0xca84,
    0xca85,
    0xdea9,
    0xca86,
    0xca87,
    0xca88,
    0xca89,
    0xca8a,
    0xdea8,
    0xca8b,
    0xca8c,
    0xca8d,
    0xdea7,
    0xca8e,
    0xca8f,
    0xca90,
    0xca91,
    0xca92,
    0xca93,
    0xca94,
    0xca95,
    0xca96,
    0xdead,
    0xca97,
    0xd4cc,
    0xca98,
    0xca99,
    0xca9a,
    0xca9b,
    0xdeb3,
    0xdeaa,
    0xdeae,
    0xca9c,
    0xca9d,
    0xc0d9,
    0xca9e,
    0xca9f,
    0xcaa0,
    0xcb40,
    0xcb41,
    0xb1a1,
    0xdeb6,
    0xcb42,
    0xdeb1,
    0xcb43,
    0xcb44,
    0xcb45,
    0xcb46,
    0xcb47,
    0xcb48,
    0xcb49,
    0xdeb2,
    0xcb4a,
    0xcb4b,
    0xcb4c,
    0xcb4d,
    0xcb4e,
    0xcb4f,
    0xcb50,
    0xcb51,
    0xcb52,
    0xcb53,
    0xcb54,
    0xd1a6,
    0xdeb5,
    0xcb55,
    0xcb56,
    0xcb57,
    0xcb58,
    0xcb59,
    0xcb5a,
    0xcb5b,
    0xdeaf,
    0xcb5c,
    0xcb5d,
    0xcb5e,
    0xdeb0,
    0xcb5f,
    0xd0bd,
    0xcb60,
    0xcb61,
    0xcb62,
    0xdeb4,
    0xcaed,
    0xdeb9,
    0xcb63,
    0xcb64,
    0xcb65,
    0xcb66,
    0xcb67,
    0xcb68,
    0xdeb8,
    0xcb69,
    0xdeb7,
    0xcb6a,
    0xcb6b,
    0xcb6c,
    0xcb6d,
    0xcb6e,
    0xcb6f,
    0xcb70,
    0xdebb,
    0xcb71,
    0xcb72,
    0xcb73,
    0xcb74,
    0xcb75,
    0xcb76,
    0xcb77,
    0xbde5,
    0xcb78,
    0xcb79,
    0xcb7a,
    0xcb7b,
    0xcb7c,
    0xb2d8,
    0xc3ea,
    0xcb7d,
    0xcb7e,
    0xdeba,
    0xcb80,
    0xc5ba,
    0xcb81,
    0xcb82,
    0xcb83,
    0xcb84,
    0xcb85,
    0xcb86,
    0xdebc,
    0xcb87,
    0xcb88,
    0xcb89,
    0xcb8a,
    0xcb8b,
    0xcb8c,
    0xcb8d,
    0xccd9,
    0xcb8e,
    0xcb8f,
    0xcb90,
    0xcb91,
    0xb7aa,
    0xcb92,
    0xcb93,
    0xcb94,
    0xcb95,
    0xcb96,
    0xcb97,
    0xcb98,
    0xcb99,
    0xcb9a,
    0xcb9b,
    0xcb9c,
    0xcb9d,
    0xcb9e,
    0xcb9f,
    0xcba0,
    0xcc40,
    0xcc41,
    0xd4e5,
    0xcc42,
    0xcc43,
    0xcc44,
    0xdebd
};
UINT16 cp936_UNI_a0x86[] = {
    0xcc45,
    0xcc46,
    0xcc47,
    0xcc48,
    0xcc49,
    0xdebf,
    0xcc4a,
    0xcc4b,
    0xcc4c,
    0xcc4d,
    0xcc4e,
    0xcc4f,
    0xcc50,
    0xcc51,
    0xcc52,
    0xcc53,
    0xcc54,
    0xc4a2,
    0xcc55,
    0xcc56,
    0xcc57,
    0xcc58,
    0xdec1,
    0xcc59,
    0xcc5a,
    0xcc5b,
    0xcc5c,
    0xcc5d,
    0xcc5e,
    0xcc5f,
    0xcc60,
    0xcc61,
    0xcc62,
    0xcc63,
    0xcc64,
    0xcc65,
    0xcc66,
    0xcc67,
    0xcc68,
    0xdebe,
    0xcc69,
    0xdec0,
    0xcc6a,
    0xcc6b,
    0xcc6c,
    0xcc6d,
    0xcc6e,
    0xcc6f,
    0xcc70,
    0xcc71,
    0xcc72,
    0xcc73,
    0xcc74,
    0xcc75,
    0xcc76,
    0xcc77,
    0xd5ba,
    0xcc78,
    0xcc79,
    0xcc7a,
    0xdec2,
    0xcc7b,
    0xcc7c,
    0xcc7d,
    0xcc7e,
    0xcc80,
    0xcc81,
    0xcc82,
    0xcc83,
    0xcc84,
    0xcc85,
    0xcc86,
    0xcc87,
    0xcc88,
    0xcc89,
    0xcc8a,
    0xcc8b,
    0xf2ae,
    0xbba2,
    0xc2b2,
    0xc5b0,
    0xc2c7,
    0xcc8c,
    0xcc8d,
    0xf2af,
    0xcc8e,
    0xcc8f,
    0xcc90,
    0xcc91,
    0xcc92,
    0xd0e9,
    0xcc93,
    0xcc94,
    0xcc95,
    0xd3dd,
    0xcc96,
    0xcc97,
    0xcc98,
    0xebbd,
    0xcc99,
    0xcc9a,
    0xcc9b,
    0xcc9c,
    0xcc9d,
    0xcc9e,
    0xcc9f,
    0xcca0,
    0xb3e6,
    0xf2b0,
    0xcd40,
    0xf2b1,
    0xcd41,
    0xcd42,
    0xcaad,
    0xcd43,
    0xcd44,
    0xcd45,
    0xcd46,
    0xcd47,
    0xcd48,
    0xcd49,
    0xbae7,
    0xf2b3,
    0xf2b5,
    0xf2b4,
    0xcbe4,
    0xcfba,
    0xf2b2,
    0xcab4,
    0xd2cf,
    0xc2ec,
    0xcd4a,
    0xcd4b,
    0xcd4c,
    0xcd4d,
    0xcd4e,
    0xcd4f,
    0xcd50,
    0xcec3,
    0xf2b8,
    0xb0f6,
    0xf2b7,
    0xcd51,
    0xcd52,
    0xcd53,
    0xcd54,
    0xcd55,
    0xf2be,
    0xcd56,
    0xb2cf,
    0xcd57,
    0xcd58,
    0xcd59,
    0xcd5a,
    0xcd5b,
    0xcd5c,
    0xd1c1,
    0xf2ba,
    0xcd5d,
    0xcd5e,
    0xcd5f,
    0xcd60,
    0xcd61,
    0xf2bc,
    0xd4e9,
    0xcd62,
    0xcd63,
    0xf2bb,
    0xf2b6,
    0xf2bf,
    0xf2bd,
    0xcd64,
    0xf2b9,
    0xcd65,
    0xcd66,
    0xf2c7,
    0xf2c4,
    0xf2c6,
    0xcd67,
    0xcd68,
    0xf2ca,
    0xf2c2,
    0xf2c0,
    0xcd69,
    0xcd6a,
    0xcd6b,
    0xf2c5,
    0xcd6c,
    0xcd6d,
    0xcd6e,
    0xcd6f,
    0xcd70,
    0xd6fb,
    0xcd71,
    0xcd72,
    0xcd73,
    0xf2c1,
    0xcd74,
    0xc7f9,
    0xc9df,
    0xcd75,
    0xf2c8,
    0xb9c6,
    0xb5b0,
    0xcd76,
    0xcd77,
    0xf2c3,
    0xf2c9,
    0xf2d0,
    0xf2d6,
    0xcd78,
    0xcd79,
    0xbbd7,
    0xcd7a,
    0xcd7b,
    0xcd7c,
    0xf2d5,
    0xcddc,
    0xcd7d,
    0xd6eb,
    0xcd7e,
    0xcd80,
    0xf2d2,
    0xf2d4,
    0xcd81,
    0xcd82,
    0xcd83,
    0xcd84,
    0xb8f2,
    0xcd85,
    0xcd86,
    0xcd87,
    0xcd88,
    0xf2cb,
    0xcd89,
    0xcd8a,
    0xcd8b,
    0xf2ce,
    0xc2f9,
    0xcd8c,
    0xd5dd,
    0xf2cc,
    0xf2cd,
    0xf2cf,
    0xf2d3,
    0xcd8d,
    0xcd8e,
    0xcd8f,
    0xf2d9,
    0xd3bc,
    0xcd90,
    0xcd91,
    0xcd92,
    0xcd93,
    0xb6ea,
    0xcd94
};
UINT16 cp936_UNI_a0x87[] = {
    0xcaf1,
    0xcd95,
    0xb7e4,
    0xf2d7,
    0xcd96,
    0xcd97,
    0xcd98,
    0xf2d8,
    0xf2da,
    0xf2dd,
    0xf2db,
    0xcd99,
    0xcd9a,
    0xf2dc,
    0xcd9b,
    0xcd9c,
    0xcd9d,
    0xcd9e,
    0xd1d1,
    0xf2d1,
    0xcd9f,
    0xcdc9,
    0xcda0,
    0xcecf,
    0xd6a9,
    0xce40,
    0xf2e3,
    0xce41,
    0xc3db,
    0xce42,
    0xf2e0,
    0xce43,
    0xce44,
    0xc0af,
    0xf2ec,
    0xf2de,
    0xce45,
    0xf2e1,
    0xce46,
    0xce47,
    0xce48,
    0xf2e8,
    0xce49,
    0xce4a,
    0xce4b,
    0xce4c,
    0xf2e2,
    0xce4d,
    0xce4e,
    0xf2e7,
    0xce4f,
    0xce50,
    0xf2e6,
    0xce51,
    0xce52,
    0xf2e9,
    0xce53,
    0xce54,
    0xce55,
    0xf2df,
    0xce56,
    0xce57,
    0xf2e4,
    0xf2ea,
    0xce58,
    0xce59,
    0xce5a,
    0xce5b,
    0xce5c,
    0xce5d,
    0xce5e,
    0xd3ac,
    0xf2e5,
    0xb2f5,
    0xce5f,
    0xce60,
    0xf2f2,
    0xce61,
    0xd0ab,
    0xce62,
    0xce63,
    0xce64,
    0xce65,
    0xf2f5,
    0xce66,
    0xce67,
    0xce68,
    0xbbc8,
    0xce69,
    0xf2f9,
    0xce6a,
    0xce6b,
    0xce6c,
    0xce6d,
    0xce6e,
    0xce6f,
    0xf2f0,
    0xce70,
    0xce71,
    0xf2f6,
    0xf2f8,
    0xf2fa,
    0xce72,
    0xce73,
    0xce74,
    0xce75,
    0xce76,
    0xce77,
    0xce78,
    0xce79,
    0xf2f3,
    0xce7a,
    0xf2f1,
    0xce7b,
    0xce7c,
    0xce7d,
    0xbafb,
    0xce7e,
    0xb5fb,
    0xce80,
    0xce81,
    0xce82,
    0xce83,
    0xf2ef,
    0xf2f7,
    0xf2ed,
    0xf2ee,
    0xce84,
    0xce85,
    0xce86,
    0xf2eb,
    0xf3a6,
    0xce87,
    0xf3a3,
    0xce88,
    0xce89,
    0xf3a2,
    0xce8a,
    0xce8b,
    0xf2f4,
    0xce8c,
    0xc8da,
    0xce8d,
    0xce8e,
    0xce8f,
    0xce90,
    0xce91,
    0xf2fb,
    0xce92,
    0xce93,
    0xce94,
    0xf3a5,
    0xce95,
    0xce96,
    0xce97,
    0xce98,
    0xce99,
    0xce9a,
    0xce9b,
    0xc3f8,
    0xce9c,
    0xce9d,
    0xce9e,
    0xce9f,
    0xcea0,
    0xcf40,
    0xcf41,
    0xcf42,
    0xf2fd,
    0xcf43,
    0xcf44,
    0xf3a7,
    0xf3a9,
    0xf3a4,
    0xcf45,
    0xf2fc,
    0xcf46,
    0xcf47,
    0xcf48,
    0xf3ab,
    0xcf49,
    0xf3aa,
    0xcf4a,
    0xcf4b,
    0xcf4c,
    0xcf4d,
    0xc2dd,
    0xcf4e,
    0xcf4f,
    0xf3ae,
    0xcf50,
    0xcf51,
    0xf3b0,
    0xcf52,
    0xcf53,
    0xcf54,
    0xcf55,
    0xcf56,
    0xf3a1,
    0xcf57,
    0xcf58,
    0xcf59,
    0xf3b1,
    0xf3ac,
    0xcf5a,
    0xcf5b,
    0xcf5c,
    0xcf5d,
    0xcf5e,
    0xf3af,
    0xf2fe,
    0xf3ad,
    0xcf5f,
    0xcf60,
    0xcf61,
    0xcf62,
    0xcf63,
    0xcf64,
    0xcf65,
    0xf3b2,
    0xcf66,
    0xcf67,
    0xcf68,
    0xcf69,
    0xf3b4,
    0xcf6a,
    0xcf6b,
    0xcf6c,
    0xcf6d,
    0xf3a8,
    0xcf6e,
    0xcf6f,
    0xcf70,
    0xcf71,
    0xf3b3,
    0xcf72,
    0xcf73,
    0xcf74,
    0xf3b5,
    0xcf75,
    0xcf76,
    0xcf77,
    0xcf78,
    0xcf79,
    0xcf7a,
    0xcf7b,
    0xcf7c,
    0xcf7d,
    0xcf7e,
    0xd0b7,
    0xcf80,
    0xcf81,
    0xcf82,
    0xcf83,
    0xf3b8,
    0xcf84
};
UINT16 cp936_UNI_a0x88[] = {
    0xcf85,
    0xcf86,
    0xcf87,
    0xd9f9,
    0xcf88,
    0xcf89,
    0xcf8a,
    0xcf8b,
    0xcf8c,
    0xcf8d,
    0xf3b9,
    0xcf8e,
    0xcf8f,
    0xcf90,
    0xcf91,
    0xcf92,
    0xcf93,
    0xcf94,
    0xcf95,
    0xf3b7,
    0xcf96,
    0xc8e4,
    0xf3b6,
    0xcf97,
    0xcf98,
    0xcf99,
    0xcf9a,
    0xf3ba,
    0xcf9b,
    0xcf9c,
    0xcf9d,
    0xcf9e,
    0xcf9f,
    0xf3bb,
    0xb4c0,
    0xcfa0,
    0xd040,
    0xd041,
    0xd042,
    0xd043,
    0xd044,
    0xd045,
    0xd046,
    0xd047,
    0xd048,
    0xd049,
    0xd04a,
    0xd04b,
    0xd04c,
    0xd04d,
    0xeec3,
    0xd04e,
    0xd04f,
    0xd050,
    0xd051,
    0xd052,
    0xd053,
    0xf3bc,
    0xd054,
    0xd055,
    0xf3bd,
    0xd056,
    0xd057,
    0xd058,
    0xd1aa,
    0xd059,
    0xd05a,
    0xd05b,
    0xf4ac,
    0xd0c6,
    0xd05c,
    0xd05d,
    0xd05e,
    0xd05f,
    0xd060,
    0xd061,
    0xd0d0,
    0xd1dc,
    0xd062,
    0xd063,
    0xd064,
    0xd065,
    0xd066,
    0xd067,
    0xcfce,
    0xd068,
    0xd069,
    0xbdd6,
    0xd06a,
    0xd1c3,
    0xd06b,
    0xd06c,
    0xd06d,
    0xd06e,
    0xd06f,
    0xd070,
    0xd071,
    0xbae2,
    0xe1e9,
    0xd2c2,
    0xf1c2,
    0xb2b9,
    0xd072,
    0xd073,
    0xb1ed,
    0xf1c3,
    0xd074,
    0xc9c0,
    0xb3c4,
    0xd075,
    0xd9f2,
    0xd076,
    0xcba5,
    0xd077,
    0xf1c4,
    0xd078,
    0xd079,
    0xd07a,
    0xd07b,
    0xd6d4,
    0xd07c,
    0xd07d,
    0xd07e,
    0xd080,
    0xd081,
    0xf1c5,
    0xf4c0,
    0xf1c6,
    0xd082,
    0xd4ac,
    0xf1c7,
    0xd083,
    0xb0c0,
    0xf4c1,
    0xd084,
    0xd085,
    0xf4c2,
    0xd086,
    0xd087,
    0xb4fc,
    0xd088,
    0xc5db,
    0xd089,
    0xd08a,
    0xd08b,
    0xd08c,
    0xccbb,
    0xd08d,
    0xd08e,
    0xd08f,
    0xd0e4,
    0xd090,
    0xd091,
    0xd092,
    0xd093,
    0xd094,
    0xcde0,
    0xd095,
    0xd096,
    0xd097,
    0xd098,
    0xd099,
    0xf1c8,
    0xd09a,
    0xd9f3,
    0xd09b,
    0xd09c,
    0xd09d,
    0xd09e,
    0xd09f,
    0xd0a0,
    0xb1bb,
    0xd140,
    0xcfae,
    0xd141,
    0xd142,
    0xd143,
    0xb8a4,
    0xd144,
    0xd145,
    0xd146,
    0xd147,
    0xd148,
    0xf1ca,
    0xd149,
    0xd14a,
    0xd14b,
    0xd14c,
    0xf1cb,
    0xd14d,
    0xd14e,
    0xd14f,
    0xd150,
    0xb2c3,
    0xc1d1,
    0xd151,
    0xd152,
    0xd7b0,
    0xf1c9,
    0xd153,
    0xd154,
    0xf1cc,
    0xd155,
    0xd156,
    0xd157,
    0xd158,
    0xf1ce,
    0xd159,
    0xd15a,
    0xd15b,
    0xd9f6,
    0xd15c,
    0xd2e1,
    0xd4a3,
    0xd15d,
    0xd15e,
    0xf4c3,
    0xc8b9,
    0xd15f,
    0xd160,
    0xd161,
    0xd162,
    0xd163,
    0xf4c4,
    0xd164,
    0xd165,
    0xf1cd,
    0xf1cf,
    0xbfe3,
    0xf1d0,
    0xd166,
    0xd167,
    0xf1d4,
    0xd168,
    0xd169,
    0xd16a,
    0xd16b,
    0xd16c,
    0xd16d,
    0xd16e,
    0xf1d6,
    0xf1d1,
    0xd16f,
    0xc9d1,
    0xc5e1,
    0xd170,
    0xd171,
    0xd172,
    0xc2e3,
    0xb9fc,
    0xd173,
    0xd174,
    0xf1d3,
    0xd175,
    0xf1d5,
    0xd176
};
UINT16 cp936_UNI_a0x89[] = {
    0xd177,
    0xd178,
    0xb9d3,
    0xd179,
    0xd17a,
    0xd17b,
    0xd17c,
    0xd17d,
    0xd17e,
    0xd180,
    0xf1db,
    0xd181,
    0xd182,
    0xd183,
    0xd184,
    0xd185,
    0xbad6,
    0xd186,
    0xb0fd,
    0xf1d9,
    0xd187,
    0xd188,
    0xd189,
    0xd18a,
    0xd18b,
    0xf1d8,
    0xf1d2,
    0xf1da,
    0xd18c,
    0xd18d,
    0xd18e,
    0xd18f,
    0xd190,
    0xf1d7,
    0xd191,
    0xd192,
    0xd193,
    0xc8ec,
    0xd194,
    0xd195,
    0xd196,
    0xd197,
    0xcdca,
    0xf1dd,
    0xd198,
    0xd199,
    0xd19a,
    0xd19b,
    0xe5bd,
    0xd19c,
    0xd19d,
    0xd19e,
    0xf1dc,
    0xd19f,
    0xf1de,
    0xd1a0,
    0xd240,
    0xd241,
    0xd242,
    0xd243,
    0xd244,
    0xd245,
    0xd246,
    0xd247,
    0xd248,
    0xf1df,
    0xd249,
    0xd24a,
    0xcfe5,
    0xd24b,
    0xd24c,
    0xd24d,
    0xd24e,
    0xd24f,
    0xd250,
    0xd251,
    0xd252,
    0xd253,
    0xd254,
    0xd255,
    0xd256,
    0xd257,
    0xd258,
    0xd259,
    0xd25a,
    0xd25b,
    0xd25c,
    0xd25d,
    0xd25e,
    0xd25f,
    0xd260,
    0xd261,
    0xd262,
    0xd263,
    0xf4c5,
    0xbdf3,
    0xd264,
    0xd265,
    0xd266,
    0xd267,
    0xd268,
    0xd269,
    0xf1e0,
    0xd26a,
    0xd26b,
    0xd26c,
    0xd26d,
    0xd26e,
    0xd26f,
    0xd270,
    0xd271,
    0xd272,
    0xd273,
    0xd274,
    0xd275,
    0xd276,
    0xd277,
    0xd278,
    0xd279,
    0xd27a,
    0xd27b,
    0xd27c,
    0xd27d,
    0xf1e1,
    0xd27e,
    0xd280,
    0xd281,
    0xcef7,
    0xd282,
    0xd2aa,
    0xd283,
    0xf1fb,
    0xd284,
    0xd285,
    0xb8b2,
    0xd286,
    0xd287,
    0xd288,
    0xd289,
    0xd28a,
    0xd28b,
    0xd28c,
    0xd28d,
    0xd28e,
    0xd28f,
    0xd290,
    0xd291,
    0xd292,
    0xd293,
    0xd294,
    0xd295,
    0xd296,
    0xd297,
    0xd298,
    0xd299,
    0xd29a,
    0xd29b,
    0xd29c,
    0xd29d,
    0xd29e,
    0xd29f,
    0xd2a0,
    0xd340,
    0xd341,
    0xd342,
    0xd343,
    0xd344,
    0xd345,
    0xd346,
    0xd347,
    0xd348,
    0xd349,
    0xd34a,
    0xd34b,
    0xd34c,
    0xd34d,
    0xd34e,
    0xd34f,
    0xd350,
    0xd351,
    0xd352,
    0xd353,
    0xd354,
    0xd355,
    0xd356,
    0xd357,
    0xd358,
    0xd359,
    0xd35a,
    0xd35b,
    0xd35c,
    0xd35d,
    0xd35e,
    0xbcfb,
    0xb9db,
    0xd35f,
    0xb9e6,
    0xc3d9,
    0xcad3,
    0xeae8,
    0xc0c0,
    0xbef5,
    0xeae9,
    0xeaea,
    0xeaeb,
    0xd360,
    0xeaec,
    0xeaed,
    0xeaee,
    0xeaef,
    0xbdc7,
    0xd361,
    0xd362,
    0xd363,
    0xf5fb,
    0xd364,
    0xd365,
    0xd366,
    0xf5fd,
    0xd367,
    0xf5fe,
    0xd368,
    0xf5fc,
    0xd369,
    0xd36a,
    0xd36b,
    0xd36c,
    0xbde2,
    0xd36d,
    0xf6a1,
    0xb4a5,
    0xd36e,
    0xd36f,
    0xd370,
    0xd371,
    0xf6a2,
    0xd372,
    0xd373,
    0xd374,
    0xf6a3,
    0xd375,
    0xd376,
    0xd377,
    0xecb2,
    0xd378,
    0xd379,
    0xd37a,
    0xd37b,
    0xd37c,
    0xd37d,
    0xd37e,
    0xd380,
    0xd381,
    0xd382,
    0xd383,
    0xd384
};
UINT16 cp936_UNI_a0x8a[] = {
    0xd1d4,
    0xd385,
    0xd386,
    0xd387,
    0xd388,
    0xd389,
    0xd38a,
    0xd9ea,
    0xd38b,
    0xd38c,
    0xd38d,
    0xd38e,
    0xd38f,
    0xd390,
    0xd391,
    0xd392,
    0xd393,
    0xd394,
    0xd395,
    0xd396,
    0xd397,
    0xd398,
    0xd399,
    0xd39a,
    0xd39b,
    0xd39c,
    0xd39d,
    0xd39e,
    0xd39f,
    0xd3a0,
    0xd440,
    0xd441,
    0xd442,
    0xd443,
    0xd444,
    0xd445,
    0xd446,
    0xd447,
    0xd448,
    0xd449,
    0xd44a,
    0xd44b,
    0xd44c,
    0xd44d,
    0xd44e,
    0xd44f,
    0xd450,
    0xd451,
    0xd452,
    0xd453,
    0xd454,
    0xd455,
    0xd456,
    0xd457,
    0xd458,
    0xd459,
    0xd45a,
    0xd45b,
    0xd45c,
    0xd45d,
    0xd45e,
    0xd45f,
    0xf6a4,
    0xd460,
    0xd461,
    0xd462,
    0xd463,
    0xd464,
    0xd465,
    0xd466,
    0xd467,
    0xd468,
    0xeeba,
    0xd469,
    0xd46a,
    0xd46b,
    0xd46c,
    0xd46d,
    0xd46e,
    0xd46f,
    0xd470,
    0xd471,
    0xd472,
    0xd473,
    0xd474,
    0xd475,
    0xd476,
    0xd477,
    0xd478,
    0xd479,
    0xd47a,
    0xd47b,
    0xd47c,
    0xd47d,
    0xd47e,
    0xd480,
    0xd481,
    0xd482,
    0xd483,
    0xd484,
    0xd485,
    0xd486,
    0xd487,
    0xd488,
    0xd489,
    0xd48a,
    0xd48b,
    0xd48c,
    0xd48d,
    0xd48e,
    0xd48f,
    0xd490,
    0xd491,
    0xd492,
    0xd493,
    0xd494,
    0xd495,
    0xd496,
    0xd497,
    0xd498,
    0xd499,
    0xd5b2,
    0xd49a,
    0xd49b,
    0xd49c,
    0xd49d,
    0xd49e,
    0xd49f,
    0xd4a0,
    0xd540,
    0xd541,
    0xd542,
    0xd543,
    0xd544,
    0xd545,
    0xd546,
    0xd547,
    0xd3fe,
    0xccdc,
    0xd548,
    0xd549,
    0xd54a,
    0xd54b,
    0xd54c,
    0xd54d,
    0xd54e,
    0xd54f,
    0xcac4,
    0xd550,
    0xd551,
    0xd552,
    0xd553,
    0xd554,
    0xd555,
    0xd556,
    0xd557,
    0xd558,
    0xd559,
    0xd55a,
    0xd55b,
    0xd55c,
    0xd55d,
    0xd55e,
    0xd55f,
    0xd560,
    0xd561,
    0xd562,
    0xd563,
    0xd564,
    0xd565,
    0xd566,
    0xd567,
    0xd568,
    0xd569,
    0xd56a,
    0xd56b,
    0xd56c,
    0xd56d,
    0xd56e,
    0xd56f,
    0xd570,
    0xd571,
    0xd572,
    0xd573,
    0xd574,
    0xd575,
    0xd576,
    0xd577,
    0xd578,
    0xd579,
    0xd57a,
    0xd57b,
    0xd57c,
    0xd57d,
    0xd57e,
    0xd580,
    0xd581,
    0xd582,
    0xd583,
    0xd584,
    0xd585,
    0xd586,
    0xd587,
    0xd588,
    0xd589,
    0xd58a,
    0xd58b,
    0xd58c,
    0xd58d,
    0xd58e,
    0xd58f,
    0xd590,
    0xd591,
    0xd592,
    0xd593,
    0xd594,
    0xd595,
    0xd596,
    0xd597,
    0xd598,
    0xd599,
    0xd59a,
    0xd59b,
    0xd59c,
    0xd59d,
    0xd59e,
    0xd59f,
    0xd5a0,
    0xd640,
    0xd641,
    0xd642,
    0xd643,
    0xd644,
    0xd645,
    0xd646,
    0xd647,
    0xd648,
    0xd649,
    0xd64a,
    0xd64b,
    0xd64c,
    0xd64d,
    0xd64e,
    0xd64f,
    0xd650,
    0xd651,
    0xd652,
    0xd653,
    0xd654,
    0xd655,
    0xd656,
    0xd657,
    0xd658,
    0xd659,
    0xd65a,
    0xd65b
};
UINT16 cp936_UNI_a0x8b[] = {
    0xd65c,
    0xd65d,
    0xd65e,
    0xd65f,
    0xd660,
    0xd661,
    0xd662,
    0xe5c0,
    0xd663,
    0xd664,
    0xd665,
    0xd666,
    0xd667,
    0xd668,
    0xd669,
    0xd66a,
    0xd66b,
    0xd66c,
    0xd66d,
    0xd66e,
    0xd66f,
    0xd670,
    0xd671,
    0xd672,
    0xd673,
    0xd674,
    0xd675,
    0xd676,
    0xd677,
    0xd678,
    0xd679,
    0xd67a,
    0xd67b,
    0xd67c,
    0xd67d,
    0xd67e,
    0xd680,
    0xd681,
    0xf6a5,
    0xd682,
    0xd683,
    0xd684,
    0xd685,
    0xd686,
    0xd687,
    0xd688,
    0xd689,
    0xd68a,
    0xd68b,
    0xd68c,
    0xd68d,
    0xd68e,
    0xd68f,
    0xd690,
    0xd691,
    0xd692,
    0xd693,
    0xd694,
    0xd695,
    0xd696,
    0xd697,
    0xd698,
    0xd699,
    0xd69a,
    0xd69b,
    0xd69c,
    0xd69d,
    0xd69e,
    0xd69f,
    0xd6a0,
    0xd740,
    0xd741,
    0xd742,
    0xd743,
    0xd744,
    0xd745,
    0xd746,
    0xd747,
    0xd748,
    0xd749,
    0xd74a,
    0xd74b,
    0xd74c,
    0xd74d,
    0xd74e,
    0xd74f,
    0xd750,
    0xd751,
    0xd752,
    0xd753,
    0xd754,
    0xd755,
    0xd756,
    0xd757,
    0xd758,
    0xd759,
    0xd75a,
    0xd75b,
    0xd75c,
    0xd75d,
    0xd75e,
    0xd75f,
    0xbeaf,
    0xd760,
    0xd761,
    0xd762,
    0xd763,
    0xd764,
    0xc6a9,
    0xd765,
    0xd766,
    0xd767,
    0xd768,
    0xd769,
    0xd76a,
    0xd76b,
    0xd76c,
    0xd76d,
    0xd76e,
    0xd76f,
    0xd770,
    0xd771,
    0xd772,
    0xd773,
    0xd774,
    0xd775,
    0xd776,
    0xd777,
    0xd778,
    0xd779,
    0xd77a,
    0xd77b,
    0xd77c,
    0xd77d,
    0xd77e,
    0xd780,
    0xd781,
    0xd782,
    0xd783,
    0xd784,
    0xd785,
    0xd786,
    0xd787,
    0xd788,
    0xd789,
    0xd78a,
    0xd78b,
    0xd78c,
    0xd78d,
    0xd78e,
    0xd78f,
    0xd790,
    0xd791,
    0xd792,
    0xd793,
    0xd794,
    0xd795,
    0xd796,
    0xd797,
    0xd798,
    0xdaa5,
    0xbcc6,
    0xb6a9,
    0xb8bc,
    0xc8cf,
    0xbca5,
    0xdaa6,
    0xdaa7,
    0xccd6,
    0xc8c3,
    0xdaa8,
    0xc6fd,
    0xd799,
    0xd1b5,
    0xd2e9,
    0xd1b6,
    0xbcc7,
    0xd79a,
    0xbdb2,
    0xbbe4,
    0xdaa9,
    0xdaaa,
    0xd1c8,
    0xdaab,
    0xd0ed,
    0xb6ef,
    0xc2db,
    0xd79b,
    0xcbcf,
    0xb7ed,
    0xc9e8,
    0xb7c3,
    0xbef7,
    0xd6a4,
    0xdaac,
    0xdaad,
    0xc6c0,
    0xd7e7,
    0xcab6,
    0xd79c,
    0xd5a9,
    0xcbdf,
    0xd5ef,
    0xdaae,
    0xd6df,
    0xb4ca,
    0xdab0,
    0xdaaf,
    0xd79d,
    0xd2eb,
    0xdab1,
    0xdab2,
    0xdab3,
    0xcad4,
    0xdab4,
    0xcaab,
    0xdab5,
    0xdab6,
    0xb3cf,
    0xd6ef,
    0xdab7,
    0xbbb0,
    0xb5ae,
    0xdab8,
    0xdab9,
    0xb9ee,
    0xd1af,
    0xd2e8,
    0xdaba,
    0xb8c3,
    0xcfea,
    0xb2ef,
    0xdabb,
    0xdabc,
    0xd79e,
    0xbdeb,
    0xcedc,
    0xd3ef,
    0xdabd,
    0xcef3,
    0xdabe,
    0xd3d5,
    0xbbe5,
    0xdabf,
    0xcbb5,
    0xcbd0,
    0xdac0,
    0xc7eb,
    0xd6ee,
    0xdac1,
    0xc5b5,
    0xb6c1,
    0xdac2,
    0xb7cc,
    0xbfce,
    0xdac3
};
UINT16 cp936_UNI_a0x8c[] = {
    0xdac4,
    0xcbad,
    0xdac5,
    0xb5f7,
    0xdac6,
    0xc1c2,
    0xd7bb,
    0xdac7,
    0xccb8,
    0xd79f,
    0xd2ea,
    0xc4b1,
    0xdac8,
    0xb5fd,
    0xbbd1,
    0xdac9,
    0xd0b3,
    0xdaca,
    0xdacb,
    0xcebd,
    0xdacc,
    0xdacd,
    0xdace,
    0xb2f7,
    0xdad1,
    0xdacf,
    0xd1e8,
    0xdad0,
    0xc3d5,
    0xdad2,
    0xd7a0,
    0xdad3,
    0xdad4,
    0xdad5,
    0xd0bb,
    0xd2a5,
    0xb0f9,
    0xdad6,
    0xc7ab,
    0xdad7,
    0xbdf7,
    0xc3a1,
    0xdad8,
    0xdad9,
    0xc3fd,
    0xccb7,
    0xdada,
    0xdadb,
    0xc0be,
    0xc6d7,
    0xdadc,
    0xdadd,
    0xc7b4,
    0xdade,
    0xdadf,
    0xb9c8,
    0xd840,
    0xd841,
    0xd842,
    0xd843,
    0xd844,
    0xd845,
    0xd846,
    0xd847,
    0xd848,
    0xbbed,
    0xd849,
    0xd84a,
    0xd84b,
    0xd84c,
    0xb6b9,
    0xf4f8,
    0xd84d,
    0xf4f9,
    0xd84e,
    0xd84f,
    0xcde3,
    0xd850,
    0xd851,
    0xd852,
    0xd853,
    0xd854,
    0xd855,
    0xd856,
    0xd857,
    0xf5b9,
    0xd858,
    0xd859,
    0xd85a,
    0xd85b,
    0xebe0,
    0xd85c,
    0xd85d,
    0xd85e,
    0xd85f,
    0xd860,
    0xd861,
    0xcff3,
    0xbbbf,
    0xd862,
    0xd863,
    0xd864,
    0xd865,
    0xd866,
    0xd867,
    0xd868,
    0xbac0,
    0xd4a5,
    0xd869,
    0xd86a,
    0xd86b,
    0xd86c,
    0xd86d,
    0xd86e,
    0xd86f,
    0xe1d9,
    0xd870,
    0xd871,
    0xd872,
    0xd873,
    0xf5f4,
    0xb1aa,
    0xb2f2,
    0xd874,
    0xd875,
    0xd876,
    0xd877,
    0xd878,
    0xd879,
    0xd87a,
    0xf5f5,
    0xd87b,
    0xd87c,
    0xf5f7,
    0xd87d,
    0xd87e,
    0xd880,
    0xbad1,
    0xf5f6,
    0xd881,
    0xc3b2,
    0xd882,
    0xd883,
    0xd884,
    0xd885,
    0xd886,
    0xd887,
    0xd888,
    0xf5f9,
    0xd889,
    0xd88a,
    0xd88b,
    0xf5f8,
    0xd88c,
    0xd88d,
    0xd88e,
    0xd88f,
    0xd890,
    0xd891,
    0xd892,
    0xd893,
    0xd894,
    0xd895,
    0xd896,
    0xd897,
    0xd898,
    0xd899,
    0xd89a,
    0xd89b,
    0xd89c,
    0xd89d,
    0xd89e,
    0xd89f,
    0xd8a0,
    0xd940,
    0xd941,
    0xd942,
    0xd943,
    0xd944,
    0xd945,
    0xd946,
    0xd947,
    0xd948,
    0xd949,
    0xd94a,
    0xd94b,
    0xd94c,
    0xd94d,
    0xd94e,
    0xd94f,
    0xd950,
    0xd951,
    0xd952,
    0xd953,
    0xd954,
    0xd955,
    0xd956,
    0xd957,
    0xd958,
    0xd959,
    0xd95a,
    0xd95b,
    0xd95c,
    0xd95d,
    0xd95e,
    0xd95f,
    0xd960,
    0xd961,
    0xd962,
    0xd963,
    0xd964,
    0xd965,
    0xd966,
    0xd967,
    0xd968,
    0xd969,
    0xd96a,
    0xd96b,
    0xd96c,
    0xd96d,
    0xd96e,
    0xd96f,
    0xd970,
    0xd971,
    0xd972,
    0xd973,
    0xd974,
    0xd975,
    0xd976,
    0xd977,
    0xd978,
    0xd979,
    0xd97a,
    0xd97b,
    0xd97c,
    0xd97d,
    0xd97e,
    0xd980,
    0xd981,
    0xd982,
    0xd983,
    0xd984,
    0xd985,
    0xd986,
    0xd987,
    0xd988,
    0xd989,
    0xd98a,
    0xd98b,
    0xd98c,
    0xd98d,
    0xd98e,
    0xd98f,
    0xd990,
    0xd991,
    0xd992
};
UINT16 cp936_UNI_a0x8d[] = {
    0xd993,
    0xd994,
    0xd995,
    0xd996,
    0xd997,
    0xd998,
    0xd999,
    0xd99a,
    0xd99b,
    0xd99c,
    0xd99d,
    0xd99e,
    0xd99f,
    0xd9a0,
    0xda40,
    0xda41,
    0xda42,
    0xda43,
    0xda44,
    0xda45,
    0xda46,
    0xda47,
    0xda48,
    0xda49,
    0xda4a,
    0xda4b,
    0xda4c,
    0xda4d,
    0xda4e,
    0xb1b4,
    0xd5ea,
    0xb8ba,
    0xda4f,
    0xb9b1,
    0xb2c6,
    0xd4f0,
    0xcfcd,
    0xb0dc,
    0xd5cb,
    0xbbf5,
    0xd6ca,
    0xb7b7,
    0xccb0,
    0xc6b6,
    0xb1e1,
    0xb9ba,
    0xd6fc,
    0xb9e1,
    0xb7a1,
    0xbcfa,
    0xeada,
    0xeadb,
    0xccf9,
    0xb9f3,
    0xeadc,
    0xb4fb,
    0xc3b3,
    0xb7d1,
    0xbad8,
    0xeadd,
    0xd4f4,
    0xeade,
    0xbcd6,
    0xbbdf,
    0xeadf,
    0xc1de,
    0xc2b8,
    0xd4df,
    0xd7ca,
    0xeae0,
    0xeae1,
    0xeae4,
    0xeae2,
    0xeae3,
    0xc9de,
    0xb8b3,
    0xb6c4,
    0xeae5,
    0xcaea,
    0xc9cd,
    0xb4cd,
    0xda50,
    0xda51,
    0xe2d9,
    0xc5e2,
    0xeae6,
    0xc0b5,
    0xda52,
    0xd7b8,
    0xeae7,
    0xd7ac,
    0xc8fc,
    0xd8d3,
    0xd8cd,
    0xd4de,
    0xda53,
    0xd4f9,
    0xc9c4,
    0xd3ae,
    0xb8d3,
    0xb3e0,
    0xda54,
    0xc9e2,
    0xf4f6,
    0xda55,
    0xda56,
    0xda57,
    0xbad5,
    0xda58,
    0xf4f7,
    0xda59,
    0xda5a,
    0xd7df,
    0xda5b,
    0xda5c,
    0xf4f1,
    0xb8b0,
    0xd5d4,
    0xb8cf,
    0xc6f0,
    0xda5d,
    0xda5e,
    0xda5f,
    0xda60,
    0xda61,
    0xda62,
    0xda63,
    0xda64,
    0xda65,
    0xb3c3,
    0xda66,
    0xda67,
    0xf4f2,
    0xb3ac,
    0xda68,
    0xda69,
    0xda6a,
    0xda6b,
    0xd4bd,
    0xc7f7,
    0xda6c,
    0xda6d,
    0xda6e,
    0xda6f,
    0xda70,
    0xf4f4,
    0xda71,
    0xda72,
    0xf4f3,
    0xda73,
    0xda74,
    0xda75,
    0xda76,
    0xda77,
    0xda78,
    0xda79,
    0xda7a,
    0xda7b,
    0xda7c,
    0xcccb,
    0xda7d,
    0xda7e,
    0xda80,
    0xc8a4,
    0xda81,
    0xda82,
    0xda83,
    0xda84,
    0xda85,
    0xda86,
    0xda87,
    0xda88,
    0xda89,
    0xda8a,
    0xda8b,
    0xda8c,
    0xda8d,
    0xf4f5,
    0xda8e,
    0xd7e3,
    0xc5bf,
    0xf5c0,
    0xda8f,
    0xda90,
    0xf5bb,
    0xda91,
    0xf5c3,
    0xda92,
    0xf5c2,
    0xda93,
    0xd6ba,
    0xf5c1,
    0xda94,
    0xda95,
    0xda96,
    0xd4be,
    0xf5c4,
    0xda97,
    0xf5cc,
    0xda98,
    0xda99,
    0xda9a,
    0xda9b,
    0xb0cf,
    0xb5f8,
    0xda9c,
    0xf5c9,
    0xf5ca,
    0xda9d,
    0xc5dc,
    0xda9e,
    0xda9f,
    0xdaa0,
    0xdb40,
    0xf5c5,
    0xf5c6,
    0xdb41,
    0xdb42,
    0xf5c7,
    0xf5cb,
    0xdb43,
    0xbee0,
    0xf5c8,
    0xb8fa,
    0xdb44,
    0xdb45,
    0xdb46,
    0xf5d0,
    0xf5d3,
    0xdb47,
    0xdb48,
    0xdb49,
    0xbfe7,
    0xdb4a,
    0xb9f2,
    0xf5bc,
    0xf5cd,
    0xdb4b,
    0xdb4c,
    0xc2b7,
    0xdb4d,
    0xdb4e,
    0xdb4f,
    0xccf8,
    0xdb50,
    0xbcf9,
    0xdb51,
    0xf5ce,
    0xf5cf,
    0xf5d1,
    0xb6e5,
    0xf5d2,
    0xdb52,
    0xf5d5,
    0xdb53,
    0xdb54
};
UINT16 cp936_UNI_a0x8e[] = {
    0xdb55,
    0xdb56,
    0xdb57,
    0xdb58,
    0xdb59,
    0xf5bd,
    0xdb5a,
    0xdb5b,
    0xdb5c,
    0xf5d4,
    0xd3bb,
    0xdb5d,
    0xb3ec,
    0xdb5e,
    0xdb5f,
    0xcca4,
    0xdb60,
    0xdb61,
    0xdb62,
    0xdb63,
    0xf5d6,
    0xdb64,
    0xdb65,
    0xdb66,
    0xdb67,
    0xdb68,
    0xdb69,
    0xdb6a,
    0xdb6b,
    0xf5d7,
    0xbee1,
    0xf5d8,
    0xdb6c,
    0xdb6d,
    0xccdf,
    0xf5db,
    0xdb6e,
    0xdb6f,
    0xdb70,
    0xdb71,
    0xdb72,
    0xb2c8,
    0xd7d9,
    0xdb73,
    0xf5d9,
    0xdb74,
    0xf5da,
    0xf5dc,
    0xdb75,
    0xf5e2,
    0xdb76,
    0xdb77,
    0xdb78,
    0xf5e0,
    0xdb79,
    0xdb7a,
    0xdb7b,
    0xf5df,
    0xf5dd,
    0xdb7c,
    0xdb7d,
    0xf5e1,
    0xdb7e,
    0xdb80,
    0xf5de,
    0xf5e4,
    0xf5e5,
    0xdb81,
    0xcce3,
    0xdb82,
    0xdb83,
    0xe5bf,
    0xb5b8,
    0xf5e3,
    0xf5e8,
    0xcca3,
    0xdb84,
    0xdb85,
    0xdb86,
    0xdb87,
    0xdb88,
    0xf5e6,
    0xf5e7,
    0xdb89,
    0xdb8a,
    0xdb8b,
    0xdb8c,
    0xdb8d,
    0xdb8e,
    0xf5be,
    0xdb8f,
    0xdb90,
    0xdb91,
    0xdb92,
    0xdb93,
    0xdb94,
    0xdb95,
    0xdb96,
    0xdb97,
    0xdb98,
    0xdb99,
    0xdb9a,
    0xb1c4,
    0xdb9b,
    0xdb9c,
    0xf5bf,
    0xdb9d,
    0xdb9e,
    0xb5c5,
    0xb2e4,
    0xdb9f,
    0xf5ec,
    0xf5e9,
    0xdba0,
    0xb6d7,
    0xdc40,
    0xf5ed,
    0xdc41,
    0xf5ea,
    0xdc42,
    0xdc43,
    0xdc44,
    0xdc45,
    0xdc46,
    0xf5eb,
    0xdc47,
    0xdc48,
    0xb4da,
    0xdc49,
    0xd4ea,
    0xdc4a,
    0xdc4b,
    0xdc4c,
    0xf5ee,
    0xdc4d,
    0xb3f9,
    0xdc4e,
    0xdc4f,
    0xdc50,
    0xdc51,
    0xdc52,
    0xdc53,
    0xdc54,
    0xf5ef,
    0xf5f1,
    0xdc55,
    0xdc56,
    0xdc57,
    0xf5f0,
    0xdc58,
    0xdc59,
    0xdc5a,
    0xdc5b,
    0xdc5c,
    0xdc5d,
    0xdc5e,
    0xf5f2,
    0xdc5f,
    0xf5f3,
    0xdc60,
    0xdc61,
    0xdc62,
    0xdc63,
    0xdc64,
    0xdc65,
    0xdc66,
    0xdc67,
    0xdc68,
    0xdc69,
    0xdc6a,
    0xdc6b,
    0xc9ed,
    0xb9aa,
    0xdc6c,
    0xdc6d,
    0xc7fb,
    0xdc6e,
    0xdc6f,
    0xb6e3,
    0xdc70,
    0xdc71,
    0xdc72,
    0xdc73,
    0xdc74,
    0xdc75,
    0xdc76,
    0xccc9,
    0xdc77,
    0xdc78,
    0xdc79,
    0xdc7a,
    0xdc7b,
    0xdc7c,
    0xdc7d,
    0xdc7e,
    0xdc80,
    0xdc81,
    0xdc82,
    0xdc83,
    0xdc84,
    0xdc85,
    0xdc86,
    0xdc87,
    0xdc88,
    0xdc89,
    0xdc8a,
    0xeaa6,
    0xdc8b,
    0xdc8c,
    0xdc8d,
    0xdc8e,
    0xdc8f,
    0xdc90,
    0xdc91,
    0xdc92,
    0xdc93,
    0xdc94,
    0xdc95,
    0xdc96,
    0xdc97,
    0xdc98,
    0xdc99,
    0xdc9a,
    0xdc9b,
    0xdc9c,
    0xdc9d,
    0xdc9e,
    0xdc9f,
    0xdca0,
    0xdd40,
    0xdd41,
    0xdd42,
    0xdd43,
    0xdd44,
    0xdd45,
    0xdd46,
    0xdd47,
    0xdd48,
    0xdd49,
    0xdd4a,
    0xdd4b,
    0xdd4c,
    0xdd4d,
    0xdd4e,
    0xdd4f,
    0xdd50,
    0xdd51,
    0xdd52,
    0xdd53,
    0xdd54,
    0xdd55,
    0xdd56,
    0xdd57,
    0xdd58,
    0xdd59,
    0xdd5a
};
UINT16 cp936_UNI_a0x8f[] = {
    0xdd5b,
    0xdd5c,
    0xdd5d,
    0xdd5e,
    0xdd5f,
    0xdd60,
    0xdd61,
    0xdd62,
    0xdd63,
    0xdd64,
    0xdd65,
    0xdd66,
    0xdd67,
    0xdd68,
    0xdd69,
    0xdd6a,
    0xdd6b,
    0xdd6c,
    0xdd6d,
    0xdd6e,
    0xdd6f,
    0xdd70,
    0xdd71,
    0xdd72,
    0xdd73,
    0xdd74,
    0xdd75,
    0xdd76,
    0xdd77,
    0xdd78,
    0xdd79,
    0xdd7a,
    0xdd7b,
    0xdd7c,
    0xdd7d,
    0xdd7e,
    0xdd80,
    0xdd81,
    0xdd82,
    0xdd83,
    0xdd84,
    0xdd85,
    0xdd86,
    0xdd87,
    0xdd88,
    0xdd89,
    0xdd8a,
    0xdd8b,
    0xdd8c,
    0xdd8d,
    0xdd8e,
    0xdd8f,
    0xdd90,
    0xdd91,
    0xdd92,
    0xdd93,
    0xdd94,
    0xdd95,
    0xdd96,
    0xdd97,
    0xdd98,
    0xdd99,
    0xdd9a,
    0xdd9b,
    0xdd9c,
    0xdd9d,
    0xdd9e,
    0xdd9f,
    0xdda0,
    0xde40,
    0xde41,
    0xde42,
    0xde43,
    0xde44,
    0xde45,
    0xde46,
    0xde47,
    0xde48,
    0xde49,
    0xde4a,
    0xde4b,
    0xde4c,
    0xde4d,
    0xde4e,
    0xde4f,
    0xde50,
    0xde51,
    0xde52,
    0xde53,
    0xde54,
    0xde55,
    0xde56,
    0xde57,
    0xde58,
    0xde59,
    0xde5a,
    0xde5b,
    0xde5c,
    0xde5d,
    0xde5e,
    0xde5f,
    0xde60,
    0xb3b5,
    0xd4fe,
    0xb9ec,
    0xd0f9,
    0xde61,
    0xe9ed,
    0xd7aa,
    0xe9ee,
    0xc2d6,
    0xc8ed,
    0xbae4,
    0xe9ef,
    0xe9f0,
    0xe9f1,
    0xd6e1,
    0xe9f2,
    0xe9f3,
    0xe9f5,
    0xe9f4,
    0xe9f6,
    0xe9f7,
    0xc7e1,
    0xe9f8,
    0xd4d8,
    0xe9f9,
    0xbdce,
    0xde62,
    0xe9fa,
    0xe9fb,
    0xbdcf,
    0xe9fc,
    0xb8a8,
    0xc1be,
    0xe9fd,
    0xb1b2,
    0xbbd4,
    0xb9f5,
    0xe9fe,
    0xde63,
    0xeaa1,
    0xeaa2,
    0xeaa3,
    0xb7f8,
    0xbcad,
    0xde64,
    0xcae4,
    0xe0ce,
    0xd4af,
    0xcfbd,
    0xd5b7,
    0xeaa4,
    0xd5de,
    0xeaa5,
    0xd0c1,
    0xb9bc,
    0xde65,
    0xb4c7,
    0xb1d9,
    0xde66,
    0xde67,
    0xde68,
    0xc0b1,
    0xde69,
    0xde6a,
    0xde6b,
    0xde6c,
    0xb1e6,
    0xb1e7,
    0xde6d,
    0xb1e8,
    0xde6e,
    0xde6f,
    0xde70,
    0xde71,
    0xb3bd,
    0xc8e8,
    0xde72,
    0xde73,
    0xde74,
    0xde75,
    0xe5c1,
    0xde76,
    0xde77,
    0xb1df,
    0xde78,
    0xde79,
    0xde7a,
    0xc1c9,
    0xb4ef,
    0xde7b,
    0xde7c,
    0xc7a8,
    0xd3d8,
    0xde7d,
    0xc6f9,
    0xd1b8,
    0xde7e,
    0xb9fd,
    0xc2f5,
    0xde80,
    0xde81,
    0xde82,
    0xde83,
    0xde84,
    0xd3ad,
    0xde85,
    0xd4cb,
    0xbdfc,
    0xde86,
    0xe5c2,
    0xb7b5,
    0xe5c3,
    0xde87,
    0xde88,
    0xbbb9,
    0xd5e2,
    0xde89,
    0xbdf8,
    0xd4b6,
    0xcea5,
    0xc1ac,
    0xb3d9,
    0xde8a,
    0xde8b,
    0xccf6,
    0xde8c,
    0xe5c6,
    0xe5c4,
    0xe5c8,
    0xde8d,
    0xe5ca,
    0xe5c7,
    0xb5cf,
    0xc6c8,
    0xde8e,
    0xb5fc,
    0xe5c5,
    0xde8f,
    0xcaf6,
    0xde90,
    0xde91,
    0xe5c9,
    0xde92,
    0xde93,
    0xde94,
    0xc3d4,
    0xb1c5,
    0xbca3,
    0xde95,
    0xde96,
    0xde97,
    0xd7b7,
    0xde98,
    0xde99
};
UINT16 cp936_UNI_a0x90[] = {
    0xcdcb,
    0xcbcd,
    0xcaca,
    0xccd3,
    0xe5cc,
    0xe5cb,
    0xc4e6,
    0xde9a,
    0xde9b,
    0xd1a1,
    0xd1b7,
    0xe5cd,
    0xde9c,
    0xe5d0,
    0xde9d,
    0xcdb8,
    0xd6f0,
    0xe5cf,
    0xb5dd,
    0xde9e,
    0xcdbe,
    0xde9f,
    0xe5d1,
    0xb6ba,
    0xdea0,
    0xdf40,
    0xcda8,
    0xb9e4,
    0xdf41,
    0xcac5,
    0xb3d1,
    0xcbd9,
    0xd4ec,
    0xe5d2,
    0xb7ea,
    0xdf42,
    0xdf43,
    0xdf44,
    0xe5ce,
    0xdf45,
    0xdf46,
    0xdf47,
    0xdf48,
    0xdf49,
    0xdf4a,
    0xe5d5,
    0xb4fe,
    0xe5d6,
    0xdf4b,
    0xdf4c,
    0xdf4d,
    0xdf4e,
    0xdf4f,
    0xe5d3,
    0xe5d4,
    0xdf50,
    0xd2dd,
    0xdf51,
    0xdf52,
    0xc2df,
    0xb1c6,
    0xdf53,
    0xd3e2,
    0xdf54,
    0xdf55,
    0xb6dd,
    0xcbec,
    0xdf56,
    0xe5d7,
    0xdf57,
    0xdf58,
    0xd3f6,
    0xdf59,
    0xdf5a,
    0xdf5b,
    0xdf5c,
    0xdf5d,
    0xb1e9,
    0xdf5e,
    0xb6f4,
    0xe5da,
    0xe5d8,
    0xe5d9,
    0xb5c0,
    0xdf5f,
    0xdf60,
    0xdf61,
    0xd2c5,
    0xe5dc,
    0xdf62,
    0xdf63,
    0xe5de,
    0xdf64,
    0xdf65,
    0xdf66,
    0xdf67,
    0xdf68,
    0xdf69,
    0xe5dd,
    0xc7b2,
    0xdf6a,
    0xd2a3,
    0xdf6b,
    0xdf6c,
    0xe5db,
    0xdf6d,
    0xdf6e,
    0xdf6f,
    0xdf70,
    0xd4e2,
    0xd5da,
    0xdf71,
    0xdf72,
    0xdf73,
    0xdf74,
    0xdf75,
    0xe5e0,
    0xd7f1,
    0xdf76,
    0xdf77,
    0xdf78,
    0xdf79,
    0xdf7a,
    0xdf7b,
    0xdf7c,
    0xe5e1,
    0xdf7d,
    0xb1dc,
    0xd1fb,
    0xdf7e,
    0xe5e2,
    0xe5e4,
    0xdf80,
    0xdf81,
    0xdf82,
    0xdf83,
    0xe5e3,
    0xdf84,
    0xdf85,
    0xe5e5,
    0xdf86,
    0xdf87,
    0xdf88,
    0xdf89,
    0xdf8a,
    0xd2d8,
    0xdf8b,
    0xb5cb,
    0xdf8c,
    0xe7df,
    0xdf8d,
    0xdaf5,
    0xdf8e,
    0xdaf8,
    0xdf8f,
    0xdaf6,
    0xdf90,
    0xdaf7,
    0xdf91,
    0xdf92,
    0xdf93,
    0xdafa,
    0xd0cf,
    0xc4c7,
    0xdf94,
    0xdf95,
    0xb0ee,
    0xdf96,
    0xdf97,
    0xdf98,
    0xd0b0,
    0xdf99,
    0xdaf9,
    0xdf9a,
    0xd3ca,
    0xbaaa,
    0xdba2,
    0xc7f1,
    0xdf9b,
    0xdafc,
    0xdafb,
    0xc9db,
    0xdafd,
    0xdf9c,
    0xdba1,
    0xd7de,
    0xdafe,
    0xc1da,
    0xdf9d,
    0xdf9e,
    0xdba5,
    0xdf9f,
    0xdfa0,
    0xd3f4,
    0xe040,
    0xe041,
    0xdba7,
    0xdba4,
    0xe042,
    0xdba8,
    0xe043,
    0xe044,
    0xbdbc,
    0xe045,
    0xe046,
    0xe047,
    0xc0c9,
    0xdba3,
    0xdba6,
    0xd6a3,
    0xe048,
    0xdba9,
    0xe049,
    0xe04a,
    0xe04b,
    0xdbad,
    0xe04c,
    0xe04d,
    0xe04e,
    0xdbae,
    0xdbac,
    0xbac2,
    0xe04f,
    0xe050,
    0xe051,
    0xbfa4,
    0xdbab,
    0xe052,
    0xe053,
    0xe054,
    0xdbaa,
    0xd4c7,
    0xb2bf,
    0xe055,
    0xe056,
    0xdbaf,
    0xe057,
    0xb9f9,
    0xe058,
    0xdbb0,
    0xe059,
    0xe05a,
    0xe05b,
    0xe05c,
    0xb3bb,
    0xe05d,
    0xe05e,
    0xe05f,
    0xb5a6,
    0xe060,
    0xe061,
    0xe062,
    0xe063,
    0xb6bc,
    0xdbb1,
    0xe064
};
UINT16 cp936_UNI_a0x91[] = {
    0xe065,
    0xe066,
    0xb6f5,
    0xe067,
    0xdbb2,
    0xe068,
    0xe069,
    0xe06a,
    0xe06b,
    0xe06c,
    0xe06d,
    0xe06e,
    0xe06f,
    0xe070,
    0xe071,
    0xe072,
    0xe073,
    0xe074,
    0xe075,
    0xe076,
    0xe077,
    0xe078,
    0xe079,
    0xe07a,
    0xe07b,
    0xb1c9,
    0xe07c,
    0xe07d,
    0xe07e,
    0xe080,
    0xdbb4,
    0xe081,
    0xe082,
    0xe083,
    0xdbb3,
    0xdbb5,
    0xe084,
    0xe085,
    0xe086,
    0xe087,
    0xe088,
    0xe089,
    0xe08a,
    0xe08b,
    0xe08c,
    0xe08d,
    0xe08e,
    0xdbb7,
    0xe08f,
    0xdbb6,
    0xe090,
    0xe091,
    0xe092,
    0xe093,
    0xe094,
    0xe095,
    0xe096,
    0xdbb8,
    0xe097,
    0xe098,
    0xe099,
    0xe09a,
    0xe09b,
    0xe09c,
    0xe09d,
    0xe09e,
    0xe09f,
    0xdbb9,
    0xe0a0,
    0xe140,
    0xdbba,
    0xe141,
    0xe142,
    0xd3cf,
    0xf4fa,
    0xc7f5,
    0xd7c3,
    0xc5e4,
    0xf4fc,
    0xf4fd,
    0xf4fb,
    0xe143,
    0xbec6,
    0xe144,
    0xe145,
    0xe146,
    0xe147,
    0xd0ef,
    0xe148,
    0xe149,
    0xb7d3,
    0xe14a,
    0xe14b,
    0xd4cd,
    0xccaa,
    0xe14c,
    0xe14d,
    0xf5a2,
    0xf5a1,
    0xbaa8,
    0xf4fe,
    0xcbd6,
    0xe14e,
    0xe14f,
    0xe150,
    0xf5a4,
    0xc0d2,
    0xe151,
    0xb3ea,
    0xe152,
    0xcdaa,
    0xf5a5,
    0xf5a3,
    0xbdb4,
    0xf5a8,
    0xe153,
    0xf5a9,
    0xbdcd,
    0xc3b8,
    0xbfe1,
    0xcbe1,
    0xf5aa,
    0xe154,
    0xe155,
    0xe156,
    0xf5a6,
    0xf5a7,
    0xc4f0,
    0xe157,
    0xe158,
    0xe159,
    0xe15a,
    0xe15b,
    0xf5ac,
    0xe15c,
    0xb4bc,
    0xe15d,
    0xd7ed,
    0xe15e,
    0xb4d7,
    0xf5ab,
    0xf5ae,
    0xe15f,
    0xe160,
    0xf5ad,
    0xf5af,
    0xd0d1,
    0xe161,
    0xe162,
    0xe163,
    0xe164,
    0xe165,
    0xe166,
    0xe167,
    0xc3d1,
    0xc8a9,
    0xe168,
    0xe169,
    0xe16a,
    0xe16b,
    0xe16c,
    0xe16d,
    0xf5b0,
    0xf5b1,
    0xe16e,
    0xe16f,
    0xe170,
    0xe171,
    0xe172,
    0xe173,
    0xf5b2,
    0xe174,
    0xe175,
    0xf5b3,
    0xf5b4,
    0xf5b5,
    0xe176,
    0xe177,
    0xe178,
    0xe179,
    0xf5b7,
    0xf5b6,
    0xe17a,
    0xe17b,
    0xe17c,
    0xe17d,
    0xf5b8,
    0xe17e,
    0xe180,
    0xe181,
    0xe182,
    0xe183,
    0xe184,
    0xe185,
    0xe186,
    0xe187,
    0xe188,
    0xe189,
    0xe18a,
    0xb2c9,
    0xe18b,
    0xd3d4,
    0xcacd,
    0xe18c,
    0xc0ef,
    0xd6d8,
    0xd2b0,
    0xc1bf,
    0xe18d,
    0xbdf0,
    0xe18e,
    0xe18f,
    0xe190,
    0xe191,
    0xe192,
    0xe193,
    0xe194,
    0xe195,
    0xe196,
    0xe197,
    0xb8aa,
    0xe198,
    0xe199,
    0xe19a,
    0xe19b,
    0xe19c,
    0xe19d,
    0xe19e,
    0xe19f,
    0xe1a0,
    0xe240,
    0xe241,
    0xe242,
    0xe243,
    0xe244,
    0xe245,
    0xe246,
    0xe247,
    0xe248,
    0xe249,
    0xe24a,
    0xe24b,
    0xe24c,
    0xe24d,
    0xe24e,
    0xe24f,
    0xe250,
    0xe251,
    0xe252,
    0xe253,
    0xe254,
    0xe255,
    0xe256,
    0xe257,
    0xe258,
    0xe259
};
UINT16 cp936_UNI_a0x92[] = {
    0xe25a,
    0xe25b,
    0xe25c,
    0xe25d,
    0xe25e,
    0xe25f,
    0xe260,
    0xe261,
    0xe262,
    0xe263,
    0xe264,
    0xe265,
    0xe266,
    0xe267,
    0xe268,
    0xe269,
    0xe26a,
    0xe26b,
    0xe26c,
    0xe26d,
    0xe26e,
    0xe26f,
    0xe270,
    0xe271,
    0xe272,
    0xe273,
    0xe274,
    0xe275,
    0xe276,
    0xe277,
    0xe278,
    0xe279,
    0xe27a,
    0xe27b,
    0xe27c,
    0xe27d,
    0xe27e,
    0xe280,
    0xe281,
    0xe282,
    0xe283,
    0xe284,
    0xe285,
    0xe286,
    0xe287,
    0xe288,
    0xe289,
    0xe28a,
    0xe28b,
    0xe28c,
    0xe28d,
    0xe28e,
    0xe28f,
    0xe290,
    0xe291,
    0xe292,
    0xe293,
    0xe294,
    0xe295,
    0xe296,
    0xe297,
    0xe298,
    0xe299,
    0xe29a,
    0xe29b,
    0xe29c,
    0xe29d,
    0xe29e,
    0xe29f,
    0xe2a0,
    0xe340,
    0xe341,
    0xe342,
    0xe343,
    0xe344,
    0xe345,
    0xe346,
    0xe347,
    0xe348,
    0xe349,
    0xe34a,
    0xe34b,
    0xe34c,
    0xe34d,
    0xe34e,
    0xe34f,
    0xe350,
    0xe351,
    0xe352,
    0xe353,
    0xe354,
    0xe355,
    0xe356,
    0xe357,
    0xe358,
    0xe359,
    0xe35a,
    0xe35b,
    0xe35c,
    0xe35d,
    0xe35e,
    0xe35f,
    0xe360,
    0xe361,
    0xe362,
    0xe363,
    0xe364,
    0xe365,
    0xe366,
    0xe367,
    0xe368,
    0xe369,
    0xe36a,
    0xe36b,
    0xe36c,
    0xe36d,
    0xbcf8,
    0xe36e,
    0xe36f,
    0xe370,
    0xe371,
    0xe372,
    0xe373,
    0xe374,
    0xe375,
    0xe376,
    0xe377,
    0xe378,
    0xe379,
    0xe37a,
    0xe37b,
    0xe37c,
    0xe37d,
    0xe37e,
    0xe380,
    0xe381,
    0xe382,
    0xe383,
    0xe384,
    0xe385,
    0xe386,
    0xe387,
    0xf6c6,
    0xe388,
    0xe389,
    0xe38a,
    0xe38b,
    0xe38c,
    0xe38d,
    0xe38e,
    0xe38f,
    0xe390,
    0xe391,
    0xe392,
    0xe393,
    0xe394,
    0xe395,
    0xe396,
    0xe397,
    0xe398,
    0xe399,
    0xe39a,
    0xe39b,
    0xe39c,
    0xe39d,
    0xe39e,
    0xe39f,
    0xe3a0,
    0xe440,
    0xe441,
    0xe442,
    0xe443,
    0xe444,
    0xe445,
    0xf6c7,
    0xe446,
    0xe447,
    0xe448,
    0xe449,
    0xe44a,
    0xe44b,
    0xe44c,
    0xe44d,
    0xe44e,
    0xe44f,
    0xe450,
    0xe451,
    0xe452,
    0xe453,
    0xe454,
    0xe455,
    0xe456,
    0xe457,
    0xe458,
    0xe459,
    0xe45a,
    0xe45b,
    0xe45c,
    0xe45d,
    0xe45e,
    0xf6c8,
    0xe45f,
    0xe460,
    0xe461,
    0xe462,
    0xe463,
    0xe464,
    0xe465,
    0xe466,
    0xe467,
    0xe468,
    0xe469,
    0xe46a,
    0xe46b,
    0xe46c,
    0xe46d,
    0xe46e,
    0xe46f,
    0xe470,
    0xe471,
    0xe472,
    0xe473,
    0xe474,
    0xe475,
    0xe476,
    0xe477,
    0xe478,
    0xe479,
    0xe47a,
    0xe47b,
    0xe47c,
    0xe47d,
    0xe47e,
    0xe480,
    0xe481,
    0xe482,
    0xe483,
    0xe484,
    0xe485,
    0xe486,
    0xe487,
    0xe488,
    0xe489,
    0xe48a,
    0xe48b,
    0xe48c,
    0xe48d,
    0xe48e,
    0xe48f,
    0xe490,
    0xe491,
    0xe492,
    0xe493,
    0xe494,
    0xe495,
    0xe496
};
UINT16 cp936_UNI_a0x93[] = {
    0xe497,
    0xe498,
    0xe499,
    0xe49a,
    0xe49b,
    0xe49c,
    0xe49d,
    0xe49e,
    0xe49f,
    0xe4a0,
    0xe540,
    0xe541,
    0xe542,
    0xe543,
    0xe544,
    0xe545,
    0xe546,
    0xe547,
    0xe548,
    0xe549,
    0xe54a,
    0xe54b,
    0xe54c,
    0xe54d,
    0xe54e,
    0xe54f,
    0xe550,
    0xe551,
    0xe552,
    0xe553,
    0xe554,
    0xe555,
    0xe556,
    0xe557,
    0xe558,
    0xe559,
    0xe55a,
    0xe55b,
    0xe55c,
    0xe55d,
    0xe55e,
    0xe55f,
    0xe560,
    0xe561,
    0xe562,
    0xe563,
    0xe564,
    0xe565,
    0xe566,
    0xe567,
    0xe568,
    0xe569,
    0xe56a,
    0xe56b,
    0xe56c,
    0xe56d,
    0xe56e,
    0xe56f,
    0xe570,
    0xe571,
    0xe572,
    0xe573,
    0xf6c9,
    0xe574,
    0xe575,
    0xe576,
    0xe577,
    0xe578,
    0xe579,
    0xe57a,
    0xe57b,
    0xe57c,
    0xe57d,
    0xe57e,
    0xe580,
    0xe581,
    0xe582,
    0xe583,
    0xe584,
    0xe585,
    0xe586,
    0xe587,
    0xe588,
    0xe589,
    0xe58a,
    0xe58b,
    0xe58c,
    0xe58d,
    0xe58e,
    0xe58f,
    0xe590,
    0xe591,
    0xe592,
    0xe593,
    0xe594,
    0xe595,
    0xe596,
    0xe597,
    0xe598,
    0xe599,
    0xe59a,
    0xe59b,
    0xe59c,
    0xe59d,
    0xe59e,
    0xe59f,
    0xf6ca,
    0xe5a0,
    0xe640,
    0xe641,
    0xe642,
    0xe643,
    0xe644,
    0xe645,
    0xe646,
    0xe647,
    0xe648,
    0xe649,
    0xe64a,
    0xe64b,
    0xe64c,
    0xe64d,
    0xe64e,
    0xe64f,
    0xe650,
    0xe651,
    0xe652,
    0xe653,
    0xe654,
    0xe655,
    0xe656,
    0xe657,
    0xe658,
    0xe659,
    0xe65a,
    0xe65b,
    0xe65c,
    0xe65d,
    0xe65e,
    0xe65f,
    0xe660,
    0xe661,
    0xe662,
    0xf6cc,
    0xe663,
    0xe664,
    0xe665,
    0xe666,
    0xe667,
    0xe668,
    0xe669,
    0xe66a,
    0xe66b,
    0xe66c,
    0xe66d,
    0xe66e,
    0xe66f,
    0xe670,
    0xe671,
    0xe672,
    0xe673,
    0xe674,
    0xe675,
    0xe676,
    0xe677,
    0xe678,
    0xe679,
    0xe67a,
    0xe67b,
    0xe67c,
    0xe67d,
    0xe67e,
    0xe680,
    0xe681,
    0xe682,
    0xe683,
    0xe684,
    0xe685,
    0xe686,
    0xe687,
    0xe688,
    0xe689,
    0xe68a,
    0xe68b,
    0xe68c,
    0xe68d,
    0xe68e,
    0xe68f,
    0xe690,
    0xe691,
    0xe692,
    0xe693,
    0xe694,
    0xe695,
    0xe696,
    0xe697,
    0xe698,
    0xe699,
    0xe69a,
    0xe69b,
    0xe69c,
    0xe69d,
    0xf6cb,
    0xe69e,
    0xe69f,
    0xe6a0,
    0xe740,
    0xe741,
    0xe742,
    0xe743,
    0xe744,
    0xe745,
    0xe746,
    0xe747,
    0xf7e9,
    0xe748,
    0xe749,
    0xe74a,
    0xe74b,
    0xe74c,
    0xe74d,
    0xe74e,
    0xe74f,
    0xe750,
    0xe751,
    0xe752,
    0xe753,
    0xe754,
    0xe755,
    0xe756,
    0xe757,
    0xe758,
    0xe759,
    0xe75a,
    0xe75b,
    0xe75c,
    0xe75d,
    0xe75e,
    0xe75f,
    0xe760,
    0xe761,
    0xe762,
    0xe763,
    0xe764,
    0xe765,
    0xe766,
    0xe767,
    0xe768,
    0xe769,
    0xe76a,
    0xe76b,
    0xe76c,
    0xe76d,
    0xe76e,
    0xe76f,
    0xe770
};
UINT16 cp936_UNI_a0x94[] = {
    0xe771,
    0xe772,
    0xe773,
    0xe774,
    0xe775,
    0xe776,
    0xe777,
    0xe778,
    0xe779,
    0xe77a,
    0xe77b,
    0xe77c,
    0xe77d,
    0xe77e,
    0xe780,
    0xe781,
    0xe782,
    0xe783,
    0xe784,
    0xe785,
    0xe786,
    0xe787,
    0xe788,
    0xe789,
    0xe78a,
    0xe78b,
    0xe78c,
    0xe78d,
    0xe78e,
    0xe78f,
    0xe790,
    0xe791,
    0xe792,
    0xe793,
    0xe794,
    0xe795,
    0xe796,
    0xe797,
    0xe798,
    0xe799,
    0xe79a,
    0xe79b,
    0xe79c,
    0xe79d,
    0xe79e,
    0xe79f,
    0xe7a0,
    0xe840,
    0xe841,
    0xe842,
    0xe843,
    0xe844,
    0xe845,
    0xe846,
    0xe847,
    0xe848,
    0xe849,
    0xe84a,
    0xe84b,
    0xe84c,
    0xe84d,
    0xe84e,
    0xf6cd,
    0xe84f,
    0xe850,
    0xe851,
    0xe852,
    0xe853,
    0xe854,
    0xe855,
    0xe856,
    0xe857,
    0xe858,
    0xe859,
    0xe85a,
    0xe85b,
    0xe85c,
    0xe85d,
    0xe85e,
    0xe85f,
    0xe860,
    0xe861,
    0xe862,
    0xe863,
    0xe864,
    0xe865,
    0xe866,
    0xe867,
    0xe868,
    0xe869,
    0xe86a,
    0xe86b,
    0xe86c,
    0xe86d,
    0xe86e,
    0xe86f,
    0xe870,
    0xe871,
    0xe872,
    0xe873,
    0xe874,
    0xe875,
    0xe876,
    0xe877,
    0xe878,
    0xe879,
    0xe87a,
    0xf6ce,
    0xe87b,
    0xe87c,
    0xe87d,
    0xe87e,
    0xe880,
    0xe881,
    0xe882,
    0xe883,
    0xe884,
    0xe885,
    0xe886,
    0xe887,
    0xe888,
    0xe889,
    0xe88a,
    0xe88b,
    0xe88c,
    0xe88d,
    0xe88e,
    0xe88f,
    0xe890,
    0xe891,
    0xe892,
    0xe893,
    0xe894,
    0xeec4,
    0xeec5,
    0xeec6,
    0xd5eb,
    0xb6a4,
    0xeec8,
    0xeec7,
    0xeec9,
    0xeeca,
    0xc7a5,
    0xeecb,
    0xeecc,
    0xe895,
    0xb7b0,
    0xb5f6,
    0xeecd,
    0xeecf,
    0xe896,
    0xeece,
    0xe897,
    0xb8c6,
    0xeed0,
    0xeed1,
    0xeed2,
    0xb6db,
    0xb3ae,
    0xd6d3,
    0xc4c6,
    0xb1b5,
    0xb8d6,
    0xeed3,
    0xeed4,
    0xd4bf,
    0xc7d5,
    0xbefb,
    0xced9,
    0xb9b3,
    0xeed6,
    0xeed5,
    0xeed8,
    0xeed7,
    0xc5a5,
    0xeed9,
    0xeeda,
    0xc7ae,
    0xeedb,
    0xc7af,
    0xeedc,
    0xb2a7,
    0xeedd,
    0xeede,
    0xeedf,
    0xeee0,
    0xeee1,
    0xd7ea,
    0xeee2,
    0xeee3,
    0xbcd8,
    0xeee4,
    0xd3cb,
    0xccfa,
    0xb2ac,
    0xc1e5,
    0xeee5,
    0xc7a6,
    0xc3ad,
    0xe898,
    0xeee6,
    0xeee7,
    0xeee8,
    0xeee9,
    0xeeea,
    0xeeeb,
    0xeeec,
    0xe899,
    0xeeed,
    0xeeee,
    0xeeef,
    0xe89a,
    0xe89b,
    0xeef0,
    0xeef1,
    0xeef2,
    0xeef4,
    0xeef3,
    0xe89c,
    0xeef5,
    0xcdad,
    0xc2c1,
    0xeef6,
    0xeef7,
    0xeef8,
    0xd5a1,
    0xeef9,
    0xcfb3,
    0xeefa,
    0xeefb,
    0xe89d,
    0xeefc,
    0xeefd,
    0xefa1,
    0xeefe,
    0xefa2,
    0xb8f5,
    0xc3fa,
    0xefa3,
    0xefa4,
    0xbdc2,
    0xd2bf,
    0xb2f9,
    0xefa5,
    0xefa6,
    0xefa7,
    0xd2f8,
    0xefa8,
    0xd6fd,
    0xefa9,
    0xc6cc,
    0xe89e,
    0xefaa,
    0xefab,
    0xc1b4,
    0xefac
};
UINT16 cp936_UNI_a0x95[] = {
    0xcffa,
    0xcbf8,
    0xefae,
    0xefad,
    0xb3fa,
    0xb9f8,
    0xefaf,
    0xefb0,
    0xd0e2,
    0xefb1,
    0xefb2,
    0xb7e6,
    0xd0bf,
    0xefb3,
    0xefb4,
    0xefb5,
    0xc8f1,
    0xcce0,
    0xefb6,
    0xefb7,
    0xefb8,
    0xefb9,
    0xefba,
    0xd5e0,
    0xefbb,
    0xb4ed,
    0xc3aa,
    0xefbc,
    0xe89f,
    0xefbd,
    0xefbe,
    0xefbf,
    0xe8a0,
    0xcefd,
    0xefc0,
    0xc2e0,
    0xb4b8,
    0xd7b6,
    0xbdf5,
    0xe940,
    0xcfc7,
    0xefc3,
    0xefc1,
    0xefc2,
    0xefc4,
    0xb6a7,
    0xbcfc,
    0xbee2,
    0xc3cc,
    0xefc5,
    0xefc6,
    0xe941,
    0xefc7,
    0xefcf,
    0xefc8,
    0xefc9,
    0xefca,
    0xc7c2,
    0xeff1,
    0xb6cd,
    0xefcb,
    0xe942,
    0xefcc,
    0xefcd,
    0xb6c6,
    0xc3be,
    0xefce,
    0xe943,
    0xefd0,
    0xefd1,
    0xefd2,
    0xd5f2,
    0xe944,
    0xefd3,
    0xc4f7,
    0xe945,
    0xefd4,
    0xc4f8,
    0xefd5,
    0xefd6,
    0xb8e4,
    0xb0f7,
    0xefd7,
    0xefd8,
    0xefd9,
    0xe946,
    0xefda,
    0xefdb,
    0xefdc,
    0xefdd,
    0xe947,
    0xefde,
    0xbeb5,
    0xefe1,
    0xefdf,
    0xefe0,
    0xe948,
    0xefe2,
    0xefe3,
    0xc1cd,
    0xefe4,
    0xefe5,
    0xefe6,
    0xefe7,
    0xefe8,
    0xefe9,
    0xefea,
    0xefeb,
    0xefec,
    0xc0d8,
    0xe949,
    0xefed,
    0xc1ad,
    0xefee,
    0xefef,
    0xeff0,
    0xe94a,
    0xe94b,
    0xcfe2,
    0xe94c,
    0xe94d,
    0xe94e,
    0xe94f,
    0xe950,
    0xe951,
    0xe952,
    0xe953,
    0xb3a4,
    0xe954,
    0xe955,
    0xe956,
    0xe957,
    0xe958,
    0xe959,
    0xe95a,
    0xe95b,
    0xe95c,
    0xe95d,
    0xe95e,
    0xe95f,
    0xe960,
    0xe961,
    0xe962,
    0xe963,
    0xe964,
    0xe965,
    0xe966,
    0xe967,
    0xe968,
    0xe969,
    0xe96a,
    0xe96b,
    0xe96c,
    0xe96d,
    0xe96e,
    0xe96f,
    0xe970,
    0xe971,
    0xe972,
    0xe973,
    0xe974,
    0xe975,
    0xe976,
    0xe977,
    0xe978,
    0xe979,
    0xe97a,
    0xe97b,
    0xe97c,
    0xe97d,
    0xe97e,
    0xe980,
    0xe981,
    0xe982,
    0xe983,
    0xe984,
    0xe985,
    0xe986,
    0xe987,
    0xe988,
    0xe989,
    0xe98a,
    0xe98b,
    0xe98c,
    0xe98d,
    0xe98e,
    0xe98f,
    0xe990,
    0xe991,
    0xe992,
    0xe993,
    0xe994,
    0xe995,
    0xe996,
    0xe997,
    0xe998,
    0xe999,
    0xe99a,
    0xe99b,
    0xe99c,
    0xe99d,
    0xe99e,
    0xe99f,
    0xe9a0,
    0xea40,
    0xea41,
    0xea42,
    0xea43,
    0xea44,
    0xea45,
    0xea46,
    0xea47,
    0xea48,
    0xea49,
    0xea4a,
    0xea4b,
    0xea4c,
    0xea4d,
    0xea4e,
    0xea4f,
    0xea50,
    0xea51,
    0xea52,
    0xea53,
    0xea54,
    0xea55,
    0xea56,
    0xea57,
    0xea58,
    0xea59,
    0xea5a,
    0xea5b,
    0xc3c5,
    0xe3c5,
    0xc9c1,
    0xe3c6,
    0xea5c,
    0xb1d5,
    0xceca,
    0xb4b3,
    0xc8f2,
    0xe3c7,
    0xcfd0,
    0xe3c8,
    0xbce4,
    0xe3c9,
    0xe3ca,
    0xc3c6,
    0xd5a2,
    0xc4d6,
    0xb9eb,
    0xcec5,
    0xe3cb,
    0xc3f6,
    0xe3cc,
    0xea5d
};
UINT16 cp936_UNI_a0x96[] = {
    0xb7a7,
    0xb8f3,
    0xbad2,
    0xe3cd,
    0xe3ce,
    0xd4c4,
    0xe3cf,
    0xea5e,
    0xe3d0,
    0xd1cb,
    0xe3d1,
    0xe3d2,
    0xe3d3,
    0xe3d4,
    0xd1d6,
    0xe3d5,
    0xb2fb,
    0xc0bb,
    0xe3d6,
    0xea5f,
    0xc0ab,
    0xe3d7,
    0xe3d8,
    0xe3d9,
    0xea60,
    0xe3da,
    0xe3db,
    0xea61,
    0xb8b7,
    0xdae2,
    0xea62,
    0xb6d3,
    0xea63,
    0xdae4,
    0xdae3,
    0xea64,
    0xea65,
    0xea66,
    0xea67,
    0xea68,
    0xea69,
    0xea6a,
    0xdae6,
    0xea6b,
    0xea6c,
    0xea6d,
    0xc8ee,
    0xea6e,
    0xea6f,
    0xdae5,
    0xb7c0,
    0xd1f4,
    0xd2f5,
    0xd5f3,
    0xbdd7,
    0xea70,
    0xea71,
    0xea72,
    0xea73,
    0xd7e8,
    0xdae8,
    0xdae7,
    0xea74,
    0xb0a2,
    0xcdd3,
    0xea75,
    0xdae9,
    0xea76,
    0xb8bd,
    0xbcca,
    0xc2bd,
    0xc2a4,
    0xb3c2,
    0xdaea,
    0xea77,
    0xc2aa,
    0xc4b0,
    0xbdb5,
    0xea78,
    0xea79,
    0xcfde,
    0xea7a,
    0xea7b,
    0xea7c,
    0xdaeb,
    0xc9c2,
    0xea7d,
    0xea7e,
    0xea80,
    0xea81,
    0xea82,
    0xb1dd,
    0xea83,
    0xea84,
    0xea85,
    0xdaec,
    0xea86,
    0xb6b8,
    0xd4ba,
    0xea87,
    0xb3fd,
    0xea88,
    0xea89,
    0xdaed,
    0xd4c9,
    0xcfd5,
    0xc5e3,
    0xea8a,
    0xdaee,
    0xea8b,
    0xea8c,
    0xea8d,
    0xea8e,
    0xea8f,
    0xdaef,
    0xea90,
    0xdaf0,
    0xc1ea,
    0xccd5,
    0xcfdd,
    0xea91,
    0xea92,
    0xea93,
    0xea94,
    0xea95,
    0xea96,
    0xea97,
    0xea98,
    0xea99,
    0xea9a,
    0xea9b,
    0xea9c,
    0xea9d,
    0xd3e7,
    0xc2a1,
    0xea9e,
    0xdaf1,
    0xea9f,
    0xeaa0,
    0xcbe5,
    0xeb40,
    0xdaf2,
    0xeb41,
    0xcbe6,
    0xd2fe,
    0xeb42,
    0xeb43,
    0xeb44,
    0xb8f4,
    0xeb45,
    0xeb46,
    0xdaf3,
    0xb0af,
    0xcfb6,
    0xeb47,
    0xeb48,
    0xd5cf,
    0xeb49,
    0xeb4a,
    0xeb4b,
    0xeb4c,
    0xeb4d,
    0xeb4e,
    0xeb4f,
    0xeb50,
    0xeb51,
    0xeb52,
    0xcbed,
    0xeb53,
    0xeb54,
    0xeb55,
    0xeb56,
    0xeb57,
    0xeb58,
    0xeb59,
    0xeb5a,
    0xdaf4,
    0xeb5b,
    0xeb5c,
    0xe3c4,
    0xeb5d,
    0xeb5e,
    0xc1a5,
    0xeb5f,
    0xeb60,
    0xf6bf,
    0xeb61,
    0xeb62,
    0xf6c0,
    0xf6c1,
    0xc4d1,
    0xeb63,
    0xc8b8,
    0xd1e3,
    0xeb64,
    0xeb65,
    0xd0db,
    0xd1c5,
    0xbcaf,
    0xb9cd,
    0xeb66,
    0xeff4,
    0xeb67,
    0xeb68,
    0xb4c6,
    0xd3ba,
    0xf6c2,
    0xb3fb,
    0xeb69,
    0xeb6a,
    0xf6c3,
    0xeb6b,
    0xeb6c,
    0xb5f1,
    0xeb6d,
    0xeb6e,
    0xeb6f,
    0xeb70,
    0xeb71,
    0xeb72,
    0xeb73,
    0xeb74,
    0xeb75,
    0xeb76,
    0xf6c5,
    0xeb77,
    0xeb78,
    0xeb79,
    0xeb7a,
    0xeb7b,
    0xeb7c,
    0xeb7d,
    0xd3ea,
    0xf6a7,
    0xd1a9,
    0xeb7e,
    0xeb80,
    0xeb81,
    0xeb82,
    0xf6a9,
    0xeb83,
    0xeb84,
    0xeb85,
    0xf6a8,
    0xeb86,
    0xeb87,
    0xc1e3,
    0xc0d7,
    0xeb88,
    0xb1a2,
    0xeb89,
    0xeb8a,
    0xeb8b,
    0xeb8c,
    0xceed,
    0xeb8d
};
UINT16 cp936_UNI_a0x97[] = {
    0xd0e8,
    0xf6ab,
    0xeb8e,
    0xeb8f,
    0xcff6,
    0xeb90,
    0xf6aa,
    0xd5f0,
    0xf6ac,
    0xc3b9,
    0xeb91,
    0xeb92,
    0xeb93,
    0xbbf4,
    0xf6ae,
    0xf6ad,
    0xeb94,
    0xeb95,
    0xeb96,
    0xc4de,
    0xeb97,
    0xeb98,
    0xc1d8,
    0xeb99,
    0xeb9a,
    0xeb9b,
    0xeb9c,
    0xeb9d,
    0xcbaa,
    0xeb9e,
    0xcfbc,
    0xeb9f,
    0xeba0,
    0xec40,
    0xec41,
    0xec42,
    0xec43,
    0xec44,
    0xec45,
    0xec46,
    0xec47,
    0xec48,
    0xf6af,
    0xec49,
    0xec4a,
    0xf6b0,
    0xec4b,
    0xec4c,
    0xf6b1,
    0xec4d,
    0xc2b6,
    0xec4e,
    0xec4f,
    0xec50,
    0xec51,
    0xec52,
    0xb0d4,
    0xc5f9,
    0xec53,
    0xec54,
    0xec55,
    0xec56,
    0xf6b2,
    0xec57,
    0xec58,
    0xec59,
    0xec5a,
    0xec5b,
    0xec5c,
    0xec5d,
    0xec5e,
    0xec5f,
    0xec60,
    0xec61,
    0xec62,
    0xec63,
    0xec64,
    0xec65,
    0xec66,
    0xec67,
    0xec68,
    0xec69,
    0xc7e0,
    0xf6a6,
    0xec6a,
    0xec6b,
    0xbeb8,
    0xec6c,
    0xec6d,
    0xbeb2,
    0xec6e,
    0xb5e5,
    0xec6f,
    0xec70,
    0xb7c7,
    0xec71,
    0xbfbf,
    0xc3d2,
    0xc3e6,
    0xec72,
    0xec73,
    0xd8cc,
    0xec74,
    0xec75,
    0xec76,
    0xb8ef,
    0xec77,
    0xec78,
    0xec79,
    0xec7a,
    0xec7b,
    0xec7c,
    0xec7d,
    0xec7e,
    0xec80,
    0xbdf9,
    0xd1a5,
    0xec81,
    0xb0d0,
    0xec82,
    0xec83,
    0xec84,
    0xec85,
    0xec86,
    0xf7b0,
    0xec87,
    0xec88,
    0xec89,
    0xec8a,
    0xec8b,
    0xec8c,
    0xec8d,
    0xec8e,
    0xf7b1,
    0xec8f,
    0xec90,
    0xec91,
    0xec92,
    0xec93,
    0xd0ac,
    0xec94,
    0xb0b0,
    0xec95,
    0xec96,
    0xec97,
    0xf7b2,
    0xf7b3,
    0xec98,
    0xf7b4,
    0xec99,
    0xec9a,
    0xec9b,
    0xc7ca,
    0xec9c,
    0xec9d,
    0xec9e,
    0xec9f,
    0xeca0,
    0xed40,
    0xed41,
    0xbecf,
    0xed42,
    0xed43,
    0xf7b7,
    0xed44,
    0xed45,
    0xed46,
    0xed47,
    0xed48,
    0xed49,
    0xed4a,
    0xf7b6,
    0xed4b,
    0xb1de,
    0xed4c,
    0xf7b5,
    0xed4d,
    0xed4e,
    0xf7b8,
    0xed4f,
    0xf7b9,
    0xed50,
    0xed51,
    0xed52,
    0xed53,
    0xed54,
    0xed55,
    0xed56,
    0xed57,
    0xed58,
    0xed59,
    0xed5a,
    0xed5b,
    0xed5c,
    0xed5d,
    0xed5e,
    0xed5f,
    0xed60,
    0xed61,
    0xed62,
    0xed63,
    0xed64,
    0xed65,
    0xed66,
    0xed67,
    0xed68,
    0xed69,
    0xed6a,
    0xed6b,
    0xed6c,
    0xed6d,
    0xed6e,
    0xed6f,
    0xed70,
    0xed71,
    0xed72,
    0xed73,
    0xed74,
    0xed75,
    0xed76,
    0xed77,
    0xed78,
    0xed79,
    0xed7a,
    0xed7b,
    0xed7c,
    0xed7d,
    0xed7e,
    0xed80,
    0xed81,
    0xcea4,
    0xc8cd,
    0xed82,
    0xbaab,
    0xe8b8,
    0xe8b9,
    0xe8ba,
    0xbec2,
    0xed83,
    0xed84,
    0xed85,
    0xed86,
    0xed87,
    0xd2f4,
    0xed88,
    0xd4cf,
    0xc9d8,
    0xed89,
    0xed8a,
    0xed8b,
    0xed8c,
    0xed8d,
    0xed8e,
    0xed8f,
    0xed90,
    0xed91
};
UINT16 cp936_UNI_a0x98[] = {
    0xed92,
    0xed93,
    0xed94,
    0xed95,
    0xed96,
    0xed97,
    0xed98,
    0xed99,
    0xed9a,
    0xed9b,
    0xed9c,
    0xed9d,
    0xed9e,
    0xed9f,
    0xeda0,
    0xee40,
    0xee41,
    0xee42,
    0xee43,
    0xee44,
    0xee45,
    0xee46,
    0xee47,
    0xee48,
    0xee49,
    0xee4a,
    0xee4b,
    0xee4c,
    0xee4d,
    0xee4e,
    0xee4f,
    0xee50,
    0xee51,
    0xee52,
    0xee53,
    0xee54,
    0xee55,
    0xee56,
    0xee57,
    0xee58,
    0xee59,
    0xee5a,
    0xee5b,
    0xee5c,
    0xee5d,
    0xee5e,
    0xee5f,
    0xee60,
    0xee61,
    0xee62,
    0xee63,
    0xee64,
    0xee65,
    0xee66,
    0xee67,
    0xee68,
    0xee69,
    0xee6a,
    0xee6b,
    0xee6c,
    0xee6d,
    0xee6e,
    0xee6f,
    0xee70,
    0xee71,
    0xee72,
    0xee73,
    0xee74,
    0xee75,
    0xee76,
    0xee77,
    0xee78,
    0xee79,
    0xee7a,
    0xee7b,
    0xee7c,
    0xee7d,
    0xee7e,
    0xee80,
    0xee81,
    0xee82,
    0xee83,
    0xee84,
    0xee85,
    0xee86,
    0xee87,
    0xee88,
    0xee89,
    0xee8a,
    0xee8b,
    0xee8c,
    0xee8d,
    0xee8e,
    0xee8f,
    0xee90,
    0xee91,
    0xee92,
    0xee93,
    0xee94,
    0xee95,
    0xee96,
    0xee97,
    0xee98,
    0xee99,
    0xee9a,
    0xee9b,
    0xee9c,
    0xee9d,
    0xee9e,
    0xee9f,
    0xeea0,
    0xef40,
    0xef41,
    0xef42,
    0xef43,
    0xef44,
    0xef45,
    0xd2b3,
    0xb6a5,
    0xc7ea,
    0xf1fc,
    0xcfee,
    0xcbb3,
    0xd0eb,
    0xe7ef,
    0xcde7,
    0xb9cb,
    0xb6d9,
    0xf1fd,
    0xb0e4,
    0xcbcc,
    0xf1fe,
    0xd4a4,
    0xc2ad,
    0xc1ec,
    0xc6c4,
    0xbeb1,
    0xf2a1,
    0xbcd5,
    0xef46,
    0xf2a2,
    0xf2a3,
    0xef47,
    0xf2a4,
    0xd2c3,
    0xc6b5,
    0xef48,
    0xcdc7,
    0xf2a5,
    0xef49,
    0xd3b1,
    0xbfc5,
    0xcce2,
    0xef4a,
    0xf2a6,
    0xf2a7,
    0xd1d5,
    0xb6ee,
    0xf2a8,
    0xf2a9,
    0xb5df,
    0xf2aa,
    0xf2ab,
    0xef4b,
    0xb2fc,
    0xf2ac,
    0xf2ad,
    0xc8a7,
    0xef4c,
    0xef4d,
    0xef4e,
    0xef4f,
    0xef50,
    0xef51,
    0xef52,
    0xef53,
    0xef54,
    0xef55,
    0xef56,
    0xef57,
    0xef58,
    0xef59,
    0xef5a,
    0xef5b,
    0xef5c,
    0xef5d,
    0xef5e,
    0xef5f,
    0xef60,
    0xef61,
    0xef62,
    0xef63,
    0xef64,
    0xef65,
    0xef66,
    0xef67,
    0xef68,
    0xef69,
    0xef6a,
    0xef6b,
    0xef6c,
    0xef6d,
    0xef6e,
    0xef6f,
    0xef70,
    0xef71,
    0xb7e7,
    0xef72,
    0xef73,
    0xeca9,
    0xecaa,
    0xecab,
    0xef74,
    0xecac,
    0xef75,
    0xef76,
    0xc6ae,
    0xecad,
    0xecae,
    0xef77,
    0xef78,
    0xef79,
    0xb7c9,
    0xcab3,
    0xef7a,
    0xef7b,
    0xef7c,
    0xef7d,
    0xef7e,
    0xef80,
    0xef81,
    0xe2b8,
    0xf7cf,
    0xef82,
    0xef83,
    0xef84,
    0xef85,
    0xef86,
    0xef87,
    0xef88,
    0xef89,
    0xef8a,
    0xef8b,
    0xef8c,
    0xef8d,
    0xef8e,
    0xef8f,
    0xef90,
    0xef91,
    0xef92,
    0xef93,
    0xef94,
    0xef95,
    0xef96,
    0xef97,
    0xef98
};
UINT16 cp936_UNI_a0x99[] = {
    0xef99,
    0xef9a,
    0xef9b,
    0xef9c,
    0xef9d,
    0xef9e,
    0xef9f,
    0xefa0,
    0xf040,
    0xf041,
    0xf042,
    0xf043,
    0xf044,
    0xf7d0,
    0xf045,
    0xf046,
    0xb2cd,
    0xf047,
    0xf048,
    0xf049,
    0xf04a,
    0xf04b,
    0xf04c,
    0xf04d,
    0xf04e,
    0xf04f,
    0xf050,
    0xf051,
    0xf052,
    0xf053,
    0xf054,
    0xf055,
    0xf056,
    0xf057,
    0xf058,
    0xf059,
    0xf05a,
    0xf05b,
    0xf05c,
    0xf05d,
    0xf05e,
    0xf05f,
    0xf060,
    0xf061,
    0xf062,
    0xf063,
    0xf7d1,
    0xf064,
    0xf065,
    0xf066,
    0xf067,
    0xf068,
    0xf069,
    0xf06a,
    0xf06b,
    0xf06c,
    0xf06d,
    0xf06e,
    0xf06f,
    0xf070,
    0xf071,
    0xf072,
    0xf073,
    0xf074,
    0xf075,
    0xf076,
    0xf077,
    0xf078,
    0xf079,
    0xf07a,
    0xf07b,
    0xf07c,
    0xf07d,
    0xf07e,
    0xf080,
    0xf081,
    0xf082,
    0xf083,
    0xf084,
    0xf085,
    0xf086,
    0xf087,
    0xf088,
    0xf089,
    0xf7d3,
    0xf7d2,
    0xf08a,
    0xf08b,
    0xf08c,
    0xf08d,
    0xf08e,
    0xf08f,
    0xf090,
    0xf091,
    0xf092,
    0xf093,
    0xf094,
    0xf095,
    0xf096,
    0xe2bb,
    0xf097,
    0xbca2,
    0xf098,
    0xe2bc,
    0xe2bd,
    0xe2be,
    0xe2bf,
    0xe2c0,
    0xe2c1,
    0xb7b9,
    0xd2fb,
    0xbda4,
    0xcace,
    0xb1a5,
    0xcbc7,
    0xf099,
    0xe2c2,
    0xb6fc,
    0xc8c4,
    0xe2c3,
    0xf09a,
    0xf09b,
    0xbdc8,
    0xf09c,
    0xb1fd,
    0xe2c4,
    0xf09d,
    0xb6f6,
    0xe2c5,
    0xc4d9,
    0xf09e,
    0xf09f,
    0xe2c6,
    0xcfda,
    0xb9dd,
    0xe2c7,
    0xc0a1,
    0xf0a0,
    0xe2c8,
    0xb2f6,
    0xf140,
    0xe2c9,
    0xf141,
    0xc1f3,
    0xe2ca,
    0xe2cb,
    0xc2f8,
    0xe2cc,
    0xe2cd,
    0xe2ce,
    0xcad7,
    0xd8b8,
    0xd9e5,
    0xcfe3,
    0xf142,
    0xf143,
    0xf144,
    0xf145,
    0xf146,
    0xf147,
    0xf148,
    0xf149,
    0xf14a,
    0xf14b,
    0xf14c,
    0xf0a5,
    0xf14d,
    0xf14e,
    0xdcb0,
    0xf14f,
    0xf150,
    0xf151,
    0xf152,
    0xf153,
    0xf154,
    0xf155,
    0xf156,
    0xf157,
    0xf158,
    0xf159,
    0xf15a,
    0xf15b,
    0xf15c,
    0xf15d,
    0xf15e,
    0xf15f,
    0xf160,
    0xf161,
    0xf162,
    0xf163,
    0xf164,
    0xf165,
    0xf166,
    0xf167,
    0xf168,
    0xf169,
    0xf16a,
    0xf16b,
    0xf16c,
    0xf16d,
    0xf16e,
    0xf16f,
    0xf170,
    0xf171,
    0xf172,
    0xf173,
    0xf174,
    0xf175,
    0xf176,
    0xf177,
    0xf178,
    0xf179,
    0xf17a,
    0xf17b,
    0xf17c,
    0xf17d,
    0xf17e,
    0xf180,
    0xf181,
    0xf182,
    0xf183,
    0xf184,
    0xf185,
    0xf186,
    0xf187,
    0xf188,
    0xf189,
    0xf18a,
    0xf18b,
    0xf18c,
    0xf18d,
    0xf18e,
    0xf18f,
    0xf190,
    0xf191,
    0xf192,
    0xf193,
    0xf194,
    0xf195,
    0xf196,
    0xf197,
    0xf198,
    0xf199,
    0xf19a,
    0xf19b,
    0xf19c,
    0xf19d,
    0xf19e,
    0xf19f,
    0xf1a0,
    0xf240,
    0xf241,
    0xf242,
    0xf243,
    0xf244,
    0xf245
};
UINT16 cp936_UNI_a0x9a[] = {
    0xf246,
    0xf247,
    0xf248,
    0xf249,
    0xf24a,
    0xf24b,
    0xf24c,
    0xf24d,
    0xf24e,
    0xf24f,
    0xf250,
    0xf251,
    0xf252,
    0xf253,
    0xf254,
    0xf255,
    0xf256,
    0xf257,
    0xf258,
    0xf259,
    0xf25a,
    0xf25b,
    0xf25c,
    0xf25d,
    0xf25e,
    0xf25f,
    0xf260,
    0xf261,
    0xf262,
    0xf263,
    0xf264,
    0xf265,
    0xf266,
    0xf267,
    0xf268,
    0xf269,
    0xf26a,
    0xf26b,
    0xf26c,
    0xf26d,
    0xf26e,
    0xf26f,
    0xf270,
    0xf271,
    0xf272,
    0xf273,
    0xf274,
    0xf275,
    0xf276,
    0xf277,
    0xf278,
    0xf279,
    0xf27a,
    0xf27b,
    0xf27c,
    0xf27d,
    0xf27e,
    0xf280,
    0xf281,
    0xf282,
    0xf283,
    0xf284,
    0xf285,
    0xf286,
    0xf287,
    0xf288,
    0xf289,
    0xf28a,
    0xf28b,
    0xf28c,
    0xf28d,
    0xf28e,
    0xf28f,
    0xf290,
    0xf291,
    0xf292,
    0xf293,
    0xf294,
    0xf295,
    0xf296,
    0xf297,
    0xf298,
    0xf299,
    0xf29a,
    0xf29b,
    0xf29c,
    0xf29d,
    0xf29e,
    0xf29f,
    0xf2a0,
    0xf340,
    0xf341,
    0xf342,
    0xf343,
    0xf344,
    0xf345,
    0xf346,
    0xf347,
    0xf348,
    0xf349,
    0xf34a,
    0xf34b,
    0xf34c,
    0xf34d,
    0xf34e,
    0xf34f,
    0xf350,
    0xf351,
    0xc2ed,
    0xd4a6,
    0xcdd4,
    0xd1b1,
    0xb3db,
    0xc7fd,
    0xf352,
    0xb2b5,
    0xc2bf,
    0xe6e0,
    0xcabb,
    0xe6e1,
    0xe6e2,
    0xbed4,
    0xe6e3,
    0xd7a4,
    0xcdd5,
    0xe6e5,
    0xbcdd,
    0xe6e4,
    0xe6e6,
    0xe6e7,
    0xc2ee,
    0xf353,
    0xbdbe,
    0xe6e8,
    0xc2e6,
    0xbaa7,
    0xe6e9,
    0xf354,
    0xe6ea,
    0xb3d2,
    0xd1e9,
    0xf355,
    0xf356,
    0xbfa5,
    0xe6eb,
    0xc6ef,
    0xe6ec,
    0xe6ed,
    0xf357,
    0xf358,
    0xe6ee,
    0xc6ad,
    0xe6ef,
    0xf359,
    0xc9a7,
    0xe6f0,
    0xe6f1,
    0xe6f2,
    0xe5b9,
    0xe6f3,
    0xe6f4,
    0xc2e2,
    0xe6f5,
    0xe6f6,
    0xd6e8,
    0xe6f7,
    0xf35a,
    0xe6f8,
    0xb9c7,
    0xf35b,
    0xf35c,
    0xf35d,
    0xf35e,
    0xf35f,
    0xf360,
    0xf361,
    0xf7bb,
    0xf7ba,
    0xf362,
    0xf363,
    0xf364,
    0xf365,
    0xf7be,
    0xf7bc,
    0xbaa1,
    0xf366,
    0xf7bf,
    0xf367,
    0xf7c0,
    0xf368,
    0xf369,
    0xf36a,
    0xf7c2,
    0xf7c1,
    0xf7c4,
    0xf36b,
    0xf36c,
    0xf7c3,
    0xf36d,
    0xf36e,
    0xf36f,
    0xf370,
    0xf371,
    0xf7c5,
    0xf7c6,
    0xf372,
    0xf373,
    0xf374,
    0xf375,
    0xf7c7,
    0xf376,
    0xcbe8,
    0xf377,
    0xf378,
    0xf379,
    0xf37a,
    0xb8df,
    0xf37b,
    0xf37c,
    0xf37d,
    0xf37e,
    0xf380,
    0xf381,
    0xf7d4,
    0xf382,
    0xf7d5,
    0xf383,
    0xf384,
    0xf385,
    0xf386,
    0xf7d6,
    0xf387,
    0xf388,
    0xf389,
    0xf38a,
    0xf7d8,
    0xf38b,
    0xf7da,
    0xf38c,
    0xf7d7,
    0xf38d,
    0xf38e,
    0xf38f,
    0xf390,
    0xf391,
    0xf392,
    0xf393,
    0xf394,
    0xf395,
    0xf7db,
    0xf396,
    0xf7d9,
    0xf397,
    0xf398,
    0xf399,
    0xf39a
};
UINT16 cp936_UNI_a0x9b[] = {
    0xf39b,
    0xf39c,
    0xf39d,
    0xd7d7,
    0xf39e,
    0xf39f,
    0xf3a0,
    0xf440,
    0xf7dc,
    0xf441,
    0xf442,
    0xf443,
    0xf444,
    0xf445,
    0xf446,
    0xf7dd,
    0xf447,
    0xf448,
    0xf449,
    0xf7de,
    0xf44a,
    0xf44b,
    0xf44c,
    0xf44d,
    0xf44e,
    0xf44f,
    0xf450,
    0xf451,
    0xf452,
    0xf453,
    0xf454,
    0xf7df,
    0xf455,
    0xf456,
    0xf457,
    0xf7e0,
    0xf458,
    0xf459,
    0xf45a,
    0xf45b,
    0xf45c,
    0xf45d,
    0xf45e,
    0xf45f,
    0xf460,
    0xf461,
    0xf462,
    0xdbcb,
    0xf463,
    0xf464,
    0xd8aa,
    0xf465,
    0xf466,
    0xf467,
    0xf468,
    0xf469,
    0xf46a,
    0xf46b,
    0xf46c,
    0xe5f7,
    0xb9ed,
    0xf46d,
    0xf46e,
    0xf46f,
    0xf470,
    0xbffd,
    0xbbea,
    0xf7c9,
    0xc6c7,
    0xf7c8,
    0xf471,
    0xf7ca,
    0xf7cc,
    0xf7cb,
    0xf472,
    0xf473,
    0xf474,
    0xf7cd,
    0xf475,
    0xceba,
    0xf476,
    0xf7ce,
    0xf477,
    0xf478,
    0xc4a7,
    0xf479,
    0xf47a,
    0xf47b,
    0xf47c,
    0xf47d,
    0xf47e,
    0xf480,
    0xf481,
    0xf482,
    0xf483,
    0xf484,
    0xf485,
    0xf486,
    0xf487,
    0xf488,
    0xf489,
    0xf48a,
    0xf48b,
    0xf48c,
    0xf48d,
    0xf48e,
    0xf48f,
    0xf490,
    0xf491,
    0xf492,
    0xf493,
    0xf494,
    0xf495,
    0xf496,
    0xf497,
    0xf498,
    0xf499,
    0xf49a,
    0xf49b,
    0xf49c,
    0xf49d,
    0xf49e,
    0xf49f,
    0xf4a0,
    0xf540,
    0xf541,
    0xf542,
    0xf543,
    0xf544,
    0xf545,
    0xf546,
    0xf547,
    0xf548,
    0xf549,
    0xf54a,
    0xf54b,
    0xf54c,
    0xf54d,
    0xf54e,
    0xf54f,
    0xf550,
    0xf551,
    0xf552,
    0xf553,
    0xf554,
    0xf555,
    0xf556,
    0xf557,
    0xf558,
    0xf559,
    0xf55a,
    0xf55b,
    0xf55c,
    0xf55d,
    0xf55e,
    0xf55f,
    0xf560,
    0xf561,
    0xf562,
    0xf563,
    0xf564,
    0xf565,
    0xf566,
    0xf567,
    0xf568,
    0xf569,
    0xf56a,
    0xf56b,
    0xf56c,
    0xf56d,
    0xf56e,
    0xf56f,
    0xf570,
    0xf571,
    0xf572,
    0xf573,
    0xf574,
    0xf575,
    0xf576,
    0xf577,
    0xf578,
    0xf579,
    0xf57a,
    0xf57b,
    0xf57c,
    0xf57d,
    0xf57e,
    0xf580,
    0xf581,
    0xf582,
    0xf583,
    0xf584,
    0xf585,
    0xf586,
    0xf587,
    0xf588,
    0xf589,
    0xf58a,
    0xf58b,
    0xf58c,
    0xf58d,
    0xf58e,
    0xf58f,
    0xf590,
    0xf591,
    0xf592,
    0xf593,
    0xf594,
    0xf595,
    0xf596,
    0xf597,
    0xf598,
    0xf599,
    0xf59a,
    0xf59b,
    0xf59c,
    0xf59d,
    0xf59e,
    0xf59f,
    0xf5a0,
    0xf640,
    0xf641,
    0xf642,
    0xf643,
    0xf644,
    0xf645,
    0xf646,
    0xf647,
    0xf648,
    0xf649,
    0xf64a,
    0xf64b,
    0xf64c,
    0xf64d,
    0xf64e,
    0xf64f,
    0xf650,
    0xf651,
    0xf652,
    0xf653,
    0xf654,
    0xf655,
    0xf656,
    0xf657,
    0xf658,
    0xf659,
    0xf65a,
    0xf65b,
    0xf65c,
    0xf65d,
    0xf65e,
    0xf65f,
    0xf660,
    0xf661,
    0xf662,
    0xf663
};
UINT16 cp936_UNI_a0x9c[] = {
    0xf664,
    0xf665,
    0xf666,
    0xf667,
    0xf668,
    0xf669,
    0xf66a,
    0xf66b,
    0xf66c,
    0xf66d,
    0xf66e,
    0xf66f,
    0xf670,
    0xf671,
    0xf672,
    0xf673,
    0xf674,
    0xf675,
    0xf676,
    0xf677,
    0xf678,
    0xf679,
    0xf67a,
    0xf67b,
    0xf67c,
    0xf67d,
    0xf67e,
    0xf680,
    0xf681,
    0xf682,
    0xf683,
    0xf684,
    0xf685,
    0xf686,
    0xf687,
    0xf688,
    0xf689,
    0xf68a,
    0xf68b,
    0xf68c,
    0xf68d,
    0xf68e,
    0xf68f,
    0xf690,
    0xf691,
    0xf692,
    0xf693,
    0xf694,
    0xf695,
    0xf696,
    0xf697,
    0xf698,
    0xf699,
    0xf69a,
    0xf69b,
    0xf69c,
    0xf69d,
    0xf69e,
    0xf69f,
    0xf6a0,
    0xf740,
    0xf741,
    0xf742,
    0xf743,
    0xf744,
    0xf745,
    0xf746,
    0xf747,
    0xf748,
    0xf749,
    0xf74a,
    0xf74b,
    0xf74c,
    0xf74d,
    0xf74e,
    0xf74f,
    0xf750,
    0xf751,
    0xf752,
    0xf753,
    0xf754,
    0xf755,
    0xf756,
    0xf757,
    0xf758,
    0xf759,
    0xf75a,
    0xf75b,
    0xf75c,
    0xf75d,
    0xf75e,
    0xf75f,
    0xf760,
    0xf761,
    0xf762,
    0xf763,
    0xf764,
    0xf765,
    0xf766,
    0xf767,
    0xf768,
    0xf769,
    0xf76a,
    0xf76b,
    0xf76c,
    0xf76d,
    0xf76e,
    0xf76f,
    0xf770,
    0xf771,
    0xf772,
    0xf773,
    0xf774,
    0xf775,
    0xf776,
    0xf777,
    0xf778,
    0xf779,
    0xf77a,
    0xf77b,
    0xf77c,
    0xf77d,
    0xf77e,
    0xf780,
    0xd3e3,
    0xf781,
    0xf782,
    0xf6cf,
    0xf783,
    0xc2b3,
    0xf6d0,
    0xf784,
    0xf785,
    0xf6d1,
    0xf6d2,
    0xf6d3,
    0xf6d4,
    0xf786,
    0xf787,
    0xf6d6,
    0xf788,
    0xb1ab,
    0xf6d7,
    0xf789,
    0xf6d8,
    0xf6d9,
    0xf6da,
    0xf78a,
    0xf6db,
    0xf6dc,
    0xf78b,
    0xf78c,
    0xf78d,
    0xf78e,
    0xf6dd,
    0xf6de,
    0xcfca,
    0xf78f,
    0xf6df,
    0xf6e0,
    0xf6e1,
    0xf6e2,
    0xf6e3,
    0xf6e4,
    0xc0f0,
    0xf6e5,
    0xf6e6,
    0xf6e7,
    0xf6e8,
    0xf6e9,
    0xf790,
    0xf6ea,
    0xf791,
    0xf6eb,
    0xf6ec,
    0xf792,
    0xf6ed,
    0xf6ee,
    0xf6ef,
    0xf6f0,
    0xf6f1,
    0xf6f2,
    0xf6f3,
    0xf6f4,
    0xbea8,
    0xf793,
    0xf6f5,
    0xf6f6,
    0xf6f7,
    0xf6f8,
    0xf794,
    0xf795,
    0xf796,
    0xf797,
    0xf798,
    0xc8fa,
    0xf6f9,
    0xf6fa,
    0xf6fb,
    0xf6fc,
    0xf799,
    0xf79a,
    0xf6fd,
    0xf6fe,
    0xf7a1,
    0xf7a2,
    0xf7a3,
    0xf7a4,
    0xf7a5,
    0xf79b,
    0xf79c,
    0xf7a6,
    0xf7a7,
    0xf7a8,
    0xb1ee,
    0xf7a9,
    0xf7aa,
    0xf7ab,
    0xf79d,
    0xf79e,
    0xf7ac,
    0xf7ad,
    0xc1db,
    0xf7ae,
    0xf79f,
    0xf7a0,
    0xf7af,
    0xf840,
    0xf841,
    0xf842,
    0xf843,
    0xf844,
    0xf845,
    0xf846,
    0xf847,
    0xf848,
    0xf849,
    0xf84a,
    0xf84b,
    0xf84c,
    0xf84d,
    0xf84e,
    0xf84f,
    0xf850,
    0xf851,
    0xf852,
    0xf853,
    0xf854,
    0xf855,
    0xf856,
    0xf857,
    0xf858,
    0xf859,
    0xf85a,
    0xf85b,
    0xf85c
};
UINT16 cp936_UNI_a0x9d[] = {
    0xf85d,
    0xf85e,
    0xf85f,
    0xf860,
    0xf861,
    0xf862,
    0xf863,
    0xf864,
    0xf865,
    0xf866,
    0xf867,
    0xf868,
    0xf869,
    0xf86a,
    0xf86b,
    0xf86c,
    0xf86d,
    0xf86e,
    0xf86f,
    0xf870,
    0xf871,
    0xf872,
    0xf873,
    0xf874,
    0xf875,
    0xf876,
    0xf877,
    0xf878,
    0xf879,
    0xf87a,
    0xf87b,
    0xf87c,
    0xf87d,
    0xf87e,
    0xf880,
    0xf881,
    0xf882,
    0xf883,
    0xf884,
    0xf885,
    0xf886,
    0xf887,
    0xf888,
    0xf889,
    0xf88a,
    0xf88b,
    0xf88c,
    0xf88d,
    0xf88e,
    0xf88f,
    0xf890,
    0xf891,
    0xf892,
    0xf893,
    0xf894,
    0xf895,
    0xf896,
    0xf897,
    0xf898,
    0xf899,
    0xf89a,
    0xf89b,
    0xf89c,
    0xf89d,
    0xf89e,
    0xf89f,
    0xf8a0,
    0xf940,
    0xf941,
    0xf942,
    0xf943,
    0xf944,
    0xf945,
    0xf946,
    0xf947,
    0xf948,
    0xf949,
    0xf94a,
    0xf94b,
    0xf94c,
    0xf94d,
    0xf94e,
    0xf94f,
    0xf950,
    0xf951,
    0xf952,
    0xf953,
    0xf954,
    0xf955,
    0xf956,
    0xf957,
    0xf958,
    0xf959,
    0xf95a,
    0xf95b,
    0xf95c,
    0xf95d,
    0xf95e,
    0xf95f,
    0xf960,
    0xf961,
    0xf962,
    0xf963,
    0xf964,
    0xf965,
    0xf966,
    0xf967,
    0xf968,
    0xf969,
    0xf96a,
    0xf96b,
    0xf96c,
    0xf96d,
    0xf96e,
    0xf96f,
    0xf970,
    0xf971,
    0xf972,
    0xf973,
    0xf974,
    0xf975,
    0xf976,
    0xf977,
    0xf978,
    0xf979,
    0xf97a,
    0xf97b,
    0xf97c,
    0xf97d,
    0xf97e,
    0xf980,
    0xf981,
    0xf982,
    0xf983,
    0xf984,
    0xf985,
    0xf986,
    0xf987,
    0xf988,
    0xf989,
    0xf98a,
    0xf98b,
    0xf98c,
    0xf98d,
    0xf98e,
    0xf98f,
    0xf990,
    0xf991,
    0xf992,
    0xf993,
    0xf994,
    0xf995,
    0xf996,
    0xf997,
    0xf998,
    0xf999,
    0xf99a,
    0xf99b,
    0xf99c,
    0xf99d,
    0xf99e,
    0xf99f,
    0xf9a0,
    0xfa40,
    0xfa41,
    0xfa42,
    0xfa43,
    0xfa44,
    0xfa45,
    0xfa46,
    0xfa47,
    0xfa48,
    0xfa49,
    0xfa4a,
    0xfa4b,
    0xfa4c,
    0xfa4d,
    0xfa4e,
    0xfa4f,
    0xfa50,
    0xfa51,
    0xfa52,
    0xfa53,
    0xfa54,
    0xfa55,
    0xfa56,
    0xfa57,
    0xfa58,
    0xfa59,
    0xfa5a,
    0xfa5b,
    0xfa5c,
    0xfa5d,
    0xfa5e,
    0xfa5f,
    0xfa60,
    0xfa61,
    0xfa62,
    0xfa63,
    0xfa64,
    0xfa65,
    0xfa66,
    0xfa67,
    0xfa68,
    0xfa69,
    0xfa6a,
    0xfa6b,
    0xfa6c,
    0xfa6d,
    0xfa6e,
    0xfa6f,
    0xfa70,
    0xfa71,
    0xfa72,
    0xfa73,
    0xfa74,
    0xfa75,
    0xfa76,
    0xfa77,
    0xfa78,
    0xfa79,
    0xfa7a,
    0xfa7b,
    0xfa7c,
    0xfa7d,
    0xfa7e,
    0xfa80,
    0xfa81,
    0xfa82,
    0xfa83,
    0xfa84,
    0xfa85,
    0xfa86,
    0xfa87,
    0xfa88,
    0xfa89,
    0xfa8a,
    0xfa8b,
    0xfa8c,
    0xfa8d,
    0xfa8e,
    0xfa8f,
    0xfa90,
    0xfa91,
    0xfa92,
    0xfa93,
    0xfa94,
    0xfa95,
    0xfa96,
    0xfa97,
    0xfa98,
    0xfa99,
    0xfa9a,
    0xfa9b,
    0xfa9c,
    0xfa9d
};
UINT16 cp936_UNI_a0x9e[] = {
    0xfa9e,
    0xfa9f,
    0xfaa0,
    0xfb40,
    0xfb41,
    0xfb42,
    0xfb43,
    0xfb44,
    0xfb45,
    0xfb46,
    0xfb47,
    0xfb48,
    0xfb49,
    0xfb4a,
    0xfb4b,
    0xfb4c,
    0xfb4d,
    0xfb4e,
    0xfb4f,
    0xfb50,
    0xfb51,
    0xfb52,
    0xfb53,
    0xfb54,
    0xfb55,
    0xfb56,
    0xfb57,
    0xfb58,
    0xfb59,
    0xfb5a,
    0xfb5b,
    0xc4f1,
    0xf0af,
    0xbca6,
    0xf0b0,
    0xc3f9,
    0xfb5c,
    0xc5b8,
    0xd1bb,
    0xfb5d,
    0xf0b1,
    0xf0b2,
    0xf0b3,
    0xf0b4,
    0xf0b5,
    0xd1bc,
    0xfb5e,
    0xd1ec,
    0xfb5f,
    0xf0b7,
    0xf0b6,
    0xd4a7,
    0xfb60,
    0xcdd2,
    0xf0b8,
    0xf0ba,
    0xf0b9,
    0xf0bb,
    0xf0bc,
    0xfb61,
    0xfb62,
    0xb8eb,
    0xf0bd,
    0xbae8,
    0xfb63,
    0xf0be,
    0xf0bf,
    0xbee9,
    0xf0c0,
    0xb6ec,
    0xf0c1,
    0xf0c2,
    0xf0c3,
    0xf0c4,
    0xc8b5,
    0xf0c5,
    0xf0c6,
    0xfb64,
    0xf0c7,
    0xc5f4,
    0xfb65,
    0xf0c8,
    0xfb66,
    0xfb67,
    0xfb68,
    0xf0c9,
    0xfb69,
    0xf0ca,
    0xf7bd,
    0xfb6a,
    0xf0cb,
    0xf0cc,
    0xf0cd,
    0xfb6b,
    0xf0ce,
    0xfb6c,
    0xfb6d,
    0xfb6e,
    0xfb6f,
    0xf0cf,
    0xbad7,
    0xfb70,
    0xf0d0,
    0xf0d1,
    0xf0d2,
    0xf0d3,
    0xf0d4,
    0xf0d5,
    0xf0d6,
    0xf0d8,
    0xfb71,
    0xfb72,
    0xd3a5,
    0xf0d7,
    0xfb73,
    0xf0d9,
    0xfb74,
    0xfb75,
    0xfb76,
    0xfb77,
    0xfb78,
    0xfb79,
    0xfb7a,
    0xfb7b,
    0xfb7c,
    0xfb7d,
    0xf5ba,
    0xc2b9,
    0xfb7e,
    0xfb80,
    0xf7e4,
    0xfb81,
    0xfb82,
    0xfb83,
    0xfb84,
    0xf7e5,
    0xf7e6,
    0xfb85,
    0xfb86,
    0xf7e7,
    0xfb87,
    0xfb88,
    0xfb89,
    0xfb8a,
    0xfb8b,
    0xfb8c,
    0xf7e8,
    0xc2b4,
    0xfb8d,
    0xfb8e,
    0xfb8f,
    0xfb90,
    0xfb91,
    0xfb92,
    0xfb93,
    0xfb94,
    0xfb95,
    0xf7ea,
    0xfb96,
    0xf7eb,
    0xfb97,
    0xfb98,
    0xfb99,
    0xfb9a,
    0xfb9b,
    0xfb9c,
    0xc2f3,
    0xfb9d,
    0xfb9e,
    0xfb9f,
    0xfba0,
    0xfc40,
    0xfc41,
    0xfc42,
    0xfc43,
    0xfc44,
    0xfc45,
    0xfc46,
    0xfc47,
    0xfc48,
    0xf4f0,
    0xfc49,
    0xfc4a,
    0xfc4b,
    0xf4ef,
    0xfc4c,
    0xfc4d,
    0xc2e9,
    0xfc4e,
    0xf7e1,
    0xf7e2,
    0xfc4f,
    0xfc50,
    0xfc51,
    0xfc52,
    0xfc53,
    0xbbc6,
    0xfc54,
    0xfc55,
    0xfc56,
    0xfc57,
    0xd9e4,
    0xfc58,
    0xfc59,
    0xfc5a,
    0xcaf2,
    0xc0e8,
    0xf0a4,
    0xfc5b,
    0xbada,
    0xfc5c,
    0xfc5d,
    0xc7ad,
    0xfc5e,
    0xfc5f,
    0xfc60,
    0xc4ac,
    0xfc61,
    0xfc62,
    0xf7ec,
    0xf7ed,
    0xf7ee,
    0xfc63,
    0xf7f0,
    0xf7ef,
    0xfc64,
    0xf7f1,
    0xfc65,
    0xfc66,
    0xf7f4,
    0xfc67,
    0xf7f3,
    0xfc68,
    0xf7f2,
    0xf7f5,
    0xfc69,
    0xfc6a,
    0xfc6b,
    0xfc6c,
    0xf7f6,
    0xfc6d,
    0xfc6e,
    0xfc6f,
    0xfc70,
    0xfc71,
    0xfc72,
    0xfc73,
    0xfc74,
    0xfc75,
    0xede9,
    0xfc76,
    0xedea,
    0xedeb,
    0xfc77,
    0xf6bc,
    0xfc78
};
UINT16 cp936_UNI_a0x9f[] = {
    0xfc79,
    0xfc7a,
    0xfc7b,
    0xfc7c,
    0xfc7d,
    0xfc7e,
    0xfc80,
    0xfc81,
    0xfc82,
    0xfc83,
    0xfc84,
    0xf6bd,
    0xfc85,
    0xf6be,
    0xb6a6,
    0xfc86,
    0xd8be,
    0xfc87,
    0xfc88,
    0xb9c4,
    0xfc89,
    0xfc8a,
    0xfc8b,
    0xd8bb,
    0xfc8c,
    0xdcb1,
    0xfc8d,
    0xfc8e,
    0xfc8f,
    0xfc90,
    0xfc91,
    0xfc92,
    0xcaf3,
    0xfc93,
    0xf7f7,
    0xfc94,
    0xfc95,
    0xfc96,
    0xfc97,
    0xfc98,
    0xfc99,
    0xfc9a,
    0xfc9b,
    0xfc9c,
    0xf7f8,
    0xfc9d,
    0xfc9e,
    0xf7f9,
    0xfc9f,
    0xfca0,
    0xfd40,
    0xfd41,
    0xfd42,
    0xfd43,
    0xfd44,
    0xf7fb,
    0xfd45,
    0xf7fa,
    0xfd46,
    0xb1c7,
    0xfd47,
    0xf7fc,
    0xf7fd,
    0xfd48,
    0xfd49,
    0xfd4a,
    0xfd4b,
    0xfd4c,
    0xf7fe,
    0xfd4d,
    0xfd4e,
    0xfd4f,
    0xfd50,
    0xfd51,
    0xfd52,
    0xfd53,
    0xfd54,
    0xfd55,
    0xfd56,
    0xfd57,
    0xc6eb,
    0xecb4,
    0xfd58,
    0xfd59,
    0xfd5a,
    0xfd5b,
    0xfd5c,
    0xfd5d,
    0xfd5e,
    0xfd5f,
    0xfd60,
    0xfd61,
    0xfd62,
    0xfd63,
    0xfd64,
    0xfd65,
    0xfd66,
    0xfd67,
    0xfd68,
    0xfd69,
    0xfd6a,
    0xfd6b,
    0xfd6c,
    0xfd6d,
    0xfd6e,
    0xfd6f,
    0xfd70,
    0xfd71,
    0xfd72,
    0xfd73,
    0xfd74,
    0xfd75,
    0xfd76,
    0xfd77,
    0xfd78,
    0xfd79,
    0xfd7a,
    0xfd7b,
    0xfd7c,
    0xfd7d,
    0xfd7e,
    0xfd80,
    0xfd81,
    0xfd82,
    0xfd83,
    0xfd84,
    0xfd85,
    0xb3dd,
    0xf6b3,
    0xfd86,
    0xfd87,
    0xf6b4,
    0xc1e4,
    0xf6b5,
    0xf6b6,
    0xf6b7,
    0xf6b8,
    0xf6b9,
    0xf6ba,
    0xc8a3,
    0xf6bb,
    0xfd88,
    0xfd89,
    0xfd8a,
    0xfd8b,
    0xfd8c,
    0xfd8d,
    0xfd8e,
    0xfd8f,
    0xfd90,
    0xfd91,
    0xfd92,
    0xfd93,
    0xc1fa,
    0xb9a8,
    0xede8,
    0xfd94,
    0xfd95,
    0xfd96,
    0xb9ea,
    0xd9df,
    0xfd97,
    0xfd98,
    0xfd99,
    0xfd9a,
    0xfd9b,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL
};
UINT16 cp936_UNI_a0xf9[] = {
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xfd9c,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xfd9d,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xfd9e,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xfd9f,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xfda0,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL
};
UINT16 cp936_UNI_a0xfa[] = {
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xfe40,
    0xfe41,
    0xfe42,
    0xfe43,
    CP936_UNI_VAL_NULL,
    0xfe44,
    CP936_UNI_VAL_NULL,
    0xfe45,
    0xfe46,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xfe47,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xfe48,
    0xfe49,
    0xfe4a,
    CP936_UNI_VAL_NULL,
    0xfe4b,
    0xfe4c,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xfe4d,
    0xfe4e,
    0xfe4f,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL
};
UINT16 cp936_UNI_a0xfe[] = {
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa955,
    0xa6f2,
    CP936_UNI_VAL_NULL,
    0xa6f4,
    0xa6f5,
    0xa6e0,
    0xa6e1,
    0xa6f0,
    0xa6f1,
    0xa6e2,
    0xa6e3,
    0xa6ee,
    0xa6ef,
    0xa6e6,
    0xa6e7,
    0xa6e4,
    0xa6e5,
    0xa6e8,
    0xa6e9,
    0xa6ea,
    0xa6eb,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa968,
    0xa969,
    0xa96a,
    0xa96b,
    0xa96c,
    0xa96d,
    0xa96e,
    0xa96f,
    0xa970,
    0xa971,
    CP936_UNI_VAL_NULL,
    0xa972,
    0xa973,
    0xa974,
    0xa975,
    CP936_UNI_VAL_NULL,
    0xa976,
    0xa977,
    0xa978,
    0xa979,
    0xa97a,
    0xa97b,
    0xa97c,
    0xa97d,
    0xa97e,
    0xa980,
    0xa981,
    0xa982,
    0xa983,
    0xa984,
    CP936_UNI_VAL_NULL,
    0xa985,
    0xa986,
    0xa987,
    0xa988,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL
};
UINT16 cp936_UNI_a0xff[] = {
    CP936_UNI_VAL_NULL,
    0xa3a1,
    0xa3a2,
    0xa3a3,
    0xa1e7,
    0xa3a5,
    0xa3a6,
    0xa3a7,
    0xa3a8,
    0xa3a9,
    0xa3aa,
    0xa3ab,
    0xa3ac,
    0xa3ad,
    0xa3ae,
    0xa3af,
    0xa3b0,
    0xa3b1,
    0xa3b2,
    0xa3b3,
    0xa3b4,
    0xa3b5,
    0xa3b6,
    0xa3b7,
    0xa3b8,
    0xa3b9,
    0xa3ba,
    0xa3bb,
    0xa3bc,
    0xa3bd,
    0xa3be,
    0xa3bf,
    0xa3c0,
    0xa3c1,
    0xa3c2,
    0xa3c3,
    0xa3c4,
    0xa3c5,
    0xa3c6,
    0xa3c7,
    0xa3c8,
    0xa3c9,
    0xa3ca,
    0xa3cb,
    0xa3cc,
    0xa3cd,
    0xa3ce,
    0xa3cf,
    0xa3d0,
    0xa3d1,
    0xa3d2,
    0xa3d3,
    0xa3d4,
    0xa3d5,
    0xa3d6,
    0xa3d7,
    0xa3d8,
    0xa3d9,
    0xa3da,
    0xa3db,
    0xa3dc,
    0xa3dd,
    0xa3de,
    0xa3df,
    0xa3e0,
    0xa3e1,
    0xa3e2,
    0xa3e3,
    0xa3e4,
    0xa3e5,
    0xa3e6,
    0xa3e7,
    0xa3e8,
    0xa3e9,
    0xa3ea,
    0xa3eb,
    0xa3ec,
    0xa3ed,
    0xa3ee,
    0xa3ef,
    0xa3f0,
    0xa3f1,
    0xa3f2,
    0xa3f3,
    0xa3f4,
    0xa3f5,
    0xa3f6,
    0xa3f7,
    0xa3f8,
    0xa3f9,
    0xa3fa,
    0xa3fb,
    0xa3fc,
    0xa3fd,
    0xa1ab,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    0xa1e9,
    0xa1ea,
    0xa956,
    0xa3fe,
    0xa957,
    0xa3a4,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL
};
VOID *cp936_UNI_idx[] = {
    &cp936_UNI_a0x0,
    &cp936_UNI_a0x1,
    &cp936_UNI_a0x2,
    &cp936_UNI_a0x3,
    &cp936_UNI_a0x4,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    &cp936_UNI_a0x20,
    &cp936_UNI_a0x21,
    &cp936_UNI_a0x22,
    &cp936_UNI_a0x23,
    &cp936_UNI_a0x24,
    &cp936_UNI_a0x25,
    &cp936_UNI_a0x26,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    &cp936_UNI_a0x30,
    &cp936_UNI_a0x31,
    &cp936_UNI_a0x32,
    &cp936_UNI_a0x33,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    &cp936_UNI_a0x4e,
    &cp936_UNI_a0x4f,
    &cp936_UNI_a0x50,
    &cp936_UNI_a0x51,
    &cp936_UNI_a0x52,
    &cp936_UNI_a0x53,
    &cp936_UNI_a0x54,
    &cp936_UNI_a0x55,
    &cp936_UNI_a0x56,
    &cp936_UNI_a0x57,
    &cp936_UNI_a0x58,
    &cp936_UNI_a0x59,
    &cp936_UNI_a0x5a,
    &cp936_UNI_a0x5b,
    &cp936_UNI_a0x5c,
    &cp936_UNI_a0x5d,
    &cp936_UNI_a0x5e,
    &cp936_UNI_a0x5f,
    &cp936_UNI_a0x60,
    &cp936_UNI_a0x61,
    &cp936_UNI_a0x62,
    &cp936_UNI_a0x63,
    &cp936_UNI_a0x64,
    &cp936_UNI_a0x65,
    &cp936_UNI_a0x66,
    &cp936_UNI_a0x67,
    &cp936_UNI_a0x68,
    &cp936_UNI_a0x69,
    &cp936_UNI_a0x6a,
    &cp936_UNI_a0x6b,
    &cp936_UNI_a0x6c,
    &cp936_UNI_a0x6d,
    &cp936_UNI_a0x6e,
    &cp936_UNI_a0x6f,
    &cp936_UNI_a0x70,
    &cp936_UNI_a0x71,
    &cp936_UNI_a0x72,
    &cp936_UNI_a0x73,
    &cp936_UNI_a0x74,
    &cp936_UNI_a0x75,
    &cp936_UNI_a0x76,
    &cp936_UNI_a0x77,
    &cp936_UNI_a0x78,
    &cp936_UNI_a0x79,
    &cp936_UNI_a0x7a,
    &cp936_UNI_a0x7b,
    &cp936_UNI_a0x7c,
    &cp936_UNI_a0x7d,
    &cp936_UNI_a0x7e,
    &cp936_UNI_a0x7f,
    &cp936_UNI_a0x80,
    &cp936_UNI_a0x81,
    &cp936_UNI_a0x82,
    &cp936_UNI_a0x83,
    &cp936_UNI_a0x84,
    &cp936_UNI_a0x85,
    &cp936_UNI_a0x86,
    &cp936_UNI_a0x87,
    &cp936_UNI_a0x88,
    &cp936_UNI_a0x89,
    &cp936_UNI_a0x8a,
    &cp936_UNI_a0x8b,
    &cp936_UNI_a0x8c,
    &cp936_UNI_a0x8d,
    &cp936_UNI_a0x8e,
    &cp936_UNI_a0x8f,
    &cp936_UNI_a0x90,
    &cp936_UNI_a0x91,
    &cp936_UNI_a0x92,
    &cp936_UNI_a0x93,
    &cp936_UNI_a0x94,
    &cp936_UNI_a0x95,
    &cp936_UNI_a0x96,
    &cp936_UNI_a0x97,
    &cp936_UNI_a0x98,
    &cp936_UNI_a0x99,
    &cp936_UNI_a0x9a,
    &cp936_UNI_a0x9b,
    &cp936_UNI_a0x9c,
    &cp936_UNI_a0x9d,
    &cp936_UNI_a0x9e,
    &cp936_UNI_a0x9f,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    &cp936_UNI_a0xf9,
    &cp936_UNI_a0xfa,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    CP936_UNI_VAL_NULL,
    &cp936_UNI_a0xfe,
    &cp936_UNI_a0xff
};
#endif /* CFG_NU_OS_STOR_FILE_VFS_INCLUDE_CP_SUPPORT == 1 */
