/*************************************************************************/
/*                                                                       */
/*               Copyright 1993 Mentor Graphics Corporation              */
/*                         All Rights Reserved.                          */
/*                                                                       */
/* THIS WORK CONTAINS TRADE SECRET AND PROPRIETARY INFORMATION WHICH IS  */
/* THE PROPERTY OF MENTOR GRAPHICS CORPORATION OR ITS LICENSORS AND IS   */
/* SUBJECT TO LICENSE TERMS.                                             */
/*                                                                       */
/*************************************************************************/
/*************************************************************************
* FILE NAME
*                                                                       
*       cp932.c
*                                                                       
* COMPONENT                                                             
*                                                                       
*       CP
*                                                                       
* DESCRIPTION                                                           
*                                                                       
*       Data tables used for converting a character from codepage 932 
*       format to Unicode and vice versa.       
*   
*
* FUNCTIONS                                                             
*
*       None.
*
*************************************************************************/
#include "storage/pcdisk.h"
#if (CFG_NU_OS_STOR_FILE_VFS_INCLUDE_CP_SUPPORT == 1)

#define CP932_CP_IDX_NULL     0x0000
#define CP932_CP_VAL_NULL     0x0000
#define CP932_UNI_IDX_NULL    0x0000
#define CP932_UNI_VAL_NULL    0x0000

UINT16 cp932_CP_a0x0[] = {
    0x0,
    0x1,
    0x2,
    0x3,
    0x4,
    0x5,
    0x6,
    0x7,
    0x8,
    0x9,
    0xa,
    0xb,
    0xc,
    0xd,
    0xe,
    0xf,
    0x10,
    0x11,
    0x12,
    0x13,
    0x14,
    0x15,
    0x16,
    0x17,
    0x18,
    0x19,
    0x1a,
    0x1b,
    0x1c,
    0x1d,
    0x1e,
    0x1f,
    0x20,
    0x21,
    0x22,
    0x23,
    0x24,
    0x25,
    0x26,
    0x27,
    0x28,
    0x29,
    0x2a,
    0x2b,
    0x2c,
    0x2d,
    0x2e,
    0x2f,
    0x30,
    0x31,
    0x32,
    0x33,
    0x34,
    0x35,
    0x36,
    0x37,
    0x38,
    0x39,
    0x3a,
    0x3b,
    0x3c,
    0x3d,
    0x3e,
    0x3f,
    0x40,
    0x41,
    0x42,
    0x43,
    0x44,
    0x45,
    0x46,
    0x47,
    0x48,
    0x49,
    0x4a,
    0x4b,
    0x4c,
    0x4d,
    0x4e,
    0x4f,
    0x50,
    0x51,
    0x52,
    0x53,
    0x54,
    0x55,
    0x56,
    0x57,
    0x58,
    0x59,
    0x5a,
    0x5b,
    0x5c,
    0x5d,
    0x5e,
    0x5f,
    0x60,
    0x61,
    0x62,
    0x63,
    0x64,
    0x65,
    0x66,
    0x67,
    0x68,
    0x69,
    0x6a,
    0x6b,
    0x6c,
    0x6d,
    0x6e,
    0x6f,
    0x70,
    0x71,
    0x72,
    0x73,
    0x74,
    0x75,
    0x76,
    0x77,
    0x78,
    0x79,
    0x7a,
    0x7b,
    0x7c,
    0x7d,
    0x7e,
    0x7f,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0xff61,
    0xff62,
    0xff63,
    0xff64,
    0xff65,
    0xff66,
    0xff67,
    0xff68,
    0xff69,
    0xff6a,
    0xff6b,
    0xff6c,
    0xff6d,
    0xff6e,
    0xff6f,
    0xff70,
    0xff71,
    0xff72,
    0xff73,
    0xff74,
    0xff75,
    0xff76,
    0xff77,
    0xff78,
    0xff79,
    0xff7a,
    0xff7b,
    0xff7c,
    0xff7d,
    0xff7e,
    0xff7f,
    0xff80,
    0xff81,
    0xff82,
    0xff83,
    0xff84,
    0xff85,
    0xff86,
    0xff87,
    0xff88,
    0xff89,
    0xff8a,
    0xff8b,
    0xff8c,
    0xff8d,
    0xff8e,
    0xff8f,
    0xff90,
    0xff91,
    0xff92,
    0xff93,
    0xff94,
    0xff95,
    0xff96,
    0xff97,
    0xff98,
    0xff99,
    0xff9a,
    0xff9b,
    0xff9c,
    0xff9d,
    0xff9e,
    0xff9f,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL
};
UINT16 cp932_CP_a0x81[] = {
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x3000,
    0x3001,
    0x3002,
    0xff0c,
    0xff0e,
    0x30fb,
    0xff1a,
    0xff1b,
    0xff1f,
    0xff01,
    0x309b,
    0x309c,
    0xb4,
    0xff40,
    0xa8,
    0xff3e,
    0xffe3,
    0xff3f,
    0x30fd,
    0x30fe,
    0x309d,
    0x309e,
    0x3003,
    0x4edd,
    0x3005,
    0x3006,
    0x3007,
    0x30fc,
    0x2015,
    0x2010,
    0xff0f,
    0xff3c,
    0xff5e,
    0x2225,
    0xff5c,
    0x2026,
    0x2025,
    0x2018,
    0x2019,
    0x201c,
    0x201d,
    0xff08,
    0xff09,
    0x3014,
    0x3015,
    0xff3b,
    0xff3d,
    0xff5b,
    0xff5d,
    0x3008,
    0x3009,
    0x300a,
    0x300b,
    0x300c,
    0x300d,
    0x300e,
    0x300f,
    0x3010,
    0x3011,
    0xff0b,
    0xff0d,
    0xb1,
    0xd7,
    CP932_CP_VAL_NULL,
    0xf7,
    0xff1d,
    0x2260,
    0xff1c,
    0xff1e,
    0x2266,
    0x2267,
    0x221e,
    0x2234,
    0x2642,
    0x2640,
    0xb0,
    0x2032,
    0x2033,
    0x2103,
    0xffe5,
    0xff04,
    0xffe0,
    0xffe1,
    0xff05,
    0xff03,
    0xff06,
    0xff0a,
    0xff20,
    0xa7,
    0x2606,
    0x2605,
    0x25cb,
    0x25cf,
    0x25ce,
    0x25c7,
    0x25c6,
    0x25a1,
    0x25a0,
    0x25b3,
    0x25b2,
    0x25bd,
    0x25bc,
    0x203b,
    0x3012,
    0x2192,
    0x2190,
    0x2191,
    0x2193,
    0x3013,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x2208,
    0x220b,
    0x2286,
    0x2287,
    0x2282,
    0x2283,
    0x222a,
    0x2229,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x2227,
    0x2228,
    0xffe2,
    0x21d2,
    0x21d4,
    0x2200,
    0x2203,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x2220,
    0x22a5,
    0x2312,
    0x2202,
    0x2207,
    0x2261,
    0x2252,
    0x226a,
    0x226b,
    0x221a,
    0x223d,
    0x221d,
    0x2235,
    0x222b,
    0x222c,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x212b,
    0x2030,
    0x266f,
    0x266d,
    0x266a,
    0x2020,
    0x2021,
    0xb6,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x25ef,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL
};
UINT16 cp932_CP_a0x82[] = {
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0xff10,
    0xff11,
    0xff12,
    0xff13,
    0xff14,
    0xff15,
    0xff16,
    0xff17,
    0xff18,
    0xff19,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0xff21,
    0xff22,
    0xff23,
    0xff24,
    0xff25,
    0xff26,
    0xff27,
    0xff28,
    0xff29,
    0xff2a,
    0xff2b,
    0xff2c,
    0xff2d,
    0xff2e,
    0xff2f,
    0xff30,
    0xff31,
    0xff32,
    0xff33,
    0xff34,
    0xff35,
    0xff36,
    0xff37,
    0xff38,
    0xff39,
    0xff3a,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0xff41,
    0xff42,
    0xff43,
    0xff44,
    0xff45,
    0xff46,
    0xff47,
    0xff48,
    0xff49,
    0xff4a,
    0xff4b,
    0xff4c,
    0xff4d,
    0xff4e,
    0xff4f,
    0xff50,
    0xff51,
    0xff52,
    0xff53,
    0xff54,
    0xff55,
    0xff56,
    0xff57,
    0xff58,
    0xff59,
    0xff5a,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x3041,
    0x3042,
    0x3043,
    0x3044,
    0x3045,
    0x3046,
    0x3047,
    0x3048,
    0x3049,
    0x304a,
    0x304b,
    0x304c,
    0x304d,
    0x304e,
    0x304f,
    0x3050,
    0x3051,
    0x3052,
    0x3053,
    0x3054,
    0x3055,
    0x3056,
    0x3057,
    0x3058,
    0x3059,
    0x305a,
    0x305b,
    0x305c,
    0x305d,
    0x305e,
    0x305f,
    0x3060,
    0x3061,
    0x3062,
    0x3063,
    0x3064,
    0x3065,
    0x3066,
    0x3067,
    0x3068,
    0x3069,
    0x306a,
    0x306b,
    0x306c,
    0x306d,
    0x306e,
    0x306f,
    0x3070,
    0x3071,
    0x3072,
    0x3073,
    0x3074,
    0x3075,
    0x3076,
    0x3077,
    0x3078,
    0x3079,
    0x307a,
    0x307b,
    0x307c,
    0x307d,
    0x307e,
    0x307f,
    0x3080,
    0x3081,
    0x3082,
    0x3083,
    0x3084,
    0x3085,
    0x3086,
    0x3087,
    0x3088,
    0x3089,
    0x308a,
    0x308b,
    0x308c,
    0x308d,
    0x308e,
    0x308f,
    0x3090,
    0x3091,
    0x3092,
    0x3093,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL
};
UINT16 cp932_CP_a0x83[] = {
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x30a1,
    0x30a2,
    0x30a3,
    0x30a4,
    0x30a5,
    0x30a6,
    0x30a7,
    0x30a8,
    0x30a9,
    0x30aa,
    0x30ab,
    0x30ac,
    0x30ad,
    0x30ae,
    0x30af,
    0x30b0,
    0x30b1,
    0x30b2,
    0x30b3,
    0x30b4,
    0x30b5,
    0x30b6,
    0x30b7,
    0x30b8,
    0x30b9,
    0x30ba,
    0x30bb,
    0x30bc,
    0x30bd,
    0x30be,
    0x30bf,
    0x30c0,
    0x30c1,
    0x30c2,
    0x30c3,
    0x30c4,
    0x30c5,
    0x30c6,
    0x30c7,
    0x30c8,
    0x30c9,
    0x30ca,
    0x30cb,
    0x30cc,
    0x30cd,
    0x30ce,
    0x30cf,
    0x30d0,
    0x30d1,
    0x30d2,
    0x30d3,
    0x30d4,
    0x30d5,
    0x30d6,
    0x30d7,
    0x30d8,
    0x30d9,
    0x30da,
    0x30db,
    0x30dc,
    0x30dd,
    0x30de,
    0x30df,
    CP932_CP_VAL_NULL,
    0x30e0,
    0x30e1,
    0x30e2,
    0x30e3,
    0x30e4,
    0x30e5,
    0x30e6,
    0x30e7,
    0x30e8,
    0x30e9,
    0x30ea,
    0x30eb,
    0x30ec,
    0x30ed,
    0x30ee,
    0x30ef,
    0x30f0,
    0x30f1,
    0x30f2,
    0x30f3,
    0x30f4,
    0x30f5,
    0x30f6,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x391,
    0x392,
    0x393,
    0x394,
    0x395,
    0x396,
    0x397,
    0x398,
    0x399,
    0x39a,
    0x39b,
    0x39c,
    0x39d,
    0x39e,
    0x39f,
    0x3a0,
    0x3a1,
    0x3a3,
    0x3a4,
    0x3a5,
    0x3a6,
    0x3a7,
    0x3a8,
    0x3a9,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x3b1,
    0x3b2,
    0x3b3,
    0x3b4,
    0x3b5,
    0x3b6,
    0x3b7,
    0x3b8,
    0x3b9,
    0x3ba,
    0x3bb,
    0x3bc,
    0x3bd,
    0x3be,
    0x3bf,
    0x3c0,
    0x3c1,
    0x3c3,
    0x3c4,
    0x3c5,
    0x3c6,
    0x3c7,
    0x3c8,
    0x3c9,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL
};
UINT16 cp932_CP_a0x84[] = {
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x410,
    0x411,
    0x412,
    0x413,
    0x414,
    0x415,
    0x401,
    0x416,
    0x417,
    0x418,
    0x419,
    0x41a,
    0x41b,
    0x41c,
    0x41d,
    0x41e,
    0x41f,
    0x420,
    0x421,
    0x422,
    0x423,
    0x424,
    0x425,
    0x426,
    0x427,
    0x428,
    0x429,
    0x42a,
    0x42b,
    0x42c,
    0x42d,
    0x42e,
    0x42f,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x430,
    0x431,
    0x432,
    0x433,
    0x434,
    0x435,
    0x451,
    0x436,
    0x437,
    0x438,
    0x439,
    0x43a,
    0x43b,
    0x43c,
    0x43d,
    CP932_CP_VAL_NULL,
    0x43e,
    0x43f,
    0x440,
    0x441,
    0x442,
    0x443,
    0x444,
    0x445,
    0x446,
    0x447,
    0x448,
    0x449,
    0x44a,
    0x44b,
    0x44c,
    0x44d,
    0x44e,
    0x44f,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x2500,
    0x2502,
    0x250c,
    0x2510,
    0x2518,
    0x2514,
    0x251c,
    0x252c,
    0x2524,
    0x2534,
    0x253c,
    0x2501,
    0x2503,
    0x250f,
    0x2513,
    0x251b,
    0x2517,
    0x2523,
    0x2533,
    0x252b,
    0x253b,
    0x254b,
    0x2520,
    0x252f,
    0x2528,
    0x2537,
    0x253f,
    0x251d,
    0x2530,
    0x2525,
    0x2538,
    0x2542,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL
};
UINT16 cp932_CP_a0x87[] = {
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x2460,
    0x2461,
    0x2462,
    0x2463,
    0x2464,
    0x2465,
    0x2466,
    0x2467,
    0x2468,
    0x2469,
    0x246a,
    0x246b,
    0x246c,
    0x246d,
    0x246e,
    0x246f,
    0x2470,
    0x2471,
    0x2472,
    0x2473,
    0x2160,
    0x2161,
    0x2162,
    0x2163,
    0x2164,
    0x2165,
    0x2166,
    0x2167,
    0x2168,
    0x2169,
    CP932_CP_VAL_NULL,
    0x3349,
    0x3314,
    0x3322,
    0x334d,
    0x3318,
    0x3327,
    0x3303,
    0x3336,
    0x3351,
    0x3357,
    0x330d,
    0x3326,
    0x3323,
    0x332b,
    0x334a,
    0x333b,
    0x339c,
    0x339d,
    0x339e,
    0x338e,
    0x338f,
    0x33c4,
    0x33a1,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x337b,
    CP932_CP_VAL_NULL,
    0x301d,
    0x301f,
    0x2116,
    0x33cd,
    0x2121,
    0x32a4,
    0x32a5,
    0x32a6,
    0x32a7,
    0x32a8,
    0x3231,
    0x3232,
    0x3239,
    0x337e,
    0x337d,
    0x337c,
    0x2252,
    0x2261,
    0x222b,
    0x222e,
    0x2211,
    0x221a,
    0x22a5,
    0x2220,
    0x221f,
    0x22bf,
    0x2235,
    0x2229,
    0x222a,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL
};
UINT16 cp932_CP_a0x88[] = {
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x4e9c,
    0x5516,
    0x5a03,
    0x963f,
    0x54c0,
    0x611b,
    0x6328,
    0x59f6,
    0x9022,
    0x8475,
    0x831c,
    0x7a50,
    0x60aa,
    0x63e1,
    0x6e25,
    0x65ed,
    0x8466,
    0x82a6,
    0x9bf5,
    0x6893,
    0x5727,
    0x65a1,
    0x6271,
    0x5b9b,
    0x59d0,
    0x867b,
    0x98f4,
    0x7d62,
    0x7dbe,
    0x9b8e,
    0x6216,
    0x7c9f,
    0x88b7,
    0x5b89,
    0x5eb5,
    0x6309,
    0x6697,
    0x6848,
    0x95c7,
    0x978d,
    0x674f,
    0x4ee5,
    0x4f0a,
    0x4f4d,
    0x4f9d,
    0x5049,
    0x56f2,
    0x5937,
    0x59d4,
    0x5a01,
    0x5c09,
    0x60df,
    0x610f,
    0x6170,
    0x6613,
    0x6905,
    0x70ba,
    0x754f,
    0x7570,
    0x79fb,
    0x7dad,
    0x7def,
    0x80c3,
    0x840e,
    0x8863,
    0x8b02,
    0x9055,
    0x907a,
    0x533b,
    0x4e95,
    0x4ea5,
    0x57df,
    0x80b2,
    0x90c1,
    0x78ef,
    0x4e00,
    0x58f1,
    0x6ea2,
    0x9038,
    0x7a32,
    0x8328,
    0x828b,
    0x9c2f,
    0x5141,
    0x5370,
    0x54bd,
    0x54e1,
    0x56e0,
    0x59fb,
    0x5f15,
    0x98f2,
    0x6deb,
    0x80e4,
    0x852d,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL
};
UINT16 cp932_CP_a0x89[] = {
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x9662,
    0x9670,
    0x96a0,
    0x97fb,
    0x540b,
    0x53f3,
    0x5b87,
    0x70cf,
    0x7fbd,
    0x8fc2,
    0x96e8,
    0x536f,
    0x9d5c,
    0x7aba,
    0x4e11,
    0x7893,
    0x81fc,
    0x6e26,
    0x5618,
    0x5504,
    0x6b1d,
    0x851a,
    0x9c3b,
    0x59e5,
    0x53a9,
    0x6d66,
    0x74dc,
    0x958f,
    0x5642,
    0x4e91,
    0x904b,
    0x96f2,
    0x834f,
    0x990c,
    0x53e1,
    0x55b6,
    0x5b30,
    0x5f71,
    0x6620,
    0x66f3,
    0x6804,
    0x6c38,
    0x6cf3,
    0x6d29,
    0x745b,
    0x76c8,
    0x7a4e,
    0x9834,
    0x82f1,
    0x885b,
    0x8a60,
    0x92ed,
    0x6db2,
    0x75ab,
    0x76ca,
    0x99c5,
    0x60a6,
    0x8b01,
    0x8d8a,
    0x95b2,
    0x698e,
    0x53ad,
    0x5186,
    CP932_CP_VAL_NULL,
    0x5712,
    0x5830,
    0x5944,
    0x5bb4,
    0x5ef6,
    0x6028,
    0x63a9,
    0x63f4,
    0x6cbf,
    0x6f14,
    0x708e,
    0x7114,
    0x7159,
    0x71d5,
    0x733f,
    0x7e01,
    0x8276,
    0x82d1,
    0x8597,
    0x9060,
    0x925b,
    0x9d1b,
    0x5869,
    0x65bc,
    0x6c5a,
    0x7525,
    0x51f9,
    0x592e,
    0x5965,
    0x5f80,
    0x5fdc,
    0x62bc,
    0x65fa,
    0x6a2a,
    0x6b27,
    0x6bb4,
    0x738b,
    0x7fc1,
    0x8956,
    0x9d2c,
    0x9d0e,
    0x9ec4,
    0x5ca1,
    0x6c96,
    0x837b,
    0x5104,
    0x5c4b,
    0x61b6,
    0x81c6,
    0x6876,
    0x7261,
    0x4e59,
    0x4ffa,
    0x5378,
    0x6069,
    0x6e29,
    0x7a4f,
    0x97f3,
    0x4e0b,
    0x5316,
    0x4eee,
    0x4f55,
    0x4f3d,
    0x4fa1,
    0x4f73,
    0x52a0,
    0x53ef,
    0x5609,
    0x590f,
    0x5ac1,
    0x5bb6,
    0x5be1,
    0x79d1,
    0x6687,
    0x679c,
    0x67b6,
    0x6b4c,
    0x6cb3,
    0x706b,
    0x73c2,
    0x798d,
    0x79be,
    0x7a3c,
    0x7b87,
    0x82b1,
    0x82db,
    0x8304,
    0x8377,
    0x83ef,
    0x83d3,
    0x8766,
    0x8ab2,
    0x5629,
    0x8ca8,
    0x8fe6,
    0x904e,
    0x971e,
    0x868a,
    0x4fc4,
    0x5ce8,
    0x6211,
    0x7259,
    0x753b,
    0x81e5,
    0x82bd,
    0x86fe,
    0x8cc0,
    0x96c5,
    0x9913,
    0x99d5,
    0x4ecb,
    0x4f1a,
    0x89e3,
    0x56de,
    0x584a,
    0x58ca,
    0x5efb,
    0x5feb,
    0x602a,
    0x6094,
    0x6062,
    0x61d0,
    0x6212,
    0x62d0,
    0x6539,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL
};
UINT16 cp932_CP_a0x8a[] = {
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x9b41,
    0x6666,
    0x68b0,
    0x6d77,
    0x7070,
    0x754c,
    0x7686,
    0x7d75,
    0x82a5,
    0x87f9,
    0x958b,
    0x968e,
    0x8c9d,
    0x51f1,
    0x52be,
    0x5916,
    0x54b3,
    0x5bb3,
    0x5d16,
    0x6168,
    0x6982,
    0x6daf,
    0x788d,
    0x84cb,
    0x8857,
    0x8a72,
    0x93a7,
    0x9ab8,
    0x6d6c,
    0x99a8,
    0x86d9,
    0x57a3,
    0x67ff,
    0x86ce,
    0x920e,
    0x5283,
    0x5687,
    0x5404,
    0x5ed3,
    0x62e1,
    0x64b9,
    0x683c,
    0x6838,
    0x6bbb,
    0x7372,
    0x78ba,
    0x7a6b,
    0x899a,
    0x89d2,
    0x8d6b,
    0x8f03,
    0x90ed,
    0x95a3,
    0x9694,
    0x9769,
    0x5b66,
    0x5cb3,
    0x697d,
    0x984d,
    0x984e,
    0x639b,
    0x7b20,
    0x6a2b,
    CP932_CP_VAL_NULL,
    0x6a7f,
    0x68b6,
    0x9c0d,
    0x6f5f,
    0x5272,
    0x559d,
    0x6070,
    0x62ec,
    0x6d3b,
    0x6e07,
    0x6ed1,
    0x845b,
    0x8910,
    0x8f44,
    0x4e14,
    0x9c39,
    0x53f6,
    0x691b,
    0x6a3a,
    0x9784,
    0x682a,
    0x515c,
    0x7ac3,
    0x84b2,
    0x91dc,
    0x938c,
    0x565b,
    0x9d28,
    0x6822,
    0x8305,
    0x8431,
    0x7ca5,
    0x5208,
    0x82c5,
    0x74e6,
    0x4e7e,
    0x4f83,
    0x51a0,
    0x5bd2,
    0x520a,
    0x52d8,
    0x52e7,
    0x5dfb,
    0x559a,
    0x582a,
    0x59e6,
    0x5b8c,
    0x5b98,
    0x5bdb,
    0x5e72,
    0x5e79,
    0x60a3,
    0x611f,
    0x6163,
    0x61be,
    0x63db,
    0x6562,
    0x67d1,
    0x6853,
    0x68fa,
    0x6b3e,
    0x6b53,
    0x6c57,
    0x6f22,
    0x6f97,
    0x6f45,
    0x74b0,
    0x7518,
    0x76e3,
    0x770b,
    0x7aff,
    0x7ba1,
    0x7c21,
    0x7de9,
    0x7f36,
    0x7ff0,
    0x809d,
    0x8266,
    0x839e,
    0x89b3,
    0x8acc,
    0x8cab,
    0x9084,
    0x9451,
    0x9593,
    0x9591,
    0x95a2,
    0x9665,
    0x97d3,
    0x9928,
    0x8218,
    0x4e38,
    0x542b,
    0x5cb8,
    0x5dcc,
    0x73a9,
    0x764c,
    0x773c,
    0x5ca9,
    0x7feb,
    0x8d0b,
    0x96c1,
    0x9811,
    0x9854,
    0x9858,
    0x4f01,
    0x4f0e,
    0x5371,
    0x559c,
    0x5668,
    0x57fa,
    0x5947,
    0x5b09,
    0x5bc4,
    0x5c90,
    0x5e0c,
    0x5e7e,
    0x5fcc,
    0x63ee,
    0x673a,
    0x65d7,
    0x65e2,
    0x671f,
    0x68cb,
    0x68c4,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL
};
UINT16 cp932_CP_a0x8b[] = {
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x6a5f,
    0x5e30,
    0x6bc5,
    0x6c17,
    0x6c7d,
    0x757f,
    0x7948,
    0x5b63,
    0x7a00,
    0x7d00,
    0x5fbd,
    0x898f,
    0x8a18,
    0x8cb4,
    0x8d77,
    0x8ecc,
    0x8f1d,
    0x98e2,
    0x9a0e,
    0x9b3c,
    0x4e80,
    0x507d,
    0x5100,
    0x5993,
    0x5b9c,
    0x622f,
    0x6280,
    0x64ec,
    0x6b3a,
    0x72a0,
    0x7591,
    0x7947,
    0x7fa9,
    0x87fb,
    0x8abc,
    0x8b70,
    0x63ac,
    0x83ca,
    0x97a0,
    0x5409,
    0x5403,
    0x55ab,
    0x6854,
    0x6a58,
    0x8a70,
    0x7827,
    0x6775,
    0x9ecd,
    0x5374,
    0x5ba2,
    0x811a,
    0x8650,
    0x9006,
    0x4e18,
    0x4e45,
    0x4ec7,
    0x4f11,
    0x53ca,
    0x5438,
    0x5bae,
    0x5f13,
    0x6025,
    0x6551,
    CP932_CP_VAL_NULL,
    0x673d,
    0x6c42,
    0x6c72,
    0x6ce3,
    0x7078,
    0x7403,
    0x7a76,
    0x7aae,
    0x7b08,
    0x7d1a,
    0x7cfe,
    0x7d66,
    0x65e7,
    0x725b,
    0x53bb,
    0x5c45,
    0x5de8,
    0x62d2,
    0x62e0,
    0x6319,
    0x6e20,
    0x865a,
    0x8a31,
    0x8ddd,
    0x92f8,
    0x6f01,
    0x79a6,
    0x9b5a,
    0x4ea8,
    0x4eab,
    0x4eac,
    0x4f9b,
    0x4fa0,
    0x50d1,
    0x5147,
    0x7af6,
    0x5171,
    0x51f6,
    0x5354,
    0x5321,
    0x537f,
    0x53eb,
    0x55ac,
    0x5883,
    0x5ce1,
    0x5f37,
    0x5f4a,
    0x602f,
    0x6050,
    0x606d,
    0x631f,
    0x6559,
    0x6a4b,
    0x6cc1,
    0x72c2,
    0x72ed,
    0x77ef,
    0x80f8,
    0x8105,
    0x8208,
    0x854e,
    0x90f7,
    0x93e1,
    0x97ff,
    0x9957,
    0x9a5a,
    0x4ef0,
    0x51dd,
    0x5c2d,
    0x6681,
    0x696d,
    0x5c40,
    0x66f2,
    0x6975,
    0x7389,
    0x6850,
    0x7c81,
    0x50c5,
    0x52e4,
    0x5747,
    0x5dfe,
    0x9326,
    0x65a4,
    0x6b23,
    0x6b3d,
    0x7434,
    0x7981,
    0x79bd,
    0x7b4b,
    0x7dca,
    0x82b9,
    0x83cc,
    0x887f,
    0x895f,
    0x8b39,
    0x8fd1,
    0x91d1,
    0x541f,
    0x9280,
    0x4e5d,
    0x5036,
    0x53e5,
    0x533a,
    0x72d7,
    0x7396,
    0x77e9,
    0x82e6,
    0x8eaf,
    0x99c6,
    0x99c8,
    0x99d2,
    0x5177,
    0x611a,
    0x865e,
    0x55b0,
    0x7a7a,
    0x5076,
    0x5bd3,
    0x9047,
    0x9685,
    0x4e32,
    0x6adb,
    0x91e7,
    0x5c51,
    0x5c48,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL
};
UINT16 cp932_CP_a0x8c[] = {
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x6398,
    0x7a9f,
    0x6c93,
    0x9774,
    0x8f61,
    0x7aaa,
    0x718a,
    0x9688,
    0x7c82,
    0x6817,
    0x7e70,
    0x6851,
    0x936c,
    0x52f2,
    0x541b,
    0x85ab,
    0x8a13,
    0x7fa4,
    0x8ecd,
    0x90e1,
    0x5366,
    0x8888,
    0x7941,
    0x4fc2,
    0x50be,
    0x5211,
    0x5144,
    0x5553,
    0x572d,
    0x73ea,
    0x578b,
    0x5951,
    0x5f62,
    0x5f84,
    0x6075,
    0x6176,
    0x6167,
    0x61a9,
    0x63b2,
    0x643a,
    0x656c,
    0x666f,
    0x6842,
    0x6e13,
    0x7566,
    0x7a3d,
    0x7cfb,
    0x7d4c,
    0x7d99,
    0x7e4b,
    0x7f6b,
    0x830e,
    0x834a,
    0x86cd,
    0x8a08,
    0x8a63,
    0x8b66,
    0x8efd,
    0x981a,
    0x9d8f,
    0x82b8,
    0x8fce,
    0x9be8,
    CP932_CP_VAL_NULL,
    0x5287,
    0x621f,
    0x6483,
    0x6fc0,
    0x9699,
    0x6841,
    0x5091,
    0x6b20,
    0x6c7a,
    0x6f54,
    0x7a74,
    0x7d50,
    0x8840,
    0x8a23,
    0x6708,
    0x4ef6,
    0x5039,
    0x5026,
    0x5065,
    0x517c,
    0x5238,
    0x5263,
    0x55a7,
    0x570f,
    0x5805,
    0x5acc,
    0x5efa,
    0x61b2,
    0x61f8,
    0x62f3,
    0x6372,
    0x691c,
    0x6a29,
    0x727d,
    0x72ac,
    0x732e,
    0x7814,
    0x786f,
    0x7d79,
    0x770c,
    0x80a9,
    0x898b,
    0x8b19,
    0x8ce2,
    0x8ed2,
    0x9063,
    0x9375,
    0x967a,
    0x9855,
    0x9a13,
    0x9e78,
    0x5143,
    0x539f,
    0x53b3,
    0x5e7b,
    0x5f26,
    0x6e1b,
    0x6e90,
    0x7384,
    0x73fe,
    0x7d43,
    0x8237,
    0x8a00,
    0x8afa,
    0x9650,
    0x4e4e,
    0x500b,
    0x53e4,
    0x547c,
    0x56fa,
    0x59d1,
    0x5b64,
    0x5df1,
    0x5eab,
    0x5f27,
    0x6238,
    0x6545,
    0x67af,
    0x6e56,
    0x72d0,
    0x7cca,
    0x88b4,
    0x80a1,
    0x80e1,
    0x83f0,
    0x864e,
    0x8a87,
    0x8de8,
    0x9237,
    0x96c7,
    0x9867,
    0x9f13,
    0x4e94,
    0x4e92,
    0x4f0d,
    0x5348,
    0x5449,
    0x543e,
    0x5a2f,
    0x5f8c,
    0x5fa1,
    0x609f,
    0x68a7,
    0x6a8e,
    0x745a,
    0x7881,
    0x8a9e,
    0x8aa4,
    0x8b77,
    0x9190,
    0x4e5e,
    0x9bc9,
    0x4ea4,
    0x4f7c,
    0x4faf,
    0x5019,
    0x5016,
    0x5149,
    0x516c,
    0x529f,
    0x52b9,
    0x52fe,
    0x539a,
    0x53e3,
    0x5411,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL
};
UINT16 cp932_CP_a0x8d[] = {
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x540e,
    0x5589,
    0x5751,
    0x57a2,
    0x597d,
    0x5b54,
    0x5b5d,
    0x5b8f,
    0x5de5,
    0x5de7,
    0x5df7,
    0x5e78,
    0x5e83,
    0x5e9a,
    0x5eb7,
    0x5f18,
    0x6052,
    0x614c,
    0x6297,
    0x62d8,
    0x63a7,
    0x653b,
    0x6602,
    0x6643,
    0x66f4,
    0x676d,
    0x6821,
    0x6897,
    0x69cb,
    0x6c5f,
    0x6d2a,
    0x6d69,
    0x6e2f,
    0x6e9d,
    0x7532,
    0x7687,
    0x786c,
    0x7a3f,
    0x7ce0,
    0x7d05,
    0x7d18,
    0x7d5e,
    0x7db1,
    0x8015,
    0x8003,
    0x80af,
    0x80b1,
    0x8154,
    0x818f,
    0x822a,
    0x8352,
    0x884c,
    0x8861,
    0x8b1b,
    0x8ca2,
    0x8cfc,
    0x90ca,
    0x9175,
    0x9271,
    0x783f,
    0x92fc,
    0x95a4,
    0x964d,
    CP932_CP_VAL_NULL,
    0x9805,
    0x9999,
    0x9ad8,
    0x9d3b,
    0x525b,
    0x52ab,
    0x53f7,
    0x5408,
    0x58d5,
    0x62f7,
    0x6fe0,
    0x8c6a,
    0x8f5f,
    0x9eb9,
    0x514b,
    0x523b,
    0x544a,
    0x56fd,
    0x7a40,
    0x9177,
    0x9d60,
    0x9ed2,
    0x7344,
    0x6f09,
    0x8170,
    0x7511,
    0x5ffd,
    0x60da,
    0x9aa8,
    0x72db,
    0x8fbc,
    0x6b64,
    0x9803,
    0x4eca,
    0x56f0,
    0x5764,
    0x58be,
    0x5a5a,
    0x6068,
    0x61c7,
    0x660f,
    0x6606,
    0x6839,
    0x68b1,
    0x6df7,
    0x75d5,
    0x7d3a,
    0x826e,
    0x9b42,
    0x4e9b,
    0x4f50,
    0x53c9,
    0x5506,
    0x5d6f,
    0x5de6,
    0x5dee,
    0x67fb,
    0x6c99,
    0x7473,
    0x7802,
    0x8a50,
    0x9396,
    0x88df,
    0x5750,
    0x5ea7,
    0x632b,
    0x50b5,
    0x50ac,
    0x518d,
    0x6700,
    0x54c9,
    0x585e,
    0x59bb,
    0x5bb0,
    0x5f69,
    0x624d,
    0x63a1,
    0x683d,
    0x6b73,
    0x6e08,
    0x707d,
    0x91c7,
    0x7280,
    0x7815,
    0x7826,
    0x796d,
    0x658e,
    0x7d30,
    0x83dc,
    0x88c1,
    0x8f09,
    0x969b,
    0x5264,
    0x5728,
    0x6750,
    0x7f6a,
    0x8ca1,
    0x51b4,
    0x5742,
    0x962a,
    0x583a,
    0x698a,
    0x80b4,
    0x54b2,
    0x5d0e,
    0x57fc,
    0x7895,
    0x9dfa,
    0x4f5c,
    0x524a,
    0x548b,
    0x643e,
    0x6628,
    0x6714,
    0x67f5,
    0x7a84,
    0x7b56,
    0x7d22,
    0x932f,
    0x685c,
    0x9bad,
    0x7b39,
    0x5319,
    0x518a,
    0x5237,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL
};
UINT16 cp932_CP_a0x8e[] = {
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x5bdf,
    0x62f6,
    0x64ae,
    0x64e6,
    0x672d,
    0x6bba,
    0x85a9,
    0x96d1,
    0x7690,
    0x9bd6,
    0x634c,
    0x9306,
    0x9bab,
    0x76bf,
    0x6652,
    0x4e09,
    0x5098,
    0x53c2,
    0x5c71,
    0x60e8,
    0x6492,
    0x6563,
    0x685f,
    0x71e6,
    0x73ca,
    0x7523,
    0x7b97,
    0x7e82,
    0x8695,
    0x8b83,
    0x8cdb,
    0x9178,
    0x9910,
    0x65ac,
    0x66ab,
    0x6b8b,
    0x4ed5,
    0x4ed4,
    0x4f3a,
    0x4f7f,
    0x523a,
    0x53f8,
    0x53f2,
    0x55e3,
    0x56db,
    0x58eb,
    0x59cb,
    0x59c9,
    0x59ff,
    0x5b50,
    0x5c4d,
    0x5e02,
    0x5e2b,
    0x5fd7,
    0x601d,
    0x6307,
    0x652f,
    0x5b5c,
    0x65af,
    0x65bd,
    0x65e8,
    0x679d,
    0x6b62,
    CP932_CP_VAL_NULL,
    0x6b7b,
    0x6c0f,
    0x7345,
    0x7949,
    0x79c1,
    0x7cf8,
    0x7d19,
    0x7d2b,
    0x80a2,
    0x8102,
    0x81f3,
    0x8996,
    0x8a5e,
    0x8a69,
    0x8a66,
    0x8a8c,
    0x8aee,
    0x8cc7,
    0x8cdc,
    0x96cc,
    0x98fc,
    0x6b6f,
    0x4e8b,
    0x4f3c,
    0x4f8d,
    0x5150,
    0x5b57,
    0x5bfa,
    0x6148,
    0x6301,
    0x6642,
    0x6b21,
    0x6ecb,
    0x6cbb,
    0x723e,
    0x74bd,
    0x75d4,
    0x78c1,
    0x793a,
    0x800c,
    0x8033,
    0x81ea,
    0x8494,
    0x8f9e,
    0x6c50,
    0x9e7f,
    0x5f0f,
    0x8b58,
    0x9d2b,
    0x7afa,
    0x8ef8,
    0x5b8d,
    0x96eb,
    0x4e03,
    0x53f1,
    0x57f7,
    0x5931,
    0x5ac9,
    0x5ba4,
    0x6089,
    0x6e7f,
    0x6f06,
    0x75be,
    0x8cea,
    0x5b9f,
    0x8500,
    0x7be0,
    0x5072,
    0x67f4,
    0x829d,
    0x5c61,
    0x854a,
    0x7e1e,
    0x820e,
    0x5199,
    0x5c04,
    0x6368,
    0x8d66,
    0x659c,
    0x716e,
    0x793e,
    0x7d17,
    0x8005,
    0x8b1d,
    0x8eca,
    0x906e,
    0x86c7,
    0x90aa,
    0x501f,
    0x52fa,
    0x5c3a,
    0x6753,
    0x707c,
    0x7235,
    0x914c,
    0x91c8,
    0x932b,
    0x82e5,
    0x5bc2,
    0x5f31,
    0x60f9,
    0x4e3b,
    0x53d6,
    0x5b88,
    0x624b,
    0x6731,
    0x6b8a,
    0x72e9,
    0x73e0,
    0x7a2e,
    0x816b,
    0x8da3,
    0x9152,
    0x9996,
    0x5112,
    0x53d7,
    0x546a,
    0x5bff,
    0x6388,
    0x6a39,
    0x7dac,
    0x9700,
    0x56da,
    0x53ce,
    0x5468,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL
};
UINT16 cp932_CP_a0x8f[] = {
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x5b97,
    0x5c31,
    0x5dde,
    0x4fee,
    0x6101,
    0x62fe,
    0x6d32,
    0x79c0,
    0x79cb,
    0x7d42,
    0x7e4d,
    0x7fd2,
    0x81ed,
    0x821f,
    0x8490,
    0x8846,
    0x8972,
    0x8b90,
    0x8e74,
    0x8f2f,
    0x9031,
    0x914b,
    0x916c,
    0x96c6,
    0x919c,
    0x4ec0,
    0x4f4f,
    0x5145,
    0x5341,
    0x5f93,
    0x620e,
    0x67d4,
    0x6c41,
    0x6e0b,
    0x7363,
    0x7e26,
    0x91cd,
    0x9283,
    0x53d4,
    0x5919,
    0x5bbf,
    0x6dd1,
    0x795d,
    0x7e2e,
    0x7c9b,
    0x587e,
    0x719f,
    0x51fa,
    0x8853,
    0x8ff0,
    0x4fca,
    0x5cfb,
    0x6625,
    0x77ac,
    0x7ae3,
    0x821c,
    0x99ff,
    0x51c6,
    0x5faa,
    0x65ec,
    0x696f,
    0x6b89,
    0x6df3,
    CP932_CP_VAL_NULL,
    0x6e96,
    0x6f64,
    0x76fe,
    0x7d14,
    0x5de1,
    0x9075,
    0x9187,
    0x9806,
    0x51e6,
    0x521d,
    0x6240,
    0x6691,
    0x66d9,
    0x6e1a,
    0x5eb6,
    0x7dd2,
    0x7f72,
    0x66f8,
    0x85af,
    0x85f7,
    0x8af8,
    0x52a9,
    0x53d9,
    0x5973,
    0x5e8f,
    0x5f90,
    0x6055,
    0x92e4,
    0x9664,
    0x50b7,
    0x511f,
    0x52dd,
    0x5320,
    0x5347,
    0x53ec,
    0x54e8,
    0x5546,
    0x5531,
    0x5617,
    0x5968,
    0x59be,
    0x5a3c,
    0x5bb5,
    0x5c06,
    0x5c0f,
    0x5c11,
    0x5c1a,
    0x5e84,
    0x5e8a,
    0x5ee0,
    0x5f70,
    0x627f,
    0x6284,
    0x62db,
    0x638c,
    0x6377,
    0x6607,
    0x660c,
    0x662d,
    0x6676,
    0x677e,
    0x68a2,
    0x6a1f,
    0x6a35,
    0x6cbc,
    0x6d88,
    0x6e09,
    0x6e58,
    0x713c,
    0x7126,
    0x7167,
    0x75c7,
    0x7701,
    0x785d,
    0x7901,
    0x7965,
    0x79f0,
    0x7ae0,
    0x7b11,
    0x7ca7,
    0x7d39,
    0x8096,
    0x83d6,
    0x848b,
    0x8549,
    0x885d,
    0x88f3,
    0x8a1f,
    0x8a3c,
    0x8a54,
    0x8a73,
    0x8c61,
    0x8cde,
    0x91a4,
    0x9266,
    0x937e,
    0x9418,
    0x969c,
    0x9798,
    0x4e0a,
    0x4e08,
    0x4e1e,
    0x4e57,
    0x5197,
    0x5270,
    0x57ce,
    0x5834,
    0x58cc,
    0x5b22,
    0x5e38,
    0x60c5,
    0x64fe,
    0x6761,
    0x6756,
    0x6d44,
    0x72b6,
    0x7573,
    0x7a63,
    0x84b8,
    0x8b72,
    0x91b8,
    0x9320,
    0x5631,
    0x57f4,
    0x98fe,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL
};
UINT16 cp932_CP_a0x90[] = {
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x62ed,
    0x690d,
    0x6b96,
    0x71ed,
    0x7e54,
    0x8077,
    0x8272,
    0x89e6,
    0x98df,
    0x8755,
    0x8fb1,
    0x5c3b,
    0x4f38,
    0x4fe1,
    0x4fb5,
    0x5507,
    0x5a20,
    0x5bdd,
    0x5be9,
    0x5fc3,
    0x614e,
    0x632f,
    0x65b0,
    0x664b,
    0x68ee,
    0x699b,
    0x6d78,
    0x6df1,
    0x7533,
    0x75b9,
    0x771f,
    0x795e,
    0x79e6,
    0x7d33,
    0x81e3,
    0x82af,
    0x85aa,
    0x89aa,
    0x8a3a,
    0x8eab,
    0x8f9b,
    0x9032,
    0x91dd,
    0x9707,
    0x4eba,
    0x4ec1,
    0x5203,
    0x5875,
    0x58ec,
    0x5c0b,
    0x751a,
    0x5c3d,
    0x814e,
    0x8a0a,
    0x8fc5,
    0x9663,
    0x976d,
    0x7b25,
    0x8acf,
    0x9808,
    0x9162,
    0x56f3,
    0x53a8,
    CP932_CP_VAL_NULL,
    0x9017,
    0x5439,
    0x5782,
    0x5e25,
    0x63a8,
    0x6c34,
    0x708a,
    0x7761,
    0x7c8b,
    0x7fe0,
    0x8870,
    0x9042,
    0x9154,
    0x9310,
    0x9318,
    0x968f,
    0x745e,
    0x9ac4,
    0x5d07,
    0x5d69,
    0x6570,
    0x67a2,
    0x8da8,
    0x96db,
    0x636e,
    0x6749,
    0x6919,
    0x83c5,
    0x9817,
    0x96c0,
    0x88fe,
    0x6f84,
    0x647a,
    0x5bf8,
    0x4e16,
    0x702c,
    0x755d,
    0x662f,
    0x51c4,
    0x5236,
    0x52e2,
    0x59d3,
    0x5f81,
    0x6027,
    0x6210,
    0x653f,
    0x6574,
    0x661f,
    0x6674,
    0x68f2,
    0x6816,
    0x6b63,
    0x6e05,
    0x7272,
    0x751f,
    0x76db,
    0x7cbe,
    0x8056,
    0x58f0,
    0x88fd,
    0x897f,
    0x8aa0,
    0x8a93,
    0x8acb,
    0x901d,
    0x9192,
    0x9752,
    0x9759,
    0x6589,
    0x7a0e,
    0x8106,
    0x96bb,
    0x5e2d,
    0x60dc,
    0x621a,
    0x65a5,
    0x6614,
    0x6790,
    0x77f3,
    0x7a4d,
    0x7c4d,
    0x7e3e,
    0x810a,
    0x8cac,
    0x8d64,
    0x8de1,
    0x8e5f,
    0x78a9,
    0x5207,
    0x62d9,
    0x63a5,
    0x6442,
    0x6298,
    0x8a2d,
    0x7a83,
    0x7bc0,
    0x8aac,
    0x96ea,
    0x7d76,
    0x820c,
    0x8749,
    0x4ed9,
    0x5148,
    0x5343,
    0x5360,
    0x5ba3,
    0x5c02,
    0x5c16,
    0x5ddd,
    0x6226,
    0x6247,
    0x64b0,
    0x6813,
    0x6834,
    0x6cc9,
    0x6d45,
    0x6d17,
    0x67d3,
    0x6f5c,
    0x714e,
    0x717d,
    0x65cb,
    0x7a7f,
    0x7bad,
    0x7dda,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL
};
UINT16 cp932_CP_a0x91[] = {
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x7e4a,
    0x7fa8,
    0x817a,
    0x821b,
    0x8239,
    0x85a6,
    0x8a6e,
    0x8cce,
    0x8df5,
    0x9078,
    0x9077,
    0x92ad,
    0x9291,
    0x9583,
    0x9bae,
    0x524d,
    0x5584,
    0x6f38,
    0x7136,
    0x5168,
    0x7985,
    0x7e55,
    0x81b3,
    0x7cce,
    0x564c,
    0x5851,
    0x5ca8,
    0x63aa,
    0x66fe,
    0x66fd,
    0x695a,
    0x72d9,
    0x758f,
    0x758e,
    0x790e,
    0x7956,
    0x79df,
    0x7c97,
    0x7d20,
    0x7d44,
    0x8607,
    0x8a34,
    0x963b,
    0x9061,
    0x9f20,
    0x50e7,
    0x5275,
    0x53cc,
    0x53e2,
    0x5009,
    0x55aa,
    0x58ee,
    0x594f,
    0x723d,
    0x5b8b,
    0x5c64,
    0x531d,
    0x60e3,
    0x60f3,
    0x635c,
    0x6383,
    0x633f,
    0x63bb,
    CP932_CP_VAL_NULL,
    0x64cd,
    0x65e9,
    0x66f9,
    0x5de3,
    0x69cd,
    0x69fd,
    0x6f15,
    0x71e5,
    0x4e89,
    0x75e9,
    0x76f8,
    0x7a93,
    0x7cdf,
    0x7dcf,
    0x7d9c,
    0x8061,
    0x8349,
    0x8358,
    0x846c,
    0x84bc,
    0x85fb,
    0x88c5,
    0x8d70,
    0x9001,
    0x906d,
    0x9397,
    0x971c,
    0x9a12,
    0x50cf,
    0x5897,
    0x618e,
    0x81d3,
    0x8535,
    0x8d08,
    0x9020,
    0x4fc3,
    0x5074,
    0x5247,
    0x5373,
    0x606f,
    0x6349,
    0x675f,
    0x6e2c,
    0x8db3,
    0x901f,
    0x4fd7,
    0x5c5e,
    0x8cca,
    0x65cf,
    0x7d9a,
    0x5352,
    0x8896,
    0x5176,
    0x63c3,
    0x5b58,
    0x5b6b,
    0x5c0a,
    0x640d,
    0x6751,
    0x905c,
    0x4ed6,
    0x591a,
    0x592a,
    0x6c70,
    0x8a51,
    0x553e,
    0x5815,
    0x59a5,
    0x60f0,
    0x6253,
    0x67c1,
    0x8235,
    0x6955,
    0x9640,
    0x99c4,
    0x9a28,
    0x4f53,
    0x5806,
    0x5bfe,
    0x8010,
    0x5cb1,
    0x5e2f,
    0x5f85,
    0x6020,
    0x614b,
    0x6234,
    0x66ff,
    0x6cf0,
    0x6ede,
    0x80ce,
    0x817f,
    0x82d4,
    0x888b,
    0x8cb8,
    0x9000,
    0x902e,
    0x968a,
    0x9edb,
    0x9bdb,
    0x4ee3,
    0x53f0,
    0x5927,
    0x7b2c,
    0x918d,
    0x984c,
    0x9df9,
    0x6edd,
    0x7027,
    0x5353,
    0x5544,
    0x5b85,
    0x6258,
    0x629e,
    0x62d3,
    0x6ca2,
    0x6fef,
    0x7422,
    0x8a17,
    0x9438,
    0x6fc1,
    0x8afe,
    0x8338,
    0x51e7,
    0x86f8,
    0x53ea,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL
};
UINT16 cp932_CP_a0x92[] = {
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x53e9,
    0x4f46,
    0x9054,
    0x8fb0,
    0x596a,
    0x8131,
    0x5dfd,
    0x7aea,
    0x8fbf,
    0x68da,
    0x8c37,
    0x72f8,
    0x9c48,
    0x6a3d,
    0x8ab0,
    0x4e39,
    0x5358,
    0x5606,
    0x5766,
    0x62c5,
    0x63a2,
    0x65e6,
    0x6b4e,
    0x6de1,
    0x6e5b,
    0x70ad,
    0x77ed,
    0x7aef,
    0x7baa,
    0x7dbb,
    0x803d,
    0x80c6,
    0x86cb,
    0x8a95,
    0x935b,
    0x56e3,
    0x58c7,
    0x5f3e,
    0x65ad,
    0x6696,
    0x6a80,
    0x6bb5,
    0x7537,
    0x8ac7,
    0x5024,
    0x77e5,
    0x5730,
    0x5f1b,
    0x6065,
    0x667a,
    0x6c60,
    0x75f4,
    0x7a1a,
    0x7f6e,
    0x81f4,
    0x8718,
    0x9045,
    0x99b3,
    0x7bc9,
    0x755c,
    0x7af9,
    0x7b51,
    0x84c4,
    CP932_CP_VAL_NULL,
    0x9010,
    0x79e9,
    0x7a92,
    0x8336,
    0x5ae1,
    0x7740,
    0x4e2d,
    0x4ef2,
    0x5b99,
    0x5fe0,
    0x62bd,
    0x663c,
    0x67f1,
    0x6ce8,
    0x866b,
    0x8877,
    0x8a3b,
    0x914e,
    0x92f3,
    0x99d0,
    0x6a17,
    0x7026,
    0x732a,
    0x82e7,
    0x8457,
    0x8caf,
    0x4e01,
    0x5146,
    0x51cb,
    0x558b,
    0x5bf5,
    0x5e16,
    0x5e33,
    0x5e81,
    0x5f14,
    0x5f35,
    0x5f6b,
    0x5fb4,
    0x61f2,
    0x6311,
    0x66a2,
    0x671d,
    0x6f6e,
    0x7252,
    0x753a,
    0x773a,
    0x8074,
    0x8139,
    0x8178,
    0x8776,
    0x8abf,
    0x8adc,
    0x8d85,
    0x8df3,
    0x929a,
    0x9577,
    0x9802,
    0x9ce5,
    0x52c5,
    0x6357,
    0x76f4,
    0x6715,
    0x6c88,
    0x73cd,
    0x8cc3,
    0x93ae,
    0x9673,
    0x6d25,
    0x589c,
    0x690e,
    0x69cc,
    0x8ffd,
    0x939a,
    0x75db,
    0x901a,
    0x585a,
    0x6802,
    0x63b4,
    0x69fb,
    0x4f43,
    0x6f2c,
    0x67d8,
    0x8fbb,
    0x8526,
    0x7db4,
    0x9354,
    0x693f,
    0x6f70,
    0x576a,
    0x58f7,
    0x5b2c,
    0x7d2c,
    0x722a,
    0x540a,
    0x91e3,
    0x9db4,
    0x4ead,
    0x4f4e,
    0x505c,
    0x5075,
    0x5243,
    0x8c9e,
    0x5448,
    0x5824,
    0x5b9a,
    0x5e1d,
    0x5e95,
    0x5ead,
    0x5ef7,
    0x5f1f,
    0x608c,
    0x62b5,
    0x633a,
    0x63d0,
    0x68af,
    0x6c40,
    0x7887,
    0x798e,
    0x7a0b,
    0x7de0,
    0x8247,
    0x8a02,
    0x8ae6,
    0x8e44,
    0x9013,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL
};
UINT16 cp932_CP_a0x93[] = {
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x90b8,
    0x912d,
    0x91d8,
    0x9f0e,
    0x6ce5,
    0x6458,
    0x64e2,
    0x6575,
    0x6ef4,
    0x7684,
    0x7b1b,
    0x9069,
    0x93d1,
    0x6eba,
    0x54f2,
    0x5fb9,
    0x64a4,
    0x8f4d,
    0x8fed,
    0x9244,
    0x5178,
    0x586b,
    0x5929,
    0x5c55,
    0x5e97,
    0x6dfb,
    0x7e8f,
    0x751c,
    0x8cbc,
    0x8ee2,
    0x985b,
    0x70b9,
    0x4f1d,
    0x6bbf,
    0x6fb1,
    0x7530,
    0x96fb,
    0x514e,
    0x5410,
    0x5835,
    0x5857,
    0x59ac,
    0x5c60,
    0x5f92,
    0x6597,
    0x675c,
    0x6e21,
    0x767b,
    0x83df,
    0x8ced,
    0x9014,
    0x90fd,
    0x934d,
    0x7825,
    0x783a,
    0x52aa,
    0x5ea6,
    0x571f,
    0x5974,
    0x6012,
    0x5012,
    0x515a,
    0x51ac,
    CP932_CP_VAL_NULL,
    0x51cd,
    0x5200,
    0x5510,
    0x5854,
    0x5858,
    0x5957,
    0x5b95,
    0x5cf6,
    0x5d8b,
    0x60bc,
    0x6295,
    0x642d,
    0x6771,
    0x6843,
    0x68bc,
    0x68df,
    0x76d7,
    0x6dd8,
    0x6e6f,
    0x6d9b,
    0x706f,
    0x71c8,
    0x5f53,
    0x75d8,
    0x7977,
    0x7b49,
    0x7b54,
    0x7b52,
    0x7cd6,
    0x7d71,
    0x5230,
    0x8463,
    0x8569,
    0x85e4,
    0x8a0e,
    0x8b04,
    0x8c46,
    0x8e0f,
    0x9003,
    0x900f,
    0x9419,
    0x9676,
    0x982d,
    0x9a30,
    0x95d8,
    0x50cd,
    0x52d5,
    0x540c,
    0x5802,
    0x5c0e,
    0x61a7,
    0x649e,
    0x6d1e,
    0x77b3,
    0x7ae5,
    0x80f4,
    0x8404,
    0x9053,
    0x9285,
    0x5ce0,
    0x9d07,
    0x533f,
    0x5f97,
    0x5fb3,
    0x6d9c,
    0x7279,
    0x7763,
    0x79bf,
    0x7be4,
    0x6bd2,
    0x72ec,
    0x8aad,
    0x6803,
    0x6a61,
    0x51f8,
    0x7a81,
    0x6934,
    0x5c4a,
    0x9cf6,
    0x82eb,
    0x5bc5,
    0x9149,
    0x701e,
    0x5678,
    0x5c6f,
    0x60c7,
    0x6566,
    0x6c8c,
    0x8c5a,
    0x9041,
    0x9813,
    0x5451,
    0x66c7,
    0x920d,
    0x5948,
    0x90a3,
    0x5185,
    0x4e4d,
    0x51ea,
    0x8599,
    0x8b0e,
    0x7058,
    0x637a,
    0x934b,
    0x6962,
    0x99b4,
    0x7e04,
    0x7577,
    0x5357,
    0x6960,
    0x8edf,
    0x96e3,
    0x6c5d,
    0x4e8c,
    0x5c3c,
    0x5f10,
    0x8fe9,
    0x5302,
    0x8cd1,
    0x8089,
    0x8679,
    0x5eff,
    0x65e5,
    0x4e73,
    0x5165,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL
};
UINT16 cp932_CP_a0x94[] = {
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x5982,
    0x5c3f,
    0x97ee,
    0x4efb,
    0x598a,
    0x5fcd,
    0x8a8d,
    0x6fe1,
    0x79b0,
    0x7962,
    0x5be7,
    0x8471,
    0x732b,
    0x71b1,
    0x5e74,
    0x5ff5,
    0x637b,
    0x649a,
    0x71c3,
    0x7c98,
    0x4e43,
    0x5efc,
    0x4e4b,
    0x57dc,
    0x56a2,
    0x60a9,
    0x6fc3,
    0x7d0d,
    0x80fd,
    0x8133,
    0x81bf,
    0x8fb2,
    0x8997,
    0x86a4,
    0x5df4,
    0x628a,
    0x64ad,
    0x8987,
    0x6777,
    0x6ce2,
    0x6d3e,
    0x7436,
    0x7834,
    0x5a46,
    0x7f75,
    0x82ad,
    0x99ac,
    0x4ff3,
    0x5ec3,
    0x62dd,
    0x6392,
    0x6557,
    0x676f,
    0x76c3,
    0x724c,
    0x80cc,
    0x80ba,
    0x8f29,
    0x914d,
    0x500d,
    0x57f9,
    0x5a92,
    0x6885,
    CP932_CP_VAL_NULL,
    0x6973,
    0x7164,
    0x72fd,
    0x8cb7,
    0x58f2,
    0x8ce0,
    0x966a,
    0x9019,
    0x877f,
    0x79e4,
    0x77e7,
    0x8429,
    0x4f2f,
    0x5265,
    0x535a,
    0x62cd,
    0x67cf,
    0x6cca,
    0x767d,
    0x7b94,
    0x7c95,
    0x8236,
    0x8584,
    0x8feb,
    0x66dd,
    0x6f20,
    0x7206,
    0x7e1b,
    0x83ab,
    0x99c1,
    0x9ea6,
    0x51fd,
    0x7bb1,
    0x7872,
    0x7bb8,
    0x8087,
    0x7b48,
    0x6ae8,
    0x5e61,
    0x808c,
    0x7551,
    0x7560,
    0x516b,
    0x9262,
    0x6e8c,
    0x767a,
    0x9197,
    0x9aea,
    0x4f10,
    0x7f70,
    0x629c,
    0x7b4f,
    0x95a5,
    0x9ce9,
    0x567a,
    0x5859,
    0x86e4,
    0x96bc,
    0x4f34,
    0x5224,
    0x534a,
    0x53cd,
    0x53db,
    0x5e06,
    0x642c,
    0x6591,
    0x677f,
    0x6c3e,
    0x6c4e,
    0x7248,
    0x72af,
    0x73ed,
    0x7554,
    0x7e41,
    0x822c,
    0x85e9,
    0x8ca9,
    0x7bc4,
    0x91c6,
    0x7169,
    0x9812,
    0x98ef,
    0x633d,
    0x6669,
    0x756a,
    0x76e4,
    0x78d0,
    0x8543,
    0x86ee,
    0x532a,
    0x5351,
    0x5426,
    0x5983,
    0x5e87,
    0x5f7c,
    0x60b2,
    0x6249,
    0x6279,
    0x62ab,
    0x6590,
    0x6bd4,
    0x6ccc,
    0x75b2,
    0x76ae,
    0x7891,
    0x79d8,
    0x7dcb,
    0x7f77,
    0x80a5,
    0x88ab,
    0x8ab9,
    0x8cbb,
    0x907f,
    0x975e,
    0x98db,
    0x6a0b,
    0x7c38,
    0x5099,
    0x5c3e,
    0x5fae,
    0x6787,
    0x6bd8,
    0x7435,
    0x7709,
    0x7f8e,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL
};
UINT16 cp932_CP_a0x95[] = {
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x9f3b,
    0x67ca,
    0x7a17,
    0x5339,
    0x758b,
    0x9aed,
    0x5f66,
    0x819d,
    0x83f1,
    0x8098,
    0x5f3c,
    0x5fc5,
    0x7562,
    0x7b46,
    0x903c,
    0x6867,
    0x59eb,
    0x5a9b,
    0x7d10,
    0x767e,
    0x8b2c,
    0x4ff5,
    0x5f6a,
    0x6a19,
    0x6c37,
    0x6f02,
    0x74e2,
    0x7968,
    0x8868,
    0x8a55,
    0x8c79,
    0x5edf,
    0x63cf,
    0x75c5,
    0x79d2,
    0x82d7,
    0x9328,
    0x92f2,
    0x849c,
    0x86ed,
    0x9c2d,
    0x54c1,
    0x5f6c,
    0x658c,
    0x6d5c,
    0x7015,
    0x8ca7,
    0x8cd3,
    0x983b,
    0x654f,
    0x74f6,
    0x4e0d,
    0x4ed8,
    0x57e0,
    0x592b,
    0x5a66,
    0x5bcc,
    0x51a8,
    0x5e03,
    0x5e9c,
    0x6016,
    0x6276,
    0x6577,
    CP932_CP_VAL_NULL,
    0x65a7,
    0x666e,
    0x6d6e,
    0x7236,
    0x7b26,
    0x8150,
    0x819a,
    0x8299,
    0x8b5c,
    0x8ca0,
    0x8ce6,
    0x8d74,
    0x961c,
    0x9644,
    0x4fae,
    0x64ab,
    0x6b66,
    0x821e,
    0x8461,
    0x856a,
    0x90e8,
    0x5c01,
    0x6953,
    0x98a8,
    0x847a,
    0x8557,
    0x4f0f,
    0x526f,
    0x5fa9,
    0x5e45,
    0x670d,
    0x798f,
    0x8179,
    0x8907,
    0x8986,
    0x6df5,
    0x5f17,
    0x6255,
    0x6cb8,
    0x4ecf,
    0x7269,
    0x9b92,
    0x5206,
    0x543b,
    0x5674,
    0x58b3,
    0x61a4,
    0x626e,
    0x711a,
    0x596e,
    0x7c89,
    0x7cde,
    0x7d1b,
    0x96f0,
    0x6587,
    0x805e,
    0x4e19,
    0x4f75,
    0x5175,
    0x5840,
    0x5e63,
    0x5e73,
    0x5f0a,
    0x67c4,
    0x4e26,
    0x853d,
    0x9589,
    0x965b,
    0x7c73,
    0x9801,
    0x50fb,
    0x58c1,
    0x7656,
    0x78a7,
    0x5225,
    0x77a5,
    0x8511,
    0x7b86,
    0x504f,
    0x5909,
    0x7247,
    0x7bc7,
    0x7de8,
    0x8fba,
    0x8fd4,
    0x904d,
    0x4fbf,
    0x52c9,
    0x5a29,
    0x5f01,
    0x97ad,
    0x4fdd,
    0x8217,
    0x92ea,
    0x5703,
    0x6355,
    0x6b69,
    0x752b,
    0x88dc,
    0x8f14,
    0x7a42,
    0x52df,
    0x5893,
    0x6155,
    0x620a,
    0x66ae,
    0x6bcd,
    0x7c3f,
    0x83e9,
    0x5023,
    0x4ff8,
    0x5305,
    0x5446,
    0x5831,
    0x5949,
    0x5b9d,
    0x5cf0,
    0x5cef,
    0x5d29,
    0x5e96,
    0x62b1,
    0x6367,
    0x653e,
    0x65b9,
    0x670b,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL
};
UINT16 cp932_CP_a0x96[] = {
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x6cd5,
    0x6ce1,
    0x70f9,
    0x7832,
    0x7e2b,
    0x80de,
    0x82b3,
    0x840c,
    0x84ec,
    0x8702,
    0x8912,
    0x8a2a,
    0x8c4a,
    0x90a6,
    0x92d2,
    0x98fd,
    0x9cf3,
    0x9d6c,
    0x4e4f,
    0x4ea1,
    0x508d,
    0x5256,
    0x574a,
    0x59a8,
    0x5e3d,
    0x5fd8,
    0x5fd9,
    0x623f,
    0x66b4,
    0x671b,
    0x67d0,
    0x68d2,
    0x5192,
    0x7d21,
    0x80aa,
    0x81a8,
    0x8b00,
    0x8c8c,
    0x8cbf,
    0x927e,
    0x9632,
    0x5420,
    0x982c,
    0x5317,
    0x50d5,
    0x535c,
    0x58a8,
    0x64b2,
    0x6734,
    0x7267,
    0x7766,
    0x7a46,
    0x91e6,
    0x52c3,
    0x6ca1,
    0x6b86,
    0x5800,
    0x5e4c,
    0x5954,
    0x672c,
    0x7ffb,
    0x51e1,
    0x76c6,
    CP932_CP_VAL_NULL,
    0x6469,
    0x78e8,
    0x9b54,
    0x9ebb,
    0x57cb,
    0x59b9,
    0x6627,
    0x679a,
    0x6bce,
    0x54e9,
    0x69d9,
    0x5e55,
    0x819c,
    0x6795,
    0x9baa,
    0x67fe,
    0x9c52,
    0x685d,
    0x4ea6,
    0x4fe3,
    0x53c8,
    0x62b9,
    0x672b,
    0x6cab,
    0x8fc4,
    0x4fad,
    0x7e6d,
    0x9ebf,
    0x4e07,
    0x6162,
    0x6e80,
    0x6f2b,
    0x8513,
    0x5473,
    0x672a,
    0x9b45,
    0x5df3,
    0x7b95,
    0x5cac,
    0x5bc6,
    0x871c,
    0x6e4a,
    0x84d1,
    0x7a14,
    0x8108,
    0x5999,
    0x7c8d,
    0x6c11,
    0x7720,
    0x52d9,
    0x5922,
    0x7121,
    0x725f,
    0x77db,
    0x9727,
    0x9d61,
    0x690b,
    0x5a7f,
    0x5a18,
    0x51a5,
    0x540d,
    0x547d,
    0x660e,
    0x76df,
    0x8ff7,
    0x9298,
    0x9cf4,
    0x59ea,
    0x725d,
    0x6ec5,
    0x514d,
    0x68c9,
    0x7dbf,
    0x7dec,
    0x9762,
    0x9eba,
    0x6478,
    0x6a21,
    0x8302,
    0x5984,
    0x5b5f,
    0x6bdb,
    0x731b,
    0x76f2,
    0x7db2,
    0x8017,
    0x8499,
    0x5132,
    0x6728,
    0x9ed9,
    0x76ee,
    0x6762,
    0x52ff,
    0x9905,
    0x5c24,
    0x623b,
    0x7c7e,
    0x8cb0,
    0x554f,
    0x60b6,
    0x7d0b,
    0x9580,
    0x5301,
    0x4e5f,
    0x51b6,
    0x591c,
    0x723a,
    0x8036,
    0x91ce,
    0x5f25,
    0x77e2,
    0x5384,
    0x5f79,
    0x7d04,
    0x85ac,
    0x8a33,
    0x8e8d,
    0x9756,
    0x67f3,
    0x85ae,
    0x9453,
    0x6109,
    0x6108,
    0x6cb9,
    0x7652,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL
};
UINT16 cp932_CP_a0x97[] = {
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x8aed,
    0x8f38,
    0x552f,
    0x4f51,
    0x512a,
    0x52c7,
    0x53cb,
    0x5ba5,
    0x5e7d,
    0x60a0,
    0x6182,
    0x63d6,
    0x6709,
    0x67da,
    0x6e67,
    0x6d8c,
    0x7336,
    0x7337,
    0x7531,
    0x7950,
    0x88d5,
    0x8a98,
    0x904a,
    0x9091,
    0x90f5,
    0x96c4,
    0x878d,
    0x5915,
    0x4e88,
    0x4f59,
    0x4e0e,
    0x8a89,
    0x8f3f,
    0x9810,
    0x50ad,
    0x5e7c,
    0x5996,
    0x5bb9,
    0x5eb8,
    0x63da,
    0x63fa,
    0x64c1,
    0x66dc,
    0x694a,
    0x69d8,
    0x6d0b,
    0x6eb6,
    0x7194,
    0x7528,
    0x7aaf,
    0x7f8a,
    0x8000,
    0x8449,
    0x84c9,
    0x8981,
    0x8b21,
    0x8e0a,
    0x9065,
    0x967d,
    0x990a,
    0x617e,
    0x6291,
    0x6b32,
    CP932_CP_VAL_NULL,
    0x6c83,
    0x6d74,
    0x7fcc,
    0x7ffc,
    0x6dc0,
    0x7f85,
    0x87ba,
    0x88f8,
    0x6765,
    0x83b1,
    0x983c,
    0x96f7,
    0x6d1b,
    0x7d61,
    0x843d,
    0x916a,
    0x4e71,
    0x5375,
    0x5d50,
    0x6b04,
    0x6feb,
    0x85cd,
    0x862d,
    0x89a7,
    0x5229,
    0x540f,
    0x5c65,
    0x674e,
    0x68a8,
    0x7406,
    0x7483,
    0x75e2,
    0x88cf,
    0x88e1,
    0x91cc,
    0x96e2,
    0x9678,
    0x5f8b,
    0x7387,
    0x7acb,
    0x844e,
    0x63a0,
    0x7565,
    0x5289,
    0x6d41,
    0x6e9c,
    0x7409,
    0x7559,
    0x786b,
    0x7c92,
    0x9686,
    0x7adc,
    0x9f8d,
    0x4fb6,
    0x616e,
    0x65c5,
    0x865c,
    0x4e86,
    0x4eae,
    0x50da,
    0x4e21,
    0x51cc,
    0x5bee,
    0x6599,
    0x6881,
    0x6dbc,
    0x731f,
    0x7642,
    0x77ad,
    0x7a1c,
    0x7ce7,
    0x826f,
    0x8ad2,
    0x907c,
    0x91cf,
    0x9675,
    0x9818,
    0x529b,
    0x7dd1,
    0x502b,
    0x5398,
    0x6797,
    0x6dcb,
    0x71d0,
    0x7433,
    0x81e8,
    0x8f2a,
    0x96a3,
    0x9c57,
    0x9e9f,
    0x7460,
    0x5841,
    0x6d99,
    0x7d2f,
    0x985e,
    0x4ee4,
    0x4f36,
    0x4f8b,
    0x51b7,
    0x52b1,
    0x5dba,
    0x601c,
    0x73b2,
    0x793c,
    0x82d3,
    0x9234,
    0x96b7,
    0x96f6,
    0x970a,
    0x9e97,
    0x9f62,
    0x66a6,
    0x6b74,
    0x5217,
    0x52a3,
    0x70c8,
    0x88c2,
    0x5ec9,
    0x604b,
    0x6190,
    0x6f23,
    0x7149,
    0x7c3e,
    0x7df4,
    0x806f,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL
};
UINT16 cp932_CP_a0x98[] = {
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x84ee,
    0x9023,
    0x932c,
    0x5442,
    0x9b6f,
    0x6ad3,
    0x7089,
    0x8cc2,
    0x8def,
    0x9732,
    0x52b4,
    0x5a41,
    0x5eca,
    0x5f04,
    0x6717,
    0x697c,
    0x6994,
    0x6d6a,
    0x6f0f,
    0x7262,
    0x72fc,
    0x7bed,
    0x8001,
    0x807e,
    0x874b,
    0x90ce,
    0x516d,
    0x9e93,
    0x7984,
    0x808b,
    0x9332,
    0x8ad6,
    0x502d,
    0x548c,
    0x8a71,
    0x6b6a,
    0x8cc4,
    0x8107,
    0x60d1,
    0x67a0,
    0x9df2,
    0x4e99,
    0x4e98,
    0x9c10,
    0x8a6b,
    0x85c1,
    0x8568,
    0x6900,
    0x6e7e,
    0x7897,
    0x8155,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x5f0c,
    0x4e10,
    0x4e15,
    0x4e2a,
    0x4e31,
    0x4e36,
    0x4e3c,
    0x4e3f,
    0x4e42,
    0x4e56,
    0x4e58,
    0x4e82,
    0x4e85,
    0x8c6b,
    0x4e8a,
    0x8212,
    0x5f0d,
    0x4e8e,
    0x4e9e,
    0x4e9f,
    0x4ea0,
    0x4ea2,
    0x4eb0,
    0x4eb3,
    0x4eb6,
    0x4ece,
    0x4ecd,
    0x4ec4,
    0x4ec6,
    0x4ec2,
    0x4ed7,
    0x4ede,
    0x4eed,
    0x4edf,
    0x4ef7,
    0x4f09,
    0x4f5a,
    0x4f30,
    0x4f5b,
    0x4f5d,
    0x4f57,
    0x4f47,
    0x4f76,
    0x4f88,
    0x4f8f,
    0x4f98,
    0x4f7b,
    0x4f69,
    0x4f70,
    0x4f91,
    0x4f6f,
    0x4f86,
    0x4f96,
    0x5118,
    0x4fd4,
    0x4fdf,
    0x4fce,
    0x4fd8,
    0x4fdb,
    0x4fd1,
    0x4fda,
    0x4fd0,
    0x4fe4,
    0x4fe5,
    0x501a,
    0x5028,
    0x5014,
    0x502a,
    0x5025,
    0x5005,
    0x4f1c,
    0x4ff6,
    0x5021,
    0x5029,
    0x502c,
    0x4ffe,
    0x4fef,
    0x5011,
    0x5006,
    0x5043,
    0x5047,
    0x6703,
    0x5055,
    0x5050,
    0x5048,
    0x505a,
    0x5056,
    0x506c,
    0x5078,
    0x5080,
    0x509a,
    0x5085,
    0x50b4,
    0x50b2,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL
};
UINT16 cp932_CP_a0x99[] = {
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x50c9,
    0x50ca,
    0x50b3,
    0x50c2,
    0x50d6,
    0x50de,
    0x50e5,
    0x50ed,
    0x50e3,
    0x50ee,
    0x50f9,
    0x50f5,
    0x5109,
    0x5101,
    0x5102,
    0x5116,
    0x5115,
    0x5114,
    0x511a,
    0x5121,
    0x513a,
    0x5137,
    0x513c,
    0x513b,
    0x513f,
    0x5140,
    0x5152,
    0x514c,
    0x5154,
    0x5162,
    0x7af8,
    0x5169,
    0x516a,
    0x516e,
    0x5180,
    0x5182,
    0x56d8,
    0x518c,
    0x5189,
    0x518f,
    0x5191,
    0x5193,
    0x5195,
    0x5196,
    0x51a4,
    0x51a6,
    0x51a2,
    0x51a9,
    0x51aa,
    0x51ab,
    0x51b3,
    0x51b1,
    0x51b2,
    0x51b0,
    0x51b5,
    0x51bd,
    0x51c5,
    0x51c9,
    0x51db,
    0x51e0,
    0x8655,
    0x51e9,
    0x51ed,
    CP932_CP_VAL_NULL,
    0x51f0,
    0x51f5,
    0x51fe,
    0x5204,
    0x520b,
    0x5214,
    0x520e,
    0x5227,
    0x522a,
    0x522e,
    0x5233,
    0x5239,
    0x524f,
    0x5244,
    0x524b,
    0x524c,
    0x525e,
    0x5254,
    0x526a,
    0x5274,
    0x5269,
    0x5273,
    0x527f,
    0x527d,
    0x528d,
    0x5294,
    0x5292,
    0x5271,
    0x5288,
    0x5291,
    0x8fa8,
    0x8fa7,
    0x52ac,
    0x52ad,
    0x52bc,
    0x52b5,
    0x52c1,
    0x52cd,
    0x52d7,
    0x52de,
    0x52e3,
    0x52e6,
    0x98ed,
    0x52e0,
    0x52f3,
    0x52f5,
    0x52f8,
    0x52f9,
    0x5306,
    0x5308,
    0x7538,
    0x530d,
    0x5310,
    0x530f,
    0x5315,
    0x531a,
    0x5323,
    0x532f,
    0x5331,
    0x5333,
    0x5338,
    0x5340,
    0x5346,
    0x5345,
    0x4e17,
    0x5349,
    0x534d,
    0x51d6,
    0x535e,
    0x5369,
    0x536e,
    0x5918,
    0x537b,
    0x5377,
    0x5382,
    0x5396,
    0x53a0,
    0x53a6,
    0x53a5,
    0x53ae,
    0x53b0,
    0x53b6,
    0x53c3,
    0x7c12,
    0x96d9,
    0x53df,
    0x66fc,
    0x71ee,
    0x53ee,
    0x53e8,
    0x53ed,
    0x53fa,
    0x5401,
    0x543d,
    0x5440,
    0x542c,
    0x542d,
    0x543c,
    0x542e,
    0x5436,
    0x5429,
    0x541d,
    0x544e,
    0x548f,
    0x5475,
    0x548e,
    0x545f,
    0x5471,
    0x5477,
    0x5470,
    0x5492,
    0x547b,
    0x5480,
    0x5476,
    0x5484,
    0x5490,
    0x5486,
    0x54c7,
    0x54a2,
    0x54b8,
    0x54a5,
    0x54ac,
    0x54c4,
    0x54c8,
    0x54a8,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL
};
UINT16 cp932_CP_a0x9a[] = {
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x54ab,
    0x54c2,
    0x54a4,
    0x54be,
    0x54bc,
    0x54d8,
    0x54e5,
    0x54e6,
    0x550f,
    0x5514,
    0x54fd,
    0x54ee,
    0x54ed,
    0x54fa,
    0x54e2,
    0x5539,
    0x5540,
    0x5563,
    0x554c,
    0x552e,
    0x555c,
    0x5545,
    0x5556,
    0x5557,
    0x5538,
    0x5533,
    0x555d,
    0x5599,
    0x5580,
    0x54af,
    0x558a,
    0x559f,
    0x557b,
    0x557e,
    0x5598,
    0x559e,
    0x55ae,
    0x557c,
    0x5583,
    0x55a9,
    0x5587,
    0x55a8,
    0x55da,
    0x55c5,
    0x55df,
    0x55c4,
    0x55dc,
    0x55e4,
    0x55d4,
    0x5614,
    0x55f7,
    0x5616,
    0x55fe,
    0x55fd,
    0x561b,
    0x55f9,
    0x564e,
    0x5650,
    0x71df,
    0x5634,
    0x5636,
    0x5632,
    0x5638,
    CP932_CP_VAL_NULL,
    0x566b,
    0x5664,
    0x562f,
    0x566c,
    0x566a,
    0x5686,
    0x5680,
    0x568a,
    0x56a0,
    0x5694,
    0x568f,
    0x56a5,
    0x56ae,
    0x56b6,
    0x56b4,
    0x56c2,
    0x56bc,
    0x56c1,
    0x56c3,
    0x56c0,
    0x56c8,
    0x56ce,
    0x56d1,
    0x56d3,
    0x56d7,
    0x56ee,
    0x56f9,
    0x5700,
    0x56ff,
    0x5704,
    0x5709,
    0x5708,
    0x570b,
    0x570d,
    0x5713,
    0x5718,
    0x5716,
    0x55c7,
    0x571c,
    0x5726,
    0x5737,
    0x5738,
    0x574e,
    0x573b,
    0x5740,
    0x574f,
    0x5769,
    0x57c0,
    0x5788,
    0x5761,
    0x577f,
    0x5789,
    0x5793,
    0x57a0,
    0x57b3,
    0x57a4,
    0x57aa,
    0x57b0,
    0x57c3,
    0x57c6,
    0x57d4,
    0x57d2,
    0x57d3,
    0x580a,
    0x57d6,
    0x57e3,
    0x580b,
    0x5819,
    0x581d,
    0x5872,
    0x5821,
    0x5862,
    0x584b,
    0x5870,
    0x6bc0,
    0x5852,
    0x583d,
    0x5879,
    0x5885,
    0x58b9,
    0x589f,
    0x58ab,
    0x58ba,
    0x58de,
    0x58bb,
    0x58b8,
    0x58ae,
    0x58c5,
    0x58d3,
    0x58d1,
    0x58d7,
    0x58d9,
    0x58d8,
    0x58e5,
    0x58dc,
    0x58e4,
    0x58df,
    0x58ef,
    0x58fa,
    0x58f9,
    0x58fb,
    0x58fc,
    0x58fd,
    0x5902,
    0x590a,
    0x5910,
    0x591b,
    0x68a6,
    0x5925,
    0x592c,
    0x592d,
    0x5932,
    0x5938,
    0x593e,
    0x7ad2,
    0x5955,
    0x5950,
    0x594e,
    0x595a,
    0x5958,
    0x5962,
    0x5960,
    0x5967,
    0x596c,
    0x5969,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL
};
UINT16 cp932_CP_a0x9b[] = {
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x5978,
    0x5981,
    0x599d,
    0x4f5e,
    0x4fab,
    0x59a3,
    0x59b2,
    0x59c6,
    0x59e8,
    0x59dc,
    0x598d,
    0x59d9,
    0x59da,
    0x5a25,
    0x5a1f,
    0x5a11,
    0x5a1c,
    0x5a09,
    0x5a1a,
    0x5a40,
    0x5a6c,
    0x5a49,
    0x5a35,
    0x5a36,
    0x5a62,
    0x5a6a,
    0x5a9a,
    0x5abc,
    0x5abe,
    0x5acb,
    0x5ac2,
    0x5abd,
    0x5ae3,
    0x5ad7,
    0x5ae6,
    0x5ae9,
    0x5ad6,
    0x5afa,
    0x5afb,
    0x5b0c,
    0x5b0b,
    0x5b16,
    0x5b32,
    0x5ad0,
    0x5b2a,
    0x5b36,
    0x5b3e,
    0x5b43,
    0x5b45,
    0x5b40,
    0x5b51,
    0x5b55,
    0x5b5a,
    0x5b5b,
    0x5b65,
    0x5b69,
    0x5b70,
    0x5b73,
    0x5b75,
    0x5b78,
    0x6588,
    0x5b7a,
    0x5b80,
    CP932_CP_VAL_NULL,
    0x5b83,
    0x5ba6,
    0x5bb8,
    0x5bc3,
    0x5bc7,
    0x5bc9,
    0x5bd4,
    0x5bd0,
    0x5be4,
    0x5be6,
    0x5be2,
    0x5bde,
    0x5be5,
    0x5beb,
    0x5bf0,
    0x5bf6,
    0x5bf3,
    0x5c05,
    0x5c07,
    0x5c08,
    0x5c0d,
    0x5c13,
    0x5c20,
    0x5c22,
    0x5c28,
    0x5c38,
    0x5c39,
    0x5c41,
    0x5c46,
    0x5c4e,
    0x5c53,
    0x5c50,
    0x5c4f,
    0x5b71,
    0x5c6c,
    0x5c6e,
    0x4e62,
    0x5c76,
    0x5c79,
    0x5c8c,
    0x5c91,
    0x5c94,
    0x599b,
    0x5cab,
    0x5cbb,
    0x5cb6,
    0x5cbc,
    0x5cb7,
    0x5cc5,
    0x5cbe,
    0x5cc7,
    0x5cd9,
    0x5ce9,
    0x5cfd,
    0x5cfa,
    0x5ced,
    0x5d8c,
    0x5cea,
    0x5d0b,
    0x5d15,
    0x5d17,
    0x5d5c,
    0x5d1f,
    0x5d1b,
    0x5d11,
    0x5d14,
    0x5d22,
    0x5d1a,
    0x5d19,
    0x5d18,
    0x5d4c,
    0x5d52,
    0x5d4e,
    0x5d4b,
    0x5d6c,
    0x5d73,
    0x5d76,
    0x5d87,
    0x5d84,
    0x5d82,
    0x5da2,
    0x5d9d,
    0x5dac,
    0x5dae,
    0x5dbd,
    0x5d90,
    0x5db7,
    0x5dbc,
    0x5dc9,
    0x5dcd,
    0x5dd3,
    0x5dd2,
    0x5dd6,
    0x5ddb,
    0x5deb,
    0x5df2,
    0x5df5,
    0x5e0b,
    0x5e1a,
    0x5e19,
    0x5e11,
    0x5e1b,
    0x5e36,
    0x5e37,
    0x5e44,
    0x5e43,
    0x5e40,
    0x5e4e,
    0x5e57,
    0x5e54,
    0x5e5f,
    0x5e62,
    0x5e64,
    0x5e47,
    0x5e75,
    0x5e76,
    0x5e7a,
    0x9ebc,
    0x5e7f,
    0x5ea0,
    0x5ec1,
    0x5ec2,
    0x5ec8,
    0x5ed0,
    0x5ecf,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL
};
UINT16 cp932_CP_a0x9c[] = {
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x5ed6,
    0x5ee3,
    0x5edd,
    0x5eda,
    0x5edb,
    0x5ee2,
    0x5ee1,
    0x5ee8,
    0x5ee9,
    0x5eec,
    0x5ef1,
    0x5ef3,
    0x5ef0,
    0x5ef4,
    0x5ef8,
    0x5efe,
    0x5f03,
    0x5f09,
    0x5f5d,
    0x5f5c,
    0x5f0b,
    0x5f11,
    0x5f16,
    0x5f29,
    0x5f2d,
    0x5f38,
    0x5f41,
    0x5f48,
    0x5f4c,
    0x5f4e,
    0x5f2f,
    0x5f51,
    0x5f56,
    0x5f57,
    0x5f59,
    0x5f61,
    0x5f6d,
    0x5f73,
    0x5f77,
    0x5f83,
    0x5f82,
    0x5f7f,
    0x5f8a,
    0x5f88,
    0x5f91,
    0x5f87,
    0x5f9e,
    0x5f99,
    0x5f98,
    0x5fa0,
    0x5fa8,
    0x5fad,
    0x5fbc,
    0x5fd6,
    0x5ffb,
    0x5fe4,
    0x5ff8,
    0x5ff1,
    0x5fdd,
    0x60b3,
    0x5fff,
    0x6021,
    0x6060,
    CP932_CP_VAL_NULL,
    0x6019,
    0x6010,
    0x6029,
    0x600e,
    0x6031,
    0x601b,
    0x6015,
    0x602b,
    0x6026,
    0x600f,
    0x603a,
    0x605a,
    0x6041,
    0x606a,
    0x6077,
    0x605f,
    0x604a,
    0x6046,
    0x604d,
    0x6063,
    0x6043,
    0x6064,
    0x6042,
    0x606c,
    0x606b,
    0x6059,
    0x6081,
    0x608d,
    0x60e7,
    0x6083,
    0x609a,
    0x6084,
    0x609b,
    0x6096,
    0x6097,
    0x6092,
    0x60a7,
    0x608b,
    0x60e1,
    0x60b8,
    0x60e0,
    0x60d3,
    0x60b4,
    0x5ff0,
    0x60bd,
    0x60c6,
    0x60b5,
    0x60d8,
    0x614d,
    0x6115,
    0x6106,
    0x60f6,
    0x60f7,
    0x6100,
    0x60f4,
    0x60fa,
    0x6103,
    0x6121,
    0x60fb,
    0x60f1,
    0x610d,
    0x610e,
    0x6147,
    0x613e,
    0x6128,
    0x6127,
    0x614a,
    0x613f,
    0x613c,
    0x612c,
    0x6134,
    0x613d,
    0x6142,
    0x6144,
    0x6173,
    0x6177,
    0x6158,
    0x6159,
    0x615a,
    0x616b,
    0x6174,
    0x616f,
    0x6165,
    0x6171,
    0x615f,
    0x615d,
    0x6153,
    0x6175,
    0x6199,
    0x6196,
    0x6187,
    0x61ac,
    0x6194,
    0x619a,
    0x618a,
    0x6191,
    0x61ab,
    0x61ae,
    0x61cc,
    0x61ca,
    0x61c9,
    0x61f7,
    0x61c8,
    0x61c3,
    0x61c6,
    0x61ba,
    0x61cb,
    0x7f79,
    0x61cd,
    0x61e6,
    0x61e3,
    0x61f6,
    0x61fa,
    0x61f4,
    0x61ff,
    0x61fd,
    0x61fc,
    0x61fe,
    0x6200,
    0x6208,
    0x6209,
    0x620d,
    0x620c,
    0x6214,
    0x621b,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL
};
UINT16 cp932_CP_a0x9d[] = {
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x621e,
    0x6221,
    0x622a,
    0x622e,
    0x6230,
    0x6232,
    0x6233,
    0x6241,
    0x624e,
    0x625e,
    0x6263,
    0x625b,
    0x6260,
    0x6268,
    0x627c,
    0x6282,
    0x6289,
    0x627e,
    0x6292,
    0x6293,
    0x6296,
    0x62d4,
    0x6283,
    0x6294,
    0x62d7,
    0x62d1,
    0x62bb,
    0x62cf,
    0x62ff,
    0x62c6,
    0x64d4,
    0x62c8,
    0x62dc,
    0x62cc,
    0x62ca,
    0x62c2,
    0x62c7,
    0x629b,
    0x62c9,
    0x630c,
    0x62ee,
    0x62f1,
    0x6327,
    0x6302,
    0x6308,
    0x62ef,
    0x62f5,
    0x6350,
    0x633e,
    0x634d,
    0x641c,
    0x634f,
    0x6396,
    0x638e,
    0x6380,
    0x63ab,
    0x6376,
    0x63a3,
    0x638f,
    0x6389,
    0x639f,
    0x63b5,
    0x636b,
    CP932_CP_VAL_NULL,
    0x6369,
    0x63be,
    0x63e9,
    0x63c0,
    0x63c6,
    0x63e3,
    0x63c9,
    0x63d2,
    0x63f6,
    0x63c4,
    0x6416,
    0x6434,
    0x6406,
    0x6413,
    0x6426,
    0x6436,
    0x651d,
    0x6417,
    0x6428,
    0x640f,
    0x6467,
    0x646f,
    0x6476,
    0x644e,
    0x652a,
    0x6495,
    0x6493,
    0x64a5,
    0x64a9,
    0x6488,
    0x64bc,
    0x64da,
    0x64d2,
    0x64c5,
    0x64c7,
    0x64bb,
    0x64d8,
    0x64c2,
    0x64f1,
    0x64e7,
    0x8209,
    0x64e0,
    0x64e1,
    0x62ac,
    0x64e3,
    0x64ef,
    0x652c,
    0x64f6,
    0x64f4,
    0x64f2,
    0x64fa,
    0x6500,
    0x64fd,
    0x6518,
    0x651c,
    0x6505,
    0x6524,
    0x6523,
    0x652b,
    0x6534,
    0x6535,
    0x6537,
    0x6536,
    0x6538,
    0x754b,
    0x6548,
    0x6556,
    0x6555,
    0x654d,
    0x6558,
    0x655e,
    0x655d,
    0x6572,
    0x6578,
    0x6582,
    0x6583,
    0x8b8a,
    0x659b,
    0x659f,
    0x65ab,
    0x65b7,
    0x65c3,
    0x65c6,
    0x65c1,
    0x65c4,
    0x65cc,
    0x65d2,
    0x65db,
    0x65d9,
    0x65e0,
    0x65e1,
    0x65f1,
    0x6772,
    0x660a,
    0x6603,
    0x65fb,
    0x6773,
    0x6635,
    0x6636,
    0x6634,
    0x661c,
    0x664f,
    0x6644,
    0x6649,
    0x6641,
    0x665e,
    0x665d,
    0x6664,
    0x6667,
    0x6668,
    0x665f,
    0x6662,
    0x6670,
    0x6683,
    0x6688,
    0x668e,
    0x6689,
    0x6684,
    0x6698,
    0x669d,
    0x66c1,
    0x66b9,
    0x66c9,
    0x66be,
    0x66bc,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL
};
UINT16 cp932_CP_a0x9e[] = {
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x66c4,
    0x66b8,
    0x66d6,
    0x66da,
    0x66e0,
    0x663f,
    0x66e6,
    0x66e9,
    0x66f0,
    0x66f5,
    0x66f7,
    0x670f,
    0x6716,
    0x671e,
    0x6726,
    0x6727,
    0x9738,
    0x672e,
    0x673f,
    0x6736,
    0x6741,
    0x6738,
    0x6737,
    0x6746,
    0x675e,
    0x6760,
    0x6759,
    0x6763,
    0x6764,
    0x6789,
    0x6770,
    0x67a9,
    0x677c,
    0x676a,
    0x678c,
    0x678b,
    0x67a6,
    0x67a1,
    0x6785,
    0x67b7,
    0x67ef,
    0x67b4,
    0x67ec,
    0x67b3,
    0x67e9,
    0x67b8,
    0x67e4,
    0x67de,
    0x67dd,
    0x67e2,
    0x67ee,
    0x67b9,
    0x67ce,
    0x67c6,
    0x67e7,
    0x6a9c,
    0x681e,
    0x6846,
    0x6829,
    0x6840,
    0x684d,
    0x6832,
    0x684e,
    CP932_CP_VAL_NULL,
    0x68b3,
    0x682b,
    0x6859,
    0x6863,
    0x6877,
    0x687f,
    0x689f,
    0x688f,
    0x68ad,
    0x6894,
    0x689d,
    0x689b,
    0x6883,
    0x6aae,
    0x68b9,
    0x6874,
    0x68b5,
    0x68a0,
    0x68ba,
    0x690f,
    0x688d,
    0x687e,
    0x6901,
    0x68ca,
    0x6908,
    0x68d8,
    0x6922,
    0x6926,
    0x68e1,
    0x690c,
    0x68cd,
    0x68d4,
    0x68e7,
    0x68d5,
    0x6936,
    0x6912,
    0x6904,
    0x68d7,
    0x68e3,
    0x6925,
    0x68f9,
    0x68e0,
    0x68ef,
    0x6928,
    0x692a,
    0x691a,
    0x6923,
    0x6921,
    0x68c6,
    0x6979,
    0x6977,
    0x695c,
    0x6978,
    0x696b,
    0x6954,
    0x697e,
    0x696e,
    0x6939,
    0x6974,
    0x693d,
    0x6959,
    0x6930,
    0x6961,
    0x695e,
    0x695d,
    0x6981,
    0x696a,
    0x69b2,
    0x69ae,
    0x69d0,
    0x69bf,
    0x69c1,
    0x69d3,
    0x69be,
    0x69ce,
    0x5be8,
    0x69ca,
    0x69dd,
    0x69bb,
    0x69c3,
    0x69a7,
    0x6a2e,
    0x6991,
    0x69a0,
    0x699c,
    0x6995,
    0x69b4,
    0x69de,
    0x69e8,
    0x6a02,
    0x6a1b,
    0x69ff,
    0x6b0a,
    0x69f9,
    0x69f2,
    0x69e7,
    0x6a05,
    0x69b1,
    0x6a1e,
    0x69ed,
    0x6a14,
    0x69eb,
    0x6a0a,
    0x6a12,
    0x6ac1,
    0x6a23,
    0x6a13,
    0x6a44,
    0x6a0c,
    0x6a72,
    0x6a36,
    0x6a78,
    0x6a47,
    0x6a62,
    0x6a59,
    0x6a66,
    0x6a48,
    0x6a38,
    0x6a22,
    0x6a90,
    0x6a8d,
    0x6aa0,
    0x6a84,
    0x6aa2,
    0x6aa3,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL
};
UINT16 cp932_CP_a0x9f[] = {
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x6a97,
    0x8617,
    0x6abb,
    0x6ac3,
    0x6ac2,
    0x6ab8,
    0x6ab3,
    0x6aac,
    0x6ade,
    0x6ad1,
    0x6adf,
    0x6aaa,
    0x6ada,
    0x6aea,
    0x6afb,
    0x6b05,
    0x8616,
    0x6afa,
    0x6b12,
    0x6b16,
    0x9b31,
    0x6b1f,
    0x6b38,
    0x6b37,
    0x76dc,
    0x6b39,
    0x98ee,
    0x6b47,
    0x6b43,
    0x6b49,
    0x6b50,
    0x6b59,
    0x6b54,
    0x6b5b,
    0x6b5f,
    0x6b61,
    0x6b78,
    0x6b79,
    0x6b7f,
    0x6b80,
    0x6b84,
    0x6b83,
    0x6b8d,
    0x6b98,
    0x6b95,
    0x6b9e,
    0x6ba4,
    0x6baa,
    0x6bab,
    0x6baf,
    0x6bb2,
    0x6bb1,
    0x6bb3,
    0x6bb7,
    0x6bbc,
    0x6bc6,
    0x6bcb,
    0x6bd3,
    0x6bdf,
    0x6bec,
    0x6beb,
    0x6bf3,
    0x6bef,
    CP932_CP_VAL_NULL,
    0x9ebe,
    0x6c08,
    0x6c13,
    0x6c14,
    0x6c1b,
    0x6c24,
    0x6c23,
    0x6c5e,
    0x6c55,
    0x6c62,
    0x6c6a,
    0x6c82,
    0x6c8d,
    0x6c9a,
    0x6c81,
    0x6c9b,
    0x6c7e,
    0x6c68,
    0x6c73,
    0x6c92,
    0x6c90,
    0x6cc4,
    0x6cf1,
    0x6cd3,
    0x6cbd,
    0x6cd7,
    0x6cc5,
    0x6cdd,
    0x6cae,
    0x6cb1,
    0x6cbe,
    0x6cba,
    0x6cdb,
    0x6cef,
    0x6cd9,
    0x6cea,
    0x6d1f,
    0x884d,
    0x6d36,
    0x6d2b,
    0x6d3d,
    0x6d38,
    0x6d19,
    0x6d35,
    0x6d33,
    0x6d12,
    0x6d0c,
    0x6d63,
    0x6d93,
    0x6d64,
    0x6d5a,
    0x6d79,
    0x6d59,
    0x6d8e,
    0x6d95,
    0x6fe4,
    0x6d85,
    0x6df9,
    0x6e15,
    0x6e0a,
    0x6db5,
    0x6dc7,
    0x6de6,
    0x6db8,
    0x6dc6,
    0x6dec,
    0x6dde,
    0x6dcc,
    0x6de8,
    0x6dd2,
    0x6dc5,
    0x6dfa,
    0x6dd9,
    0x6de4,
    0x6dd5,
    0x6dea,
    0x6dee,
    0x6e2d,
    0x6e6e,
    0x6e2e,
    0x6e19,
    0x6e72,
    0x6e5f,
    0x6e3e,
    0x6e23,
    0x6e6b,
    0x6e2b,
    0x6e76,
    0x6e4d,
    0x6e1f,
    0x6e43,
    0x6e3a,
    0x6e4e,
    0x6e24,
    0x6eff,
    0x6e1d,
    0x6e38,
    0x6e82,
    0x6eaa,
    0x6e98,
    0x6ec9,
    0x6eb7,
    0x6ed3,
    0x6ebd,
    0x6eaf,
    0x6ec4,
    0x6eb2,
    0x6ed4,
    0x6ed5,
    0x6e8f,
    0x6ea5,
    0x6ec2,
    0x6e9f,
    0x6f41,
    0x6f11,
    0x704c,
    0x6eec,
    0x6ef8,
    0x6efe,
    0x6f3f,
    0x6ef2,
    0x6f31,
    0x6eef,
    0x6f32,
    0x6ecc,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL
};
UINT16 cp932_CP_a0xe0[] = {
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x6f3e,
    0x6f13,
    0x6ef7,
    0x6f86,
    0x6f7a,
    0x6f78,
    0x6f81,
    0x6f80,
    0x6f6f,
    0x6f5b,
    0x6ff3,
    0x6f6d,
    0x6f82,
    0x6f7c,
    0x6f58,
    0x6f8e,
    0x6f91,
    0x6fc2,
    0x6f66,
    0x6fb3,
    0x6fa3,
    0x6fa1,
    0x6fa4,
    0x6fb9,
    0x6fc6,
    0x6faa,
    0x6fdf,
    0x6fd5,
    0x6fec,
    0x6fd4,
    0x6fd8,
    0x6ff1,
    0x6fee,
    0x6fdb,
    0x7009,
    0x700b,
    0x6ffa,
    0x7011,
    0x7001,
    0x700f,
    0x6ffe,
    0x701b,
    0x701a,
    0x6f74,
    0x701d,
    0x7018,
    0x701f,
    0x7030,
    0x703e,
    0x7032,
    0x7051,
    0x7063,
    0x7099,
    0x7092,
    0x70af,
    0x70f1,
    0x70ac,
    0x70b8,
    0x70b3,
    0x70ae,
    0x70df,
    0x70cb,
    0x70dd,
    CP932_CP_VAL_NULL,
    0x70d9,
    0x7109,
    0x70fd,
    0x711c,
    0x7119,
    0x7165,
    0x7155,
    0x7188,
    0x7166,
    0x7162,
    0x714c,
    0x7156,
    0x716c,
    0x718f,
    0x71fb,
    0x7184,
    0x7195,
    0x71a8,
    0x71ac,
    0x71d7,
    0x71b9,
    0x71be,
    0x71d2,
    0x71c9,
    0x71d4,
    0x71ce,
    0x71e0,
    0x71ec,
    0x71e7,
    0x71f5,
    0x71fc,
    0x71f9,
    0x71ff,
    0x720d,
    0x7210,
    0x721b,
    0x7228,
    0x722d,
    0x722c,
    0x7230,
    0x7232,
    0x723b,
    0x723c,
    0x723f,
    0x7240,
    0x7246,
    0x724b,
    0x7258,
    0x7274,
    0x727e,
    0x7282,
    0x7281,
    0x7287,
    0x7292,
    0x7296,
    0x72a2,
    0x72a7,
    0x72b9,
    0x72b2,
    0x72c3,
    0x72c6,
    0x72c4,
    0x72ce,
    0x72d2,
    0x72e2,
    0x72e0,
    0x72e1,
    0x72f9,
    0x72f7,
    0x500f,
    0x7317,
    0x730a,
    0x731c,
    0x7316,
    0x731d,
    0x7334,
    0x732f,
    0x7329,
    0x7325,
    0x733e,
    0x734e,
    0x734f,
    0x9ed8,
    0x7357,
    0x736a,
    0x7368,
    0x7370,
    0x7378,
    0x7375,
    0x737b,
    0x737a,
    0x73c8,
    0x73b3,
    0x73ce,
    0x73bb,
    0x73c0,
    0x73e5,
    0x73ee,
    0x73de,
    0x74a2,
    0x7405,
    0x746f,
    0x7425,
    0x73f8,
    0x7432,
    0x743a,
    0x7455,
    0x743f,
    0x745f,
    0x7459,
    0x7441,
    0x745c,
    0x7469,
    0x7470,
    0x7463,
    0x746a,
    0x7476,
    0x747e,
    0x748b,
    0x749e,
    0x74a7,
    0x74ca,
    0x74cf,
    0x74d4,
    0x73f1,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL
};
UINT16 cp932_CP_a0xe1[] = {
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x74e0,
    0x74e3,
    0x74e7,
    0x74e9,
    0x74ee,
    0x74f2,
    0x74f0,
    0x74f1,
    0x74f8,
    0x74f7,
    0x7504,
    0x7503,
    0x7505,
    0x750c,
    0x750e,
    0x750d,
    0x7515,
    0x7513,
    0x751e,
    0x7526,
    0x752c,
    0x753c,
    0x7544,
    0x754d,
    0x754a,
    0x7549,
    0x755b,
    0x7546,
    0x755a,
    0x7569,
    0x7564,
    0x7567,
    0x756b,
    0x756d,
    0x7578,
    0x7576,
    0x7586,
    0x7587,
    0x7574,
    0x758a,
    0x7589,
    0x7582,
    0x7594,
    0x759a,
    0x759d,
    0x75a5,
    0x75a3,
    0x75c2,
    0x75b3,
    0x75c3,
    0x75b5,
    0x75bd,
    0x75b8,
    0x75bc,
    0x75b1,
    0x75cd,
    0x75ca,
    0x75d2,
    0x75d9,
    0x75e3,
    0x75de,
    0x75fe,
    0x75ff,
    CP932_CP_VAL_NULL,
    0x75fc,
    0x7601,
    0x75f0,
    0x75fa,
    0x75f2,
    0x75f3,
    0x760b,
    0x760d,
    0x7609,
    0x761f,
    0x7627,
    0x7620,
    0x7621,
    0x7622,
    0x7624,
    0x7634,
    0x7630,
    0x763b,
    0x7647,
    0x7648,
    0x7646,
    0x765c,
    0x7658,
    0x7661,
    0x7662,
    0x7668,
    0x7669,
    0x766a,
    0x7667,
    0x766c,
    0x7670,
    0x7672,
    0x7676,
    0x7678,
    0x767c,
    0x7680,
    0x7683,
    0x7688,
    0x768b,
    0x768e,
    0x7696,
    0x7693,
    0x7699,
    0x769a,
    0x76b0,
    0x76b4,
    0x76b8,
    0x76b9,
    0x76ba,
    0x76c2,
    0x76cd,
    0x76d6,
    0x76d2,
    0x76de,
    0x76e1,
    0x76e5,
    0x76e7,
    0x76ea,
    0x862f,
    0x76fb,
    0x7708,
    0x7707,
    0x7704,
    0x7729,
    0x7724,
    0x771e,
    0x7725,
    0x7726,
    0x771b,
    0x7737,
    0x7738,
    0x7747,
    0x775a,
    0x7768,
    0x776b,
    0x775b,
    0x7765,
    0x777f,
    0x777e,
    0x7779,
    0x778e,
    0x778b,
    0x7791,
    0x77a0,
    0x779e,
    0x77b0,
    0x77b6,
    0x77b9,
    0x77bf,
    0x77bc,
    0x77bd,
    0x77bb,
    0x77c7,
    0x77cd,
    0x77d7,
    0x77da,
    0x77dc,
    0x77e3,
    0x77ee,
    0x77fc,
    0x780c,
    0x7812,
    0x7926,
    0x7820,
    0x792a,
    0x7845,
    0x788e,
    0x7874,
    0x7886,
    0x787c,
    0x789a,
    0x788c,
    0x78a3,
    0x78b5,
    0x78aa,
    0x78af,
    0x78d1,
    0x78c6,
    0x78cb,
    0x78d4,
    0x78be,
    0x78bc,
    0x78c5,
    0x78ca,
    0x78ec,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL
};
UINT16 cp932_CP_a0xe2[] = {
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x78e7,
    0x78da,
    0x78fd,
    0x78f4,
    0x7907,
    0x7912,
    0x7911,
    0x7919,
    0x792c,
    0x792b,
    0x7940,
    0x7960,
    0x7957,
    0x795f,
    0x795a,
    0x7955,
    0x7953,
    0x797a,
    0x797f,
    0x798a,
    0x799d,
    0x79a7,
    0x9f4b,
    0x79aa,
    0x79ae,
    0x79b3,
    0x79b9,
    0x79ba,
    0x79c9,
    0x79d5,
    0x79e7,
    0x79ec,
    0x79e1,
    0x79e3,
    0x7a08,
    0x7a0d,
    0x7a18,
    0x7a19,
    0x7a20,
    0x7a1f,
    0x7980,
    0x7a31,
    0x7a3b,
    0x7a3e,
    0x7a37,
    0x7a43,
    0x7a57,
    0x7a49,
    0x7a61,
    0x7a62,
    0x7a69,
    0x9f9d,
    0x7a70,
    0x7a79,
    0x7a7d,
    0x7a88,
    0x7a97,
    0x7a95,
    0x7a98,
    0x7a96,
    0x7aa9,
    0x7ac8,
    0x7ab0,
    CP932_CP_VAL_NULL,
    0x7ab6,
    0x7ac5,
    0x7ac4,
    0x7abf,
    0x9083,
    0x7ac7,
    0x7aca,
    0x7acd,
    0x7acf,
    0x7ad5,
    0x7ad3,
    0x7ad9,
    0x7ada,
    0x7add,
    0x7ae1,
    0x7ae2,
    0x7ae6,
    0x7aed,
    0x7af0,
    0x7b02,
    0x7b0f,
    0x7b0a,
    0x7b06,
    0x7b33,
    0x7b18,
    0x7b19,
    0x7b1e,
    0x7b35,
    0x7b28,
    0x7b36,
    0x7b50,
    0x7b7a,
    0x7b04,
    0x7b4d,
    0x7b0b,
    0x7b4c,
    0x7b45,
    0x7b75,
    0x7b65,
    0x7b74,
    0x7b67,
    0x7b70,
    0x7b71,
    0x7b6c,
    0x7b6e,
    0x7b9d,
    0x7b98,
    0x7b9f,
    0x7b8d,
    0x7b9c,
    0x7b9a,
    0x7b8b,
    0x7b92,
    0x7b8f,
    0x7b5d,
    0x7b99,
    0x7bcb,
    0x7bc1,
    0x7bcc,
    0x7bcf,
    0x7bb4,
    0x7bc6,
    0x7bdd,
    0x7be9,
    0x7c11,
    0x7c14,
    0x7be6,
    0x7be5,
    0x7c60,
    0x7c00,
    0x7c07,
    0x7c13,
    0x7bf3,
    0x7bf7,
    0x7c17,
    0x7c0d,
    0x7bf6,
    0x7c23,
    0x7c27,
    0x7c2a,
    0x7c1f,
    0x7c37,
    0x7c2b,
    0x7c3d,
    0x7c4c,
    0x7c43,
    0x7c54,
    0x7c4f,
    0x7c40,
    0x7c50,
    0x7c58,
    0x7c5f,
    0x7c64,
    0x7c56,
    0x7c65,
    0x7c6c,
    0x7c75,
    0x7c83,
    0x7c90,
    0x7ca4,
    0x7cad,
    0x7ca2,
    0x7cab,
    0x7ca1,
    0x7ca8,
    0x7cb3,
    0x7cb2,
    0x7cb1,
    0x7cae,
    0x7cb9,
    0x7cbd,
    0x7cc0,
    0x7cc5,
    0x7cc2,
    0x7cd8,
    0x7cd2,
    0x7cdc,
    0x7ce2,
    0x9b3b,
    0x7cef,
    0x7cf2,
    0x7cf4,
    0x7cf6,
    0x7cfa,
    0x7d06,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL
};
UINT16 cp932_CP_a0xe3[] = {
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x7d02,
    0x7d1c,
    0x7d15,
    0x7d0a,
    0x7d45,
    0x7d4b,
    0x7d2e,
    0x7d32,
    0x7d3f,
    0x7d35,
    0x7d46,
    0x7d73,
    0x7d56,
    0x7d4e,
    0x7d72,
    0x7d68,
    0x7d6e,
    0x7d4f,
    0x7d63,
    0x7d93,
    0x7d89,
    0x7d5b,
    0x7d8f,
    0x7d7d,
    0x7d9b,
    0x7dba,
    0x7dae,
    0x7da3,
    0x7db5,
    0x7dc7,
    0x7dbd,
    0x7dab,
    0x7e3d,
    0x7da2,
    0x7daf,
    0x7ddc,
    0x7db8,
    0x7d9f,
    0x7db0,
    0x7dd8,
    0x7ddd,
    0x7de4,
    0x7dde,
    0x7dfb,
    0x7df2,
    0x7de1,
    0x7e05,
    0x7e0a,
    0x7e23,
    0x7e21,
    0x7e12,
    0x7e31,
    0x7e1f,
    0x7e09,
    0x7e0b,
    0x7e22,
    0x7e46,
    0x7e66,
    0x7e3b,
    0x7e35,
    0x7e39,
    0x7e43,
    0x7e37,
    CP932_CP_VAL_NULL,
    0x7e32,
    0x7e3a,
    0x7e67,
    0x7e5d,
    0x7e56,
    0x7e5e,
    0x7e59,
    0x7e5a,
    0x7e79,
    0x7e6a,
    0x7e69,
    0x7e7c,
    0x7e7b,
    0x7e83,
    0x7dd5,
    0x7e7d,
    0x8fae,
    0x7e7f,
    0x7e88,
    0x7e89,
    0x7e8c,
    0x7e92,
    0x7e90,
    0x7e93,
    0x7e94,
    0x7e96,
    0x7e8e,
    0x7e9b,
    0x7e9c,
    0x7f38,
    0x7f3a,
    0x7f45,
    0x7f4c,
    0x7f4d,
    0x7f4e,
    0x7f50,
    0x7f51,
    0x7f55,
    0x7f54,
    0x7f58,
    0x7f5f,
    0x7f60,
    0x7f68,
    0x7f69,
    0x7f67,
    0x7f78,
    0x7f82,
    0x7f86,
    0x7f83,
    0x7f88,
    0x7f87,
    0x7f8c,
    0x7f94,
    0x7f9e,
    0x7f9d,
    0x7f9a,
    0x7fa3,
    0x7faf,
    0x7fb2,
    0x7fb9,
    0x7fae,
    0x7fb6,
    0x7fb8,
    0x8b71,
    0x7fc5,
    0x7fc6,
    0x7fca,
    0x7fd5,
    0x7fd4,
    0x7fe1,
    0x7fe6,
    0x7fe9,
    0x7ff3,
    0x7ff9,
    0x98dc,
    0x8006,
    0x8004,
    0x800b,
    0x8012,
    0x8018,
    0x8019,
    0x801c,
    0x8021,
    0x8028,
    0x803f,
    0x803b,
    0x804a,
    0x8046,
    0x8052,
    0x8058,
    0x805a,
    0x805f,
    0x8062,
    0x8068,
    0x8073,
    0x8072,
    0x8070,
    0x8076,
    0x8079,
    0x807d,
    0x807f,
    0x8084,
    0x8086,
    0x8085,
    0x809b,
    0x8093,
    0x809a,
    0x80ad,
    0x5190,
    0x80ac,
    0x80db,
    0x80e5,
    0x80d9,
    0x80dd,
    0x80c4,
    0x80da,
    0x80d6,
    0x8109,
    0x80ef,
    0x80f1,
    0x811b,
    0x8129,
    0x8123,
    0x812f,
    0x814b,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL
};
UINT16 cp932_CP_a0xe4[] = {
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x968b,
    0x8146,
    0x813e,
    0x8153,
    0x8151,
    0x80fc,
    0x8171,
    0x816e,
    0x8165,
    0x8166,
    0x8174,
    0x8183,
    0x8188,
    0x818a,
    0x8180,
    0x8182,
    0x81a0,
    0x8195,
    0x81a4,
    0x81a3,
    0x815f,
    0x8193,
    0x81a9,
    0x81b0,
    0x81b5,
    0x81be,
    0x81b8,
    0x81bd,
    0x81c0,
    0x81c2,
    0x81ba,
    0x81c9,
    0x81cd,
    0x81d1,
    0x81d9,
    0x81d8,
    0x81c8,
    0x81da,
    0x81df,
    0x81e0,
    0x81e7,
    0x81fa,
    0x81fb,
    0x81fe,
    0x8201,
    0x8202,
    0x8205,
    0x8207,
    0x820a,
    0x820d,
    0x8210,
    0x8216,
    0x8229,
    0x822b,
    0x8238,
    0x8233,
    0x8240,
    0x8259,
    0x8258,
    0x825d,
    0x825a,
    0x825f,
    0x8264,
    CP932_CP_VAL_NULL,
    0x8262,
    0x8268,
    0x826a,
    0x826b,
    0x822e,
    0x8271,
    0x8277,
    0x8278,
    0x827e,
    0x828d,
    0x8292,
    0x82ab,
    0x829f,
    0x82bb,
    0x82ac,
    0x82e1,
    0x82e3,
    0x82df,
    0x82d2,
    0x82f4,
    0x82f3,
    0x82fa,
    0x8393,
    0x8303,
    0x82fb,
    0x82f9,
    0x82de,
    0x8306,
    0x82dc,
    0x8309,
    0x82d9,
    0x8335,
    0x8334,
    0x8316,
    0x8332,
    0x8331,
    0x8340,
    0x8339,
    0x8350,
    0x8345,
    0x832f,
    0x832b,
    0x8317,
    0x8318,
    0x8385,
    0x839a,
    0x83aa,
    0x839f,
    0x83a2,
    0x8396,
    0x8323,
    0x838e,
    0x8387,
    0x838a,
    0x837c,
    0x83b5,
    0x8373,
    0x8375,
    0x83a0,
    0x8389,
    0x83a8,
    0x83f4,
    0x8413,
    0x83eb,
    0x83ce,
    0x83fd,
    0x8403,
    0x83d8,
    0x840b,
    0x83c1,
    0x83f7,
    0x8407,
    0x83e0,
    0x83f2,
    0x840d,
    0x8422,
    0x8420,
    0x83bd,
    0x8438,
    0x8506,
    0x83fb,
    0x846d,
    0x842a,
    0x843c,
    0x855a,
    0x8484,
    0x8477,
    0x846b,
    0x84ad,
    0x846e,
    0x8482,
    0x8469,
    0x8446,
    0x842c,
    0x846f,
    0x8479,
    0x8435,
    0x84ca,
    0x8462,
    0x84b9,
    0x84bf,
    0x849f,
    0x84d9,
    0x84cd,
    0x84bb,
    0x84da,
    0x84d0,
    0x84c1,
    0x84c6,
    0x84d6,
    0x84a1,
    0x8521,
    0x84ff,
    0x84f4,
    0x8517,
    0x8518,
    0x852c,
    0x851f,
    0x8515,
    0x8514,
    0x84fc,
    0x8540,
    0x8563,
    0x8558,
    0x8548,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL
};
UINT16 cp932_CP_a0xe5[] = {
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x8541,
    0x8602,
    0x854b,
    0x8555,
    0x8580,
    0x85a4,
    0x8588,
    0x8591,
    0x858a,
    0x85a8,
    0x856d,
    0x8594,
    0x859b,
    0x85ea,
    0x8587,
    0x859c,
    0x8577,
    0x857e,
    0x8590,
    0x85c9,
    0x85ba,
    0x85cf,
    0x85b9,
    0x85d0,
    0x85d5,
    0x85dd,
    0x85e5,
    0x85dc,
    0x85f9,
    0x860a,
    0x8613,
    0x860b,
    0x85fe,
    0x85fa,
    0x8606,
    0x8622,
    0x861a,
    0x8630,
    0x863f,
    0x864d,
    0x4e55,
    0x8654,
    0x865f,
    0x8667,
    0x8671,
    0x8693,
    0x86a3,
    0x86a9,
    0x86aa,
    0x868b,
    0x868c,
    0x86b6,
    0x86af,
    0x86c4,
    0x86c6,
    0x86b0,
    0x86c9,
    0x8823,
    0x86ab,
    0x86d4,
    0x86de,
    0x86e9,
    0x86ec,
    CP932_CP_VAL_NULL,
    0x86df,
    0x86db,
    0x86ef,
    0x8712,
    0x8706,
    0x8708,
    0x8700,
    0x8703,
    0x86fb,
    0x8711,
    0x8709,
    0x870d,
    0x86f9,
    0x870a,
    0x8734,
    0x873f,
    0x8737,
    0x873b,
    0x8725,
    0x8729,
    0x871a,
    0x8760,
    0x875f,
    0x8778,
    0x874c,
    0x874e,
    0x8774,
    0x8757,
    0x8768,
    0x876e,
    0x8759,
    0x8753,
    0x8763,
    0x876a,
    0x8805,
    0x87a2,
    0x879f,
    0x8782,
    0x87af,
    0x87cb,
    0x87bd,
    0x87c0,
    0x87d0,
    0x96d6,
    0x87ab,
    0x87c4,
    0x87b3,
    0x87c7,
    0x87c6,
    0x87bb,
    0x87ef,
    0x87f2,
    0x87e0,
    0x880f,
    0x880d,
    0x87fe,
    0x87f6,
    0x87f7,
    0x880e,
    0x87d2,
    0x8811,
    0x8816,
    0x8815,
    0x8822,
    0x8821,
    0x8831,
    0x8836,
    0x8839,
    0x8827,
    0x883b,
    0x8844,
    0x8842,
    0x8852,
    0x8859,
    0x885e,
    0x8862,
    0x886b,
    0x8881,
    0x887e,
    0x889e,
    0x8875,
    0x887d,
    0x88b5,
    0x8872,
    0x8882,
    0x8897,
    0x8892,
    0x88ae,
    0x8899,
    0x88a2,
    0x888d,
    0x88a4,
    0x88b0,
    0x88bf,
    0x88b1,
    0x88c3,
    0x88c4,
    0x88d4,
    0x88d8,
    0x88d9,
    0x88dd,
    0x88f9,
    0x8902,
    0x88fc,
    0x88f4,
    0x88e8,
    0x88f2,
    0x8904,
    0x890c,
    0x890a,
    0x8913,
    0x8943,
    0x891e,
    0x8925,
    0x892a,
    0x892b,
    0x8941,
    0x8944,
    0x893b,
    0x8936,
    0x8938,
    0x894c,
    0x891d,
    0x8960,
    0x895e,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL
};
UINT16 cp932_CP_a0xe6[] = {
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x8966,
    0x8964,
    0x896d,
    0x896a,
    0x896f,
    0x8974,
    0x8977,
    0x897e,
    0x8983,
    0x8988,
    0x898a,
    0x8993,
    0x8998,
    0x89a1,
    0x89a9,
    0x89a6,
    0x89ac,
    0x89af,
    0x89b2,
    0x89ba,
    0x89bd,
    0x89bf,
    0x89c0,
    0x89da,
    0x89dc,
    0x89dd,
    0x89e7,
    0x89f4,
    0x89f8,
    0x8a03,
    0x8a16,
    0x8a10,
    0x8a0c,
    0x8a1b,
    0x8a1d,
    0x8a25,
    0x8a36,
    0x8a41,
    0x8a5b,
    0x8a52,
    0x8a46,
    0x8a48,
    0x8a7c,
    0x8a6d,
    0x8a6c,
    0x8a62,
    0x8a85,
    0x8a82,
    0x8a84,
    0x8aa8,
    0x8aa1,
    0x8a91,
    0x8aa5,
    0x8aa6,
    0x8a9a,
    0x8aa3,
    0x8ac4,
    0x8acd,
    0x8ac2,
    0x8ada,
    0x8aeb,
    0x8af3,
    0x8ae7,
    CP932_CP_VAL_NULL,
    0x8ae4,
    0x8af1,
    0x8b14,
    0x8ae0,
    0x8ae2,
    0x8af7,
    0x8ade,
    0x8adb,
    0x8b0c,
    0x8b07,
    0x8b1a,
    0x8ae1,
    0x8b16,
    0x8b10,
    0x8b17,
    0x8b20,
    0x8b33,
    0x97ab,
    0x8b26,
    0x8b2b,
    0x8b3e,
    0x8b28,
    0x8b41,
    0x8b4c,
    0x8b4f,
    0x8b4e,
    0x8b49,
    0x8b56,
    0x8b5b,
    0x8b5a,
    0x8b6b,
    0x8b5f,
    0x8b6c,
    0x8b6f,
    0x8b74,
    0x8b7d,
    0x8b80,
    0x8b8c,
    0x8b8e,
    0x8b92,
    0x8b93,
    0x8b96,
    0x8b99,
    0x8b9a,
    0x8c3a,
    0x8c41,
    0x8c3f,
    0x8c48,
    0x8c4c,
    0x8c4e,
    0x8c50,
    0x8c55,
    0x8c62,
    0x8c6c,
    0x8c78,
    0x8c7a,
    0x8c82,
    0x8c89,
    0x8c85,
    0x8c8a,
    0x8c8d,
    0x8c8e,
    0x8c94,
    0x8c7c,
    0x8c98,
    0x621d,
    0x8cad,
    0x8caa,
    0x8cbd,
    0x8cb2,
    0x8cb3,
    0x8cae,
    0x8cb6,
    0x8cc8,
    0x8cc1,
    0x8ce4,
    0x8ce3,
    0x8cda,
    0x8cfd,
    0x8cfa,
    0x8cfb,
    0x8d04,
    0x8d05,
    0x8d0a,
    0x8d07,
    0x8d0f,
    0x8d0d,
    0x8d10,
    0x9f4e,
    0x8d13,
    0x8ccd,
    0x8d14,
    0x8d16,
    0x8d67,
    0x8d6d,
    0x8d71,
    0x8d73,
    0x8d81,
    0x8d99,
    0x8dc2,
    0x8dbe,
    0x8dba,
    0x8dcf,
    0x8dda,
    0x8dd6,
    0x8dcc,
    0x8ddb,
    0x8dcb,
    0x8dea,
    0x8deb,
    0x8ddf,
    0x8de3,
    0x8dfc,
    0x8e08,
    0x8e09,
    0x8dff,
    0x8e1d,
    0x8e1e,
    0x8e10,
    0x8e1f,
    0x8e42,
    0x8e35,
    0x8e30,
    0x8e34,
    0x8e4a,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL
};
UINT16 cp932_CP_a0xe7[] = {
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x8e47,
    0x8e49,
    0x8e4c,
    0x8e50,
    0x8e48,
    0x8e59,
    0x8e64,
    0x8e60,
    0x8e2a,
    0x8e63,
    0x8e55,
    0x8e76,
    0x8e72,
    0x8e7c,
    0x8e81,
    0x8e87,
    0x8e85,
    0x8e84,
    0x8e8b,
    0x8e8a,
    0x8e93,
    0x8e91,
    0x8e94,
    0x8e99,
    0x8eaa,
    0x8ea1,
    0x8eac,
    0x8eb0,
    0x8ec6,
    0x8eb1,
    0x8ebe,
    0x8ec5,
    0x8ec8,
    0x8ecb,
    0x8edb,
    0x8ee3,
    0x8efc,
    0x8efb,
    0x8eeb,
    0x8efe,
    0x8f0a,
    0x8f05,
    0x8f15,
    0x8f12,
    0x8f19,
    0x8f13,
    0x8f1c,
    0x8f1f,
    0x8f1b,
    0x8f0c,
    0x8f26,
    0x8f33,
    0x8f3b,
    0x8f39,
    0x8f45,
    0x8f42,
    0x8f3e,
    0x8f4c,
    0x8f49,
    0x8f46,
    0x8f4e,
    0x8f57,
    0x8f5c,
    CP932_CP_VAL_NULL,
    0x8f62,
    0x8f63,
    0x8f64,
    0x8f9c,
    0x8f9f,
    0x8fa3,
    0x8fad,
    0x8faf,
    0x8fb7,
    0x8fda,
    0x8fe5,
    0x8fe2,
    0x8fea,
    0x8fef,
    0x9087,
    0x8ff4,
    0x9005,
    0x8ff9,
    0x8ffa,
    0x9011,
    0x9015,
    0x9021,
    0x900d,
    0x901e,
    0x9016,
    0x900b,
    0x9027,
    0x9036,
    0x9035,
    0x9039,
    0x8ff8,
    0x904f,
    0x9050,
    0x9051,
    0x9052,
    0x900e,
    0x9049,
    0x903e,
    0x9056,
    0x9058,
    0x905e,
    0x9068,
    0x906f,
    0x9076,
    0x96a8,
    0x9072,
    0x9082,
    0x907d,
    0x9081,
    0x9080,
    0x908a,
    0x9089,
    0x908f,
    0x90a8,
    0x90af,
    0x90b1,
    0x90b5,
    0x90e2,
    0x90e4,
    0x6248,
    0x90db,
    0x9102,
    0x9112,
    0x9119,
    0x9132,
    0x9130,
    0x914a,
    0x9156,
    0x9158,
    0x9163,
    0x9165,
    0x9169,
    0x9173,
    0x9172,
    0x918b,
    0x9189,
    0x9182,
    0x91a2,
    0x91ab,
    0x91af,
    0x91aa,
    0x91b5,
    0x91b4,
    0x91ba,
    0x91c0,
    0x91c1,
    0x91c9,
    0x91cb,
    0x91d0,
    0x91d6,
    0x91df,
    0x91e1,
    0x91db,
    0x91fc,
    0x91f5,
    0x91f6,
    0x921e,
    0x91ff,
    0x9214,
    0x922c,
    0x9215,
    0x9211,
    0x925e,
    0x9257,
    0x9245,
    0x9249,
    0x9264,
    0x9248,
    0x9295,
    0x923f,
    0x924b,
    0x9250,
    0x929c,
    0x9296,
    0x9293,
    0x929b,
    0x925a,
    0x92cf,
    0x92b9,
    0x92b7,
    0x92e9,
    0x930f,
    0x92fa,
    0x9344,
    0x932e,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL
};
UINT16 cp932_CP_a0xe8[] = {
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x9319,
    0x9322,
    0x931a,
    0x9323,
    0x933a,
    0x9335,
    0x933b,
    0x935c,
    0x9360,
    0x937c,
    0x936e,
    0x9356,
    0x93b0,
    0x93ac,
    0x93ad,
    0x9394,
    0x93b9,
    0x93d6,
    0x93d7,
    0x93e8,
    0x93e5,
    0x93d8,
    0x93c3,
    0x93dd,
    0x93d0,
    0x93c8,
    0x93e4,
    0x941a,
    0x9414,
    0x9413,
    0x9403,
    0x9407,
    0x9410,
    0x9436,
    0x942b,
    0x9435,
    0x9421,
    0x943a,
    0x9441,
    0x9452,
    0x9444,
    0x945b,
    0x9460,
    0x9462,
    0x945e,
    0x946a,
    0x9229,
    0x9470,
    0x9475,
    0x9477,
    0x947d,
    0x945a,
    0x947c,
    0x947e,
    0x9481,
    0x947f,
    0x9582,
    0x9587,
    0x958a,
    0x9594,
    0x9596,
    0x9598,
    0x9599,
    CP932_CP_VAL_NULL,
    0x95a0,
    0x95a8,
    0x95a7,
    0x95ad,
    0x95bc,
    0x95bb,
    0x95b9,
    0x95be,
    0x95ca,
    0x6ff6,
    0x95c3,
    0x95cd,
    0x95cc,
    0x95d5,
    0x95d4,
    0x95d6,
    0x95dc,
    0x95e1,
    0x95e5,
    0x95e2,
    0x9621,
    0x9628,
    0x962e,
    0x962f,
    0x9642,
    0x964c,
    0x964f,
    0x964b,
    0x9677,
    0x965c,
    0x965e,
    0x965d,
    0x965f,
    0x9666,
    0x9672,
    0x966c,
    0x968d,
    0x9698,
    0x9695,
    0x9697,
    0x96aa,
    0x96a7,
    0x96b1,
    0x96b2,
    0x96b0,
    0x96b4,
    0x96b6,
    0x96b8,
    0x96b9,
    0x96ce,
    0x96cb,
    0x96c9,
    0x96cd,
    0x894d,
    0x96dc,
    0x970d,
    0x96d5,
    0x96f9,
    0x9704,
    0x9706,
    0x9708,
    0x9713,
    0x970e,
    0x9711,
    0x970f,
    0x9716,
    0x9719,
    0x9724,
    0x972a,
    0x9730,
    0x9739,
    0x973d,
    0x973e,
    0x9744,
    0x9746,
    0x9748,
    0x9742,
    0x9749,
    0x975c,
    0x9760,
    0x9764,
    0x9766,
    0x9768,
    0x52d2,
    0x976b,
    0x9771,
    0x9779,
    0x9785,
    0x977c,
    0x9781,
    0x977a,
    0x9786,
    0x978b,
    0x978f,
    0x9790,
    0x979c,
    0x97a8,
    0x97a6,
    0x97a3,
    0x97b3,
    0x97b4,
    0x97c3,
    0x97c6,
    0x97c8,
    0x97cb,
    0x97dc,
    0x97ed,
    0x9f4f,
    0x97f2,
    0x7adf,
    0x97f6,
    0x97f5,
    0x980f,
    0x980c,
    0x9838,
    0x9824,
    0x9821,
    0x9837,
    0x983d,
    0x9846,
    0x984f,
    0x984b,
    0x986b,
    0x986f,
    0x9870,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL
};
UINT16 cp932_CP_a0xe9[] = {
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x9871,
    0x9874,
    0x9873,
    0x98aa,
    0x98af,
    0x98b1,
    0x98b6,
    0x98c4,
    0x98c3,
    0x98c6,
    0x98e9,
    0x98eb,
    0x9903,
    0x9909,
    0x9912,
    0x9914,
    0x9918,
    0x9921,
    0x991d,
    0x991e,
    0x9924,
    0x9920,
    0x992c,
    0x992e,
    0x993d,
    0x993e,
    0x9942,
    0x9949,
    0x9945,
    0x9950,
    0x994b,
    0x9951,
    0x9952,
    0x994c,
    0x9955,
    0x9997,
    0x9998,
    0x99a5,
    0x99ad,
    0x99ae,
    0x99bc,
    0x99df,
    0x99db,
    0x99dd,
    0x99d8,
    0x99d1,
    0x99ed,
    0x99ee,
    0x99f1,
    0x99f2,
    0x99fb,
    0x99f8,
    0x9a01,
    0x9a0f,
    0x9a05,
    0x99e2,
    0x9a19,
    0x9a2b,
    0x9a37,
    0x9a45,
    0x9a42,
    0x9a40,
    0x9a43,
    CP932_CP_VAL_NULL,
    0x9a3e,
    0x9a55,
    0x9a4d,
    0x9a5b,
    0x9a57,
    0x9a5f,
    0x9a62,
    0x9a65,
    0x9a64,
    0x9a69,
    0x9a6b,
    0x9a6a,
    0x9aad,
    0x9ab0,
    0x9abc,
    0x9ac0,
    0x9acf,
    0x9ad1,
    0x9ad3,
    0x9ad4,
    0x9ade,
    0x9adf,
    0x9ae2,
    0x9ae3,
    0x9ae6,
    0x9aef,
    0x9aeb,
    0x9aee,
    0x9af4,
    0x9af1,
    0x9af7,
    0x9afb,
    0x9b06,
    0x9b18,
    0x9b1a,
    0x9b1f,
    0x9b22,
    0x9b23,
    0x9b25,
    0x9b27,
    0x9b28,
    0x9b29,
    0x9b2a,
    0x9b2e,
    0x9b2f,
    0x9b32,
    0x9b44,
    0x9b43,
    0x9b4f,
    0x9b4d,
    0x9b4e,
    0x9b51,
    0x9b58,
    0x9b74,
    0x9b93,
    0x9b83,
    0x9b91,
    0x9b96,
    0x9b97,
    0x9b9f,
    0x9ba0,
    0x9ba8,
    0x9bb4,
    0x9bc0,
    0x9bca,
    0x9bb9,
    0x9bc6,
    0x9bcf,
    0x9bd1,
    0x9bd2,
    0x9be3,
    0x9be2,
    0x9be4,
    0x9bd4,
    0x9be1,
    0x9c3a,
    0x9bf2,
    0x9bf1,
    0x9bf0,
    0x9c15,
    0x9c14,
    0x9c09,
    0x9c13,
    0x9c0c,
    0x9c06,
    0x9c08,
    0x9c12,
    0x9c0a,
    0x9c04,
    0x9c2e,
    0x9c1b,
    0x9c25,
    0x9c24,
    0x9c21,
    0x9c30,
    0x9c47,
    0x9c32,
    0x9c46,
    0x9c3e,
    0x9c5a,
    0x9c60,
    0x9c67,
    0x9c76,
    0x9c78,
    0x9ce7,
    0x9cec,
    0x9cf0,
    0x9d09,
    0x9d08,
    0x9ceb,
    0x9d03,
    0x9d06,
    0x9d2a,
    0x9d26,
    0x9daf,
    0x9d23,
    0x9d1f,
    0x9d44,
    0x9d15,
    0x9d12,
    0x9d41,
    0x9d3f,
    0x9d3e,
    0x9d46,
    0x9d48,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL
};
UINT16 cp932_CP_a0xea[] = {
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x9d5d,
    0x9d5e,
    0x9d64,
    0x9d51,
    0x9d50,
    0x9d59,
    0x9d72,
    0x9d89,
    0x9d87,
    0x9dab,
    0x9d6f,
    0x9d7a,
    0x9d9a,
    0x9da4,
    0x9da9,
    0x9db2,
    0x9dc4,
    0x9dc1,
    0x9dbb,
    0x9db8,
    0x9dba,
    0x9dc6,
    0x9dcf,
    0x9dc2,
    0x9dd9,
    0x9dd3,
    0x9df8,
    0x9de6,
    0x9ded,
    0x9def,
    0x9dfd,
    0x9e1a,
    0x9e1b,
    0x9e1e,
    0x9e75,
    0x9e79,
    0x9e7d,
    0x9e81,
    0x9e88,
    0x9e8b,
    0x9e8c,
    0x9e92,
    0x9e95,
    0x9e91,
    0x9e9d,
    0x9ea5,
    0x9ea9,
    0x9eb8,
    0x9eaa,
    0x9ead,
    0x9761,
    0x9ecc,
    0x9ece,
    0x9ecf,
    0x9ed0,
    0x9ed4,
    0x9edc,
    0x9ede,
    0x9edd,
    0x9ee0,
    0x9ee5,
    0x9ee8,
    0x9eef,
    CP932_CP_VAL_NULL,
    0x9ef4,
    0x9ef6,
    0x9ef7,
    0x9ef9,
    0x9efb,
    0x9efc,
    0x9efd,
    0x9f07,
    0x9f08,
    0x76b7,
    0x9f15,
    0x9f21,
    0x9f2c,
    0x9f3e,
    0x9f4a,
    0x9f52,
    0x9f54,
    0x9f63,
    0x9f5f,
    0x9f60,
    0x9f61,
    0x9f66,
    0x9f67,
    0x9f6c,
    0x9f6a,
    0x9f77,
    0x9f72,
    0x9f76,
    0x9f95,
    0x9f9c,
    0x9fa0,
    0x582f,
    0x69c7,
    0x9059,
    0x7464,
    0x51dc,
    0x7199,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL
};
UINT16 cp932_CP_a0xed[] = {
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x7e8a,
    0x891c,
    0x9348,
    0x9288,
    0x84dc,
    0x4fc9,
    0x70bb,
    0x6631,
    0x68c8,
    0x92f9,
    0x66fb,
    0x5f45,
    0x4e28,
    0x4ee1,
    0x4efc,
    0x4f00,
    0x4f03,
    0x4f39,
    0x4f56,
    0x4f92,
    0x4f8a,
    0x4f9a,
    0x4f94,
    0x4fcd,
    0x5040,
    0x5022,
    0x4fff,
    0x501e,
    0x5046,
    0x5070,
    0x5042,
    0x5094,
    0x50f4,
    0x50d8,
    0x514a,
    0x5164,
    0x519d,
    0x51be,
    0x51ec,
    0x5215,
    0x529c,
    0x52a6,
    0x52c0,
    0x52db,
    0x5300,
    0x5307,
    0x5324,
    0x5372,
    0x5393,
    0x53b2,
    0x53dd,
    0xfa0e,
    0x549c,
    0x548a,
    0x54a9,
    0x54ff,
    0x5586,
    0x5759,
    0x5765,
    0x57ac,
    0x57c8,
    0x57c7,
    0xfa0f,
    CP932_CP_VAL_NULL,
    0xfa10,
    0x589e,
    0x58b2,
    0x590b,
    0x5953,
    0x595b,
    0x595d,
    0x5963,
    0x59a4,
    0x59ba,
    0x5b56,
    0x5bc0,
    0x752f,
    0x5bd8,
    0x5bec,
    0x5c1e,
    0x5ca6,
    0x5cba,
    0x5cf5,
    0x5d27,
    0x5d53,
    0xfa11,
    0x5d42,
    0x5d6d,
    0x5db8,
    0x5db9,
    0x5dd0,
    0x5f21,
    0x5f34,
    0x5f67,
    0x5fb7,
    0x5fde,
    0x605d,
    0x6085,
    0x608a,
    0x60de,
    0x60d5,
    0x6120,
    0x60f2,
    0x6111,
    0x6137,
    0x6130,
    0x6198,
    0x6213,
    0x62a6,
    0x63f5,
    0x6460,
    0x649d,
    0x64ce,
    0x654e,
    0x6600,
    0x6615,
    0x663b,
    0x6609,
    0x662e,
    0x661e,
    0x6624,
    0x6665,
    0x6657,
    0x6659,
    0xfa12,
    0x6673,
    0x6699,
    0x66a0,
    0x66b2,
    0x66bf,
    0x66fa,
    0x670e,
    0xf929,
    0x6766,
    0x67bb,
    0x6852,
    0x67c0,
    0x6801,
    0x6844,
    0x68cf,
    0xfa13,
    0x6968,
    0xfa14,
    0x6998,
    0x69e2,
    0x6a30,
    0x6a6b,
    0x6a46,
    0x6a73,
    0x6a7e,
    0x6ae2,
    0x6ae4,
    0x6bd6,
    0x6c3f,
    0x6c5c,
    0x6c86,
    0x6c6f,
    0x6cda,
    0x6d04,
    0x6d87,
    0x6d6f,
    0x6d96,
    0x6dac,
    0x6dcf,
    0x6df8,
    0x6df2,
    0x6dfc,
    0x6e39,
    0x6e5c,
    0x6e27,
    0x6e3c,
    0x6ebf,
    0x6f88,
    0x6fb5,
    0x6ff5,
    0x7005,
    0x7007,
    0x7028,
    0x7085,
    0x70ab,
    0x710f,
    0x7104,
    0x715c,
    0x7146,
    0x7147,
    0xfa15,
    0x71c1,
    0x71fe,
    0x72b1,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL
};
UINT16 cp932_CP_a0xee[] = {
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x72be,
    0x7324,
    0xfa16,
    0x7377,
    0x73bd,
    0x73c9,
    0x73d6,
    0x73e3,
    0x73d2,
    0x7407,
    0x73f5,
    0x7426,
    0x742a,
    0x7429,
    0x742e,
    0x7462,
    0x7489,
    0x749f,
    0x7501,
    0x756f,
    0x7682,
    0x769c,
    0x769e,
    0x769b,
    0x76a6,
    0xfa17,
    0x7746,
    0x52af,
    0x7821,
    0x784e,
    0x7864,
    0x787a,
    0x7930,
    0xfa18,
    0xfa19,
    0xfa1a,
    0x7994,
    0xfa1b,
    0x799b,
    0x7ad1,
    0x7ae7,
    0xfa1c,
    0x7aeb,
    0x7b9e,
    0xfa1d,
    0x7d48,
    0x7d5c,
    0x7db7,
    0x7da0,
    0x7dd6,
    0x7e52,
    0x7f47,
    0x7fa1,
    0xfa1e,
    0x8301,
    0x8362,
    0x837f,
    0x83c7,
    0x83f6,
    0x8448,
    0x84b4,
    0x8553,
    0x8559,
    CP932_CP_VAL_NULL,
    0x856b,
    0xfa1f,
    0x85b0,
    0xfa20,
    0xfa21,
    0x8807,
    0x88f5,
    0x8a12,
    0x8a37,
    0x8a79,
    0x8aa7,
    0x8abe,
    0x8adf,
    0xfa22,
    0x8af6,
    0x8b53,
    0x8b7f,
    0x8cf0,
    0x8cf4,
    0x8d12,
    0x8d76,
    0xfa23,
    0x8ecf,
    0xfa24,
    0xfa25,
    0x9067,
    0x90de,
    0xfa26,
    0x9115,
    0x9127,
    0x91da,
    0x91d7,
    0x91de,
    0x91ed,
    0x91ee,
    0x91e4,
    0x91e5,
    0x9206,
    0x9210,
    0x920a,
    0x923a,
    0x9240,
    0x923c,
    0x924e,
    0x9259,
    0x9251,
    0x9239,
    0x9267,
    0x92a7,
    0x9277,
    0x9278,
    0x92e7,
    0x92d7,
    0x92d9,
    0x92d0,
    0xfa27,
    0x92d5,
    0x92e0,
    0x92d3,
    0x9325,
    0x9321,
    0x92fb,
    0xfa28,
    0x931e,
    0x92ff,
    0x931d,
    0x9302,
    0x9370,
    0x9357,
    0x93a4,
    0x93c6,
    0x93de,
    0x93f8,
    0x9431,
    0x9445,
    0x9448,
    0x9592,
    0xf9dc,
    0xfa29,
    0x969d,
    0x96af,
    0x9733,
    0x973b,
    0x9743,
    0x974d,
    0x974f,
    0x9751,
    0x9755,
    0x9857,
    0x9865,
    0xfa2a,
    0xfa2b,
    0x9927,
    0xfa2c,
    0x999e,
    0x9a4e,
    0x9ad9,
    0x9adc,
    0x9b75,
    0x9b72,
    0x9b8f,
    0x9bb1,
    0x9bbb,
    0x9c00,
    0x9d70,
    0x9d6b,
    0xfa2d,
    0x9e19,
    0x9ed1,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x2170,
    0x2171,
    0x2172,
    0x2173,
    0x2174,
    0x2175,
    0x2176,
    0x2177,
    0x2178,
    0x2179,
    0xffe2,
    0xffe4,
    0xff07,
    0xff02,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL
};
UINT16 cp932_CP_a0xfa[] = {
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x2170,
    0x2171,
    0x2172,
    0x2173,
    0x2174,
    0x2175,
    0x2176,
    0x2177,
    0x2178,
    0x2179,
    0x2160,
    0x2161,
    0x2162,
    0x2163,
    0x2164,
    0x2165,
    0x2166,
    0x2167,
    0x2168,
    0x2169,
    0xffe2,
    0xffe4,
    0xff07,
    0xff02,
    0x3231,
    0x2116,
    0x2121,
    0x2235,
    0x7e8a,
    0x891c,
    0x9348,
    0x9288,
    0x84dc,
    0x4fc9,
    0x70bb,
    0x6631,
    0x68c8,
    0x92f9,
    0x66fb,
    0x5f45,
    0x4e28,
    0x4ee1,
    0x4efc,
    0x4f00,
    0x4f03,
    0x4f39,
    0x4f56,
    0x4f92,
    0x4f8a,
    0x4f9a,
    0x4f94,
    0x4fcd,
    0x5040,
    0x5022,
    0x4fff,
    0x501e,
    0x5046,
    0x5070,
    0x5042,
    0x5094,
    0x50f4,
    0x50d8,
    0x514a,
    CP932_CP_VAL_NULL,
    0x5164,
    0x519d,
    0x51be,
    0x51ec,
    0x5215,
    0x529c,
    0x52a6,
    0x52c0,
    0x52db,
    0x5300,
    0x5307,
    0x5324,
    0x5372,
    0x5393,
    0x53b2,
    0x53dd,
    0xfa0e,
    0x549c,
    0x548a,
    0x54a9,
    0x54ff,
    0x5586,
    0x5759,
    0x5765,
    0x57ac,
    0x57c8,
    0x57c7,
    0xfa0f,
    0xfa10,
    0x589e,
    0x58b2,
    0x590b,
    0x5953,
    0x595b,
    0x595d,
    0x5963,
    0x59a4,
    0x59ba,
    0x5b56,
    0x5bc0,
    0x752f,
    0x5bd8,
    0x5bec,
    0x5c1e,
    0x5ca6,
    0x5cba,
    0x5cf5,
    0x5d27,
    0x5d53,
    0xfa11,
    0x5d42,
    0x5d6d,
    0x5db8,
    0x5db9,
    0x5dd0,
    0x5f21,
    0x5f34,
    0x5f67,
    0x5fb7,
    0x5fde,
    0x605d,
    0x6085,
    0x608a,
    0x60de,
    0x60d5,
    0x6120,
    0x60f2,
    0x6111,
    0x6137,
    0x6130,
    0x6198,
    0x6213,
    0x62a6,
    0x63f5,
    0x6460,
    0x649d,
    0x64ce,
    0x654e,
    0x6600,
    0x6615,
    0x663b,
    0x6609,
    0x662e,
    0x661e,
    0x6624,
    0x6665,
    0x6657,
    0x6659,
    0xfa12,
    0x6673,
    0x6699,
    0x66a0,
    0x66b2,
    0x66bf,
    0x66fa,
    0x670e,
    0xf929,
    0x6766,
    0x67bb,
    0x6852,
    0x67c0,
    0x6801,
    0x6844,
    0x68cf,
    0xfa13,
    0x6968,
    0xfa14,
    0x6998,
    0x69e2,
    0x6a30,
    0x6a6b,
    0x6a46,
    0x6a73,
    0x6a7e,
    0x6ae2,
    0x6ae4,
    0x6bd6,
    0x6c3f,
    0x6c5c,
    0x6c86,
    0x6c6f,
    0x6cda,
    0x6d04,
    0x6d87,
    0x6d6f,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL
};
UINT16 cp932_CP_a0xfb[] = {
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x6d96,
    0x6dac,
    0x6dcf,
    0x6df8,
    0x6df2,
    0x6dfc,
    0x6e39,
    0x6e5c,
    0x6e27,
    0x6e3c,
    0x6ebf,
    0x6f88,
    0x6fb5,
    0x6ff5,
    0x7005,
    0x7007,
    0x7028,
    0x7085,
    0x70ab,
    0x710f,
    0x7104,
    0x715c,
    0x7146,
    0x7147,
    0xfa15,
    0x71c1,
    0x71fe,
    0x72b1,
    0x72be,
    0x7324,
    0xfa16,
    0x7377,
    0x73bd,
    0x73c9,
    0x73d6,
    0x73e3,
    0x73d2,
    0x7407,
    0x73f5,
    0x7426,
    0x742a,
    0x7429,
    0x742e,
    0x7462,
    0x7489,
    0x749f,
    0x7501,
    0x756f,
    0x7682,
    0x769c,
    0x769e,
    0x769b,
    0x76a6,
    0xfa17,
    0x7746,
    0x52af,
    0x7821,
    0x784e,
    0x7864,
    0x787a,
    0x7930,
    0xfa18,
    0xfa19,
    CP932_CP_VAL_NULL,
    0xfa1a,
    0x7994,
    0xfa1b,
    0x799b,
    0x7ad1,
    0x7ae7,
    0xfa1c,
    0x7aeb,
    0x7b9e,
    0xfa1d,
    0x7d48,
    0x7d5c,
    0x7db7,
    0x7da0,
    0x7dd6,
    0x7e52,
    0x7f47,
    0x7fa1,
    0xfa1e,
    0x8301,
    0x8362,
    0x837f,
    0x83c7,
    0x83f6,
    0x8448,
    0x84b4,
    0x8553,
    0x8559,
    0x856b,
    0xfa1f,
    0x85b0,
    0xfa20,
    0xfa21,
    0x8807,
    0x88f5,
    0x8a12,
    0x8a37,
    0x8a79,
    0x8aa7,
    0x8abe,
    0x8adf,
    0xfa22,
    0x8af6,
    0x8b53,
    0x8b7f,
    0x8cf0,
    0x8cf4,
    0x8d12,
    0x8d76,
    0xfa23,
    0x8ecf,
    0xfa24,
    0xfa25,
    0x9067,
    0x90de,
    0xfa26,
    0x9115,
    0x9127,
    0x91da,
    0x91d7,
    0x91de,
    0x91ed,
    0x91ee,
    0x91e4,
    0x91e5,
    0x9206,
    0x9210,
    0x920a,
    0x923a,
    0x9240,
    0x923c,
    0x924e,
    0x9259,
    0x9251,
    0x9239,
    0x9267,
    0x92a7,
    0x9277,
    0x9278,
    0x92e7,
    0x92d7,
    0x92d9,
    0x92d0,
    0xfa27,
    0x92d5,
    0x92e0,
    0x92d3,
    0x9325,
    0x9321,
    0x92fb,
    0xfa28,
    0x931e,
    0x92ff,
    0x931d,
    0x9302,
    0x9370,
    0x9357,
    0x93a4,
    0x93c6,
    0x93de,
    0x93f8,
    0x9431,
    0x9445,
    0x9448,
    0x9592,
    0xf9dc,
    0xfa29,
    0x969d,
    0x96af,
    0x9733,
    0x973b,
    0x9743,
    0x974d,
    0x974f,
    0x9751,
    0x9755,
    0x9857,
    0x9865,
    0xfa2a,
    0xfa2b,
    0x9927,
    0xfa2c,
    0x999e,
    0x9a4e,
    0x9ad9,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL
};
UINT16 cp932_CP_a0xfc[] = {
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    0x9adc,
    0x9b75,
    0x9b72,
    0x9b8f,
    0x9bb1,
    0x9bbb,
    0x9c00,
    0x9d70,
    0x9d6b,
    0xfa2d,
    0x9e19,
    0x9ed1,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL
};
VOID *cp932_CP_idx[] = {
    &cp932_CP_a0x0,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    &cp932_CP_a0x81,
    &cp932_CP_a0x82,
    &cp932_CP_a0x83,
    &cp932_CP_a0x84,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    &cp932_CP_a0x87,
    &cp932_CP_a0x88,
    &cp932_CP_a0x89,
    &cp932_CP_a0x8a,
    &cp932_CP_a0x8b,
    &cp932_CP_a0x8c,
    &cp932_CP_a0x8d,
    &cp932_CP_a0x8e,
    &cp932_CP_a0x8f,
    &cp932_CP_a0x90,
    &cp932_CP_a0x91,
    &cp932_CP_a0x92,
    &cp932_CP_a0x93,
    &cp932_CP_a0x94,
    &cp932_CP_a0x95,
    &cp932_CP_a0x96,
    &cp932_CP_a0x97,
    &cp932_CP_a0x98,
    &cp932_CP_a0x99,
    &cp932_CP_a0x9a,
    &cp932_CP_a0x9b,
    &cp932_CP_a0x9c,
    &cp932_CP_a0x9d,
    &cp932_CP_a0x9e,
    &cp932_CP_a0x9f,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    &cp932_CP_a0xe0,
    &cp932_CP_a0xe1,
    &cp932_CP_a0xe2,
    &cp932_CP_a0xe3,
    &cp932_CP_a0xe4,
    &cp932_CP_a0xe5,
    &cp932_CP_a0xe6,
    &cp932_CP_a0xe7,
    &cp932_CP_a0xe8,
    &cp932_CP_a0xe9,
    &cp932_CP_a0xea,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    &cp932_CP_a0xed,
    &cp932_CP_a0xee,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    &cp932_CP_a0xfa,
    &cp932_CP_a0xfb,
    &cp932_CP_a0xfc,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL,
    CP932_CP_VAL_NULL
};
UINT16 cp932_UNI_a0x0[] = {
    0x0,
    0x1,
    0x2,
    0x3,
    0x4,
    0x5,
    0x6,
    0x7,
    0x8,
    0x9,
    0xa,
    0xb,
    0xc,
    0xd,
    0xe,
    0xf,
    0x10,
    0x11,
    0x12,
    0x13,
    0x14,
    0x15,
    0x16,
    0x17,
    0x18,
    0x19,
    0x1a,
    0x1b,
    0x1c,
    0x1d,
    0x1e,
    0x1f,
    0x20,
    0x21,
    0x22,
    0x23,
    0x24,
    0x25,
    0x26,
    0x27,
    0x28,
    0x29,
    0x2a,
    0x2b,
    0x2c,
    0x2d,
    0x2e,
    0x2f,
    0x30,
    0x31,
    0x32,
    0x33,
    0x34,
    0x35,
    0x36,
    0x37,
    0x38,
    0x39,
    0x3a,
    0x3b,
    0x3c,
    0x3d,
    0x3e,
    0x3f,
    0x40,
    0x41,
    0x42,
    0x43,
    0x44,
    0x45,
    0x46,
    0x47,
    0x48,
    0x49,
    0x4a,
    0x4b,
    0x4c,
    0x4d,
    0x4e,
    0x4f,
    0x50,
    0x51,
    0x52,
    0x53,
    0x54,
    0x55,
    0x56,
    0x57,
    0x58,
    0x59,
    0x5a,
    0x5b,
    0x5c,
    0x5d,
    0x5e,
    0x5f,
    0x60,
    0x61,
    0x62,
    0x63,
    0x64,
    0x65,
    0x66,
    0x67,
    0x68,
    0x69,
    0x6a,
    0x6b,
    0x6c,
    0x6d,
    0x6e,
    0x6f,
    0x70,
    0x71,
    0x72,
    0x73,
    0x74,
    0x75,
    0x76,
    0x77,
    0x78,
    0x79,
    0x7a,
    0x7b,
    0x7c,
    0x7d,
    0x7e,
    0x7f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8198,
    0x814e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x818b,
    0x817d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x814c,
    CP932_UNI_VAL_NULL,
    0x81f7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x817e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8180,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x3[] = {
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x839f,
    0x83a0,
    0x83a1,
    0x83a2,
    0x83a3,
    0x83a4,
    0x83a5,
    0x83a6,
    0x83a7,
    0x83a8,
    0x83a9,
    0x83aa,
    0x83ab,
    0x83ac,
    0x83ad,
    0x83ae,
    0x83af,
    CP932_UNI_VAL_NULL,
    0x83b0,
    0x83b1,
    0x83b2,
    0x83b3,
    0x83b4,
    0x83b5,
    0x83b6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x83bf,
    0x83c0,
    0x83c1,
    0x83c2,
    0x83c3,
    0x83c4,
    0x83c5,
    0x83c6,
    0x83c7,
    0x83c8,
    0x83c9,
    0x83ca,
    0x83cb,
    0x83cc,
    0x83cd,
    0x83ce,
    0x83cf,
    CP932_UNI_VAL_NULL,
    0x83d0,
    0x83d1,
    0x83d2,
    0x83d3,
    0x83d4,
    0x83d5,
    0x83d6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x4[] = {
    CP932_UNI_VAL_NULL,
    0x8446,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8440,
    0x8441,
    0x8442,
    0x8443,
    0x8444,
    0x8445,
    0x8447,
    0x8448,
    0x8449,
    0x844a,
    0x844b,
    0x844c,
    0x844d,
    0x844e,
    0x844f,
    0x8450,
    0x8451,
    0x8452,
    0x8453,
    0x8454,
    0x8455,
    0x8456,
    0x8457,
    0x8458,
    0x8459,
    0x845a,
    0x845b,
    0x845c,
    0x845d,
    0x845e,
    0x845f,
    0x8460,
    0x8470,
    0x8471,
    0x8472,
    0x8473,
    0x8474,
    0x8475,
    0x8477,
    0x8478,
    0x8479,
    0x847a,
    0x847b,
    0x847c,
    0x847d,
    0x847e,
    0x8480,
    0x8481,
    0x8482,
    0x8483,
    0x8484,
    0x8485,
    0x8486,
    0x8487,
    0x8488,
    0x8489,
    0x848a,
    0x848b,
    0x848c,
    0x848d,
    0x848e,
    0x848f,
    0x8490,
    0x8491,
    CP932_UNI_VAL_NULL,
    0x8476,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x20[] = {
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x815d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x815c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8165,
    0x8166,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8167,
    0x8168,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x81f5,
    0x81f6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8164,
    0x8163,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x81f1,
    CP932_UNI_VAL_NULL,
    0x818c,
    0x818d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x81a6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x21[] = {
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x818e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8782,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8784,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x81f0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8754,
    0x8755,
    0x8756,
    0x8757,
    0x8758,
    0x8759,
    0x875a,
    0x875b,
    0x875c,
    0x875d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfa40,
    0xfa41,
    0xfa42,
    0xfa43,
    0xfa44,
    0xfa45,
    0xfa46,
    0xfa47,
    0xfa48,
    0xfa49,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x81a9,
    0x81aa,
    0x81a8,
    0x81ab,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x81cb,
    CP932_UNI_VAL_NULL,
    0x81cc,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x22[] = {
    0x81cd,
    CP932_UNI_VAL_NULL,
    0x81dd,
    0x81ce,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x81de,
    0x81b8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x81b9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8794,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x81e3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x81e5,
    0x8187,
    0x8798,
    0x81da,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8161,
    CP932_UNI_VAL_NULL,
    0x81c8,
    0x81c9,
    0x81bf,
    0x81be,
    0x81e7,
    0x81e8,
    CP932_UNI_VAL_NULL,
    0x8793,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8188,
    0x81e6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x81e4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x81e0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8182,
    0x81df,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8185,
    0x8186,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x81e1,
    0x81e2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x81bc,
    0x81bd,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x81ba,
    0x81bb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x81db,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8799,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x23[] = {
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x81dc,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x24[] = {
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8740,
    0x8741,
    0x8742,
    0x8743,
    0x8744,
    0x8745,
    0x8746,
    0x8747,
    0x8748,
    0x8749,
    0x874a,
    0x874b,
    0x874c,
    0x874d,
    0x874e,
    0x874f,
    0x8750,
    0x8751,
    0x8752,
    0x8753,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x25[] = {
    0x849f,
    0x84aa,
    0x84a0,
    0x84ab,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x84a1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x84ac,
    0x84a2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x84ad,
    0x84a4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x84af,
    0x84a3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x84ae,
    0x84a5,
    0x84ba,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x84b5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x84b0,
    0x84a7,
    0x84bc,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x84b7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x84b2,
    0x84a6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x84b6,
    0x84bb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x84b1,
    0x84a8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x84b8,
    0x84bd,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x84b3,
    0x84a9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x84b9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x84be,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x84b4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x81a1,
    0x81a0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x81a3,
    0x81a2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x81a5,
    0x81a4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x819f,
    0x819e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x819b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x819d,
    0x819c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x81fc,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x26[] = {
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x819a,
    0x8199,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x818a,
    CP932_UNI_VAL_NULL,
    0x8189,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x81f4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x81f3,
    CP932_UNI_VAL_NULL,
    0x81f2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x30[] = {
    0x8140,
    0x8141,
    0x8142,
    0x8156,
    CP932_UNI_VAL_NULL,
    0x8158,
    0x8159,
    0x815a,
    0x8171,
    0x8172,
    0x8173,
    0x8174,
    0x8175,
    0x8176,
    0x8177,
    0x8178,
    0x8179,
    0x817a,
    0x81a7,
    0x81ac,
    0x816b,
    0x816c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8780,
    CP932_UNI_VAL_NULL,
    0x8781,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x829f,
    0x82a0,
    0x82a1,
    0x82a2,
    0x82a3,
    0x82a4,
    0x82a5,
    0x82a6,
    0x82a7,
    0x82a8,
    0x82a9,
    0x82aa,
    0x82ab,
    0x82ac,
    0x82ad,
    0x82ae,
    0x82af,
    0x82b0,
    0x82b1,
    0x82b2,
    0x82b3,
    0x82b4,
    0x82b5,
    0x82b6,
    0x82b7,
    0x82b8,
    0x82b9,
    0x82ba,
    0x82bb,
    0x82bc,
    0x82bd,
    0x82be,
    0x82bf,
    0x82c0,
    0x82c1,
    0x82c2,
    0x82c3,
    0x82c4,
    0x82c5,
    0x82c6,
    0x82c7,
    0x82c8,
    0x82c9,
    0x82ca,
    0x82cb,
    0x82cc,
    0x82cd,
    0x82ce,
    0x82cf,
    0x82d0,
    0x82d1,
    0x82d2,
    0x82d3,
    0x82d4,
    0x82d5,
    0x82d6,
    0x82d7,
    0x82d8,
    0x82d9,
    0x82da,
    0x82db,
    0x82dc,
    0x82dd,
    0x82de,
    0x82df,
    0x82e0,
    0x82e1,
    0x82e2,
    0x82e3,
    0x82e4,
    0x82e5,
    0x82e6,
    0x82e7,
    0x82e8,
    0x82e9,
    0x82ea,
    0x82eb,
    0x82ec,
    0x82ed,
    0x82ee,
    0x82ef,
    0x82f0,
    0x82f1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x814a,
    0x814b,
    0x8154,
    0x8155,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8340,
    0x8341,
    0x8342,
    0x8343,
    0x8344,
    0x8345,
    0x8346,
    0x8347,
    0x8348,
    0x8349,
    0x834a,
    0x834b,
    0x834c,
    0x834d,
    0x834e,
    0x834f,
    0x8350,
    0x8351,
    0x8352,
    0x8353,
    0x8354,
    0x8355,
    0x8356,
    0x8357,
    0x8358,
    0x8359,
    0x835a,
    0x835b,
    0x835c,
    0x835d,
    0x835e,
    0x835f,
    0x8360,
    0x8361,
    0x8362,
    0x8363,
    0x8364,
    0x8365,
    0x8366,
    0x8367,
    0x8368,
    0x8369,
    0x836a,
    0x836b,
    0x836c,
    0x836d,
    0x836e,
    0x836f,
    0x8370,
    0x8371,
    0x8372,
    0x8373,
    0x8374,
    0x8375,
    0x8376,
    0x8377,
    0x8378,
    0x8379,
    0x837a,
    0x837b,
    0x837c,
    0x837d,
    0x837e,
    0x8380,
    0x8381,
    0x8382,
    0x8383,
    0x8384,
    0x8385,
    0x8386,
    0x8387,
    0x8388,
    0x8389,
    0x838a,
    0x838b,
    0x838c,
    0x838d,
    0x838e,
    0x838f,
    0x8390,
    0x8391,
    0x8392,
    0x8393,
    0x8394,
    0x8395,
    0x8396,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8145,
    0x815b,
    0x8152,
    0x8153,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x32[] = {
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x878a,
    0x878b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x878c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8785,
    0x8786,
    0x8787,
    0x8788,
    0x8789,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x33[] = {
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8765,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8769,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8760,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8763,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8761,
    0x876b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x876a,
    0x8764,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x876c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8766,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x876e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x875f,
    0x876d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8762,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8767,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8768,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x877e,
    0x878f,
    0x878e,
    0x878d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8772,
    0x8773,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x876f,
    0x8770,
    0x8771,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8775,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8774,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8783,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x4e[] = {
    0x88ea,
    0x929a,
    CP932_UNI_VAL_NULL,
    0x8eb5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x969c,
    0x8fe4,
    0x8e4f,
    0x8fe3,
    0x89ba,
    CP932_UNI_VAL_NULL,
    0x9573,
    0x975e,
    CP932_UNI_VAL_NULL,
    0x98a0,
    0x894e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8a8e,
    0x98a1,
    0x90a2,
    0x99c0,
    0x8b75,
    0x95b8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8fe5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x97bc,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x95c0,
    CP932_UNI_VAL_NULL,
    0xfa68,
    CP932_UNI_VAL_NULL,
    0x98a2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9286,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x98a3,
    0x8bf8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x98a4,
    CP932_UNI_VAL_NULL,
    0x8adb,
    0x924f,
    CP932_UNI_VAL_NULL,
    0x8ee5,
    0x98a5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x98a6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x98a7,
    0x9454,
    CP932_UNI_VAL_NULL,
    0x8b76,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9456,
    CP932_UNI_VAL_NULL,
    0x93e1,
    0x8cc1,
    0x9652,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe568,
    0x98a8,
    0x8fe6,
    0x98a9,
    0x89b3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8be3,
    0x8cee,
    0x96e7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ba4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9790,
    CP932_UNI_VAL_NULL,
    0x93fb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8aa3,
    CP932_UNI_VAL_NULL,
    0x8b54,
    CP932_UNI_VAL_NULL,
    0x98aa,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x98ab,
    0x97b9,
    CP932_UNI_VAL_NULL,
    0x975c,
    0x9188,
    0x98ad,
    0x8e96,
    0x93f1,
    CP932_UNI_VAL_NULL,
    0x98b0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x895d,
    0x8cdd,
    CP932_UNI_VAL_NULL,
    0x8cdc,
    0x88e4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x986a,
    0x9869,
    CP932_UNI_VAL_NULL,
    0x8db1,
    0x889f,
    CP932_UNI_VAL_NULL,
    0x98b1,
    0x98b2,
    0x98b3,
    0x9653,
    0x98b4,
    CP932_UNI_VAL_NULL,
    0x8cf0,
    0x88e5,
    0x9692,
    CP932_UNI_VAL_NULL,
    0x8b9c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8b9d,
    0x8b9e,
    0x92e0,
    0x97ba,
    CP932_UNI_VAL_NULL,
    0x98b5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x98b6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x98b7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x906c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8f59,
    0x906d,
    0x98bc,
    CP932_UNI_VAL_NULL,
    0x98ba,
    CP932_UNI_VAL_NULL,
    0x98bb,
    0x8b77,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8da1,
    0x89ee,
    CP932_UNI_VAL_NULL,
    0x98b9,
    0x98b8,
    0x95a7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8e65,
    0x8e64,
    0x91bc,
    0x98bd,
    0x9574,
    0x90e5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8157,
    0x98be,
    0x98c0,
    CP932_UNI_VAL_NULL,
    0xfa69,
    CP932_UNI_VAL_NULL,
    0x91e3,
    0x97df,
    0x88c8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x98bf,
    0x89bc,
    CP932_UNI_VAL_NULL,
    0x8bc2,
    CP932_UNI_VAL_NULL,
    0x9287,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8c8f,
    0x98c1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9443,
    0xfa6a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x4f[] = {
    0xfa6b,
    0x8ae9,
    CP932_UNI_VAL_NULL,
    0xfa6c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x98c2,
    0x88c9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8cde,
    0x8aea,
    0x959a,
    0x94b0,
    0x8b78,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x89ef,
    CP932_UNI_VAL_NULL,
    0x98e5,
    0x9360,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x948c,
    0x98c4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x94ba,
    CP932_UNI_VAL_NULL,
    0x97e0,
    CP932_UNI_VAL_NULL,
    0x904c,
    0xfa6d,
    0x8e66,
    CP932_UNI_VAL_NULL,
    0x8e97,
    0x89be,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x92cf,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9241,
    0x98c8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x88ca,
    0x92e1,
    0x8f5a,
    0x8db2,
    0x9743,
    CP932_UNI_VAL_NULL,
    0x91cc,
    CP932_UNI_VAL_NULL,
    0x89bd,
    0xfa6e,
    0x98c7,
    CP932_UNI_VAL_NULL,
    0x975d,
    0x98c3,
    0x98c5,
    0x8dec,
    0x98c6,
    0x9b43,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x98ce,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x98d1,
    0x98cf,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x89c0,
    CP932_UNI_VAL_NULL,
    0x95b9,
    0x98c9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x98cd,
    0x8cf1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8e67,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8aa4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x98d2,
    CP932_UNI_VAL_NULL,
    0x98ca,
    CP932_UNI_VAL_NULL,
    0xfa70,
    0x97e1,
    CP932_UNI_VAL_NULL,
    0x8e98,
    CP932_UNI_VAL_NULL,
    0x98cb,
    CP932_UNI_VAL_NULL,
    0x98d0,
    0xfa6f,
    CP932_UNI_VAL_NULL,
    0xfa72,
    CP932_UNI_VAL_NULL,
    0x98d3,
    CP932_UNI_VAL_NULL,
    0x98cc,
    CP932_UNI_VAL_NULL,
    0xfa71,
    0x8b9f,
    CP932_UNI_VAL_NULL,
    0x88cb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ba0,
    0x89bf,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9b44,
    CP932_UNI_VAL_NULL,
    0x9699,
    0x958e,
    0x8cf2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x904e,
    0x97b5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x95d6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8c57,
    0x91a3,
    0x89e2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfa61,
    0x8f72,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfa73,
    0x98d7,
    CP932_UNI_VAL_NULL,
    0x98dc,
    0x98da,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x98d5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x91ad,
    0x98d8,
    CP932_UNI_VAL_NULL,
    0x98db,
    0x98d9,
    CP932_UNI_VAL_NULL,
    0x95db,
    CP932_UNI_VAL_NULL,
    0x98d6,
    CP932_UNI_VAL_NULL,
    0x904d,
    CP932_UNI_VAL_NULL,
    0x9693,
    0x98dd,
    0x98de,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8f43,
    0x98eb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x946f,
    CP932_UNI_VAL_NULL,
    0x9555,
    0x98e6,
    CP932_UNI_VAL_NULL,
    0x95ee,
    CP932_UNI_VAL_NULL,
    0x89b4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x98ea,
    0xfa76
};
UINT16 cp932_UNI_a0x50[] = {
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x98e4,
    0x98ed,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9171,
    CP932_UNI_VAL_NULL,
    0x8cc2,
    CP932_UNI_VAL_NULL,
    0x947b,
    CP932_UNI_VAL_NULL,
    0xe0c5,
    CP932_UNI_VAL_NULL,
    0x98ec,
    0x937c,
    CP932_UNI_VAL_NULL,
    0x98e1,
    CP932_UNI_VAL_NULL,
    0x8cf4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8cf3,
    0x98df,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfa77,
    0x8ed8,
    CP932_UNI_VAL_NULL,
    0x98e7,
    0xfa75,
    0x95ed,
    0x926c,
    0x98e3,
    0x8c91,
    CP932_UNI_VAL_NULL,
    0x98e0,
    0x98e8,
    0x98e2,
    0x97cf,
    0x98e9,
    0x9860,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8be4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8c90,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfa74,
    CP932_UNI_VAL_NULL,
    0xfa7a,
    0x98ee,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfa78,
    0x98ef,
    0x98f3,
    0x88cc,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x95ce,
    0x98f2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x98f1,
    0x98f5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x98f4,
    CP932_UNI_VAL_NULL,
    0x92e2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8c92,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x98f6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfa79,
    CP932_UNI_VAL_NULL,
    0x8ec3,
    CP932_UNI_VAL_NULL,
    0x91a4,
    0x92e3,
    0x8bf4,
    CP932_UNI_VAL_NULL,
    0x98f7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8b55,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x98f8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x98fa,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9654,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8c86,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfa7b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8e50,
    0x94f5,
    0x98f9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8dc3,
    0x9762,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x98fc,
    0x9942,
    0x98fb,
    0x8dc2,
    CP932_UNI_VAL_NULL,
    0x8f9d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8c58,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9943,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8bcd,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9940,
    0x9941,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x93ad,
    CP932_UNI_VAL_NULL,
    0x919c,
    CP932_UNI_VAL_NULL,
    0x8ba1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x966c,
    0x9944,
    CP932_UNI_VAL_NULL,
    0xfa7d,
    CP932_UNI_VAL_NULL,
    0x97bb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9945,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9948,
    CP932_UNI_VAL_NULL,
    0x9946,
    CP932_UNI_VAL_NULL,
    0x916d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9947,
    0x9949,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfa7c,
    0x994b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x994a,
    CP932_UNI_VAL_NULL,
    0x95c6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x51[] = {
    0x8b56,
    0x994d,
    0x994e,
    CP932_UNI_VAL_NULL,
    0x89ad,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x994c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ef2,
    CP932_UNI_VAL_NULL,
    0x9951,
    0x9950,
    0x994f,
    CP932_UNI_VAL_NULL,
    0x98d4,
    CP932_UNI_VAL_NULL,
    0x9952,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8f9e,
    CP932_UNI_VAL_NULL,
    0x9953,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9744,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x96d7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9955,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9954,
    0x9957,
    0x9956,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9958,
    0x9959,
    0x88f2,
    CP932_UNI_VAL_NULL,
    0x8cb3,
    0x8c5a,
    0x8f5b,
    0x929b,
    0x8ba2,
    0x90e6,
    0x8cf5,
    0xfa7e,
    0x8d8e,
    0x995b,
    0x96c6,
    0x9365,
    CP932_UNI_VAL_NULL,
    0x8e99,
    CP932_UNI_VAL_NULL,
    0x995a,
    CP932_UNI_VAL_NULL,
    0x995c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x937d,
    CP932_UNI_VAL_NULL,
    0x8a95,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x995d,
    CP932_UNI_VAL_NULL,
    0xfa80,
    0x93fc,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9153,
    0x995f,
    0x9960,
    0x94aa,
    0x8cf6,
    0x985a,
    0x9961,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ba4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x95ba,
    0x91b4,
    0x8bef,
    0x9354,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8c93,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9962,
    CP932_UNI_VAL_NULL,
    0x9963,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x93e0,
    0x897e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9966,
    0x8dfb,
    CP932_UNI_VAL_NULL,
    0x9965,
    0x8dc4,
    CP932_UNI_VAL_NULL,
    0x9967,
    0xe3ec,
    0x9968,
    0x9660,
    0x9969,
    CP932_UNI_VAL_NULL,
    0x996a,
    0x996b,
    0x8fe7,
    CP932_UNI_VAL_NULL,
    0x8eca,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfa81,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8aa5,
    CP932_UNI_VAL_NULL,
    0x996e,
    CP932_UNI_VAL_NULL,
    0x996c,
    0x96bb,
    0x996d,
    CP932_UNI_VAL_NULL,
    0x9579,
    0x996f,
    0x9970,
    0x9971,
    0x937e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9975,
    0x9973,
    0x9974,
    0x9972,
    0x8de1,
    0x9976,
    0x96e8,
    0x97e2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9977,
    0xfa82,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x90a6,
    0x9978,
    0x8f79,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9979,
    CP932_UNI_VAL_NULL,
    0x929c,
    0x97bd,
    0x9380,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x99c3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x997a,
    0xeaa3,
    0x8bc3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x997b,
    0x967d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8f88,
    0x91fa,
    CP932_UNI_VAL_NULL,
    0x997d,
    0x93e2,
    CP932_UNI_VAL_NULL,
    0xfa83,
    0x997e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9980,
    0x8a4d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9981,
    0x8ba5,
    CP932_UNI_VAL_NULL,
    0x93ca,
    0x899a,
    0x8f6f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x949f,
    0x9982,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x52[] = {
    0x9381,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x906e,
    0x9983,
    CP932_UNI_VAL_NULL,
    0x95aa,
    0x90d8,
    0x8aa0,
    CP932_UNI_VAL_NULL,
    0x8aa7,
    0x9984,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9986,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8c59,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9985,
    0xfa84,
    CP932_UNI_VAL_NULL,
    0x97f1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8f89,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x94bb,
    0x95ca,
    CP932_UNI_VAL_NULL,
    0x9987,
    CP932_UNI_VAL_NULL,
    0x9798,
    0x9988,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9989,
    CP932_UNI_VAL_NULL,
    0x939e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x998a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x90a7,
    0x8dfc,
    0x8c94,
    0x998b,
    0x8e68,
    0x8d8f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x92e4,
    0x998d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x91a5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ded,
    0x998e,
    0x998f,
    0x914f,
    CP932_UNI_VAL_NULL,
    0x998c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9991,
    CP932_UNI_VAL_NULL,
    0x9655,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8d84,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9990,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8c95,
    0x8ddc,
    0x948d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9994,
    0x9992,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x959b,
    0x8fe8,
    0x999b,
    0x8a84,
    0x9995,
    0x9993,
    0x916e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9997,
    CP932_UNI_VAL_NULL,
    0x9996,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8a63,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8c80,
    0x999c,
    0x97ab,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9998,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x999d,
    0x999a,
    CP932_UNI_VAL_NULL,
    0x9999,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x97cd,
    0xfa85,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8cf7,
    0x89c1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x97f2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfa86,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8f95,
    0x9377,
    0x8d85,
    0x99a0,
    0x99a1,
    CP932_UNI_VAL_NULL,
    0xfb77,
    CP932_UNI_VAL_NULL,
    0x97e3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x984a,
    0x99a3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8cf8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x99a2,
    CP932_UNI_VAL_NULL,
    0x8a4e,
    CP932_UNI_VAL_NULL,
    0xfa87,
    0x99a4,
    CP932_UNI_VAL_NULL,
    0x9675,
    CP932_UNI_VAL_NULL,
    0x92ba,
    CP932_UNI_VAL_NULL,
    0x9745,
    CP932_UNI_VAL_NULL,
    0x95d7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x99a5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe8d3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x93ae,
    CP932_UNI_VAL_NULL,
    0x99a6,
    0x8aa8,
    0x96b1,
    CP932_UNI_VAL_NULL,
    0xfa88,
    CP932_UNI_VAL_NULL,
    0x8f9f,
    0x99a7,
    0x95e5,
    0x99ab,
    CP932_UNI_VAL_NULL,
    0x90a8,
    0x99a8,
    0x8bce,
    CP932_UNI_VAL_NULL,
    0x99a9,
    0x8aa9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8c4d,
    0x99ac,
    CP932_UNI_VAL_NULL,
    0x99ad,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x99ae,
    0x99af,
    0x8ed9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8cf9,
    0x96dc
};
UINT16 cp932_UNI_a0x53[] = {
    0xfa89,
    0x96e6,
    0x93f5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x95ef,
    0x99b0,
    0xfa8a,
    0x99b1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x99b3,
    CP932_UNI_VAL_NULL,
    0x99b5,
    0x99b4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x99b6,
    0x89bb,
    0x966b,
    CP932_UNI_VAL_NULL,
    0x8dfa,
    0x99b7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9178,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8fa0,
    0x8ba7,
    CP932_UNI_VAL_NULL,
    0x99b8,
    0xfa8b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x94d9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x99b9,
    CP932_UNI_VAL_NULL,
    0x99ba,
    CP932_UNI_VAL_NULL,
    0x99bb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x99bc,
    0x9543,
    0x8be6,
    0x88e3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x93bd,
    0x99bd,
    0x8f5c,
    CP932_UNI_VAL_NULL,
    0x90e7,
    CP932_UNI_VAL_NULL,
    0x99bf,
    0x99be,
    0x8fa1,
    0x8cdf,
    0x99c1,
    0x94bc,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x99c2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x94da,
    0x91b2,
    0x91ec,
    0x8ba6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x93ec,
    0x9250,
    CP932_UNI_VAL_NULL,
    0x948e,
    CP932_UNI_VAL_NULL,
    0x966d,
    CP932_UNI_VAL_NULL,
    0x99c4,
    CP932_UNI_VAL_NULL,
    0x90e8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8c54,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x99c5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x99c6,
    0x894b,
    0x88f3,
    0x8aeb,
    0xfa8c,
    0x91a6,
    0x8b70,
    0x9791,
    CP932_UNI_VAL_NULL,
    0x99c9,
    0x89b5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x99c8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ba8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x99ca,
    CP932_UNI_VAL_NULL,
    0x96ef,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfa8d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x99cb,
    CP932_UNI_VAL_NULL,
    0x97d0,
    CP932_UNI_VAL_NULL,
    0x8cfa,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8cb4,
    0x99cc,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x99ce,
    0x99cd,
    CP932_UNI_VAL_NULL,
    0x907e,
    0x8958,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x897d,
    0x99cf,
    CP932_UNI_VAL_NULL,
    0x99d0,
    CP932_UNI_VAL_NULL,
    0xfa8e,
    0x8cb5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x99d1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8b8e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8e51,
    0x99d2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9694,
    0x8db3,
    0x8b79,
    0x9746,
    0x916f,
    0x94bd,
    0x8efb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8f66,
    CP932_UNI_VAL_NULL,
    0x8ee6,
    0x8ef3,
    CP932_UNI_VAL_NULL,
    0x8f96,
    CP932_UNI_VAL_NULL,
    0x94be,
    CP932_UNI_VAL_NULL,
    0xfa8f,
    CP932_UNI_VAL_NULL,
    0x99d5,
    CP932_UNI_VAL_NULL,
    0x8962,
    0x9170,
    0x8cfb,
    0x8cc3,
    0x8be5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x99d9,
    0x9240,
    0x91fc,
    0x8ba9,
    0x8fa2,
    0x99da,
    0x99d8,
    0x89c2,
    0x91e4,
    0x8eb6,
    0x8e6a,
    0x8945,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8a90,
    0x8d86,
    0x8e69,
    CP932_UNI_VAL_NULL,
    0x99db,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x54[] = {
    CP932_UNI_VAL_NULL,
    0x99dc,
    CP932_UNI_VAL_NULL,
    0x8b68,
    0x8a65,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8d87,
    0x8b67,
    0x92dd,
    0x8944,
    0x93af,
    0x96bc,
    0x8d40,
    0x9799,
    0x9366,
    0x8cfc,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8c4e,
    CP932_UNI_VAL_NULL,
    0x99e5,
    CP932_UNI_VAL_NULL,
    0x8be1,
    0x9669,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x94db,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x99e4,
    CP932_UNI_VAL_NULL,
    0x8adc,
    0x99df,
    0x99e0,
    0x99e2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x99e3,
    CP932_UNI_VAL_NULL,
    0x8b7a,
    0x9081,
    CP932_UNI_VAL_NULL,
    0x95ab,
    0x99e1,
    0x99dd,
    0x8ce1,
    CP932_UNI_VAL_NULL,
    0x99de,
    CP932_UNI_VAL_NULL,
    0x9843,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x95f0,
    CP932_UNI_VAL_NULL,
    0x92e6,
    0x8ce0,
    0x8d90,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x99e6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x93db,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x99ea,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8efc,
    CP932_UNI_VAL_NULL,
    0x8ef4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x99ed,
    0x99eb,
    CP932_UNI_VAL_NULL,
    0x96a1,
    CP932_UNI_VAL_NULL,
    0x99e8,
    0x99f1,
    0x99ec,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x99ef,
    0x8cc4,
    0x96bd,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x99f0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x99f2,
    CP932_UNI_VAL_NULL,
    0x99f4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfa92,
    0x8dee,
    0x9861,
    CP932_UNI_VAL_NULL,
    0x99e9,
    0x99e7,
    0x99f3,
    CP932_UNI_VAL_NULL,
    0x99ee,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfa91,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x99f6,
    CP932_UNI_VAL_NULL,
    0x9a42,
    0x99f8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x99fc,
    0xfa93,
    CP932_UNI_VAL_NULL,
    0x9a40,
    0x99f9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9a5d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8de7,
    0x8a50,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x99f7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9a44,
    0x88f4,
    0x9a43,
    CP932_UNI_VAL_NULL,
    0x88a3,
    0x9569,
    0x9a41,
    CP932_UNI_VAL_NULL,
    0x99fa,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x99f5,
    0x99fb,
    0x8dc6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9a45,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x88f5,
    0x9a4e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9a46,
    0x9a47,
    CP932_UNI_VAL_NULL,
    0x8fa3,
    0x9689,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9a4c,
    0x9a4b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x934e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9a4d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9a4a,
    CP932_UNI_VAL_NULL,
    0xfa94
};
UINT16 cp932_UNI_a0x55[] = {
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8953,
    CP932_UNI_VAL_NULL,
    0x8db4,
    0x904f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9a48,
    0x9382,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9a49,
    CP932_UNI_VAL_NULL,
    0x88a0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9a53,
    0x9742,
    CP932_UNI_VAL_NULL,
    0x8fa5,
    CP932_UNI_VAL_NULL,
    0x9a59,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9a58,
    0x9a4f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x91c1,
    CP932_UNI_VAL_NULL,
    0x9a50,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x91ed,
    0x9a55,
    0x8fa4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9a52,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x96e2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8c5b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9a56,
    0x9a57,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9a54,
    0x9a5a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9a51,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9a60,
    0x9a65,
    CP932_UNI_VAL_NULL,
    0x9a61,
    CP932_UNI_VAL_NULL,
    0x9a5c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9a66,
    0x9150,
    CP932_UNI_VAL_NULL,
    0xfa95,
    0x9a68,
    CP932_UNI_VAL_NULL,
    0x8d41,
    0x9a5e,
    0x929d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9a62,
    0x9a5b,
    0x8aab,
    CP932_UNI_VAL_NULL,
    0x8aec,
    0x8a85,
    0x9a63,
    0x9a5f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8c96,
    0x9a69,
    0x9a67,
    0x9172,
    0x8b69,
    0x8baa,
    CP932_UNI_VAL_NULL,
    0x9a64,
    CP932_UNI_VAL_NULL,
    0x8bf2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8963,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9a6d,
    0x9a6b,
    CP932_UNI_VAL_NULL,
    0x9aa5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9a70,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9a6a,
    CP932_UNI_VAL_NULL,
    0x9a6e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9a6c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8e6b,
    0x9a6f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9a72,
    CP932_UNI_VAL_NULL,
    0x9a77,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9a75,
    0x9a74,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x56[] = {
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9251,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x89c3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9a71,
    CP932_UNI_VAL_NULL,
    0x9a73,
    0x8fa6,
    0x8952,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9a76,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x89dc,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9a82,
    CP932_UNI_VAL_NULL,
    0x8ffa,
    0x9a7d,
    CP932_UNI_VAL_NULL,
    0x9a7b,
    CP932_UNI_VAL_NULL,
    0x9a7c,
    CP932_UNI_VAL_NULL,
    0x9a7e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x895c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9158,
    CP932_UNI_VAL_NULL,
    0x9a78,
    CP932_UNI_VAL_NULL,
    0x9a79,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8a9a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9a81,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8aed,
    CP932_UNI_VAL_NULL,
    0x9a84,
    0x9a80,
    0x9a83,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x95ac,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x93d3,
    CP932_UNI_VAL_NULL,
    0x94b6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9a86,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9a85,
    0x8a64,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9a87,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9a8a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9a89,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9a88,
    CP932_UNI_VAL_NULL,
    0x9458,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9a8b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9a8c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9a8e,
    CP932_UNI_VAL_NULL,
    0x9a8d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9a90,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9a93,
    0x9a91,
    0x9a8f,
    0x9a92,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9a94,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9a95,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9a96,
    CP932_UNI_VAL_NULL,
    0x9a97,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9a98,
    0x9964,
    CP932_UNI_VAL_NULL,
    0x8efa,
    0x8e6c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x89f1,
    CP932_UNI_VAL_NULL,
    0x88f6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9263,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9a99,
    CP932_UNI_VAL_NULL,
    0x8da2,
    CP932_UNI_VAL_NULL,
    0x88cd,
    0x907d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9a9a,
    0x8cc5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8d91,
    CP932_UNI_VAL_NULL,
    0x9a9c
};
UINT16 cp932_UNI_a0x57[] = {
    0x9a9b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x95de,
    0x9a9d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9a9f,
    0x9a9e,
    CP932_UNI_VAL_NULL,
    0x9aa0,
    CP932_UNI_VAL_NULL,
    0x9aa1,
    CP932_UNI_VAL_NULL,
    0x8c97,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8980,
    0x9aa2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9aa4,
    CP932_UNI_VAL_NULL,
    0x9aa3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9aa6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9379,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9aa7,
    0x88b3,
    0x8ddd,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8c5c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x926e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9aa8,
    0x9aa9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9aab,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9aac,
    CP932_UNI_VAL_NULL,
    0x8de2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8bcf,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9656,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9aaa,
    0x9aad,
    0x8dbf,
    0x8d42,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfa96,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ab1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8da3,
    0xfa97,
    0x9252,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9aae,
    0x92d8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ab2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9082,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ab0,
    0x9ab3,
    CP932_UNI_VAL_NULL,
    0x8c5e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ab4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ab5,
    CP932_UNI_VAL_NULL,
    0x8d43,
    0x8a5f,
    0x9ab7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ab8,
    CP932_UNI_VAL_NULL,
    0xfa98,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ab9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ab6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9aaf,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9aba,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9abb,
    0xfa9a,
    0xfa99,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9684,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8fe9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9abd,
    0x9abe,
    0x9abc,
    CP932_UNI_VAL_NULL,
    0x9ac0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9457,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x88e6,
    0x9575,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ac1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ffb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8eb7,
    CP932_UNI_VAL_NULL,
    0x947c,
    0x8aee,
    CP932_UNI_VAL_NULL,
    0x8de9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x58[] = {
    0x9678,
    CP932_UNI_VAL_NULL,
    0x93b0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8c98,
    0x91cd,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9abf,
    0x9ac2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x91c2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ac3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ac4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ac6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x92e7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8aac,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xea9f,
    0x8981,
    0x95f1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8fea,
    0x9367,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8de4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9acc,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x95bb,
    0x97db,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x89f2,
    0x9ac8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9159,
    0x9acb,
    CP932_UNI_VAL_NULL,
    0x9383,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9368,
    0x9384,
    0x94b7,
    0x92cb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8dc7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ac7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8996,
    CP932_UNI_VAL_NULL,
    0x9355,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ac9,
    CP932_UNI_VAL_NULL,
    0x9ac5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x906f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9acd,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8f6d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8bab,
    CP932_UNI_VAL_NULL,
    0x9ace,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x95e6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x919d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x92c4,
    CP932_UNI_VAL_NULL,
    0xfa9d,
    0x9ad0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x966e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ad1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ad6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfa9e,
    0x95ad,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ad5,
    0x9acf,
    0x9ad2,
    0x9ad4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8da4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x95c7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ad7,
    CP932_UNI_VAL_NULL,
    0x9264,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x89f3,
    CP932_UNI_VAL_NULL,
    0x8feb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ad9,
    CP932_UNI_VAL_NULL,
    0x9ad8,
    CP932_UNI_VAL_NULL,
    0x8d88,
    CP932_UNI_VAL_NULL,
    0x9ada,
    0x9adc,
    0x9adb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ade,
    CP932_UNI_VAL_NULL,
    0x9ad3,
    0x9ae0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9adf,
    0x9add,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8e6d,
    0x9070,
    CP932_UNI_VAL_NULL,
    0x9173,
    0x9ae1,
    0x90ba,
    0x88eb,
    0x9484,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x92d9,
    CP932_UNI_VAL_NULL,
    0x9ae3,
    0x9ae2,
    0x9ae4,
    0x9ae5,
    0x9ae6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x59[] = {
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ae7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x95cf,
    0x9ae8,
    0xfa9f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x89c4,
    0x9ae9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x975b,
    0x8a4f,
    CP932_UNI_VAL_NULL,
    0x99c7,
    0x8f67,
    0x91bd,
    0x9aea,
    0x96e9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x96b2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9aec,
    CP932_UNI_VAL_NULL,
    0x91e5,
    CP932_UNI_VAL_NULL,
    0x9356,
    0x91be,
    0x9576,
    0x9aed,
    0x9aee,
    0x899b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8eb8,
    0x9aef,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x88ce,
    0x9af0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9af1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8982,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8aef,
    0x93de,
    0x95f2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9af5,
    0x9174,
    0x9af4,
    0x8c5f,
    CP932_UNI_VAL_NULL,
    0xfaa0,
    0x967a,
    0x9af3,
    CP932_UNI_VAL_NULL,
    0x9385,
    0x9af7,
    CP932_UNI_VAL_NULL,
    0x9af6,
    0xfaa1,
    CP932_UNI_VAL_NULL,
    0xfaa2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9af9,
    CP932_UNI_VAL_NULL,
    0x9af8,
    0xfaa3,
    CP932_UNI_VAL_NULL,
    0x899c,
    CP932_UNI_VAL_NULL,
    0x9afa,
    0x8fa7,
    0x9afc,
    0x9244,
    CP932_UNI_VAL_NULL,
    0x9afb,
    CP932_UNI_VAL_NULL,
    0x95b1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8f97,
    0x937a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9b40,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8d44,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9b41,
    0x9440,
    0x94dc,
    0x96cf,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9444,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9b4a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8b57,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9764,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x96ad,
    CP932_UNI_VAL_NULL,
    0x9baa,
    CP932_UNI_VAL_NULL,
    0x9b42,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9b45,
    0xfaa4,
    0x91c3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9657,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9369,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9b46,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9685,
    0xfaa5,
    0x8dc8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8fa8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9b47,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8e6f,
    CP932_UNI_VAL_NULL,
    0x8e6e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x88b7,
    0x8cc6,
    CP932_UNI_VAL_NULL,
    0x90a9,
    0x88cf,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9b4b,
    0x9b4c,
    CP932_UNI_VAL_NULL,
    0x9b49,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8957,
    0x8aad,
    CP932_UNI_VAL_NULL,
    0x9b48,
    CP932_UNI_VAL_NULL,
    0x96c3,
    0x9550,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x88a6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x88f7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8e70
};
UINT16 cp932_UNI_a0x5a[] = {
    CP932_UNI_VAL_NULL,
    0x88d0,
    CP932_UNI_VAL_NULL,
    0x88a1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9b51,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9b4f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x96ba,
    CP932_UNI_VAL_NULL,
    0x9b52,
    CP932_UNI_VAL_NULL,
    0x9b50,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9b4e,
    0x9050,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9b4d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x95d8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ce2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9b56,
    0x9b57,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8fa9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9b53,
    0x984b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x946b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9b55,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8da5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9b58,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9577,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9b59,
    CP932_UNI_VAL_NULL,
    0x9b54,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x96b9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x947d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9b5a,
    0x9551,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9b5b,
    0x9b5f,
    0x9b5c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x89c5,
    0x9b5e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8eb9,
    CP932_UNI_VAL_NULL,
    0x9b5d,
    0x8c99,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9b6b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9b64,
    0x9b61,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9284,
    CP932_UNI_VAL_NULL,
    0x9b60,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9b62,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9b63,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9b65,
    0x9b66,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x5b[] = {
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8af0,
    CP932_UNI_VAL_NULL,
    0x9b68,
    0x9b67,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9b69,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8fec,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9b6c,
    CP932_UNI_VAL_NULL,
    0x92da,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8964,
    CP932_UNI_VAL_NULL,
    0x9b6a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9b6d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9b6e,
    CP932_UNI_VAL_NULL,
    0x9b71,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9b6f,
    CP932_UNI_VAL_NULL,
    0x9b70,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8e71,
    0x9b72,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8d45,
    0x9b73,
    0xfaa6,
    0x8e9a,
    0x91b6,
    CP932_UNI_VAL_NULL,
    0x9b74,
    0x9b75,
    0x8e79,
    0x8d46,
    CP932_UNI_VAL_NULL,
    0x96d0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8b47,
    0x8cc7,
    0x9b76,
    0x8a77,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9b77,
    CP932_UNI_VAL_NULL,
    0x91b7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9b78,
    0x9ba1,
    CP932_UNI_VAL_NULL,
    0x9b79,
    CP932_UNI_VAL_NULL,
    0x9b7a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9b7b,
    CP932_UNI_VAL_NULL,
    0x9b7d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9b7e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9b80,
    CP932_UNI_VAL_NULL,
    0x91ee,
    CP932_UNI_VAL_NULL,
    0x8946,
    0x8ee7,
    0x88c0,
    CP932_UNI_VAL_NULL,
    0x9176,
    0x8aae,
    0x8eb3,
    CP932_UNI_VAL_NULL,
    0x8d47,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9386,
    CP932_UNI_VAL_NULL,
    0x8f40,
    0x8aaf,
    0x9288,
    0x92e8,
    0x88b6,
    0x8b58,
    0x95f3,
    CP932_UNI_VAL_NULL,
    0x8ec0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8b71,
    0x90e9,
    0x8eba,
    0x9747,
    0x9b81,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8b7b,
    CP932_UNI_VAL_NULL,
    0x8dc9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8a51,
    0x8983,
    0x8faa,
    0x89c6,
    CP932_UNI_VAL_NULL,
    0x9b82,
    0x9765,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8f68,
    0xfaa7,
    CP932_UNI_VAL_NULL,
    0x8ee2,
    0x9b83,
    0x8af1,
    0x93d0,
    0x96a7,
    0x9b84,
    CP932_UNI_VAL_NULL,
    0x9b85,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9578,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9b87,
    CP932_UNI_VAL_NULL,
    0x8aa6,
    0x8bf5,
    0x9b86,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfaa9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ab0,
    CP932_UNI_VAL_NULL,
    0x9051,
    0x9b8b,
    0x8e40,
    CP932_UNI_VAL_NULL,
    0x89c7,
    0x9b8a,
    CP932_UNI_VAL_NULL,
    0x9b88,
    0x9b8c,
    0x9b89,
    0x944a,
    0x9ecb,
    0x9052,
    CP932_UNI_VAL_NULL,
    0x9b8d,
    0xfaaa,
    CP932_UNI_VAL_NULL,
    0x97be,
    CP932_UNI_VAL_NULL,
    0x9b8e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9b90,
    CP932_UNI_VAL_NULL,
    0x929e,
    0x9b8f,
    CP932_UNI_VAL_NULL,
    0x90a1,
    CP932_UNI_VAL_NULL,
    0x8e9b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x91ce,
    0x8ef5
};
UINT16 cp932_UNI_a0x5c[] = {
    CP932_UNI_VAL_NULL,
    0x9595,
    0x90ea,
    CP932_UNI_VAL_NULL,
    0x8ecb,
    0x9b91,
    0x8fab,
    0x9b92,
    0x9b93,
    0x88d1,
    0x91b8,
    0x9071,
    CP932_UNI_VAL_NULL,
    0x9b94,
    0x93b1,
    0x8fac,
    CP932_UNI_VAL_NULL,
    0x8fad,
    CP932_UNI_VAL_NULL,
    0x9b95,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x90eb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8fae,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfaab,
    CP932_UNI_VAL_NULL,
    0x9b96,
    CP932_UNI_VAL_NULL,
    0x9b97,
    CP932_UNI_VAL_NULL,
    0x96de,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9b98,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8bc4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8f41,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9b99,
    0x9b9a,
    0x8eda,
    0x904b,
    0x93f2,
    0x9073,
    0x94f6,
    0x9441,
    0x8bc7,
    0x9b9b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8b8f,
    0x9b9c,
    CP932_UNI_VAL_NULL,
    0x8bfc,
    CP932_UNI_VAL_NULL,
    0x93cd,
    0x89ae,
    CP932_UNI_VAL_NULL,
    0x8e72,
    0x9b9d,
    0x9ba0,
    0x9b9f,
    0x8bfb,
    CP932_UNI_VAL_NULL,
    0x9b9e,
    CP932_UNI_VAL_NULL,
    0x9357,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x91ae,
    CP932_UNI_VAL_NULL,
    0x936a,
    0x8ec6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9177,
    0x979a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ba2,
    CP932_UNI_VAL_NULL,
    0x9ba3,
    0x93d4,
    CP932_UNI_VAL_NULL,
    0x8e52,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ba5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ba6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ba7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8af2,
    0x9ba8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ba9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x89aa,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfaac,
    CP932_UNI_VAL_NULL,
    0x915a,
    0x8ae2,
    CP932_UNI_VAL_NULL,
    0x9bab,
    0x96a6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x91d0,
    CP932_UNI_VAL_NULL,
    0x8a78,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9bad,
    0x9baf,
    0x8add,
    CP932_UNI_VAL_NULL,
    0xfaad,
    0x9bac,
    0x9bae,
    CP932_UNI_VAL_NULL,
    0x9bb1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9bb0,
    CP932_UNI_VAL_NULL,
    0x9bb2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9bb3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x93bb,
    0x8bac,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x89e3,
    0x9bb4,
    0x9bb9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9bb7,
    CP932_UNI_VAL_NULL,
    0x95f5,
    0x95f4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfaae,
    0x9387,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9bb6,
    0x8f73,
    CP932_UNI_VAL_NULL,
    0x9bb5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x5d[] = {
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9092,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9bba,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8de8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9bc0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9bc1,
    0x9bbb,
    0x8a52,
    0x9bbc,
    0x9bc5,
    0x9bc4,
    0x9bc3,
    0x9bbf,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9bbe,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9bc2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfaaf,
    CP932_UNI_VAL_NULL,
    0x95f6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfab2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9bc9,
    0x9bc6,
    CP932_UNI_VAL_NULL,
    0x9bc8,
    CP932_UNI_VAL_NULL,
    0x9792,
    CP932_UNI_VAL_NULL,
    0x9bc7,
    0xfab0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9bbd,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9093,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9bca,
    0xfab3,
    CP932_UNI_VAL_NULL,
    0x8db5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9bcb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9bcc,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9bcf,
    CP932_UNI_VAL_NULL,
    0x9bce,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9bcd,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9388,
    0x9bb8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9bd5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9bd1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9bd0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9bd2,
    CP932_UNI_VAL_NULL,
    0x9bd3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9bd6,
    0xfab4,
    0xfab5,
    0x97e4,
    CP932_UNI_VAL_NULL,
    0x9bd7,
    0x9bd4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9bd8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ade,
    0x9bd9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfab6,
    CP932_UNI_VAL_NULL,
    0x9bdb,
    0x9bda,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9bdc,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9bdd,
    CP932_UNI_VAL_NULL,
    0x90ec,
    0x8f42,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8f84,
    CP932_UNI_VAL_NULL,
    0x9183,
    CP932_UNI_VAL_NULL,
    0x8d48,
    0x8db6,
    0x8d49,
    0x8b90,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9bde,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8db7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8cc8,
    0x9bdf,
    0x96a4,
    0x9462,
    0x9be0,
    CP932_UNI_VAL_NULL,
    0x8d4a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8aaa,
    CP932_UNI_VAL_NULL,
    0x9246,
    0x8bd0,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x5e[] = {
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8e73,
    0x957a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x94bf,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9be1,
    0x8af3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9be4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x929f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9be3,
    0x9be2,
    0x9be5,
    CP932_UNI_VAL_NULL,
    0x92e9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9083,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8e74,
    CP932_UNI_VAL_NULL,
    0x90c8,
    CP932_UNI_VAL_NULL,
    0x91d1,
    0x8b41,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x92a0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9be6,
    0x9be7,
    0x8fed,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9658,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9bea,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9be9,
    0x9be8,
    0x959d,
    CP932_UNI_VAL_NULL,
    0x9bf1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9679,
    CP932_UNI_VAL_NULL,
    0x9beb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9bed,
    0x968b,
    CP932_UNI_VAL_NULL,
    0x9bec,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9bee,
    CP932_UNI_VAL_NULL,
    0x94a6,
    0x9bef,
    0x95bc,
    0x9bf0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ab1,
    0x95bd,
    0x944e,
    0x9bf2,
    0x9bf3,
    CP932_UNI_VAL_NULL,
    0x8d4b,
    0x8ab2,
    0x9bf4,
    0x8cb6,
    0x9763,
    0x9748,
    0x8af4,
    0x9bf6,
    CP932_UNI_VAL_NULL,
    0x92a1,
    CP932_UNI_VAL_NULL,
    0x8d4c,
    0x8faf,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x94dd,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8fb0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8f98,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x92ea,
    0x95f7,
    0x9358,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8d4d,
    CP932_UNI_VAL_NULL,
    0x957b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9bf7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9378,
    0x8dc0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8cc9,
    CP932_UNI_VAL_NULL,
    0x92eb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x88c1,
    0x8f8e,
    0x8d4e,
    0x9766,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9bf8,
    0x9bf9,
    0x9470,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9bfa,
    0x97f5,
    0x984c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9bfc,
    0x9bfb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8a66,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9c40,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9c43,
    0x9c44,
    CP932_UNI_VAL_NULL,
    0x9c42,
    CP932_UNI_VAL_NULL,
    0x955f,
    0x8fb1,
    0x9c46,
    0x9c45,
    0x9c41,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9c47,
    0x9c48,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9c49,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9c4c,
    0x9c4a,
    CP932_UNI_VAL_NULL,
    0x9c4b,
    0x9c4d,
    CP932_UNI_VAL_NULL,
    0x8984,
    0x92ec,
    0x9c4e,
    CP932_UNI_VAL_NULL,
    0x8c9a,
    0x89f4,
    0x9455,
    CP932_UNI_VAL_NULL,
    0x9c4f,
    0x93f9
};
UINT16 cp932_UNI_a0x5f[] = {
    CP932_UNI_VAL_NULL,
    0x95d9,
    CP932_UNI_VAL_NULL,
    0x9c50,
    0x984d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9c51,
    0x95be,
    0x9c54,
    0x989f,
    0x98af,
    CP932_UNI_VAL_NULL,
    0x8eae,
    0x93f3,
    0x9c55,
    CP932_UNI_VAL_NULL,
    0x8b7c,
    0x92a2,
    0x88f8,
    0x9c56,
    0x95a4,
    0x8d4f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x926f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x92ed,
    CP932_UNI_VAL_NULL,
    0xfab7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x96ed,
    0x8cb7,
    0x8cca,
    CP932_UNI_VAL_NULL,
    0x9c57,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9c58,
    CP932_UNI_VAL_NULL,
    0x9c5e,
    CP932_UNI_VAL_NULL,
    0x8ee3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfab8,
    0x92a3,
    CP932_UNI_VAL_NULL,
    0x8bad,
    0x9c59,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x954a,
    CP932_UNI_VAL_NULL,
    0x9265,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9c5a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfa67,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9c5b,
    CP932_UNI_VAL_NULL,
    0x8bae,
    CP932_UNI_VAL_NULL,
    0x9c5c,
    CP932_UNI_VAL_NULL,
    0x9c5d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9c5f,
    CP932_UNI_VAL_NULL,
    0x9396,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9c60,
    0x9c61,
    CP932_UNI_VAL_NULL,
    0x9c62,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9c53,
    0x9c52,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9c63,
    0x8c60,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9546,
    0xfab9,
    CP932_UNI_VAL_NULL,
    0x8dca,
    0x9556,
    0x92a4,
    0x956a,
    0x9c64,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8fb2,
    0x8965,
    CP932_UNI_VAL_NULL,
    0x9c65,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9c66,
    CP932_UNI_VAL_NULL,
    0x96f0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x94de,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9c69,
    0x899d,
    0x90aa,
    0x9c68,
    0x9c67,
    0x8c61,
    0x91d2,
    CP932_UNI_VAL_NULL,
    0x9c6d,
    0x9c6b,
    CP932_UNI_VAL_NULL,
    0x9c6a,
    0x97a5,
    0x8ce3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8f99,
    0x9c6c,
    0x936b,
    0x8f5d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x93be,
    0x9c70,
    0x9c6f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9c6e,
    CP932_UNI_VAL_NULL,
    0x9c71,
    0x8ce4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9c72,
    0x959c,
    0x8f7a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9c73,
    0x94f7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x93bf,
    0x92a5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfaba,
    CP932_UNI_VAL_NULL,
    0x934f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9c74,
    0x8b4a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9053,
    CP932_UNI_VAL_NULL,
    0x954b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8af5,
    0x9445,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9c75,
    0x8e75,
    0x9659,
    0x965a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x899e,
    0x9c7a,
    0xfabb,
    CP932_UNI_VAL_NULL,
    0x9289,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9c77,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x89f5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9cab,
    0x9c79,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x944f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9c78,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9c76,
    CP932_UNI_VAL_NULL,
    0x8d9a,
    CP932_UNI_VAL_NULL,
    0x9c7c
};
UINT16 cp932_UNI_a0x60[] = {
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9c83,
    0x9c89,
    0x9c81,
    CP932_UNI_VAL_NULL,
    0x937b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9c86,
    0x957c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9c80,
    CP932_UNI_VAL_NULL,
    0x9c85,
    0x97e5,
    0x8e76,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x91d3,
    0x9c7d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8b7d,
    0x9c88,
    0x90ab,
    0x8985,
    0x9c82,
    0x89f6,
    0x9c87,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8baf,
    CP932_UNI_VAL_NULL,
    0x9c84,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9c8a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9c8c,
    0x9c96,
    0x9c94,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9c91,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9c90,
    0x97f6,
    CP932_UNI_VAL_NULL,
    0x9c92,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8bb0,
    CP932_UNI_VAL_NULL,
    0x8d50,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8f9a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9c99,
    0x9c8b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfabc,
    CP932_UNI_VAL_NULL,
    0x9c8f,
    0x9c7e,
    CP932_UNI_VAL_NULL,
    0x89f8,
    0x9c93,
    0x9c95,
    0x9270,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8da6,
    0x89b6,
    0x9c8d,
    0x9c98,
    0x9c97,
    0x8bb1,
    CP932_UNI_VAL_NULL,
    0x91a7,
    0x8a86,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8c62,
    CP932_UNI_VAL_NULL,
    0x9c8e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9c9a,
    CP932_UNI_VAL_NULL,
    0x9c9d,
    0x9c9f,
    0xfabd,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ebb,
    0xfabe,
    0x9ca5,
    0x92ee,
    0x9c9b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ca3,
    CP932_UNI_VAL_NULL,
    0x89f7,
    CP932_UNI_VAL_NULL,
    0x9ca1,
    0x9ca2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9c9e,
    0x9ca0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ce5,
    0x9749,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ab3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8978,
    0x9ca4,
    CP932_UNI_VAL_NULL,
    0x9459,
    0x88ab,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x94df,
    0x9c7b,
    0x9caa,
    0x9cae,
    0x96e3,
    CP932_UNI_VAL_NULL,
    0x9ca7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9389,
    0x9cac,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8fee,
    0x9cad,
    0x93d5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9866,
    CP932_UNI_VAL_NULL,
    0x9ca9,
    CP932_UNI_VAL_NULL,
    0xfac0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9caf,
    CP932_UNI_VAL_NULL,
    0x8d9b,
    CP932_UNI_VAL_NULL,
    0x90c9,
    CP932_UNI_VAL_NULL,
    0xfabf,
    0x88d2,
    0x9ca8,
    0x9ca6,
    CP932_UNI_VAL_NULL,
    0x9179,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9c9c,
    0x8e53,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x91c4,
    0x9cbb,
    0xfac2,
    0x917a,
    0x9cb6,
    CP932_UNI_VAL_NULL,
    0x9cb3,
    0x9cb4,
    CP932_UNI_VAL_NULL,
    0x8ee4,
    0x9cb7,
    0x9cba,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x61[] = {
    0x9cb5,
    0x8f44,
    CP932_UNI_VAL_NULL,
    0x9cb8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9cb2,
    CP932_UNI_VAL_NULL,
    0x96fa,
    0x96f9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9cbc,
    0x9cbd,
    0x88d3,
    CP932_UNI_VAL_NULL,
    0xfac3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9cb1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8bf0,
    0x88a4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ab4,
    0xfac1,
    0x9cb9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9cc1,
    0x9cc0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9cc5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfac5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9cc6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfac4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9cc4,
    0x9cc7,
    0x9cbf,
    0x9cc3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9cc8,
    CP932_UNI_VAL_NULL,
    0x9cc9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9cbe,
    0x8e9c,
    CP932_UNI_VAL_NULL,
    0x9cc2,
    0x91d4,
    0x8d51,
    0x9cb0,
    0x9054,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9cd6,
    CP932_UNI_VAL_NULL,
    0x95e7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ccc,
    0x9ccd,
    0x9cce,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9cd5,
    CP932_UNI_VAL_NULL,
    0x9cd4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x969d,
    0x8ab5,
    CP932_UNI_VAL_NULL,
    0x9cd2,
    CP932_UNI_VAL_NULL,
    0x8c64,
    0x8a53,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ccf,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x97b6,
    0x9cd1,
    0x88d4,
    0x9cd3,
    CP932_UNI_VAL_NULL,
    0x9cca,
    0x9cd0,
    0x9cd7,
    0x8c63,
    0x9ccb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x977c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x974a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9cda,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9cde,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x919e,
    CP932_UNI_VAL_NULL,
    0x97f7,
    0x9cdf,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9cdc,
    CP932_UNI_VAL_NULL,
    0x9cd9,
    CP932_UNI_VAL_NULL,
    0xfac6,
    0x9cd8,
    0x9cdd,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x95ae,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x93b2,
    CP932_UNI_VAL_NULL,
    0x8c65,
    CP932_UNI_VAL_NULL,
    0x9ce0,
    0x9cdb,
    CP932_UNI_VAL_NULL,
    0x9ce1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8c9b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x89af,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ce9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ab6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ce7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ce8,
    0x8da7,
    0x9ce6,
    0x9ce4,
    0x9ce3,
    0x9cea,
    0x9ce2,
    0x9cec,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x89f9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9cee,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ced,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x92a6,
    CP932_UNI_VAL_NULL,
    0x9cf1,
    CP932_UNI_VAL_NULL,
    0x9cef,
    0x9ce5,
    0x8c9c,
    CP932_UNI_VAL_NULL,
    0x9cf0,
    CP932_UNI_VAL_NULL,
    0x9cf4,
    0x9cf3,
    0x9cf5,
    0x9cf2
};
UINT16 cp932_UNI_a0x62[] = {
    0x9cf6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9cf7,
    0x9cf8,
    0x95e8,
    CP932_UNI_VAL_NULL,
    0x9cfa,
    0x9cf9,
    0x8f5e,
    CP932_UNI_VAL_NULL,
    0x90ac,
    0x89e4,
    0x89fa,
    0xfac7,
    0x9cfb,
    CP932_UNI_VAL_NULL,
    0x88bd,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x90ca,
    0x9cfc,
    CP932_UNI_VAL_NULL,
    0xe6c1,
    0x9d40,
    0x8c81,
    CP932_UNI_VAL_NULL,
    0x9d41,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x90ed,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9d42,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9d43,
    0x8b59,
    0x9d44,
    CP932_UNI_VAL_NULL,
    0x9d45,
    0x9d46,
    0x91d5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ccb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x96df,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x965b,
    0x8f8a,
    0x9d47,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x90ee,
    0xe7bb,
    0x94e0,
    CP932_UNI_VAL_NULL,
    0x8ee8,
    CP932_UNI_VAL_NULL,
    0x8dcb,
    0x9d48,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x91c5,
    CP932_UNI_VAL_NULL,
    0x95a5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x91ef,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9d4b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9d49,
    CP932_UNI_VAL_NULL,
    0x9d4c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9d4a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9d4d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x95af,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x88b5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x957d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x94e1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9d4e,
    CP932_UNI_VAL_NULL,
    0x9d51,
    0x8fb3,
    0x8b5a,
    CP932_UNI_VAL_NULL,
    0x9d4f,
    0x9d56,
    0x8fb4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9d50,
    0x9463,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x977d,
    0x9d52,
    0x9d53,
    0x9d57,
    0x938a,
    0x9d54,
    0x8d52,
    0x90dc,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9d65,
    0x94b2,
    CP932_UNI_VAL_NULL,
    0x91f0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfac8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x94e2,
    0x9dab,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x95f8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x92ef,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9695,
    CP932_UNI_VAL_NULL,
    0x9d5a,
    0x899f,
    0x928a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9d63,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9253,
    0x9d5d,
    0x9d64,
    0x9d5f,
    0x9d66,
    0x9d62,
    CP932_UNI_VAL_NULL,
    0x9d61,
    0x948f,
    CP932_UNI_VAL_NULL,
    0x9d5b,
    0x89fb,
    0x9d59,
    0x8b91,
    0x91f1,
    0x9d55,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9d58,
    0x8d53,
    0x90d9,
    CP932_UNI_VAL_NULL,
    0x8fb5,
    0x9d60,
    0x9471,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8b92,
    0x8a67,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8a87,
    0x9040,
    0x9d68,
    0x9d6d,
    CP932_UNI_VAL_NULL,
    0x9d69,
    CP932_UNI_VAL_NULL,
    0x8c9d,
    CP932_UNI_VAL_NULL,
    0x9d6e,
    0x8e41,
    0x8d89,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8f45,
    0x9d5c
};
UINT16 cp932_UNI_a0x63[] = {
    CP932_UNI_VAL_NULL,
    0x8e9d,
    0x9d6b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8e77,
    0x9d6c,
    0x88c2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9d67,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x92a7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8b93,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8bb2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9d6a,
    0x88a5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8dc1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9055,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x92f0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x94d2,
    0x9d70,
    0x917d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x91a8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8e4a,
    0x9d71,
    CP932_UNI_VAL_NULL,
    0x9d73,
    0x9d6f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x95df,
    CP932_UNI_VAL_NULL,
    0x92bb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x917b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x95f9,
    0x8ecc,
    0x9d80,
    CP932_UNI_VAL_NULL,
    0x9d7e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9098,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8c9e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9d78,
    0x8fb7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x93e6,
    0x9450,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9d76,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x917c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ef6,
    0x9d7b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8fb6,
    CP932_UNI_VAL_NULL,
    0x9d75,
    0x9d7a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9472,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9d74,
    CP932_UNI_VAL_NULL,
    0x8c40,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8a7c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9d7c,
    0x97a9,
    0x8dcc,
    0x9254,
    0x9d79,
    CP932_UNI_VAL_NULL,
    0x90da,
    CP932_UNI_VAL_NULL,
    0x8d54,
    0x9084,
    0x8986,
    0x915b,
    0x9d77,
    0x8b64,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8c66,
    CP932_UNI_VAL_NULL,
    0x92cd,
    0x9d7d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x917e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9d81,
    CP932_UNI_VAL_NULL,
    0x9d83,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x91b5,
    0x9d89,
    CP932_UNI_VAL_NULL,
    0x9d84,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9d86,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9560,
    0x92f1,
    CP932_UNI_VAL_NULL,
    0x9d87,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x974b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9767,
    0x8ab7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x88ac,
    CP932_UNI_VAL_NULL,
    0x9d85,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9d82,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8af6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8987,
    0xfac9,
    0x9d88,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9768,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x64[] = {
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9d8c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x91b9,
    CP932_UNI_VAL_NULL,
    0x9d93,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9d8d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9d8a,
    0x9d91,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9d72,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9d8e,
    CP932_UNI_VAL_NULL,
    0x9d92,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x94c0,
    0x938b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9d8b,
    CP932_UNI_VAL_NULL,
    0x9d8f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8c67,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8def,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x90db,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9d97,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9345,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfaca,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9d94,
    CP932_UNI_VAL_NULL,
    0x9680,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9d95,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9d96,
    CP932_UNI_VAL_NULL,
    0x96cc,
    CP932_UNI_VAL_NULL,
    0x90a0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8c82,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9d9d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8e54,
    0x9d9a,
    CP932_UNI_VAL_NULL,
    0x9d99,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9451,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfacb,
    0x93b3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9350,
    0x9d9b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9d9c,
    CP932_UNI_VAL_NULL,
    0x958f,
    CP932_UNI_VAL_NULL,
    0x9464,
    0x8e42,
    CP932_UNI_VAL_NULL,
    0x90ef,
    CP932_UNI_VAL_NULL,
    0x966f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8a68,
    CP932_UNI_VAL_NULL,
    0x9da3,
    0x9d9e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9769,
    0x9da5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9da1,
    CP932_UNI_VAL_NULL,
    0x9da2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9180,
    0xfacc,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9da0,
    CP932_UNI_VAL_NULL,
    0x9d5e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9da4,
    CP932_UNI_VAL_NULL,
    0x9d9f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9da9,
    0x9daa,
    0x9346,
    0x9dac,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8e43,
    0x9da7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8b5b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9dad,
    CP932_UNI_VAL_NULL,
    0x9da6,
    0x9db1,
    CP932_UNI_VAL_NULL,
    0x9db0,
    CP932_UNI_VAL_NULL,
    0x9daf,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9db2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9db4,
    0x8fef,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x65[] = {
    0x9db3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9db7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9db5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9db6,
    0x9d90,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9db9,
    0x9db8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9d98,
    0x9dba,
    0x9dae,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8e78,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9dbb,
    0x9dbc,
    0x9dbe,
    0x9dbd,
    0x9dbf,
    0x89fc,
    CP932_UNI_VAL_NULL,
    0x8d55,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x95fa,
    0x90ad,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ccc,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9dc1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9dc4,
    0xfacd,
    0x9571,
    CP932_UNI_VAL_NULL,
    0x8b7e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9dc3,
    0x9dc2,
    0x9473,
    0x9dc5,
    0x8bb3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9dc7,
    0x9dc6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ab8,
    0x8e55,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x93d6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8c68,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9094,
    CP932_UNI_VAL_NULL,
    0x9dc8,
    CP932_UNI_VAL_NULL,
    0x90ae,
    0x9347,
    CP932_UNI_VAL_NULL,
    0x957e,
    0x9dc9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9dca,
    0x9dcb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x95b6,
    0x9b7c,
    0x90c4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x956b,
    CP932_UNI_VAL_NULL,
    0x8dd6,
    CP932_UNI_VAL_NULL,
    0x94e3,
    0x94c1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x936c,
    CP932_UNI_VAL_NULL,
    0x97bf,
    CP932_UNI_VAL_NULL,
    0x9dcd,
    0x8ece,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9dce,
    CP932_UNI_VAL_NULL,
    0x88b4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8bd2,
    0x90cb,
    CP932_UNI_VAL_NULL,
    0x9580,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9dcf,
    0x8e61,
    0x9266,
    CP932_UNI_VAL_NULL,
    0x8e7a,
    0x9056,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9dd0,
    CP932_UNI_VAL_NULL,
    0x95fb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8997,
    0x8e7b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9dd3,
    CP932_UNI_VAL_NULL,
    0x9dd1,
    0x9dd4,
    0x97b7,
    0x9dd2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x90f9,
    0x9dd5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x91b0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9dd6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8af8,
    CP932_UNI_VAL_NULL,
    0x9dd8,
    CP932_UNI_VAL_NULL,
    0x9dd7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9dd9,
    0x9dda,
    0x8af9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x93fa,
    0x9255,
    0x8b8c,
    0x8e7c,
    0x9181,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8f7b,
    0x88ae,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ddb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x89a0,
    0x9ddf,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x66[] = {
    0xface,
    CP932_UNI_VAL_NULL,
    0x8d56,
    0x9dde,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8da9,
    0x8fb8,
    CP932_UNI_VAL_NULL,
    0xfad1,
    0x9ddd,
    CP932_UNI_VAL_NULL,
    0x8fb9,
    CP932_UNI_VAL_NULL,
    0x96be,
    0x8da8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x88d5,
    0x90cc,
    0xfacf,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9de4,
    CP932_UNI_VAL_NULL,
    0xfad3,
    0x90af,
    0x8966,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfad4,
    0x8f74,
    CP932_UNI_VAL_NULL,
    0x9686,
    0x8df0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8fba,
    0xfad2,
    0x90a5,
    CP932_UNI_VAL_NULL,
    0xfa63,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9de3,
    0x9de1,
    0x9de2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfad0,
    0x928b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9e45,
    CP932_UNI_VAL_NULL,
    0x9de8,
    0x8e9e,
    0x8d57,
    0x9de6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9de7,
    CP932_UNI_VAL_NULL,
    0x9057,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9de5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8e4e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfad6,
    CP932_UNI_VAL_NULL,
    0xfad7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9dea,
    0x9de9,
    0x9dee,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9def,
    CP932_UNI_VAL_NULL,
    0x9deb,
    0xfad5,
    0x8a41,
    0x9dec,
    0x9ded,
    0x94d3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9581,
    0x8c69,
    0x9df0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfad9,
    0x90b0,
    CP932_UNI_VAL_NULL,
    0x8fbb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9271,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8bc5,
    CP932_UNI_VAL_NULL,
    0x9df1,
    0x9df5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x89c9,
    0x9df2,
    0x9df4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9df3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8f8b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9267,
    0x88c3,
    0x9df6,
    0xfada,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9df7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfadb,
    CP932_UNI_VAL_NULL,
    0x92a8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x97ef,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8e62,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x95e9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfadc,
    CP932_UNI_VAL_NULL,
    0x965c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9e41,
    0x9df9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9dfc,
    CP932_UNI_VAL_NULL,
    0x9dfb,
    0xfadd,
    CP932_UNI_VAL_NULL,
    0x9df8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9e40,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x93dc,
    CP932_UNI_VAL_NULL,
    0x9dfa,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9e42,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8f8c,
    0x9e43,
    CP932_UNI_VAL_NULL,
    0x976a,
    0x9498,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9e44,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9e46,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9e47,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9e48,
    CP932_UNI_VAL_NULL,
    0x8bc8,
    0x8967,
    0x8d58,
    0x9e49,
    CP932_UNI_VAL_NULL,
    0x9e4a,
    0x8f91,
    0x9182,
    0xfade,
    0xfa66,
    0x99d6,
    0x915d,
    0x915c,
    0x91d6
};
UINT16 cp932_UNI_a0x67[] = {
    0x8dc5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x98f0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8c8e,
    0x974c,
    CP932_UNI_VAL_NULL,
    0x95fc,
    CP932_UNI_VAL_NULL,
    0x959e,
    0xfadf,
    0x9e4b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8df1,
    0x92bd,
    0x9e4c,
    0x984e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x965d,
    CP932_UNI_VAL_NULL,
    0x92a9,
    0x9e4d,
    0x8afa,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9e4e,
    0x9e4f,
    0x96d8,
    CP932_UNI_VAL_NULL,
    0x96a2,
    0x9696,
    0x967b,
    0x8e44,
    0x9e51,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ee9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9670,
    CP932_UNI_VAL_NULL,
    0x9e53,
    0x9e56,
    0x9e55,
    CP932_UNI_VAL_NULL,
    0x8af7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8b80,
    CP932_UNI_VAL_NULL,
    0x9e52,
    CP932_UNI_VAL_NULL,
    0x9e54,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9e57,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9099,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x979b,
    0x88c7,
    0x8dde,
    0x91ba,
    CP932_UNI_VAL_NULL,
    0x8edb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ff1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9e5a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x936d,
    CP932_UNI_VAL_NULL,
    0x9e58,
    0x91a9,
    0x9e59,
    0x8ff0,
    0x96db,
    0x9e5b,
    0x9e5c,
    0x9788,
    0xfae1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9e61,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8d59,
    CP932_UNI_VAL_NULL,
    0x9474,
    0x9e5e,
    0x938c,
    0x9ddc,
    0x9de0,
    CP932_UNI_VAL_NULL,
    0x8b6e,
    CP932_UNI_VAL_NULL,
    0x9466,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9e60,
    CP932_UNI_VAL_NULL,
    0x8fbc,
    0x94c2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9e66,
    CP932_UNI_VAL_NULL,
    0x94f8,
    CP932_UNI_VAL_NULL,
    0x9e5d,
    CP932_UNI_VAL_NULL,
    0x9e63,
    0x9e62,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x90cd,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x968d,
    CP932_UNI_VAL_NULL,
    0x97d1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9687,
    CP932_UNI_VAL_NULL,
    0x89ca,
    0x8e7d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9867,
    0x9e65,
    0x9095,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9e64,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9e5f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ccd,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9e6b,
    0x9e69,
    CP932_UNI_VAL_NULL,
    0x89cb,
    0x9e67,
    0x9e6d,
    0x9e73,
    CP932_UNI_VAL_NULL,
    0xfae2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfae4,
    0x91c6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x95bf,
    CP932_UNI_VAL_NULL,
    0x9e75,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9541,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9e74,
    0x9490,
    0x965e,
    0x8ab9,
    CP932_UNI_VAL_NULL,
    0x90f5,
    0x8f5f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x92d1,
    CP932_UNI_VAL_NULL,
    0x974d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9e70,
    0x9e6f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9e71,
    CP932_UNI_VAL_NULL,
    0x9e6e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9e76,
    CP932_UNI_VAL_NULL,
    0x9e6c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9e6a,
    CP932_UNI_VAL_NULL,
    0x9e72,
    0x9e68,
    CP932_UNI_VAL_NULL,
    0x928c,
    CP932_UNI_VAL_NULL,
    0x96f6,
    0x8ec4,
    0x8df2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8db8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x968f,
    0x8a60
};
UINT16 cp932_UNI_a0x68[] = {
    CP932_UNI_VAL_NULL,
    0xfae5,
    0x92cc,
    0x93c8,
    0x8968,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x90f0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x90b2,
    0x8c49,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9e78,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8d5a,
    0x8a9c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9e7a,
    0x8a94,
    0x9e81,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9e7d,
    CP932_UNI_VAL_NULL,
    0x90f1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8a6a,
    0x8daa,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8a69,
    0x8dcd,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9e7b,
    0x8c85,
    0x8c6a,
    0x938d,
    0xfae6,
    CP932_UNI_VAL_NULL,
    0x9e79,
    CP932_UNI_VAL_NULL,
    0x88c4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9e7c,
    0x9e7e,
    CP932_UNI_VAL_NULL,
    0x8bcb,
    0x8c4b,
    0xfae3,
    0x8aba,
    0x8b6a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9e82,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8df7,
    0x9691,
    CP932_UNI_VAL_NULL,
    0x8e56,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9e83,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x954f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9e8f,
    CP932_UNI_VAL_NULL,
    0x89b1,
    0x9e84,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9e95,
    0x9e85,
    CP932_UNI_VAL_NULL,
    0x97c0,
    CP932_UNI_VAL_NULL,
    0x9e8c,
    CP932_UNI_VAL_NULL,
    0x947e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9e94,
    CP932_UNI_VAL_NULL,
    0x9e87,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x88b2,
    0x9e89,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8d5b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9e8b,
    CP932_UNI_VAL_NULL,
    0x9e8a,
    CP932_UNI_VAL_NULL,
    0x9e86,
    0x9e91,
    CP932_UNI_VAL_NULL,
    0x8fbd,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9aeb,
    0x8ce6,
    0x979c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9e88,
    CP932_UNI_VAL_NULL,
    0x92f2,
    0x8a42,
    0x8dab,
    CP932_UNI_VAL_NULL,
    0x9e80,
    CP932_UNI_VAL_NULL,
    0x9e90,
    0x8a81,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9e8e,
    0x9e92,
    CP932_UNI_VAL_NULL,
    0x938e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8afc,
    CP932_UNI_VAL_NULL,
    0x9eb0,
    CP932_UNI_VAL_NULL,
    0xfa64,
    0x96c7,
    0x9e97,
    0x8afb,
    CP932_UNI_VAL_NULL,
    0x9e9e,
    CP932_UNI_VAL_NULL,
    0xfae7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x965f,
    CP932_UNI_VAL_NULL,
    0x9e9f,
    0x9ea1,
    CP932_UNI_VAL_NULL,
    0x9ea5,
    0x9e99,
    CP932_UNI_VAL_NULL,
    0x9249,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x938f,
    0x9ea9,
    0x9e9c,
    CP932_UNI_VAL_NULL,
    0x9ea6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ea0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9058,
    0x9eaa,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x90b1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ea8,
    0x8abb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x69[] = {
    0x986f,
    0x9e96,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ea4,
    0x88d6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9e98,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x96b8,
    0x9e9d,
    0x9041,
    0x92c5,
    0x9e93,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ea3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x909a,
    0x9ead,
    0x8a91,
    0x8c9f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9eaf,
    0x9e9a,
    0x9eae,
    CP932_UNI_VAL_NULL,
    0x9ea7,
    0x9e9b,
    CP932_UNI_VAL_NULL,
    0x9eab,
    CP932_UNI_VAL_NULL,
    0x9eac,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ebd,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x93cc,
    CP932_UNI_VAL_NULL,
    0x9ea2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9eb9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ebb,
    CP932_UNI_VAL_NULL,
    0x92d6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x976b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9596,
    0x9eb6,
    0x91c8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ebc,
    0x915e,
    CP932_UNI_VAL_NULL,
    0x9eb3,
    0x9ec0,
    0x9ebf,
    CP932_UNI_VAL_NULL,
    0x93ed,
    0x9ebe,
    0x93e8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfae9,
    CP932_UNI_VAL_NULL,
    0x9ec2,
    0x9eb5,
    CP932_UNI_VAL_NULL,
    0x8bc6,
    0x9eb8,
    0x8f7c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9480,
    0x9eba,
    0x8bc9,
    CP932_UNI_VAL_NULL,
    0x9eb2,
    0x9eb4,
    0x9eb1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x984f,
    0x8a79,
    0x9eb7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ec1,
    0x8a54,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8de5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x897c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ed2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9850,
    0x9ed5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfaeb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9059,
    0x9ed4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ed3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ed0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ec4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ee1,
    0x9ec3,
    CP932_UNI_VAL_NULL,
    0x9ed6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ece,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ec9,
    0x9ec6,
    CP932_UNI_VAL_NULL,
    0x9ec7,
    CP932_UNI_VAL_NULL,
    0x9ecf,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xeaa0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ecc,
    0x8d5c,
    0x92c6,
    0x9184,
    0x9eca,
    CP932_UNI_VAL_NULL,
    0x9ec5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ec8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x976c,
    0x968a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ecd,
    0x9ed7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfaec,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9edf,
    0x9ed8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ee5,
    CP932_UNI_VAL_NULL,
    0x9ee3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ede,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9edd,
    CP932_UNI_VAL_NULL,
    0x92ce,
    CP932_UNI_VAL_NULL,
    0x9185,
    CP932_UNI_VAL_NULL,
    0x9edb
};
UINT16 cp932_UNI_a0x6a[] = {
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ed9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ee0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ee6,
    0x94f3,
    0x9eec,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ee7,
    0x9eea,
    0x9ee4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9294,
    CP932_UNI_VAL_NULL,
    0x9557,
    CP932_UNI_VAL_NULL,
    0x9eda,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ee2,
    0x8fbe,
    CP932_UNI_VAL_NULL,
    0x96cd,
    0x9ef6,
    0x9ee9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ca0,
    0x89a1,
    0x8a7e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ed1,
    CP932_UNI_VAL_NULL,
    0xfaed,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8fbf,
    0x9eee,
    CP932_UNI_VAL_NULL,
    0x9ef5,
    0x8ef7,
    0x8a92,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x924d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9eeb,
    CP932_UNI_VAL_NULL,
    0xfaef,
    0x9ef0,
    0x9ef4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8bb4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8b6b,
    0x9ef2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8b40,
    CP932_UNI_VAL_NULL,
    0x93c9,
    0x9ef1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ef3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfaee,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9eed,
    0xfaf0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9eef,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfaf1,
    0x8a80,
    0x9268,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9efa,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ef8,
    0x8ce7,
    CP932_UNI_VAL_NULL,
    0x9ef7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9f40,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9e77,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ef9,
    CP932_UNI_VAL_NULL,
    0x9efb,
    0x9efc,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9f4b,
    CP932_UNI_VAL_NULL,
    0x9f47,
    CP932_UNI_VAL_NULL,
    0x9e8d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9f46,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9f45,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9f42,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ee8,
    0x9f44,
    0x9f43,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9f49,
    CP932_UNI_VAL_NULL,
    0x9845,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9f4c,
    0x8bf9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9f48,
    0x9f4a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfaf2,
    CP932_UNI_VAL_NULL,
    0xfaf3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x94a5,
    CP932_UNI_VAL_NULL,
    0x9f4d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9f51,
    0x9f4e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x6b[] = {
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9793,
    0x9f4f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9edc,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9f52,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9f53,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8954,
    CP932_UNI_VAL_NULL,
    0x9f55,
    0x8c87,
    0x8e9f,
    CP932_UNI_VAL_NULL,
    0x8bd3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x89a2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x977e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9f57,
    0x9f56,
    0x9f59,
    0x8b5c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8bd4,
    0x8abc,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9f5c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9f5b,
    CP932_UNI_VAL_NULL,
    0x9f5d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x89cc,
    CP932_UNI_VAL_NULL,
    0x9256,
    CP932_UNI_VAL_NULL,
    0x9f5e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8abd,
    0x9f60,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9f5f,
    CP932_UNI_VAL_NULL,
    0x9f61,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9f62,
    CP932_UNI_VAL_NULL,
    0x9f63,
    0x8e7e,
    0x90b3,
    0x8d9f,
    CP932_UNI_VAL_NULL,
    0x9590,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x95e0,
    0x9863,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8e95,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8dce,
    0x97f0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9f64,
    0x9f65,
    CP932_UNI_VAL_NULL,
    0x8e80,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9f66,
    0x9f67,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9f69,
    0x9f68,
    CP932_UNI_VAL_NULL,
    0x9677,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8f7d,
    0x8eea,
    0x8e63,
    CP932_UNI_VAL_NULL,
    0x9f6a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9f6c,
    0x9042,
    CP932_UNI_VAL_NULL,
    0x9f6b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9f6d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9f6e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9f6f,
    0x9f70,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9f71,
    CP932_UNI_VAL_NULL,
    0x9f73,
    0x9f72,
    0x9f74,
    0x89a3,
    0x9269,
    CP932_UNI_VAL_NULL,
    0x9f75,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8e45,
    0x8a6b,
    0x9f76,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9361,
    0x9aca,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8b42,
    0x9f77,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9f78,
    CP932_UNI_VAL_NULL,
    0x95ea,
    0x9688,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x93c5,
    0x9f79,
    0x94e4,
    CP932_UNI_VAL_NULL,
    0xfaf4,
    CP932_UNI_VAL_NULL,
    0x94f9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x96d1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9f7a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9f7c,
    0x9f7b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9f7e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9f7d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x6c[] = {
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9f81,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8e81,
    CP932_UNI_VAL_NULL,
    0x96af,
    CP932_UNI_VAL_NULL,
    0x9f82,
    0x9f83,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8b43,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9f84,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9f86,
    0x9f85,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9085,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9558,
    0x8969,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x94c3,
    0xfaf5,
    0x92f3,
    0x8f60,
    0x8b81,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x94c4,
    CP932_UNI_VAL_NULL,
    0x8eac,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9f88,
    CP932_UNI_VAL_NULL,
    0x8abe,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8998,
    CP932_UNI_VAL_NULL,
    0xfaf6,
    0x93f0,
    0x9f87,
    0x8d5d,
    0x9272,
    CP932_UNI_VAL_NULL,
    0x9f89,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9f91,
    CP932_UNI_VAL_NULL,
    0x9f8a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfaf8,
    0x91bf,
    CP932_UNI_VAL_NULL,
    0x8b82,
    0x9f92,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8c88,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8b44,
    0x9f90,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9f8e,
    0x9f8b,
    0x9780,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfaf7,
    CP932_UNI_VAL_NULL,
    0x92be,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x93d7,
    0x9f8c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9f94,
    CP932_UNI_VAL_NULL,
    0x9f93,
    0x8c42,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x89ab,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8db9,
    0x9f8d,
    0x9f8f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9676,
    0x91f2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9697,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9f9c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9f9d,
    CP932_UNI_VAL_NULL,
    0x89cd,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x95a6,
    0x96fb,
    0x9f9f,
    0x8ea1,
    0x8fc0,
    0x9f98,
    0x9f9e,
    0x8988,
    CP932_UNI_VAL_NULL,
    0x8bb5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9f95,
    0x9f9a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x90f2,
    0x9491,
    CP932_UNI_VAL_NULL,
    0x94e5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9f97,
    CP932_UNI_VAL_NULL,
    0x9640,
    CP932_UNI_VAL_NULL,
    0x9f99,
    CP932_UNI_VAL_NULL,
    0x9fa2,
    0xfaf9,
    0x9fa0,
    CP932_UNI_VAL_NULL,
    0x9f9b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9641,
    0x9467,
    0x8b83,
    CP932_UNI_VAL_NULL,
    0x9344,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x928d,
    CP932_UNI_VAL_NULL,
    0x9fa3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9fa1,
    0x91d7,
    0x9f96,
    CP932_UNI_VAL_NULL,
    0x896a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x6d[] = {
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfafa,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x976d,
    0x9fae,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9fad,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x90f4,
    CP932_UNI_VAL_NULL,
    0x9faa,
    CP932_UNI_VAL_NULL,
    0x978c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x93b4,
    0x9fa4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x92c3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x896b,
    0x8d5e,
    0x9fa7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8f46,
    0x9fac,
    CP932_UNI_VAL_NULL,
    0x9fab,
    0x9fa6,
    CP932_UNI_VAL_NULL,
    0x9fa9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8a88,
    CP932_UNI_VAL_NULL,
    0x9fa8,
    0x9468,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x97ac,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ff2,
    0x90f3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9fb4,
    0x9fb2,
    CP932_UNI_VAL_NULL,
    0x956c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9faf,
    0x9fb1,
    CP932_UNI_VAL_NULL,
    0x8959,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8d5f,
    0x9851,
    CP932_UNI_VAL_NULL,
    0x8a5c,
    CP932_UNI_VAL_NULL,
    0x9582,
    0xfafc,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9781,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8a43,
    0x905a,
    0x9fb3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9fb8,
    CP932_UNI_VAL_NULL,
    0xfafb,
    0x8fc1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x974f,
    CP932_UNI_VAL_NULL,
    0x9fb5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9fb0,
    CP932_UNI_VAL_NULL,
    0x9fb6,
    0xfb40,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x97dc,
    CP932_UNI_VAL_NULL,
    0x9393,
    0x93c0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfb41,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8a55,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8974,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9fbc,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9fbf,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x97c1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9784,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9fc6,
    0x9fc0,
    0x9fbd,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x97d2,
    0x9fc3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfb42,
    CP932_UNI_VAL_NULL,
    0x8f69,
    0x9fc5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9fca,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9391,
    0x9fc8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9fc2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9257,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9fc9,
    CP932_UNI_VAL_NULL,
    0x9fbe,
    CP932_UNI_VAL_NULL,
    0x9fc4,
    CP932_UNI_VAL_NULL,
    0x9fcb,
    0x88fa,
    0x9fc1,
    CP932_UNI_VAL_NULL,
    0x9fcc,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x905b,
    0xfb44,
    0x8f7e,
    CP932_UNI_VAL_NULL,
    0x95a3,
    CP932_UNI_VAL_NULL,
    0x8dac,
    0xfb43,
    0x9fb9,
    0x9fc7,
    0x9359,
    0xfb45,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x6e[] = {
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x90b4,
    CP932_UNI_VAL_NULL,
    0x8a89,
    0x8dcf,
    0x8fc2,
    0x9fbb,
    0x8f61,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8c6b,
    CP932_UNI_VAL_NULL,
    0x9fba,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9fd0,
    0x8f8d,
    0x8cb8,
    CP932_UNI_VAL_NULL,
    0x9fdf,
    CP932_UNI_VAL_NULL,
    0x9fd9,
    0x8b94,
    0x936e,
    CP932_UNI_VAL_NULL,
    0x9fd4,
    0x9fdd,
    0x88ad,
    0x8951,
    0xfb48,
    CP932_UNI_VAL_NULL,
    0x89b7,
    CP932_UNI_VAL_NULL,
    0x9fd6,
    0x91aa,
    0x9fcd,
    0x9fcf,
    0x8d60,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9fe0,
    0xfb46,
    0x9fdb,
    CP932_UNI_VAL_NULL,
    0xfb49,
    CP932_UNI_VAL_NULL,
    0x9fd3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9fda,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x96a9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9fd8,
    0x9fdc,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8cce,
    CP932_UNI_VAL_NULL,
    0x8fc3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9258,
    0xfb47,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9fd2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x974e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9fd5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9fce,
    0x9392,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9fd1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9fd7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9870,
    0x8ebc,
    0x969e,
    CP932_UNI_VAL_NULL,
    0x9fe1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x94ac,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9fed,
    0x8cb9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8f80,
    CP932_UNI_VAL_NULL,
    0x9fe3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x97ad,
    0x8d61,
    CP932_UNI_VAL_NULL,
    0x9ff0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x88ec,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9fee,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9fe2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9fe8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9fea,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x976e,
    0x9fe5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x934d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9fe7,
    CP932_UNI_VAL_NULL,
    0xfb4a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9fef,
    CP932_UNI_VAL_NULL,
    0x9fe9,
    0x96c5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9fe4,
    CP932_UNI_VAL_NULL,
    0x8ea0,
    0x9ffc,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8a8a,
    CP932_UNI_VAL_NULL,
    0x9fe6,
    0x9feb,
    0x9fec,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x91ea,
    0x91d8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ff4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ffa,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ff8,
    CP932_UNI_VAL_NULL,
    0x9348,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe042,
    0x9ff5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ff6,
    0x9fde
};
UINT16 cp932_UNI_a0x6f[] = {
    CP932_UNI_VAL_NULL,
    0x8b99,
    0x9559,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ebd,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8d97,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9852,
    CP932_UNI_VAL_NULL,
    0x9ff2,
    CP932_UNI_VAL_NULL,
    0xe041,
    0x8989,
    0x9186,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9499,
    CP932_UNI_VAL_NULL,
    0x8abf,
    0x97f8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x969f,
    0x92d0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ff9,
    0x9ffb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9151,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe040,
    0x9ff7,
    CP932_UNI_VAL_NULL,
    0x9ff1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ac1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8c89,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe04e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe049,
    0x90f6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8a83,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8f81,
    CP932_UNI_VAL_NULL,
    0xe052,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe04b,
    0x92aa,
    0xe048,
    0x92d7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe06b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe045,
    CP932_UNI_VAL_NULL,
    0xe044,
    CP932_UNI_VAL_NULL,
    0xe04d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe047,
    0xe046,
    0xe04c,
    CP932_UNI_VAL_NULL,
    0x909f,
    CP932_UNI_VAL_NULL,
    0xe043,
    CP932_UNI_VAL_NULL,
    0xfb4b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe04f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe050,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ac0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe055,
    CP932_UNI_VAL_NULL,
    0xe054,
    0xe056,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe059,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9362,
    CP932_UNI_VAL_NULL,
    0xe053,
    CP932_UNI_VAL_NULL,
    0xfb4c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe057,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8c83,
    0x91f7,
    0xe051,
    0x945a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe058,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe05d,
    0xe05b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe05e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe061,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe05a,
    0x8d8a,
    0x9447,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9fb7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9794,
    0xe05c,
    CP932_UNI_VAL_NULL,
    0xe060,
    0x91f3,
    CP932_UNI_VAL_NULL,
    0xe05f,
    CP932_UNI_VAL_NULL,
    0xe04a,
    CP932_UNI_VAL_NULL,
    0xfb4d,
    0xe889,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe064,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe068,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x70[] = {
    CP932_UNI_VAL_NULL,
    0xe066,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfb4e,
    CP932_UNI_VAL_NULL,
    0xfb4f,
    CP932_UNI_VAL_NULL,
    0xe062,
    CP932_UNI_VAL_NULL,
    0xe063,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe067,
    CP932_UNI_VAL_NULL,
    0xe065,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x956d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe06d,
    CP932_UNI_VAL_NULL,
    0xe06a,
    0xe069,
    CP932_UNI_VAL_NULL,
    0xe06c,
    0x93d2,
    0xe06e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9295,
    0x91eb,
    0xfb50,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x90a3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe06f,
    CP932_UNI_VAL_NULL,
    0xe071,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe070,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9ff3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe072,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x93e5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe073,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x89ce,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9394,
    0x8a44,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8b84,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8edc,
    0x8dd0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfb51,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9846,
    0x9086,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x898a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe075,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe074,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfb52,
    0xe078,
    0x9259,
    0xe07b,
    0xe076,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe07a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe079,
    0x935f,
    0x88d7,
    0xfa62,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x97f3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe07d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8947,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe080,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe07e,
    CP932_UNI_VAL_NULL,
    0xe07c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe077,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9642,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe082,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x71[] = {
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfb54,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe081,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfb53,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x898b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe084,
    0x95b0,
    CP932_UNI_VAL_NULL,
    0xe083,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x96b3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8fc5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9152,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8fc4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfb56,
    0xfb57,
    CP932_UNI_VAL_NULL,
    0x97f9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe08a,
    CP932_UNI_VAL_NULL,
    0x90f7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe086,
    0xe08b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x898c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfb55,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe089,
    CP932_UNI_VAL_NULL,
    0x9481,
    0xe085,
    0xe088,
    0x8fc6,
    CP932_UNI_VAL_NULL,
    0x94cf,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe08c,
    CP932_UNI_VAL_NULL,
    0x8ecf,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x90f8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe08f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe087,
    CP932_UNI_VAL_NULL,
    0x8c46,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe08d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x976f,
    0xe090,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xeaa4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8f6e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe091,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe092,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x944d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe094,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe095,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfb59,
    CP932_UNI_VAL_NULL,
    0x9452,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9395,
    0xe097,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe099,
    CP932_UNI_VAL_NULL,
    0x97d3,
    CP932_UNI_VAL_NULL,
    0xe096,
    CP932_UNI_VAL_NULL,
    0xe098,
    0x898d,
    CP932_UNI_VAL_NULL,
    0xe093,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9a7a,
    0xe09a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9187,
    0x8e57,
    0xe09c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe09b,
    0x9043,
    0x99d7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe09d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe09f,
    CP932_UNI_VAL_NULL,
    0xe08e,
    0xe09e,
    CP932_UNI_VAL_NULL,
    0xfb5a,
    0xe0a0
};
UINT16 cp932_UNI_a0x72[] = {
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x949a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe0a1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe0a2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe0a3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe0a4,
    CP932_UNI_VAL_NULL,
    0x92dc,
    CP932_UNI_VAL_NULL,
    0xe0a6,
    0xe0a5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe0a7,
    CP932_UNI_VAL_NULL,
    0xe0a8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8edd,
    0x9583,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x96ea,
    0xe0a9,
    0xe0aa,
    0x9175,
    0x8ea2,
    0xe0ab,
    0xe0ac,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe0ad,
    0x95d0,
    0x94c5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe0ae,
    0x9476,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x92ab,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe0af,
    0x89e5,
    CP932_UNI_VAL_NULL,
    0x8b8d,
    CP932_UNI_VAL_NULL,
    0x96c4,
    CP932_UNI_VAL_NULL,
    0x96b4,
    CP932_UNI_VAL_NULL,
    0x89b2,
    0x9853,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9671,
    CP932_UNI_VAL_NULL,
    0x95a8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x90b5,
    CP932_UNI_VAL_NULL,
    0xe0b0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x93c1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ca1,
    0xe0b1,
    CP932_UNI_VAL_NULL,
    0x8dd2,
    0xe0b3,
    0xe0b2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe0b4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe0b5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe0b6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8b5d,
    CP932_UNI_VAL_NULL,
    0xe0b7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe0b8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ca2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x94c6,
    CP932_UNI_VAL_NULL,
    0xfb5b,
    0xe0ba,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ff3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe0b9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfb5c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8bb6,
    0xe0bb,
    0xe0bd,
    CP932_UNI_VAL_NULL,
    0xe0bc,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe0be,
    CP932_UNI_VAL_NULL,
    0x8ccf,
    CP932_UNI_VAL_NULL,
    0xe0bf,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8be7,
    CP932_UNI_VAL_NULL,
    0x915f,
    CP932_UNI_VAL_NULL,
    0x8d9d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe0c1,
    0xe0c2,
    0xe0c0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8eeb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x93c6,
    0x8bb7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe0c4,
    0x924b,
    0xe0c3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9854,
    0x9482,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x73[] = {
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe0c7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe0c9,
    0xe0c6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x96d2,
    0xe0c8,
    0xe0ca,
    CP932_UNI_VAL_NULL,
    0x97c2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfb5d,
    0xe0ce,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe0cd,
    0x9296,
    0x944c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ca3,
    0xe0cc,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe0cb,
    CP932_UNI_VAL_NULL,
    0x9750,
    0x9751,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe0cf,
    0x898e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8d96,
    0x8e82,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe0d0,
    0xe0d1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe0d3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8f62,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe0d5,
    CP932_UNI_VAL_NULL,
    0xe0d4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe0d6,
    CP932_UNI_VAL_NULL,
    0x8a6c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe0d8,
    CP932_UNI_VAL_NULL,
    0xfb5f,
    0xe0d7,
    CP932_UNI_VAL_NULL,
    0xe0da,
    0xe0d9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8cba,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x97a6,
    CP932_UNI_VAL_NULL,
    0x8bca,
    CP932_UNI_VAL_NULL,
    0x89a4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8be8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8adf,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x97e6,
    0xe0dc,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe0de,
    CP932_UNI_VAL_NULL,
    0xfb60,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe0df,
    CP932_UNI_VAL_NULL,
    0x89cf,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe0db,
    0xfb61,
    0x8e58,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x92bf,
    0xe0dd,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfb64,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfb62,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe0e2,
    CP932_UNI_VAL_NULL,
    0x8eec,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfb63,
    CP932_UNI_VAL_NULL,
    0xe0e0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8c5d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x94c7,
    0xe0e1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe0fc,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfb66,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe0e7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8cbb,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x74[] = {
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8b85,
    CP932_UNI_VAL_NULL,
    0xe0e4,
    0x979d,
    0xfb65,
    CP932_UNI_VAL_NULL,
    0x97ae,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x91f4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe0e6,
    0xfb67,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfb69,
    0xfb68,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfb6a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe0e8,
    0x97d4,
    0x8bd5,
    0x94fa,
    0x9469,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe0e9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe0eb,
    CP932_UNI_VAL_NULL,
    0xe0ee,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe0ea,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe0ed,
    0x8ce8,
    0x896c,
    0xe0ef,
    CP932_UNI_VAL_NULL,
    0x9090,
    0xe0ec,
    0x97da,
    CP932_UNI_VAL_NULL,
    0xfb6b,
    0xe0f2,
    0xeaa2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe0f0,
    0xe0f3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe0e5,
    0xe0f1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8dba,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe0f4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe0f5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x979e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfb6c,
    CP932_UNI_VAL_NULL,
    0xe0f6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe0f7,
    0xfb6d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe0e3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe0f8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ac2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ea3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe0f9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe0fa,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe0fb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x895a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe140,
    CP932_UNI_VAL_NULL,
    0x955a,
    0xe141,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8aa2,
    0xe142,
    CP932_UNI_VAL_NULL,
    0xe143,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe144,
    CP932_UNI_VAL_NULL,
    0xe146,
    0xe147,
    0xe145,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9572,
    0xe149,
    0xe148,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x75[] = {
    CP932_UNI_VAL_NULL,
    0xfb6e,
    CP932_UNI_VAL_NULL,
    0xe14b,
    0xe14a,
    0xe14c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe14d,
    0xe14f,
    0xe14e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8d99,
    CP932_UNI_VAL_NULL,
    0xe151,
    CP932_UNI_VAL_NULL,
    0xe150,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ac3,
    CP932_UNI_VAL_NULL,
    0x9072,
    CP932_UNI_VAL_NULL,
    0x935b,
    CP932_UNI_VAL_NULL,
    0xe152,
    0x90b6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8e59,
    CP932_UNI_VAL_NULL,
    0x8999,
    0xe153,
    CP932_UNI_VAL_NULL,
    0x9770,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x95e1,
    0xe154,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfaa8,
    0x9363,
    0x9752,
    0x8d62,
    0x905c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x926a,
    0x99b2,
    CP932_UNI_VAL_NULL,
    0x92ac,
    0x89e6,
    0xe155,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe156,
    CP932_UNI_VAL_NULL,
    0xe15b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe159,
    0xe158,
    0x9dc0,
    0x8a45,
    0xe157,
    CP932_UNI_VAL_NULL,
    0x88d8,
    CP932_UNI_VAL_NULL,
    0x94a8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x94c8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x97af,
    0xe15c,
    0xe15a,
    0x927b,
    0x90a4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x94a9,
    CP932_UNI_VAL_NULL,
    0x954c,
    CP932_UNI_VAL_NULL,
    0xe15e,
    0x97aa,
    0x8c6c,
    0xe15f,
    CP932_UNI_VAL_NULL,
    0xe15d,
    0x94d4,
    0xe160,
    CP932_UNI_VAL_NULL,
    0xe161,
    CP932_UNI_VAL_NULL,
    0xfb6f,
    0x88d9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ff4,
    0xe166,
    CP932_UNI_VAL_NULL,
    0xe163,
    0x93eb,
    0xe162,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8b45,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe169,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe164,
    0xe165,
    CP932_UNI_VAL_NULL,
    0xe168,
    0xe167,
    0x9544,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9161,
    0x9160,
    CP932_UNI_VAL_NULL,
    0x8b5e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe16a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe16b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe16c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe16e,
    CP932_UNI_VAL_NULL,
    0xe16d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8975,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe176,
    0x94e6,
    0xe170,
    CP932_UNI_VAL_NULL,
    0xe172,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe174,
    0x905d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe175,
    0xe173,
    0x8ebe,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe16f,
    0xe171,
    CP932_UNI_VAL_NULL,
    0x9561,
    CP932_UNI_VAL_NULL,
    0x8fc7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe178,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe177,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe179,
    CP932_UNI_VAL_NULL,
    0x8ea4,
    0x8dad,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9397,
    0xe17a,
    CP932_UNI_VAL_NULL,
    0x92c9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe17c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x979f,
    0xe17b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9189,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe182,
    CP932_UNI_VAL_NULL,
    0xe184,
    0xe185,
    0x9273,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe183,
    CP932_UNI_VAL_NULL,
    0xe180,
    CP932_UNI_VAL_NULL,
    0xe17d,
    0xe17e
};
UINT16 cp932_UNI_a0x76[] = {
    CP932_UNI_VAL_NULL,
    0xe181,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe188,
    CP932_UNI_VAL_NULL,
    0xe186,
    CP932_UNI_VAL_NULL,
    0xe187,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe189,
    0xe18b,
    0xe18c,
    0xe18d,
    CP932_UNI_VAL_NULL,
    0xe18e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe18a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe190,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe18f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe191,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x97c3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe194,
    0xe192,
    0xe193,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ae0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x96fc,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x95c8,
    CP932_UNI_VAL_NULL,
    0xe196,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe195,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe197,
    0xe198,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe19c,
    0xe199,
    0xe19a,
    0xe19b,
    CP932_UNI_VAL_NULL,
    0xe19d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe19e,
    CP932_UNI_VAL_NULL,
    0xe19f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe1a0,
    CP932_UNI_VAL_NULL,
    0xe1a1,
    CP932_UNI_VAL_NULL,
    0x94ad,
    0x936f,
    0xe1a2,
    0x9492,
    0x9553,
    CP932_UNI_VAL_NULL,
    0xe1a3,
    CP932_UNI_VAL_NULL,
    0xfb70,
    0xe1a4,
    0x9349,
    CP932_UNI_VAL_NULL,
    0x8a46,
    0x8d63,
    0xe1a5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe1a6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe1a7,
    CP932_UNI_VAL_NULL,
    0x8e48,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe1a9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe1a8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe1aa,
    0xe1ab,
    0xfb73,
    0xfb71,
    CP932_UNI_VAL_NULL,
    0xfb72,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfb74,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x94e7,
    CP932_UNI_VAL_NULL,
    0xe1ac,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe1ad,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xea89,
    0xe1ae,
    0xe1af,
    0xe1b0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8e4d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe1b1,
    0x9475,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x967e,
    CP932_UNI_VAL_NULL,
    0x896d,
    CP932_UNI_VAL_NULL,
    0x8976,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe1b2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe1b4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe1b3,
    0x9390,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x90b7,
    0x9f58,
    CP932_UNI_VAL_NULL,
    0xe1b5,
    0x96bf,
    CP932_UNI_VAL_NULL,
    0xe1b6,
    CP932_UNI_VAL_NULL,
    0x8ac4,
    0x94d5,
    0xe1b7,
    CP932_UNI_VAL_NULL,
    0xe1b8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe1b9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x96da,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x96d3,
    CP932_UNI_VAL_NULL,
    0x92bc,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x918a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe1bb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8f82,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x77[] = {
    CP932_UNI_VAL_NULL,
    0x8fc8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe1be,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe1bd,
    0xe1bc,
    0x94fb,
    CP932_UNI_VAL_NULL,
    0x8ac5,
    0x8ca7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe1c4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe1c1,
    0x905e,
    0x96b0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe1c0,
    0xe1c2,
    0xe1c3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe1bf,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe1c5,
    0xe1c6,
    CP932_UNI_VAL_NULL,
    0x92ad,
    CP932_UNI_VAL_NULL,
    0x8ae1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9285,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfb76,
    0xe1c7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe1c8,
    0xe1cb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9087,
    CP932_UNI_VAL_NULL,
    0x93c2,
    CP932_UNI_VAL_NULL,
    0xe1cc,
    0x9672,
    CP932_UNI_VAL_NULL,
    0xe1c9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe1ca,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe1cf,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe1ce,
    0xe1cd,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe1d1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe1d0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe1d2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe1d4,
    CP932_UNI_VAL_NULL,
    0xe1d3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x95cb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8f75,
    0x97c4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe1d5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x93b5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe1d6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe1d7,
    CP932_UNI_VAL_NULL,
    0xe1db,
    0xe1d9,
    0xe1da,
    CP932_UNI_VAL_NULL,
    0xe1d8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe1dc,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe1dd,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe1de,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe1df,
    0x96b5,
    0xe1e0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x96ee,
    0xe1e1,
    CP932_UNI_VAL_NULL,
    0x926d,
    CP932_UNI_VAL_NULL,
    0x948a,
    CP932_UNI_VAL_NULL,
    0x8be9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x925a,
    0xe1e2,
    0x8bb8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x90ce,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe1e3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x78[] = {
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8dbb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe1e4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe1e5,
    CP932_UNI_VAL_NULL,
    0x8ca4,
    0x8dd3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe1e7,
    0xfb78,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9375,
    0x8dd4,
    0x8b6d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9643,
    CP932_UNI_VAL_NULL,
    0x946a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9376,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8d7b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe1e9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfb79,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8fc9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfb7a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x97b0,
    0x8d64,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ca5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x94a1,
    CP932_UNI_VAL_NULL,
    0xe1eb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfb7b,
    CP932_UNI_VAL_NULL,
    0xe1ed,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ce9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe1ec,
    0x92f4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe1ef,
    0x8a56,
    0xe1ea,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x94e8,
    CP932_UNI_VAL_NULL,
    0x894f,
    CP932_UNI_VAL_NULL,
    0x8dea,
    CP932_UNI_VAL_NULL,
    0x9871,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe1ee,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe1f0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x95c9,
    CP932_UNI_VAL_NULL,
    0x90d7,
    0xe1f2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe1f3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe1f1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8a6d,
    CP932_UNI_VAL_NULL,
    0xe1f9,
    CP932_UNI_VAL_NULL,
    0xe1f8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ea5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe1fa,
    0xe1f5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe1fb,
    0xe1f6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x94d6,
    0xe1f4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe1f7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe241,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe240,
    0x9681,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe1fc,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x88e9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe243,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe242,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x79[] = {
    CP932_UNI_VAL_NULL,
    0x8fca,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe244,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9162,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe246,
    0xe245,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe247,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe1e6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe1e8,
    0xe249,
    0xe248,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfb7c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ea6,
    CP932_UNI_VAL_NULL,
    0x97e7,
    CP932_UNI_VAL_NULL,
    0x8ed0,
    CP932_UNI_VAL_NULL,
    0xe24a,
    0x8c56,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8b5f,
    0x8b46,
    0x8e83,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9753,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe250,
    CP932_UNI_VAL_NULL,
    0xe24f,
    0x9163,
    0xe24c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe24e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8f6a,
    0x905f,
    0xe24d,
    0xe24b,
    CP932_UNI_VAL_NULL,
    0x9449,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8fcb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x955b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8dd5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9398,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe251,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe252,
    0xe268,
    0x8bd6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x985c,
    0x9154,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe253,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x89d0,
    0x92f5,
    0x959f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfb81,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfb83,
    CP932_UNI_VAL_NULL,
    0xe254,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8b9a,
    0xe255,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe257,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe258,
    CP932_UNI_VAL_NULL,
    0x9448,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe259,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe25a,
    0xe25b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8bd7,
    0x89d1,
    0x93c3,
    0x8f47,
    0x8e84,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe25c,
    CP932_UNI_VAL_NULL,
    0x8f48,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x89c8,
    0x9562,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe25d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x94e9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9164,
    CP932_UNI_VAL_NULL,
    0xe260,
    CP932_UNI_VAL_NULL,
    0xe261,
    0x9489,
    CP932_UNI_VAL_NULL,
    0x9060,
    0xe25e,
    CP932_UNI_VAL_NULL,
    0x9281,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe25f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8fcc,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x88da,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x7a[] = {
    0x8b48,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe262,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x92f6,
    CP932_UNI_VAL_NULL,
    0xe263,
    0x90c5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x96ab,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9542,
    0xe264,
    0xe265,
    0x9274,
    CP932_UNI_VAL_NULL,
    0x97c5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe267,
    0xe266,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8eed,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe269,
    0x88ee,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe26c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe26a,
    0x89d2,
    0x8c6d,
    0xe26b,
    0x8d65,
    0x8d92,
    CP932_UNI_VAL_NULL,
    0x95e4,
    0xe26d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9673,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe26f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x90cf,
    0x896e,
    0x89b8,
    0x88aa,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe26e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe270,
    0xe271,
    0x8ff5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe272,
    CP932_UNI_VAL_NULL,
    0x8a6e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe274,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8c8a,
    CP932_UNI_VAL_NULL,
    0x8b86,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe275,
    0x8bf3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe276,
    CP932_UNI_VAL_NULL,
    0x90fa,
    CP932_UNI_VAL_NULL,
    0x93cb,
    CP932_UNI_VAL_NULL,
    0x90de,
    0x8df3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe277,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9282,
    0x918b,
    CP932_UNI_VAL_NULL,
    0xe279,
    0xe27b,
    0xe278,
    0xe27a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8c41,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe27c,
    0x8c45,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8b87,
    0x9771,
    0xe27e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe280,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x894d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe283,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8a96,
    0xe282,
    0xe281,
    CP932_UNI_VAL_NULL,
    0xe285,
    0xe27d,
    CP932_UNI_VAL_NULL,
    0xe286,
    0x97a7,
    CP932_UNI_VAL_NULL,
    0xe287,
    CP932_UNI_VAL_NULL,
    0xe288,
    CP932_UNI_VAL_NULL,
    0xfb84,
    0x9af2,
    0xe28a,
    CP932_UNI_VAL_NULL,
    0xe289,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe28b,
    0xe28c,
    CP932_UNI_VAL_NULL,
    0x97b3,
    0xe28d,
    CP932_UNI_VAL_NULL,
    0xe8ed,
    0x8fcd,
    0xe28e,
    0xe28f,
    0x8f76,
    CP932_UNI_VAL_NULL,
    0x93b6,
    0xe290,
    0xfb85,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9247,
    0xfb87,
    CP932_UNI_VAL_NULL,
    0xe291,
    CP932_UNI_VAL_NULL,
    0x925b,
    0xe292,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ba3,
    CP932_UNI_VAL_NULL,
    0x995e,
    0x927c,
    0x8eb1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ac6
};
UINT16 cp932_UNI_a0x7b[] = {
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe293,
    CP932_UNI_VAL_NULL,
    0xe2a0,
    CP932_UNI_VAL_NULL,
    0xe296,
    CP932_UNI_VAL_NULL,
    0x8b88,
    CP932_UNI_VAL_NULL,
    0xe295,
    0xe2a2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe294,
    CP932_UNI_VAL_NULL,
    0x8fce,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe298,
    0xe299,
    CP932_UNI_VAL_NULL,
    0x934a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe29a,
    CP932_UNI_VAL_NULL,
    0x8a7d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9079,
    0x9584,
    CP932_UNI_VAL_NULL,
    0xe29c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x91e6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe297,
    CP932_UNI_VAL_NULL,
    0xe29b,
    0xe29d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8df9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe2a4,
    0x954d,
    CP932_UNI_VAL_NULL,
    0x94a4,
    0x9399,
    CP932_UNI_VAL_NULL,
    0x8bd8,
    0xe2a3,
    0xe2a1,
    CP932_UNI_VAL_NULL,
    0x94b3,
    0xe29e,
    0x927d,
    0x939b,
    CP932_UNI_VAL_NULL,
    0x939a,
    CP932_UNI_VAL_NULL,
    0x8df4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe2b6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe2a6,
    CP932_UNI_VAL_NULL,
    0xe2a8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe2ab,
    CP932_UNI_VAL_NULL,
    0xe2ac,
    CP932_UNI_VAL_NULL,
    0xe2a9,
    0xe2aa,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe2a7,
    0xe2a5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe29f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x95cd,
    0x89d3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe2b3,
    CP932_UNI_VAL_NULL,
    0xe2b0,
    CP932_UNI_VAL_NULL,
    0xe2b5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe2b4,
    CP932_UNI_VAL_NULL,
    0x9493,
    0x96a5,
    CP932_UNI_VAL_NULL,
    0x8e5a,
    0xe2ae,
    0xe2b7,
    0xe2b2,
    CP932_UNI_VAL_NULL,
    0xe2b1,
    0xe2ad,
    0xfb88,
    0xe2af,
    CP932_UNI_VAL_NULL,
    0x8ac7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x925c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x90fb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x94a0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe2bc,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x94a2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x90df,
    0xe2b9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x94cd,
    CP932_UNI_VAL_NULL,
    0xe2bd,
    0x95d1,
    CP932_UNI_VAL_NULL,
    0x927a,
    CP932_UNI_VAL_NULL,
    0xe2b8,
    0xe2ba,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe2bb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe2be,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ec2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x93c4,
    0xe2c3,
    0xe2c2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe2bf,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9855,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe2c8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe2cc,
    0xe2c9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x7c[] = {
    0xe2c5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe2c6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe2cb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe2c0,
    0x99d3,
    0xe2c7,
    0xe2c1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe2ca,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe2d0,
    CP932_UNI_VAL_NULL,
    0x8ac8,
    CP932_UNI_VAL_NULL,
    0xe2cd,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe2ce,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe2cf,
    0xe2d2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe2d1,
    0x94f4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe2d3,
    0x97fa,
    0x95eb,
    0xe2d8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe2d5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe2d4,
    0x90d0,
    CP932_UNI_VAL_NULL,
    0xe2d7,
    0xe2d9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe2d6,
    CP932_UNI_VAL_NULL,
    0xe2dd,
    CP932_UNI_VAL_NULL,
    0xe2da,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe2db,
    0xe2c4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe2dc,
    0xe2de,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe2df,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x95c4,
    CP932_UNI_VAL_NULL,
    0xe2e0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x96e0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8bcc,
    0x8c48,
    0xe2e1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x95b2,
    CP932_UNI_VAL_NULL,
    0x9088,
    CP932_UNI_VAL_NULL,
    0x96ae,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe2e2,
    CP932_UNI_VAL_NULL,
    0x97b1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9494,
    CP932_UNI_VAL_NULL,
    0x9165,
    0x9453,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8f6c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x88be,
    CP932_UNI_VAL_NULL,
    0xe2e7,
    0xe2e5,
    CP932_UNI_VAL_NULL,
    0xe2e3,
    0x8a9f,
    CP932_UNI_VAL_NULL,
    0x8fcf,
    0xe2e8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe2e6,
    CP932_UNI_VAL_NULL,
    0xe2e4,
    0xe2ec,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe2eb,
    0xe2ea,
    0xe2e9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe2ed,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe2ee,
    0x90b8,
    CP932_UNI_VAL_NULL,
    0xe2ef,
    CP932_UNI_VAL_NULL,
    0xe2f1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe2f0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8cd0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9157,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe2f3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x939c,
    CP932_UNI_VAL_NULL,
    0xe2f2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe2f4,
    CP932_UNI_VAL_NULL,
    0x95b3,
    0x918c,
    0x8d66,
    CP932_UNI_VAL_NULL,
    0xe2f5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x97c6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe2f7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe2f8,
    CP932_UNI_VAL_NULL,
    0xe2f9,
    CP932_UNI_VAL_NULL,
    0xe2fa,
    CP932_UNI_VAL_NULL,
    0x8e85,
    CP932_UNI_VAL_NULL,
    0xe2fb,
    0x8c6e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8b8a,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x7d[] = {
    0x8b49,
    CP932_UNI_VAL_NULL,
    0xe340,
    CP932_UNI_VAL_NULL,
    0x96f1,
    0x8d67,
    0xe2fc,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe343,
    0x96e4,
    CP932_UNI_VAL_NULL,
    0x945b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9552,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8f83,
    0xe342,
    CP932_UNI_VAL_NULL,
    0x8ed1,
    0x8d68,
    0x8e86,
    0x8b89,
    0x95b4,
    0xe341,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9166,
    0x9661,
    0x8df5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8e87,
    0x92db,
    CP932_UNI_VAL_NULL,
    0xe346,
    0x97dd,
    0x8dd7,
    CP932_UNI_VAL_NULL,
    0xe347,
    0x9061,
    CP932_UNI_VAL_NULL,
    0xe349,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8fd0,
    0x8dae,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe348,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8f49,
    0x8cbc,
    0x9167,
    0xe344,
    0xe34a,
    CP932_UNI_VAL_NULL,
    0xfb8a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe345,
    0x8c6f,
    CP932_UNI_VAL_NULL,
    0xe34d,
    0xe351,
    0x8c8b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe34c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe355,
    0xfb8b,
    CP932_UNI_VAL_NULL,
    0x8d69,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x978d,
    0x88ba,
    0xe352,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8b8b,
    CP932_UNI_VAL_NULL,
    0xe34f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe350,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x939d,
    0xe34e,
    0xe34b,
    CP932_UNI_VAL_NULL,
    0x8a47,
    0x90e2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ca6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe357,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe354,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe356,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe353,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8c70,
    0x91b1,
    0xe358,
    0x918e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe365,
    0xfb8d,
    CP932_UNI_VAL_NULL,
    0xe361,
    0xe35b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe35f,
    0x8ef8,
    0x88db,
    0xe35a,
    0xe362,
    0xe366,
    0x8d6a,
    0x96d4,
    CP932_UNI_VAL_NULL,
    0x92d4,
    0xe35c,
    CP932_UNI_VAL_NULL,
    0xfb8c,
    0xe364,
    CP932_UNI_VAL_NULL,
    0xe359,
    0x925d,
    CP932_UNI_VAL_NULL,
    0xe35e,
    0x88bb,
    0x96c8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe35d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8bd9,
    0x94ea,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x918d,
    CP932_UNI_VAL_NULL,
    0x97ce,
    0x8f8f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe38e,
    0xfb8e,
    CP932_UNI_VAL_NULL,
    0xe367,
    CP932_UNI_VAL_NULL,
    0x90fc,
    CP932_UNI_VAL_NULL,
    0xe363,
    0xe368,
    0xe36a,
    CP932_UNI_VAL_NULL,
    0x92f7,
    0xe36d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe369,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x95d2,
    0x8ac9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x96c9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x88dc,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe36c,
    CP932_UNI_VAL_NULL,
    0x97fb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe36b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x7e[] = {
    CP932_UNI_VAL_NULL,
    0x898f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x93ea,
    0xe36e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe375,
    0xe36f,
    0xe376,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe372,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x949b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ec8,
    0xe374,
    CP932_UNI_VAL_NULL,
    0xe371,
    0xe377,
    0xe370,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8f63,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9644,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8f6b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe373,
    0xe380,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe37b,
    CP932_UNI_VAL_NULL,
    0xe37e,
    CP932_UNI_VAL_NULL,
    0xe37c,
    0xe381,
    0xe37a,
    CP932_UNI_VAL_NULL,
    0xe360,
    0x90d1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x94c9,
    CP932_UNI_VAL_NULL,
    0xe37d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe378,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9140,
    0x8c71,
    CP932_UNI_VAL_NULL,
    0x8f4a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfb8f,
    CP932_UNI_VAL_NULL,
    0x9044,
    0x9155,
    0xe384,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe386,
    0xe387,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe383,
    0xe385,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe379,
    0xe382,
    CP932_UNI_VAL_NULL,
    0xe38a,
    0xe389,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x969a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8c4a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe388,
    CP932_UNI_VAL_NULL,
    0xe38c,
    0xe38b,
    0xe38f,
    CP932_UNI_VAL_NULL,
    0xe391,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8e5b,
    0xe38d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe392,
    0xe393,
    0xfa5c,
    CP932_UNI_VAL_NULL,
    0xe394,
    CP932_UNI_VAL_NULL,
    0xe39a,
    0x935a,
    0xe396,
    CP932_UNI_VAL_NULL,
    0xe395,
    0xe397,
    0xe398,
    CP932_UNI_VAL_NULL,
    0xe399,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe39b,
    0xe39c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x7f[] = {
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8aca,
    CP932_UNI_VAL_NULL,
    0xe39d,
    CP932_UNI_VAL_NULL,
    0xe39e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe39f,
    CP932_UNI_VAL_NULL,
    0xfb90,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe3a0,
    0xe3a1,
    0xe3a2,
    CP932_UNI_VAL_NULL,
    0xe3a3,
    0xe3a4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe3a6,
    0xe3a5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe3a7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe3a8,
    0xe3a9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe3ac,
    0xe3aa,
    0xe3ab,
    0x8ddf,
    0x8c72,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9275,
    CP932_UNI_VAL_NULL,
    0x94b1,
    CP932_UNI_VAL_NULL,
    0x8f90,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x946c,
    CP932_UNI_VAL_NULL,
    0x94eb,
    0xe3ad,
    0x9ceb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe3ae,
    0xe3b0,
    CP932_UNI_VAL_NULL,
    0x9785,
    0xe3af,
    0xe3b2,
    0xe3b1,
    CP932_UNI_VAL_NULL,
    0x9772,
    CP932_UNI_VAL_NULL,
    0xe3b3,
    CP932_UNI_VAL_NULL,
    0x94fc,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe3b4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe3b7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe3b6,
    0xe3b5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfb91,
    CP932_UNI_VAL_NULL,
    0xe3b8,
    0x8c51,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9141,
    0x8b60,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe3bc,
    0xe3b9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe3ba,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe3bd,
    CP932_UNI_VAL_NULL,
    0xe3be,
    0xe3bb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8948,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x89a5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe3c0,
    0xe3c1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe3c2,
    CP932_UNI_VAL_NULL,
    0x9782,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8f4b,
    CP932_UNI_VAL_NULL,
    0xe3c4,
    0xe3c3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9089,
    0xe3c5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe3c6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe3c7,
    CP932_UNI_VAL_NULL,
    0x8ae3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8acb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe3c8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe3c9,
    CP932_UNI_VAL_NULL,
    0x967c,
    0x9783,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x80[] = {
    0x9773,
    0x9856,
    CP932_UNI_VAL_NULL,
    0x8d6c,
    0xe3cc,
    0x8ed2,
    0xe3cb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe3cd,
    0x8ea7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x91cf,
    CP932_UNI_VAL_NULL,
    0xe3ce,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8d6b,
    CP932_UNI_VAL_NULL,
    0x96d5,
    0xe3cf,
    0xe3d0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe3d1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe3d2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe3d3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ea8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x96eb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe3d5,
    CP932_UNI_VAL_NULL,
    0x925e,
    CP932_UNI_VAL_NULL,
    0xe3d4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe3d7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe3d6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe3d8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x90b9,
    CP932_UNI_VAL_NULL,
    0xe3d9,
    CP932_UNI_VAL_NULL,
    0xe3da,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x95b7,
    0xe3db,
    CP932_UNI_VAL_NULL,
    0x918f,
    0xe3dc,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe3dd,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x97fc,
    0xe3e0,
    CP932_UNI_VAL_NULL,
    0xe3df,
    0xe3de,
    0x92ae,
    CP932_UNI_VAL_NULL,
    0xe3e1,
    0x9045,
    CP932_UNI_VAL_NULL,
    0xe3e2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe3e3,
    0x9857,
    0xe3e4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe3e5,
    0xe3e7,
    0xe3e6,
    0x94a3,
    CP932_UNI_VAL_NULL,
    0x93f7,
    CP932_UNI_VAL_NULL,
    0x985d,
    0x94a7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe3e9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8fd1,
    CP932_UNI_VAL_NULL,
    0x9549,
    CP932_UNI_VAL_NULL,
    0xe3ea,
    0xe3e8,
    CP932_UNI_VAL_NULL,
    0x8acc,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8cd2,
    0x8e88,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x94ec,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ca8,
    0x9662,
    CP932_UNI_VAL_NULL,
    0xe3ed,
    0xe3eb,
    CP932_UNI_VAL_NULL,
    0x8d6d,
    CP932_UNI_VAL_NULL,
    0x8d6e,
    0x88e7,
    CP932_UNI_VAL_NULL,
    0x8de6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9478,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x88dd,
    0xe3f2,
    CP932_UNI_VAL_NULL,
    0x925f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9477,
    CP932_UNI_VAL_NULL,
    0x91d9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe3f4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe3f0,
    0xe3f3,
    0xe3ee,
    CP932_UNI_VAL_NULL,
    0xe3f1,
    0x9645,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8cd3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x88fb,
    0xe3ef,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe3f6,
    CP932_UNI_VAL_NULL,
    0xe3f7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x93b7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8bb9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe445,
    0x945c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x81[] = {
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8e89,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8bba,
    0x90c6,
    0x9865,
    0x96ac,
    0xe3f5,
    0x90d2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8b72,
    0xe3f8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe3fa,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe3f9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe3fb,
    CP932_UNI_VAL_NULL,
    0x9245,
    CP932_UNI_VAL_NULL,
    0x945d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x92af,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe442,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe441,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe3fc,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9074,
    CP932_UNI_VAL_NULL,
    0x9585,
    0xe444,
    CP932_UNI_VAL_NULL,
    0xe443,
    0x8d6f,
    0x9872,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe454,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe448,
    0xe449,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8eee,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe447,
    CP932_UNI_VAL_NULL,
    0x8d98,
    0xe446,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe44a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x92b0,
    0x95a0,
    0x9142,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x91da,
    0xe44e,
    CP932_UNI_VAL_NULL,
    0xe44f,
    0xe44b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe44c,
    CP932_UNI_VAL_NULL,
    0xe44d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8d70,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe455,
    CP932_UNI_VAL_NULL,
    0xe451,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9586,
    CP932_UNI_VAL_NULL,
    0x968c,
    0x9547,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe450,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe453,
    0xe452,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9663,
    0xe456,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe457,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9156,
    CP932_UNI_VAL_NULL,
    0xe458,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe45a,
    CP932_UNI_VAL_NULL,
    0xe45e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe45b,
    0xe459,
    0x945e,
    0xe45c,
    CP932_UNI_VAL_NULL,
    0xe45d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x89b0,
    CP932_UNI_VAL_NULL,
    0xe464,
    0xe45f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe460,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe461,
    CP932_UNI_VAL_NULL,
    0x919f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe463,
    0xe462,
    0xe465,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe466,
    0xe467,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9062,
    CP932_UNI_VAL_NULL,
    0x89e7,
    CP932_UNI_VAL_NULL,
    0xe468,
    0x97d5,
    CP932_UNI_VAL_NULL,
    0x8ea9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8f4c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8e8a,
    0x9276,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe469,
    0xe46a,
    0x8950,
    CP932_UNI_VAL_NULL,
    0xe46b,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x82[] = {
    CP932_UNI_VAL_NULL,
    0xe46c,
    0xe46d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe46e,
    CP932_UNI_VAL_NULL,
    0xe46f,
    0x8bbb,
    0x9da8,
    0xe470,
    CP932_UNI_VAL_NULL,
    0x90e3,
    0xe471,
    0x8ec9,
    CP932_UNI_VAL_NULL,
    0xe472,
    CP932_UNI_VAL_NULL,
    0x98ae,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe473,
    0x95dc,
    0x8ada,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9143,
    0x8f77,
    CP932_UNI_VAL_NULL,
    0x9591,
    0x8f4d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe474,
    0x8d71,
    0xe475,
    0x94ca,
    CP932_UNI_VAL_NULL,
    0xe484,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe477,
    CP932_UNI_VAL_NULL,
    0x91c7,
    0x9495,
    0x8cbd,
    0xe476,
    0x9144,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe478,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x92f8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe47a,
    0xe479,
    0xe47c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe47b,
    CP932_UNI_VAL_NULL,
    0xe47d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe480,
    CP932_UNI_VAL_NULL,
    0xe47e,
    CP932_UNI_VAL_NULL,
    0x8acd,
    CP932_UNI_VAL_NULL,
    0xe481,
    CP932_UNI_VAL_NULL,
    0xe482,
    0xe483,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8daf,
    0x97c7,
    CP932_UNI_VAL_NULL,
    0xe485,
    0x9046,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8990,
    0xe486,
    0xe487,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe488,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x88f0,
    CP932_UNI_VAL_NULL,
    0xe489,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe48a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9587,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ec5,
    CP932_UNI_VAL_NULL,
    0xe48c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8a48,
    0x88b0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe48b,
    0xe48e,
    0x946d,
    CP932_UNI_VAL_NULL,
    0x9063,
    CP932_UNI_VAL_NULL,
    0x89d4,
    CP932_UNI_VAL_NULL,
    0x9646,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8c7c,
    0x8bda,
    CP932_UNI_VAL_NULL,
    0xe48d,
    CP932_UNI_VAL_NULL,
    0x89e8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8aa1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8991,
    0xe492,
    0x97e8,
    0x91db,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9563,
    CP932_UNI_VAL_NULL,
    0xe49e,
    CP932_UNI_VAL_NULL,
    0x89d5,
    0xe49c,
    CP932_UNI_VAL_NULL,
    0xe49a,
    0xe491,
    CP932_UNI_VAL_NULL,
    0xe48f,
    CP932_UNI_VAL_NULL,
    0xe490,
    CP932_UNI_VAL_NULL,
    0x8ee1,
    0x8bea,
    0x9297,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x93cf,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8970,
    CP932_UNI_VAL_NULL,
    0xe494,
    0xe493,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe499,
    0xe495,
    0xe498,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x83[] = {
    CP932_UNI_VAL_NULL,
    0xfb93,
    0x96ce,
    0xe497,
    0x89d6,
    0x8a9d,
    0xe49b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe49d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8c73,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe4a1,
    0xe4aa,
    0xe4ab,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x88a9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe4b2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x88ef,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe4a9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe4a8,
    CP932_UNI_VAL_NULL,
    0xe4a3,
    0xe4a2,
    CP932_UNI_VAL_NULL,
    0xe4a0,
    0xe49f,
    0x9283,
    CP932_UNI_VAL_NULL,
    0x91f9,
    0xe4a5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe4a4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe4a7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9190,
    0x8c74,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8960,
    0xe4a6,
    CP932_UNI_VAL_NULL,
    0x8d72,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9191,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfb94,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe4b8,
    CP932_UNI_VAL_NULL,
    0xe4b9,
    CP932_UNI_VAL_NULL,
    0x89d7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x89ac,
    0xe4b6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfb95,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe4ac,
    CP932_UNI_VAL_NULL,
    0xe4b4,
    CP932_UNI_VAL_NULL,
    0xe4bb,
    0xe4b5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe4b3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe496,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe4b1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe4ad,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ace,
    0xe4af,
    0xe4ba,
    CP932_UNI_VAL_NULL,
    0xe4b0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe4bc,
    CP932_UNI_VAL_NULL,
    0xe4ae,
    0x949c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9789,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe4b7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe4cd,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe4c5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x909b,
    CP932_UNI_VAL_NULL,
    0xfb96,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8b65,
    CP932_UNI_VAL_NULL,
    0x8bdb,
    CP932_UNI_VAL_NULL,
    0xe4c0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x89d9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8fd2,
    CP932_UNI_VAL_NULL,
    0xe4c3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8dd8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9370,
    0xe4c8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x95ec,
    CP932_UNI_VAL_NULL,
    0xe4bf,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x89d8,
    0x8cd4,
    0x9548,
    0xe4c9,
    CP932_UNI_VAL_NULL,
    0xe4bd,
    CP932_UNI_VAL_NULL,
    0xfb97,
    0xe4c6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe4d0,
    CP932_UNI_VAL_NULL,
    0xe4c1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x84[] = {
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe4c2,
    0x93b8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe4c7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe4c4,
    0x9647,
    0xe4ca,
    0x88de,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe4be,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe4cc,
    CP932_UNI_VAL_NULL,
    0xe4cb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x948b,
    0xe4d2,
    CP932_UNI_VAL_NULL,
    0xe4dd,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8a9e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe4e0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe4ce,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe4d3,
    0x978e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe4dc,
    CP932_UNI_VAL_NULL,
    0xfb98,
    0x9774,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x97a8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9298,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8a8b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9592,
    0xe4e2,
    0x939f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x88af,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe4db,
    CP932_UNI_VAL_NULL,
    0xe4d7,
    0x9192,
    0xe4d1,
    0xe4d9,
    0xe4de,
    CP932_UNI_VAL_NULL,
    0x944b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x88a8,
    CP932_UNI_VAL_NULL,
    0xe4d6,
    CP932_UNI_VAL_NULL,
    0xe4df,
    0x9598,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe4da,
    CP932_UNI_VAL_NULL,
    0xe4d5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8fd3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8f4e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8eaa,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x96d6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9566,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe4e5,
    CP932_UNI_VAL_NULL,
    0xe4ee,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe4d8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8a97,
    CP932_UNI_VAL_NULL,
    0xfb99,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ff6,
    0xe4e3,
    CP932_UNI_VAL_NULL,
    0xe4e8,
    0x9193,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe4e4,
    CP932_UNI_VAL_NULL,
    0xe4eb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x927e,
    CP932_UNI_VAL_NULL,
    0xe4ec,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9775,
    0xe4e1,
    0x8a57,
    CP932_UNI_VAL_NULL,
    0xe4e7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe4ea,
    0x96aa,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe4ed,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe4e6,
    0xe4e9,
    CP932_UNI_VAL_NULL,
    0xfa60,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9648,
    CP932_UNI_VAL_NULL,
    0x9840,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe4f1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe4f8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe4f0
};
UINT16 cp932_UNI_a0x85[] = {
    0x8ec1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe4cf,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x95cc,
    CP932_UNI_VAL_NULL,
    0x96a0,
    0xe4f7,
    0xe4f6,
    CP932_UNI_VAL_NULL,
    0xe4f2,
    0xe4f3,
    CP932_UNI_VAL_NULL,
    0x8955,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe4f5,
    CP932_UNI_VAL_NULL,
    0xe4ef,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x92d3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe4f4,
    0x88fc,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x91a0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x95c1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe4f9,
    0xe540,
    CP932_UNI_VAL_NULL,
    0x94d7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe4fc,
    0x8fd4,
    0x8ec7,
    0xe542,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8bbc,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfb9a,
    CP932_UNI_VAL_NULL,
    0xe543,
    CP932_UNI_VAL_NULL,
    0x9599,
    0xe4fb,
    0xfb9b,
    0xe4d4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe4fa,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x986e,
    0x93a0,
    0x9593,
    0xfb9c,
    CP932_UNI_VAL_NULL,
    0xe54a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe550,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe551,
    CP932_UNI_VAL_NULL,
    0xe544,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9496,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe54e,
    0xe546,
    CP932_UNI_VAL_NULL,
    0xe548,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe552,
    0xe547,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe54b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8992,
    CP932_UNI_VAL_NULL,
    0x93e3,
    CP932_UNI_VAL_NULL,
    0xe54c,
    0xe54f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe545,
    CP932_UNI_VAL_NULL,
    0x9145,
    CP932_UNI_VAL_NULL,
    0xe549,
    0x8e46,
    0x9064,
    0x8c4f,
    0x96f2,
    CP932_UNI_VAL_NULL,
    0x96f7,
    0x8f92,
    0xfb9e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe556,
    0xe554,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x986d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe553,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9795,
    CP932_UNI_VAL_NULL,
    0xe555,
    0xe557,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe558,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe55b,
    0xe559,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x93a1,
    0xe55a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x94cb,
    0xe54d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8f93,
    CP932_UNI_VAL_NULL,
    0xe55c,
    0xe561,
    0x9194,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe560,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x86[] = {
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe541,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe562,
    0x9168,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe55d,
    0xe55f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe55e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9f50,
    0x9f41,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe564,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe563,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9796,
    CP932_UNI_VAL_NULL,
    0xe1ba,
    0xe565,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe566,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe567,
    0x8cd5,
    CP932_UNI_VAL_NULL,
    0x8b73,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe569,
    0x997c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8b95,
    CP932_UNI_VAL_NULL,
    0x97b8,
    CP932_UNI_VAL_NULL,
    0x8bf1,
    0xe56a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe56b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x928e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe56c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x93f8,
    CP932_UNI_VAL_NULL,
    0x88b8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x89e1,
    0xe571,
    0xe572,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe56d,
    CP932_UNI_VAL_NULL,
    0x8e5c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe56e,
    0x9461,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe56f,
    0xe570,
    0xe57a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe574,
    0xe577,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe573,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe575,
    CP932_UNI_VAL_NULL,
    0xe576,
    0x8ed6,
    CP932_UNI_VAL_NULL,
    0xe578,
    CP932_UNI_VAL_NULL,
    0x9260,
    CP932_UNI_VAL_NULL,
    0x8c75,
    0x8a61,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe57b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8a5e,
    CP932_UNI_VAL_NULL,
    0xe581,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe57c,
    0xe580,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x94b8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe57d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe57e,
    0x9567,
    0x94d8,
    0xe582,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x91fb,
    0xe58c,
    CP932_UNI_VAL_NULL,
    0xe588,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x89e9,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x87[] = {
    0xe586,
    CP932_UNI_VAL_NULL,
    0x9649,
    0xe587,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe584,
    CP932_UNI_VAL_NULL,
    0xe585,
    0xe58a,
    0xe58d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe58b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe589,
    0xe583,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9277,
    CP932_UNI_VAL_NULL,
    0xe594,
    CP932_UNI_VAL_NULL,
    0x96a8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe592,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe593,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe58e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe590,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe591,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe58f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x90e4,
    CP932_UNI_VAL_NULL,
    0x9858,
    0xe598,
    CP932_UNI_VAL_NULL,
    0xe599,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe59f,
    CP932_UNI_VAL_NULL,
    0x9049,
    CP932_UNI_VAL_NULL,
    0xe59b,
    CP932_UNI_VAL_NULL,
    0xe59e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe596,
    0xe595,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe5a0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x89da,
    CP932_UNI_VAL_NULL,
    0xe59c,
    CP932_UNI_VAL_NULL,
    0xe5a1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe59d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe59a,
    CP932_UNI_VAL_NULL,
    0x92b1,
    CP932_UNI_VAL_NULL,
    0xe597,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9488,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe5a5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x975a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe5a4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe5a3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe5ac,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe5a6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe5ae,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9786,
    0xe5b1,
    CP932_UNI_VAL_NULL,
    0xe5a8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe5a9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe5ad,
    CP932_UNI_VAL_NULL,
    0xe5b0,
    0xe5af,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe5a7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe5aa,
    CP932_UNI_VAL_NULL,
    0xe5bb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe5b4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe5b2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe5b3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe5b8,
    0xe5b9,
    CP932_UNI_VAL_NULL,
    0x8a49,
    CP932_UNI_VAL_NULL,
    0x8b61,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe5b7,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x88[] = {
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe5a2,
    CP932_UNI_VAL_NULL,
    0xfba1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe5b6,
    0xe5ba,
    0xe5b5,
    CP932_UNI_VAL_NULL,
    0xe5bc,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe5be,
    0xe5bd,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe5c0,
    0xe5bf,
    0xe579,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe5c4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe5c1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe5c2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe5c3,
    CP932_UNI_VAL_NULL,
    0xe5c5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8c8c,
    CP932_UNI_VAL_NULL,
    0xe5c7,
    CP932_UNI_VAL_NULL,
    0xe5c6,
    CP932_UNI_VAL_NULL,
    0x8f4f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8d73,
    0x9fa5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe5c8,
    0x8f70,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8a58,
    CP932_UNI_VAL_NULL,
    0xe5c9,
    CP932_UNI_VAL_NULL,
    0x8971,
    CP932_UNI_VAL_NULL,
    0x8fd5,
    0xe5ca,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8d74,
    0xe5cb,
    0x88df,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x955c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe5cc,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x908a,
    CP932_UNI_VAL_NULL,
    0xe5d3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe5d0,
    CP932_UNI_VAL_NULL,
    0x928f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe5d1,
    0xe5ce,
    0x8bdc,
    CP932_UNI_VAL_NULL,
    0xe5cd,
    0xe5d4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8c55,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x91dc,
    CP932_UNI_VAL_NULL,
    0xe5da,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe5d6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x91b3,
    0xe5d5,
    CP932_UNI_VAL_NULL,
    0xe5d8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe5cf,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe5d9,
    CP932_UNI_VAL_NULL,
    0xe5db,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x94ed,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe5d7,
    CP932_UNI_VAL_NULL,
    0xe5dc,
    0xe5de,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8cd1,
    0xe5d2,
    CP932_UNI_VAL_NULL,
    0x88bf,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe5dd,
    CP932_UNI_VAL_NULL,
    0x8dd9,
    0x97f4,
    0xe5df,
    0xe5e0,
    0x9195,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x97a0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe5e1,
    0x9754,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe5e2,
    0xe5e3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x95e2,
    0xe5e4,
    CP932_UNI_VAL_NULL,
    0x8dbe,
    CP932_UNI_VAL_NULL,
    0x97a1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe5e9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe5ea,
    0x8fd6,
    0xe5e8,
    0xfba2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9787,
    0xe5e5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe5e7,
    0x90bb,
    0x909e,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x89[] = {
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe5e6,
    CP932_UNI_VAL_NULL,
    0xe5eb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x95a1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe5ed,
    CP932_UNI_VAL_NULL,
    0xe5ec,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8a8c,
    CP932_UNI_VAL_NULL,
    0x964a,
    0xe5ee,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfa5d,
    0xe5fa,
    0xe5f0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe5f1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe5f2,
    0xe5f3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe5f7,
    CP932_UNI_VAL_NULL,
    0xe5f8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe5f6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe5f4,
    CP932_UNI_VAL_NULL,
    0xe5ef,
    0xe5f5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe5f9,
    0xe8b5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x89a6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe5fc,
    0x8bdd,
    0xe5fb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe641,
    CP932_UNI_VAL_NULL,
    0xe640,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe643,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe642,
    CP932_UNI_VAL_NULL,
    0xe644,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8f50,
    CP932_UNI_VAL_NULL,
    0xe645,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe646,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe647,
    0x90bc,
    CP932_UNI_VAL_NULL,
    0x9776,
    CP932_UNI_VAL_NULL,
    0xe648,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x95a2,
    0x9465,
    0xe649,
    CP932_UNI_VAL_NULL,
    0xe64a,
    0x8ca9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8b4b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe64b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8e8b,
    0x9460,
    0xe64c,
    CP932_UNI_VAL_NULL,
    0x8a6f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe64d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe64f,
    0x9797,
    CP932_UNI_VAL_NULL,
    0xe64e,
    0x9065,
    CP932_UNI_VAL_NULL,
    0xe650,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe651,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe652,
    0x8acf,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe653,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe654,
    CP932_UNI_VAL_NULL,
    0xe655,
    0xe656,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8a70,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe657,
    CP932_UNI_VAL_NULL,
    0xe658,
    0xe659,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x89f0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9047,
    0xe65a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe65b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe65c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x8a[] = {
    0x8cbe,
    CP932_UNI_VAL_NULL,
    0x92f9,
    0xe65d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8c76,
    CP932_UNI_VAL_NULL,
    0x9075,
    CP932_UNI_VAL_NULL,
    0xe660,
    CP932_UNI_VAL_NULL,
    0x93a2,
    CP932_UNI_VAL_NULL,
    0xe65f,
    CP932_UNI_VAL_NULL,
    0xfba3,
    0x8c50,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe65e,
    0x91f5,
    0x8b4c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe661,
    CP932_UNI_VAL_NULL,
    0xe662,
    CP932_UNI_VAL_NULL,
    0x8fd7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8c8d,
    CP932_UNI_VAL_NULL,
    0xe663,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x964b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x90dd,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8b96,
    CP932_UNI_VAL_NULL,
    0x96f3,
    0x9169,
    CP932_UNI_VAL_NULL,
    0xe664,
    0xfba4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9066,
    0x9290,
    0x8fd8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe665,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe668,
    CP932_UNI_VAL_NULL,
    0xe669,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8dbc,
    0x91c0,
    0xe667,
    CP932_UNI_VAL_NULL,
    0x8fd9,
    0x955d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe666,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8e8c,
    CP932_UNI_VAL_NULL,
    0x8972,
    CP932_UNI_VAL_NULL,
    0xe66d,
    0x8c77,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8e8e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8e8d,
    CP932_UNI_VAL_NULL,
    0x986c,
    0xe66c,
    0xe66b,
    0x9146,
    CP932_UNI_VAL_NULL,
    0x8b6c,
    0x9862,
    0x8a59,
    0x8fda,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfba5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe66a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe66f,
    CP932_UNI_VAL_NULL,
    0xe670,
    0xe66e,
    CP932_UNI_VAL_NULL,
    0x8cd6,
    CP932_UNI_VAL_NULL,
    0x975f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8e8f,
    0x9446,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe673,
    CP932_UNI_VAL_NULL,
    0x90be,
    CP932_UNI_VAL_NULL,
    0x9261,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9755,
    CP932_UNI_VAL_NULL,
    0xe676,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8cea,
    CP932_UNI_VAL_NULL,
    0x90bd,
    0xe672,
    CP932_UNI_VAL_NULL,
    0xe677,
    0x8ceb,
    0xe674,
    0xe675,
    0xfba6,
    0xe671,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x90e0,
    0x93c7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x924e,
    CP932_UNI_VAL_NULL,
    0x89db,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x94ee,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8b62,
    CP932_UNI_VAL_NULL,
    0xfba7,
    0x92b2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe67a,
    CP932_UNI_VAL_NULL,
    0xe678,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x926b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x90bf,
    0x8ad0,
    0xe679,
    CP932_UNI_VAL_NULL,
    0x907a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x97c8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x985f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe67b,
    0xe687,
    0x92b3,
    CP932_UNI_VAL_NULL,
    0xe686,
    0xfba8,
    0xe683,
    0xe68b,
    0xe684,
    CP932_UNI_VAL_NULL,
    0xe680,
    CP932_UNI_VAL_NULL,
    0x92fa,
    0xe67e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe67c,
    CP932_UNI_VAL_NULL,
    0x9740,
    0x8e90,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe681,
    CP932_UNI_VAL_NULL,
    0xe67d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfbaa,
    0xe685,
    0x8f94,
    CP932_UNI_VAL_NULL,
    0x8cbf,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x91f8,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x8b[] = {
    0x9664,
    0x8979,
    0x88e0,
    CP932_UNI_VAL_NULL,
    0x93a3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe689,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe688,
    CP932_UNI_VAL_NULL,
    0x93e4,
    CP932_UNI_VAL_NULL,
    0xe68d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe682,
    CP932_UNI_VAL_NULL,
    0xe68c,
    0xe68e,
    CP932_UNI_VAL_NULL,
    0x8caa,
    0xe68a,
    0x8d75,
    CP932_UNI_VAL_NULL,
    0x8ed3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe68f,
    0x9777,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe692,
    CP932_UNI_VAL_NULL,
    0xe695,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe693,
    0x9554,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe690,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8bde,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe694,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe696,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe69a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe697,
    CP932_UNI_VAL_NULL,
    0xe699,
    0xe698,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfbab,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe69b,
    CP932_UNI_VAL_NULL,
    0x8eaf,
    CP932_UNI_VAL_NULL,
    0xe69d,
    0xe69c,
    0x9588,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe69f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8c78,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe69e,
    0xe6a0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe6a1,
    0x8b63,
    0xe3bf,
    0x8ff7,
    CP932_UNI_VAL_NULL,
    0xe6a2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8cec,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe6a3,
    CP932_UNI_VAL_NULL,
    0xfbac,
    0xe6a4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8e5d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9dcc,
    CP932_UNI_VAL_NULL,
    0xe6a5,
    CP932_UNI_VAL_NULL,
    0xe6a6,
    CP932_UNI_VAL_NULL,
    0x8f51,
    CP932_UNI_VAL_NULL,
    0xe6a7,
    0xe6a8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe6a9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe6aa,
    0xe6ab,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x8c[] = {
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x924a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe6ac,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe6ae,
    CP932_UNI_VAL_NULL,
    0xe6ad,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x93a4,
    CP932_UNI_VAL_NULL,
    0xe6af,
    CP932_UNI_VAL_NULL,
    0x964c,
    CP932_UNI_VAL_NULL,
    0xe6b0,
    CP932_UNI_VAL_NULL,
    0xe6b1,
    CP932_UNI_VAL_NULL,
    0xe6b2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe6b3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x93d8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8fdb,
    0xe6b4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8d8b,
    0x98ac,
    0xe6b5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe6b6,
    0x955e,
    0xe6b7,
    CP932_UNI_VAL_NULL,
    0xe6bf,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe6b8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe6ba,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe6b9,
    0xe6bb,
    CP932_UNI_VAL_NULL,
    0x9665,
    0xe6bc,
    0xe6bd,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe6be,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe6c0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8a4c,
    0x92e5,
    CP932_UNI_VAL_NULL,
    0x9589,
    0x8de0,
    0x8d76,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x956e,
    0x89dd,
    0x94cc,
    0xe6c3,
    0x8ad1,
    0x90d3,
    0xe6c2,
    0xe6c7,
    0x9299,
    0x96e1,
    CP932_UNI_VAL_NULL,
    0xe6c5,
    0xe6c6,
    0x8b4d,
    CP932_UNI_VAL_NULL,
    0xe6c8,
    0x9483,
    0x91dd,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x94ef,
    0x935c,
    0xe6c4,
    CP932_UNI_VAL_NULL,
    0x9666,
    0x89ea,
    0xe6ca,
    0x9847,
    0x92c0,
    0x9864,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8e91,
    0xe6c9,
    CP932_UNI_VAL_NULL,
    0x91af,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe6da,
    0x9147,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x93f6,
    CP932_UNI_VAL_NULL,
    0x956f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe6cd,
    0x8e5e,
    0x8e92,
    CP932_UNI_VAL_NULL,
    0x8fdc,
    CP932_UNI_VAL_NULL,
    0x9485,
    CP932_UNI_VAL_NULL,
    0x8cab,
    0xe6cc,
    0xe6cb,
    CP932_UNI_VAL_NULL,
    0x958a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ebf,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9371,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfbad,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfbae,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe6cf,
    0xe6d0,
    0x8d77,
    0xe6ce,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x8d[] = {
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe6d1,
    0xe6d2,
    CP932_UNI_VAL_NULL,
    0xe6d4,
    0x91a1,
    CP932_UNI_VAL_NULL,
    0xe6d3,
    0x8ae4,
    CP932_UNI_VAL_NULL,
    0xe6d6,
    CP932_UNI_VAL_NULL,
    0xe6d5,
    0xe6d7,
    CP932_UNI_VAL_NULL,
    0xfbaf,
    0xe6d9,
    0xe6db,
    CP932_UNI_VAL_NULL,
    0xe6dc,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x90d4,
    CP932_UNI_VAL_NULL,
    0x8ecd,
    0xe6dd,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8a71,
    CP932_UNI_VAL_NULL,
    0xe6de,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9196,
    0xe6df,
    CP932_UNI_VAL_NULL,
    0xe6e0,
    0x958b,
    CP932_UNI_VAL_NULL,
    0xfbb0,
    0x8b4e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe6e1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x92b4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x897a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe6e2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8eef,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9096,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x91ab,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe6e5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe6e4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe6e3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe6eb,
    0xe6e9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe6e6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe6e8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe6e7,
    0xe6ea,
    CP932_UNI_VAL_NULL,
    0x8b97,
    CP932_UNI_VAL_NULL,
    0xe6ee,
    CP932_UNI_VAL_NULL,
    0x90d5,
    CP932_UNI_VAL_NULL,
    0xe6ef,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8cd7,
    CP932_UNI_VAL_NULL,
    0xe6ec,
    0xe6ed,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9848,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x92b5,
    CP932_UNI_VAL_NULL,
    0x9148,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe6f0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe6f3
};
UINT16 cp932_UNI_a0x8e[] = {
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe6f1,
    0xe6f2,
    0x9778,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x93a5,
    0xe6f6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe6f4,
    0xe6f5,
    0xe6f7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe748,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe6fa,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe6fb,
    0xe6f9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe6f8,
    CP932_UNI_VAL_NULL,
    0x92fb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe740,
    0xe744,
    0xe741,
    0xe6fc,
    CP932_UNI_VAL_NULL,
    0xe742,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe743,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe74a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe745,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x90d6,
    0xe747,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe749,
    0xe746,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe74c,
    CP932_UNI_VAL_NULL,
    0x8f52,
    CP932_UNI_VAL_NULL,
    0xe74b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe74d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe74e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe751,
    0xe750,
    CP932_UNI_VAL_NULL,
    0xe74f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe753,
    0xe752,
    CP932_UNI_VAL_NULL,
    0x96f4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe755,
    CP932_UNI_VAL_NULL,
    0xe754,
    0xe756,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe757,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe759,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe758,
    0x9067,
    0xe75a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8beb,
    0xe75b,
    0xe75d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe75e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe75f,
    0xe75c,
    CP932_UNI_VAL_NULL,
    0xe760,
    CP932_UNI_VAL_NULL,
    0x8ed4,
    0xe761,
    0x8b4f,
    0x8c52,
    CP932_UNI_VAL_NULL,
    0xfbb2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8cac,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe762,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x93ee,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x935d,
    0xe763,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe766,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8eb2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe765,
    0xe764,
    0x8c79,
    0xe767,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x8f[] = {
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8a72,
    CP932_UNI_VAL_NULL,
    0xe769,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8dda,
    0xe768,
    CP932_UNI_VAL_NULL,
    0xe771,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe76b,
    0xe76d,
    0x95e3,
    0xe76a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe76c,
    CP932_UNI_VAL_NULL,
    0xe770,
    0xe76e,
    0x8b50,
    CP932_UNI_VAL_NULL,
    0xe76f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe772,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9479,
    0x97d6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8f53,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe773,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9741,
    0xe775,
    CP932_UNI_VAL_NULL,
    0xe774,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe778,
    0x9760,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe777,
    CP932_UNI_VAL_NULL,
    0x8a8d,
    0xe776,
    0xe77b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe77a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe779,
    0x9351,
    0xe77c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe77d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe77e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8d8c,
    CP932_UNI_VAL_NULL,
    0x8c44,
    0xe780,
    0xe781,
    0xe782,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9068,
    0xe783,
    CP932_UNI_VAL_NULL,
    0x8eab,
    0xe784,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe785,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x999f,
    0x999e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe786,
    0xe390,
    0xe787,
    0x9243,
    0x904a,
    0x945f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe788,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x95d3,
    0x92d2,
    0x8d9e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9248,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8949,
    CP932_UNI_VAL_NULL,
    0x9698,
    0x9076,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8c7d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8bdf,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x95d4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe789,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe78b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe78a,
    0x89de,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x93f4,
    0xe78c,
    0x9497,
    CP932_UNI_VAL_NULL,
    0x9352,
    CP932_UNI_VAL_NULL,
    0xe78d,
    0x8f71,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe78f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x96c0,
    0xe79e,
    0xe791,
    0xe792,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x92c7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x90[] = {
    0x91de,
    0x9197,
    CP932_UNI_VAL_NULL,
    0x93a6,
    CP932_UNI_VAL_NULL,
    0xe790,
    0x8b74,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe799,
    CP932_UNI_VAL_NULL,
    0xe796,
    0xe7a3,
    0x93a7,
    0x9280,
    0xe793,
    CP932_UNI_VAL_NULL,
    0x92fc,
    0x9372,
    0xe794,
    0xe798,
    0x9080,
    CP932_UNI_VAL_NULL,
    0x9487,
    0x92ca,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x90c0,
    0xe797,
    0x91ac,
    0x91a2,
    0xe795,
    0x88a7,
    0x9841,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe79a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x91df,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8f54,
    0x9069,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe79c,
    0xe79b,
    CP932_UNI_VAL_NULL,
    0x88ed,
    0xe79d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x954e,
    CP932_UNI_VAL_NULL,
    0xe7a5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x93d9,
    0x908b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9278,
    CP932_UNI_VAL_NULL,
    0x8bf6,
    CP932_UNI_VAL_NULL,
    0xe7a4,
    0x9756,
    0x895e,
    CP932_UNI_VAL_NULL,
    0x95d5,
    0x89df,
    0xe79f,
    0xe7a0,
    0xe7a1,
    0xe7a2,
    0x93b9,
    0x9242,
    0x88e1,
    0xe7a6,
    CP932_UNI_VAL_NULL,
    0xe7a7,
    0xeaa1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x91bb,
    CP932_UNI_VAL_NULL,
    0xe7a8,
    CP932_UNI_VAL_NULL,
    0x8993,
    0x916b,
    CP932_UNI_VAL_NULL,
    0x8cad,
    CP932_UNI_VAL_NULL,
    0x9779,
    CP932_UNI_VAL_NULL,
    0xfbb5,
    0xe7a9,
    0x934b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9198,
    0x8ed5,
    0xe7aa,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe7ad,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8f85,
    0xe7ab,
    0x914a,
    0x9149,
    CP932_UNI_VAL_NULL,
    0x88e2,
    CP932_UNI_VAL_NULL,
    0x97c9,
    0xe7af,
    CP932_UNI_VAL_NULL,
    0x94f0,
    0xe7b1,
    0xe7b0,
    0xe7ae,
    0xe284,
    0x8ad2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe78e,
    CP932_UNI_VAL_NULL,
    0xe7b3,
    0xe7b2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe7b4,
    CP932_UNI_VAL_NULL,
    0x9757,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x93df,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x964d,
    CP932_UNI_VAL_NULL,
    0xe7b5,
    CP932_UNI_VAL_NULL,
    0x8ed7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe7b6,
    CP932_UNI_VAL_NULL,
    0xe7b7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe7b8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9340,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x88e8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8d78,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9859,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe7bc,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfbb6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8c53,
    0xe7b9,
    CP932_UNI_VAL_NULL,
    0xe7ba,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9594,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8a73,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9758,
    CP932_UNI_VAL_NULL,
    0x8bbd,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9373,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x91[] = {
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe7bd,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe7be,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfbb8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe7bf,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfbb9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9341,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe7c1,
    CP932_UNI_VAL_NULL,
    0xe7c0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x93d1,
    0xe7c2,
    0x8f55,
    0x8ede,
    0x947a,
    0x9291,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ef0,
    CP932_UNI_VAL_NULL,
    0x908c,
    CP932_UNI_VAL_NULL,
    0xe7c3,
    CP932_UNI_VAL_NULL,
    0xe7c4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x907c,
    0xe7c5,
    CP932_UNI_VAL_NULL,
    0xe7c6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe7c7,
    0x978f,
    CP932_UNI_VAL_NULL,
    0x8f56,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe7c9,
    0xe7c8,
    CP932_UNI_VAL_NULL,
    0x8d79,
    CP932_UNI_VAL_NULL,
    0x8d93,
    0x8e5f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe7cc,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8f86,
    CP932_UNI_VAL_NULL,
    0xe7cb,
    CP932_UNI_VAL_NULL,
    0xe7ca,
    CP932_UNI_VAL_NULL,
    0x91e7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ced,
    CP932_UNI_VAL_NULL,
    0x90c1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x94ae,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8f58,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe7cd,
    CP932_UNI_VAL_NULL,
    0x8fdd,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe7d0,
    0xe7ce,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe7cf,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe7d2,
    0xe7d1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ff8,
    CP932_UNI_VAL_NULL,
    0xe7d3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe7d4,
    0xe7d5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x94ce,
    0x8dd1,
    0x8edf,
    0xe7d6,
    CP932_UNI_VAL_NULL,
    0xe7d7,
    0x97a2,
    0x8f64,
    0x96ec,
    0x97ca,
    0xe7d8,
    0x8be0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe7d9,
    0xfbbb,
    0x9342,
    CP932_UNI_VAL_NULL,
    0xfbba,
    0xe7dc,
    0x8a98,
    0x906a,
    0xfbbc,
    0xe7da,
    CP932_UNI_VAL_NULL,
    0xe7db,
    CP932_UNI_VAL_NULL,
    0x92de,
    0xfbbf,
    0xfbc0,
    0x9674,
    0x8bfa,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfbbd,
    0xfbbe,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe7de,
    0xe7df,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe7dd,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe7e1
};
UINT16 cp932_UNI_a0x92[] = {
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfbc1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfbc3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x93dd,
    0x8a62,
    CP932_UNI_VAL_NULL,
    0xfbc2,
    0xe7e5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe7e2,
    0xe7e4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe7e0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe86e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe7e3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x97e9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8cd8,
    CP932_UNI_VAL_NULL,
    0xfbca,
    0xfbc4,
    CP932_UNI_VAL_NULL,
    0xfbc6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe7ed,
    0xfbc5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9353,
    0xe7e8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe7eb,
    0xe7e9,
    CP932_UNI_VAL_NULL,
    0xe7ee,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfbc7,
    CP932_UNI_VAL_NULL,
    0xe7ef,
    0xfbc9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe7e7,
    CP932_UNI_VAL_NULL,
    0xfbc8,
    0xe7f4,
    0x8994,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe7e6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x94ab,
    CP932_UNI_VAL_NULL,
    0xe7ea,
    CP932_UNI_VAL_NULL,
    0x8fde,
    0xfbcb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8d7a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfbcd,
    0xfbce,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9667,
    CP932_UNI_VAL_NULL,
    0x8be2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8f65,
    CP932_UNI_VAL_NULL,
    0x93ba,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfa5f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x914c,
    CP932_UNI_VAL_NULL,
    0xe7f2,
    CP932_UNI_VAL_NULL,
    0xe7ec,
    0xe7f1,
    CP932_UNI_VAL_NULL,
    0x96c1,
    CP932_UNI_VAL_NULL,
    0x92b6,
    0xe7f3,
    0xe7f0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfbcc,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x914b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe7f7,
    CP932_UNI_VAL_NULL,
    0xe7f6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe7f5,
    0xfbd2,
    CP932_UNI_VAL_NULL,
    0x964e,
    0xfbd6,
    CP932_UNI_VAL_NULL,
    0xfbd4,
    CP932_UNI_VAL_NULL,
    0xfbd0,
    CP932_UNI_VAL_NULL,
    0xfbd1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfbd5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8f9b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfbcf,
    CP932_UNI_VAL_NULL,
    0xe7f8,
    0x95dd,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8973,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9565,
    0x9292,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8b98,
    0xfa65,
    0xe7fa,
    0xfbd9,
    0x8d7c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfbdc
};
UINT16 cp932_UNI_a0x93[] = {
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfbde,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8e4b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe7f9,
    0x908d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x908e,
    0xe840,
    0xe842,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfbdd,
    0xfbdb,
    CP932_UNI_VAL_NULL,
    0x8ff9,
    0xfbd8,
    0xe841,
    0xe843,
    CP932_UNI_VAL_NULL,
    0xfbd7,
    0x8bd1,
    CP932_UNI_VAL_NULL,
    0x9564,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ee0,
    0x9842,
    CP932_UNI_VAL_NULL,
    0xe7fc,
    0x8df6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x985e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe845,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe844,
    0xe846,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe7fb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfa5e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x93e7,
    CP932_UNI_VAL_NULL,
    0x9374,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x92d5,
    CP932_UNI_VAL_NULL,
    0xe84b,
    0xfbe0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9262,
    0xe847,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe848,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8c4c,
    CP932_UNI_VAL_NULL,
    0xe84a,
    CP932_UNI_VAL_NULL,
    0xfbdf,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8cae,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe849,
    CP932_UNI_VAL_NULL,
    0x8fdf,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8a99,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe84f,
    CP932_UNI_VAL_NULL,
    0x8dbd,
    0x9199,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x92c8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfbe1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8a5a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe84d,
    0xe84e,
    0x92c1,
    CP932_UNI_VAL_NULL,
    0xe84c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe850,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe856,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfbe2,
    CP932_UNI_VAL_NULL,
    0xe859,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe858,
    0x934c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe851,
    0xe852,
    0xe855,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe857,
    0xfbe3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8bbe,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe85a,
    0xe854,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe853,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfbe4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x94[] = {
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe85e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe85f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe860,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe85d,
    0xe85c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8fe0,
    0x93a8,
    0xe85b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe864,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe862,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfbe5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe863,
    0xe861,
    CP932_UNI_VAL_NULL,
    0x91f6,
    CP932_UNI_VAL_NULL,
    0xe865,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe866,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe868,
    0xfbe6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfbe7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ad3,
    0xe867,
    0x96f8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe873,
    0xe869,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe86c,
    CP932_UNI_VAL_NULL,
    0xe86a,
    CP932_UNI_VAL_NULL,
    0xe86b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe86d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe86f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe870,
    CP932_UNI_VAL_NULL,
    0xe871,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe874,
    0xe872,
    0xe875,
    0xe877,
    CP932_UNI_VAL_NULL,
    0xe876,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x95[] = {
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x92b7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x96e5,
    CP932_UNI_VAL_NULL,
    0xe878,
    0x914d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe879,
    CP932_UNI_VAL_NULL,
    0x95c2,
    0xe87a,
    0x8a4a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x895b,
    CP932_UNI_VAL_NULL,
    0x8ad5,
    0xfbe8,
    0x8ad4,
    0xe87b,
    CP932_UNI_VAL_NULL,
    0xe87c,
    CP932_UNI_VAL_NULL,
    0xe87d,
    0xe87e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe880,
    CP932_UNI_VAL_NULL,
    0x8ad6,
    0x8a74,
    0x8d7d,
    0x94b4,
    CP932_UNI_VAL_NULL,
    0xe882,
    0xe881,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe883,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x897b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe886,
    CP932_UNI_VAL_NULL,
    0xe885,
    0xe884,
    CP932_UNI_VAL_NULL,
    0xe887,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe88a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x88c5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe888,
    CP932_UNI_VAL_NULL,
    0xe88c,
    0xe88b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe88e,
    0xe88d,
    0xe88f,
    CP932_UNI_VAL_NULL,
    0x93ac,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe890,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe891,
    0xe893,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe892,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x96[] = {
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x958c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe894,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe895,
    CP932_UNI_VAL_NULL,
    0x8de3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe896,
    0xe897,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9668,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x916a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x88a2,
    0x91c9,
    CP932_UNI_VAL_NULL,
    0xe898,
    CP932_UNI_VAL_NULL,
    0x958d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe89b,
    0xe899,
    0x8d7e,
    CP932_UNI_VAL_NULL,
    0xe89a,
    0x8cc0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x95c3,
    0xe89d,
    0xe89f,
    0xe89e,
    0xe8a0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8940,
    0x9077,
    0x8f9c,
    0x8ad7,
    0xe8a1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9486,
    CP932_UNI_VAL_NULL,
    0xe8a3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8941,
    CP932_UNI_VAL_NULL,
    0xe8a2,
    0x92c2,
    CP932_UNI_VAL_NULL,
    0x97cb,
    0x93a9,
    0xe89c,
    0x97a4,
    CP932_UNI_VAL_NULL,
    0x8caf,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x977a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8bf7,
    0x97b2,
    CP932_UNI_VAL_NULL,
    0x8c47,
    CP932_UNI_VAL_NULL,
    0x91e0,
    0xe440,
    CP932_UNI_VAL_NULL,
    0xe8a4,
    0x8a4b,
    0x908f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8a75,
    0xe8a6,
    CP932_UNI_VAL_NULL,
    0xe8a7,
    0xe8a5,
    0x8c84,
    CP932_UNI_VAL_NULL,
    0x8ddb,
    0x8fe1,
    0xfbeb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8942,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x97d7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe8a9,
    0xe7ac,
    CP932_UNI_VAL_NULL,
    0xe8a8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfbec,
    0xe8ac,
    0xe8aa,
    0xe8ab,
    CP932_UNI_VAL_NULL,
    0xe8ad,
    CP932_UNI_VAL_NULL,
    0xe8ae,
    0x97ea,
    0xe8af,
    0xe8b0,
    CP932_UNI_VAL_NULL,
    0x90c7,
    0x94b9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x909d,
    0x8ae5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9759,
    0x89eb,
    0x8f57,
    0x8cd9,
    CP932_UNI_VAL_NULL,
    0xe8b3,
    CP932_UNI_VAL_NULL,
    0xe8b2,
    0x8e93,
    0xe8b4,
    0xe8b1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8e47,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe8b8,
    0xe5ab,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x99d4,
    CP932_UNI_VAL_NULL,
    0x9097,
    0xe8b6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x97a3,
    0x93ef,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x894a,
    CP932_UNI_VAL_NULL,
    0x90e1,
    0x8eb4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x95b5,
    CP932_UNI_VAL_NULL,
    0x895f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x97eb,
    0x978b,
    CP932_UNI_VAL_NULL,
    0xe8b9,
    CP932_UNI_VAL_NULL,
    0x9364,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x97[] = {
    0x8ef9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe8ba,
    CP932_UNI_VAL_NULL,
    0xe8bb,
    0x906b,
    0xe8bc,
    CP932_UNI_VAL_NULL,
    0x97ec,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe8b7,
    0xe8be,
    0xe8c0,
    CP932_UNI_VAL_NULL,
    0xe8bf,
    CP932_UNI_VAL_NULL,
    0xe8bd,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe8c1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe8c2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x919a,
    CP932_UNI_VAL_NULL,
    0x89e0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe8c3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x96b6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe8c4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe8c5,
    CP932_UNI_VAL_NULL,
    0x9849,
    0xfbed,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9e50,
    0xe8c6,
    CP932_UNI_VAL_NULL,
    0xfbee,
    CP932_UNI_VAL_NULL,
    0xe8c7,
    0xe8c8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe8cc,
    0xfbef,
    0xe8c9,
    CP932_UNI_VAL_NULL,
    0xe8ca,
    CP932_UNI_VAL_NULL,
    0xe8cb,
    0xe8cd,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfbf0,
    CP932_UNI_VAL_NULL,
    0xfbf1,
    CP932_UNI_VAL_NULL,
    0xfbf2,
    0x90c2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfbf3,
    0x96f5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x90c3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe8ce,
    CP932_UNI_VAL_NULL,
    0x94f1,
    CP932_UNI_VAL_NULL,
    0xe8cf,
    0xea72,
    0x96ca,
    CP932_UNI_VAL_NULL,
    0xe8d0,
    CP932_UNI_VAL_NULL,
    0xe8d1,
    CP932_UNI_VAL_NULL,
    0xe8d2,
    0x8a76,
    CP932_UNI_VAL_NULL,
    0xe8d4,
    CP932_UNI_VAL_NULL,
    0x9078,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe8d5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8c43,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe8d6,
    0xe8da,
    CP932_UNI_VAL_NULL,
    0xe8d8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe8d9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8a93,
    0xe8d7,
    0xe8db,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe8dc,
    CP932_UNI_VAL_NULL,
    0x88c6,
    CP932_UNI_VAL_NULL,
    0xe8dd,
    0xe8de,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8fe2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe8df,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8b66,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe8e2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe8e1,
    CP932_UNI_VAL_NULL,
    0xe8e0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe691,
    CP932_UNI_VAL_NULL,
    0x95da,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe8e3,
    0xe8e4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe8e5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe8e6,
    CP932_UNI_VAL_NULL,
    0xe8e7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe8e8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ad8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe8e9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe8ea,
    0x9442,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe8ec,
    0x89b9,
    CP932_UNI_VAL_NULL,
    0xe8ef,
    0xe8ee,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8943,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8bbf
};
UINT16 cp932_UNI_a0x98[] = {
    CP932_UNI_VAL_NULL,
    0x95c5,
    0x92b8,
    0x8da0,
    CP932_UNI_VAL_NULL,
    0x8d80,
    0x8f87,
    CP932_UNI_VAL_NULL,
    0x907b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe8f1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe8f0,
    0x9761,
    0x8ae6,
    0x94d0,
    0x93da,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x909c,
    0x97cc,
    CP932_UNI_VAL_NULL,
    0x8c7a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe8f4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe8f3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x966a,
    0x93aa,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x896f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe8f5,
    0xe8f2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9570,
    0x978a,
    0xe8f6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe8f7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe8f9,
    0x91e8,
    0x8a7a,
    0x8a7b,
    0xe8f8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ae7,
    0x8cb0,
    CP932_UNI_VAL_NULL,
    0xfbf4,
    0x8ae8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x935e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x97de,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfbf5,
    CP932_UNI_VAL_NULL,
    0x8cda,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe8fa,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe8fb,
    0xe8fc,
    0xe940,
    CP932_UNI_VAL_NULL,
    0xe942,
    0xe941,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9597,
    CP932_UNI_VAL_NULL,
    0xe943,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe944,
    CP932_UNI_VAL_NULL,
    0xe945,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe946,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe948,
    0xe947,
    CP932_UNI_VAL_NULL,
    0xe949,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x94f2,
    0xe3ca,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9048,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8b51,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe94a,
    CP932_UNI_VAL_NULL,
    0xe94b,
    CP932_UNI_VAL_NULL,
    0x99aa,
    0x9f5a,
    0x94d1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x88f9,
    CP932_UNI_VAL_NULL,
    0x88b9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8e94,
    0x964f,
    0x8ffc,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x99[] = {
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe94c,
    CP932_UNI_VAL_NULL,
    0x96dd,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe94d,
    0x977b,
    CP932_UNI_VAL_NULL,
    0x8961,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8e60,
    CP932_UNI_VAL_NULL,
    0xe94e,
    0x89ec,
    0xe94f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe950,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe952,
    0xe953,
    CP932_UNI_VAL_NULL,
    0xe955,
    0xe951,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe954,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfbf8,
    0x8ad9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe956,
    CP932_UNI_VAL_NULL,
    0xe957,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe958,
    0xe959,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe95a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe95c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe95b,
    CP932_UNI_VAL_NULL,
    0xe95e,
    0xe961,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe95d,
    0xe95f,
    0xe960,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe962,
    CP932_UNI_VAL_NULL,
    0x8bc0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8ef1,
    0xe963,
    0xe964,
    0x8d81,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfbfa,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe965,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8a5d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x946e,
    0xe966,
    0xe967,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9279,
    0x93e9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe968,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x949d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x91ca,
    0x8977,
    0x8bec,
    CP932_UNI_VAL_NULL,
    0x8bed,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9293,
    0xe96d,
    0x8bee,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x89ed,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe96c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe96a,
    CP932_UNI_VAL_NULL,
    0xe96b,
    CP932_UNI_VAL_NULL,
    0xe969,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe977,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe96e,
    0xe96f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe970,
    0xe971,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe973,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe972,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8f78
};
UINT16 cp932_UNI_a0x9a[] = {
    CP932_UNI_VAL_NULL,
    0xe974,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe976,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8b52,
    0xe975,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x919b,
    0x8cb1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe978,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x91cb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe979,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x93ab,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe97a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe980,
    CP932_UNI_VAL_NULL,
    0xe97d,
    CP932_UNI_VAL_NULL,
    0xe97c,
    0xe97e,
    CP932_UNI_VAL_NULL,
    0xe97b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe982,
    0xfbfb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe981,
    CP932_UNI_VAL_NULL,
    0xe984,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8bc1,
    0xe983,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe985,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe986,
    CP932_UNI_VAL_NULL,
    0xe988,
    0xe987,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe989,
    0xe98b,
    0xe98a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8d9c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe98c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe98d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8a5b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe98e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe98f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9091,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe990,
    CP932_UNI_VAL_NULL,
    0xe991,
    CP932_UNI_VAL_NULL,
    0xe992,
    0xe993,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8d82,
    0xfbfc,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfc40,
    CP932_UNI_VAL_NULL,
    0xe994,
    0xe995,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe996,
    0xe997,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe998,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x94af,
    0xe99a,
    CP932_UNI_VAL_NULL,
    0x9545,
    0xe99b,
    0xe999,
    CP932_UNI_VAL_NULL,
    0xe99d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe99c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe99e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe99f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x9b[] = {
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe9a0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe9a1,
    CP932_UNI_VAL_NULL,
    0xe9a2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe9a3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe9a4,
    0xe9a5,
    CP932_UNI_VAL_NULL,
    0xe9a6,
    CP932_UNI_VAL_NULL,
    0xe9a7,
    0xe9a8,
    0xe9a9,
    0xe9aa,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe9ab,
    0xe9ac,
    CP932_UNI_VAL_NULL,
    0x9f54,
    0xe9ad,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe2f6,
    0x8b53,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8a40,
    0x8db0,
    0xe9af,
    0xe9ae,
    0x96a3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe9b1,
    0xe9b2,
    0xe9b0,
    CP932_UNI_VAL_NULL,
    0xe9b3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9682,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe9b4,
    CP932_UNI_VAL_NULL,
    0x8b9b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9844,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfc42,
    CP932_UNI_VAL_NULL,
    0xe9b5,
    0xfc41,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe9b7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x88bc,
    0xfc43,
    CP932_UNI_VAL_NULL,
    0xe9b8,
    0x95a9,
    0xe9b6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe9b9,
    0xe9ba,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe9bb,
    0xe9bc,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe9bd,
    CP932_UNI_VAL_NULL,
    0x968e,
    0x8e4c,
    CP932_UNI_VAL_NULL,
    0x8df8,
    0x914e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfc44,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe9be,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe9c1,
    CP932_UNI_VAL_NULL,
    0xfc45,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe9bf,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe9c2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8cef,
    0xe9c0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe9c3,
    CP932_UNI_VAL_NULL,
    0xe9c4,
    0xe9c5,
    CP932_UNI_VAL_NULL,
    0xe9c9,
    CP932_UNI_VAL_NULL,
    0x8e49,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x91e2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe9ca,
    0xe9c7,
    0xe9c6,
    0xe9c8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8c7e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe9ce,
    0xe9cd,
    0xe9cc,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x88b1,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x9c[] = {
    0xfc46,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe9d8,
    CP932_UNI_VAL_NULL,
    0xe9d4,
    CP932_UNI_VAL_NULL,
    0xe9d5,
    0xe9d1,
    0xe9d7,
    CP932_UNI_VAL_NULL,
    0xe9d3,
    0x8a82,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x986b,
    CP932_UNI_VAL_NULL,
    0xe9d6,
    0xe9d2,
    0xe9d0,
    0xe9cf,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe9da,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe9dd,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe9dc,
    0xe9db,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9568,
    0xe9d9,
    0x88f1,
    0xe9de,
    CP932_UNI_VAL_NULL,
    0xe9e0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8a8f,
    0xe9cb,
    0x8956,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe9e2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe9e1,
    0xe9df,
    0x924c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9690,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x97d8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe9e3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe9e4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe9e5,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe9e6,
    CP932_UNI_VAL_NULL,
    0xe9e7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x92b9,
    CP932_UNI_VAL_NULL,
    0xe9e8,
    CP932_UNI_VAL_NULL,
    0x94b5,
    CP932_UNI_VAL_NULL,
    0xe9ed,
    0xe9e9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe9ea,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9650,
    0x96c2,
    CP932_UNI_VAL_NULL,
    0x93ce,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x9d[] = {
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe9ee,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe9ef,
    0x93bc,
    0xe9ec,
    0xe9eb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x89a8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe9f7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe9f6,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8995,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe9f4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe9f3,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe9f1,
    CP932_UNI_VAL_NULL,
    0x8a9b,
    CP932_UNI_VAL_NULL,
    0xe9f0,
    0x8eb0,
    0x89a7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8d83,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe9fa,
    0xe9f9,
    CP932_UNI_VAL_NULL,
    0xe9f8,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe9f5,
    CP932_UNI_VAL_NULL,
    0xe9fb,
    CP932_UNI_VAL_NULL,
    0xe9fc,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xea44,
    0xea43,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xea45,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x894c,
    0xea40,
    0xea41,
    CP932_UNI_VAL_NULL,
    0x8d94,
    0x96b7,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xea42,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfc48,
    0x9651,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xea4a,
    0xfc47,
    CP932_UNI_VAL_NULL,
    0xea46,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xea4b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xea48,
    CP932_UNI_VAL_NULL,
    0xea47,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8c7b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xea4c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xea4d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xea4e,
    CP932_UNI_VAL_NULL,
    0xea49,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe9f2,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xea4f,
    CP932_UNI_VAL_NULL,
    0x92df,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xea53,
    CP932_UNI_VAL_NULL,
    0xea54,
    0xea52,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xea51,
    0xea57,
    CP932_UNI_VAL_NULL,
    0xea50,
    CP932_UNI_VAL_NULL,
    0xea55,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xea56,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xea59,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xea58,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xea5b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xea5c,
    CP932_UNI_VAL_NULL,
    0xea5d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9868,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xea5a,
    0x91e9,
    0x8deb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xea5e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x9e[] = {
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfc4a,
    0xea5f,
    0xea60,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xea61,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xea62,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8cb2,
    0xea63,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xea64,
    CP932_UNI_VAL_NULL,
    0x8ead,
    CP932_UNI_VAL_NULL,
    0xea65,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xea66,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xea67,
    0xea68,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xea6b,
    0xea69,
    0x985b,
    CP932_UNI_VAL_NULL,
    0xea6a,
    CP932_UNI_VAL_NULL,
    0x97ed,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xea6c,
    CP932_UNI_VAL_NULL,
    0x97d9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xea6d,
    0x949e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xea6e,
    0xea70,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xea71,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xea6f,
    0x8d8d,
    0x96cb,
    0x9683,
    0x9bf5,
    CP932_UNI_VAL_NULL,
    0x9f80,
    0x969b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x89a9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xea73,
    0x8b6f,
    0xea74,
    0xea75,
    0xea76,
    0xfc4b,
    0x8d95,
    CP932_UNI_VAL_NULL,
    0xea77,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe0d2,
    0x96d9,
    CP932_UNI_VAL_NULL,
    0x91e1,
    0xea78,
    0xea7a,
    0xea79,
    CP932_UNI_VAL_NULL,
    0xea7b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xea7c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xea7d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xea7e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xea80,
    CP932_UNI_VAL_NULL,
    0xea81,
    0xea82,
    CP932_UNI_VAL_NULL,
    0xea83,
    CP932_UNI_VAL_NULL,
    0xea84,
    0xea85,
    0xea86,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0x9f[] = {
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xea87,
    0xea88,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9343,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8cdb,
    CP932_UNI_VAL_NULL,
    0xea8a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x916c,
    0xea8b,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xea8c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x9540,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xea8d,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xea8e,
    0xe256,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xe6d8,
    0xe8eb,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xea8f,
    CP932_UNI_VAL_NULL,
    0xea90,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xea92,
    0xea93,
    0xea94,
    0x97ee,
    0xea91,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xea95,
    0xea96,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xea98,
    CP932_UNI_VAL_NULL,
    0xea97,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xea9a,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xea9b,
    0xea99,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x97b4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xea9c,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xea9d,
    0xe273,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xea9e,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0xf9[] = {
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfae0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfbe9,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0xfa[] = {
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xfa90,
    0xfa9b,
    0xfa9c,
    0xfab1,
    0xfad8,
    0xfae8,
    0xfaea,
    0xfb58,
    0xfb5e,
    0xfb75,
    0xfb7d,
    0xfb7e,
    0xfb80,
    0xfb82,
    0xfb86,
    0xfb89,
    0xfb92,
    0xfb9d,
    0xfb9f,
    0xfba0,
    0xfba9,
    0xfbb1,
    0xfbb3,
    0xfbb4,
    0xfbb7,
    0xfbd3,
    0xfbda,
    0xfbea,
    0xfbf6,
    0xfbf7,
    0xfbf9,
    0xfc49,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
UINT16 cp932_UNI_a0xff[] = {
    CP932_UNI_VAL_NULL,
    0x8149,
    0xfa57,
    0x8194,
    0x8190,
    0x8193,
    0x8195,
    0xfa56,
    0x8169,
    0x816a,
    0x8196,
    0x817b,
    0x8143,
    0x817c,
    0x8144,
    0x815e,
    0x824f,
    0x8250,
    0x8251,
    0x8252,
    0x8253,
    0x8254,
    0x8255,
    0x8256,
    0x8257,
    0x8258,
    0x8146,
    0x8147,
    0x8183,
    0x8181,
    0x8184,
    0x8148,
    0x8197,
    0x8260,
    0x8261,
    0x8262,
    0x8263,
    0x8264,
    0x8265,
    0x8266,
    0x8267,
    0x8268,
    0x8269,
    0x826a,
    0x826b,
    0x826c,
    0x826d,
    0x826e,
    0x826f,
    0x8270,
    0x8271,
    0x8272,
    0x8273,
    0x8274,
    0x8275,
    0x8276,
    0x8277,
    0x8278,
    0x8279,
    0x816d,
    0x815f,
    0x816e,
    0x814f,
    0x8151,
    0x814d,
    0x8281,
    0x8282,
    0x8283,
    0x8284,
    0x8285,
    0x8286,
    0x8287,
    0x8288,
    0x8289,
    0x828a,
    0x828b,
    0x828c,
    0x828d,
    0x828e,
    0x828f,
    0x8290,
    0x8291,
    0x8292,
    0x8293,
    0x8294,
    0x8295,
    0x8296,
    0x8297,
    0x8298,
    0x8299,
    0x829a,
    0x816f,
    0x8162,
    0x8170,
    0x8160,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0xa1,
    0xa2,
    0xa3,
    0xa4,
    0xa5,
    0xa6,
    0xa7,
    0xa8,
    0xa9,
    0xaa,
    0xab,
    0xac,
    0xad,
    0xae,
    0xaf,
    0xb0,
    0xb1,
    0xb2,
    0xb3,
    0xb4,
    0xb5,
    0xb6,
    0xb7,
    0xb8,
    0xb9,
    0xba,
    0xbb,
    0xbc,
    0xbd,
    0xbe,
    0xbf,
    0xc0,
    0xc1,
    0xc2,
    0xc3,
    0xc4,
    0xc5,
    0xc6,
    0xc7,
    0xc8,
    0xc9,
    0xca,
    0xcb,
    0xcc,
    0xcd,
    0xce,
    0xcf,
    0xd0,
    0xd1,
    0xd2,
    0xd3,
    0xd4,
    0xd5,
    0xd6,
    0xd7,
    0xd8,
    0xd9,
    0xda,
    0xdb,
    0xdc,
    0xdd,
    0xde,
    0xdf,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    0x8191,
    0x8192,
    0x81ca,
    0x8150,
    0xfa55,
    0x818f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL
};
VOID *cp932_UNI_idx[] = {
    &cp932_UNI_a0x0,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    &cp932_UNI_a0x3,
    &cp932_UNI_a0x4,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    &cp932_UNI_a0x20,
    &cp932_UNI_a0x21,
    &cp932_UNI_a0x22,
    &cp932_UNI_a0x23,
    &cp932_UNI_a0x24,
    &cp932_UNI_a0x25,
    &cp932_UNI_a0x26,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    &cp932_UNI_a0x30,
    CP932_UNI_VAL_NULL,
    &cp932_UNI_a0x32,
    &cp932_UNI_a0x33,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    &cp932_UNI_a0x4e,
    &cp932_UNI_a0x4f,
    &cp932_UNI_a0x50,
    &cp932_UNI_a0x51,
    &cp932_UNI_a0x52,
    &cp932_UNI_a0x53,
    &cp932_UNI_a0x54,
    &cp932_UNI_a0x55,
    &cp932_UNI_a0x56,
    &cp932_UNI_a0x57,
    &cp932_UNI_a0x58,
    &cp932_UNI_a0x59,
    &cp932_UNI_a0x5a,
    &cp932_UNI_a0x5b,
    &cp932_UNI_a0x5c,
    &cp932_UNI_a0x5d,
    &cp932_UNI_a0x5e,
    &cp932_UNI_a0x5f,
    &cp932_UNI_a0x60,
    &cp932_UNI_a0x61,
    &cp932_UNI_a0x62,
    &cp932_UNI_a0x63,
    &cp932_UNI_a0x64,
    &cp932_UNI_a0x65,
    &cp932_UNI_a0x66,
    &cp932_UNI_a0x67,
    &cp932_UNI_a0x68,
    &cp932_UNI_a0x69,
    &cp932_UNI_a0x6a,
    &cp932_UNI_a0x6b,
    &cp932_UNI_a0x6c,
    &cp932_UNI_a0x6d,
    &cp932_UNI_a0x6e,
    &cp932_UNI_a0x6f,
    &cp932_UNI_a0x70,
    &cp932_UNI_a0x71,
    &cp932_UNI_a0x72,
    &cp932_UNI_a0x73,
    &cp932_UNI_a0x74,
    &cp932_UNI_a0x75,
    &cp932_UNI_a0x76,
    &cp932_UNI_a0x77,
    &cp932_UNI_a0x78,
    &cp932_UNI_a0x79,
    &cp932_UNI_a0x7a,
    &cp932_UNI_a0x7b,
    &cp932_UNI_a0x7c,
    &cp932_UNI_a0x7d,
    &cp932_UNI_a0x7e,
    &cp932_UNI_a0x7f,
    &cp932_UNI_a0x80,
    &cp932_UNI_a0x81,
    &cp932_UNI_a0x82,
    &cp932_UNI_a0x83,
    &cp932_UNI_a0x84,
    &cp932_UNI_a0x85,
    &cp932_UNI_a0x86,
    &cp932_UNI_a0x87,
    &cp932_UNI_a0x88,
    &cp932_UNI_a0x89,
    &cp932_UNI_a0x8a,
    &cp932_UNI_a0x8b,
    &cp932_UNI_a0x8c,
    &cp932_UNI_a0x8d,
    &cp932_UNI_a0x8e,
    &cp932_UNI_a0x8f,
    &cp932_UNI_a0x90,
    &cp932_UNI_a0x91,
    &cp932_UNI_a0x92,
    &cp932_UNI_a0x93,
    &cp932_UNI_a0x94,
    &cp932_UNI_a0x95,
    &cp932_UNI_a0x96,
    &cp932_UNI_a0x97,
    &cp932_UNI_a0x98,
    &cp932_UNI_a0x99,
    &cp932_UNI_a0x9a,
    &cp932_UNI_a0x9b,
    &cp932_UNI_a0x9c,
    &cp932_UNI_a0x9d,
    &cp932_UNI_a0x9e,
    &cp932_UNI_a0x9f,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    &cp932_UNI_a0xf9,
    &cp932_UNI_a0xfa,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    CP932_UNI_VAL_NULL,
    &cp932_UNI_a0xff
};
#endif /* CFG_NU_OS_STOR_FILE_VFS_INCLUDE_CP_SUPPORT == 1 */
