/*************************************************************************
*
*               Copyright Mentor Graphics Corporation 2013
*                         All Rights Reserved.
*
* THIS WORK CONTAINS TRADE SECRET AND PROPRIETARY INFORMATION WHICH IS
* THE PROPERTY OF MENTOR GRAPHICS CORPORATION OR ITS LICENSORS AND IS
* SUBJECT TO LICENSE TERMS.
*
*************************************************************************/
/*************************************************************************
*
*   FILE NAME
*
*       net_exp.c
*
*   COMPONENT
*
*       Exported Symbols
*
*   DESCRIPTION
*
*       Export symbols for Nucleus Networking Stack.
*
*   DATA STRUCTURES
*
*       None
*
*   FUNCTIONS
*
*       None
*
*************************************************************************/

#include "networking/nu_networking.h"

#if (CFG_NU_OS_NET_STACK_EXPORT_SYMBOLS == NU_TRUE)

#include "kernel/proc_extern.h"

/* Define component name for these symbols */
NU_SYMBOL_COMPONENT(NU_OS_NET_STACK);

/* Export networking APIs */
NU_EXPORT_SYMBOL(NETBOOT_Wait_For_Network_Up);
NU_EXPORT_SYMBOL(NU_Abort);
NU_EXPORT_SYMBOL(NU_Accept);
NU_EXPORT_SYMBOL(NU_Add_DNS_Server2);
NU_EXPORT_SYMBOL(NU_Bind);
NU_EXPORT_SYMBOL(NLOG_Clear_All_Errors);            /* NU_Clear_Internal_Log maps to this. */
NU_EXPORT_SYMBOL(NU_Close_Socket);
NU_EXPORT_SYMBOL(NU_Connect);
NU_EXPORT_SYMBOL(NU_Delete_DNS_Server2);
NU_EXPORT_SYMBOL(NU_Delete_Host_Entry);
NU_EXPORT_SYMBOL(NU_Delete_Route2);
NU_EXPORT_SYMBOL(NU_Detach_IP_From_Device);
NU_EXPORT_SYMBOL(NU_Device_Up);
NU_EXPORT_SYMBOL(NU_DNS_SD_Browse);
NU_EXPORT_SYMBOL(NU_DNS_SD_Look_Up);
NU_EXPORT_SYMBOL(NU_DNS_SD_Refresh);
NU_EXPORT_SYMBOL(NU_DNS_SD_Register_Service);
NU_EXPORT_SYMBOL(NU_DNS_Build_Key);
NU_EXPORT_SYMBOL(NU_DNS_Parse_Key);
NU_EXPORT_SYMBOL(NU_Ethernet_Link_Down);
NU_EXPORT_SYMBOL(NU_Ethernet_Link_Up);
NU_EXPORT_SYMBOL(NU_Fcntl);
NU_EXPORT_SYMBOL(NU_FD_Check);
NU_EXPORT_SYMBOL(NU_FD_Init);
NU_EXPORT_SYMBOL(NU_FD_Reset);
NU_EXPORT_SYMBOL(NU_FD_Set);
NU_EXPORT_SYMBOL(NU_Select);
NU_EXPORT_SYMBOL(NU_Find_Next_Route);
NU_EXPORT_SYMBOL(NU_Find_Next_Route_Entry);
NU_EXPORT_SYMBOL(NU_Find_Route_By_Gateway);
NU_EXPORT_SYMBOL(NU_Find_Socket);
NU_EXPORT_SYMBOL(NU_Get_Default_Route);
NU_EXPORT_SYMBOL(NU_Free_Host_Entry);
NU_EXPORT_SYMBOL(NU_Get_DNS_Servers2);
NU_EXPORT_SYMBOL(SCK_Get_Domain_Name);              /* NU_Get_Domain_Name maps to this. */
NU_EXPORT_SYMBOL(NU_Get_Host_By_Addr);
NU_EXPORT_SYMBOL(NU_Get_Host_By_Name);
NU_EXPORT_SYMBOL(NU_Get_Host_MX);
NU_EXPORT_SYMBOL(SCK_Get_Host_Name);                /* NU_Get_Host_Name maps to this. */
NU_EXPORT_SYMBOL(NU_Get_IP_Node_By_Addr);
NU_EXPORT_SYMBOL(NU_Get_IP_Node_By_Name);
NU_EXPORT_SYMBOL(NU_Get_Peer_Name);
NU_EXPORT_SYMBOL(NU_Get_PMTU);
NU_EXPORT_SYMBOL(NU_Get_Reasm_Max_Size);
NU_EXPORT_SYMBOL(NU_Get_Sock_Name);
NU_EXPORT_SYMBOL(NU_Getsockopt);
NU_EXPORT_SYMBOL(NU_Getsockopt_IP_HDRINCL);
NU_EXPORT_SYMBOL(NU_Getsockopt_IP_RECVIFADDR);
NU_EXPORT_SYMBOL(NU_Getsockopt_IP_TOS);
NU_EXPORT_SYMBOL(NU_Getsockopt_SO_BROADCAST);
NU_EXPORT_SYMBOL(NU_Getsockopt_SO_KEEPALIVE);
NU_EXPORT_SYMBOL(NU_Getsockopt_SO_LINGER);
NU_EXPORT_SYMBOL(NU_Getsockopt_SO_RCVBUF);
NU_EXPORT_SYMBOL(NU_Getsockopt_SO_REUSEADDR);
NU_EXPORT_SYMBOL(NU_Getsockopt_TCP_CFG_DSACK);
NU_EXPORT_SYMBOL(NU_Getsockopt_TCP_CFG_SACK);
NU_EXPORT_SYMBOL(NU_Getsockopt_TCP_CONGESTION_CTRL);
NU_EXPORT_SYMBOL(NU_Getsockopt_TCP_DELAY_ACK);
NU_EXPORT_SYMBOL(NU_Getsockopt_TCP_FIRST_RTO);
NU_EXPORT_SYMBOL(NU_Getsockopt_TCP_FIRST_PROBE_TIMEOUT);
NU_EXPORT_SYMBOL(NU_Getsockopt_TCP_KEEPALIVE_R2);
NU_EXPORT_SYMBOL(NU_Getsockopt_TCP_KEEPALIVE_WAIT);
NU_EXPORT_SYMBOL(NU_Getsockopt_TCP_MAX_PROBES);
NU_EXPORT_SYMBOL(NU_Getsockopt_TCP_MAX_R2);
NU_EXPORT_SYMBOL(NU_Getsockopt_TCP_MAX_RTO);
NU_EXPORT_SYMBOL(NU_Getsockopt_TCP_MAX_SYN_R2);
NU_EXPORT_SYMBOL(NU_Getsockopt_TCP_MSL);
NU_EXPORT_SYMBOL(NU_Getsockopt_TCP_NODELAY);
NU_EXPORT_SYMBOL(NU_Getsockopt_TCP_PROBE_TIMEOUT);
NU_EXPORT_SYMBOL(NU_Getsockopt_TCP_RCV_WINDOWSIZE);
NU_EXPORT_SYMBOL(NU_Getsockopt_TCP_SND_WINDOWSIZE);
NU_EXPORT_SYMBOL(NU_Getsockopt_TCP_TIMESTAMP);
NU_EXPORT_SYMBOL(NU_Getsockopt_TCP_WINDOWSCALE);
NU_EXPORT_SYMBOL(NU_Getsockopt_UDP_NOCHECKSUM);
NU_EXPORT_SYMBOL(NU_IF_FreeNameIndex);
NU_EXPORT_SYMBOL(NU_IF_IndexToName);
NU_EXPORT_SYMBOL(NU_IF_NameIndex);
NU_EXPORT_SYMBOL(NU_IF_NameToIndex);
NU_EXPORT_SYMBOL(NU_Inet_NTOP);
NU_EXPORT_SYMBOL(NU_Inet_PTON);
NU_EXPORT_SYMBOL(NU_Init_Devices);
NU_EXPORT_SYMBOL(NU_Init_Net);
NU_EXPORT_SYMBOL(NU_Ioctl);
NU_EXPORT_SYMBOL(NU_Ioctl_FIONREAD);
NU_EXPORT_SYMBOL(NU_Ioctl_SIOCGETVLAN);
NU_EXPORT_SYMBOL(NU_Ioctl_SIOCGETVLANPRIO);
NU_EXPORT_SYMBOL(NU_Ioctl_SIOCGHWCAP);
NU_EXPORT_SYMBOL(NU_Ioctl_SIOCICMPLIMIT);
NU_EXPORT_SYMBOL(NU_Ioctl_SIOCIFREQ);
NU_EXPORT_SYMBOL(NU_Ioctl_SIOCSHWOPTS);
NU_EXPORT_SYMBOL(NU_Ioctl_SIOCSETVLAN);
NU_EXPORT_SYMBOL(NU_Ioctl_SIOCSETVLANPRIO);
NU_EXPORT_SYMBOL(NU_Is_Connected);
NU_EXPORT_SYMBOL(NU_Listen);
NU_EXPORT_SYMBOL(NU_Ping2);
NU_EXPORT_SYMBOL(NU_Push);
NU_EXPORT_SYMBOL(NU_Recv);
NU_EXPORT_SYMBOL(NU_Recvmsg);
NU_EXPORT_SYMBOL(NU_Recv_From);
NU_EXPORT_SYMBOL(NU_Recv_From_Raw);
NU_EXPORT_SYMBOL(NU_Remove_Device);
NU_EXPORT_SYMBOL(NU_Remove_IP_From_Device);
NU_EXPORT_SYMBOL(NU_Send);
NU_EXPORT_SYMBOL(NU_Sendmsg);
NU_EXPORT_SYMBOL(NU_Send_To);
NU_EXPORT_SYMBOL(NU_Send_To_Raw);
NU_EXPORT_SYMBOL(NU_Set_Device_Hostname);
NU_EXPORT_SYMBOL(SCK_Set_Domain_Name);              /* NU_Set_Domain_Name maps to this. */
NU_EXPORT_SYMBOL(SCK_Set_Host_Name);                /* NU_Set_Host_Name maps to this. */
NU_EXPORT_SYMBOL(NU_Set_IP_Forwarding);
NU_EXPORT_SYMBOL(NU_Set_Reasm_Max_Size);
NU_EXPORT_SYMBOL(NU_Shutdown);
NU_EXPORT_SYMBOL(NU_Socket);
NU_EXPORT_SYMBOL(NU_Setsockopt);
NU_EXPORT_SYMBOL(NU_Setsockopt_IP_HDRINCL);
NU_EXPORT_SYMBOL(NU_Setsockopt_IP_PKTINFO);
NU_EXPORT_SYMBOL(NU_Setsockopt_IP_RECVIFADDR);
NU_EXPORT_SYMBOL(NU_Setsockopt_IP_TOS);
NU_EXPORT_SYMBOL(NU_Setsockopt_IP_TTL);
NU_EXPORT_SYMBOL(NU_Setsockopt_SO_BROADCAST);
NU_EXPORT_SYMBOL(NU_Setsockopt_SO_KEEPALIVE);
NU_EXPORT_SYMBOL(NU_Setsockopt_SO_LINGER);
NU_EXPORT_SYMBOL(NU_Setsockopt_SO_RCVBUF);
NU_EXPORT_SYMBOL(NU_Setsockopt_SO_REUSEADDR);
NU_EXPORT_SYMBOL(NU_Setsockopt_TCP_CFG_DSACK);
NU_EXPORT_SYMBOL(NU_Setsockopt_TCP_CFG_SACK);
NU_EXPORT_SYMBOL(NU_Setsockopt_TCP_CONGESTION_CTRL);
NU_EXPORT_SYMBOL(NU_Setsockopt_TCP_DELAY_ACK);
NU_EXPORT_SYMBOL(NU_Setsockopt_TCP_FIRST_PROBE_TIMEOUT);
NU_EXPORT_SYMBOL(NU_Setsockopt_TCP_FIRST_RTO);
/*NU_EXPORT_SYMBOL(NU_Setsockopt_TCP_KEEPINTVL);*/
NU_EXPORT_SYMBOL(NU_Setsockopt_TCP_KEEPALIVE_R2);
NU_EXPORT_SYMBOL(NU_Setsockopt_TCP_KEEPALIVE_WAIT);
NU_EXPORT_SYMBOL(NU_Setsockopt_TCP_MAX_PROBES);
NU_EXPORT_SYMBOL(NU_Setsockopt_TCP_MAX_R2);
NU_EXPORT_SYMBOL(NU_Setsockopt_TCP_MAX_RTO);
NU_EXPORT_SYMBOL(NU_Setsockopt_TCP_MAX_SYN_R2);
NU_EXPORT_SYMBOL(NU_Setsockopt_TCP_MSL);
NU_EXPORT_SYMBOL(NU_Setsockopt_TCP_PROBE_TIMEOUT);
NU_EXPORT_SYMBOL(NU_Setsockopt_TCP_NODELAY);
NU_EXPORT_SYMBOL(NU_Setsockopt_TCP_RCV_WINDOWSIZE);
NU_EXPORT_SYMBOL(NU_Setsockopt_TCP_TIMESTAMP);
NU_EXPORT_SYMBOL(NU_Setsockopt_UDP_NOCHECKSUM);
NU_EXPORT_SYMBOL(NU_Setsockopt_TCP_WINDOWSCALE);
NU_EXPORT_SYMBOL(NU_Socket_Connected);
NU_EXPORT_SYMBOL(NU_Test_Link_Up);
NU_EXPORT_SYMBOL(NU_Update_DNS_Record);
NU_EXPORT_SYMBOL(NU_Update_Route);
NU_EXPORT_SYMBOL(NU_ZC_Allocate_Buffer);
NU_EXPORT_SYMBOL(NU_ZC_Deallocate_Buffer);
NU_EXPORT_SYMBOL(NU_ZC_Recv);
NU_EXPORT_SYMBOL(NU_ZC_Recv_From);
NU_EXPORT_SYMBOL(UM_Add_User);
NU_EXPORT_SYMBOL(UM_Delete_User_Permissions);
NU_EXPORT_SYMBOL(UM_Find_User);
NU_EXPORT_SYMBOL(UM_Find_User_First);
NU_EXPORT_SYMBOL(UM_Find_User_Next);
NU_EXPORT_SYMBOL(UM_Get_User_Count);
NU_EXPORT_SYMBOL(UM_Validate_User);
NU_EXPORT_SYMBOL(TLS_Put32);

#if (INCLUDE_IPV4 == NU_TRUE)
NU_EXPORT_SYMBOL(NU_Bootp);
NU_EXPORT_SYMBOL(NU_Attach_IP_To_Device);
NU_EXPORT_SYMBOL(NU_Add_Route);
NU_EXPORT_SYMBOL(IP_Time_To_Live);                  /* NU_Get_Default_TTL maps to this. */
NU_EXPORT_SYMBOL(ICMP_Send_Echo_Request);           /* NU_Ping maps to this. */
NU_EXPORT_SYMBOL(SCK_Recv_IF_Addr);                 /* NU_Recv_IF_Addr maps to this. */
NU_EXPORT_SYMBOL(NU_Ioctl_SIOCGIFADDR);
NU_EXPORT_SYMBOL(NU_Ioctl_SIOCGIFNETMASK);
NU_EXPORT_SYMBOL(NU_Ioctl_SIOCGIFDSTADDR);
NU_EXPORT_SYMBOL(NU_Getsockopt_IP_MULTICAST_IF);
NU_EXPORT_SYMBOL(NU_Getsockopt_IP_BROADCAST_IF);
NU_EXPORT_SYMBOL(NU_Getsockopt_IP_MULTICAST_TTL);
NU_EXPORT_SYMBOL(NU_Getsockopt_IP_TTL);
NU_EXPORT_SYMBOL(NU_Setsockopt_IP_MULTICAST_TTL);
NU_EXPORT_SYMBOL(NU_Setsockopt_IP_MULTICAST_IF);
NU_EXPORT_SYMBOL(NU_Setsockopt_IP_BROADCAST_IF);
NU_EXPORT_SYMBOL(NU_Ioctl_SIOCSIFADDR);
NU_EXPORT_SYMBOL(NU_Set_Default_TTL);
#endif

#if ((INCLUDE_IPV4 == NU_TRUE) && (INCLUDE_IP_MULTICASTING == NU_TRUE))
NU_EXPORT_SYMBOL(NU_Setsockopt_IP_ADD_MEMBERSHIP);
NU_EXPORT_SYMBOL(NU_Setsockopt_IP_DROP_MEMBERSHIP);
NU_EXPORT_SYMBOL(NU_IP_Multicast_Listen);
#endif

#if (INCLUDE_IP_FORWARDING == NU_TRUE)
NU_EXPORT_SYMBOL(IP_Forwarding);                    /* NU_Get_IP_Forwarding maps to this. */
#endif

#if ((INCLUDE_IPV4 == NU_TRUE) && (INCLUDE_ARP == NU_TRUE))
NU_EXPORT_SYMBOL(NU_ARP_Update);
NU_EXPORT_SYMBOL(NU_Ioctl_SIOCDARP);
NU_EXPORT_SYMBOL(NU_Ioctl_SIOCGARP);
NU_EXPORT_SYMBOL(NU_Ioctl_SIOCSARP);
#endif

#if (INCLUDE_IPV4 == NU_TRUE) && (INCLUDE_RARP == NU_TRUE)
NU_EXPORT_SYMBOL(ARP_Rarp);                         /* NU_Rarp maps to this. */
#endif

#if (INCLUDE_IPV4 == NU_TRUE) && (INCLUDE_UDP == NU_TRUE)
NU_EXPORT_SYMBOL(NU_Rip2_Initialize);
#endif

#if ((INCLUDE_IPV4 == NU_TRUE) && (INCLUDE_DHCP == NU_TRUE))
NU_EXPORT_SYMBOL(NU_Dhcp);
NU_EXPORT_SYMBOL(NU_Dhcp_Release);
#endif

#if ((INCLUDE_DHCP == NU_TRUE) || (INCLUDE_DHCP6 == NU_TRUE))
NU_EXPORT_SYMBOL(NU_Get_DHCP_DUID);
NU_EXPORT_SYMBOL(NU_Get_DHCP_IAID);
NU_EXPORT_SYMBOL(NU_Set_DHCP_DUID);
NU_EXPORT_SYMBOL(NU_Set_DHCP_IAID);
#endif

#if (INCLUDE_MDNS == NU_TRUE)
NU_EXPORT_SYMBOL(NU_Set_MDNS_Hostname_Callback);
NU_EXPORT_SYMBOL(NU_Start_mDNS_Query);
NU_EXPORT_SYMBOL(NU_Stop_mDNS_Query);
#endif

#endif /* CFG_NU_OS_NET_STACK_EXPORT_SYMBOLS == NU_TRUE */
