/***************************************************************************
*
*           Copyright 1999 Mentor Graphics Corporation
*                         All Rights Reserved.
*
*           THIS WORK CONTAINS TRADE SECRET AND PROPRIETARY
*             INFORMATION WHICH IS THE PROPERTY OF MENTOR
*             GRAPHICS CORPORATION OR ITS LICENSORS AND IS
*                      SUBJECT TO LICENSE TERMS.
*
****************************************************************************

****************************************************************************
*
* FILE NAME                                             
*
*  marin_11.h                                                  
*
* DESCRIPTION
*
*  This file contains the _marin_11FR unicode structure.
*
*  This file was created with MetaWINDOW FontBUILDER v6.1B (50617)
*
* DATA STRUCTURES
*
*  None.
*
* FUNCTIONS
*
*  None.
*
* DEPENDENCIES
*
*  None.
*
***************************************************************************/

#ifndef MARIN_11_H
#define MARIN_11_H

/* -----------------------------------------------------------------------------
 * font name is the starting address of the font header
 */
#define  marin_11  &marin_11FR.marin_11FH


struct  _marin_11FR           /* Font Record Structure */
{
    fontRcd   marin_11FH;           /* font header      */
    char      marin_11FN[     48];  /* font notice      */
    char      marin_11FS[     48];  /* font supplier    */
    char      marin_11FA[     48];  /* font author      */
    char      marin_11FI[     48];  /* font info        */
    char      marin_11FD[     32];  /* font date        */
#ifdef USE_UNICODE
    charMap   marin_11FM[     53];  /* font cmapTable   */
#else
    short     marin_11FM[      8];  /* font cmapTable   */
#endif
    short     marin_11FL[    516];  /* font locTable    */
    ofswid    marin_11FO[    516];  /* font offwidTable */
    grafMap   marin_11FG;           /* font grafMap 2.6 */
    long      marin_11FR[     17];  /* font rowTable    */
unsigned char marin_11FP[   3536];  /* font pixel data  */
}  marin_11FR  =  /* font data follows */

{   /* -------------------------------------------------------------------------
     * fontRcd - font header record structure (offset=0, size=268)
     */
          0x22,   /* fontVer          (000)*/
          0x00,   /* fontRev          (001)*/
          0x05,   /* nameLen          (002)*/
          0x00,   /* pad0             (003)*/
     0x4D,0x61,0x72,0x69,0x6E,0x00,0x00,0x00, /* fontBaseName "Marin"  (004)*/
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* fontSuffix1 ""  (020)*/
        0x0000,   /* pad1             (030)*/
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* fontSuffix2 ""  (032)*/
        0x0000,   /* pad2             (042)*/
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* fontSuffix3 ""  (044)*/
        0x0000,   /* pad3             (054)*/
         0,0,0,   /* pad4[3]          (056)*/
          0x00,   /* fontFacing       (059)*/
     0x4E,0x55,0x5F,0x5F,0x46,0x4F,0x4E,0x54, /* fontSign 'NU__FONT'  (060)*/
            80,   /* fontWeight       (068)*/
             0,   /* fontCoding       (069)*/
        0x0000,   /* pad5             (070)*/
          6848,   /* fontSize         (072)*/
         65534,   /* fontMax =U+FFFE  (076)*/
            30,   /* fontMin =U+001E  (078)*/
            11,   /* fontPtSize       (080)*/
        0x0000,   /* fontfamily       (082)*/
        0x0000,   /* fontStyle        (084)*/
        0x0008,   /* fontFlags        (086)*/
    0xFFFFFFFF,   /* fontColor[0]     (088)*/
    0x00000000,   /* fontColor[1]     (092)*/
            30,   /* minChar          (096)*/
           255,   /* maxChar          (097)*/
             6,   /* chWidth          (098)*/
            17,   /* chHeight         (100)*/
             0,   /* chKern           (102)*/
            14,   /* ascent           (104)*/
             3,   /* descent          (106)*/
            17,   /* lnSpace          (108)*/
            31,   /* chBad            (110)*/
        0,   0,   /* chCenter         (112)*/
          -200,   /* chAngle          (116)*/
             1,   /* chUnder          (118)*/
             1,   /* chScore          (120)*/
           515,   /* numGlyphs        (122)*/
           916,   /* locTbl           (124)*/
          1948,   /* ofwdTbl          (128)*/
             0,   /* kernTbl          (132)*/
             0,   /* sizeTbl          (136)*/
          2980,   /* grafMapTbl       (140)*/
          3244,   /* rowTbl           (144)*/
          3312,   /* fontTbl          (148)*/
           268,   /* fontNotice       (152)*/
           316,   /* fontSupplier     (156)*/
           364,   /* fontAuthor       (160)*/
           412,   /* fontInfo         (164)*/
           460,   /* fontDate         (168)*/
       17,   0,   /* fontSpacing      (172)*/
       14,   0,   /* fontLowHgt       (176)*/
       14,   0,   /* fontCapHgt       (180)*/
       14,   0,   /* fontAscent       (184)*/
        3,   0,   /* fontDescent      (188)*/
       15,   0,   /* fontMaxWid,U+004D(192)*/
        6,   0,   /* fontAvgWid       (196)*/
       16,   0,   /* fontEmWid        (200)*/
#ifdef USE_UNICODE
             1,   /* numCRows =0x0001 (204)*/
            52,   /* numCMaps =0x0034 (206)*/
           492,   /* cmapTbl          (208)*/
     0,0,0,0,0,0,0,0,0,0,0,0,0,0, /* offwidTbl[14]  (212)*/
#else
 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0, /* offwidTbl[16]  (204)*/
#endif

    /* -------------------------------------------------------------------------
     * fontNotice[48] = ""  (offset=268, size=48)
     */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

    /* -------------------------------------------------------------------------
     * fontSupplier[48] = ""  (offset=316, size=48)
     */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

    /* -------------------------------------------------------------------------
     * fontAuthor[48] = ""  (offset=364, size=48)
     */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

    /* -------------------------------------------------------------------------
     * fontInfo[48] = "FontBUILDER v6.1B (50617)"  (offset=412, size=48)
     */
    0x46,0x6F,0x6E,0x74,0x42,0x55,0x49,0x4C,0x44,0x45,0x52,0x20,0x76,0x36,0x2E,0x31,
    0x42,0x20,0x28,0x35,0x30,0x36,0x31,0x37,0x29,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

    /* -------------------------------------------------------------------------
     * fontDate[32] = "08/01/06 13:31:39"  (offset=460, size=32)
     */
    0x30,0x38,0x2F,0x30,0x31,0x2F,0x30,0x36,0x20,0x31,0x33,0x3A,0x33,0x31,0x3A,0x33,
    0x39,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

    /* -------------------------------------------------------------------------
     * cmapTbl[53] - Unicode character mapping table  (offset=492, size=424)
     */
    /* charStart,    charEnd, glyphStart,   glyphRow */ /*    (numCMaps= 52)   */
          0x001E,     0x0107,     0x0000,     0x0000,   /* cmapTbl[  0]   (492)*/
          0x010C,     0x0111,     0x00EA,     0x0000,   /* cmapTbl[  1]   (500)*/
          0x0118,     0x011F,     0x00F0,     0x0000,   /* cmapTbl[  2]   (508)*/
          0x0130,     0x0131,     0x00F8,     0x0000,   /* cmapTbl[  3]   (516)*/
          0x0139,     0x0148,     0x00FA,     0x0000,   /* cmapTbl[  4]   (524)*/
          0x0150,     0x0165,     0x010A,     0x0000,   /* cmapTbl[  5]   (532)*/
          0x016E,     0x0171,     0x0120,     0x0000,   /* cmapTbl[  6]   (540)*/
          0x0178,     0x017E,     0x0124,     0x0000,   /* cmapTbl[  7]   (548)*/
          0x0192,     0x0192,     0x012B,     0x0000,   /* cmapTbl[  8]   (556)*/
          0x02BA,     0x02BA,     0x012C,     0x0000,   /* cmapTbl[  9]   (564)*/
          0x02C6,     0x02C9,     0x012D,     0x0000,   /* cmapTbl[ 10]   (572)*/
          0x02D8,     0x02DC,     0x0131,     0x0000,   /* cmapTbl[ 11]   (580)*/
          0x0393,     0x0393,     0x0136,     0x0000,   /* cmapTbl[ 12]   (588)*/
          0x0398,     0x0398,     0x0137,     0x0000,   /* cmapTbl[ 13]   (596)*/
          0x03A3,     0x03A9,     0x0138,     0x0000,   /* cmapTbl[ 14]   (604)*/
          0x03B1,     0x03B5,     0x013F,     0x0000,   /* cmapTbl[ 15]   (612)*/
          0x03C0,     0x03C6,     0x0144,     0x0000,   /* cmapTbl[ 16]   (620)*/
          0x2013,     0x2026,     0x014B,     0x0000,   /* cmapTbl[ 17]   (628)*/
          0x2030,     0x2030,     0x015F,     0x0000,   /* cmapTbl[ 18]   (636)*/
          0x2039,     0x203C,     0x0160,     0x0000,   /* cmapTbl[ 19]   (644)*/
          0x207F,     0x207F,     0x0164,     0x0000,   /* cmapTbl[ 20]   (652)*/
          0x20A3,     0x20A7,     0x0165,     0x0000,   /* cmapTbl[ 21]   (660)*/
          0x2122,     0x2122,     0x016A,     0x0000,   /* cmapTbl[ 22]   (668)*/
          0x2190,     0x2195,     0x016B,     0x0000,   /* cmapTbl[ 23]   (676)*/
          0x21A8,     0x21A8,     0x0171,     0x0000,   /* cmapTbl[ 24]   (684)*/
          0x2202,     0x2206,     0x0172,     0x0000,   /* cmapTbl[ 25]   (692)*/
          0x220F,     0x221F,     0x0177,     0x0000,   /* cmapTbl[ 26]   (700)*/
          0x2229,     0x222B,     0x0188,     0x0000,   /* cmapTbl[ 27]   (708)*/
          0x2248,     0x2248,     0x018B,     0x0000,   /* cmapTbl[ 28]   (716)*/
          0x2260,     0x2265,     0x018C,     0x0000,   /* cmapTbl[ 29]   (724)*/
          0x2302,     0x2302,     0x0192,     0x0000,   /* cmapTbl[ 30]   (732)*/
          0x2310,     0x2310,     0x0193,     0x0000,   /* cmapTbl[ 31]   (740)*/
          0x2320,     0x2321,     0x0194,     0x0000,   /* cmapTbl[ 32]   (748)*/
          0x2500,     0x2502,     0x0196,     0x0000,   /* cmapTbl[ 33]   (756)*/
          0x250C,     0x251C,     0x0199,     0x0000,   /* cmapTbl[ 34]   (764)*/
          0x2524,     0x2524,     0x01AA,     0x0000,   /* cmapTbl[ 35]   (772)*/
          0x252C,     0x252C,     0x01AB,     0x0000,   /* cmapTbl[ 36]   (780)*/
          0x2534,     0x2534,     0x01AC,     0x0000,   /* cmapTbl[ 37]   (788)*/
          0x253C,     0x253C,     0x01AD,     0x0000,   /* cmapTbl[ 38]   (796)*/
          0x2550,     0x256C,     0x01AE,     0x0000,   /* cmapTbl[ 39]   (804)*/
          0x2580,     0x2593,     0x01CB,     0x0000,   /* cmapTbl[ 40]   (812)*/
          0x25A0,     0x25A0,     0x01DF,     0x0000,   /* cmapTbl[ 41]   (820)*/
          0x25AC,     0x25AC,     0x01E0,     0x0000,   /* cmapTbl[ 42]   (828)*/
          0x25B2,     0x25B2,     0x01E1,     0x0000,   /* cmapTbl[ 43]   (836)*/
          0x25BA,     0x25BC,     0x01E2,     0x0000,   /* cmapTbl[ 44]   (844)*/
          0x25C4,     0x25C4,     0x01E5,     0x0000,   /* cmapTbl[ 45]   (852)*/
          0x25CA,     0x25CB,     0x01E6,     0x0000,   /* cmapTbl[ 46]   (860)*/
          0x25D8,     0x25D9,     0x01E8,     0x0000,   /* cmapTbl[ 47]   (868)*/
          0x263A,     0x2642,     0x01EA,     0x0000,   /* cmapTbl[ 48]   (876)*/
          0x2660,     0x266B,     0x01F3,     0x0000,   /* cmapTbl[ 49]   (884)*/
          0xF000,     0xF002,     0x01FF,     0x0000,   /* cmapTbl[ 50]   (892)*/
          0xFFFE,     0xFFFE,     0x0202,     0x0000,   /* cmapTbl[ 51]   (900)*/
                                                        /* (ending NULL record)*/
          0x0000,     0x0000,     0x0000,     0x0000,   /* cmapTbl[ 52]   (908)*/


    /* -------------------------------------------------------------------------
     * locTbl[516] - location table  (offset=916, size=1032)
     */
    0x0000,0x0004,0x0008,0x0009,0x000B,0x000F,0x0019,0x001F,0x002B,0x0036,  /* 0-9 */
    0x0038,0x003C,0x0040,0x0045,0x004D,0x004F,0x0053,0x0055,0x0059,0x0060,  /* 10-19 */
    0x0065,0x006C,0x0072,0x0078,0x007E,0x0084,0x008A,0x0090,0x0096,0x0098,  /* 20-29 */
    0x009A,0x00A2,0x00AA,0x00B2,0x00B7,0x00C4,0x00CF,0x00D8,0x00E2,0x00EE,  /* 30-39 */
    0x00F6,0x00FE,0x0109,0x0113,0x0118,0x011D,0x0129,0x0133,0x0142,0x014E,  /* 40-49 */
    0x0158,0x0160,0x016A,0x0174,0x017B,0x0185,0x0191,0x019C,0x01AB,0x01B6,  /* 50-59 */
    0x01C1,0x01CB,0x01CE,0x01D2,0x01D5,0x01DC,0x01E4,0x01E6,0x01EC,0x01F4,  /* 60-69 */
    0x01FA,0x0201,0x0207,0x020D,0x0214,0x021C,0x021F,0x0223,0x022A,0x022D,  /* 70-79 */
    0x0239,0x0241,0x0248,0x024F,0x0256,0x025B,0x0260,0x0264,0x026B,0x0272,  /* 80-89 */
    0x027D,0x0284,0x028B,0x0291,0x0295,0x0296,0x029B,0x02A3,0x02A3,0x02A3,  /* 90-99 */
    0x02A3,0x02A3,0x02A3,0x02A3,0x02A3,0x02A3,0x02A3,0x02A3,0x02A3,0x02A3,  /* 100-109 */
    0x02A3,0x02A3,0x02A3,0x02A3,0x02A3,0x02A3,0x02A3,0x02A3,0x02A3,0x02A3,  /* 110-119 */
    0x02A3,0x02A3,0x02A3,0x02A3,0x02A3,0x02A3,0x02A3,0x02A3,0x02A3,0x02A3,  /* 120-129 */
    0x02A3,0x02A4,0x02A6,0x02AC,0x02B3,0x02B9,0x02C0,0x02C1,0x02C7,0x02C8,  /* 130-139 */
    0x02D2,0x02D7,0x02DE,0x02DF,0x02E3,0x02ED,0x02EE,0x02EF,0x02F0,0x02F1,  /* 140-149 */
    0x02F2,0x02F4,0x02F5,0x02FC,0x02FD,0x0300,0x0301,0x0306,0x030D,0x030E,  /* 150-159 */
    0x030F,0x0310,0x0315,0x0320,0x032B,0x0336,0x0341,0x034C,0x0357,0x0365,  /* 160-169 */
    0x036F,0x0378,0x0381,0x038A,0x0393,0x0398,0x039D,0x03A2,0x03A7,0x03A8,  /* 170-179 */
    0x03B4,0x03BE,0x03C8,0x03D2,0x03DC,0x03E6,0x03E7,0x03F1,0x03FD,0x0409,  /* 180-189 */
    0x0415,0x0421,0x0422,0x0423,0x042A,0x0430,0x0436,0x043C,0x0442,0x0448,  /* 190-199 */
    0x044E,0x0456,0x045C,0x0462,0x0468,0x046E,0x0474,0x0477,0x047A,0x047E,  /* 200-209 */
    0x0482,0x0483,0x048B,0x0492,0x0499,0x04A0,0x04A7,0x04AE,0x04AF,0x04B6,  /* 210-219 */
    0x04BD,0x04C4,0x04CB,0x04D2,0x04D3,0x04D4,0x04DB,0x04DB,0x04DB,0x04DC,  /* 220-229 */
    0x04DD,0x04DE,0x04DF,0x04E0,0x04E1,0x04E2,0x04E3,0x04E4,0x04E5,0x04E6,  /* 230-239 */
    0x04E7,0x04E8,0x04E9,0x04EA,0x04EB,0x04EB,0x04EB,0x04EC,0x04ED,0x04EE,  /* 240-249 */
    0x04F1,0x04F2,0x04F3,0x04F3,0x04F3,0x04F4,0x04F5,0x04F6,0x04F7,0x04F8,  /* 250-259 */
    0x04F9,0x04FA,0x04FB,0x04FB,0x04FB,0x04FC,0x04FD,0x04FE,0x04FF,0x050C,  /* 260-269 */
    0x0515,0x0516,0x0517,0x0517,0x0517,0x0518,0x0519,0x051A,0x051B,0x051B,  /* 270-279 */
    0x051B,0x051C,0x051D,0x0524,0x0529,0x052A,0x052B,0x052C,0x052D,0x052E,  /* 280-289 */
    0x052F,0x0530,0x0531,0x053D,0x053E,0x053F,0x0540,0x0541,0x0542,0x0543,  /* 290-299 */
    0x054A,0x054E,0x0553,0x0557,0x0557,0x055C,0x0560,0x0562,0x0565,0x0568,  /* 300-309 */
    0x056C,0x056D,0x056E,0x056F,0x056F,0x056F,0x0570,0x0570,0x0570,0x0571,  /* 310-319 */
    0x0572,0x0572,0x0572,0x0573,0x0574,0x0575,0x0575,0x0575,0x0576,0x0577,  /* 320-329 */
    0x0577,0x0578,0x0580,0x058F,0x058F,0x058F,0x0590,0x0592,0x0595,0x0596,  /* 330-339 */
    0x0596,0x059C,0x05A2,0x05A7,0x05A7,0x05AD,0x05B3,0x05B7,0x05B7,0x05B7,  /* 340-349 */
    0x05B7,0x05BF,0x05CE,0x05D2,0x05D6,0x05D6,0x05D7,0x05D8,0x05D9,0x05D9,  /* 350-359 */
    0x05D9,0x05D9,0x05DA,0x05E8,0x05E9,0x05EA,0x05F3,0x05F4,0x05F5,0x05F6,  /* 360-369 */
    0x05F7,0x05F8,0x05F8,0x05F8,0x05F8,0x05F9,0x05FA,0x05FA,0x05FA,0x05FB,  /* 370-379 */
    0x05FB,0x05FB,0x0609,0x0609,0x0609,0x0609,0x060B,0x060C,0x060C,0x060C,  /* 380-389 */
    0x060C,0x060D,0x060E,0x060F,0x060F,0x0610,0x0611,0x0612,0x0613,0x0613,  /* 390-399 */
    0x0613,0x0614,0x0615,0x061F,0x0620,0x0621,0x0622,0x0623,0x0623,0x0624,  /* 400-409 */
    0x0625,0x0625,0x0625,0x0625,0x0626,0x0626,0x0626,0x0626,0x0627,0x0627,  /* 410-419 */
    0x0627,0x0627,0x0628,0x0628,0x0628,0x0628,0x0629,0x062A,0x062B,0x062C,  /* 420-429 */
    0x062D,0x062E,0x062F,0x0630,0x0631,0x0632,0x0633,0x0634,0x0635,0x0636,  /* 430-439 */
    0x0637,0x0638,0x0639,0x063A,0x063B,0x063C,0x063D,0x063E,0x063F,0x0640,  /* 440-449 */
    0x0641,0x0642,0x0643,0x0644,0x0645,0x0646,0x0647,0x0648,0x0649,0x064A,  /* 450-459 */
    0x064B,0x064B,0x064B,0x064B,0x064C,0x064C,0x064C,0x064C,0x064D,0x064D,  /* 460-469 */
    0x064D,0x064D,0x064E,0x064E,0x064E,0x064E,0x064F,0x0650,0x0651,0x0652,  /* 470-479 */
    0x065C,0x065D,0x065E,0x065F,0x065F,0x0660,0x0661,0x0662,0x0663,0x0664,  /* 480-489 */
    0x0665,0x0666,0x0667,0x0668,0x0668,0x0668,0x0668,0x0669,0x0669,0x066A,  /* 490-499 */
    0x066B,0x066B,0x066B,0x066C,0x066C,0x066D,0x066E,0x066E,0x066E,0x066E,  /* 500-509 */
    0x066F,0x0670,0x0671,0x0672,0x0673,0x0677,  /* 510-515 */

    /* -------------------------------------------------------------------------
     * ofwdTbl[516] - offset/width table {.wid,.ofs}  (offset=1948, size=1032)
     */
      4,-1,   4,-1,   4,0,    4,1,    6,1,   10,0,    7,1,   12,0,   12,0,    4,1,  /* 0-9 */
      5,1,    5,0,    7,1,   10,1,    4,1,    5,1,    4,1,    4,0,    7,0,    7,1,  /* 10-19 */
      7,0,    7,1,    7,1,    7,1,    7,1,    7,1,    7,1,    7,1,    4,1,    4,1,  /* 20-29 */
     10,1,   10,1,   10,1,    6,0,   14,1,   12,0,   10,0,   11,1,   12,0,   10,1,  /* 30-39 */
     10,1,   12,1,   12,1,    6,0,    7,1,   12,0,   10,0,   15,0,   12,0,   12,1,  /* 40-49 */
      9,1,   12,1,   12,1,    8,1,   10,0,   12,0,   11,0,   15,0,   12,0,   12,0,  /* 50-59 */
     10,0,    4,1,    4,0,    4,0,    7,0,    7,0,    4,1,    7,1,    8,0,    7,0,  /* 60-69 */
      8,1,    7,0,    5,1,    7,0,    8,0,    4,1,    4,-1,   8,1,    4,1,   12,0,  /* 70-79 */
      8,0,    8,1,    8,1,    8,1,    6,1,    6,0,    5,1,    8,1,    7,0,   11,0,  /* 80-89 */
      7,0,    7,0,    7,0,    7,2,    3,1,    7,1,    8,0,  255,-1, 255,-1, 255,-1, /* 90-99 */
    255,-1, 255,-1, 255,-1, 255,-1, 255,-1, 255,-1, 255,-1, 255,-1, 255,-1, 255,-1, /* 100-109 */
    255,-1, 255,-1, 255,-1, 255,-1, 255,-1, 255,-1, 255,-1, 255,-1, 255,-1, 255,-1, /* 110-119 */
    255,-1, 255,-1, 255,-1, 255,-1, 255,-1, 255,-1, 255,-1, 255,-1, 255,-1, 255,-1, /* 120-129 */
      4,0,    4,1,    7,0,    7,0,    7,1,    7,0,    4,0,    6,0,    4,0,   11,1,  /* 130-139 */
      5,0,    7,0,    4,0,    7,1,   11,1,    4,0,    4,0,    4,0,    4,0,    4,0,  /* 140-149 */
      7,3,    4,0,    7,0,    4,0,   11,4,    4,0,    5,0,    7,0,    4,0,    4,0,  /* 150-159 */
      4,0,    6,0,   12,0,   12,0,   12,0,   12,0,   12,0,   12,0,   15,1,   11,1,  /* 160-169 */
     10,1,   10,1,   10,1,   10,1,    6,0,    6,0,    6,0,    6,0,    4,0,   12,0,  /* 170-179 */
     12,1,   12,1,   12,1,   12,1,   12,1,    4,0,   12,1,   12,0,   12,0,   12,0,  /* 180-189 */
     12,0,    4,0,    4,0,    8,1,    7,1,    7,1,    7,1,    7,1,    7,1,    7,1,  /* 190-199 */
     10,1,    7,0,    7,0,    7,0,    7,0,    7,0,    4,0,    4,1,    4,0,    4,0,  /* 200-209 */
      4,0,    8,0,    8,1,    8,1,    8,1,    8,1,    8,1,    4,0,    8,1,    8,1,  /* 210-219 */
      8,1,    8,1,    8,1,    4,0,    4,0,    7,0,  255,-1, 255,-1,   4,0,    4,0,  /* 220-229 */
      4,0,    4,0,    4,0,    4,0,    4,0,    4,0,    4,0,    4,0,    4,0,    4,0,  /* 230-239 */
      4,0,    4,0,    4,0,    4,0,  255,-1, 255,-1,   4,0,    4,0,    4,0,    4,1,  /* 240-249 */
      4,0,    4,0,  255,-1, 255,-1,   4,0,    4,0,    4,0,    4,0,    4,0,    4,0,  /* 250-259 */
      4,0,    4,0,  255,-1, 255,-1,   4,0,    4,0,    4,0,    4,0,   15,1,   11,1,  /* 260-269 */
      4,0,    4,0,  255,-1, 255,-1,   4,0,    4,0,    4,0,    4,0,  255,-1, 255,-1, /* 270-279 */
      4,0,    4,0,    8,1,    6,0,    4,0,    4,0,    4,0,    4,0,    4,0,    4,0,  /* 280-289 */
      4,0,    4,0,   12,0,    4,0,    4,0,    4,0,    4,0,    4,0,    4,0,    7,0,  /* 290-299 */
      7,3,    8,2,    6,1,  255,-1,   7,2,    6,1,    4,1,    7,2,   11,4,    7,2,  /* 300-309 */
      4,0,    4,0,    4,0,  255,-1, 255,-1,   4,0,  255,-1, 255,-1,   4,0,    4,0,  /* 310-319 */
    255,-1, 255,-1,   4,0,    4,0,    4,0,  255,-1, 255,-1,   4,0,    4,0,  255,-1, /* 320-329 */
      4,0,    7,0,   15,0,  255,-1, 255,-1,   4,0,    9,0,    7,2,    4,0,  255,-1, /* 330-339 */
      7,1,    7,1,    7,1,  255,-1,   7,1,    7,1,    5,1,  255,-1, 255,-1, 255,-1, /* 340-349 */
      9,1,   15,0,    4,0,    4,0,  255,-1,   4,0,    4,0,    4,0,  255,-1, 255,-1, /* 350-359 */
    255,-1,   4,0,   15,0,    4,0,    4,0,   11,1,    4,0,    4,0,    4,0,    4,0,  /* 360-369 */
      4,0,  255,-1, 255,-1, 255,-1,   4,0,    4,0,  255,-1, 255,-1,   4,0,  255,-1, /* 370-379 */
    255,-1,  15,0,  255,-1, 255,-1, 255,-1,   7,4,    4,0,  255,-1, 255,-1, 255,-1, /* 380-389 */
      4,0,    4,0,    4,0,  255,-1,   4,0,    4,0,    4,0,    4,0,  255,-1, 255,-1, /* 390-399 */
      4,0,    4,0,   12,1,    4,0,    4,0,    4,0,    4,0,  255,-1,   4,0,    4,0,  /* 400-409 */
    255,-1, 255,-1, 255,-1,   4,0,  255,-1, 255,-1, 255,-1,   4,0,  255,-1, 255,-1, /* 410-419 */
    255,-1,   4,0,  255,-1, 255,-1, 255,-1,   4,0,    4,0,    4,0,    4,0,    4,0,  /* 420-429 */
      4,0,    4,0,    4,0,    4,0,    4,0,    4,0,    4,0,    4,0,    4,0,    4,0,  /* 430-439 */
      4,0,    4,0,    4,0,    4,0,    4,0,    4,0,    4,0,    4,0,    4,0,    4,0,  /* 440-449 */
      4,0,    4,0,    4,0,    4,0,    4,0,    4,0,    4,0,    4,0,    4,0,    4,0,  /* 450-459 */
    255,-1, 255,-1, 255,-1,   4,0,  255,-1, 255,-1, 255,-1,   4,0,  255,-1, 255,-1, /* 460-469 */
    255,-1,   4,0,  255,-1, 255,-1, 255,-1,   4,0,    4,0,    4,0,    4,0,   13,2,  /* 470-479 */
      4,0,    4,0,    4,0,  255,-1,   4,0,    4,0,    4,0,    4,0,    4,0,    4,0,  /* 480-489 */
      4,0,    4,0,    4,0,  255,-1, 255,-1, 255,-1,   4,0,  255,-1,   4,0,    4,0,  /* 490-499 */
    255,-1, 255,-1,   4,0,  255,-1,   4,0,    4,0,  255,-1, 255,-1, 255,-1,   4,0,  /* 500-509 */
      4,0,    4,0,    4,0,    4,0,    4,-1, 255,-1, /* 510-515 */

    /* -------------------------------------------------------------------------
     * grafMap - graphics bitmap structure  (offset=2980, size=264)
     */
             0,   /* devClass         (000)*/
             0,   /* devTech          (002)*/
             0,   /* devMode          (004)*/
             0,   /* pad1             (008)*/
           208,   /* pixBytes         (010)*/
          1655,   /* pixWidth         (012)*/
            17,   /* pixHeight        (016)*/
            96,   /* pixResX          (020)*/
            96,   /* pixResY          (022)*/
             1,   /* pixBits          (024)*/
             1,   /* pixPlanes        (026)*/
          0x00,   /* mapFlags         (028)*/
             0,   /* pad2             (030)*/
     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  /* mapTable[32]  (032)*/
     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,
             0,   /* mapLock          (160)*/
             0,   /* mapNextSel       (162)*/
             0,   /* mapWinType       (164)*/
             0,   /* mapWinOffset     (168)*/
        0,   0,   /* mapWinYmin[2]    (172)*/
        0,   0,   /* mapWinYmax[2]    (180)*/
             0,   /* mapWinPlane      (188)*/
             0,   /* mapWinScans      (192)*/
             0,   /* mapHandle        (196)*/
             0,   /* mapBankMgr       (200)*/
             0,   /* mapPlaneMgr      (204)*/
             0,   /* mapAltMgr        (208)*/
             0,   /* devMgr           (212)*/
             0,   /* prFill           (216)*/
             0,   /* prBlitSS         (220)*/
             0,   /* prBlit1S         (224)*/
             0,   /* prBlitMS         (228)*/
             0,   /* prBlitSM         (232)*/
             0,   /* prRdImg          (236)*/
             0,   /* prWrImg          (240)*/
             0,   /* prLine           (244)*/
             0,   /* prSetPx          (248)*/
             0,   /* prGetPx          (252)*/
             0,   /* cbSyncFunc       (256)*/
             0,   /* cbPostErr        (260)*/


    /* -------------------------------------------------------------------------
     * rowTable[17] - raster line pointers  (offset=3244, size=68)
     * (these pointer values are initialized when the font is opened)
     */
     0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,  /* 0-16 */

    /* -------------------------------------------------------------------------
     * fontTbl[3536] - font pixel data  (offset=3312, size=3536)
     */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 0-15 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 16-31 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 32-47 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 48-63 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 64-79 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 80-95 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x00,0x00,0x00,0x00,0x00,  /* 96-111 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 112-127 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 128-143 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 144-159 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 160-175 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 176-191 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 192-207 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 208-223 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 224-239 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 240-255 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 256-271 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 272-287 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 288-303 */
    0x00,0x00,0x00,0x60,0x02,0x00,0xC0,0x34,0x07,0x80,0xA0,0x00,0x00,0x00,0x60,0x0C,  /* 304-319 */
    0x0C,0x0F,0x0C,0x19,0x9E,0x0E,0x81,0x80,0x10,0x0C,0x0E,0x81,0xE0,0x00,0x02,0x00,  /* 320-335 */
    0x18,0x03,0x00,0x78,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 336-351 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 352-367 */
    0x00,0x00,0x00,0x03,0x40,0x00,0x07,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 368-383 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 384-399 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 400-415 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 416-431 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 432-447 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 448-463 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 464-479 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 480-495 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 496-511 */
    0x00,0x00,0x00,0x20,0x04,0x01,0x40,0xDC,0x04,0x80,0xE0,0x00,0x00,0x00,0x10,0x10,  /* 512-527 */
    0x12,0x09,0x04,0x22,0x92,0x13,0x00,0x80,0x20,0x14,0x13,0x01,0x20,0x00,0x01,0x00,  /* 528-543 */
    0x20,0x04,0x80,0x48,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 544-559 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 560-575 */
    0x00,0x00,0x00,0x01,0x80,0x00,0x04,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 576-591 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 592-607 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 608-623 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 624-639 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 640-655 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 656-671 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,  /* 672-687 */
    0x00,0x20,0x04,0x04,0x28,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 688-703 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 704-719 */
    0x00,0x00,0x00,0x20,0x08,0x02,0x20,0x88,0x00,0x00,0x40,0x00,0x00,0x00,0x00,0x00,  /* 720-735 */
    0x00,0x00,0x02,0x00,0x40,0x00,0x00,0x40,0x00,0x22,0x11,0x00,0x00,0x00,0x00,0x00,  /* 736-751 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x00,0x00,0x00,  /* 752-767 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 768-783 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,  /* 784-799 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 800-815 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 816-831 */
    0x00,0x72,0x11,0x3D,0xE0,0x81,0xC3,0x38,0xA8,0x00,0x00,0x9C,0x23,0xC7,0x02,0x3C,  /* 832-847 */
    0x77,0xDC,0x70,0x00,0x00,0x00,0x1C,0x1F,0x00,0x40,0xFC,0x1F,0xBF,0xE3,0xFB,0xFC,  /* 848-863 */
    0x7E,0x79,0xFF,0x7F,0xCF,0x7C,0x0E,0x03,0xF8,0x1C,0x78,0xFC,0x1E,0x3F,0x07,0xDF,  /* 864-879 */
    0xFF,0xC7,0xFC,0xFF,0x78,0xFF,0x3F,0xE3,0xBF,0xFE,0x38,0x80,0x0C,0x0C,0x00,0x01,  /* 880-895 */
    0x00,0xD8,0x0C,0x04,0x78,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 896-911 */
    0x00,0x00,0x1F,0x00,0x00,0x21,0xE0,0x77,0x3C,0x1E,0x3C,0x00,0x03,0xC0,0x13,0xF0,  /* 912-927 */
    0x38,0x00,0x00,0x30,0x04,0x00,0x80,0x10,0x02,0x00,0x40,0x1F,0xF0,0xFD,0xFE,0xFF,  /* 928-943 */
    0x7F,0xBF,0xDF,0xFF,0xBE,0xE0,0x71,0xE0,0x78,0x1E,0x07,0x81,0xE0,0x7E,0xFC,0x7F,  /* 944-959 */
    0xC7,0xFC,0x7F,0xC7,0x8F,0x18,0x10,0xCE,0x9E,0x50,0x00,0x02,0x06,0x31,0xEC,0xDB,  /* 960-975 */
    0xC7,0x4C,0x06,0x18,0x68,0xF0,0x01,0x80,0xC3,0x0F,0x02,0xC0,0x00,0x00,0x00,0x00,  /* 976-991 */
    0x3F,0xF0,0x00,0x03,0xE4,0x80,0x7C,0x70,0x01,0xEF,0xB2,0x09,0xE8,0x60,0x00,0x00,  /* 992-1007 */
    0x00,0x00,0xF3,0x7E,0xC0,0x60,0x80,0x01,0xC3,0x00,0x00,0x3F,0x63,0x00,0x00,0x00,  /* 1008-1023 */
    0xFF,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0xF0,0x00,0x00,0x00,0x00,  /* 1024-1039 */
    0x00,0x72,0x11,0x65,0x21,0x02,0x41,0x24,0xF8,0x00,0x00,0xA2,0xE4,0x69,0x8E,0x41,  /* 1040-1055 */
    0x88,0x62,0x88,0x00,0x00,0x00,0x26,0x60,0xC0,0x40,0x62,0x20,0x8C,0x39,0x09,0x84,  /* 1056-1071 */
    0x82,0x30,0xC6,0x31,0x88,0x18,0x06,0x03,0x0C,0x09,0x86,0x63,0x61,0x98,0x88,0x51,  /* 1072-1087 */
    0x89,0x82,0x18,0x46,0x30,0x46,0x30,0xC2,0x21,0x92,0x09,0x40,0x0C,0x04,0x00,0x03,  /* 1088-1103 */
    0x00,0x80,0x04,0x00,0x08,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x00,0x00,0x00,  /* 1104-1119 */
    0x00,0x00,0x24,0x80,0x00,0x22,0x20,0x32,0x24,0x61,0x9C,0x00,0x0C,0x30,0x27,0xA0,  /* 1120-1135 */
    0x44,0x00,0x00,0x60,0x0C,0x01,0x80,0x10,0x06,0x00,0x40,0x0E,0x11,0x04,0xC2,0x61,  /* 1136-1151 */
    0x30,0x98,0x46,0x31,0x8C,0x30,0x26,0x19,0x86,0x61,0x98,0x66,0x18,0xC1,0x18,0x21,  /* 1152-1167 */
    0x82,0x18,0x21,0x82,0x18,0x88,0x21,0x4B,0x12,0x58,0x00,0x01,0x04,0x51,0x25,0x26,  /* 1168-1183 */
    0x49,0x82,0x08,0x24,0x98,0x90,0x00,0x41,0x04,0x89,0x02,0x40,0x00,0x00,0x00,0x00,  /* 1184-1199 */
    0xC6,0x10,0x00,0x04,0x23,0x00,0x18,0x20,0x01,0x2A,0xCD,0xFE,0x38,0xB0,0x00,0x00,  /* 1200-1215 */
    0x00,0x00,0x53,0x64,0x40,0x60,0x80,0x01,0x22,0x00,0x00,0x0D,0x67,0x00,0x00,0x00,  /* 1216-1231 */
    0xB0,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x10,0x00,0x00,0x00,0x00,  /* 1232-1247 */
    0x00,0x72,0x22,0x61,0x22,0x03,0x42,0x42,0xF0,0x80,0x01,0x63,0x20,0x20,0x8A,0x41,  /* 1248-1263 */
    0x00,0xA2,0x84,0x00,0x40,0x20,0x22,0x80,0x40,0xE0,0x63,0x40,0x4C,0x19,0x05,0x81,  /* 1264-1279 */
    0x01,0x30,0xC6,0x31,0x90,0x18,0x07,0x07,0x0E,0x09,0x02,0x63,0x40,0x98,0xCC,0x41,  /* 1280-1295 */
    0x81,0x82,0x18,0x42,0x18,0x83,0x60,0x62,0x41,0x92,0x09,0x40,0x0C,0x04,0x00,0x01,  /* 1296-1311 */
    0x00,0x80,0x04,0x00,0x08,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x00,0x00,0x00,  /* 1312-1327 */
    0x00,0x00,0x24,0x80,0x0C,0x42,0x1F,0xFF,0x30,0x9E,0xA4,0x00,0x13,0xD0,0x27,0xA0,  /* 1328-1343 */
    0x44,0x00,0x30,0x70,0x0E,0x01,0xC0,0x38,0x07,0x00,0xE0,0x16,0x02,0x02,0xC0,0x60,  /* 1344-1359 */
    0x30,0x18,0x06,0x31,0x8C,0x38,0x24,0x09,0x02,0x40,0x90,0x24,0x08,0x87,0x18,0x21,  /* 1360-1375 */
    0x82,0x18,0x21,0x82,0x18,0x84,0x40,0x20,0x00,0x20,0x00,0x01,0x08,0x08,0x03,0x00,  /* 1376-1391 */
    0x00,0x02,0x08,0x00,0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 1392-1407 */
    0x86,0x00,0x00,0x06,0x20,0x00,0x0C,0x40,0x01,0x30,0x00,0x00,0x00,0x00,0x00,0x00,  /* 1408-1423 */
    0x00,0x00,0x8B,0x3C,0x81,0xCF,0x60,0x01,0x24,0x00,0x00,0x0C,0x7B,0x00,0x00,0x00,  /* 1424-1439 */
    0xB0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x10,0x00,0x00,0x00,0x00,  /* 1440-1455 */
    0x33,0x33,0xFF,0xE1,0x22,0x03,0x9C,0x42,0xA8,0x80,0x01,0x63,0x20,0x21,0x12,0x7A,  /* 1456-1471 */
    0xE0,0x92,0x87,0xC1,0xBF,0xD8,0x02,0x8F,0x21,0x60,0x63,0xC0,0x0C,0x0D,0x09,0x8B,  /* 1472-1487 */
    0x00,0x30,0xC6,0x31,0xA0,0x18,0x05,0x07,0x0B,0x0B,0x03,0x63,0xC0,0xD8,0xCE,0x01,  /* 1488-1503 */
    0x81,0x82,0x08,0x43,0x18,0x81,0xC0,0x64,0x03,0x12,0x0A,0x20,0x03,0xE5,0xE3,0x8F,  /* 1504-1519 */
    0x3D,0xE1,0xF5,0xE4,0x69,0x92,0xE6,0x2F,0x1C,0xDC,0x79,0x6F,0xEC,0xDC,0xFB,0x9F,  /* 1520-1535 */
    0x7E,0x6F,0xA4,0x80,0x05,0xA2,0x10,0x94,0x18,0xE0,0x7E,0x64,0x12,0x48,0x07,0xA0,  /* 1536-1551 */
    0x3A,0x20,0x30,0x50,0x0A,0x01,0x40,0x28,0x05,0x00,0xA0,0x16,0x26,0x00,0xC4,0x62,  /* 1552-1567 */
    0x31,0x18,0x86,0x31,0x8C,0x2C,0x2C,0x0F,0x03,0xC0,0xF0,0x3C,0x0D,0x89,0x98,0x21,  /* 1568-1583 */
    0x82,0x18,0x21,0x82,0x19,0xBA,0xBB,0xEF,0xBE,0xDB,0xF8,0xE7,0x9E,0x79,0xE7,0x99,  /* 1584-1599 */
    0x8D,0xC7,0x0E,0x1C,0x38,0x70,0x77,0x36,0x6C,0xD9,0x8F,0x60,0x00,0x01,0x00,0x01,  /* 1600-1615 */
    0x86,0x27,0x70,0x07,0x07,0x80,0x0C,0x80,0x07,0x80,0x00,0x00,0x00,0x00,0x00,0x00,  /* 1616-1631 */
    0x00,0x00,0x00,0x00,0x01,0xF8,0x8C,0x01,0x28,0x00,0xE0,0x0C,0x5B,0x00,0x00,0x01,  /* 1632-1647 */
    0x31,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x10,0x00,0x00,0x06,0x00,  /* 1648-1663 */
    0x11,0x41,0xFF,0xB1,0x24,0x03,0x90,0xC3,0x20,0x80,0x01,0x41,0x20,0x41,0x22,0x0B,  /* 1664-1679 */
    0xF0,0x9C,0xC5,0x8E,0x00,0x06,0x05,0x11,0x21,0x30,0x7E,0xC0,0x0C,0x0D,0xF9,0xFB,  /* 1680-1695 */
    0x07,0xBF,0xC6,0x31,0xE0,0x18,0x05,0x8B,0x09,0x8B,0x03,0x7E,0xC0,0xD9,0x07,0x81,  /* 1696-1711 */
    0x81,0x82,0x0C,0x81,0x29,0x01,0x80,0x38,0x06,0x11,0x0C,0x30,0x02,0x26,0x34,0xD1,  /* 1712-1727 */
    0x46,0x82,0x26,0x2C,0x2A,0x17,0x19,0x71,0x22,0xE6,0x8B,0xA9,0xC4,0x4C,0x91,0x11,  /* 1728-1743 */
    0x44,0x51,0x24,0x8E,0x22,0x7F,0x90,0xF7,0x6C,0xC0,0x40,0x48,0x12,0xC8,0x07,0xA0,  /* 1744-1759 */
    0x01,0x20,0x00,0x98,0x13,0x02,0x60,0x4C,0x09,0x81,0x30,0x27,0xE6,0x00,0xFC,0x7E,  /* 1760-1775 */
    0x3F,0x1F,0x86,0x31,0x8C,0x26,0x2C,0x0F,0x03,0xC0,0xF0,0x3C,0x0D,0x91,0x98,0x21,  /* 1776-1791 */
    0x82,0x18,0x21,0x82,0x19,0xA2,0x8A,0x28,0xA2,0x8A,0x4D,0x38,0xE3,0x8E,0x37,0x99,  /* 1792-1807 */
    0x9E,0x48,0x91,0x22,0x45,0x88,0x89,0x12,0x24,0x48,0x86,0x40,0x00,0x03,0x00,0x01,  /* 1808-1823 */
    0x87,0xE4,0x98,0x03,0xC4,0x80,0x07,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 1824-1839 */
    0x00,0x00,0x00,0x00,0x00,0x60,0x9E,0x01,0x48,0x00,0x90,0x0C,0x5B,0x00,0x40,0x01,  /* 1840-1855 */
    0x3F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x10,0x00,0x00,0x02,0x00,  /* 1856-1871 */
    0x11,0x40,0x22,0x2C,0xC9,0xCD,0x90,0x81,0x07,0xF8,0x02,0x41,0x20,0x43,0xE2,0x06,  /* 1872-1887 */
    0x31,0x14,0x7C,0x30,0x00,0x01,0x85,0x11,0x22,0x30,0x62,0xC0,0x0C,0x0D,0x09,0x8B,  /* 1888-1903 */
    0x03,0x30,0xC6,0x31,0xF0,0x18,0x04,0x8B,0x08,0xCB,0x03,0x60,0xC0,0xDF,0x01,0xC1,  /* 1904-1919 */
    0x81,0x82,0x04,0x81,0xAD,0x00,0xC0,0x18,0x0C,0x11,0x08,0x00,0x00,0x64,0x38,0x21,  /* 1920-1935 */
    0x78,0x82,0x24,0x24,0x2C,0x12,0x11,0x21,0x43,0xC7,0x09,0x0C,0xC4,0x44,0x89,0xA1,  /* 1936-1951 */
    0x82,0x42,0x24,0x91,0xCA,0x82,0x10,0x88,0x46,0xC0,0x40,0x89,0xF3,0x88,0x01,0xA0,  /* 1952-1967 */
    0x00,0x90,0x20,0x88,0x11,0x02,0x20,0x44,0x08,0x81,0x10,0x3E,0x26,0x00,0xC4,0x62,  /* 1968-1983 */
    0x31,0x18,0x86,0x31,0x8C,0x23,0x2C,0x0F,0x03,0xC0,0xF0,0x3C,0x0D,0x91,0x98,0x21,  /* 1984-1999 */
    0x82,0x18,0x21,0x82,0x18,0xC6,0x18,0x61,0x86,0x08,0x72,0x08,0xE3,0x8E,0x37,0x99,  /* 2000-2015 */
    0x8C,0x50,0xE1,0xC3,0x87,0x0D,0x15,0x12,0x24,0x48,0x82,0x40,0x00,0x01,0x00,0x01,  /* 2016-2031 */
    0x86,0x28,0xE0,0x00,0xE6,0x00,0x03,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 2032-2047 */
    0x00,0x00,0x00,0x00,0x00,0x61,0x1E,0x00,0x97,0x39,0x08,0x0C,0x53,0x3F,0xE0,0x01,  /* 2048-2063 */
    0xF1,0x00,0x04,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x10,0x00,0x00,0x02,0x00,  /* 2064-2079 */
    0x11,0x40,0x44,0x26,0x09,0x39,0xE0,0x81,0x00,0x81,0xE2,0x63,0x20,0x80,0x7F,0x06,  /* 2080-2095 */
    0x11,0x22,0x0C,0x18,0x3F,0xC1,0xC9,0x22,0x23,0xF8,0x63,0xC0,0x0C,0x0D,0x01,0x83,  /* 2096-2111 */
    0x03,0x30,0xC6,0x31,0xB0,0x18,0x04,0xD3,0x08,0x6B,0x03,0x60,0xC0,0xDB,0x80,0x61,  /* 2112-2127 */
    0x81,0x82,0x07,0x01,0xC5,0x03,0x60,0x18,0x0C,0x10,0x88,0x00,0x01,0xA4,0x18,0x21,  /* 2128-2143 */
    0x40,0x83,0x24,0x24,0x2C,0x12,0x11,0x21,0x41,0xC3,0x09,0x06,0xC4,0x45,0x0A,0xA0,  /* 2144-2159 */
    0xC2,0x86,0x44,0x60,0x0A,0x82,0x10,0x88,0x42,0xE2,0x41,0x91,0xF2,0x48,0x00,0xA0,  /* 2160-2175 */
    0x00,0xC8,0x21,0xFC,0x3F,0x87,0xF0,0xFE,0x1F,0xC3,0xF8,0x46,0x06,0x00,0xC0,0x60,  /* 2176-2191 */
    0x30,0x18,0x06,0x31,0x8C,0x21,0xAC,0x0F,0x03,0xC0,0xF0,0x3C,0x0D,0xA1,0x98,0x21,  /* 2192-2207 */
    0x82,0x18,0x21,0x82,0x18,0x5A,0x69,0xA6,0x9A,0x79,0xC2,0x0F,0x3C,0xF3,0xC7,0x99,  /* 2208-2223 */
    0x8C,0x50,0x60,0xC1,0x83,0x05,0x25,0x12,0x24,0x48,0x83,0x80,0x00,0x01,0x00,0x01,  /* 2224-2239 */
    0x86,0x08,0x80,0x00,0x33,0x00,0x03,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,  /* 2240-2255 */
    0xFF,0xFE,0x00,0x00,0x00,0x61,0x8C,0x00,0x24,0xA7,0x0C,0x00,0x00,0x00,0x40,0x02,  /* 2256-2271 */
    0x30,0x00,0x04,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x10,0x00,0x00,0x02,0x00,  /* 2272-2287 */
    0x11,0x41,0xFF,0xE6,0x11,0x38,0xE0,0x81,0x00,0x80,0x04,0x63,0x21,0x00,0x42,0x06,  /* 2288-2303 */
    0x11,0x23,0x08,0x07,0x00,0x0E,0x09,0x22,0x42,0x18,0x63,0x40,0x4C,0x19,0x05,0x81,  /* 2304-2319 */
    0x83,0x30,0xC6,0x31,0x98,0x18,0x64,0x53,0x08,0x39,0x02,0x60,0x40,0x99,0x88,0x61,  /* 2320-2335 */
    0x81,0x82,0x07,0x00,0xC6,0x02,0x60,0x18,0x18,0x30,0x88,0x00,0x02,0x24,0x1C,0x71,  /* 2336-2351 */
    0x42,0x82,0xC4,0x24,0x2A,0x12,0x11,0x21,0x61,0xC3,0x09,0x03,0xC4,0x47,0x0E,0xC1,  /* 2352-2367 */
    0x43,0x84,0x24,0x80,0x0B,0x92,0x3F,0x88,0x24,0xB4,0x40,0x88,0x12,0x68,0x00,0xA0,  /* 2368-2383 */
    0x00,0x90,0x42,0x0C,0x41,0x88,0x30,0x86,0x20,0xC2,0x18,0x46,0x0A,0x02,0xC1,0x60,  /* 2384-2399 */
    0xB0,0x58,0x26,0x31,0x8C,0x20,0xE4,0x09,0x02,0x40,0x90,0x24,0x08,0xC1,0x18,0x21,  /* 2400-2415 */
    0x82,0x18,0x21,0x82,0x18,0x62,0x8A,0x28,0xA2,0x8A,0x47,0x18,0x61,0x86,0x17,0x99,  /* 2416-2431 */
    0x8C,0x58,0x70,0xE1,0xC3,0x05,0xC5,0x12,0x24,0x48,0x83,0x80,0x00,0x01,0x00,0x01,  /* 2432-2447 */
    0x86,0x18,0x88,0x04,0x31,0x80,0x03,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 2448-2463 */
    0x00,0x00,0x00,0x00,0x00,0x60,0x80,0x00,0x24,0xA5,0x08,0x00,0x00,0x00,0x00,0x04,  /* 2464-2479 */
    0x30,0x00,0x04,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x10,0x00,0x00,0x02,0x00,  /* 2480-2495 */
    0x11,0x40,0x84,0x64,0x21,0x38,0xF4,0xC3,0x00,0x80,0x14,0x22,0x22,0x30,0x82,0x0B,  /* 2496-2511 */
    0x22,0x22,0x12,0x80,0xC0,0x30,0x05,0x26,0x44,0x08,0x63,0x60,0x8C,0x11,0x05,0x81,  /* 2512-2527 */
    0x83,0x30,0xC6,0xB1,0x8C,0x18,0x44,0x63,0x08,0x19,0x86,0x60,0x61,0x98,0xC8,0x61,  /* 2528-2543 */
    0x80,0x84,0x02,0x00,0xC6,0x04,0x30,0x18,0x30,0x50,0x88,0x00,0x02,0x34,0x2C,0x71,  /* 2544-2559 */
    0x62,0x82,0x04,0x24,0x2B,0x12,0x11,0x21,0x22,0xC5,0x89,0x11,0xC4,0x42,0x04,0x42,  /* 2560-2575 */
    0x21,0x88,0xA4,0x80,0x0B,0x1F,0x20,0x08,0x18,0x48,0x80,0x48,0x0D,0x10,0x00,0xA0,  /* 2576-2591 */
    0x01,0x20,0x42,0x04,0x40,0x88,0x11,0x02,0x20,0x44,0x0C,0x86,0x0B,0x04,0xC2,0x61,  /* 2592-2607 */
    0x30,0x98,0x46,0x31,0x8C,0x20,0x66,0x19,0x86,0x61,0x98,0x66,0x18,0x83,0x08,0x40,  /* 2608-2623 */
    0x84,0x08,0x40,0x84,0x1A,0x63,0x8E,0x38,0xE3,0x8E,0x67,0x1C,0x71,0xC7,0x17,0x99,  /* 2624-2639 */
    0x8C,0x48,0x91,0x22,0x45,0x88,0x89,0x12,0x24,0x48,0x81,0x80,0x00,0x01,0x00,0x00,  /* 2640-2655 */
    0xC6,0x1C,0xC8,0x04,0x38,0x80,0x03,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 2656-2671 */
    0x00,0x00,0x00,0x00,0x00,0x20,0x81,0x22,0x44,0xA4,0x90,0x00,0x00,0x00,0x00,0x04,  /* 2672-2687 */
    0x30,0x40,0x04,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x10,0x00,0x00,0x02,0x00,  /* 2688-2703 */
    0x11,0x60,0x88,0x68,0x61,0xCF,0x3C,0x42,0x00,0x86,0x1C,0x1C,0xFF,0xEF,0x02,0xF1,  /* 2704-2719 */
    0xC2,0x1E,0xE3,0xC0,0x00,0x00,0x0D,0x3B,0xBE,0x1E,0xFE,0x1F,0x3F,0xE3,0xFF,0xC0,  /* 2720-2735 */
    0x7C,0x79,0xFF,0xE7,0xCF,0xFF,0xCE,0x27,0xDC,0x08,0x78,0xF0,0x33,0x3C,0x7F,0xC3,  /* 2736-2751 */
    0xC0,0x78,0x02,0x00,0x82,0x1C,0x7C,0x7C,0x7F,0xD0,0x48,0x00,0x03,0xF3,0xC7,0x9F,  /* 2752-2767 */
    0xBD,0xC3,0xFE,0x7E,0x3D,0xFF,0x3B,0xF3,0x9C,0xE8,0xFB,0xCE,0xF7,0xE2,0x04,0x46,  /* 2768-2783 */
    0x31,0x1F,0xA4,0x80,0x0D,0xED,0xC0,0x3C,0x0C,0x3F,0x00,0x64,0x07,0xE0,0x00,0xA0,  /* 2784-2799 */
    0x02,0x20,0x97,0x0F,0xE1,0xFC,0x3F,0x87,0xF0,0xFE,0x1F,0xCF,0xF8,0xF9,0xFE,0xFF,  /* 2800-2815 */
    0x7F,0xBF,0xDF,0xFF,0xFE,0x78,0x21,0xE0,0x78,0x1E,0x07,0x81,0xE1,0x7E,0x07,0x80,  /* 2816-2831 */
    0x78,0x07,0x80,0x78,0x1B,0xBF,0xFF,0xFF,0xFF,0xFF,0xB9,0xE7,0x9E,0x79,0xE7,0x99,  /* 2832-2847 */
    0x9E,0xE7,0x0E,0x1C,0x38,0xF1,0x71,0xFB,0xF7,0xEF,0xC1,0x00,0x00,0x03,0x80,0x00,  /* 2848-2863 */
    0x7F,0xF7,0x70,0x07,0xE7,0x00,0x0F,0x80,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 2864-2879 */
    0x00,0x00,0x00,0x00,0x36,0x43,0x21,0xB6,0x87,0x38,0xE0,0x00,0x00,0x00,0x00,0x1E,  /* 2880-2895 */
    0x78,0x60,0x07,0xFE,0x00,0x00,0x00,0x00,0x00,0x00,0x3F,0xF0,0x00,0x00,0x02,0x00,  /* 2896-2911 */
    0x11,0x00,0x88,0x30,0x00,0x00,0x00,0x42,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,  /* 2912-2927 */
    0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x80,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 2928-2943 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x00,0x00,0x00,  /* 2944-2959 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x08,0x00,0x00,0x00,0x00,0x00,  /* 2960-2975 */
    0x00,0x02,0x10,0x00,0x20,0x00,0x00,0x00,0x00,0xD0,0x08,0x00,0x00,0x00,0x00,0x00,  /* 2976-2991 */
    0x01,0x00,0x24,0x80,0x0D,0x00,0x00,0x00,0x24,0x00,0x00,0x00,0x00,0x00,0x00,0xA3,  /* 2992-3007 */
    0x00,0x00,0x88,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x00,0x00,  /* 3008-3023 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 3024-3039 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x60,0x00,0x00,0x00,0x00,  /* 3040-3055 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x00,0x00,  /* 3056-3071 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x06,0x00,0x00,0x00,  /* 3072-3087 */
    0x00,0x00,0x00,0x00,0x0A,0x47,0xE0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 3088-3103 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,  /* 3104-3119 */
    0x11,0x00,0x00,0x00,0x00,0x00,0x00,0x24,0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,  /* 3120-3135 */
    0x00,0x00,0x00,0x80,0x00,0x00,0x00,0x40,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 3136-3151 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x00,0x00,0x00,  /* 3152-3167 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x08,0x00,0x00,0x00,0x00,0x00,  /* 3168-3183 */
    0x00,0x06,0x10,0x00,0x20,0x00,0x00,0x00,0x00,0xC0,0x08,0x00,0x00,0x00,0x00,0x00,  /* 3184-3199 */
    0x0A,0x00,0x24,0x80,0x0E,0x00,0x00,0x00,0x24,0x00,0x00,0x00,0x00,0x00,0x00,0xA1,  /* 3200-3215 */
    0x00,0x00,0xC8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x00,0x00,  /* 3216-3231 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 3232-3247 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xE0,0x00,0x00,0x00,0x00,  /* 3248-3263 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0A,0x00,0x00,0x00,0x00,0x00,  /* 3264-3279 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x04,0x00,0x00,0x00,  /* 3280-3295 */
    0x00,0x00,0x00,0x00,0x14,0x40,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 3296-3311 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x02,0x00,  /* 3312-3327 */
    0xEE,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,  /* 3328-3343 */
    0x00,0x00,0x00,0x80,0x00,0x00,0x00,0x3F,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 3344-3359 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x01,0xC0,0x00,0x00,  /* 3360-3375 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x38,0x0F,0xF0,0x00,0x00,0x00,  /* 3376-3391 */
    0x00,0x03,0xE0,0x01,0xC0,0x00,0x00,0x00,0x00,0xC0,0x1C,0x00,0x00,0x00,0x00,0x00,  /* 3392-3407 */
    0x0E,0x00,0x1F,0x00,0x0E,0x00,0x00,0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0xA6,  /* 3408-3423 */
    0x00,0x00,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 3424-3439 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 3440-3455 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 3456-3471 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x00,0x00,0x00,0x00,0x00,  /* 3472-3487 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x00,0x00,0x03,0x00,0x00,0x00,  /* 3488-3503 */
    0x00,0x00,0x00,0x00,0x28,0x41,0x80,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  /* 3504-3519 */
    0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x00   /* 3520-3535 */

};  /* end:struct marin_11 (size=6848 bytes) */

#endif /*MARIN_11_H*/

/* End of File - marin_11.h */
