/*************************************************************************
*
*              Copyright 2002 Mentor Graphics Corporation              
*                         All Rights Reserved.                          
*                                                                       
* THIS WORK CONTAINS TRADE SECRET AND PROPRIETARY INFORMATION WHICH IS  
* THE PROPERTY OF MENTOR GRAPHICS CORPORATION OR ITS LICENSORS AND IS   
* SUBJECT TO LICENSE TERMS.                                             
*
*************************************************************************/

/*************************************************************************
*
*   FILE NAME                                        
*
*        ip6_mib_s.h                                 
*
*   DESCRIPTION
*
*        This file includes all files that have declarations of the
*        functions that are responsible for handling SNMP requests on
*        IPv6 MIB objects.
*
*   DATA STRUCTURES
*
*        None.
*
*   DEPENDENCIES
*
*        ip6_mib_get_bulk_s.h
*        2465gen.h
*        2465if.h
*        2465addr_pre.h
*        2465rt.h
*        2465if_addr.h
*        2465ntm.h
*        2466icmp.h
*        2452tcp.h
*        2454udp.h
*        3019mld.h
*
************************************************************************/

#ifndef IP6_MIB_S_H
#define IP6_MIB_S_H

#ifdef          __cplusplus
extern  "C" {                               /* C declarations in C++     */
#endif /* _cplusplus */

#include "networking/ip6_mib_get_bulk_s.h"
#include "networking/2465gen.h"
#include "networking/2465if.h"
#include "networking/2465addr_pre.h"
#include "networking/2465rt.h"
#include "networking/2465if_addr.h"
#include "networking/2465ntm.h"
#include "networking/2466icmp.h"
#include "networking/2452tcp.h"
#include "networking/2454udp.h"
#include "networking/3019mld.h"

#ifdef          __cplusplus
}
#endif /* _cplusplus */

#endif /* IP6_MIB_S_H */
