/*************************************************************************
*
*             Copyright 2006 Mentor Graphics Corporation
*                         All Rights Reserved.
*
* THIS WORK CONTAINS TRADE SECRET AND PROPRIETARY INFORMATION WHICH IS
* THE PROPERTY OF MENTOR GRAPHICS CORPORATION OR ITS LICENSORS AND IS
* SUBJECT TO LICENSE TERMS.
*
*************************************************************************/
/*************************************************************************
*
*   FILE NAME
*
*       ppc_debug_defs.h
*
*   DESCRIPTION
*
*       This file contains all definitions, structures, etc for the
*       PPC Debug support.
*
*       NOTE: The debugging support is designed around the GNU GDB
*             Remote Serial Protocol (RSP) specification.
*
*   DATA STRUCTURES
*
*       None
*
*   DEPENDENCIES
*
*       nucleus.h
*       nucleus_gen_cfg.h
*
*************************************************************************/

#ifndef         ESAL_AR_DBG_DEFS_H
#define         ESAL_AR_DBG_DEFS_H

/* Include required header files */
#include            "nucleus.h"
#include            "nucleus_gen_cfg.h"

/* PPC FPU Development Enable - For DEVELOPMENT PURPOSES ONLY. DO NOT
   CHANGE! */
#define         PPC_DEBUG_FPU_DEV_ENABLE            NU_FALSE

/* PPC SPE Development Enable - For DEVELOPMENT PURPOSES ONLY. DO NOT
   CHANGE! */
#define         PPC_DEBUG_SPE_DEV_ENABLE            NU_FALSE

/* External functions */
extern VOID     ESAL_AR_DBG_Exception_Exit(VOID);

/* Debug Support flags */
#define         ESAL_GE_DBG_SUPPORT_HW_STEP         (0x1 << 0)

/* Define Opcode type */
typedef         UINT32                              ESAL_AR_DBG_OPCODE;

/* Define 32-bit Register type */
typedef         UINT32                              ESAL_AR_DBG_REG;

/* Define 64-bit Register type */
typedef         UINT64                              ESAL_AR_DBG_REG64;

/* Define Maximum Register Size */
#define         ESAL_AR_DBG_REG_SIZE_MAX            (sizeof(ESAL_AR_DBG_REG64))

/* Protocol specific register model definitions */
#define         NU_REG_RSP_MODE                     1

/* Register Mapping structure */
typedef struct esal_ar_dbg_reg_map_struct
{
    INT         offset;     /* Offset into stack frame */
    UINT8       size;       /* Size (in bytes) of register */

} ESAL_AR_DBG_REG_MAP;

/* Register Mapping values (positive values are register offsets) */
#define         ESAL_AR_DBG_REG_MAPPED              -1
#define         ESAL_AR_DBG_REG_NOT_MAPPED          -2
#define         ESAL_AR_DBG_REG_STACK_POINTER       -3
#define         ESAL_AR_DBG_REG_INVALID             -4

/* Register IDs.  NOTE: These match the GNU GDB RSP ID values */

/* PowerPC Core Register IDs */
#define         ESAL_AR_DBG_REG_R0                  0x00
#define         ESAL_AR_DBG_REG_R1                  0x01
#define         ESAL_AR_DBG_REG_R2                  0x02
#define         ESAL_AR_DBG_REG_R3                  0x03
#define         ESAL_AR_DBG_REG_R4                  0x04
#define         ESAL_AR_DBG_REG_R5                  0x05
#define         ESAL_AR_DBG_REG_R6                  0x06
#define         ESAL_AR_DBG_REG_R7                  0x07
#define         ESAL_AR_DBG_REG_R8                  0x08
#define         ESAL_AR_DBG_REG_R9                  0x09
#define         ESAL_AR_DBG_REG_R10                 0x0A
#define         ESAL_AR_DBG_REG_R11                 0x0B
#define         ESAL_AR_DBG_REG_R12                 0x0C
#define         ESAL_AR_DBG_REG_R13                 0x0D
#define         ESAL_AR_DBG_REG_R14                 0x0E
#define         ESAL_AR_DBG_REG_R15                 0x0F
#define         ESAL_AR_DBG_REG_R16                 0x10
#define         ESAL_AR_DBG_REG_R17                 0x11
#define         ESAL_AR_DBG_REG_R18                 0x12
#define         ESAL_AR_DBG_REG_R19                 0x13
#define         ESAL_AR_DBG_REG_R20                 0x14
#define         ESAL_AR_DBG_REG_R21                 0x15
#define         ESAL_AR_DBG_REG_R22                 0x16
#define         ESAL_AR_DBG_REG_R23                 0x17
#define         ESAL_AR_DBG_REG_R24                 0x18
#define         ESAL_AR_DBG_REG_R25                 0x19
#define         ESAL_AR_DBG_REG_R26                 0x1A
#define         ESAL_AR_DBG_REG_R27                 0x1B
#define         ESAL_AR_DBG_REG_R28                 0x1C
#define         ESAL_AR_DBG_REG_R29                 0x1D
#define         ESAL_AR_DBG_REG_R30                 0x1E
#define         ESAL_AR_DBG_REG_R31                 0x1F
#define         ESAL_AR_DBG_REG_PC                  0x40
#define         ESAL_AR_DBG_REG_MSR                 0x41
#define         ESAL_AR_DBG_REG_CR                  0x42
#define         ESAL_AR_DBG_REG_LR                  0x43
#define         ESAL_AR_DBG_REG_CTR                 0x44
#define         ESAL_AR_DBG_REG_XER                 0x45

/* PowerPC Core Register Metrics */
#define         ESAL_AR_DBG_PPC_CORE_REG_COUNT      38
#define         ESAL_AR_DBG_PPC_CORE_REG_ID_MAX     ESAL_AR_DBG_REG_XER
#define         ESAL_AR_DBG_PPC_CORE_REG_MEM_SIZE   (ESAL_AR_DBG_PPC_CORE_REG_COUNT * sizeof(ESAL_AR_DBG_REG))

/* PowerPC FPU Register IDs */
#define         ESAL_AR_DBG_REG_F0                  0x20
#define         ESAL_AR_DBG_REG_F1                  0x21
#define         ESAL_AR_DBG_REG_F2                  0x22
#define         ESAL_AR_DBG_REG_F3                  0x23
#define         ESAL_AR_DBG_REG_F4                  0x24
#define         ESAL_AR_DBG_REG_F5                  0x25
#define         ESAL_AR_DBG_REG_F6                  0x26
#define         ESAL_AR_DBG_REG_F7                  0x27
#define         ESAL_AR_DBG_REG_F8                  0x28
#define         ESAL_AR_DBG_REG_F9                  0x29
#define         ESAL_AR_DBG_REG_F10                 0x2A
#define         ESAL_AR_DBG_REG_F11                 0x2B
#define         ESAL_AR_DBG_REG_F12                 0x2C
#define         ESAL_AR_DBG_REG_F13                 0x2D
#define         ESAL_AR_DBG_REG_F14                 0x2E
#define         ESAL_AR_DBG_REG_F15                 0x2F
#define         ESAL_AR_DBG_REG_F16                 0x30
#define         ESAL_AR_DBG_REG_F17                 0x31
#define         ESAL_AR_DBG_REG_F18                 0x32
#define         ESAL_AR_DBG_REG_F19                 0x33
#define         ESAL_AR_DBG_REG_F20                 0x34
#define         ESAL_AR_DBG_REG_F21                 0x35
#define         ESAL_AR_DBG_REG_F22                 0x36
#define         ESAL_AR_DBG_REG_F23                 0x37
#define         ESAL_AR_DBG_REG_F24                 0x38
#define         ESAL_AR_DBG_REG_F25                 0x39
#define         ESAL_AR_DBG_REG_F26                 0x3A
#define         ESAL_AR_DBG_REG_F27                 0x3B
#define         ESAL_AR_DBG_REG_F28                 0x3C
#define         ESAL_AR_DBG_REG_F29                 0x3D
#define         ESAL_AR_DBG_REG_F30                 0x3E
#define         ESAL_AR_DBG_REG_F31                 0x3F
#define         ESAL_AR_DBG_REG_FPSCR               0x46

/* PowerPC FPU Register Metrics */
#define         ESAL_AR_DBG_PPC_FPU_REG_COUNT       33
#define         ESAL_AR_DBG_PPC_FPU_REG_ID_MAX      ESAL_AR_DBG_REG_FPSCR
#define         ESAL_AR_DBG_PPC_FPU_REG_MEM_SIZE    ((32 * sizeof(ESAL_AR_DBG_REG64)) + \
                                                     (1 * sizeof(ESAL_AR_DBG_REG))

/* PowerPC SPE Register IDs */
#define         ESAL_AR_DBG_REG_EV0H                0x20
#define         ESAL_AR_DBG_REG_EV1H                0x21
#define         ESAL_AR_DBG_REG_EV2H                0x22
#define         ESAL_AR_DBG_REG_EV3H                0x23
#define         ESAL_AR_DBG_REG_EV4H                0x24
#define         ESAL_AR_DBG_REG_EV5H                0x25
#define         ESAL_AR_DBG_REG_EV6H                0x26
#define         ESAL_AR_DBG_REG_EV7H                0x27
#define         ESAL_AR_DBG_REG_EV8H                0x28
#define         ESAL_AR_DBG_REG_EV9H                0x29
#define         ESAL_AR_DBG_REG_EV10H               0x2A
#define         ESAL_AR_DBG_REG_EV11H               0x2B
#define         ESAL_AR_DBG_REG_EV12H               0x2C
#define         ESAL_AR_DBG_REG_EV13H               0x2D
#define         ESAL_AR_DBG_REG_EV14H               0x2E
#define         ESAL_AR_DBG_REG_EV15H               0x2F
#define         ESAL_AR_DBG_REG_EV16H               0x30
#define         ESAL_AR_DBG_REG_EV17H               0x31
#define         ESAL_AR_DBG_REG_EV18H               0x32
#define         ESAL_AR_DBG_REG_EV19H               0x33
#define         ESAL_AR_DBG_REG_EV20H               0x34
#define         ESAL_AR_DBG_REG_EV21H               0x35
#define         ESAL_AR_DBG_REG_EV22H               0x36
#define         ESAL_AR_DBG_REG_EV23H               0x37
#define         ESAL_AR_DBG_REG_EV24H               0x38
#define         ESAL_AR_DBG_REG_EV25H               0x39
#define         ESAL_AR_DBG_REG_EV26H               0x3A
#define         ESAL_AR_DBG_REG_EV27H               0x3B
#define         ESAL_AR_DBG_REG_EV28H               0x3C
#define         ESAL_AR_DBG_REG_EV29H               0x3D
#define         ESAL_AR_DBG_REG_EV30H               0x3E
#define         ESAL_AR_DBG_REG_EV31H               0x3F
#define         ESAL_AR_DBG_REG_ACC                 0x49
#define         ESAL_AR_DBG_REG_SPEFSCR             0x4A

/* PowerPC SPE Register Metrics */
#define         ESAL_AR_DBG_PPC_SPE_REG_COUNT       34
#define         ESAL_AR_DBG_PPC_SPE_REG_ID_MAX      ESAL_AR_DBG_REG_SPEFSCR
#define         ESAL_AR_DBG_PPC_SPE_REG_MEM_SIZE    ((32 * sizeof(ESAL_AR_DBG_REG32)) + \
                                                     (1 * sizeof(ESAL_AR_DBG_REG64))

/* Generic Register IDs */
#define         ESAL_AR_DBG_STACK_PTR_REGID         ESAL_AR_DBG_REG_R1
#define         ESAL_AR_DBG_PC_IDX_REGID            ESAL_AR_DBG_REG_PC

#if (CFG_NU_OS_ARCH_PPC_COM_PPC_VARIANT == 0)

/* Register Count */
#define         ESAL_AR_DBG_REG_COUNT               (ESAL_AR_DBG_PPC_CORE_REG_COUNT \
                                                     + ESAL_AR_DBG_PPC_FPU_REG_COUNT)

/* Register Maximum ID - The maximum register ID value for the set. */
#define         ESAL_AR_DBG_REG_ID_MAX              ESAL_AR_DBG_PPC_FPU_REG_ID_MAX

/* Register Memory Size - The size of memory (in bytes) needed to hold all
   possible register values. */
#define         ESAL_AR_DBG_REG_MEM_SIZE            (ESAL_AR_DBG_PPC_CORE_REG_MEM_SIZE \
                                                     + ESAL_AR_DBG_PPC_FPU_REG_MEM_SIZE)

#endif /* (CFG_NU_OS_ARCH_PPC_COM_PPC_VARIANT == 0) */

#if (CFG_NU_OS_ARCH_PPC_COM_PPC_VARIANT == 1)

/* Unused Register IDs */
#define         ESAL_AR_DBG_REG_UNUSED_0            0x46
#define         ESAL_AR_DBG_REG_UNUSED_1            0x47
#define         ESAL_AR_DBG_REG_UNUSED_2            0x48

/* Register Count */
#define         ESAL_AR_DBG_REG_COUNT               (ESAL_AR_DBG_PPC_CORE_REG_COUNT \
                                                     + ESAL_AR_DBG_PPC_SPE_REG_COUNT)

/* Register Maximum ID - The maximum register ID value for the set. */
#define         ESAL_AR_DBG_REG_ID_MAX              ESAL_AR_DBG_PPC_SPE_REG_ID_MAX

/* Register Memory Size - The size of memory (in bytes) needed to hold all
   possible register values. */
#define         ESAL_AR_DBG_REG_MEM_SIZE            (ESAL_AR_DBG_PPC_CORE_REG_MEM_SIZE \
                                                     + ESAL_AR_DBG_PPC_SPE_REG_MEM_SIZE)

#endif /* (CFG_NU_OS_ARCH_PPC_COM_PPC_VARIANT == 1) */

/* The value returned for access to unavailable registers */
#define         ESAL_AR_DBG_REG_UNAVAIL_VAL         0x0BAD0BAD

/* Machine State Register (MSR) bits */
#define         ESAL_AR_DBG_MSR_EE_BIT              ESAL_GE_MEM_32BIT_SET(16)
#define         ESAL_AR_DBG_MSR_PR_BIT              ESAL_GE_MEM_32BIT_SET(17)
#define         ESAL_AR_DBG_MSR_ME_BIT              ESAL_GE_MEM_32BIT_SET(19)

#if (CFG_NU_OS_ARCH_PPC_COM_PPC_VARIANT == 0)

#define         ESAL_AR_DBG_MSR_SE_BIT              ESAL_GE_MEM_32BIT_SET(21)
#define         ESAL_AR_DBG_MSR_BE_BIT              ESAL_GE_MEM_32BIT_SET(22)

#endif /* (CFG_NU_OS_ARCH_PPC_COM_PPC_VARIANT == 0) */

#if (CFG_NU_OS_ARCH_PPC_COM_PPC_VARIANT == 1)

#define         ESAL_AR_DBG_MSR_DE_BIT              ESAL_GE_MEM_32BIT_SET(22)

#endif /* (CFG_NU_OS_ARCH_PPC_COM_PPC_VARIANT == 1) */

#if (CFG_NU_OS_ARCH_PPC_COM_PPC_VARIANT == 1)

/* Book E Debug Registers (SPR numbers) */
#define         ESAL_AR_DBG_DBCR0_REG_ID            308
#define         ESAL_AR_DBG_DBSR_REG_ID             304

/* Debug Control Register 0 (DBCR0) bits */
#define         ESAL_AR_DBG_DBCR0_EDM_BIT           ESAL_GE_MEM_32BIT_SET(0)
#define         ESAL_AR_DBG_DBCR0_IDM_BIT           ESAL_GE_MEM_32BIT_SET(1)
#define         ESAL_AR_DBG_DBCR0_RST_BIT           (ESAL_GE_MEM_32BIT_SET(2) | ESAL_GE_MEM_32BIT_SET(3))
#define         ESAL_AR_DBG_DBCR0_ICMP_BIT          ESAL_GE_MEM_32BIT_SET(4)

/* Debug Status Register (DBSR) bits */
#define         ESAL_AR_DBG_DBSR_ICMP_BIT           ESAL_GE_MEM_32BIT_SET(4)

#endif /* (CFG_NU_OS_ARCH_PPC_COM_PPC_VARIANT == 1) */

#if (CFG_NU_OS_ARCH_PPC_COM_PPC_VARIANT == 0)

/* Exception Vectors - IDs for vectors that support PPC32 debugging */
#define         ESAL_AR_DBG_PPC_BREAKPOINT_VECTOR_ID        ESAL_AR_PROGRAM_EXCEPT_VECTOR_ID
#define         ESAL_AR_DBG_PPC_DATA_ABORT_VECTOR_ID        ESAL_AR_DSI_EXCEPT_VECTOR_ID
#define         ESAL_AR_DBG_PPC_HARDWARE_STEP_VECTOR_ID     ESAL_AR_TRACE_EXCEPT_VECTOR_ID

#endif /* (CFG_NU_OS_ARCH_PPC_COM_PPC_VARIANT == 0) */

#if (CFG_NU_OS_ARCH_PPC_COM_PPC_VARIANT == 1)

/* Exception Vectors - IDs for vectors that support PPC Book E debugging */
#define         ESAL_AR_DBG_PPC_BREAKPOINT_VECTOR_ID        ESAL_AR_PROGRAM_EXCEPT_VECTOR_ID
#define         ESAL_AR_DBG_PPC_DATA_ABORT_VECTOR_ID        ESAL_AR_DTLB_ERR_EXCEPT_VECTOR_ID
#define         ESAL_AR_DBG_PPC_HARDWARE_STEP_VECTOR_ID     ESAL_AR_DEBUG_INT_VECTOR_ID

#endif /* (CFG_NU_OS_ARCH_PPC_COM_PPC_VARIANT == 1) */

/* Stack Types */
#define         ESAL_AR_DBG_STK_TYPE_SOL            ESAL_GE_STK_TS_TYPE
#define         ESAL_AR_DBG_STK_TYPE_UNSOL          ESAL_GE_STK_AR_TYPE
#define         ESAL_AR_DBG_STK_TYPE_EXCEPT         2

/* Stack Types Count - Number of different stack types */
#define         ESAL_AR_DBG_STK_TYPE_COUNT          3

/* Exception Stack Frame size */
#define         ESAL_AR_DBG_STK_MIN_FRAME_SIZE      sizeof(ESAL_AR_STK_MIN)

/* Exception Stack Frame Offsets */
#define         ESAL_AR_DBG_STK_MIN_OFFSET(reg_name)    (ESAL_GE_STK_UNSOL_OFFSET(min_stack.reg_name) - ESAL_GE_STK_UNSOL_OFFSET(min_stack))

/* breakpoint instructions for specific instruction replacement (NULL is
   always considered an illegal instruction for PPC) */
#define         ESAL_AR_DBG_PPC_BRK_OPCODE          0x00000000

/* NOP instructions for specific instruction replacement */
#define         ESAL_AR_DBG_PPC_NOP_OPCODE          0x60000000

#endif /* ESAL_AR_DBG_DEFS_H */
