/*************************************************************************
*
*            Copyright 2010 Mentor Graphics Corporation
*                         All Rights Reserved.
*
* THIS WORK CONTAINS TRADE SECRET AND PROPRIETARY INFORMATION WHICH IS
* THE PROPERTY OF MENTOR GRAPHICS CORPORATION OR ITS LICENSORS AND IS
* SUBJECT TO LICENSE TERMS.
*
*************************************************************************/
/*************************************************************************
*
*   FILE NAME
*
*       cxx_rte_inc.h
*
*   COMPONENT
*
*       C++ Service - Run-Time Environment (RTE) - Inclusion
*
*   DESCRIPTION
*
*       This code forces inclusion of required C++ support from the tools.
*
*   DATA STRUCTURES
*
*       CxxRteIncClass
*
*   FUNCTIONS
*
*       CxxRteIncClass
*       ~CxxRteIncClass
*
*   DEPENDENCIES
*
*       None
*
*************************************************************************/

#ifndef CXX_RTE_INC_H
#define CXX_RTE_INC_H

/* Ensure only compiled from C++ code. */
#ifdef __cplusplus

/* Define RTE Inclusion Class */
class CxxRteIncClass
{
    public:
        CxxRteIncClass();
        ~CxxRteIncClass();
};

#else

/* Include RTE Inclusion variable */
extern int CXX_RTE_INC_var;

#endif /* __cplusplus */

#endif /* CXX_RTE_INC_H */
