/*************************************************************************
*
*             Copyright Mentor Graphics Corporation 2013
*                         All Rights Reserved.
*
* THIS WORK CONTAINS TRADE SECRET AND PROPRIETARY INFORMATION WHICH IS
* THE PROPERTY OF MENTOR GRAPHICS CORPORATION OR ITS LICENSORS AND IS
* SUBJECT TO LICENSE TERMS.
*
*************************************************************************

*************************************************************************
*
* FILE NAME
*
*       arch_proc_exception.h
*
* DESCRIPTION
*
*       This file contains defines for architecture specific exception
*       handling.
*
* DATA STRUCTURES
*
*       None
*
* DEPENDENCIES
*
*       None
*
*************************************************************************/
#ifndef _ARCH_PROC_EXCEPTION_H
#define _ARCH_PROC_EXCEPTION_H

/* Exception status register */
#define PROC_FSR_STATUS_MASK        0x0000000FUL

/* Used to distinguish a prefect from a data abort, status message
   is read from the first 4 bits of the FSR */
#define PROC_PREFETCH_ABORT         0x00000010UL

/* Undefined exception indicator */
#define PROC_UNDEF_ABORT            0x00000020UL

typedef struct
{
    ESAL_AR_STK_MIN *stack_min;             /* Pointer to minimum stack save */
    UNSIGNED         type;                  /* Type of error that occurred (arch specific) */
} NU_ARCH_EXCEPTION;

#endif /* _ARCH_PROC_EXCEPTION_H */
