/**************************************************************************
*
*           Copyright 2005 Mentor Graphics Corporation
*                         All Rights Reserved.
*
* THIS WORK CONTAINS TRADE SECRET AND PROPRIETARY INFORMATION WHICH IS THE
* PROPERTY OF MENTOR GRAPHICS CORPORATION OR ITS LICENSORS AND IS SUBJECT
* TO LICENSE TERMS.
*
***************************************************************************

***************************************************************************
* FILE NAME
*
*       nu_usbf_kb_dat.c
*
* COMPONENT
*
*       Nucleus USB Function software : HID Keyboard User Driver.
*
* DESCRIPTION
*
*       This file defines the dispatch table and other global data for HID
*       Keyboard User Driver.
*
* DATA STRUCTURES
*
*       usbf_kb_dispatch                    HID User Driver dispatch table.
*       nu_usbf_kb_keysasciitable           ASCII data for
*                                           the key pressed.
*       nu_usbf_kb_usageidtable             Usage ID Table.Usage codes are
*                                           defined in HID usage tables.
*
* FUNCTIONS
*
*       None.
*
* DEPENDENCIES
*
*       nu_usb.h                            All USB definitions.
*
**************************************************************************/

/* ==============  USB Include Files =================================  */
#include    "connectivity/nu_usb.h"

/* =====================  Global data ================================  */

NU_USBF_KB  *NU_USBF_KB_Cb_Pt;

/* Dispatch table structure. */
const NU_USBF_KB_DISPATCH usbf_kb_dispatch =
{
    {
        {
            {
                _NU_USBF_KB_Delete,
                _NU_USB_Get_Name,              /* does not override. */
                _NU_USB_Get_Object_Id          /* does not override. */
            },

            _NU_USBF_KB_Connect,
            _NU_USBF_KB_Disconnect
        },

        _NU_USBF_KB_New_Command,
        _NU_USBF_KB_New_Transfer,
        _NU_USBF_KB_Tx_Done,
        _NU_USBF_KB_Notify
    },
};

/* ASCII Table data for the keys pressed. Each entry contains a usage id
    code defined in the usage id table defined below.*/
const UINT8 nu_usbf_kb_keysasciitable[USBF_KB_ASCII_TABLE_SIZE] =
{

    0x09,0x0D,0x0B,0x20,
    0x21,0x22,0x23,0x24,0x25,0x26,0x27,0x28,0x29,
    0x2A,0x2B,0x2C,0x2D,0x2E,0x2F,
    0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,0x38,0x39,
    0x3A,0x3B,0x3C,0x3D,0x3E,0x3F,
    0x40,0x41,0x42,0x43,0x44,0x45,0x46,0x47,0x48,0x49,
    0x4A,0x4B,0x4C,0x4D,0x4E,0x4F,
    0x50,0x51,0x52,0x53,0x54,0x55,0x56,0x57,0x58,0x59,
    0x5A,0x5B,0x5C,0x5D,0x5E,0x5F,
    0x60,0x61,0x62,0x63,0x64,0x65,0x66,0x67,0x68,0x69,
    0x6A,0x6B,0x6C,0x6D,0x6E,0x6F,
    0x70,0x71,0x72,0x73,0x74,0x75,0x76,0x77,0x78,0x79,
    0x7A,0x7B,0x7C,0x7D,0x7E,0x7F,0x80
};

/* Usage ID Table for the keyboard keys*/
const UINT8   nu_usbf_kb_usageidtable[USBF_KB_ASCII_TABLE_SIZE] =
{
    0x2B,0x28,0x4A,0x2C,
    0x1E,0x34,0x20,0x21,0x22,0x24,0x34,0x26,0x27,
    0x25,0x2E,0x36,0x2D,0x37,0x38,
    0x27,0x1E,0x1F,0x20,0x21,0x22,0x23,0x24,0x25,0x26,
    0x33,0x33,0x36,0x2E,0x37,0x38,
    0x1F,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,
    0x0D,0x0E,0x0F,0x10,0x11,0x12,
    0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,
    0x1D,0x2F,0x31,0x30,0x23,0x2D,
    0x34,0x04,0x05,0x06,0x07,0x08,0x09,0x0A,0x0B,0x0C,
    0x0D,0x0E,0x0F,0x10,0x11,0x12,
    0x13,0x14,0x15,0x16,0x17,0x18,0x19,0x1A,0x1B,0x1C,
    0x1D,0x2F,0x31,0x30,0x35,0x2A,0x53
};

/* ======================  End Of File  =============================== */
