;***********************************************************************
;*
;*             Copyright 2011 Mentor Graphics Corporation
;*                         All Rights Reserved.
;*
;* THIS WORK CONTAINS TRADE SECRET AND PROPRIETARY INFORMATION WHICH IS
;* THE PROPERTY OF MENTOR GRAPHICS CORPORATION OR ITS LICENSORS AND IS
;* SUBJECT TO LICENSE TERMS.
;*
;***********************************************************************

;***********************************************************************
;*
;*  FILE NAME
;*
;*      renesas_sh_defs.inc
;*
;*  DESCRIPTION
;*
;*      This file contains the architecture specific definitions,
;*      constants, etc, for Renesas SuperH architecture
;*
;*  DATA STRUCTURES
;*
;*      None
;*
;*  DEPENDENCIES
;*
;*      None
;*
;***********************************************************************

; Define if floating point registers will be saved during context switches
; NOTE:  The C define must be changed in os/include/arch/sh/sh_defs.h to
;        match this define.
; NOTE:  This define will dictate what registers are contained
;        within solicited (TS) and unsolicited (AR) stack frames.

ESAL_AR_STK_FPU_SUPPORT:           .ASSIGNA                      1

; Startup / initialization stack size in bytes

ESAL_AR_STK_STARTUP_STACK_SIZE:    .EQU                          1024

; Based on ESAL_TS_REQ_STK_ALIGNMENT in os/include/arch/sh/tool-renesas_sh/renesas_sh_defs.h
 
ESAL_AR_STK_ALIGNMENT_MASK:        .EQU                          H'00000003

;***********************************************************************
;* ESAL_AR_STK_MIN_SAVE
;*
;* Save minimal amount of registers required for handling interrupts.
;* ESAL_AR_STK_Unsolicited_Switch() will save the rest.
;***********************************************************************

    .MACRO    ESAL_AR_STK_MIN_SAVE   

    ; SR, return PC, and R4 already on stack - save rest of min stack (PR, R7-R5 and R3-R0)
    ; NOTE:  This must match the structure found in esal_ar_stk_defs.h

    STS.L       PR,@-R15    
    MOV.L       R7,@-R15
    MOV.L       R6,@-R15
    MOV.L       R5,@-R15
    MOV.L       R3,@-R15
    MOV.L       R2,@-R15
    MOV.L       R1,@-R15
    MOV.L       R0,@-R15

    .ENDM

;***********************************************************************
;* ESAL_AR_STK_MIN_RESTORE
;* 
;* Restore minimal amount of registers required for handling interrupts.
;***********************************************************************

    .MACRO    ESAL_AR_STK_MIN_RESTORE   

    ; Restore min stack (R0-R3, R5-R7, PR, and R4) - leave SR and return PC on stack
    ; NOTE:  This must match the structure found in esal_ar_stk_defs.h
    
    MOV.L       @R15+,R0
    MOV.L       @R15+,R1
    MOV.L       @R15+,R2
    MOV.L       @R15+,R3
    MOV.L       @R15+,R5
    MOV.L       @R15+,R6
    MOV.L       @R15+,R7
    LDS.L       @R15+,PR
    MOV.L       @R15+,R4    
    
    .ENDM

; Define to allow conditional assembling of lowlevel ISR hook.
; Setting this to TRUE will allow a low-level hook to be executed in the
; interrupt handlers

ESAL_AR_ISR_HOOK_ENABLED:          .ASSIGNA                      0

; Define offset of registers on minimal stack frame

ESAL_AR_ISR_SR_OFFSET:             .EQU                          H'28

; Define value to isolate imask bits in SR

ESAL_AR_ISR_IMASK_ISOLATE:         .EQU                          H'0F

; Define interrupt enable value
; NOTE: This needs to reflect the same value defined in esal_ar_cfg.h

ESAL_AR_INTERRUPTS_ENABLE_BITS:    .EQU                          H'00000000

; Define the last ESAL exception vector ID for this architecture + 1
; NOTE: This define must match the value in esal_ar_int_defs.h

ESAL_AR_EXCEPT_VECTOR_ID_DELIMITER:        .EQU                  43

;***********************************************************************
;* ESAL_AR_ISR_EXCEPTION_TRAMPOLINE
;*
;* Saves R4 on stack and jumps to exception handler with vector # in R4
;***********************************************************************

    .MACRO    ESAL_AR_ISR_EXCEPTION_TRAMPOLINE    label

\label:

    ; Save R4 on stack

    MOV.L       R4,@-R15

    ; Branch to destination and put vector_id into R4 (delay slot)
    
    BRA         ESAL_AR_ISR_Exception_Handler
    MOV         #\@,R4

    .ENDM

   
;***********************************************************************
;* ESAL_AR_ISR_INTERRUPT_TRAMPOLINE
;*
;* Saves R4 on stack and jumps to interrupt handler with vector # in R4
;***********************************************************************

    .MACRO    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE    label

\label:

    ; Save R4 on stack

    MOV.L       R4,@-R15

    ; Branch to destination and put vector_id into R4 (delay slot)
    
    BRA         ESAL_AR_ISR_Interrupt_Handler
    MOV         #(\@-ESAL_AR_EXCEPT_VECTOR_ID_DELIMITER),R4

    .ENDM

;***********************************************************************
;* ESAL_AR_ISR_HOOK_EXECUTE
;*
;* Saves minimal registers and executes ESAL_AR_ISR_HOOK function
;***********************************************************************

    .MACRO    ESAL_AR_ISR_HOOK_EXECUTE   

    ; Save minimal registers on stack

    MOV.L       R0,@-R15
    MOV.L       R1,@-R15
    MOV.L       R2,@-R15
    MOV.L       R3,@-R15
    MOV.L       R4,@-R15

    ; Get address of hook function and jump to it

    MOVA        #_ESAL_AR_ISR_HOOK, R0
    JSR         @R0

    ; Restore minimal registers from stack

    MOV.L       @R15+,R4
    MOV.L       @R15+,R3
    MOV.L       @R15+,R2
    MOV.L       @R15+,R1
    MOV.L       @R15+,R0

    .ENDM
