;************************************************************************
;*
;*             Copyright 2011 Mentor Graphics Corporation
;*                         All Rights Reserved.
;*
;* THIS WORK CONTAINS TRADE SECRET AND PROPRIETARY INFORMATION WHICH IS
;* THE PROPERTY OF MENTOR GRAPHICS CORPORATION OR ITS LICENSORS AND IS
;* SUBJECT TO LICENSE TERMS.
;*
;************************************************************************

;************************************************************************
;*
;*  FILE NAME
;*
;*      renesas_sh.s
;*
;*  DESCRIPTION
;*
;*      This file contains the base Renesas SuperH specific functions
;*
;*  FUNCTIONS
;*
;*      ESAL_AR_ISR_Reserved
;*      ESAL_AR_ISR_Exceptions_Start
;*      ESAL_AR_ISR_Exception_Handler
;*      ESAL_AR_ISR_Interrupts_Start
;*      ESAL_AR_ISR_Interrupt_Handler
;*      ESAL_Entry
;*      ESAL_AR_STK_Unsolicited_Restore
;*      ESAL_AR_STK_Unsolicited_Switch
;*      ESAL_AR_STK_Startup_SP_Set
;*      ESAL_TS_RTE_Lowlevel_Initialize
;*      ESAL_TS_STK_Solicited_Restore
;*      ESAL_TS_STK_Solicited_Switch
;*      ESAL_TS_RTE_SP_Write
;*      ESAL_TS_RTE_SP_Read
;*      ESAL_TS_RTE_Sim_IO_Write
;*
;*  DEPENDENCIES
;*
;*      renesas_sh_defs.inc                   Renesas SuperH include file
;*
;*************************************************************************

;****************************
;* INCLUDE NECESSARY FILES  *
;****************************

    .include    "renesas_sh_defs.inc"

;**********************************
;* EXTERNAL FUNCTION DECLARATIONS *
;**********************************

;VOID           OS_Init_Entry(VOID);
;extern VOID    ESAL_AR_ISR_HOOK(VOID);

    .IMPORT    _OS_Init_Entry

    .AIF    \&ESAL_AR_ISR_HOOK_ENABLED EQ 1

    .IMPORT    _ESAL_AR_ISR_HOOK

    .AENDI ; ESAL_AR_ISR_HOOK_ENABLED

;**********************************
;* EXTERNAL VARIABLE DECLARATIONS *
;**********************************

;extern VOID    *ESAL_GE_STK_System_SP;
;extern VOID    *ESAL_GE_STK_Exception_SP;
;extern INT     ESAL_GE_STK_Unsol_Switch_Req;
;extern VOID    (*ESAL_GE_STK_Unsol_Switch_OS_Entry)(VOID);
;extern INT     const ESAL_GE_MEM_ROM_Support_Enabled;
;extern VOID    **(*ESAL_GE_ISR_OS_Entry)(INT vector, VOID *stack_ptr);
;extern VOID    (*ESAL_GE_ISR_OS_Nested_Entry)(INT vector);
;extern VOID    (*ESAL_GE_ISR_Exception_Handler[ESAL_AR_NUM_EXCEPTIONS])(INT except_num, VOID *frame_ptr);
;extern INT     ESAL_GE_ISR_Executing;

    .IMPORT _ESAL_GE_STK_System_SP
    .IMPORT _ESAL_GE_STK_Unsol_Switch_Req
    .IMPORT _ESAL_GE_STK_Unsol_Switch_OS_Entry
    .IMPORT _ESAL_GE_MEM_ROM_Support_Enabled
    .IMPORT _ESAL_GE_ISR_OS_Entry
    .IMPORT _ESAL_GE_ISR_OS_Nested_Entry
    .IMPORT _ESAL_GE_ISR_Executing

; Import linker produced labels

    .SECTION    B, DATA, ALIGN=4

;***************************
;* SECTION DECLARATIONS    *
;***************************

    .SECTION    C$INIT, DATA
    .SECTION    C$VTBL, DATA

;****************************
;* VECTOR TABLE DECLARATION *
;****************************

    .SECTION    esal_vectors, CODE, ALIGN=4

;************************************************************************
;*
;*  FUNCTION
;*
;*      ESAL_AR_ISR_Vector_Table
;*
;*  DESCRIPTION
;*
;*      Identifies the start address of the actual vector table /
;*      exception handling code utilized by the target processor /
;*      architecture.  Other interrupt related data structures
;*      (priority tables / etc) will be defined in their respective
;*      esal_xx_isr.c file.
;*
;*  CALLED BY
;*
;*      Interrupt
;*
;*  CALLS
;*
;*      Interrupt Service Routine
;*
;*  INPUTS
;*
;*      None
;*
;*  OUTPUTS
;*
;*      None
;*
;************************************************************************
;VOID ESAL_AR_ISR_Vector_Table(VOID)

    .EXPORT    _ESAL_AR_ISR_Vector_Table
_ESAL_AR_ISR_Vector_Table:

    ;Vector Table Value                        Offset/4      Note
    ;==================                        ========      ====
    .DATA.L     ESAL_Entry                      ; 000  - Power-on reset entry
    .DATA.L     0                               ; 001  - Power-on reset SP
    .DATA.L     ESAL_Entry                      ; 002  - Manual reset entry
    .DATA.L     0                               ; 003  - Manual reset SP
    .DATA.L     ESAL_AR_ISR_Gen_Illegal_Inst    ; 004  - General illegal instruction
    .DATA.L     ESAL_AR_ISR_RAM_Error           ; 005  - RAM Error
    .DATA.L     ESAL_AR_ISR_Slot_Illegal_Inst   ; 006  - Slot illegal instruction
    .DATA.L     ESAL_AR_ISR_Reserved            ; 007  - Reserved
    .DATA.L     ESAL_AR_ISR_Reserved            ; 008  - Reserved
    .DATA.L     ESAL_AR_ISR_CPU_Addr_Error      ; 009  - CPU address error
    .DATA.L     ESAL_AR_ISR_Bus_Addr_Error      ; 010  - Bus / DMAC address error
    .DATA.L     ESAL_AR_ISR_NMI                 ; 011  - NMI
    .DATA.L     ESAL_AR_ISR_User_Break          ; 012  - User break interrupt
    .DATA.L     ESAL_AR_ISR_FPU_Exception       ; 013  - FPU Exception
    .DATA.L     ESAL_AR_ISR_HUDI                ; 014  - H-UDI exception
    .DATA.L     ESAL_AR_ISR_Bank_Overflow       ; 015  - Bank overflow exception (SH-2A)
    .DATA.L     ESAL_AR_ISR_Bank_Underflow      ; 016  - Bank underflow exception (SH-2A)
    .DATA.L     ESAL_AR_ISR_Int_Div_0           ; 017  - Integer DIV0 exception (SH-2A)
    .DATA.L     ESAL_AR_ISR_Int_Div_Overflow    ; 018  - Integer div overflow exception (SH-2A)
    .DATA.L     ESAL_AR_ISR_Reserved            ; 019  - Reserved
    .DATA.L     ESAL_AR_ISR_Reserved            ; 020  - Reserved
    .DATA.L     ESAL_AR_ISR_Reserved            ; 021  - Reserved
    .DATA.L     ESAL_AR_ISR_Reserved            ; 022  - Reserved
    .DATA.L     ESAL_AR_ISR_Reserved            ; 023  - Reserved
    .DATA.L     ESAL_AR_ISR_Reserved            ; 024  - Reserved
    .DATA.L     ESAL_AR_ISR_Reserved            ; 025  - Reserved
    .DATA.L     ESAL_AR_ISR_Reserved            ; 026  - Reserved
    .DATA.L     ESAL_AR_ISR_Reserved            ; 027  - Reserved
    .DATA.L     ESAL_AR_ISR_Reserved            ; 028  - Reserved
    .DATA.L     ESAL_AR_ISR_Reserved            ; 029  - Reserved
    .DATA.L     ESAL_AR_ISR_Reserved            ; 030  - Reserved
    .DATA.L     ESAL_AR_ISR_Reserved            ; 031  - Reserved
    .DATA.L     ESAL_AR_ISR_Trap0               ; 032  - Trap 0
    .DATA.L     ESAL_AR_ISR_Trap1               ; 033  - Trap 1
    .DATA.L     ESAL_AR_ISR_Trap2               ; 034  - Trap 2
    .DATA.L     ESAL_AR_ISR_Trap3               ; 035  - Trap 3
    .DATA.L     ESAL_AR_ISR_Trap4               ; 036  - Trap 4
    .DATA.L     ESAL_AR_ISR_Trap5               ; 037  - Trap 5
    .DATA.L     ESAL_AR_ISR_Trap6               ; 038  - Trap 6
    .DATA.L     ESAL_AR_ISR_Trap7               ; 039  - Trap 7
    .DATA.L     ESAL_AR_ISR_Trap8               ; 040  - Trap 8
    .DATA.L     ESAL_AR_ISR_Trap9               ; 041  - Trap 9
    .DATA.L     ESAL_AR_ISR_Trap10              ; 042  - Trap 10
    .DATA.L     ESAL_AR_ISR_Trap11              ; 043  - Trap 11
    .DATA.L     ESAL_AR_ISR_Trap12              ; 044  - Trap 12
    .DATA.L     ESAL_AR_ISR_Trap13              ; 045  - Trap 13
    .DATA.L     ESAL_AR_ISR_Trap14              ; 046  - Trap 14
    .DATA.L     ESAL_AR_ISR_Trap15              ; 047  - Trap 15
    .DATA.L     ESAL_AR_ISR_Trap16              ; 048  - Trap 16
    .DATA.L     ESAL_AR_ISR_Trap17              ; 049  - Trap 17
    .DATA.L     ESAL_AR_ISR_Trap18              ; 050  - Trap 18
    .DATA.L     ESAL_AR_ISR_Trap19              ; 051  - Trap 19
    .DATA.L     ESAL_AR_ISR_Trap20              ; 052  - Trap 20
    .DATA.L     ESAL_AR_ISR_Trap21              ; 053  - Trap 21
    .DATA.L     ESAL_AR_ISR_Trap22              ; 054  - Trap 22
    .DATA.L     ESAL_AR_ISR_Trap23              ; 055  - Trap 23
    .DATA.L     ESAL_AR_ISR_Trap24              ; 056  - Trap 24
    .DATA.L     ESAL_AR_ISR_Trap25              ; 057  - Trap 25
    .DATA.L     ESAL_AR_ISR_Trap26              ; 058  - Trap 26
    .DATA.L     ESAL_AR_ISR_Trap27              ; 059  - Trap 27
    .DATA.L     ESAL_AR_ISR_Trap28              ; 060  - Trap 28
    .DATA.L     ESAL_AR_ISR_Trap29              ; 061  - Trap 29
    .DATA.L     ESAL_AR_ISR_Trap30              ; 062  - Trap 30
    .DATA.L     ESAL_AR_ISR_Trap31              ; 063  - Trap 31
    .DATA.L     ESAL_AR_ISR_Proc0_Int           ; 064  - Processor 0 interrupt
    .DATA.L     ESAL_AR_ISR_Proc1_Int           ; 065  - Processor 1 interrupt
    .DATA.L     ESAL_AR_ISR_Proc2_Int           ; 066  - Processor 2 interrupt
    .DATA.L     ESAL_AR_ISR_Proc3_Int           ; 067  - Processor 3 interrupt
    .DATA.L     ESAL_AR_ISR_Proc4_Int           ; 068  - Processor 4 interrupt
    .DATA.L     ESAL_AR_ISR_Proc5_Int           ; 069  - Processor 5 interrupt
    .DATA.L     ESAL_AR_ISR_Proc6_Int           ; 070  - Processor 6 interrupt
    .DATA.L     ESAL_AR_ISR_Proc7_Int           ; 071  - Processor 7 interrupt
    .DATA.L     ESAL_AR_ISR_Proc8_Int           ; 072  - Processor 8 interrupt
    .DATA.L     ESAL_AR_ISR_Proc9_Int           ; 073  - Processor 9 interrupt
    .DATA.L     ESAL_AR_ISR_Proc10_Int          ; 074  - Processor 10 interrupt
    .DATA.L     ESAL_AR_ISR_Proc11_Int          ; 075  - Processor 11 interrupt
    .DATA.L     ESAL_AR_ISR_Proc12_Int          ; 076  - Processor 12 interrupt
    .DATA.L     ESAL_AR_ISR_Proc13_Int          ; 077  - Processor 13 interrupt
    .DATA.L     ESAL_AR_ISR_Proc14_Int          ; 078  - Processor 14 interrupt
    .DATA.L     ESAL_AR_ISR_Proc15_Int          ; 079  - Processor 15 interrupt
    .DATA.L     ESAL_AR_ISR_Proc16_Int          ; 080  - Processor 16 interrupt
    .DATA.L     ESAL_AR_ISR_Proc17_Int          ; 081  - Processor 17 interrupt
    .DATA.L     ESAL_AR_ISR_Proc18_Int          ; 082  - Processor 18 interrupt
    .DATA.L     ESAL_AR_ISR_Proc19_Int          ; 083  - Processor 19 interrupt
    .DATA.L     ESAL_AR_ISR_Proc20_Int          ; 084  - Processor 20 interrupt
    .DATA.L     ESAL_AR_ISR_Proc21_Int          ; 085  - Processor 21 interrupt
    .DATA.L     ESAL_AR_ISR_Proc22_Int          ; 086  - Processor 22 interrupt
    .DATA.L     ESAL_AR_ISR_Proc23_Int          ; 087  - Processor 23 interrupt
    .DATA.L     ESAL_AR_ISR_Proc24_Int          ; 088  - Processor 24 interrupt
    .DATA.L     ESAL_AR_ISR_Proc25_Int          ; 089  - Processor 25 interrupt
    .DATA.L     ESAL_AR_ISR_Proc26_Int          ; 090  - Processor 26 interrupt
    .DATA.L     ESAL_AR_ISR_Proc27_Int          ; 091  - Processor 27 interrupt
    .DATA.L     ESAL_AR_ISR_Proc28_Int          ; 092  - Processor 28 interrupt
    .DATA.L     ESAL_AR_ISR_Proc29_Int          ; 093  - Processor 29 interrupt
    .DATA.L     ESAL_AR_ISR_Proc30_Int          ; 094  - Processor 30 interrupt
    .DATA.L     ESAL_AR_ISR_Proc31_Int          ; 095  - Processor 31 interrupt
    .DATA.L     ESAL_AR_ISR_Proc32_Int          ; 096  - Processor 32 interrupt
    .DATA.L     ESAL_AR_ISR_Proc33_Int          ; 097  - Processor 33 interrupt
    .DATA.L     ESAL_AR_ISR_Proc34_Int          ; 098  - Processor 34 interrupt
    .DATA.L     ESAL_AR_ISR_Proc35_Int          ; 099  - Processor 35 interrupt
    .DATA.L     ESAL_AR_ISR_Proc36_Int          ; 100  - Processor 36 interrupt
    .DATA.L     ESAL_AR_ISR_Proc37_Int          ; 101  - Processor 37 interrupt
    .DATA.L     ESAL_AR_ISR_Proc38_Int          ; 102  - Processor 38 interrupt
    .DATA.L     ESAL_AR_ISR_Proc39_Int          ; 103  - Processor 39 interrupt
    .DATA.L     ESAL_AR_ISR_Proc40_Int          ; 104  - Processor 40 interrupt
    .DATA.L     ESAL_AR_ISR_Proc41_Int          ; 105  - Processor 41 interrupt
    .DATA.L     ESAL_AR_ISR_Proc42_Int          ; 106  - Processor 42 interrupt
    .DATA.L     ESAL_AR_ISR_Proc43_Int          ; 107  - Processor 43 interrupt
    .DATA.L     ESAL_AR_ISR_Proc44_Int          ; 108  - Processor 44 interrupt
    .DATA.L     ESAL_AR_ISR_Proc45_Int          ; 109  - Processor 45 interrupt
    .DATA.L     ESAL_AR_ISR_Proc46_Int          ; 110  - Processor 46 interrupt
    .DATA.L     ESAL_AR_ISR_Proc47_Int          ; 111  - Processor 47 interrupt
    .DATA.L     ESAL_AR_ISR_Proc48_Int          ; 112  - Processor 48 interrupt
    .DATA.L     ESAL_AR_ISR_Proc49_Int          ; 113  - Processor 49 interrupt
    .DATA.L     ESAL_AR_ISR_Proc50_Int          ; 114  - Processor 50 interrupt
    .DATA.L     ESAL_AR_ISR_Proc51_Int          ; 115  - Processor 51 interrupt
    .DATA.L     ESAL_AR_ISR_Proc52_Int          ; 116  - Processor 52 interrupt
    .DATA.L     ESAL_AR_ISR_Proc53_Int          ; 117  - Processor 53 interrupt
    .DATA.L     ESAL_AR_ISR_Proc54_Int          ; 118  - Processor 54 interrupt
    .DATA.L     ESAL_AR_ISR_Proc55_Int          ; 119  - Processor 55 interrupt
    .DATA.L     ESAL_AR_ISR_Proc56_Int          ; 120  - Processor 56 interrupt
    .DATA.L     ESAL_AR_ISR_Proc57_Int          ; 121  - Processor 57 interrupt
    .DATA.L     ESAL_AR_ISR_Proc58_Int          ; 122  - Processor 58 interrupt
    .DATA.L     ESAL_AR_ISR_Proc59_Int          ; 123  - Processor 59 interrupt
    .DATA.L     ESAL_AR_ISR_Proc60_Int          ; 124  - Processor 60 interrupt
    .DATA.L     ESAL_AR_ISR_Proc61_Int          ; 125  - Processor 61 interrupt
    .DATA.L     ESAL_AR_ISR_Proc62_Int          ; 126  - Processor 62 interrupt
    .DATA.L     ESAL_AR_ISR_Proc63_Int          ; 127  - Processor 63 interrupt
    .DATA.L     ESAL_AR_ISR_Proc64_Int          ; 128  - Processor 64 interrupt
    .DATA.L     ESAL_AR_ISR_Proc65_Int          ; 129  - Processor 65 interrupt
    .DATA.L     ESAL_AR_ISR_Proc66_Int          ; 130  - Processor 66 interrupt
    .DATA.L     ESAL_AR_ISR_Proc67_Int          ; 131  - Processor 67 interrupt
    .DATA.L     ESAL_AR_ISR_Proc68_Int          ; 132  - Processor 68 interrupt
    .DATA.L     ESAL_AR_ISR_Proc69_Int          ; 133  - Processor 69 interrupt
    .DATA.L     ESAL_AR_ISR_Proc70_Int          ; 134  - Processor 70 interrupt
    .DATA.L     ESAL_AR_ISR_Proc71_Int          ; 135  - Processor 71 interrupt
    .DATA.L     ESAL_AR_ISR_Proc72_Int          ; 136  - Processor 72 interrupt
    .DATA.L     ESAL_AR_ISR_Proc73_Int          ; 137  - Processor 73 interrupt
    .DATA.L     ESAL_AR_ISR_Proc74_Int          ; 138  - Processor 74 interrupt
    .DATA.L     ESAL_AR_ISR_Proc75_Int          ; 139  - Processor 75 interrupt
    .DATA.L     ESAL_AR_ISR_Proc76_Int          ; 140  - Processor 76 interrupt
    .DATA.L     ESAL_AR_ISR_Proc77_Int          ; 141  - Processor 77 interrupt
    .DATA.L     ESAL_AR_ISR_Proc78_Int          ; 142  - Processor 78 interrupt
    .DATA.L     ESAL_AR_ISR_Proc79_Int          ; 143  - Processor 79 interrupt
    .DATA.L     ESAL_AR_ISR_Proc80_Int          ; 144  - Processor 80 interrupt
    .DATA.L     ESAL_AR_ISR_Proc81_Int          ; 145  - Processor 81 interrupt
    .DATA.L     ESAL_AR_ISR_Proc82_Int          ; 146  - Processor 82 interrupt
    .DATA.L     ESAL_AR_ISR_Proc83_Int          ; 147  - Processor 83 interrupt
    .DATA.L     ESAL_AR_ISR_Proc84_Int          ; 148  - Processor 84 interrupt
    .DATA.L     ESAL_AR_ISR_Proc85_Int          ; 149  - Processor 85 interrupt
    .DATA.L     ESAL_AR_ISR_Proc86_Int          ; 150  - Processor 86 interrupt
    .DATA.L     ESAL_AR_ISR_Proc87_Int          ; 151  - Processor 87 interrupt
    .DATA.L     ESAL_AR_ISR_Proc88_Int          ; 152  - Processor 88 interrupt
    .DATA.L     ESAL_AR_ISR_Proc89_Int          ; 153  - Processor 89 interrupt
    .DATA.L     ESAL_AR_ISR_Proc90_Int          ; 154  - Processor 90 interrupt
    .DATA.L     ESAL_AR_ISR_Proc91_Int          ; 155  - Processor 91 interrupt
    .DATA.L     ESAL_AR_ISR_Proc92_Int          ; 156  - Processor 92 interrupt
    .DATA.L     ESAL_AR_ISR_Proc93_Int          ; 157  - Processor 93 interrupt
    .DATA.L     ESAL_AR_ISR_Proc94_Int          ; 158  - Processor 94 interrupt
    .DATA.L     ESAL_AR_ISR_Proc95_Int          ; 159  - Processor 95 interrupt
    .DATA.L     ESAL_AR_ISR_Proc96_Int          ; 160  - Processor 96 interrupt
    .DATA.L     ESAL_AR_ISR_Proc97_Int          ; 161  - Processor 97 interrupt
    .DATA.L     ESAL_AR_ISR_Proc98_Int          ; 162  - Processor 98 interrupt
    .DATA.L     ESAL_AR_ISR_Proc99_Int          ; 163  - Processor 99 interrupt
    .DATA.L     ESAL_AR_ISR_Proc100_Int         ; 164  - Processor 100 interrupt
    .DATA.L     ESAL_AR_ISR_Proc101_Int         ; 165  - Processor 101 interrupt
    .DATA.L     ESAL_AR_ISR_Proc102_Int         ; 166  - Processor 102 interrupt
    .DATA.L     ESAL_AR_ISR_Proc103_Int         ; 167  - Processor 103 interrupt
    .DATA.L     ESAL_AR_ISR_Proc104_Int         ; 168  - Processor 104 interrupt
    .DATA.L     ESAL_AR_ISR_Proc105_Int         ; 169  - Processor 105 interrupt
    .DATA.L     ESAL_AR_ISR_Proc106_Int         ; 170  - Processor 106 interrupt
    .DATA.L     ESAL_AR_ISR_Proc107_Int         ; 171  - Processor 107 interrupt
    .DATA.L     ESAL_AR_ISR_Proc108_Int         ; 172  - Processor 108 interrupt
    .DATA.L     ESAL_AR_ISR_Proc109_Int         ; 173  - Processor 109 interrupt
    .DATA.L     ESAL_AR_ISR_Proc110_Int         ; 174  - Processor 110 interrupt
    .DATA.L     ESAL_AR_ISR_Proc111_Int         ; 175  - Processor 111 interrupt
    .DATA.L     ESAL_AR_ISR_Proc112_Int         ; 176  - Processor 112 interrupt
    .DATA.L     ESAL_AR_ISR_Proc113_Int         ; 177  - Processor 113 interrupt
    .DATA.L     ESAL_AR_ISR_Proc114_Int         ; 178  - Processor 114 interrupt
    .DATA.L     ESAL_AR_ISR_Proc115_Int         ; 179  - Processor 115 interrupt
    .DATA.L     ESAL_AR_ISR_Proc116_Int         ; 180  - Processor 116 interrupt
    .DATA.L     ESAL_AR_ISR_Proc117_Int         ; 181  - Processor 117 interrupt
    .DATA.L     ESAL_AR_ISR_Proc118_Int         ; 182  - Processor 118 interrupt
    .DATA.L     ESAL_AR_ISR_Proc119_Int         ; 183  - Processor 119 interrupt
    .DATA.L     ESAL_AR_ISR_Proc120_Int         ; 184  - Processor 120 interrupt
    .DATA.L     ESAL_AR_ISR_Proc121_Int         ; 185  - Processor 121 interrupt
    .DATA.L     ESAL_AR_ISR_Proc122_Int         ; 186  - Processor 122 interrupt
    .DATA.L     ESAL_AR_ISR_Proc123_Int         ; 187  - Processor 123 interrupt
    .DATA.L     ESAL_AR_ISR_Proc124_Int         ; 188  - Processor 124 interrupt
    .DATA.L     ESAL_AR_ISR_Proc125_Int         ; 189  - Processor 125 interrupt
    .DATA.L     ESAL_AR_ISR_Proc126_Int         ; 190  - Processor 126 interrupt
    .DATA.L     ESAL_AR_ISR_Proc127_Int         ; 191  - Processor 127 interrupt
    .DATA.L     ESAL_AR_ISR_Proc128_Int         ; 192  - Processor 128 interrupt
    .DATA.L     ESAL_AR_ISR_Proc129_Int         ; 193  - Processor 129 interrupt
    .DATA.L     ESAL_AR_ISR_Proc130_Int         ; 194  - Processor 130 interrupt
    .DATA.L     ESAL_AR_ISR_Proc131_Int         ; 195  - Processor 131 interrupt
    .DATA.L     ESAL_AR_ISR_Proc132_Int         ; 196  - Processor 132 interrupt
    .DATA.L     ESAL_AR_ISR_Proc133_Int         ; 197  - Processor 133 interrupt
    .DATA.L     ESAL_AR_ISR_Proc134_Int         ; 198  - Processor 134 interrupt
    .DATA.L     ESAL_AR_ISR_Proc135_Int         ; 199  - Processor 135 interrupt
    .DATA.L     ESAL_AR_ISR_Proc136_Int         ; 200  - Processor 136 interrupt
    .DATA.L     ESAL_AR_ISR_Proc137_Int         ; 201  - Processor 137 interrupt
    .DATA.L     ESAL_AR_ISR_Proc138_Int         ; 202  - Processor 138 interrupt
    .DATA.L     ESAL_AR_ISR_Proc139_Int         ; 203  - Processor 139 interrupt
    .DATA.L     ESAL_AR_ISR_Proc140_Int         ; 204  - Processor 140 interrupt
    .DATA.L     ESAL_AR_ISR_Proc141_Int         ; 205  - Processor 141 interrupt
    .DATA.L     ESAL_AR_ISR_Proc142_Int         ; 206  - Processor 142 interrupt
    .DATA.L     ESAL_AR_ISR_Proc143_Int         ; 207  - Processor 143 interrupt
    .DATA.L     ESAL_AR_ISR_Proc144_Int         ; 208  - Processor 144 interrupt
    .DATA.L     ESAL_AR_ISR_Proc145_Int         ; 209  - Processor 145 interrupt
    .DATA.L     ESAL_AR_ISR_Proc146_Int         ; 210  - Processor 146 interrupt
    .DATA.L     ESAL_AR_ISR_Proc147_Int         ; 211  - Processor 147 interrupt
    .DATA.L     ESAL_AR_ISR_Proc148_Int         ; 212  - Processor 148 interrupt
    .DATA.L     ESAL_AR_ISR_Proc149_Int         ; 213  - Processor 149 interrupt
    .DATA.L     ESAL_AR_ISR_Proc150_Int         ; 214  - Processor 150 interrupt
    .DATA.L     ESAL_AR_ISR_Proc151_Int         ; 215  - Processor 151 interrupt
    .DATA.L     ESAL_AR_ISR_Proc152_Int         ; 216  - Processor 152 interrupt
    .DATA.L     ESAL_AR_ISR_Proc153_Int         ; 217  - Processor 153 interrupt
    .DATA.L     ESAL_AR_ISR_Proc154_Int         ; 218  - Processor 154 interrupt
    .DATA.L     ESAL_AR_ISR_Proc155_Int         ; 219  - Processor 155 interrupt
    .DATA.L     ESAL_AR_ISR_Proc156_Int         ; 220  - Processor 156 interrupt
    .DATA.L     ESAL_AR_ISR_Proc157_Int         ; 221  - Processor 157 interrupt
    .DATA.L     ESAL_AR_ISR_Proc158_Int         ; 222  - Processor 158 interrupt
    .DATA.L     ESAL_AR_ISR_Proc159_Int         ; 223  - Processor 159 interrupt
    .DATA.L     ESAL_AR_ISR_Proc160_Int         ; 224  - Processor 160 interrupt
    .DATA.L     ESAL_AR_ISR_Proc161_Int         ; 225  - Processor 161 interrupt
    .DATA.L     ESAL_AR_ISR_Proc162_Int         ; 226  - Processor 162 interrupt
    .DATA.L     ESAL_AR_ISR_Proc163_Int         ; 227  - Processor 163 interrupt
    .DATA.L     ESAL_AR_ISR_Proc164_Int         ; 228  - Processor 164 interrupt
    .DATA.L     ESAL_AR_ISR_Proc165_Int         ; 229  - Processor 165 interrupt
    .DATA.L     ESAL_AR_ISR_Proc166_Int         ; 230  - Processor 166 interrupt
    .DATA.L     ESAL_AR_ISR_Proc167_Int         ; 231  - Processor 167 interrupt
    .DATA.L     ESAL_AR_ISR_Proc168_Int         ; 232  - Processor 168 interrupt
    .DATA.L     ESAL_AR_ISR_Proc169_Int         ; 233  - Processor 169 interrupt
    .DATA.L     ESAL_AR_ISR_Proc170_Int         ; 234  - Processor 170 interrupt
    .DATA.L     ESAL_AR_ISR_Proc171_Int         ; 235  - Processor 171 interrupt
    .DATA.L     ESAL_AR_ISR_Proc172_Int         ; 236  - Processor 172 interrupt
    .DATA.L     ESAL_AR_ISR_Proc173_Int         ; 237  - Processor 173 interrupt
    .DATA.L     ESAL_AR_ISR_Proc174_Int         ; 238  - Processor 174 interrupt
    .DATA.L     ESAL_AR_ISR_Proc175_Int         ; 239  - Processor 175 interrupt
    .DATA.L     ESAL_AR_ISR_Proc176_Int         ; 240  - Processor 176 interrupt
    .DATA.L     ESAL_AR_ISR_Proc177_Int         ; 241  - Processor 177 interrupt
    .DATA.L     ESAL_AR_ISR_Proc178_Int         ; 242  - Processor 178 interrupt
    .DATA.L     ESAL_AR_ISR_Proc179_Int         ; 243  - Processor 179 interrupt
    .DATA.L     ESAL_AR_ISR_Proc180_Int         ; 244  - Processor 180 interrupt
    .DATA.L     ESAL_AR_ISR_Proc181_Int         ; 245  - Processor 181 interrupt
    .DATA.L     ESAL_AR_ISR_Proc182_Int         ; 246  - Processor 182 interrupt
    .DATA.L     ESAL_AR_ISR_Proc183_Int         ; 247  - Processor 183 interrupt
    .DATA.L     ESAL_AR_ISR_Proc184_Int         ; 248  - Processor 184 interrupt
    .DATA.L     ESAL_AR_ISR_Proc185_Int         ; 249  - Processor 185 interrupt
    .DATA.L     ESAL_AR_ISR_Proc186_Int         ; 250  - Processor 186 interrupt
    .DATA.L     ESAL_AR_ISR_Proc187_Int         ; 251  - Processor 187 interrupt
    .DATA.L     ESAL_AR_ISR_Proc188_Int         ; 252  - Processor 188 interrupt
    .DATA.L     ESAL_AR_ISR_Proc189_Int         ; 253  - Processor 189 interrupt
    .DATA.L     ESAL_AR_ISR_Proc190_Int         ; 254  - Processor 190 interrupt
    .DATA.L     ESAL_AR_ISR_Proc191_Int         ; 255  - Processor 191 interrupt
    .DATA.L     ESAL_AR_ISR_Proc192_Int         ; 256  - Processor 192 interrupt
    .DATA.L     ESAL_AR_ISR_Proc193_Int         ; 257  - Processor 193 interrupt
    .DATA.L     ESAL_AR_ISR_Proc194_Int         ; 258  - Processor 194 interrupt
    .DATA.L     ESAL_AR_ISR_Proc195_Int         ; 259  - Processor 195 interrupt
    .DATA.L     ESAL_AR_ISR_Proc196_Int         ; 260  - Processor 196 interrupt
    .DATA.L     ESAL_AR_ISR_Proc197_Int         ; 261  - Processor 197 interrupt
    .DATA.L     ESAL_AR_ISR_Proc198_Int         ; 262  - Processor 198 interrupt
    .DATA.L     ESAL_AR_ISR_Proc199_Int         ; 263  - Processor 199 interrupt
    .DATA.L     ESAL_AR_ISR_Proc200_Int         ; 264  - Processor 200 interrupt
    .DATA.L     ESAL_AR_ISR_Proc201_Int         ; 265  - Processor 201 interrupt
    .DATA.L     ESAL_AR_ISR_Proc202_Int         ; 266  - Processor 202 interrupt
    .DATA.L     ESAL_AR_ISR_Proc203_Int         ; 267  - Processor 203 interrupt
    .DATA.L     ESAL_AR_ISR_Proc204_Int         ; 268  - Processor 204 interrupt
    .DATA.L     ESAL_AR_ISR_Proc205_Int         ; 269  - Processor 205 interrupt
    .DATA.L     ESAL_AR_ISR_Proc206_Int         ; 270  - Processor 206 interrupt
    .DATA.L     ESAL_AR_ISR_Proc207_Int         ; 271  - Processor 207 interrupt
    .DATA.L     ESAL_AR_ISR_Proc208_Int         ; 272  - Processor 208 interrupt
    .DATA.L     ESAL_AR_ISR_Proc209_Int         ; 273  - Processor 209 interrupt
    .DATA.L     ESAL_AR_ISR_Proc210_Int         ; 274  - Processor 210 interrupt
    .DATA.L     ESAL_AR_ISR_Proc211_Int         ; 275  - Processor 211 interrupt
    .DATA.L     ESAL_AR_ISR_Proc212_Int         ; 276  - Processor 212 interrupt
    .DATA.L     ESAL_AR_ISR_Proc213_Int         ; 277  - Processor 213 interrupt
    .DATA.L     ESAL_AR_ISR_Proc214_Int         ; 278  - Processor 214 interrupt
    .DATA.L     ESAL_AR_ISR_Proc215_Int         ; 279  - Processor 215 interrupt
    .DATA.L     ESAL_AR_ISR_Proc216_Int         ; 280  - Processor 216 interrupt
    .DATA.L     ESAL_AR_ISR_Proc217_Int         ; 281  - Processor 217 interrupt
    .DATA.L     ESAL_AR_ISR_Proc218_Int         ; 282  - Processor 218 interrupt
    .DATA.L     ESAL_AR_ISR_Proc219_Int         ; 283  - Processor 219 interrupt
    .DATA.L     ESAL_AR_ISR_Proc220_Int         ; 284  - Processor 220 interrupt
    .DATA.L     ESAL_AR_ISR_Proc221_Int         ; 285  - Processor 221 interrupt
    .DATA.L     ESAL_AR_ISR_Proc222_Int         ; 286  - Processor 222 interrupt
    .DATA.L     ESAL_AR_ISR_Proc223_Int         ; 287  - Processor 223 interrupt
    .DATA.L     ESAL_AR_ISR_Proc224_Int         ; 288  - Processor 224 interrupt
    .DATA.L     ESAL_AR_ISR_Proc225_Int         ; 289  - Processor 225 interrupt
    .DATA.L     ESAL_AR_ISR_Proc226_Int         ; 290  - Processor 226 interrupt
    .DATA.L     ESAL_AR_ISR_Proc227_Int         ; 291  - Processor 227 interrupt
    .DATA.L     ESAL_AR_ISR_Proc228_Int         ; 292  - Processor 228 interrupt
    .DATA.L     ESAL_AR_ISR_Proc229_Int         ; 293  - Processor 229 interrupt
    .DATA.L     ESAL_AR_ISR_Proc230_Int         ; 294  - Processor 230 interrupt
    .DATA.L     ESAL_AR_ISR_Proc231_Int         ; 295  - Processor 231 interrupt
    .DATA.L     ESAL_AR_ISR_Proc232_Int         ; 296  - Processor 232 interrupt
    .DATA.L     ESAL_AR_ISR_Proc233_Int         ; 297  - Processor 233 interrupt
    .DATA.L     ESAL_AR_ISR_Proc234_Int         ; 298  - Processor 234 interrupt
    .DATA.L     ESAL_AR_ISR_Proc235_Int         ; 299  - Processor 235 interrupt
    .DATA.L     ESAL_AR_ISR_Proc236_Int         ; 300  - Processor 236 interrupt
    .DATA.L     ESAL_AR_ISR_Proc237_Int         ; 301  - Processor 237 interrupt
    .DATA.L     ESAL_AR_ISR_Proc238_Int         ; 302  - Processor 238 interrupt
    .DATA.L     ESAL_AR_ISR_Proc239_Int         ; 303  - Processor 239 interrupt
    .DATA.L     ESAL_AR_ISR_Proc240_Int         ; 304  - Processor 240 interrupt
    .DATA.L     ESAL_AR_ISR_Proc241_Int         ; 305  - Processor 241 interrupt
    .DATA.L     ESAL_AR_ISR_Proc242_Int         ; 306  - Processor 242 interrupt
    .DATA.L     ESAL_AR_ISR_Proc243_Int         ; 307  - Processor 243 interrupt
    .DATA.L     ESAL_AR_ISR_Proc244_Int         ; 308  - Processor 244 interrupt
    .DATA.L     ESAL_AR_ISR_Proc245_Int         ; 309  - Processor 245 interrupt
    .DATA.L     ESAL_AR_ISR_Proc246_Int         ; 310  - Processor 246 interrupt
    .DATA.L     ESAL_AR_ISR_Proc247_Int         ; 311  - Processor 247 interrupt
    .DATA.L     ESAL_AR_ISR_Proc248_Int         ; 312  - Processor 248 interrupt


;****************************
;* FUNCTIONS DECLARATIONS   *
;****************************

    .SECTION    esal_code, CODE, ALIGN=4

;**********************************
;* LOCAL VARIABLE DECLARATIONS    *
;**********************************

ESAL_AR_STK_Startup_SP:
    .DATA.L     (STARTOF B) + (SIZEOF B) + ESAL_AR_STK_STARTUP_STACK_SIZE

;************************************************************************
;*
;*  FUNCTION
;*
;*      ESAL_AR_ISR_Reserved
;*
;*  DESCRIPTION
;*
;*      This is a stub to trap reserved exceptions.  These should never
;*      occur.
;*
;*  CALLED BY
;*
;*      Reserved Exception
;*
;*  CALLS
;*
;*      None
;*
;*  INPUTS
;*
;*      None
;*
;*  OUTPUTS
;*
;*      None
;*
;************************************************************************    
;VOID   ESAL_AR_ISR_Reserved(VOID)

ESAL_AR_ISR_Reserved

     ; Shouldn't get here - loop endlessly
     
     BRA        ESAL_AR_ISR_Reserved


;************************************************************************
;*
;*  FUNCTION
;*
;*      ESAL_AR_ISR_Exceptions_Start
;*
;*  DESCRIPTION
;*
;*      This is a trampoline for exceptions.  It is used to calculate
;*      the vector ID for a given exception while entering into a
;*      common exception handler function.
;*
;*  CALLED BY
;*
;*      Exception
;*
;*  CALLS
;*
;*      Exception Handler
;*
;*  INPUTS
;*
;*      None
;*
;*  OUTPUTS
;*
;*      None
;*
;************************************************************************
;VOID ESAL_AR_ISR_Exceptions_Start(VOID)

ESAL_AR_ISR_Exceptions_Start:

    ESAL_AR_ISR_EXCEPTION_TRAMPOLINE  ESAL_AR_ISR_Gen_Illegal_Inst
    ESAL_AR_ISR_EXCEPTION_TRAMPOLINE  ESAL_AR_ISR_RAM_Error
    ESAL_AR_ISR_EXCEPTION_TRAMPOLINE  ESAL_AR_ISR_Slot_Illegal_Inst
    ESAL_AR_ISR_EXCEPTION_TRAMPOLINE  ESAL_AR_ISR_CPU_Addr_Error
    ESAL_AR_ISR_EXCEPTION_TRAMPOLINE  ESAL_AR_ISR_Bus_Addr_Error
    ESAL_AR_ISR_EXCEPTION_TRAMPOLINE  ESAL_AR_ISR_FPU_Exception
    ESAL_AR_ISR_EXCEPTION_TRAMPOLINE  ESAL_AR_ISR_HUDI
    ESAL_AR_ISR_EXCEPTION_TRAMPOLINE  ESAL_AR_ISR_Bank_Overflow
    ESAL_AR_ISR_EXCEPTION_TRAMPOLINE  ESAL_AR_ISR_Bank_Underflow
    ESAL_AR_ISR_EXCEPTION_TRAMPOLINE  ESAL_AR_ISR_Int_Div_0
    ESAL_AR_ISR_EXCEPTION_TRAMPOLINE  ESAL_AR_ISR_Int_Div_Overflow
    ESAL_AR_ISR_EXCEPTION_TRAMPOLINE  ESAL_AR_ISR_Trap0
    ESAL_AR_ISR_EXCEPTION_TRAMPOLINE  ESAL_AR_ISR_Trap1
    ESAL_AR_ISR_EXCEPTION_TRAMPOLINE  ESAL_AR_ISR_Trap2
    ESAL_AR_ISR_EXCEPTION_TRAMPOLINE  ESAL_AR_ISR_Trap3
    ESAL_AR_ISR_EXCEPTION_TRAMPOLINE  ESAL_AR_ISR_Trap4
    ESAL_AR_ISR_EXCEPTION_TRAMPOLINE  ESAL_AR_ISR_Trap5
    ESAL_AR_ISR_EXCEPTION_TRAMPOLINE  ESAL_AR_ISR_Trap6
    ESAL_AR_ISR_EXCEPTION_TRAMPOLINE  ESAL_AR_ISR_Trap7
    ESAL_AR_ISR_EXCEPTION_TRAMPOLINE  ESAL_AR_ISR_Trap8
    ESAL_AR_ISR_EXCEPTION_TRAMPOLINE  ESAL_AR_ISR_Trap9
    ESAL_AR_ISR_EXCEPTION_TRAMPOLINE  ESAL_AR_ISR_Trap10
    ESAL_AR_ISR_EXCEPTION_TRAMPOLINE  ESAL_AR_ISR_Trap11
    ESAL_AR_ISR_EXCEPTION_TRAMPOLINE  ESAL_AR_ISR_Trap12
    ESAL_AR_ISR_EXCEPTION_TRAMPOLINE  ESAL_AR_ISR_Trap13
    ESAL_AR_ISR_EXCEPTION_TRAMPOLINE  ESAL_AR_ISR_Trap14
    ESAL_AR_ISR_EXCEPTION_TRAMPOLINE  ESAL_AR_ISR_Trap15
    ESAL_AR_ISR_EXCEPTION_TRAMPOLINE  ESAL_AR_ISR_Trap16
    ESAL_AR_ISR_EXCEPTION_TRAMPOLINE  ESAL_AR_ISR_Trap17
    ESAL_AR_ISR_EXCEPTION_TRAMPOLINE  ESAL_AR_ISR_Trap18
    ESAL_AR_ISR_EXCEPTION_TRAMPOLINE  ESAL_AR_ISR_Trap19
    ESAL_AR_ISR_EXCEPTION_TRAMPOLINE  ESAL_AR_ISR_Trap20
    ESAL_AR_ISR_EXCEPTION_TRAMPOLINE  ESAL_AR_ISR_Trap21
    ESAL_AR_ISR_EXCEPTION_TRAMPOLINE  ESAL_AR_ISR_Trap22
    ESAL_AR_ISR_EXCEPTION_TRAMPOLINE  ESAL_AR_ISR_Trap23
    ESAL_AR_ISR_EXCEPTION_TRAMPOLINE  ESAL_AR_ISR_Trap24
    ESAL_AR_ISR_EXCEPTION_TRAMPOLINE  ESAL_AR_ISR_Trap25
    ESAL_AR_ISR_EXCEPTION_TRAMPOLINE  ESAL_AR_ISR_Trap26
    ESAL_AR_ISR_EXCEPTION_TRAMPOLINE  ESAL_AR_ISR_Trap27
    ESAL_AR_ISR_EXCEPTION_TRAMPOLINE  ESAL_AR_ISR_Trap28
    ESAL_AR_ISR_EXCEPTION_TRAMPOLINE  ESAL_AR_ISR_Trap29
    ESAL_AR_ISR_EXCEPTION_TRAMPOLINE  ESAL_AR_ISR_Trap30
    ESAL_AR_ISR_EXCEPTION_TRAMPOLINE  ESAL_AR_ISR_Trap31


;************************************************************************
;*                                                                      
;*  FUNCTION                                                              
;*                                                                      
;*      ESAL_AR_ISR_Exception_Handler
;*                                                                      
;*  DESCRIPTION                                                           
;*                                                                      
;*      Handler for all exceptions
;*
;*  CALLED BY                                                             
;*                                                                      
;*      Interrupt / Exception Vector Table
;*                                                                      
;*  CALLS                                                                 
;*                                                                      
;*      Registered Exception Handler
;*                                                                      
;*  INPUTS                                                                
;*                                                                      
;*      None
;*                                                                      
;*  OUTPUTS                                                               
;*                                                                      
;*      None
;*                                                                      
;************************************************************************
;static VOID    ESAL_AR_ISR_Exception_Handler(VOID)

ESAL_AR_ISR_Exception_Handler:

    ; Loop forever

    BRA         ESAL_AR_ISR_Exception_Handler
    NOP


;************************************************************************
;*
;*  FUNCTION
;*
;*      ESAL_AR_ISR_Interrupts_Start
;*
;*  DESCRIPTION
;*
;*      This is a trampoline for interrupts.  It is used to calculate
;*      the vector ID for a given interrupt while entering into a
;*      common interrupt handler function.
;*
;*  CALLED BY
;*
;*      Interrupt
;*
;*  CALLS
;*
;*      Interrupt Handler
;*
;*  INPUTS
;*
;*      None
;*
;*  OUTPUTS
;*
;*      None
;*
;************************************************************************
;VOID ESAL_AR_ISR_Interrupts_Start(VOID)

ESAL_AR_ISR_Interrupts_Start:

    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_NMI
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_User_Break
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc0_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc1_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc2_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc3_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc4_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc5_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc6_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc7_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc8_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc9_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc10_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc11_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc12_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc13_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc14_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc15_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc16_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc17_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc18_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc19_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc20_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc21_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc22_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc23_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc24_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc25_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc26_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc27_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc28_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc29_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc30_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc31_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc32_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc33_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc34_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc35_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc36_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc37_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc38_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc39_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc40_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc41_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc42_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc43_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc44_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc45_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc46_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc47_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc48_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc49_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc50_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc51_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc52_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc53_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc54_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc55_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc56_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc57_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc58_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc59_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc60_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc61_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc62_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc63_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc64_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc65_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc66_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc67_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc68_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc69_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc70_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc71_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc72_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc73_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc74_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc75_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc76_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc77_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc78_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc79_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc80_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc81_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc82_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc83_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc84_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc85_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc86_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc87_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc88_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc89_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc90_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc91_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc92_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc93_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc94_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc95_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc96_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc97_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc98_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc99_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc100_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc101_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc102_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc103_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc104_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc105_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc106_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc107_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc108_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc109_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc110_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc111_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc112_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc113_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc114_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc115_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc116_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc117_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc118_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc119_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc120_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc121_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc122_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc123_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc124_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc125_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc126_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc127_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc128_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc129_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc130_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc131_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc132_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc133_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc134_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc135_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc136_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc137_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc138_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc139_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc140_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc141_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc142_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc143_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc144_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc145_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc146_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc147_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc148_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc149_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc150_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc151_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc152_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc153_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc154_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc155_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc156_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc157_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc158_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc159_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc160_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc161_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc162_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc163_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc164_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc165_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc166_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc167_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc168_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc169_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc170_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc171_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc172_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc173_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc174_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc175_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc176_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc177_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc178_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc179_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc180_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc181_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc182_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc183_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc184_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc185_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc186_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc187_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc188_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc189_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc190_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc191_Int
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc192_Int  
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc193_Int         
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc194_Int         
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc195_Int         
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc196_Int         
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc197_Int         
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc198_Int         
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc199_Int         
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc200_Int         
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc201_Int         
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc202_Int         
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc203_Int         
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc204_Int         
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc205_Int         
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc206_Int         
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc207_Int         
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc208_Int         
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc209_Int         
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc210_Int         
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc211_Int         
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc212_Int         
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc213_Int         
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc214_Int         
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc215_Int         
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc216_Int         
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc217_Int         
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc218_Int         
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc219_Int         
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc220_Int         
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc221_Int         
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc222_Int         
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc223_Int         
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc224_Int         
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc225_Int         
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc226_Int         
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc227_Int         
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc228_Int         
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc229_Int         
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc230_Int         
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc231_Int         
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc232_Int         
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc233_Int         
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc234_Int         
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc235_Int         
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc236_Int         
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc237_Int         
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc238_Int         
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc239_Int         
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc240_Int         
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc241_Int         
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc242_Int         
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc243_Int         
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc244_Int         
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc245_Int         
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc246_Int         
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc247_Int         
    ESAL_AR_ISR_INTERRUPT_TRAMPOLINE  ESAL_AR_ISR_Proc248_Int         


;************************************************************************
;*                                                                      
;*  FUNCTION                                                              
;*                                                                      
;*      ESAL_AR_ISR_Interrupt_Handler
;*                                                                      
;*  DESCRIPTION                                                           
;*                                                                      
;*      Handler for all interrupts
;*
;*  CALLED BY                                                             
;*                                                                      
;*      Interrupt / Exception Vector Table
;*                                                                      
;*  CALLS                                                                 
;*                                                                      
;*      OS interrupt entry
;*                                                                      
;*  INPUTS                                                                
;*                                                                      
;*      None
;*                                                                      
;*  OUTPUTS                                                               
;*                                                                      
;*      None
;*                                                                      
;************************************************************************
;static VOID    ESAL_AR_ISR_Interrupt_Handler(VOID)

ESAL_AR_ISR_Interrupt_Handler:

    .AIF    \&ESAL_AR_ISR_HOOK_ENABLED EQ 1

    ; Execute ISR Hook

    ESAL_AR_ISR_HOOK_EXECUTE
    
    .AENDI  ; ESAL_AR_ISR_HOOK_ENABLED

    ; Save minimum context for interrupt

    ESAL_AR_STK_MIN_SAVE

    ; Isoloate lower 8 bits of vector number

    EXTU.B      R4,R4
    
    ; Check if this interrupt occurred during execution of
    ; another interrupt (nested)
    
    MOV.L       #_ESAL_GE_ISR_Executing, R0
    MOV.L       @R0,R0
    CMP/EQ      #0,R0
    BF          ESAL_AR_ISR_Nested_Interrupt

    ; Check for special case of nested interrupt
    ; Get offset of SR on stack

    MOV         #ESAL_AR_ISR_SR_OFFSET,R0

    ; Read SR from stack

    MOV.L       @(R0,R15),R0

    ; Move imask bits into lower 4-bits and isolate them

    SHLR2       R0
    SHLR2       R0
    AND         #ESAL_AR_ISR_IMASK_ISOLATE,R0

    ; Check if interrupts were enabled when interrupt occurred

    CMP/EQ      #(ESAL_AR_INTERRUPTS_ENABLE_BITS>>4),R0

    ; Nested condition exists, branch to nested interrupt label

    BF          ESAL_AR_ISR_Nested_Interrupt

    ; Move stack pointer in R5 (2nd parameter register)
    
    MOV         R15,R5

    ; Switch to system stack for non-nested interrupts
   
    MOV.L       #_ESAL_GE_STK_System_SP,R0 
    MOV.L       @R0,R15

    ; Get address of OS entry for non-nested interrupt

    MOV.L       #_ESAL_GE_ISR_OS_Entry,R0
    MOV.L       @R0,R0

    ; Jump to OS non-nested interrupt handler

    JSR         @R0
    NOP

    ; Save return value in R4

    MOV         R0,R4

    ; Check if context switch is required as a result of 
    ; the interrupt service routine

    MOV.L       #_ESAL_GE_STK_Unsol_Switch_Req,R0
    MOV.L       @R0,R0
    CMP/EQ      #0,R0

    ; Skip context switch if flag is 0
    
    BT          ESAL_AR_ISR_Interrupt_Return
    
    ; Perform context switch if required
    
    MOV.L       #ESAL_AR_STK_Unsolicited_Switch,R0
    JMP         @R0
    NOP
    
ESAL_AR_ISR_Interrupt_Return:
    
    ; No context switch required, restore minimal context and
    ; return to point of interrupt

    ; Switch back to original stack

    MOV.L       @R4,R15

    ; Restore minimum registers from stack

    ESAL_AR_STK_MIN_RESTORE

    ; Return from interrupt

    RTE
    NOP

ESAL_AR_ISR_Nested_Interrupt:

    ; Get address of OS entry for nested interrupt

    MOV.L       #_ESAL_GE_ISR_OS_Nested_Entry,R0
    MOV.L       @R0,R0

    ; Jump to OS nested interrupt handler

    JSR         @R0
    NOP

    ; Restore minimum registers from stack

    ESAL_AR_STK_MIN_RESTORE

    ; Return from interrupt

    RTE
    NOP


;************************************************************************
;*
;*   FUNCTION
;*
;*       ESAL_Entry
;*
;*   DESCRIPTION
;*
;*       This function is the entry point into ESAL.  Entry to this
;*       function is normally done through the reset mechanism
;*       (reset vector, jump from reset handler, etc) on the given
;*       processor / architecture.
;*
;*   CALLED BY
;*
;*       Reset
;*
;*   CALLS
;*
;*       ESAL_AR_STK_Startup_SP_Set
;*
;*   INPUTS
;*
;*       None
;*
;*   OUTPUTS
;*
;*       None
;*
;***********************************************************************/
;VOID    ESAL_Entry(VOID)

    ; Define the entry point for the debugger

    .EXPORT    ESAL_Entry
ESAL_Entry:

    ; Check if running from ROM (ROM support enabled)

    MOV.L       #_ESAL_GE_MEM_ROM_Support_Enabled,R0
    MOV.L       @R0,R0 
    CMP/EQ      #0,R0
    BT          ESAL_Entry_ROM_Support_End

    ; Initialize memory controllers, chip-selects, etc, to allow
    ; access to volatile memory (RAM) when running from ROM.  Access
    ; to this memory must be done before entering a C environment
    ; so the stack can be set-up / utilized.
    ; NOTE:    When executing from RAM (debug environment) these operations
    ;          are normally performed by the debugger (via an initialization
    ;          script) or by a monitor or boot code on the target hardware.


    
ESAL_Entry_ROM_Support_End:

    ; Transfer control to ESAL_AR_STK_Startup_SP_Set function
    ; NOTE:   Control will not return here

    BRA         ESAL_AR_STK_Startup_SP_Set
    NOP


;************************************************************************
;*
;*   FUNCTION
;*
;*       ESAL_AR_STK_Unsolicited_Restore
;*
;*   DESCRIPTION
;*
;*       This function restores the context of a stack frame as required
;*       by a given architecture (stack frame that contains all registers
;*       used by a given architecture)
;*
;*   CALLED BY
;*
;*       Operating System Services
;*
;*   CALLS
;*
;*       None
;*
;*   INPUTS
;*
;*       r0                                  Stack pointer of
;*                                           stack frame to be restored
;*
;*   OUTPUTS
;*
;*       None
;*
;***********************************************************************
;VOID    ESAL_AR_STK_Unsolicited_Restore(VOID *stack_ptr)

    .EXPORT    _ESAL_AR_STK_Unsolicited_Restore
_ESAL_AR_STK_Unsolicited_Restore:

    ; Switch to the passed-in stack pointer

    MOV         R4,R15

    ; Skip stack type

    ADD         #4,R15

    ; Restore registers from stack

    MOV.L       @R15+,R8
    MOV.L       @R15+,R9
    MOV.L       @R15+,R10
    MOV.L       @R15+,R11
    MOV.L       @R15+,R12
    MOV.L       @R15+,R13
    MOV.L       @R15+,R14
    LDC.L       @R15+,GBR
    LDS.L       @R15+,MACH
    LDS.L       @R15+,MACL

    .AIF    \&ESAL_AR_STK_FPU_SUPPORT EQ 1

    ; Restore floating point stats / control register

    LDS.L       @R15+,FPSCR
    
    ; Restore floating point registers

    FMOV.S      @R15+,FR0
    FMOV.S      @R15+,FR1
    FMOV.S      @R15+,FR2
    FMOV.S      @R15+,FR3
    FMOV.S      @R15+,FR4
    FMOV.S      @R15+,FR5
    FMOV.S      @R15+,FR6
    FMOV.S      @R15+,FR7
    FMOV.S      @R15+,FR8
    FMOV.S      @R15+,FR9
    FMOV.S      @R15+,FR10
    FMOV.S      @R15+,FR11
    FMOV.S      @R15+,FR12
    FMOV.S      @R15+,FR13
    FMOV.S      @R15+,FR14
    FMOV.S      @R15+,FR15

    .AENDI

    ESAL_AR_STK_MIN_RESTORE

    ; Return from interrupt

    RTE
    NOP


;***********************************************************************
;*
;*   FUNCTION
;*
;*       ESAL_AR_STK_Unsolicited_Switch
;*
;*   DESCRIPTION
;*
;*       This function saves the entire architecture context on the
;*       given stack and passes control to the OS
;*
;*   CALLED BY
;*
;*       Operating System Services
;*
;*   CALLS
;*
;*       None
;*
;*   INPUTS
;*
;*       r0                                  Pointer to stack pointer
;*
;*   OUTPUTS
;*
;*       None
;*
;***********************************************************************
;VOID  ESAL_AR_STK_Unsolicited_Switch(VOID **stack_ptr)

    .EXPORT    ESAL_AR_STK_Unsolicited_Switch
ESAL_AR_STK_Unsolicited_Switch:

    ; Get stack pointer

    MOV.L       @R4,R15

    .AIF    \&ESAL_AR_STK_FPU_SUPPORT EQ 1

    ; Save floating point registers

    FMOV.S      FR15,@-R15
    FMOV.S      FR14,@-R15
    FMOV.S      FR13,@-R15
    FMOV.S      FR12,@-R15
    FMOV.S      FR11,@-R15
    FMOV.S      FR10,@-R15
    FMOV.S      FR9,@-R15
    FMOV.S      FR8,@-R15
    FMOV.S      FR7,@-R15
    FMOV.S      FR6,@-R15
    FMOV.S      FR5,@-R15
    FMOV.S      FR4,@-R15
    FMOV.S      FR3,@-R15
    FMOV.S      FR2,@-R15
    FMOV.S      FR1,@-R15
    FMOV.S      FR0,@-R15

    ; Save floating point stats / control register

    STS.L       FPSCR,@-R15
    
    .AENDI

    ; Save remaining registers on stack

    STS.L       MACL,@-R15
    STS.L       MACH,@-R15
    STC.L       GBR,@-R15
    MOV.L       R14,@-R15
    MOV.L       R13,@-R15
    MOV.L       R12,@-R15
    MOV.L       R11,@-R15
    MOV.L       R10,@-R15
    MOV.L       R9,@-R15
    MOV.L       R8,@-R15

    ; Save stack type on stack (1 = unsolicited)

    MOV         #1,R8
    MOV.L       R8,@-R15
    
    ; Save new stack pointer in save location

    MOV.L       R15,@R4

    ; Switch to the system stack

    MOV.L       #_ESAL_GE_STK_System_SP,R0 
    MOV.L       @R0,R15

    ; Clear switch flag

    MOV.L       #_ESAL_GE_STK_Unsol_Switch_Req,R0
    MOV         #0,R8
    MOV.L       R8,@R0

    ; Transfer control to OS unsolicited stack switch entry point

    MOV.L       #_ESAL_GE_STK_Unsol_Switch_OS_Entry,R0
    MOV.L       @R0, R0
    JMP         @R0
    NOP


;************************************************************************
;*
;*  FUNCTION
;*
;*      ESAL_AR_STK_Startup_SP_Set
;*
;*  DESCRIPTION
;*
;*      This function sets the architecture stack pointer to an address
;*      that can be used during initialization.  This can include on-chip
;*      SRAM, available RAM not used by the application during
;*      initialization, etc.
;*
;*  CALLED BY
;*
;*      ESAL_Entry
;*
;*  CALLS
;*
;*      ESAL_TS_RTE_Lowlevel_Initialize
;*
;*  INPUTS
;*
;*      None
;*
;*  OUTPUTS
;*
;*      None
;*
;************************************************************************
;VOID    ESAL_AR_STK_Startup_SP_Set(VOID)

    .EXPORT    ESAL_AR_STK_Startup_SP_Set
ESAL_AR_STK_Startup_SP_Set:

    ; Get start address of available memory that can be used for the
    ; startup stack.

    MOV.L       #ESAL_AR_STK_Startup_SP,R0
    MOV.L       @R0,R15

    ; Align stack (clear bottom 2-bits for 4-byte aligned stack)

    SHLR2       R15
    SHLL2       R15
    
    ; Jump to toolset run-time environment setup function - control will not return.

    BRA         ESAL_TS_RTE_Lowlevel_Initialize
    NOP


;************************************************************************
;*
;*   FUNCTION
;*
;*       ESAL_TS_RTE_Lowlevel_Initialize
;*
;*   DESCRIPTION
;*
;*       This function initializes registers and hardware as required
;*       for a run-time environment.  Many toolsets require a certain
;*       environment to be set-up to allow correct run-time execution
;*       in a C environment.  This may include initializing certain
;*       architecture registers (base registers, mode registers, etc)
;*       and anything else specified in the toolset documentation.
;*
;*   CALLED BY
;*
;*       ESAL_AR_STK_Startup_SP_Set
;*
;*   CALLS
;*
;*       OS_Init_Entry                          OS Entry Point
;*
;*   INPUTS
;*
;*       None
;*
;*   OUTPUTS
;*
;*       None
;*
;************************************************************************
;VOID    ESAL_TS_RTE_Lowlevel_Initialize(VOID)

    .EXPORT    ESAL_TS_RTE_Lowlevel_Initialize
ESAL_TS_RTE_Lowlevel_Initialize:

    ; Zero out the pr to provide a nicer debug environment (call stack-trace)

    MOV         #0,R0
    LDS         R0,PR

    ; Call OS entry point
    ; NOTE:   Control will not return here

    MOV.L       #_OS_Init_Entry, R0
    JMP         @R0
    NOP


;************************************************************************
;*
;*  FUNCTION
;*
;*      ESAL_TS_STK_Solicited_Restore
;*
;*  DESCRIPTION
;*
;*      This function restores the context of a stack frame as required
;*      by a given toolset (stack frame that contains registers
;*      required to be saved across function call boundaries)
;*
;*  CALLED BY
;*
;*      Operating System Services
;*
;*  CALLS
;*
;*      None
;*
;*  INPUTS
;*
;*      stack_ptr                           Stack pointer of
;*                                          stack frame to be restored
;*
;*  OUTPUTS
;*
;*      None
;*
;************************************************************************
;VOID    ESAL_TS_STK_Solicited_Restore(VOID *stack_ptr)

    .EXPORT    _ESAL_TS_STK_Solicited_Restore
_ESAL_TS_STK_Solicited_Restore:

    ; Switch to the passed-in stack pointer

    MOV         R4,R15

    ; Skip stack type

    ADD         #4,R15

    ; Restore all registers stored in the solicited
    ; stack frame.

    MOV.L       @R15+,R8
    MOV.L       @R15+,R9
    MOV.L       @R15+,R10
    MOV.L       @R15+,R11
    MOV.L       @R15+,R12
    MOV.L       @R15+,R13
    MOV.L       @R15+,R14
    LDC.L       @R15+,GBR
    LDS.L       @R15+,MACH
    LDS.L       @R15+,MACL
    LDS.L       @R15+,PR

    .AIF    \&ESAL_AR_STK_FPU_SUPPORT EQ 1

    ; Restore floating point registers
  
    FMOV.S      @R15+,FR12
    FMOV.S      @R15+,FR13
    FMOV.S      @R15+,FR14
    FMOV.S      @R15+,FR15
    
    .AENDI

    ; Use the architecture's return from function call 
    ; mechanism to transfer control to the stack frame
    ; return address.

    RTS
    NOP


;************************************************************************
;*
;*  FUNCTION
;*
;*      ESAL_TS_STK_Solicited_Switch
;*
;*  DESCRIPTION
;*
;*      This function saves the necessary registers, designated by a
;*      given toolset, to be preserved across a function call
;*      boundary.  Control is then transferred to the designated
;*      call-back function with the designated call-back parameter.
;*
;*  CALLED BY
;*
;*      Operating System Services
;*
;*  CALLS
;*
;*      <call back function>
;*
;*  INPUTS
;*
;*      call_back_param                     Parameter passed to callback
;*                                          function
;*      call_back                           Call back function pointer
;*      stack_ptr                           Pointer to stack pointer
;*                                          storage address
;*
;*  OUTPUTS
;*
;*      None
;*
;************************************************************************
;VOID    ESAL_TS_STK_Solicited_Switch(VOID *call_back_param,
;                                     VOID (*call_back)(VOID),
;                                     VOID **stack_ptr)

    .EXPORT    _ESAL_TS_STK_Solicited_Switch
_ESAL_TS_STK_Solicited_Switch:

    .AIF    \&ESAL_AR_STK_FPU_SUPPORT EQ 1
    
    ; Save required floating point registers on the current stack.

    FMOV.S      FR15,@-R15
    FMOV.S      FR14,@-R15
    FMOV.S      FR13,@-R15
    FMOV.S      FR12,@-R15

    .AENDI

    ; Save the toolset required registers to the current stack.  
    ; NOTE:   The format of this stack frame is contained in esal_ts_stk_defs.h
    ;         (structure name is ESAL_TS_STK).
    
    STS.L       PR,@-R15
    STS.L       MACL,@-R15
    STS.L       MACH,@-R15
    STC.L       GBR,@-R15
    MOV.L       R14,@-R15
    MOV.L       R13,@-R15
    MOV.L       R12,@-R15
    MOV.L       R11,@-R15
    MOV.L       R10,@-R15
    MOV.L       R9,@-R15
    MOV.L       R8,@-R15

    ; Save stack type (solicited stack = 0) on top of stack

    MOV         #0,R8
    MOV.L       R8,@-R15

    ; Save resultant stack pointer back to location passed in

    MOV.L       R15,@R6

    ; Switch to the system stack

    MOV.L       #_ESAL_GE_STK_System_SP,R0 
    MOV.L       @R0,R15

    ; Transfer control to callback function (call-back parameter is
    ; already in register r5).

    JMP         @R5
    NOP


;************************************************************************
;*
;*   FUNCTION
;*
;*       ESAL_TS_RTE_SP_Write
;*
;*   DESCRIPTION
;*
;*       This function writes the stack pointer.  This function is only
;*       used by toolsets where this operation cannot be done with inline
;*       assembler.
;*
;*   CALLED BY
;*
;*       OS Services
;*       ESAL_AR_ISR_Initialize
;*
;*   CALLS
;*
;*       None
;*
;*   INPUTS
;*
;*       stk_ptr                                     Stack pointer to set
;*
;*   OUTPUTS
;*
;*       None
;*
;************************************************************************
;VOID    ESAL_TS_RTE_SP_Write(VOID *stk_ptr)

    .EXPORT    _ESAL_TS_RTE_SP_Write
_ESAL_TS_RTE_SP_Write:

    ; Set the stack pointer (delay slot)
    ; Return to caller

    RTS
    MOV         R4,R15  


;************************************************************************
;*
;*   FUNCTION
;*
;*       ESAL_TS_RTE_SP_Read
;*
;*   DESCRIPTION
;*
;*       This function reads the stack pointer.  This function is only
;*       used by toolsets where this operation cannot be done with inline
;*       assembler.
;*
;*   CALLED BY
;*
;*       OS Services
;*
;*   CALLS
;*
;*       None
;*
;*   INPUTS
;*
;*       None
;*
;*   OUTPUTS
;*
;*       stack pointer
;*
;************************************************************************
;VOID *   ESAL_TS_RTE_SP_Read(VOID)

    .EXPORT    _ESAL_TS_RTE_SP_Read
_ESAL_TS_RTE_SP_Read:

    ; Get the stack pointer (delay slot)
    ; Return to caller

    RTS
    MOV         R15,R0    
    .END
