/***********************************************************************
*
*             Copyright 2011 Mentor Graphics Corporation
*                         All Rights Reserved.
*
* THIS WORK CONTAINS TRADE SECRET AND PROPRIETARY INFORMATION WHICH IS
* THE PROPERTY OF MENTOR GRAPHICS CORPORATION OR ITS LICENSORS AND IS
* SUBJECT TO LICENSE TERMS.
*
************************************************************************

************************************************************************
*
*   FILE NAME
*
*       sh_debug.c
*
*   DESCRIPTION
*
*       This file contains the Renesas SuperH architecture debug functions
*
*   FUNCTIONS
*
*       ESAL_AR_DBG_Initialize
*       ESAL_AR_DBG_Terminate
*       ESAL_AR_DBG_Reg_Mappings_Get_Offset
*       ESAL_AR_DBG_Reg_Read
*       ESAL_AR_DBG_Reg_Write
*       ESAL_AR_DBG_Opcode_Read
*       ESAL_AR_DBG_Opcode_Write
*       ESAL_AR_DBG_Opcode_Nop_Get
*       ESAL_AR_DBG_Opcode_Brk_Get
*       ESAL_AR_DBG_Step_Addr_Get
*       ESAL_AR_DBG_Set_Protocol
*       ESAL_AR_DBG_Reg_Block_Read
*       ESAL_AR_DBG_Reg_Block_Write
*       ESAL_AR_DBG_Reg_Expedite_Read
*       ESAL_AR_DBG_Hardware_Step
*       ESAL_AR_DBG_Get_Support_Flags
*
*   DEPENDENCIES
*
*       nucleus.h                 Contains system constants common to both the
*                                 application and the actual Nucleus PLUS components.
*       nu_kernel.h               Contains kernel constants common to both the
*                                 application and the actual Nucleus PLUS kernel.
*
***********************************************************************/

/* Include required header files */
#include "nucleus.h"
#include "kernel/nu_kernel.h"

/***********************************************************************
*
*   FUNCTION
*
*       ESAL_AR_DBG_Initialize
*
*   DESCRIPTION
*
*       This function initializes debugging at architecture level
*
*   CALLED BY
*
*       OS Services
*
*   CALLS
*
*       None
*
*   INPUTS
*
*       None
*
*   OUTPUTS
*
*       None
*
***********************************************************************/
VOID    ESAL_AR_DBG_Initialize(VOID)
{
}
     
/***********************************************************************
*
*   FUNCTION
*
*       ESAL_AR_DBG_Terminate
*
*   DESCRIPTION
*
*       This function terminates debugging at architecture level
*
*   CALLED BY
*
*       OS Services
*
*   CALLS
*
*       None
*
*   INPUTS
*
*       None
*
*   OUTPUTS
*
*       None
*
***********************************************************************/
VOID    ESAL_AR_DBG_Terminate(VOID)
{
}

/***********************************************************************
*
*   FUNCTION
*
*       ESAL_AR_DBG_Reg_Mappings_Get_Offset
*
*   DESCRIPTION
*
*       This function returns the offset of a register in a stack frame
*       if the register parameter is valid.
*
*   CALLED BY
*
*       OS Services
*
*   CALLS
*
*       None
*
*   INPUTS
*
*       reg_no                              Register number
*
*   OUTPUTS
*
*       INT                                 Offset of specified register 
*                                           or a value indicating that
*                                           the register is not mapped.
*
***********************************************************************/
INT     ESAL_AR_DBG_Reg_Mappings_Get_Offset(INT reg_no)
{
    /* Ensure unused parameter doesn't cause tool warnings */
    NU_UNUSED_PARAM(reg_no);

    /* Return NU_TRUE */
    return (NU_TRUE);
}

/***********************************************************************
*
*   FUNCTION
*
*       ESAL_AR_DBG_Reg_Read
*
*   DESCRIPTION
*
*       This function reads register stored in stack
*
*   CALLED BY
*
*       OS Services
*
*   CALLS
*
*       None
*
*   INPUTS
*
*       p_stack_frame                       Start address of stack memory
*       stack_frame_type                    stack frame type
*       reg_no                              Register number
*       reg_val                             Register value for return
*
*   OUTPUTS
*
*       NU_TRUE or NU_FALSE
*
***********************************************************************/
INT    ESAL_AR_DBG_Reg_Read(VOID * p_stack_frame, INT stack_frame_type, INT reg_no, ESAL_GE_DBG_REG *reg_val)
{
    /* Ensure unused parameter doesn't cause tool warnings */
    NU_UNUSED_PARAM(p_stack_frame);
    NU_UNUSED_PARAM(stack_frame_type);
    NU_UNUSED_PARAM(reg_no);
    NU_UNUSED_PARAM(reg_val);

    /* Return NU_TRUE */
    return(NU_TRUE);
}

/***********************************************************************
*
*   FUNCTION
*
*       ESAL_AR_DBG_Reg_Write
*
*   DESCRIPTION
*
*       This function write register stored in stack
*
*   CALLED BY
*
*       OS Services
*
*   CALLS
*
*       None
*
*   INPUTS
*
*       p_stack_frame                       Start address of stack memory
*       stack_frame_type                    stack frame type
*       reg_no                              Register number
*       reg_val                             Register value to write
*
*   OUTPUTS
*
*       NU_TRUE or NU_FALSE
*
***********************************************************************/
INT    ESAL_AR_DBG_Reg_Write(VOID *p_stack_frame, INT stack_frame_type, INT reg_no, ESAL_GE_DBG_REG *reg_val)
{
    /* Ensure unused parameter doesn't cause tool warnings */
    NU_UNUSED_PARAM(p_stack_frame);
    NU_UNUSED_PARAM(stack_frame_type);
    NU_UNUSED_PARAM(reg_no);
    NU_UNUSED_PARAM(reg_val);

    /* Return NU_TRUE */
    return (NU_TRUE);
}

/***********************************************************************
*
*   FUNCTION
*
*       ESAL_AR_DBG_Opcode_Read
*
*   DESCRIPTION
*
*       This function reads 4 byte (or 2 byte for thumb) instruction
*
*   CALLED BY
*
*       OS Services
*
*   CALLS
*
*       None
*
*   INPUTS
*
*       read_addr                           Address to read
*
*   OUTPUTS
*
*       instruction
*
***********************************************************************/
ESAL_GE_DBG_OPCODE  ESAL_AR_DBG_Opcode_Read(VOID *read_addr)
{
    /* Ensure unused parameter doesn't cause tool warnings */
    NU_UNUSED_PARAM(read_addr);

    /* Return NU_NULL */
    return (NU_NULL);
}

/***********************************************************************
*
*   FUNCTION
*
*       ESAL_AR_DBG_Opcode_Write
*
*   DESCRIPTION
*
*       This function writes 4 byte (or 2 byte for thumb) instruction
*
*   CALLED BY
*
*       OS Services
*
*   CALLS
*
*       None
*
*   INPUTS
*
*       write_addr                          Address to write
*       opcode                              Value to write
*
*   OUTPUTS
*
*       None
*
***********************************************************************/
VOID    ESAL_AR_DBG_Opcode_Write(VOID *write_addr, 
                                 ESAL_GE_DBG_OPCODE opcode)
{
    /* Ensure unused parameter doesn't cause tool warnings */
    NU_UNUSED_PARAM(write_addr);
    NU_UNUSED_PARAM(opcode);
}

/***********************************************************************
*
*   FUNCTION
*
*       ESAL_AR_DBG_Opcode_Nop_Get
*
*   DESCRIPTION
*
*       This function returns NOP opcode depending on its mode
*
*   CALLED BY
*
*       OS Services
*
*   CALLS
*
*       None
*
*   INPUTS
*
*       addr                                Address to check
*
*   OUTPUTS
*
*       NOP opcode
*
***********************************************************************/
ESAL_GE_DBG_OPCODE  ESAL_AR_DBG_Opcode_Nop_Get(VOID *addr)
{
    /* Ensure unused parameter doesn't cause tool warnings */
    NU_UNUSED_PARAM(addr);

    /* Return NU_NULL */
    return (NU_NULL);
}

/***********************************************************************
*
*   FUNCTION
*
*       ESAL_AR_DBG_Opcode_Brk_Get
*
*   DESCRIPTION
*
*       This function returns breakpoint opcode depending on its mode
*
*   CALLED BY
*
*       OS Services
*
*   CALLS
*
*       None
*
*   INPUTS
*
*       addr                                Address to check
*
*   OUTPUTS
*
*       Breakpoint opcode
*
***********************************************************************/
ESAL_GE_DBG_OPCODE  ESAL_AR_DBG_Opcode_Brk_Get(VOID *addr)
{
    /* Ensure unused parameter doesn't cause tool warnings */
    NU_UNUSED_PARAM(addr);

    /* Return NU_NULL */
    return (NU_NULL);
}

/***********************************************************************
*
*   FUNCTION
*
*       ESAL_AR_DBG_Step_Addr_Get
*
*   DESCRIPTION
*
*       This function returns next program counter from given instruction
*
*   CALLED BY
*
*       OS Services
*
*   CALLS
*
*       None
*
*   INPUTS
*
*       addr                                Address of current instruction
*       p_stack_frame                       Start address of stack memory
*       stack_frame_type                    stack frame type
*
*   OUTPUTS
*
*       Next program counter
*
***********************************************************************/
VOID    *ESAL_AR_DBG_Step_Addr_Get(VOID *addr, VOID *p_stack_frame, INT stack_frame_type)
{
    /* Ensure unused parameter doesn't cause tool warnings */
    NU_UNUSED_PARAM(addr);
    NU_UNUSED_PARAM(p_stack_frame);
    NU_UNUSED_PARAM(stack_frame_type);

    /* Return NU_NULL */
    return (NU_NULL);
}

/***********************************************************************
*
*   FUNCTION
*
*       ESAL_AR_DBG_Set_Protocol
*
*   DESCRIPTION
*
*       This function returns the register model for the protocol
*       set by the debugging agent OS service.
*
*   CALLED BY
*
*       OS Services
*
*   CALLS
*
*       None
*
*   INPUTS
*
*       dbg_prot                            debug protocol to use
*       stk_ptr                             Obtains the stack pointer
*                                           register id     
*       pc                                  Obtains the pc register id
*
*   OUTPUTS
*
*       NU_TRUE or NU_FALSE
*
***********************************************************************/
INT ESAL_AR_DBG_Set_Protocol(UINT8  dbg_prot, UINT8*    stk_ptr, UINT8* pc)
{
    /* Ensure unused parameter doesn't cause tool warnings */
    NU_UNUSED_PARAM(dbg_prot);
    NU_UNUSED_PARAM(stk_ptr);
    NU_UNUSED_PARAM(pc);

    /* Return NU_TRUE */
    return (NU_TRUE);
}

/***********************************************************************
*
*   FUNCTION
*
*       ESAL_AR_DBG_Reg_Block_Read
*
*   DESCRIPTION
*
*       This function reads a block of registers stored in the stack
*
*   CALLED BY
*
*       OS Services
*
*   CALLS
*
*       None
*
*   INPUTS
*
*       p_stack_frame                       Start address of stack mem
*       stack_frame_type                    stack frame type
*       reg_buff                            Buffer address to copy 
*                                           register block.
*
*   OUTPUTS
*
*       NU_TRUE or NU_FALSE
*
***********************************************************************/
INT ESAL_AR_DBG_Reg_Block_Read(VOID *p_stack_frame, INT stack_frame_type, VOID* reg_buff, UINT32* blk_size)
{
    /* Ensure unused parameter doesn't cause tool warnings */
    NU_UNUSED_PARAM(p_stack_frame);
    NU_UNUSED_PARAM(stack_frame_type);
    NU_UNUSED_PARAM(reg_buff);
    NU_UNUSED_PARAM(blk_size);

    /* Return NU_TRUE */
    return (NU_TRUE);
}

/***********************************************************************
*
*   FUNCTION
*
*       ESAL_AR_DBG_Reg_Block_Write
*
*   DESCRIPTION
*
*       This function writes a block of registers stored in the stack
*
*   CALLED BY
*
*       OS Services
*
*   CALLS
*
*       None
*
*   INPUTS
*
*       p_stack_frame                       Start address of stack mem
*       stack_frame_type                    stack frame type
*       reg_buff                            Buffer containing reg block
*
*   OUTPUTS
*
*       NU_TRUE or NU_FALSE
*
***********************************************************************/
INT ESAL_AR_DBG_Reg_Block_Write(VOID *p_stack_frame, INT stack_frame_type, VOID* reg_buff)
{
    /* Ensure unused parameter doesn't cause tool warnings */
    NU_UNUSED_PARAM(p_stack_frame);
    NU_UNUSED_PARAM(stack_frame_type);
    NU_UNUSED_PARAM(reg_buff);

    /* Return NU_TRUE */
    return (NU_TRUE);
}

/***********************************************************************
*
*   FUNCTION
*
*       ESAL_AR_DBG_Reg_Expedite_Read
*
*   DESCRIPTION
*
*       This function reads the registers needed for a stop reply packet.
*
*   CALLED BY
*
*       OS Services
*
*   CALLS
*
*       None
*
*   INPUTS
*
*       p_stack_frame                       Start address of stack memory
*       stack_frame_type                    stack frame type
*       reg_buff                            Buffer address to copy 
*                                           register block.
*
*   OUTPUTS
*
*       NU_TRUE or NU_FALSE
*
***********************************************************************/
INT ESAL_AR_DBG_Reg_Expedite_Read(VOID *p_stack_frame, INT stack_frame_type, VOID* reg_buff, UINT32* blk_size)
{
    /* Ensure unused parameter doesn't cause tool warnings */
    NU_UNUSED_PARAM(p_stack_frame);
    NU_UNUSED_PARAM(stack_frame_type);
    NU_UNUSED_PARAM(reg_buff);
    NU_UNUSED_PARAM(blk_size);

    /* Return NU_TRUE */
    return (NU_TRUE);
}

/*************************************************************************
*
*   FUNCTION
*
*       ESAL_AR_DBG_Hardware_Step
*
*   DESCRIPTION
*
*       This function performs a hardware-supported step operation.
*
*   CALLED BY
*
*       OS Services
*
*   CALLS
*
*       None
*
*   INPUTS
*
*       p_stack_frame                       Start address of stack mem
*       stack_frame_type                    Type of stack frame
*
*   OUTPUTS
*
*       NU_TRUE or NU_FALSE
*
*************************************************************************/
INT ESAL_AR_DBG_Hardware_Step(VOID * p_stack_frame, INT stack_frame_type) 
{
    /* Ensure unused parameter doesn't cause tool warnings */
    NU_UNUSED_PARAM(p_stack_frame);
    NU_UNUSED_PARAM(stack_frame_type);

    /* Return NU_TRUE */
    return (NU_TRUE);
}

/*************************************************************************
*
*   FUNCTION
*
*       ESAL_AR_DBG_Get_Support_Flags
*
*   DESCRIPTION
*
*       This function retreives the debug support flags.
*
*   CALLED BY
*
*       OS Services
*
*   CALLS
*
*       None
*
*   INPUTS
*
*       flags                           The debug support flags value.
*
*   OUTPUTS
*
*       NU_TRUE or NU_FALSE
*
*************************************************************************/
INT ESAL_AR_DBG_Get_Support_Flags(UINT32 * flags)
{
    /* Ensure unused parameter doesn't cause tool warnings */
    NU_UNUSED_PARAM(flags);

    /* Return NU_TRUE */
    return (NU_TRUE);
}
