/************************************************************************
 *
 *             Copyright 2011 Mentor Graphics Corporation
 *                         All Rights Reserved.
 *
 * THIS WORK CONTAINS TRADE SECRET AND PROPRIETARY INFORMATION WHICH IS
 * THE PROPERTY OF MENTOR GRAPHICS CORPORATION OR ITS LICENSORS AND IS
 * SUBJECT TO LICENSE TERMS.
 *
 ************************************************************************/

/************************************************************************
 *
 *  FILE NAME
 *
 *
 *  DESCRIPTION
 *
 *      This file contains the PPC vector table support
 *
 *  FUNCTIONS
 *
 *      Vector Table entries
 *
 *  DEPENDENCIES
 *
 *      nucleus_gen_cfg.h
 *      csgnu_ppc_defs.inc
 *
 *************************************************************************/

#****************************
#* INCLUDE NECESSARY FILES  *
#****************************

    #include    "nucleus_gen_cfg.h"
    #include    "csgnu_ppc_defs.inc"

#**********************************
#* EXTERNAL FUNCTION DECLARATIONS *
#**********************************

    .extern ESAL_Entry
    .extern ESAL_AR_ISR_Nested_Crit_ISR

#if (CFG_NU_OS_ARCH_PPC_COM_ISR_HOOK_ENABLED == 1)

    .extern ESAL_AR_ISR_HOOK

#endif

#****************************
#* VECTOR TABLE DECLARATION *
#****************************

    .sect       esal_vectors,"ax"

#************************************************************************
#*
#*  FUNCTION
#*
#*      ESAL_AR_ISR_Vector_Table
#*
#*  DESCRIPTION
#*
#*      Identifies the start address of the actual vector table /
#*      exception handling code utilized by the target processor /
#*      architecture.  Other interrupt related data structures
#*      (priority tables / etc) will be defined in their respective
#*      esal_xx_isr.c file.
#*
#*  CALLED BY
#*
#*      Interrupt
#*
#*  CALLS
#*
#*      Interrupt Service Routine
#*
#*  INPUTS
#*
#*      None
#*
#*  OUTPUTS
#*
#*      None
#*
#************************************************************************
#VOID ESAL_AR_ISR_Vector_Table(VOID)
    
    .global ESAL_AR_ISR_Vector_Table
ESAL_AR_ISR_Vector_Table:

#********************
#* RESET VECTOR
#********************

#if (CFG_NU_OS_ARCH_PPC_COM_PPC_VARIANT == 0)
    .org 0x0100+ESAL_AR_ISR_Vector_Table
#else
    .align  4
#endif

    .global  ESAL_AR_ISR_Reset
ESAL_AR_ISR_Reset:

    # Get address of ESAL_Entry
    lis     r3,ESAL_Entry@h
    ori     r3,r3,ESAL_Entry@l
    mtspr   CTR,r3

    # Branch to ESAL_Entry
    bctr

#********************
#* MACHINE CHECK
#********************

    ESAL_AR_ISR_EXTERNAL_HANDLER ESAL_AR_ISR_Machine_Check, ESAL_AR_MACHINE_CHECK_INT_VECTOR_ID, 0x0200

#********************
#* DSI
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_ISR_DSI, ESAL_AR_DSI_EXCEPT_VECTOR_ID, 0x0300

#********************
#* ISI
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_ISR_ISI, ESAL_AR_ISI_EXCEPT_VECTOR_ID, 0x0400

#********************
#* EXTERNAL
#********************

    ESAL_AR_ISR_EXTERNAL_HANDLER ESAL_AR_ISR_External, ESAL_AR_EXTERNAL_INT_VECTOR_ID, 0x0500

#********************
#* ALIGN ERROR
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_ISR_Align_Error, ESAL_AR_ALIGNMENT_EXCEPT_VECTOR_ID, 0x0600

#********************
#* PROGRAM ERROR
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_ISR_Prog_Error, ESAL_AR_PROGRAM_EXCEPT_VECTOR_ID, 0x0700

#********************
#* FPU UNAVAILABLE
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_ISR_FPU_Unavail, ESAL_AR_FLTPT_UNAVAIL_EXCEPT_VECTOR_ID, 0x0800

#********************
#* DECREMENTER
#********************

    ESAL_AR_ISR_EXTERNAL_HANDLER ESAL_AR_ISR_Decrementer, ESAL_AR_DECREMENTER_INT_VECTOR_ID, 0x0900

#if (CFG_NU_OS_ARCH_PPC_COM_CRIT_INT_SUPPORT == 1)

#********************
#* CRITICAL
#********************

#if (CFG_NU_OS_ARCH_PPC_COM_PPC_VARIANT == 0)
    .org 0x0A00+ESAL_AR_ISR_Vector_Table
#else
    .align  4
#endif

    .global  ESAL_AR_ISR_Critical
ESAL_AR_ISR_Critical:

    # Execute low-level ISR hook (if enabled)

    ESAL_AR_ISR_HOOK_EXECUTE

    # Save minimal registers along with CSRR0 and CSRR1

    ESAL_AR_STK_MIN_SAVE ESAL_AR_ISR_CSRR0_NUM, ESAL_AR_ISR_CSRR1_NUM

    # Get vector number in r3

    li      r3,ESAL_AR_CRITICAL_INT_VECTOR_ID

    # Get return address for interrupt in r12

    mfspr   r12,ESAL_AR_ISR_CSRR0_NUM

    # Get start address of critical interrupt handler in r11

    lis     r11,ESAL_AR_ISR_Critical@h
    ori     r11,r11,ESAL_AR_ISR_Critical@l

    # Check if interrupt occurred before critical interrupt handler code
    # NOTE:  This assumes the vector table is at address 0x00000000.  If
    #        the vector table is at 0xFFF00000, than this code must be
    #        updated to check from the start of the vector table to the
    #        the critical interrupt handler address

    cmp     0,r11,r12
    blt     ESAL_AR_ISR_No_Special_Int

    # Get saved MSR for external interrupt (an external interrupt was
    # interrupted by this interrupt)

    mfspr   r12,ESAL_AR_ISR_SRR1_NUM

    # Load address of nested critical interrupt handler for this "special" case into CTR

    lis     r9,ESAL_AR_ISR_Nested_Crit_ISR@h
    ori     r9,r9,ESAL_AR_ISR_Nested_Crit_ISR@l
    mtspr   CTR,r9

    # Jump to nested critical interrupt handler for this "special" case

    bctr

ESAL_AR_ISR_No_Special_Int:

    # Load address of critical interrupt handler into CTR

    lis     r9,ESAL_AR_ISR_Critical_Handler@h
    ori     r9,r9,ESAL_AR_ISR_Critical_Handler@l
    mtspr   CTR,r9

    # Jump to critical interrupt handler

    bctr

#endif

#if (CFG_NU_OS_ARCH_PPC_COM_PPC_VARIANT == 1)
# BookE variant ONLY

#***********************
#* FIXED INTERVAL TIMER
#***********************

    ESAL_AR_ISR_EXTERNAL_HANDLER ESAL_AR_ISR_Fixed_Interval_Timer, ESAL_AR_FIT_INT_VECTOR_ID

#********************
#* WATCHDOG TIMER
#********************

    ESAL_AR_ISR_EXTERNAL_HANDLER ESAL_AR_ISR_Watchdog_Timer, ESAL_AR_WATCHDOG_INT_VECTOR_ID

#********************
#* DEBUG
#********************

    .align  4

    .global  ESAL_AR_ISR_Debug
ESAL_AR_ISR_Debug:

    # Execute low-level ISR hook (if enabled)

    ESAL_AR_ISR_HOOK_EXECUTE

    # Save minimal registers (Debug exception uses CSRRx)

    ESAL_AR_STK_MIN_SAVE ESAL_AR_ISR_CSRR0_NUM, ESAL_AR_ISR_CSRR1_NUM

    # Get vector number in r3

    li      r3,ESAL_AR_DEBUG_INT_VECTOR_ID

    # Load address of exception handler into CTR

    lis     r9,ESAL_AR_ISR_Exception_Handler@h
    ori     r9,r9,ESAL_AR_ISR_Exception_Handler@l
    mtspr   CTR,r9

    # Jump to exception handler

    bctr

#endif /* CFG_NU_OS_ARCH_PPC_COM_PPC_VARIANT == 1 */

#if (CFG_NU_OS_ARCH_PPC_COM_PPC_VARIANT == 0)
# PPC32 variant ONLY

#if (CFG_NU_OS_ARCH_PPC_COM_RESERVED_VECTORS_ENABLED == 1)

#********************
#* RESERVED 0x0B00
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_ISR_Rsrvd_0B00, ESAL_AR_RSRVD_0B00_EXCEPT_VECTOR_ID, 0x0B00

#endif /* (CFG_NU_OS_ARCH_PPC_COM_RESERVED_VECTORS_ENABLED == 1) */

#endif /* CFG_NU_OS_ARCH_PPC_COM_PPC_VARIANT == 0 */

#********************
#* SYSTEM CALL
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_ISR_System_Call, ESAL_AR_SYSCALL_EXCEPT_VECTOR_ID, 0x0C00

#if (CFG_NU_OS_ARCH_PPC_COM_PPC_VARIANT == 0)
# PPC32 variant ONLY

#********************
#* TRACE
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_ISR_Trace, ESAL_AR_TRACE_EXCEPT_VECTOR_ID, 0x0D00

#********************
#* FLOAT PT ASSIST
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_ISR_Fltpt_Assist, ESAL_AR_FLTPT_ASSIST_EXCEPT_VECTOR_ID, 0x0E00

#if (CFG_NU_OS_ARCH_PPC_COM_RESERVED_VECTORS_ENABLED == 1)

#********************
#* RESERVED 0x0F00
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_ISR_Rsrvd_0F00, ESAL_AR_RSRVD_0F00_EXCEPT_VECTOR_ID, 0x0F00

#********************
#* RESERVED 0x1000
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_ISR_Rsrvd_1000, ESAL_AR_RSRVD_1000_EXCEPT_VECTOR_ID, 0x1000

#********************
#* RESERVED 0x1100
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_ISR_Rsrvd_1100, ESAL_AR_RSRVD_1100_EXCEPT_VECTOR_ID, 0x1100

#********************
#* RESERVED 0x1200
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_ISR_Rsrvd_1200, ESAL_AR_RSRVD_1200_EXCEPT_VECTOR_ID, 0x1200

#********************
#* RESERVED 0x1300
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_ISR_Rsrvd_1300, ESAL_AR_RSRVD_1300_EXCEPT_VECTOR_ID, 0x1300

#********************
#* RESERVED 0x1400
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_ISR_Rsrvd_1400, ESAL_AR_RSRVD_1400_EXCEPT_VECTOR_ID, 0x1400

#********************
#* RESERVED 0x1500
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_ISR_Rsrvd_1500, ESAL_AR_RSRVD_1500_EXCEPT_VECTOR_ID, 0x1500

#********************
#* RESERVED 0x1600
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_ISR_Rsrvd_1600, ESAL_AR_RSRVD_1600_EXCEPT_VECTOR_ID, 0x1600

#********************
#* RESERVED 0x1700
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_ISR_Rsrvd_1700, ESAL_AR_RSRVD_1700_EXCEPT_VECTOR_ID, 0x1700

#********************
#* RESERVED 0x1800
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_ISR_Rsrvd_1800, ESAL_AR_RSRVD_1800_EXCEPT_VECTOR_ID, 0x1800

#********************
#* RESERVED 0x1900
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_ISR_Rsrvd_1900, ESAL_AR_RSRVD_1900_EXCEPT_VECTOR_ID, 0x1900

#********************
#* RESERVED 0x1A00
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_ISR_Rsrvd_1A00, ESAL_AR_RSRVD_1A00_EXCEPT_VECTOR_ID, 0x1A00

#********************
#* RESERVED 0x1B00
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_ISR_Rsrvd_1B00, ESAL_AR_RSRVD_1B00_EXCEPT_VECTOR_ID, 0x1B00

#********************
#* RESERVED 0x1C00
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_ISR_Rsrvd_1C00, ESAL_AR_RSRVD_1C00_EXCEPT_VECTOR_ID, 0x1C00

#********************
#* RESERVED 0x1D00
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_ISR_Rsrvd_1D00, ESAL_AR_RSRVD_1D00_EXCEPT_VECTOR_ID, 0x1D00

#********************
#* RESERVED 0x1E00
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_ISR_Rsrvd_1E00, ESAL_AR_RSRVD_1E00_EXCEPT_VECTOR_ID, 0x1E00

#********************
#* RESERVED 0x1F00
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_ISR_Rsrvd_1F00, ESAL_AR_RSRVD_1F00_EXCEPT_VECTOR_ID, 0x1F00

#endif /* (CFG_NU_OS_ARCH_PPC_COM_RESERVED_VECTORS_ENABLED == 1) */

#else /* CFG_NU_OS_ARCH_PPC_COM_PPC_VARIANT == 1 */
# BookE variant ONLY

#********************
#* DATA TLB
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_ISR_Data_TLB, ESAL_AR_DTLB_ERR_EXCEPT_VECTOR_ID

#********************
#* INSTRUCTION TLB
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_ISR_Instr_TLB, ESAL_AR_ITLB_ERR_EXCEPT_VECTOR_ID

#********************
#* IVOR32 Exception
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_IVOR32_Exception, ESAL_AR_IVOR32_EXCEPT_VECTOR_ID

#********************
#* IVOR33 Exception
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_IVOR33_Exception, ESAL_AR_IVOR33_EXCEPT_VECTOR_ID

#********************
#* IVOR34 Exception
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_IVOR34_Exception, ESAL_AR_IVOR34_EXCEPT_VECTOR_ID

#********************
#* IVOR35 Exception
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_IVOR35_Exception, ESAL_AR_IVOR35_EXCEPT_VECTOR_ID

#if (CFG_NU_OS_ARCH_PPC_COM_RESERVED_VECTORS_ENABLED == 1)

#********************
#* IVOR36 Exception
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_IVOR36_Exception, ESAL_AR_IVOR36_EXCEPT_VECTOR_ID

#********************
#* IVOR37 Exception
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_IVOR37_Exception, ESAL_AR_IVOR37_EXCEPT_VECTOR_ID

#********************
#* IVOR38 Exception
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_IVOR38_Exception, ESAL_AR_IVOR38_EXCEPT_VECTOR_ID

#********************
#* IVOR39 Exception
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_IVOR39_Exception, ESAL_AR_IVOR39_EXCEPT_VECTOR_ID

#********************
#* IVOR40 Exception
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_IVOR40_Exception, ESAL_AR_IVOR40_EXCEPT_VECTOR_ID

#********************
#* IVOR41 Exception
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_IVOR41_Exception, ESAL_AR_IVOR41_EXCEPT_VECTOR_ID

#********************
#* IVOR42 Exception
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_IVOR42_Exception, ESAL_AR_IVOR42_EXCEPT_VECTOR_ID

#********************
#* IVOR43 Exception
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_IVOR43_Exception, ESAL_AR_IVOR43_EXCEPT_VECTOR_ID

#********************
#* IVOR44 Exception
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_IVOR44_Exception, ESAL_AR_IVOR44_EXCEPT_VECTOR_ID

#********************
#* IVOR45 Exception
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_IVOR45_Exception, ESAL_AR_IVOR45_EXCEPT_VECTOR_ID

#********************
#* IVOR46 Exception
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_IVOR46_Exception, ESAL_AR_IVOR46_EXCEPT_VECTOR_ID

#********************
#* IVOR47 Exception
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_IVOR47_Exception, ESAL_AR_IVOR47_EXCEPT_VECTOR_ID

#********************
#* IVOR48 Exception
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_IVOR48_Exception, ESAL_AR_IVOR48_EXCEPT_VECTOR_ID

#********************
#* IVOR49 Exception
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_IVOR49_Exception, ESAL_AR_IVOR49_EXCEPT_VECTOR_ID

#********************
#* IVOR50 Exception
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_IVOR50_Exception, ESAL_AR_IVOR50_EXCEPT_VECTOR_ID

#********************
#* IVOR51 Exception
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_IVOR51_Exception, ESAL_AR_IVOR51_EXCEPT_VECTOR_ID

#********************
#* IVOR52 Exception
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_IVOR52_Exception, ESAL_AR_IVOR52_EXCEPT_VECTOR_ID

#********************
#* IVOR53 Exception
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_IVOR53_Exception, ESAL_AR_IVOR53_EXCEPT_VECTOR_ID

#********************
#* IVOR54 Exception
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_IVOR54_Exception, ESAL_AR_IVOR54_EXCEPT_VECTOR_ID

#********************
#* IVOR55 Exception
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_IVOR55_Exception, ESAL_AR_IVOR55_EXCEPT_VECTOR_ID

#********************
#* IVOR56 Exception
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_IVOR56_Exception, ESAL_AR_IVOR56_EXCEPT_VECTOR_ID

#********************
#* IVOR57 Exception
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_IVOR57_Exception, ESAL_AR_IVOR57_EXCEPT_VECTOR_ID

#********************
#* IVOR58 Exception
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_IVOR58_Exception, ESAL_AR_IVOR58_EXCEPT_VECTOR_ID

#********************
#* IVOR59 Exception
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_IVOR59_Exception, ESAL_AR_IVOR59_EXCEPT_VECTOR_ID

#********************
#* IVOR60 Exception
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_IVOR60_Exception, ESAL_AR_IVOR60_EXCEPT_VECTOR_ID

#********************
#* IVOR61 Exception
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_IVOR61_Exception, ESAL_AR_IVOR61_EXCEPT_VECTOR_ID

#********************
#* IVOR62 Exception
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_IVOR62_Exception, ESAL_AR_IVOR62_EXCEPT_VECTOR_ID

#********************
#* IVOR63 Exception
#********************

    ESAL_AR_ISR_EXCEPTION_HANDLER ESAL_AR_IVOR63_Exception, ESAL_AR_IVOR63_EXCEPT_VECTOR_ID

#endif /* (CFG_NU_OS_ARCH_PPC_COM_RESERVED_VECTORS_ENABLED == 1) */

#endif /* CFG_NU_OS_ARCH_PPC_COM_PPC_VARIANT == 0 */

    .global ESAL_AR_ISR_Vector_Table_End
ESAL_AR_ISR_Vector_Table_End:

    .end

