#************************************************************************
#*
#*             Copyright 2011 Mentor Graphics Corporation
#*                         All Rights Reserved.
#*
#* THIS WORK CONTAINS TRADE SECRET AND PROPRIETARY INFORMATION WHICH IS
#* THE PROPERTY OF MENTOR GRAPHICS CORPORATION OR ITS LICENSORS AND IS
#* SUBJECT TO LICENSE TERMS.
#*
#************************************************************************

#************************************************************************
#*
#*  FILE NAME
#*
#*      csgnu_ppc_debug.S
#*
#*  DESCRIPTION
#*
#*      This file contains the ARM CSGNU Debug specific functions
#*
#*  FUNCTIONS
#*
#*      ESAL_AR_DBG_Exception_Exit
#*
#*  DEPENDENCIES
#*
#*      csgnu_ppc_defs.inc                              CSGNU include file
#*
#*************************************************************************

#****************************
#* INCLUDE NECESSARY FILES  *
#****************************
    
#include    "nucleus_gen_cfg.h"
#include    "csgnu_ppc_defs.inc"

#**********************************
#* EXTERNAL FUNCTION DECLARATIONS *
#**********************************

#extern VOID    **(*ESAL_AR_DBG_OS_Exception_Handler)(VOID *stk_ptr);
#extern VOID    ESAL_AR_STK_Unsolicited_Switch(VOID **);

    .extern      ESAL_AR_DBG_OS_Exception_Handler
    .extern      ESAL_AR_STK_Unsolicited_Switch    
    
#**********************************
#* EXTERNAL VARIABLE DECLARATIONS *
#**********************************

#UINT32         ESAL_AR_DBG_Exception_Return;
#UINT32         ESAL_AR_DBG_Exception_MSR;

    .extern      ESAL_AR_DBG_Exception_Return
    .extern      ESAL_AR_DBG_Exception_MSR

#****************************
#* FUNCTIONS DECLARATIONS   *
#****************************

    .section        esal_code, "ax"

#**********************************
#* LOCAL VARIABLE DECLARATIONS    *
#**********************************

# None


#*************************************************************************
#*
#*  FUNCTION
#*
#*      ESAL_AR_DBG_Exception_Exit
#*
#*  DESCRIPTION
#*
#*      Exit function used when a breakpoint is hit - saves the
#*      minimal context on the stack and calls the unsolicited context
#*      switch function
#*
#*  CALLED BY
#*
#*      Exception
#*
#*  CALLS
#*
#*      ESAL_AR_STK_Unsolicited_Switch
#*
#*  INPUTS
#*
#*      None
#*
#*  OUTPUTS
#*
#*      None
#*
#*************************************************************************
#VOID    ESAL_AR_DBG_Exception_Exit(VOID)

    .global ESAL_AR_DBG_Exception_Exit
ESAL_AR_DBG_Exception_Exit:

    # Save minimal context on current stack

    ESAL_AR_STK_MIN_SAVE

    # Store return address in minimum stack frame

    lis     r11,ESAL_AR_DBG_Exception_Return@h
    ori     r11,r11,ESAL_AR_DBG_Exception_Return@l
    lwz     r12,0(r11)
    stw     r12,ESAL_AR_STK_MIN_PC_OFFSET(r1)

    # Store MSR in minimum stack frame

    lis     r11,ESAL_AR_DBG_Exception_MSR@h
    ori     r11,r11,ESAL_AR_DBG_Exception_MSR@l
    lwz     r12,0(r11)
    stw     r12,ESAL_AR_STK_MIN_MSR_OFFSET(r1)

    # Get address of OS exception handler

    lis     r11,ESAL_AR_DBG_OS_Exception_Handler@h
    ori     r11,r11,ESAL_AR_DBG_OS_Exception_Handler@l
    lwz     r12,0(r11)

    # Put stack pointer into 1st parameter register (r3)

    mr      r3,r1

    # Jump to OS breakpoint handler

    mtspr   CTR,r12
    bcctrl  ESAL_AR_STK_BRANCH_ALWAYS,0

    # Perform unsolicited context switch and return to OS

    b       ESAL_AR_STK_Unsolicited_Switch
    
    .end
