#***********************************************************************
#*
#*             Copyright 2011 Mentor Graphics Corporation
#*                         All Rights Reserved.
#*
#* THIS WORK CONTAINS TRADE SECRET AND PROPRIETARY INFORMATION WHICH IS
#* THE PROPERTY OF MENTOR GRAPHICS CORPORATION OR ITS LICENSORS AND IS
#* SUBJECT TO LICENSE TERMS.
#*
#***********************************************************************

#***********************************************************************
#*
#*  FILE NAME
#*
#*      csgnu_mips_defs.inc
#*
#*  DESCRIPTION
#*
#*      This file contains the architecture specific definitions,
#*      constants, etc, for CSGNU for MIPS
#*
#*  DATA STRUCTURES
#*
#*      None
#*
#*  DEPENDENCIES
#*
#*      None
#*
#***********************************************************************

# Define if floating point registers will be saved during context switches
# NOTE:  The assembly define must be changed in esal_ar_stk_defs.h to
#        match this define (0 = NU_FALSE / 1 = NU_TRUE)
# NOTE:  This define will dictate what registers are contained
#        within solicited (TS) and unsolicited (AR) stack frames.

ESAL_AR_STK_FPU_SUPPORT               =         0

# Startup / initialization stack size in bytes

ESAL_AR_STK_STARTUP_SIZE              =         1024

# Size of max and min architecture stack frames

.if ESAL_AR_STK_FPU_SUPPORT

ESAL_AR_STK_MAX_FRAME_SIZE            =         256

.else

ESAL_AR_STK_MAX_FRAME_SIZE            =         128

.endif # ESAL_AR_STK_FPU_SUPPORT

ESAL_AR_STK_MIN_FRAME_SIZE            =         88

# Based on ESAL_TS_REQ_STK_ALIGNMENT in esal_ts_cfg.h

ESAL_AR_STK_ALIGNMENT_OFFSET          =         3

# Initial Status Reg value

ESAL_AR_STK_SR_CU_BITS            =         0xF0000000

#***********************************************************************
#* ESAL_AR_STK_MIN_SAVE
#*
#* Save minimal amount of registers required for handling interrupts.
#* ESAL_AR_STK_Unsolicited_Switch() will save the rest.
#***********************************************************************

.macro    ESAL_AR_STK_MIN_SAVE 

    # Offset stack pointer to start of the stack

    addi     $sp, $sp, -(ESAL_AR_STK_MIN_FRAME_SIZE)

    # Disable assembler use of the $at ($1) register
    
    .set     noat

    # Save $1 to the stack
    
    sw       $1, 0($sp)
    
    # Re-enable assembler use of the $at ($1) register    
    
    .set     at

    # Save minium number of remainding registers
    
    sw       $2,  4($sp)
    sw       $3,  8($sp)
    sw       $4,  12($sp)
    sw       $5,  16($sp)
    sw       $6,  20($sp)
    sw       $7,  24($sp)
    sw       $8,  28($sp)
    sw       $9,  32($sp)
    sw       $10, 36($sp)
    sw       $11, 40($sp)
    sw       $12, 44($sp)
    sw       $13, 48($sp)
    sw       $14, 52($sp)
    sw       $15, 56($sp)
    sw       $24, 60($sp)
    sw       $25, 64($sp)

    # Saving high register

    mfhi     $27
    sw       $27, 68($sp)

    # Saving low register

    mflo     $27
    sw       $27, 72($sp)

    # Saving return register

    sw       $31, 76($sp)

    # Saving status register (SR)

    mfc0     $27, $12
    sw       $27, 80($sp)

    # Save EPC

    mfc0     $27, $14
    sw       $27, 84($sp)

    .endm


#***********************************************************************
#* ESAL_AR_STK_MIN_RESTORE
#*
#* Restore minimal amount of registers required for handling interrupts.
#***********************************************************************

.macro    ESAL_AR_STK_MIN_RESTORE 

    # Restore all minimum registers to the
    # stack.

    # Disable assembler use of the $at ($1) register
    
    .set     noat

    # Restore $1 from the stack
    
    lw       $1,  0($sp)
    lw       $2,  4($sp)
    lw       $3,  8($sp)
    lw       $4,  12($sp)
    lw       $5,  16($sp)
    lw       $6,  20($sp)
    lw       $7,  24($sp)
    lw       $8,  28($sp)
    lw       $9,  32($sp)
    lw       $10, 36($sp)
    lw       $11, 40($sp)
    lw       $12, 44($sp)
    lw       $13, 48($sp)
    lw       $14, 52($sp)
    lw       $15, 56($sp)
    lw       $24, 60($sp)
    lw       $25, 64($sp)

    # Restoring high register

    lw       $27, 68($sp)
    mthi     $27

    # Restoring low register

    lw       $27, 72($sp)
    mtlo     $27

    # Restore return address

    lw       $31, 76($sp)

    # Restoring status register (SR)

    lw       $27, 80($sp)
    mtc0     $27, $12
    ssnop
    ssnop
    ehb

    # Get return address from stack frame (EPC)

    lw       $27, 84($sp)
    mtc0     $27, $14
    ssnop
    ssnop
    ehb

    # Recover stack space 

    addi     $sp, $sp, ESAL_AR_STK_MIN_FRAME_SIZE

    # Re-enable assembler use of the $at ($1) register

    .set     at    

    .endm


# Define to allow conditional assembling of lowlevel ISR hook
# Setting this to TRUE (1) will allow a low-level hook to be executed in the
# interrupt handlers

ESAL_AR_ISR_HOOK_ENABLED          =         0

# Architecture Exception mask

ESAL_AR_ISR_CR_EXCCODE_MASK       =         0x0000001F



# Size of toolset stack frame.

.if ESAL_AR_STK_FPU_SUPPORT

ESAL_TS_STK_FRAME_SIZE          =             92

.else

ESAL_TS_STK_FRAME_SIZE          =             44

.endif

