/***********************************************************************
*
*             Copyright 2011 Mentor Graphics Corporation
*                         All Rights Reserved.
*
* THIS WORK CONTAINS TRADE SECRET AND PROPRIETARY INFORMATION WHICH IS
* THE PROPERTY OF MENTOR GRAPHICS CORPORATION OR ITS LICENSORS AND IS
* SUBJECT TO LICENSE TERMS.
*
************************************************************************

************************************************************************
*
*   FILE NAME
*
*       mips_debug.c
*
*   DESCRIPTION
*
*       This file contains the MIPS architecture debug functions
*
*   FUNCTIONS
*
*       ESAL_AR_DBG_Initialize
*       ESAL_AR_DBG_Terminate
*       ESAL_AR_DBG_Reg_Read
*       ESAL_AR_DBG_Reg_Write
*       ESAL_AR_DBG_Opcode_Read
*       ESAL_AR_DBG_Opcode_Write
*       ESAL_AR_DBG_Opcode_Brk_Get
*       ESAL_AR_DBG_Step_Addr_Get
*
*   DEPENDENCIES
*
*       nucleus.h                           Nucleus System constants
*
***********************************************************************/

/* Include required header files */
#include            "nucleus.h"


/***********************************************************************
*
*   FUNCTION
*
*       ESAL_AR_DBG_Initialize
*
*   DESCRIPTION
*
*       This function initializes debugging at architecture level
*
*   CALLED BY
*
*       OS Services
*
*   CALLS
*
*       None
*
*   INPUTS
*
*       None
*
*   OUTPUTS
*
*       None
*
***********************************************************************/
VOID    ESAL_AR_DBG_Initialize(VOID)
{
}


/***********************************************************************
*
*   FUNCTION
*
*       ESAL_AR_DBG_Terminate
*
*   DESCRIPTION
*
*       This function terminates debugging at architecture level
*
*   CALLED BY
*
*       OS Services
*
*   CALLS
*
*       None
*
*   INPUTS
*
*       None
*
*   OUTPUTS
*
*       None
*
***********************************************************************/
VOID    ESAL_AR_DBG_Terminate(VOID)
{
}


/***********************************************************************
*
*   FUNCTION
*
*       ESAL_AR_DBG_Reg_Read
*
*   DESCRIPTION
*
*       This function reads register stored in stack
*
*   CALLED BY
*
*       OS Services
*
*   CALLS
*
*       None
*
*   INPUTS
*
*       p_stack_frame                       Start address of stack memory
*       stack_frame_type                    stack frame type
*       reg_no                              Register number
*       reg_val                             Register value for return
*
*   OUTPUTS
*
*       TRUE or FALSE
*
***********************************************************************/
INT    ESAL_AR_DBG_Reg_Read(VOID * p_stack_frame, INT stack_frame_type, INT reg_no, ESAL_GE_DBG_REG *reg_val)
{
    /* Reference unused parameters to avoid compiler warnings */
    NU_UNUSED_PARAM(p_stack_frame);
    NU_UNUSED_PARAM(stack_frame_type);
    NU_UNUSED_PARAM(reg_no);
    NU_UNUSED_PARAM(reg_val);

    /* Return TRUE to caller */
    return (NU_TRUE);
}


/***********************************************************************
*
*   FUNCTION
*
*       ESAL_AR_DBG_Reg_Write
*
*   DESCRIPTION
*
*       This function write register stored in stack
*
*   CALLED BY
*
*       OS Services
*
*   CALLS
*
*       None
*
*   INPUTS
*
*       p_stack_frame                       Start address of stack memory
*       stack_frame_type                    stack frame type
*       reg_no                              Register number
*       reg_val                             Register value to write
*
*   OUTPUTS
*
*       TRUE or FALSE
*
***********************************************************************/
INT    ESAL_AR_DBG_Reg_Write(VOID *p_stack_frame, INT stack_frame_type, INT reg_no, ESAL_GE_DBG_REG *reg_val)
{
    /* Reference unused parameters to avoid compiler warnings */
    NU_UNUSED_PARAM(p_stack_frame);
    NU_UNUSED_PARAM(stack_frame_type);
    NU_UNUSED_PARAM(reg_no);
    NU_UNUSED_PARAM(reg_val);
    
    /* Return TRUE to caller */
    return (NU_TRUE);
}


/***********************************************************************
*
*   FUNCTION
*
*       ESAL_AR_DBG_Opcode_Read
*
*   DESCRIPTION
*
*       This function reads 4 byte (or 2 byte for thumb) instruction
*
*   CALLED BY
*
*       OS Services
*
*   CALLS
*
*       None
*
*   INPUTS
*
*       read_addr                           Address to read
*
*   OUTPUTS
*
*       instruction
*
***********************************************************************/
ESAL_GE_DBG_OPCODE  ESAL_AR_DBG_Opcode_Read(VOID *read_addr)
{
    /* Reference unused parameters to avoid compiler warnings */
    NU_UNUSED_PARAM(read_addr);
    
    /* Return opcode to caller */
    return (NU_NULL);
}


/***********************************************************************
*
*   FUNCTION
*
*       ESAL_AR_DBG_Opcode_Write
*
*   DESCRIPTION
*
*       This function writes 4 byte (or 2 byte for thumb) instruction
*
*   CALLED BY
*
*       OS Services
*
*   CALLS
*
*       None
*
*   INPUTS
*
*       write_addr                          Address to write
*       opcode                              Value to write
*
*   OUTPUTS
*
*       None
*
***********************************************************************/
VOID    ESAL_AR_DBG_Opcode_Write(VOID *write_addr, 
                                 ESAL_GE_DBG_OPCODE opcode)
{
    /* Reference unused parameters to avoid compiler warnings */
    NU_UNUSED_PARAM(write_addr);
    NU_UNUSED_PARAM(opcode);
}


/***********************************************************************
*
*   FUNCTION
*
*       ESAL_AR_DBG_Opcode_Brk_Get
*
*   DESCRIPTION
*
*       This function returns breakpoint opcode depending on its mode
*
*   CALLED BY
*
*       OS Services
*
*   CALLS
*
*       None
*
*   INPUTS
*
*       addr                                Address to check
*
*   OUTPUTS
*
*       Breakpoint opcode
*
***********************************************************************/
ESAL_GE_DBG_OPCODE  ESAL_AR_DBG_Opcode_Brk_Get(VOID *addr)
{
    /* Reference unused parameters to avoid compiler warnings */
    NU_UNUSED_PARAM(addr);
    
    /* Return opcode to caller */
    return (NU_NULL);
}


/***********************************************************************
*
*   FUNCTION
*
*       ESAL_AR_DBG_Step_Addr_Get
*
*   DESCRIPTION
*
*       This function returns next program counter from given instruction
*
*   CALLED BY
*
*       OS Services
*
*   CALLS
*
*       None
*
*   INPUTS
*
*       addr                                Address of current instruction
*       p_stack_frame                       Start address of stack memory
*       stack_frame_type                    stack frame type
*
*   OUTPUTS
*
*       Next program counter
*
***********************************************************************/
VOID    *ESAL_AR_DBG_Step_Addr_Get(VOID *addr, VOID *p_stack_frame, INT stack_frame_type)
{
    /* Reference unused parameters to avoid compiler warnings */
    NU_UNUSED_PARAM(addr);
    NU_UNUSED_PARAM(p_stack_frame);
    NU_UNUSED_PARAM(stack_frame_type);

    /* Return NULL to caller */
    return (NU_NULL);
}
