;***********************************************************************
;*
;*             Copyright 2010 Mentor Graphics Corporation
;*                         All Rights Reserved.
;*
;* THIS WORK CONTAINS TRADE SECRET AND PROPRIETARY INFORMATION WHICH IS
;* THE PROPERTY OF MENTOR GRAPHICS CORPORATION OR ITS LICENSORS AND IS
;* SUBJECT TO LICENSE TERMS.
;*
;***********************************************************************

;***********************************************************************
;*
;*  FILE NAME
;*
;*      rvct_arm_defs.inc
;*
;*  DESCRIPTION
;*
;*      This file contains the architecture specific definitions,
;*      constants, etc, for RVCT
;*
;*  DATA STRUCTURES
;*
;*      None
;*
;*  DEPENDENCIES
;*
;*      None
;*
;***********************************************************************

ESAL_AR_STK_CONTROL_FP_MASK         EQU         0xFFFFFFFB
ESAL_AR_STK_CPACR_ADDR              EQU         0xE000ED88
ESAL_AR_STK_CPACR_CP11_CP10_CLR     EQU         0xFF0FFFFF
ESAL_AR_STK_FPCCR_ADDR              EQU         0xE000EF34
ESAL_AR_STK_FPCCR_LAZY_MASK         EQU         0x3FFFFFFF

; Define to allow conditional compilation for ARM7TDMI processor. Setting this
; will include necessary low-level interrupt handling code specific to
; the ARM7TDMI and its pipeline architecture.

    GBLL ESAL_AR_ISR_HOOK_ENABLED
ESAL_AR_ISR_HOOK_ENABLED            SETL        {FALSE}

; Define to allow conditional assembling of reset vector type (branch versus load).
; Setting this to TRUE will force the reset vector to utilize a branch instruction.
; This is necessary for certain processors that re-map memory and require a PC
; relative jump to the entry point versus a full 32-bit address (before remapping memory).

    GBLL ESAL_AR_ISR_RESET_BRANCH
ESAL_AR_ISR_RESET_BRANCH            SETL        {FALSE}

; Startup / initialization stack size in bytes

ESAL_AR_STK_STARTUP_STACK_SIZE      EQU         1024

; Constant used to perform a return from exception.
; The upper 28 bits are always 1 - the bottom 4 bits
; are set to b1001 to allow a return from handler state
; to thread state and to use the main stack

ESAL_AR_ISR_RTN_EXCEPT              EQU         0xFFFFFFF9

; Constant used to perform a nested return from exception.
; The upper 28 bits are always 1 - the bottom 4 bits
; are set to b0001 to allow a return from handler state
; to handler state and to use the main stack (for nested interrupts)

ESAL_AR_ISR_RTN_EXCEPT_NEST         EQU         0xFFFFFFF1

; Define offset on stack for special registers required
; to perform a return from exception

ESAL_AR_ISR_PC_OFFSET               EQU         0x18
ESAL_AR_ISR_XPSR_OFFSET             EQU         0x1C

; Define XPSR value that must be inserted in exception stack
; when performing a return from exception

ESAL_AR_ISR_XPSR_VALUE              EQU         0x01000000

; Define register address to get exception number
; This is the Interrupt Control State register

ESAL_AR_ISR_NVIC_ICSR_ADDR          EQU         0xE000ED04

; Define ICSR masks and adjustment values to obtain
; interrupt vector IDs and exception vector IDs

ESAL_AR_ISR_INTERRUPT_VECT_ADJUST   EQU         15
ESAL_AR_ISR_EXCEPT_VECT_ADJUST      EQU         2
ESAL_AR_ISR_VECT_MASK               EQU         0xFF

; Size, in bytes, of max architecture stack frames (without floating point)

#if (CFG_NU_OS_ARCH_ARMV7_M_COM_FPU_SUPPORT > 0)

; Size, in bytes, of max architecture stack frames (with floating point)

ESAL_AR_STK_MAX_FRAME_SIZE          EQU         200

#else

; Size, in bytes, of max architecture stack frames (without floating point)

ESAL_AR_STK_MAX_FRAME_SIZE          EQU         68

#endif  /* CFG_NU_OS_ARCH_ARMV7_M_COM_FPU_SUPPORT > 0 */

; Offset, in bytes, of LR in full stack frame

ESAL_AR_STK_PC_OFFSET               EQU         (ESAL_AR_STK_MAX_FRAME_SIZE-4)
ESAL_AR_STK_LR_OFFSET               EQU         (ESAL_AR_STK_MAX_FRAME_SIZE-8)
ESAL_AR_STK_SPSR_OFFSET             EQU         (ESAL_AR_STK_MAX_FRAME_SIZE-12)
ESAL_AR_STK_R12_OFFSET              EQU         (ESAL_AR_STK_MAX_FRAME_SIZE-16)

; Size, in bytes, of min architecture stack frames

ESAL_AR_STK_MIN_FRAME_SIZE          EQU         32

; Based on ESAL_TS_REQ_STK_ALIGNMENT in esal_ts_cfg.h

ESAL_AR_STK_ALIGNMENT_MASK          EQU         0x00000007

; Offsets, in bytes, of registers on temp stack

ESAL_AR_STK_TMP_R0_OFFSET           EQU         0
ESAL_AR_STK_TMP_SPSR_OFFSET         EQU         4
ESAL_AR_STK_TMP_LR_OFFSET           EQU         8

; Offsets, in bytes, of registers in minimum stack frame

ESAL_AR_STK_MIN_PC_OFFSET           EQU         0x18
ESAL_AR_STK_MIN_LR_OFFSET           EQU         24
ESAL_AR_STK_MIN_SPSR_OFFSET         EQU         20
ESAL_AR_STK_MIN_R12_OFFSET          EQU         16

