;************************************************************************
;*
;*             Copyright 2010 Mentor Graphics Corporation
;*                         All Rights Reserved.
;*
;* THIS WORK CONTAINS TRADE SECRET AND PROPRIETARY INFORMATION WHICH IS
;* THE PROPERTY OF MENTOR GRAPHICS CORPORATION OR ITS LICENSORS AND IS
;* SUBJECT TO LICENSE TERMS.
;*
;************************************************************************

;************************************************************************
;*
;*  FILE NAME
;*
;*      rvct_arm_debug.s
;*
;*  DESCRIPTION
;*
;*      This file contains the ARM RVCT Debug specific functions
;*
;*  FUNCTIONS
;*
;*      ESAL_AR_DBG_Exception_Exit
;*
;*  DEPENDENCIES
;*
;*      rvct_arm_defs.inc                            RVCT include file
;*
;*************************************************************************

;****************************
;* INCLUDE NECESSARY FILES  *
;****************************

#include    "rvct_arm_defs.inc"

;**********************************
;* EXTERNAL FUNCTION DECLARATIONS *
;**********************************

;extern VOID    **(*ESAL_AR_DBG_OS_Exception_Handler)(VOID *stk_ptr);
;extern VOID    ESAL_AR_STK_Unsolicited_Switch(VOID **);

    IMPORT      ESAL_AR_DBG_OS_Exception_Handler
    IMPORT      ESAL_AR_STK_Unsolicited_Switch    
    
;**********************************
;* EXTERNAL VARIABLE DECLARATIONS *
;**********************************

;UINT32         ESAL_AR_DBG_Exception_Return;
;UINT32         ESAL_AR_DBG_Exception_SPSR;

    IMPORT      ESAL_AR_DBG_Exception_Return
    IMPORT      ESAL_AR_DBG_Exception_SPSR

;****************************
;* FUNCTIONS DECLARATIONS   *
;****************************

    AREA        esal_code, CODE, READONLY
    PRESERVE8

;**********************************
;* LOCAL VARIABLE DECLARATIONS    *
;**********************************

ESAL_AR_DBG_OS_Exception_Handler_ASM
    DCD ESAL_AR_DBG_OS_Exception_Handler
ESAL_AR_DBG_Exception_Return_ASM
    DCD ESAL_AR_DBG_Exception_Return
ESAL_AR_DBG_Exception_SPSR_ASM
    DCD ESAL_AR_DBG_Exception_SPSR


;************************************************************************
;*
;*  FUNCTION
;*
;*      ESAL_AR_DBG_Exception_Exit
;*
;*  DESCRIPTION
;*
;*      Exit function used when a breakpoint is hit - saves the
;*      minimal context on the stack and calls the unsolicited context
;*      switch function
;*
;*  CALLED BY
;*
;*      Exception
;*
;*  CALLS
;*
;*      ESAL_AR_STK_Unsolicited_Switch
;*
;*  INPUTS
;*
;*      None
;*
;*  OUTPUTS
;*
;*      None
;*
;************************************************************************
;VOID    ESAL_AR_DBG_Exception_Exit(VOID)

    THUMB ; ESAL_AR_DBG_Exception_Exit
    EXPORT ESAL_AR_DBG_Exception_Exit
ESAL_AR_DBG_Exception_Exit

    
    END
