/*************************************************************************
*
*            Copyright 2010 Mentor Graphics Corporation
*                         All Rights Reserved.
*
* THIS WORK CONTAINS TRADE SECRET AND PROPRIETARY INFORMATION WHICH IS
* THE PROPERTY OF MENTOR GRAPHICS CORPORATION OR ITS LICENSORS AND IS
* SUBJECT TO LICENSE TERMS.
*
*************************************************************************/
/*************************************************************************
*
*   FILE NAME
*
*       cxx_rte_inc.cpp
*
*   COMPONENT
*
*       C++ Service - Run-Time Environment (RTE) - Inclusion
*
*   DESCRIPTION
*
*       This code forces inclusion of required C++ support from the tools.
*
*   DATA STRUCTURES
*
*       CXX_RTE_INC_Object
*
*   FUNCTIONS
*
*       CxxRteIncClass
*       ~CxxRteIncClass
*
*   DEPENDENCIES
*
*       cxx_rte_inc.h
*
*************************************************************************/
#include "os/include/arch/arm/tool-rvct/cxx_rte_inc.h"

/* Variable to force C++ inclusion. */
int CXX_RTE_INC_var = 0;

#ifdef CFG_NU_OS_SVCS_CXX_ENABLE

/* Instance of CxxRteIncClass to force inclusion of C++ support. */
static CxxRteIncClass  CXX_RTE_INC_Object;

/*************************************************************************
*
*   FUNCTION
*
*       CxxRteIncClass
*
*   DESCRIPTION
*
*       Default Constructor for CxxRteIncClass class.
*
*   INPUTS
*
*       None
*
*   OUTPUTS
*
*       None
*
*************************************************************************/
CxxRteIncClass::CxxRteIncClass()
{
    CXX_RTE_INC_var = 0;
    return;
}

/*************************************************************************
*
*   FUNCTION
*
*       ~CxxRteIncClass
*
*   DESCRIPTION
*
*       Default Destructor for CxxRteIncClass class.
*
*   INPUTS
*
*       None
*
*   OUTPUTS
*
*       None
*
*************************************************************************/
CxxRteIncClass::~CxxRteIncClass()
{
    return;
}

#endif

