@************************************************************************
@*
@*             Copyright 2006 Mentor Graphics Corporation
@*                         All Rights Reserved.
@*
@* THIS WORK CONTAINS TRADE SECRET AND PROPRIETARY INFORMATION WHICH IS
@* THE PROPERTY OF MENTOR GRAPHICS CORPORATION OR ITS LICENSORS AND IS
@* SUBJECT TO LICENSE TERMS.
@*
@************************************************************************

@************************************************************************
@*
@*  FILE NAME
@*
@*      csgnu_arm_debug.s
@*
@*  DESCRIPTION
@*
@*      This file contains the ARM CSGNU Debug specific functions
@*
@*  FUNCTIONS
@*
@*      ESAL_AR_DBG_Exception_Exit
@*
@*  DEPENDENCIES
@*
@*      csgnu_arm_defs.inc                              CSGNU include file
@*
@*************************************************************************

@****************************
@* INCLUDE NECESSARY FILES  *
@****************************

#include    "nucleus_gen_cfg.h"
#include    "csgnu_arm_defs.inc"

@**********************************
@* EXTERNAL FUNCTION DECLARATIONS *
@**********************************

@extern VOID    **(*ESAL_AR_DBG_OS_Exception_Handler)(VOID *stk_ptr);
@extern VOID    ESAL_AR_STK_Unsolicited_Switch(VOID **);

    .extern      ESAL_AR_DBG_OS_Exception_Handler
    .extern      ESAL_AR_STK_Unsolicited_Switch    
    
@**********************************
@* EXTERNAL VARIABLE DECLARATIONS *
@**********************************

@UINT32         ESAL_AR_DBG_Exception_Return;
@UINT32         ESAL_AR_DBG_Exception_SPSR;

    .extern      ESAL_AR_DBG_Exception_Return
    .extern      ESAL_AR_DBG_Exception_SPSR

@****************************
@* FUNCTIONS DECLARATIONS   *
@****************************

    .section        esal_code, "ax"

@**********************************
@* LOCAL VARIABLE DECLARATIONS    *
@**********************************

ESAL_AR_DBG_OS_Exception_Handler_ASM:
    .long ESAL_AR_DBG_OS_Exception_Handler
ESAL_AR_DBG_Exception_Return_ASM:
    .long ESAL_AR_DBG_Exception_Return
ESAL_AR_DBG_Exception_SPSR_ASM:
    .long ESAL_AR_DBG_Exception_SPSR


@************************************************************************
@*
@*  FUNCTION
@*
@*      ESAL_AR_DBG_Exception_Exit
@*
@*  DESCRIPTION
@*
@*      Exit function used when a breakpoint is hit - saves the
@*      minimal context on the stack and calls the unsolicited context
@*      switch function
@*
@*  CALLED BY
@*
@*      Exception
@*
@*  CALLS
@*
@*      ESAL_AR_STK_Unsolicited_Switch
@*
@*  INPUTS
@*
@*      None
@*
@*  OUTPUTS
@*
@*      None
@*
@************************************************************************
@VOID    ESAL_AR_DBG_Exception_Exit(VOID)

    .code 32 @ ESAL_AR_DBG_Exception_Exit
    .global ESAL_AR_DBG_Exception_Exit
ESAL_AR_DBG_Exception_Exit:

    @ Preserve space for r14, SPSR, and return PC

    SUB     sp,sp,#12

    @ Save minimal context on current stack

    STMDB   sp!,{r0-r3,r12}

    @ Get return address

    LDR     r0,ESAL_AR_DBG_Exception_Return_ASM
    LDR     r0,[r0]

    @ Get SPSR

    LDR     r1,ESAL_AR_DBG_Exception_SPSR_ASM
    LDR     r1,[r1]

    @ Save return address, SPSR, and LR on stack

    STR     r0,[sp,#ESAL_AR_STK_MIN_PC_OFFSET]
    STR     r1,[sp,#ESAL_AR_STK_MIN_SPSR_OFFSET]
    STR     lr,[sp,#ESAL_AR_STK_MIN_LR_OFFSET]

    @ Get address of OS exception handler

    LDR     r1,ESAL_AR_DBG_OS_Exception_Handler_ASM
    LDR     r1,[r1]

    @ Put stack pointer into 1st parameter register (r0)

    MOV     r0,sp

    @ Jump to OS breakpoint handler

    MOV     lr,pc
    BX      r1

    @ Perform unsolicited context switch and return to OS

    B       ESAL_AR_STK_Unsolicited_Switch
    
    .end
