/************************************************************************
*
*             Copyright Mentor Graphics Corporation 2013
*                         All Rights Reserved.
*
* THIS WORK CONTAINS TRADE SECRET AND PROPRIETARY INFORMATION WHICH IS
* THE PROPERTY OF MENTOR GRAPHICS CORPORATION OR ITS LICENSORS AND IS
* SUBJECT TO LICENSE TERMS.
*
*************************************************************************

*************************************************************************
*
* FILE NAME
*
*       arm_proc_init.c
*
* COMPONENT
*
*       PROC - Nucleus Processes
*
* DESCRIPTION
*
*       This file contains target specific implementations of mode
*       switching routines.
*
* DATA STRUCTURES
*
*       None
*
* FUNCTIONS
*
*       PROC_AR_Kernel_Initialize
*
* DEPENDENCIES
*
*       nu_plus.h
*       nu_kernel.h
*       proc_core.h
*
***********************************************************************/
#include "nucleus.h"
#include "kernel/nu_kernel.h"
#include "os/kernel/process/core/proc_core.h"

/***********************************************************************
*
* FUNCTION
*
*      PROC_AR_Kernel_Initialize
*
* DESCRIPTION
*
*      This function initializes the swi exception handler.
*
***********************************************************************/
STATUS PROC_AR_Kernel_Initialize(VOID)
{
    STATUS status = NU_SUCCESS;

    /* Register the SWI handler with ESAL */
    ESAL_GE_EXCEPT_HANDLER_SET(ESAL_AR_SWI_EXCEPT_VECTOR_ID,
                               PROC_AR_Software_Interrupt);

    /* Register the prefetch abort handler with ESAL */
    ESAL_GE_EXCEPT_HANDLER_SET(ESAL_AR_PREFETCH_EXCEPT_VECTOR_ID,
                               PROC_AR_Exception);

    /* Register the data abort handler with ESAL */
    ESAL_GE_EXCEPT_HANDLER_SET(ESAL_AR_DATA_EXCEPT_VECTOR_ID,
                               PROC_AR_Exception);

    /* Register the undefined instruction handler with ESAL */
    ESAL_GE_EXCEPT_HANDLER_SET(ESAL_AR_UNDEF_EXCEPT_VECTOR_ID,
                               PROC_AR_Exception);

    return(status);
}
