/*
 * Decompiled with CFR 0.152.
 */
package com.mentor.nucleus.fuse.util;

import com.mentor.nucleus.fuse.util.ConfigFileLoadException;
import com.mentor.nucleus.fuse.util.LinearizedProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RichProperties
extends LinearizedProperties {
    private Stack<File> includePaths = new Stack();
    private Stack<File> includedFiles = new Stack();
    String currentFilename = null;

    private void enterIncludeFile(File file) {
        this.includedFiles.push(file);
        this.includePaths.push(file.getParentFile());
    }

    private void exitIncludeFile() {
        this.includedFiles.pop();
        this.includePaths.pop();
    }

    private String canonicalFilename(String filename) {
        if (filename.startsWith("\"") && filename.endsWith("\"")) {
            filename = filename.substring(1, filename.length() - 1);
        }
        return filename;
    }

    private File expandFilename(String filename) {
        filename = this.canonicalFilename(filename);
        for (File path : this.includePaths) {
            File abspath = new File(path, filename);
            if (!abspath.exists()) continue;
            return abspath;
        }
        return new File(filename);
    }

    private void ensureNotRecursiveInclude(File filename, String canonicalFilename) throws IOException {
        if (this.includedFiles.contains(filename)) {
            throw new ConfigFileLoadException("the file named '" + canonicalFilename + "' has been recursively included.", this.currentFilename);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expandInclude(String includeFilename) throws IOException {
        String previousFilename = null;
        File filename = this.expandFilename(includeFilename);
        this.ensureNotRecursiveInclude(filename, this.canonicalFilename(includeFilename));
        if (!filename.exists()) {
            throw new ConfigFileLoadException("the file '" + this.canonicalFilename(includeFilename) + "' referenced in '.include' does not exist", this.currentFilename);
        }
        try {
            this.enterIncludeFile(filename);
            previousFilename = this.currentFilename;
            this.currentFilename = this.canonicalFilename(includeFilename);
            this.load(new FileInputStream(filename));
        }
        finally {
            this.currentFilename = previousFilename;
            this.exitIncludeFile();
        }
    }

    private String expandMacro(String key, String value) throws IOException {
        Pattern macroPattern = Pattern.compile("\\$\\{([\\.\\-\\w]+)\\}");
        LinkedHashSet<String> expandedVariables = new LinkedHashSet<String>();
        Matcher matcher = macroPattern.matcher(value);
        while (matcher.find()) {
            String varName = matcher.group(1);
            String expandedValue = this.getProperty(varName);
            if (expandedValue != null) {
                expandedValue = expandedValue.replaceAll("\\$", "\\\\\\$");
                value = matcher.replaceFirst(expandedValue);
                expandedVariables.add(varName);
                matcher = macroPattern.matcher(value);
                continue;
            }
            if (!value.contains("${" + key + "}")) continue;
            throw new IOException("the variable named '" + varName + "' has been recursively expanded.");
        }
        return value;
    }

    private boolean isInclude(String key, String value) {
        return key.startsWith(".include");
    }

    private boolean hasMacro(String key, String value) {
        return value.contains("${");
    }

    private void processProperties(Properties props) throws IOException {
        for (Object obj : props.keySet()) {
            String value;
            String key = (String)obj;
            if (this.hasMacro(key, value = props.getProperty(key))) {
                value = this.expandMacro(key, value);
            }
            if (this.hasMacro(value, key)) {
                key = this.expandMacro(value, key);
            }
            if (this.isInclude(key, value)) {
                this.expandInclude(value);
                this.setProperty(key, this.expandFilename(value).getPath());
                continue;
            }
            this.setProperty(key, value);
        }
    }

    @Override
    public void load(InputStream inStream) throws IOException {
        LinearizedProperties props = new LinearizedProperties();
        props.load(inStream);
        this.processProperties(props);
    }

    public void addIncludePath(File path) {
        this.includePaths.add(path);
    }

    public void store(OutputStream outStream) {
        PrintWriter out = new PrintWriter(outStream);
        for (Object obj : this.keySet()) {
            String key = (String)obj;
            String value = this.getProperty(key);
            String cleanKey = key;
            key = cleanKey.replaceFirst("(\\.\\*)([0-9]+)(\\*)", "");
            out.println(key + " = " + value);
        }
        out.flush();
        out.close();
    }
}

