/*
 * Decompiled with CFR 0.152.
 */
package com.mentor.nucleus.fuse.phases;

import com.mentor.nucleus.fuse.core.properties.NoSuchPropertyException;
import com.mentor.nucleus.fuse.core.runners.BadOptionValueException;
import com.mentor.nucleus.fuse.core.types.AnnotatedElement;
import com.mentor.nucleus.fuse.core.types.Component;
import com.mentor.nucleus.fuse.core.types.Option;
import com.mentor.nucleus.fuse.core.types.OptionGroup;
import com.mentor.nucleus.fuse.core.types.Package;
import com.mentor.nucleus.fuse.phases.BuiltinLoaderPhase;
import com.mentor.nucleus.fuse.phases.ComponentLoaderPhase;
import com.mentor.nucleus.fuse.phases.FuseContext;
import com.mentor.nucleus.fuse.phases.Phase;
import com.mentor.nucleus.fuse.phases.PropertyLoaderPhase;
import com.mentor.nucleus.fuse.phases.SerializeContextPhase;
import com.mentor.nucleus.fuse.util.ConfigFileLoadException;
import com.mentor.nucleus.fuse.util.RichProperties;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import org.jruby.embed.EmbedEvalUnit;
import org.jruby.embed.ScriptingContainer;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;

public class UIContext {
    private static final String ENABLED_PROP = ".enable = true";
    private static final String DISABLED_PROP = ".enable = false";
    private FuseContext context = null;
    private HashMap<String, Object> defaultProperties = new LinkedHashMap<String, Object>();

    public void loadContext(String savedContext) throws Exception {
        String[] localTransforms = new String[]{"PlatformLoadTransform"};
        this.context = this.deserializeContext(savedContext);
        this.context.setConfigurationRoot(this.context.getConfigurationRoot());
        this.executeTransforms(this.context, localTransforms);
    }

    public void loadContext(Hashtable<?, ?> options, String outputContext) throws Exception {
        String[] requiredKeys = new String[]{"platform", "toolset", "build-root", "configuration-root"};
        String[] localTransforms = new String[]{"PlatformLoadTransform"};
        for (int i = 0; i < requiredKeys.length; ++i) {
            if (options.containsKey(requiredKeys[i])) continue;
            throw new Exception("The key '" + requiredKeys[i] + "' is required.");
        }
        this.context = new FuseContext();
        this.context.setReloadScripts(Boolean.parseBoolean((String)options.get("reload-scripts")));
        File buildRoot = new File((String)options.get("build-root"));
        this.context.setBuildRoot(buildRoot);
        File f = new File((String)options.get("configuration-root"));
        this.context.setConfigurationRoot(f);
        new BuiltinLoaderPhase().execute(this.context);
        this.context.setToolsetName((String)options.get("toolset"));
        String platform = (String)options.get("platform");
        this.context.setPlatformName(platform);
        RichProperties inherentProps = new RichProperties();
        inherentProps.put("platform", options.get("platform"));
        inherentProps.put("toolset", options.get("toolset"));
        this.context.setCliProperties(inherentProps);
        Phase localPhases = null;
        if (outputContext != null) {
            localPhases = new SerializeContextPhase(localPhases, outputContext);
        }
        localPhases = new PropertyLoaderPhase(localPhases);
        localPhases = new ComponentLoaderPhase(localPhases);
        localPhases.execute(this.context);
        this.executeTransforms(this.context, localTransforms);
    }

    public Object getYAMLModel() throws BadOptionValueException {
        String[] yamltransform = new String[]{"YAMLModelTransform"};
        this.executeTransforms(this.context, yamltransform);
        return this.context.getYamlModel();
    }

    public void executeTransforms(FuseContext context, String[] transforms) throws BadOptionValueException {
        Phase localPhases = null;
        localPhases = this.addTransforms(context, transforms, localPhases);
        localPhases.execute(context);
    }

    public void loadConfigurationFile(String configFilename) throws Exception {
        String[] propertyTransforms = new String[]{"PropertyLoaderTransform"};
        RichProperties newprops = this.context.getCliProperties();
        if (newprops == null) {
            newprops = new RichProperties();
        }
        try {
            File configfilePath = new File(configFilename);
            newprops.addIncludePath(this.context.getBuildRoot());
            newprops.addIncludePath(configfilePath.getParentFile());
            newprops.load(new FileInputStream(configFilename));
        }
        catch (ConfigFileLoadException e) {
            if (e.getFilename() != null) {
                throw e;
            }
            throw new ConfigFileLoadException(e.getMessage(), configFilename);
        }
        catch (IOException e) {
            throw new ConfigFileLoadException(e.getMessage(), configFilename);
        }
        this.context.setCliProperties(newprops);
        this.executeTransforms(this.context, propertyTransforms);
    }

    public void writeConfigurationFile(ByteArrayOutputStream outStream) {
        PrintWriter out = new PrintWriter(outStream);
        this.writeConfigurationElement(out, this.context.universe, this.context.universe.getName());
        out.flush();
        out.close();
    }

    /*
     * WARNING - void declaration
     */
    private void writeConfigurationElement(PrintWriter out, AnnotatedElement element, String elementPath) {
        Option option;
        Object newValue;
        String childPathPrefix;
        String string = childPathPrefix = elementPath.isEmpty() ? "" : elementPath + ".";
        if (element instanceof Package) {
            Package pkg = (Package)element;
            if (elementPath.isEmpty()) {
                out.println("nu.enable = false");
            }
            if (elementPath.equals(this.context.getPlatformName())) {
                out.println(this.context.getPlatformName() + DISABLED_PROP);
            }
            for (Component component : pkg.getComponents()) {
                this.writeConfigurationElement(out, component, childPathPrefix + component.getName());
            }
            for (AnnotatedElement annotatedElement : pkg.getPackages()) {
                this.writeConfigurationElement(out, annotatedElement, childPathPrefix + ((Package)annotatedElement).getName());
            }
        } else if (element instanceof Component) {
            void var9_27;
            void var9_25;
            String runlevel;
            Component comp = (Component)element;
            if (comp.getEnabled()) {
                out.println(elementPath + ENABLED_PROP);
            }
            if (comp.hasProperty(runlevel = "runlevel")) {
                try {
                    Object newValue2 = comp.getProperty(runlevel);
                    runlevel = elementPath + "." + runlevel;
                    if (!newValue2.equals(this.defaultProperties.get(runlevel))) {
                        out.println(runlevel + " = " + newValue2);
                    }
                }
                catch (NoSuchPropertyException e) {
                    e.printStackTrace();
                }
            }
            AnnotatedElement[] arr$ = comp.getOptions();
            int len$ = arr$.length;
            boolean bl = false;
            while (var9_25 < len$) {
                Option option2 = arr$[var9_25];
                this.writeConfigurationElement(out, option2, childPathPrefix + option2.getName());
                ++var9_25;
            }
            arr$ = comp.getOptionGroups();
            len$ = arr$.length;
            boolean bl2 = false;
            while (var9_27 < len$) {
                AnnotatedElement annotatedElement = arr$[var9_27];
                this.writeConfigurationElement(out, annotatedElement, childPathPrefix + ((OptionGroup)annotatedElement).getName());
                ++var9_27;
            }
        } else if (element instanceof OptionGroup) {
            void var9_29;
            OptionGroup group = (OptionGroup)element;
            String parentPath = elementPath.substring(0, elementPath.lastIndexOf(46));
            try {
                if (this.context.universe.getBooleanProperty(parentPath + ".enable")) {
                    out.println(elementPath + (group.getEnabled() ? ENABLED_PROP : DISABLED_PROP));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Option[] arr$ = group.getOptions();
            int len$ = arr$.length;
            boolean bl = false;
            while (var9_29 < len$) {
                Option option3 = arr$[var9_29];
                this.writeConfigurationElement(out, option3, childPathPrefix + option3.getName());
                ++var9_29;
            }
        } else if (element instanceof Option && !(newValue = (option = (Option)element).get()).equals(this.defaultProperties.get(elementPath))) {
            out.println(elementPath + " = " + newValue);
        }
    }

    public void buildDefaultsMap() {
        this.internalBuildDefaultsMap(this.context.universe, this.context.universe.getName());
    }

    private void internalBuildDefaultsMap(Package parentPack, String packAddress) {
        if (!packAddress.isEmpty()) {
            packAddress = packAddress + ".";
        }
        for (Package subPack : parentPack.getPackages()) {
            String subPackName = packAddress + subPack.getName();
            this.defaultProperties.put(subPackName + ".enable", subPack.getEnabled());
            for (Component comp : subPack.getComponents()) {
                String optName;
                String compName = subPackName + "." + comp.getName();
                this.defaultProperties.put(compName + ".enable", comp.getEnabled());
                if (comp.hasProperty("runlevel")) {
                    try {
                        this.defaultProperties.put(compName + ".runlevel", comp.getProperty("runlevel"));
                    }
                    catch (NoSuchPropertyException e) {
                        // empty catch block
                    }
                }
                for (Option option : comp.getOptions()) {
                    optName = compName + "." + option.getName();
                    this.defaultProperties.put(optName, option.get());
                }
                for (AnnotatedElement annotatedElement : comp.getOptionGroups()) {
                    this.defaultProperties.put(compName + "." + ((OptionGroup)annotatedElement).getName() + ".enable", ((OptionGroup)annotatedElement).getEnabled());
                    for (Option opt : ((OptionGroup)annotatedElement).getOptions()) {
                        optName = compName + "." + ((OptionGroup)annotatedElement).getName() + "." + opt.getName();
                        this.defaultProperties.put(optName, opt.get());
                    }
                }
            }
            this.internalBuildDefaultsMap(subPack, subPackName);
        }
    }

    public Object getDefaultPropertyValue(String propertyName) {
        if (propertyName == null) {
            return null;
        }
        return this.defaultProperties.get(propertyName);
    }

    public String getPropertyValue(String propertyName) throws Exception {
        if (!this.context.universe.hasProperty(propertyName)) {
            throw new NoSuchPropertyException("The property '" + propertyName + "' does not exist.");
        }
        return this.context.universe.getProperty(propertyName).toString();
    }

    public void setPropertyValue(String propertyName, String value) throws Exception {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put(propertyName, value);
        this.setPropertyValues(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPropertyValues(Hashtable<String, String> properties) throws Exception {
        String[] propertyLoaderTransform = new String[]{"PropertyLoaderTransform"};
        RichProperties currentProps = this.context.getCliProperties();
        RichProperties newProps = new RichProperties();
        try {
            for (String key : properties.keySet()) {
                if (!this.context.universe.hasProperty(key)) {
                    throw new NoSuchPropertyException("The key '" + key + "' does not exist.");
                }
                newProps.put(key, properties.get(key));
            }
            this.context.setCliProperties(newProps);
            this.executeTransforms(this.context, propertyLoaderTransform);
        }
        finally {
            this.context.setCliProperties(currentProps);
        }
    }

    private FuseContext deserializeContext(String filename) {
        FuseContext localContext = null;
        try {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(filename));
            localContext = (FuseContext)ois.readObject();
            ois.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        return localContext;
    }

    private Phase addTransforms(FuseContext context, String[] transformOptions, Phase phaseList) throws BadOptionValueException {
        if (transformOptions != null) {
            for (String transformName : transformOptions) {
                this.verify("transform", transformName, context.getAvailableTransforms());
                phaseList = this.prependTransform(context, transformName, phaseList);
            }
        } else {
            throw new BadOptionValueException("you must specify a transform. Please invoke 'fuse --list-transforms' to see what is available.");
        }
        return phaseList;
    }

    private Phase prependTransform(FuseContext context, String transformName, Phase phaseList) {
        ScriptingContainer container = context.getScriptingContainer();
        container.put("phase_list", (Object)phaseList);
        EmbedEvalUnit unit = container.parse(String.format("%1$2s.new(phase_list)", transformName), new int[0]);
        IRubyObject ret = unit.run();
        return (Phase)JavaEmbedUtils.rubyToJava((IRubyObject)ret);
    }

    private void verify(String header, String itemToCheck, String[] items) throws BadOptionValueException {
        for (String item : items) {
            if (!item.equals(itemToCheck)) continue;
            return;
        }
        throw new BadOptionValueException("the specified " + header + " '" + itemToCheck + "' does not exist.");
    }
}

