/*
 * Decompiled with CFR 0.152.
 */
package com.mentor.nucleus.fuse.phases;

import com.mentor.nucleus.fuse.core.types.Component;
import com.mentor.nucleus.fuse.core.types.Composite;
import com.mentor.nucleus.fuse.core.types.Package;
import com.mentor.nucleus.fuse.parsers.jruby.JRubyParser;
import com.mentor.nucleus.fuse.phases.FuseContext;
import com.mentor.nucleus.fuse.phases.Phase;
import java.io.File;
import java.util.LinkedList;
import java.util.List;

public abstract class ParsePhase
extends Phase {
    public ParsePhase() {
    }

    public ParsePhase(Phase next) {
        super(next);
    }

    @Override
    public boolean executePhase(FuseContext context) {
        JRubyParser p = new JRubyParser(context.getScriptingContainer(), context.shouldReloadScripts());
        for (File file : this.metadataFiles(this.scanRoot(context))) {
            if (this.shouldFilter(context, file)) continue;
            Composite newComposite = p.parse(file);
            if (newComposite == null) {
                return false;
            }
            if (!this.shouldAddComposite(context, newComposite)) continue;
            this.addComposite(context.getUniverse(), newComposite);
        }
        return true;
    }

    private void addComposite(Package universe, Composite comp) {
        String[] packageList = comp.getPackageName().split("\\.");
        Package parentPackage = universe;
        if (packageList.length > 0 && comp.getPackageName().length() > 0) {
            for (String packageName : packageList) {
                if (parentPackage.findPackage(packageName) == null) {
                    Package newPackage = new Package(packageName);
                    newPackage.setPackageName(parentPackage.getName());
                    newPackage.setBooleanProperty("anointed", false);
                    parentPackage.addPackage(newPackage);
                }
                parentPackage = parentPackage.findPackage(packageName);
            }
        }
        if (comp instanceof Component) {
            parentPackage.addComponent((Component)comp);
        } else if (comp instanceof Package) {
            parentPackage.addPackage((Package)comp);
        }
    }

    private List<File> metadataFiles(File baseDirectory) {
        LinkedList<File> metadataFileList = new LinkedList<File>();
        LinkedList<File> directoryQueue = new LinkedList<File>();
        directoryQueue.add(baseDirectory);
        while (directoryQueue.size() > 0) {
            File currentDirectory = (File)directoryQueue.removeFirst();
            for (File file : currentDirectory.listFiles()) {
                if (this.isMetadataFile(file)) {
                    metadataFileList.add(file);
                    continue;
                }
                if (!file.isDirectory()) continue;
                directoryQueue.add(file);
            }
        }
        return metadataFileList;
    }

    protected boolean shouldFilter(FuseContext context, File file) {
        return false;
    }

    protected boolean isMetadataFile(File file) {
        return file.isFile() && file.getName().endsWith(".metadata");
    }

    protected abstract File scanRoot(FuseContext var1);

    protected abstract boolean shouldAddComponent(FuseContext var1, Component var2);

    protected abstract boolean shouldAddComposite(FuseContext var1, Composite var2);
}

