/*
 * Decompiled with CFR 0.152.
 */
package com.mentor.nucleus.fuse.phases;

import com.mentor.nucleus.fuse.core.types.Package;
import com.mentor.nucleus.fuse.util.RichProperties;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.jruby.RubyArray;
import org.jruby.embed.EmbedEvalUnit;
import org.jruby.embed.LocalContextScope;
import org.jruby.embed.ScriptingContainer;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.runtime.builtin.IRubyObject;

public class FuseContext
implements Serializable {
    public static final String FUSE_VERSION = "1.1";
    Package universe = new Package("");
    File buildRoot = null;
    File configurationRoot = null;
    String toolsetName = null;
    Set<String> availableToolsets = new HashSet<String>();
    String platformName = null;
    Set<String> availablePlatforms = new HashSet<String>();
    transient ScriptingContainer container = new ScriptingContainer(LocalContextScope.SINGLETHREAD);
    transient Object yamlModel = null;
    RichProperties cliProperties = null;
    private boolean reloadScripts = false;

    public void setReloadScripts(boolean reloadScripts) {
        this.reloadScripts = reloadScripts;
    }

    public boolean shouldReloadScripts() {
        return this.reloadScripts;
    }

    public void setYamlModel(Object model) {
        this.yamlModel = model;
    }

    public Object getYamlModel() {
        return this.yamlModel;
    }

    public File getBuildRoot() {
        return this.buildRoot;
    }

    public ScriptingContainer getScriptingContainer() {
        return this.container;
    }

    public void setBuildRoot(File root) {
        this.buildRoot = root;
    }

    public File getConfigurationRoot() {
        return this.configurationRoot;
    }

    public void setConfigurationRoot(File root) {
        this.configurationRoot = root;
        File jrubyDirectory = new File(this.getConfigurationRoot().getAbsolutePath() + File.separator + "jruby");
        File transformDirectory = new File(jrubyDirectory, "transforms");
        ArrayList<String> paths = new ArrayList<String>();
        paths.add(this.getConfigurationRoot().getAbsolutePath());
        paths.add(jrubyDirectory.getAbsolutePath());
        paths.add(transformDirectory.getAbsolutePath());
        this.getScriptingContainer().getProvider().setLoadPaths(paths);
        this.loadTransforms(transformDirectory);
    }

    public String getToolsetName() {
        return this.toolsetName;
    }

    public void setToolsetName(String name) {
        this.toolsetName = name;
    }

    public String[] getAvailableToolsets() {
        String[] toolsets = new String[this.availableToolsets.size()];
        return this.availableToolsets.toArray(toolsets);
    }

    public void addAvailableToolset(String toolsetName) {
        this.availableToolsets.add(toolsetName);
    }

    public String[] getAvailablePlatforms() {
        String[] platforms = new String[this.availablePlatforms.size()];
        return this.availablePlatforms.toArray(platforms);
    }

    public void addAvailablePlatform(String platformName) {
        this.availablePlatforms.add(platformName);
    }

    public String[] getAvailableTransforms() {
        String[] transforms = null;
        EmbedEvalUnit unit = this.container.parse("Module.constants.find_all { |e| e.match('.+Transform') != nil }", new int[0]);
        IRubyObject ret = unit.run();
        RubyArray array = (RubyArray)JavaEmbedUtils.rubyToJava((IRubyObject)ret);
        if (array != null) {
            transforms = new String[array.size()];
            for (int i = 0; i < transforms.length; ++i) {
                transforms[i] = (String)array.get(i);
            }
        } else {
            transforms = new String[]{};
        }
        return transforms;
    }

    public String getPlatformName() {
        return this.platformName;
    }

    public void setPlatformName(String name) {
        this.platformName = name;
    }

    public Package getUniverse() {
        return this.universe;
    }

    public void setUniverse(Package universe) {
        this.universe = universe;
    }

    public RichProperties getCliProperties() {
        return this.cliProperties;
    }

    public void setCliProperties(RichProperties properties) {
        this.cliProperties = properties;
    }

    private void loadTransforms(File transformDirectory) {
        String command;
        String string = command = this.reloadScripts ? "load" : "require";
        if (this.reloadScripts) {
            this.container.runScriptlet("$VERBOSE = nil");
        }
        this.container.runScriptlet(command + " 'Transform.rb'");
        for (File f : transformDirectory.listFiles()) {
            if (!f.getName().endsWith("Transform.rb")) continue;
            this.container.runScriptlet(command + " '" + f.getName() + "'");
        }
    }

    private void writeOject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.container = new ScriptingContainer();
    }
}

