/*
 * Decompiled with CFR 0.152.
 */
package com.mentor.nucleus.fuse.phases;

import com.mentor.nucleus.fuse.core.types.Component;
import com.mentor.nucleus.fuse.core.types.Composite;
import com.mentor.nucleus.fuse.phases.FuseContext;
import com.mentor.nucleus.fuse.phases.ParsePhase;
import com.mentor.nucleus.fuse.phases.Phase;
import java.io.File;

public class BuiltinLoaderPhase
extends ParsePhase {
    public BuiltinLoaderPhase() {
    }

    public BuiltinLoaderPhase(Phase next) {
        super(next);
    }

    @Override
    protected File scanRoot(FuseContext context) {
        return context.getBuildRoot();
    }

    @Override
    protected boolean shouldFilter(FuseContext context, File file) {
        String root = "tools";
        File searchPath = new File(context.getBuildRoot(), root);
        return file.getAbsolutePath().startsWith(searchPath.getAbsolutePath());
    }

    @Override
    protected boolean isMetadataFile(File file) {
        return file.isFile() && file.getName().endsWith(".toolset");
    }

    @Override
    protected boolean shouldAddComponent(FuseContext context, Component c) {
        if (c.getPackageName().startsWith("toolsets")) {
            context.addAvailableToolset(c.getName());
        }
        for (String platformName : c.getPlatforms()) {
            context.addAvailablePlatform(platformName);
        }
        return true;
    }

    @Override
    protected boolean shouldAddComposite(FuseContext context, Composite comp) {
        if (comp.getPackageName().startsWith("toolsets")) {
            context.addAvailableToolset(comp.getName());
        }
        for (String platformName : comp.getPlatforms()) {
            context.addAvailablePlatform(platformName);
        }
        return true;
    }
}

